/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sf.gogui.game.Clock;
import net.sf.gogui.game.ConstClock;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.Game;
import net.sf.gogui.game.StringInfoColor;
import net.sf.gogui.go.BlackWhiteSet;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.gui.GuiClock;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.Prisoners;
import net.sf.gogui.util.StringUtil;

public class GameInfoPanel
extends JPanel {
    private final BlackWhiteSet<GuiClock> m_clock = new BlackWhiteSet();
    private final BlackWhiteSet<JLabel> m_icon = new BlackWhiteSet();
    private final BlackWhiteSet<Prisoners> m_prisoners = new BlackWhiteSet();
    private final Game m_game;
    private final UpdateTimeRunnable m_updateTime = new UpdateTimeRunnable();

    public GameInfoPanel(Game game) {
        this.setBorder(GuiUtil.createEmptyBorder());
        JPanel panel = new JPanel(new GridLayout(0, 2, 5, 5));
        this.add((Component)panel, "Center");
        this.m_game = game;
        for (GoColor c : GoColor.WHITE_BLACK) {
            Box box = Box.createVerticalBox();
            panel.add(box);
            ImageIcon icon = c == GoColor.BLACK ? GuiUtil.getIcon("gogui-black-32x32", I18n.i18n("LB_BLACK")) : GuiUtil.getIcon("gogui-white-32x32", I18n.i18n("LB_WHITE"));
            this.m_icon.set(c, new JLabel(icon));
            this.m_icon.get(c).setAlignmentX(0.5f);
            box.add(this.m_icon.get(c));
            box.add(GuiUtil.createFiller());
            this.m_clock.set(c, new GuiClock(c));
            this.m_clock.get(c).setAlignmentX(0.5f);
            box.add(this.m_clock.get(c));
            GoColor otherColor = c.otherColor();
            this.m_prisoners.set(otherColor, new Prisoners(otherColor));
            box.add(this.m_prisoners.get(otherColor));
        }
        Clock.Listener listener = new Clock.Listener(){

            public void clockChanged() {
                SwingUtilities.invokeLater(GameInfoPanel.this.m_updateTime);
            }
        };
        game.setClockListener(listener);
    }

    public void update() {
        ConstBoard board = this.m_game.getBoard();
        ConstNode node = this.m_game.getCurrentNode();
        ConstGameTree tree = this.m_game.getTree();
        ConstGameInfo info = tree.getGameInfoConst(node);
        for (GoColor c : GoColor.BLACK_WHITE) {
            String name = info.get(StringInfoColor.NAME, c);
            String rank = info.get(StringInfoColor.RANK, c);
            this.updatePlayerToolTip(this.m_icon.get(c), name, rank, c);
            this.m_prisoners.get(c).setCount(board.getCaptured(c));
            this.updateTimeFromClock(this.m_game.getClock(), c);
        }
    }

    private void updatePlayerToolTip(JLabel label, String player, String rank, GoColor color) {
        assert (color.isBlackWhite());
        StringBuilder buffer = new StringBuilder(128);
        if (color == GoColor.BLACK) {
            buffer.append(I18n.i18n("TT_INFOPANEL_PLAYER_BLACK"));
        } else {
            buffer.append(I18n.i18n("TT_INFOPANEL_PLAYER_WHITE"));
        }
        buffer.append(" (");
        if (StringUtil.isEmpty(player)) {
            buffer.append(I18n.i18n("TT_INFOPANEL_UNKNOWN_NAME"));
        } else {
            buffer.append(player);
            if (!StringUtil.isEmpty(rank)) {
                buffer.append(' ');
                buffer.append(rank);
            }
        }
        buffer.append(')');
        label.setToolTipText(buffer.toString());
    }

    private void updateTimeFromClock(ConstClock clock, GoColor c) {
        assert (c.isBlackWhite());
        String text = clock.getTimeString(c);
        this.m_clock.get(c).setText(text);
    }

    private class UpdateTimeRunnable
    implements Runnable {
        private UpdateTimeRunnable() {
        }

        public void run() {
            for (GoColor c : GoColor.BLACK_WHITE) {
                GameInfoPanel.this.updateTimeFromClock(GameInfoPanel.this.m_game.getClock(), c);
            }
        }
    }
}

