/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import net.sf.gogui.boardpainter.BoardPainter;
import net.sf.gogui.boardpainter.ConstField;
import net.sf.gogui.boardpainter.Field;
import net.sf.gogui.go.BoardConstants;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.gui.ConstGuiBoard;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.SquareLayout;
import net.sf.gogui.util.ObjectUtil;

public final class GuiBoard
extends JPanel
implements ConstGuiBoard,
Printable {
    private static final boolean DEBUG_REPAINT = false;
    private boolean m_showCursor = true;
    private boolean m_showGrid = true;
    private int m_imageHeight;
    private int m_imageWidth;
    private int m_size;
    private BoardConstants m_constants;
    private BoardPanel m_panel;
    private Dimension m_minimumFieldSize;
    private Dimension m_preferredFieldSize;
    private GoPoint m_cursor;
    private GoPoint m_lastMove;
    private final BoardPainter m_painter;
    private Field[][] m_field;
    private Image m_image;
    private Listener m_listener;
    private Rectangle m_dirty = new Rectangle();

    public GuiBoard(int size) {
        this.m_painter = new BoardPainter();
        this.setPreferredFieldSize();
        this.initSize(size);
    }

    public void clearAll() {
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                this.setFieldBackground(GoPoint.get(x, y), null);
            }
        }
        this.clearAllCrossHair();
        this.clearAllMarkup();
        this.clearAllSelect();
        this.clearAllInfluence();
        this.clearAllLabels();
        this.clearAllGhostStones();
        this.clearAllTerritory();
        this.clearLastMove();
    }

    public void clearAllCrossHair() {
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                this.setCrossHair(GoPoint.get(x, y), false);
            }
        }
    }

    public void clearAllInfluence() {
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                this.clearInfluence(GoPoint.get(x, y));
            }
        }
    }

    public void clearAllMarkup() {
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                GoPoint point = GoPoint.get(x, y);
                this.setMark(point, false);
                this.setMarkCircle(point, false);
                this.setMarkSquare(point, false);
                this.setMarkTriangle(point, false);
            }
        }
    }

    public void clearAllSelect() {
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                this.setSelect(GoPoint.get(x, y), false);
            }
        }
    }

    public void clearAllLabels() {
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                this.setLabel(GoPoint.get(x, y), "");
            }
        }
    }

    public void clearAllGhostStones() {
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                this.setGhostStone(GoPoint.get(x, y), null);
            }
        }
    }

    public void clearAllTerritory() {
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                this.setTerritory(GoPoint.get(x, y), GoColor.EMPTY);
            }
        }
    }

    public void clearInfluence(GoPoint point) {
        this.getField(point).clearInfluence();
        this.repaint(point);
    }

    public void contextMenu(GoPoint point) {
        this.m_panel.contextMenu(point);
    }

    public int getBoardSize() {
        return this.m_size;
    }

    public ConstField getFieldConst(GoPoint p) {
        return this.getField(p);
    }

    public Dimension getFieldSize() {
        int size = this.m_painter.getFieldSize();
        return new Dimension(size, size);
    }

    public String getLabel(GoPoint point) {
        return this.getField(point).getLabel();
    }

    public Point getLocationOnScreen(GoPoint point) {
        Point center = this.m_painter.getCenter(point.getX(), point.getY());
        Point location = this.m_panel.getLocationOnScreen();
        location.x += center.x;
        location.y += center.y;
        return location;
    }

    public boolean getMark(GoPoint point) {
        return this.getField(point).getMark();
    }

    public boolean getMarkCircle(GoPoint point) {
        return this.getField(point).getMarkCircle();
    }

    public boolean getMarkSquare(GoPoint point) {
        return this.getField(point).getMarkSquare();
    }

    public boolean getMarkTriangle(GoPoint point) {
        return this.getField(point).getMarkTriangle();
    }

    public Dimension getMinimumFieldSize() {
        return this.m_minimumFieldSize;
    }

    public Dimension getPreferredFieldSize() {
        return this.m_preferredFieldSize;
    }

    public boolean getSelect(GoPoint point) {
        return this.getField(point).getSelect();
    }

    public boolean getShowCursor() {
        return this.m_showCursor;
    }

    public boolean getShowGrid() {
        return this.m_showGrid;
    }

    public void initSize(int size) {
        assert (size > 0 && size <= 25);
        this.m_size = size;
        this.m_constants = BoardConstants.get(size);
        this.m_field = new Field[size][size];
        this.removeAll();
        this.m_cursor = null;
        this.setLayout(new SquareLayout());
        this.m_panel = new BoardPanel();
        this.m_panel.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                if (GuiBoard.this.getShowCursor()) {
                    GuiBoard.this.setCursor(GuiBoard.this.m_cursor, true);
                }
            }

            public void focusLost(FocusEvent event) {
                if (GuiBoard.this.getShowCursor()) {
                    GuiBoard.this.setCursor(GuiBoard.this.m_cursor, false);
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                GuiBoard.this.m_panel.requestFocusInWindow();
            }
        });
        this.add(this.m_panel);
        this.m_panel.requestFocusInWindow();
        this.m_panel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                GuiBoard.this.keyPressed(event);
            }
        });
        this.m_panel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GoPoint point = GuiBoard.this.m_panel.getPoint(e);
                if (point == null) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    GuiBoard.this.contextMenu(point);
                    return;
                }
                int button = e.getButton();
                int count = e.getClickCount();
                if (button != 1) {
                    return;
                }
                if (count == 2) {
                    GuiBoard.this.fieldClicked(point, true);
                } else {
                    int mask;
                    int modifiers = e.getModifiers();
                    boolean modifiedSelect = (modifiers & (mask = 14)) != 0;
                    GuiBoard.this.fieldClicked(point, modifiedSelect);
                }
            }

            public void mouseReleased(MouseEvent e) {
                GoPoint point = GuiBoard.this.m_panel.getPoint(e);
                if (point == null) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    GuiBoard.this.contextMenu(point);
                    return;
                }
            }
        });
        this.m_panel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                GuiBoard.this.m_panel.setToolTipText(null);
                GoPoint point = GuiBoard.this.m_panel.getPoint(e);
                if (point == null) {
                    return;
                }
                String label = GuiBoard.this.getField(point).getLabel();
                if (label != null && label.length() > 3) {
                    GuiBoard.this.m_panel.setToolTipText(label);
                }
            }
        });
        for (int y = size - 1; y >= 0; --y) {
            for (int x = 0; x < size; ++x) {
                this.m_field[x][y] = new Field();
            }
        }
        this.m_lastMove = null;
        this.setCursor(GoPoint.get(this.m_size / 2, this.m_size / 2));
        this.revalidate();
        this.m_dirty = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        this.repaint();
    }

    public void markLastMove(GoPoint point) {
        this.clearLastMove();
        this.m_lastMove = point;
        if (this.m_lastMove != null) {
            Field field = this.getField(this.m_lastMove);
            field.setLastMoveMarker(true);
            this.repaint(point);
            this.m_lastMove = point;
        }
    }

    public void paintImmediately(GoPoint point) {
        this.m_panel.paintImmediately(point);
    }

    public int print(Graphics g, PageFormat format, int page) throws PrinterException {
        if (page >= 1) {
            return 1;
        }
        double width = this.getSize().width;
        double height = this.getSize().height;
        double pageWidth = format.getImageableWidth();
        double pageHeight = format.getImageableHeight();
        double scale = 1.0;
        if (width >= pageWidth) {
            scale = pageWidth / width;
        }
        double xSpace = (pageWidth - width * scale) / 2.0;
        double ySpace = (pageHeight - height * scale) / 2.0;
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(format.getImageableX() + xSpace, format.getImageableY() + ySpace);
        g2d.scale(scale, scale);
        this.print(g2d);
        return 0;
    }

    public void setColor(GoPoint point, GoColor color) {
        Field field = this.getField(point);
        if (field.getColor() != color) {
            field.setColor(color);
            this.m_panel.repaintWithShadow(point);
        }
    }

    public void setCursor(GoPoint point) {
        if (point != null && !point.isOnBoard(this.m_size)) {
            point = null;
        }
        if (!GoPoint.equals(this.m_cursor, point)) {
            this.setCursor(this.m_cursor, false);
            if (this.getShowCursor()) {
                this.setCursor(point, true);
            }
            this.m_cursor = point;
        }
    }

    public void setFieldBackground(GoPoint point, Color color) {
        Field field = this.getField(point);
        if (field.getFieldBackground() == null && color != null || field.getFieldBackground() != null && !field.getFieldBackground().equals(color)) {
            field.setFieldBackground(color);
            this.repaint(point);
        }
    }

    public void setCrossHair(GoPoint point, boolean crossHair) {
        Field field = this.getField(point);
        if (field.getCrossHair() != crossHair) {
            field.setCrossHair(crossHair);
            this.repaint(point);
        }
    }

    public void setGhostStone(GoPoint point, GoColor color) {
        Field field = this.getField(point);
        if (!ObjectUtil.equals((Object)field.getGhostStone(), (Object)color)) {
            field.setGhostStone(color);
            this.m_panel.repaintWithShadow(point);
        }
    }

    public void setInfluence(GoPoint point, double value) {
        this.getField(point).setInfluence(value);
        this.repaint(point);
    }

    public void setLabel(GoPoint point, String label) {
        Field field = this.getField(point);
        if (field.getLabel() == null && label != null || field.getLabel() != null && !field.getLabel().equals(label)) {
            field.setLabel(label);
            this.repaint(point);
        }
    }

    public void setListener(Listener listener) {
        this.m_listener = listener;
    }

    public void setMark(GoPoint point, boolean mark) {
        Field field = this.getField(point);
        if (field.getMark() != mark) {
            this.getField(point).setMark(mark);
            this.repaint(point);
        }
    }

    public void setMarkCircle(GoPoint point, boolean mark) {
        Field field = this.getField(point);
        if (field.getMarkCircle() != mark) {
            this.getField(point).setMarkCircle(mark);
            this.repaint(point);
        }
    }

    public void setMarkSquare(GoPoint point, boolean mark) {
        Field field = this.getField(point);
        if (field.getMarkSquare() != mark) {
            this.getField(point).setMarkSquare(mark);
            this.repaint(point);
        }
    }

    public void setMarkTriangle(GoPoint point, boolean mark) {
        Field field = this.getField(point);
        if (field.getMarkTriangle() != mark) {
            this.getField(point).setMarkTriangle(mark);
            this.repaint(point);
        }
    }

    public void setPreferredFieldSize(Dimension size) {
        this.m_preferredFieldSize = size;
        this.m_panel.setPreferredFieldSize();
    }

    public void setSelect(GoPoint point, boolean select) {
        Field field = this.getField(point);
        if (field.getSelect() != select) {
            this.getField(point).setSelect(select);
            this.repaint(point);
        }
    }

    public void setShowCursor(boolean showCursor) {
        this.setCursor(this.m_cursor, false);
        this.m_showCursor = showCursor;
        if (this.m_showCursor) {
            this.setCursor(this.m_cursor, true);
        }
        this.m_panel.requestFocusInWindow();
    }

    public void setShowGrid(boolean showGrid) {
        if (showGrid != this.m_showGrid) {
            this.m_showGrid = showGrid;
            this.m_dirty = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            this.repaint();
        }
    }

    public void setTerritory(GoPoint point, GoColor color) {
        Field field = this.getField(point);
        if (field.getTerritory() != color) {
            field.setTerritory(color);
            this.repaint(point);
        }
    }

    private void addDirty(Rectangle rectangle) {
        if (this.m_dirty == null) {
            this.m_dirty = rectangle;
        } else {
            this.m_dirty.add(rectangle);
        }
    }

    private void clearLastMove() {
        if (this.m_lastMove != null) {
            Field field = this.getField(this.m_lastMove);
            field.setLastMoveMarker(false);
            this.repaint(this.m_lastMove);
            this.m_lastMove = null;
        }
    }

    private void drawImage() {
        if (this.m_image == null || this.m_dirty == null) {
            return;
        }
        Graphics graphics = this.m_image.getGraphics();
        graphics.setClip(this.m_dirty);
        this.m_painter.draw(graphics, (ConstField[][])this.m_field, this.m_imageWidth, this.m_showGrid);
        this.m_dirty = null;
    }

    private void fieldClicked(GoPoint p, boolean modifiedSelect) {
        if (this.m_listener != null) {
            this.m_listener.fieldClicked(p, modifiedSelect);
        }
    }

    private Field getField(GoPoint p) {
        assert (p != null);
        return this.m_field[p.getX()][p.getY()];
    }

    private boolean isHandicapLineOrEdge(int line) {
        return this.m_constants.isHandicapLine(line) || this.m_constants.isEdgeLine(line);
    }

    private void keyPressed(KeyEvent event) {
        int code = event.getKeyCode();
        int modifiers = event.getModifiers();
        if (code == 10) {
            boolean modifiedSelect;
            int mask = 14;
            boolean bl = modifiedSelect = (modifiers & mask) != 0;
            if (this.getShowCursor() && this.m_cursor != null) {
                this.fieldClicked(this.m_cursor, modifiedSelect);
            }
            return;
        }
        if ((modifiers & 2) != 0 || !this.getShowCursor() || this.m_cursor == null) {
            return;
        }
        boolean shiftModifier = (modifiers & 1) != 0;
        GoPoint point = this.m_cursor;
        if (code == 40) {
            point = point.down();
            if (shiftModifier) {
                while (!this.isHandicapLineOrEdge(point.getY())) {
                    point = point.down();
                }
            }
        } else if (code == 38) {
            point = point.up(this.m_size);
            if (shiftModifier) {
                while (!this.isHandicapLineOrEdge(point.getY())) {
                    point = point.up(this.m_size);
                }
            }
        } else if (code == 37) {
            point = point.left();
            if (shiftModifier) {
                while (!this.isHandicapLineOrEdge(point.getX())) {
                    point = point.left();
                }
            }
        } else if (code == 39) {
            point = point.right(this.m_size);
            if (shiftModifier) {
                while (!this.isHandicapLineOrEdge(point.getX())) {
                    point = point.right(this.m_size);
                }
            }
        }
        this.setCursor(point);
    }

    private void repaint(GoPoint point) {
        this.m_panel.repaint(point);
    }

    private void setCursor(GoPoint point, boolean cursor) {
        if (point == null) {
            return;
        }
        Field field = this.getField(point);
        if (field.getCursor() != cursor) {
            field.setCursor(cursor);
            this.repaint(point);
        }
    }

    private void setPreferredFieldSize() {
        int size = (int)((double)GuiUtil.getDefaultMonoFontSize() * 2.5);
        if (size % 2 == 0) {
            ++size;
        }
        this.m_preferredFieldSize = new Dimension(size, size);
        size = GuiUtil.getDefaultMonoFontSize();
        if (size % 2 == 0) {
            ++size;
        }
        this.m_minimumFieldSize = new Dimension(size, size);
    }

    private class BoardPanel
    extends JPanel {
        public BoardPanel() {
            this.setPreferredFieldSize();
            this.setFocusable(true);
            this.setOpaque(true);
        }

        public void contextMenu(GoPoint point) {
            if (GuiBoard.this.m_listener == null) {
                return;
            }
            Point center = GuiBoard.this.m_painter.getCenter(point.getX(), point.getY());
            GuiBoard.this.m_listener.contextMenu(point, this, center.x, center.y);
        }

        public GoPoint getPoint(MouseEvent event) {
            return GuiBoard.this.m_painter.getPoint(event.getPoint());
        }

        public void paintComponent(Graphics graphics) {
            int width = this.getWidth();
            int height = this.getHeight();
            if (GuiBoard.this.m_image == null || width != GuiBoard.this.m_imageWidth || height != GuiBoard.this.m_imageHeight) {
                GuiBoard.this.m_image = this.createImage(width, height);
                GuiBoard.this.m_imageWidth = width;
                GuiBoard.this.m_imageHeight = height;
                GuiBoard.this.m_dirty = new Rectangle(0, 0, width, height);
            }
            GuiBoard.this.drawImage();
            graphics.drawImage(GuiBoard.this.m_image, 0, 0, null);
        }

        public void paintImmediately(GoPoint point) {
            Point location = GuiBoard.this.m_painter.getLocation(point.getX(), point.getY());
            Rectangle dirty = new Rectangle();
            dirty.x = location.x;
            dirty.y = location.y;
            int offset = GuiBoard.this.m_painter.getShadowOffset() - Field.getStoneMargin((int)GuiBoard.this.m_painter.getFieldSize());
            dirty.width = GuiBoard.this.m_painter.getFieldSize() + offset;
            dirty.height = GuiBoard.this.m_painter.getFieldSize() + offset;
            GuiBoard.this.addDirty(dirty);
            Rectangle oldDirty = GuiBoard.this.m_dirty;
            GuiBoard.this.m_dirty = dirty;
            this.paintImmediately(dirty);
            GuiBoard.this.m_dirty = oldDirty;
        }

        public void repaint(GoPoint point) {
            Point location = GuiBoard.this.m_painter.getLocation(point.getX(), point.getY());
            Rectangle dirty = new Rectangle();
            dirty.x = location.x;
            dirty.y = location.y;
            dirty.width = GuiBoard.this.m_painter.getFieldSize();
            dirty.height = GuiBoard.this.m_painter.getFieldSize();
            GuiBoard.this.addDirty(dirty);
            this.repaint(dirty);
        }

        public void repaintWithShadow(GoPoint point) {
            Point location = GuiBoard.this.m_painter.getLocation(point.getX(), point.getY());
            Rectangle dirty = new Rectangle();
            dirty.x = location.x;
            dirty.y = location.y;
            int offset = GuiBoard.this.m_painter.getShadowOffset() - Field.getStoneMargin((int)GuiBoard.this.m_painter.getFieldSize());
            dirty.width = GuiBoard.this.m_painter.getFieldSize() + offset;
            dirty.height = GuiBoard.this.m_painter.getFieldSize() + offset;
            GuiBoard.this.addDirty(dirty);
            this.repaint(dirty);
        }

        public final void setPreferredFieldSize() {
            int preferredFieldSize = GuiBoard.this.getPreferredFieldSize().width;
            this.setPreferredSize(BoardPainter.getPreferredSize((int)preferredFieldSize, (int)GuiBoard.this.m_size, (boolean)GuiBoard.this.m_showGrid));
            int minimumSize = 4 * GuiBoard.this.m_size + 2;
            this.setMinimumSize(new Dimension(minimumSize, minimumSize));
        }
    }

    public static interface Listener {
        public void fieldClicked(GoPoint var1, boolean var2);

        public void contextMenu(GoPoint var1, Component var2, int var3, int var4);
    }
}

