/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.util.ArrayList;
import java.util.prefs.Preferences;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.util.ObjectUtil;
import net.sf.gogui.util.PrefUtil;
import net.sf.gogui.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Program {
    public String m_label;
    public String m_name;
    public String m_version;
    public String m_command;
    public String m_workingDirectory;

    public Program(Program program) {
        this.copyFrom(program);
    }

    public Program(String label, String name, String version, String command, String workingDirectory) {
        this.init(label, name, version, command, workingDirectory);
    }

    public void copyFrom(Program program) {
        this.init(program.m_label, program.m_name, program.m_version, program.m_command, program.m_workingDirectory);
    }

    public static Program findProgram(ArrayList<Program> programs, String command) {
        for (Program p : programs) {
            if (!p.m_command.equals(command)) continue;
            return p;
        }
        return null;
    }

    public static ArrayList<Program> load() {
        String label;
        ArrayList<Program> programs = new ArrayList<Program>();
        Preferences prefs = PrefUtil.getNode("net/sf/gogui/gui/program");
        if (prefs == null) {
            return programs;
        }
        int size = prefs.getInt("size", 0);
        for (int i = 0; i < size && (prefs = PrefUtil.getNode("net/sf/gogui/gui/program/" + i)) != null && (label = prefs.get("label", null)) != null; ++i) {
            String name = prefs.get("name", "");
            String version = prefs.get("version", "");
            String command = prefs.get("command", "");
            String workingDirectory = prefs.get("working-directory", "");
            programs.add(new Program(label, name, version, command, workingDirectory));
        }
        return programs;
    }

    public static void save(ArrayList<Program> programs) {
        Preferences prefs = PrefUtil.createNode("net/sf/gogui/gui/program");
        if (prefs == null) {
            return;
        }
        prefs.putInt("size", programs.size());
        for (int i = 0; i < programs.size() && (prefs = PrefUtil.createNode("net/sf/gogui/gui/program/" + i)) != null; ++i) {
            Program p = programs.get(i);
            prefs.put("label", p.m_label);
            prefs.put("name", p.m_name);
            prefs.put("version", p.m_version);
            prefs.put("command", p.m_command);
            prefs.put("working-directory", p.m_workingDirectory);
        }
    }

    public void setUniqueLabel(ArrayList<Program> programs) {
        int i;
        String label = this.m_name;
        if (StringUtil.isEmpty(label)) {
            label = I18n.i18n("LB_UNKNOWN_PROGRAM");
        }
        String tryLabel = label;
        boolean alreadyExists = false;
        for (i = 0; i < programs.size(); ++i) {
            if (!tryLabel.equals(programs.get((int)i).m_label)) continue;
            alreadyExists = true;
            break;
        }
        if (!alreadyExists) {
            this.m_label = tryLabel;
            return;
        }
        i = 2;
        while (true) {
            tryLabel = label + " (" + i + ")";
            alreadyExists = false;
            for (int j = 0; j < programs.size(); ++j) {
                if (!tryLabel.equals(programs.get((int)j).m_label)) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) {
                this.m_label = tryLabel;
                return;
            }
            ++i;
        }
    }

    public boolean updateInfo(String name, String version) {
        if (name == null) {
            name = "";
        }
        if (version == null) {
            version = "";
        }
        boolean changed = false;
        if (!ObjectUtil.equals(this.m_name, name)) {
            this.m_name = name;
            changed = true;
        }
        if (!ObjectUtil.equals(this.m_version, version)) {
            this.m_version = version;
            changed = true;
        }
        return changed;
    }

    private void init(String label, String name, String version, String command, String workingDirectory) {
        this.m_label = label.trim();
        this.m_name = name.trim();
        this.m_version = version.trim();
        this.m_command = command.trim();
        this.m_workingDirectory = workingDirectory.trim();
    }
}

