/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.statistics;

import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.Histogram;
import net.sf.gogui.util.Statistics;
import net.sf.gogui.util.Table;
import net.sf.gogui.util.TableUtil;

public final class PositionStatistics {
    public final boolean m_onlyBoolValues;
    public final boolean m_onlyIntValues;
    public final int m_numberNoResult;
    public final Histogram m_histogram;
    public final Statistics m_statistics = new Statistics();
    public final Table m_histoTable;

    public PositionStatistics(String command, Table table, boolean noAutoScaleHisto, double histoMin, double histoMax) throws Table.InvalidLocation, ErrorMessage {
        boolean onlyIntValues = true;
        int numberNoResult = 0;
        boolean onlyBoolValues = true;
        for (int row = 0; row < table.getNumberRows(); ++row) {
            int move;
            String value = table.get(command, row);
            if (value == null) {
                ++numberNoResult;
                continue;
            }
            if (TableUtil.isNumberValue(value)) {
                if (!TableUtil.isIntValue(value)) {
                    onlyIntValues = false;
                }
                if (!TableUtil.isBoolValue(value)) {
                    onlyBoolValues = false;
                }
            }
            try {
                move = Integer.parseInt(table.get("Move", row));
            }
            catch (NumberFormatException e) {
                throw new ErrorMessage("Invalid move in table");
            }
            if (move < 0) {
                throw new ErrorMessage("Invalid move in table");
            }
            try {
                this.m_statistics.add(Double.parseDouble(value));
                continue;
            }
            catch (NumberFormatException e) {
                ++numberNoResult;
            }
        }
        this.m_onlyBoolValues = onlyBoolValues;
        this.m_onlyIntValues = onlyIntValues;
        this.m_numberNoResult = numberNoResult;
        double min = this.m_statistics.getMin();
        double max = this.m_statistics.getMax();
        if (!noAutoScaleHisto) {
            histoMin = min;
            histoMax = max;
        }
        double diff = histoMax - histoMin;
        int maxBins = 20;
        if (onlyIntValues) {
            int step = Math.max(1, (int)(diff / (double)maxBins + 1.0));
            this.m_histogram = new Histogram(histoMin, histoMax, step);
        } else {
            this.m_histogram = new Histogram(histoMin, histoMax, diff / (double)maxBins);
        }
        for (int i = 0; i < table.getNumberRows(); ++i) {
            String value = table.get(command, i);
            if (value == null) continue;
            try {
                this.m_histogram.add(Double.parseDouble(value));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.m_histoTable = TableUtil.fromHistogram(this.m_histogram, command);
    }

    public int getCount() {
        return this.m_statistics.getCount();
    }

    public double getError() {
        return this.m_statistics.getError();
    }

    public double getDeviation() {
        return this.m_statistics.getDeviation();
    }

    public double getMax() {
        return this.m_statistics.getMax();
    }

    public double getMaxError(int n) {
        return this.m_statistics.getMaxError(n);
    }

    public double getMean() {
        return this.m_statistics.getMean();
    }

    public double getMin() {
        return this.m_statistics.getMin();
    }

    public double getSum() {
        return this.m_statistics.getSum();
    }
}

