/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.statistics;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.sf.gogui.game.ConstGame;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.Game;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.InvalidPointException;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpClientBase;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpSynchronizer;
import net.sf.gogui.sgf.SgfError;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.tools.statistics.FileCheck;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.Platform;
import net.sf.gogui.util.StringUtil;
import net.sf.gogui.util.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics {
    private boolean m_allowSetup;
    private boolean m_backward;
    private boolean m_random;
    private boolean m_quiet;
    private int m_max = Integer.MAX_VALUE;
    private int m_min = 0;
    private int m_numberGames;
    private int m_size;
    private double m_lastCpuTime = 0.0;
    private GtpClientBase m_gtp;
    private static final NumberFormat FORMAT1 = StringUtil.getNumberFormat(1);
    private static final NumberFormat FORMAT2 = StringUtil.getNumberFormat(2);
    private Table m_table;
    private ArrayList<Command> m_commands;
    private GtpSynchronizer m_synchronizer;

    public void run(String program, ArrayList<String> sgfFiles, int size, ArrayList<String> commands, ArrayList<String> beginCommands, ArrayList<String> finalCommands, boolean verbose, boolean allowSetup, boolean backward, boolean random) throws ErrorMessage, GtpError, IOException {
        this.run(new GtpClient(program, null, verbose, null), program, sgfFiles, size, commands, beginCommands, finalCommands, allowSetup, backward, random);
    }

    public void run(GtpClientBase gtp, String program, ArrayList<String> sgfFiles, int size, ArrayList<String> commands, ArrayList<String> beginCommands, ArrayList<String> finalCommands, boolean allowSetup, boolean backward, boolean random) throws ErrorMessage, IOException {
        new FileCheck(sgfFiles, size, allowSetup);
        this.m_size = size;
        this.m_allowSetup = allowSetup;
        this.m_backward = backward;
        this.m_random = random;
        this.initCommands(commands, beginCommands, finalCommands);
        ArrayList<String> columnHeaders = new ArrayList<String>();
        columnHeaders.add("File");
        columnHeaders.add("Move");
        for (int i = 0; i < this.m_commands.size(); ++i) {
            columnHeaders.add(this.getCommand((int)i).m_columnTitle);
        }
        this.m_table = new Table(columnHeaders);
        this.m_table.setProperty("Size", Integer.toString(size));
        this.m_gtp = gtp;
        this.m_synchronizer = new GtpSynchronizer(this.m_gtp);
        this.m_gtp.queryProtocolVersion();
        this.m_gtp.queryName();
        if (program != null) {
            this.m_table.setProperty("Program", program);
        }
        this.m_table.setProperty("Name", this.m_gtp.getLabel());
        this.m_table.setProperty("Version", this.m_gtp.queryVersion());
        String host = Platform.getHostInfo();
        this.m_table.setProperty("Host", host);
        this.m_table.setProperty("Date", StringUtil.getDate());
        for (int i = 0; i < sgfFiles.size(); ++i) {
            this.handleFile(sgfFiles.get(i));
        }
        this.m_gtp.send("quit");
        this.m_gtp.close();
        this.m_gtp.waitForExit();
        this.m_table.setProperty("Games", Integer.toString(this.m_numberGames));
        this.m_table.setProperty("Backward", backward ? "yes" : "no");
        this.m_table.setProperty("Random", random ? "yes" : "no");
    }

    public void setMax(int max) {
        this.m_max = max;
    }

    public void setMin(int min) {
        this.m_min = min;
    }

    public void setQuiet(boolean enable) {
        this.m_quiet = enable;
    }

    public void saveTable(File output) throws IOException {
        FileWriter writer = new FileWriter(output);
        try {
            this.m_table.save(writer);
        }
        finally {
            writer.close();
        }
    }

    private void addCommand(String commandLine, boolean isBegin, boolean isFinal) throws ErrorMessage {
        if ((commandLine = commandLine.trim()).equals("")) {
            throw new ErrorMessage("Empty command not allowed");
        }
        Command command = new Command();
        command.m_command = commandLine;
        command.m_begin = isBegin;
        command.m_final = isFinal;
        int numberSame = 0;
        Command firstSame = null;
        for (int i = 0; i < this.m_commands.size(); ++i) {
            if (!this.getCommand((int)i).m_command.equals(commandLine)) continue;
            firstSame = this.getCommand(i);
            ++numberSame;
        }
        if (numberSame == 0) {
            command.m_columnTitle = commandLine;
        } else {
            if (numberSame == 1) {
                firstSame.m_columnTitle = firstSame.m_columnTitle + " (1)";
            }
            command.m_columnTitle = commandLine + " (" + (numberSame + 1) + ")";
        }
        this.m_commands.add(command);
    }

    private void addCommands(ArrayList<String> commands, boolean isBegin, boolean isFinal) throws ErrorMessage {
        for (String c : commands) {
            this.addCommand(c, isBegin, isFinal);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkGame(ConstGameTree tree, String name) throws ErrorMessage {
        int size = tree.getBoardSize();
        if (size != this.m_size) {
            throw new ErrorMessage(name + " has not size " + this.m_size);
        }
        ConstNode root = tree.getRootConst();
        GoColor toMove = GoColor.BLACK;
        for (ConstNode node = root; node != null; node = node.getChildConst()) {
            Move move;
            if (node.hasSetup()) {
                if (!this.m_allowSetup) throw new ErrorMessage(name + " contains setup stones");
                if (node != root) throw new ErrorMessage(name + " contains setup stones in non-root position");
                toMove = GoColor.EMPTY;
            }
            if ((move = node.getMove()) == null) continue;
            if (toMove == GoColor.EMPTY) {
                toMove = move.getColor();
            }
            if (move.getColor() != toMove) {
                throw new ErrorMessage(name + "has non-alternating moves");
            }
            toMove = toMove.otherColor();
        }
    }

    private String convertCommand(String command, GoColor toMove) {
        if (command.equals("reg_genmove")) {
            return command + ' ' + (Object)((Object)toMove);
        }
        return command;
    }

    private String convertResponse(String command, String response, GoColor toMove, Move move) throws GtpError {
        if (command.equals("cputime")) {
            try {
                double cpuTime = Double.parseDouble(response);
                double diff = cpuTime - this.m_lastCpuTime;
                this.m_lastCpuTime = cpuTime;
                return FORMAT2.format(diff);
            }
            catch (NumberFormatException e) {
                return response;
            }
        }
        if (command.equals("estimate_score")) {
            String[] arg = StringUtil.splitArguments(response);
            if (arg.length == 0) {
                return response;
            }
            return this.convertScore(arg[0]);
        }
        if (command.equals("final_score")) {
            return this.convertScore(response);
        }
        if (command.equals("reg_genmove")) {
            if (move == null) {
                return "";
            }
            try {
                GoPoint point = GoPoint.parsePoint(response, this.m_size);
                return Move.get(toMove, point) == move ? "1" : "0";
            }
            catch (InvalidPointException e) {
                throw new GtpError("Program sent invalid move: " + response);
            }
        }
        return response;
    }

    private String convertScore(String string) {
        String score = string.trim();
        double sign = 1.0;
        if (score.startsWith("W+")) {
            score = score.substring(2);
            sign = -1.0;
        } else if (score.startsWith("B+")) {
            score = score.substring(2);
        }
        try {
            return FORMAT1.format(sign * Double.parseDouble(score));
        }
        catch (NumberFormatException e) {
            return string;
        }
    }

    private void initCommands(ArrayList<String> commands, ArrayList<String> beginCommands, ArrayList<String> finalCommands) throws ErrorMessage {
        this.m_commands = new ArrayList();
        if (beginCommands != null) {
            this.addCommands(beginCommands, true, false);
        }
        if (commands != null) {
            this.addCommands(commands, false, false);
        }
        if (finalCommands != null) {
            this.addCommands(finalCommands, false, true);
        }
        if (this.m_commands.isEmpty()) {
            throw new ErrorMessage("No commands defined");
        }
    }

    private Command getCommand(int index) {
        return this.m_commands.get(index);
    }

    private void handleFile(String name) throws ErrorMessage, FileNotFoundException, GtpError, SgfError {
        File file = new File(name);
        FileInputStream in = new FileInputStream(file);
        SgfReader reader = new SgfReader(in, file, null, 0L);
        ++this.m_numberGames;
        Game game = new Game(reader.getTree());
        this.checkGame(game.getTree(), name);
        if (this.m_random) {
            this.iteratePositionsRandom(game, name);
        } else if (this.m_backward) {
            this.iteratePositionsBackward(game, name);
        } else {
            this.iteratePositions(game, name);
        }
    }

    private void handlePosition(String name, GoColor toMove, Move move, int number, boolean beginCommands, boolean regularCommands, boolean finalCommands) throws GtpError {
        block6: {
            if (!this.m_quiet) {
                System.err.println(name + ":" + number);
            }
            this.m_table.startRow();
            try {
                String response;
                Command command;
                int i;
                this.m_table.set("File", name);
                this.m_table.set("Move", number);
                for (i = 0; i < this.m_commands.size(); ++i) {
                    command = this.getCommand(i);
                    if (!command.m_begin || !beginCommands) continue;
                    response = this.send(command.m_command, toMove, move);
                    this.m_table.set(command.m_columnTitle, response);
                }
                for (i = 0; i < this.m_commands.size(); ++i) {
                    command = this.getCommand(i);
                    if (command.m_begin || command.m_final || !regularCommands) continue;
                    response = this.send(command.m_command, toMove, move);
                    this.m_table.set(command.m_columnTitle, response);
                }
                for (i = 0; i < this.m_commands.size(); ++i) {
                    command = this.getCommand(i);
                    if (!command.m_final || !finalCommands) continue;
                    response = this.send(command.m_command, toMove, move);
                    this.m_table.set(command.m_columnTitle, response);
                }
            }
            catch (Table.InvalidLocation e) {
                System.err.println(e.getMessage());
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    private void iteratePositions(Game game, String name) throws GtpError {
        int number = 0;
        for (ConstNode node = game.getRoot(); node != null; node = node.getChildConst()) {
            boolean finalCommands;
            game.gotoNode(node);
            this.synchronize(game);
            Move move = node.getMove();
            boolean beginCommands = !node.hasFather();
            boolean regularCommands = (move != null || node.hasSetup() || !node.hasFather()) && number >= this.m_min && number <= this.m_max;
            boolean bl = finalCommands = !node.hasChildren();
            if (beginCommands || regularCommands || finalCommands) {
                this.handlePosition(name, node.getToMove(), move, number, beginCommands, regularCommands, finalCommands);
            }
            ++number;
        }
    }

    private void iteratePositionsBackward(Game game, String name) throws GtpError {
        int number = 0;
        for (ConstNode node = NodeUtil.getLast(game.getRoot()); node != null; node = node.getFatherConst()) {
            boolean finalCommands;
            game.gotoNode(node);
            this.synchronize(game);
            Move move = node.getMove();
            boolean beginCommands = !node.hasChildren();
            boolean regularCommands = (move != null || node.hasSetup() || !node.hasFather()) && number >= this.m_min && number <= this.m_max;
            boolean bl = finalCommands = !node.hasFather();
            if (beginCommands || regularCommands || finalCommands) {
                this.handlePosition(name, node.getToMove(), move, number, beginCommands, regularCommands, finalCommands);
            }
            ++number;
        }
    }

    private void iteratePositionsRandom(Game game, String name) throws GtpError {
        boolean finalCommands;
        int maxDepth;
        int minDepth;
        if (this.m_backward) {
            int depth = NodeUtil.getDepth(NodeUtil.getLast(game.getRoot()));
            minDepth = depth - this.m_max;
            maxDepth = depth - this.m_min;
        } else {
            minDepth = this.m_min;
            maxDepth = this.m_max;
        }
        ConstNode node = NodeUtil.selectRandom(game.getRoot(), minDepth, maxDepth);
        if (node == null) {
            return;
        }
        int number = NodeUtil.getDepth(node);
        game.gotoNode(node);
        this.synchronize(game);
        Move move = node.getMove();
        boolean beginCommands = !node.hasChildren();
        boolean regularCommands = move != null || node.hasSetup() || !node.hasFather();
        boolean bl = finalCommands = !node.hasFather();
        if (beginCommands || regularCommands || finalCommands) {
            this.handlePosition(name, node.getToMove(), move, number, beginCommands, regularCommands, finalCommands);
        }
    }

    private String send(String command, GoColor toMove, Move move) throws GtpError {
        String cmd = this.convertCommand(command, toMove);
        String response = this.m_gtp.send(cmd).trim();
        response = response.replaceAll("\t", " ");
        response = response.replaceAll("\n", " ");
        return this.convertResponse(command, response, toMove, move);
    }

    private void synchronize(ConstGame game) throws GtpError {
        ConstNode node = game.getGameInfoNode();
        ConstGameInfo info = game.getGameInfo(node);
        this.m_synchronizer.synchronize(game.getBoard(), info.getKomi(), info.getTimeSettings());
    }

    private static class Command {
        public boolean m_begin;
        public boolean m_final;
        public String m_command;
        public String m_columnTitle;

        private Command() {
        }
    }
}

