#!/2022Q2/bin/perl -w

use strict;

# This script updates some configuration keys

# read the whole config file
my $currentGroup = "";
my %configFile;
while ( <> ) {
  chomp; # eat the trailing '\n'
  next if ( /^$/ ); # skip empty lines
  next if ( /^\#/ ); # skip comments
  if ( /^\[/ ) { # group begin
    $currentGroup = $_;
    next;
  } elsif ( $currentGroup eq "[General]" and /^sendOnCheck/ ) {
    my ($key,$value) = split /=/;
    print "# DELETE $currentGroup$key\n";
    if ( $value eq "true" ) {
      print "[Behaviour]\nSendOnCheck=SendOnManualCheck\n";
    }
    else {
      print "[Behaviour]\nSendOnCheck=DontSendOnCheck\n";
    }
  }
}
