# Do not modify this file. Any change will be overwritten by CMake.

# Config file for Baloo. This file will define:
# BALOO_INCLUDE_DIR - The Baloo include directory
# BALOO_LIBRARIES - The library needed to use Baloo

get_filename_component(_currentDir ${CMAKE_CURRENT_LIST_FILE} PATH) # The current directory
get_filename_component(rootDir ${_currentDir}/ ABSOLUTE) # The install prefix

# The library version
set(BALOO_VERSION_MAJOR 4)
set(BALOO_VERSION_MINOR 14)
set(BALOO_VERSION_RELEASE 3)
set(BALOO_VERSION ${BALOO_VERSION_MAJOR}.${BALOO_VERSION_MINOR}.${BALOO_VERSION_RELEASE})


# Include directory
set(BALOO_INSTALL_PREFIX "${rootDir}")
set(BALOO_INCLUDE_DIR "/2022Q2/include")
set(Baloo_FOUND true)

include(${_currentDir}/BalooTargetsWithPrefix.cmake)

set(BALOO_CORE_LIBRARY baloocore)
set(BALOO_FILE_LIBRARY baloofiles)
set(BALOO_PIM_LIBRARY baloopim)
set(BALOO_QUERYPARSER_LIBRARY balooqueryparser)
#set(BALOO_TAG_LIBRARY balootags)

# Set the library variable
set(BALOO_LIBRARIES ${BALOO_CORE_LIBRARY} ${BALOO_FILE_LIBRARY} ${BALOO_PIM_LIBRARY} ${BALOO_QUERYPARSER_LIBRARY})

