# Creating a new guest
use strict;
use warnings;
our (%gui, %signal, %sensgrp, %ETruth, %hostspec, %osfamily, %osversion);

sub show_newguest_dialog() {
    my @IMedium = IVirtualBox_getHardDisks($gui{websn});
    $gui{entryNewName}->set_text('NewGuest' . int(rand(9999)));
    $gui{notebookNew}->set_current_page(0);
    $gui{spinbuttonNewMemory}->set_range(4, $hostspec{memsize});
    $gui{spinbuttonNewHDSize}->set_range(8.00, $hostspec{maxhdsize});
    $gui{comboboxNewOSFam}->signal_handler_block($signal{fam}); # Block to avoid signal emission when changing
    $gui{comboboxNewOSVer}->signal_handler_block($signal{ver});
    &clr_list($gui{liststoreNewOSFam}, $gui{liststoreNewOSVer}, $gui{liststoreNewChooseHD});

    foreach my $fam (sort(keys %osfamily)) {
        my $iter = &addrow_list($gui{liststoreNewOSFam}, 0, "$osfamily{$fam}{description}", 1, $fam, 2, $osfamily{$fam}{icon});
        $gui{comboboxNewOSFam}->set_active_iter($iter) if ($fam eq 'Windows');
    }

    if (@IMedium > 0) {
        &addrow_list($gui{liststoreNewChooseHD}, 0, IMedium_getName($_), 1, $_) foreach (@IMedium);
        $gui{comboboxNewChooseHD}->set_active(0);
        &sensitive_on($gui{radiobuttonNewExistingHD});
    }
    else { &sensitive_off($gui{radiobuttonNewExistingHD}) };

    $gui{comboboxNewOSFam}->signal_handler_unblock($signal{fam});
    $gui{comboboxNewOSVer}->signal_handler_unblock($signal{ver});
    $gui{comboboxNewOSFam}->signal_emit('changed'); # Force update of other fields based on OS
    $gui{comboboxNewOSVer}->signal_emit('changed'); # Force update of other fields based on OS
    my $response = $gui{dialogNew}->run;
    $gui{dialogNew}->hide;

    if ($response eq 'ok') {
        my $buttongrp = $gui{radiobuttonNewNewHD}->get_group();
        my %guest = (name   => $gui{entryNewName}->get_text(),
                     fam    => &getsel_combo($gui{comboboxNewOSFam}, 1),
                     ver    => &getsel_combo($gui{comboboxNewOSVer}, 1),
                     mem    => $gui{spinbuttonNewMemory}->get_value_as_int(),
                     hdsize => $gui{spinbuttonNewHDSize}->get_value_as_int());

        $guest{name} = 'NewGuest' . int(rand(9999)) if (!$guest{name});
        my ($IMachine, $dvdctrname, $hdctrname) = &create_new_guest($guest{name},$guest{fam}, $guest{ver}, $guest{mem});

        if ($IMachine) {
            my ($ISession, $IMachineM) = &get_mutable_session($IMachine);
            my $IMediumHD;

            if ($$buttongrp[0]->get_active() == 1){ $IMediumHD = &getsel_combo($gui{comboboxNewChooseHD}, 1); }
            else {
                my $hdimgtype = 'Fixed';
                $hdimgtype = 'Standard' if ($gui{checkbuttonNewDynamic}->get_active());
                $IMediumHD = &create_new_hd($guest{name}, 'VDI', $hdimgtype, $guest{hdsize}, $gui{windowMain});
            }

            my $IStorCtrHD = IMachine_getStorageControllerByName($IMachineM, $hdctrname);
            &create_sas_sata_port($IStorCtrHD);
            my ($hddev, $hdport) = &get_free_deviceport($IMachineM, $IStorCtrHD);
            IMachine_attachDevice($IMachineM, $hdctrname, $hdport, $hddev, 'HardDisk', IMedium_getId($IMediumHD));

            # Attach Empty CD/DVD Device
            my $IStorCtrDVD = IMachine_getStorageControllerByName($IMachineM, $dvdctrname);
            &create_sas_sata_port($IStorCtrDVD);
            my ($dvddev, $dvdport) = &get_free_deviceport($IMachineM, $IStorCtrDVD);
            IMachine_attachDevice($IMachineM, $dvdctrname, $dvdport, $dvddev, 'DVD', 'UUID 00000000-0000-0000-0000-000000000000');
            IMachine_saveSettings($IMachineM);
            ISession_close($ISession);
        }
        else { &show_err_msg('createguest', $gui{messagedialogError}, " ($guest{name})"); }

        &fill_list_guest();
    }
}

sub create_new_guest() {
    my ($name, $fam, $ver, $mem) = @_;
    my $IMachine;
    my $dvdctrname = $osversion{$ver}{recommendedDvdStorageBus} .  ' Controller';
    my $hdctrname = $osversion{$ver}{recommendedHdStorageBus} . ' Controller';
    my $portnum = int(rand(15000)) + 50000; # Pick random between 50000 and 65000
    $IMachine = IVirtualBox_createMachine($gui{websn}, $name, $ver, '', 'UUID 00000000-0000-0000-0000-000000000000');

    if ($IMachine) {
        my $IVRDPServer = IMachine_getVRDPServer($IMachine);
        my $IBIOSSettings = IMachine_getBIOSSettings($IMachine);
        IBIOSSettings_setIOAPICEnabled($IBIOSSettings, $ETruth{$osversion{$ver}{recommendedIOAPIC}});
        IMachine_setCPUProperty($IMachine, 'PAE', $ETruth{$osversion{$ver}{recommendedPae}});
        IMachine_setHWVirtExProperty($IMachine, 'Enabled', $ETruth{$osversion{$ver}{recommendedVirtEx}});
        IMachine_setVRAMSize($IMachine, $osversion{$ver}{recommendedVRAM});
        IMachine_setFirmwareType($IMachine, $osversion{$ver}{recommendedFirmware});
        IMachine_setMemorySize($IMachine, $mem);
        my $IStorCtrDVD = IMachine_addStorageController($IMachine, $dvdctrname, $osversion{$ver}{recommendedDvdStorageBus});
        IStorageController_setControllerType($IStorCtrDVD, $osversion{$ver}{recommendedDvdStorageController});

        if ($osversion{$ver}{recommendedHdStorageBus} ne $osversion{$ver}{recommendedDvdStorageBus}) {
            my $IStorCtrHD = IMachine_addStorageController($IMachine, $hdctrname, $osversion{$ver}{recommendedHdStorageBus});
            IStorageController_setControllerType($IStorCtrHD, $osversion{$ver}{recommendedHdStorageController});
        }

        IVRDPServer_setPorts($IVRDPServer, $portnum);
        IVRDPServer_setEnabled($IVRDPServer, 'true');
        IMachine_saveSettings($IMachine);
        IVirtualBox_registerMachine($gui{websn}, $IMachine);
        &log_msg("Created a new guest: $name.");
    }

    return $IMachine, $dvdctrname, $hdctrname;
}

sub newgen_osfam() {
    my ($combofam, $combover) = @_;
    my $fam = &getsel_combo($combofam, 1);
    $combofam->signal_handler_block($signal{fam}); # Block to avoid signal emission when changing
    $combover->signal_handler_block($signal{ver});
    &clr_list($gui{liststoreNewOSVer});

    foreach my $ver (sort(@{ $osfamily{$fam}{verids} })) {
        my $iter = &addrow_list($gui{liststoreNewOSVer}, 0, $osversion{$ver}{description}, 1, $ver, 2, $osversion{$ver}{icon});
        $combover->set_active_iter($iter) if ($ver eq 'WindowsXP' | $ver eq 'Ubuntu' | $ver eq 'Solaris');
    }

    $combover->set_active(0) if ($combover->get_active() == -1);
    $combofam->signal_handler_unblock($signal{fam});
    $combover->signal_handler_unblock($signal{ver});
    $combover->signal_emit('changed'); # Force update of other fields based on OS
}

sub newgen_osver() {
    my ($combover, $combofam) = @_;
    my $ver = &getsel_combo($combover, 1);
    $combofam->signal_handler_block($signal{fam}); # Avoid signal emission when changing
    $combover->signal_handler_block($signal{ver});
    $gui{spinbuttonNewMemory}->set_value($osversion{$ver}{recommendedRAM});
    $gui{spinbuttonNewHDSize}->set_value($osversion{$ver}{recommendedHDD});
    $combofam->signal_handler_unblock($signal{fam});
    $combover->signal_handler_unblock($signal{ver});
}

sub newstor_new_exist() {
    my ($widget) = @_;
    my $buttongrp = $widget->get_group();

    if ($$buttongrp[0]->get_active() == 1) {
        &sensitive_on($gui{comboboxNewChooseHD});
        &sensitive_off($gui{checkbuttonNewDynamic}, $gui{spinbuttonNewHDSize});
    }
    else {
        &sensitive_off($gui{comboboxNewChooseHD});
        &sensitive_on($gui{checkbuttonNewDynamic}, $gui{spinbuttonNewHDSize});
    }
}

1;