# Edit Network Settings of a Guest
use strict;
use warnings;
our (%gui, %signal, %bool, %ENetAdap, %ENetAttach, %vmc);

sub setup_edit_dialog_network() {
    &busy_window($gui{dialogEdit}, 0, 'watch');
    $gui{comboboxEditNetType1}->signal_handler_block($signal{netadaptype1});
    $gui{comboboxEditNetType2}->signal_handler_block($signal{netadaptype2});
    $gui{comboboxEditNetType3}->signal_handler_block($signal{netadaptype3});
    $gui{comboboxEditNetType4}->signal_handler_block($signal{netadaptype4});
    $gui{comboboxEditNetAttach1}->signal_handler_block($signal{netattach1});
    $gui{comboboxEditNetAttach2}->signal_handler_block($signal{netattach2});
    $gui{comboboxEditNetAttach3}->signal_handler_block($signal{netattach3});
    $gui{comboboxEditNetAttach4}->signal_handler_block($signal{netattach4});
    $gui{comboboxEditNetName1}->signal_handler_block($signal{netname1});
    $gui{comboboxEditNetName2}->signal_handler_block($signal{netname2});
    $gui{comboboxEditNetName3}->signal_handler_block($signal{netname3});
    $gui{comboboxEditNetName4}->signal_handler_block($signal{netname4});
    foreach ($gui{liststoreEditNetAdapterType1}, $gui{liststoreEditNetAdapterType2}, $gui{liststoreEditNetAdapterType3},
             $gui{liststoreEditNetAdapterType4}, $gui{liststoreEditNetAttachTo1}, $gui{liststoreEditNetAttachTo2},
             $gui{liststoreEditNetAttachTo3}, $gui{liststoreEditNetAttachTo4}, $gui{liststoreEditNetName1},
             $gui{liststoreEditNetName2}, $gui{liststoreEditNetName3}, $gui{liststoreEditNetName4}) {
        $_->clear();
    }

    my $IHost = IVirtualBox_getHost($gui{websn});

    foreach my $slot (1..4) {
        my $INetworkAdapter = IMachine_getNetworkAdapter($vmc{IMachine},($slot-1));
        my $NetAdapterType = INetworkAdapter_getAdapterType($INetworkAdapter);
        my $AttachType = INetworkAdapter_getAttachmentType($INetworkAdapter);
        my $hostinterface = INetworkAdapter_getHostInterface($INetworkAdapter);
        my @IHostNetworkInterface = IHost_getNetworkInterfaces($IHost);
        $gui{'checkbuttonEditNetEnable' . $slot}->set_active($bool{INetworkAdapter_getEnabled($INetworkAdapter)});
        $gui{'tableEditNet' . $slot}->set_sensitive($gui{'checkbuttonEditNetEnable' . $slot}->get_active()); # Ghost/Unghost other widgets based on net enabled
        $gui{'checkbuttonEditNetCable' . $slot}->set_active($bool{INetworkAdapter_getCableConnected($INetworkAdapter)});
        $gui{'entryEditNetMac' . $slot}->set_text(INetworkAdapter_getMACAddress($INetworkAdapter));
        # Set current adapter type for NICs 1-4
        foreach my $adaptertype (sort(keys %ENetAdap)) {
            my $iter = $gui{'liststoreEditNetAdapterType' . $slot}->append();
            $gui{'liststoreEditNetAdapterType' . $slot}->set($iter, 0, $ENetAdap{$adaptertype}, 1, $adaptertype);
            $gui{'comboboxEditNetType' . $slot}->set_active_iter($iter) if ($adaptertype eq $NetAdapterType);
        }
        # Set current attachment type for NICs 1-4
        foreach my $attach (sort(keys %ENetAttach)) {
            my $iter = $gui{'liststoreEditNetAttachTo' . $slot}->append();
            $gui{'liststoreEditNetAttachTo' . $slot}->set($iter, 0, $ENetAttach{$attach}, 1, $attach);
            $gui{'comboboxEditNetAttach' . $slot}->set_active_iter($iter) if ($attach eq $AttachType);
        }

        if ($AttachType eq 'Bridged') {
            # Set current bridged network name for NICs 1-4, depending on attachment type
            foreach my $interface (@IHostNetworkInterface) {
                if (IHostNetworkInterface_getInterfaceType($interface) eq 'Bridged') {
                    my $name = IHostNetworkInterface_getName($interface);
                    my $iter = $gui{'liststoreEditNetName' . $slot}->append();
                    $gui{'liststoreEditNetName' . $slot}->set($iter, 0, $name);
                    $gui{'comboboxEditNetName' . $slot}->set_active_iter($iter) if ($name eq $hostinterface);
                }
            }
            &hide_off($gui{'labelEditNetName' . $slot}, $gui{'comboboxEditNetName' . $slot});
            &hide_on($gui{'labelEditNetNameInt' . $slot}, $gui{'entryEditNetNameInt' . $slot});
        }
        elsif ($AttachType eq 'HostOnly') {
            # Set current hostonly network name for NICs 1-4, depending on attachment type
            foreach my $interface (@IHostNetworkInterface) {
                if (IHostNetworkInterface_getInterfaceType($interface) eq 'HostOnly') {
                    my $name = IHostNetworkInterface_getName($interface);
                    my $iter = $gui{'liststoreEditNetName' . $slot}->append();
                    $gui{'liststoreEditNetName' . $slot}->set($iter, 0, $name);
                    $gui{'comboboxEditNetName' . $slot}->set_active_iter($iter) if ($name eq $hostinterface);
                }
            }
            &hide_off($gui{'labelEditNetName' . $slot}, $gui{'comboboxEditNetName' . $slot});
            &hide_on($gui{'labelEditNetNameInt' . $slot}, $gui{'entryEditNetNameInt' . $slot});
        }
        elsif ($AttachType eq 'Internal') {
            my $name = INetworkAdapter_getInternalNetwork($INetworkAdapter);
            $gui{'entryEditNetNameInt' . $slot}->set_text($name);
            &hide_on($gui{'labelEditNetName' . $slot}, $gui{'comboboxEditNetName' . $slot});
            &hide_off($gui{'labelEditNetNameInt' . $slot}, $gui{'entryEditNetNameInt' . $slot});
        }
        #elsif ($AttachType eq 'VDE') {
        #
        #}
        else {
            # All other networking types do not have name associated with them
            &hide_on($gui{'labelEditNetName' . $slot}, $gui{'comboboxEditNetName' . $slot},
                     $gui{'labelEditNetNameInt' . $slot}, $gui{'entryEditNetNameInt' . $slot});
        }
    }

    $gui{comboboxEditNetType1}->signal_handler_unblock($signal{netadaptype1});
    $gui{comboboxEditNetType2}->signal_handler_unblock($signal{netadaptype2});
    $gui{comboboxEditNetType3}->signal_handler_unblock($signal{netadaptype3});
    $gui{comboboxEditNetType4}->signal_handler_unblock($signal{netadaptype4});
    $gui{comboboxEditNetAttach1}->signal_handler_unblock($signal{netattach1});
    $gui{comboboxEditNetAttach2}->signal_handler_unblock($signal{netattach2});
    $gui{comboboxEditNetAttach3}->signal_handler_unblock($signal{netattach3});
    $gui{comboboxEditNetAttach4}->signal_handler_unblock($signal{netattach4});
    $gui{comboboxEditNetName1}->signal_handler_unblock($signal{netname1});
    $gui{comboboxEditNetName2}->signal_handler_unblock($signal{netname2});
    $gui{comboboxEditNetName3}->signal_handler_unblock($signal{netname3});
    $gui{comboboxEditNetName4}->signal_handler_unblock($signal{netname4});
    &busy_window($gui{dialogEdit}, 1, undef);
}

sub net_toggle() {
    my ($widget, $checkbutton) = @_;
    my $state = $widget->get_active();
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    INetworkAdapter_setEnabled($INetworkAdapter, $state);
    $gui{'tableEditNet' . $num}->set_sensitive($state);
}

sub net_cable() {
    my ($widget, $checkbutton) = @_;
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    INetworkAdapter_setCableConnected($INetworkAdapter, $widget->get_active());
}

sub net_mac() {
    my ($widget, $focus, $checkbutton) = @_;
    $checkbutton = $focus if (!$checkbutton);
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    my $mac = $widget->get_text();
    INetworkAdapter_setMACAddress($INetworkAdapter, $mac) if (length($mac) == 12);
}

sub net_adapter_type() {
    my ($widget, $checkbutton) = @_;
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    my $type = &getsel_combo($widget, 1);
    INetworkAdapter_setAdapterType($INetworkAdapter, $type);
}

sub net_attach() {
    my ($widget, $checkbutton) = @_;
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    $gui{'comboboxEditNetName' . $num}->signal_handler_block($signal{'netname' . $num});
    my $IHost = IVirtualBox_getHost($gui{websn});
    my $AttachType = &getsel_combo($widget, 1);
    $gui{'liststoreEditNetName' . $num}->clear();

    if ($AttachType eq 'Bridged') {
        # Set current bridged network name for NICs 1-4, depending on attachment type
        my @IHostNetworkInterface = IHost_getNetworkInterfaces($IHost);
        foreach my $interface (@IHostNetworkInterface) {
            if (IHostNetworkInterface_getInterfaceType($interface) eq 'Bridged') {
                my $name = IHostNetworkInterface_getName($interface);
                my $iter = $gui{'liststoreEditNetName' . $num}->append();
                $gui{'liststoreEditNetName' . $num}->set($iter, 0, $name);
            }
        }
        INetworkAdapter_attachToBridgedInterface($INetworkAdapter);
        &hide_off($gui{'labelEditNetName' . $num}, $gui{'comboboxEditNetName' . $num});
        &hide_on($gui{'labelEditNetNameInt' . $num}, $gui{'entryEditNetNameInt' . $num});
    }
    elsif ($AttachType eq 'HostOnly') {
        # Set current hostonly network name for NICs 1-4, depending on attachment type
        my @IHostNetworkInterface = IHost_getNetworkInterfaces($IHost);
        foreach my $interface (@IHostNetworkInterface) {
            if (IHostNetworkInterface_getInterfaceType($interface) eq 'HostOnly') {
                my $name = IHostNetworkInterface_getName($interface);
                my $iter = $gui{'liststoreEditNetName' . $num}->append();
                $gui{'liststoreEditNetName' . $num}->set($iter, 0, $name);
            }
        }
        INetworkAdapter_attachToHostOnlyInterface($INetworkAdapter);
        &hide_off($gui{'labelEditNetName' . $num}, $gui{'comboboxEditNetName' . $num});
        &hide_on($gui{'labelEditNetNameInt' . $num}, $gui{'entryEditNetNameInt' . $num});
    }
    elsif ($AttachType eq 'Internal') {
        my $name = INetworkAdapter_getInternalNetwork($INetworkAdapter);
        $gui{'entryEditNetNameInt' . $num}->set_text($name);
        INetworkAdapter_attachToInternalNetwork($INetworkAdapter);
        &hide_on($gui{'labelEditNetName' . $num}, $gui{'comboboxEditNetName' . $num});
        &hide_off($gui{'labelEditNetNameInt' . $num}, $gui{'entryEditNetNameInt' . $num});
    }
    elsif ($AttachType eq 'NAT') {
        INetworkAdapter_attachToNAT($INetworkAdapter);
        &hide_on($gui{'labelEditNetName' . $num}, $gui{'comboboxEditNetName' . $num},
                 $gui{'labelEditNetNameInt' . $num}, $gui{'entryEditNetNameInt' . $num});
    }
    else {
        # Assume detach as we either don't support it yet, or it really is detach
        INetworkAdapter_detach($INetworkAdapter);
        &hide_on($gui{'labelEditNetName' . $num}, $gui{'comboboxEditNetName' . $num},
                 $gui{'labelEditNetNameInt' . $num}, $gui{'entryEditNetNameInt' . $num});
    }

    $gui{'comboboxEditNetName' . $num}->signal_handler_unblock($signal{'netname' . $num});
    $gui{'comboboxEditNetName' . $num}->set_active(0); # This will call net_name()
}

sub net_name() {
    my ($widget, $checkbutton) = @_;
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    my $AttachType = &getsel_combo($gui{'comboboxEditNetAttach' . $num}, 1);
    if ($AttachType eq 'Bridged' | $AttachType eq 'HostOnly') {
        INetworkAdapter_setHostInterface($INetworkAdapter, $gui{'comboboxEditNetName' . $num}->get_active_text());
    }
}

sub net_name_internal() {
    my ($widget, $focus, $checkbutton) = @_;
    $checkbutton = $focus if (!$checkbutton);
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    my $name = $gui{'entryEditNetNameInt' . $num}->get_text();
    INetworkAdapter_setInternalNetwork($INetworkAdapter, $name) if ($name);
}

sub callout_getnetadapter() {
    my ($checkbutton) = @_;
    my $slot = 0;
    if ($checkbutton eq $gui{checkbuttonEditNetEnable1}) { $slot = 0; }
    elsif ($checkbutton eq $gui{checkbuttonEditNetEnable2}) { $slot = 1; }
    elsif ($checkbutton eq $gui{checkbuttonEditNetEnable3}) { $slot = 2; }
    elsif ($checkbutton eq $gui{checkbuttonEditNetEnable4}) { $slot = 3; }
    my $INetworkAdapter = IMachine_getNetworkAdapter($vmc{IMachine}, $slot);
    return $INetworkAdapter, $slot+1;
}

1;