# RemoteBox and VirtualBox preferences
use strict;
use warnings;
our (%gui, %bool);
our %prefs = (RDPCLIENT    => 'rdesktop -T "%n - RemoteBox" %h:%p',
              HEARTBEAT    => 1,
              RDPAUTOOPEN  => 1,
              MSGLOGEXPAND => 1,
              STOPTYPE     => 'INSTANT');

sub rbprefs_get() {
    $gui{PREFSDIR} = Glib::get_user_config_dir();
    $gui{CONFIGFILE} = "$gui{PREFSDIR}/remotebox.conf";
    $gui{THUMBDIR} = "$gui{PREFSDIR}/remoteboxthumbs";

    if (open(PREFS, '<', $gui{CONFIGFILE})) {
        my @contents = <PREFS>;
        chomp(@contents);
        close(PREFS);
        foreach (@contents) {
            if ($_ =~ m/^URL=(.*)$/) { $prefs{URL}{$1} = 'URL'; }
            elsif ($_ =~ m/^USER=(.*)$/) { $prefs{USER}{$1} = 'USER'; }
            elsif ($_ =~ m/^(.*?)=(.*)$/) { $prefs{$1} = $2; }
        }
    }
    else { $prefs{URL}{qq[http://localhost:18083]} = 'URL'; } #Add a default URL
}

sub rbprefs_save() {
	mkdir($gui{PREFSDIR}, 0755) unless (-e $gui{PREFSDIR});

    if (open(PREFS, '>', $gui{CONFIGFILE})) {
        foreach my $key (keys %prefs) {
            if ($key eq 'URL') {
                foreach (keys %{$prefs{URL}}) { print PREFS "URL=$_\n"; }
            }
            elsif ($key eq 'USER') {
                foreach (keys %{$prefs{USER}}) { print PREFS "USER=$_\n"; }
            }
            else { print PREFS "$key=$prefs{$key}\n"; }
        }
        close(PREFS);
    }
    else { warn "Unable to save preferences: $gui{CONFIGFILE}\n"; }
}

sub show_prefs_dialog() {
    $gui{entryPrefsRDPClient}->set_text($prefs{RDPCLIENT});
    $gui{checkbuttonPrefsRDPAuto}->set_active($prefs{RDPAUTOOPEN});
    $gui{checkbuttonPrefsHeartbeat}->set_active($prefs{HEARTBEAT});

    if ($prefs{STOPTYPE} eq 'ACPI') { $gui{comboboxPrefsDefaultStop}->set_active(1); }
    elsif ($prefs{STOPTYPE} eq 'STATE')  { $gui{comboboxPrefsDefaultStop}->set_active(2); }
    else { $gui{comboboxPrefsDefaultStop}->set_active(0); }

    my $response = $gui{dialogPrefs}->run;
    $gui{dialogPrefs}->hide;

    if ($response eq 'ok') {
        $prefs{RDPCLIENT} = $gui{entryPrefsRDPClient}->get_text();
        $prefs{RDPAUTOOPEN} = int($gui{checkbuttonPrefsRDPAuto}->get_active());
        $prefs{HEARTBEAT} = int($gui{checkbuttonPrefsHeartbeat}->get_active());
        $prefs{STOPTYPE} = &getsel_combo($gui{comboboxPrefsDefaultStop}, 1);
        &rbprefs_save();
    }
}

sub show_vbprefs_dialog() {
    my $ISystemProperties = IVirtualBox_getSystemProperties($gui{websn});
    my %oprefs = (macfolder => ISystemProperties_getDefaultMachineFolder($ISystemProperties),
                  vrdpauth  => ISystemProperties_getVRDEAuthLibrary($ISystemProperties));
    $gui{entryVBPrefsGenDefMachineFolder}->set_text($oprefs{macfolder});
    $gui{entryVBPrefsGenVRDPAuth}->set_text($oprefs{vrdpauth});
    &fill_list_vbprefsnet();
    $gui{dialogVBPrefs}->run();
    $gui{dialogVBPrefs}->hide();
    my %nprefs = (macfolder => $gui{entryVBPrefsGenDefMachineFolder}->get_text(),
                  vrdpauth  => $gui{entryVBPrefsGenVRDPAuth}->get_text());
    # For the library, strip any .dll or .so extention
    $nprefs{vrdpauth} =~ s/\.dll$//i;
    $nprefs{vrdpauth} =~ s/\.so$//i;
    ISystemProperties_setDefaultMachineFolder($ISystemProperties, $nprefs{macfolder}) if ($oprefs{macfolder} ne $nprefs{macfolder});
    ISystemProperties_setVRDEAuthLibrary($ISystemProperties, $nprefs{vrdpauth}) if ($oprefs{vrdpauth} ne $nprefs{vrdpauth});
    &populate_hostspec(); # VB Prefs changes can potentially alter hostspec values, so repopulate them
}

sub show_hon_dialog() {
    my $ifref = &getsel_list_vbprefsnet();
    $gui{entryHONAddress}->set_text(IHostNetworkInterface_getIPAddress($$ifref{IHostNetworkInterface}));
    $gui{entryHONNetmask}->set_text(IHostNetworkInterface_getNetworkMask($$ifref{IHostNetworkInterface}));
    $gui{entryHON6Address}->set_text(IHostNetworkInterface_getIPV6Address($$ifref{IHostNetworkInterface}));
    $gui{entryHON6Netmask}->set_text(IHostNetworkInterface_getIPV6NetworkMaskPrefixLength($$ifref{IHostNetworkInterface}));
    # We have to actually prefix the net name with HostInterfaceNetworking- (not mentioned in SDK)
    my $IDHCPServer = IVirtualBox_findDHCPServerByNetworkName($gui{websn}, 'HostInterfaceNetworking-' . $$ifref{Name});
    $gui{checkbuttonHONDHCP}->set_active($bool{IDHCPServer_getEnabled($IDHCPServer)});
    $gui{tableHONDHCP}->set_sensitive($gui{checkbuttonHONDHCP}->get_active()); # Ghost/Unghost other widgets based on dhcp enabled
    $gui{entryHONServerAddress}->set_text(IDHCPServer_getIPAddress($IDHCPServer));
    $gui{entryHONServerMask}->set_text(IDHCPServer_getNetworkMask($IDHCPServer));
    $gui{entryHONLBound}->set_text(IDHCPServer_getLowerIP($IDHCPServer));
    $gui{entryHONUBound}->set_text(IDHCPServer_getUpperIP($IDHCPServer));
    my $response = $gui{dialogHON}->run();
    $gui{dialogHON}->hide();

    if ($response eq 'ok') {
        #Ideally we need some validation here for the IP addresses
        IDHCPServer_setEnabled($IDHCPServer, $gui{checkbuttonHONDHCP}->get_active());
        IDHCPServer_setConfiguration($IDHCPServer,
                                     $gui{entryHONServerAddress}->get_text(),
                                     $gui{entryHONServerMask}->get_text(),
                                     $gui{entryHONLBound}->get_text(),
                                     $gui{entryHONUBound}->get_text());
        IHostNetworkInterface_enableStaticIpConfig($$ifref{IHostNetworkInterface},
                                                   $gui{entryHONAddress}->get_text(),
                                                   $gui{entryHONNetmask}->get_text());
        IHostNetworkInterface_enableStaticIpConfigV6($$ifref{IHostNetworkInterface},
                                                     $gui{entryHON6Address}->get_text(),
                                                     $gui{entryHON6Netmask}->get_text());
        &fill_list_vbprefsnet();
    }
}

sub vbprefs_reset() {
    my ($widget) = @_;
    my $ISystemProperties = IVirtualBox_getSystemProperties($gui{websn});

    if ($widget eq $gui{buttonVBPrefsGenDefMachineFolderReset}) {
        ISystemProperties_setDefaultMachineFolder($ISystemProperties, '');
        $gui{entryVBPrefsGenDefMachineFolder}->set_text(ISystemProperties_getDefaultMachineFolder($ISystemProperties));
    }
    elsif ($widget eq $gui{buttonVBPrefsGenDefVRDPAuthReset}) {
        ISystemProperties_setVRDEAuthLibrary($ISystemProperties, '');
        $gui{entryVBPrefsGenVRDPAuth}->set_text(ISystemProperties_getVRDEAuthLibrary($ISystemProperties));
    }
}

sub vbprefs_createhon() {
    my $IHost = IVirtualBox_getHost($gui{websn});
    my $IProgress = IHost_createHostOnlyNetworkInterface($IHost);
    &fill_list_vbprefsnet();
}

sub vbprefs_removehon() {
    my $ifref = &getsel_list_vbprefsnet();
    my $IHost = IVirtualBox_getHost($gui{websn});
    IHost_removeHostOnlyNetworkInterface($IHost, $$ifref{Uuid});
    &fill_list_vbprefsnet();
}

sub rbprefs_msglog() {
    my ($widget) = @_;
    $prefs{MSGLOGEXPAND} = int($widget->get_expanded()); # int forces 0 on undefined
    &rbprefs_save();
}

sub rbprefs_saveurluser() {
    $prefs{SAVEURLUSER} = $gui{checkbuttonConnectSave}->get_active();
    &rbprefs_save();
}


sub vbprefs_hon_dhcp_toggle() {
    $gui{tableHONDHCP}->set_sensitive($gui{checkbuttonHONDHCP}->get_active()); # Ghost/Unghost other widgets based on dhcp enabled
}

sub sens_vbprefs_net() {
    $gui{buttonVBPrefsDelNet}->set_sensitive(1);
    $gui{buttonVBPrefsEditNet}->set_sensitive(1);
}

1;