# Edit Serial and Parallel Port Settings of a Guest
use strict;
use warnings;
our (%gui, %bool, %vmc);

sub setup_edit_dialog_ioports() {
    &addrow_log("Retrieving I/O port settings for $vmc{Name}...");
    &busy_pointer($gui{dialogEdit}, 1);
    $gui{checkbuttonEditParallelEnable}->set_active($bool{IParallelPort_getEnabled($vmc{IParallelPort})});
    $gui{tableEditParallel}->set_sensitive($gui{checkbuttonEditParallelEnable}->get_active()); # Ghost/Unghost other widgets based on parallel enabled
    $gui{entryEditParallelPath}->set_text(IParallelPort_getPath($vmc{IParallelPort}));
    my $pirq = IParallelPort_getIRQ($vmc{IParallelPort});
    my $pioport = sprintf('%X', IParallelPort_getIOBase($vmc{IParallelPort}));
    $gui{entryEditParallelIRQ}->set_text($pirq);
    $gui{entryEditParallelIO}->set_text($pioport);
    $gui{entryEditParallelIRQ}->set_sensitive(0);
    $gui{entryEditParallelIO}->set_sensitive(0);

    if ($pirq == 2 and uc($pioport) eq '3BC') { $gui{comboboxEditParallelPortNum}->set_active(0); }
    elsif ($pirq == 7 and uc($pioport) eq '378') { $gui{comboboxEditParallelPortNum}->set_active(1); }
    elsif ($pirq == 5 and uc($pioport) eq '278') { $gui{comboboxEditParallelPortNum}->set_active(2); }
    else {
        $gui{comboboxEditParallelPortNum}->set_active(3);
        $gui{entryEditParallelIRQ}->set_sensitive(1);
        $gui{entryEditParallelIO}->set_sensitive(1);
    }

    foreach my $slot (1..2) {
        my $ISerialPort = IMachine_getSerialPort($vmc{IMachine}, ($slot - 1));
        my $irq = ISerialPort_getIRQ($ISerialPort);
        my $ioport = sprintf('%X', ISerialPort_getIOBase($ISerialPort));
        my $mode = ISerialPort_getHostMode($ISerialPort);
        $gui{'checkbuttonEditSerialEnable' . $slot}->set_active($bool{ISerialPort_getEnabled($ISerialPort)});
        $gui{'tableEditSerial' . $slot}->set_sensitive($gui{'checkbuttonEditSerialEnable' . $slot}->get_active()); # Ghost/Unghost other widgets based on serial enabled
        $gui{'checkbuttonEditSerialPipe' . $slot}->set_active($bool{ISerialPort_getServer($ISerialPort)});
        $gui{'entryEditSerialPath' . $slot}->set_text(ISerialPort_getPath($ISerialPort));
        $gui{'entryEditSerialIRQ' . $slot}->set_text($irq);
        $gui{'entryEditSerialIO' . $slot}->set_text($ioport);
        $gui{'entryEditSerialIRQ' . $slot}->set_sensitive(0);
        $gui{'entryEditSerialIO' . $slot}->set_sensitive(0);

        if ($irq == 4 and uc($ioport) eq '3F8') { $gui{'comboboxEditSerialPortNum' . $slot}->set_active(0); }
        elsif ($irq == 3 and uc($ioport) eq '2F8') { $gui{'comboboxEditSerialPortNum' . $slot}->set_active(1); }
        elsif ($irq == 4 and uc($ioport) eq '3E8') { $gui{'comboboxEditSerialPortNum' . $slot}->set_active(2); }
        elsif ($irq == 3 and uc($ioport) eq '2E8') { $gui{'comboboxEditSerialPortNum' . $slot}->set_active(3); }
        else {
            $gui{'comboboxEditSerialPortNum' . $slot}->set_active(4);
            $gui{'entryEditSerialIRQ' . $slot}->set_sensitive(1);
            $gui{'entryEditSerialIO' . $slot}->set_sensitive(1);
        }

        if ($mode eq 'HostPipe') { $gui{'comboboxEditSerialMode' . $slot}->set_active(1); }
        elsif ($mode eq 'HostDevice') { $gui{'comboboxEditSerialMode' . $slot}->set_active(2); }
        elsif ($mode eq 'RawFile') { $gui{'comboboxEditSerialMode' . $slot}->set_active(3); }
        else { $gui{'comboboxEditSerialMode' . $slot}->set_active(0); }
        $gui{'checkbuttonEditSerialPipe' . $slot}->set_active($bool{ISerialPort_getServer($ISerialPort)});
    }

    &busy_pointer($gui{dialogEdit}, 0);
    &addrow_log("I/O Port settings for $vmc{Name} retrieved.");
}

sub serial_toggle() {
    my ($widget, $checkbutton) = @_;

    if ($vmc{SessionType} eq 'WriteLock') {
        my $state = $widget->get_active();
        my ($ISerialPort, $num) = &serial_callout($checkbutton);
        ISerialPort_setEnabled($ISerialPort, $state);
        $gui{'tableEditSerial' . $num}->set_sensitive($state);
    }
}

sub parallel_toggle() {
    my ($widget) = @_;

    if ($vmc{SessionType} eq 'WriteLock') {
        my $state = $widget->get_active();
        # Set path when first enabled, avoids VB chucking a no path specified warning
        if ($state and !$gui{entryEditParallelPath}->get_text()) {
            $gui{entryEditParallelPath}->set_text('/dev/parport0');
            &parallel_portpath($gui{entryEditParallelPath});
        }

        IParallelPort_setEnabled($vmc{IParallelPort}, $state);
        $gui{tableEditParallel}->set_sensitive($state);
    }
}

sub serial_irq() {
    my ($widget, $focus, $checkbutton) = @_;

    if ($vmc{SessionType} eq 'WriteLock') {
        $checkbutton = $focus if (!$checkbutton);
        my $irq = int($widget->get_text());
        $irq = 255 if ($irq > 255);
        $irq = 15 if ($irq > 15 and !$gui{checkbuttonEditSysAPIC}->get_active());
        my ($ISerialPort, $num) = &serial_callout($checkbutton);
        ISerialPort_setIRQ($ISerialPort, $irq);
    }
}

sub parallel_irq() {
    if ($vmc{SessionType} eq 'WriteLock') {
        my $irq = int($gui{entryEditParallelIRQ}->get_text());
        $irq = 255 if ($irq > 255);
        $irq = 15 if ($irq > 15 and !$gui{checkbuttonEditSysAPIC}->get_active());
        IParallelPort_setIRQ($vmc{IParallelPort}, $irq);
    }
}

sub serial_ioport() {
    my ($widget, $focus, $checkbutton) = @_;

    if ($vmc{SessionType} eq 'WriteLock') {
        $checkbutton = $focus if (!$checkbutton);
        my $ioport = $widget->get_text();
        $ioport = 'FFFF' if (hex($ioport) > 65535);

        if ($ioport) {
            my ($ISerialPort, $num) = &serial_callout($checkbutton);
            ISerialPort_setIOBase($ISerialPort, hex($ioport));
        }
    }
}

sub parallel_ioport() {
    if ($vmc{SessionType} eq 'WriteLock') {
        my $ioport = $gui{entryEditParallelIO}->get_text();
        $ioport = 'FFFF' if (hex($ioport) > 65535);
        if ($ioport) { IParallelPort_setIOBase($vmc{IParallelPort}, hex($ioport)); }
    }
}

sub serial_portmode() {
    my ($widget, $checkbutton) = @_;

    if ($vmc{SessionType} eq 'WriteLock') {
        my ($ISerialPort, $num) = &serial_callout($checkbutton);
        ISerialPort_setHostMode($ISerialPort, &getsel_combo($widget, 0));
    }
}

sub serial_createpipe() {
    my ($widget, $checkbutton) = @_;
    my ($ISerialPort, $num) = &serial_callout($checkbutton);
    ISerialPort_setServer($ISerialPort, $widget->get_active());
}

sub serial_portpath() {
    my ($widget, $focus, $checkbutton) = @_;

    if ($vmc{SessionType} eq 'WriteLock') {
        $checkbutton = $focus if (!$checkbutton);
        my $path = $widget->get_text();
        if ($path) {
            my ($ISerialPort, $num) = &serial_callout($checkbutton);
            ISerialPort_setPath($ISerialPort, $path);
        }
    }
}

sub parallel_portpath() {
    if ($vmc{SessionType} eq 'WriteLock') {
        my $path = $gui{entryEditParallelPath}->get_text();
        if ($path) { IParallelPort_setPath($vmc{IParallelPort}, $path); }
    }
}

sub serial_portnum() {
    my ($widget, $checkbutton) = @_;

    if ($vmc{SessionType} eq 'WriteLock') {
        my $portnum = &getsel_combo($widget, 0);
        my ($ISerialPort, $num) = &serial_callout($checkbutton);

        if ($portnum eq 'COM1') {
            $gui{'entryEditSerialIRQ' . $num}->set_text('4');
            $gui{'entryEditSerialIO' . $num}->set_text('3F8');
        }
        elsif ($portnum eq 'COM2') {
            $gui{'entryEditSerialIRQ' . $num}->set_text('3');
            $gui{'entryEditSerialIO' . $num}->set_text('2F8');
        }
        elsif ($portnum eq 'COM3') {
            $gui{'entryEditSerialIRQ' . $num}->set_text('4');
            $gui{'entryEditSerialIO' . $num}->set_text('3E8');
        }
        elsif ($portnum eq 'COM4') {
            $gui{'entryEditSerialIRQ' . $num}->set_text('3');
            $gui{'entryEditSerialIO' . $num}->set_text('2E8');
        }

        if ($portnum ne 'Custom') {
            &serial_irq($gui{'entryEditSerialIRQ' . $num}, 0, $checkbutton);
            &serial_ioport($gui{'entryEditSerialIO' . $num}, 0, $checkbutton);
            $gui{'entryEditSerialIRQ' . $num}->set_sensitive(0);
            $gui{'entryEditSerialIO' . $num}->set_sensitive(0);
        }
        else {
            $gui{'entryEditSerialIRQ' . $num}->set_sensitive(1);
            $gui{'entryEditSerialIO' . $num}->set_sensitive(1);
        }
    }
}

sub parallel_portnum() {
    my ($widget) = @_;

    if ($vmc{SessionType} eq 'WriteLock') {
        my $portnum = &getsel_combo($widget, 0);

        if ($portnum eq 'LPT1') {
            $gui{entryEditParallelIRQ}->set_text('2');
            $gui{entryEditParallelIO}->set_text('3BC');
        }
        elsif ($portnum eq 'LPT2') {
            $gui{entryEditParallelIRQ}->set_text('7');
            $gui{entryEditParallelIO}->set_text('378');
        }
        elsif ($portnum eq 'LPT3') {
            $gui{entryEditParallelIRQ}->set_text('5');
            $gui{entryEditParallelIO}->set_text('278');
        }

        if ($portnum ne 'Custom') {
            &parallel_irq($gui{entryEditParallelIRQ}, 0);
            &parallel_ioport($gui{entryEditParallelIO}, 0);
            $gui{entryEditParallelIRQ}->set_sensitive(0);
            $gui{entryEditParallelIO}->set_sensitive(0);
        }
        else {
            $gui{entryEditParallelIRQ}->set_sensitive(1);
            $gui{entryEditParallelIO}->set_sensitive(1);
        }
    }

}

sub serial_callout() {
    my ($checkbutton) = @_;

    if ($vmc{SessionType} eq 'WriteLock') {
        my $slot = 0;
        if ($checkbutton eq $gui{checkbuttonEditSerialEnable1}) { $slot = 0; }
        elsif ($checkbutton eq $gui{checkbuttonEditSerialEnable2}) { $slot = 1; }
        my $ISerialPort = IMachine_getSerialPort($vmc{IMachine}, $slot);
        return $ISerialPort, $slot+1;
    }
}

1;