#include <X11/Intrinsic.h>
#include <X11/Vendor.h>
#include <X11/xpm.h>
#include <X11/Xaw3d/Xpm.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/param.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <unistd.h>

Pixmap *InsertPixmap(w, filename, dir)
Widget w;
char *filename;
char *dir;
{
PixmapNode *pixnode;
PixmapNode *pixnew;
char error_buf[BUFSIZ];
XWindowAttributes root_att;
XpmAttributes orig_att; 
char directory[MAXPATHLEN];

	if(PixList.n_entries == 0) /* First in the list */
	{
		pixnode = (void *)malloc(sizeof(PixmapNode));
		
/* The following 4 lines make the pixmap just use the closest allocated
	    colours if it cant get exactly what it wants */
	    
		XGetWindowAttributes(XtDisplay(w) ,DefaultRootWindow(XtDisplay(w)),&root_att);
   		orig_att.closeness=65536;
   		orig_att.colormap=root_att.colormap;
   		orig_att.valuemask=XpmSize|XpmReturnPixels|XpmColormap|XpmCloseness;
	     if(XpmReadFileToPixmap(XtDisplay(w), XtWindow(w),
	      filename, &pixnode->pixmap, NULL, &orig_att))
		{
   			getwd(directory);
   			chdir(dir);
	  		if(XpmReadFileToPixmap(XtDisplay(w), XtWindow(w),
   			  filename, &pixnode->pixmap, NULL, &orig_att))
			{
	                       sprintf(error_buf, "%s: Couldn't load pixmap %s!", XtName(w),
 	                               filename);
 	                       XtWarning(error_buf);
			}
			chdir(directory);
		}
		(PixmapNode *)PixList.first = (PixmapNode *)pixnode;
		pixnode->next = NULL;
		PixList.n_entries = 1;
		pixnode->filename = filename;
   		return((Pixmap *)&pixnode->pixmap);
	}

/* Is the pixmap already in the list? */

	(PixmapNode *)pixnode = (PixmapNode *)PixList.first;
	for(;;)
	{
		if(strncmp(filename,pixnode->filename, MAXPATHLEN) == 0)
			return((Pixmap *)&pixnode->pixmap);
		if(pixnode->next == NULL) break;
		(PixmapNode *)pixnode = (PixmapNode *)pixnode->next;
	}

/* Didnt find the pixmap...make a new one */
	
	(PixmapNode *)pixnew = (void *)malloc(sizeof(PixmapNode));
	
	XGetWindowAttributes(XtDisplay(w) ,DefaultRootWindow(XtDisplay(w)),&root_att);
   	orig_att.closeness=65536;
   	orig_att.colormap=root_att.colormap;
   	orig_att.valuemask=XpmSize|XpmReturnPixels|XpmColormap|XpmCloseness;
	if(XpmReadFileToPixmap(XtDisplay(w), XtWindow(w),
   		filename, &pixnew->pixmap, NULL, &orig_att))
   	{
   		getwd(directory);
   		chdir(dir);
	  	if(XpmReadFileToPixmap(XtDisplay(w), XtWindow(w),
   		filename, &pixnew->pixmap, NULL, &orig_att))
 		{
   		  	sprintf(error_buf, "%s: Couldn't load pixmap %s!", XtName(w),
   				filename);
   		  	XtWarning(error_buf);
   		 }
   		 chdir(directory);
   	}
	(PixmapNode *)pixnode->next = (PixmapNode *)pixnew;
	pixnew->filename = filename;
	pixnew->next = NULL;
   	return((Pixmap *)&pixnew->pixmap);
}

Pixmap *GetMask(w, filename, dir)
Widget w;
char *filename;
char *dir;
{
PixmapNode *pixnode;
PixmapNode *pixnew;
int found=0;
XWindowAttributes root_att;
XpmAttributes orig_att;
char error_buf[BUFSIZ];
char directory[MAXPATHLEN];

           (PixmapNode *)pixnode = (PixmapNode *)PixList.first;
	for(;;)
	{
		if(strncmp(filename,pixnode->filename, MAXPATHLEN) == 0)
		{
			found = 1;
			break;
		}
		if(pixnode->next == NULL) break;
		(PixmapNode *)pixnode = (PixmapNode *)pixnode->next;
	}
	if(found)
	{
		XGetWindowAttributes(XtDisplay(w) ,DefaultRootWindow(XtDisplay(w)),&root_att);
  	 	orig_att.closeness=65536;
  	 	orig_att.colormap=root_att.colormap;
  	 	orig_att.valuemask=XpmSize|XpmReturnPixels|XpmColormap|XpmCloseness;
		if(XpmReadFileToPixmap(XtDisplay(w), XtWindow(w),
   		     filename, &pixnode->pixmap, &pixnode->mask, &orig_att))
   		{
   			getwd(directory);
   			chdir(dir);
   			if(XpmReadFileToPixmap(XtDisplay(w), XtWindow(w),
   			filename, &pixnode->pixmap, &pixnode->mask, &orig_att))
   			{
   				sprintf(error_buf, "%s: Couldn't load pixmap %s!", XtName(w),
   					filename);
   				XtWarning(error_buf);
   			}
   			chdir(directory);
   		}
   		return((Pixmap *)&pixnode->mask);
   	}
	else
	{
		(PixmapNode *)pixnew = (void *)malloc(sizeof(PixmapNode));
		 XGetWindowAttributes(XtDisplay(w) ,DefaultRootWindow(XtDisplay(w)),&root_att);
  	 	orig_att.closeness=65536;
  	 	orig_att.colormap=root_att.colormap;
  	 	orig_att.valuemask=XpmSize|XpmReturnPixels|XpmColormap|XpmCloseness;
		if(XpmReadFileToPixmap(XtDisplay(w), XtWindow(w),
   			filename, &pixnew->pixmap, &pixnew->mask, &orig_att))
  	 	{
   			getwd(directory);
   			chdir(dir);
   	 	 	if(XpmReadFileToPixmap(XtDisplay(w), XtWindow(w),
   			filename, &pixnew->pixmap, &pixnew->mask, &orig_att))
   			{
   				sprintf(error_buf, "%s: Couldn't load pixmap %s!", XtName(w),
   				filename);
   				XtWarning(error_buf);
   			}
   			chdir(directory);
 	  	}
		(PixmapNode *)pixnode->next = (PixmapNode *)pixnew;
		pixnew->filename = filename;
		pixnew->next = NULL;
  	 	return((Pixmap *)&pixnew->mask);
   	}
}

#ifdef SUN_AUDIO
/*
	Restores the original SIGCHLD mask when our sound has finished
	playing. If the child that caused this signal isnt the one
	playing the sound (eg a child of the app exited while the sound
	was playing), the original handler is restored, a SIGCHLD is
	send to our pid to call that handler, then our handler is put 
	back in place to wait for our child.
*/
void SigHandle(int sig)
{
	sigaction(SIGCHLD, &old, NULL);	
	if(waitpid(soundpid, NULL, WNOHANG) != soundpid)
	{
		kill(getpid(), SIGCHLD);
		sigaction(SIGCHLD, &new, &old);
	} else playing = 0;
}

extern void PlaySound(soundfile)
char *soundfile;
{
  if(soundfile && playing == 0)
  {
   uid_t ruid;
/*
  Security is important here...dont want people doing strange things
  with setuid progs (eg xterm) and sound files, etc.
 */  
  	ruid = geteuid();
  	if(seteuid(getuid()) != -1)
  	{
/* The following few lines save the current SIGCHLD handler, which
	would otherwise break anything that sets one, like xterm. The
	original handler is restored in SigHandle (above). The 'playing'
	variable is used to ensure the original handler isn't
	overwritten if this function is called again before the next 
	sigchld.
*/
  		new.sa_handler=SigHandle;
		new.sa_mask=0;
		new.sa_flags=SA_NOMASK | SA_ONESHOT;
		new.sa_restorer=NULL;
		sigaction(SIGCHLD, &new, &old);
		playing = 1;
		soundpid = fork();
          if(soundpid == 0)
          {
/* Write directly to the audio device using fast system calls */
          	int sound_dev, sound, count;
          	char buf[4096];
			sound_dev = open(AUDIO_DEVICE, O_WRONLY);
			sound = open(soundfile, O_RDONLY);
			if(sound_dev == -1 || sound == -1) exit(0);
			while((count = read(sound, buf,  4096)) > 0)
				write(sound_dev, buf, count);
 			exit(0);
		} 
		else if (soundpid == -1)
		{
			playing = 0;
			sigaction(SIGCHLD, &new, &old);
		}

	}
	seteuid(ruid);
   }
}

#endif
