Name: black-hole-solver
Version: 1.10.1
Release: 1
License: MIT
Group: Amusement/Games
Source: https://fc-solve.shlomifish.org/downloads/fc-solve/black-hole-solver-%{version}.tar.xz
URL: https://www.shlomifish.org/open-source/projects/black-hole-solitaire-solver/
Requires: libblack_hole_solver1 = %{version}
Summary: The Black Hole Solver Executable
BuildRequires: cmake
BuildRequires: perl(Carp)
BuildRequires: perl(Cwd)
BuildRequires: perl(Data::Dumper)
BuildRequires: perl(Env::Path)
BuildRequires: perl(File::Path)
BuildRequires: perl(File::Spec)
BuildRequires: perl(Inline)
BuildRequires: perl(Inline::C)
BuildRequires: perl(List::MoreUtils)
BuildRequires: perl(Path::Tiny)
BuildRequires: perl(Test::Differences)
BuildRequires: perl(Test::More)
BuildRequires: perl(Test::RunValgrind)
BuildRequires: perl(Test::Some)
BuildRequires: perl(base)
BuildRequires: perl(lib)
BuildRequires: perl(strict)
BuildRequires: perl(warnings)
BuildRequires: perl-devel
BuildRequires: python3
BuildRequires: valgrind

%description
This is a solver, written in C, to solve the Solitaire variant called “Black
Hole” and the one called “All in a Row”. It provides a portable C library, and
a command line application that after being fed with a layout will emit the
cards to move.

%package -n libblack_hole_solver1
Summary: The Black Hole Solitaire Solver dynamic libraries
Group: Amusement/Games

%description -n libblack_hole_solver1
Contains the Blach Hole Solitaire libraries.

This package is mandatory for the Black Hole Solitaire executable too.

%package -n libblack_hole_solver1-devel
Summary: The Freecell Solver development tools for solving Freecell games
Group: Amusement/Games
Requires: libblack_hole_solver1 = %{version}

%description -n libblack_hole_solver1-devel
Freecell Solver is a library for automatically solving boards of Freecell and
similar variants of card Solitaire. This package contains the header files and
static libraries necessary for developing programs using Freecell Solver.

You should install it if you are a game developer who would like to use
Freecell Solver from within your programs.

%prep
%setup

%build
%cmake -DLOCALE_INSTALL_DIR=%{_datadir}/locale -DLIB_INSTALL_DIR=%{_libdir}
%cmake_build

%check
unset FCS_TEST_BUILD
rm -f t/clang-format.t
%ctest

%install
rm -rf %buildroot
%cmake_install

%files -n libblack_hole_solver1
%{_libdir}/libblack_hole_solver.so*

%files
%defattr(-,root,root)
%{_bindir}/black-hole-solve
%{_mandir}/*/*
%doc README.md NEWS.asciidoc

%files -n libblack_hole_solver1-devel
%defattr(-,root,root)
/usr/include/black-hole-solver/*.h
%{_libdir}/pkgconfig/*.pc

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Tue Mar 31 2009 Shlomi Fish <shlomif@cpan.org> 2.21.2-1
- Adapted to the CMake build system.
- Changed the license from "Public Domain" to "MIT".

* Mon Oct 24 2005 Shlomi Fish <shlomif@cpan.org> 2.8.11-1
- Changed "Copyright" to "License"

* Fri Jul 30 2004 Shlomi Fish <shlomif@cpan.org> 2.8.7-1
- Added some unpackaged files
- deleted make-microsoft-freecell-board so it won't be reported as
  unpacked
- removed some old cd's that are now useless
- removed the serial tags - they are just trouble.

* Mon Sep 02 2002 Shlomi Fish <shlomif@cpan.org> 2.7.15-1
- Used strip on the range solver
- Added the presets' related files

* Sat Feb 16 2002 Shlomi Fish <shlomif@cpan.org> 2.1.10-1
- updated to version 2.1.10
- removed the man pages symlinks (they were superceded by the ".so" links).

* Fri Jan 04 2002 Shlomi Fish <shlomif@cpan.org> 2.0.1-1
- updated to version 2.0.1
- added freecell-solver-range-parallel-solve to the /usr/bin programs

* Tue Dec 18 2001 Shlomi Fish <shlomif@cpan.org> 2.0.0-1
- updated to version 2.0.0

* Fri Nov 23 2001 Shlomi Fish <shlomif@cpan.org> 1.10.3-1
- updated to version 1.10.3

* Thu Nov 22 2001 Shlomi Fish <shlomif@cpan.org> 1.10.2-1
- updated to version 1.10.2

* Tue Oct 02 2001 Shlomi Fish <shlomif@cpan.org> 1.10.0-1
- updated to version 1.10.0

* Sat Sep 22 2001 Shlomi Fish <shlomif@cpan.org> 1.8.2-1
- updated to version 1.8.2

* Sat Sep 01 2001 Shlomi Fish <shlomif@cpan.org> 1.8.0-1
- Changed the version to 1.8.0
- Removed the -autconf suffix from the archive.

* Sat Jul 07 2001 Shlomi Fish <shlomif@cpan.org> 1.6.7-2
- Fixed the man pages.
- Included a paragraph about the board_gen programs in the description of
  the executable package.

* Sat Jun 09 2001 Shlomi Fish <shlomif@cpan.org> 1.6.7-1
- Changed the version to 1.6.7.
- Added support for the man pages.
- Added the symlinked man pages.
- Added the board_gen sub-dir in the documentation directory. (using a rather
crude hack)
- Known Bugs:
    1 - The man pages need a little rework, there are some typos and they
        don't look very standard.


* Thu May 24 2001 Shlomi Fish <shlomif@cpan.org> 1.6.4-3
- Added the board generation programs into the RPM.
- Changed the package to my name and E-mail. Done through the home-dir conf
file, not by editting the SPEC, but what the heck.

* Sat May 19 2001 Shlomi Fish <shlomif@cpan.org> 1.6.4-2
- Changed the descriptions and summaries to something more meaningful
- Removed the dependency on "Serial" in "Requires".

* Fri May 18 2001 Shlomi Fish <shlomif@cpan.org> 1.6.4-1
- First working version with libs and executable support.
- Known Bugs:
      1 - No "devel" package.
      2 - No options passed to "configure".
- Added calls to strip.
- "configure" is now OK with all the options set.
- Added Headers and a working freecell-solver-devel
