/* Verb processors for DUNGEON */

/* COPYRIGHT 1980, 1990, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. */
/* ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED */
/* WRITTEN BY R. M. SUPNIK */
/* Translated from Fortran to C by Andrew Plotkin <erkyrath@netcom.com>
   on 10/4/98. */

/* 1-Oct-94      RMS     Fixed bugs in ANSWER, INCANT, UNTIE FROM, FILL, */
/*                       GIVE, SHAKE, PLAY, POUR, POUR ON, TAKE, SPIN, BURN, */
/*                       ALARM, collectives, subcripting. */
/*                       Added COUNT, Puzzle Room entrance test. */
/* 11-Feb-94     RMS     Fixed bug in chimney load calculation. */
/* 30-Jan-94     RMS     Fixed bugs from MS DOS port. */
/* 27-Jan-94     RMS     Fixed portability problem in answer array. */
/* 25-Jan-94     RMS     Fixed bug in DIG not with shovel. */
/* 09-Jul-92     RMS     Fixed subscript range error. */
/* 01-Jul-92     RMS     Removed extraneous function from TAKE. */
/* 30-Jun-92     RMS     Changed file names to lower case. */

#include "glk.h"
#include "miscfort.h"
#include "funcs.h"
#include "commons.h"

/* VAPPLI- Main verb processing routine */

/* Declarations */

logical vappli_(integer *ri)
{
    /* Initialized data */

    static integer jokes[25] = { 4,5,3,304,305,306,307,308,309,310,311,312,
        313,5314,5319,324,325,883,884,120,120,0,0,0,0 };
    static integer answer[16] = { 0,1,2,2,3,4,4,4,4,4,5,5,5,6,7,7 };
    static char ansstr[12*16] = "TEMPLE      " "FOREST      " "30003       " 
        "30,003      " "FLASK       " "RUB         " "FONDLE      " "CAR"
        "ESS      " "FEEL        " "TOUCH       " "BONES       " "BODY   "
        "     " "SKELETON    " "RUSTY KNIFE " "NONE        " "NOWHERE     "
        ;

    /* System generated locals */
    integer i__1, i__2, i__3;
    logical ret_val;

    /* Local variables */
    logical waslit;
    logical f;
    char pw[8*2], ch[8], ch2[8];
    integer av, i__, j;
    integer x;
    integer rmk;
    integer melee;
    integer k;
    integer l, wp, cp;
    integer odo2, odi2;

/* Functions and data */

/* VAPPLI, PAGE 2 */

    ret_val = TRUE_;
/* assume wins. */
    odo2 = 0;
    odi2 = 0;
    if (prsvec_1.prso != 0 && prsvec_1.prso <= 300) {
        odo2 = objcts_1.odesc2[prsvec_1.prso - 1];
    }
    if (prsvec_1.prsi != 0) {
        odi2 = objcts_1.odesc2[prsvec_1.prsi - 1];
    }
/* set up descriptors. */
    av = advs_1.avehic[play_1.winner - 1];
/* (PRSO can be direction */
    rmk = rnd_(&c__6) + 372;
/* remark for hack-hacks. */
    if (*ri == 0) {
        goto L10;
    }
/* zero is false. */
    if (*ri <= 39) {
        return ret_val;
    }
/* nop? */
    if (*ri <= 64) {
        goto L20;
    }
/* joke? */
    if (*ri <= 99) {
        goto L30;
    }
/* simple verb? */
    waslit = lit_(&play_1.here);
    switch (*ri - 99) {
        case 1:  goto L500;
        case 2:  goto L1000;
        case 3:  goto L2000;
        case 4:  goto L3000;
        case 5:  goto L4000;
        case 6:  goto L5000;
        case 7:  goto L6000;
        case 8:  goto L7000;
        case 9:  goto L8000;
        case 10:  goto L9000;
        case 11:  goto L10000;
        case 12:  goto L11000;
        case 13:  goto L12000;
        case 14:  goto L13000;
        case 15:  goto L14000;
        case 16:  goto L15000;
        case 17:  goto L16000;
        case 18:  goto L17000;
        case 19:  goto L18000;
        case 20:  goto L19000;
        case 21:  goto L20000;
        case 22:  goto L21000;
        case 23:  goto L22000;
        case 24:  goto L23000;
        case 25:  goto L24000;
        case 26:  goto L25000;
        case 27:  goto L26000;
        case 28:  goto L27000;
        case 29:  goto L28000;
        case 30:  goto L29000;
        case 31:  goto L30000;
        case 32:  goto L31000;
        case 33:  goto L32000;
        case 34:  goto L33000;
        case 35:  goto L34000;
        case 36:  goto L35000;
        case 37:  goto L36000;
        case 38:  goto L37000;
        case 39:  goto L38000;
        case 40:  goto L39000;
        case 41:  goto L40000;
        case 42:  goto L41000;
        case 43:  goto L42000;
        case 44:  goto L43000;
        case 45:  goto L44000;
        case 46:  goto L45000;
        case 47:  goto L46000;
        case 48:  goto L47000;
        case 49:  goto L48000;
        case 50:  goto L49000;
        case 51:  goto L50000;
        case 52:  goto L51000;
        case 53:  goto L52000;
        case 54:  goto L53000;
        case 55:  goto L54000;
        case 56:  goto L55000;
        case 57:  goto L56000;
        case 58:  goto L57000;
        case 59:  goto L58000;
        case 60:  goto L59000;
        case 61:  goto L60000;
        case 62:  goto L61000;
        case 63:  goto L62000;
        case 64:  goto L63000;
        case 65:  goto L64000;
        case 66:  goto L65000;
        case 67:  goto L66000;
        case 68:  goto L67000;
        case 69:  goto L68000;
        case 70:  goto L69000;
    }
    bug_(&c__7, ri);

/* All verb processors return here to declare failure. */

L10:
    ret_val = FALSE_;
/* lose. */
    return ret_val;

/* Joke processor. */
/* Find proper entry in jokes, use it to select string to print. */

L20:
    i__ = jokes[*ri - 40];
/* get table entry. */
    j = i__ / 1000;
/* isolate # strings. */
    if (j != 0) {
        i__ = i__ % 1000 + rnd_(&j);
    }
/* if random, choose. */
    rspeak_(&i__);
/* print joke. */
    return ret_val;

/* 'Simple' verbs. */

L30:
    switch (*ri - 64) {
        case 1:  goto L65001;
        case 2:  goto L66001;
        case 3:  goto L67001;
        case 4:  goto L68001;
        case 5:  goto L69001;
        case 6:  goto L70000;
        case 7:  goto L71000;
        case 8:  goto L72000;
        case 9:  goto L73000;
        case 10:  goto L74000;
        case 11:  goto L75000;
        case 12:  goto L76000;
        case 13:  goto L77000;
        case 14:  goto L78000;
        case 15:  goto L79000;
        case 16:  goto L80000;
        case 17:  goto L81000;
        case 18:  goto L82000;
        case 19:  goto L83000;
        case 20:  goto L84000;
        case 21:  goto L85000;
        case 22:  goto L86000;
        case 23:  goto L87000;
        case 24:  goto L88000;
        case 25:  goto L89000;
        case 26:  goto L90000;
        case 27:  goto L91000;
        case 28:  goto L92000;
        case 29:  goto L93000;
        case 30:  goto L94000;
        case 31:  goto L95000;
        case 32:  goto L96000;
        case 33:  goto L97000;
    }
    bug_(&c__7, ri);

/* Here to test for change in light. */

L50:
    if (waslit && ! lit_(&play_1.here)) {
        rspeak_(&c__406);
    }
    return ret_val;
/* VAPPLI, PAGE 3 */

/* V100--        Read */

L500:
    if (lit_(&play_1.here)) {
        goto L600;
    }
/* room lit? */
    rspeak_(&c__356);
/* no, cant read. */
    return ret_val;

L600:
    if (prsvec_1.prsi == 0) {
        goto L700;
    }
/* read through obj? */
    if ((objcts_1.oflag1[prsvec_1.prsi - 1] & 2048) != 0) {
        goto L700;
    }
    rspsub_(&c__357, &odi2);
/* not transparent. */
    return ret_val;

L700:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 16384) != 0) {
        goto L800;
    }
    rspsub_(&c__358, &odo2);
/* not readable. */
    return ret_val;

L800:
    rspeak_(&objcts_1.oread[prsvec_1.prso - 1]);
/* print reading material */
    return ret_val;

/* V101--        Melt */

L1000:
    if (! objact_(&x)) {
        rspsub_(&c__361, &odo2);
    }
    return ret_val;

/* V102--        Inflate */

L2000:
    if ((objcts_1.oflag1[prsvec_1.prsi - 1] & 4) != 0) {
        goto L2100;
    }
/* tool? */
    rspsub_(&c__301, &odi2);
/* no, joke. */
    return ret_val;

L2100:
    if (! objact_(&x)) {
        rspeak_(&c__368);
    }
/* obj handle? */
    return ret_val;

/* V103--        Deflate. */

L3000:
    if (! objact_(&x)) {
        rspeak_(&c__369);
    }
/* obj handle? */
    return ret_val;
/* VAPPLI, PAGE 4 */

/* V104--        Alarm */

L4000:
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 128) != 0) {
        goto L4100;
    }
/* villain? */
    i__1 = rnd_(&c__6) + 552;
    rspeak_(&i__1);
/* no, joke. */
    return ret_val;

L4100:
    if (! objact_(&x)) {
        rspsub_(&c__370, &odo2);
    }
    return ret_val;

/* V105--        Exorcise */

L5000:
    f = objact_(&x);
/* objects handle. */
    return ret_val;

/* V106--        Plug */

L6000:
    if (! objact_(&x)) {
        rspeak_(&c__371);
    }
    return ret_val;

/* V107--        Kick */

L7000:
    if (! objact_(&x)) {
        rspsb2_(&c__378, &odo2, &rmk);
    }
    return ret_val;

/* V108--        Wave */

L8000:
    if (! objact_(&x)) {
        rspsb2_(&c__379, &odo2, &rmk);
    }
    return ret_val;

/* V109,V110--   Raise, lower */

L9000:
L10000:
    if (! objact_(&x)) {
        rspsb2_(&c__380, &odo2, &rmk);
    }
    return ret_val;

/* V111--        Rub */

L11000:
    if (! objact_(&x)) {
        rspsb2_(&c__381, &odo2, &rmk);
    }
    return ret_val;

/* V112--        Push */

L12000:
    if (! objact_(&x)) {
        rspsb2_(&c__382, &odo2, &rmk);
    }
    return ret_val;
/* VAPPLI, PAGE 5 */

/* V113--        Untie */

L13000:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    i__ = 383;
/* no, not tied. */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 4096) == 0) {
        i__ = 384;
    }
/* not tieable. */
    rspeak_(&i__);
    return ret_val;

/* V114--        Tie */

L14000:
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 4096) != 0) {
        goto L14100;
    }
    rspeak_(&c__385);
/* not tieable. */
    return ret_val;

L14100:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    i__ = 386;
/* joke 1. */
    if (prsvec_1.prsi == 251) {
        i__ = 919;
    }
/* if player, joke 2. */
    rspsub_(&c__386, &odo2);
/* print remark. */
    return ret_val;

/* V115--        Tie up */

L15000:
    if ((objcts_1.oflag2[prsvec_1.prsi - 1] & 4096) != 0) {
        goto L15100;
    }
    rspsub_(&c__387, &odo2);
/* not tieable. */
    return ret_val;

L15100:
    i__ = 388;
/* assume villain. */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 128) == 0) {
        i__ = 389;
    }
    rspsub_(&i__, &odo2);
/* joke. */
    return ret_val;

/* V116--        Turn */

L16000:
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 2) != 0) {
        goto L16100;
    }
    rspeak_(&c__390);
/* not turnable. */
    return ret_val;

L16100:
    if ((objcts_1.oflag1[prsvec_1.prsi - 1] & 4) != 0) {
        goto L16200;
    }
    rspsub_(&c__391, &odi2);
/* not a tool. */
    return ret_val;

L16200:
    ret_val = objact_(&x);
/* let object handle. */
    return ret_val;

/* V117--        Breathe */

L17000:
    prsvec_1.prsa = 102;
    prsvec_1.prsi = 260;
    goto L2000;
/* VAPPLI, PAGE 5A. */

/* V118--        Knock */

/* handle like inflate. */
L18000:
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    i__ = 394;
/* joke for door. */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 4096) == 0) {
        i__ = 395;
    }
    rspsub_(&i__, &odo2);
/* joke for nondoors too. */
    return ret_val;

/* V119--        Look */

L19000:
    if (prsvec_1.prso != 0) {
        goto L20500;
    }
/* something to look at? */
    ret_val = rmdesc_(&c__3);
/* handled by rmdesc. */
    return ret_val;

/* V120--        Examine */

L20000:
    if (prsvec_1.prso != 0) {
        goto L20500;
    }
/* something to examine? */
    ret_val = rmdesc_(&c__0);
/* handled by rmdesc. */
    return ret_val;

L20500:
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    i__ = objcts_1.oread[prsvec_1.prso - 1];
/* get reading material. */
    if (i__ != 0) {
        rspeak_(&i__);
    }
/* output if there, */
    if (i__ == 0) {
        rspsub_(&c__429, &odo2);
    }
/* otherwise default. */
    prsvec_1.prsa = 8;
/* defuse room processors */
    return ret_val;

/* V121--        Shake */

L21000:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    if (prsvec_1.prso == 273) {
        goto L10;
    }
/* global water? fails. */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 128) == 0) {
        goto L21100;
    }
    rspeak_(&c__371);
/* joke for villains. */
    return ret_val;

L21100:
    if (prsvec_1.prso != av) {
        goto L21150;
    }
/* vehicle? */
    rspeak_(&c__672);
/* yes, joke. */
    return ret_val;

L21150:
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 8192) != 0) {
        goto L21200;
    }
/* takeable? */
    rspeak_(&c__923);
/* no, joke. */
    return ret_val;

L21200:
    if (objcts_1.oadv[prsvec_1.prso - 1] == play_1.winner) {
        goto L21250;
    }
/* carrying? */
    rspeak_(&c__527);
/* no, joke. */
    return ret_val;

L21250:
    if (qempty_(&prsvec_1.prso)) {
        goto L10;
    }
/* empty?  fails. */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 8) != 0) {
        goto L21300;
    }
/* open?  spill. */
    rspsub_(&c__396, &odo2);
/* no, describe noise. */
    return ret_val;

L21300:
    rspsub_(&c__397, &odo2);
/* spill the works. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* spill contents. */
        if (objcts_1.ocan[i__ - 1] != prsvec_1.prso) {
            goto L21500;
        }
/* inside? */
        objcts_1.oflag2[i__ - 1] = objcts_1.oflag2[i__ - 1] | 4;
/* touch object. */
        if (av == 0) {
            goto L21400;
        }
/* in vehicle? */
        newsta_(&i__, &c__0, &c__0, &av, &c__0);
/* yes, spill in there. */
        goto L21500;

L21400:
        newsta_(&i__, &c__0, &play_1.here, &c__0, &c__0);
/* no, spill on floor, */
        if (i__ == 11) {
            newsta_(&i__, &c__133, &c__0, &c__0, &c__0);
        }
/* but water disappears. */
L21500:
        ;
    }
    return ret_val;
/* VAPPLI, PAGE 6 */

/* V122--        Move */

L22000:
    if (! qhere_(&prsvec_1.prso, &play_1.here)) {
        goto L22100;
    }
/* is it here? */
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    i__ = 399;
/* assume not takeable. */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 8192) != 0) {
        i__ = 887;
    }
    rspsub_(&i__, &odo2);
/* joke. */
    return ret_val;

L22100:
    rspeak_(&c__398);
/* not here. */
    return ret_val;

/* V123--        Turn on */

L23000:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 64) != 0 && objcts_1.oadv[
            prsvec_1.prso - 1] == play_1.winner) {
        goto L23100;
    }
    rspeak_(&c__400);
/* cant do it. */
    return ret_val;

L23100:
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 1) == 0) {
        goto L23200;
    }
    rspeak_(&c__401);
/* already on. */
    return ret_val;

L23200:
    objcts_1.oflag1[prsvec_1.prso - 1] = objcts_1.oflag1[prsvec_1.prso - 1] | 
            1;
/* turn it on. */
    rspsub_(&c__404, &odo2);
    return ret_val;

/* V124--        Turn off */

L24000:
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 64) != 0 && objcts_1.oadv[
            prsvec_1.prso - 1] == play_1.winner) {
        goto L24100;
    }
    rspeak_(&c__402);
/* cant do it. */
    return ret_val;

L24100:
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 1) != 0) {
        goto L24200;
    }
    rspeak_(&c__403);
/* already off. */
    return ret_val;

L24200:
    objcts_1.oflag1[prsvec_1.prso - 1] = objcts_1.oflag1[prsvec_1.prso - 1] & 
            -2;
    rspsub_(&c__405, &odo2);
    goto L50;

/* V125--        Open */

/* go see if now dark. */
L25000:
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 4096) != 0) {
        goto L25150;
    }
/* door? */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 128) != 0) {
        goto L25100;
    }
/* container? */
L25050:
    rspsub_(&c__407, &odo2);
/* not door or container. */
    return ret_val;

L25100:
    if (objcts_1.ocapac[prsvec_1.prso - 1] != 0) {
        goto L25200;
    }
/* openable container? */
L25150:
    rspsub_(&c__408, &odo2);
/* door or not openable. */
    return ret_val;

L25200:
    if (! ((objcts_1.oflag2[prsvec_1.prso - 1] & 8) != 0)) {
        goto L25225;
    }
    rspeak_(&c__412);
/* already open. */
    return ret_val;

L25225:
    objcts_1.oflag2[prsvec_1.prso - 1] = objcts_1.oflag2[prsvec_1.prso - 1] | 
            8;
/* open it. */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 2048) != 0 || qempty_(&
            prsvec_1.prso)) {
        goto L25300;
    }
    princo_(&prsvec_1.prso, &c__410, &c_false);
/* print contents. */
    return ret_val;

L25300:
    rspeak_(&c__409);
/* done */
    return ret_val;

/* V126--        Close */

L26000:
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 4096) != 0) {
        goto L26050;
    }
/* door? */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 128) == 0) {
        goto L25050;
    }
/* container? */
    if (objcts_1.ocapac[prsvec_1.prso - 1] != 0) {
        goto L26100;
    }
/* closable container? */
L26050:
    rspsub_(&c__411, &odo2);
/* door or not closable. */
    return ret_val;

L26100:
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 8) != 0) {
        goto L26200;
    }
/* open? */
    rspeak_(&c__413);
/* no, joke. */
    return ret_val;

L26200:
    objcts_1.oflag2[prsvec_1.prso - 1] = objcts_1.oflag2[prsvec_1.prso - 1] & 
            -9;
    rspeak_(&c__414);
/* done. */
    goto L50;
/* VAPPLI, PAGE 7 */

/* V127--        Find */

/* go see if now dark. */
L27000:
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    i__ = 415;
/* room string. */
    if (qhere_(&prsvec_1.prso, &play_1.here)) {
        goto L27200;
    }
/* in room? */
    i__ = 416;
/* winner string. */
    if (objcts_1.oadv[prsvec_1.prso - 1] == play_1.winner) {
        goto L27200;
    }
/* on winner? */
    j = objcts_1.ocan[prsvec_1.prso - 1];
/* down one level. */
    if (j == 0) {
        goto L10;
    }
    if ((objcts_1.oflag1[j - 1] & 2048) == 0 && (! ((objcts_1.oflag2[j - 1] & 
            8) != 0) || (objcts_1.oflag1[j - 1] & 4224) == 0)) {
        goto L10;
    }
/* if not visible, punt. */
    i__ = 417;
/* assume in room. */
    if (qhere_(&j, &play_1.here)) {
        goto L27100;
    }
    i__ = 418;
/* assume on winner. */
    if (objcts_1.oadv[j - 1] != play_1.winner) {
        goto L10;
    }
/* not here or on person. */
L27100:
    rspsub_(&i__, &objcts_1.odesc2[j - 1]);
/* describe findings. */
    return ret_val;

L27200:
    rspsub_(&i__, &odo2);
/* describe findings. */
    return ret_val;

/* V128--        Wait */

L28000:
    rspeak_(&c__419);
/* time passes. */
    for (i__ = 1; i__ <= 3; ++i__) {
        if (clockd_(&x)) {
            return ret_val;
        }
        if (! findex_1.deadf) {
            fightd_();
        }
        if (prsvec_1.prscon == 0) {
            return ret_val;
        }
/* fighting happened. */
/* L28100: */
    }
    return ret_val;

/* V129--        Spin */
/* V159--        Turn to */

L29000:
L59000:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 2) != 0) {
        goto L59100;
    }
    rspeak_(&c__390);
/* can't turn? */
    return ret_val;

L59100:
    rspsub_(&c__663, &odo2);
/* won't budge. */
    return ret_val;

/* V130--        Board */

L30000:
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 2) != 0) {
        goto L30100;
    }
    rspsub_(&c__421, &odo2);
/* not vehicle, joke. */
    prsvec_1.prscon = 0;
/* kill cmd stream. */
    return ret_val;

L30100:
    if (qhere_(&prsvec_1.prso, &play_1.here)) {
        goto L30200;
    }
/* here? */
    rspsub_(&c__420, &odo2);
/* no, joke. */
    prsvec_1.prscon = 0;
/* kill cmd stream. */
    return ret_val;

L30200:
    if (av == 0) {
        goto L30300;
    }
/* already got one? */
    rspsub_(&c__422, &odo2);
/* yes, joke. */
    prsvec_1.prscon = 0;
/* kill cmd stream. */
    return ret_val;

L30300:
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    rspsub_(&c__423, &odo2);
/* describe. */
    advs_1.avehic[play_1.winner - 1] = prsvec_1.prso;
    if (play_1.winner != 1) {
        newsta_(&advs_1.aobj[play_1.winner - 1], &c__0, &c__0, &prsvec_1.prso,
                 &c__0);
    }
    return ret_val;

/* V131--        Disembark */

L31000:
    if (av == prsvec_1.prso) {
        goto L31100;
    }
/* from vehicle? */
    rspeak_(&c__424);
/* no, joke. */
    prsvec_1.prscon = 0;
/* kill cmd stream. */
    return ret_val;

L31100:
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    if ((rooms_1.rflag[play_1.here - 1] & 8192) != 0) {
        goto L31200;
    }
    rspeak_(&c__425);
/* not on land. */
    prsvec_1.prscon = 0;
/* kill cmd stream. */
    return ret_val;

L31200:
    advs_1.avehic[play_1.winner - 1] = 0;
    rspeak_(&c__426);
    if (play_1.winner != 1) {
        newsta_(&advs_1.aobj[play_1.winner - 1], &c__0, &play_1.here, &c__0, &
                c__0);
    }
    return ret_val;

/* V132--        Take */

L32000:
    ret_val = take_(&c_true);
    return ret_val;

/* V133--        Inventory */

L33000:
    invent_(&play_1.winner);
    return ret_val;
/* VAPPLI, PAGE 8 */

/* V134--        Fill */

L34000:
    if (prsvec_1.prsi != 0) {
        goto L34050;
    }
/* any obj specified? */
    if ((rooms_1.rflag[play_1.here - 1] & 4608) != 0) {
        goto L34025;
    }
    rspeak_(&c__516);
/* nothing to fill with. */
    prsvec_1.prswon = FALSE_;
/* you lose. */
    orphan_(&c_n1, &prssta_1.act, &prssta_1.prep1, &prsvec_1.prso, &c__2, 
            " ", &c__0, &c__0, 1L);
/* orphan "fill obj with" */
    goto L10;

/* return false. */
L34025:
    prsvec_1.prsi = 273;
/* use global water. */
L34050:
    prsvec_1.prsa = 144;
    i__ = prsvec_1.prso;
/* fill x with y becomes */
    prsvec_1.prso = prsvec_1.prsi;
/* put y in x */
    prsvec_1.prsi = i__;
    ret_val = put_(&c_true);
    return ret_val;

/* V135,V136--   Eat/Drink */

L35000:
L36000:
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    if (prsvec_1.prso == 273) {
        goto L36500;
    }
/* drink global water? */
    if (! ((objcts_1.oflag1[prsvec_1.prso - 1] & 1024) != 0)) {
        goto L36400;
    }
/* edible? */
    if (objcts_1.oadv[prsvec_1.prso - 1] == play_1.winner) {
        goto L36200;
    }
/* yes, on winner? */
L36100:
    rspsub_(&c__454, &odo2);
/* not accessible. */
    return ret_val;

L36200:
    if (prsvec_1.prsa == 136) {
        goto L36300;
    }
/* drink food? */
    newsta_(&prsvec_1.prso, &c__455, &c__0, &c__0, &c__0);
/* no, it disappears. */
    return ret_val;

L36300:
    rspeak_(&c__456);
/* yes, joke. */
    return ret_val;

L36400:
    if (! ((objcts_1.oflag1[prsvec_1.prso - 1] & 256) != 0)) {
        goto L36600;
    }
/* drinkable? */
    if (objcts_1.ocan[prsvec_1.prso - 1] == 0) {
        goto L36100;
    }
/* yes, in something? */
    if (objcts_1.oadv[objcts_1.ocan[prsvec_1.prso - 1] - 1] != play_1.winner) 
            {
        goto L36100;
    }
    if ((objcts_1.oflag2[objcts_1.ocan[prsvec_1.prso - 1] - 1] & 8) != 0) {
        goto L36500;
    }
/* cont open? */
    rspeak_(&c__457);
/* no, joke. */
    return ret_val;

L36500:
    newsta_(&prsvec_1.prso, &c__458, &c__0, &c__0, &c__0);
/* gone. */
    return ret_val;

L36600:
    rspsub_(&c__453, &odo2);
/* not food or drink. */
    return ret_val;

/* V137--        Burn */

L37000:
    if ((objcts_1.oflag1[prsvec_1.prsi - 1] & 73) != 73) {
        goto L37600;
    }
/* with flame? */
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 16) == 0) {
        goto L37500;
    }
/* burnable? */
    if (objcts_1.oadv[prsvec_1.prso - 1] == play_1.winner) {
        goto L37400;
    }
/* carrying it? */
    if (qhere_(&prsvec_1.prso, &play_1.here)) {
        goto L37200;
    }
/* here? */
    j = objcts_1.ocan[prsvec_1.prso - 1];
/* get container. */
    if (j == 0) {
        goto L37100;
    }
/* is there one? */
    if (! ((objcts_1.oflag2[j - 1] & 8) != 0)) {
        goto L37100;
    }
/* open? */
    if (j == 99) {
        goto L37300;
    }
/* in balloon receptacle? */
    if (objcts_1.oadv[j - 1] == play_1.winner) {
        goto L37400;
    }
/* carrying? */
    if (qhere_(&j, &play_1.here)) {
        goto L37200;
    }
/* here? */
L37100:
    rspeak_(&c__461);
/* cant reach it. */
    return ret_val;

L37200:
    rspsub_(&c__462, &odo2);
/* burn it. */
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &c__0);
    return ret_val;

L37300:
    ret_val = oappli_(&objcts_1.oactio[97], &c__0);
/* fire in receptacle. */
    return ret_val;

L37400:
    rspsub_(&c__459, &odo2);
/* burnable on player. */
    jigsup_(&c__460);
    return ret_val;

L37500:
    rspsub_(&c__463, &odo2);
/* cant burn it. */
    return ret_val;

L37600:
    rspsub_(&c__301, &odi2);
/* cant burn it with that */
    return ret_val;
/* VAPPLI, PAGE 9 */

/* V138--        Mung */

L38000:
    i__ = 466;
/* choose phrase. */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 128) != 0) {
        goto L41100;
    }
    if (! objact_(&x)) {
        rspsb2_(&c__466, &odo2, &rmk);
    }
    return ret_val;

/* V139--        Kill */

L39000:
    i__ = 467;
/* choose phrase. */
    goto L41100;

/* V140--        Swing */

L40000:
    j = prsvec_1.prso;
/* invert. */
    prsvec_1.prso = prsvec_1.prsi;
    prsvec_1.prsi = j;
    j = odo2;
    odo2 = odi2;
    odi2 = j;
    prsvec_1.prsa = 141;

/* V141--        Attack */

/* for objact. */
L41000:
    i__ = 468;

/* Common mung/attack/swing/kill code. */

L41100:
    if (prsvec_1.prso != 0) {
        goto L41200;
    }
/* anything? */
    rspeak_(&c__469);
/* no, joke. */
    return ret_val;

L41200:
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 128) != 0) {
        goto L41300;
    }
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 32) == 0) {
        rspsub_(&c__470, &odo2);
    }
/* not a villain. */
    return ret_val;

L41300:
    j = 471;
/* assume no weapon. */
    if (prsvec_1.prsi == 0) {
        goto L41500;
    }
    if ((objcts_1.oflag2[prsvec_1.prsi - 1] & 512) == 0) {
        goto L41400;
    }
    melee = 1;
/* assume sword. */
    if (prsvec_1.prsi != 14) {
        melee = 2;
    }
/* must be knife. */
    i__ = blow_(&c__1, &prsvec_1.prso, &melee, &c_true, &c__0);
/* strike blow. */
    return ret_val;

L41400:
    j = 472;
/* not a weapon. */
L41500:
    rspsb2_(&i__, &odo2, &j);
/* joke. */
    return ret_val;
/* VAPPLI, PAGE 10 */

/* V142--        Walk */

L42000:
    ret_val = walk_(&x);
    return ret_val;

/* V143--        Tell */

L43000:
    rspeak_(&c__603);
    prsvec_1.prscon = 0;
/* kill cmd stream. */
    return ret_val;

/* V144--        Put */

L44000:
    ret_val = put_(&c_true);
    return ret_val;

/* V145,V148--   Drop/Throw */

L45000:
/* throw. */
L48000:
    ret_val = drop_(&c_true);
/* drop. */
    return ret_val;

/* V146--        Give */

L46000:
    if (objcts_1.oadv[prsvec_1.prso - 1] == play_1.winner) {
        goto L46100;
    }
/* is he carrying obj? */
    x = objcts_1.ocan[prsvec_1.prso - 1];
/* get container. */
    if (x == 0) {
        goto L46200;
    }
/* container? */
    if (! ((objcts_1.oflag2[x - 1] & 8) != 0)) {
        goto L46200;
    }
/* open? */
    if (objcts_1.oadv[x - 1] != play_1.winner) {
        goto L46200;
    }
/* carrying? */
L46100:
    ret_val = objact_(&x);
/* iobject must handle. */
    return ret_val;

L46200:
    rspeak_(&c__527);
/* don't have it. */
    return ret_val;

/* V147--        Pour */

L47000:
    if (prsvec_1.prso == 11) {
        goto L47100;
    }
/* pour? must be water. */
    rspeak_(&c__1075);
/* otherwise, joke. */
    return ret_val;

L47100:
    if (prsvec_1.prsi == 0) {
        goto L48000;
    }
/* pour x, treat like dro */
    prsvec_1.prsa = 144;
/* else, treat like put. */
    ret_val = put_(&c_true);
    return ret_val;

/* V149--        Save */

L49000:
    if ((rooms_1.rflag[157] & 32768) == 0) {
        goto L49100;
    }
    rspeak_(&c__828);
/* no saves in endgame. */
    return ret_val;

L49100:
    savegm_();
/* save game. */
    prsvec_1.prswon = FALSE_;
/* disable rest of move. */
    prsvec_1.prscon = 0;
    return ret_val;

/* V150--        Restore */

L50000:
    if ((rooms_1.rflag[157] & 32768) == 0) {
        goto L50100;
    }
    rspeak_(&c__829);
/* no restores in endgame */
    return ret_val;

L50100:
    rstrgm_();
/* restore game. */
    prsvec_1.prswon = FALSE_;
/* disable rest of move. */
    prsvec_1.prscon = 0;
    return ret_val;
/* VAPPLI, PAGE 11 */

/* V151--        Hello */

L51000:
    if (prsvec_1.prso != 0) {
        goto L51100;
    }
/* any obj? */
    i__1 = rnd_(&c__4) + 346;
    rspeak_(&i__1);
/* no, vanilla hello. */
    return ret_val;

L51100:
    if (prsvec_1.prso != 261) {
        goto L51200;
    }
/* hello aviator? */
    rspeak_(&c__350);
/* nothing happens. */
    return ret_val;

L51200:
    if (prsvec_1.prso != 255) {
        goto L51300;
    }
/* hello sailor? */
    ++play_1.hs;
/* count. */
    i__ = 351;
/* give normal or */
    if (play_1.hs % 10 == 0) {
        i__ = 352;
    }
/* random message. */
    if (play_1.hs % 20 == 0) {
        i__ = 353;
    }
    rspeak_(&i__);
/* speak up. */
    return ret_val;

L51300:
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    i__ = 354;
/* assume villain. */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 1152) == 0) {
        i__ = 355;
    }
    rspsub_(&i__, &odo2);
/* hello there! */
    return ret_val;

/* V152--        Look into */

L52000:
    if (objact_(&x)) {
        return ret_val;
    }
/* obj handle? */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 4096) == 0) {
        goto L52300;
    }
/* door? */
    if (! ((objcts_1.oflag2[prsvec_1.prso - 1] & 8) != 0)) {
        goto L52200;
    }
/* open? */
    rspsub_(&c__628, &odo2);
/* open door- uninteresti */
    return ret_val;

L52200:
    rspsub_(&c__525, &odo2);
/* closed door- cant see. */
    return ret_val;

L52300:
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 128) != 0) {
        goto L52500;
    }
/* container? */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 8) != 0) {
        goto L52400;
    }
/* open anyway? */
    rspsub_(&c__630, &odo2);
/* cant look inside. */
    return ret_val;

L52400:
    if (! qempty_(&prsvec_1.prso)) {
        goto L52700;
    }
/* not empty? */
    rspsub_(&c__1054, &odo2);
/* doesn't contain anythi */
    return ret_val;

L52500:
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 8) != 0 || (objcts_1.oflag1[
            prsvec_1.prso - 1] & 2048) != 0) {
        goto L52600;
    }
/* open or see inside? */
    rspsub_(&c__525, &odo2);
/* closed. */
    return ret_val;

L52600:
    if (qempty_(&prsvec_1.prso)) {
        goto L52800;
    }
/* see in.  empty? */
L52700:
    princo_(&prsvec_1.prso, &c__573, &c_true);
/* no, list contents. */
    return ret_val;

L52800:
    rspsub_(&c__629, &odo2);
/* empty. */
    return ret_val;
/* VAPPLI, PAGE 12 */

/* V153--        Look under */

L53000:
    if (! objact_(&x)) {
        rspeak_(&c__631);
    }
/* object handle? */
    return ret_val;

/* V154--        Pump */

L54000:
    if (objcts_1.oroom[88] == play_1.here || objcts_1.oadv[88] == 
            play_1.winner) {
        goto L54100;
    }
/* pump here? */
    rspeak_(&c__632);
/* no. */
    return ret_val;

L54100:
    prsvec_1.prsi = 89;
/* becomes inflate */
    prsvec_1.prsa = 102;
/* x with pump. */
    goto L2000;

/* V155--        Wind */

/* done. */
L55000:
    if (! objact_(&x)) {
        rspsub_(&c__634, &odo2);
    }
/* obj handle? */
    return ret_val;

/* V156--        Climb */
/* V157--        Climb up */
/* V158--        Climb down */

L56000:
L57000:
L58000:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    i__ = 9216;
/* assume up. */
    if (prsvec_1.prsa == 158) {
        i__ = 10240;
    }
/* unless climb dn. */
    f = (objcts_1.oflag2[prsvec_1.prso - 1] & 2048) != 0;
    if (f && findxt_(&i__, &play_1.here)) {
        goto L58500;
    }
/* anything to climb? */
    i__ = 657;
    if (f) {
        i__ = 524;
    }
/* variety of jokes. */
    if (! f && (prsvec_1.prso == 257 || prsvec_1.prso == 265 || (
            prsvec_1.prso >= 269 && prsvec_1.prso <= 272))) {
        i__ = 656;
    }
/* if walls. */
    rspeak_(&i__);
/* joke. */
    return ret_val;

L58500:
    prsvec_1.prsa = 142;
/* walk */
    prsvec_1.prso = i__;
/* in specified dir. */
    goto L42000;
/* VAPPLI, PAGE 13 */

/* V160--        Pour on */

/* treat as walk. */
L60000:
    if (prsvec_1.prso != 11) {
        goto L60500;
    }
/* pour water? */
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    newsta_(&c__11, &c__0, &c__0, &c__0, &c__0);
/* vanish water. */
    if (objcts_1.ocan[prsvec_1.prsi - 1] != 99) {
        goto L60100;
    }
/* onto obj in receptacle */
    rspsub_(&c__977, &odi2);
/* doesn't work. */
    return ret_val;

L60100:
    if ((objcts_1.oflag1[prsvec_1.prsi - 1] & 73) != 73) {
        goto L60300;
    }
/* on flame? */
    if (prsvec_1.prsi != 34) {
        goto L60200;
    }
/* on torch? */
    rspeak_(&c__978);
/* doesn't work. */
    return ret_val;

L60200:
    objcts_1.oflag1[prsvec_1.prsi - 1] = objcts_1.oflag1[prsvec_1.prsi - 1] & 
            -2;
/* extinguish. */
    rspsub_(&c__979, &odi2);
/* describe. */
    if (prsvec_1.prsi == 48) {
        cevent_1.cflag[4] = FALSE_;
    }
/* if candle, disable tim */
    if (prsvec_1.prsi == 51) {
        cevent_1.ctick[3] = 0;
    }
/* if match, gone. */
    goto L50;

/* go see if now dark. */
L60300:
    rspsub_(&c__980, &odi2);
/* doesn't work. */
    return ret_val;

L60500:
    rspeak_(&c__981);
/* not water, joke. */
    return ret_val;

/* V161--        Put under */

L61000:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle. */
    i__ = 1037;
/* can't do. */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 4096) != 0) {
        i__ = 982;
    }
/* if door, won't fit. */
    rspeak_(&i__);
    return ret_val;

/* V162--        Untie from */

L62000:
    if ((prsvec_1.prso == 101 && findex_1.btief != 0) || (prsvec_1.prso == 12 
            && findex_1.ttie == prsvec_1.prsi) || (prsvec_1.prso == 12 && 
            prsvec_1.prsi == 75 && findex_1.domef)) {
        goto L62100;
    }
/* untie rope? */
    rspeak_(&c__1070);
/* not attached to that. */
    return ret_val;

L62100:
    prsvec_1.prsa = 113;
/* treat as normal untie. */
    goto L13000;
/* VAPPLI, PAGE 14 */

/* V163--        Make */
/* V169--        Wish */

L63000:
    if (prsvec_1.prso != 263) {
        goto L10;
    }
/* make a wish? */
L69000:
    if (play_1.here != 143) {
        goto L63100;
    }
/* at well? */
    if (objcts_1.oroom[24] == play_1.here) {
        goto L63200;
    }
/* coins here? */
    if (objcts_1.oroom[103] == play_1.here) {
        goto L63300;
    }
/* zorkmid here? */
L63100:
    rspeak_(&c__937);
/* doesn't work. */
    return ret_val;

L63200:
    newsta_(&c__25, &c__938, &c__0, &c__0, &c__0);
/* vanish coins */
    return ret_val;

L63300:
    newsta_(&c__104, &c__938, &c__0, &c__0, &c__0);
/* vanish zorkmid. */
    return ret_val;

/* V164--        Oil */

L64000:
    if (prsvec_1.prsi != 55) {
        goto L64100;
    }
/* with putty? */
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    rspeak_(&c__904);
/* doesn't work. */
    return ret_val;

L64100:
    rspeak_(&c__905);
/* joke. */
    return ret_val;

/* V165--        Play */

L65000:
    if (prsvec_1.prso != 40) {
        goto L65200;
    }
/* play violin? */
    if (prsvec_1.prsi == 0) {
        goto L65100;
    }
/* with anything? */
    if ((objcts_1.oflag2[prsvec_1.prsi - 1] & 512) == 0) {
        goto L65100;
    }
    objcts_1.otval[39] = 0;
/* with weapon, ruined. */
    rspeak_(&c__933);
    return ret_val;

L65100:
    rspeak_(&c__934);
/* offensive noise. */
    return ret_val;

L65200:
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 128) == 0) {
        goto L10;
    }
/* play villain? */
    rspsub_(&c__935, &odo2);
/* you're dead. */
    jigsup_(&c__0);
    return ret_val;

/* V166--        Send */

L66000:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    i__ = 940;
/* can't do it. */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 128) != 0) {
        i__ = 941;
    }
/* why do it? */
    rspsub_(&i__, &odo2);
    return ret_val;
/* VAPPLI, PAGE 15 */

/* V167--        Enter */

L67000:
    prsvec_1.prsa = 142;
/* treat as walk. */
    prsvec_1.prso = 13312;
    goto L42000;

/* V168--        Leave */

L68000:
    prsvec_1.prsa = 142;
/* treat as walk. */
    prsvec_1.prso = 14336;
    goto L42000;

/* V65-- Room */

L65001:
    ret_val = rmdesc_(&c__2);
/* describe room only. */
    return ret_val;

/* V66-- Objects */

L66001:
    ret_val = rmdesc_(&c__1);
/* describe obj only. */
    if (! play_1.telflg) {
        rspeak_(&c__138);
    }
/* no objects. */
    return ret_val;

/* V67-- Rname */

L67001:
    i__1 = rooms_1.rdesc2 - play_1.here;
    rspeak_(&i__1);
/* short room name. */
    return ret_val;

/* V68-- Squeeze */

L68001:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    i__ = 901;
/* can't. */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 128) != 0) {
        i__ = 902;
    }
/* don't understand. */
    rspsub_(&i__, &odo2);
    return ret_val;

/* V69-- Smell */

L69001:
    rspsub_(&c__903, &odo2);
/* joke. */
    return ret_val;
/* VAPPLI, PAGE 16 */

/* V70-- Brief */

L70000:
    findex_1.brieff = TRUE_;
/* brief descriptions. */
    findex_1.superf = FALSE_;
    rspeak_(&c__326);
    return ret_val;

/* V71-- Verbose */

L71000:
    findex_1.brieff = FALSE_;
/* long descriptions. */
    findex_1.superf = FALSE_;
    rspeak_(&c__327);
    return ret_val;

/* V72-- Superbrief */

L72000:
    findex_1.superf = TRUE_;
    rspeak_(&c__328);
    return ret_val;

/* V73-- Stay (used in endgame) */

L73000:
    if (play_1.winner != 3) {
        goto L73100;
    }
/* tell master, stay. */
    rspeak_(&c__781);
/* he does. */
    cevent_1.ctick[23] = 0;
/* not following. */
    return ret_val;

L73100:
    if (play_1.winner == 1) {
        rspeak_(&c__664);
    }
/* joke. */
    return ret_val;

/* V74-- Version */

L74000:
    weeprintf("V%d.%d%c\n", 
      misc_1.vmaj, misc_1.vmin, misc_1.vedit[0]);
    play_1.telflg = TRUE_;
    return ret_val;

/* V75-- Swim */

L75000:
    i__ = 330;
/* assume water. */
    if ((rooms_1.rflag[play_1.here - 1] & 4608) == 0) {
        i__ = rnd_(&c__3) + 331;
    }
/* if no water, joke. */
    rspeak_(&i__);
    return ret_val;

/* V76-- Geronimo */

L76000:
    if (advs_1.avehic[play_1.winner - 1] == 93) {
        goto L76100;
    }
/* in barrel? */
    rspeak_(&c__334);
/* no, joke. */
    return ret_val;

L76100:
    jigsup_(&c__335);
/* over falls. */
    return ret_val;

/* V77-- Sinbad et al */

L77000:
    if (play_1.here == 101 && objcts_1.oroom[57] == play_1.here) {
        goto L77100;
    }
    rspeak_(&c__336);
/* not here, joke. */
    return ret_val;

L77100:
    newsta_(&c__58, &c__337, &c__0, &c__0, &c__0);
/* cyclops flees. */
    findex_1.cyclof = TRUE_;
/* set all flags. */
    findex_1.magicf = TRUE_;
    objcts_1.oflag2[57] = objcts_1.oflag2[57] & -257;
    return ret_val;

/* V78-- unused */

L78000:
    goto L10;

/* V79-- Pray */

L79000:
    if (play_1.here != 97) {
        goto L79050;
    }
/* in temple? */
    if (moveto_(&c__31, &play_1.winner)) {
        goto L79100;
    }
/* fore1 still there? */
L79050:
    rspeak_(&c__340);
/* joke. */
    return ret_val;

L79100:
    f = rmdesc_(&c__3);
/* moved, describe. */
    return ret_val;

/* V80-- Treasure */

L80000:
    if (play_1.here != 96) {
        goto L80050;
    }
/* in temple? */
    if (moveto_(&c__103, &play_1.winner)) {
        goto L79100;
    }
/* treasure room there? */
L80050:
    rspeak_(&c__341);
/* nothing happens. */
    return ret_val;

/* V81-- Temple */

L81000:
    if (play_1.here != 103) {
        goto L81050;
    }
/* in treasure? */
    if (moveto_(&c__96, &play_1.winner)) {
        goto L79100;
    }
/* temp1 still there? */
L81050:
    rspeak_(&c__341);
/* nothing happens. */
    return ret_val;

/* V82-- Blast */

L82000:
    i__ = 342;
/* dont understand. */
    if (prsvec_1.prso == 105) {
        i__ = 252;
    }
/* joke for safe. */
    rspeak_(&i__);
    return ret_val;

/* V83-- Score */

L83000:
    score_(&c_false);
    return ret_val;

/* V84-- Quit */

L84000:
    score_(&c_true);
/* tell score. */
    if (! yesno_(&c__343, &c__10, &c__0)) {
        return ret_val;
    }
/* ask for y/n decision. */
    s_stop(" ", 1L);
/* VAPPLI, PAGE 17 */

/* V85-- Follow (used in endgame) */

/* bye. */
L85000:
    if (play_1.winner != 3) {
        goto L85100;
    }
/* tell master, follow. */
    rspeak_(&c__782);
    cevent_1.cflag[23] = TRUE_;
    cevent_1.ctick[23] = -1;
/* starts following. */
    return ret_val;

L85100:
    i__ = 10;
/* assume ok. */
    if (prsvec_1.prso == 0) {
        goto L85200;
    }
/* any object? */
    i__ = 964;
/* joke 1 */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 128) != 0) {
        i__ = 965;
    }
/* joke 2. */
L85200:
    rspeak_(&i__);
    return ret_val;

/* V86-- Walk through */

L86000:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    if (screen_1.scolrm == 0 || (prsvec_1.prso != 151 && (prsvec_1.prso != 
            269 || play_1.here != 155))) {
        goto L86100;
    }
    screen_1.scolac = screen_1.scolrm;
/* walked thru scol. */
    prsvec_1.prso = 0;
/* fake out fromdr. */
    cevent_1.cflag[16] = TRUE_;
    cevent_1.ctick[16] = 6;
/* start alarm. */
    rspeak_(&c__668);
/* disorient him. */
    f = moveto_(&screen_1.scolrm, &play_1.winner);
/* into room. */
    f = rmdesc_(&c__0);
/* describe. */
    return ret_val;

L86100:
    if (play_1.here != screen_1.scolac) {
        goto L86300;
    }
/* on other side of scol? */
    for (i__ = 1; i__ <= 12; i__ += 3) {
/* walk thru proper wall? */
        if (screen_1.scolwl[i__ - 1] == play_1.here && screen_1.scolwl[i__] ==
                 prsvec_1.prso) {
            goto L86500;
        }
/* in specified room? */
/* L86200: */
    }

L86300:
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 8192) != 0) {
        goto L86400;
    }
/* tkble? */
    i__ = 669;
/* no, joke. */
    if (prsvec_1.prso == 151) {
        i__ = 670;
    }
/* special joke for scol. */
    rspsub_(&i__, &odo2);
    return ret_val;

L86400:
    i__ = 671;
/* joke. */
    if (objcts_1.oroom[prsvec_1.prso - 1] != 0) {
        i__ = rnd_(&c__6) + 552;
    }
/* special jokes if carry */
    rspeak_(&i__);
    return ret_val;

L86500:
    prsvec_1.prso = screen_1.scolwl[i__ + 1];
/* thru scol wall... */
    for (i__ = 1; i__ <= 8; i__ += 2) {
/* find matching room. */
        if (prsvec_1.prso == screen_1.scoldr[i__ - 1]) {
            screen_1.scolrm = screen_1.scoldr[i__];
        }
/* L86600: */
    }
/* declare new scolrm. */
    cevent_1.ctick[16] = 0;
/* cancel alarm. */
    rspeak_(&c__668);
/* disorient him. */
    f = moveto_(&c__155, &play_1.winner);
/* back in box room. */
    f = rmdesc_(&c__0);
    return ret_val;

/* V87-- Ring */

L87000:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    i__ = 359;
/* cant ring. */
    if (prsvec_1.prso == 46) {
        i__ = 360;
    }
/* ding, dong. */
    rspeak_(&i__);
/* joke. */
    return ret_val;

/* V88-- Brush */

L88000:
    if (prsvec_1.prso == 256) {
        goto L88100;
    }
/* brush teeth? */
    rspeak_(&c__362);
/* no, joke. */
    return ret_val;

L88100:
    if (prsvec_1.prsi != 0) {
        goto L88200;
    }
/* with something? */
    rspeak_(&c__363);
/* no, joke. */
    return ret_val;

L88200:
    if (prsvec_1.prsi == 55 && objcts_1.oadv[54] == play_1.winner) {
        goto L88300;
    }
/* with putty? */
    rspsub_(&c__364, &odi2);
/* no, joke. */
    return ret_val;

L88300:
    jigsup_(&c__365);
/* yes, dead!!!!! */
    return ret_val;
/* VAPPLI, PAGE 18 */

/* V89-- Dig */

L89000:
    if (prsvec_1.prsi != 96) {
        goto L89100;
    }
/* shovel? */
    ret_val = objact_(&x);
/* must handle. */
    return ret_val;

L89100:
    i__ = 392;
/* assume tool. */
    if ((objcts_1.oflag1[prsvec_1.prsi - 1] & 4) == 0) {
        i__ = 393;
    }
    rspsub_(&i__, &odi2);
    return ret_val;

/* V90-- Time */

L90000:
    gttime_(&k);
/* get play time. */
    i__ = k / 60;
    j = k % 60;
    glk_put_string("You have been playing Dungeon for ");
    if (k == 0) {
        glk_put_string("longer than you think.\n");
    }
    else {
        if (i__ != 0) {
            weeprintf("%d hour", i__);
        }
        if (i__ >= 2) {
            glk_put_string("s and ");
        }
        if (i__ == 1) {
            glk_put_string(" and ");
        }
        if (j == 1) {
            weeprintf("%d minute.\n", j);
        }
        if (j != 1) {
            weeprintf("%d minutes.\n", j);
        }
    }
    play_1.telflg = TRUE_;
    return ret_val;


/* V91-- Leap */

L91000:
    if (prsvec_1.prso == 0) {
        goto L91200;
    }
/* over something? */
    if (qhere_(&prsvec_1.prso, &play_1.here)) {
        goto L91100;
    }
/* here? */
    rspeak_(&c__447);
/* no, joke. */
    return ret_val;

L91100:
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 128) == 0) {
        goto L91300;
    }
    rspsub_(&c__448, &odo2);
/* cant jump villain. */
    return ret_val;

L91200:
    if (! findxt_(&c__10240, &play_1.here)) {
        goto L91300;
    }
/* down exit? */
    if (curxt_1.xtype == 2) {
        goto L91400;
    }
/* invalid? */
    if (curxt_1.xtype != 3) {
        goto L91300;
    }
/* conditional? */
    if (! findex_flags[(curxt_1.xobj) - 1]) {
        goto L91400;
    }
/* blocked off? */
L91300:
    i__1 = rnd_(&c__5) + 314;
    rspeak_(&i__1);
/* wheeee! */
    return ret_val;

L91400:
    if (play_1.winner == 1) {
        goto L91500;
    }
/* tell x, jump? */
    jigsup_(&c__452);
/* Geronimo! */
    return ret_val;

L91500:
    i__1 = rnd_(&c__4) + 449;
    jigsup_(&i__1);
/* fatal leap. */
    return ret_val;
/* VAPPLI, PAGE 19 */

/* V92-- Lock */

L92000:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    if (prsvec_1.prso == 65 && ! ((objcts_1.oflag2[c__65 - 1] & 8) != 0) && 
            play_1.here == 25) {
        goto L92200;
    }
/* lock closed grate? */
L92100:
    rspeak_(&c__464);
/* not lock grate. */
    return ret_val;

L92200:
    findex_1.grunlf = FALSE_;
/* grate now locked. */
    rspeak_(&c__214);
    exits_1.travel[rooms_1.rexit[play_1.here - 1]] = 214;
/* change exit status. */
    return ret_val;

/* V93-- Unlock */

L93000:
    if (objact_(&x)) {
        return ret_val;
    }
/* object handle? */
    if (prsvec_1.prso != 65 || play_1.here != 25) {
        goto L92100;
    }
/* not unlock grate. */
    if (prsvec_1.prsi == 23) {
        goto L93200;
    }
/* got keys? */
    rspsub_(&c__465, &odi2);
/* no, joke. */
    return ret_val;

L93200:
    findex_1.grunlf = TRUE_;
/* unlock grate. */
    rspeak_(&c__217);
    exits_1.travel[rooms_1.rexit[play_1.here - 1]] = 1041;
/* change exit status. */
    return ret_val;

/* V94-- Diagnose */

L94000:
    i__ = fights_(&play_1.winner, &c_false);
/* get fights strength. */
    j = advs_1.astren[play_1.winner - 1];
/* get health. */
/* Computing MIN */
    i__1 = i__ + j;
    k = min(i__1,4);
/* get state. */
    if (! cevent_1.cflag[0]) {
        j = 0;
    }
/* if no wounds. */
/* Computing MIN */
    i__1 = 4, i__2 = abs(j);
    l = min(i__1,i__2);
/* scale. */
    i__1 = l + 473;
    rspeak_(&i__1);
/* describe health. */
    i__ = (-j - 1) * 30 + cevent_1.ctick[0];
/* compute wait. */
    if (j != 0) {
        weeprintf("You will be cured after %d moves.\n", i__);
    }
    i__1 = k + 478;
    rspeak_(&i__1);
/* how much more? */
    if (play_1.deaths != 0) {
        i__1 = play_1.deaths + 482;
        rspeak_(&i__1);
    }
/* how many deaths? */
    return ret_val;
/* VAPPLI, PAGE 20 */

/* V95-- Incant */

L95000:
    if (play_1.winner != 1) {
        goto L10;
    }
/* must do yourself. */
    if ((rooms_1.rflag[159] & 32768) != 0) {
        goto L95800;
    }
/* too late? */
    if (input_1.sublnt == 0) {
        goto L95350;
    }
/* any input? */
    s_copy(pw, " ", 8L, 1L);
/* set up parse. */
    s_copy(pw + 8, " ", 8L, 1L);
    wp = 1;
    cp = 1;
    i__1 = input_1.sublnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* scan substring */
        if (*(unsigned char *)&input_1.subbuf[i__ - 1] != ' ') {
            goto L95150;
        }
/* blank? */
        if (cp == 1) {
            goto L95200;
        }
/* anything in word yet? */
/* Computing MIN */
        i__2 = 2, i__3 = wp + 1;
        wp = min(i__2,i__3);
/* advance word pointer. */
        cp = 1;
/* reset char pointer. */
        goto L95200;
L95150:
        if (cp <= 8) {
            *(unsigned char *)&pw[((wp - 1) << 3) + (cp - 1)] = *(unsigned 
                    char *)&input_1.subbuf[i__ - 1];
        }
/* add char to word. */
        ++cp;
L95200:
        ;
    }

    if (s_cmp(pw, " ", 8L, 1L) != 0) {
        goto L95400;
    }
/* any input? */
L95350:
    rspeak_(&c__856);
/* no, ho hum. */
L95375:
    prsvec_1.prscon = 0;
/* kill cmd stream. */
    return ret_val;

L95400:
    encryp_(pw, ch, 8L, 8L);
/* compute response. */
    if (s_cmp(pw + 8, " ", 8L, 1L) != 0) {
        goto L95600;
    }

/* two phrases? */
    if (findex_1.spellf) {
        goto L95550;
    }
/* he's trying to learn. */
    if ((rooms_1.rflag[157] & 32768) == 0) {
        goto L95575;
    }
/* really in end game */
    findex_1.spellf = TRUE_;
/* tell him. */
    play_1.telflg = TRUE_;
    glk_put_string("A hollow voice replies: \""); 
    glk_put_buffer(pw, nblen_(pw, 8L));
    glk_put_string(" ");
    glk_put_buffer(ch, 8L);
    glk_put_string("\".\n");
    return ret_val;

L95550:
    rspeak_(&c__857);
/* he's got one already. */
    goto L95375;

L95575:
    rspeak_(&c__858);
/* he's not in endgame. */
    goto L95375;

L95600:
    encryp_(pw + 8, ch2, 8L, 8L);
/* try both ways. */
    if (findex_1.spellf || (s_cmp(pw, ch2, 8L, 8L) != 0 && s_cmp(pw + 8, ch, 
            8L, 8L) != 0)) {
        goto L95900;
    }
/* wrong or second use. */
    findex_1.spellf = TRUE_;
/* it works. */
    rspeak_(&c__859);
    cevent_1.cflag[19] = TRUE_;
    cevent_1.ctick[19] = 1;
/* force start. */
    return ret_val;

L95800:
    rspeak_(&c__855);
/* too late. */
    goto L95375;

L95900:
    rspeak_(&c__1052);
/* got it wrong. */
    goto L95375;
/* VAPPLI, PAGE 21 */

/* V96-- Answer */

L96000:
    if (play_1.winner != 1) {
        goto L10;
    }
/* must answer for himsel */
    if (input_1.sublnt == 0) {
        goto L96050;
    }
/* any substring? */
    if (play_1.here == 91 && ! findex_1.riddlf) {
        goto L96700;
    }
/* riddle room? */
    if (play_1.here == 166) {
        goto L96100;
    }
/* end game front door? */
L96050:
    rspeak_(&c__799);
/* no one listens. */
    prsvec_1.prscon = 0;
/* kill cmd stream. */
    return ret_val;

L96100:
    if (findex_1.inqstf && findex_1.nqatt < 5 && findex_1.corrct < 3) {
        goto L96200;
    }
/* knocked, didn't lose o */
    rspeak_(&c__783);
/* no reply. */
    prsvec_1.prscon = 0;
/* kill cmd stream. */
    return ret_val;

L96200:
    for (j = 1; j <= 16; ++j) {
/* check answers. */
        if (findex_1.quesno != answer[j - 1]) {
            goto L96300;
        }
/* only check proper ans. */
        if (s_cmp(input_1.subbuf, ansstr + (j - 1) * 12, 76L, nblen_(ansstr + 
                (j - 1) * 12, 12L)) == 0) {
            goto L96500;
        }
L96300:
        ;
    }

    prsvec_1.prscon = 0;
/* kill cmd stream. */
    ++findex_1.nqatt;
/* wrong, cretin. */
    if (findex_1.nqatt >= 5) {
        goto L96400;
    }
/* too many wrong? */
    i__1 = findex_1.nqatt + 800;
    rspeak_(&i__1);
/* no, try again. */
    return ret_val;

L96400:
    rspeak_(&c__826);
/* all over. */
    cevent_1.cflag[22] = FALSE_;
/* lose. */
    return ret_val;

L96500:
    ++findex_1.corrct;
/* got it right. */
    rspeak_(&c__800);
/* hooray. */
    if (findex_1.corrct >= 3) {
        goto L96600;
    }
/* won totally? */
    cevent_1.cflag[22] = TRUE_;
    cevent_1.ctick[22] = 2;
/* no, start again. */
    findex_1.quesno = (findex_1.quesno + 3) % 8;
    findex_1.nqatt = 0;
    rspeak_(&c__769);
/* ask next question. */
    i__1 = findex_1.quesno + 770;
    rspeak_(&i__1);
    return ret_val;

L96600:
    rspeak_(&c__827);
/* quiz over, */
    cevent_1.cflag[22] = FALSE_;
    objcts_1.oflag2[172] = objcts_1.oflag2[172] | 8;
/* open door. */
    return ret_val;

L96700:
    if (s_cmp(input_1.subbuf, "WELL", 76L, 4L) != 0) {
        goto L96050;
    }
/* right answer? */
    findex_1.riddlf = TRUE_;
/* solved riddle. */
    rspeak_(&c__338);
    return ret_val;
/* V97-- Count (valuables, possessions in VALUAC) */

L97000:
    if (prsvec_1.prso != 51) {
        goto L97100;
    }
/* matches? */
    if (findex_1.ormtch == 1) {
        weeprintf("You have %d match.\n", findex_1.ormtch);
        /* number of matches */
    }
/* print number. */
    if (findex_1.ormtch != 1) {
        weeprintf("You have %d matches.\n", findex_1.ormtch);
        /* number of matches */
    }
    play_1.telflg = TRUE_;
    return ret_val;

L97100:
    i__ = 1062;
/* default. */
    if (prsvec_1.prso == 25) {
        i__ = 561;
    }
/* bag of coins. */
    if (prsvec_1.prso == 48) {
        i__ = 1058;
    }
/* candles. */
    if (prsvec_1.prso == 148) {
        i__ = 1059;
    }
/* stack of bills. */
    if (prsvec_1.prso == 18) {
        i__ = 1060;
    }
/* pile of leaves. */
    if (prsvec_1.prso == 263) {
        i__ = 1061;
    }
/* blessings. */
    if (prsvec_1.prso == 120) {
        i__ = 1084;
    }
/* heads. */
    rspeak_(&i__);
/* print response. */
    return ret_val;

} /* vappli_ */



/* TAKE-- Basic take sequence */

/* Take an object (for verbs take, put, drop, read, etc.) */

logical take_(logical *flg)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    integer x;
    integer i__;


/* Declarations */

/* TAKE, PAGE 2 */

    if (prsvec_1.prso <= misc_1.strbit && (objcts_1.oflag2[prsvec_1.prso - 1] 
            & 16) == 0) {
        goto L100;
    }
/* star or nocheck? */
    ret_val = objact_(&x);
/* yes, let it handle. */
    return ret_val;

L100:
    ret_val = FALSE_;
/* assume loses. */
    x = objcts_1.ocan[prsvec_1.prso - 1];
/* inside? */
    if (prsvec_1.prsi == 0 || prsvec_1.prsi == x) {
        goto L200;
    }
/* take x from ocan(x)? */
    rspeak_(&c__1038);
/* not in that. */
    return ret_val;

L200:
    if (prsvec_1.prso != advs_1.avehic[play_1.winner - 1]) {
        goto L400;
    }
/* his vehicle? */
    rspeak_(&c__672);
/* dummy. */
    return ret_val;

L400:
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 8192) != 0) {
        goto L500;
    }
/* takeable? */
    if (! oappli_(&objcts_1.oactio[prsvec_1.prso - 1], &c__0)) {
        i__1 = rnd_(&c__6) + 552;
        rspeak_(&i__1);
    }
    return ret_val;

/* Object is takeable and in position to be taken. */

L500:
    if (x != 0 || qhere_(&prsvec_1.prso, &play_1.here)) {
        goto L600;
    }
    i__ = 103;
/* assume player. */
    if (play_1.winner != 1) {
        i__ = 1080;
    }
    if (objcts_1.oadv[prsvec_1.prso - 1] == play_1.winner) {
        rspeak_(&i__);
    }
/* already got it? */
    return ret_val;

L600:
    if (x == 0) {
        goto L650;
    }
/* contained? */
    if (objcts_1.oadv[x - 1] == play_1.winner) {
        goto L700;
    }
/* already carrying cont? */
L650:
    if (weighr_(&prsvec_1.prso, &play_1.winner) + objcts_1.osize[
            prsvec_1.prso - 1] <= play_1.mxload) {
        goto L700;
    }
/* can he carry? */
    i__ = 558;
/* assume player. */
    if (play_1.winner != 1) {
        i__ = 1079;
    }
    rspeak_(&i__);
/* too much weight. */
    prsvec_1.prscon = 0;
/* kill cmd stream. */
    return ret_val;

L700:
    ret_val = TRUE_;
/* at last. */
    if (oappli_(&objcts_1.oactio[prsvec_1.prso - 1], &c__0)) {
        return ret_val;
    }
/* did it handle? */
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &play_1.winner);
/* take object for winner */
    objcts_1.oflag2[prsvec_1.prso - 1] = objcts_1.oflag2[prsvec_1.prso - 1] | 
            4;
/* has been touched. */
    scrupd_(&objcts_1.ofval[prsvec_1.prso - 1]);
/* update score. */
    objcts_1.ofval[prsvec_1.prso - 1] = 0;
/* cant be scored again. */
    if (*flg) {
        rspeak_(&c__559);
    }
/* tell taken. */
    return ret_val;

} /* take_ */



/* DROP- Drop verb processor (also throw, pour water) */

/* Declarations */

logical drop_(logical *flg)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */
    logical f;
    integer x;
    integer i__;


    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 16) == 0) {
        goto L100;
    }
    ret_val = objact_(&x);
/* no check, let obj hand */
    return ret_val;

L100:
    ret_val = TRUE_;
/* assume wins. */
    x = objcts_1.ocan[prsvec_1.prso - 1];
/* get container. */
    if (x == 0) {
        goto L200;
    }
/* is it inside? */
    if (objcts_1.oadv[x - 1] != play_1.winner) {
        goto L1000;
    }
/* is he carrying con? */
    if ((objcts_1.oflag2[x - 1] & 8) != 0) {
        goto L300;
    }
/* is it open? */
    rspsub_(&c__525, &objcts_1.odesc2[x - 1]);
/* cant reach. */
    return ret_val;

L200:
    if (objcts_1.oadv[prsvec_1.prso - 1] != play_1.winner) {
        goto L1000;
    }
/* is he carrying obj? */
L300:
    if (advs_1.avehic[play_1.winner - 1] == 0) {
        goto L400;
    }
/* is he in vehicle? */
    prsvec_1.prsi = advs_1.avehic[play_1.winner - 1];
/* yes, */
    f = put_(&c_true);
/* drop into vehicle. */
    prsvec_1.prsi = 0;
/* disarm parser. */
    return ret_val;

/* done. */
L400:
    newsta_(&prsvec_1.prso, &c__0, &play_1.here, &c__0, &c__0);
/* drop into room. */
    scrupd_(&objcts_1.ofval[prsvec_1.prso - 1]);
/* score object. */
    objcts_1.ofval[prsvec_1.prso - 1] = 0;
/* cant be scored again. */
    objcts_1.oflag2[prsvec_1.prso - 1] = objcts_1.oflag2[prsvec_1.prso - 1] | 
            4;

/* has been touched. */
    if (objact_(&x)) {
        return ret_val;
    }
/* did it handle? */
    if (prsvec_1.prsa == 145) {
        rspeak_(&c__528);
    }
    if (prsvec_1.prsa == 148) {
        rspeak_(&c__529);
    }
    return ret_val;

L1000:
    i__ = 527;
/* assume player. */
    if (play_1.winner != 1) {
        i__ = 1078;
    }
    rspeak_(&i__);
/* dont have it. */
    return ret_val;

} /* drop_ */



/* PUT- Put verb processor */

/* Declarations */

logical put_(logical *flg)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */
    integer x;
    integer j;
    integer svi, svo;


/* Functions and data */

/* PUT, PAGE 2 */

    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 16) == 0) {
        goto L100;
    }
    ret_val = objact_(&x);
/* no check, let obj hand */
    return ret_val;

L100:
    ret_val = FALSE_;
    if (prsvec_1.prso <= misc_1.strbit && prsvec_1.prsi <= misc_1.strbit) {
        goto L200;
    }
    if (! objact_(&x)) {
        rspeak_(&c__560);
    }
/* star */
    ret_val = TRUE_;
    return ret_val;

L200:
    if ((objcts_1.oflag2[prsvec_1.prsi - 1] & 8) != 0 || (objcts_1.oflag1[
            prsvec_1.prsi - 1] & 4224) != 0 || (objcts_1.oflag2[prsvec_1.prsi 
            - 1] & 2) != 0) {
        goto L300;
    }
    rspeak_(&c__561);
/* cant put in that. */
    return ret_val;

L300:
    if ((objcts_1.oflag2[prsvec_1.prsi - 1] & 8) != 0) {
        goto L400;
    }
/* is it open? */
    rspeak_(&c__562);
/* no, joke */
    return ret_val;

L400:
    if (prsvec_1.prso != prsvec_1.prsi) {
        goto L500;
    }
/* into itself? */
    rspeak_(&c__563);
/* yes, joke. */
    return ret_val;

L500:
    if (objcts_1.ocan[prsvec_1.prso - 1] != prsvec_1.prsi) {
        goto L600;
    }
/* already inside. */
    rspsb2_(&c__564, &objcts_1.odesc2[prsvec_1.prso - 1], &objcts_1.odesc2[
            prsvec_1.prsi - 1]);
    ret_val = TRUE_;
    return ret_val;

L600:
    if (weighr_(&prsvec_1.prso, &c__0) + weighr_(&prsvec_1.prsi, &c__0) + 
            objcts_1.osize[prsvec_1.prso - 1] <= objcts_1.ocapac[
            prsvec_1.prsi - 1]) {
        goto L700;
    }
/* not too full? */
    if (prsvec_1.prsi != advs_1.avehic[play_1.winner - 1]) {
        goto L650;
    }
/* into vehicle? */
    rspsub_(&c__889, &objcts_1.odesc2[prsvec_1.prsi - 1]);
/* too full. */
    return ret_val;

L650:
    rspeak_(&c__565);
/* then cant do it. */
    return ret_val;

/* Now see if object (or its container) is in room */

L700:
    j = prsvec_1.prso;
/* start search. */
L725:
    if (qhere_(&j, &play_1.here)) {
        goto L750;
    }
/* is it here? */
    j = objcts_1.ocan[j - 1];
    if (j != 0) {
        goto L725;
    }
/* more to do? */
    goto L800;

/* no, sch fails. */
L750:
    if (prsvec_1.prso == 11 || prsvec_1.prso == 273) {
        goto L800;
    }
    svo = prsvec_1.prso;
/* save parser. */
    svi = prsvec_1.prsi;
    prsvec_1.prsa = 132;
    prsvec_1.prsi = 0;
    if (! take_(&c_false)) {
        return ret_val;
    }
/* take object. */
    prsvec_1.prsa = 144;
    prsvec_1.prso = svo;
    prsvec_1.prsi = svi;
    goto L1000;

/* Now see if object is on person. */

L800:
    if (objcts_1.ocan[prsvec_1.prso - 1] == 0) {
        goto L1000;
    }
/* inside? */
    if ((objcts_1.oflag2[objcts_1.ocan[prsvec_1.prso - 1] - 1] & 8) != 0) {
        goto L900;
    }
/* open? */
    rspsub_(&c__566, &objcts_1.odesc2[prsvec_1.prso - 1]);
/* lose. */
    return ret_val;

L900:
    scrupd_(&objcts_1.ofval[prsvec_1.prso - 1]);
/* score object. */
    objcts_1.ofval[prsvec_1.prso - 1] = 0;
    objcts_1.oflag2[prsvec_1.prso - 1] = objcts_1.oflag2[prsvec_1.prso - 1] | 
            4;
/* has been touched. */
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &play_1.winner);

/* temporarily on winner. */
L1000:
    if (objact_(&x)) {
        return ret_val;
    }
/* no, give object a shot */
    newsta_(&prsvec_1.prso, &c__2, &c__0, &prsvec_1.prsi, &c__0);
/* contained inside. */
    ret_val = TRUE_;
    return ret_val;

} /* put_ */



/* VALUAC- Handles valuables/everything/possessions/bunch object */
/*         for take, put, drop, count */

/* Declarations */

/* Subroutine */ int valuac_(integer *v)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    logical f, f1;
    integer savep, av, k, j, l, saveh, i__;

/* Functions and data */

/* VALUAC, PAGE 2 */
/* Count */

    if (prsvec_1.prsa != 97 || prsvec_1.prso != 254) {
        goto L100;
    }
    k = 0;
    i__1 = objcts_1.olnt;
    for (j = 1; j <= i__1; ++j) {
/* count possessions. */
        if (objcts_1.oadv[j - 1] == play_1.winner) {
            ++k;
        }
/* L50: */
    }
    if (k == 1) {
        weeprintf("You have %d possession.\n", k);
    }
    if (k != 1) {
        weeprintf("You have %d possessions.\n", k);
    }
    play_1.telflg = TRUE_;
    return 0;

L100:
    if (prsvec_1.prsa != 97 || prsvec_1.prso != 253) {
        goto L200;
    }
    k = 0;
    l = 0;
    i__1 = objcts_1.olnt;
    for (j = 1; j <= i__1; ++j) {
/* count treasures. */
        if (objcts_1.oadv[j - 1] == play_1.winner && objcts_1.otval[j - 1] > 
                0) {
            ++k;
        }
        if (objcts_1.ocan[j - 1] == 9 && objcts_1.otval[j - 1] > 0) {
            ++l;
        }
/* L150: */
    }
    if (k == 1) {
        weeprintf("You have %d valuable.\n", k);
    }
    if (k != 1) {
        weeprintf("You have %d valuables.\n", k);
    }
    play_1.telflg = TRUE_;
    if (play_1.here != 8) {
        return 0;
    }
    if (l == 1) {
        weeprintf("Your adventure has netted %d treasure.\n", l); 
    }
    if (l != 1) {
        weeprintf("Your adventure has netted %d treasures.\n", l); 
    }
    return 0;
/* VALUAC, PAGE 3 */
/* Take */

L200:
    savep = prsvec_1.prso;
/* save prso. */
    saveh = play_1.here;
/* save here. */
    f = TRUE_;
/* assume no actions. */
    i__ = 579;
/* assume not lit. */
    av = advs_1.avehic[play_1.winner - 1];

/* get vehicle. */
    if (prsvec_1.prsa != 132) {
        goto L1000;
    }
/* take? */
    if (! lit_(&play_1.here)) {
        goto L4500;
    }
/* if not lit, punt. */
    if (prsvec_1.prso != 284 || prssta_1.bunsub != 0) {
        goto L400;
    }
/* bunch, no except */
    i__1 = prssta_1.bunlnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop through bunch. */
        prsvec_1.prso = prssta_1.bunvec[i__ - 1];
/* get next item. */
        f = FALSE_;
        rspsub_(&c__580, &objcts_1.odesc2[prsvec_1.prso - 1]);
        f1 = take_(&c_true);
        if (saveh != play_1.here) {
            goto L4500;
        }
/* L300: */
    }
    goto L4000;

/* go clean up. */
L400:
    i__1 = objcts_1.olnt;
    for (prsvec_1.prso = 1; prsvec_1.prso <= i__1; ++prsvec_1.prso) {
/* loop thru objects. */
        if (((objcts_1.oflag1[prsvec_1.prso - 1] & 8192) == 0 && (
                objcts_1.oflag2[prsvec_1.prso - 1] & 32) == 0) || (
                objcts_1.oflag1[prsvec_1.prso - 1] & 32768) == 0 || (
                objcts_1.oflag2[prsvec_1.prso - 1] & 1024) != 0 || ((savep == 
                284 && qbunch_(&prsvec_1.prso)) || (objcts_1.otval[
                prsvec_1.prso - 1] <= 0 && (savep == 253 || (savep == 284 && 
                prssta_1.bunsub == 253))) || (objcts_1.oadv[prsvec_1.prso - 1]
                 != play_1.winner && (savep == 254 || (savep == 284 && 
                prssta_1.bunsub == 254))))) {
            goto L500;
        }
        if (! ((av == 0 && ! qhere_(&prsvec_1.prso, &play_1.here)) || (av != 
                0 && objcts_1.ocan[prsvec_1.prso - 1] != av))) {
            goto L450;
        }
/* is it here? */
        j = objcts_1.ocan[prsvec_1.prso - 1];
/* get container. */
        if (j == 0 || prsvec_1.prso == 11) {
            goto L500;
        }
/* in a cont? */
        if ((objcts_1.oflag2[j - 1] & 8) == 0 || (((av == 0 && ! qhere_(&j, &
                play_1.here)) || (av != 0 && objcts_1.ocan[j - 1] != av)) && 
                objcts_1.oadv[j - 1] != play_1.winner)) {
            goto L500;
        }

/* in open cont here? */
L450:
        f = FALSE_;
        rspsub_(&c__580, &objcts_1.odesc2[prsvec_1.prso - 1]);
        f1 = take_(&c_true);
        if (saveh != play_1.here) {
            goto L4500;
        }
L500:
        ;
    }
    goto L4000;
/* VALUAC, PAGE 4 */
/* Drop */

/* go clean up. */
L1000:
    if (prsvec_1.prsa != 145) {
        goto L2000;
    }
/* drop? */
    if (prsvec_1.prso != 284 || prssta_1.bunsub != 0) {
        goto L1400;
    }
/* bunch, no excep */
    i__1 = prssta_1.bunlnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop through bunch. */
        prsvec_1.prso = prssta_1.bunvec[i__ - 1];
/* get next item. */
        f = FALSE_;
        rspsub_(&c__580, &objcts_1.odesc2[prsvec_1.prso - 1]);
        f1 = drop_(&c_true);
        if (saveh != play_1.here) {
            goto L4500;
        }
/* L1300: */
    }
    goto L4000;

/* go clean up. */
L1400:
    i__1 = objcts_1.olnt;
    for (prsvec_1.prso = 1; prsvec_1.prso <= i__1; ++prsvec_1.prso) {
/* loop through inventory */
        if (objcts_1.oadv[prsvec_1.prso - 1] != play_1.winner || ((savep == 
                284 && qbunch_(&prsvec_1.prso)) || (objcts_1.otval[
                prsvec_1.prso - 1] <= 0 && (savep == 253 || (savep == 284 && 
                prssta_1.bunsub == 253))) || (objcts_1.oadv[prsvec_1.prso - 1]
                 != play_1.winner && (savep == 254 || (savep == 284 && 
                prssta_1.bunsub == 254))))) {
            goto L1500;
        }
        f = FALSE_;
        rspsub_(&c__580, &objcts_1.odesc2[prsvec_1.prso - 1]);
        f1 = drop_(&c_true);
        if (saveh != play_1.here) {
            goto L4500;
        }
L1500:
        ;
    }
    goto L4000;
/* VALUAC, PAGE 5 */
/* Put */

/* go clean up. */
L2000:
    if (prsvec_1.prsa != 144) {
        goto L3000;
    }
/* put? */
    if (! lit_(&play_1.here)) {
        goto L4500;
    }
/* if not lit, punt. */
    if (prsvec_1.prso != 284 || prssta_1.bunsub != 0) {
        goto L2400;
    }
/* bunch, no excep */
    i__1 = prssta_1.bunlnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop through bunch. */
        prsvec_1.prso = prssta_1.bunvec[i__ - 1];
/* get next item. */
        f = FALSE_;
        rspsub_(&c__580, &objcts_1.odesc2[prsvec_1.prso - 1]);
        f1 = put_(&c_true);
        if (saveh != play_1.here) {
            goto L4500;
        }
/* L2300: */
    }
    goto L4000;

/* go clean up. */
L2400:
    i__1 = objcts_1.olnt;
    for (prsvec_1.prso = 1; prsvec_1.prso <= i__1; ++prsvec_1.prso) {
/* loop thru objects. */
        if ((objcts_1.oadv[prsvec_1.prso - 1] != play_1.winner && ((av == 0 &&
                 ! qhere_(&prsvec_1.prso, &play_1.here)) || (av != 0 && 
                objcts_1.ocan[prsvec_1.prso - 1] != av) || ((objcts_1.oflag1[
                prsvec_1.prso - 1] & 8192) == 0 && (objcts_1.oflag2[
                prsvec_1.prso - 1] & 32) == 0))) || prsvec_1.prso == 
                prsvec_1.prsi || ((savep == 284 && qbunch_(&prsvec_1.prso)) ||
                 (objcts_1.otval[prsvec_1.prso - 1] <= 0 && (savep == 253 || (
                savep == 284 && prssta_1.bunsub == 253))) || (objcts_1.oadv[
                prsvec_1.prso - 1] != play_1.winner && (savep == 254 || (
                savep == 284 && prssta_1.bunsub == 254)))) || (
                objcts_1.oflag1[prsvec_1.prso - 1] & 32768) == 0) {
            goto L2500;
        }
        f = FALSE_;
        rspsub_(&c__580, &objcts_1.odesc2[prsvec_1.prso - 1]);
        f1 = put_(&c_true);
        if (saveh != play_1.here) {
            goto L4500;
        }
L2500:
        ;
    }
    goto L4000;

/* Wrong verb. */

/* go clean up. */
L3000:
    i__ = 677;
/* wrong verb. */
    goto L4500;

/* Clean up. */

L4000:
    i__ = 581;
/* right verb, choose */
    if (savep == 253) {
        i__ = 582;
    }
/* nothing happened messa */
L4500:
    if (f) {
        rspeak_(&i__);
    }
/* not lit, nothing, wron */
    prsvec_1.prso = savep;
/* restore PRSO. */
    prssta_1.bunsub = 0;
/* cancel EXCEPT/BUT. */
    return 0;
} /* valuac_ */



/* QBUNCH-       Is object in bunch vector? */

/* Declarations */

logical qbunch_(integer *obj)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    integer i__;


    if (prssta_1.bunlnt == 0) {
        goto L200;
    }
/* bunch vector empty? */
    ret_val = TRUE_;
/* assume found. */
    i__1 = prssta_1.bunlnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* search bunch vector. */
        if (*obj == prssta_1.bunvec[i__ - 1]) {
            return ret_val;
        }
/* got one. */
/* L100: */
    }
L200:
    ret_val = FALSE_;
/* not found. */
    return ret_val;

} /* qbunch_ */



/* SAVE- Save game state */

/* Declarations */

/* Subroutine */ int savegm_(void)
{
    /* System generated locals */
    integer i__1;
    frefid_t savefileref;
    strid_t savefile;

    /* Local variables */
    integer i__;

    if (input_1.sublnt == 0) {
        savefileref = glk_fileref_create_by_prompt(fileusage_SavedGame|fileusage_BinaryMode,
            filemode_Write, 0);
    }
    else {
        char namebuf[128];
        for (i__ = 0; i__ < input_1.sublnt; i__++)
            namebuf[i__] = input_1.subbuf[i__];
        namebuf[input_1.sublnt] = '\0';
        savefileref = glk_fileref_create_by_name(fileusage_SavedGame|fileusage_BinaryMode,
            namebuf, 0);
    }
    if (!savefileref) {
        goto L100;
    }
    savefile = glk_stream_open_file(savefileref, filemode_Write, 0);
    glk_fileref_destroy(savefileref);
    if (!savefile) {
        goto L100;
    }

    gttime_(&i__); /* get amount of play time. */

    f_put_ints(savefile, &misc_1.vmaj, 1);
    f_put_ints(savefile, &misc_1.vmin, 1);

    f_put_ints(savefile, &play_1.winner, 1);
    f_put_ints(savefile, &play_1.here, 1);
    f_put_ints(savefile, &hack_1.thfpos, 1);
    f_put_logicals(savefile, &play_1.telflg, 1);
    f_put_logicals(savefile, &hack_1.thfflg, 1);
    f_put_logicals(savefile, &hack_1.thfact, 1);
    f_put_logicals(savefile, &hack_1.swdact, 1);
    f_put_ints(savefile, &hack_1.swdsta, 1);
    f_put_ints(savefile, &puzzle_1.cpvec[0], 64);

    f_put_ints(savefile, &i__, 1);
    f_put_ints(savefile, &play_1.moves, 1);
    f_put_ints(savefile, &play_1.deaths, 1);
    f_put_ints(savefile, &play_1.rwscor, 1);
    f_put_ints(savefile, &play_1.egscor, 1);
    f_put_ints(savefile, &play_1.mxload, 1);
    f_put_ints(savefile, &play_1.ltshft, 1);
    f_put_ints(savefile, &play_1.bloc, 1);
    f_put_ints(savefile, &play_1.mungrm, 1);
    f_put_ints(savefile, &play_1.hs, 1);
    f_put_ints(savefile, &screen_1.fromdr, 1);
    f_put_ints(savefile, &screen_1.scolrm, 1);
    f_put_ints(savefile, &screen_1.scolac, 1);

    f_put_ints(savefile, &objcts_1.odesc1[0], 300);
    f_put_ints(savefile, &objcts_1.odesc2[0], 300);
    f_put_ints(savefile, &objcts_1.oflag1[0], 300);
    f_put_ints(savefile, &objcts_1.oflag2[0], 300);
    f_put_ints(savefile, &objcts_1.ofval[0], 300);
    f_put_ints(savefile, &objcts_1.otval[0], 300);
    f_put_ints(savefile, &objcts_1.osize[0], 300);
    f_put_ints(savefile, &objcts_1.ocapac[0], 300);
    f_put_ints(savefile, &objcts_1.oroom[0], 300);
    f_put_ints(savefile, &objcts_1.oadv[0], 300);
    f_put_ints(savefile, &objcts_1.ocan[0], 300);

    f_put_ints(savefile, &rooms_1.rdesc1[0], 200);
    f_put_ints(savefile, &rooms_1.rval[0], 200);
    f_put_ints(savefile, &rooms_1.rflag[0], 200);
    f_put_ints(savefile, &exits_1.travel[0], 1000);

    f_put_ints(savefile, &advs_1.aroom[0], 4);
    f_put_ints(savefile, &advs_1.ascore[0], 4);
    f_put_ints(savefile, &advs_1.avehic[0], 4);
    f_put_ints(savefile, &advs_1.astren[0], 4);
    f_put_ints(savefile, &advs_1.aflag[0], 4);

    f_put_logicals(savefile, findex_flags, 56);
    f_put_ints(savefile, findex_switches, 24);
    f_put_ints(savefile, &vill_1.vprob[0], 4);
    f_put_logicals(savefile, &cevent_1.cflag[0], 30);
    f_put_ints(savefile, &cevent_1.ctick[0], 30);
    f_put_logicals(savefile, &cevent_1.ccncel[0], 30);

    rspeak_(&c__597);

    glk_stream_close(savefile, NULL);
    return 0;

L100:
    rspeak_(&c__598);
/* cant do it. */
    return 0;
} /* savegm_ */



/* RESTORE- Restore game state */

/* Declarations */

/* Subroutine */ int rstrgm_(void)
{
    /* System generated locals */
    integer i__1;
    frefid_t savefileref;
    strid_t savefile;

    /* Local variables */
    integer i__, j;

    
    if (input_1.sublnt == 0) {
        savefileref = glk_fileref_create_by_prompt(fileusage_SavedGame|fileusage_BinaryMode,
            filemode_Read, 0);
    }
    else {
        char namebuf[128];
        for (i__ = 0; i__ < input_1.sublnt; i__++)
            namebuf[i__] = input_1.subbuf[i__];
        namebuf[input_1.sublnt] = '\0';
        savefileref = glk_fileref_create_by_name(fileusage_SavedGame|fileusage_BinaryMode,
            namebuf, 0);
    }
    if (!savefileref) {
        goto L100;
    }
    savefile = glk_stream_open_file(savefileref, filemode_Read, 0);
    glk_fileref_destroy(savefileref);
    if (!savefile) {
        goto L100;
    }

    f_get_ints(savefile, &i__, 1);
    f_get_ints(savefile, &j, 1);
    if (i__ != misc_1.vmaj || j != misc_1.vmin) {
        goto L200;
    }

    f_get_ints(savefile, &play_1.winner, 1);
    f_get_ints(savefile, &play_1.here, 1);
    f_get_ints(savefile, &hack_1.thfpos, 1);
    f_get_logicals(savefile, &play_1.telflg, 1);
    f_get_logicals(savefile, &hack_1.thfflg, 1);
    f_get_logicals(savefile, &hack_1.thfact, 1);
    f_get_logicals(savefile, &hack_1.swdact, 1);
    f_get_ints(savefile, &hack_1.swdsta, 1);
    f_get_ints(savefile, &puzzle_1.cpvec[0], 64);

    f_get_ints(savefile, &misc_1.pltime, 1);
    f_get_ints(savefile, &play_1.moves, 1);
    f_get_ints(savefile, &play_1.deaths, 1);
    f_get_ints(savefile, &play_1.rwscor, 1);
    f_get_ints(savefile, &play_1.egscor, 1);
    f_get_ints(savefile, &play_1.mxload, 1);
    f_get_ints(savefile, &play_1.ltshft, 1);
    f_get_ints(savefile, &play_1.bloc, 1);
    f_get_ints(savefile, &play_1.mungrm, 1);
    f_get_ints(savefile, &play_1.hs, 1);
    f_get_ints(savefile, &screen_1.fromdr, 1);
    f_get_ints(savefile, &screen_1.scolrm, 1);
    f_get_ints(savefile, &screen_1.scolac, 1);

    f_get_ints(savefile, &objcts_1.odesc1[0], 300);
    f_get_ints(savefile, &objcts_1.odesc2[0], 300);
    f_get_ints(savefile, &objcts_1.oflag1[0], 300);
    f_get_ints(savefile, &objcts_1.oflag2[0], 300);
    f_get_ints(savefile, &objcts_1.ofval[0], 300);
    f_get_ints(savefile, &objcts_1.otval[0], 300);
    f_get_ints(savefile, &objcts_1.osize[0], 300);
    f_get_ints(savefile, &objcts_1.ocapac[0], 300);
    f_get_ints(savefile, &objcts_1.oroom[0], 300);
    f_get_ints(savefile, &objcts_1.oadv[0], 300);
    f_get_ints(savefile, &objcts_1.ocan[0], 300);

    f_get_ints(savefile, &rooms_1.rdesc1[0], 200);
    f_get_ints(savefile, &rooms_1.rval[0], 200);
    f_get_ints(savefile, &rooms_1.rflag[0], 200);
    f_get_ints(savefile, &exits_1.travel[0], 1000);

    f_get_ints(savefile, &advs_1.aroom[0], 4);
    f_get_ints(savefile, &advs_1.ascore[0], 4);
    f_get_ints(savefile, &advs_1.avehic[0], 4);
    f_get_ints(savefile, &advs_1.astren[0], 4);
    f_get_ints(savefile, &advs_1.aflag[0], 4);

    f_get_logicals(savefile, findex_flags, 56);
    f_get_ints(savefile, findex_switches, 24);
    f_get_ints(savefile, &vill_1.vprob[0], 4);
    f_get_logicals(savefile, &cevent_1.cflag[0], 30);
    f_get_ints(savefile, &cevent_1.ctick[0], 30);
    f_get_logicals(savefile, &cevent_1.ccncel[0], 30);

    advs_1.aactio[0] = 0;
    
    rspeak_(&c__599);

    glk_stream_close(savefile, NULL);
    return 0;

L100:
    rspeak_(&c__598);
/* cant do it. */
    return 0;

L200:
    rspeak_(&c__600); /* obsolete version */

    glk_stream_close(savefile, NULL);
    return 0;
} /* rstrgm_ */



/* WALK- Move in specified direction */

/* Declarations */

logical walk_(integer *x)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */


/* Functions and data */

/* WALK, PAGE 2 */

    ret_val = TRUE_;
/* assume wins. */
    if (play_1.winner != 1 || lit_(&play_1.here) || prob_(&c__25, &c__25)) {
        goto L500;
    }
    if (! findxt_(&prsvec_1.prso, &play_1.here)) {
        goto L450;
    }
/* invalid exit? grue! */
    switch (curxt_1.xtype) {
        case 1:  goto L400;
        case 2:  goto L200;
        case 3:  goto L100;
        case 4:  goto L300;
    }
/* decode exit type. */
    bug_(&c__9, &curxt_1.xtype);

L100:
    if (cxappl_(&curxt_1.xactio) != 0) {
        goto L400;
    }
/* cexit... returned room */
    if (findex_flags[(curxt_1.xobj) - 1]) {
        goto L400;
    }
/* no, flag on? */
L200:
    jigsup_(&c__523);
/* bad exit, grue! */
    return ret_val;

L300:
    if (cxappl_(&curxt_1.xactio) != 0) {
        goto L400;
    }
/* door... returned room? */
    if ((objcts_1.oflag2[curxt_1.xobj - 1] & 8) != 0) {
        goto L400;
    }
/* no, door open? */
    jigsup_(&c__523);
/* bad exit, grue! */
    return ret_val;

L400:
    if (lit_(&curxt_1.xroom1)) {
        goto L900;
    }
/* valid room, is it lit? */
L450:
    jigsup_(&c__522);
/* no, grue! */
    return ret_val;

/* Room is lit, or winner is not player (no grue). */

L500:
    if (findxt_(&prsvec_1.prso, &play_1.here)) {
        goto L550;
    }
/* exit exist? */
L525:
    curxt_1.xstrng = 678;
/* assume wall. */
    if (prsvec_1.prso == 9216) {
        curxt_1.xstrng = 679;
    }
/* if up, cant. */
    if (prsvec_1.prso == 10240) {
        curxt_1.xstrng = 680;
    }
/* if down, cant. */
    if ((rooms_1.rflag[play_1.here - 1] & 32) != 0 && play_1.winner == 1) {
        curxt_1.xstrng = 524;
    }
/* no wall for player. */
    rspeak_(&curxt_1.xstrng);
    prsvec_1.prscon = 0;
/* stop cmd stream. */
    return ret_val;

L550:
    switch (curxt_1.xtype) {
        case 1:  goto L900;
        case 2:  goto L600;
        case 3:  goto L700;
        case 4:  goto L800;
    }
/* branch on exit type. */
    bug_(&c__9, &curxt_1.xtype);

L700:
    if (cxappl_(&curxt_1.xactio) != 0) {
        goto L900;
    }
/* cexit... returned room */
    if (findex_flags[(curxt_1.xobj) - 1]) {
        goto L900;
    }
/* no, flag on? */
L600:
    if (curxt_1.xstrng == 0) {
        goto L525;
    }
/* if no reason, use std. */
    rspeak_(&curxt_1.xstrng);
/* deny exit. */
    prsvec_1.prscon = 0;
/* stop cmd stream. */
    return ret_val;

L800:
    if (cxappl_(&curxt_1.xactio) != 0) {
        goto L900;
    }
/* door... returned room? */
    if ((objcts_1.oflag2[curxt_1.xobj - 1] & 8) != 0) {
        goto L900;
    }
/* no, door open? */
    if (curxt_1.xstrng == 0) {
        curxt_1.xstrng = 525;
    }
/* if no reason, use std. */
    rspsub_(&curxt_1.xstrng, &objcts_1.odesc2[curxt_1.xobj - 1]);
    prsvec_1.prscon = 0;
/* stop cmd stream. */
    return ret_val;

L900:
    ret_val = moveto_(&curxt_1.xroom1, &play_1.winner);
/* move to room. */
    if (ret_val) {
        ret_val = rmdesc_(&c__0);
    }
/* describe room. */
    return ret_val;
} /* walk_ */



/* CXAPPL- Conditional exit processors */

/* Declarations */

integer cxappl_(integer *ri)
{
    /* System generated locals */
    integer ret_val, i__1, i__2;

    /* Local variables */
    integer i__, j, ldir;
    integer k;
    integer nxt;


    ret_val = 0;
/* no return. */
    if (*ri == 0) {
        return ret_val;
    }
/* if no action, done. */
    switch (*ri) {
        case 1:  goto L1000;
        case 2:  goto L2000;
        case 3:  goto L3000;
        case 4:  goto L4000;
        case 5:  goto L5000;
        case 6:  goto L6000;
        case 7:  goto L7000;
        case 8:  goto L8000;
        case 9:  goto L9000;
        case 10:  goto L10000;
        case 11:  goto L11000;
        case 12:  goto L12000;
        case 13:  goto L13000;
        case 14:  goto L14000;
        case 15:  goto L15000;
    }
    bug_(&c__5, ri);
/* CXAPPL, PAGE 2 */

/* C1-   Coffin-cure */

L1000:
    findex_1.egyptf = objcts_1.oadv[32] != play_1.winner;
/* t if no coffin. */
    return ret_val;

/* C2-   Carousel exit */
/* C5-   Carousel out */

L2000:
    if (findex_1.caroff) {
        return ret_val;
    }
/* if flipped, nothing. */
L2500:
    rspeak_(&c__121);
/* can't tell directions. */
L5000:
    i__ = curxt_1.xelnt[2] * rnd_(&c__8);
/* choose random exit. */
    curxt_1.xroom1 = exits_1.travel[rooms_1.rexit[play_1.here - 1] + i__ - 1] 
            & 255;
    ret_val = curxt_1.xroom1;
/* return exit. */
    return ret_val;

/* C3-   Chimney function */

L3000:
    findex_1.litldf = FALSE_;
/* assume heavy load. */
    if (findex_1.deadf) {
        goto L3300;
    }
/* if dead, always ok. */
    j = 0;
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* count objects. */
        if (objcts_1.oadv[i__ - 1] == play_1.winner) {
            ++j;
        }
/* L3100: */
    }

    if (j > 2) {
        return ret_val;
    }
/* carrying too much? */
    if (j != 0) {
        goto L3200;
    }
/* carrying too little? */
    curxt_1.xstrng = 890;
/* bad idea. */
    return ret_val;

L3200:
    if (objcts_1.oadv[14] == play_1.winner) {
        goto L3300;
    }
/* no lamp? */
    curxt_1.xstrng = 446;
/* bad idea. */
    return ret_val;

L3300:
    findex_1.litldf = TRUE_;
/* he can do it. */
    if ((objcts_1.oflag2[65] & 8) == 0) {
        objcts_1.oflag2[65] = objcts_1.oflag2[65] & -5;
    }
    return ret_val;

/* C4-   Frobozz flag (Magnet Room, fake exit) */
/* C6-   Frobozz flag (Magnet Room, real exit) */

L4000:
    if (findex_1.caroff) {
        goto L2500;
    }
/* if flipped, go spin. */
    findex_1.frobzf = FALSE_;
/* otherwise, not an exit */
    return ret_val;

L6000:
    if (findex_1.caroff) {
        goto L2500;
    }
/* if flipped, go spin. */
    findex_1.frobzf = TRUE_;
/* otherwise, an exit. */
    return ret_val;
/* CXAPPL, PAGE 3 */

/* C7-   Frobozz flag (bank alarm) */

L7000:
    findex_1.frobzf = FALSE_;
/* assume fails. */
    j = 148;
/* check for bills. */
L7100:
    if (objcts_1.oadv[j - 1] == play_1.winner) {
        return ret_val;
    }
/* winner's got it, fail. */
    j = objcts_1.ocan[j - 1];
/* get container. */
    if (j != 0) {
        goto L7100;
    }
/* if inside, loop */
    j = 149;
/* check for portrait. */
L7200:
    if (objcts_1.oadv[j - 1] == play_1.winner) {
        return ret_val;
    }
/* winner's got it, fail. */
    j = objcts_1.ocan[j - 1];
/* get container. */
    if (j != 0) {
        goto L7200;
    }
/* if inside, loop */
    findex_1.frobzf = TRUE_;
/* wins. */
    return ret_val;

/* C8-   Frobozz flag (MRGO) */

L8000:
    findex_1.frobzf = FALSE_;
/* assume cant move. */
    if (findex_1.mloc != curxt_1.xroom1) {
        goto L8100;
    }
/* mirror in way? */
    if (prsvec_1.prso == 1024 || prsvec_1.prso == 5120) {
        goto L8200;
    }
    if (findex_1.mdir % 180 != 0) {
        goto L8300;
    }
/* mirror must be n-s. */
    curxt_1.xroom1 = ((curxt_1.xroom1 - 161) << 1) + 167;
/* calc east room. */
    if (prsvec_1.prso > 5120) {
        ++curxt_1.xroom1;
    }
/* if sw/nw, calc west. */
L8100:
    ret_val = curxt_1.xroom1;
    return ret_val;

L8200:
    curxt_1.xstrng = 814;
/* assume struc blocks. */
    if (findex_1.mdir % 180 == 0) {
        return ret_val;
    }
/* if mirror n-s, done. */
L8300:
    ldir = findex_1.mdir;
/* see which mirror. */
    if (prsvec_1.prso == 5120) {
        ldir = 180;
    }
    curxt_1.xstrng = 815;
/* mirror blocks. */
    if ((ldir > 180 && ! findex_1.mr1f) || (ldir < 180 && ! findex_1.mr2f)) {
        curxt_1.xstrng = 816;
    }
/* mirror broken. */
    return ret_val;

/* C9-   Frobozz flag (MIRIN) */

L9000:
    if (mrhere_(&play_1.here) != 1) {
        goto L9100;
    }
/* mirror 1 here? */
    if (findex_1.mr1f) {
        curxt_1.xstrng = 805;
    }
/* see if broken. */
    findex_1.frobzf = findex_1.mropnf;
/* enter if open. */
    return ret_val;

L9100:
    findex_1.frobzf = FALSE_;
/* not here, */
    curxt_1.xstrng = 817;
/* lose. */
    return ret_val;
/* CXAPPL, PAGE 4 */

/* C10-  Frobozz flag (mirror exit) */

L10000:
    findex_1.frobzf = FALSE_;
/* assume cant. */
    ldir = (prsvec_1.prso - 1024) / 1024 * 45;
/* xlate dir to degrees. */
    if (! findex_1.mropnf || ((findex_1.mdir + 270) % 360 != ldir && 
            prsvec_1.prso != 14336)) {
        goto L10200;
    }
/* exit via mirror? */
    curxt_1.xroom1 = ((findex_1.mloc - 161) << 1) + 168 - findex_1.mdir / 180;
/* assume e-w exit. */
    if (findex_1.mdir % 180 == 0) {
        goto L10100;
    }
/* if n-s, ok. */
    curxt_1.xroom1 = findex_1.mloc + 1;
/* assume n exit. */
    if (findex_1.mdir > 180) {
        curxt_1.xroom1 = findex_1.mloc - 1;
    }
/* if south. */
L10100:
    ret_val = curxt_1.xroom1;
    return ret_val;

L10200:
    if (! findex_1.wdopnf || ((findex_1.mdir + 180) % 360 != ldir && 
            prsvec_1.prso != 14336)) {
        return ret_val;
    }
/* exit via open door? */
    curxt_1.xroom1 = findex_1.mloc + 1;
/* assume n. */
    if (findex_1.mdir == 0) {
        curxt_1.xroom1 = findex_1.mloc - 1;
    }
/* if s. */
    rspeak_(&c__818);
/* close door. */
    findex_1.wdopnf = FALSE_;
    ret_val = curxt_1.xroom1;
    return ret_val;

/* C11-  Maybe door.  Normal message is that door is closed. */
/*       But if LCELL.NE.4, door isn't there. */

L11000:
    if (findex_1.lcell != 4) {
        curxt_1.xstrng = 678;
    }
/* set up msg. */
    return ret_val;

/* C12-  Frobozz flag (Puzzle Room main entrance) */

L12000:
    findex_1.cphere = 10;
/* set substate. */
    findex_1.frobzf = puzzle_1.cpvec[findex_1.cphere - 1] == 0;
/* enter if not blocked. */
    return ret_val;

/* C13-  CPOUTF (Puzzle Room size entrance) */

L13000:
    findex_1.cphere = 52;
/* set substate. */
    return ret_val;
/* CXAPPL, PAGE 5 */

/* C14-  Frobozz flag (Puzzle Room transitions) */

L14000:
    findex_1.frobzf = FALSE_;
/* asssume lose. */
    if (prsvec_1.prso != 9216) {
        goto L14100;
    }
/* up? */
    if (findex_1.cphere != 10) {
        return ret_val;
    }
/* at exit? */
    curxt_1.xstrng = 881;
/* assume no ladder. */
    if (puzzle_1.cpvec[findex_1.cphere] != -2) {
        return ret_val;
    }
/* ladder here? */
    rspeak_(&c__882);
/* you win. */
    rooms_1.rflag[189] = rooms_1.rflag[189] & -32769;
/* reset seen. */
    findex_1.frobzf = TRUE_;
/* let him out. */
    return ret_val;

L14100:
    if (findex_1.cphere != 52 || prsvec_1.prso != 7168 || ! findex_1.cpoutf) {
        goto L14200;
    }
/* w exit at door? */
    rooms_1.rflag[189] = rooms_1.rflag[189] & -32769;
/* reset seen. */
    findex_1.frobzf = TRUE_;
/* yes, let him out. */
    return ret_val;

L14200:
    if (findex_1.cphere != 52 || prsvec_1.prso != 7168) {
        goto L14250;
    }
    curxt_1.xstrng = 932;
/* door in way. */
    return ret_val;

L14250:
    for (i__ = 1; i__ <= 16; i__ += 2) {
/* locate exit. */
        if (prsvec_1.prso == puzzle_1.cpdr[i__ - 1]) {
            goto L14400;
        }
/* L14300: */
    }
    return ret_val;

/* no such exit. */
L14400:
    j = puzzle_1.cpdr[i__];
/* get directional offset */
    nxt = findex_1.cphere + j;
/* get next state. */
    k = 8;
/* get orthogonal dir. */
    if (j < 0) {
        k = -8;
    }
    if ((abs(j) == 1 || abs(j) == 8 || (puzzle_1.cpvec[findex_1.cphere + k - 
            1] == 0 || puzzle_1.cpvec[nxt - k - 1] == 0)) && puzzle_1.cpvec[
            nxt - 1] == 0) {
        goto L14500;
    }
/* cant do it? */
    return ret_val;

L14500:
    cpgoto_(&nxt);
/* move to state. */
    curxt_1.xroom1 = 190;
/* stay in room. */
    ret_val = curxt_1.xroom1;
    return ret_val;

/* C15-  Frobozz flag (slide exit) */

L15000:
    findex_1.frobzf = TRUE_;
/* works. */
    if (findex_1.ttie == 0 || findex_1.deadf) {
        return ret_val;
    }
/* if no rope or dead, ce */
    if (objcts_1.oroom[findex_1.ttie - 1] != play_1.here) {
        return ret_val;
    }
/* if rope elsewhere, cel */
    rspeak_(&c__1014);
/* slippery. */
    cevent_1.cflag[26] = TRUE_;
/* turn on slide clock. */
/* Computing MAX */
    i__1 = 2, i__2 = 100 / weighr_(&c__0, &play_1.winner);
    cevent_1.ctick[26] = max(i__1,i__2);
    curxt_1.xroom1 = 194;
/* on the ropes. */
    ret_val = curxt_1.xroom1;
    return ret_val;

} /* cxappl_ */


