// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/tasks/v2beta3/cloudtasks.proto

package tasks // import "google.golang.org/genproto/googleapis/cloud/tasks/v2beta3"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import v1 "google.golang.org/genproto/googleapis/iam/v1"
import _ "google.golang.org/genproto/googleapis/rpc/code"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [ListQueues][google.cloud.tasks.v2beta3.CloudTasks.ListQueues].
type ListQueuesRequest struct {
	// Required.
	//
	// The location name.
	// For example: `projects/PROJECT_ID/locations/LOCATION_ID`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// `filter` can be used to specify a subset of queues. Any [Queue][google.cloud.tasks.v2beta3.Queue]
	// field can be used as a filter and several operators as supported.
	// For example: `<=, <, >=, >, !=, =, :`. The filter syntax is the same as
	// described in
	// [Stackdriver's Advanced Logs Filters](https://cloud.google.com/logging/docs/view/advanced_filters).
	//
	// Sample filter "state: PAUSED".
	//
	// Note that using filters might cause fewer queues than the
	// requested page_size to be returned.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size.
	//
	// The maximum page size is 9800. If unspecified, the page size will
	// be the maximum. Fewer queues than requested might be returned,
	// even if more queues exist; use the
	// [next_page_token][google.cloud.tasks.v2beta3.ListQueuesResponse.next_page_token] in the
	// response to determine if more queues exist.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying the page of results to return.
	//
	// To request the first page results, page_token must be empty. To
	// request the next page of results, page_token must be the value of
	// [next_page_token][google.cloud.tasks.v2beta3.ListQueuesResponse.next_page_token] returned
	// from the previous call to [ListQueues][google.cloud.tasks.v2beta3.CloudTasks.ListQueues]
	// method. It is an error to switch the value of the
	// [filter][google.cloud.tasks.v2beta3.ListQueuesRequest.filter] while iterating through pages.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListQueuesRequest) Reset()         { *m = ListQueuesRequest{} }
func (m *ListQueuesRequest) String() string { return proto.CompactTextString(m) }
func (*ListQueuesRequest) ProtoMessage()    {}
func (*ListQueuesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{0}
}
func (m *ListQueuesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListQueuesRequest.Unmarshal(m, b)
}
func (m *ListQueuesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListQueuesRequest.Marshal(b, m, deterministic)
}
func (dst *ListQueuesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListQueuesRequest.Merge(dst, src)
}
func (m *ListQueuesRequest) XXX_Size() int {
	return xxx_messageInfo_ListQueuesRequest.Size(m)
}
func (m *ListQueuesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListQueuesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListQueuesRequest proto.InternalMessageInfo

func (m *ListQueuesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListQueuesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListQueuesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListQueuesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [ListQueues][google.cloud.tasks.v2beta3.CloudTasks.ListQueues].
type ListQueuesResponse struct {
	// The list of queues.
	Queues []*Queue `protobuf:"bytes,1,rep,name=queues,proto3" json:"queues,omitempty"`
	// A token to retrieve next page of results.
	//
	// To return the next page of results, call
	// [ListQueues][google.cloud.tasks.v2beta3.CloudTasks.ListQueues] with this value as the
	// [page_token][google.cloud.tasks.v2beta3.ListQueuesRequest.page_token].
	//
	// If the next_page_token is empty, there are no more results.
	//
	// The page token is valid for only 2 hours.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListQueuesResponse) Reset()         { *m = ListQueuesResponse{} }
func (m *ListQueuesResponse) String() string { return proto.CompactTextString(m) }
func (*ListQueuesResponse) ProtoMessage()    {}
func (*ListQueuesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{1}
}
func (m *ListQueuesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListQueuesResponse.Unmarshal(m, b)
}
func (m *ListQueuesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListQueuesResponse.Marshal(b, m, deterministic)
}
func (dst *ListQueuesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListQueuesResponse.Merge(dst, src)
}
func (m *ListQueuesResponse) XXX_Size() int {
	return xxx_messageInfo_ListQueuesResponse.Size(m)
}
func (m *ListQueuesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListQueuesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListQueuesResponse proto.InternalMessageInfo

func (m *ListQueuesResponse) GetQueues() []*Queue {
	if m != nil {
		return m.Queues
	}
	return nil
}

func (m *ListQueuesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for [GetQueue][google.cloud.tasks.v2beta3.CloudTasks.GetQueue].
type GetQueueRequest struct {
	// Required.
	//
	// The resource name of the queue. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetQueueRequest) Reset()         { *m = GetQueueRequest{} }
func (m *GetQueueRequest) String() string { return proto.CompactTextString(m) }
func (*GetQueueRequest) ProtoMessage()    {}
func (*GetQueueRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{2}
}
func (m *GetQueueRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetQueueRequest.Unmarshal(m, b)
}
func (m *GetQueueRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetQueueRequest.Marshal(b, m, deterministic)
}
func (dst *GetQueueRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetQueueRequest.Merge(dst, src)
}
func (m *GetQueueRequest) XXX_Size() int {
	return xxx_messageInfo_GetQueueRequest.Size(m)
}
func (m *GetQueueRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetQueueRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetQueueRequest proto.InternalMessageInfo

func (m *GetQueueRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [CreateQueue][google.cloud.tasks.v2beta3.CloudTasks.CreateQueue].
type CreateQueueRequest struct {
	// Required.
	//
	// The location name in which the queue will be created.
	// For example: `projects/PROJECT_ID/locations/LOCATION_ID`
	//
	// The list of allowed locations can be obtained by calling Cloud
	// Tasks' implementation of
	// [ListLocations][google.cloud.location.Locations.ListLocations].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The queue to create.
	//
	// [Queue's name][google.cloud.tasks.v2beta3.Queue.name] cannot be the same as an existing queue.
	Queue                *Queue   `protobuf:"bytes,2,opt,name=queue,proto3" json:"queue,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateQueueRequest) Reset()         { *m = CreateQueueRequest{} }
func (m *CreateQueueRequest) String() string { return proto.CompactTextString(m) }
func (*CreateQueueRequest) ProtoMessage()    {}
func (*CreateQueueRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{3}
}
func (m *CreateQueueRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateQueueRequest.Unmarshal(m, b)
}
func (m *CreateQueueRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateQueueRequest.Marshal(b, m, deterministic)
}
func (dst *CreateQueueRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateQueueRequest.Merge(dst, src)
}
func (m *CreateQueueRequest) XXX_Size() int {
	return xxx_messageInfo_CreateQueueRequest.Size(m)
}
func (m *CreateQueueRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateQueueRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateQueueRequest proto.InternalMessageInfo

func (m *CreateQueueRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateQueueRequest) GetQueue() *Queue {
	if m != nil {
		return m.Queue
	}
	return nil
}

// Request message for [UpdateQueue][google.cloud.tasks.v2beta3.CloudTasks.UpdateQueue].
type UpdateQueueRequest struct {
	// Required.
	//
	// The queue to create or update.
	//
	// The queue's [name][google.cloud.tasks.v2beta3.Queue.name] must be specified.
	//
	// Output only fields cannot be modified using UpdateQueue.
	// Any value specified for an output only field will be ignored.
	// The queue's [name][google.cloud.tasks.v2beta3.Queue.name] cannot be changed.
	Queue *Queue `protobuf:"bytes,1,opt,name=queue,proto3" json:"queue,omitempty"`
	// A mask used to specify which fields of the queue are being updated.
	//
	// If empty, then all fields will be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateQueueRequest) Reset()         { *m = UpdateQueueRequest{} }
func (m *UpdateQueueRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateQueueRequest) ProtoMessage()    {}
func (*UpdateQueueRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{4}
}
func (m *UpdateQueueRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateQueueRequest.Unmarshal(m, b)
}
func (m *UpdateQueueRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateQueueRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateQueueRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateQueueRequest.Merge(dst, src)
}
func (m *UpdateQueueRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateQueueRequest.Size(m)
}
func (m *UpdateQueueRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateQueueRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateQueueRequest proto.InternalMessageInfo

func (m *UpdateQueueRequest) GetQueue() *Queue {
	if m != nil {
		return m.Queue
	}
	return nil
}

func (m *UpdateQueueRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [DeleteQueue][google.cloud.tasks.v2beta3.CloudTasks.DeleteQueue].
type DeleteQueueRequest struct {
	// Required.
	//
	// The queue name. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteQueueRequest) Reset()         { *m = DeleteQueueRequest{} }
func (m *DeleteQueueRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteQueueRequest) ProtoMessage()    {}
func (*DeleteQueueRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{5}
}
func (m *DeleteQueueRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteQueueRequest.Unmarshal(m, b)
}
func (m *DeleteQueueRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteQueueRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteQueueRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteQueueRequest.Merge(dst, src)
}
func (m *DeleteQueueRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteQueueRequest.Size(m)
}
func (m *DeleteQueueRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteQueueRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteQueueRequest proto.InternalMessageInfo

func (m *DeleteQueueRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue].
type PurgeQueueRequest struct {
	// Required.
	//
	// The queue name. For example:
	// `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PurgeQueueRequest) Reset()         { *m = PurgeQueueRequest{} }
func (m *PurgeQueueRequest) String() string { return proto.CompactTextString(m) }
func (*PurgeQueueRequest) ProtoMessage()    {}
func (*PurgeQueueRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{6}
}
func (m *PurgeQueueRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PurgeQueueRequest.Unmarshal(m, b)
}
func (m *PurgeQueueRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PurgeQueueRequest.Marshal(b, m, deterministic)
}
func (dst *PurgeQueueRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeQueueRequest.Merge(dst, src)
}
func (m *PurgeQueueRequest) XXX_Size() int {
	return xxx_messageInfo_PurgeQueueRequest.Size(m)
}
func (m *PurgeQueueRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeQueueRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeQueueRequest proto.InternalMessageInfo

func (m *PurgeQueueRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [PauseQueue][google.cloud.tasks.v2beta3.CloudTasks.PauseQueue].
type PauseQueueRequest struct {
	// Required.
	//
	// The queue name. For example:
	// `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PauseQueueRequest) Reset()         { *m = PauseQueueRequest{} }
func (m *PauseQueueRequest) String() string { return proto.CompactTextString(m) }
func (*PauseQueueRequest) ProtoMessage()    {}
func (*PauseQueueRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{7}
}
func (m *PauseQueueRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PauseQueueRequest.Unmarshal(m, b)
}
func (m *PauseQueueRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PauseQueueRequest.Marshal(b, m, deterministic)
}
func (dst *PauseQueueRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PauseQueueRequest.Merge(dst, src)
}
func (m *PauseQueueRequest) XXX_Size() int {
	return xxx_messageInfo_PauseQueueRequest.Size(m)
}
func (m *PauseQueueRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PauseQueueRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PauseQueueRequest proto.InternalMessageInfo

func (m *PauseQueueRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue].
type ResumeQueueRequest struct {
	// Required.
	//
	// The queue name. For example:
	// `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResumeQueueRequest) Reset()         { *m = ResumeQueueRequest{} }
func (m *ResumeQueueRequest) String() string { return proto.CompactTextString(m) }
func (*ResumeQueueRequest) ProtoMessage()    {}
func (*ResumeQueueRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{8}
}
func (m *ResumeQueueRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResumeQueueRequest.Unmarshal(m, b)
}
func (m *ResumeQueueRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResumeQueueRequest.Marshal(b, m, deterministic)
}
func (dst *ResumeQueueRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResumeQueueRequest.Merge(dst, src)
}
func (m *ResumeQueueRequest) XXX_Size() int {
	return xxx_messageInfo_ResumeQueueRequest.Size(m)
}
func (m *ResumeQueueRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResumeQueueRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResumeQueueRequest proto.InternalMessageInfo

func (m *ResumeQueueRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for listing tasks using [ListTasks][google.cloud.tasks.v2beta3.CloudTasks.ListTasks].
type ListTasksRequest struct {
	// Required.
	//
	// The queue name. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The response_view specifies which subset of the [Task][google.cloud.tasks.v2beta3.Task] will be
	// returned.
	//
	// By default response_view is [BASIC][google.cloud.tasks.v2beta3.Task.View.BASIC]; not all
	// information is retrieved by default because some data, such as
	// payloads, might be desirable to return only when needed because
	// of its large size or because of the sensitivity of data that it
	// contains.
	//
	// Authorization for [FULL][google.cloud.tasks.v2beta3.Task.View.FULL] requires
	// `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
	// permission on the [Task][google.cloud.tasks.v2beta3.Task] resource.
	ResponseView Task_View `protobuf:"varint,2,opt,name=response_view,json=responseView,proto3,enum=google.cloud.tasks.v2beta3.Task_View" json:"response_view,omitempty"`
	// Requested page size. Fewer tasks than requested might be returned.
	//
	// The maximum page size is 1000. If unspecified, the page size will
	// be the maximum. Fewer tasks than requested might be returned,
	// even if more tasks exist; use
	// [next_page_token][google.cloud.tasks.v2beta3.ListTasksResponse.next_page_token] in the
	// response to determine if more tasks exist.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying the page of results to return.
	//
	// To request the first page results, page_token must be empty. To
	// request the next page of results, page_token must be the value of
	// [next_page_token][google.cloud.tasks.v2beta3.ListTasksResponse.next_page_token] returned
	// from the previous call to [ListTasks][google.cloud.tasks.v2beta3.CloudTasks.ListTasks]
	// method.
	//
	// The page token is valid for only 2 hours.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTasksRequest) Reset()         { *m = ListTasksRequest{} }
func (m *ListTasksRequest) String() string { return proto.CompactTextString(m) }
func (*ListTasksRequest) ProtoMessage()    {}
func (*ListTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{9}
}
func (m *ListTasksRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTasksRequest.Unmarshal(m, b)
}
func (m *ListTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTasksRequest.Marshal(b, m, deterministic)
}
func (dst *ListTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTasksRequest.Merge(dst, src)
}
func (m *ListTasksRequest) XXX_Size() int {
	return xxx_messageInfo_ListTasksRequest.Size(m)
}
func (m *ListTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTasksRequest proto.InternalMessageInfo

func (m *ListTasksRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTasksRequest) GetResponseView() Task_View {
	if m != nil {
		return m.ResponseView
	}
	return Task_VIEW_UNSPECIFIED
}

func (m *ListTasksRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTasksRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for listing tasks using [ListTasks][google.cloud.tasks.v2beta3.CloudTasks.ListTasks].
type ListTasksResponse struct {
	// The list of tasks.
	Tasks []*Task `protobuf:"bytes,1,rep,name=tasks,proto3" json:"tasks,omitempty"`
	// A token to retrieve next page of results.
	//
	// To return the next page of results, call
	// [ListTasks][google.cloud.tasks.v2beta3.CloudTasks.ListTasks] with this value as the
	// [page_token][google.cloud.tasks.v2beta3.ListTasksRequest.page_token].
	//
	// If the next_page_token is empty, there are no more results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTasksResponse) Reset()         { *m = ListTasksResponse{} }
func (m *ListTasksResponse) String() string { return proto.CompactTextString(m) }
func (*ListTasksResponse) ProtoMessage()    {}
func (*ListTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{10}
}
func (m *ListTasksResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTasksResponse.Unmarshal(m, b)
}
func (m *ListTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTasksResponse.Marshal(b, m, deterministic)
}
func (dst *ListTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTasksResponse.Merge(dst, src)
}
func (m *ListTasksResponse) XXX_Size() int {
	return xxx_messageInfo_ListTasksResponse.Size(m)
}
func (m *ListTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTasksResponse proto.InternalMessageInfo

func (m *ListTasksResponse) GetTasks() []*Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func (m *ListTasksResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for getting a task using [GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
type GetTaskRequest struct {
	// Required.
	//
	// The task name. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The response_view specifies which subset of the [Task][google.cloud.tasks.v2beta3.Task] will be
	// returned.
	//
	// By default response_view is [BASIC][google.cloud.tasks.v2beta3.Task.View.BASIC]; not all
	// information is retrieved by default because some data, such as
	// payloads, might be desirable to return only when needed because
	// of its large size or because of the sensitivity of data that it
	// contains.
	//
	// Authorization for [FULL][google.cloud.tasks.v2beta3.Task.View.FULL] requires
	// `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
	// permission on the [Task][google.cloud.tasks.v2beta3.Task] resource.
	ResponseView         Task_View `protobuf:"varint,2,opt,name=response_view,json=responseView,proto3,enum=google.cloud.tasks.v2beta3.Task_View" json:"response_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *GetTaskRequest) Reset()         { *m = GetTaskRequest{} }
func (m *GetTaskRequest) String() string { return proto.CompactTextString(m) }
func (*GetTaskRequest) ProtoMessage()    {}
func (*GetTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{11}
}
func (m *GetTaskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTaskRequest.Unmarshal(m, b)
}
func (m *GetTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTaskRequest.Marshal(b, m, deterministic)
}
func (dst *GetTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTaskRequest.Merge(dst, src)
}
func (m *GetTaskRequest) XXX_Size() int {
	return xxx_messageInfo_GetTaskRequest.Size(m)
}
func (m *GetTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTaskRequest proto.InternalMessageInfo

func (m *GetTaskRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetTaskRequest) GetResponseView() Task_View {
	if m != nil {
		return m.ResponseView
	}
	return Task_VIEW_UNSPECIFIED
}

// Request message for [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
type CreateTaskRequest struct {
	// Required.
	//
	// The queue name. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
	//
	// The queue must already exist.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The task to add.
	//
	// Task names have the following format:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
	// The user can optionally specify a task [name][google.cloud.tasks.v2beta3.Task.name]. If a
	// name is not specified then the system will generate a random
	// unique task id, which will be set in the task returned in the
	// [response][google.cloud.tasks.v2beta3.Task.name].
	//
	// If [schedule_time][google.cloud.tasks.v2beta3.Task.schedule_time] is not set or is in the
	// past then Cloud Tasks will set it to the current time.
	//
	// Task De-duplication:
	//
	// Explicitly specifying a task ID enables task de-duplication.  If
	// a task's ID is identical to that of an existing task or a task
	// that was deleted or executed recently then the call will fail
	// with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
	// If the task's queue was created using Cloud Tasks, then another task with
	// the same name can't be created for ~1hour after the original task was
	// deleted or executed. If the task's queue was created using queue.yaml or
	// queue.xml, then another task with the same name can't be created
	// for ~9days after the original task was deleted or executed.
	//
	// Because there is an extra lookup cost to identify duplicate task
	// names, these [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask] calls have significantly
	// increased latency. Using hashed strings for the task id or for
	// the prefix of the task id is recommended. Choosing task ids that
	// are sequential or have sequential prefixes, for example using a
	// timestamp, causes an increase in latency and error rates in all
	// task commands. The infrastructure relies on an approximately
	// uniform distribution of task ids to store and serve tasks
	// efficiently.
	Task *Task `protobuf:"bytes,2,opt,name=task,proto3" json:"task,omitempty"`
	// The response_view specifies which subset of the [Task][google.cloud.tasks.v2beta3.Task] will be
	// returned.
	//
	// By default response_view is [BASIC][google.cloud.tasks.v2beta3.Task.View.BASIC]; not all
	// information is retrieved by default because some data, such as
	// payloads, might be desirable to return only when needed because
	// of its large size or because of the sensitivity of data that it
	// contains.
	//
	// Authorization for [FULL][google.cloud.tasks.v2beta3.Task.View.FULL] requires
	// `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
	// permission on the [Task][google.cloud.tasks.v2beta3.Task] resource.
	ResponseView         Task_View `protobuf:"varint,3,opt,name=response_view,json=responseView,proto3,enum=google.cloud.tasks.v2beta3.Task_View" json:"response_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateTaskRequest) Reset()         { *m = CreateTaskRequest{} }
func (m *CreateTaskRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTaskRequest) ProtoMessage()    {}
func (*CreateTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{12}
}
func (m *CreateTaskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTaskRequest.Unmarshal(m, b)
}
func (m *CreateTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTaskRequest.Marshal(b, m, deterministic)
}
func (dst *CreateTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTaskRequest.Merge(dst, src)
}
func (m *CreateTaskRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTaskRequest.Size(m)
}
func (m *CreateTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTaskRequest proto.InternalMessageInfo

func (m *CreateTaskRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTaskRequest) GetTask() *Task {
	if m != nil {
		return m.Task
	}
	return nil
}

func (m *CreateTaskRequest) GetResponseView() Task_View {
	if m != nil {
		return m.ResponseView
	}
	return Task_VIEW_UNSPECIFIED
}

// Request message for deleting a task using
// [DeleteTask][google.cloud.tasks.v2beta3.CloudTasks.DeleteTask].
type DeleteTaskRequest struct {
	// Required.
	//
	// The task name. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTaskRequest) Reset()         { *m = DeleteTaskRequest{} }
func (m *DeleteTaskRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTaskRequest) ProtoMessage()    {}
func (*DeleteTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{13}
}
func (m *DeleteTaskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTaskRequest.Unmarshal(m, b)
}
func (m *DeleteTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTaskRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTaskRequest.Merge(dst, src)
}
func (m *DeleteTaskRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTaskRequest.Size(m)
}
func (m *DeleteTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTaskRequest proto.InternalMessageInfo

func (m *DeleteTaskRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for forcing a task to run now using
// [RunTask][google.cloud.tasks.v2beta3.CloudTasks.RunTask].
type RunTaskRequest struct {
	// Required.
	//
	// The task name. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The response_view specifies which subset of the [Task][google.cloud.tasks.v2beta3.Task] will be
	// returned.
	//
	// By default response_view is [BASIC][google.cloud.tasks.v2beta3.Task.View.BASIC]; not all
	// information is retrieved by default because some data, such as
	// payloads, might be desirable to return only when needed because
	// of its large size or because of the sensitivity of data that it
	// contains.
	//
	// Authorization for [FULL][google.cloud.tasks.v2beta3.Task.View.FULL] requires
	// `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
	// permission on the [Task][google.cloud.tasks.v2beta3.Task] resource.
	ResponseView         Task_View `protobuf:"varint,2,opt,name=response_view,json=responseView,proto3,enum=google.cloud.tasks.v2beta3.Task_View" json:"response_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *RunTaskRequest) Reset()         { *m = RunTaskRequest{} }
func (m *RunTaskRequest) String() string { return proto.CompactTextString(m) }
func (*RunTaskRequest) ProtoMessage()    {}
func (*RunTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloudtasks_f9775ddf05248897, []int{14}
}
func (m *RunTaskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunTaskRequest.Unmarshal(m, b)
}
func (m *RunTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunTaskRequest.Marshal(b, m, deterministic)
}
func (dst *RunTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunTaskRequest.Merge(dst, src)
}
func (m *RunTaskRequest) XXX_Size() int {
	return xxx_messageInfo_RunTaskRequest.Size(m)
}
func (m *RunTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunTaskRequest proto.InternalMessageInfo

func (m *RunTaskRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RunTaskRequest) GetResponseView() Task_View {
	if m != nil {
		return m.ResponseView
	}
	return Task_VIEW_UNSPECIFIED
}

func init() {
	proto.RegisterType((*ListQueuesRequest)(nil), "google.cloud.tasks.v2beta3.ListQueuesRequest")
	proto.RegisterType((*ListQueuesResponse)(nil), "google.cloud.tasks.v2beta3.ListQueuesResponse")
	proto.RegisterType((*GetQueueRequest)(nil), "google.cloud.tasks.v2beta3.GetQueueRequest")
	proto.RegisterType((*CreateQueueRequest)(nil), "google.cloud.tasks.v2beta3.CreateQueueRequest")
	proto.RegisterType((*UpdateQueueRequest)(nil), "google.cloud.tasks.v2beta3.UpdateQueueRequest")
	proto.RegisterType((*DeleteQueueRequest)(nil), "google.cloud.tasks.v2beta3.DeleteQueueRequest")
	proto.RegisterType((*PurgeQueueRequest)(nil), "google.cloud.tasks.v2beta3.PurgeQueueRequest")
	proto.RegisterType((*PauseQueueRequest)(nil), "google.cloud.tasks.v2beta3.PauseQueueRequest")
	proto.RegisterType((*ResumeQueueRequest)(nil), "google.cloud.tasks.v2beta3.ResumeQueueRequest")
	proto.RegisterType((*ListTasksRequest)(nil), "google.cloud.tasks.v2beta3.ListTasksRequest")
	proto.RegisterType((*ListTasksResponse)(nil), "google.cloud.tasks.v2beta3.ListTasksResponse")
	proto.RegisterType((*GetTaskRequest)(nil), "google.cloud.tasks.v2beta3.GetTaskRequest")
	proto.RegisterType((*CreateTaskRequest)(nil), "google.cloud.tasks.v2beta3.CreateTaskRequest")
	proto.RegisterType((*DeleteTaskRequest)(nil), "google.cloud.tasks.v2beta3.DeleteTaskRequest")
	proto.RegisterType((*RunTaskRequest)(nil), "google.cloud.tasks.v2beta3.RunTaskRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CloudTasksClient is the client API for CloudTasks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudTasksClient interface {
	// Lists queues.
	//
	// Queues are returned in lexicographical order.
	ListQueues(ctx context.Context, in *ListQueuesRequest, opts ...grpc.CallOption) (*ListQueuesResponse, error)
	// Gets a queue.
	GetQueue(ctx context.Context, in *GetQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Creates a queue.
	//
	// Queues created with this method allow tasks to live for a maximum of 31
	// days. After a task is 31 days old, the task will be deleted regardless of whether
	// it was dispatched or not.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml)
	// before using this method.
	CreateQueue(ctx context.Context, in *CreateQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Updates a queue.
	//
	// This method creates the queue if it does not exist and updates
	// the queue if it does exist.
	//
	// Queues created with this method allow tasks to live for a maximum of 31
	// days. After a task is 31 days old, the task will be deleted regardless of whether
	// it was dispatched or not.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml)
	// before using this method.
	UpdateQueue(ctx context.Context, in *UpdateQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Deletes a queue.
	//
	// This command will delete the queue even if it has tasks in it.
	//
	// Note: If you delete a queue, a queue with the same name can't be created
	// for 7 days.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml)
	// before using this method.
	DeleteQueue(ctx context.Context, in *DeleteQueueRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Purges a queue by deleting all of its tasks.
	//
	// All tasks created before this method is called are permanently deleted.
	//
	// Purge operations can take up to one minute to take effect. Tasks
	// might be dispatched before the purge takes effect. A purge is irreversible.
	PurgeQueue(ctx context.Context, in *PurgeQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Pauses the queue.
	//
	// If a queue is paused then the system will stop dispatching tasks
	// until the queue is resumed via
	// [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue]. Tasks can still be added
	// when the queue is paused. A queue is paused if its
	// [state][google.cloud.tasks.v2beta3.Queue.state] is [PAUSED][google.cloud.tasks.v2beta3.Queue.State.PAUSED].
	PauseQueue(ctx context.Context, in *PauseQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Resume a queue.
	//
	// This method resumes a queue after it has been
	// [PAUSED][google.cloud.tasks.v2beta3.Queue.State.PAUSED] or
	// [DISABLED][google.cloud.tasks.v2beta3.Queue.State.DISABLED]. The state of a queue is stored
	// in the queue's [state][google.cloud.tasks.v2beta3.Queue.state]; after calling this method it
	// will be set to [RUNNING][google.cloud.tasks.v2beta3.Queue.State.RUNNING].
	//
	// WARNING: Resuming many high-QPS queues at the same time can
	// lead to target overloading. If you are resuming high-QPS
	// queues, follow the 500/50/5 pattern described in
	// [Managing Cloud Tasks Scaling Risks](https://cloud.google.com/tasks/docs/manage-cloud-task-scaling).
	ResumeQueue(ctx context.Context, in *ResumeQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Gets the access control policy for a [Queue][google.cloud.tasks.v2beta3.Queue].
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	//
	// Authorization requires the following
	// [Google IAM](https://cloud.google.com/iam) permission on the specified
	// resource parent:
	//
	// * `cloudtasks.queues.getIamPolicy`
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the access control policy for a [Queue][google.cloud.tasks.v2beta3.Queue]. Replaces any existing
	// policy.
	//
	// Note: The Cloud Console does not check queue-level IAM permissions yet.
	// Project-level permissions are required to use the Cloud Console.
	//
	// Authorization requires the following
	// [Google IAM](https://cloud.google.com/iam) permission on the specified
	// resource parent:
	//
	// * `cloudtasks.queues.setIamPolicy`
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has on a [Queue][google.cloud.tasks.v2beta3.Queue].
	// If the resource does not exist, this will return an empty set of
	// permissions, not a [NOT_FOUND][google.rpc.Code.NOT_FOUND] error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Lists the tasks in a queue.
	//
	// By default, only the [BASIC][google.cloud.tasks.v2beta3.Task.View.BASIC] view is retrieved
	// due to performance considerations;
	// [response_view][google.cloud.tasks.v2beta3.ListTasksRequest.response_view] controls the
	// subset of information which is returned.
	//
	// The tasks may be returned in any order. The ordering may change at any
	// time.
	ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error)
	// Gets a task.
	GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Creates a task and adds it to a queue.
	//
	// Tasks cannot be updated after creation; there is no UpdateTask command.
	//
	// * For [App Engine queues][google.cloud.tasks.v2beta3.AppEngineHttpQueue], the maximum task size is
	//   100KB.
	CreateTask(ctx context.Context, in *CreateTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Deletes a task.
	//
	// A task can be deleted if it is scheduled or dispatched. A task
	// cannot be deleted if it has executed successfully or permanently
	// failed.
	DeleteTask(ctx context.Context, in *DeleteTaskRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Forces a task to run now.
	//
	// When this method is called, Cloud Tasks will dispatch the task, even if
	// the task is already running, the queue has reached its [RateLimits][google.cloud.tasks.v2beta3.RateLimits] or
	// is [PAUSED][google.cloud.tasks.v2beta3.Queue.State.PAUSED].
	//
	// This command is meant to be used for manual debugging. For
	// example, [RunTask][google.cloud.tasks.v2beta3.CloudTasks.RunTask] can be used to retry a failed
	// task after a fix has been made or to manually force a task to be
	// dispatched now.
	//
	// The dispatched task is returned. That is, the task that is returned
	// contains the [status][Task.status] after the task is dispatched but
	// before the task is received by its target.
	//
	// If Cloud Tasks receives a successful response from the task's
	// target, then the task will be deleted; otherwise the task's
	// [schedule_time][google.cloud.tasks.v2beta3.Task.schedule_time] will be reset to the time that
	// [RunTask][google.cloud.tasks.v2beta3.CloudTasks.RunTask] was called plus the retry delay specified
	// in the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
	//
	// [RunTask][google.cloud.tasks.v2beta3.CloudTasks.RunTask] returns
	// [NOT_FOUND][google.rpc.Code.NOT_FOUND] when it is called on a
	// task that has already succeeded or permanently failed.
	RunTask(ctx context.Context, in *RunTaskRequest, opts ...grpc.CallOption) (*Task, error)
}

type cloudTasksClient struct {
	cc *grpc.ClientConn
}

func NewCloudTasksClient(cc *grpc.ClientConn) CloudTasksClient {
	return &cloudTasksClient{cc}
}

func (c *cloudTasksClient) ListQueues(ctx context.Context, in *ListQueuesRequest, opts ...grpc.CallOption) (*ListQueuesResponse, error) {
	out := new(ListQueuesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/ListQueues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) GetQueue(ctx context.Context, in *GetQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/GetQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) CreateQueue(ctx context.Context, in *CreateQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/CreateQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) UpdateQueue(ctx context.Context, in *UpdateQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/UpdateQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) DeleteQueue(ctx context.Context, in *DeleteQueueRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/DeleteQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) PurgeQueue(ctx context.Context, in *PurgeQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/PurgeQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) PauseQueue(ctx context.Context, in *PauseQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/PauseQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) ResumeQueue(ctx context.Context, in *ResumeQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/ResumeQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error) {
	out := new(ListTasksResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/ListTasks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/GetTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) CreateTask(ctx context.Context, in *CreateTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/CreateTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) DeleteTask(ctx context.Context, in *DeleteTaskRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/DeleteTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) RunTask(ctx context.Context, in *RunTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2beta3.CloudTasks/RunTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudTasksServer is the server API for CloudTasks service.
type CloudTasksServer interface {
	// Lists queues.
	//
	// Queues are returned in lexicographical order.
	ListQueues(context.Context, *ListQueuesRequest) (*ListQueuesResponse, error)
	// Gets a queue.
	GetQueue(context.Context, *GetQueueRequest) (*Queue, error)
	// Creates a queue.
	//
	// Queues created with this method allow tasks to live for a maximum of 31
	// days. After a task is 31 days old, the task will be deleted regardless of whether
	// it was dispatched or not.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml)
	// before using this method.
	CreateQueue(context.Context, *CreateQueueRequest) (*Queue, error)
	// Updates a queue.
	//
	// This method creates the queue if it does not exist and updates
	// the queue if it does exist.
	//
	// Queues created with this method allow tasks to live for a maximum of 31
	// days. After a task is 31 days old, the task will be deleted regardless of whether
	// it was dispatched or not.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml)
	// before using this method.
	UpdateQueue(context.Context, *UpdateQueueRequest) (*Queue, error)
	// Deletes a queue.
	//
	// This command will delete the queue even if it has tasks in it.
	//
	// Note: If you delete a queue, a queue with the same name can't be created
	// for 7 days.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml)
	// before using this method.
	DeleteQueue(context.Context, *DeleteQueueRequest) (*empty.Empty, error)
	// Purges a queue by deleting all of its tasks.
	//
	// All tasks created before this method is called are permanently deleted.
	//
	// Purge operations can take up to one minute to take effect. Tasks
	// might be dispatched before the purge takes effect. A purge is irreversible.
	PurgeQueue(context.Context, *PurgeQueueRequest) (*Queue, error)
	// Pauses the queue.
	//
	// If a queue is paused then the system will stop dispatching tasks
	// until the queue is resumed via
	// [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue]. Tasks can still be added
	// when the queue is paused. A queue is paused if its
	// [state][google.cloud.tasks.v2beta3.Queue.state] is [PAUSED][google.cloud.tasks.v2beta3.Queue.State.PAUSED].
	PauseQueue(context.Context, *PauseQueueRequest) (*Queue, error)
	// Resume a queue.
	//
	// This method resumes a queue after it has been
	// [PAUSED][google.cloud.tasks.v2beta3.Queue.State.PAUSED] or
	// [DISABLED][google.cloud.tasks.v2beta3.Queue.State.DISABLED]. The state of a queue is stored
	// in the queue's [state][google.cloud.tasks.v2beta3.Queue.state]; after calling this method it
	// will be set to [RUNNING][google.cloud.tasks.v2beta3.Queue.State.RUNNING].
	//
	// WARNING: Resuming many high-QPS queues at the same time can
	// lead to target overloading. If you are resuming high-QPS
	// queues, follow the 500/50/5 pattern described in
	// [Managing Cloud Tasks Scaling Risks](https://cloud.google.com/tasks/docs/manage-cloud-task-scaling).
	ResumeQueue(context.Context, *ResumeQueueRequest) (*Queue, error)
	// Gets the access control policy for a [Queue][google.cloud.tasks.v2beta3.Queue].
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	//
	// Authorization requires the following
	// [Google IAM](https://cloud.google.com/iam) permission on the specified
	// resource parent:
	//
	// * `cloudtasks.queues.getIamPolicy`
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the access control policy for a [Queue][google.cloud.tasks.v2beta3.Queue]. Replaces any existing
	// policy.
	//
	// Note: The Cloud Console does not check queue-level IAM permissions yet.
	// Project-level permissions are required to use the Cloud Console.
	//
	// Authorization requires the following
	// [Google IAM](https://cloud.google.com/iam) permission on the specified
	// resource parent:
	//
	// * `cloudtasks.queues.setIamPolicy`
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has on a [Queue][google.cloud.tasks.v2beta3.Queue].
	// If the resource does not exist, this will return an empty set of
	// permissions, not a [NOT_FOUND][google.rpc.Code.NOT_FOUND] error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Lists the tasks in a queue.
	//
	// By default, only the [BASIC][google.cloud.tasks.v2beta3.Task.View.BASIC] view is retrieved
	// due to performance considerations;
	// [response_view][google.cloud.tasks.v2beta3.ListTasksRequest.response_view] controls the
	// subset of information which is returned.
	//
	// The tasks may be returned in any order. The ordering may change at any
	// time.
	ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error)
	// Gets a task.
	GetTask(context.Context, *GetTaskRequest) (*Task, error)
	// Creates a task and adds it to a queue.
	//
	// Tasks cannot be updated after creation; there is no UpdateTask command.
	//
	// * For [App Engine queues][google.cloud.tasks.v2beta3.AppEngineHttpQueue], the maximum task size is
	//   100KB.
	CreateTask(context.Context, *CreateTaskRequest) (*Task, error)
	// Deletes a task.
	//
	// A task can be deleted if it is scheduled or dispatched. A task
	// cannot be deleted if it has executed successfully or permanently
	// failed.
	DeleteTask(context.Context, *DeleteTaskRequest) (*empty.Empty, error)
	// Forces a task to run now.
	//
	// When this method is called, Cloud Tasks will dispatch the task, even if
	// the task is already running, the queue has reached its [RateLimits][google.cloud.tasks.v2beta3.RateLimits] or
	// is [PAUSED][google.cloud.tasks.v2beta3.Queue.State.PAUSED].
	//
	// This command is meant to be used for manual debugging. For
	// example, [RunTask][google.cloud.tasks.v2beta3.CloudTasks.RunTask] can be used to retry a failed
	// task after a fix has been made or to manually force a task to be
	// dispatched now.
	//
	// The dispatched task is returned. That is, the task that is returned
	// contains the [status][Task.status] after the task is dispatched but
	// before the task is received by its target.
	//
	// If Cloud Tasks receives a successful response from the task's
	// target, then the task will be deleted; otherwise the task's
	// [schedule_time][google.cloud.tasks.v2beta3.Task.schedule_time] will be reset to the time that
	// [RunTask][google.cloud.tasks.v2beta3.CloudTasks.RunTask] was called plus the retry delay specified
	// in the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
	//
	// [RunTask][google.cloud.tasks.v2beta3.CloudTasks.RunTask] returns
	// [NOT_FOUND][google.rpc.Code.NOT_FOUND] when it is called on a
	// task that has already succeeded or permanently failed.
	RunTask(context.Context, *RunTaskRequest) (*Task, error)
}

func RegisterCloudTasksServer(s *grpc.Server, srv CloudTasksServer) {
	s.RegisterService(&_CloudTasks_serviceDesc, srv)
}

func _CloudTasks_ListQueues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQueuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).ListQueues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/ListQueues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).ListQueues(ctx, req.(*ListQueuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_GetQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).GetQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/GetQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).GetQueue(ctx, req.(*GetQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_CreateQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).CreateQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/CreateQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).CreateQueue(ctx, req.(*CreateQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_UpdateQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).UpdateQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/UpdateQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).UpdateQueue(ctx, req.(*UpdateQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_DeleteQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).DeleteQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/DeleteQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).DeleteQueue(ctx, req.(*DeleteQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_PurgeQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).PurgeQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/PurgeQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).PurgeQueue(ctx, req.(*PurgeQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_PauseQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).PauseQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/PauseQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).PauseQueue(ctx, req.(*PauseQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_ResumeQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).ResumeQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/ResumeQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).ResumeQueue(ctx, req.(*ResumeQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_ListTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).ListTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/ListTasks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).ListTasks(ctx, req.(*ListTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_GetTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).GetTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/GetTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).GetTask(ctx, req.(*GetTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_CreateTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).CreateTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/CreateTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).CreateTask(ctx, req.(*CreateTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_DeleteTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).DeleteTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/DeleteTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).DeleteTask(ctx, req.(*DeleteTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_RunTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).RunTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2beta3.CloudTasks/RunTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).RunTask(ctx, req.(*RunTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudTasks_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.tasks.v2beta3.CloudTasks",
	HandlerType: (*CloudTasksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListQueues",
			Handler:    _CloudTasks_ListQueues_Handler,
		},
		{
			MethodName: "GetQueue",
			Handler:    _CloudTasks_GetQueue_Handler,
		},
		{
			MethodName: "CreateQueue",
			Handler:    _CloudTasks_CreateQueue_Handler,
		},
		{
			MethodName: "UpdateQueue",
			Handler:    _CloudTasks_UpdateQueue_Handler,
		},
		{
			MethodName: "DeleteQueue",
			Handler:    _CloudTasks_DeleteQueue_Handler,
		},
		{
			MethodName: "PurgeQueue",
			Handler:    _CloudTasks_PurgeQueue_Handler,
		},
		{
			MethodName: "PauseQueue",
			Handler:    _CloudTasks_PauseQueue_Handler,
		},
		{
			MethodName: "ResumeQueue",
			Handler:    _CloudTasks_ResumeQueue_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _CloudTasks_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _CloudTasks_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _CloudTasks_TestIamPermissions_Handler,
		},
		{
			MethodName: "ListTasks",
			Handler:    _CloudTasks_ListTasks_Handler,
		},
		{
			MethodName: "GetTask",
			Handler:    _CloudTasks_GetTask_Handler,
		},
		{
			MethodName: "CreateTask",
			Handler:    _CloudTasks_CreateTask_Handler,
		},
		{
			MethodName: "DeleteTask",
			Handler:    _CloudTasks_DeleteTask_Handler,
		},
		{
			MethodName: "RunTask",
			Handler:    _CloudTasks_RunTask_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/tasks/v2beta3/cloudtasks.proto",
}

func init() {
	proto.RegisterFile("google/cloud/tasks/v2beta3/cloudtasks.proto", fileDescriptor_cloudtasks_f9775ddf05248897)
}

var fileDescriptor_cloudtasks_f9775ddf05248897 = []byte{
	// 1102 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x98, 0x5b, 0x6f, 0xdc, 0x44,
	0x14, 0xc7, 0x35, 0xb9, 0xb5, 0x39, 0xdb, 0x36, 0x64, 0x44, 0xab, 0x95, 0x0b, 0xd5, 0x62, 0x29,
	0xed, 0xe2, 0x52, 0x5b, 0xd9, 0xd2, 0x86, 0x6e, 0xa0, 0x4d, 0xd3, 0x36, 0x11, 0x04, 0xa4, 0xad,
	0x37, 0xf0, 0xc0, 0xcb, 0xca, 0xd9, 0x4c, 0x2c, 0x93, 0xf5, 0xa5, 0x1e, 0x3b, 0x81, 0x42, 0x84,
	0xc4, 0x23, 0x0f, 0xbc, 0x14, 0x21, 0xde, 0xb8, 0x0a, 0xc4, 0x03, 0x2f, 0x3c, 0xf3, 0x2d, 0xf8,
	0x0a, 0x7c, 0x10, 0x34, 0x17, 0xaf, 0x9d, 0x75, 0xd6, 0x76, 0x16, 0xe8, 0x53, 0x76, 0xe6, 0xfc,
	0x67, 0xce, 0xcf, 0x67, 0x8e, 0xe7, 0x1c, 0x07, 0xae, 0xdb, 0xbe, 0x6f, 0x0f, 0x88, 0xd1, 0x1f,
	0xf8, 0xf1, 0xae, 0x11, 0x59, 0x74, 0x9f, 0x1a, 0x07, 0xad, 0x1d, 0x12, 0x59, 0x37, 0xc5, 0x1c,
	0x9f, 0xd2, 0x83, 0xd0, 0x8f, 0x7c, 0xac, 0x08, 0xb1, 0xce, 0x0d, 0xba, 0xb0, 0x48, 0xb1, 0xf2,
	0x92, 0xdc, 0xc8, 0x0a, 0x1c, 0xc3, 0xf2, 0x3c, 0x3f, 0xb2, 0x22, 0xc7, 0xf7, 0xe4, 0x4a, 0xe5,
	0x6a, 0x81, 0x9b, 0x27, 0x31, 0x89, 0x89, 0xd4, 0x2d, 0x15, 0xe8, 0xd8, 0x48, 0xca, 0xae, 0x48,
	0x99, 0x63, 0xb9, 0xc6, 0xc1, 0x32, 0xfb, 0xd3, 0x0b, 0xfc, 0x81, 0xd3, 0xff, 0x44, 0xda, 0x95,
	0xe3, 0xf6, 0x63, 0xb6, 0xcb, 0xd2, 0xc6, 0x47, 0x3b, 0xf1, 0x9e, 0x41, 0xdc, 0x20, 0x4a, 0x8c,
	0x8d, 0x51, 0xe3, 0x9e, 0x43, 0x06, 0xbb, 0x3d, 0x37, 0x75, 0x7d, 0x51, 0x2a, 0xc2, 0xa0, 0x6f,
	0xf4, 0xfd, 0x5d, 0x09, 0xae, 0x7e, 0x0e, 0x8b, 0xef, 0x3a, 0x34, 0x7a, 0xcc, 0x9e, 0x85, 0x9a,
	0xe4, 0x49, 0x4c, 0x68, 0x84, 0x2f, 0xc1, 0x5c, 0x60, 0x85, 0xc4, 0x8b, 0xea, 0xa8, 0x81, 0x9a,
	0xf3, 0xa6, 0x1c, 0xb1, 0xf9, 0x3d, 0x67, 0x10, 0x91, 0xb0, 0x3e, 0x25, 0xe6, 0xc5, 0x08, 0x5f,
	0x86, 0xf9, 0xc0, 0xb2, 0x49, 0x8f, 0x3a, 0x4f, 0x49, 0x7d, 0xba, 0x81, 0x9a, 0xb3, 0xe6, 0x59,
	0x36, 0xd1, 0x75, 0x9e, 0x12, 0xfc, 0x32, 0x00, 0x37, 0x46, 0xfe, 0x3e, 0xf1, 0xea, 0x33, 0x7c,
	0x21, 0x97, 0x6f, 0xb3, 0x09, 0xf5, 0x10, 0x70, 0x16, 0x80, 0x06, 0xbe, 0x47, 0x09, 0xbe, 0x03,
	0x73, 0x3c, 0xbc, 0xb4, 0x8e, 0x1a, 0xd3, 0xcd, 0x5a, 0xeb, 0x15, 0x7d, 0xfc, 0x11, 0xea, 0x7c,
	0xad, 0x29, 0x17, 0xe0, 0xab, 0xb0, 0xe0, 0x91, 0x8f, 0xa3, 0x5e, 0xc6, 0xa9, 0xa0, 0x3d, 0xcf,
	0xa6, 0x3b, 0x43, 0xc7, 0x4b, 0xb0, 0xb0, 0x49, 0x84, 0xdf, 0xe4, 0xb9, 0x31, 0xcc, 0x78, 0x96,
	0x4b, 0xe4, 0x53, 0xf3, 0xdf, 0x2a, 0x01, 0xfc, 0x20, 0x24, 0x56, 0x44, 0x8e, 0x29, 0xc7, 0x45,
	0x68, 0x05, 0x66, 0x39, 0x06, 0x77, 0x59, 0x09, 0x5b, 0xe8, 0xd5, 0x2f, 0x11, 0xe0, 0xf7, 0x83,
	0xdd, 0x51, 0x3f, 0xc3, 0xfd, 0xd0, 0xe9, 0xf6, 0xc3, 0xab, 0x50, 0x8b, 0xf9, 0x76, 0x3c, 0x07,
	0x24, 0x8e, 0x92, 0x2c, 0x4f, 0xd2, 0x44, 0xdf, 0x60, 0x69, 0xf2, 0x9e, 0x45, 0xf7, 0x4d, 0x10,
	0x72, 0xf6, 0x5b, 0x6d, 0x02, 0x7e, 0x48, 0x06, 0x64, 0x84, 0xe5, 0xa4, 0xe8, 0x5c, 0x83, 0xc5,
	0x4e, 0x1c, 0xda, 0xd5, 0x84, 0x56, 0x4c, 0xcb, 0x85, 0x4d, 0xc0, 0x26, 0xa1, 0xb1, 0x5b, 0xae,
	0xfc, 0x03, 0xc1, 0x0b, 0x2c, 0x75, 0xb6, 0x59, 0x14, 0xca, 0x0e, 0xe6, 0x1d, 0x38, 0x1f, 0xca,
	0xe4, 0xea, 0x1d, 0x38, 0xe4, 0x90, 0x47, 0xe4, 0x42, 0x6b, 0xa9, 0x28, 0xa0, 0x6c, 0x63, 0xfd,
	0x03, 0x87, 0x1c, 0x9a, 0xe7, 0x92, 0xb5, 0x6c, 0xf4, 0xaf, 0xd2, 0x9d, 0x8a, 0xf7, 0x4d, 0x32,
	0xcb, 0x6c, 0xbf, 0x0d, 0xb3, 0xdc, 0xb3, 0x4c, 0xf6, 0x46, 0x19, 0x94, 0x29, 0xe4, 0x95, 0x53,
	0x3d, 0x80, 0x0b, 0x9b, 0x84, 0xfb, 0x2c, 0x88, 0xe7, 0x7f, 0x19, 0x22, 0xf5, 0x77, 0x04, 0x8b,
	0xe2, 0xb5, 0xc9, 0x7a, 0x1d, 0x77, 0x38, 0xaf, 0xc3, 0x4c, 0x94, 0x66, 0x69, 0xf9, 0xe3, 0x73,
	0x75, 0x9e, 0x77, 0x7a, 0x72, 0xde, 0x6b, 0xb0, 0x28, 0x32, 0xbe, 0x24, 0x48, 0x2c, 0x94, 0x66,
	0xec, 0x3d, 0xc7, 0x50, 0xb6, 0x7e, 0x7d, 0x11, 0xe0, 0x01, 0xd3, 0xf3, 0x9c, 0xc1, 0x3f, 0x23,
	0x80, 0xf4, 0xc2, 0xc4, 0x37, 0x8a, 0xb6, 0xcc, 0xdd, 0xec, 0x8a, 0x5e, 0x55, 0x2e, 0x00, 0xd4,
	0x95, 0x2f, 0xfe, 0xfa, 0xfb, 0xd9, 0xd4, 0x32, 0x36, 0x86, 0xd5, 0xec, 0x53, 0x71, 0x66, 0x6f,
	0x05, 0xa1, 0xff, 0x11, 0xe9, 0x47, 0xd4, 0xd0, 0x8c, 0x81, 0xdf, 0x17, 0x45, 0xd3, 0xd0, 0x8e,
	0x0c, 0x79, 0x0b, 0x3f, 0x43, 0x70, 0x36, 0xb9, 0x5e, 0xf1, 0xf5, 0x22, 0xaf, 0x23, 0x97, 0xb0,
	0x52, 0x7e, 0xc7, 0x9d, 0x44, 0xc5, 0xc2, 0x3e, 0x86, 0x49, 0x22, 0x19, 0xda, 0x11, 0xfe, 0x1e,
	0x41, 0x2d, 0x73, 0x9b, 0xe3, 0xc2, 0x70, 0xe4, 0xaf, 0xfd, 0x2a, 0x6c, 0x77, 0x39, 0xdb, 0x1b,
	0xea, 0x69, 0x23, 0xd6, 0x96, 0x17, 0xf7, 0x2f, 0x08, 0x6a, 0x99, 0x42, 0x50, 0x8c, 0x98, 0xaf,
	0x18, 0x55, 0x10, 0x1f, 0x72, 0xc4, 0xbb, 0xad, 0x5b, 0x29, 0xa2, 0xe8, 0x65, 0x2a, 0x05, 0x31,
	0x01, 0xfd, 0x0a, 0x41, 0x2d, 0x53, 0x25, 0x8a, 0x41, 0xf3, 0xe5, 0x44, 0xb9, 0x94, 0x2b, 0x46,
	0x8f, 0x58, 0x43, 0x93, 0x1c, 0xae, 0x36, 0xc9, 0xe1, 0x42, 0x5a, 0x8c, 0x8a, 0xdf, 0x8c, 0x5c,
	0xd1, 0xaa, 0x12, 0xb7, 0x35, 0x4e, 0xd6, 0x56, 0x6f, 0x9d, 0x92, 0xac, 0x1d, 0x30, 0x6f, 0x6d,
	0xa4, 0x09, 0xc4, 0x61, 0x19, 0x2c, 0x41, 0x1c, 0x2d, 0x97, 0xff, 0x2f, 0x22, 0xf3, 0xc6, 0x10,
	0x7f, 0x42, 0x50, 0xcb, 0x14, 0xe0, 0xe2, 0x63, 0xcd, 0x57, 0xea, 0x2a, 0x90, 0xf7, 0x39, 0xe4,
	0xaa, 0x7a, 0xfb, 0xb4, 0x90, 0x21, 0x77, 0xc7, 0x28, 0xbf, 0x41, 0x70, 0x6e, 0x93, 0x44, 0x6f,
	0x5b, 0x6e, 0x87, 0xf7, 0xc8, 0x58, 0x4d, 0xdc, 0x3a, 0x96, 0xab, 0x1f, 0x2c, 0xeb, 0x59, 0x63,
	0x82, 0x76, 0x71, 0x44, 0x23, 0xac, 0xea, 0x16, 0xc7, 0x79, 0xa4, 0xae, 0xa5, 0x38, 0x21, 0xa1,
	0x7e, 0x1c, 0xf6, 0x2b, 0x20, 0xd9, 0x19, 0x3f, 0x09, 0x58, 0xb7, 0x08, 0xac, 0xfb, 0x9c, 0xc0,
	0xe8, 0x08, 0xd8, 0x9f, 0x08, 0xf0, 0x36, 0xa1, 0x7c, 0x92, 0x84, 0xae, 0x43, 0x29, 0x5b, 0x82,
	0x9b, 0x23, 0xae, 0xf3, 0x92, 0x04, 0xf2, 0xd5, 0x0a, 0x4a, 0x59, 0x35, 0x1e, 0x73, 0xf0, 0x2d,
	0x75, 0x63, 0x12, 0xf0, 0x28, 0xb7, 0x2f, 0xc3, 0xff, 0x0d, 0xc1, 0xfc, 0xb0, 0x71, 0xc2, 0xaf,
	0x95, 0x95, 0xb1, 0x6c, 0x4f, 0xa8, 0xdc, 0xa8, 0xa8, 0x96, 0xf4, 0xf7, 0x38, 0xfd, 0x1d, 0xbc,
	0x52, 0xf1, 0x06, 0x4f, 0xd9, 0xc5, 0x87, 0x1f, 0xfe, 0x16, 0xc1, 0x19, 0xd9, 0x6f, 0x61, 0xad,
	0xa4, 0xf4, 0x65, 0x3a, 0x09, 0xa5, 0xb4, 0xf1, 0x39, 0x09, 0xad, 0xca, 0x9b, 0x23, 0x3f, 0x48,
	0xb5, 0x23, 0xfc, 0x03, 0x02, 0x48, 0xfb, 0xb2, 0xe2, 0x0b, 0x28, 0xd7, 0xbf, 0x55, 0x00, 0x5c,
	0xe7, 0x80, 0x6f, 0xaa, 0x93, 0xc6, 0x8e, 0x1d, 0xf5, 0xd7, 0x08, 0x20, 0x6d, 0xc6, 0x8a, 0x19,
	0x73, 0x4d, 0xdb, 0xd8, 0xb2, 0x22, 0x43, 0xa7, 0x4d, 0x1c, 0xba, 0xef, 0x10, 0x9c, 0x91, 0xad,
	0x5f, 0xf1, 0xa9, 0x1e, 0xef, 0x0f, 0x2b, 0x04, 0x6d, 0x83, 0xa3, 0xad, 0xa9, 0xab, 0x13, 0xa2,
	0xb5, 0xc3, 0xd8, 0x6b, 0x23, 0x6d, 0xfd, 0x33, 0xb8, 0xd2, 0xf7, 0xdd, 0x02, 0x77, 0xeb, 0x0b,
	0x69, 0x23, 0xd9, 0x61, 0xe1, 0xe9, 0xa0, 0x0f, 0xef, 0x49, 0xb9, 0xed, 0x0f, 0x2c, 0xcf, 0xd6,
	0xfd, 0xd0, 0x36, 0x6c, 0xe2, 0xf1, 0xe0, 0x19, 0xc2, 0x64, 0x05, 0x0e, 0x3d, 0xe9, 0x1f, 0x1b,
	0xab, 0x7c, 0xf4, 0xe3, 0xd4, 0xec, 0xf6, 0xfd, 0xee, 0x56, 0x77, 0x67, 0x8e, 0xaf, 0xb9, 0xf9,
	0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x27, 0xc1, 0x2c, 0x59, 0x9a, 0x11, 0x00, 0x00,
}
