/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpdummy;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Random;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpEngine;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.version.Version;

public class GtpDummy
extends GtpEngine {
    private boolean m_nextResponseFixed;
    private boolean m_nextStatus;
    private int m_delay;
    private int m_size;
    private boolean[][] m_alreadyPlayed;
    private final Random m_random;
    private String m_nextResponse;
    private final Thread m_thread;
    private ArrayList m_ePList = new ArrayList();

    public GtpDummy(PrintStream printStream, boolean bl, long l) throws Exception {
        super(printStream);
        this.m_random = new Random();
        if (bl) {
            this.m_random.setSeed(l);
        }
        this.initSize(19);
        this.m_thread = Thread.currentThread();
    }

    public void handleCommand(GtpCommand gtpCommand) throws GtpError {
        if (this.m_nextResponseFixed && !gtpCommand.getCommand().equals("dummy_next_failure") && !gtpCommand.getCommand().equals("dummy_next_success")) {
            this.m_nextResponseFixed = false;
            if (!this.m_nextStatus) {
                throw new GtpError(this.m_nextResponse);
            }
            gtpCommand.setResponse(this.m_nextResponse);
        } else if (gtpCommand.getCommand().equals("boardsize")) {
            this.cmdBoardsize(gtpCommand);
        } else if (gtpCommand.getCommand().equals("clear_board")) {
            this.cmdClearBoard();
        } else if (gtpCommand.getCommand().equals("dummy_bwboard")) {
            this.cmdBWBoard(gtpCommand);
        } else if (gtpCommand.getCommand().equals("dummy_delay")) {
            this.cmdDelay(gtpCommand);
        } else if (gtpCommand.getCommand().equals("dummy_eplist")) {
            this.cmdEPList(gtpCommand);
        } else if (gtpCommand.getCommand().equals("dummy_gfx")) {
            this.cmdGfx(gtpCommand);
        } else if (gtpCommand.getCommand().equals("dummy_invalid")) {
            this.cmdInvalid();
        } else if (gtpCommand.getCommand().equals("dummy_live_gfx")) {
            this.cmdLiveGfx(gtpCommand);
        } else if (gtpCommand.getCommand().equals("dummy_long_response")) {
            this.cmdLongResponse(gtpCommand);
        } else if (gtpCommand.getCommand().equals("dummy_crash")) {
            this.cmdCrash();
        } else if (gtpCommand.getCommand().equals("dummy_next_failure")) {
            this.nextResponseFixed(gtpCommand, false);
        } else if (gtpCommand.getCommand().equals("dummy_next_success")) {
            this.nextResponseFixed(gtpCommand, true);
        } else if (gtpCommand.getCommand().equals("dummy_sleep")) {
            this.cmdSleep(gtpCommand);
        } else if (gtpCommand.getCommand().equals("echo")) {
            this.cmdEcho(gtpCommand);
        } else if (gtpCommand.getCommand().equals("echo_err")) {
            this.cmdEchoErr(gtpCommand);
        } else if (gtpCommand.getCommand().equals("genmove")) {
            this.cmdGenmove(gtpCommand);
        } else if (gtpCommand.getCommand().equals("gogui_analyze_commands")) {
            this.cmdGoGuiAnalyzeCommands(gtpCommand);
        } else if (!gtpCommand.getCommand().equals("gogui_interrupt")) {
            if (gtpCommand.getCommand().equals("name")) {
                gtpCommand.setResponse("GtpDummy");
            } else if (gtpCommand.getCommand().equals("play")) {
                this.cmdPlay(gtpCommand);
            } else if (gtpCommand.getCommand().equals("protocol_version")) {
                gtpCommand.setResponse("2");
            } else if (gtpCommand.getCommand().equals("list_commands")) {
                gtpCommand.setResponse("boardsize\nclear_board\ndummy_bwboard\ndummy_crash\ndummy_delay\ndummy_eplist\ndummy_gfx\ndummy_invalid\ndummy_live_gfx\ndummy_long_response\ndummy_next_success\ndummy_next_failure\ndummy_sleep\necho\necho_err\ngenmove\ngogui_analyze_commands\ngogui_interrupt\nlist_commands\nname\nplay\nprotocol_version\nquit\nversion\n");
            } else if (gtpCommand.getCommand().equals("version")) {
                gtpCommand.setResponse(Version.get());
            } else if (!gtpCommand.getCommand().equals("quit")) {
                throw new GtpError("unknown command");
            }
        }
        if (this.m_delay > 0 && !gtpCommand.getCommand().equals("dummy_delay")) {
            try {
                Thread.sleep(1000L * (long)this.m_delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void interruptCommand() {
        this.m_thread.interrupt();
    }

    private void cmdBWBoard(GtpCommand gtpCommand) {
        gtpCommand.getResponse().append('\n');
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                gtpCommand.getResponse().append(this.m_random.nextBoolean() ? (char)'B' : 'W');
                if (j >= this.m_size - 1) continue;
                gtpCommand.getResponse().append(' ');
            }
            gtpCommand.getResponse().append('\n');
        }
    }

    private void cmdBoardsize(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArg(1);
        int n = gtpCommand.getIntArg(0, 1, 25);
        this.initSize(n);
    }

    private void cmdCrash() {
        System.err.println("Aborting GtpDummy");
        System.exit(-1);
    }

    private void cmdClearBoard() throws GtpError {
        this.initSize(this.m_size);
    }

    private void cmdEcho(GtpCommand gtpCommand) {
        gtpCommand.setResponse(gtpCommand.getArgLine());
    }

    private void cmdEchoErr(GtpCommand gtpCommand) {
        System.err.println(gtpCommand.getArgLine());
    }

    private void cmdDelay(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArgLessEqual(1);
        if (gtpCommand.getNuArg() == 1) {
            this.m_delay = gtpCommand.getIntArg(0, 0, Integer.MAX_VALUE);
        } else {
            gtpCommand.getResponse().append(this.m_delay);
        }
    }

    private void cmdEPList(GtpCommand gtpCommand) throws GtpError {
        if (gtpCommand.getNuArg() == 1 && gtpCommand.getArg(0).equals("show")) {
            gtpCommand.setResponse(GoPoint.toString(this.m_ePList));
        } else {
            this.m_ePList = gtpCommand.getPointListArg(this.m_size);
        }
    }

    private void cmdGfx(GtpCommand gtpCommand) {
        gtpCommand.setResponse("LABEL A4 test\nCOLOR green A5 A7 B9\nCOLOR #980098 B7 B8\nSQUARE B5 C9\nMARK A6 B6\nTRIANGLE A9\nWHITE A1\nBLACK B1\nCIRCLE c8\nINFLUENCE a7 -1 b7 -0.75 c7 -0.5 d7 -0.25 e7 0 f7 0.25 g7 0.5 h7 0.75 j7 1\nVAR b c1 w c2 b c3 b c4 w pass b c5\nTEXT Graphics Demo\n");
    }

    private void cmdGoGuiAnalyzeCommands(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkArgNone();
        String string = "bwboard/Dummy BWBoard/dummy_bwboard\nnone/Dummy Crash/dummy_crash\nnone/Dummy Delay/dummy_delay %o\neplist/Dummy EPList/dummy_eplist\ngfx/Dummy Gfx/dummy_gfx\nnone/Dummy Invalid/dummy_invalid\nnone/Dummy Live Gfx/dummy_live_gfx\nstring/Dummy Long Response/dummy_long_response %s\nnone/Dummy Next Failure/dummy_next_failure %s\nnone/Dummy Next Success/dummy_next_success %s\nnone/Dummy Sleep/dummy_sleep %s\nnone/Dummy Sleep 20s/dummy_sleep\n";
        gtpCommand.setResponse(string);
    }

    private void cmdGenmove(GtpCommand gtpCommand) {
        int n;
        int n2 = 0;
        for (int i = 0; i < this.m_size; ++i) {
            for (n = 0; n < this.m_size; ++n) {
                if (this.m_alreadyPlayed[i][n]) continue;
                ++n2;
            }
        }
        GoPoint goPoint = null;
        if (n2 > 0) {
            n = this.m_random.nextInt(n2);
            int n3 = 0;
            for (int i = 0; i < this.m_size && goPoint == null; ++i) {
                for (int j = 0; j < this.m_size && goPoint == null; ++j) {
                    if (this.m_alreadyPlayed[i][j]) continue;
                    if (n3 == n) {
                        goPoint = GoPoint.get(i, j);
                    }
                    ++n3;
                }
            }
        }
        gtpCommand.setResponse(GoPoint.toString(goPoint));
        if (goPoint != null) {
            this.m_alreadyPlayed[goPoint.getX()][goPoint.getY()] = true;
        }
    }

    private void cmdInvalid() {
        this.printInvalidResponse("This is an invalid GTP response.\nIt does not start with a status character.\n");
    }

    private void cmdLiveGfx(GtpCommand gtpCommand) {
        System.err.println("gogui-gfx: TEXT Live Graphics Demo");
        System.err.println("gogui-gfx: LABEL A4 test");
        this.sleep(1000L);
        System.err.println("gogui-gfx: COLOR green A5 A7 B9");
        this.sleep(1000L);
        System.err.println("gogui-gfx: COLOR #980098 B7 B8");
        this.sleep(1000L);
        System.err.println("gogui-gfx:\nCLEAR\nSQUARE B5 C9\nMARK A6 B6\nTRIANGLE A9\n");
        this.sleep(1000L);
        System.err.println("gogui-gfx: WHITE A1");
        this.sleep(1000L);
        System.err.println("gogui-gfx: BLACK B1");
        this.sleep(1000L);
        System.err.println("gogui-gfx: CIRCLE c8");
        this.sleep(1000L);
        System.err.println("gogui-gfx: INFLUENCE a7 -1 b7 -0.75 c7 -0.5 d7 -0.25 e7 0 f7 0.25 g7 0.5 h7 0.75 j7 1");
        this.sleep(1000L);
        System.err.println("gogui-gfx: VAR b c1 w c2 b c3 b c4 w pass b c5");
        this.sleep(1000L);
    }

    private void cmdLongResponse(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArg(1);
        int n = gtpCommand.getIntArg(0, 1, Integer.MAX_VALUE);
        for (int i = 1; i <= n; ++i) {
            gtpCommand.getResponse().append(i);
            gtpCommand.getResponse().append("\n");
        }
    }

    private void cmdPlay(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArg(2);
        gtpCommand.getColorArg(0);
        GoPoint goPoint = gtpCommand.getPointArg(1, this.m_size);
        if (goPoint != null) {
            this.m_alreadyPlayed[goPoint.getX()][goPoint.getY()] = true;
        }
    }

    private void cmdSleep(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArgLessEqual(1);
        long l = 20000L;
        if (gtpCommand.getNuArg() == 1) {
            l = (long)(gtpCommand.getDoubleArg(0) * 1000.0);
        }
        this.sleep(l);
    }

    private void initSize(int n) {
        this.m_alreadyPlayed = new boolean[n][n];
        this.m_size = n;
    }

    private void nextResponseFixed(GtpCommand gtpCommand, boolean bl) {
        this.m_nextResponseFixed = true;
        this.m_nextStatus = bl;
        this.m_nextResponse = gtpCommand.getArgLine();
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

