﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="IHbFunctions.cs" company="HandBrake Project (http://handbrake.fr)">
//   This file is part of the HandBrake source code - It may be used under the terms of the GNU General Public License.
// </copyright>
// <summary>
//   An interface to access the native libhb functions without using static methods.
// </summary>
// <auto-generated> Disable Stylecop Warnings for this file  </auto-generated>
// --------------------------------------------------------------------------------------------------------------------

namespace HandBrake.Interop.Interop.HbLib.Wrappers
{
    using System;
    using System.Runtime.InteropServices;

    using HandBrake.Interop.Interop.HbLib.Wrappers.Interfaces;

    public class HbFunctionsDirect : IHbFunctions
    {
        public void hb_register_logger(LoggingCallback callback)
        {
            HBFunctions.hb_register_logger(callback);
        }

        public void hb_register_error_handler(LoggingCallback callback)
        {
            HBFunctions.hb_register_error_handler(callback);
        }

        public int hb_global_init()
        {
            return HBFunctions.hb_global_init();
        }

        public int hb_global_init_no_hardware()
        {
            return HBFunctions.hb_global_init_no_hardware();
        }

        public IntPtr hb_init(int verbose, int update_check)
        {
            return HBFunctions.hb_init(verbose, update_check);
        }

        public IntPtr hb_init_dl(int verbose, int update_check)
        {
            return HBFunctions.hb_init_dl(verbose, update_check);
        }

        public IntPtr hb_get_version(IntPtr hbHandle)
        {
            return HBFunctions.hb_get_version(hbHandle);
        }

        public int hb_get_build(IntPtr hbHandle)
        {
            return HBFunctions.hb_get_build(hbHandle);
        }

        public IntPtr hb_dvd_name(IntPtr path)
        {
            return HBFunctions.hb_dvd_name(path);
        }

        public void hb_dvd_set_dvdnav(int enable)
        {
            HBFunctions.hb_dvd_set_dvdnav(enable);
        }

        public void hb_scan(IntPtr hbHandle, IntPtr path, int title_index, int preview_count, int store_previews, ulong min_duration)
        {
            HBFunctions.hb_scan(hbHandle, path, title_index, preview_count, store_previews, min_duration);
        }

        public void hb_scan_stop(IntPtr hbHandle)
        {
            HBFunctions.hb_scan_stop(hbHandle);
        }

        public IntPtr hb_get_titles(IntPtr hbHandle)
        {
            return HBFunctions.hb_get_titles(hbHandle);
        }

        public void hb_set_anamorphic_size2(ref hb_geometry_s sourceGeometry, ref hb_geometry_settings_s uiGeometry, ref hb_geometry_s result)
        {
            HBFunctions.hb_set_anamorphic_size2(ref sourceGeometry, ref uiGeometry, ref result);
        }

        public int hb_count(IntPtr hbHandle)
        {
            return HBFunctions.hb_count(hbHandle);
        }

        public IntPtr hb_job(IntPtr hbHandle, int jobIndex)
        {
            return HBFunctions.hb_job(hbHandle, jobIndex);
        }

        public void hb_rem(IntPtr hbHandle, IntPtr job)
        {
            HBFunctions.hb_rem(hbHandle, job);
        }

        public void hb_start(IntPtr hbHandle)
        {
            HBFunctions.hb_start(hbHandle);
        }

        public void hb_pause(IntPtr hbHandle)
        {
            HBFunctions.hb_pause(hbHandle);
        }

        public void hb_resume(IntPtr hbHandle)
        {
            HBFunctions.hb_resume(hbHandle);
        }

        public void hb_stop(IntPtr hbHandle)
        {
            HBFunctions.hb_stop(hbHandle);
        }

        public void hb_close(IntPtr hbHandle)
        {
            HBFunctions.hb_close(hbHandle);
        }

        public void hb_global_close()
        {
            HBFunctions.hb_global_close();
        }

        public IntPtr hb_list_init()
        {
            return HBFunctions.hb_list_init();
        }

        public int hb_list_count(IntPtr listPtr)
        {
            return HBFunctions.hb_list_count(listPtr);
        }

        public void hb_list_add(IntPtr listPtr, IntPtr item)
        {
            HBFunctions.hb_list_add(listPtr, item);
        }

        public void hb_list_insert(IntPtr listPtr, int pos, IntPtr item)
        {
            HBFunctions.hb_list_insert(listPtr, pos, item);
        }

        public void hb_list_rem(IntPtr listPtr, IntPtr item)
        {
            HBFunctions.hb_list_rem(listPtr, item);
        }

        public IntPtr hb_list_item(IntPtr listPtr, int itemIndex)
        {
            return HBFunctions.hb_list_item(listPtr, itemIndex);
        }

        public void hb_list_close(IntPtr listPtrPtr)
        {
            HBFunctions.hb_list_close(listPtrPtr);
        }

        public int hb_subtitle_can_force(int source)
        {
            return HBFunctions.hb_subtitle_can_force(source);
        }

        public int hb_subtitle_can_burn(int source)
        {
            return HBFunctions.hb_subtitle_can_burn(source);
        }

        public int hb_subtitle_can_pass(int source, int mux)
        {
            return HBFunctions.hb_subtitle_can_pass(source, mux);
        }

        public int hb_video_framerate_get_from_name(IntPtr name)
        {
            return HBFunctions.hb_video_framerate_get_from_name(name);
        }

        public IntPtr hb_video_framerate_get_next(IntPtr last)
        {
            return HBFunctions.hb_video_framerate_get_next(last);
        }

        public IntPtr hb_audio_samplerate_get_next(IntPtr last)
        {
            return HBFunctions.hb_audio_samplerate_get_next(last);
        }

        public int hb_audio_samplerate_find_closest(int samplerate, uint codec)
        {
            return HBFunctions.hb_audio_samplerate_find_closest(samplerate, codec);
        }

        public int hb_audio_bitrate_get_best(uint codec, int bitrate, int samplerate, int mixdown)
        {
            return HBFunctions.hb_audio_bitrate_get_best(codec, bitrate, samplerate, mixdown);
        }

        public int hb_audio_bitrate_get_default(uint codec, int samplerate, int mixdown)
        {
            return HBFunctions.hb_audio_bitrate_get_default(codec, samplerate, mixdown);
        }

        public int hb_audio_bitrate_get_limits(uint codec, int samplerate, int mixdown, ref int low, ref int high)
        {
            return HBFunctions.hb_audio_bitrate_get_limits(codec, samplerate, mixdown, ref low, ref high);
        }

        public IntPtr hb_audio_bitrate_get_next(IntPtr last)
        {
            return HBFunctions.hb_audio_bitrate_get_next(last);
        }

        public void hb_video_quality_get_limits(uint codec, ref float low, ref float high, ref float granularity, ref int direction)
        {
            HBFunctions.hb_video_quality_get_limits(codec, ref low, ref high, ref granularity, ref direction);
        }

        public IntPtr hb_video_quality_get_name(uint codec)
        {
            return HBFunctions.hb_video_quality_get_name(codec);
        }

        public void hb_audio_quality_get_limits(uint codec, ref float low, ref float high, ref float granularity, ref int direction)
        {
            HBFunctions.hb_audio_quality_get_limits(codec, ref low, ref high, ref granularity, ref direction);
        }

        public float hb_audio_quality_get_default(uint codec)
        {
            return HBFunctions.hb_audio_quality_get_default(codec);
        }

        public void hb_audio_compression_get_limits(uint codec, ref float low, ref float high, ref float granularity, ref int direction)
        {
            HBFunctions.hb_audio_compression_get_limits(codec, ref low, ref high, ref granularity, ref direction);
        }

        public float hb_audio_compression_get_default(uint codec)
        {
            return HBFunctions.hb_audio_compression_get_default(codec);
        }

        public int hb_audio_can_apply_drc2(IntPtr handle, int title_index, int audio_index, int encoder)
        {
            return HBFunctions.hb_audio_can_apply_drc2(handle, title_index, audio_index, encoder);
        }

        public int hb_mixdown_is_supported(int mixdown, uint codec, ulong layout)
        {
            return HBFunctions.hb_mixdown_is_supported(mixdown, codec, layout);
        }

        public int hb_mixdown_has_codec_support(int mixdown, uint codec)
        {
            return HBFunctions.hb_mixdown_has_codec_support(mixdown, codec);
        }

        public int hb_mixdown_has_remix_support(int mixdown, ulong layout)
        {
            return HBFunctions.hb_mixdown_has_remix_support(mixdown, layout);
        }

        public int hb_mixdown_get_best(uint codec, ulong layout, int mixdown)
        {
            return HBFunctions.hb_mixdown_get_best(codec, layout, mixdown);
        }

        public int hb_mixdown_get_default(uint codec, ulong layout)
        {
            return HBFunctions.hb_mixdown_get_default(codec, layout);
        }

        public IntPtr hb_mixdown_get_next(IntPtr last)
        {
            return HBFunctions.hb_mixdown_get_next(last);
        }

        public IntPtr hb_video_encoder_get_next(IntPtr last)
        {
            return HBFunctions.hb_video_encoder_get_next(last);
        }

        public IntPtr hb_audio_encoder_get_next(IntPtr last)
        {
            return HBFunctions.hb_audio_encoder_get_next(last);
        }

        public IntPtr hb_container_get_next(IntPtr last)
        {
            return HBFunctions.hb_container_get_next(last);
        }

        public IntPtr hb_video_encoder_get_presets(int encoder)
        {
            return HBFunctions.hb_video_encoder_get_presets(encoder);
        }

        public IntPtr hb_video_encoder_get_tunes(int encoder)
        {
            return HBFunctions.hb_video_encoder_get_tunes(encoder);
        }

        public IntPtr hb_video_encoder_get_profiles(int encoder)
        {
            return HBFunctions.hb_video_encoder_get_profiles(encoder);
        }

        public IntPtr hb_video_encoder_get_levels(int encoder)
        {
            return HBFunctions.hb_video_encoder_get_levels(encoder);
        }

        public IntPtr lang_get_next(IntPtr last)
        {
            return HBFunctions.lang_get_next(last);
        }

        public IntPtr lang_for_code2([In] [MarshalAs(UnmanagedType.LPStr)] string code2)
        {
            return HBFunctions.lang_for_code2(code2);
        }

        public void hb_job_close(IntPtr job)
        {
            HBFunctions.hb_job_close(job);
        }

        public IntPtr hb_filter_get_keys(int filter_id)
        {
            return HBFunctions.hb_filter_get_keys(filter_id);
        }

        public IntPtr hb_x264_encopt_name(IntPtr name)
        {
            return HBFunctions.hb_x264_encopt_name(name);
        }

        public int hb_check_h264_level(
            [In] [MarshalAs(UnmanagedType.LPStr)] string level,
            int width,
            int height,
            int fps_num,
            int fps_den,
            int interlaced,
            int fake_interlaced)
        {
            return HBFunctions.hb_check_h264_level(
                level,
                width,
                height,
                fps_num,
                fps_den,
                interlaced,
                fake_interlaced);
        }

        public IntPtr hb_x264_param_unparse(
            int bit_depth,
            [In] [MarshalAs(UnmanagedType.LPStr)] string x264_preset,
            [In] [MarshalAs(UnmanagedType.LPStr)] string x264_tune,
            [In] [MarshalAs(UnmanagedType.LPStr)] string x264_encopts,
            [In] [MarshalAs(UnmanagedType.LPStr)] string x264_profile,
            [In] [MarshalAs(UnmanagedType.LPStr)] string h264_level,
            int width,
            int height)
        {
            return HBFunctions.hb_x264_param_unparse(
                bit_depth,
                x264_preset,
                x264_tune,
                x264_encopts,
                x264_profile,
                h264_level,
                width,
                height);
        }

        public int hb_qsv_available()
        {
            return HBFunctions.hb_qsv_available();
        }

        public int hb_vce_h264_available()
        {
            return HBFunctions.hb_vce_h264_available();
        }

        public int hb_vce_h265_available()
        {
            return HBFunctions.hb_vce_h265_available();
        }

        public int hb_nvenc_h264_available()
        {
            return HBFunctions.hb_nvenc_h264_available();
        }

        public int hb_nvenc_h265_available()
        {
            return HBFunctions.hb_nvenc_h265_available();
        }

        public IntPtr hb_get_preview2(IntPtr hbHandle, int title_idx, int preview_idx, ref hb_geometry_settings_s geo, int deinterlace)
        {
            return HBFunctions.hb_get_preview2(hbHandle, title_idx, preview_idx, ref geo, deinterlace);
        }

        public IntPtr hb_image_close(IntPtr image)
        {
            return HBFunctions.hb_image_close(image);
        }

        /* JSON API */

        public IntPtr hb_get_title_set_json(IntPtr hbHandle)
        {
            return HBFunctions.hb_get_title_set_json(hbHandle);
        }

        public IntPtr hb_job_init_json(IntPtr hbHandle, int title_index)
        {
            return HBFunctions.hb_job_init_json(hbHandle, title_index);
        }

        public IntPtr hb_json_to_job(IntPtr hbHandle, IntPtr json_job)
        {
            return HBFunctions.hb_json_to_job(hbHandle, json_job);
        }

        public int hb_add_json(IntPtr hbHandle, IntPtr json_job)
        {
            return HBFunctions.hb_add_json(hbHandle, json_job);
        }

        public IntPtr hb_set_anamorphic_size_json(IntPtr json_param)
        {
            return HBFunctions.hb_set_anamorphic_size_json(json_param);
        }

        public IntPtr hb_get_state_json(IntPtr hbHandle)
        {
            return HBFunctions.hb_get_state_json(hbHandle);
        }

        public IntPtr hb_get_preview_params_json(int title_idx, int preview_idx, int deinterlace, ref hb_geometry_settings_s settings)
        {
            return HBFunctions.hb_get_preview_params_json(title_idx, preview_idx, deinterlace, ref settings);
        }

        public void hb_presets_builtin_init()
        {
            HBFunctions.hb_presets_builtin_init();
        }

        public IntPtr hb_presets_builtin_get_json()
        {
            return HBFunctions.hb_presets_builtin_get_json();
        }

        public IntPtr hb_presets_read_file_json(IntPtr filename)
        {
            return HBFunctions.hb_presets_read_file_json(filename);
        }

        public IntPtr hb_presets_current_version(IntPtr major, IntPtr minor, IntPtr micro)
        {
            return HBFunctions.hb_presets_current_version(major, minor, micro);
        }

        public IntPtr hb_generate_filter_settings_json(
            int filter_id,
            [In] [MarshalAs(UnmanagedType.LPStr)] string preset,
            [In] [MarshalAs(UnmanagedType.LPStr)] string tune,
            [In] [MarshalAs(UnmanagedType.LPStr)] string custom)
        {
            return HBFunctions.hb_generate_filter_settings_json(filter_id, preset, tune, custom);
        }

        public IntPtr hb_filter_get_presets_json(int filter_id)
        {
            return HBFunctions.hb_filter_get_presets_json(filter_id);
        }

        public IntPtr hb_filter_get_tunes_json(int filter_id)
        {
            return HBFunctions.hb_filter_get_tunes_json(filter_id);
        }
    }
}
