#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 2365
#define LARGE_STATE_COUNT 350
#define SYMBOL_COUNT 433
#define ALIAS_COUNT 1
#define TOKEN_COUNT 141
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 21
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 82

enum {
  sym_identifier = 1,
  anon_sym_POUND = 2,
  sym_decimal_integer_literal = 3,
  sym_hex_integer_literal = 4,
  sym_decimal_floating_point_literal = 5,
  anon_sym_true = 6,
  anon_sym_false = 7,
  anon_sym_DQUOTE = 8,
  anon_sym_SQUOTE = 9,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 10,
  anon_sym_SQUOTE_SQUOTE_SQUOTE = 11,
  anon_sym_r_DQUOTE = 12,
  anon_sym_DOLLAR = 13,
  anon_sym_r_SQUOTE = 14,
  anon_sym_r_DQUOTE_DQUOTE_DQUOTE = 15,
  anon_sym_r_SQUOTE_SQUOTE_SQUOTE = 16,
  anon_sym_LBRACE = 17,
  anon_sym_RBRACE = 18,
  aux_sym__sub_string_test_token1 = 19,
  sym__unused_escape_sequence = 20,
  anon_sym_LBRACK = 21,
  anon_sym_COMMA = 22,
  anon_sym_RBRACK = 23,
  anon_sym_COLON = 24,
  anon_sym_null = 25,
  anon_sym_throw = 26,
  anon_sym_EQ = 27,
  anon_sym_QMARK_QMARK = 28,
  anon_sym_LPAREN = 29,
  anon_sym_RPAREN = 30,
  anon_sym_QMARK = 31,
  anon_sym_PIPE_PIPE = 32,
  anon_sym_AMP_AMP = 33,
  sym_equality_operator = 34,
  anon_sym_LT = 35,
  anon_sym_GT = 36,
  anon_sym_LT_EQ = 37,
  anon_sym_GT_EQ = 38,
  anon_sym_PIPE = 39,
  anon_sym_CARET = 40,
  anon_sym_AMP = 41,
  anon_sym_LT_LT = 42,
  anon_sym_GT_GT = 43,
  anon_sym_GT_GT_GT = 44,
  sym__additive_operator = 45,
  anon_sym_STAR = 46,
  anon_sym_SLASH = 47,
  anon_sym_PERCENT = 48,
  anon_sym_TILDE_SLASH = 49,
  sym_increment_operator = 50,
  anon_sym_DOT_DOT_DOT = 51,
  sym_minus_operator = 52,
  sym__exclamation_operator = 53,
  anon_sym_TILDE = 54,
  anon_sym_await = 55,
  anon_sym_is = 56,
  anon_sym_as = 57,
  anon_sym_DOT = 58,
  anon_sym_QMARK_DOT = 59,
  anon_sym_DOT_DOT = 60,
  anon_sym_extends = 61,
  anon_sym_SEMI = 62,
  anon_sym_switch = 63,
  anon_sym_default = 64,
  anon_sym_do = 65,
  anon_sym_while = 66,
  anon_sym_continue = 67,
  anon_sym_yield = 68,
  anon_sym_return = 69,
  anon_sym_on = 70,
  anon_sym_try = 71,
  anon_sym_catch = 72,
  anon_sym_finally = 73,
  anon_sym_if = 74,
  anon_sym_else = 75,
  anon_sym_for = 76,
  anon_sym_in = 77,
  anon_sym_AT = 78,
  anon_sym_transitive = 79,
  anon_sym_part = 80,
  anon_sym_of = 81,
  anon_sym_EQ_EQ = 82,
  anon_sym_show = 83,
  anon_sym_hide = 84,
  anon_sym_enum = 85,
  anon_sym_abstract = 86,
  anon_sym_class = 87,
  anon_sym_extension = 88,
  anon_sym_with = 89,
  anon_sym_LBRACK_RBRACK = 90,
  anon_sym_LBRACK_RBRACK_EQ = 91,
  anon_sym_super = 92,
  sym_floating_point_type = 93,
  anon_sym_bool = 94,
  sym_void_type = 95,
  anon_sym_var = 96,
  anon_sym_async = 97,
  anon_sym_EQ_GT = 98,
  anon_sym_async_STAR = 99,
  anon_sym_sync_STAR = 100,
  anon_sym_required = 101,
  anon_sym_throws = 102,
  anon_sym_POUND_BANG = 103,
  aux_sym_script_tag_token1 = 104,
  anon_sym_LF = 105,
  anon_sym_library = 106,
  sym__break_builtin = 107,
  sym__assert_builtin = 108,
  sym_case_builtin = 109,
  anon_sym_covariant = 110,
  anon_sym_deferred = 111,
  anon_sym_dynamic = 112,
  anon_sym_export = 113,
  anon_sym_factory = 114,
  anon_sym_Function = 115,
  anon_sym_get = 116,
  anon_sym_native = 117,
  anon_sym_implements = 118,
  anon_sym_import = 119,
  anon_sym_interface = 120,
  anon_sym_operator = 121,
  anon_sym_mixin = 122,
  anon_sym_set = 123,
  anon_sym_static = 124,
  anon_sym_typedef = 125,
  anon_sym_new = 126,
  sym_const_builtin = 127,
  sym_final_builtin = 128,
  anon_sym_late = 129,
  anon_sym_external = 130,
  anon_sym_this = 131,
  sym_identifier_dollar_escaped = 132,
  sym_comment = 133,
  sym_documentation_comment = 134,
  sym__automatic_semicolon = 135,
  sym__template_chars_double = 136,
  sym__template_chars_single = 137,
  sym__template_chars_double_single = 138,
  sym__template_chars_single_single = 139,
  sym__template_chars_raw_slash = 140,
  sym_program = 141,
  sym__top_level_definition = 142,
  sym__literal = 143,
  sym_symbol_literal = 144,
  sym_true = 145,
  sym_false = 146,
  sym_string_literal = 147,
  sym__string_literal_double_quotes = 148,
  sym__string_literal_single_quotes = 149,
  sym__string_literal_double_quotes_multiple = 150,
  sym__string_literal_single_quotes_multiple = 151,
  sym__raw_string_literal_double_quotes = 152,
  sym__raw_string_literal_single_quotes = 153,
  sym__raw_string_literal_double_quotes_multiple = 154,
  sym__raw_string_literal_single_quotes_multiple = 155,
  sym_template_substitution = 156,
  sym__sub_string_test = 157,
  sym_escape_sequence = 158,
  sym_list_literal = 159,
  sym_set_or_map_literal = 160,
  sym_pair = 161,
  sym__element = 162,
  sym_null_literal = 163,
  sym__expression = 164,
  sym__expression_without_cascade = 165,
  sym__real_expression = 166,
  sym_throw_expression = 167,
  sym_throw_expression_without_cascade = 168,
  sym_assignment_expression = 169,
  sym_assignment_expression_without_cascade = 170,
  sym_assignable_expression = 171,
  sym__assignable_selector_part = 172,
  sym__assignment_operator = 173,
  sym_lambda_expression = 174,
  sym_function_expression = 175,
  sym_if_null_expression = 176,
  aux_sym__if_null_expression = 177,
  sym_conditional_expression = 178,
  sym_logical_or_expression = 179,
  sym_logical_and_expression = 180,
  sym_equality_expression = 181,
  sym_type_cast_expression = 182,
  sym_type_test_expression = 183,
  sym_relational_expression = 184,
  sym_relational_operator = 185,
  sym_bitwise_or_expression = 186,
  sym_bitwise_xor_expression = 187,
  sym_bitwise_and_expression = 188,
  sym_shift_expression = 189,
  sym_additive_expression = 190,
  sym_multiplicative_expression = 191,
  sym_bitwise_operator = 192,
  sym__bitwise_operator = 193,
  sym_shift_operator = 194,
  sym__shift_operator = 195,
  sym_additive_operator = 196,
  sym_multiplicative_operator = 197,
  sym__multiplicative_operator = 198,
  sym__unary_expression = 199,
  sym_unary_expression = 200,
  sym__postfix_expression = 201,
  sym_postfix_expression = 202,
  sym_postfix_operator = 203,
  sym_spread_element = 204,
  sym_selector = 205,
  sym_prefix_operator = 206,
  sym_negation_operator = 207,
  sym_tilde_operator = 208,
  sym_await_expression = 209,
  sym_type_test = 210,
  sym_is_operator = 211,
  sym_type_cast = 212,
  sym_as_operator = 213,
  sym_new_expression = 214,
  sym__dot_identifier = 215,
  sym_const_object_expression = 216,
  sym__primary = 217,
  sym_parenthesized_expression = 218,
  sym_constructor_invocation = 219,
  sym_arguments = 220,
  sym__argument_list = 221,
  sym_argument = 222,
  sym_named_argument = 223,
  sym_cascade_section = 224,
  sym__cascade_subsection = 225,
  sym__cascade_assignment_section = 226,
  sym_cascade_selector = 227,
  sym_argument_part = 228,
  sym_unconditional_assignable_selector = 229,
  sym_conditional_assignable_selector = 230,
  sym__assignable_selector = 231,
  sym_type_arguments = 232,
  sym__statement = 233,
  sym_block = 234,
  sym_expression_statement = 235,
  sym_labeled_statement = 236,
  sym_assert_statement = 237,
  sym_assertion = 238,
  sym_switch_statement = 239,
  sym_switch_block = 240,
  sym_switch_label = 241,
  sym_do_statement = 242,
  sym_break_statement = 243,
  sym_continue_statement = 244,
  sym_yield_statement = 245,
  sym_yield_each_statement = 246,
  sym_return_statement = 247,
  sym_try_statement = 248,
  sym__on_part = 249,
  sym__try_head = 250,
  sym_catch_clause = 251,
  sym_finally_clause = 252,
  sym_if_element = 253,
  sym_if_statement = 254,
  sym_while_statement = 255,
  sym_for_statement = 256,
  sym__for_loop_parts = 257,
  sym_for_element = 258,
  sym__annotation = 259,
  sym_marker_annotation = 260,
  sym_annotation = 261,
  sym_import_or_export = 262,
  sym_library_import = 263,
  sym_library_export = 264,
  sym_import_specification = 265,
  sym_part_directive = 266,
  sym_part_of_directive = 267,
  sym_uri = 268,
  sym_configurable_uri = 269,
  sym_configuration_uri = 270,
  sym_uri_test = 271,
  sym_combinator = 272,
  sym__identifier_list = 273,
  sym_enum_declaration = 274,
  sym_enum_body = 275,
  sym_enum_constant = 276,
  sym_type_alias = 277,
  sym_class_definition = 278,
  sym_extension_declaration = 279,
  sym__metadata = 280,
  sym_type_parameters = 281,
  sym_type_parameter = 282,
  sym_type_bound = 283,
  sym_superclass = 284,
  sym_mixins = 285,
  sym_mixin_application_class = 286,
  sym_mixin_application = 287,
  sym_mixin_declaration = 288,
  sym_interfaces = 289,
  sym_class_body = 290,
  sym_extension_body = 291,
  sym_getter_signature = 292,
  sym_setter_signature = 293,
  sym_method_signature = 294,
  sym_declaration = 295,
  sym_initialized_identifier_list = 296,
  sym_initialized_identifier = 297,
  sym_static_final_declaration_list = 298,
  sym_binary_operator = 299,
  sym_operator_signature = 300,
  sym_static_final_declaration = 301,
  sym__external_and_static = 302,
  sym__static_or_covariant = 303,
  sym__final_or_const = 304,
  sym_initializers = 305,
  sym_initializer_list_entry = 306,
  sym_field_initializer = 307,
  sym_factory_constructor_signature = 308,
  sym_redirecting_factory_constructor_signature = 309,
  sym_redirection = 310,
  sym_constructor_signature = 311,
  sym_constant_constructor_signature = 312,
  sym_scoped_identifier = 313,
  sym_initialized_variable_definition = 314,
  sym__declared_identifier = 315,
  sym__final_const_var_or_type = 316,
  sym__type = 317,
  sym__type_not_function = 318,
  sym__type_not_void_not_function = 319,
  sym_function_type = 320,
  aux_sym__function_type_tails = 321,
  sym__function_type_tail = 322,
  sym_parameter_type_list = 323,
  sym_normal_parameter_type = 324,
  sym_optional_parameter_types = 325,
  sym_optional_positional_parameter_types = 326,
  sym_named_parameter_types = 327,
  sym__type_not_void = 328,
  sym__type_not_void_list = 329,
  sym__type_name = 330,
  sym__type_dot_identifier = 331,
  sym_typed_identifier = 332,
  sym__nullable_type = 333,
  sym_inferred_type = 334,
  sym_function_body = 335,
  sym_function_expression_body = 336,
  sym_function_signature = 337,
  sym__formal_parameter_part = 338,
  sym_formal_parameter_list = 339,
  sym__strict_formal_parameter_list = 340,
  sym__normal_formal_parameters = 341,
  sym_optional_formal_parameters = 342,
  sym__optional_postional_formal_parameters = 343,
  sym__named_formal_parameters = 344,
  sym_formal_parameter = 345,
  sym__default_formal_parameter = 346,
  sym__default_named_parameter = 347,
  sym__normal_formal_parameter = 348,
  sym__function_formal_parameter = 349,
  sym__simple_formal_parameter = 350,
  sym_constructor_param = 351,
  sym_local_variable_declaration = 352,
  sym_script_tag = 353,
  sym_library_name = 354,
  sym_dotted_identifier_list = 355,
  sym_qualified = 356,
  sym__as = 357,
  sym__covariant = 358,
  sym__deferred = 359,
  sym__export = 360,
  sym__external = 361,
  sym__factory = 362,
  sym__function_builtin_identifier = 363,
  sym__get = 364,
  sym__native = 365,
  sym__implements = 366,
  sym__import = 367,
  sym__operator = 368,
  sym__mixin = 369,
  sym__set = 370,
  sym__static = 371,
  sym__typedef = 372,
  sym__new_builtin = 373,
  sym__late_builtin = 374,
  sym__external_builtin = 375,
  sym_this = 376,
  sym_super = 377,
  sym_label = 378,
  sym__semicolon = 379,
  aux_sym_program_repeat1 = 380,
  aux_sym_program_repeat2 = 381,
  aux_sym_program_repeat3 = 382,
  aux_sym_program_repeat4 = 383,
  aux_sym_program_repeat5 = 384,
  aux_sym_string_literal_repeat1 = 385,
  aux_sym__string_literal_double_quotes_repeat1 = 386,
  aux_sym__string_literal_single_quotes_repeat1 = 387,
  aux_sym__string_literal_double_quotes_multiple_repeat1 = 388,
  aux_sym__string_literal_single_quotes_multiple_repeat1 = 389,
  aux_sym__raw_string_literal_double_quotes_repeat1 = 390,
  aux_sym__raw_string_literal_single_quotes_repeat1 = 391,
  aux_sym__raw_string_literal_double_quotes_multiple_repeat1 = 392,
  aux_sym__raw_string_literal_single_quotes_multiple_repeat1 = 393,
  aux_sym_list_literal_repeat1 = 394,
  aux_sym__expression_repeat1 = 395,
  aux_sym__assignable_selector_part_repeat1 = 396,
  aux_sym_inferred_parameters_repeat1 = 397,
  aux_sym_logical_or_expression_repeat1 = 398,
  aux_sym_logical_and_expression_repeat1 = 399,
  aux_sym_bitwise_or_expression_repeat1 = 400,
  aux_sym_bitwise_xor_expression_repeat1 = 401,
  aux_sym_bitwise_and_expression_repeat1 = 402,
  aux_sym_shift_expression_repeat1 = 403,
  aux_sym_additive_expression_repeat1 = 404,
  aux_sym_multiplicative_expression_repeat1 = 405,
  aux_sym__argument_list_repeat1 = 406,
  aux_sym__argument_list_repeat2 = 407,
  aux_sym__argument_list_repeat3 = 408,
  aux_sym_cascade_section_repeat1 = 409,
  aux_sym_cascade_section_repeat2 = 410,
  aux_sym_type_arguments_repeat1 = 411,
  aux_sym_switch_block_repeat1 = 412,
  aux_sym_try_statement_repeat1 = 413,
  aux_sym__for_loop_parts_repeat1 = 414,
  aux_sym__for_loop_parts_repeat2 = 415,
  aux_sym_library_export_repeat1 = 416,
  aux_sym_configurable_uri_repeat1 = 417,
  aux_sym_enum_body_repeat1 = 418,
  aux_sym__metadata_repeat1 = 419,
  aux_sym_type_parameters_repeat1 = 420,
  aux_sym_class_body_repeat1 = 421,
  aux_sym_extension_body_repeat1 = 422,
  aux_sym_initialized_identifier_list_repeat1 = 423,
  aux_sym_static_final_declaration_list_repeat1 = 424,
  aux_sym_initializers_repeat1 = 425,
  aux_sym_factory_constructor_signature_repeat1 = 426,
  aux_sym_parameter_type_list_repeat1 = 427,
  aux_sym_named_parameter_types_repeat1 = 428,
  aux_sym__type_not_void_list_repeat1 = 429,
  aux_sym__normal_formal_parameters_repeat1 = 430,
  aux_sym_positional_parameters_repeat1 = 431,
  aux_sym__named_formal_parameters_repeat1 = 432,
  alias_sym_type_identifier = 433,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_POUND] = "#",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_hex_integer_literal] = "hex_integer_literal",
  [sym_decimal_floating_point_literal] = "decimal_floating_point_literal",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = "'''",
  [anon_sym_r_DQUOTE] = "r\"",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_r_SQUOTE] = "r'",
  [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = "r\"\"\"",
  [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = "r'''",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [aux_sym__sub_string_test_token1] = "_sub_string_test_token1",
  [sym__unused_escape_sequence] = "_unused_escape_sequence",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COLON] = ":",
  [anon_sym_null] = "null",
  [anon_sym_throw] = "throw",
  [anon_sym_EQ] = "=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_QMARK] = "\?",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [sym_equality_operator] = "equality_operator",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [sym__additive_operator] = "_additive_operator",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_TILDE_SLASH] = "~/",
  [sym_increment_operator] = "increment_operator",
  [anon_sym_DOT_DOT_DOT] = "...",
  [sym_minus_operator] = "minus_operator",
  [sym__exclamation_operator] = "_exclamation_operator",
  [anon_sym_TILDE] = "~",
  [anon_sym_await] = "await",
  [anon_sym_is] = "is",
  [anon_sym_as] = "as",
  [anon_sym_DOT] = ".",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_extends] = "extends",
  [anon_sym_SEMI] = ";",
  [anon_sym_switch] = "switch",
  [anon_sym_default] = "default",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_continue] = "continue",
  [anon_sym_yield] = "yield",
  [anon_sym_return] = "return",
  [anon_sym_on] = "on",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_AT] = "@",
  [anon_sym_transitive] = "transitive",
  [anon_sym_part] = "part",
  [anon_sym_of] = "of",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_show] = "show",
  [anon_sym_hide] = "hide",
  [anon_sym_enum] = "enum",
  [anon_sym_abstract] = "abstract",
  [anon_sym_class] = "class",
  [anon_sym_extension] = "extension",
  [anon_sym_with] = "with",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_LBRACK_RBRACK_EQ] = "[]=",
  [anon_sym_super] = "super",
  [sym_floating_point_type] = "floating_point_type",
  [anon_sym_bool] = "bool",
  [sym_void_type] = "void_type",
  [anon_sym_var] = "var",
  [anon_sym_async] = "async",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_async_STAR] = "async*",
  [anon_sym_sync_STAR] = "sync*",
  [anon_sym_required] = "required",
  [anon_sym_throws] = "throws",
  [anon_sym_POUND_BANG] = "#!",
  [aux_sym_script_tag_token1] = "script_tag_token1",
  [anon_sym_LF] = "\n",
  [anon_sym_library] = "library",
  [sym__break_builtin] = "_break_builtin",
  [sym__assert_builtin] = "_assert_builtin",
  [sym_case_builtin] = "case_builtin",
  [anon_sym_covariant] = "covariant",
  [anon_sym_deferred] = "deferred",
  [anon_sym_dynamic] = "dynamic",
  [anon_sym_export] = "export",
  [anon_sym_factory] = "factory",
  [anon_sym_Function] = "Function",
  [anon_sym_get] = "get",
  [anon_sym_native] = "native",
  [anon_sym_implements] = "implements",
  [anon_sym_import] = "import",
  [anon_sym_interface] = "interface",
  [anon_sym_operator] = "operator",
  [anon_sym_mixin] = "mixin",
  [anon_sym_set] = "set",
  [anon_sym_static] = "static",
  [anon_sym_typedef] = "typedef",
  [anon_sym_new] = "new",
  [sym_const_builtin] = "const_builtin",
  [sym_final_builtin] = "final_builtin",
  [anon_sym_late] = "late",
  [anon_sym_external] = "external",
  [anon_sym_this] = "this",
  [sym_identifier_dollar_escaped] = "identifier_dollar_escaped",
  [sym_comment] = "comment",
  [sym_documentation_comment] = "documentation_comment",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars_double] = "_template_chars_double",
  [sym__template_chars_single] = "_template_chars_single",
  [sym__template_chars_double_single] = "_template_chars_double_single",
  [sym__template_chars_single_single] = "_template_chars_single_single",
  [sym__template_chars_raw_slash] = "_template_chars_raw_slash",
  [sym_program] = "program",
  [sym__top_level_definition] = "_top_level_definition",
  [sym__literal] = "_literal",
  [sym_symbol_literal] = "symbol_literal",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_string_literal] = "string_literal",
  [sym__string_literal_double_quotes] = "_string_literal_double_quotes",
  [sym__string_literal_single_quotes] = "_string_literal_single_quotes",
  [sym__string_literal_double_quotes_multiple] = "_string_literal_double_quotes_multiple",
  [sym__string_literal_single_quotes_multiple] = "_string_literal_single_quotes_multiple",
  [sym__raw_string_literal_double_quotes] = "_raw_string_literal_double_quotes",
  [sym__raw_string_literal_single_quotes] = "_raw_string_literal_single_quotes",
  [sym__raw_string_literal_double_quotes_multiple] = "_raw_string_literal_double_quotes_multiple",
  [sym__raw_string_literal_single_quotes_multiple] = "_raw_string_literal_single_quotes_multiple",
  [sym_template_substitution] = "template_substitution",
  [sym__sub_string_test] = "_sub_string_test",
  [sym_escape_sequence] = "escape_sequence",
  [sym_list_literal] = "list_literal",
  [sym_set_or_map_literal] = "set_or_map_literal",
  [sym_pair] = "pair",
  [sym__element] = "_element",
  [sym_null_literal] = "null_literal",
  [sym__expression] = "_expression",
  [sym__expression_without_cascade] = "_expression_without_cascade",
  [sym__real_expression] = "_real_expression",
  [sym_throw_expression] = "throw_expression",
  [sym_throw_expression_without_cascade] = "throw_expression_without_cascade",
  [sym_assignment_expression] = "assignment_expression",
  [sym_assignment_expression_without_cascade] = "assignment_expression_without_cascade",
  [sym_assignable_expression] = "assignable_expression",
  [sym__assignable_selector_part] = "_assignable_selector_part",
  [sym__assignment_operator] = "_assignment_operator",
  [sym_lambda_expression] = "lambda_expression",
  [sym_function_expression] = "function_expression",
  [sym_if_null_expression] = "if_null_expression",
  [aux_sym__if_null_expression] = "_if_null_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_logical_or_expression] = "logical_or_expression",
  [sym_logical_and_expression] = "logical_and_expression",
  [sym_equality_expression] = "equality_expression",
  [sym_type_cast_expression] = "type_cast_expression",
  [sym_type_test_expression] = "type_test_expression",
  [sym_relational_expression] = "relational_expression",
  [sym_relational_operator] = "relational_operator",
  [sym_bitwise_or_expression] = "bitwise_or_expression",
  [sym_bitwise_xor_expression] = "bitwise_xor_expression",
  [sym_bitwise_and_expression] = "bitwise_and_expression",
  [sym_shift_expression] = "shift_expression",
  [sym_additive_expression] = "additive_expression",
  [sym_multiplicative_expression] = "multiplicative_expression",
  [sym_bitwise_operator] = "bitwise_operator",
  [sym__bitwise_operator] = "_bitwise_operator",
  [sym_shift_operator] = "shift_operator",
  [sym__shift_operator] = "_shift_operator",
  [sym_additive_operator] = "additive_operator",
  [sym_multiplicative_operator] = "multiplicative_operator",
  [sym__multiplicative_operator] = "_multiplicative_operator",
  [sym__unary_expression] = "_unary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym__postfix_expression] = "_postfix_expression",
  [sym_postfix_expression] = "postfix_expression",
  [sym_postfix_operator] = "postfix_operator",
  [sym_spread_element] = "spread_element",
  [sym_selector] = "selector",
  [sym_prefix_operator] = "prefix_operator",
  [sym_negation_operator] = "negation_operator",
  [sym_tilde_operator] = "tilde_operator",
  [sym_await_expression] = "await_expression",
  [sym_type_test] = "type_test",
  [sym_is_operator] = "is_operator",
  [sym_type_cast] = "type_cast",
  [sym_as_operator] = "as_operator",
  [sym_new_expression] = "new_expression",
  [sym__dot_identifier] = "_dot_identifier",
  [sym_const_object_expression] = "const_object_expression",
  [sym__primary] = "_primary",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_constructor_invocation] = "constructor_invocation",
  [sym_arguments] = "arguments",
  [sym__argument_list] = "_argument_list",
  [sym_argument] = "argument",
  [sym_named_argument] = "named_argument",
  [sym_cascade_section] = "cascade_section",
  [sym__cascade_subsection] = "_cascade_subsection",
  [sym__cascade_assignment_section] = "_cascade_assignment_section",
  [sym_cascade_selector] = "cascade_selector",
  [sym_argument_part] = "argument_part",
  [sym_unconditional_assignable_selector] = "unconditional_assignable_selector",
  [sym_conditional_assignable_selector] = "conditional_assignable_selector",
  [sym__assignable_selector] = "_assignable_selector",
  [sym_type_arguments] = "type_arguments",
  [sym__statement] = "_statement",
  [sym_block] = "block",
  [sym_expression_statement] = "expression_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_assertion] = "assertion",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_block] = "switch_block",
  [sym_switch_label] = "switch_label",
  [sym_do_statement] = "do_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_yield_statement] = "yield_statement",
  [sym_yield_each_statement] = "yield_each_statement",
  [sym_return_statement] = "return_statement",
  [sym_try_statement] = "try_statement",
  [sym__on_part] = "_on_part",
  [sym__try_head] = "_try_head",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_if_element] = "if_element",
  [sym_if_statement] = "if_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_statement] = "for_statement",
  [sym__for_loop_parts] = "_for_loop_parts",
  [sym_for_element] = "for_element",
  [sym__annotation] = "_annotation",
  [sym_marker_annotation] = "marker_annotation",
  [sym_annotation] = "annotation",
  [sym_import_or_export] = "import_or_export",
  [sym_library_import] = "library_import",
  [sym_library_export] = "library_export",
  [sym_import_specification] = "import_specification",
  [sym_part_directive] = "part_directive",
  [sym_part_of_directive] = "part_of_directive",
  [sym_uri] = "uri",
  [sym_configurable_uri] = "configurable_uri",
  [sym_configuration_uri] = "configuration_uri",
  [sym_uri_test] = "uri_test",
  [sym_combinator] = "combinator",
  [sym__identifier_list] = "_identifier_list",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_constant] = "enum_constant",
  [sym_type_alias] = "type_alias",
  [sym_class_definition] = "class_definition",
  [sym_extension_declaration] = "extension_declaration",
  [sym__metadata] = "_metadata",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_bound] = "type_bound",
  [sym_superclass] = "superclass",
  [sym_mixins] = "mixins",
  [sym_mixin_application_class] = "mixin_application_class",
  [sym_mixin_application] = "mixin_application",
  [sym_mixin_declaration] = "mixin_declaration",
  [sym_interfaces] = "interfaces",
  [sym_class_body] = "class_body",
  [sym_extension_body] = "extension_body",
  [sym_getter_signature] = "getter_signature",
  [sym_setter_signature] = "setter_signature",
  [sym_method_signature] = "method_signature",
  [sym_declaration] = "declaration",
  [sym_initialized_identifier_list] = "initialized_identifier_list",
  [sym_initialized_identifier] = "initialized_identifier",
  [sym_static_final_declaration_list] = "static_final_declaration_list",
  [sym_binary_operator] = "binary_operator",
  [sym_operator_signature] = "operator_signature",
  [sym_static_final_declaration] = "static_final_declaration",
  [sym__external_and_static] = "_external_and_static",
  [sym__static_or_covariant] = "_static_or_covariant",
  [sym__final_or_const] = "_final_or_const",
  [sym_initializers] = "initializers",
  [sym_initializer_list_entry] = "initializer_list_entry",
  [sym_field_initializer] = "field_initializer",
  [sym_factory_constructor_signature] = "factory_constructor_signature",
  [sym_redirecting_factory_constructor_signature] = "redirecting_factory_constructor_signature",
  [sym_redirection] = "redirection",
  [sym_constructor_signature] = "constructor_signature",
  [sym_constant_constructor_signature] = "constant_constructor_signature",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_initialized_variable_definition] = "initialized_variable_definition",
  [sym__declared_identifier] = "_declared_identifier",
  [sym__final_const_var_or_type] = "_final_const_var_or_type",
  [sym__type] = "_type",
  [sym__type_not_function] = "_type_not_function",
  [sym__type_not_void_not_function] = "_type_not_void_not_function",
  [sym_function_type] = "function_type",
  [aux_sym__function_type_tails] = "_function_type_tails",
  [sym__function_type_tail] = "_function_type_tail",
  [sym_parameter_type_list] = "parameter_type_list",
  [sym_normal_parameter_type] = "normal_parameter_type",
  [sym_optional_parameter_types] = "optional_parameter_types",
  [sym_optional_positional_parameter_types] = "optional_positional_parameter_types",
  [sym_named_parameter_types] = "named_parameter_types",
  [sym__type_not_void] = "_type_not_void",
  [sym__type_not_void_list] = "_type_not_void_list",
  [sym__type_name] = "_type_name",
  [sym__type_dot_identifier] = "_type_dot_identifier",
  [sym_typed_identifier] = "typed_identifier",
  [sym__nullable_type] = "_nullable_type",
  [sym_inferred_type] = "inferred_type",
  [sym_function_body] = "function_body",
  [sym_function_expression_body] = "function_expression_body",
  [sym_function_signature] = "function_signature",
  [sym__formal_parameter_part] = "_formal_parameter_part",
  [sym_formal_parameter_list] = "formal_parameter_list",
  [sym__strict_formal_parameter_list] = "_strict_formal_parameter_list",
  [sym__normal_formal_parameters] = "_normal_formal_parameters",
  [sym_optional_formal_parameters] = "optional_formal_parameters",
  [sym__optional_postional_formal_parameters] = "_optional_postional_formal_parameters",
  [sym__named_formal_parameters] = "_named_formal_parameters",
  [sym_formal_parameter] = "formal_parameter",
  [sym__default_formal_parameter] = "_default_formal_parameter",
  [sym__default_named_parameter] = "_default_named_parameter",
  [sym__normal_formal_parameter] = "_normal_formal_parameter",
  [sym__function_formal_parameter] = "_function_formal_parameter",
  [sym__simple_formal_parameter] = "_simple_formal_parameter",
  [sym_constructor_param] = "constructor_param",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym_script_tag] = "script_tag",
  [sym_library_name] = "library_name",
  [sym_dotted_identifier_list] = "dotted_identifier_list",
  [sym_qualified] = "qualified",
  [sym__as] = "_as",
  [sym__covariant] = "_covariant",
  [sym__deferred] = "_deferred",
  [sym__export] = "_export",
  [sym__external] = "_external",
  [sym__factory] = "_factory",
  [sym__function_builtin_identifier] = "_function_builtin_identifier",
  [sym__get] = "_get",
  [sym__native] = "_native",
  [sym__implements] = "_implements",
  [sym__import] = "_import",
  [sym__operator] = "_operator",
  [sym__mixin] = "_mixin",
  [sym__set] = "_set",
  [sym__static] = "_static",
  [sym__typedef] = "_typedef",
  [sym__new_builtin] = "_new_builtin",
  [sym__late_builtin] = "_late_builtin",
  [sym__external_builtin] = "_external_builtin",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_label] = "label",
  [sym__semicolon] = "_semicolon",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_program_repeat2] = "program_repeat2",
  [aux_sym_program_repeat3] = "program_repeat3",
  [aux_sym_program_repeat4] = "program_repeat4",
  [aux_sym_program_repeat5] = "program_repeat5",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym__string_literal_double_quotes_repeat1] = "_string_literal_double_quotes_repeat1",
  [aux_sym__string_literal_single_quotes_repeat1] = "_string_literal_single_quotes_repeat1",
  [aux_sym__string_literal_double_quotes_multiple_repeat1] = "_string_literal_double_quotes_multiple_repeat1",
  [aux_sym__string_literal_single_quotes_multiple_repeat1] = "_string_literal_single_quotes_multiple_repeat1",
  [aux_sym__raw_string_literal_double_quotes_repeat1] = "_raw_string_literal_double_quotes_repeat1",
  [aux_sym__raw_string_literal_single_quotes_repeat1] = "_raw_string_literal_single_quotes_repeat1",
  [aux_sym__raw_string_literal_double_quotes_multiple_repeat1] = "_raw_string_literal_double_quotes_multiple_repeat1",
  [aux_sym__raw_string_literal_single_quotes_multiple_repeat1] = "_raw_string_literal_single_quotes_multiple_repeat1",
  [aux_sym_list_literal_repeat1] = "list_literal_repeat1",
  [aux_sym__expression_repeat1] = "_expression_repeat1",
  [aux_sym__assignable_selector_part_repeat1] = "_assignable_selector_part_repeat1",
  [aux_sym_inferred_parameters_repeat1] = "inferred_parameters_repeat1",
  [aux_sym_logical_or_expression_repeat1] = "logical_or_expression_repeat1",
  [aux_sym_logical_and_expression_repeat1] = "logical_and_expression_repeat1",
  [aux_sym_bitwise_or_expression_repeat1] = "bitwise_or_expression_repeat1",
  [aux_sym_bitwise_xor_expression_repeat1] = "bitwise_xor_expression_repeat1",
  [aux_sym_bitwise_and_expression_repeat1] = "bitwise_and_expression_repeat1",
  [aux_sym_shift_expression_repeat1] = "shift_expression_repeat1",
  [aux_sym_additive_expression_repeat1] = "additive_expression_repeat1",
  [aux_sym_multiplicative_expression_repeat1] = "multiplicative_expression_repeat1",
  [aux_sym__argument_list_repeat1] = "_argument_list_repeat1",
  [aux_sym__argument_list_repeat2] = "_argument_list_repeat2",
  [aux_sym__argument_list_repeat3] = "_argument_list_repeat3",
  [aux_sym_cascade_section_repeat1] = "cascade_section_repeat1",
  [aux_sym_cascade_section_repeat2] = "cascade_section_repeat2",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_switch_block_repeat1] = "switch_block_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym__for_loop_parts_repeat1] = "_for_loop_parts_repeat1",
  [aux_sym__for_loop_parts_repeat2] = "_for_loop_parts_repeat2",
  [aux_sym_library_export_repeat1] = "library_export_repeat1",
  [aux_sym_configurable_uri_repeat1] = "configurable_uri_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym__metadata_repeat1] = "_metadata_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_extension_body_repeat1] = "extension_body_repeat1",
  [aux_sym_initialized_identifier_list_repeat1] = "initialized_identifier_list_repeat1",
  [aux_sym_static_final_declaration_list_repeat1] = "static_final_declaration_list_repeat1",
  [aux_sym_initializers_repeat1] = "initializers_repeat1",
  [aux_sym_factory_constructor_signature_repeat1] = "factory_constructor_signature_repeat1",
  [aux_sym_parameter_type_list_repeat1] = "parameter_type_list_repeat1",
  [aux_sym_named_parameter_types_repeat1] = "named_parameter_types_repeat1",
  [aux_sym__type_not_void_list_repeat1] = "_type_not_void_list_repeat1",
  [aux_sym__normal_formal_parameters_repeat1] = "_normal_formal_parameters_repeat1",
  [aux_sym_positional_parameters_repeat1] = "positional_parameters_repeat1",
  [aux_sym__named_formal_parameters_repeat1] = "_named_formal_parameters_repeat1",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_POUND] = anon_sym_POUND,
  [sym_decimal_integer_literal] = sym_decimal_integer_literal,
  [sym_hex_integer_literal] = sym_hex_integer_literal,
  [sym_decimal_floating_point_literal] = sym_decimal_floating_point_literal,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE_SQUOTE,
  [anon_sym_r_DQUOTE] = anon_sym_r_DQUOTE,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_r_SQUOTE] = anon_sym_r_SQUOTE,
  [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = anon_sym_r_DQUOTE_DQUOTE_DQUOTE,
  [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = anon_sym_r_SQUOTE_SQUOTE_SQUOTE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [aux_sym__sub_string_test_token1] = aux_sym__sub_string_test_token1,
  [sym__unused_escape_sequence] = sym__unused_escape_sequence,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_null] = anon_sym_null,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [sym_equality_operator] = sym_equality_operator,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [sym__additive_operator] = sym__additive_operator,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_TILDE_SLASH] = anon_sym_TILDE_SLASH,
  [sym_increment_operator] = sym_increment_operator,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [sym_minus_operator] = sym_minus_operator,
  [sym__exclamation_operator] = sym__exclamation_operator,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_on] = anon_sym_on,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_transitive] = anon_sym_transitive,
  [anon_sym_part] = anon_sym_part,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_show] = anon_sym_show,
  [anon_sym_hide] = anon_sym_hide,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extension] = anon_sym_extension,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_LBRACK_RBRACK_EQ] = anon_sym_LBRACK_RBRACK_EQ,
  [anon_sym_super] = anon_sym_super,
  [sym_floating_point_type] = sym_floating_point_type,
  [anon_sym_bool] = anon_sym_bool,
  [sym_void_type] = sym_void_type,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_async_STAR] = anon_sym_async_STAR,
  [anon_sym_sync_STAR] = anon_sym_sync_STAR,
  [anon_sym_required] = anon_sym_required,
  [anon_sym_throws] = anon_sym_throws,
  [anon_sym_POUND_BANG] = anon_sym_POUND_BANG,
  [aux_sym_script_tag_token1] = aux_sym_script_tag_token1,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_library] = anon_sym_library,
  [sym__break_builtin] = sym__break_builtin,
  [sym__assert_builtin] = sym__assert_builtin,
  [sym_case_builtin] = sym_case_builtin,
  [anon_sym_covariant] = anon_sym_covariant,
  [anon_sym_deferred] = anon_sym_deferred,
  [anon_sym_dynamic] = anon_sym_dynamic,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_factory] = anon_sym_factory,
  [anon_sym_Function] = anon_sym_Function,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_operator] = anon_sym_operator,
  [anon_sym_mixin] = anon_sym_mixin,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_typedef] = anon_sym_typedef,
  [anon_sym_new] = anon_sym_new,
  [sym_const_builtin] = sym_const_builtin,
  [sym_final_builtin] = sym_final_builtin,
  [anon_sym_late] = anon_sym_late,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_this] = anon_sym_this,
  [sym_identifier_dollar_escaped] = sym_identifier_dollar_escaped,
  [sym_comment] = sym_comment,
  [sym_documentation_comment] = sym_documentation_comment,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars_double] = sym__template_chars_double,
  [sym__template_chars_single] = sym__template_chars_single,
  [sym__template_chars_double_single] = sym__template_chars_double_single,
  [sym__template_chars_single_single] = sym__template_chars_single_single,
  [sym__template_chars_raw_slash] = sym__template_chars_raw_slash,
  [sym_program] = sym_program,
  [sym__top_level_definition] = sym__top_level_definition,
  [sym__literal] = sym__literal,
  [sym_symbol_literal] = sym_symbol_literal,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_string_literal] = sym_string_literal,
  [sym__string_literal_double_quotes] = sym__string_literal_double_quotes,
  [sym__string_literal_single_quotes] = sym__string_literal_single_quotes,
  [sym__string_literal_double_quotes_multiple] = sym__string_literal_double_quotes_multiple,
  [sym__string_literal_single_quotes_multiple] = sym__string_literal_single_quotes_multiple,
  [sym__raw_string_literal_double_quotes] = sym__raw_string_literal_double_quotes,
  [sym__raw_string_literal_single_quotes] = sym__raw_string_literal_single_quotes,
  [sym__raw_string_literal_double_quotes_multiple] = sym__raw_string_literal_double_quotes_multiple,
  [sym__raw_string_literal_single_quotes_multiple] = sym__raw_string_literal_single_quotes_multiple,
  [sym_template_substitution] = sym_template_substitution,
  [sym__sub_string_test] = sym__sub_string_test,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_list_literal] = sym_list_literal,
  [sym_set_or_map_literal] = sym_set_or_map_literal,
  [sym_pair] = sym_pair,
  [sym__element] = sym__element,
  [sym_null_literal] = sym_null_literal,
  [sym__expression] = sym__expression,
  [sym__expression_without_cascade] = sym__expression_without_cascade,
  [sym__real_expression] = sym__real_expression,
  [sym_throw_expression] = sym_throw_expression,
  [sym_throw_expression_without_cascade] = sym_throw_expression_without_cascade,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_assignment_expression_without_cascade] = sym_assignment_expression_without_cascade,
  [sym_assignable_expression] = sym_assignable_expression,
  [sym__assignable_selector_part] = sym__assignable_selector_part,
  [sym__assignment_operator] = sym__assignment_operator,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_function_expression] = sym_function_expression,
  [sym_if_null_expression] = sym_if_null_expression,
  [aux_sym__if_null_expression] = aux_sym__if_null_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_logical_or_expression] = sym_logical_or_expression,
  [sym_logical_and_expression] = sym_logical_and_expression,
  [sym_equality_expression] = sym_equality_expression,
  [sym_type_cast_expression] = sym_type_cast_expression,
  [sym_type_test_expression] = sym_type_test_expression,
  [sym_relational_expression] = sym_relational_expression,
  [sym_relational_operator] = sym_relational_operator,
  [sym_bitwise_or_expression] = sym_bitwise_or_expression,
  [sym_bitwise_xor_expression] = sym_bitwise_xor_expression,
  [sym_bitwise_and_expression] = sym_bitwise_and_expression,
  [sym_shift_expression] = sym_shift_expression,
  [sym_additive_expression] = sym_additive_expression,
  [sym_multiplicative_expression] = sym_multiplicative_expression,
  [sym_bitwise_operator] = sym_bitwise_operator,
  [sym__bitwise_operator] = sym__bitwise_operator,
  [sym_shift_operator] = sym_shift_operator,
  [sym__shift_operator] = sym__shift_operator,
  [sym_additive_operator] = sym_additive_operator,
  [sym_multiplicative_operator] = sym_multiplicative_operator,
  [sym__multiplicative_operator] = sym__multiplicative_operator,
  [sym__unary_expression] = sym__unary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym__postfix_expression] = sym__postfix_expression,
  [sym_postfix_expression] = sym_postfix_expression,
  [sym_postfix_operator] = sym_postfix_operator,
  [sym_spread_element] = sym_spread_element,
  [sym_selector] = sym_selector,
  [sym_prefix_operator] = sym_prefix_operator,
  [sym_negation_operator] = sym_negation_operator,
  [sym_tilde_operator] = sym_tilde_operator,
  [sym_await_expression] = sym_await_expression,
  [sym_type_test] = sym_type_test,
  [sym_is_operator] = sym_is_operator,
  [sym_type_cast] = sym_type_cast,
  [sym_as_operator] = sym_as_operator,
  [sym_new_expression] = sym_new_expression,
  [sym__dot_identifier] = sym__dot_identifier,
  [sym_const_object_expression] = sym_const_object_expression,
  [sym__primary] = sym__primary,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_constructor_invocation] = sym_constructor_invocation,
  [sym_arguments] = sym_arguments,
  [sym__argument_list] = sym__argument_list,
  [sym_argument] = sym_argument,
  [sym_named_argument] = sym_named_argument,
  [sym_cascade_section] = sym_cascade_section,
  [sym__cascade_subsection] = sym__cascade_subsection,
  [sym__cascade_assignment_section] = sym__cascade_assignment_section,
  [sym_cascade_selector] = sym_cascade_selector,
  [sym_argument_part] = sym_argument_part,
  [sym_unconditional_assignable_selector] = sym_unconditional_assignable_selector,
  [sym_conditional_assignable_selector] = sym_conditional_assignable_selector,
  [sym__assignable_selector] = sym__assignable_selector,
  [sym_type_arguments] = sym_type_arguments,
  [sym__statement] = sym__statement,
  [sym_block] = sym_block,
  [sym_expression_statement] = sym_expression_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_assert_statement] = sym_assert_statement,
  [sym_assertion] = sym_assertion,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_block] = sym_switch_block,
  [sym_switch_label] = sym_switch_label,
  [sym_do_statement] = sym_do_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_yield_statement] = sym_yield_statement,
  [sym_yield_each_statement] = sym_yield_each_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_try_statement] = sym_try_statement,
  [sym__on_part] = sym__on_part,
  [sym__try_head] = sym__try_head,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_if_element] = sym_if_element,
  [sym_if_statement] = sym_if_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_for_statement] = sym_for_statement,
  [sym__for_loop_parts] = sym__for_loop_parts,
  [sym_for_element] = sym_for_element,
  [sym__annotation] = sym__annotation,
  [sym_marker_annotation] = sym_marker_annotation,
  [sym_annotation] = sym_annotation,
  [sym_import_or_export] = sym_import_or_export,
  [sym_library_import] = sym_library_import,
  [sym_library_export] = sym_library_export,
  [sym_import_specification] = sym_import_specification,
  [sym_part_directive] = sym_part_directive,
  [sym_part_of_directive] = sym_part_of_directive,
  [sym_uri] = sym_uri,
  [sym_configurable_uri] = sym_configurable_uri,
  [sym_configuration_uri] = sym_configuration_uri,
  [sym_uri_test] = sym_uri_test,
  [sym_combinator] = sym_combinator,
  [sym__identifier_list] = sym__identifier_list,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_constant] = sym_enum_constant,
  [sym_type_alias] = sym_type_alias,
  [sym_class_definition] = sym_class_definition,
  [sym_extension_declaration] = sym_extension_declaration,
  [sym__metadata] = sym__metadata,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_bound] = sym_type_bound,
  [sym_superclass] = sym_superclass,
  [sym_mixins] = sym_mixins,
  [sym_mixin_application_class] = sym_mixin_application_class,
  [sym_mixin_application] = sym_mixin_application,
  [sym_mixin_declaration] = sym_mixin_declaration,
  [sym_interfaces] = sym_interfaces,
  [sym_class_body] = sym_class_body,
  [sym_extension_body] = sym_extension_body,
  [sym_getter_signature] = sym_getter_signature,
  [sym_setter_signature] = sym_setter_signature,
  [sym_method_signature] = sym_method_signature,
  [sym_declaration] = sym_declaration,
  [sym_initialized_identifier_list] = sym_initialized_identifier_list,
  [sym_initialized_identifier] = sym_initialized_identifier,
  [sym_static_final_declaration_list] = sym_static_final_declaration_list,
  [sym_binary_operator] = sym_binary_operator,
  [sym_operator_signature] = sym_operator_signature,
  [sym_static_final_declaration] = sym_static_final_declaration,
  [sym__external_and_static] = sym__external_and_static,
  [sym__static_or_covariant] = sym__static_or_covariant,
  [sym__final_or_const] = sym__final_or_const,
  [sym_initializers] = sym_initializers,
  [sym_initializer_list_entry] = sym_initializer_list_entry,
  [sym_field_initializer] = sym_field_initializer,
  [sym_factory_constructor_signature] = sym_factory_constructor_signature,
  [sym_redirecting_factory_constructor_signature] = sym_redirecting_factory_constructor_signature,
  [sym_redirection] = sym_redirection,
  [sym_constructor_signature] = sym_constructor_signature,
  [sym_constant_constructor_signature] = sym_constant_constructor_signature,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_initialized_variable_definition] = sym_initialized_variable_definition,
  [sym__declared_identifier] = sym__declared_identifier,
  [sym__final_const_var_or_type] = sym__final_const_var_or_type,
  [sym__type] = sym__type,
  [sym__type_not_function] = sym__type_not_function,
  [sym__type_not_void_not_function] = sym__type_not_void_not_function,
  [sym_function_type] = sym_function_type,
  [aux_sym__function_type_tails] = aux_sym__function_type_tails,
  [sym__function_type_tail] = sym__function_type_tail,
  [sym_parameter_type_list] = sym_parameter_type_list,
  [sym_normal_parameter_type] = sym_normal_parameter_type,
  [sym_optional_parameter_types] = sym_optional_parameter_types,
  [sym_optional_positional_parameter_types] = sym_optional_positional_parameter_types,
  [sym_named_parameter_types] = sym_named_parameter_types,
  [sym__type_not_void] = sym__type_not_void,
  [sym__type_not_void_list] = sym__type_not_void_list,
  [sym__type_name] = sym__type_name,
  [sym__type_dot_identifier] = sym__type_dot_identifier,
  [sym_typed_identifier] = sym_typed_identifier,
  [sym__nullable_type] = sym__nullable_type,
  [sym_inferred_type] = sym_inferred_type,
  [sym_function_body] = sym_function_body,
  [sym_function_expression_body] = sym_function_expression_body,
  [sym_function_signature] = sym_function_signature,
  [sym__formal_parameter_part] = sym__formal_parameter_part,
  [sym_formal_parameter_list] = sym_formal_parameter_list,
  [sym__strict_formal_parameter_list] = sym__strict_formal_parameter_list,
  [sym__normal_formal_parameters] = sym__normal_formal_parameters,
  [sym_optional_formal_parameters] = sym_optional_formal_parameters,
  [sym__optional_postional_formal_parameters] = sym__optional_postional_formal_parameters,
  [sym__named_formal_parameters] = sym__named_formal_parameters,
  [sym_formal_parameter] = sym_formal_parameter,
  [sym__default_formal_parameter] = sym__default_formal_parameter,
  [sym__default_named_parameter] = sym__default_named_parameter,
  [sym__normal_formal_parameter] = sym__normal_formal_parameter,
  [sym__function_formal_parameter] = sym__function_formal_parameter,
  [sym__simple_formal_parameter] = sym__simple_formal_parameter,
  [sym_constructor_param] = sym_constructor_param,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym_script_tag] = sym_script_tag,
  [sym_library_name] = sym_library_name,
  [sym_dotted_identifier_list] = sym_dotted_identifier_list,
  [sym_qualified] = sym_qualified,
  [sym__as] = sym__as,
  [sym__covariant] = sym__covariant,
  [sym__deferred] = sym__deferred,
  [sym__export] = sym__export,
  [sym__external] = sym__external,
  [sym__factory] = sym__factory,
  [sym__function_builtin_identifier] = sym__function_builtin_identifier,
  [sym__get] = sym__get,
  [sym__native] = sym__native,
  [sym__implements] = sym__implements,
  [sym__import] = sym__import,
  [sym__operator] = sym__operator,
  [sym__mixin] = sym__mixin,
  [sym__set] = sym__set,
  [sym__static] = sym__static,
  [sym__typedef] = sym__typedef,
  [sym__new_builtin] = sym__new_builtin,
  [sym__late_builtin] = sym__late_builtin,
  [sym__external_builtin] = sym__external_builtin,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_label] = sym_label,
  [sym__semicolon] = sym__semicolon,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_program_repeat2] = aux_sym_program_repeat2,
  [aux_sym_program_repeat3] = aux_sym_program_repeat3,
  [aux_sym_program_repeat4] = aux_sym_program_repeat4,
  [aux_sym_program_repeat5] = aux_sym_program_repeat5,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym__string_literal_double_quotes_repeat1] = aux_sym__string_literal_double_quotes_repeat1,
  [aux_sym__string_literal_single_quotes_repeat1] = aux_sym__string_literal_single_quotes_repeat1,
  [aux_sym__string_literal_double_quotes_multiple_repeat1] = aux_sym__string_literal_double_quotes_multiple_repeat1,
  [aux_sym__string_literal_single_quotes_multiple_repeat1] = aux_sym__string_literal_single_quotes_multiple_repeat1,
  [aux_sym__raw_string_literal_double_quotes_repeat1] = aux_sym__raw_string_literal_double_quotes_repeat1,
  [aux_sym__raw_string_literal_single_quotes_repeat1] = aux_sym__raw_string_literal_single_quotes_repeat1,
  [aux_sym__raw_string_literal_double_quotes_multiple_repeat1] = aux_sym__raw_string_literal_double_quotes_multiple_repeat1,
  [aux_sym__raw_string_literal_single_quotes_multiple_repeat1] = aux_sym__raw_string_literal_single_quotes_multiple_repeat1,
  [aux_sym_list_literal_repeat1] = aux_sym_list_literal_repeat1,
  [aux_sym__expression_repeat1] = aux_sym__expression_repeat1,
  [aux_sym__assignable_selector_part_repeat1] = aux_sym__assignable_selector_part_repeat1,
  [aux_sym_inferred_parameters_repeat1] = aux_sym_inferred_parameters_repeat1,
  [aux_sym_logical_or_expression_repeat1] = aux_sym_logical_or_expression_repeat1,
  [aux_sym_logical_and_expression_repeat1] = aux_sym_logical_and_expression_repeat1,
  [aux_sym_bitwise_or_expression_repeat1] = aux_sym_bitwise_or_expression_repeat1,
  [aux_sym_bitwise_xor_expression_repeat1] = aux_sym_bitwise_xor_expression_repeat1,
  [aux_sym_bitwise_and_expression_repeat1] = aux_sym_bitwise_and_expression_repeat1,
  [aux_sym_shift_expression_repeat1] = aux_sym_shift_expression_repeat1,
  [aux_sym_additive_expression_repeat1] = aux_sym_additive_expression_repeat1,
  [aux_sym_multiplicative_expression_repeat1] = aux_sym_multiplicative_expression_repeat1,
  [aux_sym__argument_list_repeat1] = aux_sym__argument_list_repeat1,
  [aux_sym__argument_list_repeat2] = aux_sym__argument_list_repeat2,
  [aux_sym__argument_list_repeat3] = aux_sym__argument_list_repeat3,
  [aux_sym_cascade_section_repeat1] = aux_sym_cascade_section_repeat1,
  [aux_sym_cascade_section_repeat2] = aux_sym_cascade_section_repeat2,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_switch_block_repeat1] = aux_sym_switch_block_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym__for_loop_parts_repeat1] = aux_sym__for_loop_parts_repeat1,
  [aux_sym__for_loop_parts_repeat2] = aux_sym__for_loop_parts_repeat2,
  [aux_sym_library_export_repeat1] = aux_sym_library_export_repeat1,
  [aux_sym_configurable_uri_repeat1] = aux_sym_configurable_uri_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym__metadata_repeat1] = aux_sym__metadata_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_extension_body_repeat1] = aux_sym_extension_body_repeat1,
  [aux_sym_initialized_identifier_list_repeat1] = aux_sym_initialized_identifier_list_repeat1,
  [aux_sym_static_final_declaration_list_repeat1] = aux_sym_static_final_declaration_list_repeat1,
  [aux_sym_initializers_repeat1] = aux_sym_initializers_repeat1,
  [aux_sym_factory_constructor_signature_repeat1] = aux_sym_factory_constructor_signature_repeat1,
  [aux_sym_parameter_type_list_repeat1] = aux_sym_parameter_type_list_repeat1,
  [aux_sym_named_parameter_types_repeat1] = aux_sym_named_parameter_types_repeat1,
  [aux_sym__type_not_void_list_repeat1] = aux_sym__type_not_void_list_repeat1,
  [aux_sym__normal_formal_parameters_repeat1] = aux_sym__normal_formal_parameters_repeat1,
  [aux_sym_positional_parameters_repeat1] = aux_sym_positional_parameters_repeat1,
  [aux_sym__named_formal_parameters_repeat1] = aux_sym__named_formal_parameters_repeat1,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__sub_string_test_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__unused_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_equality_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [sym__additive_operator] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_increment_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_minus_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__exclamation_operator] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_on] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_part] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_show] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hide] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extension] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_super] = {
    .visible = true,
    .named = false,
  },
  [sym_floating_point_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [sym_void_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sync_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_required] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throws] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_script_tag_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_library] = {
    .visible = true,
    .named = false,
  },
  [sym__break_builtin] = {
    .visible = false,
    .named = true,
  },
  [sym__assert_builtin] = {
    .visible = false,
    .named = true,
  },
  [sym_case_builtin] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_covariant] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_deferred] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dynamic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_factory] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_operator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mixin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [sym_const_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_final_builtin] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_late] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_this] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier_dollar_escaped] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_documentation_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars_double] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars_single] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars_double_single] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars_single_single] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars_raw_slash] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_definition] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_symbol_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__string_literal_double_quotes] = {
    .visible = false,
    .named = true,
  },
  [sym__string_literal_single_quotes] = {
    .visible = false,
    .named = true,
  },
  [sym__string_literal_double_quotes_multiple] = {
    .visible = false,
    .named = true,
  },
  [sym__string_literal_single_quotes_multiple] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_string_literal_double_quotes] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_string_literal_single_quotes] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_string_literal_double_quotes_multiple] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_string_literal_single_quotes_multiple] = {
    .visible = false,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym__sub_string_test] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_list_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_or_map_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__element] = {
    .visible = false,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_without_cascade] = {
    .visible = false,
    .named = true,
  },
  [sym__real_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_throw_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_expression_without_cascade] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression_without_cascade] = {
    .visible = true,
    .named = true,
  },
  [sym_assignable_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__assignable_selector_part] = {
    .visible = false,
    .named = true,
  },
  [sym__assignment_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_if_null_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__if_null_expression] = {
    .visible = false,
    .named = false,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_test_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_relational_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_relational_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_xor_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_multiplicative_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__bitwise_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_shift_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__shift_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_additive_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_multiplicative_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__multiplicative_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__unary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__postfix_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_negation_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_tilde_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_test] = {
    .visible = true,
    .named = true,
  },
  [sym_is_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_type_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_as_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__dot_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_const_object_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__primary] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__argument_list] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_named_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_cascade_section] = {
    .visible = true,
    .named = true,
  },
  [sym__cascade_subsection] = {
    .visible = false,
    .named = true,
  },
  [sym__cascade_assignment_section] = {
    .visible = false,
    .named = true,
  },
  [sym_cascade_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_part] = {
    .visible = true,
    .named = true,
  },
  [sym_unconditional_assignable_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_assignable_selector] = {
    .visible = true,
    .named = true,
  },
  [sym__assignable_selector] = {
    .visible = false,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yield_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yield_each_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__on_part] = {
    .visible = false,
    .named = true,
  },
  [sym__try_head] = {
    .visible = false,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_element] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_loop_parts] = {
    .visible = false,
    .named = true,
  },
  [sym_for_element] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_marker_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_import_or_export] = {
    .visible = true,
    .named = true,
  },
  [sym_library_import] = {
    .visible = true,
    .named = true,
  },
  [sym_library_export] = {
    .visible = true,
    .named = true,
  },
  [sym_import_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_part_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_part_of_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_uri] = {
    .visible = true,
    .named = true,
  },
  [sym_configurable_uri] = {
    .visible = true,
    .named = true,
  },
  [sym_configuration_uri] = {
    .visible = true,
    .named = true,
  },
  [sym_uri_test] = {
    .visible = true,
    .named = true,
  },
  [sym_combinator] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier_list] = {
    .visible = false,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_extension_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__metadata] = {
    .visible = false,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_superclass] = {
    .visible = true,
    .named = true,
  },
  [sym_mixins] = {
    .visible = true,
    .named = true,
  },
  [sym_mixin_application_class] = {
    .visible = true,
    .named = true,
  },
  [sym_mixin_application] = {
    .visible = true,
    .named = true,
  },
  [sym_mixin_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_extension_body] = {
    .visible = true,
    .named = true,
  },
  [sym_getter_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_setter_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_initialized_identifier_list] = {
    .visible = true,
    .named = true,
  },
  [sym_initialized_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_static_final_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_static_final_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__external_and_static] = {
    .visible = false,
    .named = true,
  },
  [sym__static_or_covariant] = {
    .visible = false,
    .named = true,
  },
  [sym__final_or_const] = {
    .visible = false,
    .named = true,
  },
  [sym_initializers] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_list_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_factory_constructor_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_redirecting_factory_constructor_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_redirection] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_constructor_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_initialized_variable_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__declared_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__final_const_var_or_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_not_function] = {
    .visible = false,
    .named = true,
  },
  [sym__type_not_void_not_function] = {
    .visible = false,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__function_type_tails] = {
    .visible = false,
    .named = false,
  },
  [sym__function_type_tail] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_parameter_type] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_positional_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_named_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym__type_not_void] = {
    .visible = false,
    .named = true,
  },
  [sym__type_not_void_list] = {
    .visible = false,
    .named = true,
  },
  [sym__type_name] = {
    .visible = false,
    .named = true,
  },
  [sym__type_dot_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_typed_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__nullable_type] = {
    .visible = false,
    .named = true,
  },
  [sym_inferred_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym__formal_parameter_part] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym__strict_formal_parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym__normal_formal_parameters] = {
    .visible = false,
    .named = true,
  },
  [sym_optional_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__optional_postional_formal_parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__named_formal_parameters] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__default_formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym__default_named_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym__normal_formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym__function_formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_param] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_script_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_library_name] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_identifier_list] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified] = {
    .visible = true,
    .named = true,
  },
  [sym__as] = {
    .visible = false,
    .named = true,
  },
  [sym__covariant] = {
    .visible = false,
    .named = true,
  },
  [sym__deferred] = {
    .visible = false,
    .named = true,
  },
  [sym__export] = {
    .visible = false,
    .named = true,
  },
  [sym__external] = {
    .visible = false,
    .named = true,
  },
  [sym__factory] = {
    .visible = false,
    .named = true,
  },
  [sym__function_builtin_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__get] = {
    .visible = false,
    .named = true,
  },
  [sym__native] = {
    .visible = false,
    .named = true,
  },
  [sym__implements] = {
    .visible = false,
    .named = true,
  },
  [sym__import] = {
    .visible = false,
    .named = true,
  },
  [sym__operator] = {
    .visible = false,
    .named = true,
  },
  [sym__mixin] = {
    .visible = false,
    .named = true,
  },
  [sym__set] = {
    .visible = false,
    .named = true,
  },
  [sym__static] = {
    .visible = false,
    .named = true,
  },
  [sym__typedef] = {
    .visible = false,
    .named = true,
  },
  [sym__new_builtin] = {
    .visible = false,
    .named = true,
  },
  [sym__late_builtin] = {
    .visible = false,
    .named = true,
  },
  [sym__external_builtin] = {
    .visible = false,
    .named = true,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_program_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_program_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_program_repeat4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_program_repeat5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_literal_double_quotes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_literal_single_quotes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_literal_double_quotes_multiple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_literal_single_quotes_multiple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__raw_string_literal_double_quotes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__raw_string_literal_single_quotes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__raw_string_literal_double_quotes_multiple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__raw_string_literal_single_quotes_multiple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__assignable_selector_part_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inferred_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_logical_or_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_logical_and_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bitwise_or_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bitwise_xor_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bitwise_and_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shift_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_additive_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multiplicative_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__argument_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__argument_list_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cascade_section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cascade_section_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__for_loop_parts_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__for_loop_parts_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_library_export_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_configurable_uri_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__metadata_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extension_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initialized_identifier_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_static_final_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_factory_constructor_signature_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_parameter_types_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_not_void_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__normal_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_positional_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__named_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_class = 4,
  field_condition = 5,
  field_consequence = 6,
  field_first = 7,
  field_init = 8,
  field_interfaces = 9,
  field_key = 10,
  field_left = 11,
  field_name = 12,
  field_operator = 13,
  field_parameters = 14,
  field_right = 15,
  field_scope = 16,
  field_second = 17,
  field_superclass = 18,
  field_type_parameters = 19,
  field_update = 20,
  field_value = 21,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_class] = "class",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_first] = "first",
  [field_init] = "init",
  [field_interfaces] = "interfaces",
  [field_key] = "key",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_second] = "second",
  [field_superclass] = "superclass",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 2},
  [7] = {.index = 6, .length = 1},
  [8] = {.index = 7, .length = 2},
  [9] = {.index = 3, .length = 1},
  [10] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 2},
  [13] = {.index = 12, .length = 2},
  [14] = {.index = 14, .length = 2},
  [15] = {.index = 16, .length = 2},
  [16] = {.index = 18, .length = 1},
  [17] = {.index = 19, .length = 2},
  [18] = {.index = 21, .length = 3},
  [19] = {.index = 24, .length = 1},
  [20] = {.index = 25, .length = 2},
  [21] = {.index = 2, .length = 1},
  [22] = {.index = 27, .length = 2},
  [23] = {.index = 29, .length = 1},
  [24] = {.index = 30, .length = 1},
  [25] = {.index = 31, .length = 1},
  [26] = {.index = 32, .length = 2},
  [27] = {.index = 34, .length = 2},
  [28] = {.index = 36, .length = 3},
  [29] = {.index = 39, .length = 3},
  [30] = {.index = 42, .length = 3},
  [31] = {.index = 45, .length = 2},
  [32] = {.index = 47, .length = 1},
  [33] = {.index = 48, .length = 2},
  [34] = {.index = 50, .length = 3},
  [35] = {.index = 53, .length = 1},
  [36] = {.index = 54, .length = 1},
  [37] = {.index = 55, .length = 2},
  [38] = {.index = 57, .length = 2},
  [39] = {.index = 59, .length = 6},
  [40] = {.index = 65, .length = 2},
  [41] = {.index = 67, .length = 2},
  [42] = {.index = 69, .length = 1},
  [43] = {.index = 70, .length = 2},
  [44] = {.index = 72, .length = 1},
  [45] = {.index = 73, .length = 3},
  [46] = {.index = 76, .length = 3},
  [47] = {.index = 79, .length = 3},
  [48] = {.index = 82, .length = 2},
  [49] = {.index = 84, .length = 4},
  [50] = {.index = 88, .length = 4},
  [51] = {.index = 92, .length = 4},
  [52] = {.index = 96, .length = 3},
  [53] = {.index = 99, .length = 3},
  [54] = {.index = 102, .length = 2},
  [55] = {.index = 104, .length = 6},
  [56] = {.index = 110, .length = 2},
  [57] = {.index = 112, .length = 3},
  [58] = {.index = 115, .length = 2},
  [59] = {.index = 117, .length = 2},
  [60] = {.index = 119, .length = 3},
  [61] = {.index = 122, .length = 3},
  [62] = {.index = 125, .length = 2},
  [63] = {.index = 127, .length = 2},
  [64] = {.index = 129, .length = 2},
  [65] = {.index = 131, .length = 4},
  [66] = {.index = 135, .length = 4},
  [67] = {.index = 139, .length = 4},
  [68] = {.index = 143, .length = 5},
  [69] = {.index = 148, .length = 4},
  [70] = {.index = 152, .length = 3},
  [71] = {.index = 155, .length = 3},
  [72] = {.index = 158, .length = 3},
  [73] = {.index = 161, .length = 3},
  [74] = {.index = 164, .length = 4},
  [75] = {.index = 168, .length = 3},
  [76] = {.index = 171, .length = 5},
  [77] = {.index = 176, .length = 4},
  [78] = {.index = 180, .length = 4},
  [79] = {.index = 184, .length = 4},
  [80] = {.index = 188, .length = 4},
  [81] = {.index = 192, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0, .inherited = true},
  [1] =
    {field_body, 1},
  [2] =
    {field_name, 1},
  [3] =
    {field_name, 0},
  [4] =
    {field_first, 0},
    {field_second, 1, .inherited = true},
  [6] =
    {field_body, 0, .inherited = true},
  [7] =
    {field_body, 1},
    {field_parameters, 0},
  [9] =
    {field_name, 1, .inherited = true},
  [10] =
    {field_body, 2},
    {field_condition, 1},
  [12] =
    {field_condition, 1},
    {field_consequence, 2},
  [14] =
    {field_arguments, 2},
    {field_name, 1},
  [16] =
    {field_body, 2},
    {field_name, 1},
  [18] =
    {field_second, 1},
  [19] =
    {field_second, 0, .inherited = true},
    {field_second, 1, .inherited = true},
  [21] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [24] =
    {field_name, 2},
  [25] =
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [27] =
    {field_key, 0},
    {field_value, 2},
  [29] =
    {field_condition, 0},
  [30] =
    {field_init, 0},
  [31] =
    {field_update, 1},
  [32] =
    {field_name, 2},
    {field_scope, 0},
  [34] =
    {field_body, 3},
    {field_name, 2},
  [36] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [39] =
    {field_body, 3},
    {field_name, 1},
    {field_superclass, 2},
  [42] =
    {field_body, 3},
    {field_interfaces, 2},
    {field_name, 1},
  [45] =
    {field_body, 3},
    {field_class, 2},
  [47] =
    {field_name, 3},
  [48] =
    {field_body, 1},
    {field_condition, 3},
  [50] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [53] =
    {field_value, 2},
  [54] =
    {field_init, 1},
  [55] =
    {field_condition, 0},
    {field_update, 2},
  [57] =
    {field_init, 0, .inherited = true},
    {field_init, 1, .inherited = true},
  [59] =
    {field_body, 4},
    {field_condition, 2, .inherited = true},
    {field_init, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_update, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [65] =
    {field_condition, 1},
    {field_init, 0},
  [67] =
    {field_init, 0},
    {field_update, 2},
  [69] =
    {field_condition, 1},
  [70] =
    {field_update, 1},
    {field_update, 2, .inherited = true},
  [72] =
    {field_update, 2},
  [73] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [76] =
    {field_body, 4},
    {field_name, 2},
    {field_superclass, 3},
  [79] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 2},
  [82] =
    {field_name, 0},
    {field_parameters, 1},
  [84] =
    {field_body, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [88] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [92] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_superclass, 2},
  [96] =
    {field_body, 4},
    {field_class, 3},
    {field_name, 1},
  [99] =
    {field_body, 4},
    {field_class, 3},
    {field_type_parameters, 1},
  [102] =
    {field_alternative, 4},
    {field_consequence, 2},
  [104] =
    {field_body, 5},
    {field_condition, 3, .inherited = true},
    {field_init, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_update, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [110] =
    {field_condition, 2},
    {field_init, 0},
  [112] =
    {field_condition, 0},
    {field_update, 2},
    {field_update, 3, .inherited = true},
  [115] =
    {field_init, 0},
    {field_update, 3},
  [117] =
    {field_init, 0},
    {field_init, 1, .inherited = true},
  [119] =
    {field_condition, 1},
    {field_init, 0},
    {field_update, 3},
  [122] =
    {field_init, 0},
    {field_update, 2},
    {field_update, 3, .inherited = true},
  [125] =
    {field_condition, 1},
    {field_update, 3},
  [127] =
    {field_update, 0, .inherited = true},
    {field_update, 1, .inherited = true},
  [129] =
    {field_update, 2},
    {field_update, 3, .inherited = true},
  [131] =
    {field_body, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [135] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [139] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_superclass, 3},
  [143] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [148] =
    {field_body, 5},
    {field_class, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [152] =
    {field_condition, 2},
    {field_init, 0},
    {field_update, 4},
  [155] =
    {field_init, 0},
    {field_update, 3},
    {field_update, 4, .inherited = true},
  [158] =
    {field_condition, 3},
    {field_init, 0},
    {field_init, 1, .inherited = true},
  [161] =
    {field_init, 0},
    {field_init, 1, .inherited = true},
    {field_update, 4},
  [164] =
    {field_condition, 1},
    {field_init, 0},
    {field_update, 3},
    {field_update, 4, .inherited = true},
  [168] =
    {field_condition, 1},
    {field_update, 3},
    {field_update, 4, .inherited = true},
  [171] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [176] =
    {field_name, 0},
    {field_name, 1},
    {field_name, 2},
    {field_parameters, 3},
  [180] =
    {field_condition, 2},
    {field_init, 0},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [184] =
    {field_condition, 3},
    {field_init, 0},
    {field_init, 1, .inherited = true},
    {field_update, 5},
  [188] =
    {field_init, 0},
    {field_init, 1, .inherited = true},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [192] =
    {field_condition, 3},
    {field_init, 0},
    {field_init, 1, .inherited = true},
    {field_update, 5},
    {field_update, 6, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [9] = {
    [0] = sym_identifier,
  },
  [11] = {
    [1] = alias_sym_type_identifier,
  },
  [21] = {
    [1] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__get, 2,
    sym__get,
    sym_identifier,
  sym__set, 2,
    sym__set,
    sym_identifier,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(71);
      if (lookahead == '!') ADVANCE(149);
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '#') ADVANCE(73);
      if (lookahead == '$') ADVANCE(87);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(134);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == ')') ADVANCE(115);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(139);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '.') ADVANCE(156);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(75);
      if (lookahead == ':') ADVANCE(107);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '@') ADVANCE(163);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == '\\') ADVANCE(54);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(186);
      if (lookahead == 'r') ADVANCE(180);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(67)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(179);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(2)
      if (lookahead == '/') ADVANCE(176);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(177);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(149);
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(134);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == ')') ADVANCE(115);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(138);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ':') ADVANCE(107);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(109);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '@') ADVANCE(163);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == 'r') ADVANCE(180);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(149);
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(134);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(138);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(186);
      if (lookahead == 'r') ADVANCE(180);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '~') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(149);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(134);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == ')') ADVANCE(115);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(139);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(140);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ':') ADVANCE(107);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(109);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(149);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(134);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(139);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(140);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(186);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '~') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(148);
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(138);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ':') ADVANCE(107);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(124);
      if (lookahead == '=') ADVANCE(112);
      if (lookahead == '>') ADVANCE(43);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(53);
      if (lookahead == 'r') ADVANCE(16);
      if (lookahead == 's') ADVANCE(55);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(148);
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(42);
      if (lookahead == '?') ADVANCE(117);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(53);
      if (lookahead == 'r') ADVANCE(16);
      if (lookahead == 's') ADVANCE(55);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(148);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == ')') ADVANCE(115);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(138);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ':') ADVANCE(107);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(124);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(43);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(39);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(134);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == ')') ADVANCE(115);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(138);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ':') ADVANCE(107);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(119);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(39);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(134);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(138);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(40);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(119);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(186);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '~') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(39);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == ')') ADVANCE(115);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(138);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '.') ADVANCE(155);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ':') ADVANCE(107);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(116);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(188);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '\'') ADVANCE(81);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(54);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '\'') ADVANCE(81);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '\'') ADVANCE(81);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(94);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(93);
      END_STATE();
    case 16:
      if (lookahead == '"') ADVANCE(85);
      if (lookahead == '\'') ADVANCE(88);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(83);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(89);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(79);
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(138);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(41);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') ADVANCE(54);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      END_STATE();
    case 20:
      if (lookahead == '"') ADVANCE(79);
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(138);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(41);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      END_STATE();
    case 21:
      if (lookahead == '"') ADVANCE(79);
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(95);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(93);
      END_STATE();
    case 22:
      if (lookahead == '"') ADVANCE(79);
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '\'') ADVANCE(81);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(54);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      END_STATE();
    case 23:
      if (lookahead == '"') ADVANCE(79);
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '\'') ADVANCE(81);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      END_STATE();
    case 24:
      if (lookahead == '"') ADVANCE(79);
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '\'') ADVANCE(81);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(96);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(93);
      END_STATE();
    case 25:
      if (lookahead == '$') ADVANCE(192);
      END_STATE();
    case 26:
      if (lookahead == '\'') ADVANCE(84);
      END_STATE();
    case 27:
      if (lookahead == '\'') ADVANCE(90);
      END_STATE();
    case 28:
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == ')') ADVANCE(115);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '.') ADVANCE(155);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == ':') ADVANCE(107);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(116);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 29:
      if (lookahead == '*') ADVANCE(31);
      if (lookahead == '/') ADVANCE(37);
      END_STATE();
    case 30:
      if (lookahead == '*') ADVANCE(30);
      if (lookahead == '/') ADVANCE(193);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 31:
      if (lookahead == '*') ADVANCE(30);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 32:
      if (lookahead == '*') ADVANCE(171);
      END_STATE();
    case 33:
      if (lookahead == '+') ADVANCE(145);
      END_STATE();
    case 34:
      if (lookahead == '.') ADVANCE(146);
      END_STATE();
    case 35:
      if (lookahead == '.') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      END_STATE();
    case 36:
      if (lookahead == '/') ADVANCE(144);
      END_STATE();
    case 37:
      if (lookahead == '/') ADVANCE(195);
      if (lookahead != 0) ADVANCE(194);
      END_STATE();
    case 38:
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '\\') ADVANCE(97);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(99);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(192);
      if (lookahead != 0) ADVANCE(93);
      END_STATE();
    case 39:
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 40:
      if (lookahead == '=') ADVANCE(122);
      if (lookahead == '>') ADVANCE(169);
      END_STATE();
    case 41:
      if (lookahead == '=') ADVANCE(164);
      END_STATE();
    case 42:
      if (lookahead == '>') ADVANCE(169);
      END_STATE();
    case 43:
      if (lookahead == '>') ADVANCE(136);
      END_STATE();
    case 44:
      if (lookahead == ']') ADVANCE(165);
      END_STATE();
    case 45:
      if (lookahead == '_') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 46:
      if (lookahead == '_') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      END_STATE();
    case 47:
      if (lookahead == '_') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 48:
      if (lookahead == 'c') ADVANCE(32);
      END_STATE();
    case 49:
      if (lookahead == 'c') ADVANCE(167);
      END_STATE();
    case 50:
      if (lookahead == 'n') ADVANCE(48);
      END_STATE();
    case 51:
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 52:
      if (lookahead == 's') ADVANCE(152);
      END_STATE();
    case 53:
      if (lookahead == 's') ADVANCE(56);
      END_STATE();
    case 54:
      if (lookahead == 'u') ADVANCE(57);
      if (lookahead == 'x') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(103);
      if (lookahead != 0) ADVANCE(101);
      END_STATE();
    case 55:
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 56:
      if (lookahead == 'y') ADVANCE(51);
      END_STATE();
    case 57:
      if (lookahead == '{') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 58:
      if (lookahead == '}') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 59:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(101);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(76);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 66:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 67:
      if (eof) ADVANCE(71);
      if (lookahead == '!') ADVANCE(149);
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '#') ADVANCE(73);
      if (lookahead == '$') ADVANCE(87);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(134);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == ')') ADVANCE(115);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(139);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '.') ADVANCE(156);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(75);
      if (lookahead == ':') ADVANCE(107);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '@') ADVANCE(163);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(186);
      if (lookahead == 'r') ADVANCE(180);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(67)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 68:
      if (eof) ADVANCE(71);
      if (lookahead == '!') ADVANCE(149);
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '#') ADVANCE(72);
      if (lookahead == '%') ADVANCE(143);
      if (lookahead == '&') ADVANCE(134);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(139);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '.') ADVANCE(158);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(75);
      if (lookahead == ':') ADVANCE(107);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '@') ADVANCE(163);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == 'r') ADVANCE(180);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 69:
      if (eof) ADVANCE(71);
      if (lookahead == '!') ADVANCE(148);
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '#') ADVANCE(73);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == ')') ADVANCE(115);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(33);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '.') ADVANCE(35);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == '0') ADVANCE(75);
      if (lookahead == ':') ADVANCE(107);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(116);
      if (lookahead == '@') ADVANCE(163);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == 'r') ADVANCE(180);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(150);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(69)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 70:
      if (eof) ADVANCE(71);
      if (lookahead == '!') ADVANCE(148);
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '#') ADVANCE(72);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '(') ADVANCE(114);
      if (lookahead == ')') ADVANCE(115);
      if (lookahead == '+') ADVANCE(33);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '.') ADVANCE(158);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == '0') ADVANCE(75);
      if (lookahead == ':') ADVANCE(107);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(41);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(117);
      if (lookahead == '@') ADVANCE(163);
      if (lookahead == '[') ADVANCE(104);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == 'r') ADVANCE(180);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '}') ADVANCE(92);
      if (lookahead == '~') ADVANCE(150);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(70)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(172);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == '_') ADVANCE(45);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(63);
      if (lookahead == '_') ADVANCE(45);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '_') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(46);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(17);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '\'') ADVANCE(26);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_r_DQUOTE);
      if (lookahead == '"') ADVANCE(18);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_r_SQUOTE);
      if (lookahead == '\'') ADVANCE(27);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_r_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_r_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == '"') ADVANCE(80);
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '\'') ADVANCE(81);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(94);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(93);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == '"') ADVANCE(79);
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '\'') ADVANCE(82);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(95);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(93);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == '"') ADVANCE(79);
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '\'') ADVANCE(81);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(96);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(93);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == '$') ADVANCE(192);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == '*') ADVANCE(31);
      if (lookahead == '/') ADVANCE(37);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '\\') ADVANCE(97);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(99);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(93);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == 'u') ADVANCE(57);
      if (lookahead == 'x') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(103);
      if (lookahead != 0) ADVANCE(101);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym__unused_escape_sequence);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym__unused_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(101);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym__unused_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(102);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(122);
      if (lookahead == '>') ADVANCE(169);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(164);
      if (lookahead == '>') ADVANCE(169);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(169);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(159);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(159);
      if (lookahead == '?') ADVANCE(113);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '?') ADVANCE(113);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_equality_operator);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(135);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(135);
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(129);
      if (lookahead == '>') ADVANCE(136);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(120);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(121);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(137);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym__additive_operator);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym__additive_operator);
      if (lookahead == '+') ADVANCE(145);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym__additive_operator);
      if (lookahead == '-') ADVANCE(145);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(31);
      if (lookahead == '/') ADVANCE(37);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_TILDE_SLASH);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_increment_operator);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_minus_operator);
      if (lookahead == '-') ADVANCE(145);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym__exclamation_operator);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym__exclamation_operator);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '/') ADVANCE(144);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(185);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(160);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(146);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      if (lookahead == '=') ADVANCE(166);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK_EQ);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_async);
      if (lookahead == '*') ADVANCE(170);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_async);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_async_STAR);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_sync_STAR);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_POUND_BANG);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym_script_tag_token1);
      if (lookahead == '\n') ADVANCE(31);
      if (lookahead == '*') ADVANCE(173);
      if (lookahead == '/') ADVANCE(178);
      if (lookahead != 0) ADVANCE(174);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym_script_tag_token1);
      if (lookahead == '\n') ADVANCE(31);
      if (lookahead == '*') ADVANCE(173);
      if (lookahead != 0) ADVANCE(174);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym_script_tag_token1);
      if (lookahead == '\n') ADVANCE(194);
      if (lookahead == '/') ADVANCE(178);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(aux_sym_script_tag_token1);
      if (lookahead == '*') ADVANCE(174);
      if (lookahead == '/') ADVANCE(175);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(aux_sym_script_tag_token1);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(aux_sym_script_tag_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(85);
      if (lookahead == '\'') ADVANCE(88);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(181);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(168);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(182);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(183);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(153);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(154);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(184);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(185);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_identifier_dollar_escaped);
      if (lookahead == '\\') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_documentation_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(195);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'b') ADVANCE(3);
      if (lookahead == 'c') ADVANCE(4);
      if (lookahead == 'd') ADVANCE(5);
      if (lookahead == 'e') ADVANCE(6);
      if (lookahead == 'f') ADVANCE(7);
      if (lookahead == 'g') ADVANCE(8);
      if (lookahead == 'h') ADVANCE(9);
      if (lookahead == 'i') ADVANCE(10);
      if (lookahead == 'l') ADVANCE(11);
      if (lookahead == 'm') ADVANCE(12);
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(14);
      if (lookahead == 'p') ADVANCE(15);
      if (lookahead == 'r') ADVANCE(16);
      if (lookahead == 's') ADVANCE(17);
      if (lookahead == 't') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'u') ADVANCE(22);
      END_STATE();
    case 2:
      if (lookahead == 'b') ADVANCE(23);
      if (lookahead == 's') ADVANCE(24);
      if (lookahead == 'w') ADVANCE(25);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(26);
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      if (lookahead == 'y') ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(36);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 9:
      if (lookahead == 'i') ADVANCE(41);
      END_STATE();
    case 10:
      if (lookahead == 'f') ADVANCE(42);
      if (lookahead == 'm') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(44);
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(46);
      if (lookahead == 'i') ADVANCE(47);
      END_STATE();
    case 12:
      if (lookahead == 'i') ADVANCE(48);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'e') ADVANCE(50);
      if (lookahead == 'u') ADVANCE(51);
      END_STATE();
    case 14:
      if (lookahead == 'f') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead == 'p') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 'h') ADVANCE(58);
      if (lookahead == 't') ADVANCE(59);
      if (lookahead == 'u') ADVANCE(60);
      if (lookahead == 'w') ADVANCE(61);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(62);
      if (lookahead == 'r') ADVANCE(63);
      if (lookahead == 'y') ADVANCE(64);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(65);
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 22:
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 23:
      if (lookahead == 's') ADVANCE(71);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(73);
      END_STATE();
    case 26:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(76);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(78);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(79);
      if (lookahead == 'v') ADVANCE(80);
      END_STATE();
    case 31:
      if (lookahead == 'f') ADVANCE(81);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(82);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(83);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(84);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(85);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(86);
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 37:
      if (lookahead == 'c') ADVANCE(88);
      if (lookahead == 'l') ADVANCE(89);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(90);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(91);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(92);
      END_STATE();
    case 41:
      if (lookahead == 'd') ADVANCE(93);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 43:
      if (lookahead == 'p') ADVANCE(94);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 't') ADVANCE(95);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 47:
      if (lookahead == 'b') ADVANCE(97);
      END_STATE();
    case 48:
      if (lookahead == 'x') ADVANCE(98);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(99);
      END_STATE();
    case 50:
      if (lookahead == 'w') ADVANCE(100);
      END_STATE();
    case 51:
      if (lookahead == 'l') ADVANCE(101);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_on);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 55:
      if (lookahead == 'r') ADVANCE(103);
      END_STATE();
    case 56:
      if (lookahead == 'q') ADVANCE(104);
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(107);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(108);
      END_STATE();
    case 60:
      if (lookahead == 'p') ADVANCE(109);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(110);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(111);
      if (lookahead == 'r') ADVANCE(112);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(113);
      if (lookahead == 'u') ADVANCE(114);
      if (lookahead == 'y') ADVANCE(115);
      END_STATE();
    case 64:
      if (lookahead == 'p') ADVANCE(116);
      END_STATE();
    case 65:
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(118);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(119);
      END_STATE();
    case 68:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 70:
      if (lookahead == 'c') ADVANCE(122);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(123);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 73:
      if (lookahead == 'i') ADVANCE(125);
      END_STATE();
    case 74:
      if (lookahead == 'l') ADVANCE(126);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(127);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 77:
      if (lookahead == 'c') ADVANCE(129);
      END_STATE();
    case 78:
      if (lookahead == 's') ADVANCE(130);
      END_STATE();
    case 79:
      if (lookahead == 's') ADVANCE(131);
      if (lookahead == 't') ADVANCE(132);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(133);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(134);
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 82:
      if (lookahead == 'b') ADVANCE(136);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(137);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(138);
      END_STATE();
    case 85:
      if (lookahead == 'm') ADVANCE(139);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(140);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 89:
      if (lookahead == 's') ADVANCE(143);
      END_STATE();
    case 90:
      if (lookahead == 'a') ADVANCE(144);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(146);
      if (lookahead == 'o') ADVANCE(147);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 98:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 99:
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 101:
      if (lookahead == 'l') ADVANCE(153);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(154);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(155);
      END_STATE();
    case 104:
      if (lookahead == 'u') ADVANCE(156);
      END_STATE();
    case 105:
      if (lookahead == 'u') ADVANCE(157);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 107:
      if (lookahead == 'w') ADVANCE(158);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(160);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 111:
      if (lookahead == 's') ADVANCE(162);
      END_STATE();
    case 112:
      if (lookahead == 'o') ADVANCE(163);
      END_STATE();
    case 113:
      if (lookahead == 'n') ADVANCE(164);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 118:
      if (lookahead == 'd') ADVANCE(167);
      END_STATE();
    case 119:
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 120:
      if (lookahead == 'h') ADVANCE(169);
      END_STATE();
    case 121:
      if (lookahead == 'l') ADVANCE(170);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 123:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 124:
      if (lookahead == 'r') ADVANCE(173);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 127:
      if (lookahead == 'k') ADVANCE(175);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_case_builtin);
      END_STATE();
    case 129:
      if (lookahead == 'h') ADVANCE(176);
      END_STATE();
    case 130:
      if (lookahead == 's') ADVANCE(177);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 132:
      if (lookahead == 'i') ADVANCE(179);
      END_STATE();
    case 133:
      if (lookahead == 'r') ADVANCE(180);
      END_STATE();
    case 134:
      if (lookahead == 'u') ADVANCE(181);
      END_STATE();
    case 135:
      if (lookahead == 'r') ADVANCE(182);
      END_STATE();
    case 136:
      if (lookahead == 'l') ADVANCE(183);
      END_STATE();
    case 137:
      if (lookahead == 'm') ADVANCE(184);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 140:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(186);
      if (lookahead == 'r') ADVANCE(187);
      END_STATE();
    case 142:
      if (lookahead == 'o') ADVANCE(188);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 144:
      if (lookahead == 'l') ADVANCE(190);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_hide);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(192);
      END_STATE();
    case 148:
      if (lookahead == 'r') ADVANCE(193);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_late);
      END_STATE();
    case 150:
      if (lookahead == 'a') ADVANCE(194);
      END_STATE();
    case 151:
      if (lookahead == 'n') ADVANCE(195);
      END_STATE();
    case 152:
      if (lookahead == 'v') ADVANCE(196);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_null);
      END_STATE();
    case 154:
      if (lookahead == 'a') ADVANCE(197);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_part);
      END_STATE();
    case 156:
      if (lookahead == 'i') ADVANCE(198);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(199);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_show);
      END_STATE();
    case 159:
      if (lookahead == 'i') ADVANCE(200);
      END_STATE();
    case 160:
      if (lookahead == 'r') ADVANCE(201);
      END_STATE();
    case 161:
      if (lookahead == 'c') ADVANCE(202);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_this);
      END_STATE();
    case 163:
      if (lookahead == 'w') ADVANCE(203);
      END_STATE();
    case 164:
      if (lookahead == 's') ADVANCE(204);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 166:
      if (lookahead == 'd') ADVANCE(205);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_void_type);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(206);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 170:
      if (lookahead == 'd') ADVANCE(207);
      END_STATE();
    case 171:
      if (lookahead == 'i') ADVANCE(208);
      END_STATE();
    case 172:
      if (lookahead == 'a') ADVANCE(209);
      END_STATE();
    case 173:
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym__break_builtin);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_const_builtin);
      END_STATE();
    case 179:
      if (lookahead == 'n') ADVANCE(211);
      END_STATE();
    case 180:
      if (lookahead == 'i') ADVANCE(212);
      END_STATE();
    case 181:
      if (lookahead == 'l') ADVANCE(213);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(214);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 184:
      if (lookahead == 'i') ADVANCE(216);
      END_STATE();
    case 185:
      if (lookahead == 't') ADVANCE(217);
      END_STATE();
    case 186:
      if (lookahead == 'd') ADVANCE(218);
      if (lookahead == 's') ADVANCE(219);
      END_STATE();
    case 187:
      if (lookahead == 'n') ADVANCE(220);
      END_STATE();
    case 188:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_final_builtin);
      if (lookahead == 'l') ADVANCE(222);
      END_STATE();
    case 191:
      if (lookahead == 'm') ADVANCE(223);
      END_STATE();
    case 192:
      if (lookahead == 't') ADVANCE(224);
      END_STATE();
    case 193:
      if (lookahead == 'f') ADVANCE(225);
      END_STATE();
    case 194:
      if (lookahead == 'r') ADVANCE(226);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_mixin);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(227);
      END_STATE();
    case 197:
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 198:
      if (lookahead == 'r') ADVANCE(229);
      END_STATE();
    case 199:
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 200:
      if (lookahead == 'c') ADVANCE(231);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_super);
      END_STATE();
    case 202:
      if (lookahead == 'h') ADVANCE(232);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == 's') ADVANCE(233);
      END_STATE();
    case 204:
      if (lookahead == 'i') ADVANCE(234);
      END_STATE();
    case 205:
      if (lookahead == 'e') ADVANCE(235);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 208:
      if (lookahead == 'o') ADVANCE(236);
      END_STATE();
    case 209:
      if (lookahead == 'c') ADVANCE(237);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym__assert_builtin);
      END_STATE();
    case 211:
      if (lookahead == 'u') ADVANCE(238);
      END_STATE();
    case 212:
      if (lookahead == 'a') ADVANCE(239);
      END_STATE();
    case 213:
      if (lookahead == 't') ADVANCE(240);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_floating_point_type);
      END_STATE();
    case 216:
      if (lookahead == 'c') ADVANCE(242);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 218:
      if (lookahead == 's') ADVANCE(243);
      END_STATE();
    case 219:
      if (lookahead == 'i') ADVANCE(244);
      END_STATE();
    case 220:
      if (lookahead == 'a') ADVANCE(245);
      END_STATE();
    case 221:
      if (lookahead == 'y') ADVANCE(246);
      END_STATE();
    case 222:
      if (lookahead == 'y') ADVANCE(247);
      END_STATE();
    case 223:
      if (lookahead == 'e') ADVANCE(248);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 225:
      if (lookahead == 'a') ADVANCE(249);
      END_STATE();
    case 226:
      if (lookahead == 'y') ADVANCE(250);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 228:
      if (lookahead == 'o') ADVANCE(251);
      END_STATE();
    case 229:
      if (lookahead == 'e') ADVANCE(252);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_throws);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(253);
      END_STATE();
    case 235:
      if (lookahead == 'f') ADVANCE(254);
      END_STATE();
    case 236:
      if (lookahead == 'n') ADVANCE(255);
      END_STATE();
    case 237:
      if (lookahead == 't') ADVANCE(256);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 239:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 241:
      if (lookahead == 'd') ADVANCE(259);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_dynamic);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 244:
      if (lookahead == 'o') ADVANCE(260);
      END_STATE();
    case 245:
      if (lookahead == 'l') ADVANCE(261);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_factory);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 248:
      if (lookahead == 'n') ADVANCE(262);
      END_STATE();
    case 249:
      if (lookahead == 'c') ADVANCE(263);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_library);
      END_STATE();
    case 251:
      if (lookahead == 'r') ADVANCE(264);
      END_STATE();
    case 252:
      if (lookahead == 'd') ADVANCE(265);
      END_STATE();
    case 253:
      if (lookahead == 'i') ADVANCE(266);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_typedef);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_Function);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 258:
      if (lookahead == 't') ADVANCE(267);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_deferred);
      END_STATE();
    case 260:
      if (lookahead == 'n') ADVANCE(268);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 262:
      if (lookahead == 't') ADVANCE(269);
      END_STATE();
    case 263:
      if (lookahead == 'e') ADVANCE(270);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_operator);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_required);
      END_STATE();
    case 266:
      if (lookahead == 'v') ADVANCE(271);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_covariant);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_extension);
      END_STATE();
    case 269:
      if (lookahead == 's') ADVANCE(272);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_transitive);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 69},
  [2] = {.lex_state = 69},
  [3] = {.lex_state = 69},
  [4] = {.lex_state = 69},
  [5] = {.lex_state = 69},
  [6] = {.lex_state = 69},
  [7] = {.lex_state = 69},
  [8] = {.lex_state = 69},
  [9] = {.lex_state = 69},
  [10] = {.lex_state = 69},
  [11] = {.lex_state = 69},
  [12] = {.lex_state = 69},
  [13] = {.lex_state = 69},
  [14] = {.lex_state = 69},
  [15] = {.lex_state = 69},
  [16] = {.lex_state = 69},
  [17] = {.lex_state = 69},
  [18] = {.lex_state = 69},
  [19] = {.lex_state = 69},
  [20] = {.lex_state = 69},
  [21] = {.lex_state = 69},
  [22] = {.lex_state = 69},
  [23] = {.lex_state = 69},
  [24] = {.lex_state = 69},
  [25] = {.lex_state = 69},
  [26] = {.lex_state = 69},
  [27] = {.lex_state = 69},
  [28] = {.lex_state = 69},
  [29] = {.lex_state = 69},
  [30] = {.lex_state = 69},
  [31] = {.lex_state = 69},
  [32] = {.lex_state = 69},
  [33] = {.lex_state = 69},
  [34] = {.lex_state = 69},
  [35] = {.lex_state = 69},
  [36] = {.lex_state = 69},
  [37] = {.lex_state = 69},
  [38] = {.lex_state = 69},
  [39] = {.lex_state = 69},
  [40] = {.lex_state = 69},
  [41] = {.lex_state = 69},
  [42] = {.lex_state = 69},
  [43] = {.lex_state = 69},
  [44] = {.lex_state = 69},
  [45] = {.lex_state = 69},
  [46] = {.lex_state = 69},
  [47] = {.lex_state = 69},
  [48] = {.lex_state = 69},
  [49] = {.lex_state = 69},
  [50] = {.lex_state = 69},
  [51] = {.lex_state = 69},
  [52] = {.lex_state = 69},
  [53] = {.lex_state = 69},
  [54] = {.lex_state = 69},
  [55] = {.lex_state = 69},
  [56] = {.lex_state = 69},
  [57] = {.lex_state = 69},
  [58] = {.lex_state = 69},
  [59] = {.lex_state = 69},
  [60] = {.lex_state = 69},
  [61] = {.lex_state = 69},
  [62] = {.lex_state = 69},
  [63] = {.lex_state = 69},
  [64] = {.lex_state = 69},
  [65] = {.lex_state = 69},
  [66] = {.lex_state = 69},
  [67] = {.lex_state = 69},
  [68] = {.lex_state = 69},
  [69] = {.lex_state = 69},
  [70] = {.lex_state = 69},
  [71] = {.lex_state = 69},
  [72] = {.lex_state = 69},
  [73] = {.lex_state = 69},
  [74] = {.lex_state = 69},
  [75] = {.lex_state = 69},
  [76] = {.lex_state = 69},
  [77] = {.lex_state = 69},
  [78] = {.lex_state = 69},
  [79] = {.lex_state = 69},
  [80] = {.lex_state = 69},
  [81] = {.lex_state = 69},
  [82] = {.lex_state = 69},
  [83] = {.lex_state = 69},
  [84] = {.lex_state = 69},
  [85] = {.lex_state = 69},
  [86] = {.lex_state = 69},
  [87] = {.lex_state = 69},
  [88] = {.lex_state = 69},
  [89] = {.lex_state = 69},
  [90] = {.lex_state = 69},
  [91] = {.lex_state = 69},
  [92] = {.lex_state = 69},
  [93] = {.lex_state = 69},
  [94] = {.lex_state = 69},
  [95] = {.lex_state = 69},
  [96] = {.lex_state = 69},
  [97] = {.lex_state = 69},
  [98] = {.lex_state = 69},
  [99] = {.lex_state = 69},
  [100] = {.lex_state = 69},
  [101] = {.lex_state = 69},
  [102] = {.lex_state = 69},
  [103] = {.lex_state = 69},
  [104] = {.lex_state = 69},
  [105] = {.lex_state = 69},
  [106] = {.lex_state = 69},
  [107] = {.lex_state = 69},
  [108] = {.lex_state = 69},
  [109] = {.lex_state = 69},
  [110] = {.lex_state = 69},
  [111] = {.lex_state = 69},
  [112] = {.lex_state = 69},
  [113] = {.lex_state = 69},
  [114] = {.lex_state = 69},
  [115] = {.lex_state = 69},
  [116] = {.lex_state = 69},
  [117] = {.lex_state = 69},
  [118] = {.lex_state = 69},
  [119] = {.lex_state = 69},
  [120] = {.lex_state = 69},
  [121] = {.lex_state = 69},
  [122] = {.lex_state = 69},
  [123] = {.lex_state = 69},
  [124] = {.lex_state = 69},
  [125] = {.lex_state = 69},
  [126] = {.lex_state = 69},
  [127] = {.lex_state = 69},
  [128] = {.lex_state = 69},
  [129] = {.lex_state = 69},
  [130] = {.lex_state = 69},
  [131] = {.lex_state = 69},
  [132] = {.lex_state = 69},
  [133] = {.lex_state = 69},
  [134] = {.lex_state = 69},
  [135] = {.lex_state = 69},
  [136] = {.lex_state = 69},
  [137] = {.lex_state = 69},
  [138] = {.lex_state = 69},
  [139] = {.lex_state = 69},
  [140] = {.lex_state = 69},
  [141] = {.lex_state = 69},
  [142] = {.lex_state = 69},
  [143] = {.lex_state = 69},
  [144] = {.lex_state = 69},
  [145] = {.lex_state = 69},
  [146] = {.lex_state = 69},
  [147] = {.lex_state = 69},
  [148] = {.lex_state = 69},
  [149] = {.lex_state = 69},
  [150] = {.lex_state = 69},
  [151] = {.lex_state = 69},
  [152] = {.lex_state = 69},
  [153] = {.lex_state = 69},
  [154] = {.lex_state = 69},
  [155] = {.lex_state = 69},
  [156] = {.lex_state = 69},
  [157] = {.lex_state = 69},
  [158] = {.lex_state = 69},
  [159] = {.lex_state = 69},
  [160] = {.lex_state = 69},
  [161] = {.lex_state = 69},
  [162] = {.lex_state = 69},
  [163] = {.lex_state = 69},
  [164] = {.lex_state = 69},
  [165] = {.lex_state = 69},
  [166] = {.lex_state = 69},
  [167] = {.lex_state = 69},
  [168] = {.lex_state = 69},
  [169] = {.lex_state = 69},
  [170] = {.lex_state = 69},
  [171] = {.lex_state = 69},
  [172] = {.lex_state = 69},
  [173] = {.lex_state = 69},
  [174] = {.lex_state = 69},
  [175] = {.lex_state = 69},
  [176] = {.lex_state = 69},
  [177] = {.lex_state = 69},
  [178] = {.lex_state = 69},
  [179] = {.lex_state = 69},
  [180] = {.lex_state = 69},
  [181] = {.lex_state = 69},
  [182] = {.lex_state = 69},
  [183] = {.lex_state = 69},
  [184] = {.lex_state = 69},
  [185] = {.lex_state = 69},
  [186] = {.lex_state = 69},
  [187] = {.lex_state = 69},
  [188] = {.lex_state = 69},
  [189] = {.lex_state = 69},
  [190] = {.lex_state = 69},
  [191] = {.lex_state = 69},
  [192] = {.lex_state = 69},
  [193] = {.lex_state = 69},
  [194] = {.lex_state = 69},
  [195] = {.lex_state = 69},
  [196] = {.lex_state = 69},
  [197] = {.lex_state = 69},
  [198] = {.lex_state = 69},
  [199] = {.lex_state = 69},
  [200] = {.lex_state = 69},
  [201] = {.lex_state = 69},
  [202] = {.lex_state = 69},
  [203] = {.lex_state = 69},
  [204] = {.lex_state = 69},
  [205] = {.lex_state = 69},
  [206] = {.lex_state = 69},
  [207] = {.lex_state = 69},
  [208] = {.lex_state = 69},
  [209] = {.lex_state = 69},
  [210] = {.lex_state = 69},
  [211] = {.lex_state = 69},
  [212] = {.lex_state = 69},
  [213] = {.lex_state = 69},
  [214] = {.lex_state = 69},
  [215] = {.lex_state = 69},
  [216] = {.lex_state = 69},
  [217] = {.lex_state = 69},
  [218] = {.lex_state = 69},
  [219] = {.lex_state = 69},
  [220] = {.lex_state = 69},
  [221] = {.lex_state = 69},
  [222] = {.lex_state = 69},
  [223] = {.lex_state = 69},
  [224] = {.lex_state = 69},
  [225] = {.lex_state = 69},
  [226] = {.lex_state = 69},
  [227] = {.lex_state = 69},
  [228] = {.lex_state = 69},
  [229] = {.lex_state = 69},
  [230] = {.lex_state = 69},
  [231] = {.lex_state = 69},
  [232] = {.lex_state = 69},
  [233] = {.lex_state = 69},
  [234] = {.lex_state = 69},
  [235] = {.lex_state = 69},
  [236] = {.lex_state = 69},
  [237] = {.lex_state = 69},
  [238] = {.lex_state = 69},
  [239] = {.lex_state = 69},
  [240] = {.lex_state = 69},
  [241] = {.lex_state = 69},
  [242] = {.lex_state = 69},
  [243] = {.lex_state = 69},
  [244] = {.lex_state = 69},
  [245] = {.lex_state = 69},
  [246] = {.lex_state = 69},
  [247] = {.lex_state = 69},
  [248] = {.lex_state = 69},
  [249] = {.lex_state = 69},
  [250] = {.lex_state = 69},
  [251] = {.lex_state = 69},
  [252] = {.lex_state = 69},
  [253] = {.lex_state = 69},
  [254] = {.lex_state = 69},
  [255] = {.lex_state = 69},
  [256] = {.lex_state = 69},
  [257] = {.lex_state = 69},
  [258] = {.lex_state = 69},
  [259] = {.lex_state = 69},
  [260] = {.lex_state = 69},
  [261] = {.lex_state = 69},
  [262] = {.lex_state = 69},
  [263] = {.lex_state = 69},
  [264] = {.lex_state = 69},
  [265] = {.lex_state = 69},
  [266] = {.lex_state = 69},
  [267] = {.lex_state = 69},
  [268] = {.lex_state = 69},
  [269] = {.lex_state = 69},
  [270] = {.lex_state = 69},
  [271] = {.lex_state = 69},
  [272] = {.lex_state = 69},
  [273] = {.lex_state = 69},
  [274] = {.lex_state = 69},
  [275] = {.lex_state = 69},
  [276] = {.lex_state = 69},
  [277] = {.lex_state = 69},
  [278] = {.lex_state = 69},
  [279] = {.lex_state = 69},
  [280] = {.lex_state = 69},
  [281] = {.lex_state = 69},
  [282] = {.lex_state = 69},
  [283] = {.lex_state = 69},
  [284] = {.lex_state = 69},
  [285] = {.lex_state = 69},
  [286] = {.lex_state = 69},
  [287] = {.lex_state = 69},
  [288] = {.lex_state = 69},
  [289] = {.lex_state = 69},
  [290] = {.lex_state = 69},
  [291] = {.lex_state = 69},
  [292] = {.lex_state = 69},
  [293] = {.lex_state = 69},
  [294] = {.lex_state = 69},
  [295] = {.lex_state = 69},
  [296] = {.lex_state = 69},
  [297] = {.lex_state = 69},
  [298] = {.lex_state = 69},
  [299] = {.lex_state = 69},
  [300] = {.lex_state = 69},
  [301] = {.lex_state = 69},
  [302] = {.lex_state = 69},
  [303] = {.lex_state = 69},
  [304] = {.lex_state = 69},
  [305] = {.lex_state = 69},
  [306] = {.lex_state = 69},
  [307] = {.lex_state = 69},
  [308] = {.lex_state = 69},
  [309] = {.lex_state = 69},
  [310] = {.lex_state = 69},
  [311] = {.lex_state = 69},
  [312] = {.lex_state = 69},
  [313] = {.lex_state = 69},
  [314] = {.lex_state = 69},
  [315] = {.lex_state = 68},
  [316] = {.lex_state = 68},
  [317] = {.lex_state = 68},
  [318] = {.lex_state = 69},
  [319] = {.lex_state = 69, .external_lex_state = 2},
  [320] = {.lex_state = 69},
  [321] = {.lex_state = 69},
  [322] = {.lex_state = 69},
  [323] = {.lex_state = 69},
  [324] = {.lex_state = 69},
  [325] = {.lex_state = 69},
  [326] = {.lex_state = 69},
  [327] = {.lex_state = 69},
  [328] = {.lex_state = 69},
  [329] = {.lex_state = 69},
  [330] = {.lex_state = 69},
  [331] = {.lex_state = 69},
  [332] = {.lex_state = 69},
  [333] = {.lex_state = 69},
  [334] = {.lex_state = 69},
  [335] = {.lex_state = 69},
  [336] = {.lex_state = 69},
  [337] = {.lex_state = 69},
  [338] = {.lex_state = 69},
  [339] = {.lex_state = 69},
  [340] = {.lex_state = 69},
  [341] = {.lex_state = 69},
  [342] = {.lex_state = 70},
  [343] = {.lex_state = 70},
  [344] = {.lex_state = 69},
  [345] = {.lex_state = 69},
  [346] = {.lex_state = 69},
  [347] = {.lex_state = 69},
  [348] = {.lex_state = 69},
  [349] = {.lex_state = 69},
  [350] = {.lex_state = 69},
  [351] = {.lex_state = 69},
  [352] = {.lex_state = 69},
  [353] = {.lex_state = 69},
  [354] = {.lex_state = 69},
  [355] = {.lex_state = 69},
  [356] = {.lex_state = 69},
  [357] = {.lex_state = 69},
  [358] = {.lex_state = 69},
  [359] = {.lex_state = 69},
  [360] = {.lex_state = 69},
  [361] = {.lex_state = 69},
  [362] = {.lex_state = 69},
  [363] = {.lex_state = 69},
  [364] = {.lex_state = 69},
  [365] = {.lex_state = 69},
  [366] = {.lex_state = 69},
  [367] = {.lex_state = 69},
  [368] = {.lex_state = 69},
  [369] = {.lex_state = 69},
  [370] = {.lex_state = 69},
  [371] = {.lex_state = 69},
  [372] = {.lex_state = 69},
  [373] = {.lex_state = 69},
  [374] = {.lex_state = 69},
  [375] = {.lex_state = 69},
  [376] = {.lex_state = 69},
  [377] = {.lex_state = 69},
  [378] = {.lex_state = 69},
  [379] = {.lex_state = 69},
  [380] = {.lex_state = 69},
  [381] = {.lex_state = 69},
  [382] = {.lex_state = 69},
  [383] = {.lex_state = 69},
  [384] = {.lex_state = 69},
  [385] = {.lex_state = 69},
  [386] = {.lex_state = 69},
  [387] = {.lex_state = 69},
  [388] = {.lex_state = 69},
  [389] = {.lex_state = 69},
  [390] = {.lex_state = 69},
  [391] = {.lex_state = 69},
  [392] = {.lex_state = 69},
  [393] = {.lex_state = 69},
  [394] = {.lex_state = 69},
  [395] = {.lex_state = 69},
  [396] = {.lex_state = 69},
  [397] = {.lex_state = 69},
  [398] = {.lex_state = 69},
  [399] = {.lex_state = 69},
  [400] = {.lex_state = 69},
  [401] = {.lex_state = 69},
  [402] = {.lex_state = 69},
  [403] = {.lex_state = 69},
  [404] = {.lex_state = 69},
  [405] = {.lex_state = 69},
  [406] = {.lex_state = 69},
  [407] = {.lex_state = 69},
  [408] = {.lex_state = 69},
  [409] = {.lex_state = 69},
  [410] = {.lex_state = 69},
  [411] = {.lex_state = 69},
  [412] = {.lex_state = 69},
  [413] = {.lex_state = 69},
  [414] = {.lex_state = 69},
  [415] = {.lex_state = 69},
  [416] = {.lex_state = 69},
  [417] = {.lex_state = 69},
  [418] = {.lex_state = 69},
  [419] = {.lex_state = 69},
  [420] = {.lex_state = 69},
  [421] = {.lex_state = 69},
  [422] = {.lex_state = 69},
  [423] = {.lex_state = 69},
  [424] = {.lex_state = 69},
  [425] = {.lex_state = 69},
  [426] = {.lex_state = 69},
  [427] = {.lex_state = 3},
  [428] = {.lex_state = 69},
  [429] = {.lex_state = 69},
  [430] = {.lex_state = 69},
  [431] = {.lex_state = 3},
  [432] = {.lex_state = 69},
  [433] = {.lex_state = 69},
  [434] = {.lex_state = 69},
  [435] = {.lex_state = 69},
  [436] = {.lex_state = 69},
  [437] = {.lex_state = 69},
  [438] = {.lex_state = 69},
  [439] = {.lex_state = 69},
  [440] = {.lex_state = 69},
  [441] = {.lex_state = 69},
  [442] = {.lex_state = 69},
  [443] = {.lex_state = 69},
  [444] = {.lex_state = 69},
  [445] = {.lex_state = 69},
  [446] = {.lex_state = 69},
  [447] = {.lex_state = 69},
  [448] = {.lex_state = 69},
  [449] = {.lex_state = 69},
  [450] = {.lex_state = 69},
  [451] = {.lex_state = 69},
  [452] = {.lex_state = 69},
  [453] = {.lex_state = 69},
  [454] = {.lex_state = 69},
  [455] = {.lex_state = 69},
  [456] = {.lex_state = 69},
  [457] = {.lex_state = 69},
  [458] = {.lex_state = 4},
  [459] = {.lex_state = 69},
  [460] = {.lex_state = 69},
  [461] = {.lex_state = 3},
  [462] = {.lex_state = 69},
  [463] = {.lex_state = 4},
  [464] = {.lex_state = 69},
  [465] = {.lex_state = 69},
  [466] = {.lex_state = 69},
  [467] = {.lex_state = 4},
  [468] = {.lex_state = 69},
  [469] = {.lex_state = 69},
  [470] = {.lex_state = 69},
  [471] = {.lex_state = 69},
  [472] = {.lex_state = 4},
  [473] = {.lex_state = 4},
  [474] = {.lex_state = 3},
  [475] = {.lex_state = 3},
  [476] = {.lex_state = 3},
  [477] = {.lex_state = 3},
  [478] = {.lex_state = 3},
  [479] = {.lex_state = 3},
  [480] = {.lex_state = 3},
  [481] = {.lex_state = 3},
  [482] = {.lex_state = 3},
  [483] = {.lex_state = 3},
  [484] = {.lex_state = 3},
  [485] = {.lex_state = 4},
  [486] = {.lex_state = 4},
  [487] = {.lex_state = 4},
  [488] = {.lex_state = 3},
  [489] = {.lex_state = 4},
  [490] = {.lex_state = 4},
  [491] = {.lex_state = 4},
  [492] = {.lex_state = 4},
  [493] = {.lex_state = 4},
  [494] = {.lex_state = 4},
  [495] = {.lex_state = 4},
  [496] = {.lex_state = 4},
  [497] = {.lex_state = 3},
  [498] = {.lex_state = 69},
  [499] = {.lex_state = 69},
  [500] = {.lex_state = 69},
  [501] = {.lex_state = 3},
  [502] = {.lex_state = 3},
  [503] = {.lex_state = 3},
  [504] = {.lex_state = 3},
  [505] = {.lex_state = 3},
  [506] = {.lex_state = 3},
  [507] = {.lex_state = 4},
  [508] = {.lex_state = 3},
  [509] = {.lex_state = 4},
  [510] = {.lex_state = 3},
  [511] = {.lex_state = 3},
  [512] = {.lex_state = 3},
  [513] = {.lex_state = 3},
  [514] = {.lex_state = 3},
  [515] = {.lex_state = 3},
  [516] = {.lex_state = 3},
  [517] = {.lex_state = 3},
  [518] = {.lex_state = 3},
  [519] = {.lex_state = 3},
  [520] = {.lex_state = 3},
  [521] = {.lex_state = 3},
  [522] = {.lex_state = 69},
  [523] = {.lex_state = 3},
  [524] = {.lex_state = 4},
  [525] = {.lex_state = 4},
  [526] = {.lex_state = 4},
  [527] = {.lex_state = 3},
  [528] = {.lex_state = 4},
  [529] = {.lex_state = 3},
  [530] = {.lex_state = 3},
  [531] = {.lex_state = 4},
  [532] = {.lex_state = 4},
  [533] = {.lex_state = 3},
  [534] = {.lex_state = 4},
  [535] = {.lex_state = 4},
  [536] = {.lex_state = 3},
  [537] = {.lex_state = 3},
  [538] = {.lex_state = 3},
  [539] = {.lex_state = 69},
  [540] = {.lex_state = 3},
  [541] = {.lex_state = 3},
  [542] = {.lex_state = 3},
  [543] = {.lex_state = 4},
  [544] = {.lex_state = 4},
  [545] = {.lex_state = 3},
  [546] = {.lex_state = 3},
  [547] = {.lex_state = 69},
  [548] = {.lex_state = 3},
  [549] = {.lex_state = 3},
  [550] = {.lex_state = 3},
  [551] = {.lex_state = 4},
  [552] = {.lex_state = 4},
  [553] = {.lex_state = 4},
  [554] = {.lex_state = 4},
  [555] = {.lex_state = 4},
  [556] = {.lex_state = 5},
  [557] = {.lex_state = 4},
  [558] = {.lex_state = 10},
  [559] = {.lex_state = 3},
  [560] = {.lex_state = 4},
  [561] = {.lex_state = 11},
  [562] = {.lex_state = 11},
  [563] = {.lex_state = 4},
  [564] = {.lex_state = 4},
  [565] = {.lex_state = 4},
  [566] = {.lex_state = 4},
  [567] = {.lex_state = 4},
  [568] = {.lex_state = 4},
  [569] = {.lex_state = 4},
  [570] = {.lex_state = 4},
  [571] = {.lex_state = 4},
  [572] = {.lex_state = 4},
  [573] = {.lex_state = 4},
  [574] = {.lex_state = 4},
  [575] = {.lex_state = 4},
  [576] = {.lex_state = 4},
  [577] = {.lex_state = 4},
  [578] = {.lex_state = 4},
  [579] = {.lex_state = 11},
  [580] = {.lex_state = 3},
  [581] = {.lex_state = 10},
  [582] = {.lex_state = 10},
  [583] = {.lex_state = 10},
  [584] = {.lex_state = 10},
  [585] = {.lex_state = 10},
  [586] = {.lex_state = 10},
  [587] = {.lex_state = 3},
  [588] = {.lex_state = 11},
  [589] = {.lex_state = 11},
  [590] = {.lex_state = 10},
  [591] = {.lex_state = 10},
  [592] = {.lex_state = 11},
  [593] = {.lex_state = 11},
  [594] = {.lex_state = 10},
  [595] = {.lex_state = 11},
  [596] = {.lex_state = 11},
  [597] = {.lex_state = 9},
  [598] = {.lex_state = 9},
  [599] = {.lex_state = 10},
  [600] = {.lex_state = 3},
  [601] = {.lex_state = 10},
  [602] = {.lex_state = 11},
  [603] = {.lex_state = 3},
  [604] = {.lex_state = 11},
  [605] = {.lex_state = 11},
  [606] = {.lex_state = 11},
  [607] = {.lex_state = 7},
  [608] = {.lex_state = 3},
  [609] = {.lex_state = 7},
  [610] = {.lex_state = 4},
  [611] = {.lex_state = 5},
  [612] = {.lex_state = 69},
  [613] = {.lex_state = 5},
  [614] = {.lex_state = 5},
  [615] = {.lex_state = 5},
  [616] = {.lex_state = 5},
  [617] = {.lex_state = 3},
  [618] = {.lex_state = 3},
  [619] = {.lex_state = 3},
  [620] = {.lex_state = 3},
  [621] = {.lex_state = 3},
  [622] = {.lex_state = 3},
  [623] = {.lex_state = 3},
  [624] = {.lex_state = 3},
  [625] = {.lex_state = 4},
  [626] = {.lex_state = 3},
  [627] = {.lex_state = 4},
  [628] = {.lex_state = 4},
  [629] = {.lex_state = 5},
  [630] = {.lex_state = 3},
  [631] = {.lex_state = 3},
  [632] = {.lex_state = 3},
  [633] = {.lex_state = 3},
  [634] = {.lex_state = 3},
  [635] = {.lex_state = 4},
  [636] = {.lex_state = 10},
  [637] = {.lex_state = 4},
  [638] = {.lex_state = 3},
  [639] = {.lex_state = 3},
  [640] = {.lex_state = 3},
  [641] = {.lex_state = 10},
  [642] = {.lex_state = 4},
  [643] = {.lex_state = 3},
  [644] = {.lex_state = 3},
  [645] = {.lex_state = 3},
  [646] = {.lex_state = 4},
  [647] = {.lex_state = 4},
  [648] = {.lex_state = 3},
  [649] = {.lex_state = 5},
  [650] = {.lex_state = 4},
  [651] = {.lex_state = 4},
  [652] = {.lex_state = 4},
  [653] = {.lex_state = 4},
  [654] = {.lex_state = 3},
  [655] = {.lex_state = 4},
  [656] = {.lex_state = 3},
  [657] = {.lex_state = 4},
  [658] = {.lex_state = 4},
  [659] = {.lex_state = 4},
  [660] = {.lex_state = 3},
  [661] = {.lex_state = 3},
  [662] = {.lex_state = 3},
  [663] = {.lex_state = 3},
  [664] = {.lex_state = 6},
  [665] = {.lex_state = 4},
  [666] = {.lex_state = 3},
  [667] = {.lex_state = 3},
  [668] = {.lex_state = 3},
  [669] = {.lex_state = 3},
  [670] = {.lex_state = 4},
  [671] = {.lex_state = 3},
  [672] = {.lex_state = 5},
  [673] = {.lex_state = 3},
  [674] = {.lex_state = 5},
  [675] = {.lex_state = 5},
  [676] = {.lex_state = 4},
  [677] = {.lex_state = 69},
  [678] = {.lex_state = 4},
  [679] = {.lex_state = 5},
  [680] = {.lex_state = 4},
  [681] = {.lex_state = 4},
  [682] = {.lex_state = 3},
  [683] = {.lex_state = 3},
  [684] = {.lex_state = 5},
  [685] = {.lex_state = 3},
  [686] = {.lex_state = 5},
  [687] = {.lex_state = 6},
  [688] = {.lex_state = 4},
  [689] = {.lex_state = 6},
  [690] = {.lex_state = 6},
  [691] = {.lex_state = 6},
  [692] = {.lex_state = 3},
  [693] = {.lex_state = 69},
  [694] = {.lex_state = 4},
  [695] = {.lex_state = 3},
  [696] = {.lex_state = 5},
  [697] = {.lex_state = 5},
  [698] = {.lex_state = 4},
  [699] = {.lex_state = 6},
  [700] = {.lex_state = 6},
  [701] = {.lex_state = 4},
  [702] = {.lex_state = 3},
  [703] = {.lex_state = 3},
  [704] = {.lex_state = 6},
  [705] = {.lex_state = 6},
  [706] = {.lex_state = 4},
  [707] = {.lex_state = 4},
  [708] = {.lex_state = 4},
  [709] = {.lex_state = 6},
  [710] = {.lex_state = 4},
  [711] = {.lex_state = 4},
  [712] = {.lex_state = 4},
  [713] = {.lex_state = 4},
  [714] = {.lex_state = 6},
  [715] = {.lex_state = 4},
  [716] = {.lex_state = 6},
  [717] = {.lex_state = 4},
  [718] = {.lex_state = 4},
  [719] = {.lex_state = 4},
  [720] = {.lex_state = 3},
  [721] = {.lex_state = 4},
  [722] = {.lex_state = 4},
  [723] = {.lex_state = 4},
  [724] = {.lex_state = 4},
  [725] = {.lex_state = 4},
  [726] = {.lex_state = 69},
  [727] = {.lex_state = 4},
  [728] = {.lex_state = 4},
  [729] = {.lex_state = 4},
  [730] = {.lex_state = 4},
  [731] = {.lex_state = 4},
  [732] = {.lex_state = 4},
  [733] = {.lex_state = 4},
  [734] = {.lex_state = 4},
  [735] = {.lex_state = 4},
  [736] = {.lex_state = 4},
  [737] = {.lex_state = 4},
  [738] = {.lex_state = 4},
  [739] = {.lex_state = 4},
  [740] = {.lex_state = 4},
  [741] = {.lex_state = 4},
  [742] = {.lex_state = 4},
  [743] = {.lex_state = 4},
  [744] = {.lex_state = 9},
  [745] = {.lex_state = 4},
  [746] = {.lex_state = 3},
  [747] = {.lex_state = 4},
  [748] = {.lex_state = 3},
  [749] = {.lex_state = 4},
  [750] = {.lex_state = 69},
  [751] = {.lex_state = 4},
  [752] = {.lex_state = 4},
  [753] = {.lex_state = 4},
  [754] = {.lex_state = 3},
  [755] = {.lex_state = 3},
  [756] = {.lex_state = 4},
  [757] = {.lex_state = 4},
  [758] = {.lex_state = 4},
  [759] = {.lex_state = 3},
  [760] = {.lex_state = 3},
  [761] = {.lex_state = 3},
  [762] = {.lex_state = 3},
  [763] = {.lex_state = 3},
  [764] = {.lex_state = 3},
  [765] = {.lex_state = 3},
  [766] = {.lex_state = 5},
  [767] = {.lex_state = 3},
  [768] = {.lex_state = 3},
  [769] = {.lex_state = 4},
  [770] = {.lex_state = 3},
  [771] = {.lex_state = 3},
  [772] = {.lex_state = 7},
  [773] = {.lex_state = 7},
  [774] = {.lex_state = 4},
  [775] = {.lex_state = 3},
  [776] = {.lex_state = 3},
  [777] = {.lex_state = 9},
  [778] = {.lex_state = 3},
  [779] = {.lex_state = 3},
  [780] = {.lex_state = 3},
  [781] = {.lex_state = 3},
  [782] = {.lex_state = 9},
  [783] = {.lex_state = 3},
  [784] = {.lex_state = 3},
  [785] = {.lex_state = 3},
  [786] = {.lex_state = 3},
  [787] = {.lex_state = 3},
  [788] = {.lex_state = 3},
  [789] = {.lex_state = 3},
  [790] = {.lex_state = 3},
  [791] = {.lex_state = 3},
  [792] = {.lex_state = 69},
  [793] = {.lex_state = 5},
  [794] = {.lex_state = 9},
  [795] = {.lex_state = 4},
  [796] = {.lex_state = 3},
  [797] = {.lex_state = 3},
  [798] = {.lex_state = 69},
  [799] = {.lex_state = 3},
  [800] = {.lex_state = 3},
  [801] = {.lex_state = 3},
  [802] = {.lex_state = 4},
  [803] = {.lex_state = 3},
  [804] = {.lex_state = 3},
  [805] = {.lex_state = 3},
  [806] = {.lex_state = 3},
  [807] = {.lex_state = 5},
  [808] = {.lex_state = 3},
  [809] = {.lex_state = 3},
  [810] = {.lex_state = 5},
  [811] = {.lex_state = 4},
  [812] = {.lex_state = 3},
  [813] = {.lex_state = 3},
  [814] = {.lex_state = 3},
  [815] = {.lex_state = 3},
  [816] = {.lex_state = 3},
  [817] = {.lex_state = 4},
  [818] = {.lex_state = 4},
  [819] = {.lex_state = 4},
  [820] = {.lex_state = 3},
  [821] = {.lex_state = 4},
  [822] = {.lex_state = 3},
  [823] = {.lex_state = 4},
  [824] = {.lex_state = 10},
  [825] = {.lex_state = 4},
  [826] = {.lex_state = 3},
  [827] = {.lex_state = 3},
  [828] = {.lex_state = 69},
  [829] = {.lex_state = 3},
  [830] = {.lex_state = 4},
  [831] = {.lex_state = 3},
  [832] = {.lex_state = 4},
  [833] = {.lex_state = 3},
  [834] = {.lex_state = 3},
  [835] = {.lex_state = 4},
  [836] = {.lex_state = 3},
  [837] = {.lex_state = 4},
  [838] = {.lex_state = 3},
  [839] = {.lex_state = 3},
  [840] = {.lex_state = 4},
  [841] = {.lex_state = 4},
  [842] = {.lex_state = 69},
  [843] = {.lex_state = 4},
  [844] = {.lex_state = 3},
  [845] = {.lex_state = 3},
  [846] = {.lex_state = 4},
  [847] = {.lex_state = 3},
  [848] = {.lex_state = 3},
  [849] = {.lex_state = 4},
  [850] = {.lex_state = 3},
  [851] = {.lex_state = 3},
  [852] = {.lex_state = 3},
  [853] = {.lex_state = 4},
  [854] = {.lex_state = 4},
  [855] = {.lex_state = 4},
  [856] = {.lex_state = 3},
  [857] = {.lex_state = 3},
  [858] = {.lex_state = 3},
  [859] = {.lex_state = 3},
  [860] = {.lex_state = 4},
  [861] = {.lex_state = 3},
  [862] = {.lex_state = 4},
  [863] = {.lex_state = 3},
  [864] = {.lex_state = 3},
  [865] = {.lex_state = 3},
  [866] = {.lex_state = 4},
  [867] = {.lex_state = 3},
  [868] = {.lex_state = 3},
  [869] = {.lex_state = 4},
  [870] = {.lex_state = 4},
  [871] = {.lex_state = 4},
  [872] = {.lex_state = 3},
  [873] = {.lex_state = 4},
  [874] = {.lex_state = 4},
  [875] = {.lex_state = 3},
  [876] = {.lex_state = 4},
  [877] = {.lex_state = 4},
  [878] = {.lex_state = 4},
  [879] = {.lex_state = 3},
  [880] = {.lex_state = 4},
  [881] = {.lex_state = 4},
  [882] = {.lex_state = 4},
  [883] = {.lex_state = 4},
  [884] = {.lex_state = 4},
  [885] = {.lex_state = 4},
  [886] = {.lex_state = 4},
  [887] = {.lex_state = 4},
  [888] = {.lex_state = 3},
  [889] = {.lex_state = 10},
  [890] = {.lex_state = 4},
  [891] = {.lex_state = 3},
  [892] = {.lex_state = 10},
  [893] = {.lex_state = 10},
  [894] = {.lex_state = 3},
  [895] = {.lex_state = 4},
  [896] = {.lex_state = 4},
  [897] = {.lex_state = 10},
  [898] = {.lex_state = 3},
  [899] = {.lex_state = 10},
  [900] = {.lex_state = 10},
  [901] = {.lex_state = 4},
  [902] = {.lex_state = 10},
  [903] = {.lex_state = 10},
  [904] = {.lex_state = 10},
  [905] = {.lex_state = 4},
  [906] = {.lex_state = 10},
  [907] = {.lex_state = 4},
  [908] = {.lex_state = 4},
  [909] = {.lex_state = 4},
  [910] = {.lex_state = 3},
  [911] = {.lex_state = 3},
  [912] = {.lex_state = 3},
  [913] = {.lex_state = 3},
  [914] = {.lex_state = 4},
  [915] = {.lex_state = 4},
  [916] = {.lex_state = 3},
  [917] = {.lex_state = 3},
  [918] = {.lex_state = 3},
  [919] = {.lex_state = 4},
  [920] = {.lex_state = 3},
  [921] = {.lex_state = 3},
  [922] = {.lex_state = 4},
  [923] = {.lex_state = 4},
  [924] = {.lex_state = 4},
  [925] = {.lex_state = 4},
  [926] = {.lex_state = 4},
  [927] = {.lex_state = 3},
  [928] = {.lex_state = 4},
  [929] = {.lex_state = 3},
  [930] = {.lex_state = 3},
  [931] = {.lex_state = 4},
  [932] = {.lex_state = 4},
  [933] = {.lex_state = 3},
  [934] = {.lex_state = 4},
  [935] = {.lex_state = 3},
  [936] = {.lex_state = 3},
  [937] = {.lex_state = 4},
  [938] = {.lex_state = 3},
  [939] = {.lex_state = 3},
  [940] = {.lex_state = 69},
  [941] = {.lex_state = 5},
  [942] = {.lex_state = 69},
  [943] = {.lex_state = 10},
  [944] = {.lex_state = 12},
  [945] = {.lex_state = 10},
  [946] = {.lex_state = 12},
  [947] = {.lex_state = 11},
  [948] = {.lex_state = 12},
  [949] = {.lex_state = 12},
  [950] = {.lex_state = 70},
  [951] = {.lex_state = 12},
  [952] = {.lex_state = 12},
  [953] = {.lex_state = 12},
  [954] = {.lex_state = 3},
  [955] = {.lex_state = 12},
  [956] = {.lex_state = 12},
  [957] = {.lex_state = 70},
  [958] = {.lex_state = 10},
  [959] = {.lex_state = 70},
  [960] = {.lex_state = 11},
  [961] = {.lex_state = 11},
  [962] = {.lex_state = 12},
  [963] = {.lex_state = 12},
  [964] = {.lex_state = 12},
  [965] = {.lex_state = 7},
  [966] = {.lex_state = 9},
  [967] = {.lex_state = 9},
  [968] = {.lex_state = 69},
  [969] = {.lex_state = 10},
  [970] = {.lex_state = 3},
  [971] = {.lex_state = 7},
  [972] = {.lex_state = 7},
  [973] = {.lex_state = 3},
  [974] = {.lex_state = 9},
  [975] = {.lex_state = 11},
  [976] = {.lex_state = 11},
  [977] = {.lex_state = 9},
  [978] = {.lex_state = 9},
  [979] = {.lex_state = 3},
  [980] = {.lex_state = 7},
  [981] = {.lex_state = 10},
  [982] = {.lex_state = 3},
  [983] = {.lex_state = 10},
  [984] = {.lex_state = 11},
  [985] = {.lex_state = 10},
  [986] = {.lex_state = 11},
  [987] = {.lex_state = 69},
  [988] = {.lex_state = 69},
  [989] = {.lex_state = 11},
  [990] = {.lex_state = 69},
  [991] = {.lex_state = 69},
  [992] = {.lex_state = 11},
  [993] = {.lex_state = 11},
  [994] = {.lex_state = 69},
  [995] = {.lex_state = 10},
  [996] = {.lex_state = 11},
  [997] = {.lex_state = 11},
  [998] = {.lex_state = 10},
  [999] = {.lex_state = 8},
  [1000] = {.lex_state = 10},
  [1001] = {.lex_state = 11},
  [1002] = {.lex_state = 10},
  [1003] = {.lex_state = 69},
  [1004] = {.lex_state = 10},
  [1005] = {.lex_state = 11},
  [1006] = {.lex_state = 10},
  [1007] = {.lex_state = 10},
  [1008] = {.lex_state = 11},
  [1009] = {.lex_state = 10},
  [1010] = {.lex_state = 10},
  [1011] = {.lex_state = 69},
  [1012] = {.lex_state = 11},
  [1013] = {.lex_state = 11},
  [1014] = {.lex_state = 10},
  [1015] = {.lex_state = 69},
  [1016] = {.lex_state = 11},
  [1017] = {.lex_state = 10},
  [1018] = {.lex_state = 11},
  [1019] = {.lex_state = 10},
  [1020] = {.lex_state = 10},
  [1021] = {.lex_state = 8},
  [1022] = {.lex_state = 11},
  [1023] = {.lex_state = 10},
  [1024] = {.lex_state = 69},
  [1025] = {.lex_state = 10},
  [1026] = {.lex_state = 10},
  [1027] = {.lex_state = 11},
  [1028] = {.lex_state = 70},
  [1029] = {.lex_state = 11},
  [1030] = {.lex_state = 11},
  [1031] = {.lex_state = 69},
  [1032] = {.lex_state = 69},
  [1033] = {.lex_state = 69},
  [1034] = {.lex_state = 11},
  [1035] = {.lex_state = 10},
  [1036] = {.lex_state = 69},
  [1037] = {.lex_state = 69},
  [1038] = {.lex_state = 10},
  [1039] = {.lex_state = 69},
  [1040] = {.lex_state = 7},
  [1041] = {.lex_state = 7},
  [1042] = {.lex_state = 10},
  [1043] = {.lex_state = 11},
  [1044] = {.lex_state = 10},
  [1045] = {.lex_state = 11},
  [1046] = {.lex_state = 7},
  [1047] = {.lex_state = 10},
  [1048] = {.lex_state = 7},
  [1049] = {.lex_state = 7},
  [1050] = {.lex_state = 11},
  [1051] = {.lex_state = 10},
  [1052] = {.lex_state = 7},
  [1053] = {.lex_state = 11},
  [1054] = {.lex_state = 19},
  [1055] = {.lex_state = 11},
  [1056] = {.lex_state = 7},
  [1057] = {.lex_state = 10},
  [1058] = {.lex_state = 7},
  [1059] = {.lex_state = 19},
  [1060] = {.lex_state = 10},
  [1061] = {.lex_state = 10},
  [1062] = {.lex_state = 7},
  [1063] = {.lex_state = 7},
  [1064] = {.lex_state = 19},
  [1065] = {.lex_state = 11},
  [1066] = {.lex_state = 70},
  [1067] = {.lex_state = 19},
  [1068] = {.lex_state = 7},
  [1069] = {.lex_state = 11},
  [1070] = {.lex_state = 11},
  [1071] = {.lex_state = 7},
  [1072] = {.lex_state = 10},
  [1073] = {.lex_state = 11},
  [1074] = {.lex_state = 11},
  [1075] = {.lex_state = 10},
  [1076] = {.lex_state = 10},
  [1077] = {.lex_state = 11},
  [1078] = {.lex_state = 11},
  [1079] = {.lex_state = 10},
  [1080] = {.lex_state = 10},
  [1081] = {.lex_state = 10},
  [1082] = {.lex_state = 10},
  [1083] = {.lex_state = 10},
  [1084] = {.lex_state = 3},
  [1085] = {.lex_state = 10},
  [1086] = {.lex_state = 10},
  [1087] = {.lex_state = 10},
  [1088] = {.lex_state = 10},
  [1089] = {.lex_state = 10},
  [1090] = {.lex_state = 10},
  [1091] = {.lex_state = 10},
  [1092] = {.lex_state = 10},
  [1093] = {.lex_state = 10},
  [1094] = {.lex_state = 11},
  [1095] = {.lex_state = 11},
  [1096] = {.lex_state = 11},
  [1097] = {.lex_state = 10},
  [1098] = {.lex_state = 10},
  [1099] = {.lex_state = 10},
  [1100] = {.lex_state = 11},
  [1101] = {.lex_state = 11},
  [1102] = {.lex_state = 10},
  [1103] = {.lex_state = 3},
  [1104] = {.lex_state = 10},
  [1105] = {.lex_state = 11},
  [1106] = {.lex_state = 10},
  [1107] = {.lex_state = 11},
  [1108] = {.lex_state = 11},
  [1109] = {.lex_state = 11},
  [1110] = {.lex_state = 10},
  [1111] = {.lex_state = 11},
  [1112] = {.lex_state = 10},
  [1113] = {.lex_state = 11},
  [1114] = {.lex_state = 11},
  [1115] = {.lex_state = 11},
  [1116] = {.lex_state = 10},
  [1117] = {.lex_state = 10},
  [1118] = {.lex_state = 11},
  [1119] = {.lex_state = 11},
  [1120] = {.lex_state = 11},
  [1121] = {.lex_state = 11},
  [1122] = {.lex_state = 11},
  [1123] = {.lex_state = 11},
  [1124] = {.lex_state = 11},
  [1125] = {.lex_state = 9},
  [1126] = {.lex_state = 10},
  [1127] = {.lex_state = 11},
  [1128] = {.lex_state = 11},
  [1129] = {.lex_state = 11},
  [1130] = {.lex_state = 11},
  [1131] = {.lex_state = 11},
  [1132] = {.lex_state = 10},
  [1133] = {.lex_state = 10},
  [1134] = {.lex_state = 10},
  [1135] = {.lex_state = 10},
  [1136] = {.lex_state = 11},
  [1137] = {.lex_state = 11},
  [1138] = {.lex_state = 11},
  [1139] = {.lex_state = 11},
  [1140] = {.lex_state = 11},
  [1141] = {.lex_state = 10},
  [1142] = {.lex_state = 10},
  [1143] = {.lex_state = 10},
  [1144] = {.lex_state = 3},
  [1145] = {.lex_state = 69},
  [1146] = {.lex_state = 11},
  [1147] = {.lex_state = 10},
  [1148] = {.lex_state = 10},
  [1149] = {.lex_state = 3},
  [1150] = {.lex_state = 10},
  [1151] = {.lex_state = 11},
  [1152] = {.lex_state = 10},
  [1153] = {.lex_state = 10},
  [1154] = {.lex_state = 11},
  [1155] = {.lex_state = 69},
  [1156] = {.lex_state = 3},
  [1157] = {.lex_state = 69},
  [1158] = {.lex_state = 69},
  [1159] = {.lex_state = 9},
  [1160] = {.lex_state = 69},
  [1161] = {.lex_state = 9},
  [1162] = {.lex_state = 3},
  [1163] = {.lex_state = 69},
  [1164] = {.lex_state = 3},
  [1165] = {.lex_state = 69},
  [1166] = {.lex_state = 3},
  [1167] = {.lex_state = 3},
  [1168] = {.lex_state = 3},
  [1169] = {.lex_state = 3},
  [1170] = {.lex_state = 69},
  [1171] = {.lex_state = 3},
  [1172] = {.lex_state = 69},
  [1173] = {.lex_state = 69},
  [1174] = {.lex_state = 3},
  [1175] = {.lex_state = 69},
  [1176] = {.lex_state = 69},
  [1177] = {.lex_state = 69},
  [1178] = {.lex_state = 69},
  [1179] = {.lex_state = 3},
  [1180] = {.lex_state = 3},
  [1181] = {.lex_state = 69},
  [1182] = {.lex_state = 69},
  [1183] = {.lex_state = 3},
  [1184] = {.lex_state = 7},
  [1185] = {.lex_state = 69},
  [1186] = {.lex_state = 69},
  [1187] = {.lex_state = 10},
  [1188] = {.lex_state = 28},
  [1189] = {.lex_state = 28},
  [1190] = {.lex_state = 10},
  [1191] = {.lex_state = 8},
  [1192] = {.lex_state = 8},
  [1193] = {.lex_state = 28},
  [1194] = {.lex_state = 8},
  [1195] = {.lex_state = 10},
  [1196] = {.lex_state = 8},
  [1197] = {.lex_state = 69},
  [1198] = {.lex_state = 8},
  [1199] = {.lex_state = 8},
  [1200] = {.lex_state = 10},
  [1201] = {.lex_state = 8},
  [1202] = {.lex_state = 8},
  [1203] = {.lex_state = 28},
  [1204] = {.lex_state = 8},
  [1205] = {.lex_state = 8},
  [1206] = {.lex_state = 8},
  [1207] = {.lex_state = 8},
  [1208] = {.lex_state = 28},
  [1209] = {.lex_state = 8},
  [1210] = {.lex_state = 8},
  [1211] = {.lex_state = 69},
  [1212] = {.lex_state = 8},
  [1213] = {.lex_state = 8},
  [1214] = {.lex_state = 28},
  [1215] = {.lex_state = 10},
  [1216] = {.lex_state = 10},
  [1217] = {.lex_state = 10},
  [1218] = {.lex_state = 10},
  [1219] = {.lex_state = 10},
  [1220] = {.lex_state = 69},
  [1221] = {.lex_state = 10},
  [1222] = {.lex_state = 10},
  [1223] = {.lex_state = 10},
  [1224] = {.lex_state = 28},
  [1225] = {.lex_state = 69},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 69},
  [1228] = {.lex_state = 28},
  [1229] = {.lex_state = 10},
  [1230] = {.lex_state = 69},
  [1231] = {.lex_state = 28},
  [1232] = {.lex_state = 28},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 28},
  [1235] = {.lex_state = 69},
  [1236] = {.lex_state = 28},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 69},
  [1239] = {.lex_state = 28},
  [1240] = {.lex_state = 10},
  [1241] = {.lex_state = 10},
  [1242] = {.lex_state = 10},
  [1243] = {.lex_state = 28},
  [1244] = {.lex_state = 5},
  [1245] = {.lex_state = 5},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 5},
  [1248] = {.lex_state = 5},
  [1249] = {.lex_state = 28},
  [1250] = {.lex_state = 69},
  [1251] = {.lex_state = 5},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 69},
  [1254] = {.lex_state = 69},
  [1255] = {.lex_state = 5},
  [1256] = {.lex_state = 69},
  [1257] = {.lex_state = 28},
  [1258] = {.lex_state = 5},
  [1259] = {.lex_state = 12},
  [1260] = {.lex_state = 5},
  [1261] = {.lex_state = 28},
  [1262] = {.lex_state = 5},
  [1263] = {.lex_state = 69},
  [1264] = {.lex_state = 28},
  [1265] = {.lex_state = 5},
  [1266] = {.lex_state = 5},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 28},
  [1269] = {.lex_state = 5},
  [1270] = {.lex_state = 28},
  [1271] = {.lex_state = 0},
  [1272] = {.lex_state = 28},
  [1273] = {.lex_state = 5},
  [1274] = {.lex_state = 28},
  [1275] = {.lex_state = 69},
  [1276] = {.lex_state = 69},
  [1277] = {.lex_state = 69},
  [1278] = {.lex_state = 28},
  [1279] = {.lex_state = 69},
  [1280] = {.lex_state = 0},
  [1281] = {.lex_state = 69},
  [1282] = {.lex_state = 28},
  [1283] = {.lex_state = 69},
  [1284] = {.lex_state = 28},
  [1285] = {.lex_state = 28},
  [1286] = {.lex_state = 28},
  [1287] = {.lex_state = 28},
  [1288] = {.lex_state = 28},
  [1289] = {.lex_state = 28},
  [1290] = {.lex_state = 69},
  [1291] = {.lex_state = 69},
  [1292] = {.lex_state = 28},
  [1293] = {.lex_state = 28},
  [1294] = {.lex_state = 69},
  [1295] = {.lex_state = 69},
  [1296] = {.lex_state = 70},
  [1297] = {.lex_state = 70},
  [1298] = {.lex_state = 70},
  [1299] = {.lex_state = 70},
  [1300] = {.lex_state = 70},
  [1301] = {.lex_state = 70},
  [1302] = {.lex_state = 69},
  [1303] = {.lex_state = 69},
  [1304] = {.lex_state = 69},
  [1305] = {.lex_state = 70},
  [1306] = {.lex_state = 70},
  [1307] = {.lex_state = 70},
  [1308] = {.lex_state = 70},
  [1309] = {.lex_state = 70},
  [1310] = {.lex_state = 69},
  [1311] = {.lex_state = 69},
  [1312] = {.lex_state = 8},
  [1313] = {.lex_state = 69},
  [1314] = {.lex_state = 8},
  [1315] = {.lex_state = 8},
  [1316] = {.lex_state = 8},
  [1317] = {.lex_state = 8},
  [1318] = {.lex_state = 8},
  [1319] = {.lex_state = 69},
  [1320] = {.lex_state = 69},
  [1321] = {.lex_state = 12},
  [1322] = {.lex_state = 5},
  [1323] = {.lex_state = 12},
  [1324] = {.lex_state = 69},
  [1325] = {.lex_state = 69},
  [1326] = {.lex_state = 12},
  [1327] = {.lex_state = 12},
  [1328] = {.lex_state = 69},
  [1329] = {.lex_state = 12},
  [1330] = {.lex_state = 69},
  [1331] = {.lex_state = 69},
  [1332] = {.lex_state = 69},
  [1333] = {.lex_state = 28},
  [1334] = {.lex_state = 12},
  [1335] = {.lex_state = 69},
  [1336] = {.lex_state = 69},
  [1337] = {.lex_state = 28},
  [1338] = {.lex_state = 69},
  [1339] = {.lex_state = 69},
  [1340] = {.lex_state = 69},
  [1341] = {.lex_state = 69},
  [1342] = {.lex_state = 69},
  [1343] = {.lex_state = 28},
  [1344] = {.lex_state = 69},
  [1345] = {.lex_state = 69},
  [1346] = {.lex_state = 69},
  [1347] = {.lex_state = 69},
  [1348] = {.lex_state = 69},
  [1349] = {.lex_state = 69},
  [1350] = {.lex_state = 69},
  [1351] = {.lex_state = 69},
  [1352] = {.lex_state = 69},
  [1353] = {.lex_state = 69},
  [1354] = {.lex_state = 69},
  [1355] = {.lex_state = 69},
  [1356] = {.lex_state = 70},
  [1357] = {.lex_state = 69},
  [1358] = {.lex_state = 69},
  [1359] = {.lex_state = 69},
  [1360] = {.lex_state = 69},
  [1361] = {.lex_state = 69},
  [1362] = {.lex_state = 69},
  [1363] = {.lex_state = 69},
  [1364] = {.lex_state = 69},
  [1365] = {.lex_state = 69},
  [1366] = {.lex_state = 69},
  [1367] = {.lex_state = 69},
  [1368] = {.lex_state = 69},
  [1369] = {.lex_state = 69},
  [1370] = {.lex_state = 69},
  [1371] = {.lex_state = 69},
  [1372] = {.lex_state = 69},
  [1373] = {.lex_state = 69},
  [1374] = {.lex_state = 69},
  [1375] = {.lex_state = 69},
  [1376] = {.lex_state = 69},
  [1377] = {.lex_state = 69},
  [1378] = {.lex_state = 69},
  [1379] = {.lex_state = 69},
  [1380] = {.lex_state = 69},
  [1381] = {.lex_state = 69},
  [1382] = {.lex_state = 69},
  [1383] = {.lex_state = 69},
  [1384] = {.lex_state = 69},
  [1385] = {.lex_state = 69},
  [1386] = {.lex_state = 69},
  [1387] = {.lex_state = 69},
  [1388] = {.lex_state = 69},
  [1389] = {.lex_state = 69},
  [1390] = {.lex_state = 69},
  [1391] = {.lex_state = 28},
  [1392] = {.lex_state = 19, .external_lex_state = 3},
  [1393] = {.lex_state = 7},
  [1394] = {.lex_state = 69},
  [1395] = {.lex_state = 28},
  [1396] = {.lex_state = 13, .external_lex_state = 4},
  [1397] = {.lex_state = 19, .external_lex_state = 3},
  [1398] = {.lex_state = 13, .external_lex_state = 4},
  [1399] = {.lex_state = 19, .external_lex_state = 3},
  [1400] = {.lex_state = 70},
  [1401] = {.lex_state = 70},
  [1402] = {.lex_state = 70},
  [1403] = {.lex_state = 19, .external_lex_state = 3},
  [1404] = {.lex_state = 13, .external_lex_state = 4},
  [1405] = {.lex_state = 19, .external_lex_state = 3},
  [1406] = {.lex_state = 28},
  [1407] = {.lex_state = 13, .external_lex_state = 4},
  [1408] = {.lex_state = 69},
  [1409] = {.lex_state = 13, .external_lex_state = 4},
  [1410] = {.lex_state = 13, .external_lex_state = 4},
  [1411] = {.lex_state = 69},
  [1412] = {.lex_state = 69},
  [1413] = {.lex_state = 69},
  [1414] = {.lex_state = 28},
  [1415] = {.lex_state = 13, .external_lex_state = 4},
  [1416] = {.lex_state = 19, .external_lex_state = 3},
  [1417] = {.lex_state = 7},
  [1418] = {.lex_state = 7},
  [1419] = {.lex_state = 69},
  [1420] = {.lex_state = 69},
  [1421] = {.lex_state = 70},
  [1422] = {.lex_state = 69},
  [1423] = {.lex_state = 19, .external_lex_state = 3},
  [1424] = {.lex_state = 22, .external_lex_state = 5},
  [1425] = {.lex_state = 69},
  [1426] = {.lex_state = 13, .external_lex_state = 6},
  [1427] = {.lex_state = 19, .external_lex_state = 7},
  [1428] = {.lex_state = 13, .external_lex_state = 6},
  [1429] = {.lex_state = 70},
  [1430] = {.lex_state = 28},
  [1431] = {.lex_state = 22, .external_lex_state = 5},
  [1432] = {.lex_state = 13, .external_lex_state = 6},
  [1433] = {.lex_state = 19, .external_lex_state = 7},
  [1434] = {.lex_state = 22, .external_lex_state = 8},
  [1435] = {.lex_state = 28},
  [1436] = {.lex_state = 19, .external_lex_state = 7},
  [1437] = {.lex_state = 28},
  [1438] = {.lex_state = 7},
  [1439] = {.lex_state = 22, .external_lex_state = 8},
  [1440] = {.lex_state = 22, .external_lex_state = 5},
  [1441] = {.lex_state = 69},
  [1442] = {.lex_state = 69},
  [1443] = {.lex_state = 19, .external_lex_state = 7},
  [1444] = {.lex_state = 69},
  [1445] = {.lex_state = 19, .external_lex_state = 7},
  [1446] = {.lex_state = 13, .external_lex_state = 6},
  [1447] = {.lex_state = 22, .external_lex_state = 5},
  [1448] = {.lex_state = 13, .external_lex_state = 6},
  [1449] = {.lex_state = 19, .external_lex_state = 7},
  [1450] = {.lex_state = 28},
  [1451] = {.lex_state = 22, .external_lex_state = 8},
  [1452] = {.lex_state = 22, .external_lex_state = 5},
  [1453] = {.lex_state = 22, .external_lex_state = 8},
  [1454] = {.lex_state = 22, .external_lex_state = 8},
  [1455] = {.lex_state = 7},
  [1456] = {.lex_state = 68},
  [1457] = {.lex_state = 19, .external_lex_state = 7},
  [1458] = {.lex_state = 13, .external_lex_state = 6},
  [1459] = {.lex_state = 69},
  [1460] = {.lex_state = 28},
  [1461] = {.lex_state = 28},
  [1462] = {.lex_state = 7},
  [1463] = {.lex_state = 22, .external_lex_state = 5},
  [1464] = {.lex_state = 22, .external_lex_state = 8},
  [1465] = {.lex_state = 22, .external_lex_state = 5},
  [1466] = {.lex_state = 22, .external_lex_state = 8},
  [1467] = {.lex_state = 69},
  [1468] = {.lex_state = 13, .external_lex_state = 6},
  [1469] = {.lex_state = 12},
  [1470] = {.lex_state = 22, .external_lex_state = 9},
  [1471] = {.lex_state = 12},
  [1472] = {.lex_state = 69},
  [1473] = {.lex_state = 69},
  [1474] = {.lex_state = 12},
  [1475] = {.lex_state = 69},
  [1476] = {.lex_state = 28},
  [1477] = {.lex_state = 28},
  [1478] = {.lex_state = 69},
  [1479] = {.lex_state = 12},
  [1480] = {.lex_state = 28},
  [1481] = {.lex_state = 7},
  [1482] = {.lex_state = 12},
  [1483] = {.lex_state = 69},
  [1484] = {.lex_state = 69},
  [1485] = {.lex_state = 69},
  [1486] = {.lex_state = 22, .external_lex_state = 9},
  [1487] = {.lex_state = 22, .external_lex_state = 10},
  [1488] = {.lex_state = 22, .external_lex_state = 9},
  [1489] = {.lex_state = 22, .external_lex_state = 10},
  [1490] = {.lex_state = 69},
  [1491] = {.lex_state = 68},
  [1492] = {.lex_state = 7},
  [1493] = {.lex_state = 12},
  [1494] = {.lex_state = 69},
  [1495] = {.lex_state = 69},
  [1496] = {.lex_state = 22, .external_lex_state = 10},
  [1497] = {.lex_state = 69},
  [1498] = {.lex_state = 22, .external_lex_state = 9},
  [1499] = {.lex_state = 69},
  [1500] = {.lex_state = 28},
  [1501] = {.lex_state = 22, .external_lex_state = 9},
  [1502] = {.lex_state = 22, .external_lex_state = 10},
  [1503] = {.lex_state = 69},
  [1504] = {.lex_state = 69},
  [1505] = {.lex_state = 12},
  [1506] = {.lex_state = 69},
  [1507] = {.lex_state = 12},
  [1508] = {.lex_state = 69},
  [1509] = {.lex_state = 69},
  [1510] = {.lex_state = 69},
  [1511] = {.lex_state = 69},
  [1512] = {.lex_state = 69},
  [1513] = {.lex_state = 7},
  [1514] = {.lex_state = 22, .external_lex_state = 10},
  [1515] = {.lex_state = 69},
  [1516] = {.lex_state = 12},
  [1517] = {.lex_state = 69},
  [1518] = {.lex_state = 22, .external_lex_state = 9},
  [1519] = {.lex_state = 22, .external_lex_state = 9},
  [1520] = {.lex_state = 15, .external_lex_state = 6},
  [1521] = {.lex_state = 12},
  [1522] = {.lex_state = 21, .external_lex_state = 7},
  [1523] = {.lex_state = 22, .external_lex_state = 10},
  [1524] = {.lex_state = 12},
  [1525] = {.lex_state = 28},
  [1526] = {.lex_state = 22, .external_lex_state = 10},
  [1527] = {.lex_state = 28},
  [1528] = {.lex_state = 70},
  [1529] = {.lex_state = 69},
  [1530] = {.lex_state = 70},
  [1531] = {.lex_state = 70},
  [1532] = {.lex_state = 70},
  [1533] = {.lex_state = 70},
  [1534] = {.lex_state = 70},
  [1535] = {.lex_state = 70},
  [1536] = {.lex_state = 70},
  [1537] = {.lex_state = 24, .external_lex_state = 9},
  [1538] = {.lex_state = 7},
  [1539] = {.lex_state = 70},
  [1540] = {.lex_state = 70},
  [1541] = {.lex_state = 70},
  [1542] = {.lex_state = 70},
  [1543] = {.lex_state = 7},
  [1544] = {.lex_state = 70},
  [1545] = {.lex_state = 70},
  [1546] = {.lex_state = 19, .external_lex_state = 7},
  [1547] = {.lex_state = 70},
  [1548] = {.lex_state = 69},
  [1549] = {.lex_state = 70},
  [1550] = {.lex_state = 12},
  [1551] = {.lex_state = 70},
  [1552] = {.lex_state = 7},
  [1553] = {.lex_state = 7},
  [1554] = {.lex_state = 13, .external_lex_state = 6},
  [1555] = {.lex_state = 70},
  [1556] = {.lex_state = 7},
  [1557] = {.lex_state = 69},
  [1558] = {.lex_state = 7},
  [1559] = {.lex_state = 69},
  [1560] = {.lex_state = 69},
  [1561] = {.lex_state = 28},
  [1562] = {.lex_state = 12},
  [1563] = {.lex_state = 70},
  [1564] = {.lex_state = 70},
  [1565] = {.lex_state = 69},
  [1566] = {.lex_state = 69},
  [1567] = {.lex_state = 70},
  [1568] = {.lex_state = 69},
  [1569] = {.lex_state = 70},
  [1570] = {.lex_state = 70},
  [1571] = {.lex_state = 70},
  [1572] = {.lex_state = 24, .external_lex_state = 10},
  [1573] = {.lex_state = 68},
  [1574] = {.lex_state = 70},
  [1575] = {.lex_state = 70},
  [1576] = {.lex_state = 70},
  [1577] = {.lex_state = 70},
  [1578] = {.lex_state = 70},
  [1579] = {.lex_state = 70},
  [1580] = {.lex_state = 7},
  [1581] = {.lex_state = 7},
  [1582] = {.lex_state = 7},
  [1583] = {.lex_state = 7},
  [1584] = {.lex_state = 68},
  [1585] = {.lex_state = 70},
  [1586] = {.lex_state = 70},
  [1587] = {.lex_state = 70},
  [1588] = {.lex_state = 70},
  [1589] = {.lex_state = 69},
  [1590] = {.lex_state = 70},
  [1591] = {.lex_state = 69},
  [1592] = {.lex_state = 7},
  [1593] = {.lex_state = 70},
  [1594] = {.lex_state = 7},
  [1595] = {.lex_state = 70},
  [1596] = {.lex_state = 12},
  [1597] = {.lex_state = 69},
  [1598] = {.lex_state = 7},
  [1599] = {.lex_state = 7},
  [1600] = {.lex_state = 7},
  [1601] = {.lex_state = 7},
  [1602] = {.lex_state = 7},
  [1603] = {.lex_state = 69},
  [1604] = {.lex_state = 7},
  [1605] = {.lex_state = 0},
  [1606] = {.lex_state = 69},
  [1607] = {.lex_state = 69},
  [1608] = {.lex_state = 69},
  [1609] = {.lex_state = 69},
  [1610] = {.lex_state = 69},
  [1611] = {.lex_state = 69},
  [1612] = {.lex_state = 69},
  [1613] = {.lex_state = 69},
  [1614] = {.lex_state = 69},
  [1615] = {.lex_state = 7},
  [1616] = {.lex_state = 69},
  [1617] = {.lex_state = 69},
  [1618] = {.lex_state = 69},
  [1619] = {.lex_state = 19, .external_lex_state = 3},
  [1620] = {.lex_state = 69},
  [1621] = {.lex_state = 69},
  [1622] = {.lex_state = 7},
  [1623] = {.lex_state = 7},
  [1624] = {.lex_state = 19, .external_lex_state = 3},
  [1625] = {.lex_state = 19, .external_lex_state = 3},
  [1626] = {.lex_state = 69},
  [1627] = {.lex_state = 22, .external_lex_state = 10},
  [1628] = {.lex_state = 7},
  [1629] = {.lex_state = 7},
  [1630] = {.lex_state = 69},
  [1631] = {.lex_state = 7},
  [1632] = {.lex_state = 69},
  [1633] = {.lex_state = 70},
  [1634] = {.lex_state = 69},
  [1635] = {.lex_state = 69},
  [1636] = {.lex_state = 7},
  [1637] = {.lex_state = 69},
  [1638] = {.lex_state = 22, .external_lex_state = 9},
  [1639] = {.lex_state = 69},
  [1640] = {.lex_state = 69},
  [1641] = {.lex_state = 69},
  [1642] = {.lex_state = 69},
  [1643] = {.lex_state = 68},
  [1644] = {.lex_state = 69},
  [1645] = {.lex_state = 69},
  [1646] = {.lex_state = 69},
  [1647] = {.lex_state = 7},
  [1648] = {.lex_state = 69},
  [1649] = {.lex_state = 13, .external_lex_state = 4},
  [1650] = {.lex_state = 7},
  [1651] = {.lex_state = 7},
  [1652] = {.lex_state = 69},
  [1653] = {.lex_state = 13, .external_lex_state = 4},
  [1654] = {.lex_state = 7},
  [1655] = {.lex_state = 7},
  [1656] = {.lex_state = 13, .external_lex_state = 4},
  [1657] = {.lex_state = 13, .external_lex_state = 4},
  [1658] = {.lex_state = 69},
  [1659] = {.lex_state = 69},
  [1660] = {.lex_state = 69},
  [1661] = {.lex_state = 69},
  [1662] = {.lex_state = 69},
  [1663] = {.lex_state = 69},
  [1664] = {.lex_state = 69},
  [1665] = {.lex_state = 69},
  [1666] = {.lex_state = 69},
  [1667] = {.lex_state = 69},
  [1668] = {.lex_state = 69},
  [1669] = {.lex_state = 69},
  [1670] = {.lex_state = 19, .external_lex_state = 3},
  [1671] = {.lex_state = 69},
  [1672] = {.lex_state = 28},
  [1673] = {.lex_state = 69},
  [1674] = {.lex_state = 7},
  [1675] = {.lex_state = 69},
  [1676] = {.lex_state = 69},
  [1677] = {.lex_state = 0},
  [1678] = {.lex_state = 12},
  [1679] = {.lex_state = 22, .external_lex_state = 5},
  [1680] = {.lex_state = 69},
  [1681] = {.lex_state = 68},
  [1682] = {.lex_state = 70},
  [1683] = {.lex_state = 69},
  [1684] = {.lex_state = 69},
  [1685] = {.lex_state = 68},
  [1686] = {.lex_state = 68},
  [1687] = {.lex_state = 69},
  [1688] = {.lex_state = 22, .external_lex_state = 5},
  [1689] = {.lex_state = 69},
  [1690] = {.lex_state = 12},
  [1691] = {.lex_state = 69},
  [1692] = {.lex_state = 69},
  [1693] = {.lex_state = 69},
  [1694] = {.lex_state = 69},
  [1695] = {.lex_state = 68},
  [1696] = {.lex_state = 68},
  [1697] = {.lex_state = 69},
  [1698] = {.lex_state = 68},
  [1699] = {.lex_state = 69},
  [1700] = {.lex_state = 68},
  [1701] = {.lex_state = 69},
  [1702] = {.lex_state = 12},
  [1703] = {.lex_state = 69},
  [1704] = {.lex_state = 69},
  [1705] = {.lex_state = 22, .external_lex_state = 8},
  [1706] = {.lex_state = 22, .external_lex_state = 8},
  [1707] = {.lex_state = 69},
  [1708] = {.lex_state = 69},
  [1709] = {.lex_state = 68},
  [1710] = {.lex_state = 22, .external_lex_state = 5},
  [1711] = {.lex_state = 68},
  [1712] = {.lex_state = 69},
  [1713] = {.lex_state = 12},
  [1714] = {.lex_state = 7},
  [1715] = {.lex_state = 70},
  [1716] = {.lex_state = 69},
  [1717] = {.lex_state = 69},
  [1718] = {.lex_state = 12},
  [1719] = {.lex_state = 69},
  [1720] = {.lex_state = 22, .external_lex_state = 5},
  [1721] = {.lex_state = 69},
  [1722] = {.lex_state = 69},
  [1723] = {.lex_state = 22, .external_lex_state = 8},
  [1724] = {.lex_state = 69},
  [1725] = {.lex_state = 69},
  [1726] = {.lex_state = 69},
  [1727] = {.lex_state = 22, .external_lex_state = 8},
  [1728] = {.lex_state = 69},
  [1729] = {.lex_state = 69},
  [1730] = {.lex_state = 0},
  [1731] = {.lex_state = 70},
  [1732] = {.lex_state = 69},
  [1733] = {.lex_state = 69},
  [1734] = {.lex_state = 12},
  [1735] = {.lex_state = 69},
  [1736] = {.lex_state = 69},
  [1737] = {.lex_state = 68},
  [1738] = {.lex_state = 70},
  [1739] = {.lex_state = 69},
  [1740] = {.lex_state = 0},
  [1741] = {.lex_state = 69},
  [1742] = {.lex_state = 69},
  [1743] = {.lex_state = 0},
  [1744] = {.lex_state = 69},
  [1745] = {.lex_state = 0},
  [1746] = {.lex_state = 68},
  [1747] = {.lex_state = 69},
  [1748] = {.lex_state = 69},
  [1749] = {.lex_state = 69},
  [1750] = {.lex_state = 69},
  [1751] = {.lex_state = 68},
  [1752] = {.lex_state = 69},
  [1753] = {.lex_state = 69},
  [1754] = {.lex_state = 69},
  [1755] = {.lex_state = 69},
  [1756] = {.lex_state = 69},
  [1757] = {.lex_state = 0},
  [1758] = {.lex_state = 68},
  [1759] = {.lex_state = 69},
  [1760] = {.lex_state = 69},
  [1761] = {.lex_state = 69},
  [1762] = {.lex_state = 0},
  [1763] = {.lex_state = 69},
  [1764] = {.lex_state = 69},
  [1765] = {.lex_state = 69},
  [1766] = {.lex_state = 69},
  [1767] = {.lex_state = 69},
  [1768] = {.lex_state = 68},
  [1769] = {.lex_state = 69},
  [1770] = {.lex_state = 0},
  [1771] = {.lex_state = 0},
  [1772] = {.lex_state = 69},
  [1773] = {.lex_state = 69},
  [1774] = {.lex_state = 69},
  [1775] = {.lex_state = 69},
  [1776] = {.lex_state = 69},
  [1777] = {.lex_state = 69},
  [1778] = {.lex_state = 0},
  [1779] = {.lex_state = 69},
  [1780] = {.lex_state = 69},
  [1781] = {.lex_state = 68},
  [1782] = {.lex_state = 69},
  [1783] = {.lex_state = 69},
  [1784] = {.lex_state = 0},
  [1785] = {.lex_state = 69},
  [1786] = {.lex_state = 69},
  [1787] = {.lex_state = 0},
  [1788] = {.lex_state = 0},
  [1789] = {.lex_state = 0},
  [1790] = {.lex_state = 0},
  [1791] = {.lex_state = 0},
  [1792] = {.lex_state = 0},
  [1793] = {.lex_state = 69},
  [1794] = {.lex_state = 69},
  [1795] = {.lex_state = 0},
  [1796] = {.lex_state = 69},
  [1797] = {.lex_state = 68},
  [1798] = {.lex_state = 69},
  [1799] = {.lex_state = 38},
  [1800] = {.lex_state = 0},
  [1801] = {.lex_state = 69},
  [1802] = {.lex_state = 0},
  [1803] = {.lex_state = 0},
  [1804] = {.lex_state = 0},
  [1805] = {.lex_state = 0},
  [1806] = {.lex_state = 68},
  [1807] = {.lex_state = 0},
  [1808] = {.lex_state = 0},
  [1809] = {.lex_state = 0},
  [1810] = {.lex_state = 0},
  [1811] = {.lex_state = 0},
  [1812] = {.lex_state = 0},
  [1813] = {.lex_state = 0},
  [1814] = {.lex_state = 69},
  [1815] = {.lex_state = 69},
  [1816] = {.lex_state = 0},
  [1817] = {.lex_state = 0},
  [1818] = {.lex_state = 69},
  [1819] = {.lex_state = 69},
  [1820] = {.lex_state = 69},
  [1821] = {.lex_state = 0},
  [1822] = {.lex_state = 69},
  [1823] = {.lex_state = 0},
  [1824] = {.lex_state = 0},
  [1825] = {.lex_state = 69},
  [1826] = {.lex_state = 0},
  [1827] = {.lex_state = 69},
  [1828] = {.lex_state = 0},
  [1829] = {.lex_state = 0},
  [1830] = {.lex_state = 0},
  [1831] = {.lex_state = 0},
  [1832] = {.lex_state = 69},
  [1833] = {.lex_state = 69},
  [1834] = {.lex_state = 0},
  [1835] = {.lex_state = 0},
  [1836] = {.lex_state = 0},
  [1837] = {.lex_state = 69},
  [1838] = {.lex_state = 69},
  [1839] = {.lex_state = 0},
  [1840] = {.lex_state = 38},
  [1841] = {.lex_state = 0},
  [1842] = {.lex_state = 0},
  [1843] = {.lex_state = 0},
  [1844] = {.lex_state = 69},
  [1845] = {.lex_state = 69},
  [1846] = {.lex_state = 38},
  [1847] = {.lex_state = 69},
  [1848] = {.lex_state = 0},
  [1849] = {.lex_state = 0},
  [1850] = {.lex_state = 0},
  [1851] = {.lex_state = 0},
  [1852] = {.lex_state = 0},
  [1853] = {.lex_state = 0},
  [1854] = {.lex_state = 0},
  [1855] = {.lex_state = 0},
  [1856] = {.lex_state = 0},
  [1857] = {.lex_state = 68},
  [1858] = {.lex_state = 69},
  [1859] = {.lex_state = 0},
  [1860] = {.lex_state = 0},
  [1861] = {.lex_state = 69},
  [1862] = {.lex_state = 0},
  [1863] = {.lex_state = 0},
  [1864] = {.lex_state = 0},
  [1865] = {.lex_state = 0},
  [1866] = {.lex_state = 69},
  [1867] = {.lex_state = 69},
  [1868] = {.lex_state = 0},
  [1869] = {.lex_state = 0},
  [1870] = {.lex_state = 0},
  [1871] = {.lex_state = 0},
  [1872] = {.lex_state = 69},
  [1873] = {.lex_state = 0},
  [1874] = {.lex_state = 0},
  [1875] = {.lex_state = 69},
  [1876] = {.lex_state = 0},
  [1877] = {.lex_state = 69},
  [1878] = {.lex_state = 0},
  [1879] = {.lex_state = 69},
  [1880] = {.lex_state = 69},
  [1881] = {.lex_state = 0},
  [1882] = {.lex_state = 0},
  [1883] = {.lex_state = 69},
  [1884] = {.lex_state = 69},
  [1885] = {.lex_state = 69},
  [1886] = {.lex_state = 0},
  [1887] = {.lex_state = 0},
  [1888] = {.lex_state = 0},
  [1889] = {.lex_state = 69},
  [1890] = {.lex_state = 69},
  [1891] = {.lex_state = 0},
  [1892] = {.lex_state = 0},
  [1893] = {.lex_state = 0},
  [1894] = {.lex_state = 0},
  [1895] = {.lex_state = 0},
  [1896] = {.lex_state = 0},
  [1897] = {.lex_state = 0},
  [1898] = {.lex_state = 0},
  [1899] = {.lex_state = 0},
  [1900] = {.lex_state = 69},
  [1901] = {.lex_state = 69},
  [1902] = {.lex_state = 0},
  [1903] = {.lex_state = 0},
  [1904] = {.lex_state = 0},
  [1905] = {.lex_state = 0},
  [1906] = {.lex_state = 0},
  [1907] = {.lex_state = 69},
  [1908] = {.lex_state = 69},
  [1909] = {.lex_state = 69},
  [1910] = {.lex_state = 69},
  [1911] = {.lex_state = 0},
  [1912] = {.lex_state = 0},
  [1913] = {.lex_state = 0},
  [1914] = {.lex_state = 0},
  [1915] = {.lex_state = 0},
  [1916] = {.lex_state = 0},
  [1917] = {.lex_state = 0},
  [1918] = {.lex_state = 0},
  [1919] = {.lex_state = 0},
  [1920] = {.lex_state = 0},
  [1921] = {.lex_state = 69},
  [1922] = {.lex_state = 0},
  [1923] = {.lex_state = 0},
  [1924] = {.lex_state = 0},
  [1925] = {.lex_state = 0},
  [1926] = {.lex_state = 69},
  [1927] = {.lex_state = 68},
  [1928] = {.lex_state = 0},
  [1929] = {.lex_state = 69},
  [1930] = {.lex_state = 69},
  [1931] = {.lex_state = 0},
  [1932] = {.lex_state = 69},
  [1933] = {.lex_state = 0},
  [1934] = {.lex_state = 0},
  [1935] = {.lex_state = 69},
  [1936] = {.lex_state = 0},
  [1937] = {.lex_state = 0},
  [1938] = {.lex_state = 69},
  [1939] = {.lex_state = 0},
  [1940] = {.lex_state = 69},
  [1941] = {.lex_state = 0},
  [1942] = {.lex_state = 69},
  [1943] = {.lex_state = 69},
  [1944] = {.lex_state = 0},
  [1945] = {.lex_state = 69},
  [1946] = {.lex_state = 0},
  [1947] = {.lex_state = 69},
  [1948] = {.lex_state = 69},
  [1949] = {.lex_state = 69},
  [1950] = {.lex_state = 0},
  [1951] = {.lex_state = 69},
  [1952] = {.lex_state = 0},
  [1953] = {.lex_state = 69},
  [1954] = {.lex_state = 69},
  [1955] = {.lex_state = 0},
  [1956] = {.lex_state = 0},
  [1957] = {.lex_state = 69},
  [1958] = {.lex_state = 0},
  [1959] = {.lex_state = 0},
  [1960] = {.lex_state = 69},
  [1961] = {.lex_state = 0},
  [1962] = {.lex_state = 69},
  [1963] = {.lex_state = 0},
  [1964] = {.lex_state = 38},
  [1965] = {.lex_state = 69},
  [1966] = {.lex_state = 69},
  [1967] = {.lex_state = 0},
  [1968] = {.lex_state = 0},
  [1969] = {.lex_state = 0},
  [1970] = {.lex_state = 0},
  [1971] = {.lex_state = 0},
  [1972] = {.lex_state = 0},
  [1973] = {.lex_state = 0},
  [1974] = {.lex_state = 0},
  [1975] = {.lex_state = 0},
  [1976] = {.lex_state = 69},
  [1977] = {.lex_state = 0},
  [1978] = {.lex_state = 69},
  [1979] = {.lex_state = 69},
  [1980] = {.lex_state = 69},
  [1981] = {.lex_state = 69},
  [1982] = {.lex_state = 0},
  [1983] = {.lex_state = 0},
  [1984] = {.lex_state = 0},
  [1985] = {.lex_state = 69},
  [1986] = {.lex_state = 68},
  [1987] = {.lex_state = 0},
  [1988] = {.lex_state = 0},
  [1989] = {.lex_state = 69},
  [1990] = {.lex_state = 0},
  [1991] = {.lex_state = 69},
  [1992] = {.lex_state = 0},
  [1993] = {.lex_state = 69},
  [1994] = {.lex_state = 0},
  [1995] = {.lex_state = 69},
  [1996] = {.lex_state = 0},
  [1997] = {.lex_state = 70},
  [1998] = {.lex_state = 0},
  [1999] = {.lex_state = 68},
  [2000] = {.lex_state = 69},
  [2001] = {.lex_state = 68},
  [2002] = {.lex_state = 0},
  [2003] = {.lex_state = 69},
  [2004] = {.lex_state = 0},
  [2005] = {.lex_state = 0},
  [2006] = {.lex_state = 0},
  [2007] = {.lex_state = 0},
  [2008] = {.lex_state = 0},
  [2009] = {.lex_state = 0},
  [2010] = {.lex_state = 0},
  [2011] = {.lex_state = 0},
  [2012] = {.lex_state = 0},
  [2013] = {.lex_state = 0},
  [2014] = {.lex_state = 0},
  [2015] = {.lex_state = 0},
  [2016] = {.lex_state = 0},
  [2017] = {.lex_state = 0},
  [2018] = {.lex_state = 69},
  [2019] = {.lex_state = 69},
  [2020] = {.lex_state = 68},
  [2021] = {.lex_state = 69},
  [2022] = {.lex_state = 0},
  [2023] = {.lex_state = 0},
  [2024] = {.lex_state = 0},
  [2025] = {.lex_state = 0},
  [2026] = {.lex_state = 69},
  [2027] = {.lex_state = 0},
  [2028] = {.lex_state = 69},
  [2029] = {.lex_state = 0},
  [2030] = {.lex_state = 0},
  [2031] = {.lex_state = 69},
  [2032] = {.lex_state = 0},
  [2033] = {.lex_state = 0},
  [2034] = {.lex_state = 0},
  [2035] = {.lex_state = 0},
  [2036] = {.lex_state = 0},
  [2037] = {.lex_state = 0},
  [2038] = {.lex_state = 0},
  [2039] = {.lex_state = 0},
  [2040] = {.lex_state = 0},
  [2041] = {.lex_state = 0},
  [2042] = {.lex_state = 0},
  [2043] = {.lex_state = 0},
  [2044] = {.lex_state = 0},
  [2045] = {.lex_state = 0},
  [2046] = {.lex_state = 69},
  [2047] = {.lex_state = 0},
  [2048] = {.lex_state = 0},
  [2049] = {.lex_state = 0},
  [2050] = {.lex_state = 0},
  [2051] = {.lex_state = 0},
  [2052] = {.lex_state = 0},
  [2053] = {.lex_state = 0},
  [2054] = {.lex_state = 0},
  [2055] = {.lex_state = 0},
  [2056] = {.lex_state = 69},
  [2057] = {.lex_state = 0},
  [2058] = {.lex_state = 0},
  [2059] = {.lex_state = 0},
  [2060] = {.lex_state = 0},
  [2061] = {.lex_state = 0},
  [2062] = {.lex_state = 0},
  [2063] = {.lex_state = 69},
  [2064] = {.lex_state = 0},
  [2065] = {.lex_state = 0},
  [2066] = {.lex_state = 0},
  [2067] = {.lex_state = 0},
  [2068] = {.lex_state = 69},
  [2069] = {.lex_state = 0},
  [2070] = {.lex_state = 0},
  [2071] = {.lex_state = 0},
  [2072] = {.lex_state = 0},
  [2073] = {.lex_state = 0},
  [2074] = {.lex_state = 0},
  [2075] = {.lex_state = 0},
  [2076] = {.lex_state = 69},
  [2077] = {.lex_state = 0},
  [2078] = {.lex_state = 0},
  [2079] = {.lex_state = 0},
  [2080] = {.lex_state = 0},
  [2081] = {.lex_state = 0},
  [2082] = {.lex_state = 0},
  [2083] = {.lex_state = 0},
  [2084] = {.lex_state = 0},
  [2085] = {.lex_state = 69},
  [2086] = {.lex_state = 69},
  [2087] = {.lex_state = 0},
  [2088] = {.lex_state = 0},
  [2089] = {.lex_state = 69},
  [2090] = {.lex_state = 0},
  [2091] = {.lex_state = 0},
  [2092] = {.lex_state = 0},
  [2093] = {.lex_state = 0},
  [2094] = {.lex_state = 0},
  [2095] = {.lex_state = 0},
  [2096] = {.lex_state = 0},
  [2097] = {.lex_state = 19},
  [2098] = {.lex_state = 0},
  [2099] = {.lex_state = 0},
  [2100] = {.lex_state = 0},
  [2101] = {.lex_state = 0},
  [2102] = {.lex_state = 0},
  [2103] = {.lex_state = 0},
  [2104] = {.lex_state = 69},
  [2105] = {.lex_state = 0},
  [2106] = {.lex_state = 0},
  [2107] = {.lex_state = 0},
  [2108] = {.lex_state = 0},
  [2109] = {.lex_state = 0},
  [2110] = {.lex_state = 0},
  [2111] = {.lex_state = 69},
  [2112] = {.lex_state = 0},
  [2113] = {.lex_state = 0},
  [2114] = {.lex_state = 69},
  [2115] = {.lex_state = 69},
  [2116] = {.lex_state = 0},
  [2117] = {.lex_state = 0},
  [2118] = {.lex_state = 0},
  [2119] = {.lex_state = 69},
  [2120] = {.lex_state = 0},
  [2121] = {.lex_state = 0},
  [2122] = {.lex_state = 0},
  [2123] = {.lex_state = 0},
  [2124] = {.lex_state = 0},
  [2125] = {.lex_state = 69},
  [2126] = {.lex_state = 0},
  [2127] = {.lex_state = 0},
  [2128] = {.lex_state = 0},
  [2129] = {.lex_state = 69},
  [2130] = {.lex_state = 0},
  [2131] = {.lex_state = 69},
  [2132] = {.lex_state = 0},
  [2133] = {.lex_state = 0},
  [2134] = {.lex_state = 69},
  [2135] = {.lex_state = 0},
  [2136] = {.lex_state = 69},
  [2137] = {.lex_state = 69},
  [2138] = {.lex_state = 69},
  [2139] = {.lex_state = 0},
  [2140] = {.lex_state = 0},
  [2141] = {.lex_state = 69},
  [2142] = {.lex_state = 69},
  [2143] = {.lex_state = 69},
  [2144] = {.lex_state = 0},
  [2145] = {.lex_state = 0},
  [2146] = {.lex_state = 69},
  [2147] = {.lex_state = 69},
  [2148] = {.lex_state = 69},
  [2149] = {.lex_state = 0},
  [2150] = {.lex_state = 0},
  [2151] = {.lex_state = 0},
  [2152] = {.lex_state = 0},
  [2153] = {.lex_state = 69},
  [2154] = {.lex_state = 0},
  [2155] = {.lex_state = 0},
  [2156] = {.lex_state = 69},
  [2157] = {.lex_state = 0},
  [2158] = {.lex_state = 0},
  [2159] = {.lex_state = 0},
  [2160] = {.lex_state = 0},
  [2161] = {.lex_state = 0},
  [2162] = {.lex_state = 69},
  [2163] = {.lex_state = 69},
  [2164] = {.lex_state = 69},
  [2165] = {.lex_state = 0},
  [2166] = {.lex_state = 0},
  [2167] = {.lex_state = 0},
  [2168] = {.lex_state = 69},
  [2169] = {.lex_state = 69},
  [2170] = {.lex_state = 0},
  [2171] = {.lex_state = 0},
  [2172] = {.lex_state = 69},
  [2173] = {.lex_state = 0},
  [2174] = {.lex_state = 0},
  [2175] = {.lex_state = 0},
  [2176] = {.lex_state = 0},
  [2177] = {.lex_state = 0},
  [2178] = {.lex_state = 0},
  [2179] = {.lex_state = 69},
  [2180] = {.lex_state = 69},
  [2181] = {.lex_state = 0},
  [2182] = {.lex_state = 0},
  [2183] = {.lex_state = 0},
  [2184] = {.lex_state = 0},
  [2185] = {.lex_state = 0},
  [2186] = {.lex_state = 0},
  [2187] = {.lex_state = 69},
  [2188] = {.lex_state = 69},
  [2189] = {.lex_state = 0},
  [2190] = {.lex_state = 69},
  [2191] = {.lex_state = 0},
  [2192] = {.lex_state = 0},
  [2193] = {.lex_state = 69},
  [2194] = {.lex_state = 69},
  [2195] = {.lex_state = 0},
  [2196] = {.lex_state = 0},
  [2197] = {.lex_state = 0},
  [2198] = {.lex_state = 0},
  [2199] = {.lex_state = 0},
  [2200] = {.lex_state = 69},
  [2201] = {.lex_state = 69},
  [2202] = {.lex_state = 0},
  [2203] = {.lex_state = 69},
  [2204] = {.lex_state = 69},
  [2205] = {.lex_state = 69},
  [2206] = {.lex_state = 0},
  [2207] = {.lex_state = 0},
  [2208] = {.lex_state = 69},
  [2209] = {.lex_state = 69},
  [2210] = {.lex_state = 69},
  [2211] = {.lex_state = 0},
  [2212] = {.lex_state = 69},
  [2213] = {.lex_state = 0},
  [2214] = {.lex_state = 69},
  [2215] = {.lex_state = 69},
  [2216] = {.lex_state = 0},
  [2217] = {.lex_state = 0},
  [2218] = {.lex_state = 0},
  [2219] = {.lex_state = 0},
  [2220] = {.lex_state = 0},
  [2221] = {.lex_state = 1},
  [2222] = {.lex_state = 0},
  [2223] = {.lex_state = 0},
  [2224] = {.lex_state = 0},
  [2225] = {.lex_state = 0},
  [2226] = {.lex_state = 69},
  [2227] = {.lex_state = 0},
  [2228] = {.lex_state = 0},
  [2229] = {.lex_state = 0},
  [2230] = {.lex_state = 0},
  [2231] = {.lex_state = 0},
  [2232] = {.lex_state = 0},
  [2233] = {.lex_state = 0},
  [2234] = {.lex_state = 69},
  [2235] = {.lex_state = 0},
  [2236] = {.lex_state = 0},
  [2237] = {.lex_state = 0},
  [2238] = {.lex_state = 0},
  [2239] = {.lex_state = 0},
  [2240] = {.lex_state = 0},
  [2241] = {.lex_state = 69},
  [2242] = {.lex_state = 69},
  [2243] = {.lex_state = 69},
  [2244] = {.lex_state = 0},
  [2245] = {.lex_state = 0},
  [2246] = {.lex_state = 69},
  [2247] = {.lex_state = 69},
  [2248] = {.lex_state = 0},
  [2249] = {.lex_state = 0},
  [2250] = {.lex_state = 69},
  [2251] = {.lex_state = 0},
  [2252] = {.lex_state = 0},
  [2253] = {.lex_state = 0},
  [2254] = {.lex_state = 69},
  [2255] = {.lex_state = 69},
  [2256] = {.lex_state = 68},
  [2257] = {.lex_state = 69},
  [2258] = {.lex_state = 0},
  [2259] = {.lex_state = 69},
  [2260] = {.lex_state = 69},
  [2261] = {.lex_state = 69},
  [2262] = {.lex_state = 0},
  [2263] = {.lex_state = 0},
  [2264] = {.lex_state = 69},
  [2265] = {.lex_state = 0},
  [2266] = {.lex_state = 0},
  [2267] = {.lex_state = 0},
  [2268] = {.lex_state = 0},
  [2269] = {.lex_state = 2},
  [2270] = {.lex_state = 0},
  [2271] = {.lex_state = 69},
  [2272] = {.lex_state = 0},
  [2273] = {.lex_state = 0},
  [2274] = {.lex_state = 0},
  [2275] = {.lex_state = 0},
  [2276] = {.lex_state = 0},
  [2277] = {.lex_state = 0},
  [2278] = {.lex_state = 0},
  [2279] = {.lex_state = 0},
  [2280] = {.lex_state = 0},
  [2281] = {.lex_state = 0},
  [2282] = {.lex_state = 0},
  [2283] = {.lex_state = 69},
  [2284] = {.lex_state = 0},
  [2285] = {.lex_state = 68},
  [2286] = {.lex_state = 0},
  [2287] = {.lex_state = 0},
  [2288] = {.lex_state = 68},
  [2289] = {.lex_state = 68},
  [2290] = {.lex_state = 69},
  [2291] = {.lex_state = 69},
  [2292] = {.lex_state = 0},
  [2293] = {.lex_state = 0},
  [2294] = {.lex_state = 0},
  [2295] = {.lex_state = 0},
  [2296] = {.lex_state = 69},
  [2297] = {.lex_state = 0},
  [2298] = {.lex_state = 69},
  [2299] = {.lex_state = 0},
  [2300] = {.lex_state = 69},
  [2301] = {.lex_state = 0},
  [2302] = {.lex_state = 68},
  [2303] = {.lex_state = 0},
  [2304] = {.lex_state = 69},
  [2305] = {.lex_state = 0},
  [2306] = {.lex_state = 69},
  [2307] = {.lex_state = 69},
  [2308] = {.lex_state = 0},
  [2309] = {.lex_state = 0},
  [2310] = {.lex_state = 0},
  [2311] = {.lex_state = 0},
  [2312] = {.lex_state = 0},
  [2313] = {.lex_state = 69},
  [2314] = {.lex_state = 0},
  [2315] = {.lex_state = 69},
  [2316] = {.lex_state = 0},
  [2317] = {.lex_state = 69},
  [2318] = {.lex_state = 0},
  [2319] = {.lex_state = 69},
  [2320] = {.lex_state = 69},
  [2321] = {.lex_state = 0},
  [2322] = {.lex_state = 69},
  [2323] = {.lex_state = 69},
  [2324] = {.lex_state = 0},
  [2325] = {.lex_state = 0},
  [2326] = {.lex_state = 0},
  [2327] = {.lex_state = 69},
  [2328] = {.lex_state = 0},
  [2329] = {.lex_state = 68},
  [2330] = {.lex_state = 0},
  [2331] = {.lex_state = 0},
  [2332] = {.lex_state = 69},
  [2333] = {.lex_state = 0},
  [2334] = {.lex_state = 69},
  [2335] = {.lex_state = 69},
  [2336] = {.lex_state = 69},
  [2337] = {.lex_state = 69},
  [2338] = {.lex_state = 69},
  [2339] = {.lex_state = 0},
  [2340] = {.lex_state = 69},
  [2341] = {.lex_state = 69},
  [2342] = {.lex_state = 69},
  [2343] = {.lex_state = 0},
  [2344] = {.lex_state = 0},
  [2345] = {.lex_state = 0},
  [2346] = {.lex_state = 0},
  [2347] = {.lex_state = 68},
  [2348] = {.lex_state = 0},
  [2349] = {.lex_state = 0},
  [2350] = {.lex_state = 0},
  [2351] = {.lex_state = 0},
  [2352] = {.lex_state = 0},
  [2353] = {.lex_state = 0},
  [2354] = {.lex_state = 0},
  [2355] = {.lex_state = 0},
  [2356] = {.lex_state = 0},
  [2357] = {.lex_state = 69},
  [2358] = {.lex_state = 0},
  [2359] = {.lex_state = 0},
  [2360] = {.lex_state = 0},
  [2361] = {.lex_state = 0},
  [2362] = {.lex_state = 69},
  [2363] = {.lex_state = 69},
  [2364] = {.lex_state = 69},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars_double = 1,
  ts_external_token__template_chars_single = 2,
  ts_external_token__template_chars_double_single = 3,
  ts_external_token__template_chars_single_single = 4,
  ts_external_token__template_chars_raw_slash = 5,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars_double] = sym__template_chars_double,
  [ts_external_token__template_chars_single] = sym__template_chars_single,
  [ts_external_token__template_chars_double_single] = sym__template_chars_double_single,
  [ts_external_token__template_chars_single_single] = sym__template_chars_single_single,
  [ts_external_token__template_chars_raw_slash] = sym__template_chars_raw_slash,
};

static const bool ts_external_scanner_states[11][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars_double] = true,
    [ts_external_token__template_chars_single] = true,
    [ts_external_token__template_chars_double_single] = true,
    [ts_external_token__template_chars_single_single] = true,
    [ts_external_token__template_chars_raw_slash] = true,
  },
  [2] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [3] = {
    [ts_external_token__template_chars_single] = true,
  },
  [4] = {
    [ts_external_token__template_chars_double] = true,
  },
  [5] = {
    [ts_external_token__template_chars_single_single] = true,
  },
  [6] = {
    [ts_external_token__template_chars_double] = true,
    [ts_external_token__template_chars_raw_slash] = true,
  },
  [7] = {
    [ts_external_token__template_chars_single] = true,
    [ts_external_token__template_chars_raw_slash] = true,
  },
  [8] = {
    [ts_external_token__template_chars_double_single] = true,
  },
  [9] = {
    [ts_external_token__template_chars_single_single] = true,
    [ts_external_token__template_chars_raw_slash] = true,
  },
  [10] = {
    [ts_external_token__template_chars_double_single] = true,
    [ts_external_token__template_chars_raw_slash] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [sym_hex_integer_literal] = ACTIONS(1),
    [sym_decimal_floating_point_literal] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_r_DQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_r_SQUOTE] = ACTIONS(1),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym__unused_escape_sequence] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_null] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [sym_equality_operator] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [sym__additive_operator] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_TILDE_SLASH] = ACTIONS(1),
    [sym_increment_operator] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [sym_minus_operator] = ACTIONS(1),
    [sym__exclamation_operator] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_on] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_transitive] = ACTIONS(1),
    [anon_sym_part] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_show] = ACTIONS(1),
    [anon_sym_hide] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extension] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_super] = ACTIONS(1),
    [sym_floating_point_type] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [sym_void_type] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_async_STAR] = ACTIONS(1),
    [anon_sym_sync_STAR] = ACTIONS(1),
    [anon_sym_required] = ACTIONS(1),
    [anon_sym_throws] = ACTIONS(1),
    [anon_sym_POUND_BANG] = ACTIONS(1),
    [anon_sym_library] = ACTIONS(1),
    [sym__break_builtin] = ACTIONS(1),
    [sym__assert_builtin] = ACTIONS(1),
    [sym_case_builtin] = ACTIONS(1),
    [anon_sym_covariant] = ACTIONS(1),
    [anon_sym_deferred] = ACTIONS(1),
    [anon_sym_dynamic] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_factory] = ACTIONS(1),
    [anon_sym_Function] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_operator] = ACTIONS(1),
    [anon_sym_mixin] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_typedef] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [sym_const_builtin] = ACTIONS(1),
    [sym_final_builtin] = ACTIONS(1),
    [anon_sym_late] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_this] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars_double] = ACTIONS(1),
    [sym__template_chars_single] = ACTIONS(1),
    [sym__template_chars_double_single] = ACTIONS(1),
    [sym__template_chars_single_single] = ACTIONS(1),
    [sym__template_chars_raw_slash] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(2248),
    [sym__top_level_definition] = STATE(19),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(43),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_import_or_export] = STATE(6),
    [sym_library_import] = STATE(360),
    [sym_library_export] = STATE(360),
    [sym_import_specification] = STATE(356),
    [sym_part_directive] = STATE(10),
    [sym_part_of_directive] = STATE(13),
    [sym_enum_declaration] = STATE(19),
    [sym_type_alias] = STATE(19),
    [sym_class_definition] = STATE(19),
    [sym_extension_declaration] = STATE(19),
    [sym__metadata] = STATE(424),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(19),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym_script_tag] = STATE(2),
    [sym_library_name] = STATE(5),
    [sym__covariant] = STATE(1283),
    [sym__export] = STATE(1226),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__import] = STATE(1233),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_program_repeat2] = STATE(10),
    [aux_sym_program_repeat3] = STATE(13),
    [aux_sym_program_repeat4] = STATE(19),
    [aux_sym_program_repeat5] = STATE(43),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(9),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(77),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_POUND_BANG] = ACTIONS(93),
    [anon_sym_library] = ACTIONS(95),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_export] = ACTIONS(103),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_import] = ACTIONS(109),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__top_level_definition] = STATE(22),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(42),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_import_or_export] = STATE(7),
    [sym_library_import] = STATE(360),
    [sym_library_export] = STATE(360),
    [sym_import_specification] = STATE(356),
    [sym_part_directive] = STATE(9),
    [sym_part_of_directive] = STATE(14),
    [sym_enum_declaration] = STATE(22),
    [sym_type_alias] = STATE(22),
    [sym_class_definition] = STATE(22),
    [sym_extension_declaration] = STATE(22),
    [sym__metadata] = STATE(424),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(22),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym_library_name] = STATE(3),
    [sym__covariant] = STATE(1283),
    [sym__export] = STATE(1226),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__import] = STATE(1233),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_program_repeat2] = STATE(9),
    [aux_sym_program_repeat3] = STATE(14),
    [aux_sym_program_repeat4] = STATE(22),
    [aux_sym_program_repeat5] = STATE(42),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(129),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(77),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_library] = ACTIONS(95),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_export] = ACTIONS(103),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_import] = ACTIONS(109),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__top_level_definition] = STATE(18),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(37),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_import_or_export] = STATE(4),
    [sym_library_import] = STATE(360),
    [sym_library_export] = STATE(360),
    [sym_import_specification] = STATE(356),
    [sym_part_directive] = STATE(8),
    [sym_part_of_directive] = STATE(12),
    [sym_enum_declaration] = STATE(18),
    [sym_type_alias] = STATE(18),
    [sym_class_definition] = STATE(18),
    [sym_extension_declaration] = STATE(18),
    [sym__metadata] = STATE(456),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(18),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__export] = STATE(1226),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__import] = STATE(1233),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_program_repeat2] = STATE(8),
    [aux_sym_program_repeat3] = STATE(12),
    [aux_sym_program_repeat4] = STATE(18),
    [aux_sym_program_repeat5] = STATE(37),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(133),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(77),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_export] = ACTIONS(103),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_import] = ACTIONS(109),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__top_level_definition] = STATE(17),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(45),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_import_or_export] = STATE(318),
    [sym_library_import] = STATE(360),
    [sym_library_export] = STATE(360),
    [sym_import_specification] = STATE(356),
    [sym_part_directive] = STATE(11),
    [sym_part_of_directive] = STATE(16),
    [sym_enum_declaration] = STATE(17),
    [sym_type_alias] = STATE(17),
    [sym_class_definition] = STATE(17),
    [sym_extension_declaration] = STATE(17),
    [sym__metadata] = STATE(456),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(17),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__export] = STATE(1226),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__import] = STATE(1233),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat1] = STATE(318),
    [aux_sym_program_repeat2] = STATE(11),
    [aux_sym_program_repeat3] = STATE(16),
    [aux_sym_program_repeat4] = STATE(17),
    [aux_sym_program_repeat5] = STATE(45),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(135),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(77),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_export] = ACTIONS(103),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_import] = ACTIONS(109),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__top_level_definition] = STATE(22),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(42),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_import_or_export] = STATE(7),
    [sym_library_import] = STATE(360),
    [sym_library_export] = STATE(360),
    [sym_import_specification] = STATE(356),
    [sym_part_directive] = STATE(9),
    [sym_part_of_directive] = STATE(14),
    [sym_enum_declaration] = STATE(22),
    [sym_type_alias] = STATE(22),
    [sym_class_definition] = STATE(22),
    [sym_extension_declaration] = STATE(22),
    [sym__metadata] = STATE(456),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(22),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__export] = STATE(1226),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__import] = STATE(1233),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_program_repeat2] = STATE(9),
    [aux_sym_program_repeat3] = STATE(14),
    [aux_sym_program_repeat4] = STATE(22),
    [aux_sym_program_repeat5] = STATE(42),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(129),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(77),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_export] = ACTIONS(103),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_import] = ACTIONS(109),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__top_level_definition] = STATE(22),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(42),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_import_or_export] = STATE(318),
    [sym_library_import] = STATE(360),
    [sym_library_export] = STATE(360),
    [sym_import_specification] = STATE(356),
    [sym_part_directive] = STATE(9),
    [sym_part_of_directive] = STATE(14),
    [sym_enum_declaration] = STATE(22),
    [sym_type_alias] = STATE(22),
    [sym_class_definition] = STATE(22),
    [sym_extension_declaration] = STATE(22),
    [sym__metadata] = STATE(456),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(22),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__export] = STATE(1226),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__import] = STATE(1233),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat1] = STATE(318),
    [aux_sym_program_repeat2] = STATE(9),
    [aux_sym_program_repeat3] = STATE(14),
    [aux_sym_program_repeat4] = STATE(22),
    [aux_sym_program_repeat5] = STATE(42),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(129),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(77),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_export] = ACTIONS(103),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_import] = ACTIONS(109),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__top_level_definition] = STATE(18),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(37),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_import_or_export] = STATE(318),
    [sym_library_import] = STATE(360),
    [sym_library_export] = STATE(360),
    [sym_import_specification] = STATE(356),
    [sym_part_directive] = STATE(8),
    [sym_part_of_directive] = STATE(12),
    [sym_enum_declaration] = STATE(18),
    [sym_type_alias] = STATE(18),
    [sym_class_definition] = STATE(18),
    [sym_extension_declaration] = STATE(18),
    [sym__metadata] = STATE(456),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(18),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__export] = STATE(1226),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__import] = STATE(1233),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat1] = STATE(318),
    [aux_sym_program_repeat2] = STATE(8),
    [aux_sym_program_repeat3] = STATE(12),
    [aux_sym_program_repeat4] = STATE(18),
    [aux_sym_program_repeat5] = STATE(37),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(133),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(77),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_export] = ACTIONS(103),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_import] = ACTIONS(109),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__top_level_definition] = STATE(17),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(45),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_part_directive] = STATE(345),
    [sym_part_of_directive] = STATE(16),
    [sym_enum_declaration] = STATE(17),
    [sym_type_alias] = STATE(17),
    [sym_class_definition] = STATE(17),
    [sym_extension_declaration] = STATE(17),
    [sym__metadata] = STATE(498),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(17),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat2] = STATE(345),
    [aux_sym_program_repeat3] = STATE(16),
    [aux_sym_program_repeat4] = STATE(17),
    [aux_sym_program_repeat5] = STATE(45),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(135),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(77),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__top_level_definition] = STATE(18),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(37),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_part_directive] = STATE(345),
    [sym_part_of_directive] = STATE(12),
    [sym_enum_declaration] = STATE(18),
    [sym_type_alias] = STATE(18),
    [sym_class_definition] = STATE(18),
    [sym_extension_declaration] = STATE(18),
    [sym__metadata] = STATE(498),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(18),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat2] = STATE(345),
    [aux_sym_program_repeat3] = STATE(12),
    [aux_sym_program_repeat4] = STATE(18),
    [aux_sym_program_repeat5] = STATE(37),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(133),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(77),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__top_level_definition] = STATE(22),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(42),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_part_directive] = STATE(345),
    [sym_part_of_directive] = STATE(14),
    [sym_enum_declaration] = STATE(22),
    [sym_type_alias] = STATE(22),
    [sym_class_definition] = STATE(22),
    [sym_extension_declaration] = STATE(22),
    [sym__metadata] = STATE(498),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(22),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat2] = STATE(345),
    [aux_sym_program_repeat3] = STATE(14),
    [aux_sym_program_repeat4] = STATE(22),
    [aux_sym_program_repeat5] = STATE(42),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(129),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(77),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__top_level_definition] = STATE(21),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(44),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_part_directive] = STATE(345),
    [sym_part_of_directive] = STATE(15),
    [sym_enum_declaration] = STATE(21),
    [sym_type_alias] = STATE(21),
    [sym_class_definition] = STATE(21),
    [sym_extension_declaration] = STATE(21),
    [sym__metadata] = STATE(498),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(21),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat2] = STATE(345),
    [aux_sym_program_repeat3] = STATE(15),
    [aux_sym_program_repeat4] = STATE(21),
    [aux_sym_program_repeat5] = STATE(44),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(77),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__top_level_definition] = STATE(17),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(45),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_part_of_directive] = STATE(344),
    [sym_enum_declaration] = STATE(17),
    [sym_type_alias] = STATE(17),
    [sym_class_definition] = STATE(17),
    [sym_extension_declaration] = STATE(17),
    [sym__metadata] = STATE(499),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(17),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat3] = STATE(344),
    [aux_sym_program_repeat4] = STATE(17),
    [aux_sym_program_repeat5] = STATE(45),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(135),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(139),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__top_level_definition] = STATE(22),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(42),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_part_of_directive] = STATE(344),
    [sym_enum_declaration] = STATE(22),
    [sym_type_alias] = STATE(22),
    [sym_class_definition] = STATE(22),
    [sym_extension_declaration] = STATE(22),
    [sym__metadata] = STATE(499),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(22),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat3] = STATE(344),
    [aux_sym_program_repeat4] = STATE(22),
    [aux_sym_program_repeat5] = STATE(42),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(129),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(139),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__top_level_definition] = STATE(18),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(37),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_part_of_directive] = STATE(344),
    [sym_enum_declaration] = STATE(18),
    [sym_type_alias] = STATE(18),
    [sym_class_definition] = STATE(18),
    [sym_extension_declaration] = STATE(18),
    [sym__metadata] = STATE(499),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(18),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat3] = STATE(344),
    [aux_sym_program_repeat4] = STATE(18),
    [aux_sym_program_repeat5] = STATE(37),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(133),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(139),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__top_level_definition] = STATE(20),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(35),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_part_of_directive] = STATE(344),
    [sym_enum_declaration] = STATE(20),
    [sym_type_alias] = STATE(20),
    [sym_class_definition] = STATE(20),
    [sym_extension_declaration] = STATE(20),
    [sym__metadata] = STATE(499),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(20),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat3] = STATE(344),
    [aux_sym_program_repeat4] = STATE(20),
    [aux_sym_program_repeat5] = STATE(35),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(141),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(139),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__top_level_definition] = STATE(21),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(44),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_part_of_directive] = STATE(344),
    [sym_enum_declaration] = STATE(21),
    [sym_type_alias] = STATE(21),
    [sym_class_definition] = STATE(21),
    [sym_extension_declaration] = STATE(21),
    [sym__metadata] = STATE(499),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(21),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat3] = STATE(344),
    [aux_sym_program_repeat4] = STATE(21),
    [aux_sym_program_repeat5] = STATE(44),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_part] = ACTIONS(139),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__top_level_definition] = STATE(204),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(44),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_enum_declaration] = STATE(204),
    [sym_type_alias] = STATE(204),
    [sym_class_definition] = STATE(204),
    [sym_extension_declaration] = STATE(204),
    [sym__metadata] = STATE(500),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(204),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat4] = STATE(204),
    [aux_sym_program_repeat5] = STATE(44),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__top_level_definition] = STATE(204),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(45),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_enum_declaration] = STATE(204),
    [sym_type_alias] = STATE(204),
    [sym_class_definition] = STATE(204),
    [sym_extension_declaration] = STATE(204),
    [sym__metadata] = STATE(500),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(204),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat4] = STATE(204),
    [aux_sym_program_repeat5] = STATE(45),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(135),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__top_level_definition] = STATE(204),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(42),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_enum_declaration] = STATE(204),
    [sym_type_alias] = STATE(204),
    [sym_class_definition] = STATE(204),
    [sym_extension_declaration] = STATE(204),
    [sym__metadata] = STATE(500),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(204),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat4] = STATE(204),
    [aux_sym_program_repeat5] = STATE(42),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(129),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__top_level_definition] = STATE(204),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(51),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_enum_declaration] = STATE(204),
    [sym_type_alias] = STATE(204),
    [sym_class_definition] = STATE(204),
    [sym_extension_declaration] = STATE(204),
    [sym__metadata] = STATE(500),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(204),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat4] = STATE(204),
    [aux_sym_program_repeat5] = STATE(51),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(143),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__top_level_definition] = STATE(204),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(35),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_enum_declaration] = STATE(204),
    [sym_type_alias] = STATE(204),
    [sym_class_definition] = STATE(204),
    [sym_extension_declaration] = STATE(204),
    [sym__metadata] = STATE(500),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(204),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat4] = STATE(204),
    [aux_sym_program_repeat5] = STATE(35),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(141),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__top_level_definition] = STATE(204),
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(37),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym_enum_declaration] = STATE(204),
    [sym_type_alias] = STATE(204),
    [sym_class_definition] = STATE(204),
    [sym_extension_declaration] = STATE(204),
    [sym__metadata] = STATE(500),
    [sym_type_parameters] = STATE(1971),
    [sym_mixin_declaration] = STATE(204),
    [sym_getter_signature] = STATE(1455),
    [sym_setter_signature] = STATE(1455),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1597),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1921),
    [sym_function_signature] = STATE(1438),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1560),
    [sym__mixin] = STATE(2169),
    [sym__set] = STATE(1568),
    [sym__typedef] = STATE(1381),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1324),
    [sym__external_builtin] = STATE(1291),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat4] = STATE(204),
    [aux_sym_program_repeat5] = STATE(37),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(133),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_enum] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(81),
    [anon_sym_class] = ACTIONS(83),
    [anon_sym_extension] = ACTIONS(85),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_mixin] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_typedef] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(119),
    [sym_final_builtin] = ACTIONS(121),
    [anon_sym_late] = ACTIONS(123),
    [anon_sym_external] = ACTIONS(125),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1915),
    [sym__element] = STATE(1915),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1637),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1637),
    [sym_assignment_expression] = STATE(1637),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1915),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(47),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_element] = STATE(1915),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym_for_element] = STATE(1915),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(47),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_RBRACE] = ACTIONS(147),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(151),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1915),
    [sym__element] = STATE(1915),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1637),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1637),
    [sym_assignment_expression] = STATE(1637),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1915),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(47),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_element] = STATE(1915),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym_for_element] = STATE(1915),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(47),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_RBRACE] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(151),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1915),
    [sym__element] = STATE(1915),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1637),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1637),
    [sym_assignment_expression] = STATE(1637),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1915),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(47),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_element] = STATE(1915),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym_for_element] = STATE(1915),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(47),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_RBRACE] = ACTIONS(167),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(151),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1915),
    [sym__element] = STATE(1915),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1637),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1637),
    [sym_assignment_expression] = STATE(1637),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1915),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(47),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_element] = STATE(1915),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym_for_element] = STATE(1915),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(47),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_RBRACE] = ACTIONS(169),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(151),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1741),
    [sym__element] = STATE(1741),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1637),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1637),
    [sym_assignment_expression] = STATE(1637),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1741),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(448),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_element] = STATE(1741),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym_for_element] = STATE(1741),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(173),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1741),
    [sym__element] = STATE(1741),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1637),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1637),
    [sym_assignment_expression] = STATE(1637),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1741),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(448),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_element] = STATE(1741),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym_for_element] = STATE(1741),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(151),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1774),
    [sym__element] = STATE(1774),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1637),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1637),
    [sym_assignment_expression] = STATE(1637),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1774),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(450),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_element] = STATE(1774),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym_for_element] = STATE(1774),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(173),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1775),
    [sym__element] = STATE(1775),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1637),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1637),
    [sym_assignment_expression] = STATE(1637),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1775),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(457),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_element] = STATE(1775),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym_for_element] = STATE(1775),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(173),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1774),
    [sym__element] = STATE(1774),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1637),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1637),
    [sym_assignment_expression] = STATE(1637),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1774),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(450),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_element] = STATE(1774),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym_for_element] = STATE(1774),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(151),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(33),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_switch_label] = STATE(33),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym_switch_block_repeat1] = STATE(33),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_RBRACE] = ACTIONS(181),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_default] = ACTIONS(185),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [sym_case_builtin] = ACTIONS(191),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(33),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_switch_label] = STATE(33),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym_switch_block_repeat1] = STATE(33),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(193),
    [anon_sym_POUND] = ACTIONS(196),
    [sym_decimal_integer_literal] = ACTIONS(199),
    [sym_hex_integer_literal] = ACTIONS(202),
    [sym_decimal_floating_point_literal] = ACTIONS(199),
    [anon_sym_true] = ACTIONS(205),
    [anon_sym_false] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(214),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(217),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(220),
    [anon_sym_r_DQUOTE] = ACTIONS(223),
    [anon_sym_r_SQUOTE] = ACTIONS(226),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(229),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(232),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_RBRACE] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_null] = ACTIONS(243),
    [anon_sym_throw] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(252),
    [sym_increment_operator] = ACTIONS(255),
    [sym_minus_operator] = ACTIONS(258),
    [sym__exclamation_operator] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(264),
    [anon_sym_await] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(270),
    [anon_sym_default] = ACTIONS(273),
    [anon_sym_do] = ACTIONS(276),
    [anon_sym_while] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(282),
    [anon_sym_yield] = ACTIONS(285),
    [anon_sym_return] = ACTIONS(288),
    [anon_sym_try] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(294),
    [anon_sym_for] = ACTIONS(297),
    [anon_sym_AT] = ACTIONS(300),
    [anon_sym_super] = ACTIONS(303),
    [sym_void_type] = ACTIONS(306),
    [anon_sym_var] = ACTIONS(309),
    [sym__break_builtin] = ACTIONS(312),
    [sym__assert_builtin] = ACTIONS(315),
    [sym_case_builtin] = ACTIONS(318),
    [anon_sym_covariant] = ACTIONS(321),
    [anon_sym_Function] = ACTIONS(324),
    [anon_sym_get] = ACTIONS(327),
    [anon_sym_set] = ACTIONS(330),
    [anon_sym_new] = ACTIONS(333),
    [sym_const_builtin] = ACTIONS(336),
    [sym_final_builtin] = ACTIONS(339),
    [anon_sym_late] = ACTIONS(342),
    [anon_sym_this] = ACTIONS(345),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(32),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_switch_label] = STATE(32),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym_switch_block_repeat1] = STATE(32),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_RBRACE] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_default] = ACTIONS(185),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [sym_case_builtin] = ACTIONS(191),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(41),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(41),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(143),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(46),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(46),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_RBRACE] = ACTIONS(350),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(41),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(41),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(135),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(39),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(39),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_RBRACE] = ACTIONS(352),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(52),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(52),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_RBRACE] = ACTIONS(354),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(50),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(50),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_RBRACE] = ACTIONS(356),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(41),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(41),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(358),
    [sym_identifier] = ACTIONS(360),
    [anon_sym_POUND] = ACTIONS(363),
    [sym_decimal_integer_literal] = ACTIONS(366),
    [sym_hex_integer_literal] = ACTIONS(369),
    [sym_decimal_floating_point_literal] = ACTIONS(366),
    [anon_sym_true] = ACTIONS(372),
    [anon_sym_false] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(378),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(384),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(387),
    [anon_sym_r_DQUOTE] = ACTIONS(390),
    [anon_sym_r_SQUOTE] = ACTIONS(393),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(396),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(399),
    [anon_sym_LBRACE] = ACTIONS(402),
    [anon_sym_LBRACK] = ACTIONS(405),
    [anon_sym_null] = ACTIONS(408),
    [anon_sym_throw] = ACTIONS(411),
    [anon_sym_LPAREN] = ACTIONS(414),
    [anon_sym_LT] = ACTIONS(417),
    [sym_increment_operator] = ACTIONS(420),
    [sym_minus_operator] = ACTIONS(423),
    [sym__exclamation_operator] = ACTIONS(426),
    [anon_sym_TILDE] = ACTIONS(429),
    [anon_sym_await] = ACTIONS(432),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(438),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_continue] = ACTIONS(444),
    [anon_sym_yield] = ACTIONS(447),
    [anon_sym_return] = ACTIONS(450),
    [anon_sym_try] = ACTIONS(453),
    [anon_sym_if] = ACTIONS(456),
    [anon_sym_for] = ACTIONS(459),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_super] = ACTIONS(465),
    [sym_void_type] = ACTIONS(468),
    [anon_sym_var] = ACTIONS(471),
    [sym__break_builtin] = ACTIONS(474),
    [sym__assert_builtin] = ACTIONS(477),
    [anon_sym_covariant] = ACTIONS(480),
    [anon_sym_Function] = ACTIONS(483),
    [anon_sym_get] = ACTIONS(486),
    [anon_sym_set] = ACTIONS(489),
    [anon_sym_new] = ACTIONS(492),
    [sym_const_builtin] = ACTIONS(495),
    [sym_final_builtin] = ACTIONS(498),
    [anon_sym_late] = ACTIONS(501),
    [anon_sym_this] = ACTIONS(504),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(41),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(41),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(133),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(41),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(41),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(129),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(41),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(41),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(141),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(41),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(41),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [46] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(52),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(52),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_RBRACE] = ACTIONS(507),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [47] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(52),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(52),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_RBRACE] = ACTIONS(509),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [48] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(47),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(47),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_RBRACE] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [49] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(47),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(47),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_RBRACE] = ACTIONS(350),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [50] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(52),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(52),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_RBRACE] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(41),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(41),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [ts_builtin_sym_end] = ACTIONS(515),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(52),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_program_repeat5] = STATE(52),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(517),
    [anon_sym_POUND] = ACTIONS(363),
    [sym_decimal_integer_literal] = ACTIONS(366),
    [sym_hex_integer_literal] = ACTIONS(369),
    [sym_decimal_floating_point_literal] = ACTIONS(366),
    [anon_sym_true] = ACTIONS(372),
    [anon_sym_false] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(378),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(384),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(387),
    [anon_sym_r_DQUOTE] = ACTIONS(390),
    [anon_sym_r_SQUOTE] = ACTIONS(393),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(396),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(399),
    [anon_sym_LBRACE] = ACTIONS(520),
    [anon_sym_RBRACE] = ACTIONS(358),
    [anon_sym_LBRACK] = ACTIONS(405),
    [anon_sym_null] = ACTIONS(408),
    [anon_sym_throw] = ACTIONS(411),
    [anon_sym_LPAREN] = ACTIONS(414),
    [anon_sym_LT] = ACTIONS(417),
    [sym_increment_operator] = ACTIONS(420),
    [sym_minus_operator] = ACTIONS(423),
    [sym__exclamation_operator] = ACTIONS(426),
    [anon_sym_TILDE] = ACTIONS(429),
    [anon_sym_await] = ACTIONS(523),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(438),
    [anon_sym_while] = ACTIONS(526),
    [anon_sym_continue] = ACTIONS(444),
    [anon_sym_yield] = ACTIONS(447),
    [anon_sym_return] = ACTIONS(450),
    [anon_sym_try] = ACTIONS(453),
    [anon_sym_if] = ACTIONS(529),
    [anon_sym_for] = ACTIONS(532),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_super] = ACTIONS(465),
    [sym_void_type] = ACTIONS(468),
    [anon_sym_var] = ACTIONS(471),
    [sym__break_builtin] = ACTIONS(474),
    [sym__assert_builtin] = ACTIONS(477),
    [anon_sym_covariant] = ACTIONS(480),
    [anon_sym_Function] = ACTIONS(483),
    [anon_sym_get] = ACTIONS(486),
    [anon_sym_set] = ACTIONS(489),
    [anon_sym_new] = ACTIONS(492),
    [sym_const_builtin] = ACTIONS(495),
    [sym_final_builtin] = ACTIONS(498),
    [anon_sym_late] = ACTIONS(501),
    [anon_sym_this] = ACTIONS(504),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [53] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(1978),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1603),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1598),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(535),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(539),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(545),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(436),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1603),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1598),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(535),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(539),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(545),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(445),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(436),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [57] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(448),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1603),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1598),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(535),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(539),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(545),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(450),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1603),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1598),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(535),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(539),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(545),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(2209),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1603),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1598),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(535),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(539),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(545),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(436),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(450),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(462),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(449),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(450),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(448),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(448),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(55),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(449),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1603),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1598),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(535),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(539),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(545),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(445),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(457),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(449),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1548),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1582),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [71] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2112),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2112),
    [sym_assignment_expression] = STATE(2112),
    [sym_assignable_expression] = STATE(1273),
    [sym_lambda_expression] = STATE(440),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__statement] = STATE(445),
    [sym_block] = STATE(440),
    [sym_expression_statement] = STATE(440),
    [sym_labeled_statement] = STATE(440),
    [sym_assert_statement] = STATE(440),
    [sym_assertion] = STATE(2216),
    [sym_switch_statement] = STATE(440),
    [sym_do_statement] = STATE(440),
    [sym_break_statement] = STATE(440),
    [sym_continue_statement] = STATE(440),
    [sym_yield_statement] = STATE(440),
    [sym_yield_each_statement] = STATE(440),
    [sym_return_statement] = STATE(440),
    [sym_try_statement] = STATE(440),
    [sym__try_head] = STATE(1603),
    [sym_if_statement] = STATE(440),
    [sym_while_statement] = STATE(440),
    [sym_for_statement] = STATE(440),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1736),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(1719),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym_function_signature] = STATE(1598),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(440),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__get] = STATE(1616),
    [sym__set] = STATE(1616),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(535),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(539),
    [anon_sym_switch] = ACTIONS(57),
    [anon_sym_do] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(67),
    [anon_sym_try] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(545),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [sym__break_builtin] = ACTIONS(97),
    [sym__assert_builtin] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [72] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1915),
    [sym__element] = STATE(1915),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1915),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1915),
    [sym_for_element] = STATE(1915),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(968),
    [sym_type_parameters] = STATE(1971),
    [sym__declared_identifier] = STATE(1610),
    [sym__final_const_var_or_type] = STATE(1957),
    [sym__type] = STATE(2003),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1957),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_formal_parameter] = STATE(1773),
    [sym__default_named_parameter] = STATE(1939),
    [sym__normal_formal_parameter] = STATE(1634),
    [sym__function_formal_parameter] = STATE(1634),
    [sym__simple_formal_parameter] = STATE(1635),
    [sym_constructor_param] = STATE(1634),
    [sym__covariant] = STATE(1277),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(954),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(547),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_required] = ACTIONS(559),
    [anon_sym_covariant] = ACTIONS(561),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [73] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1936),
    [sym__element] = STATE(1936),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1936),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1936),
    [sym_for_element] = STATE(1936),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(968),
    [sym_type_parameters] = STATE(1971),
    [sym__declared_identifier] = STATE(1610),
    [sym__final_const_var_or_type] = STATE(1957),
    [sym__type] = STATE(2003),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1957),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_formal_parameter] = STATE(1940),
    [sym__default_formal_parameter] = STATE(1941),
    [sym__normal_formal_parameter] = STATE(1634),
    [sym__function_formal_parameter] = STATE(1634),
    [sym__simple_formal_parameter] = STATE(1635),
    [sym_constructor_param] = STATE(1634),
    [sym__covariant] = STATE(1277),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(954),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(563),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(565),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(561),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [74] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2196),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2196),
    [sym_assignment_expression] = STATE(2196),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(968),
    [sym_type_parameters] = STATE(1971),
    [sym__declared_identifier] = STATE(1610),
    [sym__final_const_var_or_type] = STATE(1957),
    [sym__type] = STATE(2003),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1957),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__normal_formal_parameters] = STATE(1987),
    [sym_optional_formal_parameters] = STATE(2198),
    [sym__optional_postional_formal_parameters] = STATE(2199),
    [sym__named_formal_parameters] = STATE(2199),
    [sym_formal_parameter] = STATE(1855),
    [sym__normal_formal_parameter] = STATE(1634),
    [sym__function_formal_parameter] = STATE(1634),
    [sym__simple_formal_parameter] = STATE(1635),
    [sym_constructor_param] = STATE(1634),
    [sym__covariant] = STATE(1277),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(954),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(567),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(569),
    [anon_sym_LBRACK] = ACTIONS(571),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_RPAREN] = ACTIONS(573),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(561),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [75] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2252),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2252),
    [sym_assignment_expression] = STATE(2252),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(968),
    [sym_type_parameters] = STATE(1971),
    [sym__declared_identifier] = STATE(1610),
    [sym__final_const_var_or_type] = STATE(1957),
    [sym__type] = STATE(2003),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1957),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__normal_formal_parameters] = STATE(1987),
    [sym_optional_formal_parameters] = STATE(2198),
    [sym__optional_postional_formal_parameters] = STATE(2199),
    [sym__named_formal_parameters] = STATE(2199),
    [sym_formal_parameter] = STATE(1855),
    [sym__normal_formal_parameter] = STATE(1634),
    [sym__function_formal_parameter] = STATE(1634),
    [sym__simple_formal_parameter] = STATE(1635),
    [sym_constructor_param] = STATE(1634),
    [sym__covariant] = STATE(1277),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(954),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(567),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(569),
    [anon_sym_LBRACK] = ACTIONS(571),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_RPAREN] = ACTIONS(573),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(561),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [76] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(2195),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(2195),
    [sym_assignment_expression] = STATE(2195),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(968),
    [sym_type_parameters] = STATE(1971),
    [sym__declared_identifier] = STATE(1610),
    [sym__final_const_var_or_type] = STATE(1957),
    [sym__type] = STATE(2003),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(1957),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__normal_formal_parameters] = STATE(1987),
    [sym_optional_formal_parameters] = STATE(2198),
    [sym__optional_postional_formal_parameters] = STATE(2199),
    [sym__named_formal_parameters] = STATE(2199),
    [sym_formal_parameter] = STATE(1855),
    [sym__normal_formal_parameter] = STATE(1634),
    [sym__function_formal_parameter] = STATE(1634),
    [sym__simple_formal_parameter] = STATE(1635),
    [sym_constructor_param] = STATE(1634),
    [sym__covariant] = STATE(1277),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(954),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(567),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(569),
    [anon_sym_LBRACK] = ACTIONS(571),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_RPAREN] = ACTIONS(573),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(561),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [77] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1743),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1743),
    [sym_assignment_expression] = STATE(1743),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__for_loop_parts] = STATE(2325),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1722),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(2193),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(144),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [sym__semicolon] = STATE(141),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [78] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1743),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1743),
    [sym_assignment_expression] = STATE(1743),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__for_loop_parts] = STATE(2328),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1722),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(2193),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(144),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [sym__semicolon] = STATE(141),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [79] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1743),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1743),
    [sym_assignment_expression] = STATE(1743),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__for_loop_parts] = STATE(2301),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1722),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(2193),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(144),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [sym__semicolon] = STATE(141),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [80] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1743),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1743),
    [sym_assignment_expression] = STATE(1743),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__for_loop_parts] = STATE(2299),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1722),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(2193),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(144),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [sym__semicolon] = STATE(141),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [81] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1743),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1743),
    [sym_assignment_expression] = STATE(1743),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__for_loop_parts] = STATE(2217),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1722),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(2193),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(144),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [sym__semicolon] = STATE(141),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [82] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1743),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1743),
    [sym_assignment_expression] = STATE(1743),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__for_loop_parts] = STATE(2276),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1722),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(2193),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(144),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [sym__semicolon] = STATE(141),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [83] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1743),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1743),
    [sym_assignment_expression] = STATE(1743),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__for_loop_parts] = STATE(2244),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1722),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(2193),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(144),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [sym__semicolon] = STATE(141),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [84] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1743),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1743),
    [sym_assignment_expression] = STATE(1743),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__for_loop_parts] = STATE(2316),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1722),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(2193),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(144),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [sym__semicolon] = STATE(141),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [85] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1743),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1743),
    [sym_assignment_expression] = STATE(1743),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__for_loop_parts] = STATE(2245),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1722),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(2193),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(144),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [sym__semicolon] = STATE(141),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [86] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1743),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1743),
    [sym_assignment_expression] = STATE(1743),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__for_loop_parts] = STATE(2249),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1722),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(2193),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(144),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [sym__semicolon] = STATE(141),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [87] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1743),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1743),
    [sym_assignment_expression] = STATE(1743),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__for_loop_parts] = STATE(2281),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1722),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(2193),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(144),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [sym__semicolon] = STATE(141),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [88] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1743),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1743),
    [sym_assignment_expression] = STATE(1743),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym__for_loop_parts] = STATE(2294),
    [sym__annotation] = STATE(987),
    [sym_marker_annotation] = STATE(987),
    [sym_annotation] = STATE(987),
    [sym__metadata] = STATE(1227),
    [sym_type_parameters] = STATE(1971),
    [sym_initialized_variable_definition] = STATE(2006),
    [sym__declared_identifier] = STATE(1722),
    [sym__final_const_var_or_type] = STATE(2193),
    [sym__type] = STATE(2193),
    [sym__type_not_function] = STATE(1330),
    [sym__type_not_void_not_function] = STATE(1330),
    [sym_function_type] = STATE(1349),
    [aux_sym__function_type_tails] = STATE(1228),
    [sym__function_type_tail] = STATE(1228),
    [sym__type_name] = STATE(1441),
    [sym_inferred_type] = STATE(2193),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym_local_variable_declaration] = STATE(144),
    [sym__covariant] = STATE(1283),
    [sym__function_builtin_identifier] = STATE(1188),
    [sym__new_builtin] = STATE(1378),
    [sym__late_builtin] = STATE(1325),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [sym__semicolon] = STATE(141),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [aux_sym__metadata_repeat1] = STATE(987),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_super] = ACTIONS(87),
    [sym_void_type] = ACTIONS(89),
    [anon_sym_var] = ACTIONS(91),
    [anon_sym_covariant] = ACTIONS(101),
    [anon_sym_Function] = ACTIONS(105),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(159),
    [sym_final_builtin] = ACTIONS(161),
    [anon_sym_late] = ACTIONS(163),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [89] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(583),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [90] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1936),
    [sym__element] = STATE(1936),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1936),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1936),
    [sym_for_element] = STATE(1936),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(565),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [91] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(587),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [92] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1869),
    [sym__element] = STATE(1869),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1869),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1869),
    [sym_for_element] = STATE(1869),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(589),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [93] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1870),
    [sym__element] = STATE(1870),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1870),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1870),
    [sym_for_element] = STATE(1870),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(591),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [94] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1906),
    [sym__element] = STATE(1906),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1906),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1906),
    [sym_for_element] = STATE(1906),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(593),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [95] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1915),
    [sym__element] = STATE(1915),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1915),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1915),
    [sym_for_element] = STATE(1915),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [96] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(595),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [97] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(597),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [98] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(599),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [99] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1898),
    [sym__element] = STATE(1898),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1898),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1898),
    [sym_for_element] = STATE(1898),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(597),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [100] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1975),
    [sym__element] = STATE(1975),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1975),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1975),
    [sym_for_element] = STATE(1975),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(587),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [101] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1899),
    [sym__element] = STATE(1899),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1899),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1899),
    [sym_for_element] = STATE(1899),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(599),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [102] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(601),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [103] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1905),
    [sym__element] = STATE(1905),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1905),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1905),
    [sym_for_element] = STATE(1905),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(603),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [104] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(605),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [105] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(607),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [106] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1852),
    [sym__element] = STATE(1852),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1852),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1852),
    [sym_for_element] = STATE(1852),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(609),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [107] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(611),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [108] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1856),
    [sym__element] = STATE(1856),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1856),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1856),
    [sym_for_element] = STATE(1856),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(613),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [109] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(615),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [110] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(617),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [111] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(619),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [112] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(621),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [113] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(623),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [114] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1808),
    [sym__element] = STATE(1808),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1808),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1808),
    [sym_for_element] = STATE(1808),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(625),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [115] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1828),
    [sym__element] = STATE(1828),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1828),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1828),
    [sym_for_element] = STATE(1828),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(627),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [116] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(629),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [117] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(631),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [118] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1956),
    [sym__element] = STATE(1956),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1956),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1956),
    [sym_for_element] = STATE(1956),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(633),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [119] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(635),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [120] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(637),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [121] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(627),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [122] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(639),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [123] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1811),
    [sym__element] = STATE(1811),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1811),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1811),
    [sym_for_element] = STATE(1811),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(641),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [124] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(643),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [125] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(645),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [126] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1860),
    [sym__element] = STATE(1860),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1860),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1860),
    [sym_for_element] = STATE(1860),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_RBRACK] = ACTIONS(583),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [127] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1958),
    [sym__element] = STATE(1958),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1958),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1958),
    [sym_for_element] = STATE(1958),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(647),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [128] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(649),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [129] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1892),
    [sym__element] = STATE(1892),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1892),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1892),
    [sym_for_element] = STATE(1892),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(651),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [130] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1868),
    [sym__element] = STATE(1868),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1868),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1868),
    [sym_for_element] = STATE(1868),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(649),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_operator] = ACTIONS(51),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(557),
    [anon_sym_super] = ACTIONS(87),
    [anon_sym_new] = ACTIONS(117),
    [sym_const_builtin] = ACTIONS(585),
    [anon_sym_this] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_documentation_comment] = ACTIONS(3),
  },
  [131] = {
    [sym__literal] = STATE(533),
    [sym_symbol_literal] = STATE(813),
    [sym_true] = STATE(813),
    [sym_false] = STATE(813),
    [sym_string_literal] = STATE(813),
    [sym__string_literal_double_quotes] = STATE(427),
    [sym__string_literal_single_quotes] = STATE(427),
    [sym__string_literal_double_quotes_multiple] = STATE(427),
    [sym__string_literal_single_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_double_quotes] = STATE(427),
    [sym__raw_string_literal_single_quotes] = STATE(427),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(427),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(427),
    [sym_list_literal] = STATE(813),
    [sym_set_or_map_literal] = STATE(813),
    [sym_pair] = STATE(1774),
    [sym__element] = STATE(1774),
    [sym_null_literal] = STATE(813),
    [sym__expression] = STATE(1733),
    [sym__real_expression] = STATE(558),
    [sym_throw_expression] = STATE(1733),
    [sym_assignment_expression] = STATE(1733),
    [sym_assignable_expression] = STATE(1273),
    [sym_function_expression] = STATE(533),
    [sym_if_null_expression] = STATE(558),
    [sym_conditional_expression] = STATE(558),
    [sym_logical_or_expression] = STATE(558),
    [sym_logical_and_expression] = STATE(558),
    [sym_equality_expression] = STATE(558),
    [sym_type_cast_expression] = STATE(558),
    [sym_type_test_expression] = STATE(558),
    [sym_relational_expression] = STATE(558),
    [sym_bitwise_or_expression] = STATE(558),
    [sym_bitwise_xor_expression] = STATE(558),
    [sym_bitwise_and_expression] = STATE(558),
    [sym_shift_expression] = STATE(558),
    [sym_additive_expression] = STATE(558),
    [sym_multiplicative_expression] = STATE(558),
    [sym__unary_expression] = STATE(958),
    [sym_unary_expression] = STATE(958),
    [sym__postfix_expression] = STATE(958),
    [sym_postfix_expression] = STATE(958),
    [sym_spread_element] = STATE(1774),
    [sym_prefix_operator] = STATE(341),
    [sym_negation_operator] = STATE(1024),
    [sym_tilde_operator] = STATE(1011),
    [sym_await_expression] = STATE(1002),
    [sym_new_expression] = STATE(533),
    [sym_const_object_expression] = STATE(533),
    [sym__primary] = STATE(533),
    [sym_constructor_invocation] = STATE(527),
    [sym_type_arguments] = STATE(2033),
    [sym_if_element] = STATE(1774),
    [sym_for_element] = STATE(1774),
    [sym_type_parameters] = STATE(1971),
    [sym__type_name] = STATE(2019),
    [sym__formal_parameter_part] = STATE(1552),
    [sym_formal_parameter_list] = STATE(1552),
    [sym__strict_formal_parameter_list] = STATE(1326),
    [sym__new_builtin] = STATE(1378),
    [sym_this] = STATE(533),
    [sym_super] = STATE(951),
    [aux_sym_string_literal_repeat1] = STATE(427),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_POUND] = ACTIONS(131),
    [sym_decimal_integer_literal] = ACTIONS(11),
    [sym_hex_integer_literal] = ACTIONS(13),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [anon_sym_true] = ACTIONS(15),
    [anon_sym_false] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_r_DQUOTE] = ACTIONS(27),
    [anon_sym_r_SQUOTE] = ACTIONS(29),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_null] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_LT] = ACTIONS(45),
    [sym_increment_operator] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [sym_minus_operator] = ACTIONS(49),
    [sym__exclamation_o