#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1429
#define LARGE_STATE_COUNT 94
#define SYMBOL_COUNT 154
#define ALIAS_COUNT 2
#define TOKEN_COUNT 87
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 21
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 62

enum {
  anon_sym_COMMA = 1,
  anon_sym_DOT = 2,
  anon_sym_LF = 3,
  anon_sym_SEMI = 4,
  anon_sym_DASH = 5,
  anon_sym_define = 6,
  anon_sym_LPAREN = 7,
  anon_sym_RPAREN = 8,
  anon_sym_spec = 9,
  anon_sym_callback = 10,
  anon_sym_COLON = 11,
  anon_sym_when = 12,
  anon_sym_if = 13,
  anon_sym_LT_LT = 14,
  anon_sym_GT_GT = 15,
  anon_sym_LBRACE = 16,
  anon_sym_RBRACE = 17,
  anon_sym_LBRACK = 18,
  anon_sym_RBRACK = 19,
  anon_sym_POUND = 20,
  anon_sym_PLUS = 21,
  anon_sym_not = 22,
  anon_sym_bnot = 23,
  anon_sym_catch = 24,
  anon_sym_SLASH = 25,
  anon_sym_STAR = 26,
  anon_sym_div = 27,
  anon_sym_rem = 28,
  anon_sym_band = 29,
  anon_sym_and = 30,
  anon_sym_bor = 31,
  anon_sym_bxor = 32,
  anon_sym_bsl = 33,
  anon_sym_bsr = 34,
  anon_sym_or = 35,
  anon_sym_xor = 36,
  anon_sym_PLUS_PLUS = 37,
  anon_sym_DASH_DASH = 38,
  anon_sym_EQ_EQ = 39,
  anon_sym_SLASH_EQ = 40,
  anon_sym_EQ_LT = 41,
  anon_sym_LT = 42,
  anon_sym_GT_EQ = 43,
  anon_sym_GT = 44,
  anon_sym_EQ_COLON_EQ = 45,
  anon_sym_EQ_SLASH_EQ = 46,
  anon_sym_andalso = 47,
  anon_sym_orelse = 48,
  anon_sym_EQ = 49,
  anon_sym_BANG = 50,
  anon_sym_QMARK_EQ = 51,
  anon_sym_DOT_DOT = 52,
  anon_sym_PIPE_PIPE = 53,
  anon_sym_COLON_COLON = 54,
  anon_sym_PIPE = 55,
  anon_sym_LT_DASH = 56,
  anon_sym_LT_EQ = 57,
  anon_sym_EQ_GT = 58,
  anon_sym_COLON_EQ = 59,
  anon_sym_DASH_GT = 60,
  anon_sym_fun = 61,
  anon_sym_end = 62,
  anon_sym_begin = 63,
  anon_sym_case = 64,
  anon_sym_of = 65,
  anon_sym_receive = 66,
  anon_sym_after = 67,
  anon_sym_try = 68,
  anon_sym_maybe = 69,
  anon_sym_else = 70,
  anon_sym_DOLLAR = 71,
  aux_sym_character_token1 = 72,
  aux_sym_integer_token1 = 73,
  aux_sym_integer_token2 = 74,
  sym_float = 75,
  sym_atom = 76,
  anon_sym_SQUOTE = 77,
  sym_variable = 78,
  anon_sym_QMARK = 79,
  anon_sym_QMARK2 = 80,
  anon_sym_DQUOTE = 81,
  sym_escape_sequence = 82,
  sym_quoted_content = 83,
  sym_tripledot = 84,
  aux_sym_comment_token1 = 85,
  aux_sym_comment_token2 = 86,
  sym_source = 87,
  sym__statement = 88,
  sym__terminator = 89,
  sym_function = 90,
  sym__macro_declaration = 91,
  sym__macro_arguments = 92,
  sym__semicolon_separated_expressions = 93,
  sym__spec = 94,
  sym_attribute = 95,
  sym__expression = 96,
  sym__parenthesized_expression = 97,
  sym_bitstring = 98,
  sym_tuple = 99,
  sym_list = 100,
  sym_map = 101,
  sym__map_body = 102,
  sym_record = 103,
  sym__record_body = 104,
  sym_unary_operator = 105,
  sym_binary_operator = 106,
  sym__literal = 107,
  sym_anonymous_function = 108,
  sym_stab_clause = 109,
  sym__named_stab_clause = 110,
  sym__anonymous_stab_clause = 111,
  sym_clause = 112,
  sym_guard = 113,
  sym_arguments = 114,
  sym__body = 115,
  sym_body = 116,
  sym__items = 117,
  sym_call = 118,
  sym__qualified_function = 119,
  sym__unqualified_function = 120,
  sym_function_capture = 121,
  sym_function_type = 122,
  sym_block = 123,
  sym_if = 124,
  sym__if_clause = 125,
  sym_case = 126,
  sym_receive = 127,
  sym_after = 128,
  sym__body_after = 129,
  sym_try = 130,
  sym_maybe = 131,
  sym_character = 132,
  sym__number = 133,
  sym_integer = 134,
  sym__identifier = 135,
  sym__atom = 136,
  sym_quoted_atom = 137,
  sym_macro = 138,
  sym__strings = 139,
  sym_string = 140,
  sym_comment = 141,
  aux_sym_source_repeat1 = 142,
  aux_sym_source_repeat2 = 143,
  aux_sym_function_repeat1 = 144,
  aux_sym__semicolon_separated_expressions_repeat1 = 145,
  aux_sym__spec_repeat1 = 146,
  aux_sym_anonymous_function_repeat1 = 147,
  aux_sym_guard_repeat1 = 148,
  aux_sym_if_repeat1 = 149,
  aux_sym_case_repeat1 = 150,
  aux_sym_quoted_atom_repeat1 = 151,
  aux_sym__strings_repeat1 = 152,
  aux_sym_string_repeat1 = 153,
  alias_sym_map_content = 154,
  alias_sym_record_content = 155,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_COMMA] = ",",
  [anon_sym_DOT] = ".",
  [anon_sym_LF] = "\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_DASH] = "-",
  [anon_sym_define] = "atom",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_spec] = "atom",
  [anon_sym_callback] = "atom",
  [anon_sym_COLON] = ":",
  [anon_sym_when] = "when",
  [anon_sym_if] = "if",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_POUND] = "#",
  [anon_sym_PLUS] = "+",
  [anon_sym_not] = "not",
  [anon_sym_bnot] = "bnot",
  [anon_sym_catch] = "catch",
  [anon_sym_SLASH] = "/",
  [anon_sym_STAR] = "*",
  [anon_sym_div] = "div",
  [anon_sym_rem] = "rem",
  [anon_sym_band] = "band",
  [anon_sym_and] = "and",
  [anon_sym_bor] = "bor",
  [anon_sym_bxor] = "bxor",
  [anon_sym_bsl] = "bsl",
  [anon_sym_bsr] = "bsr",
  [anon_sym_or] = "or",
  [anon_sym_xor] = "xor",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_EQ_LT] = "=<",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_EQ_COLON_EQ] = "=:=",
  [anon_sym_EQ_SLASH_EQ] = "=/=",
  [anon_sym_andalso] = "andalso",
  [anon_sym_orelse] = "orelse",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG] = "!",
  [anon_sym_QMARK_EQ] = "\?=",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_PIPE] = "|",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_fun] = "fun",
  [anon_sym_end] = "end",
  [anon_sym_begin] = "begin",
  [anon_sym_case] = "case",
  [anon_sym_of] = "of",
  [anon_sym_receive] = "receive",
  [anon_sym_after] = "after",
  [anon_sym_try] = "try",
  [anon_sym_maybe] = "maybe",
  [anon_sym_else] = "else",
  [anon_sym_DOLLAR] = "$",
  [aux_sym_character_token1] = "character_token1",
  [aux_sym_integer_token1] = "integer_token1",
  [aux_sym_integer_token2] = "integer_token2",
  [sym_float] = "float",
  [sym_atom] = "atom",
  [anon_sym_SQUOTE] = "'",
  [sym_variable] = "variable",
  [anon_sym_QMARK] = "\?",
  [anon_sym_QMARK2] = "\?",
  [anon_sym_DQUOTE] = "\"",
  [sym_escape_sequence] = "escape_sequence",
  [sym_quoted_content] = "quoted_content",
  [sym_tripledot] = "tripledot",
  [aux_sym_comment_token1] = "comment_token1",
  [aux_sym_comment_token2] = "comment_token2",
  [sym_source] = "source",
  [sym__statement] = "_statement",
  [sym__terminator] = "_terminator",
  [sym_function] = "function",
  [sym__macro_declaration] = "attribute",
  [sym__macro_arguments] = "arguments",
  [sym__semicolon_separated_expressions] = "body",
  [sym__spec] = "attribute",
  [sym_attribute] = "attribute",
  [sym__expression] = "_expression",
  [sym__parenthesized_expression] = "_parenthesized_expression",
  [sym_bitstring] = "bitstring",
  [sym_tuple] = "tuple",
  [sym_list] = "list",
  [sym_map] = "map",
  [sym__map_body] = "_map_body",
  [sym_record] = "record",
  [sym__record_body] = "_record_body",
  [sym_unary_operator] = "unary_operator",
  [sym_binary_operator] = "binary_operator",
  [sym__literal] = "_literal",
  [sym_anonymous_function] = "anonymous_function",
  [sym_stab_clause] = "stab_clause",
  [sym__named_stab_clause] = "_named_stab_clause",
  [sym__anonymous_stab_clause] = "_anonymous_stab_clause",
  [sym_clause] = "clause",
  [sym_guard] = "guard",
  [sym_arguments] = "arguments",
  [sym__body] = "_body",
  [sym_body] = "body",
  [sym__items] = "_items",
  [sym_call] = "call",
  [sym__qualified_function] = "_qualified_function",
  [sym__unqualified_function] = "_unqualified_function",
  [sym_function_capture] = "function_capture",
  [sym_function_type] = "function_type",
  [sym_block] = "block",
  [sym_if] = "if",
  [sym__if_clause] = "clause",
  [sym_case] = "case",
  [sym_receive] = "receive",
  [sym_after] = "after",
  [sym__body_after] = "after",
  [sym_try] = "try",
  [sym_maybe] = "maybe",
  [sym_character] = "character",
  [sym__number] = "_number",
  [sym_integer] = "integer",
  [sym__identifier] = "_identifier",
  [sym__atom] = "_atom",
  [sym_quoted_atom] = "quoted_atom",
  [sym_macro] = "macro",
  [sym__strings] = "_strings",
  [sym_string] = "string",
  [sym_comment] = "comment",
  [aux_sym_source_repeat1] = "source_repeat1",
  [aux_sym_source_repeat2] = "source_repeat2",
  [aux_sym_function_repeat1] = "function_repeat1",
  [aux_sym__semicolon_separated_expressions_repeat1] = "_semicolon_separated_expressions_repeat1",
  [aux_sym__spec_repeat1] = "_spec_repeat1",
  [aux_sym_anonymous_function_repeat1] = "anonymous_function_repeat1",
  [aux_sym_guard_repeat1] = "guard_repeat1",
  [aux_sym_if_repeat1] = "if_repeat1",
  [aux_sym_case_repeat1] = "case_repeat1",
  [aux_sym_quoted_atom_repeat1] = "quoted_atom_repeat1",
  [aux_sym__strings_repeat1] = "_strings_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [alias_sym_map_content] = "map_content",
  [alias_sym_record_content] = "record_content",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_define] = sym_atom,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_spec] = sym_atom,
  [anon_sym_callback] = sym_atom,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_bnot] = anon_sym_bnot,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_div] = anon_sym_div,
  [anon_sym_rem] = anon_sym_rem,
  [anon_sym_band] = anon_sym_band,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_bor] = anon_sym_bor,
  [anon_sym_bxor] = anon_sym_bxor,
  [anon_sym_bsl] = anon_sym_bsl,
  [anon_sym_bsr] = anon_sym_bsr,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_EQ_LT] = anon_sym_EQ_LT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_EQ_COLON_EQ] = anon_sym_EQ_COLON_EQ,
  [anon_sym_EQ_SLASH_EQ] = anon_sym_EQ_SLASH_EQ,
  [anon_sym_andalso] = anon_sym_andalso,
  [anon_sym_orelse] = anon_sym_orelse,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_QMARK_EQ] = anon_sym_QMARK_EQ,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_fun] = anon_sym_fun,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_begin] = anon_sym_begin,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_receive] = anon_sym_receive,
  [anon_sym_after] = anon_sym_after,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_maybe] = anon_sym_maybe,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [aux_sym_character_token1] = aux_sym_character_token1,
  [aux_sym_integer_token1] = aux_sym_integer_token1,
  [aux_sym_integer_token2] = aux_sym_integer_token2,
  [sym_float] = sym_float,
  [sym_atom] = sym_atom,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_variable] = sym_variable,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_QMARK2] = anon_sym_QMARK,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_quoted_content] = sym_quoted_content,
  [sym_tripledot] = sym_tripledot,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [aux_sym_comment_token2] = aux_sym_comment_token2,
  [sym_source] = sym_source,
  [sym__statement] = sym__statement,
  [sym__terminator] = sym__terminator,
  [sym_function] = sym_function,
  [sym__macro_declaration] = sym_attribute,
  [sym__macro_arguments] = sym_arguments,
  [sym__semicolon_separated_expressions] = sym_body,
  [sym__spec] = sym_attribute,
  [sym_attribute] = sym_attribute,
  [sym__expression] = sym__expression,
  [sym__parenthesized_expression] = sym__parenthesized_expression,
  [sym_bitstring] = sym_bitstring,
  [sym_tuple] = sym_tuple,
  [sym_list] = sym_list,
  [sym_map] = sym_map,
  [sym__map_body] = sym__map_body,
  [sym_record] = sym_record,
  [sym__record_body] = sym__record_body,
  [sym_unary_operator] = sym_unary_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym__literal] = sym__literal,
  [sym_anonymous_function] = sym_anonymous_function,
  [sym_stab_clause] = sym_stab_clause,
  [sym__named_stab_clause] = sym__named_stab_clause,
  [sym__anonymous_stab_clause] = sym__anonymous_stab_clause,
  [sym_clause] = sym_clause,
  [sym_guard] = sym_guard,
  [sym_arguments] = sym_arguments,
  [sym__body] = sym__body,
  [sym_body] = sym_body,
  [sym__items] = sym__items,
  [sym_call] = sym_call,
  [sym__qualified_function] = sym__qualified_function,
  [sym__unqualified_function] = sym__unqualified_function,
  [sym_function_capture] = sym_function_capture,
  [sym_function_type] = sym_function_type,
  [sym_block] = sym_block,
  [sym_if] = sym_if,
  [sym__if_clause] = sym_clause,
  [sym_case] = sym_case,
  [sym_receive] = sym_receive,
  [sym_after] = sym_after,
  [sym__body_after] = sym_after,
  [sym_try] = sym_try,
  [sym_maybe] = sym_maybe,
  [sym_character] = sym_character,
  [sym__number] = sym__number,
  [sym_integer] = sym_integer,
  [sym__identifier] = sym__identifier,
  [sym__atom] = sym__atom,
  [sym_quoted_atom] = sym_quoted_atom,
  [sym_macro] = sym_macro,
  [sym__strings] = sym__strings,
  [sym_string] = sym_string,
  [sym_comment] = sym_comment,
  [aux_sym_source_repeat1] = aux_sym_source_repeat1,
  [aux_sym_source_repeat2] = aux_sym_source_repeat2,
  [aux_sym_function_repeat1] = aux_sym_function_repeat1,
  [aux_sym__semicolon_separated_expressions_repeat1] = aux_sym__semicolon_separated_expressions_repeat1,
  [aux_sym__spec_repeat1] = aux_sym__spec_repeat1,
  [aux_sym_anonymous_function_repeat1] = aux_sym_anonymous_function_repeat1,
  [aux_sym_guard_repeat1] = aux_sym_guard_repeat1,
  [aux_sym_if_repeat1] = aux_sym_if_repeat1,
  [aux_sym_case_repeat1] = aux_sym_case_repeat1,
  [aux_sym_quoted_atom_repeat1] = aux_sym_quoted_atom_repeat1,
  [aux_sym__strings_repeat1] = aux_sym__strings_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [alias_sym_map_content] = alias_sym_map_content,
  [alias_sym_record_content] = alias_sym_record_content,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_define] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_spec] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_callback] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bnot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_band] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bxor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bsl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bsr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_andalso] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_orelse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fun] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_receive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_after] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_maybe] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_character_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integer_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integer_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_atom] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_content] = {
    .visible = true,
    .named = true,
  },
  [sym_tripledot] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comment_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_source] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__terminator] = {
    .visible = false,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym__macro_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__macro_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__semicolon_separated_expressions] = {
    .visible = true,
    .named = true,
  },
  [sym__spec] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__parenthesized_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_bitstring] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_map] = {
    .visible = true,
    .named = true,
  },
  [sym__map_body] = {
    .visible = false,
    .named = true,
  },
  [sym_record] = {
    .visible = true,
    .named = true,
  },
  [sym__record_body] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_anonymous_function] = {
    .visible = true,
    .named = true,
  },
  [sym_stab_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__named_stab_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__anonymous_stab_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_guard] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__body] = {
    .visible = false,
    .named = true,
  },
  [sym_body] = {
    .visible = true,
    .named = true,
  },
  [sym__items] = {
    .visible = false,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym__qualified_function] = {
    .visible = false,
    .named = true,
  },
  [sym__unqualified_function] = {
    .visible = false,
    .named = true,
  },
  [sym_function_capture] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym__if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_receive] = {
    .visible = true,
    .named = true,
  },
  [sym_after] = {
    .visible = true,
    .named = true,
  },
  [sym__body_after] = {
    .visible = true,
    .named = true,
  },
  [sym_try] = {
    .visible = true,
    .named = true,
  },
  [sym_maybe] = {
    .visible = true,
    .named = true,
  },
  [sym_character] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = false,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__atom] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_macro] = {
    .visible = true,
    .named = true,
  },
  [sym__strings] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_source_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__semicolon_separated_expressions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__spec_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anonymous_function_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_guard_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_quoted_atom_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__strings_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_map_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_record_content] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_after = 1,
  field_arguments = 2,
  field_arity = 3,
  field_body = 4,
  field_catch = 5,
  field_comment_content = 6,
  field_else = 7,
  field_field = 8,
  field_function = 9,
  field_guard = 10,
  field_left = 11,
  field_module = 12,
  field_name = 13,
  field_of = 14,
  field_operand = 15,
  field_operator = 16,
  field_pattern = 17,
  field_quoted_end = 18,
  field_quoted_start = 19,
  field_right = 20,
  field_subject = 21,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_after] = "after",
  [field_arguments] = "arguments",
  [field_arity] = "arity",
  [field_body] = "body",
  [field_catch] = "catch",
  [field_comment_content] = "comment_content",
  [field_else] = "else",
  [field_field] = "field",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_left] = "left",
  [field_module] = "module",
  [field_name] = "name",
  [field_of] = "of",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_pattern] = "pattern",
  [field_quoted_end] = "quoted_end",
  [field_quoted_start] = "quoted_start",
  [field_right] = "right",
  [field_subject] = "subject",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 4},
  [3] = {.index = 5, .length = 1},
  [4] = {.index = 6, .length = 1},
  [5] = {.index = 7, .length = 2},
  [6] = {.index = 9, .length = 2},
  [7] = {.index = 11, .length = 1},
  [8] = {.index = 12, .length = 3},
  [9] = {.index = 15, .length = 2},
  [10] = {.index = 17, .length = 1},
  [11] = {.index = 18, .length = 2},
  [12] = {.index = 20, .length = 8},
  [13] = {.index = 28, .length = 2},
  [14] = {.index = 30, .length = 1},
  [15] = {.index = 31, .length = 4},
  [16] = {.index = 6, .length = 1},
  [17] = {.index = 35, .length = 1},
  [18] = {.index = 36, .length = 2},
  [19] = {.index = 38, .length = 2},
  [20] = {.index = 40, .length = 1},
  [21] = {.index = 41, .length = 3},
  [22] = {.index = 44, .length = 5},
  [23] = {.index = 49, .length = 2},
  [24] = {.index = 51, .length = 2},
  [26] = {.index = 53, .length = 3},
  [27] = {.index = 56, .length = 2},
  [28] = {.index = 58, .length = 3},
  [29] = {.index = 61, .length = 2},
  [30] = {.index = 63, .length = 2},
  [31] = {.index = 65, .length = 2},
  [32] = {.index = 67, .length = 3},
  [33] = {.index = 6, .length = 1},
  [34] = {.index = 70, .length = 2},
  [35] = {.index = 11, .length = 1},
  [36] = {.index = 72, .length = 3},
  [37] = {.index = 75, .length = 3},
  [38] = {.index = 78, .length = 2},
  [39] = {.index = 80, .length = 4},
  [40] = {.index = 84, .length = 4},
  [41] = {.index = 88, .length = 4},
  [42] = {.index = 92, .length = 4},
  [43] = {.index = 96, .length = 4},
  [44] = {.index = 100, .length = 3},
  [45] = {.index = 103, .length = 5},
  [46] = {.index = 108, .length = 4},
  [47] = {.index = 6, .length = 1},
  [48] = {.index = 112, .length = 2},
  [50] = {.index = 70, .length = 2},
  [51] = {.index = 114, .length = 5},
  [52] = {.index = 119, .length = 5},
  [53] = {.index = 124, .length = 5},
  [54] = {.index = 129, .length = 6},
  [55] = {.index = 135, .length = 6},
  [56] = {.index = 141, .length = 6},
  [57] = {.index = 112, .length = 2},
  [58] = {.index = 147, .length = 7},
  [59] = {.index = 154, .length = 7},
  [60] = {.index = 161, .length = 7},
  [61] = {.index = 168, .length = 8},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_function, 0},
  [1] =
    {field_body, 0, .inherited = true},
    {field_guard, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [5] =
    {field_comment_content, 1},
  [6] =
    {field_name, 1},
  [7] =
    {field_operand, 1},
    {field_operator, 0},
  [9] =
    {field_field, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [11] =
    {field_name, 0},
  [12] =
    {field_body, 0, .inherited = true},
    {field_guard, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [15] =
    {field_quoted_end, 1},
    {field_quoted_start, 0},
  [17] =
    {field_name, 0, .inherited = true},
  [18] =
    {field_module, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [20] =
    {field_body, 0, .inherited = true},
    {field_body, 1, .inherited = true},
    {field_guard, 0, .inherited = true},
    {field_guard, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_pattern, 1, .inherited = true},
  [28] =
    {field_function, 0, .inherited = true},
    {field_module, 0, .inherited = true},
  [30] =
    {field_function, 0, .inherited = true},
  [31] =
    {field_body, 1, .inherited = true},
    {field_guard, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_pattern, 1, .inherited = true},
  [35] =
    {field_subject, 1},
  [36] =
    {field_quoted_end, 2},
    {field_quoted_start, 0},
  [38] =
    {field_arguments, 2},
    {field_name, 1},
  [40] =
    {field_name, 2},
  [41] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [44] =
    {field_field, 2, .inherited = true},
    {field_left, 0},
    {field_name, 2, .inherited = true},
    {field_operator, 1},
    {field_right, 2},
  [49] =
    {field_function, 2},
    {field_module, 0},
  [51] =
    {field_field, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [53] =
    {field_field, 1},
    {field_field, 2},
    {field_name, 0},
  [56] =
    {field_body, 2},
    {field_pattern, 0},
  [58] =
    {field_arity, 3},
    {field_function, 1, .inherited = true},
    {field_module, 1, .inherited = true},
  [61] =
    {field_arity, 3},
    {field_function, 1, .inherited = true},
  [63] =
    {field_after, 2},
    {field_subject, 1},
  [65] =
    {field_arguments, 3},
    {field_name, 2},
  [67] =
    {field_body, 3},
    {field_name, 0},
    {field_pattern, 1},
  [70] =
    {field_module, 2},
    {field_name, 1},
  [72] =
    {field_catch, 2},
    {field_catch, 3},
    {field_subject, 1},
  [75] =
    {field_of, 2},
    {field_of, 3},
    {field_subject, 1},
  [78] =
    {field_else, 2},
    {field_else, 3},
  [80] =
    {field_body, 4},
    {field_guard, 1},
    {field_guard, 2},
    {field_pattern, 0},
  [84] =
    {field_after, 4},
    {field_catch, 2},
    {field_catch, 3},
    {field_subject, 1},
  [88] =
    {field_catch, 2},
    {field_catch, 3},
    {field_catch, 4},
    {field_subject, 1},
  [92] =
    {field_after, 4},
    {field_of, 2},
    {field_of, 3},
    {field_subject, 1},
  [96] =
    {field_of, 2},
    {field_of, 3},
    {field_of, 4},
    {field_subject, 1},
  [100] =
    {field_else, 2},
    {field_else, 3},
    {field_else, 4},
  [103] =
    {field_body, 5},
    {field_guard, 2},
    {field_guard, 3},
    {field_name, 0},
    {field_pattern, 1},
  [108] =
    {field_body, 3, .inherited = true},
    {field_guard, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_pattern, 3, .inherited = true},
  [112] =
    {field_module, 3},
    {field_name, 1},
  [114] =
    {field_after, 5},
    {field_catch, 2},
    {field_catch, 3},
    {field_catch, 4},
    {field_subject, 1},
  [119] =
    {field_catch, 4},
    {field_catch, 5},
    {field_of, 2},
    {field_of, 3},
    {field_subject, 1},
  [124] =
    {field_after, 5},
    {field_of, 2},
    {field_of, 3},
    {field_of, 4},
    {field_subject, 1},
  [129] =
    {field_after, 6},
    {field_catch, 4},
    {field_catch, 5},
    {field_of, 2},
    {field_of, 3},
    {field_subject, 1},
  [135] =
    {field_catch, 4},
    {field_catch, 5},
    {field_catch, 6},
    {field_of, 2},
    {field_of, 3},
    {field_subject, 1},
  [141] =
    {field_catch, 5},
    {field_catch, 6},
    {field_of, 2},
    {field_of, 3},
    {field_of, 4},
    {field_subject, 1},
  [147] =
    {field_after, 7},
    {field_catch, 4},
    {field_catch, 5},
    {field_catch, 6},
    {field_of, 2},
    {field_of, 3},
    {field_subject, 1},
  [154] =
    {field_after, 7},
    {field_catch, 5},
    {field_catch, 6},
    {field_of, 2},
    {field_of, 3},
    {field_of, 4},
    {field_subject, 1},
  [161] =
    {field_catch, 5},
    {field_catch, 6},
    {field_catch, 7},
    {field_of, 2},
    {field_of, 3},
    {field_of, 4},
    {field_subject, 1},
  [168] =
    {field_after, 8},
    {field_catch, 5},
    {field_catch, 6},
    {field_catch, 7},
    {field_of, 2},
    {field_of, 3},
    {field_of, 4},
    {field_subject, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [16] = {
    [2] = sym_arguments,
  },
  [25] = {
    [1] = alias_sym_map_content,
  },
  [33] = {
    [4] = sym_guard,
  },
  [35] = {
    [2] = alias_sym_record_content,
  },
  [46] = {
    [3] = sym_function,
  },
  [47] = {
    [5] = sym_guard,
  },
  [49] = {
    [3] = sym_guard,
  },
  [50] = {
    [6] = sym_guard,
  },
  [57] = {
    [7] = sym_guard,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__named_stab_clause, 2,
    sym__named_stab_clause,
    sym_function,
  sym__items, 5,
    sym__items,
    alias_sym_map_content,
    alias_sym_record_content,
    sym_arguments,
    sym_guard,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(81);
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(109);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(142);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(146);
      if (lookahead == '?') ADVANCE(280);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == 'a') ADVANCE(223);
      if (lookahead == 'b') ADVANCE(192);
      if (lookahead == 'c') ADVANCE(193);
      if (lookahead == 'd') ADVANCE(216);
      if (lookahead == 'e') ADVANCE(236);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(226);
      if (lookahead == 'r') ADVANCE(209);
      if (lookahead == 's') ADVANCE(254);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == 'w') ADVANCE(230);
      if (lookahead == 'x') ADVANCE(251);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '}') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('g' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(79)
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(87);
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(109);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(142);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(145);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == 'a') ADVANCE(242);
      if (lookahead == 'b') ADVANCE(192);
      if (lookahead == 'c') ADVANCE(195);
      if (lookahead == 'd') ADVANCE(231);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(255);
      if (lookahead == 'r') ADVANCE(209);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == 'w') ADVANCE(230);
      if (lookahead == 'x') ADVANCE(251);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('e' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(1)
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(87);
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(108);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(89);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(143);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(145);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == 'a') ADVANCE(53);
      if (lookahead == 'b') ADVANCE(32);
      if (lookahead == 'd') ADVANCE(47);
      if (lookahead == 'o') ADVANCE(59);
      if (lookahead == 'r') ADVANCE(38);
      if (lookahead == 'w') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(57);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(160);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(2)
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(87);
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(108);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(89);
      if (lookahead == '.') ADVANCE(86);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(143);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(145);
      if (lookahead == '?') ADVANCE(27);
      if (lookahead == 'a') ADVANCE(53);
      if (lookahead == 'b') ADVANCE(32);
      if (lookahead == 'd') ADVANCE(47);
      if (lookahead == 'o') ADVANCE(59);
      if (lookahead == 'r') ADVANCE(38);
      if (lookahead == 'w') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(57);
      if (lookahead == '|') ADVANCE(160);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(3)
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(109);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(142);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(146);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == 'a') ADVANCE(242);
      if (lookahead == 'b') ADVANCE(192);
      if (lookahead == 'c') ADVANCE(195);
      if (lookahead == 'd') ADVANCE(231);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(255);
      if (lookahead == 'r') ADVANCE(209);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == 'w') ADVANCE(230);
      if (lookahead == 'x') ADVANCE(251);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '}') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('e' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(4)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(109);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(142);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(145);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == 'a') ADVANCE(223);
      if (lookahead == 'b') ADVANCE(192);
      if (lookahead == 'c') ADVANCE(195);
      if (lookahead == 'd') ADVANCE(231);
      if (lookahead == 'e') ADVANCE(246);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(255);
      if (lookahead == 'r') ADVANCE(209);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == 'w') ADVANCE(230);
      if (lookahead == 'x') ADVANCE(251);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('g' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(109);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(142);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(145);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == 'a') ADVANCE(242);
      if (lookahead == 'b') ADVANCE(192);
      if (lookahead == 'c') ADVANCE(195);
      if (lookahead == 'd') ADVANCE(231);
      if (lookahead == 'e') ADVANCE(246);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(255);
      if (lookahead == 'r') ADVANCE(209);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == 'w') ADVANCE(230);
      if (lookahead == 'x') ADVANCE(251);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('g' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(109);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(142);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(145);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == 'a') ADVANCE(223);
      if (lookahead == 'b') ADVANCE(192);
      if (lookahead == 'c') ADVANCE(195);
      if (lookahead == 'd') ADVANCE(231);
      if (lookahead == 'e') ADVANCE(246);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(226);
      if (lookahead == 'r') ADVANCE(209);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == 'w') ADVANCE(230);
      if (lookahead == 'x') ADVANCE(251);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('g' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(7)
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(109);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(142);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(145);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == 'a') ADVANCE(242);
      if (lookahead == 'b') ADVANCE(192);
      if (lookahead == 'c') ADVANCE(195);
      if (lookahead == 'd') ADVANCE(231);
      if (lookahead == 'e') ADVANCE(236);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(255);
      if (lookahead == 'r') ADVANCE(209);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == 'w') ADVANCE(230);
      if (lookahead == 'x') ADVANCE(251);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('g' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(8)
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(109);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(142);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(145);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == 'a') ADVANCE(242);
      if (lookahead == 'b') ADVANCE(192);
      if (lookahead == 'c') ADVANCE(195);
      if (lookahead == 'd') ADVANCE(231);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(226);
      if (lookahead == 'r') ADVANCE(209);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == 'w') ADVANCE(230);
      if (lookahead == 'x') ADVANCE(251);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('e' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(9)
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(108);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(89);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(143);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(146);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == 'a') ADVANCE(43);
      if (lookahead == 'b') ADVANCE(32);
      if (lookahead == 'c') ADVANCE(33);
      if (lookahead == 'd') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'o') ADVANCE(44);
      if (lookahead == 'r') ADVANCE(38);
      if (lookahead == 'w') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(57);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '}') ADVANCE(104);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(10)
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(108);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(89);
      if (lookahead == '.') ADVANCE(86);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(143);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(146);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == 'a') ADVANCE(43);
      if (lookahead == 'b') ADVANCE(32);
      if (lookahead == 'c') ADVANCE(33);
      if (lookahead == 'd') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'o') ADVANCE(44);
      if (lookahead == 'r') ADVANCE(38);
      if (lookahead == 'w') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(57);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '}') ADVANCE(104);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(11)
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '+') ADVANCE(110);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(25);
      if (lookahead == '<') ADVANCE(26);
      if (lookahead == '?') ADVANCE(277);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == 'a') ADVANCE(224);
      if (lookahead == 'b') ADVANCE(208);
      if (lookahead == 'c') ADVANCE(195);
      if (lookahead == 'e') ADVANCE(246);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'r') ADVANCE(221);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == '{') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('d' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(12)
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '+') ADVANCE(110);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(25);
      if (lookahead == '<') ADVANCE(26);
      if (lookahead == '?') ADVANCE(277);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == 'b') ADVANCE(208);
      if (lookahead == 'c') ADVANCE(193);
      if (lookahead == 'd') ADVANCE(217);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'r') ADVANCE(221);
      if (lookahead == 's') ADVANCE(254);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == '{') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(13)
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '+') ADVANCE(110);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(25);
      if (lookahead == '<') ADVANCE(26);
      if (lookahead == '?') ADVANCE(277);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == 'b') ADVANCE(208);
      if (lookahead == 'c') ADVANCE(195);
      if (lookahead == 'e') ADVANCE(246);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'r') ADVANCE(221);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == '{') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(14)
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '\'') ADVANCE(287);
      if (lookahead == '\\') ADVANCE(291);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(288);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 16:
      if (lookahead == '"') ADVANCE(287);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '\\') ADVANCE(291);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(289);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 17:
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '?') ADVANCE(277);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(185);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(17)
      END_STATE();
    case 18:
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '?') ADVANCE(277);
      if (lookahead == 'c') ADVANCE(197);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(18)
      END_STATE();
    case 19:
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '?') ADVANCE(277);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(19)
      END_STATE();
    case 20:
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '?') ADVANCE(279);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(21)
      END_STATE();
    case 21:
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(21)
      END_STATE();
    case 22:
      if (lookahead == '%') ADVANCE(182);
      if (lookahead == '\\') ADVANCE(31);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(181);
      if (lookahead != 0) ADVANCE(181);
      END_STATE();
    case 23:
      if (lookahead == '.') ADVANCE(157);
      END_STATE();
    case 24:
      if (lookahead == '.') ADVANCE(293);
      END_STATE();
    case 25:
      if (lookahead == '.') ADVANCE(24);
      END_STATE();
    case 26:
      if (lookahead == '<') ADVANCE(101);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(155);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 29:
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 30:
      if (lookahead == '>') ADVANCE(102);
      END_STATE();
    case 31:
      if (lookahead == '^') ADVANCE(286);
      if (lookahead == 'x') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(285);
      if ((' ' <= lookahead && lookahead <= 127)) ADVANCE(282);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(55);
      if (lookahead == 'o') ADVANCE(60);
      if (lookahead == 's') ADVANCE(49);
      if (lookahead == 'x') ADVANCE(58);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 34:
      if (lookahead == 'c') ADVANCE(45);
      END_STATE();
    case 35:
      if (lookahead == 'd') ADVANCE(123);
      END_STATE();
    case 36:
      if (lookahead == 'd') ADVANCE(167);
      END_STATE();
    case 37:
      if (lookahead == 'd') ADVANCE(121);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(52);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(54);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(68);
      if (lookahead == 'n') ADVANCE(35);
      END_STATE();
    case 44:
      if (lookahead == 'f') ADVANCE(171);
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 45:
      if (lookahead == 'h') ADVANCE(113);
      END_STATE();
    case 46:
      if (lookahead == 'h') ADVANCE(41);
      END_STATE();
    case 47:
      if (lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(65);
      if (lookahead == 'n') ADVANCE(36);
      END_STATE();
    case 49:
      if (lookahead == 'l') ADVANCE(129);
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 50:
      if (lookahead == 'l') ADVANCE(64);
      END_STATE();
    case 51:
      if (lookahead == 'l') ADVANCE(66);
      END_STATE();
    case 52:
      if (lookahead == 'm') ADVANCE(119);
      END_STATE();
    case 53:
      if (lookahead == 'n') ADVANCE(35);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 55:
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 56:
      if (lookahead == 'o') ADVANCE(149);
      END_STATE();
    case 57:
      if (lookahead == 'o') ADVANCE(61);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 60:
      if (lookahead == 'r') ADVANCE(125);
      END_STATE();
    case 61:
      if (lookahead == 'r') ADVANCE(135);
      END_STATE();
    case 62:
      if (lookahead == 'r') ADVANCE(127);
      END_STATE();
    case 63:
      if (lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 64:
      if (lookahead == 's') ADVANCE(56);
      END_STATE();
    case 65:
      if (lookahead == 's') ADVANCE(39);
      END_STATE();
    case 66:
      if (lookahead == 's') ADVANCE(40);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(34);
      END_STATE();
    case 68:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 69:
      if (lookahead == 'v') ADVANCE(117);
      END_STATE();
    case 70:
      if (lookahead == '}') ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 71:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 72:
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 73:
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(185);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 74:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 75:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(190);
      END_STATE();
    case 76:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(282);
      END_STATE();
    case 77:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 78:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(189);
      END_STATE();
    case 79:
      if (eof) ADVANCE(81);
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(109);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(142);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(146);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == 'a') ADVANCE(223);
      if (lookahead == 'b') ADVANCE(192);
      if (lookahead == 'c') ADVANCE(193);
      if (lookahead == 'd') ADVANCE(216);
      if (lookahead == 'e') ADVANCE(236);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(226);
      if (lookahead == 'r') ADVANCE(209);
      if (lookahead == 's') ADVANCE(254);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == 'w') ADVANCE(230);
      if (lookahead == 'x') ADVANCE(251);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '}') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('g' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(79)
      END_STATE();
    case 80:
      if (eof) ADVANCE(81);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '#') ADVANCE(107);
      if (lookahead == '$') ADVANCE(180);
      if (lookahead == '%') ADVANCE(294);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == '+') ADVANCE(110);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '<') ADVANCE(26);
      if (lookahead == '>') ADVANCE(30);
      if (lookahead == '?') ADVANCE(277);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == 'b') ADVANCE(208);
      if (lookahead == 'c') ADVANCE(195);
      if (lookahead == 'f') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'r') ADVANCE(221);
      if (lookahead == 't') ADVANCE(260);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '}') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(276);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(274);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(80)
      END_STATE();
    case 81:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(157);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(24);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(156);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(138);
      if (lookahead == '>') ADVANCE(165);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(138);
      if (lookahead == '>') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_define);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_spec);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_callback);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(159);
      if (lookahead == '=') ADVANCE(164);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_when);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(137);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(183);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_not);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_bnot);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_catch);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '=') ADVANCE(140);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_div);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_div);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_rem);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_rem);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_band);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_band);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_and);
      if (lookahead == 'a') ADVANCE(50);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_and);
      if (lookahead == 'a') ADVANCE(239);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_bor);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_bor);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_bxor);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_bxor);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_bsl);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_bsl);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_bsr);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_bsr);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'e') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_xor);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_xor);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_EQ_LT);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(144);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(144);
      if (lookahead == '>') ADVANCE(102);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_EQ_COLON_EQ);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_EQ_SLASH_EQ);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_andalso);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_andalso);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_orelse);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_orelse);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == ':') ADVANCE(29);
      if (lookahead == '<') ADVANCE(141);
      if (lookahead == '=') ADVANCE(139);
      if (lookahead == '>') ADVANCE(163);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_QMARK_EQ);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(293);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(158);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_fun);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_end);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_begin);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_case);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_of);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_receive);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_after);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_after);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_try);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_maybe);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym_character_token1);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == '%') ADVANCE(294);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '.') ADVANCE(75);
      if (lookahead == '_') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '.') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(187);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '_') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (lookahead == '#') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(188);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (lookahead == '.') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(187);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym_integer_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(189);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'a') ADVANCE(247);
      if (lookahead == 'e') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(252);
      if (lookahead == 'o') ADVANCE(256);
      if (lookahead == 's') ADVANCE(237);
      if (lookahead == 'x') ADVANCE(253);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'a') ADVANCE(238);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'a') ADVANCE(272);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'a') ADVANCE(262);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'a') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'a') ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'b') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'b') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'c') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'c') ADVANCE(235);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'c') ADVANCE(229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'c') ADVANCE(218);
      if (lookahead == 'm') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'c') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'd') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'd') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'd') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(179);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(232);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'f') ADVANCE(268);
      if (lookahead == 'n') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'f') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'f') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'f') ADVANCE(172);
      if (lookahead == 'r') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'f') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'g') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'h') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'h') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'i') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'i') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'i') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'i') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'k') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'l') ADVANCE(264);
      if (lookahead == 'n') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'l') ADVANCE(130);
      if (lookahead == 'r') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'l') ADVANCE(240);
      if (lookahead == 's') ADVANCE(210);
      if (lookahead == 't') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'l') ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'l') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'l') ADVANCE(265);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'n') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'n') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'n') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'n') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'n') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'n') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'n') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'o') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'o') ADVANCE(266);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'o') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'o') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'o') ADVANCE(258);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'p') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'r') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'r') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'r') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'r') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'r') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'r') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 's') ADVANCE(249);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 's') ADVANCE(210);
      if (lookahead == 't') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 's') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 's') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 's') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 't') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 't') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 't') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'u') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'v') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'v') ADVANCE(215);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'y') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'y') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_atom);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(274);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_variable);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(276);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '=') ADVANCE(155);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_QMARK2);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_QMARK2);
      if (lookahead == '=') ADVANCE(155);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '{') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(76);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(282);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(284);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(282);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_quoted_content);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead == '"') ADVANCE(281);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '\'') ADVANCE(287);
      if (lookahead == '\\') ADVANCE(291);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(288);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead == '"') ADVANCE(287);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '\\') ADVANCE(291);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(289);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(292);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead == '^') ADVANCE(286);
      if (lookahead == 'x') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(285);
      if ((' ' <= lookahead && lookahead <= 127)) ADVANCE(282);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(292);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_tripledot);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '%') ADVANCE(294);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '%') ADVANCE(295);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(297);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(aux_sym_comment_token2);
      if (lookahead == '%') ADVANCE(295);
      if ((1 <= lookahead && lookahead <= '\t') ||
          (11 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(296);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(297);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(aux_sym_comment_token2);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(297);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 80},
  [2] = {.lex_state = 4},
  [3] = {.lex_state = 4},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 5},
  [7] = {.lex_state = 5},
  [8] = {.lex_state = 5},
  [9] = {.lex_state = 5},
  [10] = {.lex_state = 4},
  [11] = {.lex_state = 7},
  [12] = {.lex_state = 7},
  [13] = {.lex_state = 4},
  [14] = {.lex_state = 6},
  [15] = {.lex_state = 4},
  [16] = {.lex_state = 1},
  [17] = {.lex_state = 6},
  [18] = {.lex_state = 8},
  [19] = {.lex_state = 1},
  [20] = {.lex_state = 4},
  [21] = {.lex_state = 8},
  [22] = {.lex_state = 9},
  [23] = {.lex_state = 9},
  [24] = {.lex_state = 4},
  [25] = {.lex_state = 4},
  [26] = {.lex_state = 4},
  [27] = {.lex_state = 4},
  [28] = {.lex_state = 4},
  [29] = {.lex_state = 4},
  [30] = {.lex_state = 4},
  [31] = {.lex_state = 4},
  [32] = {.lex_state = 4},
  [33] = {.lex_state = 5},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 7},
  [36] = {.lex_state = 7},
  [37] = {.lex_state = 5},
  [38] = {.lex_state = 1},
  [39] = {.lex_state = 5},
  [40] = {.lex_state = 7},
  [41] = {.lex_state = 1},
  [42] = {.lex_state = 1},
  [43] = {.lex_state = 7},
  [44] = {.lex_state = 1},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 1},
  [47] = {.lex_state = 7},
  [48] = {.lex_state = 7},
  [49] = {.lex_state = 7},
  [50] = {.lex_state = 7},
  [51] = {.lex_state = 5},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 1},
  [54] = {.lex_state = 5},
  [55] = {.lex_state = 6},
  [56] = {.lex_state = 7},
  [57] = {.lex_state = 6},
  [58] = {.lex_state = 5},
  [59] = {.lex_state = 8},
  [60] = {.lex_state = 5},
  [61] = {.lex_state = 5},
  [62] = {.lex_state = 5},
  [63] = {.lex_state = 8},
  [64] = {.lex_state = 6},
  [65] = {.lex_state = 6},
  [66] = {.lex_state = 6},
  [67] = {.lex_state = 6},
  [68] = {.lex_state = 8},
  [69] = {.lex_state = 6},
  [70] = {.lex_state = 8},
  [71] = {.lex_state = 8},
  [72] = {.lex_state = 8},
  [73] = {.lex_state = 6},
  [74] = {.lex_state = 8},
  [75] = {.lex_state = 6},
  [76] = {.lex_state = 8},
  [77] = {.lex_state = 8},
  [78] = {.lex_state = 80},
  [79] = {.lex_state = 80},
  [80] = {.lex_state = 9},
  [81] = {.lex_state = 9},
  [82] = {.lex_state = 9},
  [83] = {.lex_state = 9},
  [84] = {.lex_state = 9},
  [85] = {.lex_state = 9},
  [86] = {.lex_state = 9},
  [87] = {.lex_state = 9},
  [88] = {.lex_state = 9},
  [89] = {.lex_state = 80},
  [90] = {.lex_state = 80},
  [91] = {.lex_state = 12},
  [92] = {.lex_state = 12},
  [93] = {.lex_state = 80},
  [94] = {.lex_state = 80},
  [95] = {.lex_state = 80},
  [96] = {.lex_state = 80},
  [97] = {.lex_state = 80},
  [98] = {.lex_state = 13},
  [99] = {.lex_state = 80},
  [100] = {.lex_state = 80},
  [101] = {.lex_state = 80},
  [102] = {.lex_state = 80},
  [103] = {.lex_state = 80},
  [104] = {.lex_state = 80},
  [105] = {.lex_state = 80},
  [106] = {.lex_state = 80},
  [107] = {.lex_state = 80},
  [108] = {.lex_state = 14},
  [109] = {.lex_state = 80},
  [110] = {.lex_state = 80},
  [111] = {.lex_state = 80},
  [112] = {.lex_state = 80},
  [113] = {.lex_state = 80},
  [114] = {.lex_state = 80},
  [115] = {.lex_state = 80},
  [116] = {.lex_state = 80},
  [117] = {.lex_state = 80},
  [118] = {.lex_state = 80},
  [119] = {.lex_state = 14},
  [120] = {.lex_state = 80},
  [121] = {.lex_state = 80},
  [122] = {.lex_state = 80},
  [123] = {.lex_state = 80},
  [124] = {.lex_state = 80},
  [125] = {.lex_state = 80},
  [126] = {.lex_state = 80},
  [127] = {.lex_state = 80},
  [128] = {.lex_state = 80},
  [129] = {.lex_state = 80},
  [130] = {.lex_state = 80},
  [131] = {.lex_state = 80},
  [132] = {.lex_state = 80},
  [133] = {.lex_state = 80},
  [134] = {.lex_state = 80},
  [135] = {.lex_state = 80},
  [136] = {.lex_state = 80},
  [137] = {.lex_state = 80},
  [138] = {.lex_state = 80},
  [139] = {.lex_state = 80},
  [140] = {.lex_state = 80},
  [141] = {.lex_state = 80},
  [142] = {.lex_state = 80},
  [143] = {.lex_state = 80},
  [144] = {.lex_state = 80},
  [145] = {.lex_state = 80},
  [146] = {.lex_state = 80},
  [147] = {.lex_state = 80},
  [148] = {.lex_state = 80},
  [149] = {.lex_state = 80},
  [150] = {.lex_state = 80},
  [151] = {.lex_state = 80},
  [152] = {.lex_state = 80},
  [153] = {.lex_state = 80},
  [154] = {.lex_state = 80},
  [155] = {.lex_state = 80},
  [156] = {.lex_state = 80},
  [157] = {.lex_state = 80},
  [158] = {.lex_state = 80},
  [159] = {.lex_state = 80},
  [160] = {.lex_state = 80},
  [161] = {.lex_state = 80},
  [162] = {.lex_state = 80},
  [163] = {.lex_state = 80},
  [164] = {.lex_state = 80},
  [165] = {.lex_state = 80},
  [166] = {.lex_state = 80},
  [167] = {.lex_state = 80},
  [168] = {.lex_state = 80},
  [169] = {.lex_state = 80},
  [170] = {.lex_state = 80},
  [171] = {.lex_state = 80},
  [172] = {.lex_state = 80},
  [173] = {.lex_state = 80},
  [174] = {.lex_state = 80},
  [175] = {.lex_state = 80},
  [176] = {.lex_state = 80},
  [177] = {.lex_state = 80},
  [178] = {.lex_state = 80},
  [179] = {.lex_state = 80},
  [180] = {.lex_state = 80},
  [181] = {.lex_state = 80},
  [182] = {.lex_state = 80},
  [183] = {.lex_state = 80},
  [184] = {.lex_state = 80},
  [185] = {.lex_state = 80},
  [186] = {.lex_state = 80},
  [187] = {.lex_state = 80},
  [188] = {.lex_state = 80},
  [189] = {.lex_state = 80},
  [190] = {.lex_state = 80},
  [191] = {.lex_state = 80},
  [192] = {.lex_state = 80},
  [193] = {.lex_state = 80},
  [194] = {.lex_state = 80},
  [195] = {.lex_state = 80},
  [196] = {.lex_state = 80},
  [197] = {.lex_state = 80},
  [198] = {.lex_state = 80},
  [199] = {.lex_state = 80},
  [200] = {.lex_state = 80},
  [201] = {.lex_state = 80},
  [202] = {.lex_state = 80},
  [203] = {.lex_state = 80},
  [204] = {.lex_state = 80},
  [205] = {.lex_state = 80},
  [206] = {.lex_state = 80},
  [207] = {.lex_state = 80},
  [208] = {.lex_state = 80},
  [209] = {.lex_state = 80},
  [210] = {.lex_state = 80},
  [211] = {.lex_state = 80},
  [212] = {.lex_state = 80},
  [213] = {.lex_state = 80},
  [214] = {.lex_state = 80},
  [215] = {.lex_state = 80},
  [216] = {.lex_state = 80},
  [217] = {.lex_state = 80},
  [218] = {.lex_state = 80},
  [219] = {.lex_state = 80},
  [220] = {.lex_state = 80},
  [221] = {.lex_state = 80},
  [222] = {.lex_state = 80},
  [223] = {.lex_state = 80},
  [224] = {.lex_state = 80},
  [225] = {.lex_state = 80},
  [226] = {.lex_state = 80},
  [227] = {.lex_state = 80},
  [228] = {.lex_state = 80},
  [229] = {.lex_state = 80},
  [230] = {.lex_state = 80},
  [231] = {.lex_state = 80},
  [232] = {.lex_state = 80},
  [233] = {.lex_state = 80},
  [234] = {.lex_state = 80},
  [235] = {.lex_state = 80},
  [236] = {.lex_state = 80},
  [237] = {.lex_state = 80},
  [238] = {.lex_state = 80},
  [239] = {.lex_state = 80},
  [240] = {.lex_state = 80},
  [241] = {.lex_state = 80},
  [242] = {.lex_state = 80},
  [243] = {.lex_state = 80},
  [244] = {.lex_state = 80},
  [245] = {.lex_state = 80},
  [246] = {.lex_state = 80},
  [247] = {.lex_state = 80},
  [248] = {.lex_state = 80},
  [249] = {.lex_state = 80},
  [250] = {.lex_state = 80},
  [251] = {.lex_state = 80},
  [252] = {.lex_state = 80},
  [253] = {.lex_state = 80},
  [254] = {.lex_state = 80},
  [255] = {.lex_state = 80},
  [256] = {.lex_state = 80},
  [257] = {.lex_state = 80},
  [258] = {.lex_state = 80},
  [259] = {.lex_state = 80},
  [260] = {.lex_state = 80},
  [261] = {.lex_state = 80},
  [262] = {.lex_state = 80},
  [263] = {.lex_state = 80},
  [264] = {.lex_state = 80},
  [265] = {.lex_state = 80},
  [266] = {.lex_state = 80},
  [267] = {.lex_state = 80},
  [268] = {.lex_state = 80},
  [269] = {.lex_state = 80},
  [270] = {.lex_state = 80},
  [271] = {.lex_state = 80},
  [272] = {.lex_state = 80},
  [273] = {.lex_state = 80},
  [274] = {.lex_state = 80},
  [275] = {.lex_state = 80},
  [276] = {.lex_state = 80},
  [277] = {.lex_state = 80},
  [278] = {.lex_state = 80},
  [279] = {.lex_state = 80},
  [280] = {.lex_state = 80},
  [281] = {.lex_state = 80},
  [282] = {.lex_state = 80},
  [283] = {.lex_state = 80},
  [284] = {.lex_state = 80},
  [285] = {.lex_state = 80},
  [286] = {.lex_state = 80},
  [287] = {.lex_state = 80},
  [288] = {.lex_state = 80},
  [289] = {.lex_state = 80},
  [290] = {.lex_state = 80},
  [291] = {.lex_state = 80},
  [292] = {.lex_state = 80},
  [293] = {.lex_state = 80},
  [294] = {.lex_state = 80},
  [295] = {.lex_state = 80},
  [296] = {.lex_state = 80},
  [297] = {.lex_state = 80},
  [298] = {.lex_state = 80},
  [299] = {.lex_state = 80},
  [300] = {.lex_state = 80},
  [301] = {.lex_state = 80},
  [302] = {.lex_state = 80},
  [303] = {.lex_state = 80},
  [304] = {.lex_state = 80},
  [305] = {.lex_state = 80},
  [306] = {.lex_state = 80},
  [307] = {.lex_state = 80},
  [308] = {.lex_state = 80},
  [309] = {.lex_state = 80},
  [310] = {.lex_state = 80},
  [311] = {.lex_state = 80},
  [312] = {.lex_state = 80},
  [313] = {.lex_state = 80},
  [314] = {.lex_state = 80},
  [315] = {.lex_state = 80},
  [316] = {.lex_state = 80},
  [317] = {.lex_state = 80},
  [318] = {.lex_state = 80},
  [319] = {.lex_state = 80},
  [320] = {.lex_state = 80},
  [321] = {.lex_state = 80},
  [322] = {.lex_state = 80},
  [323] = {.lex_state = 80},
  [324] = {.lex_state = 80},
  [325] = {.lex_state = 80},
  [326] = {.lex_state = 80},
  [327] = {.lex_state = 80},
  [328] = {.lex_state = 80},
  [329] = {.lex_state = 80},
  [330] = {.lex_state = 80},
  [331] = {.lex_state = 80},
  [332] = {.lex_state = 80},
  [333] = {.lex_state = 80},
  [334] = {.lex_state = 80},
  [335] = {.lex_state = 80},
  [336] = {.lex_state = 80},
  [337] = {.lex_state = 80},
  [338] = {.lex_state = 80},
  [339] = {.lex_state = 80},
  [340] = {.lex_state = 80},
  [341] = {.lex_state = 80},
  [342] = {.lex_state = 80},
  [343] = {.lex_state = 80},
  [344] = {.lex_state = 80},
  [345] = {.lex_state = 80},
  [346] = {.lex_state = 80},
  [347] = {.lex_state = 80},
  [348] = {.lex_state = 80},
  [349] = {.lex_state = 80},
  [350] = {.lex_state = 80},
  [351] = {.lex_state = 80},
  [352] = {.lex_state = 80},
  [353] = {.lex_state = 80},
  [354] = {.lex_state = 80},
  [355] = {.lex_state = 80},
  [356] = {.lex_state = 80},
  [357] = {.lex_state = 80},
  [358] = {.lex_state = 80},
  [359] = {.lex_state = 80},
  [360] = {.lex_state = 80},
  [361] = {.lex_state = 80},
  [362] = {.lex_state = 80},
  [363] = {.lex_state = 80},
  [364] = {.lex_state = 80},
  [365] = {.lex_state = 80},
  [366] = {.lex_state = 80},
  [367] = {.lex_state = 80},
  [368] = {.lex_state = 80},
  [369] = {.lex_state = 80},
  [370] = {.lex_state = 80},
  [371] = {.lex_state = 80},
  [372] = {.lex_state = 80},
  [373] = {.lex_state = 80},
  [374] = {.lex_state = 80},
  [375] = {.lex_state = 80},
  [376] = {.lex_state = 80},
  [377] = {.lex_state = 80},
  [378] = {.lex_state = 80},
  [379] = {.lex_state = 80},
  [380] = {.lex_state = 80},
  [381] = {.lex_state = 80},
  [382] = {.lex_state = 80},
  [383] = {.lex_state = 80},
  [384] = {.lex_state = 80},
  [385] = {.lex_state = 80},
  [386] = {.lex_state = 80},
  [387] = {.lex_state = 80},
  [388] = {.lex_state = 80},
  [389] = {.lex_state = 80},
  [390] = {.lex_state = 80},
  [391] = {.lex_state = 80},
  [392] = {.lex_state = 80},
  [393] = {.lex_state = 80},
  [394] = {.lex_state = 80},
  [395] = {.lex_state = 80},
  [396] = {.lex_state = 80},
  [397] = {.lex_state = 80},
  [398] = {.lex_state = 80},
  [399] = {.lex_state = 80},
  [400] = {.lex_state = 80},
  [401] = {.lex_state = 80},
  [402] = {.lex_state = 80},
  [403] = {.lex_state = 80},
  [404] = {.lex_state = 80},
  [405] = {.lex_state = 80},
  [406] = {.lex_state = 80},
  [407] = {.lex_state = 80},
  [408] = {.lex_state = 80},
  [409] = {.lex_state = 80},
  [410] = {.lex_state = 80},
  [411] = {.lex_state = 80},
  [412] = {.lex_state = 80},
  [413] = {.lex_state = 80},
  [414] = {.lex_state = 80},
  [415] = {.lex_state = 80},
  [416] = {.lex_state = 80},
  [417] = {.lex_state = 80},
  [418] = {.lex_state = 80},
  [419] = {.lex_state = 80},
  [420] = {.lex_state = 80},
  [421] = {.lex_state = 80},
  [422] = {.lex_state = 80},
  [423] = {.lex_state = 80},
  [424] = {.lex_state = 80},
  [425] = {.lex_state = 80},
  [426] = {.lex_state = 80},
  [427] = {.lex_state = 80},
  [428] = {.lex_state = 80},
  [429] = {.lex_state = 80},
  [430] = {.lex_state = 80},
  [431] = {.lex_state = 80},
  [432] = {.lex_state = 80},
  [433] = {.lex_state = 80},
  [434] = {.lex_state = 80},
  [435] = {.lex_state = 80},
  [436] = {.lex_state = 80},
  [437] = {.lex_state = 80},
  [438] = {.lex_state = 80},
  [439] = {.lex_state = 80},
  [440] = {.lex_state = 80},
  [441] = {.lex_state = 80},
  [442] = {.lex_state = 80},
  [443] = {.lex_state = 80},
  [444] = {.lex_state = 80},
  [445] = {.lex_state = 80},
  [446] = {.lex_state = 80},
  [447] = {.lex_state = 80},
  [448] = {.lex_state = 80},
  [449] = {.lex_state = 80},
  [450] = {.lex_state = 80},
  [451] = {.lex_state = 80},
  [452] = {.lex_state = 80},
  [453] = {.lex_state = 80},
  [454] = {.lex_state = 80},
  [455] = {.lex_state = 80},
  [456] = {.lex_state = 80},
  [457] = {.lex_state = 80},
  [458] = {.lex_state = 80},
  [459] = {.lex_state = 80},
  [460] = {.lex_state = 80},
  [461] = {.lex_state = 80},
  [462] = {.lex_state = 80},
  [463] = {.lex_state = 80},
  [464] = {.lex_state = 80},
  [465] = {.lex_state = 80},
  [466] = {.lex_state = 80},
  [467] = {.lex_state = 80},
  [468] = {.lex_state = 80},
  [469] = {.lex_state = 80},
  [470] = {.lex_state = 80},
  [471] = {.lex_state = 80},
  [472] = {.lex_state = 80},
  [473] = {.lex_state = 80},
  [474] = {.lex_state = 80},
  [475] = {.lex_state = 80},
  [476] = {.lex_state = 80},
  [477] = {.lex_state = 80},
  [478] = {.lex_state = 80},
  [479] = {.lex_state = 80},
  [480] = {.lex_state = 80},
  [481] = {.lex_state = 80},
  [482] = {.lex_state = 80},
  [483] = {.lex_state = 80},
  [484] = {.lex_state = 80},
  [485] = {.lex_state = 80},
  [486] = {.lex_state = 80},
  [487] = {.lex_state = 80},
  [488] = {.lex_state = 80},
  [489] = {.lex_state = 80},
  [490] = {.lex_state = 80},
  [491] = {.lex_state = 80},
  [492] = {.lex_state = 80},
  [493] = {.lex_state = 80},
  [494] = {.lex_state = 80},
  [495] = {.lex_state = 80},
  [496] = {.lex_state = 80},
  [497] = {.lex_state = 80},
  [498] = {.lex_state = 80},
  [499] = {.lex_state = 80},
  [500] = {.lex_state = 80},
  [501] = {.lex_state = 80},
  [502] = {.lex_state = 80},
  [503] = {.lex_state = 80},
  [504] = {.lex_state = 80},
  [505] = {.lex_state = 80},
  [506] = {.lex_state = 80},
  [507] = {.lex_state = 80},
  [508] = {.lex_state = 80},
  [509] = {.lex_state = 80},
  [510] = {.lex_state = 80},
  [511] = {.lex_state = 80},
  [512] = {.lex_state = 10},
  [513] = {.lex_state = 10},
  [514] = {.lex_state = 10},
  [515] = {.lex_state = 10},
  [516] = {.lex_state = 10},
  [517] = {.lex_state = 11},
  [518] = {.lex_state = 11},
  [519] = {.lex_state = 10},
  [520] = {.lex_state = 10},
  [521] = {.lex_state = 10},
  [522] = {.lex_state = 11},
  [523] = {.lex_state = 10},
  [524] = {.lex_state = 10},
  [525] = {.lex_state = 10},
  [526] = {.lex_state = 10},
  [527] = {.lex_state = 10},
  [528] = {.lex_state = 10},
  [529] = {.lex_state = 10},
  [530] = {.lex_state = 10},
  [531] = {.lex_state = 11},
  [532] = {.lex_state = 10},
  [533] = {.lex_state = 11},
  [534] = {.lex_state = 11},
  [535] = {.lex_state = 10},
  [536] = {.lex_state = 10},
  [537] = {.lex_state = 10},
  [538] = {.lex_state = 10},
  [539] = {.lex_state = 10},
  [540] = {.lex_state = 10},
  [541] = {.lex_state = 10},
  [542] = {.lex_state = 11},
  [543] = {.lex_state = 11},
  [544] = {.lex_state = 11},
  [545] = {.lex_state = 10},
  [546] = {.lex_state = 10},
  [547] = {.lex_state = 10},
  [548] = {.lex_state = 10},
  [549] = {.lex_state = 10},
  [550] = {.lex_state = 10},
  [551] = {.lex_state = 10},
  [552] = {.lex_state = 10},
  [553] = {.lex_state = 10},
  [554] = {.lex_state = 10},
  [555] = {.lex_state = 10},
  [556] = {.lex_state = 10},
  [557] = {.lex_state = 10},
  [558] = {.lex_state = 11},
  [559] = {.lex_state = 10},
  [560] = {.lex_state = 10},
  [561] = {.lex_state = 10},
  [562] = {.lex_state = 10},
  [563] = {.lex_state = 10},
  [564] = {.lex_state = 10},
  [565] = {.lex_state = 10},
  [566] = {.lex_state = 10},
  [567] = {.lex_state = 10},
  [568] = {.lex_state = 10},
  [569] = {.lex_state = 10},
  [570] = {.lex_state = 10},
  [571] = {.lex_state = 10},
  [572] = {.lex_state = 10},
  [573] = {.lex_state = 10},
  [574] = {.lex_state = 10},
  [575] = {.lex_state = 10},
  [576] = {.lex_state = 10},
  [577] = {.lex_state = 10},
  [578] = {.lex_state = 10},
  [579] = {.lex_state = 10},
  [580] = {.lex_state = 10},
  [581] = {.lex_state = 10},
  [582] = {.lex_state = 10},
  [583] = {.lex_state = 10},
  [584] = {.lex_state = 10},
  [585] = {.lex_state = 10},
  [586] = {.lex_state = 10},
  [587] = {.lex_state = 10},
  [588] = {.lex_state = 10},
  [589] = {.lex_state = 10},
  [590] = {.lex_state = 10},
  [591] = {.lex_state = 10},
  [592] = {.lex_state = 10},
  [593] = {.lex_state = 10},
  [594] = {.lex_state = 10},
  [595] = {.lex_state = 10},
  [596] = {.lex_state = 10},
  [597] = {.lex_state = 10},
  [598] = {.lex_state = 10},
  [599] = {.lex_state = 10},
  [600] = {.lex_state = 10},
  [601] = {.lex_state = 10},
  [602] = {.lex_state = 2},
  [603] = {.lex_state = 10},
  [604] = {.lex_state = 2},
  [605] = {.lex_state = 2},
  [606] = {.lex_state = 2},
  [607] = {.lex_state = 2},
  [608] = {.lex_state = 10},
  [609] = {.lex_state = 2},
  [610] = {.lex_state = 10},
  [611] = {.lex_state = 10},
  [612] = {.lex_state = 10},
  [613] = {.lex_state = 10},
  [614] = {.lex_state = 10},
  [615] = {.lex_state = 10},
  [616] = {.lex_state = 10},
  [617] = {.lex_state = 10},
  [618] = {.lex_state = 10},
  [619] = {.lex_state = 10},
  [620] = {.lex_state = 10},
  [621] = {.lex_state = 10},
  [622] = {.lex_state = 2},
  [623] = {.lex_state = 2},
  [624] = {.lex_state = 10},
  [625] = {.lex_state = 10},
  [626] = {.lex_state = 2},
  [627] = {.lex_state = 2},
  [628] = {.lex_state = 10},
  [629] = {.lex_state = 10},
  [630] = {.lex_state = 10},
  [631] = {.lex_state = 2},
  [632] = {.lex_state = 10},
  [633] = {.lex_state = 10},
  [634] = {.lex_state = 10},
  [635] = {.lex_state = 10},
  [636] = {.lex_state = 10},
  [637] = {.lex_state = 10},
  [638] = {.lex_state = 10},
  [639] = {.lex_state = 10},
  [640] = {.lex_state = 10},
  [641] = {.lex_state = 10},
  [642] = {.lex_state = 10},
  [643] = {.lex_state = 10},
  [644] = {.lex_state = 10},
  [645] = {.lex_state = 10},
  [646] = {.lex_state = 2},
  [647] = {.lex_state = 10},
  [648] = {.lex_state = 10},
  [649] = {.lex_state = 10},
  [650] = {.lex_state = 10},
  [651] = {.lex_state = 10},
  [652] = {.lex_state = 3},
  [653] = {.lex_state = 10},
  [654] = {.lex_state = 10},
  [655] = {.lex_state = 10},
  [656] = {.lex_state = 10},
  [657] = {.lex_state = 10},
  [658] = {.lex_state = 10},
  [659] = {.lex_state = 2},
  [660] = {.lex_state = 10},
  [661] = {.lex_state = 10},
  [662] = {.lex_state = 10},
  [663] = {.lex_state = 10},
  [664] = {.lex_state = 10},
  [665] = {.lex_state = 10},
  [666] = {.lex_state = 10},
  [667] = {.lex_state = 10},
  [668] = {.lex_state = 10},
  [669] = {.lex_state = 10},
  [670] = {.lex_state = 10},
  [671] = {.lex_state = 10},
  [672] = {.lex_state = 10},
  [673] = {.lex_state = 10},
  [674] = {.lex_state = 10},
  [675] = {.lex_state = 11},
  [676] = {.lex_state = 10},
  [677] = {.lex_state = 10},
  [678] = {.lex_state = 10},
  [679] = {.lex_state = 10},
  [680] = {.lex_state = 10},
  [681] = {.lex_state = 10},
  [682] = {.lex_state = 10},
  [683] = {.lex_state = 10},
  [684] = {.lex_state = 10},
  [685] = {.lex_state = 10},
  [686] = {.lex_state = 2},
  [687] = {.lex_state = 10},
  [688] = {.lex_state = 10},
  [689] = {.lex_state = 10},
  [690] = {.lex_state = 10},
  [691] = {.lex_state = 10},
  [692] = {.lex_state = 10},
  [693] = {.lex_state = 10},
  [694] = {.lex_state = 10},
  [695] = {.lex_state = 10},
  [696] = {.lex_state = 10},
  [697] = {.lex_state = 10},
  [698] = {.lex_state = 3},
  [699] = {.lex_state = 2},
  [700] = {.lex_state = 3},
  [701] = {.lex_state = 11},
  [702] = {.lex_state = 10},
  [703] = {.lex_state = 10},
  [704] = {.lex_state = 3},
  [705] = {.lex_state = 3},
  [706] = {.lex_state = 11},
  [707] = {.lex_state = 11},
  [708] = {.lex_state = 10},
  [709] = {.lex_state = 10},
  [710] = {.lex_state = 3},
  [711] = {.lex_state = 2},
  [712] = {.lex_state = 10},
  [713] = {.lex_state = 10},
  [714] = {.lex_state = 10},
  [715] = {.lex_state = 10},
  [716] = {.lex_state = 10},
  [717] = {.lex_state = 10},
  [718] = {.lex_state = 10},
  [719] = {.lex_state = 10},
  [720] = {.lex_state = 10},
  [721] = {.lex_state = 10},
  [722] = {.lex_state = 3},
  [723] = {.lex_state = 2},
  [724] = {.lex_state = 3},
  [725] = {.lex_state = 10},
  [726] = {.lex_state = 10},
  [727] = {.lex_state = 10},
  [728] = {.lex_state = 10},
  [729] = {.lex_state = 10},
  [730] = {.lex_state = 10},
  [731] = {.lex_state = 10},
  [732] = {.lex_state = 10},
  [733] = {.lex_state = 10},
  [734] = {.lex_state = 10},
  [735] = {.lex_state = 10},
  [736] = {.lex_state = 10},
  [737] = {.lex_state = 10},
  [738] = {.lex_state = 10},
  [739] = {.lex_state = 10},
  [740] = {.lex_state = 11},
  [741] = {.lex_state = 3},
  [742] = {.lex_state = 3},
  [743] = {.lex_state = 11},
  [744] = {.lex_state = 10},
  [745] = {.lex_state = 10},
  [746] = {.lex_state = 2},
  [747] = {.lex_state = 2},
  [748] = {.lex_state = 10},
  [749] = {.lex_state = 10},
  [750] = {.lex_state = 10},
  [751] = {.lex_state = 10},
  [752] = {.lex_state = 10},
  [753] = {.lex_state = 10},
  [754] = {.lex_state = 10},
  [755] = {.lex_state = 10},
  [756] = {.lex_state = 10},
  [757] = {.lex_state = 10},
  [758] = {.lex_state = 10},
  [759] = {.lex_state = 10},
  [760] = {.lex_state = 10},
  [761] = {.lex_state = 10},
  [762] = {.lex_state = 10},
  [763] = {.lex_state = 10},
  [764] = {.lex_state = 3},
  [765] = {.lex_state = 10},
  [766] = {.lex_state = 10},
  [767] = {.lex_state = 2},
  [768] = {.lex_state = 10},
  [769] = {.lex_state = 10},
  [770] = {.lex_state = 10},
  [771] = {.lex_state = 10},
  [772] = {.lex_state = 10},
  [773] = {.lex_state = 2},
  [774] = {.lex_state = 10},
  [775] = {.lex_state = 2},
  [776] = {.lex_state = 10},
  [777] = {.lex_state = 10},
  [778] = {.lex_state = 10},
  [779] = {.lex_state = 10},
  [780] = {.lex_state = 10},
  [781] = {.lex_state = 2},
  [782] = {.lex_state = 10},
  [783] = {.lex_state = 10},
  [784] = {.lex_state = 10},
  [785] = {.lex_state = 10},
  [786] = {.lex_state = 10},
  [787] = {.lex_state = 10},
  [788] = {.lex_state = 10},
  [789] = {.lex_state = 10},
  [790] = {.lex_state = 10},
  [791] = {.lex_state = 10},
  [792] = {.lex_state = 10},
  [793] = {.lex_state = 10},
  [794] = {.lex_state = 10},
  [795] = {.lex_state = 10},
  [796] = {.lex_state = 10},
  [797] = {.lex_state = 10},
  [798] = {.lex_state = 10},
  [799] = {.lex_state = 2},
  [800] = {.lex_state = 2},
  [801] = {.lex_state = 2},
  [802] = {.lex_state = 2},
  [803] = {.lex_state = 2},
  [804] = {.lex_state = 2},
  [805] = {.lex_state = 2},
  [806] = {.lex_state = 2},
  [807] = {.lex_state = 10},
  [808] = {.lex_state = 2},
  [809] = {.lex_state = 10},
  [810] = {.lex_state = 10},
  [811] = {.lex_state = 2},
  [812] = {.lex_state = 2},
  [813] = {.lex_state = 10},
  [814] = {.lex_state = 2},
  [815] = {.lex_state = 2},
  [816] = {.lex_state = 2},
  [817] = {.lex_state = 2},
  [818] = {.lex_state = 2},
  [819] = {.lex_state = 2},
  [820] = {.lex_state = 2},
  [821] = {.lex_state = 2},
  [822] = {.lex_state = 2},
  [823] = {.lex_state = 2},
  [824] = {.lex_state = 2},
  [825] = {.lex_state = 2},
  [826] = {.lex_state = 2},
  [827] = {.lex_state = 2},
  [828] = {.lex_state = 2},
  [829] = {.lex_state = 2},
  [830] = {.lex_state = 2},
  [831] = {.lex_state = 2},
  [832] = {.lex_state = 2},
  [833] = {.lex_state = 2},
  [834] = {.lex_state = 2},
  [835] = {.lex_state = 2},
  [836] = {.lex_state = 2},
  [837] = {.lex_state = 2},
  [838] = {.lex_state = 2},
  [839] = {.lex_state = 10},
  [840] = {.lex_state = 10},
  [841] = {.lex_state = 10},
  [842] = {.lex_state = 10},
  [843] = {.lex_state = 10},
  [844] = {.lex_state = 10},
  [845] = {.lex_state = 10},
  [846] = {.lex_state = 10},
  [847] = {.lex_state = 10},
  [848] = {.lex_state = 2},
  [849] = {.lex_state = 2},
  [850] = {.lex_state = 10},
  [851] = {.lex_state = 10},
  [852] = {.lex_state = 10},
  [853] = {.lex_state = 10},
  [854] = {.lex_state = 10},
  [855] = {.lex_state = 2},
  [856] = {.lex_state = 2},
  [857] = {.lex_state = 2},
  [858] = {.lex_state = 2},
  [859] = {.lex_state = 2},
  [860] = {.lex_state = 2},
  [861] = {.lex_state = 10},
  [862] = {.lex_state = 10},
  [863] = {.lex_state = 10},
  [864] = {.lex_state = 10},
  [865] = {.lex_state = 10},
  [866] = {.lex_state = 10},
  [867] = {.lex_state = 2},
  [868] = {.lex_state = 2},
  [869] = {.lex_state = 10},
  [870] = {.lex_state = 10},
  [871] = {.lex_state = 10},
  [872] = {.lex_state = 10},
  [873] = {.lex_state = 10},
  [874] = {.lex_state = 10},
  [875] = {.lex_state = 2},
  [876] = {.lex_state = 10},
  [877] = {.lex_state = 2},
  [878] = {.lex_state = 2},
  [879] = {.lex_state = 2},
  [880] = {.lex_state = 2},
  [881] = {.lex_state = 2},
  [882] = {.lex_state = 2},
  [883] = {.lex_state = 2},
  [884] = {.lex_state = 2},
  [885] = {.lex_state = 2},
  [886] = {.lex_state = 2},
  [887] = {.lex_state = 10},
  [888] = {.lex_state = 2},
  [889] = {.lex_state = 2},
  [890] = {.lex_state = 2},
  [891] = {.lex_state = 2},
  [892] = {.lex_state = 2},
  [893] = {.lex_state = 2},
  [894] = {.lex_state = 2},
  [895] = {.lex_state = 2},
  [896] = {.lex_state = 2},
  [897] = {.lex_state = 10},
  [898] = {.lex_state = 2},
  [899] = {.lex_state = 2},
  [900] = {.lex_state = 2},
  [901] = {.lex_state = 2},
  [902] = {.lex_state = 2},
  [903] = {.lex_state = 2},
  [904] = {.lex_state = 2},
  [905] = {.lex_state = 2},
  [906] = {.lex_state = 2},
  [907] = {.lex_state = 10},
  [908] = {.lex_state = 10},
  [909] = {.lex_state = 10},
  [910] = {.lex_state = 10},
  [911] = {.lex_state = 10},
  [912] = {.lex_state = 10},
  [913] = {.lex_state = 10},
  [914] = {.lex_state = 10},
  [915] = {.lex_state = 10},
  [916] = {.lex_state = 10},
  [917] = {.lex_state = 10},
  [918] = {.lex_state = 10},
  [919] = {.lex_state = 10},
  [920] = {.lex_state = 10},
  [921] = {.lex_state = 10},
  [922] = {.lex_state = 10},
  [923] = {.lex_state = 2},
  [924] = {.lex_state = 2},
  [925] = {.lex_state = 10},
  [926] = {.lex_state = 10},
  [927] = {.lex_state = 10},
  [928] = {.lex_state = 2},
  [929] = {.lex_state = 10},
  [930] = {.lex_state = 2},
  [931] = {.lex_state = 2},
  [932] = {.lex_state = 2},
  [933] = {.lex_state = 2},
  [934] = {.lex_state = 2},
  [935] = {.lex_state = 2},
  [936] = {.lex_state = 10},
  [937] = {.lex_state = 10},
  [938] = {.lex_state = 2},
  [939] = {.lex_state = 10},
  [940] = {.lex_state = 2},
  [941] = {.lex_state = 10},
  [942] = {.lex_state = 2},
  [943] = {.lex_state = 2},
  [944] = {.lex_state = 10},
  [945] = {.lex_state = 2},
  [946] = {.lex_state = 2},
  [947] = {.lex_state = 10},
  [948] = {.lex_state = 2},
  [949] = {.lex_state = 2},
  [950] = {.lex_state = 10},
  [951] = {.lex_state = 10},
  [952] = {.lex_state = 10},
  [953] = {.lex_state = 10},
  [954] = {.lex_state = 10},
  [955] = {.lex_state = 10},
  [956] = {.lex_state = 10},
  [957] = {.lex_state = 10},
  [958] = {.lex_state = 10},
  [959] = {.lex_state = 10},
  [960] = {.lex_state = 10},
  [961] = {.lex_state = 10},
  [962] = {.lex_state = 10},
  [963] = {.lex_state = 10},
  [964] = {.lex_state = 10},
  [965] = {.lex_state = 10},
  [966] = {.lex_state = 10},
  [967] = {.lex_state = 10},
  [968] = {.lex_state = 10},
  [969] = {.lex_state = 10},
  [970] = {.lex_state = 10},
  [971] = {.lex_state = 10},
  [972] = {.lex_state = 10},
  [973] = {.lex_state = 10},
  [974] = {.lex_state = 10},
  [975] = {.lex_state = 10},
  [976] = {.lex_state = 10},
  [977] = {.lex_state = 10},
  [978] = {.lex_state = 10},
  [979] = {.lex_state = 10},
  [980] = {.lex_state = 10},
  [981] = {.lex_state = 10},
  [982] = {.lex_state = 10},
  [983] = {.lex_state = 10},
  [984] = {.lex_state = 10},
  [985] = {.lex_state = 2},
  [986] = {.lex_state = 10},
  [987] = {.lex_state = 10},
  [988] = {.lex_state = 10},
  [989] = {.lex_state = 10},
  [990] = {.lex_state = 10},
  [991] = {.lex_state = 10},
  [992] = {.lex_state = 10},
  [993] = {.lex_state = 10},
  [994] = {.lex_state = 10},
  [995] = {.lex_state = 10},
  [996] = {.lex_state = 10},
  [997] = {.lex_state = 10},
  [998] = {.lex_state = 10},
  [999] = {.lex_state = 10},
  [1000] = {.lex_state = 10},
  [1001] = {.lex_state = 10},
  [1002] = {.lex_state = 10},
  [1003] = {.lex_state = 10},
  [1004] = {.lex_state = 10},
  [1005] = {.lex_state = 10},
  [1006] = {.lex_state = 10},
  [1007] = {.lex_state = 10},
  [1008] = {.lex_state = 10},
  [1009] = {.lex_state = 10},
  [1010] = {.lex_state = 10},
  [1011] = {.lex_state = 10},
  [1012] = {.lex_state = 10},
  [1013] = {.lex_state = 10},
  [1014] = {.lex_state = 10},
  [1015] = {.lex_state = 10},
  [1016] = {.lex_state = 10},
  [1017] = {.lex_state = 10},
  [1018] = {.lex_state = 10},
  [1019] = {.lex_state = 10},
  [1020] = {.lex_state = 10},
  [1021] = {.lex_state = 10},
  [1022] = {.lex_state = 10},
  [1023] = {.lex_state = 10},
  [1024] = {.lex_state = 10},
  [1025] = {.lex_state = 10},
  [1026] = {.lex_state = 10},
  [1027] = {.lex_state = 10},
  [1028] = {.lex_state = 10},
  [1029] = {.lex_state = 10},
  [1030] = {.lex_state = 10},
  [1031] = {.lex_state = 10},
  [1032] = {.lex_state = 10},
  [1033] = {.lex_state = 10},
  [1034] = {.lex_state = 10},
  [1035] = {.lex_state = 10},
  [1036] = {.lex_state = 10},
  [1037] = {.lex_state = 10},
  [1038] = {.lex_state = 10},
  [1039] = {.lex_state = 10},
  [1040] = {.lex_state = 10},
  [1041] = {.lex_state = 10},
  [1042] = {.lex_state = 80},
  [1043] = {.lex_state = 80},
  [1044] = {.lex_state = 80},
  [1045] = {.lex_state = 80},
  [1046] = {.lex_state = 80},
  [1047] = {.lex_state = 80},
  [1048] = {.lex_state = 80},
  [1049] = {.lex_state = 19},
  [1050] = {.lex_state = 19},
  [1051] = {.lex_state = 19},
  [1052] = {.lex_state = 19},
  [1053] = {.lex_state = 19},
  [1054] = {.lex_state = 19},
  [1055] = {.lex_state = 19},
  [1056] = {.lex_state = 19},
  [1057] = {.lex_state = 19},
  [1058] = {.lex_state = 19},
  [1059] = {.lex_state = 19},
  [1060] = {.lex_state = 19},
  [1061] = {.lex_state = 19},
  [1062] = {.lex_state = 19},
  [1063] = {.lex_state = 19},
  [1064] = {.lex_state = 19},
  [1065] = {.lex_state = 19},
  [1066] = {.lex_state = 19},
  [1067] = {.lex_state = 18},
  [1068] = {.lex_state = 17},
  [1069] = {.lex_state = 19},
  [1070] = {.lex_state = 17},
  [1071] = {.lex_state = 19},
  [1072] = {.lex_state = 19},
  [1073] = {.lex_state = 19},
  [1074] = {.lex_state = 19},
  [1075] = {.lex_state = 17},
  [1076] = {.lex_state = 19},
  [1077] = {.lex_state = 19},
  [1078] = {.lex_state = 19},
  [1079] = {.lex_state = 19},
  [1080] = {.lex_state = 19},
  [1081] = {.lex_state = 19},
  [1082] = {.lex_state = 19},
  [1083] = {.lex_state = 10},
  [1084] = {.lex_state = 19},
  [1085] = {.lex_state = 19},
  [1086] = {.lex_state = 19},
  [1087] = {.lex_state = 19},
  [1088] = {.lex_state = 19},
  [1089] = {.lex_state = 19},
  [1090] = {.lex_state = 19},
  [1091] = {.lex_state = 19},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 20},
  [1095] = {.lex_state = 20},
  [1096] = {.lex_state = 20},
  [1097] = {.lex_state = 20},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 20},
  [1100] = {.lex_state = 10},
  [1101] = {.lex_state = 20},
  [1102] = {.lex_state = 10},
  [1103] = {.lex_state = 20},
  [1104] = {.lex_state = 20},
  [1105] = {.lex_state = 10},
  [1106] = {.lex_state = 10},
  [1107] = {.lex_state = 10},
  [1108] = {.lex_state = 20},
  [1109] = {.lex_state = 10},
  [1110] = {.lex_state = 10},
  [1111] = {.lex_state = 20},
  [1112] = {.lex_state = 10},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 20},
  [1115] = {.lex_state = 19},
  [1116] = {.lex_state = 2},
  [1117] = {.lex_state = 10},
  [1118] = {.lex_state = 10},
  [1119] = {.lex_state = 10},
  [1120] = {.lex_state = 10},
  [1121] = {.lex_state = 10},
  [1122] = {.lex_state = 19},
  [1123] = {.lex_state = 19},
  [1124] = {.lex_state = 10},
  [1125] = {.lex_state = 10},
  [1126] = {.lex_state = 10},
  [1127] = {.lex_state = 10},
  [1128] = {.lex_state = 10},
  [1129] = {.lex_state = 10},
  [1130] = {.lex_state = 10},
  [1131] = {.lex_state = 10},
  [1132] = {.lex_state = 10},
  [1133] = {.lex_state = 10},
  [1134] = {.lex_state = 10},
  [1135] = {.lex_state = 10},
  [1136] = {.lex_state = 10},
  [1137] = {.lex_state = 19},
  [1138] = {.lex_state = 10},
  [1139] = {.lex_state = 19},
  [1140] = {.lex_state = 10},
  [1141] = {.lex_state = 10},
  [1142] = {.lex_state = 10},
  [1143] = {.lex_state = 10},
  [1144] = {.lex_state = 10},
  [1145] = {.lex_state = 10},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 19},
  [1148] = {.lex_state = 19},
  [1149] = {.lex_state = 10},
  [1150] = {.lex_state = 10},
  [1151] = {.lex_state = 10},
  [1152] = {.lex_state = 10},
  [1153] = {.lex_state = 19},
  [1154] = {.lex_state = 10},
  [1155] = {.lex_state = 10},
  [1156] = {.lex_state = 19},
  [1157] = {.lex_state = 10},
  [1158] = {.lex_state = 19},
  [1159] = {.lex_state = 10},
  [1160] = {.lex_state = 19},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 16},
  [1163] = {.lex_state = 15},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 10},
  [1166] = {.lex_state = 16},
  [1167] = {.lex_state = 16},
  [1168] = {.lex_state = 10},
  [1169] = {.lex_state = 16},
  [1170] = {.lex_state = 10},
  [1171] = {.lex_state = 16},
  [1172] = {.lex_state = 10},
  [1173] = {.lex_state = 16},
  [1174] = {.lex_state = 15},
  [1175] = {.lex_state = 16},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 2},
  [1178] = {.lex_state = 16},
  [1179] = {.lex_state = 16},
  [1180] = {.lex_state = 10},
  [1181] = {.lex_state = 16},
  [1182] = {.lex_state = 16},
  [1183] = {.lex_state = 15},
  [1184] = {.lex_state = 15},
  [1185] = {.lex_state = 16},
  [1186] = {.lex_state = 16},
  [1187] = {.lex_state = 16},
  [1188] = {.lex_state = 15},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 16},
  [1191] = {.lex_state = 16},
  [1192] = {.lex_state = 10},
  [1193] = {.lex_state = 10},
  [1194] = {.lex_state = 16},
  [1195] = {.lex_state = 10},
  [1196] = {.lex_state = 10},
  [1197] = {.lex_state = 10},
  [1198] = {.lex_state = 10},
  [1199] = {.lex_state = 10},
  [1200] = {.lex_state = 10},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 16},
  [1203] = {.lex_state = 16},
  [1204] = {.lex_state = 10},
  [1205] = {.lex_state = 16},
  [1206] = {.lex_state = 10},
  [1207] = {.lex_state = 10},
  [1208] = {.lex_state = 10},
  [1209] = {.lex_state = 16},
  [1210] = {.lex_state = 10},
  [1211] = {.lex_state = 16},
  [1212] = {.lex_state = 16},
  [1213] = {.lex_state = 10},
  [1214] = {.lex_state = 10},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 10},
  [1218] = {.lex_state = 10},
  [1219] = {.lex_state = 10},
  [1220] = {.lex_state = 10},
  [1221] = {.lex_state = 10},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 10},
  [1224] = {.lex_state = 10},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 10},
  [1228] = {.lex_state = 10},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 10},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 10},
  [1233] = {.lex_state = 10},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 10},
  [1236] = {.lex_state = 10},
  [1237] = {.lex_state = 10},
  [1238] = {.lex_state = 10},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 10},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 10},
  [1243] = {.lex_state = 10},
  [1244] = {.lex_state = 10},
  [1245] = {.lex_state = 10},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 10},
  [1251] = {.lex_state = 10},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 0},
  [1254] = {.lex_state = 10},
  [1255] = {.lex_state = 10},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 10},
  [1258] = {.lex_state = 0},
  [1259] = {.lex_state = 0},
  [1260] = {.lex_state = 10},
  [1261] = {.lex_state = 15},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 10},
  [1264] = {.lex_state = 16},
  [1265] = {.lex_state = 10},
  [1266] = {.lex_state = 10},
  [1267] = {.lex_state = 10},
  [1268] = {.lex_state = 10},
  [1269] = {.lex_state = 10},
  [1270] = {.lex_state = 10},
  [1271] = {.lex_state = 0},
  [1272] = {.lex_state = 0},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 22},
  [1275] = {.lex_state = 10},
  [1276] = {.lex_state = 10},
  [1277] = {.lex_state = 22},
  [1278] = {.lex_state = 10},
  [1279] = {.lex_state = 22},
  [1280] = {.lex_state = 0},
  [1281] = {.lex_state = 0},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 10},
  [1284] = {.lex_state = 0},
  [1285] = {.lex_state = 0},
  [1286] = {.lex_state = 0},
  [1287] = {.lex_state = 0},
  [1288] = {.lex_state = 10},
  [1289] = {.lex_state = 10},
  [1290] = {.lex_state = 10},
  [1291] = {.lex_state = 10},
  [1292] = {.lex_state = 10},
  [1293] = {.lex_state = 0},
  [1294] = {.lex_state = 10},
  [1295] = {.lex_state = 22},
  [1296] = {.lex_state = 10},
  [1297] = {.lex_state = 0},
  [1298] = {.lex_state = 0},
  [1299] = {.lex_state = 0},
  [1300] = {.lex_state = 0},
  [1301] = {.lex_state = 10},
  [1302] = {.lex_state = 0},
  [1303] = {.lex_state = 10},
  [1304] = {.lex_state = 10},
  [1305] = {.lex_state = 0},
  [1306] = {.lex_state = 10},
  [1307] = {.lex_state = 0},
  [1308] = {.lex_state = 10},
  [1309] = {.lex_state = 0},
  [1310] = {.lex_state = 0},
  [1311] = {.lex_state = 296},
  [1312] = {.lex_state = 0},
  [1313] = {.lex_state = 0},
  [1314] = {.lex_state = 0},
  [1315] = {.lex_state = 0},
  [1316] = {.lex_state = 10},
  [1317] = {.lex_state = 0},
  [1318] = {.lex_state = 0},
  [1319] = {.lex_state = 0},
  [1320] = {.lex_state = 0},
  [1321] = {.lex_state = 10},
  [1322] = {.lex_state = 0},
  [1323] = {.lex_state = 0},
  [1324] = {.lex_state = 0},
  [1325] = {.lex_state = 0},
  [1326] = {.lex_state = 0},
  [1327] = {.lex_state = 10},
  [1328] = {.lex_state = 10},
  [1329] = {.lex_state = 0},
  [1330] = {.lex_state = 0},
  [1331] = {.lex_state = 0},
  [1332] = {.lex_state = 0},
  [1333] = {.lex_state = 10},
  [1334] = {.lex_state = 0},
  [1335] = {.lex_state = 0},
  [1336] = {.lex_state = 0},
  [1337] = {.lex_state = 0},
  [1338] = {.lex_state = 0},
  [1339] = {.lex_state = 0},
  [1340] = {.lex_state = 10},
  [1341] = {.lex_state = 0},
  [1342] = {.lex_state = 10},
  [1343] = {.lex_state = 0},
  [1344] = {.lex_state = 0},
  [1345] = {.lex_state = 10},
  [1346] = {.lex_state = 10},
  [1347] = {.lex_state = 10},
  [1348] = {.lex_state = 0},
  [1349] = {.lex_state = 10},
  [1350] = {.lex_state = 0},
  [1351] = {.lex_state = 0},
  [1352] = {.lex_state = 0},
  [1353] = {.lex_state = 0},
  [1354] = {.lex_state = 0},
  [1355] = {.lex_state = 0},
  [1356] = {.lex_state = 10},
  [1357] = {.lex_state = 0},
  [1358] = {.lex_state = 0},
  [1359] = {.lex_state = 0},
  [1360] = {.lex_state = 10},
  [1361] = {.lex_state = 0},
  [1362] = {.lex_state = 0},
  [1363] = {.lex_state = 10},
  [1364] = {.lex_state = 0},
  [1365] = {.lex_state = 0},
  [1366] = {.lex_state = 10},
  [1367] = {.lex_state = 10},
  [1368] = {.lex_state = 0},
  [1369] = {.lex_state = 10},
  [1370] = {.lex_state = 0},
  [1371] = {.lex_state = 0},
  [1372] = {.lex_state = 10},
  [1373] = {.lex_state = 10},
  [1374] = {.lex_state = 0},
  [1375] = {.lex_state = 10},
  [1376] = {.lex_state = 10},
  [1377] = {.lex_state = 10},
  [1378] = {.lex_state = 0},
  [1379] = {.lex_state = 0},
  [1380] = {.lex_state = 0},
  [1381] = {.lex_state = 0},
  [1382] = {.lex_state = 0},
  [1383] = {.lex_state = 10},
  [1384] = {.lex_state = 0},
  [1385] = {.lex_state = 10},
  [1386] = {.lex_state = 10},
  [1387] = {.lex_state = 10},
  [1388] = {.lex_state = 10},
  [1389] = {.lex_state = 0},
  [1390] = {.lex_state = 0},
  [1391] = {.lex_state = 0},
  [1392] = {.lex_state = 0},
  [1393] = {.lex_state = 10},
  [1394] = {.lex_state = 0},
  [1395] = {.lex_state = 10},
  [1396] = {.lex_state = 10},
  [1397] = {.lex_state = 0},
  [1398] = {.lex_state = 10},
  [1399] = {.lex_state = 10},
  [1400] = {.lex_state = 10},
  [1401] = {.lex_state = 10},
  [1402] = {.lex_state = 10},
  [1403] = {.lex_state = 10},
  [1404] = {.lex_state = 0},
  [1405] = {.lex_state = 10},
  [1406] = {.lex_state = 10},
  [1407] = {.lex_state = 0},
  [1408] = {.lex_state = 0},
  [1409] = {.lex_state = 0},
  [1410] = {.lex_state = 0},
  [1411] = {.lex_state = 10},
  [1412] = {.lex_state = 10},
  [1413] = {.lex_state = 10},
  [1414] = {.lex_state = 10},
  [1415] = {.lex_state = 10},
  [1416] = {.lex_state = 10},
  [1417] = {.lex_state = 10},
  [1418] = {.lex_state = 0},
  [1419] = {.lex_state = 0},
  [1420] = {.lex_state = 0},
  [1421] = {.lex_state = 0},
  [1422] = {.lex_state = 0},
  [1423] = {.lex_state = 0},
  [1424] = {.lex_state = 0},
  [1425] = {.lex_state = 0},
  [1426] = {.lex_state = 0},
  [1427] = {.lex_state = 0},
  [1428] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_define] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_spec] = ACTIONS(1),
    [anon_sym_callback] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_bnot] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_div] = ACTIONS(1),
    [anon_sym_rem] = ACTIONS(1),
    [anon_sym_band] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_bor] = ACTIONS(1),
    [anon_sym_bxor] = ACTIONS(1),
    [anon_sym_bsl] = ACTIONS(1),
    [anon_sym_bsr] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_xor] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_EQ_LT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(1),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(1),
    [anon_sym_andalso] = ACTIONS(1),
    [anon_sym_orelse] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_fun] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_begin] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_receive] = ACTIONS(1),
    [anon_sym_after] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_maybe] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [aux_sym_integer_token1] = ACTIONS(1),
    [aux_sym_integer_token2] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_atom] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_variable] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_QMARK2] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_tripledot] = ACTIONS(1),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [1] = {
    [sym_source] = STATE(1408),
    [sym__statement] = STATE(1044),
    [sym_function] = STATE(1406),
    [sym__macro_declaration] = STATE(1405),
    [sym__spec] = STATE(1387),
    [sym_attribute] = STATE(1406),
    [sym__expression] = STATE(723),
    [sym__parenthesized_expression] = STATE(775),
    [sym_bitstring] = STATE(773),
    [sym_tuple] = STATE(746),
    [sym_list] = STATE(746),
    [sym_map] = STATE(773),
    [sym_record] = STATE(773),
    [sym_unary_operator] = STATE(746),
    [sym_binary_operator] = STATE(773),
    [sym__literal] = STATE(1252),
    [sym_anonymous_function] = STATE(746),
    [sym__named_stab_clause] = STATE(1260),
    [sym_call] = STATE(773),
    [sym__qualified_function] = STATE(1293),
    [sym__unqualified_function] = STATE(1300),
    [sym_function_capture] = STATE(773),
    [sym_function_type] = STATE(773),
    [sym_block] = STATE(773),
    [sym_if] = STATE(773),
    [sym_case] = STATE(773),
    [sym_receive] = STATE(773),
    [sym_try] = STATE(746),
    [sym_maybe] = STATE(773),
    [sym_character] = STATE(742),
    [sym__number] = STATE(775),
    [sym_integer] = STATE(741),
    [sym__identifier] = STATE(652),
    [sym__atom] = STATE(704),
    [sym_quoted_atom] = STATE(698),
    [sym_macro] = STATE(5),
    [sym__strings] = STATE(773),
    [sym_string] = STATE(686),
    [sym_comment] = STATE(1),
    [aux_sym_source_repeat2] = STATE(79),
    [aux_sym__strings_repeat1] = STATE(604),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LT_LT] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_POUND] = ACTIONS(19),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_not] = ACTIONS(21),
    [anon_sym_bnot] = ACTIONS(21),
    [anon_sym_catch] = ACTIONS(23),
    [anon_sym_fun] = ACTIONS(25),
    [anon_sym_begin] = ACTIONS(27),
    [anon_sym_case] = ACTIONS(29),
    [anon_sym_receive] = ACTIONS(31),
    [anon_sym_try] = ACTIONS(33),
    [anon_sym_maybe] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(37),
    [aux_sym_integer_token1] = ACTIONS(39),
    [aux_sym_integer_token2] = ACTIONS(41),
    [sym_float] = ACTIONS(43),
    [sym_atom] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym_variable] = ACTIONS(49),
    [anon_sym_QMARK] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_tripledot] = ACTIONS(55),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [2] = {
    [sym__expression] = STATE(632),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(3),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(2),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(57),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_RBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(57),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(73),
    [anon_sym_bnot] = ACTIONS(73),
    [anon_sym_catch] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(79),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [3] = {
    [sym__expression] = STATE(632),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(3),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(3),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(57),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_RBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(57),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(73),
    [anon_sym_bnot] = ACTIONS(73),
    [anon_sym_catch] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(79),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [4] = {
    [sym__expression] = STATE(771),
    [sym__parenthesized_expression] = STATE(559),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(529),
    [sym_list] = STATE(529),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(529),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1249),
    [sym_anonymous_function] = STATE(529),
    [sym_arguments] = STATE(1328),
    [sym__items] = STATE(1333),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(529),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(707),
    [sym__number] = STATE(559),
    [sym_integer] = STATE(706),
    [sym__identifier] = STATE(701),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(20),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(4),
    [aux_sym__strings_repeat1] = STATE(603),
    [anon_sym_COMMA] = ACTIONS(77),
    [anon_sym_DOT] = ACTIONS(111),
    [anon_sym_LF] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(117),
    [anon_sym_COLON] = ACTIONS(77),
    [anon_sym_when] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(120),
    [anon_sym_LBRACE] = ACTIONS(122),
    [anon_sym_LBRACK] = ACTIONS(124),
    [anon_sym_POUND] = ACTIONS(126),
    [anon_sym_PLUS] = ACTIONS(114),
    [anon_sym_not] = ACTIONS(129),
    [anon_sym_bnot] = ACTIONS(129),
    [anon_sym_catch] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(77),
    [anon_sym_div] = ACTIONS(77),
    [anon_sym_rem] = ACTIONS(77),
    [anon_sym_band] = ACTIONS(77),
    [anon_sym_and] = ACTIONS(77),
    [anon_sym_bor] = ACTIONS(77),
    [anon_sym_bxor] = ACTIONS(77),
    [anon_sym_bsl] = ACTIONS(77),
    [anon_sym_bsr] = ACTIONS(77),
    [anon_sym_or] = ACTIONS(77),
    [anon_sym_xor] = ACTIONS(77),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_EQ_EQ] = ACTIONS(77),
    [anon_sym_SLASH_EQ] = ACTIONS(77),
    [anon_sym_EQ_LT] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(77),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(77),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(77),
    [anon_sym_andalso] = ACTIONS(77),
    [anon_sym_orelse] = ACTIONS(77),
    [anon_sym_EQ] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_QMARK_EQ] = ACTIONS(77),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(77),
    [anon_sym_COLON_COLON] = ACTIONS(77),
    [anon_sym_PIPE] = ACTIONS(77),
    [anon_sym_LT_DASH] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(77),
    [anon_sym_EQ_GT] = ACTIONS(77),
    [anon_sym_COLON_EQ] = ACTIONS(77),
    [anon_sym_DASH_GT] = ACTIONS(77),
    [anon_sym_fun] = ACTIONS(133),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(135),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(93),
    [sym_float] = ACTIONS(137),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(139),
    [sym_variable] = ACTIONS(141),
    [anon_sym_QMARK] = ACTIONS(143),
    [anon_sym_DQUOTE] = ACTIONS(145),
    [sym_tripledot] = ACTIONS(147),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [5] = {
    [sym__expression] = STATE(812),
    [sym__parenthesized_expression] = STATE(905),
    [sym_bitstring] = STATE(773),
    [sym_tuple] = STATE(699),
    [sym_list] = STATE(699),
    [sym_map] = STATE(773),
    [sym_record] = STATE(773),
    [sym_unary_operator] = STATE(699),
    [sym_binary_operator] = STATE(773),
    [sym__literal] = STATE(1252),
    [sym_anonymous_function] = STATE(699),
    [sym_call] = STATE(773),
    [sym__qualified_function] = STATE(1293),
    [sym__unqualified_function] = STATE(1300),
    [sym_function_capture] = STATE(773),
    [sym_function_type] = STATE(773),
    [sym_block] = STATE(773),
    [sym_if] = STATE(773),
    [sym_case] = STATE(773),
    [sym_receive] = STATE(773),
    [sym_try] = STATE(699),
    [sym_maybe] = STATE(773),
    [sym_character] = STATE(742),
    [sym__number] = STATE(905),
    [sym_integer] = STATE(741),
    [sym__identifier] = STATE(710),
    [sym__atom] = STATE(704),
    [sym_quoted_atom] = STATE(698),
    [sym_macro] = STATE(19),
    [sym__strings] = STATE(773),
    [sym_string] = STATE(686),
    [sym_comment] = STATE(5),
    [aux_sym_function_repeat1] = STATE(1235),
    [aux_sym__strings_repeat1] = STATE(604),
    [anon_sym_COMMA] = ACTIONS(60),
    [anon_sym_DOT] = ACTIONS(151),
    [anon_sym_LF] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(77),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LT_LT] = ACTIONS(157),
    [anon_sym_LBRACE] = ACTIONS(159),
    [anon_sym_LBRACK] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(60),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(21),
    [anon_sym_bnot] = ACTIONS(21),
    [anon_sym_catch] = ACTIONS(23),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(60),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(60),
    [anon_sym_DASH_DASH] = ACTIONS(60),
    [anon_sym_EQ_EQ] = ACTIONS(60),
    [anon_sym_SLASH_EQ] = ACTIONS(60),
    [anon_sym_EQ_LT] = ACTIONS(60),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(60),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(60),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(60),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(60),
    [anon_sym_QMARK_EQ] = ACTIONS(60),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(60),
    [anon_sym_COLON_COLON] = ACTIONS(60),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(60),
    [anon_sym_LT_EQ] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(60),
    [anon_sym_COLON_EQ] = ACTIONS(60),
    [anon_sym_DASH_GT] = ACTIONS(60),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(27),
    [anon_sym_case] = ACTIONS(29),
    [anon_sym_receive] = ACTIONS(31),
    [anon_sym_try] = ACTIONS(33),
    [anon_sym_maybe] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [aux_sym_integer_token1] = ACTIONS(39),
    [aux_sym_integer_token2] = ACTIONS(39),
    [sym_float] = ACTIONS(167),
    [sym_atom] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(169),
    [sym_variable] = ACTIONS(171),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_tripledot] = ACTIONS(173),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [6] = {
    [sym__expression] = STATE(662),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(6),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(6),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(175),
    [anon_sym_bnot] = ACTIONS(175),
    [anon_sym_catch] = ACTIONS(60),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(177),
    [anon_sym_end] = ACTIONS(60),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_after] = ACTIONS(60),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [7] = {
    [sym__expression] = STATE(662),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(6),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(7),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(175),
    [anon_sym_bnot] = ACTIONS(175),
    [anon_sym_catch] = ACTIONS(60),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(177),
    [anon_sym_end] = ACTIONS(60),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_after] = ACTIONS(60),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [8] = {
    [sym__expression] = STATE(763),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(8),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(8),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(179),
    [anon_sym_bnot] = ACTIONS(179),
    [anon_sym_catch] = ACTIONS(181),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(183),
    [anon_sym_end] = ACTIONS(60),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_after] = ACTIONS(60),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [9] = {
    [sym__expression] = STATE(763),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(8),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(9),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(179),
    [anon_sym_bnot] = ACTIONS(179),
    [anon_sym_catch] = ACTIONS(181),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(183),
    [anon_sym_end] = ACTIONS(60),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_after] = ACTIONS(60),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [10] = {
    [sym__expression] = STATE(632),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(3),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(10),
    [aux_sym_function_repeat1] = STATE(1239),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_RPAREN] = ACTIONS(190),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(73),
    [anon_sym_bnot] = ACTIONS(73),
    [anon_sym_catch] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(79),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [11] = {
    [sym__expression] = STATE(676),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(12),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(11),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(194),
    [anon_sym_bnot] = ACTIONS(194),
    [anon_sym_catch] = ACTIONS(60),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(196),
    [anon_sym_end] = ACTIONS(60),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_of] = ACTIONS(60),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_after] = ACTIONS(60),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [12] = {
    [sym__expression] = STATE(676),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(12),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(12),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(194),
    [anon_sym_bnot] = ACTIONS(194),
    [anon_sym_catch] = ACTIONS(60),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(196),
    [anon_sym_end] = ACTIONS(60),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_of] = ACTIONS(60),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_after] = ACTIONS(60),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [13] = {
    [sym__expression] = STATE(632),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(3),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(13),
    [aux_sym_function_repeat1] = STATE(1239),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(73),
    [anon_sym_bnot] = ACTIONS(73),
    [anon_sym_catch] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(79),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [14] = {
    [sym__expression] = STATE(807),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(14),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(14),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(198),
    [anon_sym_bnot] = ACTIONS(198),
    [anon_sym_catch] = ACTIONS(200),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(202),
    [anon_sym_end] = ACTIONS(60),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [15] = {
    [sym__expression] = STATE(768),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1249),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(707),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(706),
    [sym__identifier] = STATE(743),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(15),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(15),
    [aux_sym__strings_repeat1] = STATE(603),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(60),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(129),
    [anon_sym_bnot] = ACTIONS(129),
    [anon_sym_catch] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(204),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [16] = {
    [sym__expression] = STATE(812),
    [sym__parenthesized_expression] = STATE(905),
    [sym_bitstring] = STATE(773),
    [sym_tuple] = STATE(699),
    [sym_list] = STATE(699),
    [sym_map] = STATE(773),
    [sym_record] = STATE(773),
    [sym_unary_operator] = STATE(699),
    [sym_binary_operator] = STATE(773),
    [sym__literal] = STATE(1252),
    [sym_anonymous_function] = STATE(699),
    [sym_call] = STATE(773),
    [sym__qualified_function] = STATE(1293),
    [sym__unqualified_function] = STATE(1300),
    [sym_function_capture] = STATE(773),
    [sym_function_type] = STATE(773),
    [sym_block] = STATE(773),
    [sym_if] = STATE(773),
    [sym_case] = STATE(773),
    [sym_receive] = STATE(773),
    [sym_try] = STATE(699),
    [sym_maybe] = STATE(773),
    [sym_character] = STATE(742),
    [sym__number] = STATE(905),
    [sym_integer] = STATE(741),
    [sym__identifier] = STATE(710),
    [sym__atom] = STATE(704),
    [sym_quoted_atom] = STATE(698),
    [sym_macro] = STATE(19),
    [sym__strings] = STATE(773),
    [sym_string] = STATE(686),
    [sym_comment] = STATE(16),
    [aux_sym__strings_repeat1] = STATE(604),
    [anon_sym_COMMA] = ACTIONS(60),
    [anon_sym_DOT] = ACTIONS(60),
    [anon_sym_LF] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(77),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LT_LT] = ACTIONS(157),
    [anon_sym_LBRACE] = ACTIONS(159),
    [anon_sym_LBRACK] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(60),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(21),
    [anon_sym_bnot] = ACTIONS(21),
    [anon_sym_catch] = ACTIONS(23),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(60),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(60),
    [anon_sym_DASH_DASH] = ACTIONS(60),
    [anon_sym_EQ_EQ] = ACTIONS(60),
    [anon_sym_SLASH_EQ] = ACTIONS(60),
    [anon_sym_EQ_LT] = ACTIONS(60),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(60),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(60),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(60),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(60),
    [anon_sym_QMARK_EQ] = ACTIONS(60),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(60),
    [anon_sym_COLON_COLON] = ACTIONS(60),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(60),
    [anon_sym_LT_EQ] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(60),
    [anon_sym_COLON_EQ] = ACTIONS(60),
    [anon_sym_DASH_GT] = ACTIONS(60),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(27),
    [anon_sym_case] = ACTIONS(29),
    [anon_sym_receive] = ACTIONS(31),
    [anon_sym_try] = ACTIONS(33),
    [anon_sym_maybe] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [aux_sym_integer_token1] = ACTIONS(39),
    [aux_sym_integer_token2] = ACTIONS(39),
    [sym_float] = ACTIONS(167),
    [sym_atom] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(169),
    [sym_variable] = ACTIONS(171),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_tripledot] = ACTIONS(173),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [17] = {
    [sym__expression] = STATE(807),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(14),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(17),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(198),
    [anon_sym_bnot] = ACTIONS(198),
    [anon_sym_catch] = ACTIONS(200),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(202),
    [anon_sym_end] = ACTIONS(60),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [18] = {
    [sym__expression] = STATE(777),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(21),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(18),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(206),
    [anon_sym_bnot] = ACTIONS(206),
    [anon_sym_catch] = ACTIONS(208),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(210),
    [anon_sym_end] = ACTIONS(60),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_else] = ACTIONS(60),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [19] = {
    [sym__expression] = STATE(812),
    [sym__parenthesized_expression] = STATE(905),
    [sym_bitstring] = STATE(773),
    [sym_tuple] = STATE(699),
    [sym_list] = STATE(699),
    [sym_map] = STATE(773),
    [sym_record] = STATE(773),
    [sym_unary_operator] = STATE(699),
    [sym_binary_operator] = STATE(773),
    [sym__literal] = STATE(1252),
    [sym_anonymous_function] = STATE(699),
    [sym_call] = STATE(773),
    [sym__qualified_function] = STATE(1293),
    [sym__unqualified_function] = STATE(1300),
    [sym_function_capture] = STATE(773),
    [sym_function_type] = STATE(773),
    [sym_block] = STATE(773),
    [sym_if] = STATE(773),
    [sym_case] = STATE(773),
    [sym_receive] = STATE(773),
    [sym_try] = STATE(699),
    [sym_maybe] = STATE(773),
    [sym_character] = STATE(742),
    [sym__number] = STATE(905),
    [sym_integer] = STATE(741),
    [sym__identifier] = STATE(710),
    [sym__atom] = STATE(704),
    [sym_quoted_atom] = STATE(698),
    [sym_macro] = STATE(19),
    [sym__strings] = STATE(773),
    [sym_string] = STATE(686),
    [sym_comment] = STATE(19),
    [aux_sym__strings_repeat1] = STATE(604),
    [anon_sym_COMMA] = ACTIONS(60),
    [anon_sym_DOT] = ACTIONS(60),
    [anon_sym_LF] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(60),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LT_LT] = ACTIONS(157),
    [anon_sym_LBRACE] = ACTIONS(159),
    [anon_sym_LBRACK] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(60),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(21),
    [anon_sym_bnot] = ACTIONS(21),
    [anon_sym_catch] = ACTIONS(23),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(60),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(60),
    [anon_sym_DASH_DASH] = ACTIONS(60),
    [anon_sym_EQ_EQ] = ACTIONS(60),
    [anon_sym_SLASH_EQ] = ACTIONS(60),
    [anon_sym_EQ_LT] = ACTIONS(60),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(60),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(60),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(60),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(60),
    [anon_sym_QMARK_EQ] = ACTIONS(60),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(60),
    [anon_sym_COLON_COLON] = ACTIONS(60),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(60),
    [anon_sym_LT_EQ] = ACTIONS(60),
    [anon_sym_EQ_GT] = ACTIONS(60),
    [anon_sym_COLON_EQ] = ACTIONS(60),
    [anon_sym_DASH_GT] = ACTIONS(60),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(27),
    [anon_sym_case] = ACTIONS(29),
    [anon_sym_receive] = ACTIONS(31),
    [anon_sym_try] = ACTIONS(33),
    [anon_sym_maybe] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [aux_sym_integer_token1] = ACTIONS(39),
    [aux_sym_integer_token2] = ACTIONS(39),
    [sym_float] = ACTIONS(167),
    [sym_atom] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(169),
    [sym_variable] = ACTIONS(171),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_tripledot] = ACTIONS(173),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [20] = {
    [sym__expression] = STATE(768),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1249),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(707),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(706),
    [sym__identifier] = STATE(743),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(15),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(20),
    [aux_sym__strings_repeat1] = STATE(603),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(60),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(129),
    [anon_sym_bnot] = ACTIONS(129),
    [anon_sym_catch] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(204),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [21] = {
    [sym__expression] = STATE(777),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(21),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(21),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(206),
    [anon_sym_bnot] = ACTIONS(206),
    [anon_sym_catch] = ACTIONS(208),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(210),
    [anon_sym_end] = ACTIONS(60),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_else] = ACTIONS(60),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [22] = {
    [sym__expression] = STATE(1009),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(22),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(22),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(212),
    [anon_sym_bnot] = ACTIONS(212),
    [anon_sym_catch] = ACTIONS(214),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(216),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_of] = ACTIONS(60),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [23] = {
    [sym__expression] = STATE(1009),
    [sym__parenthesized_expression] = STATE(595),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(535),
    [sym_list] = STATE(535),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(535),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(535),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(535),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(595),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(558),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(22),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(23),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_DASH] = ACTIONS(60),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_COLON] = ACTIONS(60),
    [anon_sym_when] = ACTIONS(60),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_PLUS] = ACTIONS(60),
    [anon_sym_not] = ACTIONS(212),
    [anon_sym_bnot] = ACTIONS(212),
    [anon_sym_catch] = ACTIONS(214),
    [anon_sym_SLASH] = ACTIONS(60),
    [anon_sym_STAR] = ACTIONS(57),
    [anon_sym_div] = ACTIONS(60),
    [anon_sym_rem] = ACTIONS(60),
    [anon_sym_band] = ACTIONS(60),
    [anon_sym_and] = ACTIONS(60),
    [anon_sym_bor] = ACTIONS(60),
    [anon_sym_bxor] = ACTIONS(60),
    [anon_sym_bsl] = ACTIONS(60),
    [anon_sym_bsr] = ACTIONS(60),
    [anon_sym_or] = ACTIONS(60),
    [anon_sym_xor] = ACTIONS(60),
    [anon_sym_PLUS_PLUS] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_SLASH_EQ] = ACTIONS(57),
    [anon_sym_EQ_LT] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(60),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(60),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(57),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(57),
    [anon_sym_andalso] = ACTIONS(60),
    [anon_sym_orelse] = ACTIONS(60),
    [anon_sym_EQ] = ACTIONS(60),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_QMARK_EQ] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_COLON_COLON] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(60),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_COLON_EQ] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(216),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_of] = ACTIONS(60),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [24] = {
    [sym_arguments] = STATE(26),
    [sym_comment] = STATE(24),
    [anon_sym_COMMA] = ACTIONS(218),
    [anon_sym_DOT] = ACTIONS(220),
    [anon_sym_SEMI] = ACTIONS(218),
    [anon_sym_DASH] = ACTIONS(220),
    [anon_sym_LPAREN] = ACTIONS(222),
    [anon_sym_RPAREN] = ACTIONS(218),
    [anon_sym_COLON] = ACTIONS(220),
    [anon_sym_when] = ACTIONS(220),
    [anon_sym_if] = ACTIONS(220),
    [anon_sym_LT_LT] = ACTIONS(218),
    [anon_sym_GT_GT] = ACTIONS(218),
    [anon_sym_LBRACE] = ACTIONS(218),
    [anon_sym_RBRACE] = ACTIONS(218),
    [anon_sym_LBRACK] = ACTIONS(218),
    [anon_sym_RBRACK] = ACTIONS(218),
    [anon_sym_POUND] = ACTIONS(218),
    [anon_sym_PLUS] = ACTIONS(220),
    [anon_sym_not] = ACTIONS(220),
    [anon_sym_bnot] = ACTIONS(220),
    [anon_sym_catch] = ACTIONS(220),
    [anon_sym_SLASH] = ACTIONS(220),
    [anon_sym_STAR] = ACTIONS(218),
    [anon_sym_div] = ACTIONS(220),
    [anon_sym_rem] = ACTIONS(220),
    [anon_sym_band] = ACTIONS(220),
    [anon_sym_and] = ACTIONS(220),
    [anon_sym_bor] = ACTIONS(220),
    [anon_sym_bxor] = ACTIONS(220),
    [anon_sym_bsl] = ACTIONS(220),
    [anon_sym_bsr] = ACTIONS(220),
    [anon_sym_or] = ACTIONS(220),
    [anon_sym_xor] = ACTIONS(220),
    [anon_sym_PLUS_PLUS] = ACTIONS(218),
    [anon_sym_DASH_DASH] = ACTIONS(218),
    [anon_sym_EQ_EQ] = ACTIONS(218),
    [anon_sym_SLASH_EQ] = ACTIONS(218),
    [anon_sym_EQ_LT] = ACTIONS(218),
    [anon_sym_LT] = ACTIONS(220),
    [anon_sym_GT_EQ] = ACTIONS(218),
    [anon_sym_GT] = ACTIONS(220),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(218),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(218),
    [anon_sym_andalso] = ACTIONS(220),
    [anon_sym_orelse] = ACTIONS(220),
    [anon_sym_EQ] = ACTIONS(220),
    [anon_sym_BANG] = ACTIONS(218),
    [anon_sym_QMARK_EQ] = ACTIONS(218),
    [anon_sym_DOT_DOT] = ACTIONS(220),
    [anon_sym_PIPE_PIPE] = ACTIONS(218),
    [anon_sym_COLON_COLON] = ACTIONS(218),
    [anon_sym_PIPE] = ACTIONS(220),
    [anon_sym_LT_DASH] = ACTIONS(218),
    [anon_sym_LT_EQ] = ACTIONS(218),
    [anon_sym_EQ_GT] = ACTIONS(218),
    [anon_sym_COLON_EQ] = ACTIONS(218),
    [anon_sym_DASH_GT] = ACTIONS(218),
    [anon_sym_fun] = ACTIONS(220),
    [anon_sym_begin] = ACTIONS(220),
    [anon_sym_case] = ACTIONS(220),
    [anon_sym_receive] = ACTIONS(220),
    [anon_sym_try] = ACTIONS(220),
    [anon_sym_maybe] = ACTIONS(220),
    [anon_sym_DOLLAR] = ACTIONS(218),
    [aux_sym_integer_token1] = ACTIONS(220),
    [aux_sym_integer_token2] = ACTIONS(218),
    [sym_float] = ACTIONS(218),
    [sym_atom] = ACTIONS(220),
    [anon_sym_SQUOTE] = ACTIONS(218),
    [sym_variable] = ACTIONS(218),
    [anon_sym_QMARK] = ACTIONS(220),
    [anon_sym_DQUOTE] = ACTIONS(218),
    [sym_tripledot] = ACTIONS(218),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [25] = {
    [sym_arguments] = STATE(28),
    [sym_comment] = STATE(25),
    [anon_sym_COMMA] = ACTIONS(224),
    [anon_sym_DOT] = ACTIONS(226),
    [anon_sym_SEMI] = ACTIONS(224),
    [anon_sym_DASH] = ACTIONS(226),
    [anon_sym_LPAREN] = ACTIONS(222),
    [anon_sym_RPAREN] = ACTIONS(224),
    [anon_sym_COLON] = ACTIONS(226),
    [anon_sym_when] = ACTIONS(226),
    [anon_sym_if] = ACTIONS(226),
    [anon_sym_LT_LT] = ACTIONS(224),
    [anon_sym_GT_GT] = ACTIONS(224),
    [anon_sym_LBRACE] = ACTIONS(224),
    [anon_sym_RBRACE] = ACTIONS(224),
    [anon_sym_LBRACK] = ACTIONS(224),
    [anon_sym_RBRACK] = ACTIONS(224),
    [anon_sym_POUND] = ACTIONS(224),
    [anon_sym_PLUS] = ACTIONS(226),
    [anon_sym_not] = ACTIONS(226),
    [anon_sym_bnot] = ACTIONS(226),
    [anon_sym_catch] = ACTIONS(226),
    [anon_sym_SLASH] = ACTIONS(226),
    [anon_sym_STAR] = ACTIONS(224),
    [anon_sym_div] = ACTIONS(226),
    [anon_sym_rem] = ACTIONS(226),
    [anon_sym_band] = ACTIONS(226),
    [anon_sym_and] = ACTIONS(226),
    [anon_sym_bor] = ACTIONS(226),
    [anon_sym_bxor] = ACTIONS(226),
    [anon_sym_bsl] = ACTIONS(226),
    [anon_sym_bsr] = ACTIONS(226),
    [anon_sym_or] = ACTIONS(226),
    [anon_sym_xor] = ACTIONS(226),
    [anon_sym_PLUS_PLUS] = ACTIONS(224),
    [anon_sym_DASH_DASH] = ACTIONS(224),
    [anon_sym_EQ_EQ] = ACTIONS(224),
    [anon_sym_SLASH_EQ] = ACTIONS(224),
    [anon_sym_EQ_LT] = ACTIONS(224),
    [anon_sym_LT] = ACTIONS(226),
    [anon_sym_GT_EQ] = ACTIONS(224),
    [anon_sym_GT] = ACTIONS(226),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(224),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(224),
    [anon_sym_andalso] = ACTIONS(226),
    [anon_sym_orelse] = ACTIONS(226),
    [anon_sym_EQ] = ACTIONS(226),
    [anon_sym_BANG] = ACTIONS(224),
    [anon_sym_QMARK_EQ] = ACTIONS(224),
    [anon_sym_DOT_DOT] = ACTIONS(226),
    [anon_sym_PIPE_PIPE] = ACTIONS(224),
    [anon_sym_COLON_COLON] = ACTIONS(224),
    [anon_sym_PIPE] = ACTIONS(226),
    [anon_sym_LT_DASH] = ACTIONS(224),
    [anon_sym_LT_EQ] = ACTIONS(224),
    [anon_sym_EQ_GT] = ACTIONS(224),
    [anon_sym_COLON_EQ] = ACTIONS(224),
    [anon_sym_DASH_GT] = ACTIONS(224),
    [anon_sym_fun] = ACTIONS(226),
    [anon_sym_begin] = ACTIONS(226),
    [anon_sym_case] = ACTIONS(226),
    [anon_sym_receive] = ACTIONS(226),
    [anon_sym_try] = ACTIONS(226),
    [anon_sym_maybe] = ACTIONS(226),
    [anon_sym_DOLLAR] = ACTIONS(224),
    [aux_sym_integer_token1] = ACTIONS(226),
    [aux_sym_integer_token2] = ACTIONS(224),
    [sym_float] = ACTIONS(224),
    [sym_atom] = ACTIONS(226),
    [anon_sym_SQUOTE] = ACTIONS(224),
    [sym_variable] = ACTIONS(224),
    [anon_sym_QMARK] = ACTIONS(226),
    [anon_sym_DQUOTE] = ACTIONS(224),
    [sym_tripledot] = ACTIONS(224),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [26] = {
    [sym_comment] = STATE(26),
    [anon_sym_COMMA] = ACTIONS(228),
    [anon_sym_DOT] = ACTIONS(230),
    [anon_sym_SEMI] = ACTIONS(228),
    [anon_sym_DASH] = ACTIONS(230),
    [anon_sym_LPAREN] = ACTIONS(228),
    [anon_sym_RPAREN] = ACTIONS(228),
    [anon_sym_COLON] = ACTIONS(230),
    [anon_sym_when] = ACTIONS(230),
    [anon_sym_if] = ACTIONS(230),
    [anon_sym_LT_LT] = ACTIONS(228),
    [anon_sym_GT_GT] = ACTIONS(228),
    [anon_sym_LBRACE] = ACTIONS(228),
    [anon_sym_RBRACE] = ACTIONS(228),
    [anon_sym_LBRACK] = ACTIONS(228),
    [anon_sym_RBRACK] = ACTIONS(228),
    [anon_sym_POUND] = ACTIONS(228),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_not] = ACTIONS(230),
    [anon_sym_bnot] = ACTIONS(230),
    [anon_sym_catch] = ACTIONS(230),
    [anon_sym_SLASH] = ACTIONS(230),
    [anon_sym_STAR] = ACTIONS(228),
    [anon_sym_div] = ACTIONS(230),
    [anon_sym_rem] = ACTIONS(230),
    [anon_sym_band] = ACTIONS(230),
    [anon_sym_and] = ACTIONS(230),
    [anon_sym_bor] = ACTIONS(230),
    [anon_sym_bxor] = ACTIONS(230),
    [anon_sym_bsl] = ACTIONS(230),
    [anon_sym_bsr] = ACTIONS(230),
    [anon_sym_or] = ACTIONS(230),
    [anon_sym_xor] = ACTIONS(230),
    [anon_sym_PLUS_PLUS] = ACTIONS(228),
    [anon_sym_DASH_DASH] = ACTIONS(228),
    [anon_sym_EQ_EQ] = ACTIONS(228),
    [anon_sym_SLASH_EQ] = ACTIONS(228),
    [anon_sym_EQ_LT] = ACTIONS(228),
    [anon_sym_LT] = ACTIONS(230),
    [anon_sym_GT_EQ] = ACTIONS(228),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(228),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(228),
    [anon_sym_andalso] = ACTIONS(230),
    [anon_sym_orelse] = ACTIONS(230),
    [anon_sym_EQ] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(228),
    [anon_sym_QMARK_EQ] = ACTIONS(228),
    [anon_sym_DOT_DOT] = ACTIONS(230),
    [anon_sym_PIPE_PIPE] = ACTIONS(228),
    [anon_sym_COLON_COLON] = ACTIONS(228),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_LT_DASH] = ACTIONS(228),
    [anon_sym_LT_EQ] = ACTIONS(228),
    [anon_sym_EQ_GT] = ACTIONS(228),
    [anon_sym_COLON_EQ] = ACTIONS(228),
    [anon_sym_DASH_GT] = ACTIONS(228),
    [anon_sym_fun] = ACTIONS(230),
    [anon_sym_begin] = ACTIONS(230),
    [anon_sym_case] = ACTIONS(230),
    [anon_sym_receive] = ACTIONS(230),
    [anon_sym_try] = ACTIONS(230),
    [anon_sym_maybe] = ACTIONS(230),
    [anon_sym_DOLLAR] = ACTIONS(228),
    [aux_sym_integer_token1] = ACTIONS(230),
    [aux_sym_integer_token2] = ACTIONS(228),
    [sym_float] = ACTIONS(228),
    [sym_atom] = ACTIONS(230),
    [anon_sym_SQUOTE] = ACTIONS(228),
    [sym_variable] = ACTIONS(228),
    [anon_sym_QMARK] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(228),
    [sym_tripledot] = ACTIONS(228),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [27] = {
    [sym_comment] = STATE(27),
    [anon_sym_COMMA] = ACTIONS(232),
    [anon_sym_DOT] = ACTIONS(234),
    [anon_sym_SEMI] = ACTIONS(232),
    [anon_sym_DASH] = ACTIONS(234),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(232),
    [anon_sym_COLON] = ACTIONS(234),
    [anon_sym_when] = ACTIONS(234),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_LT_LT] = ACTIONS(232),
    [anon_sym_GT_GT] = ACTIONS(232),
    [anon_sym_LBRACE] = ACTIONS(232),
    [anon_sym_RBRACE] = ACTIONS(232),
    [anon_sym_LBRACK] = ACTIONS(232),
    [anon_sym_RBRACK] = ACTIONS(232),
    [anon_sym_POUND] = ACTIONS(232),
    [anon_sym_PLUS] = ACTIONS(234),
    [anon_sym_not] = ACTIONS(234),
    [anon_sym_bnot] = ACTIONS(234),
    [anon_sym_catch] = ACTIONS(234),
    [anon_sym_SLASH] = ACTIONS(234),
    [anon_sym_STAR] = ACTIONS(232),
    [anon_sym_div] = ACTIONS(234),
    [anon_sym_rem] = ACTIONS(234),
    [anon_sym_band] = ACTIONS(234),
    [anon_sym_and] = ACTIONS(234),
    [anon_sym_bor] = ACTIONS(234),
    [anon_sym_bxor] = ACTIONS(234),
    [anon_sym_bsl] = ACTIONS(234),
    [anon_sym_bsr] = ACTIONS(234),
    [anon_sym_or] = ACTIONS(234),
    [anon_sym_xor] = ACTIONS(234),
    [anon_sym_PLUS_PLUS] = ACTIONS(232),
    [anon_sym_DASH_DASH] = ACTIONS(232),
    [anon_sym_EQ_EQ] = ACTIONS(232),
    [anon_sym_SLASH_EQ] = ACTIONS(232),
    [anon_sym_EQ_LT] = ACTIONS(232),
    [anon_sym_LT] = ACTIONS(234),
    [anon_sym_GT_EQ] = ACTIONS(232),
    [anon_sym_GT] = ACTIONS(234),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(232),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(232),
    [anon_sym_andalso] = ACTIONS(234),
    [anon_sym_orelse] = ACTIONS(234),
    [anon_sym_EQ] = ACTIONS(234),
    [anon_sym_BANG] = ACTIONS(232),
    [anon_sym_QMARK_EQ] = ACTIONS(232),
    [anon_sym_DOT_DOT] = ACTIONS(234),
    [anon_sym_PIPE_PIPE] = ACTIONS(232),
    [anon_sym_COLON_COLON] = ACTIONS(232),
    [anon_sym_PIPE] = ACTIONS(234),
    [anon_sym_LT_DASH] = ACTIONS(232),
    [anon_sym_LT_EQ] = ACTIONS(232),
    [anon_sym_EQ_GT] = ACTIONS(232),
    [anon_sym_COLON_EQ] = ACTIONS(232),
    [anon_sym_DASH_GT] = ACTIONS(232),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_begin] = ACTIONS(234),
    [anon_sym_case] = ACTIONS(234),
    [anon_sym_receive] = ACTIONS(234),
    [anon_sym_try] = ACTIONS(234),
    [anon_sym_maybe] = ACTIONS(234),
    [anon_sym_DOLLAR] = ACTIONS(232),
    [aux_sym_integer_token1] = ACTIONS(234),
    [aux_sym_integer_token2] = ACTIONS(232),
    [sym_float] = ACTIONS(232),
    [sym_atom] = ACTIONS(234),
    [anon_sym_SQUOTE] = ACTIONS(232),
    [sym_variable] = ACTIONS(232),
    [anon_sym_QMARK] = ACTIONS(234),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [sym_tripledot] = ACTIONS(232),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [28] = {
    [sym_comment] = STATE(28),
    [anon_sym_COMMA] = ACTIONS(236),
    [anon_sym_DOT] = ACTIONS(238),
    [anon_sym_SEMI] = ACTIONS(236),
    [anon_sym_DASH] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(236),
    [anon_sym_RPAREN] = ACTIONS(236),
    [anon_sym_COLON] = ACTIONS(238),
    [anon_sym_when] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_LT_LT] = ACTIONS(236),
    [anon_sym_GT_GT] = ACTIONS(236),
    [anon_sym_LBRACE] = ACTIONS(236),
    [anon_sym_RBRACE] = ACTIONS(236),
    [anon_sym_LBRACK] = ACTIONS(236),
    [anon_sym_RBRACK] = ACTIONS(236),
    [anon_sym_POUND] = ACTIONS(236),
    [anon_sym_PLUS] = ACTIONS(238),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_bnot] = ACTIONS(238),
    [anon_sym_catch] = ACTIONS(238),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_STAR] = ACTIONS(236),
    [anon_sym_div] = ACTIONS(238),
    [anon_sym_rem] = ACTIONS(238),
    [anon_sym_band] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_bor] = ACTIONS(238),
    [anon_sym_bxor] = ACTIONS(238),
    [anon_sym_bsl] = ACTIONS(238),
    [anon_sym_bsr] = ACTIONS(238),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_xor] = ACTIONS(238),
    [anon_sym_PLUS_PLUS] = ACTIONS(236),
    [anon_sym_DASH_DASH] = ACTIONS(236),
    [anon_sym_EQ_EQ] = ACTIONS(236),
    [anon_sym_SLASH_EQ] = ACTIONS(236),
    [anon_sym_EQ_LT] = ACTIONS(236),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_GT_EQ] = ACTIONS(236),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(236),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(236),
    [anon_sym_andalso] = ACTIONS(238),
    [anon_sym_orelse] = ACTIONS(238),
    [anon_sym_EQ] = ACTIONS(238),
    [anon_sym_BANG] = ACTIONS(236),
    [anon_sym_QMARK_EQ] = ACTIONS(236),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_PIPE_PIPE] = ACTIONS(236),
    [anon_sym_COLON_COLON] = ACTIONS(236),
    [anon_sym_PIPE] = ACTIONS(238),
    [anon_sym_LT_DASH] = ACTIONS(236),
    [anon_sym_LT_EQ] = ACTIONS(236),
    [anon_sym_EQ_GT] = ACTIONS(236),
    [anon_sym_COLON_EQ] = ACTIONS(236),
    [anon_sym_DASH_GT] = ACTIONS(236),
    [anon_sym_fun] = ACTIONS(238),
    [anon_sym_begin] = ACTIONS(238),
    [anon_sym_case] = ACTIONS(238),
    [anon_sym_receive] = ACTIONS(238),
    [anon_sym_try] = ACTIONS(238),
    [anon_sym_maybe] = ACTIONS(238),
    [anon_sym_DOLLAR] = ACTIONS(236),
    [aux_sym_integer_token1] = ACTIONS(238),
    [aux_sym_integer_token2] = ACTIONS(236),
    [sym_float] = ACTIONS(236),
    [sym_atom] = ACTIONS(238),
    [anon_sym_SQUOTE] = ACTIONS(236),
    [sym_variable] = ACTIONS(236),
    [anon_sym_QMARK] = ACTIONS(238),
    [anon_sym_DQUOTE] = ACTIONS(236),
    [sym_tripledot] = ACTIONS(236),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [29] = {
    [sym_comment] = STATE(29),
    [anon_sym_COMMA] = ACTIONS(240),
    [anon_sym_DOT] = ACTIONS(242),
    [anon_sym_SEMI] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(242),
    [anon_sym_LPAREN] = ACTIONS(240),
    [anon_sym_RPAREN] = ACTIONS(240),
    [anon_sym_COLON] = ACTIONS(242),
    [anon_sym_when] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_GT_GT] = ACTIONS(240),
    [anon_sym_LBRACE] = ACTIONS(240),
    [anon_sym_RBRACE] = ACTIONS(240),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_RBRACK] = ACTIONS(240),
    [anon_sym_POUND] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(242),
    [anon_sym_not] = ACTIONS(242),
    [anon_sym_bnot] = ACTIONS(242),
    [anon_sym_catch] = ACTIONS(242),
    [anon_sym_SLASH] = ACTIONS(242),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_div] = ACTIONS(242),
    [anon_sym_rem] = ACTIONS(242),
    [anon_sym_band] = ACTIONS(242),
    [anon_sym_and] = ACTIONS(242),
    [anon_sym_bor] = ACTIONS(242),
    [anon_sym_bxor] = ACTIONS(242),
    [anon_sym_bsl] = ACTIONS(242),
    [anon_sym_bsr] = ACTIONS(242),
    [anon_sym_or] = ACTIONS(242),
    [anon_sym_xor] = ACTIONS(242),
    [anon_sym_PLUS_PLUS] = ACTIONS(240),
    [anon_sym_DASH_DASH] = ACTIONS(240),
    [anon_sym_EQ_EQ] = ACTIONS(240),
    [anon_sym_SLASH_EQ] = ACTIONS(240),
    [anon_sym_EQ_LT] = ACTIONS(240),
    [anon_sym_LT] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(242),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(240),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(240),
    [anon_sym_andalso] = ACTIONS(242),
    [anon_sym_orelse] = ACTIONS(242),
    [anon_sym_EQ] = ACTIONS(242),
    [anon_sym_BANG] = ACTIONS(240),
    [anon_sym_QMARK_EQ] = ACTIONS(240),
    [anon_sym_DOT_DOT] = ACTIONS(242),
    [anon_sym_PIPE_PIPE] = ACTIONS(240),
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_LT_DASH] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(240),
    [anon_sym_EQ_GT] = ACTIONS(240),
    [anon_sym_COLON_EQ] = ACTIONS(240),
    [anon_sym_DASH_GT] = ACTIONS(240),
    [anon_sym_fun] = ACTIONS(242),
    [anon_sym_begin] = ACTIONS(242),
    [anon_sym_case] = ACTIONS(242),
    [anon_sym_receive] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(242),
    [anon_sym_maybe] = ACTIONS(242),
    [anon_sym_DOLLAR] = ACTIONS(240),
    [aux_sym_integer_token1] = ACTIONS(242),
    [aux_sym_integer_token2] = ACTIONS(240),
    [sym_float] = ACTIONS(240),
    [sym_atom] = ACTIONS(242),
    [anon_sym_SQUOTE] = ACTIONS(240),
    [sym_variable] = ACTIONS(240),
    [anon_sym_QMARK] = ACTIONS(242),
    [anon_sym_DQUOTE] = ACTIONS(240),
    [sym_tripledot] = ACTIONS(240),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [30] = {
    [sym_comment] = STATE(30),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_DOT] = ACTIONS(246),
    [anon_sym_SEMI] = ACTIONS(244),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(244),
    [anon_sym_RPAREN] = ACTIONS(244),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(244),
    [anon_sym_GT_GT] = ACTIONS(244),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_RBRACE] = ACTIONS(244),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_RBRACK] = ACTIONS(244),
    [anon_sym_POUND] = ACTIONS(244),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(244),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_EQ_EQ] = ACTIONS(244),
    [anon_sym_SLASH_EQ] = ACTIONS(244),
    [anon_sym_EQ_LT] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(244),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(244),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_QMARK_EQ] = ACTIONS(244),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(244),
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(244),
    [anon_sym_LT_EQ] = ACTIONS(244),
    [anon_sym_EQ_GT] = ACTIONS(244),
    [anon_sym_COLON_EQ] = ACTIONS(244),
    [anon_sym_DASH_GT] = ACTIONS(244),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(244),
    [sym_float] = ACTIONS(244),
    [sym_atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(244),
    [sym_variable] = ACTIONS(244),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [sym_tripledot] = ACTIONS(244),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [31] = {
    [sym_comment] = STATE(31),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym_DOT] = ACTIONS(250),
    [anon_sym_SEMI] = ACTIONS(248),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_RPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_GT_GT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_RBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_RBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_DASH_GT] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym_atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [32] = {
    [sym_comment] = STATE(32),
    [anon_sym_COMMA] = ACTIONS(252),
    [anon_sym_DOT] = ACTIONS(254),
    [anon_sym_SEMI] = ACTIONS(252),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(252),
    [anon_sym_GT_GT] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_RBRACE] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_RBRACK] = ACTIONS(252),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(252),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_EQ_EQ] = ACTIONS(252),
    [anon_sym_SLASH_EQ] = ACTIONS(252),
    [anon_sym_EQ_LT] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(252),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(252),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(252),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_QMARK_EQ] = ACTIONS(252),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(252),
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(252),
    [anon_sym_LT_EQ] = ACTIONS(252),
    [anon_sym_EQ_GT] = ACTIONS(252),
    [anon_sym_COLON_EQ] = ACTIONS(252),
    [anon_sym_DASH_GT] = ACTIONS(252),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(252),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(252),
    [sym_float] = ACTIONS(252),
    [sym_atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [sym_variable] = ACTIONS(252),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_tripledot] = ACTIONS(252),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [33] = {
    [sym_arguments] = STATE(58),
    [sym_comment] = STATE(33),
    [anon_sym_COMMA] = ACTIONS(218),
    [anon_sym_SEMI] = ACTIONS(218),
    [anon_sym_DASH] = ACTIONS(220),
    [anon_sym_LPAREN] = ACTIONS(256),
    [anon_sym_COLON] = ACTIONS(220),
    [anon_sym_when] = ACTIONS(220),
    [anon_sym_if] = ACTIONS(220),
    [anon_sym_LT_LT] = ACTIONS(218),
    [anon_sym_LBRACE] = ACTIONS(218),
    [anon_sym_LBRACK] = ACTIONS(218),
    [anon_sym_POUND] = ACTIONS(218),
    [anon_sym_PLUS] = ACTIONS(220),
    [anon_sym_not] = ACTIONS(220),
    [anon_sym_bnot] = ACTIONS(220),
    [anon_sym_catch] = ACTIONS(220),
    [anon_sym_SLASH] = ACTIONS(220),
    [anon_sym_STAR] = ACTIONS(218),
    [anon_sym_div] = ACTIONS(220),
    [anon_sym_rem] = ACTIONS(220),
    [anon_sym_band] = ACTIONS(220),
    [anon_sym_and] = ACTIONS(220),
    [anon_sym_bor] = ACTIONS(220),
    [anon_sym_bxor] = ACTIONS(220),
    [anon_sym_bsl] = ACTIONS(220),
    [anon_sym_bsr] = ACTIONS(220),
    [anon_sym_or] = ACTIONS(220),
    [anon_sym_xor] = ACTIONS(220),
    [anon_sym_PLUS_PLUS] = ACTIONS(218),
    [anon_sym_DASH_DASH] = ACTIONS(218),
    [anon_sym_EQ_EQ] = ACTIONS(218),
    [anon_sym_SLASH_EQ] = ACTIONS(218),
    [anon_sym_EQ_LT] = ACTIONS(218),
    [anon_sym_LT] = ACTIONS(220),
    [anon_sym_GT_EQ] = ACTIONS(218),
    [anon_sym_GT] = ACTIONS(220),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(218),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(218),
    [anon_sym_andalso] = ACTIONS(220),
    [anon_sym_orelse] = ACTIONS(220),
    [anon_sym_EQ] = ACTIONS(220),
    [anon_sym_BANG] = ACTIONS(218),
    [anon_sym_QMARK_EQ] = ACTIONS(218),
    [anon_sym_DOT_DOT] = ACTIONS(220),
    [anon_sym_PIPE_PIPE] = ACTIONS(218),
    [anon_sym_COLON_COLON] = ACTIONS(218),
    [anon_sym_PIPE] = ACTIONS(220),
    [anon_sym_LT_DASH] = ACTIONS(218),
    [anon_sym_LT_EQ] = ACTIONS(218),
    [anon_sym_EQ_GT] = ACTIONS(218),
    [anon_sym_COLON_EQ] = ACTIONS(218),
    [anon_sym_DASH_GT] = ACTIONS(218),
    [anon_sym_fun] = ACTIONS(220),
    [anon_sym_end] = ACTIONS(220),
    [anon_sym_begin] = ACTIONS(220),
    [anon_sym_case] = ACTIONS(220),
    [anon_sym_receive] = ACTIONS(220),
    [anon_sym_after] = ACTIONS(220),
    [anon_sym_try] = ACTIONS(220),
    [anon_sym_maybe] = ACTIONS(220),
    [anon_sym_DOLLAR] = ACTIONS(218),
    [aux_sym_integer_token1] = ACTIONS(220),
    [aux_sym_integer_token2] = ACTIONS(218),
    [sym_float] = ACTIONS(218),
    [sym_atom] = ACTIONS(220),
    [anon_sym_SQUOTE] = ACTIONS(218),
    [sym_variable] = ACTIONS(218),
    [anon_sym_QMARK] = ACTIONS(220),
    [anon_sym_DQUOTE] = ACTIONS(218),
    [sym_tripledot] = ACTIONS(218),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [34] = {
    [sym_arguments] = STATE(42),
    [sym_comment] = STATE(34),
    [anon_sym_COMMA] = ACTIONS(220),
    [anon_sym_DOT] = ACTIONS(220),
    [anon_sym_LF] = ACTIONS(218),
    [anon_sym_SEMI] = ACTIONS(220),
    [anon_sym_DASH] = ACTIONS(220),
    [anon_sym_LPAREN] = ACTIONS(258),
    [anon_sym_COLON] = ACTIONS(220),
    [anon_sym_when] = ACTIONS(220),
    [anon_sym_if] = ACTIONS(220),
    [anon_sym_LT_LT] = ACTIONS(220),
    [anon_sym_LBRACE] = ACTIONS(220),
    [anon_sym_LBRACK] = ACTIONS(220),
    [anon_sym_POUND] = ACTIONS(220),
    [anon_sym_PLUS] = ACTIONS(220),
    [anon_sym_not] = ACTIONS(220),
    [anon_sym_bnot] = ACTIONS(220),
    [anon_sym_catch] = ACTIONS(220),
    [anon_sym_SLASH] = ACTIONS(220),
    [anon_sym_STAR] = ACTIONS(220),
    [anon_sym_div] = ACTIONS(220),
    [anon_sym_rem] = ACTIONS(220),
    [anon_sym_band] = ACTIONS(220),
    [anon_sym_and] = ACTIONS(220),
    [anon_sym_bor] = ACTIONS(220),
    [anon_sym_bxor] = ACTIONS(220),
    [anon_sym_bsl] = ACTIONS(220),
    [anon_sym_bsr] = ACTIONS(220),
    [anon_sym_or] = ACTIONS(220),
    [anon_sym_xor] = ACTIONS(220),
    [anon_sym_PLUS_PLUS] = ACTIONS(220),
    [anon_sym_DASH_DASH] = ACTIONS(220),
    [anon_sym_EQ_EQ] = ACTIONS(220),
    [anon_sym_SLASH_EQ] = ACTIONS(220),
    [anon_sym_EQ_LT] = ACTIONS(220),
    [anon_sym_LT] = ACTIONS(220),
    [anon_sym_GT_EQ] = ACTIONS(220),
    [anon_sym_GT] = ACTIONS(220),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(220),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(220),
    [anon_sym_andalso] = ACTIONS(220),
    [anon_sym_orelse] = ACTIONS(220),
    [anon_sym_EQ] = ACTIONS(220),
    [anon_sym_BANG] = ACTIONS(220),
    [anon_sym_QMARK_EQ] = ACTIONS(220),
    [anon_sym_DOT_DOT] = ACTIONS(220),
    [anon_sym_PIPE_PIPE] = ACTIONS(220),
    [anon_sym_COLON_COLON] = ACTIONS(220),
    [anon_sym_PIPE] = ACTIONS(220),
    [anon_sym_LT_DASH] = ACTIONS(220),
    [anon_sym_LT_EQ] = ACTIONS(220),
    [anon_sym_EQ_GT] = ACTIONS(220),
    [anon_sym_COLON_EQ] = ACTIONS(220),
    [anon_sym_DASH_GT] = ACTIONS(220),
    [anon_sym_fun] = ACTIONS(220),
    [anon_sym_begin] = ACTIONS(220),
    [anon_sym_case] = ACTIONS(220),
    [anon_sym_receive] = ACTIONS(220),
    [anon_sym_try] = ACTIONS(220),
    [anon_sym_maybe] = ACTIONS(220),
    [anon_sym_DOLLAR] = ACTIONS(220),
    [aux_sym_integer_token1] = ACTIONS(220),
    [aux_sym_integer_token2] = ACTIONS(220),
    [sym_float] = ACTIONS(220),
    [sym_atom] = ACTIONS(220),
    [anon_sym_SQUOTE] = ACTIONS(220),
    [sym_variable] = ACTIONS(220),
    [anon_sym_QMARK] = ACTIONS(220),
    [anon_sym_DQUOTE] = ACTIONS(220),
    [sym_tripledot] = ACTIONS(220),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [35] = {
    [sym_arguments] = STATE(40),
    [sym_comment] = STATE(35),
    [anon_sym_COMMA] = ACTIONS(224),
    [anon_sym_DASH] = ACTIONS(226),
    [anon_sym_LPAREN] = ACTIONS(260),
    [anon_sym_COLON] = ACTIONS(226),
    [anon_sym_when] = ACTIONS(226),
    [anon_sym_if] = ACTIONS(226),
    [anon_sym_LT_LT] = ACTIONS(224),
    [anon_sym_LBRACE] = ACTIONS(224),
    [anon_sym_LBRACK] = ACTIONS(224),
    [anon_sym_POUND] = ACTIONS(224),
    [anon_sym_PLUS] = ACTIONS(226),
    [anon_sym_not] = ACTIONS(226),
    [anon_sym_bnot] = ACTIONS(226),
    [anon_sym_catch] = ACTIONS(226),
    [anon_sym_SLASH] = ACTIONS(226),
    [anon_sym_STAR] = ACTIONS(224),
    [anon_sym_div] = ACTIONS(226),
    [anon_sym_rem] = ACTIONS(226),
    [anon_sym_band] = ACTIONS(226),
    [anon_sym_and] = ACTIONS(226),
    [anon_sym_bor] = ACTIONS(226),
    [anon_sym_bxor] = ACTIONS(226),
    [anon_sym_bsl] = ACTIONS(226),
    [anon_sym_bsr] = ACTIONS(226),
    [anon_sym_or] = ACTIONS(226),
    [anon_sym_xor] = ACTIONS(226),
    [anon_sym_PLUS_PLUS] = ACTIONS(224),
    [anon_sym_DASH_DASH] = ACTIONS(224),
    [anon_sym_EQ_EQ] = ACTIONS(224),
    [anon_sym_SLASH_EQ] = ACTIONS(224),
    [anon_sym_EQ_LT] = ACTIONS(224),
    [anon_sym_LT] = ACTIONS(226),
    [anon_sym_GT_EQ] = ACTIONS(224),
    [anon_sym_GT] = ACTIONS(226),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(224),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(224),
    [anon_sym_andalso] = ACTIONS(226),
    [anon_sym_orelse] = ACTIONS(226),
    [anon_sym_EQ] = ACTIONS(226),
    [anon_sym_BANG] = ACTIONS(224),
    [anon_sym_QMARK_EQ] = ACTIONS(224),
    [anon_sym_DOT_DOT] = ACTIONS(226),
    [anon_sym_PIPE_PIPE] = ACTIONS(224),
    [anon_sym_COLON_COLON] = ACTIONS(224),
    [anon_sym_PIPE] = ACTIONS(226),
    [anon_sym_LT_DASH] = ACTIONS(224),
    [anon_sym_LT_EQ] = ACTIONS(224),
    [anon_sym_EQ_GT] = ACTIONS(224),
    [anon_sym_COLON_EQ] = ACTIONS(224),
    [anon_sym_DASH_GT] = ACTIONS(224),
    [anon_sym_fun] = ACTIONS(226),
    [anon_sym_end] = ACTIONS(226),
    [anon_sym_begin] = ACTIONS(226),
    [anon_sym_case] = ACTIONS(226),
    [anon_sym_of] = ACTIONS(226),
    [anon_sym_receive] = ACTIONS(226),
    [anon_sym_after] = ACTIONS(226),
    [anon_sym_try] = ACTIONS(226),
    [anon_sym_maybe] = ACTIONS(226),
    [anon_sym_DOLLAR] = ACTIONS(224),
    [aux_sym_integer_token1] = ACTIONS(226),
    [aux_sym_integer_token2] = ACTIONS(224),
    [sym_float] = ACTIONS(224),
    [sym_atom] = ACTIONS(226),
    [anon_sym_SQUOTE] = ACTIONS(224),
    [sym_variable] = ACTIONS(224),
    [anon_sym_QMARK] = ACTIONS(226),
    [anon_sym_DQUOTE] = ACTIONS(224),
    [sym_tripledot] = ACTIONS(224),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [36] = {
    [sym_arguments] = STATE(48),
    [sym_comment] = STATE(36),
    [anon_sym_COMMA] = ACTIONS(218),
    [anon_sym_DASH] = ACTIONS(220),
    [anon_sym_LPAREN] = ACTIONS(260),
    [anon_sym_COLON] = ACTIONS(220),
    [anon_sym_when] = ACTIONS(220),
    [anon_sym_if] = ACTIONS(220),
    [anon_sym_LT_LT] = ACTIONS(218),
    [anon_sym_LBRACE] = ACTIONS(218),
    [anon_sym_LBRACK] = ACTIONS(218),
    [anon_sym_POUND] = ACTIONS(218),
    [anon_sym_PLUS] = ACTIONS(220),
    [anon_sym_not] = ACTIONS(220),
    [anon_sym_bnot] = ACTIONS(220),
    [anon_sym_catch] = ACTIONS(220),
    [anon_sym_SLASH] = ACTIONS(220),
    [anon_sym_STAR] = ACTIONS(218),
    [anon_sym_div] = ACTIONS(220),
    [anon_sym_rem] = ACTIONS(220),
    [anon_sym_band] = ACTIONS(220),
    [anon_sym_and] = ACTIONS(220),
    [anon_sym_bor] = ACTIONS(220),
    [anon_sym_bxor] = ACTIONS(220),
    [anon_sym_bsl] = ACTIONS(220),
    [anon_sym_bsr] = ACTIONS(220),
    [anon_sym_or] = ACTIONS(220),
    [anon_sym_xor] = ACTIONS(220),
    [anon_sym_PLUS_PLUS] = ACTIONS(218),
    [anon_sym_DASH_DASH] = ACTIONS(218),
    [anon_sym_EQ_EQ] = ACTIONS(218),
    [anon_sym_SLASH_EQ] = ACTIONS(218),
    [anon_sym_EQ_LT] = ACTIONS(218),
    [anon_sym_LT] = ACTIONS(220),
    [anon_sym_GT_EQ] = ACTIONS(218),
    [anon_sym_GT] = ACTIONS(220),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(218),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(218),
    [anon_sym_andalso] = ACTIONS(220),
    [anon_sym_orelse] = ACTIONS(220),
    [anon_sym_EQ] = ACTIONS(220),
    [anon_sym_BANG] = ACTIONS(218),
    [anon_sym_QMARK_EQ] = ACTIONS(218),
    [anon_sym_DOT_DOT] = ACTIONS(220),
    [anon_sym_PIPE_PIPE] = ACTIONS(218),
    [anon_sym_COLON_COLON] = ACTIONS(218),
    [anon_sym_PIPE] = ACTIONS(220),
    [anon_sym_LT_DASH] = ACTIONS(218),
    [anon_sym_LT_EQ] = ACTIONS(218),
    [anon_sym_EQ_GT] = ACTIONS(218),
    [anon_sym_COLON_EQ] = ACTIONS(218),
    [anon_sym_DASH_GT] = ACTIONS(218),
    [anon_sym_fun] = ACTIONS(220),
    [anon_sym_end] = ACTIONS(220),
    [anon_sym_begin] = ACTIONS(220),
    [anon_sym_case] = ACTIONS(220),
    [anon_sym_of] = ACTIONS(220),
    [anon_sym_receive] = ACTIONS(220),
    [anon_sym_after] = ACTIONS(220),
    [anon_sym_try] = ACTIONS(220),
    [anon_sym_maybe] = ACTIONS(220),
    [anon_sym_DOLLAR] = ACTIONS(218),
    [aux_sym_integer_token1] = ACTIONS(220),
    [aux_sym_integer_token2] = ACTIONS(218),
    [sym_float] = ACTIONS(218),
    [sym_atom] = ACTIONS(220),
    [anon_sym_SQUOTE] = ACTIONS(218),
    [sym_variable] = ACTIONS(218),
    [anon_sym_QMARK] = ACTIONS(220),
    [anon_sym_DQUOTE] = ACTIONS(218),
    [sym_tripledot] = ACTIONS(218),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [37] = {
    [sym_arguments] = STATE(39),
    [sym_comment] = STATE(37),
    [anon_sym_COMMA] = ACTIONS(224),
    [anon_sym_SEMI] = ACTIONS(224),
    [anon_sym_DASH] = ACTIONS(226),
    [anon_sym_LPAREN] = ACTIONS(256),
    [anon_sym_COLON] = ACTIONS(226),
    [anon_sym_when] = ACTIONS(226),
    [anon_sym_if] = ACTIONS(226),
    [anon_sym_LT_LT] = ACTIONS(224),
    [anon_sym_LBRACE] = ACTIONS(224),
    [anon_sym_LBRACK] = ACTIONS(224),
    [anon_sym_POUND] = ACTIONS(224),
    [anon_sym_PLUS] = ACTIONS(226),
    [anon_sym_not] = ACTIONS(226),
    [anon_sym_bnot] = ACTIONS(226),
    [anon_sym_catch] = ACTIONS(226),
    [anon_sym_SLASH] = ACTIONS(226),
    [anon_sym_STAR] = ACTIONS(224),
    [anon_sym_div] = ACTIONS(226),
    [anon_sym_rem] = ACTIONS(226),
    [anon_sym_band] = ACTIONS(226),
    [anon_sym_and] = ACTIONS(226),
    [anon_sym_bor] = ACTIONS(226),
    [anon_sym_bxor] = ACTIONS(226),
    [anon_sym_bsl] = ACTIONS(226),
    [anon_sym_bsr] = ACTIONS(226),
    [anon_sym_or] = ACTIONS(226),
    [anon_sym_xor] = ACTIONS(226),
    [anon_sym_PLUS_PLUS] = ACTIONS(224),
    [anon_sym_DASH_DASH] = ACTIONS(224),
    [anon_sym_EQ_EQ] = ACTIONS(224),
    [anon_sym_SLASH_EQ] = ACTIONS(224),
    [anon_sym_EQ_LT] = ACTIONS(224),
    [anon_sym_LT] = ACTIONS(226),
    [anon_sym_GT_EQ] = ACTIONS(224),
    [anon_sym_GT] = ACTIONS(226),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(224),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(224),
    [anon_sym_andalso] = ACTIONS(226),
    [anon_sym_orelse] = ACTIONS(226),
    [anon_sym_EQ] = ACTIONS(226),
    [anon_sym_BANG] = ACTIONS(224),
    [anon_sym_QMARK_EQ] = ACTIONS(224),
    [anon_sym_DOT_DOT] = ACTIONS(226),
    [anon_sym_PIPE_PIPE] = ACTIONS(224),
    [anon_sym_COLON_COLON] = ACTIONS(224),
    [anon_sym_PIPE] = ACTIONS(226),
    [anon_sym_LT_DASH] = ACTIONS(224),
    [anon_sym_LT_EQ] = ACTIONS(224),
    [anon_sym_EQ_GT] = ACTIONS(224),
    [anon_sym_COLON_EQ] = ACTIONS(224),
    [anon_sym_DASH_GT] = ACTIONS(224),
    [anon_sym_fun] = ACTIONS(226),
    [anon_sym_end] = ACTIONS(226),
    [anon_sym_begin] = ACTIONS(226),
    [anon_sym_case] = ACTIONS(226),
    [anon_sym_receive] = ACTIONS(226),
    [anon_sym_after] = ACTIONS(226),
    [anon_sym_try] = ACTIONS(226),
    [anon_sym_maybe] = ACTIONS(226),
    [anon_sym_DOLLAR] = ACTIONS(224),
    [aux_sym_integer_token1] = ACTIONS(226),
    [aux_sym_integer_token2] = ACTIONS(224),
    [sym_float] = ACTIONS(224),
    [sym_atom] = ACTIONS(226),
    [anon_sym_SQUOTE] = ACTIONS(224),
    [sym_variable] = ACTIONS(224),
    [anon_sym_QMARK] = ACTIONS(226),
    [anon_sym_DQUOTE] = ACTIONS(224),
    [sym_tripledot] = ACTIONS(224),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [38] = {
    [sym_arguments] = STATE(41),
    [sym_comment] = STATE(38),
    [anon_sym_COMMA] = ACTIONS(226),
    [anon_sym_DOT] = ACTIONS(226),
    [anon_sym_LF] = ACTIONS(224),
    [anon_sym_SEMI] = ACTIONS(226),
    [anon_sym_DASH] = ACTIONS(226),
    [anon_sym_LPAREN] = ACTIONS(258),
    [anon_sym_COLON] = ACTIONS(226),
    [anon_sym_when] = ACTIONS(226),
    [anon_sym_if] = ACTIONS(226),
    [anon_sym_LT_LT] = ACTIONS(226),
    [anon_sym_LBRACE] = ACTIONS(226),
    [anon_sym_LBRACK] = ACTIONS(226),
    [anon_sym_POUND] = ACTIONS(226),
    [anon_sym_PLUS] = ACTIONS(226),
    [anon_sym_not] = ACTIONS(226),
    [anon_sym_bnot] = ACTIONS(226),
    [anon_sym_catch] = ACTIONS(226),
    [anon_sym_SLASH] = ACTIONS(226),
    [anon_sym_STAR] = ACTIONS(226),
    [anon_sym_div] = ACTIONS(226),
    [anon_sym_rem] = ACTIONS(226),
    [anon_sym_band] = ACTIONS(226),
    [anon_sym_and] = ACTIONS(226),
    [anon_sym_bor] = ACTIONS(226),
    [anon_sym_bxor] = ACTIONS(226),
    [anon_sym_bsl] = ACTIONS(226),
    [anon_sym_bsr] = ACTIONS(226),
    [anon_sym_or] = ACTIONS(226),
    [anon_sym_xor] = ACTIONS(226),
    [anon_sym_PLUS_PLUS] = ACTIONS(226),
    [anon_sym_DASH_DASH] = ACTIONS(226),
    [anon_sym_EQ_EQ] = ACTIONS(226),
    [anon_sym_SLASH_EQ] = ACTIONS(226),
    [anon_sym_EQ_LT] = ACTIONS(226),
    [anon_sym_LT] = ACTIONS(226),
    [anon_sym_GT_EQ] = ACTIONS(226),
    [anon_sym_GT] = ACTIONS(226),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(226),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(226),
    [anon_sym_andalso] = ACTIONS(226),
    [anon_sym_orelse] = ACTIONS(226),
    [anon_sym_EQ] = ACTIONS(226),
    [anon_sym_BANG] = ACTIONS(226),
    [anon_sym_QMARK_EQ] = ACTIONS(226),
    [anon_sym_DOT_DOT] = ACTIONS(226),
    [anon_sym_PIPE_PIPE] = ACTIONS(226),
    [anon_sym_COLON_COLON] = ACTIONS(226),
    [anon_sym_PIPE] = ACTIONS(226),
    [anon_sym_LT_DASH] = ACTIONS(226),
    [anon_sym_LT_EQ] = ACTIONS(226),
    [anon_sym_EQ_GT] = ACTIONS(226),
    [anon_sym_COLON_EQ] = ACTIONS(226),
    [anon_sym_DASH_GT] = ACTIONS(226),
    [anon_sym_fun] = ACTIONS(226),
    [anon_sym_begin] = ACTIONS(226),
    [anon_sym_case] = ACTIONS(226),
    [anon_sym_receive] = ACTIONS(226),
    [anon_sym_try] = ACTIONS(226),
    [anon_sym_maybe] = ACTIONS(226),
    [anon_sym_DOLLAR] = ACTIONS(226),
    [aux_sym_integer_token1] = ACTIONS(226),
    [aux_sym_integer_token2] = ACTIONS(226),
    [sym_float] = ACTIONS(226),
    [sym_atom] = ACTIONS(226),
    [anon_sym_SQUOTE] = ACTIONS(226),
    [sym_variable] = ACTIONS(226),
    [anon_sym_QMARK] = ACTIONS(226),
    [anon_sym_DQUOTE] = ACTIONS(226),
    [sym_tripledot] = ACTIONS(226),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [39] = {
    [sym_comment] = STATE(39),
    [anon_sym_COMMA] = ACTIONS(236),
    [anon_sym_SEMI] = ACTIONS(236),
    [anon_sym_DASH] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(236),
    [anon_sym_COLON] = ACTIONS(238),
    [anon_sym_when] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_LT_LT] = ACTIONS(236),
    [anon_sym_LBRACE] = ACTIONS(236),
    [anon_sym_LBRACK] = ACTIONS(236),
    [anon_sym_POUND] = ACTIONS(236),
    [anon_sym_PLUS] = ACTIONS(238),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_bnot] = ACTIONS(238),
    [anon_sym_catch] = ACTIONS(238),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_STAR] = ACTIONS(236),
    [anon_sym_div] = ACTIONS(238),
    [anon_sym_rem] = ACTIONS(238),
    [anon_sym_band] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_bor] = ACTIONS(238),
    [anon_sym_bxor] = ACTIONS(238),
    [anon_sym_bsl] = ACTIONS(238),
    [anon_sym_bsr] = ACTIONS(238),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_xor] = ACTIONS(238),
    [anon_sym_PLUS_PLUS] = ACTIONS(236),
    [anon_sym_DASH_DASH] = ACTIONS(236),
    [anon_sym_EQ_EQ] = ACTIONS(236),
    [anon_sym_SLASH_EQ] = ACTIONS(236),
    [anon_sym_EQ_LT] = ACTIONS(236),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_GT_EQ] = ACTIONS(236),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(236),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(236),
    [anon_sym_andalso] = ACTIONS(238),
    [anon_sym_orelse] = ACTIONS(238),
    [anon_sym_EQ] = ACTIONS(238),
    [anon_sym_BANG] = ACTIONS(236),
    [anon_sym_QMARK_EQ] = ACTIONS(236),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_PIPE_PIPE] = ACTIONS(236),
    [anon_sym_COLON_COLON] = ACTIONS(236),
    [anon_sym_PIPE] = ACTIONS(238),
    [anon_sym_LT_DASH] = ACTIONS(236),
    [anon_sym_LT_EQ] = ACTIONS(236),
    [anon_sym_EQ_GT] = ACTIONS(236),
    [anon_sym_COLON_EQ] = ACTIONS(236),
    [anon_sym_DASH_GT] = ACTIONS(236),
    [anon_sym_fun] = ACTIONS(238),
    [anon_sym_end] = ACTIONS(238),
    [anon_sym_begin] = ACTIONS(238),
    [anon_sym_case] = ACTIONS(238),
    [anon_sym_receive] = ACTIONS(238),
    [anon_sym_after] = ACTIONS(238),
    [anon_sym_try] = ACTIONS(238),
    [anon_sym_maybe] = ACTIONS(238),
    [anon_sym_DOLLAR] = ACTIONS(236),
    [aux_sym_integer_token1] = ACTIONS(238),
    [aux_sym_integer_token2] = ACTIONS(236),
    [sym_float] = ACTIONS(236),
    [sym_atom] = ACTIONS(238),
    [anon_sym_SQUOTE] = ACTIONS(236),
    [sym_variable] = ACTIONS(236),
    [anon_sym_QMARK] = ACTIONS(238),
    [anon_sym_DQUOTE] = ACTIONS(236),
    [sym_tripledot] = ACTIONS(236),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [40] = {
    [sym_comment] = STATE(40),
    [anon_sym_COMMA] = ACTIONS(236),
    [anon_sym_DASH] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(236),
    [anon_sym_COLON] = ACTIONS(238),
    [anon_sym_when] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_LT_LT] = ACTIONS(236),
    [anon_sym_LBRACE] = ACTIONS(236),
    [anon_sym_LBRACK] = ACTIONS(236),
    [anon_sym_POUND] = ACTIONS(236),
    [anon_sym_PLUS] = ACTIONS(238),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_bnot] = ACTIONS(238),
    [anon_sym_catch] = ACTIONS(238),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_STAR] = ACTIONS(236),
    [anon_sym_div] = ACTIONS(238),
    [anon_sym_rem] = ACTIONS(238),
    [anon_sym_band] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_bor] = ACTIONS(238),
    [anon_sym_bxor] = ACTIONS(238),
    [anon_sym_bsl] = ACTIONS(238),
    [anon_sym_bsr] = ACTIONS(238),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_xor] = ACTIONS(238),
    [anon_sym_PLUS_PLUS] = ACTIONS(236),
    [anon_sym_DASH_DASH] = ACTIONS(236),
    [anon_sym_EQ_EQ] = ACTIONS(236),
    [anon_sym_SLASH_EQ] = ACTIONS(236),
    [anon_sym_EQ_LT] = ACTIONS(236),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_GT_EQ] = ACTIONS(236),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(236),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(236),
    [anon_sym_andalso] = ACTIONS(238),
    [anon_sym_orelse] = ACTIONS(238),
    [anon_sym_EQ] = ACTIONS(238),
    [anon_sym_BANG] = ACTIONS(236),
    [anon_sym_QMARK_EQ] = ACTIONS(236),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_PIPE_PIPE] = ACTIONS(236),
    [anon_sym_COLON_COLON] = ACTIONS(236),
    [anon_sym_PIPE] = ACTIONS(238),
    [anon_sym_LT_DASH] = ACTIONS(236),
    [anon_sym_LT_EQ] = ACTIONS(236),
    [anon_sym_EQ_GT] = ACTIONS(236),
    [anon_sym_COLON_EQ] = ACTIONS(236),
    [anon_sym_DASH_GT] = ACTIONS(236),
    [anon_sym_fun] = ACTIONS(238),
    [anon_sym_end] = ACTIONS(238),
    [anon_sym_begin] = ACTIONS(238),
    [anon_sym_case] = ACTIONS(238),
    [anon_sym_of] = ACTIONS(238),
    [anon_sym_receive] = ACTIONS(238),
    [anon_sym_after] = ACTIONS(238),
    [anon_sym_try] = ACTIONS(238),
    [anon_sym_maybe] = ACTIONS(238),
    [anon_sym_DOLLAR] = ACTIONS(236),
    [aux_sym_integer_token1] = ACTIONS(238),
    [aux_sym_integer_token2] = ACTIONS(236),
    [sym_float] = ACTIONS(236),
    [sym_atom] = ACTIONS(238),
    [anon_sym_SQUOTE] = ACTIONS(236),
    [sym_variable] = ACTIONS(236),
    [anon_sym_QMARK] = ACTIONS(238),
    [anon_sym_DQUOTE] = ACTIONS(236),
    [sym_tripledot] = ACTIONS(236),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [41] = {
    [sym_comment] = STATE(41),
    [anon_sym_COMMA] = ACTIONS(238),
    [anon_sym_DOT] = ACTIONS(238),
    [anon_sym_LF] = ACTIONS(236),
    [anon_sym_SEMI] = ACTIONS(238),
    [anon_sym_DASH] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(238),
    [anon_sym_COLON] = ACTIONS(238),
    [anon_sym_when] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_LT_LT] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(238),
    [anon_sym_PLUS] = ACTIONS(238),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_bnot] = ACTIONS(238),
    [anon_sym_catch] = ACTIONS(238),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_STAR] = ACTIONS(238),
    [anon_sym_div] = ACTIONS(238),
    [anon_sym_rem] = ACTIONS(238),
    [anon_sym_band] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_bor] = ACTIONS(238),
    [anon_sym_bxor] = ACTIONS(238),
    [anon_sym_bsl] = ACTIONS(238),
    [anon_sym_bsr] = ACTIONS(238),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_xor] = ACTIONS(238),
    [anon_sym_PLUS_PLUS] = ACTIONS(238),
    [anon_sym_DASH_DASH] = ACTIONS(238),
    [anon_sym_EQ_EQ] = ACTIONS(238),
    [anon_sym_SLASH_EQ] = ACTIONS(238),
    [anon_sym_EQ_LT] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_GT_EQ] = ACTIONS(238),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(238),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(238),
    [anon_sym_andalso] = ACTIONS(238),
    [anon_sym_orelse] = ACTIONS(238),
    [anon_sym_EQ] = ACTIONS(238),
    [anon_sym_BANG] = ACTIONS(238),
    [anon_sym_QMARK_EQ] = ACTIONS(238),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_PIPE_PIPE] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(238),
    [anon_sym_LT_DASH] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(238),
    [anon_sym_EQ_GT] = ACTIONS(238),
    [anon_sym_COLON_EQ] = ACTIONS(238),
    [anon_sym_DASH_GT] = ACTIONS(238),
    [anon_sym_fun] = ACTIONS(238),
    [anon_sym_begin] = ACTIONS(238),
    [anon_sym_case] = ACTIONS(238),
    [anon_sym_receive] = ACTIONS(238),
    [anon_sym_try] = ACTIONS(238),
    [anon_sym_maybe] = ACTIONS(238),
    [anon_sym_DOLLAR] = ACTIONS(238),
    [aux_sym_integer_token1] = ACTIONS(238),
    [aux_sym_integer_token2] = ACTIONS(238),
    [sym_float] = ACTIONS(238),
    [sym_atom] = ACTIONS(238),
    [anon_sym_SQUOTE] = ACTIONS(238),
    [sym_variable] = ACTIONS(238),
    [anon_sym_QMARK] = ACTIONS(238),
    [anon_sym_DQUOTE] = ACTIONS(238),
    [sym_tripledot] = ACTIONS(238),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [42] = {
    [sym_comment] = STATE(42),
    [anon_sym_COMMA] = ACTIONS(230),
    [anon_sym_DOT] = ACTIONS(230),
    [anon_sym_LF] = ACTIONS(228),
    [anon_sym_SEMI] = ACTIONS(230),
    [anon_sym_DASH] = ACTIONS(230),
    [anon_sym_LPAREN] = ACTIONS(230),
    [anon_sym_COLON] = ACTIONS(230),
    [anon_sym_when] = ACTIONS(230),
    [anon_sym_if] = ACTIONS(230),
    [anon_sym_LT_LT] = ACTIONS(230),
    [anon_sym_LBRACE] = ACTIONS(230),
    [anon_sym_LBRACK] = ACTIONS(230),
    [anon_sym_POUND] = ACTIONS(230),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_not] = ACTIONS(230),
    [anon_sym_bnot] = ACTIONS(230),
    [anon_sym_catch] = ACTIONS(230),
    [anon_sym_SLASH] = ACTIONS(230),
    [anon_sym_STAR] = ACTIONS(230),
    [anon_sym_div] = ACTIONS(230),
    [anon_sym_rem] = ACTIONS(230),
    [anon_sym_band] = ACTIONS(230),
    [anon_sym_and] = ACTIONS(230),
    [anon_sym_bor] = ACTIONS(230),
    [anon_sym_bxor] = ACTIONS(230),
    [anon_sym_bsl] = ACTIONS(230),
    [anon_sym_bsr] = ACTIONS(230),
    [anon_sym_or] = ACTIONS(230),
    [anon_sym_xor] = ACTIONS(230),
    [anon_sym_PLUS_PLUS] = ACTIONS(230),
    [anon_sym_DASH_DASH] = ACTIONS(230),
    [anon_sym_EQ_EQ] = ACTIONS(230),
    [anon_sym_SLASH_EQ] = ACTIONS(230),
    [anon_sym_EQ_LT] = ACTIONS(230),
    [anon_sym_LT] = ACTIONS(230),
    [anon_sym_GT_EQ] = ACTIONS(230),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(230),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(230),
    [anon_sym_andalso] = ACTIONS(230),
    [anon_sym_orelse] = ACTIONS(230),
    [anon_sym_EQ] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(230),
    [anon_sym_QMARK_EQ] = ACTIONS(230),
    [anon_sym_DOT_DOT] = ACTIONS(230),
    [anon_sym_PIPE_PIPE] = ACTIONS(230),
    [anon_sym_COLON_COLON] = ACTIONS(230),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_LT_DASH] = ACTIONS(230),
    [anon_sym_LT_EQ] = ACTIONS(230),
    [anon_sym_EQ_GT] = ACTIONS(230),
    [anon_sym_COLON_EQ] = ACTIONS(230),
    [anon_sym_DASH_GT] = ACTIONS(230),
    [anon_sym_fun] = ACTIONS(230),
    [anon_sym_begin] = ACTIONS(230),
    [anon_sym_case] = ACTIONS(230),
    [anon_sym_receive] = ACTIONS(230),
    [anon_sym_try] = ACTIONS(230),
    [anon_sym_maybe] = ACTIONS(230),
    [anon_sym_DOLLAR] = ACTIONS(230),
    [aux_sym_integer_token1] = ACTIONS(230),
    [aux_sym_integer_token2] = ACTIONS(230),
    [sym_float] = ACTIONS(230),
    [sym_atom] = ACTIONS(230),
    [anon_sym_SQUOTE] = ACTIONS(230),
    [sym_variable] = ACTIONS(230),
    [anon_sym_QMARK] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(230),
    [sym_tripledot] = ACTIONS(230),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [43] = {
    [sym_comment] = STATE(43),
    [anon_sym_COMMA] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(242),
    [anon_sym_LPAREN] = ACTIONS(240),
    [anon_sym_COLON] = ACTIONS(242),
    [anon_sym_when] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_LBRACE] = ACTIONS(240),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_POUND] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(242),
    [anon_sym_not] = ACTIONS(242),
    [anon_sym_bnot] = ACTIONS(242),
    [anon_sym_catch] = ACTIONS(242),
    [anon_sym_SLASH] = ACTIONS(242),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_div] = ACTIONS(242),
    [anon_sym_rem] = ACTIONS(242),
    [anon_sym_band] = ACTIONS(242),
    [anon_sym_and] = ACTIONS(242),
    [anon_sym_bor] = ACTIONS(242),
    [anon_sym_bxor] = ACTIONS(242),
    [anon_sym_bsl] = ACTIONS(242),
    [anon_sym_bsr] = ACTIONS(242),
    [anon_sym_or] = ACTIONS(242),
    [anon_sym_xor] = ACTIONS(242),
    [anon_sym_PLUS_PLUS] = ACTIONS(240),
    [anon_sym_DASH_DASH] = ACTIONS(240),
    [anon_sym_EQ_EQ] = ACTIONS(240),
    [anon_sym_SLASH_EQ] = ACTIONS(240),
    [anon_sym_EQ_LT] = ACTIONS(240),
    [anon_sym_LT] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(242),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(240),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(240),
    [anon_sym_andalso] = ACTIONS(242),
    [anon_sym_orelse] = ACTIONS(242),
    [anon_sym_EQ] = ACTIONS(242),
    [anon_sym_BANG] = ACTIONS(240),
    [anon_sym_QMARK_EQ] = ACTIONS(240),
    [anon_sym_DOT_DOT] = ACTIONS(242),
    [anon_sym_PIPE_PIPE] = ACTIONS(240),
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_LT_DASH] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(240),
    [anon_sym_EQ_GT] = ACTIONS(240),
    [anon_sym_COLON_EQ] = ACTIONS(240),
    [anon_sym_DASH_GT] = ACTIONS(240),
    [anon_sym_fun] = ACTIONS(242),
    [anon_sym_end] = ACTIONS(242),
    [anon_sym_begin] = ACTIONS(242),
    [anon_sym_case] = ACTIONS(242),
    [anon_sym_of] = ACTIONS(242),
    [anon_sym_receive] = ACTIONS(242),
    [anon_sym_after] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(242),
    [anon_sym_maybe] = ACTIONS(242),
    [anon_sym_DOLLAR] = ACTIONS(240),
    [aux_sym_integer_token1] = ACTIONS(242),
    [aux_sym_integer_token2] = ACTIONS(240),
    [sym_float] = ACTIONS(240),
    [sym_atom] = ACTIONS(242),
    [anon_sym_SQUOTE] = ACTIONS(240),
    [sym_variable] = ACTIONS(240),
    [anon_sym_QMARK] = ACTIONS(242),
    [anon_sym_DQUOTE] = ACTIONS(240),
    [sym_tripledot] = ACTIONS(240),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [44] = {
    [sym_comment] = STATE(44),
    [anon_sym_COMMA] = ACTIONS(246),
    [anon_sym_DOT] = ACTIONS(246),
    [anon_sym_LF] = ACTIONS(244),
    [anon_sym_SEMI] = ACTIONS(246),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(246),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(246),
    [anon_sym_LBRACE] = ACTIONS(246),
    [anon_sym_LBRACK] = ACTIONS(246),
    [anon_sym_POUND] = ACTIONS(246),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(246),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(246),
    [anon_sym_DASH_DASH] = ACTIONS(246),
    [anon_sym_EQ_EQ] = ACTIONS(246),
    [anon_sym_SLASH_EQ] = ACTIONS(246),
    [anon_sym_EQ_LT] = ACTIONS(246),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(246),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(246),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(246),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(246),
    [anon_sym_QMARK_EQ] = ACTIONS(246),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(246),
    [anon_sym_COLON_COLON] = ACTIONS(246),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(246),
    [anon_sym_LT_EQ] = ACTIONS(246),
    [anon_sym_EQ_GT] = ACTIONS(246),
    [anon_sym_COLON_EQ] = ACTIONS(246),
    [anon_sym_DASH_GT] = ACTIONS(246),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(246),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(246),
    [sym_float] = ACTIONS(246),
    [sym_atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(246),
    [sym_variable] = ACTIONS(246),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(246),
    [sym_tripledot] = ACTIONS(246),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [45] = {
    [sym_comment] = STATE(45),
    [anon_sym_COMMA] = ACTIONS(250),
    [anon_sym_DOT] = ACTIONS(250),
    [anon_sym_LF] = ACTIONS(248),
    [anon_sym_SEMI] = ACTIONS(250),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(250),
    [anon_sym_LBRACE] = ACTIONS(250),
    [anon_sym_LBRACK] = ACTIONS(250),
    [anon_sym_POUND] = ACTIONS(250),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(250),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(250),
    [anon_sym_DASH_DASH] = ACTIONS(250),
    [anon_sym_EQ_EQ] = ACTIONS(250),
    [anon_sym_SLASH_EQ] = ACTIONS(250),
    [anon_sym_EQ_LT] = ACTIONS(250),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(250),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(250),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(250),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(250),
    [anon_sym_QMARK_EQ] = ACTIONS(250),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(250),
    [anon_sym_COLON_COLON] = ACTIONS(250),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(250),
    [anon_sym_LT_EQ] = ACTIONS(250),
    [anon_sym_EQ_GT] = ACTIONS(250),
    [anon_sym_COLON_EQ] = ACTIONS(250),
    [anon_sym_DASH_GT] = ACTIONS(250),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(250),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(250),
    [sym_float] = ACTIONS(250),
    [sym_atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(250),
    [sym_variable] = ACTIONS(250),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(250),
    [sym_tripledot] = ACTIONS(250),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [46] = {
    [sym_comment] = STATE(46),
    [anon_sym_COMMA] = ACTIONS(254),
    [anon_sym_DOT] = ACTIONS(254),
    [anon_sym_LF] = ACTIONS(252),
    [anon_sym_SEMI] = ACTIONS(254),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(254),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(254),
    [anon_sym_LBRACE] = ACTIONS(254),
    [anon_sym_LBRACK] = ACTIONS(254),
    [anon_sym_POUND] = ACTIONS(254),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(254),
    [anon_sym_DASH_DASH] = ACTIONS(254),
    [anon_sym_EQ_EQ] = ACTIONS(254),
    [anon_sym_SLASH_EQ] = ACTIONS(254),
    [anon_sym_EQ_LT] = ACTIONS(254),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(254),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(254),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(254),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(254),
    [anon_sym_QMARK_EQ] = ACTIONS(254),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(254),
    [anon_sym_COLON_COLON] = ACTIONS(254),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(254),
    [anon_sym_LT_EQ] = ACTIONS(254),
    [anon_sym_EQ_GT] = ACTIONS(254),
    [anon_sym_COLON_EQ] = ACTIONS(254),
    [anon_sym_DASH_GT] = ACTIONS(254),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(254),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(254),
    [sym_float] = ACTIONS(254),
    [sym_atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(254),
    [sym_variable] = ACTIONS(254),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(254),
    [sym_tripledot] = ACTIONS(254),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [47] = {
    [sym_comment] = STATE(47),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(244),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(244),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_POUND] = ACTIONS(244),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(244),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_EQ_EQ] = ACTIONS(244),
    [anon_sym_SLASH_EQ] = ACTIONS(244),
    [anon_sym_EQ_LT] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(244),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(244),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_QMARK_EQ] = ACTIONS(244),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(244),
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(244),
    [anon_sym_LT_EQ] = ACTIONS(244),
    [anon_sym_EQ_GT] = ACTIONS(244),
    [anon_sym_COLON_EQ] = ACTIONS(244),
    [anon_sym_DASH_GT] = ACTIONS(244),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_of] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_after] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(244),
    [sym_float] = ACTIONS(244),
    [sym_atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(244),
    [sym_variable] = ACTIONS(244),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [sym_tripledot] = ACTIONS(244),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [48] = {
    [sym_comment] = STATE(48),
    [anon_sym_COMMA] = ACTIONS(228),
    [anon_sym_DASH] = ACTIONS(230),
    [anon_sym_LPAREN] = ACTIONS(228),
    [anon_sym_COLON] = ACTIONS(230),
    [anon_sym_when] = ACTIONS(230),
    [anon_sym_if] = ACTIONS(230),
    [anon_sym_LT_LT] = ACTIONS(228),
    [anon_sym_LBRACE] = ACTIONS(228),
    [anon_sym_LBRACK] = ACTIONS(228),
    [anon_sym_POUND] = ACTIONS(228),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_not] = ACTIONS(230),
    [anon_sym_bnot] = ACTIONS(230),
    [anon_sym_catch] = ACTIONS(230),
    [anon_sym_SLASH] = ACTIONS(230),
    [anon_sym_STAR] = ACTIONS(228),
    [anon_sym_div] = ACTIONS(230),
    [anon_sym_rem] = ACTIONS(230),
    [anon_sym_band] = ACTIONS(230),
    [anon_sym_and] = ACTIONS(230),
    [anon_sym_bor] = ACTIONS(230),
    [anon_sym_bxor] = ACTIONS(230),
    [anon_sym_bsl] = ACTIONS(230),
    [anon_sym_bsr] = ACTIONS(230),
    [anon_sym_or] = ACTIONS(230),
    [anon_sym_xor] = ACTIONS(230),
    [anon_sym_PLUS_PLUS] = ACTIONS(228),
    [anon_sym_DASH_DASH] = ACTIONS(228),
    [anon_sym_EQ_EQ] = ACTIONS(228),
    [anon_sym_SLASH_EQ] = ACTIONS(228),
    [anon_sym_EQ_LT] = ACTIONS(228),
    [anon_sym_LT] = ACTIONS(230),
    [anon_sym_GT_EQ] = ACTIONS(228),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(228),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(228),
    [anon_sym_andalso] = ACTIONS(230),
    [anon_sym_orelse] = ACTIONS(230),
    [anon_sym_EQ] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(228),
    [anon_sym_QMARK_EQ] = ACTIONS(228),
    [anon_sym_DOT_DOT] = ACTIONS(230),
    [anon_sym_PIPE_PIPE] = ACTIONS(228),
    [anon_sym_COLON_COLON] = ACTIONS(228),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_LT_DASH] = ACTIONS(228),
    [anon_sym_LT_EQ] = ACTIONS(228),
    [anon_sym_EQ_GT] = ACTIONS(228),
    [anon_sym_COLON_EQ] = ACTIONS(228),
    [anon_sym_DASH_GT] = ACTIONS(228),
    [anon_sym_fun] = ACTIONS(230),
    [anon_sym_end] = ACTIONS(230),
    [anon_sym_begin] = ACTIONS(230),
    [anon_sym_case] = ACTIONS(230),
    [anon_sym_of] = ACTIONS(230),
    [anon_sym_receive] = ACTIONS(230),
    [anon_sym_after] = ACTIONS(230),
    [anon_sym_try] = ACTIONS(230),
    [anon_sym_maybe] = ACTIONS(230),
    [anon_sym_DOLLAR] = ACTIONS(228),
    [aux_sym_integer_token1] = ACTIONS(230),
    [aux_sym_integer_token2] = ACTIONS(228),
    [sym_float] = ACTIONS(228),
    [sym_atom] = ACTIONS(230),
    [anon_sym_SQUOTE] = ACTIONS(228),
    [sym_variable] = ACTIONS(228),
    [anon_sym_QMARK] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(228),
    [sym_tripledot] = ACTIONS(228),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [49] = {
    [sym_comment] = STATE(49),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_DASH_GT] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_end] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_of] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_after] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym_atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [50] = {
    [sym_comment] = STATE(50),
    [anon_sym_COMMA] = ACTIONS(252),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(252),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_EQ_EQ] = ACTIONS(252),
    [anon_sym_SLASH_EQ] = ACTIONS(252),
    [anon_sym_EQ_LT] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(252),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(252),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(252),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_QMARK_EQ] = ACTIONS(252),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(252),
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(252),
    [anon_sym_LT_EQ] = ACTIONS(252),
    [anon_sym_EQ_GT] = ACTIONS(252),
    [anon_sym_COLON_EQ] = ACTIONS(252),
    [anon_sym_DASH_GT] = ACTIONS(252),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_end] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_of] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_after] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(252),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(252),
    [sym_float] = ACTIONS(252),
    [sym_atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [sym_variable] = ACTIONS(252),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_tripledot] = ACTIONS(252),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [51] = {
    [sym_comment] = STATE(51),
    [anon_sym_COMMA] = ACTIONS(232),
    [anon_sym_SEMI] = ACTIONS(232),
    [anon_sym_DASH] = ACTIONS(234),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_COLON] = ACTIONS(234),
    [anon_sym_when] = ACTIONS(234),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_LT_LT] = ACTIONS(232),
    [anon_sym_LBRACE] = ACTIONS(232),
    [anon_sym_LBRACK] = ACTIONS(232),
    [anon_sym_POUND] = ACTIONS(232),
    [anon_sym_PLUS] = ACTIONS(234),
    [anon_sym_not] = ACTIONS(234),
    [anon_sym_bnot] = ACTIONS(234),
    [anon_sym_catch] = ACTIONS(234),
    [anon_sym_SLASH] = ACTIONS(234),
    [anon_sym_STAR] = ACTIONS(232),
    [anon_sym_div] = ACTIONS(234),
    [anon_sym_rem] = ACTIONS(234),
    [anon_sym_band] = ACTIONS(234),
    [anon_sym_and] = ACTIONS(234),
    [anon_sym_bor] = ACTIONS(234),
    [anon_sym_bxor] = ACTIONS(234),
    [anon_sym_bsl] = ACTIONS(234),
    [anon_sym_bsr] = ACTIONS(234),
    [anon_sym_or] = ACTIONS(234),
    [anon_sym_xor] = ACTIONS(234),
    [anon_sym_PLUS_PLUS] = ACTIONS(232),
    [anon_sym_DASH_DASH] = ACTIONS(232),
    [anon_sym_EQ_EQ] = ACTIONS(232),
    [anon_sym_SLASH_EQ] = ACTIONS(232),
    [anon_sym_EQ_LT] = ACTIONS(232),
    [anon_sym_LT] = ACTIONS(234),
    [anon_sym_GT_EQ] = ACTIONS(232),
    [anon_sym_GT] = ACTIONS(234),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(232),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(232),
    [anon_sym_andalso] = ACTIONS(234),
    [anon_sym_orelse] = ACTIONS(234),
    [anon_sym_EQ] = ACTIONS(234),
    [anon_sym_BANG] = ACTIONS(232),
    [anon_sym_QMARK_EQ] = ACTIONS(232),
    [anon_sym_DOT_DOT] = ACTIONS(234),
    [anon_sym_PIPE_PIPE] = ACTIONS(232),
    [anon_sym_COLON_COLON] = ACTIONS(232),
    [anon_sym_PIPE] = ACTIONS(234),
    [anon_sym_LT_DASH] = ACTIONS(232),
    [anon_sym_LT_EQ] = ACTIONS(232),
    [anon_sym_EQ_GT] = ACTIONS(232),
    [anon_sym_COLON_EQ] = ACTIONS(232),
    [anon_sym_DASH_GT] = ACTIONS(232),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_end] = ACTIONS(234),
    [anon_sym_begin] = ACTIONS(234),
    [anon_sym_case] = ACTIONS(234),
    [anon_sym_receive] = ACTIONS(234),
    [anon_sym_after] = ACTIONS(234),
    [anon_sym_try] = ACTIONS(234),
    [anon_sym_maybe] = ACTIONS(234),
    [anon_sym_DOLLAR] = ACTIONS(232),
    [aux_sym_integer_token1] = ACTIONS(234),
    [aux_sym_integer_token2] = ACTIONS(232),
    [sym_float] = ACTIONS(232),
    [sym_atom] = ACTIONS(234),
    [anon_sym_SQUOTE] = ACTIONS(232),
    [sym_variable] = ACTIONS(232),
    [anon_sym_QMARK] = ACTIONS(234),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [sym_tripledot] = ACTIONS(232),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [52] = {
    [sym_comment] = STATE(52),
    [anon_sym_COMMA] = ACTIONS(234),
    [anon_sym_DOT] = ACTIONS(234),
    [anon_sym_LF] = ACTIONS(232),
    [anon_sym_SEMI] = ACTIONS(234),
    [anon_sym_DASH] = ACTIONS(234),
    [anon_sym_LPAREN] = ACTIONS(234),
    [anon_sym_COLON] = ACTIONS(234),
    [anon_sym_when] = ACTIONS(234),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_LT_LT] = ACTIONS(234),
    [anon_sym_LBRACE] = ACTIONS(234),
    [anon_sym_LBRACK] = ACTIONS(234),
    [anon_sym_POUND] = ACTIONS(234),
    [anon_sym_PLUS] = ACTIONS(234),
    [anon_sym_not] = ACTIONS(234),
    [anon_sym_bnot] = ACTIONS(234),
    [anon_sym_catch] = ACTIONS(234),
    [anon_sym_SLASH] = ACTIONS(234),
    [anon_sym_STAR] = ACTIONS(234),
    [anon_sym_div] = ACTIONS(234),
    [anon_sym_rem] = ACTIONS(234),
    [anon_sym_band] = ACTIONS(234),
    [anon_sym_and] = ACTIONS(234),
    [anon_sym_bor] = ACTIONS(234),
    [anon_sym_bxor] = ACTIONS(234),
    [anon_sym_bsl] = ACTIONS(234),
    [anon_sym_bsr] = ACTIONS(234),
    [anon_sym_or] = ACTIONS(234),
    [anon_sym_xor] = ACTIONS(234),
    [anon_sym_PLUS_PLUS] = ACTIONS(234),
    [anon_sym_DASH_DASH] = ACTIONS(234),
    [anon_sym_EQ_EQ] = ACTIONS(234),
    [anon_sym_SLASH_EQ] = ACTIONS(234),
    [anon_sym_EQ_LT] = ACTIONS(234),
    [anon_sym_LT] = ACTIONS(234),
    [anon_sym_GT_EQ] = ACTIONS(234),
    [anon_sym_GT] = ACTIONS(234),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(234),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(234),
    [anon_sym_andalso] = ACTIONS(234),
    [anon_sym_orelse] = ACTIONS(234),
    [anon_sym_EQ] = ACTIONS(234),
    [anon_sym_BANG] = ACTIONS(234),
    [anon_sym_QMARK_EQ] = ACTIONS(234),
    [anon_sym_DOT_DOT] = ACTIONS(234),
    [anon_sym_PIPE_PIPE] = ACTIONS(234),
    [anon_sym_COLON_COLON] = ACTIONS(234),
    [anon_sym_PIPE] = ACTIONS(234),
    [anon_sym_LT_DASH] = ACTIONS(234),
    [anon_sym_LT_EQ] = ACTIONS(234),
    [anon_sym_EQ_GT] = ACTIONS(234),
    [anon_sym_COLON_EQ] = ACTIONS(234),
    [anon_sym_DASH_GT] = ACTIONS(234),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_begin] = ACTIONS(234),
    [anon_sym_case] = ACTIONS(234),
    [anon_sym_receive] = ACTIONS(234),
    [anon_sym_try] = ACTIONS(234),
    [anon_sym_maybe] = ACTIONS(234),
    [anon_sym_DOLLAR] = ACTIONS(234),
    [aux_sym_integer_token1] = ACTIONS(234),
    [aux_sym_integer_token2] = ACTIONS(234),
    [sym_float] = ACTIONS(234),
    [sym_atom] = ACTIONS(234),
    [anon_sym_SQUOTE] = ACTIONS(234),
    [sym_variable] = ACTIONS(234),
    [anon_sym_QMARK] = ACTIONS(234),
    [anon_sym_DQUOTE] = ACTIONS(234),
    [sym_tripledot] = ACTIONS(234),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [53] = {
    [sym_comment] = STATE(53),
    [anon_sym_COMMA] = ACTIONS(242),
    [anon_sym_DOT] = ACTIONS(242),
    [anon_sym_LF] = ACTIONS(240),
    [anon_sym_SEMI] = ACTIONS(242),
    [anon_sym_DASH] = ACTIONS(242),
    [anon_sym_LPAREN] = ACTIONS(242),
    [anon_sym_COLON] = ACTIONS(242),
    [anon_sym_when] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(242),
    [anon_sym_LBRACE] = ACTIONS(242),
    [anon_sym_LBRACK] = ACTIONS(242),
    [anon_sym_POUND] = ACTIONS(242),
    [anon_sym_PLUS] = ACTIONS(242),
    [anon_sym_not] = ACTIONS(242),
    [anon_sym_bnot] = ACTIONS(242),
    [anon_sym_catch] = ACTIONS(242),
    [anon_sym_SLASH] = ACTIONS(242),
    [anon_sym_STAR] = ACTIONS(242),
    [anon_sym_div] = ACTIONS(242),
    [anon_sym_rem] = ACTIONS(242),
    [anon_sym_band] = ACTIONS(242),
    [anon_sym_and] = ACTIONS(242),
    [anon_sym_bor] = ACTIONS(242),
    [anon_sym_bxor] = ACTIONS(242),
    [anon_sym_bsl] = ACTIONS(242),
    [anon_sym_bsr] = ACTIONS(242),
    [anon_sym_or] = ACTIONS(242),
    [anon_sym_xor] = ACTIONS(242),
    [anon_sym_PLUS_PLUS] = ACTIONS(242),
    [anon_sym_DASH_DASH] = ACTIONS(242),
    [anon_sym_EQ_EQ] = ACTIONS(242),
    [anon_sym_SLASH_EQ] = ACTIONS(242),
    [anon_sym_EQ_LT] = ACTIONS(242),
    [anon_sym_LT] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(242),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(242),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(242),
    [anon_sym_andalso] = ACTIONS(242),
    [anon_sym_orelse] = ACTIONS(242),
    [anon_sym_EQ] = ACTIONS(242),
    [anon_sym_BANG] = ACTIONS(242),
    [anon_sym_QMARK_EQ] = ACTIONS(242),
    [anon_sym_DOT_DOT] = ACTIONS(242),
    [anon_sym_PIPE_PIPE] = ACTIONS(242),
    [anon_sym_COLON_COLON] = ACTIONS(242),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_LT_DASH] = ACTIONS(242),
    [anon_sym_LT_EQ] = ACTIONS(242),
    [anon_sym_EQ_GT] = ACTIONS(242),
    [anon_sym_COLON_EQ] = ACTIONS(242),
    [anon_sym_DASH_GT] = ACTIONS(242),
    [anon_sym_fun] = ACTIONS(242),
    [anon_sym_begin] = ACTIONS(242),
    [anon_sym_case] = ACTIONS(242),
    [anon_sym_receive] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(242),
    [anon_sym_maybe] = ACTIONS(242),
    [anon_sym_DOLLAR] = ACTIONS(242),
    [aux_sym_integer_token1] = ACTIONS(242),
    [aux_sym_integer_token2] = ACTIONS(242),
    [sym_float] = ACTIONS(242),
    [sym_atom] = ACTIONS(242),
    [anon_sym_SQUOTE] = ACTIONS(242),
    [sym_variable] = ACTIONS(242),
    [anon_sym_QMARK] = ACTIONS(242),
    [anon_sym_DQUOTE] = ACTIONS(242),
    [sym_tripledot] = ACTIONS(242),
    [aux_sym_comment_token1] = ACTIONS(149),
  },
  [54] = {
    [sym_comment] = STATE(54),
    [anon_sym_COMMA] = ACTIONS(240),
    [anon_sym_SEMI] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(242),
    [anon_sym_LPAREN] = ACTIONS(240),
    [anon_sym_COLON] = ACTIONS(242),
    [anon_sym_when] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_LBRACE] = ACTIONS(240),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_POUND] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(242),
    [anon_sym_not] = ACTIONS(242),
    [anon_sym_bnot] = ACTIONS(242),
    [anon_sym_catch] = ACTIONS(242),
    [anon_sym_SLASH] = ACTIONS(242),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_div] = ACTIONS(242),
    [anon_sym_rem] = ACTIONS(242),
    [anon_sym_band] = ACTIONS(242),
    [anon_sym_and] = ACTIONS(242),
    [anon_sym_bor] = ACTIONS(242),
    [anon_sym_bxor] = ACTIONS(242),
    [anon_sym_bsl] = ACTIONS(242),
    [anon_sym_bsr] = ACTIONS(242),
    [anon_sym_or] = ACTIONS(242),
    [anon_sym_xor] = ACTIONS(242),
    [anon_sym_PLUS_PLUS] = ACTIONS(240),
    [anon_sym_DASH_DASH] = ACTIONS(240),
    [anon_sym_EQ_EQ] = ACTIONS(240),
    [anon_sym_SLASH_EQ] = ACTIONS(240),
    [anon_sym_EQ_LT] = ACTIONS(240),
    [anon_sym_LT] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(242),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(240),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(240),
    [anon_sym_andalso] = ACTIONS(242),
    [anon_sym_orelse] = ACTIONS(242),
    [anon_sym_EQ] = ACTIONS(242),
    [anon_sym_BANG] = ACTIONS(240),
    [anon_sym_QMARK_EQ] = ACTIONS(240),
    [anon_sym_DOT_DOT] = ACTIONS(242),
    [anon_sym_PIPE_PIPE] = ACTIONS(240),
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_LT_DASH] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(240),
    [anon_sym_EQ_GT] = ACTIONS(240),
    [anon_sym_COLON_EQ] = ACTIONS(240),
    [anon_sym_DASH_GT] = ACTIONS(240),
    [anon_sym_fun] = ACTIONS(242),
    [anon_sym_end] = ACTIONS(242),
    [anon_sym_begin] = ACTIONS(242),
    [anon_sym_case] = ACTIONS(242),
    [anon_sym_receive] = ACTIONS(242),
    [anon_sym_after] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(242),
    [anon_sym_maybe] = ACTIONS(242),
    [anon_sym_DOLLAR] = ACTIONS(240),
    [aux_sym_integer_token1] = ACTIONS(242),
    [aux_sym_integer_token2] = ACTIONS(240),
    [sym_float] = ACTIONS(240),
    [sym_atom] = ACTIONS(242),
    [anon_sym_SQUOTE] = ACTIONS(240),
    [sym_variable] = ACTIONS(240),
    [anon_sym_QMARK] = ACTIONS(242),
    [anon_sym_DQUOTE] = ACTIONS(240),
    [sym_tripledot] = ACTIONS(240),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [55] = {
    [sym_arguments] = STATE(64),
    [sym_comment] = STATE(55),
    [anon_sym_COMMA] = ACTIONS(224),
    [anon_sym_SEMI] = ACTIONS(224),
    [anon_sym_DASH] = ACTIONS(226),
    [anon_sym_LPAREN] = ACTIONS(262),
    [anon_sym_COLON] = ACTIONS(226),
    [anon_sym_when] = ACTIONS(226),
    [anon_sym_if] = ACTIONS(226),
    [anon_sym_LT_LT] = ACTIONS(224),
    [anon_sym_LBRACE] = ACTIONS(224),
    [anon_sym_LBRACK] = ACTIONS(224),
    [anon_sym_POUND] = ACTIONS(224),
    [anon_sym_PLUS] = ACTIONS(226),
    [anon_sym_not] = ACTIONS(226),
    [anon_sym_bnot] = ACTIONS(226),
    [anon_sym_catch] = ACTIONS(226),
    [anon_sym_SLASH] = ACTIONS(226),
    [anon_sym_STAR] = ACTIONS(224),
    [anon_sym_div] = ACTIONS(226),
    [anon_sym_rem] = ACTIONS(226),
    [anon_sym_band] = ACTIONS(226),
    [anon_sym_and] = ACTIONS(226),
    [anon_sym_bor] = ACTIONS(226),
    [anon_sym_bxor] = ACTIONS(226),
    [anon_sym_bsl] = ACTIONS(226),
    [anon_sym_bsr] = ACTIONS(226),
    [anon_sym_or] = ACTIONS(226),
    [anon_sym_xor] = ACTIONS(226),
    [anon_sym_PLUS_PLUS] = ACTIONS(224),
    [anon_sym_DASH_DASH] = ACTIONS(224),
    [anon_sym_EQ_EQ] = ACTIONS(224),
    [anon_sym_SLASH_EQ] = ACTIONS(224),
    [anon_sym_EQ_LT] = ACTIONS(224),
    [anon_sym_LT] = ACTIONS(226),
    [anon_sym_GT_EQ] = ACTIONS(224),
    [anon_sym_GT] = ACTIONS(226),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(224),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(224),
    [anon_sym_andalso] = ACTIONS(226),
    [anon_sym_orelse] = ACTIONS(226),
    [anon_sym_EQ] = ACTIONS(226),
    [anon_sym_BANG] = ACTIONS(224),
    [anon_sym_QMARK_EQ] = ACTIONS(224),
    [anon_sym_DOT_DOT] = ACTIONS(226),
    [anon_sym_PIPE_PIPE] = ACTIONS(224),
    [anon_sym_COLON_COLON] = ACTIONS(224),
    [anon_sym_PIPE] = ACTIONS(226),
    [anon_sym_LT_DASH] = ACTIONS(224),
    [anon_sym_LT_EQ] = ACTIONS(224),
    [anon_sym_EQ_GT] = ACTIONS(224),
    [anon_sym_COLON_EQ] = ACTIONS(224),
    [anon_sym_DASH_GT] = ACTIONS(224),
    [anon_sym_fun] = ACTIONS(226),
    [anon_sym_end] = ACTIONS(226),
    [anon_sym_begin] = ACTIONS(226),
    [anon_sym_case] = ACTIONS(226),
    [anon_sym_receive] = ACTIONS(226),
    [anon_sym_try] = ACTIONS(226),
    [anon_sym_maybe] = ACTIONS(226),
    [anon_sym_DOLLAR] = ACTIONS(224),
    [aux_sym_integer_token1] = ACTIONS(226),
    [aux_sym_integer_token2] = ACTIONS(224),
    [sym_float] = ACTIONS(224),
    [sym_atom] = ACTIONS(226),
    [anon_sym_SQUOTE] = ACTIONS(224),
    [sym_variable] = ACTIONS(224),
    [anon_sym_QMARK] = ACTIONS(226),
    [anon_sym_DQUOTE] = ACTIONS(224),
    [sym_tripledot] = ACTIONS(224),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [56] = {
    [sym_comment] = STATE(56),
    [anon_sym_COMMA] = ACTIONS(232),
    [anon_sym_DASH] = ACTIONS(234),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_COLON] = ACTIONS(234),
    [anon_sym_when] = ACTIONS(234),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_LT_LT] = ACTIONS(232),
    [anon_sym_LBRACE] = ACTIONS(232),
    [anon_sym_LBRACK] = ACTIONS(232),
    [anon_sym_POUND] = ACTIONS(232),
    [anon_sym_PLUS] = ACTIONS(234),
    [anon_sym_not] = ACTIONS(234),
    [anon_sym_bnot] = ACTIONS(234),
    [anon_sym_catch] = ACTIONS(234),
    [anon_sym_SLASH] = ACTIONS(234),
    [anon_sym_STAR] = ACTIONS(232),
    [anon_sym_div] = ACTIONS(234),
    [anon_sym_rem] = ACTIONS(234),
    [anon_sym_band] = ACTIONS(234),
    [anon_sym_and] = ACTIONS(234),
    [anon_sym_bor] = ACTIONS(234),
    [anon_sym_bxor] = ACTIONS(234),
    [anon_sym_bsl] = ACTIONS(234),
    [anon_sym_bsr] = ACTIONS(234),
    [anon_sym_or] = ACTIONS(234),
    [anon_sym_xor] = ACTIONS(234),
    [anon_sym_PLUS_PLUS] = ACTIONS(232),
    [anon_sym_DASH_DASH] = ACTIONS(232),
    [anon_sym_EQ_EQ] = ACTIONS(232),
    [anon_sym_SLASH_EQ] = ACTIONS(232),
    [anon_sym_EQ_LT] = ACTIONS(232),
    [anon_sym_LT] = ACTIONS(234),
    [anon_sym_GT_EQ] = ACTIONS(232),
    [anon_sym_GT] = ACTIONS(234),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(232),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(232),
    [anon_sym_andalso] = ACTIONS(234),
    [anon_sym_orelse] = ACTIONS(234),
    [anon_sym_EQ] = ACTIONS(234),
    [anon_sym_BANG] = ACTIONS(232),
    [anon_sym_QMARK_EQ] = ACTIONS(232),
    [anon_sym_DOT_DOT] = ACTIONS(234),
    [anon_sym_PIPE_PIPE] = ACTIONS(232),
    [anon_sym_COLON_COLON] = ACTIONS(232),
    [anon_sym_PIPE] = ACTIONS(234),
    [anon_sym_LT_DASH] = ACTIONS(232),
    [anon_sym_LT_EQ] = ACTIONS(232),
    [anon_sym_EQ_GT] = ACTIONS(232),
    [anon_sym_COLON_EQ] = ACTIONS(232),
    [anon_sym_DASH_GT] = ACTIONS(232),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_end] = ACTIONS(234),
    [anon_sym_begin] = ACTIONS(234),
    [anon_sym_case] = ACTIONS(234),
    [anon_sym_of] = ACTIONS(234),
    [anon_sym_receive] = ACTIONS(234),
    [anon_sym_after] = ACTIONS(234),
    [anon_sym_try] = ACTIONS(234),
    [anon_sym_maybe] = ACTIONS(234),
    [anon_sym_DOLLAR] = ACTIONS(232),
    [aux_sym_integer_token1] = ACTIONS(234),
    [aux_sym_integer_token2] = ACTIONS(232),
    [sym_float] = ACTIONS(232),
    [sym_atom] = ACTIONS(234),
    [anon_sym_SQUOTE] = ACTIONS(232),
    [sym_variable] = ACTIONS(232),
    [anon_sym_QMARK] = ACTIONS(234),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [sym_tripledot] = ACTIONS(232),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [57] = {
    [sym_arguments] = STATE(69),
    [sym_comment] = STATE(57),
    [anon_sym_COMMA] = ACTIONS(218),
    [anon_sym_SEMI] = ACTIONS(218),
    [anon_sym_DASH] = ACTIONS(220),
    [anon_sym_LPAREN] = ACTIONS(262),
    [anon_sym_COLON] = ACTIONS(220),
    [anon_sym_when] = ACTIONS(220),
    [anon_sym_if] = ACTIONS(220),
    [anon_sym_LT_LT] = ACTIONS(218),
    [anon_sym_LBRACE] = ACTIONS(218),
    [anon_sym_LBRACK] = ACTIONS(218),
    [anon_sym_POUND] = ACTIONS(218),
    [anon_sym_PLUS] = ACTIONS(220),
    [anon_sym_not] = ACTIONS(220),
    [anon_sym_bnot] = ACTIONS(220),
    [anon_sym_catch] = ACTIONS(220),
    [anon_sym_SLASH] = ACTIONS(220),
    [anon_sym_STAR] = ACTIONS(218),
    [anon_sym_div] = ACTIONS(220),
    [anon_sym_rem] = ACTIONS(220),
    [anon_sym_band] = ACTIONS(220),
    [anon_sym_and] = ACTIONS(220),
    [anon_sym_bor] = ACTIONS(220),
    [anon_sym_bxor] = ACTIONS(220),
    [anon_sym_bsl] = ACTIONS(220),
    [anon_sym_bsr] = ACTIONS(220),
    [anon_sym_or] = ACTIONS(220),
    [anon_sym_xor] = ACTIONS(220),
    [anon_sym_PLUS_PLUS] = ACTIONS(218),
    [anon_sym_DASH_DASH] = ACTIONS(218),
    [anon_sym_EQ_EQ] = ACTIONS(218),
    [anon_sym_SLASH_EQ] = ACTIONS(218),
    [anon_sym_EQ_LT] = ACTIONS(218),
    [anon_sym_LT] = ACTIONS(220),
    [anon_sym_GT_EQ] = ACTIONS(218),
    [anon_sym_GT] = ACTIONS(220),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(218),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(218),
    [anon_sym_andalso] = ACTIONS(220),
    [anon_sym_orelse] = ACTIONS(220),
    [anon_sym_EQ] = ACTIONS(220),
    [anon_sym_BANG] = ACTIONS(218),
    [anon_sym_QMARK_EQ] = ACTIONS(218),
    [anon_sym_DOT_DOT] = ACTIONS(220),
    [anon_sym_PIPE_PIPE] = ACTIONS(218),
    [anon_sym_COLON_COLON] = ACTIONS(218),
    [anon_sym_PIPE] = ACTIONS(220),
    [anon_sym_LT_DASH] = ACTIONS(218),
    [anon_sym_LT_EQ] = ACTIONS(218),
    [anon_sym_EQ_GT] = ACTIONS(218),
    [anon_sym_COLON_EQ] = ACTIONS(218),
    [anon_sym_DASH_GT] = ACTIONS(218),
    [anon_sym_fun] = ACTIONS(220),
    [anon_sym_end] = ACTIONS(220),
    [anon_sym_begin] = ACTIONS(220),
    [anon_sym_case] = ACTIONS(220),
    [anon_sym_receive] = ACTIONS(220),
    [anon_sym_try] = ACTIONS(220),
    [anon_sym_maybe] = ACTIONS(220),
    [anon_sym_DOLLAR] = ACTIONS(218),
    [aux_sym_integer_token1] = ACTIONS(220),
    [aux_sym_integer_token2] = ACTIONS(218),
    [sym_float] = ACTIONS(218),
    [sym_atom] = ACTIONS(220),
    [anon_sym_SQUOTE] = ACTIONS(218),
    [sym_variable] = ACTIONS(218),
    [anon_sym_QMARK] = ACTIONS(220),
    [anon_sym_DQUOTE] = ACTIONS(218),
    [sym_tripledot] = ACTIONS(218),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [58] = {
    [sym_comment] = STATE(58),
    [anon_sym_COMMA] = ACTIONS(228),
    [anon_sym_SEMI] = ACTIONS(228),
    [anon_sym_DASH] = ACTIONS(230),
    [anon_sym_LPAREN] = ACTIONS(228),
    [anon_sym_COLON] = ACTIONS(230),
    [anon_sym_when] = ACTIONS(230),
    [anon_sym_if] = ACTIONS(230),
    [anon_sym_LT_LT] = ACTIONS(228),
    [anon_sym_LBRACE] = ACTIONS(228),
    [anon_sym_LBRACK] = ACTIONS(228),
    [anon_sym_POUND] = ACTIONS(228),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_not] = ACTIONS(230),
    [anon_sym_bnot] = ACTIONS(230),
    [anon_sym_catch] = ACTIONS(230),
    [anon_sym_SLASH] = ACTIONS(230),
    [anon_sym_STAR] = ACTIONS(228),
    [anon_sym_div] = ACTIONS(230),
    [anon_sym_rem] = ACTIONS(230),
    [anon_sym_band] = ACTIONS(230),
    [anon_sym_and] = ACTIONS(230),
    [anon_sym_bor] = ACTIONS(230),
    [anon_sym_bxor] = ACTIONS(230),
    [anon_sym_bsl] = ACTIONS(230),
    [anon_sym_bsr] = ACTIONS(230),
    [anon_sym_or] = ACTIONS(230),
    [anon_sym_xor] = ACTIONS(230),
    [anon_sym_PLUS_PLUS] = ACTIONS(228),
    [anon_sym_DASH_DASH] = ACTIONS(228),
    [anon_sym_EQ_EQ] = ACTIONS(228),
    [anon_sym_SLASH_EQ] = ACTIONS(228),
    [anon_sym_EQ_LT] = ACTIONS(228),
    [anon_sym_LT] = ACTIONS(230),
    [anon_sym_GT_EQ] = ACTIONS(228),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(228),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(228),
    [anon_sym_andalso] = ACTIONS(230),
    [anon_sym_orelse] = ACTIONS(230),
    [anon_sym_EQ] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(228),
    [anon_sym_QMARK_EQ] = ACTIONS(228),
    [anon_sym_DOT_DOT] = ACTIONS(230),
    [anon_sym_PIPE_PIPE] = ACTIONS(228),
    [anon_sym_COLON_COLON] = ACTIONS(228),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_LT_DASH] = ACTIONS(228),
    [anon_sym_LT_EQ] = ACTIONS(228),
    [anon_sym_EQ_GT] = ACTIONS(228),
    [anon_sym_COLON_EQ] = ACTIONS(228),
    [anon_sym_DASH_GT] = ACTIONS(228),
    [anon_sym_fun] = ACTIONS(230),
    [anon_sym_end] = ACTIONS(230),
    [anon_sym_begin] = ACTIONS(230),
    [anon_sym_case] = ACTIONS(230),
    [anon_sym_receive] = ACTIONS(230),
    [anon_sym_after] = ACTIONS(230),
    [anon_sym_try] = ACTIONS(230),
    [anon_sym_maybe] = ACTIONS(230),
    [anon_sym_DOLLAR] = ACTIONS(228),
    [aux_sym_integer_token1] = ACTIONS(230),
    [aux_sym_integer_token2] = ACTIONS(228),
    [sym_float] = ACTIONS(228),
    [sym_atom] = ACTIONS(230),
    [anon_sym_SQUOTE] = ACTIONS(228),
    [sym_variable] = ACTIONS(228),
    [anon_sym_QMARK] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(228),
    [sym_tripledot] = ACTIONS(228),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [59] = {
    [sym_arguments] = STATE(72),
    [sym_comment] = STATE(59),
    [anon_sym_COMMA] = ACTIONS(224),
    [anon_sym_DASH] = ACTIONS(226),
    [anon_sym_LPAREN] = ACTIONS(264),
    [anon_sym_COLON] = ACTIONS(226),
    [anon_sym_when] = ACTIONS(226),
    [anon_sym_if] = ACTIONS(226),
    [anon_sym_LT_LT] = ACTIONS(224),
    [anon_sym_LBRACE] = ACTIONS(224),
    [anon_sym_LBRACK] = ACTIONS(224),
    [anon_sym_POUND] = ACTIONS(224),
    [anon_sym_PLUS] = ACTIONS(226),
    [anon_sym_not] = ACTIONS(226),
    [anon_sym_bnot] = ACTIONS(226),
    [anon_sym_catch] = ACTIONS(226),
    [anon_sym_SLASH] = ACTIONS(226),
    [anon_sym_STAR] = ACTIONS(224),
    [anon_sym_div] = ACTIONS(226),
    [anon_sym_rem] = ACTIONS(226),
    [anon_sym_band] = ACTIONS(226),
    [anon_sym_and] = ACTIONS(226),
    [anon_sym_bor] = ACTIONS(226),
    [anon_sym_bxor] = ACTIONS(226),
    [anon_sym_bsl] = ACTIONS(226),
    [anon_sym_bsr] = ACTIONS(226),
    [anon_sym_or] = ACTIONS(226),
    [anon_sym_xor] = ACTIONS(226),
    [anon_sym_PLUS_PLUS] = ACTIONS(224),
    [anon_sym_DASH_DASH] = ACTIONS(224),
    [anon_sym_EQ_EQ] = ACTIONS(224),
    [anon_sym_SLASH_EQ] = ACTIONS(224),
    [anon_sym_EQ_LT] = ACTIONS(224),
    [anon_sym_LT] = ACTIONS(226),
    [anon_sym_GT_EQ] = ACTIONS(224),
    [anon_sym_GT] = ACTIONS(226),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(224),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(224),
    [anon_sym_andalso] = ACTIONS(226),
    [anon_sym_orelse] = ACTIONS(226),
    [anon_sym_EQ] = ACTIONS(226),
    [anon_sym_BANG] = ACTIONS(224),
    [anon_sym_QMARK_EQ] = ACTIONS(224),
    [anon_sym_DOT_DOT] = ACTIONS(226),
    [anon_sym_PIPE_PIPE] = ACTIONS(224),
    [anon_sym_COLON_COLON] = ACTIONS(224),
    [anon_sym_PIPE] = ACTIONS(226),
    [anon_sym_LT_DASH] = ACTIONS(224),
    [anon_sym_LT_EQ] = ACTIONS(224),
    [anon_sym_EQ_GT] = ACTIONS(224),
    [anon_sym_COLON_EQ] = ACTIONS(224),
    [anon_sym_DASH_GT] = ACTIONS(224),
    [anon_sym_fun] = ACTIONS(226),
    [anon_sym_end] = ACTIONS(226),
    [anon_sym_begin] = ACTIONS(226),
    [anon_sym_case] = ACTIONS(226),
    [anon_sym_receive] = ACTIONS(226),
    [anon_sym_try] = ACTIONS(226),
    [anon_sym_maybe] = ACTIONS(226),
    [anon_sym_else] = ACTIONS(226),
    [anon_sym_DOLLAR] = ACTIONS(224),
    [aux_sym_integer_token1] = ACTIONS(226),
    [aux_sym_integer_token2] = ACTIONS(224),
    [sym_float] = ACTIONS(224),
    [sym_atom] = ACTIONS(226),
    [anon_sym_SQUOTE] = ACTIONS(224),
    [sym_variable] = ACTIONS(224),
    [anon_sym_QMARK] = ACTIONS(226),
    [anon_sym_DQUOTE] = ACTIONS(224),
    [sym_tripledot] = ACTIONS(224),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [60] = {
    [sym_comment] = STATE(60),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_SEMI] = ACTIONS(244),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(244),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(244),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_POUND] = ACTIONS(244),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(244),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_EQ_EQ] = ACTIONS(244),
    [anon_sym_SLASH_EQ] = ACTIONS(244),
    [anon_sym_EQ_LT] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(244),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(244),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_QMARK_EQ] = ACTIONS(244),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(244),
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(244),
    [anon_sym_LT_EQ] = ACTIONS(244),
    [anon_sym_EQ_GT] = ACTIONS(244),
    [anon_sym_COLON_EQ] = ACTIONS(244),
    [anon_sym_DASH_GT] = ACTIONS(244),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_after] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(244),
    [sym_float] = ACTIONS(244),
    [sym_atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(244),
    [sym_variable] = ACTIONS(244),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [sym_tripledot] = ACTIONS(244),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [61] = {
    [sym_comment] = STATE(61),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym_SEMI] = ACTIONS(248),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_DASH_GT] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_end] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_after] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym_atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [62] = {
    [sym_comment] = STATE(62),
    [anon_sym_COMMA] = ACTIONS(252),
    [anon_sym_SEMI] = ACTIONS(252),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(252),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_EQ_EQ] = ACTIONS(252),
    [anon_sym_SLASH_EQ] = ACTIONS(252),
    [anon_sym_EQ_LT] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(252),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(252),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(252),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_QMARK_EQ] = ACTIONS(252),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(252),
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(252),
    [anon_sym_LT_EQ] = ACTIONS(252),
    [anon_sym_EQ_GT] = ACTIONS(252),
    [anon_sym_COLON_EQ] = ACTIONS(252),
    [anon_sym_DASH_GT] = ACTIONS(252),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_end] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_after] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(252),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(252),
    [sym_float] = ACTIONS(252),
    [sym_atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [sym_variable] = ACTIONS(252),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_tripledot] = ACTIONS(252),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [63] = {
    [sym_arguments] = STATE(68),
    [sym_comment] = STATE(63),
    [anon_sym_COMMA] = ACTIONS(218),
    [anon_sym_DASH] = ACTIONS(220),
    [anon_sym_LPAREN] = ACTIONS(264),
    [anon_sym_COLON] = ACTIONS(220),
    [anon_sym_when] = ACTIONS(220),
    [anon_sym_if] = ACTIONS(220),
    [anon_sym_LT_LT] = ACTIONS(218),
    [anon_sym_LBRACE] = ACTIONS(218),
    [anon_sym_LBRACK] = ACTIONS(218),
    [anon_sym_POUND] = ACTIONS(218),
    [anon_sym_PLUS] = ACTIONS(220),
    [anon_sym_not] = ACTIONS(220),
    [anon_sym_bnot] = ACTIONS(220),
    [anon_sym_catch] = ACTIONS(220),
    [anon_sym_SLASH] = ACTIONS(220),
    [anon_sym_STAR] = ACTIONS(218),
    [anon_sym_div] = ACTIONS(220),
    [anon_sym_rem] = ACTIONS(220),
    [anon_sym_band] = ACTIONS(220),
    [anon_sym_and] = ACTIONS(220),
    [anon_sym_bor] = ACTIONS(220),
    [anon_sym_bxor] = ACTIONS(220),
    [anon_sym_bsl] = ACTIONS(220),
    [anon_sym_bsr] = ACTIONS(220),
    [anon_sym_or] = ACTIONS(220),
    [anon_sym_xor] = ACTIONS(220),
    [anon_sym_PLUS_PLUS] = ACTIONS(218),
    [anon_sym_DASH_DASH] = ACTIONS(218),
    [anon_sym_EQ_EQ] = ACTIONS(218),
    [anon_sym_SLASH_EQ] = ACTIONS(218),
    [anon_sym_EQ_LT] = ACTIONS(218),
    [anon_sym_LT] = ACTIONS(220),
    [anon_sym_GT_EQ] = ACTIONS(218),
    [anon_sym_GT] = ACTIONS(220),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(218),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(218),
    [anon_sym_andalso] = ACTIONS(220),
    [anon_sym_orelse] = ACTIONS(220),
    [anon_sym_EQ] = ACTIONS(220),
    [anon_sym_BANG] = ACTIONS(218),
    [anon_sym_QMARK_EQ] = ACTIONS(218),
    [anon_sym_DOT_DOT] = ACTIONS(220),
    [anon_sym_PIPE_PIPE] = ACTIONS(218),
    [anon_sym_COLON_COLON] = ACTIONS(218),
    [anon_sym_PIPE] = ACTIONS(220),
    [anon_sym_LT_DASH] = ACTIONS(218),
    [anon_sym_LT_EQ] = ACTIONS(218),
    [anon_sym_EQ_GT] = ACTIONS(218),
    [anon_sym_COLON_EQ] = ACTIONS(218),
    [anon_sym_DASH_GT] = ACTIONS(218),
    [anon_sym_fun] = ACTIONS(220),
    [anon_sym_end] = ACTIONS(220),
    [anon_sym_begin] = ACTIONS(220),
    [anon_sym_case] = ACTIONS(220),
    [anon_sym_receive] = ACTIONS(220),
    [anon_sym_try] = ACTIONS(220),
    [anon_sym_maybe] = ACTIONS(220),
    [anon_sym_else] = ACTIONS(220),
    [anon_sym_DOLLAR] = ACTIONS(218),
    [aux_sym_integer_token1] = ACTIONS(220),
    [aux_sym_integer_token2] = ACTIONS(218),
    [sym_float] = ACTIONS(218),
    [sym_atom] = ACTIONS(220),
    [anon_sym_SQUOTE] = ACTIONS(218),
    [sym_variable] = ACTIONS(218),
    [anon_sym_QMARK] = ACTIONS(220),
    [anon_sym_DQUOTE] = ACTIONS(218),
    [sym_tripledot] = ACTIONS(218),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [64] = {
    [sym_comment] = STATE(64),
    [anon_sym_COMMA] = ACTIONS(236),
    [anon_sym_SEMI] = ACTIONS(236),
    [anon_sym_DASH] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(236),
    [anon_sym_COLON] = ACTIONS(238),
    [anon_sym_when] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_LT_LT] = ACTIONS(236),
    [anon_sym_LBRACE] = ACTIONS(236),
    [anon_sym_LBRACK] = ACTIONS(236),
    [anon_sym_POUND] = ACTIONS(236),
    [anon_sym_PLUS] = ACTIONS(238),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_bnot] = ACTIONS(238),
    [anon_sym_catch] = ACTIONS(238),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_STAR] = ACTIONS(236),
    [anon_sym_div] = ACTIONS(238),
    [anon_sym_rem] = ACTIONS(238),
    [anon_sym_band] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_bor] = ACTIONS(238),
    [anon_sym_bxor] = ACTIONS(238),
    [anon_sym_bsl] = ACTIONS(238),
    [anon_sym_bsr] = ACTIONS(238),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_xor] = ACTIONS(238),
    [anon_sym_PLUS_PLUS] = ACTIONS(236),
    [anon_sym_DASH_DASH] = ACTIONS(236),
    [anon_sym_EQ_EQ] = ACTIONS(236),
    [anon_sym_SLASH_EQ] = ACTIONS(236),
    [anon_sym_EQ_LT] = ACTIONS(236),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_GT_EQ] = ACTIONS(236),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(236),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(236),
    [anon_sym_andalso] = ACTIONS(238),
    [anon_sym_orelse] = ACTIONS(238),
    [anon_sym_EQ] = ACTIONS(238),
    [anon_sym_BANG] = ACTIONS(236),
    [anon_sym_QMARK_EQ] = ACTIONS(236),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_PIPE_PIPE] = ACTIONS(236),
    [anon_sym_COLON_COLON] = ACTIONS(236),
    [anon_sym_PIPE] = ACTIONS(238),
    [anon_sym_LT_DASH] = ACTIONS(236),
    [anon_sym_LT_EQ] = ACTIONS(236),
    [anon_sym_EQ_GT] = ACTIONS(236),
    [anon_sym_COLON_EQ] = ACTIONS(236),
    [anon_sym_DASH_GT] = ACTIONS(236),
    [anon_sym_fun] = ACTIONS(238),
    [anon_sym_end] = ACTIONS(238),
    [anon_sym_begin] = ACTIONS(238),
    [anon_sym_case] = ACTIONS(238),
    [anon_sym_receive] = ACTIONS(238),
    [anon_sym_try] = ACTIONS(238),
    [anon_sym_maybe] = ACTIONS(238),
    [anon_sym_DOLLAR] = ACTIONS(236),
    [aux_sym_integer_token1] = ACTIONS(238),
    [aux_sym_integer_token2] = ACTIONS(236),
    [sym_float] = ACTIONS(236),
    [sym_atom] = ACTIONS(238),
    [anon_sym_SQUOTE] = ACTIONS(236),
    [sym_variable] = ACTIONS(236),
    [anon_sym_QMARK] = ACTIONS(238),
    [anon_sym_DQUOTE] = ACTIONS(236),
    [sym_tripledot] = ACTIONS(236),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [65] = {
    [sym_comment] = STATE(65),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym_SEMI] = ACTIONS(248),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_DASH_GT] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_end] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym_atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [66] = {
    [sym_comment] = STATE(66),
    [anon_sym_COMMA] = ACTIONS(240),
    [anon_sym_SEMI] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(242),
    [anon_sym_LPAREN] = ACTIONS(240),
    [anon_sym_COLON] = ACTIONS(242),
    [anon_sym_when] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_LBRACE] = ACTIONS(240),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_POUND] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(242),
    [anon_sym_not] = ACTIONS(242),
    [anon_sym_bnot] = ACTIONS(242),
    [anon_sym_catch] = ACTIONS(242),
    [anon_sym_SLASH] = ACTIONS(242),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_div] = ACTIONS(242),
    [anon_sym_rem] = ACTIONS(242),
    [anon_sym_band] = ACTIONS(242),
    [anon_sym_and] = ACTIONS(242),
    [anon_sym_bor] = ACTIONS(242),
    [anon_sym_bxor] = ACTIONS(242),
    [anon_sym_bsl] = ACTIONS(242),
    [anon_sym_bsr] = ACTIONS(242),
    [anon_sym_or] = ACTIONS(242),
    [anon_sym_xor] = ACTIONS(242),
    [anon_sym_PLUS_PLUS] = ACTIONS(240),
    [anon_sym_DASH_DASH] = ACTIONS(240),
    [anon_sym_EQ_EQ] = ACTIONS(240),
    [anon_sym_SLASH_EQ] = ACTIONS(240),
    [anon_sym_EQ_LT] = ACTIONS(240),
    [anon_sym_LT] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(242),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(240),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(240),
    [anon_sym_andalso] = ACTIONS(242),
    [anon_sym_orelse] = ACTIONS(242),
    [anon_sym_EQ] = ACTIONS(242),
    [anon_sym_BANG] = ACTIONS(240),
    [anon_sym_QMARK_EQ] = ACTIONS(240),
    [anon_sym_DOT_DOT] = ACTIONS(242),
    [anon_sym_PIPE_PIPE] = ACTIONS(240),
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_LT_DASH] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(240),
    [anon_sym_EQ_GT] = ACTIONS(240),
    [anon_sym_COLON_EQ] = ACTIONS(240),
    [anon_sym_DASH_GT] = ACTIONS(240),
    [anon_sym_fun] = ACTIONS(242),
    [anon_sym_end] = ACTIONS(242),
    [anon_sym_begin] = ACTIONS(242),
    [anon_sym_case] = ACTIONS(242),
    [anon_sym_receive] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(242),
    [anon_sym_maybe] = ACTIONS(242),
    [anon_sym_DOLLAR] = ACTIONS(240),
    [aux_sym_integer_token1] = ACTIONS(242),
    [aux_sym_integer_token2] = ACTIONS(240),
    [sym_float] = ACTIONS(240),
    [sym_atom] = ACTIONS(242),
    [anon_sym_SQUOTE] = ACTIONS(240),
    [sym_variable] = ACTIONS(240),
    [anon_sym_QMARK] = ACTIONS(242),
    [anon_sym_DQUOTE] = ACTIONS(240),
    [sym_tripledot] = ACTIONS(240),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [67] = {
    [sym_comment] = STATE(67),
    [anon_sym_COMMA] = ACTIONS(232),
    [anon_sym_SEMI] = ACTIONS(232),
    [anon_sym_DASH] = ACTIONS(234),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_COLON] = ACTIONS(234),
    [anon_sym_when] = ACTIONS(234),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_LT_LT] = ACTIONS(232),
    [anon_sym_LBRACE] = ACTIONS(232),
    [anon_sym_LBRACK] = ACTIONS(232),
    [anon_sym_POUND] = ACTIONS(232),
    [anon_sym_PLUS] = ACTIONS(234),
    [anon_sym_not] = ACTIONS(234),
    [anon_sym_bnot] = ACTIONS(234),
    [anon_sym_catch] = ACTIONS(234),
    [anon_sym_SLASH] = ACTIONS(234),
    [anon_sym_STAR] = ACTIONS(232),
    [anon_sym_div] = ACTIONS(234),
    [anon_sym_rem] = ACTIONS(234),
    [anon_sym_band] = ACTIONS(234),
    [anon_sym_and] = ACTIONS(234),
    [anon_sym_bor] = ACTIONS(234),
    [anon_sym_bxor] = ACTIONS(234),
    [anon_sym_bsl] = ACTIONS(234),
    [anon_sym_bsr] = ACTIONS(234),
    [anon_sym_or] = ACTIONS(234),
    [anon_sym_xor] = ACTIONS(234),
    [anon_sym_PLUS_PLUS] = ACTIONS(232),
    [anon_sym_DASH_DASH] = ACTIONS(232),
    [anon_sym_EQ_EQ] = ACTIONS(232),
    [anon_sym_SLASH_EQ] = ACTIONS(232),
    [anon_sym_EQ_LT] = ACTIONS(232),
    [anon_sym_LT] = ACTIONS(234),
    [anon_sym_GT_EQ] = ACTIONS(232),
    [anon_sym_GT] = ACTIONS(234),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(232),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(232),
    [anon_sym_andalso] = ACTIONS(234),
    [anon_sym_orelse] = ACTIONS(234),
    [anon_sym_EQ] = ACTIONS(234),
    [anon_sym_BANG] = ACTIONS(232),
    [anon_sym_QMARK_EQ] = ACTIONS(232),
    [anon_sym_DOT_DOT] = ACTIONS(234),
    [anon_sym_PIPE_PIPE] = ACTIONS(232),
    [anon_sym_COLON_COLON] = ACTIONS(232),
    [anon_sym_PIPE] = ACTIONS(234),
    [anon_sym_LT_DASH] = ACTIONS(232),
    [anon_sym_LT_EQ] = ACTIONS(232),
    [anon_sym_EQ_GT] = ACTIONS(232),
    [anon_sym_COLON_EQ] = ACTIONS(232),
    [anon_sym_DASH_GT] = ACTIONS(232),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_end] = ACTIONS(234),
    [anon_sym_begin] = ACTIONS(234),
    [anon_sym_case] = ACTIONS(234),
    [anon_sym_receive] = ACTIONS(234),
    [anon_sym_try] = ACTIONS(234),
    [anon_sym_maybe] = ACTIONS(234),
    [anon_sym_DOLLAR] = ACTIONS(232),
    [aux_sym_integer_token1] = ACTIONS(234),
    [aux_sym_integer_token2] = ACTIONS(232),
    [sym_float] = ACTIONS(232),
    [sym_atom] = ACTIONS(234),
    [anon_sym_SQUOTE] = ACTIONS(232),
    [sym_variable] = ACTIONS(232),
    [anon_sym_QMARK] = ACTIONS(234),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [sym_tripledot] = ACTIONS(232),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [68] = {
    [sym_comment] = STATE(68),
    [anon_sym_COMMA] = ACTIONS(228),
    [anon_sym_DASH] = ACTIONS(230),
    [anon_sym_LPAREN] = ACTIONS(228),
    [anon_sym_COLON] = ACTIONS(230),
    [anon_sym_when] = ACTIONS(230),
    [anon_sym_if] = ACTIONS(230),
    [anon_sym_LT_LT] = ACTIONS(228),
    [anon_sym_LBRACE] = ACTIONS(228),
    [anon_sym_LBRACK] = ACTIONS(228),
    [anon_sym_POUND] = ACTIONS(228),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_not] = ACTIONS(230),
    [anon_sym_bnot] = ACTIONS(230),
    [anon_sym_catch] = ACTIONS(230),
    [anon_sym_SLASH] = ACTIONS(230),
    [anon_sym_STAR] = ACTIONS(228),
    [anon_sym_div] = ACTIONS(230),
    [anon_sym_rem] = ACTIONS(230),
    [anon_sym_band] = ACTIONS(230),
    [anon_sym_and] = ACTIONS(230),
    [anon_sym_bor] = ACTIONS(230),
    [anon_sym_bxor] = ACTIONS(230),
    [anon_sym_bsl] = ACTIONS(230),
    [anon_sym_bsr] = ACTIONS(230),
    [anon_sym_or] = ACTIONS(230),
    [anon_sym_xor] = ACTIONS(230),
    [anon_sym_PLUS_PLUS] = ACTIONS(228),
    [anon_sym_DASH_DASH] = ACTIONS(228),
    [anon_sym_EQ_EQ] = ACTIONS(228),
    [anon_sym_SLASH_EQ] = ACTIONS(228),
    [anon_sym_EQ_LT] = ACTIONS(228),
    [anon_sym_LT] = ACTIONS(230),
    [anon_sym_GT_EQ] = ACTIONS(228),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(228),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(228),
    [anon_sym_andalso] = ACTIONS(230),
    [anon_sym_orelse] = ACTIONS(230),
    [anon_sym_EQ] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(228),
    [anon_sym_QMARK_EQ] = ACTIONS(228),
    [anon_sym_DOT_DOT] = ACTIONS(230),
    [anon_sym_PIPE_PIPE] = ACTIONS(228),
    [anon_sym_COLON_COLON] = ACTIONS(228),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_LT_DASH] = ACTIONS(228),
    [anon_sym_LT_EQ] = ACTIONS(228),
    [anon_sym_EQ_GT] = ACTIONS(228),
    [anon_sym_COLON_EQ] = ACTIONS(228),
    [anon_sym_DASH_GT] = ACTIONS(228),
    [anon_sym_fun] = ACTIONS(230),
    [anon_sym_end] = ACTIONS(230),
    [anon_sym_begin] = ACTIONS(230),
    [anon_sym_case] = ACTIONS(230),
    [anon_sym_receive] = ACTIONS(230),
    [anon_sym_try] = ACTIONS(230),
    [anon_sym_maybe] = ACTIONS(230),
    [anon_sym_else] = ACTIONS(230),
    [anon_sym_DOLLAR] = ACTIONS(228),
    [aux_sym_integer_token1] = ACTIONS(230),
    [aux_sym_integer_token2] = ACTIONS(228),
    [sym_float] = ACTIONS(228),
    [sym_atom] = ACTIONS(230),
    [anon_sym_SQUOTE] = ACTIONS(228),
    [sym_variable] = ACTIONS(228),
    [anon_sym_QMARK] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(228),
    [sym_tripledot] = ACTIONS(228),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [69] = {
    [sym_comment] = STATE(69),
    [anon_sym_COMMA] = ACTIONS(228),
    [anon_sym_SEMI] = ACTIONS(228),
    [anon_sym_DASH] = ACTIONS(230),
    [anon_sym_LPAREN] = ACTIONS(228),
    [anon_sym_COLON] = ACTIONS(230),
    [anon_sym_when] = ACTIONS(230),
    [anon_sym_if] = ACTIONS(230),
    [anon_sym_LT_LT] = ACTIONS(228),
    [anon_sym_LBRACE] = ACTIONS(228),
    [anon_sym_LBRACK] = ACTIONS(228),
    [anon_sym_POUND] = ACTIONS(228),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_not] = ACTIONS(230),
    [anon_sym_bnot] = ACTIONS(230),
    [anon_sym_catch] = ACTIONS(230),
    [anon_sym_SLASH] = ACTIONS(230),
    [anon_sym_STAR] = ACTIONS(228),
    [anon_sym_div] = ACTIONS(230),
    [anon_sym_rem] = ACTIONS(230),
    [anon_sym_band] = ACTIONS(230),
    [anon_sym_and] = ACTIONS(230),
    [anon_sym_bor] = ACTIONS(230),
    [anon_sym_bxor] = ACTIONS(230),
    [anon_sym_bsl] = ACTIONS(230),
    [anon_sym_bsr] = ACTIONS(230),
    [anon_sym_or] = ACTIONS(230),
    [anon_sym_xor] = ACTIONS(230),
    [anon_sym_PLUS_PLUS] = ACTIONS(228),
    [anon_sym_DASH_DASH] = ACTIONS(228),
    [anon_sym_EQ_EQ] = ACTIONS(228),
    [anon_sym_SLASH_EQ] = ACTIONS(228),
    [anon_sym_EQ_LT] = ACTIONS(228),
    [anon_sym_LT] = ACTIONS(230),
    [anon_sym_GT_EQ] = ACTIONS(228),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(228),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(228),
    [anon_sym_andalso] = ACTIONS(230),
    [anon_sym_orelse] = ACTIONS(230),
    [anon_sym_EQ] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(228),
    [anon_sym_QMARK_EQ] = ACTIONS(228),
    [anon_sym_DOT_DOT] = ACTIONS(230),
    [anon_sym_PIPE_PIPE] = ACTIONS(228),
    [anon_sym_COLON_COLON] = ACTIONS(228),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_LT_DASH] = ACTIONS(228),
    [anon_sym_LT_EQ] = ACTIONS(228),
    [anon_sym_EQ_GT] = ACTIONS(228),
    [anon_sym_COLON_EQ] = ACTIONS(228),
    [anon_sym_DASH_GT] = ACTIONS(228),
    [anon_sym_fun] = ACTIONS(230),
    [anon_sym_end] = ACTIONS(230),
    [anon_sym_begin] = ACTIONS(230),
    [anon_sym_case] = ACTIONS(230),
    [anon_sym_receive] = ACTIONS(230),
    [anon_sym_try] = ACTIONS(230),
    [anon_sym_maybe] = ACTIONS(230),
    [anon_sym_DOLLAR] = ACTIONS(228),
    [aux_sym_integer_token1] = ACTIONS(230),
    [aux_sym_integer_token2] = ACTIONS(228),
    [sym_float] = ACTIONS(228),
    [sym_atom] = ACTIONS(230),
    [anon_sym_SQUOTE] = ACTIONS(228),
    [sym_variable] = ACTIONS(228),
    [anon_sym_QMARK] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(228),
    [sym_tripledot] = ACTIONS(228),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [70] = {
    [sym_comment] = STATE(70),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(244),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(244),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_POUND] = ACTIONS(244),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(244),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_EQ_EQ] = ACTIONS(244),
    [anon_sym_SLASH_EQ] = ACTIONS(244),
    [anon_sym_EQ_LT] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(244),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(244),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_QMARK_EQ] = ACTIONS(244),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(244),
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(244),
    [anon_sym_LT_EQ] = ACTIONS(244),
    [anon_sym_EQ_GT] = ACTIONS(244),
    [anon_sym_COLON_EQ] = ACTIONS(244),
    [anon_sym_DASH_GT] = ACTIONS(244),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_else] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(244),
    [sym_float] = ACTIONS(244),
    [sym_atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(244),
    [sym_variable] = ACTIONS(244),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [sym_tripledot] = ACTIONS(244),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [71] = {
    [sym_comment] = STATE(71),
    [anon_sym_COMMA] = ACTIONS(232),
    [anon_sym_DASH] = ACTIONS(234),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_COLON] = ACTIONS(234),
    [anon_sym_when] = ACTIONS(234),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_LT_LT] = ACTIONS(232),
    [anon_sym_LBRACE] = ACTIONS(232),
    [anon_sym_LBRACK] = ACTIONS(232),
    [anon_sym_POUND] = ACTIONS(232),
    [anon_sym_PLUS] = ACTIONS(234),
    [anon_sym_not] = ACTIONS(234),
    [anon_sym_bnot] = ACTIONS(234),
    [anon_sym_catch] = ACTIONS(234),
    [anon_sym_SLASH] = ACTIONS(234),
    [anon_sym_STAR] = ACTIONS(232),
    [anon_sym_div] = ACTIONS(234),
    [anon_sym_rem] = ACTIONS(234),
    [anon_sym_band] = ACTIONS(234),
    [anon_sym_and] = ACTIONS(234),
    [anon_sym_bor] = ACTIONS(234),
    [anon_sym_bxor] = ACTIONS(234),
    [anon_sym_bsl] = ACTIONS(234),
    [anon_sym_bsr] = ACTIONS(234),
    [anon_sym_or] = ACTIONS(234),
    [anon_sym_xor] = ACTIONS(234),
    [anon_sym_PLUS_PLUS] = ACTIONS(232),
    [anon_sym_DASH_DASH] = ACTIONS(232),
    [anon_sym_EQ_EQ] = ACTIONS(232),
    [anon_sym_SLASH_EQ] = ACTIONS(232),
    [anon_sym_EQ_LT] = ACTIONS(232),
    [anon_sym_LT] = ACTIONS(234),
    [anon_sym_GT_EQ] = ACTIONS(232),
    [anon_sym_GT] = ACTIONS(234),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(232),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(232),
    [anon_sym_andalso] = ACTIONS(234),
    [anon_sym_orelse] = ACTIONS(234),
    [anon_sym_EQ] = ACTIONS(234),
    [anon_sym_BANG] = ACTIONS(232),
    [anon_sym_QMARK_EQ] = ACTIONS(232),
    [anon_sym_DOT_DOT] = ACTIONS(234),
    [anon_sym_PIPE_PIPE] = ACTIONS(232),
    [anon_sym_COLON_COLON] = ACTIONS(232),
    [anon_sym_PIPE] = ACTIONS(234),
    [anon_sym_LT_DASH] = ACTIONS(232),
    [anon_sym_LT_EQ] = ACTIONS(232),
    [anon_sym_EQ_GT] = ACTIONS(232),
    [anon_sym_COLON_EQ] = ACTIONS(232),
    [anon_sym_DASH_GT] = ACTIONS(232),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_end] = ACTIONS(234),
    [anon_sym_begin] = ACTIONS(234),
    [anon_sym_case] = ACTIONS(234),
    [anon_sym_receive] = ACTIONS(234),
    [anon_sym_try] = ACTIONS(234),
    [anon_sym_maybe] = ACTIONS(234),
    [anon_sym_else] = ACTIONS(234),
    [anon_sym_DOLLAR] = ACTIONS(232),
    [aux_sym_integer_token1] = ACTIONS(234),
    [aux_sym_integer_token2] = ACTIONS(232),
    [sym_float] = ACTIONS(232),
    [sym_atom] = ACTIONS(234),
    [anon_sym_SQUOTE] = ACTIONS(232),
    [sym_variable] = ACTIONS(232),
    [anon_sym_QMARK] = ACTIONS(234),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [sym_tripledot] = ACTIONS(232),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [72] = {
    [sym_comment] = STATE(72),
    [anon_sym_COMMA] = ACTIONS(236),
    [anon_sym_DASH] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(236),
    [anon_sym_COLON] = ACTIONS(238),
    [anon_sym_when] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_LT_LT] = ACTIONS(236),
    [anon_sym_LBRACE] = ACTIONS(236),
    [anon_sym_LBRACK] = ACTIONS(236),
    [anon_sym_POUND] = ACTIONS(236),
    [anon_sym_PLUS] = ACTIONS(238),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_bnot] = ACTIONS(238),
    [anon_sym_catch] = ACTIONS(238),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_STAR] = ACTIONS(236),
    [anon_sym_div] = ACTIONS(238),
    [anon_sym_rem] = ACTIONS(238),
    [anon_sym_band] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_bor] = ACTIONS(238),
    [anon_sym_bxor] = ACTIONS(238),
    [anon_sym_bsl] = ACTIONS(238),
    [anon_sym_bsr] = ACTIONS(238),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_xor] = ACTIONS(238),
    [anon_sym_PLUS_PLUS] = ACTIONS(236),
    [anon_sym_DASH_DASH] = ACTIONS(236),
    [anon_sym_EQ_EQ] = ACTIONS(236),
    [anon_sym_SLASH_EQ] = ACTIONS(236),
    [anon_sym_EQ_LT] = ACTIONS(236),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_GT_EQ] = ACTIONS(236),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(236),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(236),
    [anon_sym_andalso] = ACTIONS(238),
    [anon_sym_orelse] = ACTIONS(238),
    [anon_sym_EQ] = ACTIONS(238),
    [anon_sym_BANG] = ACTIONS(236),
    [anon_sym_QMARK_EQ] = ACTIONS(236),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_PIPE_PIPE] = ACTIONS(236),
    [anon_sym_COLON_COLON] = ACTIONS(236),
    [anon_sym_PIPE] = ACTIONS(238),
    [anon_sym_LT_DASH] = ACTIONS(236),
    [anon_sym_LT_EQ] = ACTIONS(236),
    [anon_sym_EQ_GT] = ACTIONS(236),
    [anon_sym_COLON_EQ] = ACTIONS(236),
    [anon_sym_DASH_GT] = ACTIONS(236),
    [anon_sym_fun] = ACTIONS(238),
    [anon_sym_end] = ACTIONS(238),
    [anon_sym_begin] = ACTIONS(238),
    [anon_sym_case] = ACTIONS(238),
    [anon_sym_receive] = ACTIONS(238),
    [anon_sym_try] = ACTIONS(238),
    [anon_sym_maybe] = ACTIONS(238),
    [anon_sym_else] = ACTIONS(238),
    [anon_sym_DOLLAR] = ACTIONS(236),
    [aux_sym_integer_token1] = ACTIONS(238),
    [aux_sym_integer_token2] = ACTIONS(236),
    [sym_float] = ACTIONS(236),
    [sym_atom] = ACTIONS(238),
    [anon_sym_SQUOTE] = ACTIONS(236),
    [sym_variable] = ACTIONS(236),
    [anon_sym_QMARK] = ACTIONS(238),
    [anon_sym_DQUOTE] = ACTIONS(236),
    [sym_tripledot] = ACTIONS(236),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [73] = {
    [sym_comment] = STATE(73),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_SEMI] = ACTIONS(244),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(244),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(244),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_POUND] = ACTIONS(244),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(244),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_EQ_EQ] = ACTIONS(244),
    [anon_sym_SLASH_EQ] = ACTIONS(244),
    [anon_sym_EQ_LT] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(244),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(244),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_QMARK_EQ] = ACTIONS(244),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(244),
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(244),
    [anon_sym_LT_EQ] = ACTIONS(244),
    [anon_sym_EQ_GT] = ACTIONS(244),
    [anon_sym_COLON_EQ] = ACTIONS(244),
    [anon_sym_DASH_GT] = ACTIONS(244),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(244),
    [sym_float] = ACTIONS(244),
    [sym_atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(244),
    [sym_variable] = ACTIONS(244),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [sym_tripledot] = ACTIONS(244),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [74] = {
    [sym_comment] = STATE(74),
    [anon_sym_COMMA] = ACTIONS(252),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(252),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_EQ_EQ] = ACTIONS(252),
    [anon_sym_SLASH_EQ] = ACTIONS(252),
    [anon_sym_EQ_LT] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(252),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(252),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(252),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_QMARK_EQ] = ACTIONS(252),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(252),
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(252),
    [anon_sym_LT_EQ] = ACTIONS(252),
    [anon_sym_EQ_GT] = ACTIONS(252),
    [anon_sym_COLON_EQ] = ACTIONS(252),
    [anon_sym_DASH_GT] = ACTIONS(252),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_end] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_else] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(252),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(252),
    [sym_float] = ACTIONS(252),
    [sym_atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [sym_variable] = ACTIONS(252),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_tripledot] = ACTIONS(252),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [75] = {
    [sym_comment] = STATE(75),
    [anon_sym_COMMA] = ACTIONS(252),
    [anon_sym_SEMI] = ACTIONS(252),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(252),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_EQ_EQ] = ACTIONS(252),
    [anon_sym_SLASH_EQ] = ACTIONS(252),
    [anon_sym_EQ_LT] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(252),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(252),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(252),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_QMARK_EQ] = ACTIONS(252),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(252),
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(252),
    [anon_sym_LT_EQ] = ACTIONS(252),
    [anon_sym_EQ_GT] = ACTIONS(252),
    [anon_sym_COLON_EQ] = ACTIONS(252),
    [anon_sym_DASH_GT] = ACTIONS(252),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_end] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(252),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(252),
    [sym_float] = ACTIONS(252),
    [sym_atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [sym_variable] = ACTIONS(252),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_tripledot] = ACTIONS(252),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [76] = {
    [sym_comment] = STATE(76),
    [anon_sym_COMMA] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(242),
    [anon_sym_LPAREN] = ACTIONS(240),
    [anon_sym_COLON] = ACTIONS(242),
    [anon_sym_when] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_LBRACE] = ACTIONS(240),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_POUND] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(242),
    [anon_sym_not] = ACTIONS(242),
    [anon_sym_bnot] = ACTIONS(242),
    [anon_sym_catch] = ACTIONS(242),
    [anon_sym_SLASH] = ACTIONS(242),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_div] = ACTIONS(242),
    [anon_sym_rem] = ACTIONS(242),
    [anon_sym_band] = ACTIONS(242),
    [anon_sym_and] = ACTIONS(242),
    [anon_sym_bor] = ACTIONS(242),
    [anon_sym_bxor] = ACTIONS(242),
    [anon_sym_bsl] = ACTIONS(242),
    [anon_sym_bsr] = ACTIONS(242),
    [anon_sym_or] = ACTIONS(242),
    [anon_sym_xor] = ACTIONS(242),
    [anon_sym_PLUS_PLUS] = ACTIONS(240),
    [anon_sym_DASH_DASH] = ACTIONS(240),
    [anon_sym_EQ_EQ] = ACTIONS(240),
    [anon_sym_SLASH_EQ] = ACTIONS(240),
    [anon_sym_EQ_LT] = ACTIONS(240),
    [anon_sym_LT] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(242),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(240),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(240),
    [anon_sym_andalso] = ACTIONS(242),
    [anon_sym_orelse] = ACTIONS(242),
    [anon_sym_EQ] = ACTIONS(242),
    [anon_sym_BANG] = ACTIONS(240),
    [anon_sym_QMARK_EQ] = ACTIONS(240),
    [anon_sym_DOT_DOT] = ACTIONS(242),
    [anon_sym_PIPE_PIPE] = ACTIONS(240),
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_LT_DASH] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(240),
    [anon_sym_EQ_GT] = ACTIONS(240),
    [anon_sym_COLON_EQ] = ACTIONS(240),
    [anon_sym_DASH_GT] = ACTIONS(240),
    [anon_sym_fun] = ACTIONS(242),
    [anon_sym_end] = ACTIONS(242),
    [anon_sym_begin] = ACTIONS(242),
    [anon_sym_case] = ACTIONS(242),
    [anon_sym_receive] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(242),
    [anon_sym_maybe] = ACTIONS(242),
    [anon_sym_else] = ACTIONS(242),
    [anon_sym_DOLLAR] = ACTIONS(240),
    [aux_sym_integer_token1] = ACTIONS(242),
    [aux_sym_integer_token2] = ACTIONS(240),
    [sym_float] = ACTIONS(240),
    [sym_atom] = ACTIONS(242),
    [anon_sym_SQUOTE] = ACTIONS(240),
    [sym_variable] = ACTIONS(240),
    [anon_sym_QMARK] = ACTIONS(242),
    [anon_sym_DQUOTE] = ACTIONS(240),
    [sym_tripledot] = ACTIONS(240),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [77] = {
    [sym_comment] = STATE(77),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_DASH_GT] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_end] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_else] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym_atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [78] = {
    [sym__statement] = STATE(1044),
    [sym_function] = STATE(1406),
    [sym__macro_declaration] = STATE(1405),
    [sym__spec] = STATE(1387),
    [sym_attribute] = STATE(1406),
    [sym__expression] = STATE(723),
    [sym__parenthesized_expression] = STATE(775),
    [sym_bitstring] = STATE(773),
    [sym_tuple] = STATE(746),
    [sym_list] = STATE(746),
    [sym_map] = STATE(773),
    [sym_record] = STATE(773),
    [sym_unary_operator] = STATE(746),
    [sym_binary_operator] = STATE(773),
    [sym__literal] = STATE(1252),
    [sym_anonymous_function] = STATE(746),
    [sym__named_stab_clause] = STATE(1260),
    [sym_call] = STATE(773),
    [sym__qualified_function] = STATE(1293),
    [sym__unqualified_function] = STATE(1300),
    [sym_function_capture] = STATE(773),
    [sym_function_type] = STATE(773),
    [sym_block] = STATE(773),
    [sym_if] = STATE(773),
    [sym_case] = STATE(773),
    [sym_receive] = STATE(773),
    [sym_try] = STATE(746),
    [sym_maybe] = STATE(773),
    [sym_character] = STATE(742),
    [sym__number] = STATE(775),
    [sym_integer] = STATE(741),
    [sym__identifier] = STATE(652),
    [sym__atom] = STATE(704),
    [sym_quoted_atom] = STATE(698),
    [sym_macro] = STATE(5),
    [sym__strings] = STATE(773),
    [sym_string] = STATE(686),
    [sym_comment] = STATE(78),
    [aux_sym_source_repeat2] = STATE(78),
    [aux_sym__strings_repeat1] = STATE(604),
    [ts_builtin_sym_end] = ACTIONS(266),
    [anon_sym_DASH] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_LBRACK] = ACTIONS(283),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_PLUS] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(289),
    [anon_sym_bnot] = ACTIONS(289),
    [anon_sym_catch] = ACTIONS(292),
    [anon_sym_fun] = ACTIONS(295),
    [anon_sym_begin] = ACTIONS(298),
    [anon_sym_case] = ACTIONS(301),
    [anon_sym_receive] = ACTIONS(304),
    [anon_sym_try] = ACTIONS(307),
    [anon_sym_maybe] = ACTIONS(310),
    [anon_sym_DOLLAR] = ACTIONS(313),
    [aux_sym_integer_token1] = ACTIONS(316),
    [aux_sym_integer_token2] = ACTIONS(319),
    [sym_float] = ACTIONS(322),
    [sym_atom] = ACTIONS(325),
    [anon_sym_SQUOTE] = ACTIONS(328),
    [sym_variable] = ACTIONS(331),
    [anon_sym_QMARK] = ACTIONS(334),
    [anon_sym_DQUOTE] = ACTIONS(337),
    [sym_tripledot] = ACTIONS(340),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [79] = {
    [sym__statement] = STATE(1044),
    [sym_function] = STATE(1406),
    [sym__macro_declaration] = STATE(1405),
    [sym__spec] = STATE(1387),
    [sym_attribute] = STATE(1406),
    [sym__expression] = STATE(723),
    [sym__parenthesized_expression] = STATE(775),
    [sym_bitstring] = STATE(773),
    [sym_tuple] = STATE(746),
    [sym_list] = STATE(746),
    [sym_map] = STATE(773),
    [sym_record] = STATE(773),
    [sym_unary_operator] = STATE(746),
    [sym_binary_operator] = STATE(773),
    [sym__literal] = STATE(1252),
    [sym_anonymous_function] = STATE(746),
    [sym__named_stab_clause] = STATE(1260),
    [sym_call] = STATE(773),
    [sym__qualified_function] = STATE(1293),
    [sym__unqualified_function] = STATE(1300),
    [sym_function_capture] = STATE(773),
    [sym_function_type] = STATE(773),
    [sym_block] = STATE(773),
    [sym_if] = STATE(773),
    [sym_case] = STATE(773),
    [sym_receive] = STATE(773),
    [sym_try] = STATE(746),
    [sym_maybe] = STATE(773),
    [sym_character] = STATE(742),
    [sym__number] = STATE(775),
    [sym_integer] = STATE(741),
    [sym__identifier] = STATE(652),
    [sym__atom] = STATE(704),
    [sym_quoted_atom] = STATE(698),
    [sym_macro] = STATE(5),
    [sym__strings] = STATE(773),
    [sym_string] = STATE(686),
    [sym_comment] = STATE(79),
    [aux_sym_source_repeat2] = STATE(78),
    [aux_sym__strings_repeat1] = STATE(604),
    [ts_builtin_sym_end] = ACTIONS(343),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LT_LT] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_POUND] = ACTIONS(19),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_not] = ACTIONS(21),
    [anon_sym_bnot] = ACTIONS(21),
    [anon_sym_catch] = ACTIONS(23),
    [anon_sym_fun] = ACTIONS(25),
    [anon_sym_begin] = ACTIONS(27),
    [anon_sym_case] = ACTIONS(29),
    [anon_sym_receive] = ACTIONS(31),
    [anon_sym_try] = ACTIONS(33),
    [anon_sym_maybe] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(37),
    [aux_sym_integer_token1] = ACTIONS(39),
    [aux_sym_integer_token2] = ACTIONS(41),
    [sym_float] = ACTIONS(43),
    [sym_atom] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym_variable] = ACTIONS(49),
    [anon_sym_QMARK] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_tripledot] = ACTIONS(55),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [80] = {
    [sym_arguments] = STATE(84),
    [sym_comment] = STATE(80),
    [anon_sym_DASH] = ACTIONS(226),
    [anon_sym_LPAREN] = ACTIONS(345),
    [anon_sym_COLON] = ACTIONS(226),
    [anon_sym_when] = ACTIONS(226),
    [anon_sym_if] = ACTIONS(226),
    [anon_sym_LT_LT] = ACTIONS(224),
    [anon_sym_LBRACE] = ACTIONS(224),
    [anon_sym_LBRACK] = ACTIONS(224),
    [anon_sym_POUND] = ACTIONS(224),
    [anon_sym_PLUS] = ACTIONS(226),
    [anon_sym_not] = ACTIONS(226),
    [anon_sym_bnot] = ACTIONS(226),
    [anon_sym_catch] = ACTIONS(226),
    [anon_sym_SLASH] = ACTIONS(226),
    [anon_sym_STAR] = ACTIONS(224),
    [anon_sym_div] = ACTIONS(226),
    [anon_sym_rem] = ACTIONS(226),
    [anon_sym_band] = ACTIONS(226),
    [anon_sym_and] = ACTIONS(226),
    [anon_sym_bor] = ACTIONS(226),
    [anon_sym_bxor] = ACTIONS(226),
    [anon_sym_bsl] = ACTIONS(226),
    [anon_sym_bsr] = ACTIONS(226),
    [anon_sym_or] = ACTIONS(226),
    [anon_sym_xor] = ACTIONS(226),
    [anon_sym_PLUS_PLUS] = ACTIONS(224),
    [anon_sym_DASH_DASH] = ACTIONS(224),
    [anon_sym_EQ_EQ] = ACTIONS(224),
    [anon_sym_SLASH_EQ] = ACTIONS(224),
    [anon_sym_EQ_LT] = ACTIONS(224),
    [anon_sym_LT] = ACTIONS(226),
    [anon_sym_GT_EQ] = ACTIONS(224),
    [anon_sym_GT] = ACTIONS(226),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(224),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(224),
    [anon_sym_andalso] = ACTIONS(226),
    [anon_sym_orelse] = ACTIONS(226),
    [anon_sym_EQ] = ACTIONS(226),
    [anon_sym_BANG] = ACTIONS(224),
    [anon_sym_QMARK_EQ] = ACTIONS(224),
    [anon_sym_DOT_DOT] = ACTIONS(226),
    [anon_sym_PIPE_PIPE] = ACTIONS(224),
    [anon_sym_COLON_COLON] = ACTIONS(224),
    [anon_sym_PIPE] = ACTIONS(226),
    [anon_sym_LT_DASH] = ACTIONS(224),
    [anon_sym_LT_EQ] = ACTIONS(224),
    [anon_sym_EQ_GT] = ACTIONS(224),
    [anon_sym_COLON_EQ] = ACTIONS(224),
    [anon_sym_DASH_GT] = ACTIONS(224),
    [anon_sym_fun] = ACTIONS(226),
    [anon_sym_begin] = ACTIONS(226),
    [anon_sym_case] = ACTIONS(226),
    [anon_sym_of] = ACTIONS(226),
    [anon_sym_receive] = ACTIONS(226),
    [anon_sym_try] = ACTIONS(226),
    [anon_sym_maybe] = ACTIONS(226),
    [anon_sym_DOLLAR] = ACTIONS(224),
    [aux_sym_integer_token1] = ACTIONS(226),
    [aux_sym_integer_token2] = ACTIONS(224),
    [sym_float] = ACTIONS(224),
    [sym_atom] = ACTIONS(226),
    [anon_sym_SQUOTE] = ACTIONS(224),
    [sym_variable] = ACTIONS(224),
    [anon_sym_QMARK] = ACTIONS(226),
    [anon_sym_DQUOTE] = ACTIONS(224),
    [sym_tripledot] = ACTIONS(224),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [81] = {
    [sym_arguments] = STATE(83),
    [sym_comment] = STATE(81),
    [anon_sym_DASH] = ACTIONS(220),
    [anon_sym_LPAREN] = ACTIONS(345),
    [anon_sym_COLON] = ACTIONS(220),
    [anon_sym_when] = ACTIONS(220),
    [anon_sym_if] = ACTIONS(220),
    [anon_sym_LT_LT] = ACTIONS(218),
    [anon_sym_LBRACE] = ACTIONS(218),
    [anon_sym_LBRACK] = ACTIONS(218),
    [anon_sym_POUND] = ACTIONS(218),
    [anon_sym_PLUS] = ACTIONS(220),
    [anon_sym_not] = ACTIONS(220),
    [anon_sym_bnot] = ACTIONS(220),
    [anon_sym_catch] = ACTIONS(220),
    [anon_sym_SLASH] = ACTIONS(220),
    [anon_sym_STAR] = ACTIONS(218),
    [anon_sym_div] = ACTIONS(220),
    [anon_sym_rem] = ACTIONS(220),
    [anon_sym_band] = ACTIONS(220),
    [anon_sym_and] = ACTIONS(220),
    [anon_sym_bor] = ACTIONS(220),
    [anon_sym_bxor] = ACTIONS(220),
    [anon_sym_bsl] = ACTIONS(220),
    [anon_sym_bsr] = ACTIONS(220),
    [anon_sym_or] = ACTIONS(220),
    [anon_sym_xor] = ACTIONS(220),
    [anon_sym_PLUS_PLUS] = ACTIONS(218),
    [anon_sym_DASH_DASH] = ACTIONS(218),
    [anon_sym_EQ_EQ] = ACTIONS(218),
    [anon_sym_SLASH_EQ] = ACTIONS(218),
    [anon_sym_EQ_LT] = ACTIONS(218),
    [anon_sym_LT] = ACTIONS(220),
    [anon_sym_GT_EQ] = ACTIONS(218),
    [anon_sym_GT] = ACTIONS(220),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(218),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(218),
    [anon_sym_andalso] = ACTIONS(220),
    [anon_sym_orelse] = ACTIONS(220),
    [anon_sym_EQ] = ACTIONS(220),
    [anon_sym_BANG] = ACTIONS(218),
    [anon_sym_QMARK_EQ] = ACTIONS(218),
    [anon_sym_DOT_DOT] = ACTIONS(220),
    [anon_sym_PIPE_PIPE] = ACTIONS(218),
    [anon_sym_COLON_COLON] = ACTIONS(218),
    [anon_sym_PIPE] = ACTIONS(220),
    [anon_sym_LT_DASH] = ACTIONS(218),
    [anon_sym_LT_EQ] = ACTIONS(218),
    [anon_sym_EQ_GT] = ACTIONS(218),
    [anon_sym_COLON_EQ] = ACTIONS(218),
    [anon_sym_DASH_GT] = ACTIONS(218),
    [anon_sym_fun] = ACTIONS(220),
    [anon_sym_begin] = ACTIONS(220),
    [anon_sym_case] = ACTIONS(220),
    [anon_sym_of] = ACTIONS(220),
    [anon_sym_receive] = ACTIONS(220),
    [anon_sym_try] = ACTIONS(220),
    [anon_sym_maybe] = ACTIONS(220),
    [anon_sym_DOLLAR] = ACTIONS(218),
    [aux_sym_integer_token1] = ACTIONS(220),
    [aux_sym_integer_token2] = ACTIONS(218),
    [sym_float] = ACTIONS(218),
    [sym_atom] = ACTIONS(220),
    [anon_sym_SQUOTE] = ACTIONS(218),
    [sym_variable] = ACTIONS(218),
    [anon_sym_QMARK] = ACTIONS(220),
    [anon_sym_DQUOTE] = ACTIONS(218),
    [sym_tripledot] = ACTIONS(218),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [82] = {
    [sym_comment] = STATE(82),
    [anon_sym_DASH] = ACTIONS(234),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_COLON] = ACTIONS(234),
    [anon_sym_when] = ACTIONS(234),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_LT_LT] = ACTIONS(232),
    [anon_sym_LBRACE] = ACTIONS(232),
    [anon_sym_LBRACK] = ACTIONS(232),
    [anon_sym_POUND] = ACTIONS(232),
    [anon_sym_PLUS] = ACTIONS(234),
    [anon_sym_not] = ACTIONS(234),
    [anon_sym_bnot] = ACTIONS(234),
    [anon_sym_catch] = ACTIONS(234),
    [anon_sym_SLASH] = ACTIONS(234),
    [anon_sym_STAR] = ACTIONS(232),
    [anon_sym_div] = ACTIONS(234),
    [anon_sym_rem] = ACTIONS(234),
    [anon_sym_band] = ACTIONS(234),
    [anon_sym_and] = ACTIONS(234),
    [anon_sym_bor] = ACTIONS(234),
    [anon_sym_bxor] = ACTIONS(234),
    [anon_sym_bsl] = ACTIONS(234),
    [anon_sym_bsr] = ACTIONS(234),
    [anon_sym_or] = ACTIONS(234),
    [anon_sym_xor] = ACTIONS(234),
    [anon_sym_PLUS_PLUS] = ACTIONS(232),
    [anon_sym_DASH_DASH] = ACTIONS(232),
    [anon_sym_EQ_EQ] = ACTIONS(232),
    [anon_sym_SLASH_EQ] = ACTIONS(232),
    [anon_sym_EQ_LT] = ACTIONS(232),
    [anon_sym_LT] = ACTIONS(234),
    [anon_sym_GT_EQ] = ACTIONS(232),
    [anon_sym_GT] = ACTIONS(234),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(232),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(232),
    [anon_sym_andalso] = ACTIONS(234),
    [anon_sym_orelse] = ACTIONS(234),
    [anon_sym_EQ] = ACTIONS(234),
    [anon_sym_BANG] = ACTIONS(232),
    [anon_sym_QMARK_EQ] = ACTIONS(232),
    [anon_sym_DOT_DOT] = ACTIONS(234),
    [anon_sym_PIPE_PIPE] = ACTIONS(232),
    [anon_sym_COLON_COLON] = ACTIONS(232),
    [anon_sym_PIPE] = ACTIONS(234),
    [anon_sym_LT_DASH] = ACTIONS(232),
    [anon_sym_LT_EQ] = ACTIONS(232),
    [anon_sym_EQ_GT] = ACTIONS(232),
    [anon_sym_COLON_EQ] = ACTIONS(232),
    [anon_sym_DASH_GT] = ACTIONS(232),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_begin] = ACTIONS(234),
    [anon_sym_case] = ACTIONS(234),
    [anon_sym_of] = ACTIONS(234),
    [anon_sym_receive] = ACTIONS(234),
    [anon_sym_try] = ACTIONS(234),
    [anon_sym_maybe] = ACTIONS(234),
    [anon_sym_DOLLAR] = ACTIONS(232),
    [aux_sym_integer_token1] = ACTIONS(234),
    [aux_sym_integer_token2] = ACTIONS(232),
    [sym_float] = ACTIONS(232),
    [sym_atom] = ACTIONS(234),
    [anon_sym_SQUOTE] = ACTIONS(232),
    [sym_variable] = ACTIONS(232),
    [anon_sym_QMARK] = ACTIONS(234),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [sym_tripledot] = ACTIONS(232),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [83] = {
    [sym_comment] = STATE(83),
    [anon_sym_DASH] = ACTIONS(230),
    [anon_sym_LPAREN] = ACTIONS(228),
    [anon_sym_COLON] = ACTIONS(230),
    [anon_sym_when] = ACTIONS(230),
    [anon_sym_if] = ACTIONS(230),
    [anon_sym_LT_LT] = ACTIONS(228),
    [anon_sym_LBRACE] = ACTIONS(228),
    [anon_sym_LBRACK] = ACTIONS(228),
    [anon_sym_POUND] = ACTIONS(228),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_not] = ACTIONS(230),
    [anon_sym_bnot] = ACTIONS(230),
    [anon_sym_catch] = ACTIONS(230),
    [anon_sym_SLASH] = ACTIONS(230),
    [anon_sym_STAR] = ACTIONS(228),
    [anon_sym_div] = ACTIONS(230),
    [anon_sym_rem] = ACTIONS(230),
    [anon_sym_band] = ACTIONS(230),
    [anon_sym_and] = ACTIONS(230),
    [anon_sym_bor] = ACTIONS(230),
    [anon_sym_bxor] = ACTIONS(230),
    [anon_sym_bsl] = ACTIONS(230),
    [anon_sym_bsr] = ACTIONS(230),
    [anon_sym_or] = ACTIONS(230),
    [anon_sym_xor] = ACTIONS(230),
    [anon_sym_PLUS_PLUS] = ACTIONS(228),
    [anon_sym_DASH_DASH] = ACTIONS(228),
    [anon_sym_EQ_EQ] = ACTIONS(228),
    [anon_sym_SLASH_EQ] = ACTIONS(228),
    [anon_sym_EQ_LT] = ACTIONS(228),
    [anon_sym_LT] = ACTIONS(230),
    [anon_sym_GT_EQ] = ACTIONS(228),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(228),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(228),
    [anon_sym_andalso] = ACTIONS(230),
    [anon_sym_orelse] = ACTIONS(230),
    [anon_sym_EQ] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(228),
    [anon_sym_QMARK_EQ] = ACTIONS(228),
    [anon_sym_DOT_DOT] = ACTIONS(230),
    [anon_sym_PIPE_PIPE] = ACTIONS(228),
    [anon_sym_COLON_COLON] = ACTIONS(228),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_LT_DASH] = ACTIONS(228),
    [anon_sym_LT_EQ] = ACTIONS(228),
    [anon_sym_EQ_GT] = ACTIONS(228),
    [anon_sym_COLON_EQ] = ACTIONS(228),
    [anon_sym_DASH_GT] = ACTIONS(228),
    [anon_sym_fun] = ACTIONS(230),
    [anon_sym_begin] = ACTIONS(230),
    [anon_sym_case] = ACTIONS(230),
    [anon_sym_of] = ACTIONS(230),
    [anon_sym_receive] = ACTIONS(230),
    [anon_sym_try] = ACTIONS(230),
    [anon_sym_maybe] = ACTIONS(230),
    [anon_sym_DOLLAR] = ACTIONS(228),
    [aux_sym_integer_token1] = ACTIONS(230),
    [aux_sym_integer_token2] = ACTIONS(228),
    [sym_float] = ACTIONS(228),
    [sym_atom] = ACTIONS(230),
    [anon_sym_SQUOTE] = ACTIONS(228),
    [sym_variable] = ACTIONS(228),
    [anon_sym_QMARK] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(228),
    [sym_tripledot] = ACTIONS(228),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [84] = {
    [sym_comment] = STATE(84),
    [anon_sym_DASH] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(236),
    [anon_sym_COLON] = ACTIONS(238),
    [anon_sym_when] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_LT_LT] = ACTIONS(236),
    [anon_sym_LBRACE] = ACTIONS(236),
    [anon_sym_LBRACK] = ACTIONS(236),
    [anon_sym_POUND] = ACTIONS(236),
    [anon_sym_PLUS] = ACTIONS(238),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_bnot] = ACTIONS(238),
    [anon_sym_catch] = ACTIONS(238),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_STAR] = ACTIONS(236),
    [anon_sym_div] = ACTIONS(238),
    [anon_sym_rem] = ACTIONS(238),
    [anon_sym_band] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_bor] = ACTIONS(238),
    [anon_sym_bxor] = ACTIONS(238),
    [anon_sym_bsl] = ACTIONS(238),
    [anon_sym_bsr] = ACTIONS(238),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_xor] = ACTIONS(238),
    [anon_sym_PLUS_PLUS] = ACTIONS(236),
    [anon_sym_DASH_DASH] = ACTIONS(236),
    [anon_sym_EQ_EQ] = ACTIONS(236),
    [anon_sym_SLASH_EQ] = ACTIONS(236),
    [anon_sym_EQ_LT] = ACTIONS(236),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_GT_EQ] = ACTIONS(236),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(236),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(236),
    [anon_sym_andalso] = ACTIONS(238),
    [anon_sym_orelse] = ACTIONS(238),
    [anon_sym_EQ] = ACTIONS(238),
    [anon_sym_BANG] = ACTIONS(236),
    [anon_sym_QMARK_EQ] = ACTIONS(236),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_PIPE_PIPE] = ACTIONS(236),
    [anon_sym_COLON_COLON] = ACTIONS(236),
    [anon_sym_PIPE] = ACTIONS(238),
    [anon_sym_LT_DASH] = ACTIONS(236),
    [anon_sym_LT_EQ] = ACTIONS(236),
    [anon_sym_EQ_GT] = ACTIONS(236),
    [anon_sym_COLON_EQ] = ACTIONS(236),
    [anon_sym_DASH_GT] = ACTIONS(236),
    [anon_sym_fun] = ACTIONS(238),
    [anon_sym_begin] = ACTIONS(238),
    [anon_sym_case] = ACTIONS(238),
    [anon_sym_of] = ACTIONS(238),
    [anon_sym_receive] = ACTIONS(238),
    [anon_sym_try] = ACTIONS(238),
    [anon_sym_maybe] = ACTIONS(238),
    [anon_sym_DOLLAR] = ACTIONS(236),
    [aux_sym_integer_token1] = ACTIONS(238),
    [aux_sym_integer_token2] = ACTIONS(236),
    [sym_float] = ACTIONS(236),
    [sym_atom] = ACTIONS(238),
    [anon_sym_SQUOTE] = ACTIONS(236),
    [sym_variable] = ACTIONS(236),
    [anon_sym_QMARK] = ACTIONS(238),
    [anon_sym_DQUOTE] = ACTIONS(236),
    [sym_tripledot] = ACTIONS(236),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [85] = {
    [sym_comment] = STATE(85),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(252),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_EQ_EQ] = ACTIONS(252),
    [anon_sym_SLASH_EQ] = ACTIONS(252),
    [anon_sym_EQ_LT] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(252),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(252),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(252),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_QMARK_EQ] = ACTIONS(252),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(252),
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(252),
    [anon_sym_LT_EQ] = ACTIONS(252),
    [anon_sym_EQ_GT] = ACTIONS(252),
    [anon_sym_COLON_EQ] = ACTIONS(252),
    [anon_sym_DASH_GT] = ACTIONS(252),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_of] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(252),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(252),
    [sym_float] = ACTIONS(252),
    [sym_atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [sym_variable] = ACTIONS(252),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_tripledot] = ACTIONS(252),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [86] = {
    [sym_comment] = STATE(86),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_DASH_GT] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_of] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym_atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [87] = {
    [sym_comment] = STATE(87),
    [anon_sym_DASH] = ACTIONS(242),
    [anon_sym_LPAREN] = ACTIONS(240),
    [anon_sym_COLON] = ACTIONS(242),
    [anon_sym_when] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(242),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_LBRACE] = ACTIONS(240),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_POUND] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(242),
    [anon_sym_not] = ACTIONS(242),
    [anon_sym_bnot] = ACTIONS(242),
    [anon_sym_catch] = ACTIONS(242),
    [anon_sym_SLASH] = ACTIONS(242),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_div] = ACTIONS(242),
    [anon_sym_rem] = ACTIONS(242),
    [anon_sym_band] = ACTIONS(242),
    [anon_sym_and] = ACTIONS(242),
    [anon_sym_bor] = ACTIONS(242),
    [anon_sym_bxor] = ACTIONS(242),
    [anon_sym_bsl] = ACTIONS(242),
    [anon_sym_bsr] = ACTIONS(242),
    [anon_sym_or] = ACTIONS(242),
    [anon_sym_xor] = ACTIONS(242),
    [anon_sym_PLUS_PLUS] = ACTIONS(240),
    [anon_sym_DASH_DASH] = ACTIONS(240),
    [anon_sym_EQ_EQ] = ACTIONS(240),
    [anon_sym_SLASH_EQ] = ACTIONS(240),
    [anon_sym_EQ_LT] = ACTIONS(240),
    [anon_sym_LT] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(242),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(240),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(240),
    [anon_sym_andalso] = ACTIONS(242),
    [anon_sym_orelse] = ACTIONS(242),
    [anon_sym_EQ] = ACTIONS(242),
    [anon_sym_BANG] = ACTIONS(240),
    [anon_sym_QMARK_EQ] = ACTIONS(240),
    [anon_sym_DOT_DOT] = ACTIONS(242),
    [anon_sym_PIPE_PIPE] = ACTIONS(240),
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(242),
    [anon_sym_LT_DASH] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(240),
    [anon_sym_EQ_GT] = ACTIONS(240),
    [anon_sym_COLON_EQ] = ACTIONS(240),
    [anon_sym_DASH_GT] = ACTIONS(240),
    [anon_sym_fun] = ACTIONS(242),
    [anon_sym_begin] = ACTIONS(242),
    [anon_sym_case] = ACTIONS(242),
    [anon_sym_of] = ACTIONS(242),
    [anon_sym_receive] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(242),
    [anon_sym_maybe] = ACTIONS(242),
    [anon_sym_DOLLAR] = ACTIONS(240),
    [aux_sym_integer_token1] = ACTIONS(242),
    [aux_sym_integer_token2] = ACTIONS(240),
    [sym_float] = ACTIONS(240),
    [sym_atom] = ACTIONS(242),
    [anon_sym_SQUOTE] = ACTIONS(240),
    [sym_variable] = ACTIONS(240),
    [anon_sym_QMARK] = ACTIONS(242),
    [anon_sym_DQUOTE] = ACTIONS(240),
    [sym_tripledot] = ACTIONS(240),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [88] = {
    [sym_comment] = STATE(88),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(244),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(244),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_POUND] = ACTIONS(244),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(244),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_EQ_EQ] = ACTIONS(244),
    [anon_sym_SLASH_EQ] = ACTIONS(244),
    [anon_sym_EQ_LT] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(244),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(244),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_QMARK_EQ] = ACTIONS(244),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(244),
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(244),
    [anon_sym_LT_EQ] = ACTIONS(244),
    [anon_sym_EQ_GT] = ACTIONS(244),
    [anon_sym_COLON_EQ] = ACTIONS(244),
    [anon_sym_DASH_GT] = ACTIONS(244),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_of] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(244),
    [sym_float] = ACTIONS(244),
    [sym_atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(244),
    [sym_variable] = ACTIONS(244),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [sym_tripledot] = ACTIONS(244),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [89] = {
    [sym__expression] = STATE(608),
    [sym__parenthesized_expression] = STATE(559),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(529),
    [sym_list] = STATE(529),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(529),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(529),
    [sym_stab_clause] = STATE(1170),
    [sym__named_stab_clause] = STATE(1154),
    [sym__anonymous_stab_clause] = STATE(1150),
    [sym_arguments] = STATE(1292),
    [sym__items] = STATE(1314),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(529),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(559),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(740),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(2),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(89),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(347),
    [anon_sym_RPAREN] = ACTIONS(349),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(351),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_not] = ACTIONS(73),
    [anon_sym_bnot] = ACTIONS(73),
    [anon_sym_catch] = ACTIONS(75),
    [anon_sym_fun] = ACTIONS(353),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [90] = {
    [sym__expression] = STATE(774),
    [sym__parenthesized_expression] = STATE(559),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(529),
    [sym_list] = STATE(529),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(529),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1249),
    [sym_anonymous_function] = STATE(529),
    [sym_guard] = STATE(1348),
    [sym_arguments] = STATE(1328),
    [sym__items] = STATE(1207),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym__if_clause] = STATE(1238),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(529),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(707),
    [sym__number] = STATE(559),
    [sym_integer] = STATE(706),
    [sym__identifier] = STATE(701),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(20),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(90),
    [aux_sym__strings_repeat1] = STATE(603),
    [anon_sym_DOT] = ACTIONS(359),
    [anon_sym_DASH] = ACTIONS(129),
    [anon_sym_LPAREN] = ACTIONS(347),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(129),
    [anon_sym_not] = ACTIONS(129),
    [anon_sym_bnot] = ACTIONS(129),
    [anon_sym_catch] = ACTIONS(131),
    [anon_sym_fun] = ACTIONS(133),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [91] = {
    [sym__expression] = STATE(1011),
    [sym__parenthesized_expression] = STATE(559),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(529),
    [sym_list] = STATE(529),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(529),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(529),
    [sym_clause] = STATE(1124),
    [sym__items] = STATE(1288),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_after] = STATE(1321),
    [sym_try] = STATE(529),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(559),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(544),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(2),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(91),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(363),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(351),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_not] = ACTIONS(73),
    [anon_sym_bnot] = ACTIONS(73),
    [anon_sym_catch] = ACTIONS(75),
    [anon_sym_fun] = ACTIONS(353),
    [anon_sym_end] = ACTIONS(365),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_after] = ACTIONS(367),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [92] = {
    [sym__expression] = STATE(1011),
    [sym__parenthesized_expression] = STATE(559),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(529),
    [sym_list] = STATE(529),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(529),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(529),
    [sym_clause] = STATE(1117),
    [sym__items] = STATE(1288),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_after] = STATE(1414),
    [sym_try] = STATE(529),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(559),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(544),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(2),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(92),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(363),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(351),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_not] = ACTIONS(73),
    [anon_sym_bnot] = ACTIONS(73),
    [anon_sym_catch] = ACTIONS(75),
    [anon_sym_fun] = ACTIONS(353),
    [anon_sym_end] = ACTIONS(369),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_after] = ACTIONS(367),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [93] = {
    [sym_function] = STATE(1286),
    [sym__semicolon_separated_expressions] = STATE(1384),
    [sym__expression] = STATE(721),
    [sym__parenthesized_expression] = STATE(559),
    [sym_bitstring] = STATE(540),
    [sym_tuple] = STATE(529),
    [sym_list] = STATE(529),
    [sym_map] = STATE(540),
    [sym_record] = STATE(540),
    [sym_unary_operator] = STATE(529),
    [sym_binary_operator] = STATE(540),
    [sym__literal] = STATE(1225),
    [sym_anonymous_function] = STATE(529),
    [sym__named_stab_clause] = STATE(1246),
    [sym__body] = STATE(1284),
    [sym_body] = STATE(1083),
    [sym_call] = STATE(540),
    [sym__qualified_function] = STATE(1305),
    [sym__unqualified_function] = STATE(1302),
    [sym_function_capture] = STATE(540),
    [sym_function_type] = STATE(540),
    [sym_block] = STATE(540),
    [sym_if] = STATE(540),
    [sym_case] = STATE(540),
    [sym_receive] = STATE(540),
    [sym_try] = STATE(529),
    [sym_maybe] = STATE(540),
    [sym_character] = STATE(542),
    [sym__number] = STATE(559),
    [sym_integer] = STATE(543),
    [sym__identifier] = STATE(675),
    [sym__atom] = STATE(533),
    [sym_quoted_atom] = STATE(522),
    [sym_macro] = STATE(13),
    [sym__strings] = STATE(540),
    [sym_string] = STATE(526),
    [sym_comment] = STATE(93),
    [aux_sym__strings_repeat1] = STATE(512),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(363),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_POUND] = ACTIONS(351),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_not] = ACTIONS(73),
    [anon_sym_bnot] = ACTIONS(73),
    [anon_sym_catch] = ACTIONS(75),
    [anon_sym_fun] = ACTIONS(353),
    [anon_sym_begin] = ACTIONS(81),
    [anon_sym_case] = ACTIONS(83),
    [anon_sym_receive] = ACTIONS(85),
    [anon_sym_try] = ACTIONS(87),
    [anon_sym_maybe] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [aux_sym_integer_token1] = ACTIONS(93),
    [aux_sym_integer_token2] = ACTIONS(95),
    [sym_float] = ACTIONS(97),
    [sym_atom] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [sym_variable] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_tripledot] = ACTIONS(109),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(94), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1232), 1,
      sym__if_clause,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1348), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [153] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(347), 1,
      anon_sym_LPAREN,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(371), 1,
      anon_sym_RPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(95), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(950), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1314), 1,
      sym__items,
    STATE(1404), 1,
      sym_arguments,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [306] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(347), 1,
      anon_sym_LPAREN,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(373), 1,
      anon_sym_RPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(96), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(950), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1314), 1,
      sym__items,
    STATE(1343), 1,
      sym_arguments,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [459] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(97), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1238), 1,
      sym__if_clause,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1348), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [612] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LT_LT,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_catch,
    ACTIONS(27), 1,
      anon_sym_begin,
    ACTIONS(29), 1,
      anon_sym_case,
    ACTIONS(31), 1,
      anon_sym_receive,
    ACTIONS(33), 1,
      anon_sym_try,
    ACTIONS(35), 1,
      anon_sym_maybe,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      aux_sym_integer_token1,
    ACTIONS(41), 1,
      aux_sym_integer_token2,
    ACTIONS(43), 1,
      sym_float,
    ACTIONS(49), 1,
      sym_variable,
    ACTIONS(51), 1,
      anon_sym_QMARK,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      sym_tripledot,
    ACTIONS(163), 1,
      anon_sym_fun,
    ACTIONS(375), 1,
      anon_sym_define,
    ACTIONS(379), 1,
      anon_sym_if,
    ACTIONS(381), 1,
      sym_atom,
    ACTIONS(383), 1,
      anon_sym_SQUOTE,
    STATE(4), 1,
      sym__atom,
    STATE(19), 1,
      sym_macro,
    STATE(44), 1,
      sym_quoted_atom,
    STATE(98), 1,
      sym_comment,
    STATE(604), 1,
      aux_sym__strings_repeat1,
    STATE(686), 1,
      sym_string,
    STATE(710), 1,
      sym__identifier,
    STATE(741), 1,
      sym_integer,
    STATE(742), 1,
      sym_character,
    STATE(781), 1,
      sym__expression,
    STATE(1252), 1,
      sym__literal,
    STATE(1293), 1,
      sym__qualified_function,
    STATE(1300), 1,
      sym__unqualified_function,
    ACTIONS(377), 2,
      anon_sym_spec,
      anon_sym_callback,
    STATE(905), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(21), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(699), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(773), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [763] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(99), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1304), 1,
      sym__if_clause,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1348), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [916] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(100), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(653), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1152), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1066] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(101), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1223), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1306), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1216] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(391), 1,
      anon_sym_RBRACK,
    STATE(2), 1,
      sym_macro,
    STATE(102), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1315), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1366] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(103), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(769), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1145), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1516] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(104), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(769), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1121), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1666] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(105), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(769), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1133), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1816] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(106), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(769), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1134), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1966] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(107), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1365), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [2116] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(395), 1,
      anon_sym_end,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(108), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(989), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1316), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [2266] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(131), 1,
      anon_sym_catch,
    ACTIONS(133), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(361), 1,
      anon_sym_POUND,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(20), 1,
      sym_macro,
    STATE(109), 1,
      sym_comment,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(603), 1,
      aux_sym__strings_repeat1,
    STATE(701), 1,
      sym__identifier,
    STATE(706), 1,
      sym_integer,
    STATE(707), 1,
      sym_character,
    STATE(926), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1145), 1,
      sym__body,
    STATE(1249), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(129), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [2416] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_GT_GT,
    STATE(2), 1,
      sym_macro,
    STATE(110), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1319), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [2566] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(401), 1,
      anon_sym_RBRACE,
    STATE(2), 1,
      sym_macro,
    STATE(111), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1341), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [2716] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(112), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(783), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1366), 1,
      sym__body,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [2866] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(403), 1,
      anon_sym_fun,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_macro,
    STATE(113), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(813), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1225), 1,
      sym__literal,
    STATE(1276), 1,
      sym__body,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3016] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(114), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1354), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3166] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(115), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1353), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3316] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(407), 1,
      anon_sym_GT_GT,
    STATE(2), 1,
      sym_macro,
    STATE(116), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1392), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3466] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(409), 1,
      anon_sym_RBRACE,
    STATE(2), 1,
      sym_macro,
    STATE(117), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1424), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3616] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(411), 1,
      anon_sym_RBRACK,
    STATE(2), 1,
      sym_macro,
    STATE(118), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1423), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3766] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    ACTIONS(413), 1,
      anon_sym_end,
    STATE(17), 1,
      sym_macro,
    STATE(119), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(989), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1417), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3916] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(415), 1,
      anon_sym_RPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(120), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1379), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4066] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(417), 1,
      anon_sym_RBRACE,
    STATE(2), 1,
      sym_macro,
    STATE(121), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1394), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4216] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(349), 1,
      anon_sym_RPAREN,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(122), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1314), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4366] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(123), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1351), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4516] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(419), 1,
      anon_sym_RPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(124), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1391), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4666] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(125), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1192), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1278), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4816] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(421), 1,
      anon_sym_RBRACE,
    STATE(2), 1,
      sym_macro,
    STATE(126), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1374), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4966] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(131), 1,
      anon_sym_catch,
    ACTIONS(133), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(361), 1,
      anon_sym_POUND,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(20), 1,
      sym_macro,
    STATE(127), 1,
      sym_comment,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(603), 1,
      aux_sym__strings_repeat1,
    STATE(701), 1,
      sym__identifier,
    STATE(706), 1,
      sym_integer,
    STATE(707), 1,
      sym_character,
    STATE(926), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1134), 1,
      sym__body,
    STATE(1249), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(129), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5116] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(128), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1112), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1278), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5266] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(129), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(783), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1200), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5416] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(423), 1,
      anon_sym_RPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(130), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1382), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5566] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(131), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1128), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1288), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5716] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(132), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1141), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1288), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5866] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(133), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(776), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1145), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6016] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(134), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1221), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1306), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6166] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(135), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(783), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1121), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6316] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(136), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(776), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1121), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6466] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(137), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1425), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6616] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(138), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1105), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1278), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6766] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(131), 1,
      anon_sym_catch,
    ACTIONS(133), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(361), 1,
      anon_sym_POUND,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(20), 1,
      sym_macro,
    STATE(139), 1,
      sym_comment,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(603), 1,
      aux_sym__strings_repeat1,
    STATE(701), 1,
      sym__identifier,
    STATE(706), 1,
      sym_integer,
    STATE(707), 1,
      sym_character,
    STATE(926), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1133), 1,
      sym__body,
    STATE(1249), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(129), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6916] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(140), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1140), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1288), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7066] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(141), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1192), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1306), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7216] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(349), 1,
      anon_sym_RPAREN,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(142), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(950), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1314), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7366] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(425), 1,
      anon_sym_RBRACE,
    STATE(2), 1,
      sym_macro,
    STATE(143), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1317), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7516] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(403), 1,
      anon_sym_fun,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_macro,
    STATE(144), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(813), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1225), 1,
      sym__literal,
    STATE(1283), 1,
      sym__body,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7666] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(145), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(653), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1144), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7816] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(146), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(783), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1195), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7966] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(147), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1325), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [8116] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(148), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(783), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1225), 1,
      sym__literal,
    STATE(1296), 1,
      sym__body,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [8266] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(149), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1136), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1288), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [8416] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(150), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1326), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [8566] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(151), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(783), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1145), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [8716] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(427), 1,
      anon_sym_RPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(152), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1359), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [8866] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(429), 1,
      anon_sym_RPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(153), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1329), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9016] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(431), 1,
      anon_sym_RPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(154), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1419), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9166] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(155), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1322), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9316] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(433), 1,
      anon_sym_RPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(156), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1330), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9466] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(435), 1,
      anon_sym_RPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(157), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1407), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9616] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(131), 1,
      anon_sym_catch,
    ACTIONS(133), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(361), 1,
      anon_sym_POUND,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(20), 1,
      sym_macro,
    STATE(158), 1,
      sym_comment,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(603), 1,
      aux_sym__strings_repeat1,
    STATE(701), 1,
      sym__identifier,
    STATE(706), 1,
      sym_integer,
    STATE(707), 1,
      sym_character,
    STATE(780), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1121), 1,
      sym__body,
    STATE(1249), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(129), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9766] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(10), 1,
      sym_macro,
    STATE(159), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(675), 1,
      sym__identifier,
    STATE(897), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1247), 1,
      sym__named_stab_clause,
    STATE(1282), 1,
      sym_function,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9916] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_RBRACE,
    STATE(2), 1,
      sym_macro,
    STATE(160), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1361), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [10066] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(161), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1151), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1288), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [10216] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(162), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(725), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1200), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [10366] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(163), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1364), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [10516] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(131), 1,
      anon_sym_catch,
    ACTIONS(133), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(361), 1,
      anon_sym_POUND,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(20), 1,
      sym_macro,
    STATE(164), 1,
      sym_comment,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(603), 1,
      aux_sym__strings_repeat1,
    STATE(701), 1,
      sym__identifier,
    STATE(706), 1,
      sym_integer,
    STATE(707), 1,
      sym_character,
    STATE(780), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1145), 1,
      sym__body,
    STATE(1249), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(129), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [10666] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(165), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1143), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1288), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [10816] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(166), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(725), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1195), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [10966] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(167), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(783), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1133), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [11116] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(168), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1362), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [11266] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(169), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(783), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1134), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [11416] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(170), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1242), 1,
      sym_clause,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1306), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [11566] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(171), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(651), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1200), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [11716] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(131), 1,
      anon_sym_catch,
    ACTIONS(133), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(361), 1,
      anon_sym_POUND,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(20), 1,
      sym_macro,
    STATE(172), 1,
      sym_comment,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(603), 1,
      aux_sym__strings_repeat1,
    STATE(701), 1,
      sym__identifier,
    STATE(706), 1,
      sym_integer,
    STATE(707), 1,
      sym_character,
    STATE(926), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1121), 1,
      sym__body,
    STATE(1249), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(129), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [11866] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(173), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1257), 1,
      sym_clause,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1306), 1,
      sym__items,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [12016] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(174), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(968), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1375), 1,
      sym__body,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [12166] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(175), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1011), 1,
      sym__expression,
    STATE(1192), 1,
      sym_clause,
    STATE(1225), 1,
      sym__literal,
    STATE(1288), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [12316] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(176), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(651), 1,
      sym__expression,
    STATE(1083), 1,
      sym_body,
    STATE(1195), 1,
      sym__body,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [12466] = 43,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(177), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1216), 1,
      sym__items,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(1368), 1,
      sym_guard,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [12616] = 42,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(178), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1248), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [12763] = 42,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(131), 1,
      anon_sym_catch,
    ACTIONS(133), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(361), 1,
      anon_sym_POUND,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(20), 1,
      sym_macro,
    STATE(179), 1,
      sym_comment,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(603), 1,
      aux_sym__strings_repeat1,
    STATE(701), 1,
      sym__identifier,
    STATE(706), 1,
      sym_integer,
    STATE(707), 1,
      sym_character,
    STATE(771), 1,
      sym__expression,
    STATE(1249), 1,
      sym__literal,
    STATE(1266), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(129), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [12910] = 42,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(131), 1,
      anon_sym_catch,
    ACTIONS(133), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(361), 1,
      anon_sym_POUND,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(20), 1,
      sym_macro,
    STATE(180), 1,
      sym_comment,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(603), 1,
      aux_sym__strings_repeat1,
    STATE(701), 1,
      sym__identifier,
    STATE(706), 1,
      sym_integer,
    STATE(707), 1,
      sym_character,
    STATE(771), 1,
      sym__expression,
    STATE(1249), 1,
      sym__literal,
    STATE(1267), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(129), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [13057] = 42,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(181), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1273), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [13204] = 42,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(182), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(941), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1299), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [13351] = 42,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(131), 1,
      anon_sym_catch,
    ACTIONS(133), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(361), 1,
      anon_sym_POUND,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(20), 1,
      sym_macro,
    STATE(183), 1,
      sym_comment,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(603), 1,
      aux_sym__strings_repeat1,
    STATE(701), 1,
      sym__identifier,
    STATE(706), 1,
      sym_integer,
    STATE(707), 1,
      sym_character,
    STATE(771), 1,
      sym__expression,
    STATE(1217), 1,
      sym__items,
    STATE(1249), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(129), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [13498] = 42,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(184), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(608), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1266), 1,
      sym__items,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [13645] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(185), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(757), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [13789] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(216), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_macro,
    STATE(186), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(1014), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [13933] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(187), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(664), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [14077] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(188), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(674), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [14221] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(189), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(633), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [14365] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(190), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(683), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [14509] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(191), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(685), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [14653] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(192), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(679), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [14797] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(216), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_macro,
    STATE(193), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(999), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [14941] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(194), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(670), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [15085] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(216), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_macro,
    STATE(195), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(1013), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [15229] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(196), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1024), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [15373] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(197), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(658), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [15517] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(198), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(657), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [15661] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(199), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(656), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [15805] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(200), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(541), 1,
      sym__expression,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [15949] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(201), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(655), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [16093] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(202), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1029), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [16237] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(203), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1040), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [16381] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(204), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1018), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [16525] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(205), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1022), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [16669] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(206), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1027), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [16813] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(207), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1028), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [16957] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(208), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1030), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [17101] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(209), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1034), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [17245] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(210), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1038), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [17389] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(211), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1039), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [17533] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(212), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1036), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [17677] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(213), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1021), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [17821] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(214), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1032), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [17965] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(215), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(541), 1,
      sym__expression,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [18109] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    ACTIONS(449), 1,
      anon_sym_fun,
    STATE(23), 1,
      sym_macro,
    STATE(216), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1025), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [18253] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(217), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(944), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [18397] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(218), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(762), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [18541] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(219), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(728), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [18685] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(220), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(760), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [18829] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(221), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(759), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [18973] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(222), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(758), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [19117] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(223), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1020), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [19261] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(224), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(756), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [19405] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(225), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(755), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [19549] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(226), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(754), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [19693] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(227), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(720), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [19837] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(228), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(753), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [19981] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(229), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(752), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [20125] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(230), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(751), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [20269] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(231), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(750), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [20413] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(232), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(749), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [20557] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(233), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(541), 1,
      sym__expression,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [20701] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(234), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(748), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [20845] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(235), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(541), 1,
      sym__expression,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [20989] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(236), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(719), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [21133] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(237), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(718), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [21277] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(238), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(717), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [21421] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(239), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(716), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [21565] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(240), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(715), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [21709] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(241), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1019), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [21853] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_LT_LT,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_catch,
    ACTIONS(25), 1,
      anon_sym_fun,
    ACTIONS(27), 1,
      anon_sym_begin,
    ACTIONS(29), 1,
      anon_sym_case,
    ACTIONS(31), 1,
      anon_sym_receive,
    ACTIONS(33), 1,
      anon_sym_try,
    ACTIONS(35), 1,
      anon_sym_maybe,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      aux_sym_integer_token1,
    ACTIONS(41), 1,
      aux_sym_integer_token2,
    ACTIONS(43), 1,
      sym_float,
    ACTIONS(45), 1,
      sym_atom,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      sym_variable,
    ACTIONS(51), 1,
      anon_sym_QMARK,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      sym_tripledot,
    STATE(16), 1,
      sym_macro,
    STATE(242), 1,
      sym_comment,
    STATE(604), 1,
      aux_sym__strings_repeat1,
    STATE(686), 1,
      sym_string,
    STATE(698), 1,
      sym_quoted_atom,
    STATE(704), 1,
      sym__atom,
    STATE(705), 1,
      sym__identifier,
    STATE(741), 1,
      sym_integer,
    STATE(742), 1,
      sym_character,
    STATE(943), 1,
      sym__expression,
    STATE(1252), 1,
      sym__literal,
    STATE(1293), 1,
      sym__qualified_function,
    STATE(1300), 1,
      sym__unqualified_function,
    STATE(775), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(21), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(746), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(773), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [21997] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(243), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(654), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [22141] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(244), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(650), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [22285] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(245), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(714), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [22429] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(14), 1,
      sym_macro,
    STATE(246), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(809), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [22573] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(14), 1,
      sym_macro,
    STATE(247), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(810), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [22717] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(248), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(713), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [22861] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(249), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(712), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [23005] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(250), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(694), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [23149] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_LT_LT,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_catch,
    ACTIONS(25), 1,
      anon_sym_fun,
    ACTIONS(27), 1,
      anon_sym_begin,
    ACTIONS(29), 1,
      anon_sym_case,
    ACTIONS(31), 1,
      anon_sym_receive,
    ACTIONS(33), 1,
      anon_sym_try,
    ACTIONS(35), 1,
      anon_sym_maybe,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      aux_sym_integer_token1,
    ACTIONS(41), 1,
      aux_sym_integer_token2,
    ACTIONS(43), 1,
      sym_float,
    ACTIONS(45), 1,
      sym_atom,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      sym_variable,
    ACTIONS(51), 1,
      anon_sym_QMARK,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      sym_tripledot,
    STATE(16), 1,
      sym_macro,
    STATE(251), 1,
      sym_comment,
    STATE(604), 1,
      aux_sym__strings_repeat1,
    STATE(686), 1,
      sym_string,
    STATE(698), 1,
      sym_quoted_atom,
    STATE(704), 1,
      sym__atom,
    STATE(705), 1,
      sym__identifier,
    STATE(741), 1,
      sym_integer,
    STATE(742), 1,
      sym_character,
    STATE(946), 1,
      sym__expression,
    STATE(1252), 1,
      sym__literal,
    STATE(1293), 1,
      sym__qualified_function,
    STATE(1300), 1,
      sym__unqualified_function,
    STATE(775), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(21), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(746), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(773), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [23293] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(252), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(730), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [23437] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(253), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(739), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [23581] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(254), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(737), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [23725] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(255), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(736), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [23869] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(256), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(735), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [24013] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(257), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(734), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [24157] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(258), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(733), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [24301] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(259), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(708), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [24445] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(260), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(709), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [24589] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(261), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(732), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [24733] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(262), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(731), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [24877] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(263), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(642), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [25021] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(264), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(729), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [25165] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(265), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(744), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [25309] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(266), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(641), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [25453] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(267), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(692), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [25597] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_LT_LT,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_catch,
    ACTIONS(25), 1,
      anon_sym_fun,
    ACTIONS(27), 1,
      anon_sym_begin,
    ACTIONS(29), 1,
      anon_sym_case,
    ACTIONS(31), 1,
      anon_sym_receive,
    ACTIONS(33), 1,
      anon_sym_try,
    ACTIONS(35), 1,
      anon_sym_maybe,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      aux_sym_integer_token1,
    ACTIONS(41), 1,
      aux_sym_integer_token2,
    ACTIONS(43), 1,
      sym_float,
    ACTIONS(45), 1,
      sym_atom,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      sym_variable,
    ACTIONS(51), 1,
      anon_sym_QMARK,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      sym_tripledot,
    STATE(16), 1,
      sym_macro,
    STATE(268), 1,
      sym_comment,
    STATE(604), 1,
      aux_sym__strings_repeat1,
    STATE(686), 1,
      sym_string,
    STATE(698), 1,
      sym_quoted_atom,
    STATE(704), 1,
      sym__atom,
    STATE(705), 1,
      sym__identifier,
    STATE(741), 1,
      sym_integer,
    STATE(742), 1,
      sym_character,
    STATE(948), 1,
      sym__expression,
    STATE(1252), 1,
      sym__literal,
    STATE(1293), 1,
      sym__qualified_function,
    STATE(1300), 1,
      sym__unqualified_function,
    STATE(775), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(21), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(746), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(773), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [25741] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(269), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(727), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [25885] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(270), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(541), 1,
      sym__expression,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [26029] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(8), 1,
      sym_macro,
    STATE(271), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(726), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [26173] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(272), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(839), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [26317] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(273), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(840), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [26461] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(274), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(841), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [26605] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(275), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(842), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [26749] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(276), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(843), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [26893] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(277), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(761), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [27037] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(278), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(844), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [27181] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(279), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(845), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [27325] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(280), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(846), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [27469] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(281), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(847), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [27613] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(282), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(850), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [27757] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    STATE(6), 1,
      sym_macro,
    STATE(283), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(640), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [27901] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(284), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(851), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [28045] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(285), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(852), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [28189] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(286), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(853), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [28333] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(287), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(695), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [28477] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(288), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(766), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [28621] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(289), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(541), 1,
      sym__expression,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [28765] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(439), 1,
      anon_sym_fun,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    STATE(9), 1,
      sym_macro,
    STATE(290), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(854), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [28909] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(291), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(696), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [29053] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(292), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(861), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [29197] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(293), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(697), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [29341] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(294), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(862), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [29485] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(295), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(765), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [29629] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(296), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(939), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [29773] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(297), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(863), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [29917] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(298), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(864), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [30061] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(299), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(865), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [30205] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(300), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(866), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [30349] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(301), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(869), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [30493] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(302), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(957), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [30637] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(303), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(870), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [30781] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(304), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(937), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [30925] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(305), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(871), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [31069] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(306), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(872), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [31213] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(307), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(873), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [31357] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(308), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(874), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [31501] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(309), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(876), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [31645] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(310), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(541), 1,
      sym__expression,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [31789] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(210), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(21), 1,
      sym_macro,
    STATE(311), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(887), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [31933] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(312), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(947), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [32077] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(313), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(992), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [32221] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(314), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(991), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [32365] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(315), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(990), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [32509] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(316), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(988), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [32653] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(317), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(987), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [32797] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(318), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(986), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [32941] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(319), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(979), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [33085] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(320), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(965), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [33229] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(321), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(956), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [33373] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(322), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(953), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [33517] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(323), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(541), 1,
      sym__expression,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [33661] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(200), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      anon_sym_fun,
    ACTIONS(397), 1,
      anon_sym_QMARK,
    STATE(17), 1,
      sym_macro,
    STATE(324), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(951), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(198), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [33805] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_catch,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(353), 1,
      anon_sym_fun,
    ACTIONS(355), 1,
      anon_sym_QMARK,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(325), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(665), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(73), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [33949] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(326), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(667), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [34093] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(327), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(669), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [34237] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(11), 1,
      sym_macro,
    STATE(328), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(738), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [34381] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(403), 1,
      anon_sym_fun,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_macro,
    STATE(329), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(959), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [34525] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(330), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(660), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [34669] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(331), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(661), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [34813] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(332), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(666), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [34957] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(333), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(671), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [35101] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(334), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(672), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [35245] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(335), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(677), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [35389] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(336), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(678), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [35533] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(337), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(647), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [35677] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(338), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(680), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [35821] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(339), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(634), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [35965] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(340), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(689), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [36109] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(341), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(690), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [36253] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(342), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(691), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [36397] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(343), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(688), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [36541] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(344), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(541), 1,
      sym__expression,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [36685] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(385), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(345), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(687), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [36829] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(441), 1,
      anon_sym_QMARK,
    ACTIONS(443), 1,
      anon_sym_catch,
    ACTIONS(445), 1,
      anon_sym_fun,
    STATE(7), 1,
      sym_macro,
    STATE(346), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(702), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [36973] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(208), 1,
      anon_sym_catch,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(403), 1,
      anon_sym_fun,
    ACTIONS(405), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_macro,
    STATE(347), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(541), 1,
      sym__expression,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(544), 1,
      sym__identifier,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(559), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(206), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(529), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [37117] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(216), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_macro,
    STATE(348), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(1002), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(540), 13,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_call,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [37261] = 41,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(65), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      anon_sym_LT_LT,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(81), 1,
      anon_sym_begin,
    ACTIONS(83), 1,
      anon_sym_case,
    ACTIONS(85), 1,
      anon_sym_receive,
    ACTIONS(87), 1,
      anon_sym_try,
    ACTIONS(89), 1,
      anon_sym_maybe,
    ACTIONS(91), 1,
      anon_sym_DOLLAR,
    ACTIONS(93), 1,
      aux_sym_integer_token1,
    ACTIONS(95), 1,
      aux_sym_integer_token2,
    ACTIONS(97), 1,
      sym_float,
    ACTIONS(99), 1,
      sym_atom,
    ACTIONS(101), 1,
      anon_sym_SQUOTE,
    ACTIONS(103), 1,
      sym_variable,
    ACTIONS(109), 1,
      sym_tripledot,
    ACTIONS(214), 1,
      anon_sym_catch,
    ACTIONS(216), 1,
      anon_sym_fun,
    ACTIONS(351), 1,
      anon_sym_POUND,
    ACTIONS(357), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_macro,
    STATE(349), 1,
      sym_comment,
    STATE(512), 1,
      aux_sym__strings_repeat1,
    STATE(522), 1,
      sym_quoted_atom,
    STATE(526), 1,
      sym_string,
    STATE(533), 1,
      sym__atom,
    STATE(542), 1,
      sym_character,
    STATE(543), 1,
      sym_integer,
    STATE(558), 1,
      sym__identifier,
    STATE(1001), 1,
      sym__expression,
    STATE(1225), 1,
      sym__literal,
    STATE(1302), 1,
      sym__unqualified_function,
    STATE(1305), 1,
      sym__qualified_function,
    STATE(595), 2,
      sym__parenthesized_expression,
      sym__number,
    ACTIONS(212), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(535), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
