#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 730
#define LARGE_STATE_COUNT 4
#define SYMBOL_COUNT 121
#define ALIAS_COUNT 0
#define TOKEN_COUNT 64
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 8
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 17

enum {
  anon_sym_and = 1,
  anon_sym_or = 2,
  anon_sym_PIPE_PIPE = 3,
  anon_sym_AMP_AMP = 4,
  sym_stream_redirect = 5,
  sym_direction = 6,
  anon_sym_PIPE = 7,
  anon_sym_SEMI = 8,
  anon_sym_AMP = 9,
  anon_sym_LF = 10,
  anon_sym_CR = 11,
  anon_sym_CR_LF = 12,
  anon_sym_BANG = 13,
  anon_sym_not = 14,
  anon_sym_DOLLAR = 15,
  anon_sym_LPAREN = 16,
  anon_sym_RPAREN = 17,
  anon_sym_function = 18,
  anon_sym_end = 19,
  sym_integer = 20,
  sym_float = 21,
  anon_sym_return = 22,
  anon_sym_switch = 23,
  anon_sym_case = 24,
  sym_break = 25,
  sym_continue = 26,
  anon_sym_for = 27,
  anon_sym_in = 28,
  anon_sym_while = 29,
  anon_sym_if = 30,
  anon_sym_else = 31,
  anon_sym_begin = 32,
  aux_sym_test_command_token1 = 33,
  anon_sym_RBRACK = 34,
  aux_sym_test_command_token2 = 35,
  anon_sym_test = 36,
  anon_sym_BSLASH_LPAREN = 37,
  anon_sym_BSLASH_RPAREN = 38,
  anon_sym_DASHa = 39,
  anon_sym_DASHo = 40,
  anon_sym_EQ = 41,
  anon_sym_BANG_EQ = 42,
  sym_test_option = 43,
  sym_comment = 44,
  sym_variable_name = 45,
  anon_sym_DOT_DOT = 46,
  anon_sym_LBRACK = 47,
  anon_sym_LBRACE = 48,
  anon_sym_COMMA = 49,
  anon_sym_RBRACE = 50,
  anon_sym_DQUOTE = 51,
  aux_sym_double_quote_string_token1 = 52,
  anon_sym_SQUOTE = 53,
  aux_sym_single_quote_string_token1 = 54,
  sym_escape_sequence = 55,
  sym__special_character = 56,
  sym_home_dir_expansion = 57,
  sym_glob = 58,
  sym_word = 59,
  sym_brace_word = 60,
  sym__concat = 61,
  sym__brace_concat = 62,
  sym__concat_list = 63,
  sym_program = 64,
  sym_conditional_execution = 65,
  sym_redirected_statement = 66,
  sym_file_redirect = 67,
  sym_pipe = 68,
  sym__terminated_statement = 69,
  sym__terminated_opt_statement = 70,
  sym_negated_statement = 71,
  sym_command_substitution_dollar = 72,
  sym_command_substitution_fish = 73,
  sym_command_substitution = 74,
  sym_function_definition = 75,
  sym_return = 76,
  sym_switch_statement = 77,
  sym_case_clause = 78,
  sym_for_statement = 79,
  sym_while_statement = 80,
  sym_if_statement = 81,
  sym_else_if_clause = 82,
  sym_else_clause = 83,
  sym_begin_statement = 84,
  sym_test_command = 85,
  sym__test_expression = 86,
  sym__parenthesized_test_expression = 87,
  sym_negated_expression = 88,
  sym_conditional_expression = 89,
  sym_unary_expression = 90,
  sym_binary_expression = 91,
  sym_variable_expansion = 92,
  sym_index = 93,
  sym_range = 94,
  sym_list_element_access = 95,
  sym_brace_expansion = 96,
  sym_double_quote_string = 97,
  sym_single_quote_string = 98,
  sym_command = 99,
  sym_concatenation = 100,
  sym__expression = 101,
  sym_brace_concatenation = 102,
  sym__brace_expression = 103,
  sym__base_brace_expression = 104,
  aux_sym_program_repeat1 = 105,
  aux_sym_function_definition_repeat1 = 106,
  aux_sym_function_definition_repeat2 = 107,
  aux_sym_switch_statement_repeat1 = 108,
  aux_sym_case_clause_repeat1 = 109,
  aux_sym_for_statement_repeat1 = 110,
  aux_sym_while_statement_repeat1 = 111,
  aux_sym_if_statement_repeat1 = 112,
  aux_sym_variable_expansion_repeat1 = 113,
  aux_sym_list_element_access_repeat1 = 114,
  aux_sym_brace_expansion_repeat1 = 115,
  aux_sym_double_quote_string_repeat1 = 116,
  aux_sym_single_quote_string_repeat1 = 117,
  aux_sym_command_repeat1 = 118,
  aux_sym_concatenation_repeat1 = 119,
  aux_sym_brace_concatenation_repeat1 = 120,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [sym_stream_redirect] = "stream_redirect",
  [sym_direction] = "direction",
  [anon_sym_PIPE] = "|",
  [anon_sym_SEMI] = ";",
  [anon_sym_AMP] = "&",
  [anon_sym_LF] = "\n",
  [anon_sym_CR] = "\r",
  [anon_sym_CR_LF] = "\r\n",
  [anon_sym_BANG] = "!",
  [anon_sym_not] = "not",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_function] = "function",
  [anon_sym_end] = "end",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_return] = "return",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [sym_break] = "break",
  [sym_continue] = "continue",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_begin] = "begin",
  [aux_sym_test_command_token1] = "[",
  [anon_sym_RBRACK] = "]",
  [aux_sym_test_command_token2] = "]",
  [anon_sym_test] = "test",
  [anon_sym_BSLASH_LPAREN] = "\\(",
  [anon_sym_BSLASH_RPAREN] = "\\)",
  [anon_sym_DASHa] = "test_option",
  [anon_sym_DASHo] = "test_option",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG_EQ] = "!=",
  [sym_test_option] = "test_option",
  [sym_comment] = "comment",
  [sym_variable_name] = "variable_name",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_LBRACK] = "[",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_double_quote_string_token1] = "double_quote_string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_single_quote_string_token1] = "single_quote_string_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym__special_character] = "_special_character",
  [sym_home_dir_expansion] = "home_dir_expansion",
  [sym_glob] = "glob",
  [sym_word] = "word",
  [sym_brace_word] = "word",
  [sym__concat] = "_concat",
  [sym__brace_concat] = "_brace_concat",
  [sym__concat_list] = "_concat_list",
  [sym_program] = "program",
  [sym_conditional_execution] = "conditional_execution",
  [sym_redirected_statement] = "redirected_statement",
  [sym_file_redirect] = "file_redirect",
  [sym_pipe] = "pipe",
  [sym__terminated_statement] = "_terminated_statement",
  [sym__terminated_opt_statement] = "_terminated_opt_statement",
  [sym_negated_statement] = "negated_statement",
  [sym_command_substitution_dollar] = "command_substitution_dollar",
  [sym_command_substitution_fish] = "command_substitution_fish",
  [sym_command_substitution] = "command_substitution",
  [sym_function_definition] = "function_definition",
  [sym_return] = "return",
  [sym_switch_statement] = "switch_statement",
  [sym_case_clause] = "case_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_if_clause] = "else_if_clause",
  [sym_else_clause] = "else_clause",
  [sym_begin_statement] = "begin_statement",
  [sym_test_command] = "test_command",
  [sym__test_expression] = "_test_expression",
  [sym__parenthesized_test_expression] = "_parenthesized_test_expression",
  [sym_negated_expression] = "negated_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_variable_expansion] = "variable_expansion",
  [sym_index] = "index",
  [sym_range] = "range",
  [sym_list_element_access] = "list_element_access",
  [sym_brace_expansion] = "brace_expansion",
  [sym_double_quote_string] = "double_quote_string",
  [sym_single_quote_string] = "single_quote_string",
  [sym_command] = "command",
  [sym_concatenation] = "concatenation",
  [sym__expression] = "_expression",
  [sym_brace_concatenation] = "concatenation",
  [sym__brace_expression] = "_brace_expression",
  [sym__base_brace_expression] = "_base_brace_expression",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_function_definition_repeat2] = "function_definition_repeat2",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym_case_clause_repeat1] = "case_clause_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_while_statement_repeat1] = "while_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_variable_expansion_repeat1] = "variable_expansion_repeat1",
  [aux_sym_list_element_access_repeat1] = "list_element_access_repeat1",
  [aux_sym_brace_expansion_repeat1] = "brace_expansion_repeat1",
  [aux_sym_double_quote_string_repeat1] = "double_quote_string_repeat1",
  [aux_sym_single_quote_string_repeat1] = "single_quote_string_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_brace_concatenation_repeat1] = "brace_concatenation_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [sym_stream_redirect] = sym_stream_redirect,
  [sym_direction] = sym_direction,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR] = anon_sym_CR,
  [anon_sym_CR_LF] = anon_sym_CR_LF,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_end] = anon_sym_end,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [sym_break] = sym_break,
  [sym_continue] = sym_continue,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_begin] = anon_sym_begin,
  [aux_sym_test_command_token1] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [aux_sym_test_command_token2] = anon_sym_RBRACK,
  [anon_sym_test] = anon_sym_test,
  [anon_sym_BSLASH_LPAREN] = anon_sym_BSLASH_LPAREN,
  [anon_sym_BSLASH_RPAREN] = anon_sym_BSLASH_RPAREN,
  [anon_sym_DASHa] = sym_test_option,
  [anon_sym_DASHo] = sym_test_option,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [sym_test_option] = sym_test_option,
  [sym_comment] = sym_comment,
  [sym_variable_name] = sym_variable_name,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_double_quote_string_token1] = aux_sym_double_quote_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_single_quote_string_token1] = aux_sym_single_quote_string_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__special_character] = sym__special_character,
  [sym_home_dir_expansion] = sym_home_dir_expansion,
  [sym_glob] = sym_glob,
  [sym_word] = sym_word,
  [sym_brace_word] = sym_word,
  [sym__concat] = sym__concat,
  [sym__brace_concat] = sym__brace_concat,
  [sym__concat_list] = sym__concat_list,
  [sym_program] = sym_program,
  [sym_conditional_execution] = sym_conditional_execution,
  [sym_redirected_statement] = sym_redirected_statement,
  [sym_file_redirect] = sym_file_redirect,
  [sym_pipe] = sym_pipe,
  [sym__terminated_statement] = sym__terminated_statement,
  [sym__terminated_opt_statement] = sym__terminated_opt_statement,
  [sym_negated_statement] = sym_negated_statement,
  [sym_command_substitution_dollar] = sym_command_substitution_dollar,
  [sym_command_substitution_fish] = sym_command_substitution_fish,
  [sym_command_substitution] = sym_command_substitution,
  [sym_function_definition] = sym_function_definition,
  [sym_return] = sym_return,
  [sym_switch_statement] = sym_switch_statement,
  [sym_case_clause] = sym_case_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_if_clause] = sym_else_if_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_begin_statement] = sym_begin_statement,
  [sym_test_command] = sym_test_command,
  [sym__test_expression] = sym__test_expression,
  [sym__parenthesized_test_expression] = sym__parenthesized_test_expression,
  [sym_negated_expression] = sym_negated_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_variable_expansion] = sym_variable_expansion,
  [sym_index] = sym_index,
  [sym_range] = sym_range,
  [sym_list_element_access] = sym_list_element_access,
  [sym_brace_expansion] = sym_brace_expansion,
  [sym_double_quote_string] = sym_double_quote_string,
  [sym_single_quote_string] = sym_single_quote_string,
  [sym_command] = sym_command,
  [sym_concatenation] = sym_concatenation,
  [sym__expression] = sym__expression,
  [sym_brace_concatenation] = sym_concatenation,
  [sym__brace_expression] = sym__brace_expression,
  [sym__base_brace_expression] = sym__base_brace_expression,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_function_definition_repeat2] = aux_sym_function_definition_repeat2,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym_case_clause_repeat1] = aux_sym_case_clause_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_while_statement_repeat1] = aux_sym_while_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_variable_expansion_repeat1] = aux_sym_variable_expansion_repeat1,
  [aux_sym_list_element_access_repeat1] = aux_sym_list_element_access_repeat1,
  [aux_sym_brace_expansion_repeat1] = aux_sym_brace_expansion_repeat1,
  [aux_sym_double_quote_string_repeat1] = aux_sym_double_quote_string_repeat1,
  [aux_sym_single_quote_string_repeat1] = aux_sym_single_quote_string_repeat1,
  [aux_sym_command_repeat1] = aux_sym_command_repeat1,
  [aux_sym_concatenation_repeat1] = aux_sym_concatenation_repeat1,
  [aux_sym_brace_concatenation_repeat1] = aux_sym_brace_concatenation_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_stream_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_direction] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_continue] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_test_command_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_test_command_token2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_test] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHa] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASHo] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_test_option] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_double_quote_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_single_quote_string_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__special_character] = {
    .visible = false,
    .named = true,
  },
  [sym_home_dir_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_glob] = {
    .visible = true,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_word] = {
    .visible = true,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym__brace_concat] = {
    .visible = false,
    .named = true,
  },
  [sym__concat_list] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_execution] = {
    .visible = true,
    .named = true,
  },
  [sym_redirected_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_file_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe] = {
    .visible = true,
    .named = true,
  },
  [sym__terminated_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__terminated_opt_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_negated_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution_dollar] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution_fish] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_begin_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_test_command] = {
    .visible = true,
    .named = true,
  },
  [sym__test_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__parenthesized_test_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_negated_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_index] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_list_element_access] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_double_quote_string] = {
    .visible = true,
    .named = true,
  },
  [sym_single_quote_string] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_brace_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym__brace_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__base_brace_expression] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_while_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_element_access_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_brace_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_quote_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_single_quote_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_brace_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_argument = 1,
  field_condition = 2,
  field_destination = 3,
  field_name = 4,
  field_operator = 5,
  field_option = 6,
  field_value = 7,
  field_variable = 8,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_condition] = "condition",
  [field_destination] = "destination",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_option] = "option",
  [field_value] = "value",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 2},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 2},
  [7] = {.index = 7, .length = 1},
  [8] = {.index = 8, .length = 2},
  [9] = {.index = 10, .length = 1},
  [10] = {.index = 11, .length = 2},
  [11] = {.index = 13, .length = 1},
  [12] = {.index = 14, .length = 1},
  [13] = {.index = 15, .length = 2},
  [14] = {.index = 17, .length = 2},
  [15] = {.index = 19, .length = 1},
  [16] = {.index = 20, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_argument, 0},
  [2] =
    {field_argument, 1, .inherited = true},
    {field_name, 0},
  [4] =
    {field_option, 0},
  [5] =
    {field_destination, 1},
    {field_operator, 0},
  [7] =
    {field_condition, 1},
  [8] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [10] =
    {field_name, 1},
  [11] =
    {field_option, 0, .inherited = true},
    {field_option, 1, .inherited = true},
  [13] =
    {field_value, 1},
  [14] =
    {field_value, 0},
  [15] =
    {field_name, 1},
    {field_option, 2, .inherited = true},
  [17] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [19] =
    {field_condition, 2},
  [20] =
    {field_value, 3, .inherited = true},
    {field_variable, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_word,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_word_character_set_1(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= '*' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= '^' || (c >= '{' && c <= '~')))));
}

static inline bool sym_word_character_set_2(int32_t c) {
  return (c < '"'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || c == ' '))
    : (c <= '$' || (c < '['
      ? (c < ';'
        ? (c >= '&' && c <= '*')
        : c <= ';')
      : (c <= '^' || (c >= '{' && c <= '~')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(100);
      if (lookahead == '!') ADVANCE(124);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '&') ADVANCE(117);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == ')') ADVANCE(130);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+') ADVANCE(96);
      if (lookahead == ',') ADVANCE(185);
      if (lookahead == '-') ADVANCE(36);
      if (lookahead == '.') ADVANCE(30);
      if (lookahead == ';') ADVANCE(115);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(176);
      if (lookahead == '>') ADVANCE(110);
      if (lookahead == '[') ADVANCE(183);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'b') ADVANCE(46);
      if (lookahead == 'c') ADVANCE(38);
      if (lookahead == 'e') ADVANCE(66);
      if (lookahead == 'f') ADVANCE(75);
      if (lookahead == 'i') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(74);
      if (lookahead == 'o') ADVANCE(77);
      if (lookahead == 'r') ADVANCE(53);
      if (lookahead == 's') ADVANCE(91);
      if (lookahead == 't') ADVANCE(52);
      if (lookahead == 'w') ADVANCE(58);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '|') ADVANCE(114);
      if (lookahead == '}') ADVANCE(186);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(9);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == '\r') ADVANCE(121);
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(270);
      if (lookahead == ';') ADVANCE(115);
      if (lookahead == '[') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == ']') ADVANCE(212);
      if (lookahead == 'a') ADVANCE(242);
      if (lookahead == 'b') ADVANCE(222);
      if (lookahead == 'c') ADVANCE(251);
      if (lookahead == 'e') ADVANCE(240);
      if (lookahead == 'f') ADVANCE(252);
      if (lookahead == 'i') ADVANCE(230);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(254);
      if (lookahead == 'r') ADVANCE(229);
      if (lookahead == 's') ADVANCE(268);
      if (lookahead == 't') ADVANCE(223);
      if (lookahead == 'w') ADVANCE(233);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(1)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(272);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == '\r') ADVANCE(121);
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(270);
      if (lookahead == ';') ADVANCE(115);
      if (lookahead == '[') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == ']') ADVANCE(212);
      if (lookahead == 'a') ADVANCE(242);
      if (lookahead == 'b') ADVANCE(222);
      if (lookahead == 'c') ADVANCE(251);
      if (lookahead == 'e') ADVANCE(247);
      if (lookahead == 'f') ADVANCE(252);
      if (lookahead == 'i') ADVANCE(230);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(254);
      if (lookahead == 'r') ADVANCE(229);
      if (lookahead == 's') ADVANCE(268);
      if (lookahead == 't') ADVANCE(223);
      if (lookahead == 'w') ADVANCE(233);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(2)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(272);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == '\r') ADVANCE(121);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '&') ADVANCE(117);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == ')') ADVANCE(130);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(270);
      if (lookahead == ';') ADVANCE(115);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '>') ADVANCE(110);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '|') ADVANCE(114);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '^' &&
          lookahead != '}') ADVANCE(272);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == '\r') ADVANCE(121);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(270);
      if (lookahead == ';') ADVANCE(115);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(272);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(119);
      if (lookahead == '\r') ADVANCE(122);
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '&') ADVANCE(117);
      if (lookahead == ')') ADVANCE(130);
      if (lookahead == '-') ADVANCE(37);
      if (lookahead == ';') ADVANCE(115);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(176);
      if (lookahead == '>') ADVANCE(110);
      if (lookahead == '\\') SKIP(93)
      if (lookahead == '|') ADVANCE(114);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(5)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(31);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(119);
      if (lookahead == '\r') ADVANCE(122);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '&') ADVANCE(117);
      if (lookahead == ')') ADVANCE(130);
      if (lookahead == '-') ADVANCE(40);
      if (lookahead == ';') ADVANCE(115);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '>') ADVANCE(110);
      if (lookahead == '\\') SKIP(94)
      if (lookahead == '|') ADVANCE(114);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(6)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(31);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(119);
      if (lookahead == '\r') ADVANCE(122);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == ';') ADVANCE(115);
      if (lookahead == '\\') SKIP(95)
      if (lookahead == 'i') ADVANCE(54);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(7)
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(120);
      if (lookahead == '\r') ADVANCE(123);
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '&') ADVANCE(117);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == ')') ADVANCE(130);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+') ADVANCE(270);
      if (lookahead == '-') ADVANCE(269);
      if (lookahead == ';') ADVANCE(115);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '>') ADVANCE(110);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '|') ADVANCE(114);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(8)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '^' &&
          lookahead != '}') ADVANCE(272);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(124);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '&') ADVANCE(117);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == ')') ADVANCE(130);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+') ADVANCE(96);
      if (lookahead == ',') ADVANCE(185);
      if (lookahead == '-') ADVANCE(36);
      if (lookahead == '.') ADVANCE(30);
      if (lookahead == ';') ADVANCE(115);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(176);
      if (lookahead == '>') ADVANCE(110);
      if (lookahead == '[') ADVANCE(183);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'b') ADVANCE(46);
      if (lookahead == 'c') ADVANCE(38);
      if (lookahead == 'e') ADVANCE(66);
      if (lookahead == 'f') ADVANCE(75);
      if (lookahead == 'i') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(74);
      if (lookahead == 'o') ADVANCE(77);
      if (lookahead == 'r') ADVANCE(53);
      if (lookahead == 's') ADVANCE(91);
      if (lookahead == 't') ADVANCE(52);
      if (lookahead == 'w') ADVANCE(58);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '|') ADVANCE(114);
      if (lookahead == '}') ADVANCE(186);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(9);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+') ADVANCE(270);
      if (lookahead == '-') ADVANCE(269);
      if (lookahead == '[') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(272);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+') ADVANCE(270);
      if (lookahead == '-') ADVANCE(269);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(272);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(270);
      if (lookahead == '[') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead == ']') ADVANCE(212);
      if (lookahead == 'a') ADVANCE(242);
      if (lookahead == 'b') ADVANCE(222);
      if (lookahead == 'c') ADVANCE(251);
      if (lookahead == 'e') ADVANCE(247);
      if (lookahead == 'f') ADVANCE(252);
      if (lookahead == 'i') ADVANCE(230);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(254);
      if (lookahead == 'r') ADVANCE(229);
      if (lookahead == 's') ADVANCE(268);
      if (lookahead == 't') ADVANCE(223);
      if (lookahead == 'w') ADVANCE(233);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(272);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(270);
      if (lookahead == '[') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead == ']') ADVANCE(212);
      if (lookahead == 'a') ADVANCE(242);
      if (lookahead == 'b') ADVANCE(222);
      if (lookahead == 'c') ADVANCE(251);
      if (lookahead == 'f') ADVANCE(252);
      if (lookahead == 'i') ADVANCE(230);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(254);
      if (lookahead == 'r') ADVANCE(229);
      if (lookahead == 's') ADVANCE(268);
      if (lookahead == 't') ADVANCE(223);
      if (lookahead == 'w') ADVANCE(233);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(272);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(270);
      if (lookahead == '[') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead == ']') ADVANCE(212);
      if (lookahead == 'a') ADVANCE(242);
      if (lookahead == 'b') ADVANCE(222);
      if (lookahead == 'c') ADVANCE(217);
      if (lookahead == 'e') ADVANCE(247);
      if (lookahead == 'f') ADVANCE(252);
      if (lookahead == 'i') ADVANCE(230);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(254);
      if (lookahead == 'r') ADVANCE(229);
      if (lookahead == 's') ADVANCE(268);
      if (lookahead == 't') ADVANCE(223);
      if (lookahead == 'w') ADVANCE(233);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(272);
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '-') ADVANCE(37);
      if (lookahead == '=') ADVANCE(176);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == ']') ADVANCE(167);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(181);
      END_STATE();
    case 16:
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '-') ADVANCE(37);
      if (lookahead == '=') ADVANCE(176);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(181);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(270);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(272);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '+') ADVANCE(98);
      if (lookahead == '-') ADVANCE(41);
      if (lookahead == '.') ADVANCE(30);
      if (lookahead == '[') ADVANCE(183);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(273);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(275);
      if (lookahead == ',') ADVANCE(185);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '}') ADVANCE(186);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(274);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(277);
      END_STATE();
    case 20:
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(188);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(189);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '-') ADVANCE(40);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead == ']') ADVANCE(167);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(21);
      END_STATE();
    case 22:
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '-') ADVANCE(40);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(21);
      END_STATE();
    case 23:
      if (lookahead == '#') ADVANCE(192);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(193);
      if (lookahead != 0) ADVANCE(194);
      END_STATE();
    case 24:
      if (lookahead == '(') ADVANCE(170);
      if (lookahead == ')') ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      END_STATE();
    case 25:
      if (lookahead == '(') ADVANCE(170);
      if (lookahead == 'U') ADVANCE(210);
      if (lookahead == 'X') ADVANCE(204);
      if (lookahead == 'c') ADVANCE(211);
      if (lookahead == 'u') ADVANCE(206);
      if (lookahead == 'x') ADVANCE(204);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(202);
      if (lookahead != 0) ADVANCE(195);
      END_STATE();
    case 26:
      if (lookahead == '(') ADVANCE(170);
      if (lookahead == 'U') ADVANCE(210);
      if (lookahead == 'X') ADVANCE(204);
      if (lookahead == 'c') ADVANCE(211);
      if (lookahead == 'u') ADVANCE(206);
      if (lookahead == 'x') ADVANCE(204);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(202);
      if (lookahead != 0) ADVANCE(195);
      END_STATE();
    case 27:
      if (lookahead == ')') ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      END_STATE();
    case 28:
      if (lookahead == ')') ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      END_STATE();
    case 29:
      if (lookahead == ')') ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      END_STATE();
    case 30:
      if (lookahead == '.') ADVANCE(182);
      END_STATE();
    case 31:
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '>') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(31);
      END_STATE();
    case 32:
      if (lookahead == '=') ADVANCE(177);
      END_STATE();
    case 33:
      if (lookahead == 'U') ADVANCE(210);
      if (lookahead == 'X') ADVANCE(204);
      if (lookahead == 'c') ADVANCE(211);
      if (lookahead == 'u') ADVANCE(206);
      if (lookahead == 'x') ADVANCE(204);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(202);
      if (lookahead != 0) ADVANCE(195);
      END_STATE();
    case 34:
      if (lookahead == 'U') ADVANCE(210);
      if (lookahead == 'X') ADVANCE(204);
      if (lookahead == 'c') ADVANCE(211);
      if (lookahead == 'u') ADVANCE(206);
      if (lookahead == 'x') ADVANCE(204);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(202);
      if (lookahead != 0) ADVANCE(195);
      END_STATE();
    case 35:
      if (lookahead == 'U') ADVANCE(210);
      if (lookahead == 'X') ADVANCE(204);
      if (lookahead == 'c') ADVANCE(211);
      if (lookahead == 'u') ADVANCE(206);
      if (lookahead == 'x') ADVANCE(204);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(202);
      if (lookahead != 0) ADVANCE(195);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(173);
      if (lookahead == 'o') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(136);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(178);
      END_STATE();
    case 37:
      if (lookahead == 'a') ADVANCE(173);
      if (lookahead == 'o') ADVANCE(175);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(178);
      END_STATE();
    case 38:
      if (lookahead == 'a') ADVANCE(80);
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 39:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 40:
      if (lookahead == 'a') ADVANCE(172);
      if (lookahead == 'o') ADVANCE(174);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(172);
      if (lookahead == 'o') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 42:
      if (lookahead == 'c') ADVANCE(57);
      END_STATE();
    case 43:
      if (lookahead == 'c') ADVANCE(87);
      END_STATE();
    case 44:
      if (lookahead == 'd') ADVANCE(101);
      END_STATE();
    case 45:
      if (lookahead == 'd') ADVANCE(133);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(47);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(161);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 52:
      if (lookahead == 'e') ADVANCE(82);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 54:
      if (lookahead == 'f') ADVANCE(159);
      END_STATE();
    case 55:
      if (lookahead == 'f') ADVANCE(159);
      if (lookahead == 'n') ADVANCE(156);
      END_STATE();
    case 56:
      if (lookahead == 'g') ADVANCE(61);
      END_STATE();
    case 57:
      if (lookahead == 'h') ADVANCE(146);
      END_STATE();
    case 58:
      if (lookahead == 'h') ADVANCE(59);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(86);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(72);
      END_STATE();
    case 64:
      if (lookahead == 'k') ADVANCE(150);
      END_STATE();
    case 65:
      if (lookahead == 'l') ADVANCE(50);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(81);
      if (lookahead == 'n') ADVANCE(45);
      END_STATE();
    case 67:
      if (lookahead == 'n') ADVANCE(44);
      END_STATE();
    case 68:
      if (lookahead == 'n') ADVANCE(43);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(163);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 71:
      if (lookahead == 'n') ADVANCE(131);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(90);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 74:
      if (lookahead == 'o') ADVANCE(83);
      END_STATE();
    case 75:
      if (lookahead == 'o') ADVANCE(78);
      if (lookahead == 'u') ADVANCE(68);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(71);
      END_STATE();
    case 77:
      if (lookahead == 'r') ADVANCE(103);
      END_STATE();
    case 78:
      if (lookahead == 'r') ADVANCE(154);
      END_STATE();
    case 79:
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 80:
      if (lookahead == 's') ADVANCE(48);
      END_STATE();
    case 81:
      if (lookahead == 's') ADVANCE(49);
      END_STATE();
    case 82:
      if (lookahead == 's') ADVANCE(85);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 84:
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 86:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 87:
      if (lookahead == 't') ADVANCE(60);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 89:
      if (lookahead == 'u') ADVANCE(79);
      END_STATE();
    case 90:
      if (lookahead == 'u') ADVANCE(51);
      END_STATE();
    case 91:
      if (lookahead == 'w') ADVANCE(62);
      END_STATE();
    case 92:
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '2')) ADVANCE(107);
      END_STATE();
    case 93:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      END_STATE();
    case 94:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 95:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      END_STATE();
    case 96:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(136);
      END_STATE();
    case 97:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(141);
      END_STATE();
    case 98:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 99:
      if (eof) ADVANCE(100);
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == '\r') ADVANCE(121);
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '$') ADVANCE(128);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(129);
      if (lookahead == ')') ADVANCE(130);
      if (lookahead == '*') ADVANCE(215);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(270);
      if (lookahead == ';') ADVANCE(115);
      if (lookahead == '[') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == ']') ADVANCE(212);
      if (lookahead == 'a') ADVANCE(242);
      if (lookahead == 'b') ADVANCE(222);
      if (lookahead == 'c') ADVANCE(251);
      if (lookahead == 'f') ADVANCE(252);
      if (lookahead == 'i') ADVANCE(230);
      if (lookahead == 'n') ADVANCE(250);
      if (lookahead == 'o') ADVANCE(254);
      if (lookahead == 'r') ADVANCE(229);
      if (lookahead == 's') ADVANCE(268);
      if (lookahead == 't') ADVANCE(223);
      if (lookahead == 'w') ADVANCE(233);
      if (lookahead == '{') ADVANCE(184);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(99)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(272);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_and);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_or);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_stream_redirect);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_direction);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '&') ADVANCE(92);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '&') ADVANCE(92);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '?') ADVANCE(108);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '&') ADVANCE(92);
      if (lookahead == '?') ADVANCE(108);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '?') ADVANCE(108);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '?') ADVANCE(108);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(105);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(106);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '>') ADVANCE(112);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == '\r') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(33);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(119);
      if (lookahead == '\r') ADVANCE(122);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(120);
      if (lookahead == '\r') ADVANCE(123);
      if (lookahead == '\\') ADVANCE(25);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == '\r') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(33);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(119);
      if (lookahead == '\r') ADVANCE(122);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(120);
      if (lookahead == '\r') ADVANCE(123);
      if (lookahead == '\\') ADVANCE(25);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_not);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_function);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_end);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(97);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '>') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(271);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '>') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(272);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(276);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(277);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(141);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(143);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(277);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_return);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_switch);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_case);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_break);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_continue);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_continue);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_for);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_while);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_if);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_else);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_begin);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_begin);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_test_command_token1);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_test_command_token2);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_test);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_test);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_BSLASH_LPAREN);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_BSLASH_RPAREN);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_DASHa);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_DASHa);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(178);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_DASHo);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_DASHo);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(178);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_test_option);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_test_option);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_variable_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym_double_quote_string_token1);
      if (lookahead == '\n') ADVANCE(190);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym_double_quote_string_token1);
      if (lookahead == '#') ADVANCE(188);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(189);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '\\') ADVANCE(190);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym_double_quote_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym_single_quote_string_token1);
      if (lookahead == '\n') ADVANCE(194);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_single_quote_string_token1);
      if (lookahead == '#') ADVANCE(192);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(193);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(194);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym_single_quote_string_token1);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == '\r') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(33);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(120);
      if (lookahead == '\r') ADVANCE(123);
      if (lookahead == '\\') ADVANCE(25);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(34);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(26);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(274);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(195);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(201);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(195);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(203);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(204);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(205);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(206);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(207);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(208);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(209);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(195);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym__special_character);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym__special_character);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(165);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_home_dir_expansion);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_glob);
      if (lookahead == '*') ADVANCE(215);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(239);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(259);
      if (lookahead == 'o') ADVANCE(249);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'c') ADVANCE(232);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'c') ADVANCE(264);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(102);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(134);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(231);
      if (lookahead == 'r') ADVANCE(224);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(257);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(216);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(158);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(153);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(162);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(149);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(261);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'f') ADVANCE(160);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'g') ADVANCE(235);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(147);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(234);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(241);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(244);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(263);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(248);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(253);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'k') ADVANCE(151);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(258);
      if (lookahead == 'n') ADVANCE(221);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(225);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(220);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(219);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(164);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(145);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(132);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(221);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(267);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(265);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(260);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(249);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(255);
      if (lookahead == 'u') ADVANCE(243);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(246);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(104);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(155);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(245);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(262);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(227);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(228);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(127);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(266);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(169);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(218);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(238);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(237);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'u') ADVANCE(256);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'u') ADVANCE(226);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'w') ADVANCE(236);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_word);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(272);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_brace_word);
      if (lookahead == '\n') ADVANCE(277);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(273);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_brace_word);
      if (lookahead == '#') ADVANCE(273);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(275);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(274);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '\'' || ',' < lookahead) &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(277);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_brace_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(277);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_brace_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(143);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(277);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_brace_word);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(277);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 99},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 1},
  [7] = {.lex_state = 2},
  [8] = {.lex_state = 2},
  [9] = {.lex_state = 2},
  [10] = {.lex_state = 2},
  [11] = {.lex_state = 2},
  [12] = {.lex_state = 2},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 99},
  [15] = {.lex_state = 99},
  [16] = {.lex_state = 99},
  [17] = {.lex_state = 99},
  [18] = {.lex_state = 99},
  [19] = {.lex_state = 99},
  [20] = {.lex_state = 99},
  [21] = {.lex_state = 99},
  [22] = {.lex_state = 99},
  [23] = {.lex_state = 99},
  [24] = {.lex_state = 99},
  [25] = {.lex_state = 99},
  [26] = {.lex_state = 99},
  [27] = {.lex_state = 99},
  [28] = {.lex_state = 99},
  [29] = {.lex_state = 99},
  [30] = {.lex_state = 99},
  [31] = {.lex_state = 99},
  [32] = {.lex_state = 99},
  [33] = {.lex_state = 99},
  [34] = {.lex_state = 99},
  [35] = {.lex_state = 99},
  [36] = {.lex_state = 99},
  [37] = {.lex_state = 99},
  [38] = {.lex_state = 99},
  [39] = {.lex_state = 99},
  [40] = {.lex_state = 99},
  [41] = {.lex_state = 99},
  [42] = {.lex_state = 99},
  [43] = {.lex_state = 99},
  [44] = {.lex_state = 99},
  [45] = {.lex_state = 99},
  [46] = {.lex_state = 99},
  [47] = {.lex_state = 99},
  [48] = {.lex_state = 99},
  [49] = {.lex_state = 99},
  [50] = {.lex_state = 99},
  [51] = {.lex_state = 99},
  [52] = {.lex_state = 99},
  [53] = {.lex_state = 99},
  [54] = {.lex_state = 99},
  [55] = {.lex_state = 99},
  [56] = {.lex_state = 99},
  [57] = {.lex_state = 99},
  [58] = {.lex_state = 99},
  [59] = {.lex_state = 99},
  [60] = {.lex_state = 99},
  [61] = {.lex_state = 99},
  [62] = {.lex_state = 99},
  [63] = {.lex_state = 99},
  [64] = {.lex_state = 99},
  [65] = {.lex_state = 99},
  [66] = {.lex_state = 99},
  [67] = {.lex_state = 99},
  [68] = {.lex_state = 99},
  [69] = {.lex_state = 99},
  [70] = {.lex_state = 99},
  [71] = {.lex_state = 99},
  [72] = {.lex_state = 99},
  [73] = {.lex_state = 99},
  [74] = {.lex_state = 99},
  [75] = {.lex_state = 14},
  [76] = {.lex_state = 14},
  [77] = {.lex_state = 14},
  [78] = {.lex_state = 12},
  [79] = {.lex_state = 12},
  [80] = {.lex_state = 12},
  [81] = {.lex_state = 12},
  [82] = {.lex_state = 12},
  [83] = {.lex_state = 12},
  [84] = {.lex_state = 12},
  [85] = {.lex_state = 12},
  [86] = {.lex_state = 12},
  [87] = {.lex_state = 12},
  [88] = {.lex_state = 12},
  [89] = {.lex_state = 12},
  [90] = {.lex_state = 12},
  [91] = {.lex_state = 12},
  [92] = {.lex_state = 12},
  [93] = {.lex_state = 12},
  [94] = {.lex_state = 12},
  [95] = {.lex_state = 12},
  [96] = {.lex_state = 12},
  [97] = {.lex_state = 12},
  [98] = {.lex_state = 12},
  [99] = {.lex_state = 12},
  [100] = {.lex_state = 12},
  [101] = {.lex_state = 13},
  [102] = {.lex_state = 13},
  [103] = {.lex_state = 13},
  [104] = {.lex_state = 13},
  [105] = {.lex_state = 13},
  [106] = {.lex_state = 13},
  [107] = {.lex_state = 13},
  [108] = {.lex_state = 8},
  [109] = {.lex_state = 1},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 3},
  [112] = {.lex_state = 99},
  [113] = {.lex_state = 3},
  [114] = {.lex_state = 99},
  [115] = {.lex_state = 3},
  [116] = {.lex_state = 2},
  [117] = {.lex_state = 2},
  [118] = {.lex_state = 3},
  [119] = {.lex_state = 10},
  [120] = {.lex_state = 11},
  [121] = {.lex_state = 11},
  [122] = {.lex_state = 11},
  [123] = {.lex_state = 11},
  [124] = {.lex_state = 11},
  [125] = {.lex_state = 11},
  [126] = {.lex_state = 14},
  [127] = {.lex_state = 12},
  [128] = {.lex_state = 4},
  [129] = {.lex_state = 4},
  [130] = {.lex_state = 4},
  [131] = {.lex_state = 4},
  [132] = {.lex_state = 4},
  [133] = {.lex_state = 4},
  [134] = {.lex_state = 4},
  [135] = {.lex_state = 3, .external_lex_state = 2},
  [136] = {.lex_state = 3, .external_lex_state = 2},
  [137] = {.lex_state = 3, .external_lex_state = 2},
  [138] = {.lex_state = 3, .external_lex_state = 2},
  [139] = {.lex_state = 3, .external_lex_state = 2},
  [140] = {.lex_state = 3, .external_lex_state = 2},
  [141] = {.lex_state = 3, .external_lex_state = 2},
  [142] = {.lex_state = 3, .external_lex_state = 2},
  [143] = {.lex_state = 3, .external_lex_state = 3},
  [144] = {.lex_state = 3, .external_lex_state = 3},
  [145] = {.lex_state = 3, .external_lex_state = 2},
  [146] = {.lex_state = 3, .external_lex_state = 3},
  [147] = {.lex_state = 3, .external_lex_state = 3},
  [148] = {.lex_state = 3, .external_lex_state = 2},
  [149] = {.lex_state = 3, .external_lex_state = 2},
  [150] = {.lex_state = 3, .external_lex_state = 3},
  [151] = {.lex_state = 3, .external_lex_state = 3},
  [152] = {.lex_state = 3, .external_lex_state = 3},
  [153] = {.lex_state = 3, .external_lex_state = 3},
  [154] = {.lex_state = 3, .external_lex_state = 3},
  [155] = {.lex_state = 3, .external_lex_state = 3},
  [156] = {.lex_state = 3, .external_lex_state = 3},
  [157] = {.lex_state = 3, .external_lex_state = 3},
  [158] = {.lex_state = 3, .external_lex_state = 3},
  [159] = {.lex_state = 3, .external_lex_state = 3},
  [160] = {.lex_state = 3, .external_lex_state = 3},
  [161] = {.lex_state = 3, .external_lex_state = 3},
  [162] = {.lex_state = 3, .external_lex_state = 3},
  [163] = {.lex_state = 3, .external_lex_state = 3},
  [164] = {.lex_state = 3, .external_lex_state = 3},
  [165] = {.lex_state = 19},
  [166] = {.lex_state = 19},
  [167] = {.lex_state = 19},
  [168] = {.lex_state = 19},
  [169] = {.lex_state = 19},
  [170] = {.lex_state = 19},
  [171] = {.lex_state = 3},
  [172] = {.lex_state = 19},
  [173] = {.lex_state = 19},
  [174] = {.lex_state = 19},
  [175] = {.lex_state = 19},
  [176] = {.lex_state = 19},
  [177] = {.lex_state = 17},
  [178] = {.lex_state = 19},
  [179] = {.lex_state = 19},
  [180] = {.lex_state = 19},
  [181] = {.lex_state = 19},
  [182] = {.lex_state = 17},
  [183] = {.lex_state = 19},
  [184] = {.lex_state = 19},
  [185] = {.lex_state = 17},
  [186] = {.lex_state = 17},
  [187] = {.lex_state = 17},
  [188] = {.lex_state = 17},
  [189] = {.lex_state = 17},
  [190] = {.lex_state = 17},
  [191] = {.lex_state = 17},
  [192] = {.lex_state = 4, .external_lex_state = 2},
  [193] = {.lex_state = 4, .external_lex_state = 2},
  [194] = {.lex_state = 4, .external_lex_state = 2},
  [195] = {.lex_state = 4, .external_lex_state = 2},
  [196] = {.lex_state = 4, .external_lex_state = 2},
  [197] = {.lex_state = 17},
  [198] = {.lex_state = 4, .external_lex_state = 2},
  [199] = {.lex_state = 17},
  [200] = {.lex_state = 17},
  [201] = {.lex_state = 4, .external_lex_state = 2},
  [202] = {.lex_state = 4, .external_lex_state = 2},
  [203] = {.lex_state = 17},
  [204] = {.lex_state = 17},
  [205] = {.lex_state = 17},
  [206] = {.lex_state = 4, .external_lex_state = 2},
  [207] = {.lex_state = 5, .external_lex_state = 2},
  [208] = {.lex_state = 5, .external_lex_state = 2},
  [209] = {.lex_state = 5, .external_lex_state = 2},
  [210] = {.lex_state = 4, .external_lex_state = 2},
  [211] = {.lex_state = 4, .external_lex_state = 3},
  [212] = {.lex_state = 4, .external_lex_state = 3},
  [213] = {.lex_state = 4, .external_lex_state = 2},
  [214] = {.lex_state = 5, .external_lex_state = 2},
  [215] = {.lex_state = 4, .external_lex_state = 3},
  [216] = {.lex_state = 4, .external_lex_state = 3},
  [217] = {.lex_state = 17},
  [218] = {.lex_state = 5, .external_lex_state = 2},
  [219] = {.lex_state = 4, .external_lex_state = 3},
  [220] = {.lex_state = 4, .external_lex_state = 3},
  [221] = {.lex_state = 5, .external_lex_state = 3},
  [222] = {.lex_state = 4, .external_lex_state = 3},
  [223] = {.lex_state = 5, .external_lex_state = 3},
  [224] = {.lex_state = 4, .external_lex_state = 3},
  [225] = {.lex_state = 4, .external_lex_state = 3},
  [226] = {.lex_state = 5, .external_lex_state = 2},
  [227] = {.lex_state = 4, .external_lex_state = 3},
  [228] = {.lex_state = 4, .external_lex_state = 3},
  [229] = {.lex_state = 5, .external_lex_state = 3},
  [230] = {.lex_state = 19},
  [231] = {.lex_state = 4, .external_lex_state = 3},
  [232] = {.lex_state = 4, .external_lex_state = 3},
  [233] = {.lex_state = 4, .external_lex_state = 3},
  [234] = {.lex_state = 4, .external_lex_state = 3},
  [235] = {.lex_state = 5, .external_lex_state = 2},
  [236] = {.lex_state = 5, .external_lex_state = 3},
  [237] = {.lex_state = 5, .external_lex_state = 2},
  [238] = {.lex_state = 4, .external_lex_state = 3},
  [239] = {.lex_state = 4, .external_lex_state = 3},
  [240] = {.lex_state = 4, .external_lex_state = 3},
  [241] = {.lex_state = 4, .external_lex_state = 3},
  [242] = {.lex_state = 5, .external_lex_state = 2},
  [243] = {.lex_state = 5, .external_lex_state = 2},
  [244] = {.lex_state = 5, .external_lex_state = 2},
  [245] = {.lex_state = 5, .external_lex_state = 3},
  [246] = {.lex_state = 5, .external_lex_state = 3},
  [247] = {.lex_state = 5, .external_lex_state = 3},
  [248] = {.lex_state = 5, .external_lex_state = 3},
  [249] = {.lex_state = 5, .external_lex_state = 3},
  [250] = {.lex_state = 5, .external_lex_state = 3},
  [251] = {.lex_state = 4},
  [252] = {.lex_state = 5, .external_lex_state = 3},
  [253] = {.lex_state = 5, .external_lex_state = 3},
  [254] = {.lex_state = 5, .external_lex_state = 3},
  [255] = {.lex_state = 5, .external_lex_state = 3},
  [256] = {.lex_state = 4},
  [257] = {.lex_state = 5, .external_lex_state = 3},
  [258] = {.lex_state = 5, .external_lex_state = 3},
  [259] = {.lex_state = 5, .external_lex_state = 3},
  [260] = {.lex_state = 5, .external_lex_state = 3},
  [261] = {.lex_state = 5, .external_lex_state = 3},
  [262] = {.lex_state = 18},
  [263] = {.lex_state = 18},
  [264] = {.lex_state = 6, .external_lex_state = 2},
  [265] = {.lex_state = 18},
  [266] = {.lex_state = 6, .external_lex_state = 2},
  [267] = {.lex_state = 18},
  [268] = {.lex_state = 18},
  [269] = {.lex_state = 18},
  [270] = {.lex_state = 6, .external_lex_state = 2},
  [271] = {.lex_state = 18},
  [272] = {.lex_state = 18},
  [273] = {.lex_state = 18},
  [274] = {.lex_state = 18},
  [275] = {.lex_state = 18},
  [276] = {.lex_state = 18},
  [277] = {.lex_state = 18},
  [278] = {.lex_state = 18},
  [279] = {.lex_state = 18},
  [280] = {.lex_state = 18},
  [281] = {.lex_state = 18},
  [282] = {.lex_state = 18},
  [283] = {.lex_state = 5},
  [284] = {.lex_state = 6, .external_lex_state = 2},
  [285] = {.lex_state = 18},
  [286] = {.lex_state = 18},
  [287] = {.lex_state = 6, .external_lex_state = 2},
  [288] = {.lex_state = 18},
  [289] = {.lex_state = 6, .external_lex_state = 2},
  [290] = {.lex_state = 6, .external_lex_state = 3},
  [291] = {.lex_state = 6, .external_lex_state = 3},
  [292] = {.lex_state = 6, .external_lex_state = 3},
  [293] = {.lex_state = 6, .external_lex_state = 2},
  [294] = {.lex_state = 6, .external_lex_state = 2},
  [295] = {.lex_state = 6, .external_lex_state = 2},
  [296] = {.lex_state = 6, .external_lex_state = 2},
  [297] = {.lex_state = 6, .external_lex_state = 3},
  [298] = {.lex_state = 6, .external_lex_state = 2},
  [299] = {.lex_state = 6, .external_lex_state = 3},
  [300] = {.lex_state = 6, .external_lex_state = 3},
  [301] = {.lex_state = 18},
  [302] = {.lex_state = 6, .external_lex_state = 3},
  [303] = {.lex_state = 6, .external_lex_state = 3},
  [304] = {.lex_state = 6, .external_lex_state = 3},
  [305] = {.lex_state = 18},
  [306] = {.lex_state = 6, .external_lex_state = 3},
  [307] = {.lex_state = 6, .external_lex_state = 3},
  [308] = {.lex_state = 6, .external_lex_state = 3},
  [309] = {.lex_state = 6, .external_lex_state = 3},
  [310] = {.lex_state = 6, .external_lex_state = 3},
  [311] = {.lex_state = 6, .external_lex_state = 3},
  [312] = {.lex_state = 6, .external_lex_state = 3},
  [313] = {.lex_state = 6, .external_lex_state = 3},
  [314] = {.lex_state = 6, .external_lex_state = 3},
  [315] = {.lex_state = 6, .external_lex_state = 3},
  [316] = {.lex_state = 6},
  [317] = {.lex_state = 6},
  [318] = {.lex_state = 6},
  [319] = {.lex_state = 6},
  [320] = {.lex_state = 6},
  [321] = {.lex_state = 6},
  [322] = {.lex_state = 5},
  [323] = {.lex_state = 5},
  [324] = {.lex_state = 5},
  [325] = {.lex_state = 5},
  [326] = {.lex_state = 5},
  [327] = {.lex_state = 5},
  [328] = {.lex_state = 5},
  [329] = {.lex_state = 5},
  [330] = {.lex_state = 5},
  [331] = {.lex_state = 5},
  [332] = {.lex_state = 5},
  [333] = {.lex_state = 5},
  [334] = {.lex_state = 5},
  [335] = {.lex_state = 5},
  [336] = {.lex_state = 5},
  [337] = {.lex_state = 5},
  [338] = {.lex_state = 5},
  [339] = {.lex_state = 5},
  [340] = {.lex_state = 5},
  [341] = {.lex_state = 5},
  [342] = {.lex_state = 5},
  [343] = {.lex_state = 5},
  [344] = {.lex_state = 5},
  [345] = {.lex_state = 5},
  [346] = {.lex_state = 5},
  [347] = {.lex_state = 5},
  [348] = {.lex_state = 5},
  [349] = {.lex_state = 5},
  [350] = {.lex_state = 5},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 5},
  [353] = {.lex_state = 5},
  [354] = {.lex_state = 5},
  [355] = {.lex_state = 5},
  [356] = {.lex_state = 5},
  [357] = {.lex_state = 5},
  [358] = {.lex_state = 5},
  [359] = {.lex_state = 5},
  [360] = {.lex_state = 5},
  [361] = {.lex_state = 5},
  [362] = {.lex_state = 5},
  [363] = {.lex_state = 5},
  [364] = {.lex_state = 5},
  [365] = {.lex_state = 5},
  [366] = {.lex_state = 5},
  [367] = {.lex_state = 5},
  [368] = {.lex_state = 5},
  [369] = {.lex_state = 5},
  [370] = {.lex_state = 5},
  [371] = {.lex_state = 5},
  [372] = {.lex_state = 5},
  [373] = {.lex_state = 5},
  [374] = {.lex_state = 5},
  [375] = {.lex_state = 5},
  [376] = {.lex_state = 5},
  [377] = {.lex_state = 5},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 5},
  [381] = {.lex_state = 5},
  [382] = {.lex_state = 5},
  [383] = {.lex_state = 5},
  [384] = {.lex_state = 5},
  [385] = {.lex_state = 5},
  [386] = {.lex_state = 5},
  [387] = {.lex_state = 5},
  [388] = {.lex_state = 5},
  [389] = {.lex_state = 5},
  [390] = {.lex_state = 5},
  [391] = {.lex_state = 5},
  [392] = {.lex_state = 5},
  [393] = {.lex_state = 5},
  [394] = {.lex_state = 5},
  [395] = {.lex_state = 5},
  [396] = {.lex_state = 5},
  [397] = {.lex_state = 5},
  [398] = {.lex_state = 5},
  [399] = {.lex_state = 5},
  [400] = {.lex_state = 5},
  [401] = {.lex_state = 5},
  [402] = {.lex_state = 5},
  [403] = {.lex_state = 5},
  [404] = {.lex_state = 5},
  [405] = {.lex_state = 5},
  [406] = {.lex_state = 5},
  [407] = {.lex_state = 5},
  [408] = {.lex_state = 5},
  [409] = {.lex_state = 5},
  [410] = {.lex_state = 5},
  [411] = {.lex_state = 5},
  [412] = {.lex_state = 5},
  [413] = {.lex_state = 5},
  [414] = {.lex_state = 5},
  [415] = {.lex_state = 5},
  [416] = {.lex_state = 5},
  [417] = {.lex_state = 5},
  [418] = {.lex_state = 5},
  [419] = {.lex_state = 5},
  [420] = {.lex_state = 5},
  [421] = {.lex_state = 5},
  [422] = {.lex_state = 5},
  [423] = {.lex_state = 5},
  [424] = {.lex_state = 5},
  [425] = {.lex_state = 5},
  [426] = {.lex_state = 5},
  [427] = {.lex_state = 5},
  [428] = {.lex_state = 5},
  [429] = {.lex_state = 16, .external_lex_state = 2},
  [430] = {.lex_state = 16, .external_lex_state = 2},
  [431] = {.lex_state = 16, .external_lex_state = 2},
  [432] = {.lex_state = 16, .external_lex_state = 2},
  [433] = {.lex_state = 16, .external_lex_state = 2},
  [434] = {.lex_state = 16, .external_lex_state = 2},
  [435] = {.lex_state = 18, .external_lex_state = 4},
  [436] = {.lex_state = 16, .external_lex_state = 2},
  [437] = {.lex_state = 16, .external_lex_state = 3},
  [438] = {.lex_state = 16, .external_lex_state = 2},
  [439] = {.lex_state = 16, .external_lex_state = 3},
  [440] = {.lex_state = 16, .external_lex_state = 3},
  [441] = {.lex_state = 16, .external_lex_state = 2},
  [442] = {.lex_state = 16, .external_lex_state = 3},
  [443] = {.lex_state = 18, .external_lex_state = 4},
  [444] = {.lex_state = 18, .external_lex_state = 4},
  [445] = {.lex_state = 16, .external_lex_state = 2},
  [446] = {.lex_state = 18, .external_lex_state = 4},
  [447] = {.lex_state = 18, .external_lex_state = 4},
  [448] = {.lex_state = 16, .external_lex_state = 2},
  [449] = {.lex_state = 7, .external_lex_state = 2},
  [450] = {.lex_state = 7, .external_lex_state = 2},
  [451] = {.lex_state = 18, .external_lex_state = 4},
  [452] = {.lex_state = 16, .external_lex_state = 3},
  [453] = {.lex_state = 16, .external_lex_state = 3},
  [454] = {.lex_state = 18, .external_lex_state = 4},
  [455] = {.lex_state = 16, .external_lex_state = 3},
  [456] = {.lex_state = 18, .external_lex_state = 4},
  [457] = {.lex_state = 18, .external_lex_state = 4},
  [458] = {.lex_state = 16, .external_lex_state = 3},
  [459] = {.lex_state = 18, .external_lex_state = 4},
  [460] = {.lex_state = 18, .external_lex_state = 4},
  [461] = {.lex_state = 16, .external_lex_state = 3},
  [462] = {.lex_state = 7, .external_lex_state = 2},
  [463] = {.lex_state = 16, .external_lex_state = 3},
  [464] = {.lex_state = 16, .external_lex_state = 3},
  [465] = {.lex_state = 7, .external_lex_state = 2},
  [466] = {.lex_state = 7, .external_lex_state = 2},
  [467] = {.lex_state = 16, .external_lex_state = 3},
  [468] = {.lex_state = 16, .external_lex_state = 3},
  [469] = {.lex_state = 16, .external_lex_state = 3},
  [470] = {.lex_state = 16, .external_lex_state = 3},
  [471] = {.lex_state = 16, .external_lex_state = 3},
  [472] = {.lex_state = 16, .external_lex_state = 3},
  [473] = {.lex_state = 16, .external_lex_state = 3},
  [474] = {.lex_state = 16, .external_lex_state = 3},
  [475] = {.lex_state = 20},
  [476] = {.lex_state = 22, .external_lex_state = 2},
  [477] = {.lex_state = 20},
  [478] = {.lex_state = 22, .external_lex_state = 2},
  [479] = {.lex_state = 20},
  [480] = {.lex_state = 18},
  [481] = {.lex_state = 18},
  [482] = {.lex_state = 18},
  [483] = {.lex_state = 18},
  [484] = {.lex_state = 7, .external_lex_state = 3},
  [485] = {.lex_state = 16},
  [486] = {.lex_state = 20},
  [487] = {.lex_state = 20},
  [488] = {.lex_state = 7, .external_lex_state = 3},
  [489] = {.lex_state = 22, .external_lex_state = 2},
  [490] = {.lex_state = 20},
  [491] = {.lex_state = 18},
  [492] = {.lex_state = 20},
  [493] = {.lex_state = 22, .external_lex_state = 2},
  [494] = {.lex_state = 18},
  [495] = {.lex_state = 20},
  [496] = {.lex_state = 20},
  [497] = {.lex_state = 18},
  [498] = {.lex_state = 18},
  [499] = {.lex_state = 18},
  [500] = {.lex_state = 18},
  [501] = {.lex_state = 20},
  [502] = {.lex_state = 20},
  [503] = {.lex_state = 20},
  [504] = {.lex_state = 20},
  [505] = {.lex_state = 20},
  [506] = {.lex_state = 7, .external_lex_state = 3},
  [507] = {.lex_state = 20},
  [508] = {.lex_state = 7, .external_lex_state = 3},
  [509] = {.lex_state = 7, .external_lex_state = 2},
  [510] = {.lex_state = 7, .external_lex_state = 2},
  [511] = {.lex_state = 20},
  [512] = {.lex_state = 20},
  [513] = {.lex_state = 7, .external_lex_state = 2},
  [514] = {.lex_state = 18},
  [515] = {.lex_state = 18},
  [516] = {.lex_state = 18},
  [517] = {.lex_state = 18},
  [518] = {.lex_state = 7, .external_lex_state = 2},
  [519] = {.lex_state = 22, .external_lex_state = 2},
  [520] = {.lex_state = 18},
  [521] = {.lex_state = 7, .external_lex_state = 2},
  [522] = {.lex_state = 20},
  [523] = {.lex_state = 7, .external_lex_state = 2},
  [524] = {.lex_state = 20},
  [525] = {.lex_state = 7, .external_lex_state = 3},
  [526] = {.lex_state = 22, .external_lex_state = 2},
  [527] = {.lex_state = 22, .external_lex_state = 2},
  [528] = {.lex_state = 22, .external_lex_state = 2},
  [529] = {.lex_state = 7, .external_lex_state = 3},
  [530] = {.lex_state = 7, .external_lex_state = 3},
  [531] = {.lex_state = 7, .external_lex_state = 3},
  [532] = {.lex_state = 22, .external_lex_state = 3},
  [533] = {.lex_state = 7, .external_lex_state = 3},
  [534] = {.lex_state = 7, .external_lex_state = 3},
  [535] = {.lex_state = 7, .external_lex_state = 3},
  [536] = {.lex_state = 7, .external_lex_state = 3},
  [537] = {.lex_state = 7, .external_lex_state = 3},
  [538] = {.lex_state = 22, .external_lex_state = 3},
  [539] = {.lex_state = 7, .external_lex_state = 3},
  [540] = {.lex_state = 20, .external_lex_state = 4},
  [541] = {.lex_state = 20, .external_lex_state = 4},
  [542] = {.lex_state = 7, .external_lex_state = 3},
  [543] = {.lex_state = 22, .external_lex_state = 3},
  [544] = {.lex_state = 20, .external_lex_state = 4},
  [545] = {.lex_state = 7, .external_lex_state = 3},
  [546] = {.lex_state = 7, .external_lex_state = 3},
  [547] = {.lex_state = 20, .external_lex_state = 4},
  [548] = {.lex_state = 22, .external_lex_state = 3},
  [549] = {.lex_state = 22, .external_lex_state = 2},
  [550] = {.lex_state = 20, .external_lex_state = 4},
  [551] = {.lex_state = 7, .external_lex_state = 3},
  [552] = {.lex_state = 7},
  [553] = {.lex_state = 22, .external_lex_state = 2},
  [554] = {.lex_state = 22, .external_lex_state = 2},
  [555] = {.lex_state = 7, .external_lex_state = 3},
  [556] = {.lex_state = 0, .external_lex_state = 5},
  [557] = {.lex_state = 20, .external_lex_state = 4},
  [558] = {.lex_state = 16},
  [559] = {.lex_state = 22, .external_lex_state = 3},
  [560] = {.lex_state = 16},
  [561] = {.lex_state = 20, .external_lex_state = 4},
  [562] = {.lex_state = 16},
  [563] = {.lex_state = 16},
  [564] = {.lex_state = 22, .external_lex_state = 3},
  [565] = {.lex_state = 16},
  [566] = {.lex_state = 22, .external_lex_state = 3},
  [567] = {.lex_state = 16},
  [568] = {.lex_state = 16},
  [569] = {.lex_state = 16},
  [570] = {.lex_state = 20, .external_lex_state = 4},
  [571] = {.lex_state = 16},
  [572] = {.lex_state = 22, .external_lex_state = 3},
  [573] = {.lex_state = 22, .external_lex_state = 3},
  [574] = {.lex_state = 22, .external_lex_state = 3},
  [575] = {.lex_state = 22, .external_lex_state = 3},
  [576] = {.lex_state = 16},
  [577] = {.lex_state = 22, .external_lex_state = 3},
  [578] = {.lex_state = 22, .external_lex_state = 3},
  [579] = {.lex_state = 16},
  [580] = {.lex_state = 22, .external_lex_state = 3},
  [581] = {.lex_state = 16},
  [582] = {.lex_state = 0, .external_lex_state = 5},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0, .external_lex_state = 5},
  [585] = {.lex_state = 22, .external_lex_state = 3},
  [586] = {.lex_state = 16},
  [587] = {.lex_state = 22, .external_lex_state = 3},
  [588] = {.lex_state = 16},
  [589] = {.lex_state = 16},
  [590] = {.lex_state = 22, .external_lex_state = 3},
  [591] = {.lex_state = 0, .external_lex_state = 5},
  [592] = {.lex_state = 22, .external_lex_state = 3},
  [593] = {.lex_state = 16},
  [594] = {.lex_state = 20, .external_lex_state = 4},
  [595] = {.lex_state = 16},
  [596] = {.lex_state = 20, .external_lex_state = 4},
  [597] = {.lex_state = 16},
  [598] = {.lex_state = 16},
  [599] = {.lex_state = 22, .external_lex_state = 3},
  [600] = {.lex_state = 20, .external_lex_state = 4},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0, .external_lex_state = 5},
  [603] = {.lex_state = 16},
  [604] = {.lex_state = 7},
  [605] = {.lex_state = 20},
  [606] = {.lex_state = 23},
  [607] = {.lex_state = 23},
  [608] = {.lex_state = 23},
  [609] = {.lex_state = 0, .external_lex_state = 6},
  [610] = {.lex_state = 23},
  [611] = {.lex_state = 23},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 22},
  [614] = {.lex_state = 22},
  [615] = {.lex_state = 23},
  [616] = {.lex_state = 23},
  [617] = {.lex_state = 23},
  [618] = {.lex_state = 0, .external_lex_state = 6},
  [619] = {.lex_state = 0, .external_lex_state = 5},
  [620] = {.lex_state = 0, .external_lex_state = 5},
  [621] = {.lex_state = 23},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 0, .external_lex_state = 5},
  [624] = {.lex_state = 0, .external_lex_state = 5},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 22},
  [627] = {.lex_state = 22},
  [628] = {.lex_state = 22},
  [629] = {.lex_state = 23},
  [630] = {.lex_state = 23},
  [631] = {.lex_state = 23},
  [632] = {.lex_state = 0, .external_lex_state = 6},
  [633] = {.lex_state = 0, .external_lex_state = 5},
  [634] = {.lex_state = 23},
  [635] = {.lex_state = 23},
  [636] = {.lex_state = 0, .external_lex_state = 5},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 23},
  [639] = {.lex_state = 23},
  [640] = {.lex_state = 23},
  [641] = {.lex_state = 23},
  [642] = {.lex_state = 20},
  [643] = {.lex_state = 23},
  [644] = {.lex_state = 20},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0, .external_lex_state = 6},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0, .external_lex_state = 6},
  [650] = {.lex_state = 0, .external_lex_state = 6},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0, .external_lex_state = 6},
  [653] = {.lex_state = 0, .external_lex_state = 6},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0, .external_lex_state = 6},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0, .external_lex_state = 6},
  [661] = {.lex_state = 0, .external_lex_state = 6},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0, .external_lex_state = 6},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0, .external_lex_state = 6},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 22},
  [669] = {.lex_state = 0, .external_lex_state = 6},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0, .external_lex_state = 6},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0, .external_lex_state = 6},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0, .external_lex_state = 6},
  [679] = {.lex_state = 0, .external_lex_state = 6},
  [680] = {.lex_state = 0, .external_lex_state = 6},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0, .external_lex_state = 6},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0, .external_lex_state = 6},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0, .external_lex_state = 6},
  [687] = {.lex_state = 0, .external_lex_state = 6},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0, .external_lex_state = 6},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 18},
  [695] = {.lex_state = 0, .external_lex_state = 6},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 18},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0, .external_lex_state = 6},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 18},
  [711] = {.lex_state = 18},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 18},
  [715] = {.lex_state = 18},
  [716] = {.lex_state = 18},
  [717] = {.lex_state = 18},
  [718] = {.lex_state = 18},
  [719] = {.lex_state = 18},
  [720] = {.lex_state = 18},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 18},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 16},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 0},
};

enum {
  ts_external_token__concat = 0,
  ts_external_token__brace_concat = 1,
  ts_external_token__concat_list = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__concat] = sym__concat,
  [ts_external_token__brace_concat] = sym__brace_concat,
  [ts_external_token__concat_list] = sym__concat_list,
};

static const bool ts_external_scanner_states[7][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__concat] = true,
    [ts_external_token__brace_concat] = true,
    [ts_external_token__concat_list] = true,
  },
  [2] = {
    [ts_external_token__concat] = true,
    [ts_external_token__concat_list] = true,
  },
  [3] = {
    [ts_external_token__concat] = true,
  },
  [4] = {
    [ts_external_token__concat_list] = true,
  },
  [5] = {
    [ts_external_token__brace_concat] = true,
    [ts_external_token__concat_list] = true,
  },
  [6] = {
    [ts_external_token__brace_concat] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [sym_stream_redirect] = ACTIONS(1),
    [sym_direction] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_continue] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_begin] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [aux_sym_test_command_token2] = ACTIONS(1),
    [anon_sym_test] = ACTIONS(1),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(1),
    [anon_sym_BSLASH_RPAREN] = ACTIONS(1),
    [anon_sym_DASHa] = ACTIONS(1),
    [anon_sym_DASHo] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [sym_test_option] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym__special_character] = ACTIONS(1),
    [sym_home_dir_expansion] = ACTIONS(1),
    [sym_glob] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [sym__brace_concat] = ACTIONS(1),
    [sym__concat_list] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(723),
    [sym_conditional_execution] = STATE(407),
    [sym_redirected_statement] = STATE(407),
    [sym_pipe] = STATE(407),
    [sym_negated_statement] = STATE(407),
    [sym_command_substitution_dollar] = STATE(154),
    [sym_command_substitution_fish] = STATE(154),
    [sym_command_substitution] = STATE(143),
    [sym_function_definition] = STATE(407),
    [sym_return] = STATE(407),
    [sym_switch_statement] = STATE(407),
    [sym_for_statement] = STATE(407),
    [sym_while_statement] = STATE(407),
    [sym_if_statement] = STATE(407),
    [sym_begin_statement] = STATE(407),
    [sym_test_command] = STATE(407),
    [sym_variable_expansion] = STATE(143),
    [sym_brace_expansion] = STATE(143),
    [sym_double_quote_string] = STATE(143),
    [sym_single_quote_string] = STATE(143),
    [sym_command] = STATE(407),
    [sym_concatenation] = STATE(115),
    [sym__expression] = STATE(115),
    [aux_sym_program_repeat1] = STATE(28),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_LF] = ACTIONS(9),
    [anon_sym_CR] = ACTIONS(9),
    [anon_sym_CR_LF] = ACTIONS(9),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(25),
    [sym_continue] = ACTIONS(25),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [2] = {
    [sym_conditional_execution] = STATE(406),
    [sym_redirected_statement] = STATE(406),
    [sym_pipe] = STATE(406),
    [sym__terminated_opt_statement] = STATE(6),
    [sym_negated_statement] = STATE(406),
    [sym_command_substitution_dollar] = STATE(154),
    [sym_command_substitution_fish] = STATE(154),
    [sym_command_substitution] = STATE(143),
    [sym_function_definition] = STATE(406),
    [sym_return] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_else_if_clause] = STATE(583),
    [sym_else_clause] = STATE(724),
    [sym_begin_statement] = STATE(406),
    [sym_test_command] = STATE(406),
    [sym_variable_expansion] = STATE(143),
    [sym_brace_expansion] = STATE(143),
    [sym_double_quote_string] = STATE(143),
    [sym_single_quote_string] = STATE(143),
    [sym_command] = STATE(406),
    [sym_concatenation] = STATE(115),
    [sym__expression] = STATE(115),
    [aux_sym_while_statement_repeat1] = STATE(6),
    [aux_sym_if_statement_repeat1] = STATE(583),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_LF] = ACTIONS(49),
    [anon_sym_CR] = ACTIONS(49),
    [anon_sym_CR_LF] = ACTIONS(49),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_end] = ACTIONS(51),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_else] = ACTIONS(55),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [3] = {
    [sym_conditional_execution] = STATE(406),
    [sym_redirected_statement] = STATE(406),
    [sym_pipe] = STATE(406),
    [sym__terminated_opt_statement] = STATE(2),
    [sym_negated_statement] = STATE(406),
    [sym_command_substitution_dollar] = STATE(154),
    [sym_command_substitution_fish] = STATE(154),
    [sym_command_substitution] = STATE(143),
    [sym_function_definition] = STATE(406),
    [sym_return] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_else_if_clause] = STATE(601),
    [sym_else_clause] = STATE(728),
    [sym_begin_statement] = STATE(406),
    [sym_test_command] = STATE(406),
    [sym_variable_expansion] = STATE(143),
    [sym_brace_expansion] = STATE(143),
    [sym_double_quote_string] = STATE(143),
    [sym_single_quote_string] = STATE(143),
    [sym_command] = STATE(406),
    [sym_concatenation] = STATE(115),
    [sym__expression] = STATE(115),
    [aux_sym_while_statement_repeat1] = STATE(2),
    [aux_sym_if_statement_repeat1] = STATE(601),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(57),
    [anon_sym_CR] = ACTIONS(57),
    [anon_sym_CR_LF] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_end] = ACTIONS(59),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_else] = ACTIONS(55),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(53), 2,
      sym_break,
      sym_continue,
    ACTIONS(63), 2,
      anon_sym_end,
      anon_sym_else,
    STATE(5), 2,
      sym__terminated_opt_statement,
      aux_sym_while_statement_repeat1,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(61), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(406), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [114] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(53), 2,
      sym_break,
      sym_continue,
    ACTIONS(65), 2,
      anon_sym_end,
      anon_sym_else,
    STATE(6), 2,
      sym__terminated_opt_statement,
      aux_sym_while_statement_repeat1,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(49), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(406), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [228] = 27,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(76), 1,
      anon_sym_DOLLAR,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(82), 1,
      anon_sym_function,
    ACTIONS(90), 1,
      anon_sym_return,
    ACTIONS(93), 1,
      anon_sym_switch,
    ACTIONS(99), 1,
      anon_sym_for,
    ACTIONS(102), 1,
      anon_sym_while,
    ACTIONS(105), 1,
      anon_sym_if,
    ACTIONS(108), 1,
      anon_sym_begin,
    ACTIONS(111), 1,
      aux_sym_test_command_token1,
    ACTIONS(114), 1,
      anon_sym_test,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(120), 1,
      anon_sym_DQUOTE,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(126), 1,
      sym__special_character,
    ACTIONS(67), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(73), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(85), 2,
      anon_sym_end,
      anon_sym_else,
    ACTIONS(96), 2,
      sym_break,
      sym_continue,
    STATE(6), 2,
      sym__terminated_opt_statement,
      aux_sym_while_statement_repeat1,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(70), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(87), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(406), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [342] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(131), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(133), 2,
      sym_break,
      sym_continue,
    STATE(12), 2,
      sym__terminated_opt_statement,
      aux_sym_while_statement_repeat1,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(129), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(393), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [455] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(137), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(133), 2,
      sym_break,
      sym_continue,
    STATE(9), 2,
      sym__terminated_opt_statement,
      aux_sym_while_statement_repeat1,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(135), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(393), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [568] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(141), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(133), 2,
      sym_break,
      sym_continue,
    STATE(10), 2,
      sym__terminated_opt_statement,
      aux_sym_while_statement_repeat1,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(139), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(393), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [681] = 27,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(76), 1,
      anon_sym_DOLLAR,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(82), 1,
      anon_sym_function,
    ACTIONS(85), 1,
      anon_sym_end,
    ACTIONS(90), 1,
      anon_sym_return,
    ACTIONS(93), 1,
      anon_sym_switch,
    ACTIONS(99), 1,
      anon_sym_for,
    ACTIONS(102), 1,
      anon_sym_while,
    ACTIONS(105), 1,
      anon_sym_if,
    ACTIONS(108), 1,
      anon_sym_begin,
    ACTIONS(111), 1,
      aux_sym_test_command_token1,
    ACTIONS(114), 1,
      anon_sym_test,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(120), 1,
      anon_sym_DQUOTE,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(126), 1,
      sym__special_character,
    ACTIONS(67), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(73), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(146), 2,
      sym_break,
      sym_continue,
    STATE(10), 2,
      sym__terminated_opt_statement,
      aux_sym_while_statement_repeat1,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(143), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(87), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(393), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [794] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(149), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(133), 2,
      sym_break,
      sym_continue,
    STATE(10), 2,
      sym__terminated_opt_statement,
      aux_sym_while_statement_repeat1,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(139), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(393), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [907] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(151), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(133), 2,
      sym_break,
      sym_continue,
    STATE(10), 2,
      sym__terminated_opt_statement,
      aux_sym_while_statement_repeat1,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(139), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(393), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1020] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(155), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(133), 2,
      sym_break,
      sym_continue,
    STATE(11), 2,
      sym__terminated_opt_statement,
      aux_sym_while_statement_repeat1,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(153), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(393), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1133] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(161), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(372), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1245] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(165), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(373), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1357] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(169), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(171), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(167), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(326), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1469] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(173), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(175), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(355), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1581] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(179), 1,
      anon_sym_RPAREN,
    STATE(19), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(181), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(177), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(328), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1693] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(183), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(185), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(325), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1805] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(189), 1,
      anon_sym_RPAREN,
    STATE(32), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(191), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(187), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(331), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1917] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(195), 1,
      anon_sym_RPAREN,
    STATE(23), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(197), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(193), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(342), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2029] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(201), 1,
      anon_sym_RPAREN,
    STATE(24), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(203), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(199), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(353), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2141] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(205), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(207), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(359), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2253] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(209), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(211), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(362), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2365] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(215), 1,
      anon_sym_RPAREN,
    STATE(29), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(217), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(213), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(376), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2477] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(221), 1,
      anon_sym_RPAREN,
    STATE(30), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(223), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(219), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(379), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2589] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(227), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(229), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(225), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(330), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2701] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(231), 1,
      ts_builtin_sym_end,
    STATE(74), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(25), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(233), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(407), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2813] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(235), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(237), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(380), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2925] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(239), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(241), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(382), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3037] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(245), 1,
      anon_sym_RPAREN,
    STATE(70), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(247), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(243), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(347), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3149] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(249), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(251), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(348), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3261] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(255), 1,
      anon_sym_RPAREN,
    STATE(15), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(257), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(253), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(378), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3373] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(259), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(261), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(356), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3485] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(265), 1,
      anon_sym_RPAREN,
    STATE(43), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(267), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(263), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(358), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3597] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(271), 1,
      anon_sym_RPAREN,
    STATE(14), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(273), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(269), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(375), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3709] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(277), 1,
      anon_sym_RPAREN,
    STATE(73), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(279), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(275), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(332), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3821] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(281), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(283), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(327), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3933] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(287), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(289), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(285), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(367), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4045] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(293), 1,
      anon_sym_RPAREN,
    STATE(34), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(295), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(291), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(381), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4157] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(299), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(301), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(297), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(364), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4269] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(303), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(305), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(361), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4381] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(307), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(309), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(369), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4493] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(311), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(313), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(365), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4605] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(315), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(317), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(360), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4717] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(321), 1,
      anon_sym_RPAREN,
    STATE(48), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(323), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(319), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(357), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4829] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(327), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(329), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(325), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(354), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4941] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(331), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(333), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(351), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5053] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(337), 1,
      anon_sym_RPAREN,
    STATE(51), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(339), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(335), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(371), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5165] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(341), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(343), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(350), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5277] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(345), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(347), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(322), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5389] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(351), 1,
      anon_sym_RPAREN,
    STATE(54), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(353), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(349), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(344), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5501] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(357), 1,
      anon_sym_RPAREN,
    STATE(55), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(359), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(355), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(343), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5613] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(361), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(363), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5725] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(365), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(367), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(338), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5837] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(371), 1,
      anon_sym_RPAREN,
    STATE(58), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(373), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(369), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(329), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5949] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(377), 1,
      anon_sym_RPAREN,
    STATE(59), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(379), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(375), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(370), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6061] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(381), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(383), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(333), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6173] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(385), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(387), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(334), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6285] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(391), 1,
      anon_sym_RPAREN,
    STATE(61), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(393), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(389), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(337), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6397] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(395), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(397), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(340), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6509] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(401), 1,
      anon_sym_RPAREN,
    STATE(63), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(403), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(399), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(341), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6621] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(405), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(407), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(335), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6733] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(411), 1,
      anon_sym_RPAREN,
    STATE(65), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(413), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(409), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(345), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6845] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(415), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(417), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(346), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6957] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(421), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(423), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(419), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(383), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7069] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(427), 1,
      anon_sym_RPAREN,
    STATE(44), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(429), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(425), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(368), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7181] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(433), 1,
      anon_sym_RPAREN,
    STATE(69), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(435), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(431), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(349), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7293] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(437), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(439), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(324), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7405] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(441), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(443), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(323), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7517] = 27,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(454), 1,
      anon_sym_DOLLAR,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_RPAREN,
    ACTIONS(462), 1,
      anon_sym_function,
    ACTIONS(468), 1,
      anon_sym_return,
    ACTIONS(471), 1,
      anon_sym_switch,
    ACTIONS(477), 1,
      anon_sym_for,
    ACTIONS(480), 1,
      anon_sym_while,
    ACTIONS(483), 1,
      anon_sym_if,
    ACTIONS(486), 1,
      anon_sym_begin,
    ACTIONS(489), 1,
      aux_sym_test_command_token1,
    ACTIONS(492), 1,
      anon_sym_test,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(498), 1,
      anon_sym_DQUOTE,
    ACTIONS(501), 1,
      anon_sym_SQUOTE,
    ACTIONS(504), 1,
      sym__special_character,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(445), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(451), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(474), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(448), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(465), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(386), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7629] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(507), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(509), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(352), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7741] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(511), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(513), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(336), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7853] = 27,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(454), 1,
      anon_sym_DOLLAR,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(462), 1,
      anon_sym_function,
    ACTIONS(468), 1,
      anon_sym_return,
    ACTIONS(471), 1,
      anon_sym_switch,
    ACTIONS(477), 1,
      anon_sym_for,
    ACTIONS(480), 1,
      anon_sym_while,
    ACTIONS(483), 1,
      anon_sym_if,
    ACTIONS(486), 1,
      anon_sym_begin,
    ACTIONS(489), 1,
      aux_sym_test_command_token1,
    ACTIONS(492), 1,
      anon_sym_test,
    ACTIONS(495), 1,
      anon_sym_LBRACE,
    ACTIONS(498), 1,
      anon_sym_DQUOTE,
    ACTIONS(501), 1,
      anon_sym_SQUOTE,
    ACTIONS(504), 1,
      sym__special_character,
    ACTIONS(515), 1,
      ts_builtin_sym_end,
    STATE(74), 1,
      aux_sym_program_repeat1,
    ACTIONS(445), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(451), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(520), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(517), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(465), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(407), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7965] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(523), 2,
      anon_sym_end,
      anon_sym_case,
    ACTIONS(525), 2,
      sym_break,
      sym_continue,
    STATE(76), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(408), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8074] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(525), 2,
      sym_break,
      sym_continue,
    ACTIONS(529), 2,
      anon_sym_end,
      anon_sym_case,
    STATE(77), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(408), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8183] = 27,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_DOLLAR,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(543), 1,
      anon_sym_function,
    ACTIONS(551), 1,
      anon_sym_return,
    ACTIONS(554), 1,
      anon_sym_switch,
    ACTIONS(560), 1,
      anon_sym_for,
    ACTIONS(563), 1,
      anon_sym_while,
    ACTIONS(566), 1,
      anon_sym_if,
    ACTIONS(569), 1,
      anon_sym_begin,
    ACTIONS(572), 1,
      aux_sym_test_command_token1,
    ACTIONS(575), 1,
      anon_sym_test,
    ACTIONS(578), 1,
      anon_sym_LBRACE,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(584), 1,
      anon_sym_SQUOTE,
    ACTIONS(587), 1,
      sym_escape_sequence,
    ACTIONS(590), 1,
      sym__special_character,
    ACTIONS(531), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(534), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(546), 2,
      anon_sym_end,
      anon_sym_case,
    ACTIONS(557), 2,
      sym_break,
      sym_continue,
    STATE(77), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(548), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(408), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8292] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(593), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(93), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8400] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(597), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(97), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8508] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(599), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(78), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8616] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(601), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(85), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8724] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(603), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(89), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8832] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(605), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(96), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8940] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(607), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(95), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [9048] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(609), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(93), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [9156] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(611), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [9264] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(613), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(93), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [9372] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(615), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(93), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [9480] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(617), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(93), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [9588] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(619), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(100), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [9696] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(621), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(99), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [9804] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(623), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(87), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [9912] = 27,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_DOLLAR,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(543), 1,
      anon_sym_function,
    ACTIONS(546), 1,
      anon_sym_end,
    ACTIONS(551), 1,
      anon_sym_return,
    ACTIONS(554), 1,
      anon_sym_switch,
    ACTIONS(560), 1,
      anon_sym_for,
    ACTIONS(563), 1,
      anon_sym_while,
    ACTIONS(566), 1,
      anon_sym_if,
    ACTIONS(569), 1,
      anon_sym_begin,
    ACTIONS(572), 1,
      aux_sym_test_command_token1,
    ACTIONS(575), 1,
      anon_sym_test,
    ACTIONS(578), 1,
      anon_sym_LBRACE,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(584), 1,
      anon_sym_SQUOTE,
    ACTIONS(587), 1,
      sym_escape_sequence,
    ACTIONS(590), 1,
      sym__special_character,
    ACTIONS(531), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(534), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(625), 2,
      sym_break,
      sym_continue,
    STATE(93), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(548), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [10020] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(628), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(93), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [10128] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(630), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(93), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [10236] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(632), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(93), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [10344] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(634), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(93), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [10452] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(636), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(94), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [10560] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(638), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(93), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [10668] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(640), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(595), 2,
      sym_break,
      sym_continue,
    STATE(93), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(388), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [10776] = 26,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    STATE(3), 1,
      sym__terminated_statement,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(642), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(403), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [10880] = 26,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    STATE(13), 1,
      sym__terminated_statement,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(644), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(420), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [10984] = 26,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    STATE(4), 1,
      sym__terminated_statement,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(642), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(403), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [11088] = 25,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(646), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(366), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [11189] = 25,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(648), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(374), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [11290] = 25,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(650), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(363), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [11391] = 25,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(652), 2,
      sym_break,
      sym_continue,
    STATE(115), 2,
      sym_concatenation,
      sym__expression,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(377), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [11492] = 16,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(656), 1,
      anon_sym_BANG,
    ACTIONS(658), 1,
      anon_sym_DOLLAR,
    ACTIONS(660), 1,
      anon_sym_LPAREN,
    ACTIONS(664), 1,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(666), 1,
      sym_test_option,
    ACTIONS(668), 1,
      anon_sym_LBRACE,
    ACTIONS(670), 1,
      anon_sym_DQUOTE,
    ACTIONS(672), 1,
      anon_sym_SQUOTE,
    ACTIONS(674), 1,
      sym__special_character,
    STATE(250), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(283), 2,
      sym_concatenation,
      sym__expression,
    STATE(236), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(662), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(320), 6,
      sym__test_expression,
      sym__parenthesized_test_expression,
      sym_negated_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
    ACTIONS(654), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [11567] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(676), 34,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_else,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11607] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(678), 34,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_else,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11647] = 13,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    STATE(113), 1,
      aux_sym_command_repeat1,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(171), 2,
      sym_concatenation,
      sym__expression,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(680), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [11708] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(515), 1,
      ts_builtin_sym_end,
    ACTIONS(460), 32,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11749] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(684), 1,
      anon_sym_DOLLAR,
    ACTIONS(687), 1,
      anon_sym_LPAREN,
    ACTIONS(693), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(699), 1,
      anon_sym_SQUOTE,
    ACTIONS(702), 1,
      sym__special_character,
    STATE(113), 1,
      aux_sym_command_repeat1,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(171), 2,
      sym_concatenation,
      sym__expression,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(690), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(682), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [11810] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(460), 33,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_function,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11849] = 13,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    STATE(111), 1,
      aux_sym_command_repeat1,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(171), 2,
      sym_concatenation,
      sym__expression,
    STATE(143), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(705), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [11910] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(676), 33,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11949] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(678), 33,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11988] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_DOLLAR,
    ACTIONS(660), 1,
      anon_sym_LPAREN,
    ACTIONS(668), 1,
      anon_sym_LBRACE,
    ACTIONS(670), 1,
      anon_sym_DQUOTE,
    ACTIONS(672), 1,
      anon_sym_SQUOTE,
    ACTIONS(674), 1,
      sym__special_character,
    STATE(250), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(391), 2,
      sym_concatenation,
      sym__expression,
    STATE(236), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(662), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(707), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [12046] = 16,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(709), 1,
      anon_sym_BANG,
    ACTIONS(711), 1,
      anon_sym_DOLLAR,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(717), 1,
      anon_sym_RBRACK,
    ACTIONS(719), 1,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(721), 1,
      sym_test_option,
    ACTIONS(723), 1,
      anon_sym_LBRACE,
    ACTIONS(725), 1,
      anon_sym_DQUOTE,
    ACTIONS(727), 1,
      anon_sym_SQUOTE,
    ACTIONS(729), 1,
      sym__special_character,
    STATE(468), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(485), 2,
      sym_concatenation,
      sym__expression,
    STATE(440), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(715), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(668), 6,
      sym__test_expression,
      sym__parenthesized_test_expression,
      sym_negated_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [12111] = 15,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(656), 1,
      anon_sym_BANG,
    ACTIONS(658), 1,
      anon_sym_DOLLAR,
    ACTIONS(660), 1,
      anon_sym_LPAREN,
    ACTIONS(664), 1,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(666), 1,
      sym_test_option,
    ACTIONS(668), 1,
      anon_sym_LBRACE,
    ACTIONS(670), 1,
      anon_sym_DQUOTE,
    ACTIONS(672), 1,
      anon_sym_SQUOTE,
    ACTIONS(674), 1,
      sym__special_character,
    STATE(250), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(283), 2,
      sym_concatenation,
      sym__expression,
    STATE(236), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(662), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(316), 6,
      sym__test_expression,
      sym__parenthesized_test_expression,
      sym_negated_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [12173] = 15,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(709), 1,
      anon_sym_BANG,
    ACTIONS(711), 1,
      anon_sym_DOLLAR,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(719), 1,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(721), 1,
      sym_test_option,
    ACTIONS(723), 1,
      anon_sym_LBRACE,
    ACTIONS(725), 1,
      anon_sym_DQUOTE,
    ACTIONS(727), 1,
      anon_sym_SQUOTE,
    ACTIONS(729), 1,
      sym__special_character,
    STATE(468), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(485), 2,
      sym_concatenation,
      sym__expression,
    STATE(440), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(715), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(627), 6,
      sym__test_expression,
      sym__parenthesized_test_expression,
      sym_negated_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [12235] = 15,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(709), 1,
      anon_sym_BANG,
    ACTIONS(711), 1,
      anon_sym_DOLLAR,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(719), 1,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(721), 1,
      sym_test_option,
    ACTIONS(723), 1,
      anon_sym_LBRACE,
    ACTIONS(725), 1,
      anon_sym_DQUOTE,
    ACTIONS(727), 1,
      anon_sym_SQUOTE,
    ACTIONS(729), 1,
      sym__special_character,
    STATE(468), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(485), 2,
      sym_concatenation,
      sym__expression,
    STATE(440), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(715), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(613), 6,
      sym__test_expression,
      sym__parenthesized_test_expression,
      sym_negated_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [12297] = 15,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(709), 1,
      anon_sym_BANG,
    ACTIONS(711), 1,
      anon_sym_DOLLAR,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(719), 1,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(721), 1,
      sym_test_option,
    ACTIONS(723), 1,
      anon_sym_LBRACE,
    ACTIONS(725), 1,
      anon_sym_DQUOTE,
    ACTIONS(727), 1,
      anon_sym_SQUOTE,
    ACTIONS(729), 1,
      sym__special_character,
    STATE(468), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(485), 2,
      sym_concatenation,
      sym__expression,
    STATE(440), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(715), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(694), 6,
      sym__test_expression,
      sym__parenthesized_test_expression,
      sym_negated_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [12359] = 15,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(709), 1,
      anon_sym_BANG,
    ACTIONS(711), 1,
      anon_sym_DOLLAR,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(719), 1,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(721), 1,
      sym_test_option,
    ACTIONS(723), 1,
      anon_sym_LBRACE,
    ACTIONS(725), 1,
      anon_sym_DQUOTE,
    ACTIONS(727), 1,
      anon_sym_SQUOTE,
    ACTIONS(729), 1,
      sym__special_character,
    STATE(468), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(485), 2,
      sym_concatenation,
      sym__expression,
    STATE(440), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(715), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(699), 6,
      sym__test_expression,
      sym__parenthesized_test_expression,
      sym_negated_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [12421] = 15,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(656), 1,
      anon_sym_BANG,
    ACTIONS(658), 1,
      anon_sym_DOLLAR,
    ACTIONS(660), 1,
      anon_sym_LPAREN,
    ACTIONS(664), 1,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(666), 1,
      sym_test_option,
    ACTIONS(668), 1,
      anon_sym_LBRACE,
    ACTIONS(670), 1,
      anon_sym_DQUOTE,
    ACTIONS(672), 1,
      anon_sym_SQUOTE,
    ACTIONS(674), 1,
      sym__special_character,
    STATE(250), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(283), 2,
      sym_concatenation,
      sym__expression,
    STATE(236), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(662), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(321), 6,
      sym__test_expression,
      sym__parenthesized_test_expression,
      sym_negated_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [12483] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(731), 1,
      sym_escape_sequence,
    ACTIONS(676), 28,
      anon_sym_and,
      anon_sym_or,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_case,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12520] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(731), 1,
      sym_escape_sequence,
    ACTIONS(676), 27,
      anon_sym_and,
      anon_sym_or,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12556] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_DOLLAR,
    ACTIONS(738), 1,
      anon_sym_LPAREN,
    ACTIONS(744), 1,
      anon_sym_LBRACE,
    ACTIONS(747), 1,
      anon_sym_DQUOTE,
    ACTIONS(750), 1,
      anon_sym_SQUOTE,
    ACTIONS(753), 1,
      sym__special_character,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(128), 3,
      sym_concatenation,
      sym__expression,
      aux_sym_case_clause_repeat1,
    ACTIONS(733), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(211), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(741), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12609] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_DOLLAR,
    ACTIONS(760), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      anon_sym_LBRACE,
    ACTIONS(766), 1,
      anon_sym_DQUOTE,
    ACTIONS(768), 1,
      anon_sym_SQUOTE,
    ACTIONS(770), 1,
      sym__special_character,
    STATE(131), 1,
      aux_sym_function_definition_repeat1,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(251), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(756), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(211), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(762), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12664] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_DOLLAR,
    ACTIONS(777), 1,
      anon_sym_LPAREN,
    ACTIONS(783), 1,
      anon_sym_LBRACE,
    ACTIONS(786), 1,
      anon_sym_DQUOTE,
    ACTIONS(789), 1,
      anon_sym_SQUOTE,
    ACTIONS(792), 1,
      sym__special_character,
    STATE(130), 1,
      aux_sym_function_definition_repeat1,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(251), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(772), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(211), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(780), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12719] = 17,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_DOLLAR,
    ACTIONS(760), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      anon_sym_LBRACE,
    ACTIONS(766), 1,
      anon_sym_DQUOTE,
    ACTIONS(768), 1,
      anon_sym_SQUOTE,
    ACTIONS(770), 1,
      sym__special_character,
    ACTIONS(795), 1,
      anon_sym_SEMI,
    ACTIONS(797), 1,
      anon_sym_AMP,
    ACTIONS(799), 1,
      anon_sym_LF,
    ACTIONS(801), 1,
      anon_sym_CR,
    ACTIONS(803), 1,
      anon_sym_CR_LF,
    STATE(130), 1,
      aux_sym_function_definition_repeat1,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(251), 2,
      sym_concatenation,
      sym__expression,
    STATE(211), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(762), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12782] = 17,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_DOLLAR,
    ACTIONS(760), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      anon_sym_LBRACE,
    ACTIONS(766), 1,
      anon_sym_DQUOTE,
    ACTIONS(768), 1,
      anon_sym_SQUOTE,
    ACTIONS(770), 1,
      sym__special_character,
    ACTIONS(805), 1,
      anon_sym_SEMI,
    ACTIONS(807), 1,
      anon_sym_AMP,
    ACTIONS(809), 1,
      anon_sym_LF,
    ACTIONS(811), 1,
      anon_sym_CR,
    ACTIONS(813), 1,
      anon_sym_CR_LF,
    STATE(134), 1,
      aux_sym_for_statement_repeat1,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(256), 2,
      sym_concatenation,
      sym__expression,
    STATE(211), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(762), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12845] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_DOLLAR,
    ACTIONS(760), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      anon_sym_LBRACE,
    ACTIONS(766), 1,
      anon_sym_DQUOTE,
    ACTIONS(768), 1,
      anon_sym_SQUOTE,
    ACTIONS(770), 1,
      sym__special_character,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(128), 3,
      sym_concatenation,
      sym__expression,
      aux_sym_case_clause_repeat1,
    ACTIONS(815), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(211), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(762), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12898] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(819), 1,
      anon_sym_DOLLAR,
    ACTIONS(822), 1,
      anon_sym_LPAREN,
    ACTIONS(828), 1,
      anon_sym_LBRACE,
    ACTIONS(831), 1,
      anon_sym_DQUOTE,
    ACTIONS(834), 1,
      anon_sym_SQUOTE,
    ACTIONS(837), 1,
      sym__special_character,
    STATE(134), 1,
      aux_sym_for_statement_repeat1,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(256), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(817), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(211), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(825), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12953] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym__concat,
    ACTIONS(844), 1,
      sym__concat_list,
    STATE(138), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(840), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12991] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(848), 1,
      sym__concat,
    ACTIONS(850), 1,
      sym__concat_list,
    STATE(136), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(846), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13029] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(139), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(842), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(840), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13065] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(844), 1,
      sym__concat_list,
    ACTIONS(855), 1,
      sym__concat,
    STATE(136), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(853), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13103] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(136), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(855), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(853), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13139] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(848), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(846), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13172] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(859), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(857), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13205] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(863), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(861), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13238] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(867), 1,
      sym__concat,
    STATE(147), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(865), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13273] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(871), 1,
      sym__concat,
    STATE(144), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(869), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13308] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(876), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(874), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13341] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(867), 1,
      sym__concat,
    STATE(147), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(878), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13376] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(867), 1,
      sym__concat,
    STATE(144), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(880), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13411] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(884), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(882), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13444] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(888), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(886), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13477] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(890), 1,
      sym__concat,
    ACTIONS(869), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13509] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(894), 1,
      sym__concat,
    ACTIONS(892), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13541] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(898), 1,
      sym__concat,
    ACTIONS(896), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13573] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(859), 1,
      sym__concat,
    ACTIONS(857), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13605] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(902), 1,
      sym__concat,
    ACTIONS(900), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13637] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(884), 1,
      sym__concat,
    ACTIONS(882), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13669] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(906), 1,
      sym__concat,
    ACTIONS(904), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13701] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(910), 1,
      sym__concat,
    ACTIONS(908), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13733] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(914), 1,
      sym__concat,
    ACTIONS(912), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13765] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(918), 1,
      sym__concat,
    ACTIONS(916), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13797] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(922), 1,
      sym__concat,
    ACTIONS(920), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13829] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(926), 1,
      sym__concat,
    ACTIONS(924), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13861] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(863), 1,
      sym__concat,
    ACTIONS(861), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13893] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(930), 1,
      sym__concat,
    ACTIONS(928), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13925] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(934), 1,
      sym__concat,
    ACTIONS(932), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13957] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(944), 1,
      anon_sym_COMMA,
    ACTIONS(946), 1,
      anon_sym_RBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    STATE(690), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(692), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14008] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(944), 1,
      anon_sym_COMMA,
    ACTIONS(946), 1,
      anon_sym_RBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    STATE(697), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(703), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14059] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(944), 1,
      anon_sym_COMMA,
    ACTIONS(946), 1,
      anon_sym_RBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    STATE(659), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(675), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14110] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(944), 1,
      anon_sym_COMMA,
    ACTIONS(946), 1,
      anon_sym_RBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    STATE(671), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(655), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14161] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(944), 1,
      anon_sym_COMMA,
    ACTIONS(946), 1,
      anon_sym_RBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    STATE(654), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(667), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14212] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(944), 1,
      anon_sym_COMMA,
    ACTIONS(946), 1,
      anon_sym_RBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    STATE(685), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(647), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14263] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(952), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14292] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(944), 1,
      anon_sym_COMMA,
    ACTIONS(946), 1,
      anon_sym_RBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    STATE(670), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(698), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14343] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(944), 1,
      anon_sym_COMMA,
    ACTIONS(946), 1,
      anon_sym_RBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    STATE(691), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(663), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14394] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    ACTIONS(954), 1,
      anon_sym_COMMA,
    STATE(687), 1,
      sym_variable_expansion,
    STATE(701), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(707), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14444] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    STATE(693), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(695), 1,
      sym_variable_expansion,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(709), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14494] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    ACTIONS(958), 1,
      anon_sym_COMMA,
    STATE(648), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(649), 1,
      sym_variable_expansion,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(705), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14544] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_DOLLAR,
    ACTIONS(760), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      anon_sym_LBRACE,
    ACTIONS(766), 1,
      anon_sym_DQUOTE,
    ACTIONS(768), 1,
      anon_sym_SQUOTE,
    ACTIONS(770), 1,
      sym__special_character,
    ACTIONS(960), 1,
      sym_escape_sequence,
    STATE(132), 1,
      aux_sym_for_statement_repeat1,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(256), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(762), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(211), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [14594] = 11,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    ACTIONS(946), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(713), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14640] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    ACTIONS(962), 1,
      anon_sym_COMMA,
    STATE(681), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(682), 1,
      sym_variable_expansion,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(708), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14690] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    ACTIONS(964), 1,
      anon_sym_COMMA,
    STATE(652), 1,
      sym_variable_expansion,
    STATE(665), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(706), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14740] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    ACTIONS(966), 1,
      anon_sym_COMMA,
    STATE(676), 1,
      sym_variable_expansion,
    STATE(677), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(721), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14790] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_DOLLAR,
    ACTIONS(760), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      anon_sym_LBRACE,
    ACTIONS(766), 1,
      anon_sym_DQUOTE,
    ACTIONS(768), 1,
      anon_sym_SQUOTE,
    ACTIONS(770), 1,
      sym__special_character,
    ACTIONS(960), 1,
      sym_escape_sequence,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(133), 3,
      sym_concatenation,
      sym__expression,
      aux_sym_case_clause_repeat1,
    ACTIONS(762), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(211), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [14838] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    ACTIONS(968), 1,
      anon_sym_COMMA,
    STATE(656), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(657), 1,
      sym_variable_expansion,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(704), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14888] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    ACTIONS(970), 1,
      anon_sym_COMMA,
    STATE(662), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(664), 1,
      sym_variable_expansion,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(712), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(940), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(609), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14938] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(972), 1,
      anon_sym_DOLLAR,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(978), 1,
      anon_sym_LBRACE,
    ACTIONS(980), 1,
      anon_sym_DQUOTE,
    ACTIONS(982), 1,
      anon_sym_SQUOTE,
    ACTIONS(984), 1,
      sym_escape_sequence,
    ACTIONS(986), 1,
      sym__special_character,
    STATE(313), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(319), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(976), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(292), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [14985] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_DOLLAR,
    ACTIONS(660), 1,
      anon_sym_LPAREN,
    ACTIONS(668), 1,
      anon_sym_LBRACE,
    ACTIONS(670), 1,
      anon_sym_DQUOTE,
    ACTIONS(672), 1,
      anon_sym_SQUOTE,
    ACTIONS(674), 1,
      sym__special_character,
    ACTIONS(988), 1,
      sym_escape_sequence,
    STATE(250), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(410), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(662), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(236), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15032] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_DOLLAR,
    ACTIONS(760), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      anon_sym_LBRACE,
    ACTIONS(766), 1,
      anon_sym_DQUOTE,
    ACTIONS(768), 1,
      anon_sym_SQUOTE,
    ACTIONS(770), 1,
      sym__special_character,
    ACTIONS(960), 1,
      sym_escape_sequence,
    STATE(129), 2,
      sym_concatenation,
      sym__expression,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(762), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(211), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15079] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(990), 1,
      anon_sym_DOLLAR,
    ACTIONS(992), 1,
      anon_sym_LPAREN,
    ACTIONS(996), 1,
      anon_sym_LBRACE,
    ACTIONS(998), 1,
      anon_sym_DQUOTE,
    ACTIONS(1000), 1,
      anon_sym_SQUOTE,
    ACTIONS(1002), 1,
      sym_escape_sequence,
    ACTIONS(1004), 1,
      sym__special_character,
    STATE(592), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(614), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(994), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(538), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15126] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1006), 1,
      anon_sym_DOLLAR,
    ACTIONS(1008), 1,
      anon_sym_LPAREN,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_DQUOTE,
    ACTIONS(1016), 1,
      anon_sym_SQUOTE,
    ACTIONS(1018), 1,
      sym_escape_sequence,
    ACTIONS(1020), 1,
      sym__special_character,
    STATE(534), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(604), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(1010), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(484), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15173] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(990), 1,
      anon_sym_DOLLAR,
    ACTIONS(992), 1,
      anon_sym_LPAREN,
    ACTIONS(996), 1,
      anon_sym_LBRACE,
    ACTIONS(998), 1,
      anon_sym_DQUOTE,
    ACTIONS(1000), 1,
      anon_sym_SQUOTE,
    ACTIONS(1002), 1,
      sym_escape_sequence,
    ACTIONS(1004), 1,
      sym__special_character,
    STATE(592), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(628), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(994), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(538), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15220] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(972), 1,
      anon_sym_DOLLAR,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(978), 1,
      anon_sym_LBRACE,
    ACTIONS(980), 1,
      anon_sym_DQUOTE,
    ACTIONS(982), 1,
      anon_sym_SQUOTE,
    ACTIONS(984), 1,
      sym_escape_sequence,
    ACTIONS(986), 1,
      sym__special_character,
    STATE(313), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(318), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(976), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(292), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15267] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym__concat,
    ACTIONS(1022), 1,
      sym__concat_list,
    STATE(193), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(840), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15299] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(855), 1,
      sym__concat,
    ACTIONS(1022), 1,
      sym__concat_list,
    STATE(195), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(853), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15331] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(196), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(842), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(840), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15361] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(848), 1,
      sym__concat,
    ACTIONS(1024), 1,
      sym__concat_list,
    STATE(195), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(846), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15393] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(195), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(855), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(853), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15423] = 10,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(972), 1,
      anon_sym_DOLLAR,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    ACTIONS(978), 1,
      anon_sym_LBRACE,
    ACTIONS(980), 1,
      anon_sym_DQUOTE,
    ACTIONS(982), 1,
      anon_sym_SQUOTE,
    ACTIONS(1029), 1,
      sym_escape_sequence,
    STATE(313), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(310), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(1027), 6,
      sym_integer,
      sym_float,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15464] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(863), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(861), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15491] = 10,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1006), 1,
      anon_sym_DOLLAR,
    ACTIONS(1008), 1,
      anon_sym_LPAREN,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_DQUOTE,
    ACTIONS(1016), 1,
      anon_sym_SQUOTE,
    ACTIONS(1033), 1,
      sym_escape_sequence,
    STATE(534), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(551), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(1031), 6,
      sym_integer,
      sym_float,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15532] = 10,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_DOLLAR,
    ACTIONS(660), 1,
      anon_sym_LPAREN,
    ACTIONS(668), 1,
      anon_sym_LBRACE,
    ACTIONS(670), 1,
      anon_sym_DQUOTE,
    ACTIONS(672), 1,
      anon_sym_SQUOTE,
    ACTIONS(1037), 1,
      sym_escape_sequence,
    STATE(250), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(259), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(1035), 6,
      sym_integer,
      sym_float,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15573] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(884), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(882), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15600] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(848), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(846), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15627] = 10,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(1041), 1,
      sym_escape_sequence,
    STATE(154), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(150), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(1039), 6,
      sym_integer,
      sym_float,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15668] = 10,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_DOLLAR,
    ACTIONS(760), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      anon_sym_LBRACE,
    ACTIONS(766), 1,
      anon_sym_DQUOTE,
    ACTIONS(768), 1,
      anon_sym_SQUOTE,
    ACTIONS(1045), 1,
      sym_escape_sequence,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(225), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(1043), 6,
      sym_integer,
      sym_float,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15709] = 10,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_DOLLAR,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(723), 1,
      anon_sym_LBRACE,
    ACTIONS(725), 1,
      anon_sym_DQUOTE,
    ACTIONS(727), 1,
      anon_sym_SQUOTE,
    ACTIONS(1049), 1,
      sym_escape_sequence,
    STATE(468), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(463), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(1047), 6,
      sym_integer,
      sym_float,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15750] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(859), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(857), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15777] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(855), 1,
      sym__concat,
    ACTIONS(1051), 1,
      sym__concat_list,
    STATE(214), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(853), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [15808] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(209), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(842), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(840), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [15837] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(214), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(855), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(853), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [15866] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(888), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(886), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15893] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1053), 1,
      sym__concat,
    STATE(216), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(865), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15922] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1053), 1,
      sym__concat,
    STATE(216), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(878), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15951] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(876), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(874), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [15978] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(848), 1,
      sym__concat,
    ACTIONS(1055), 1,
      sym__concat_list,
    STATE(214), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(846), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16009] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1058), 1,
      sym__concat,
    STATE(215), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(869), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16038] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1053), 1,
      sym__concat,
    STATE(215), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(880), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16067] = 10,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(990), 1,
      anon_sym_DOLLAR,
    ACTIONS(992), 1,
      anon_sym_LPAREN,
    ACTIONS(996), 1,
      anon_sym_LBRACE,
    ACTIONS(998), 1,
      anon_sym_DQUOTE,
    ACTIONS(1000), 1,
      anon_sym_SQUOTE,
    ACTIONS(1063), 1,
      sym_escape_sequence,
    STATE(592), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(599), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(1061), 6,
      sym_integer,
      sym_float,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16108] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym__concat,
    ACTIONS(1051), 1,
      sym__concat_list,
    STATE(207), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(840), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16139] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(898), 1,
      sym__concat,
    ACTIONS(896), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16165] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(914), 1,
      sym__concat,
    ACTIONS(912), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16191] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1065), 1,
      sym__concat,
    STATE(221), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(869), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16219] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(863), 1,
      sym__concat,
    ACTIONS(861), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16245] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1068), 1,
      sym__concat,
    STATE(221), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(880), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16273] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(926), 1,
      sym__concat,
    ACTIONS(924), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16299] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(890), 1,
      sym__concat,
    ACTIONS(869), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16325] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(859), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(857), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16351] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(906), 1,
      sym__concat,
    ACTIONS(904), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16377] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(902), 1,
      sym__concat,
    ACTIONS(900), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16403] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1068), 1,
      sym__concat,
    STATE(223), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(878), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16431] = 9,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_DOLLAR,
    ACTIONS(938), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 1,
      anon_sym_SQUOTE,
    STATE(678), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(1070), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(673), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [16469] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(894), 1,
      sym__concat,
    ACTIONS(892), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16495] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(934), 1,
      sym__concat,
    ACTIONS(932), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16521] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(910), 1,
      sym__concat,
    ACTIONS(908), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16547] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(918), 1,
      sym__concat,
    ACTIONS(916), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16573] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(876), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(874), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16599] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1068), 1,
      sym__concat,
    STATE(223), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(865), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16627] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(888), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(886), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16653] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(930), 1,
      sym__concat,
    ACTIONS(928), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16679] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(859), 1,
      sym__concat,
    ACTIONS(857), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16705] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(884), 1,
      sym__concat,
    ACTIONS(882), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16731] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(922), 1,
      sym__concat,
    ACTIONS(920), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [16757] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(863), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(861), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16783] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(884), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(882), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16809] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(848), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(846), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16835] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(922), 1,
      sym__concat,
    ACTIONS(920), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16860] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(930), 1,
      sym__concat,
    ACTIONS(928), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16885] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(859), 1,
      sym__concat,
    ACTIONS(857), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16910] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(910), 1,
      sym__concat,
    ACTIONS(908), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16935] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(934), 1,
      sym__concat,
    ACTIONS(932), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16960] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(902), 1,
      sym__concat,
    ACTIONS(900), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [16985] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1072), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [17008] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(906), 1,
      sym__concat,
    ACTIONS(904), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [17033] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(863), 1,
      sym__concat,
    ACTIONS(861), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [17058] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(894), 1,
      sym__concat,
    ACTIONS(892), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [17083] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(898), 1,
      sym__concat,
    ACTIONS(896), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [17108] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1074), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [17131] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(918), 1,
      sym__concat,
    ACTIONS(916), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [17156] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(926), 1,
      sym__concat,
    ACTIONS(924), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [17181] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(890), 1,
      sym__concat,
    ACTIONS(869), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [17206] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(884), 1,
      sym__concat,
    ACTIONS(882), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [17231] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(914), 1,
      sym__concat,
    ACTIONS(912), 16,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
  [17256] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1082), 1,
      anon_sym_RBRACK,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    STATE(517), 1,
      sym_index,
    STATE(265), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17298] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1090), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(280), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17340] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(266), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(855), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(853), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [17366] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_DOLLAR,
    ACTIONS(1095), 1,
      anon_sym_LPAREN,
    ACTIONS(1098), 1,
      sym_integer,
    ACTIONS(1101), 1,
      anon_sym_RBRACK,
    ACTIONS(1103), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1106), 1,
      anon_sym_DQUOTE,
    ACTIONS(1109), 1,
      anon_sym_SQUOTE,
    STATE(517), 1,
      sym_index,
    STATE(265), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17408] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(848), 1,
      sym__concat,
    ACTIONS(1112), 1,
      sym__concat_list,
    STATE(266), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(846), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [17436] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1115), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(268), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17478] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1117), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(265), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17520] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1119), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(272), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17562] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(264), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(842), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(840), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [17588] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1121), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(282), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17630] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(265), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17672] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1125), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(276), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17714] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1127), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(265), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17756] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1129), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(262), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17798] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1131), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(265), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17840] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1133), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(265), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17882] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1135), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(274), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17924] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1137), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(281), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [17966] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1139), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(265), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [18008] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1141), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(265), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [18050] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1143), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(265), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [18092] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1147), 3,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      sym_test_option,
    ACTIONS(1145), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18116] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym__concat,
    ACTIONS(1149), 1,
      sym__concat_list,
    STATE(287), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(840), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18144] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1151), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(265), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [18186] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1153), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(285), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [18228] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(855), 1,
      sym__concat,
    ACTIONS(1149), 1,
      sym__concat_list,
    STATE(266), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(853), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18256] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1084), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    ACTIONS(1155), 1,
      anon_sym_RBRACK,
    STATE(517), 1,
      sym_index,
    STATE(277), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [18298] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(888), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(886), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18321] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1157), 1,
      sym__concat,
    STATE(297), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(880), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18346] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1157), 1,
      sym__concat,
    STATE(290), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(878), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18371] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1157), 1,
      sym__concat,
    STATE(290), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(865), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18396] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(863), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(861), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18419] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(848), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(846), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18442] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(876), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(874), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18465] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(859), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(857), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18488] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1159), 1,
      sym__concat,
    STATE(297), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(869), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18513] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(884), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(882), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18536] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(922), 1,
      sym__concat,
    ACTIONS(920), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18558] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(898), 1,
      sym__concat,
    ACTIONS(896), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18580] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    STATE(520), 1,
      sym_index,
    ACTIONS(1162), 2,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [18616] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(859), 1,
      sym__concat,
    ACTIONS(857), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18638] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(884), 1,
      sym__concat,
    ACTIONS(882), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18660] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(863), 1,
      sym__concat,
    ACTIONS(861), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18682] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_DOLLAR,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      sym_integer,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    ACTIONS(1088), 1,
      anon_sym_SQUOTE,
    STATE(516), 1,
      sym_index,
    ACTIONS(1164), 2,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
    STATE(483), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(515), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [18718] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(930), 1,
      sym__concat,
    ACTIONS(928), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18740] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(918), 1,
      sym__concat,
    ACTIONS(916), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18762] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(910), 1,
      sym__concat,
    ACTIONS(908), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18784] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(926), 1,
      sym__concat,
    ACTIONS(924), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18806] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(890), 1,
      sym__concat,
    ACTIONS(869), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18828] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(894), 1,
      sym__concat,
    ACTIONS(892), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18850] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(906), 1,
      sym__concat,
    ACTIONS(904), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18872] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(902), 1,
      sym__concat,
    ACTIONS(900), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18894] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(934), 1,
      sym__concat,
    ACTIONS(932), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18916] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(914), 1,
      sym__concat,
    ACTIONS(912), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18938] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1168), 2,
      anon_sym_DASHa,
      anon_sym_DASHo,
    ACTIONS(1166), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18959] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1170), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18978] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1172), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [18997] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1174), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [19016] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1168), 2,
      anon_sym_DASHa,
      anon_sym_DASHo,
    ACTIONS(1176), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [19037] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1168), 2,
      anon_sym_DASHa,
      anon_sym_DASHo,
    ACTIONS(1178), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [19058] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1190), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19088] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1192), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19118] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1194), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19148] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1196), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19178] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(173), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19208] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1198), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19238] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(183), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19268] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(381), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19298] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(281), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19328] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19358] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(511), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19388] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1200), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19418] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1202), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19448] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1204), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19478] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1206), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19508] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(395), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19538] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1208), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19568] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1210), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19598] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1212), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19628] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(405), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19658] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(205), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19688] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(365), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19718] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(361), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19748] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(415), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19778] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1214), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19808] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19838] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1216), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19868] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19898] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1218), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19928] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1220), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19958] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1222), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19988] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(209), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20018] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(341), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20048] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1224), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20078] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1226), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20108] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(331), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20138] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(307), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20168] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20198] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1230), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20228] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1232), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20258] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1234), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20288] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1236), 6,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [20316] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(315), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20346] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1238), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20376] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1240), 9,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [20400] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(303), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20430] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(311), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20460] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1242), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20490] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(385), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20520] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(345), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20550] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1244), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20580] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1246), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20610] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1248), 6,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [20638] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20668] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(235), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20698] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1250), 8,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [20724] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20754] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20784] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1252), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20814] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(259), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20844] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    ACTIONS(1254), 1,
      anon_sym_RPAREN,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20874] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(507), 1,
      anon_sym_RPAREN,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20904] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1256), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [20921] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1256), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [20938] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [20965] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1258), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [20982] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1260), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [21009] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1262), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21026] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1264), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21043] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1266), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21060] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1268), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21077] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1270), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [21104] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1268), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21121] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1272), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21138] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1274), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21155] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1276), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21172] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1256), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21189] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1256), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21206] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1262), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21223] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1268), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21240] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1256), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21257] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1278), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [21284] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1268), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21301] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1262), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21318] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1280), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [21345] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1282), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [21372] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1284), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [21399] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1286), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21416] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1288), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21433] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1290), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21450] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1262), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21467] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1262), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21484] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1292), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21501] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1294), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21518] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1294), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21535] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1294), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21552] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1294), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21569] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1294), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21586] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_stream_redirect,
    ACTIONS(1184), 1,
      sym_direction,
    ACTIONS(1186), 1,
      anon_sym_PIPE,
    STATE(414), 1,
      sym_file_redirect,
    ACTIONS(1180), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1296), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [21613] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1298), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21630] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1268), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21647] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1300), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21664] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1176), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21681] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1302), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21698] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1304), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21715] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1306), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21732] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1308), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [21749] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(432), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(853), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(855), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [21769] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1310), 1,
      sym__concat_list,
    STATE(433), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(840), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(842), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [21791] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(429), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(840), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(842), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [21811] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1312), 1,
      sym__concat_list,
    STATE(432), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(846), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(848), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [21833] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1310), 1,
      sym__concat_list,
    STATE(432), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(853), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(855), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [21855] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(863), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [21872] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 1,
      sym__concat_list,
    STATE(435), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(848), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [21891] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(848), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [21908] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1320), 1,
      sym__concat,
    STATE(442), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(878), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(1318), 4,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [21929] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(886), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(888), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [21946] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1322), 1,
      sym__concat,
    STATE(439), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(869), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(890), 4,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [21967] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1320), 1,
      sym__concat,
    STATE(442), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(865), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(1325), 4,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [21988] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(884), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22005] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1320), 1,
      sym__concat,
    STATE(439), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(880), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(1327), 4,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22026] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(435), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(855), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22043] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(443), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(842), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22060] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(857), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(859), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22077] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 1,
      sym__concat_list,
    STATE(435), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(855), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22096] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 1,
      sym__concat_list,
    STATE(446), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(842), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22115] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(876), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22132] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(855), 1,
      sym__concat,
    ACTIONS(1331), 1,
      sym__concat_list,
    STATE(462), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(853), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [22152] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(466), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(842), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(840), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [22170] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(934), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22200] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(898), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22216] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22230] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(884), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22246] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22260] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22274] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(894), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22290] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22304] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(926), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22334] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(848), 1,
      sym__concat,
    ACTIONS(1333), 1,
      sym__concat_list,
    STATE(462), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(846), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [22354] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(869), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(890), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22370] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(906), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22386] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym__concat,
    ACTIONS(1331), 1,
      sym__concat_list,
    STATE(449), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(840), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [22406] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(462), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(855), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(853), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [22424] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(863), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22440] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(902), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22456] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(922), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22472] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(930), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22488] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(914), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22504] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(910), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22520] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(857), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(859), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22536] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(916), 3,
      anon_sym_DASHa,
      anon_sym_DASHo,
      sym_test_option,
    ACTIONS(918), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22552] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1338), 1,
      anon_sym_DQUOTE,
    ACTIONS(1340), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1342), 1,
      sym_escape_sequence,
    STATE(490), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [22573] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1344), 1,
      sym__concat_list,
    STATE(478), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(855), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [22590] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1346), 1,
      anon_sym_DQUOTE,
    ACTIONS(1348), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1350), 1,
      sym_escape_sequence,
    STATE(487), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [22611] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1352), 1,
      sym__concat_list,
    STATE(478), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(848), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [22628] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1355), 1,
      anon_sym_DQUOTE,
    ACTIONS(1357), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1359), 1,
      sym_escape_sequence,
    STATE(492), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [22649] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22662] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22675] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22688] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22701] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1361), 1,
      sym__concat,
    STATE(506), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(865), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [22718] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1367), 1,
      sym_test_option,
    ACTIONS(1145), 2,
      anon_sym_DASHa,
      anon_sym_DASHo,
    ACTIONS(1363), 2,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
    ACTIONS(1365), 2,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
  [22737] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1369), 1,
      anon_sym_DQUOTE,
    ACTIONS(1371), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1373), 1,
      sym_escape_sequence,
    STATE(503), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [22758] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1371), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1373), 1,
      sym_escape_sequence,
    ACTIONS(1375), 1,
      anon_sym_DQUOTE,
    STATE(503), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [22779] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1377), 1,
      sym__concat,
    STATE(488), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(869), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [22796] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(478), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(855), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [22811] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1371), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1373), 1,
      sym_escape_sequence,
    ACTIONS(1380), 1,
      anon_sym_DQUOTE,
    STATE(503), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [22832] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(906), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22845] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1371), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1373), 1,
      sym_escape_sequence,
    ACTIONS(1382), 1,
      anon_sym_DQUOTE,
    STATE(503), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [22866] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(489), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(842), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [22881] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(894), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22894] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1371), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1373), 1,
      sym_escape_sequence,
    ACTIONS(1384), 1,
      anon_sym_DQUOTE,
    STATE(503), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [22915] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1386), 1,
      anon_sym_DQUOTE,
    ACTIONS(1388), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1390), 1,
      sym_escape_sequence,
    STATE(505), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [22936] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(898), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22949] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(926), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22962] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(910), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22975] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(918), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [22988] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1392), 1,
      anon_sym_DQUOTE,
    ACTIONS(1394), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1396), 1,
      sym_escape_sequence,
    STATE(486), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [23009] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1398), 1,
      anon_sym_DQUOTE,
    ACTIONS(1400), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1402), 1,
      sym_escape_sequence,
    STATE(511), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [23030] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1404), 1,
      anon_sym_DOLLAR,
    ACTIONS(1407), 1,
      anon_sym_DQUOTE,
    ACTIONS(1409), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1412), 1,
      sym_escape_sequence,
    STATE(503), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [23051] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1415), 1,
      anon_sym_DQUOTE,
    ACTIONS(1417), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1419), 1,
      sym_escape_sequence,
    STATE(495), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [23072] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1371), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1373), 1,
      sym_escape_sequence,
    ACTIONS(1421), 1,
      anon_sym_DQUOTE,
    STATE(503), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [23093] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1361), 1,
      sym__concat,
    STATE(488), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(880), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23110] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1371), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1373), 1,
      sym_escape_sequence,
    ACTIONS(1423), 1,
      anon_sym_DQUOTE,
    STATE(503), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [23131] = 4,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1361), 1,
      sym__concat,
    STATE(506), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(878), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23148] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(876), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(874), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23163] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(848), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(846), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23178] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1371), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1373), 1,
      sym_escape_sequence,
    ACTIONS(1425), 1,
      anon_sym_DQUOTE,
    STATE(503), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [23199] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1371), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1373), 1,
      sym_escape_sequence,
    ACTIONS(1427), 1,
      anon_sym_DQUOTE,
    STATE(503), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [23220] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(888), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(886), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23235] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [23248] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [23261] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1431), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [23274] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1435), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1433), 6,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [23289] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(863), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(861), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23304] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1344), 1,
      sym__concat_list,
    STATE(476), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(842), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23321] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [23334] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(859), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(857), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23349] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1437), 1,
      anon_sym_DQUOTE,
    ACTIONS(1439), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1441), 1,
      sym_escape_sequence,
    STATE(512), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [23370] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(884), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(882), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23385] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1336), 1,
      anon_sym_DOLLAR,
    ACTIONS(1443), 1,
      anon_sym_DQUOTE,
    ACTIONS(1445), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1447), 1,
      sym_escape_sequence,
    STATE(507), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [23406] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(918), 1,
      sym__concat,
    ACTIONS(916), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23420] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23432] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23444] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23456] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(910), 1,
      sym__concat,
    ACTIONS(908), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23470] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(922), 1,
      sym__concat,
    ACTIONS(920), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23484] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(934), 1,
      sym__concat,
    ACTIONS(932), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23498] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1449), 1,
      sym__concat,
    STATE(532), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(890), 4,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23514] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(863), 1,
      sym__concat,
    ACTIONS(861), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23528] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(902), 1,
      sym__concat,
    ACTIONS(900), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23542] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(906), 1,
      sym__concat,
    ACTIONS(904), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23556] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(859), 1,
      sym__concat,
    ACTIONS(857), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23570] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(884), 1,
      sym__concat,
    ACTIONS(882), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23584] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1452), 1,
      sym__concat,
    STATE(548), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1325), 4,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23600] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(914), 1,
      sym__concat,
    ACTIONS(912), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23614] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(848), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1454), 1,
      sym__concat_list,
    STATE(540), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(846), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [23632] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(547), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(842), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(840), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [23648] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(894), 1,
      sym__concat,
    ACTIONS(892), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23662] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1452), 1,
      sym__concat,
    STATE(548), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1318), 4,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23678] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(855), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1457), 1,
      sym__concat_list,
    STATE(540), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(853), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [23696] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(898), 1,
      sym__concat,
    ACTIONS(896), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23710] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(926), 1,
      sym__concat,
    ACTIONS(924), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23724] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(540), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(855), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(853), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [23740] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1452), 1,
      sym__concat,
    STATE(532), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(1327), 4,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23756] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23768] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(842), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1457), 1,
      sym__concat_list,
    STATE(544), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(840), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [23786] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(890), 1,
      sym__concat,
    ACTIONS(869), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23800] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1461), 1,
      anon_sym_if,
    ACTIONS(1459), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23814] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23826] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 6,
      sym__concat,
      sym__concat_list,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23838] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(930), 1,
      sym__concat,
    ACTIONS(928), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [23852] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(584), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(842), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [23865] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(876), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(874), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [23878] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1463), 1,
      anon_sym_DOLLAR,
    ACTIONS(1465), 1,
      anon_sym_LPAREN,
    ACTIONS(1467), 1,
      sym_variable_name,
    STATE(450), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [23895] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23906] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1463), 1,
      anon_sym_DOLLAR,
    ACTIONS(1469), 1,
      anon_sym_LPAREN,
    ACTIONS(1471), 1,
      sym_variable_name,
    STATE(465), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [23923] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(888), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(886), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [23936] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1473), 1,
      anon_sym_DOLLAR,
    ACTIONS(1475), 1,
      anon_sym_LPAREN,
    ACTIONS(1477), 1,
      sym_variable_name,
    STATE(137), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [23953] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1479), 1,
      anon_sym_DOLLAR,
    ACTIONS(1481), 1,
      anon_sym_LPAREN,
    ACTIONS(1483), 1,
      sym_variable_name,
    STATE(431), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [23970] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [23981] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1479), 1,
      anon_sym_DOLLAR,
    ACTIONS(1485), 1,
      anon_sym_LPAREN,
    ACTIONS(1487), 1,
      sym_variable_name,
    STATE(430), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [23998] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24009] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1491), 1,
      anon_sym_LPAREN,
    ACTIONS(1493), 1,
      sym_variable_name,
    STATE(519), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24026] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1495), 1,
      anon_sym_DOLLAR,
    ACTIONS(1497), 1,
      anon_sym_LPAREN,
    ACTIONS(1499), 1,
      sym_variable_name,
    STATE(218), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24043] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1501), 1,
      anon_sym_DOLLAR,
    ACTIONS(1503), 1,
      anon_sym_LPAREN,
    ACTIONS(1505), 1,
      sym_variable_name,
    STATE(284), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24060] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(848), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(846), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [24073] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1495), 1,
      anon_sym_DOLLAR,
    ACTIONS(1507), 1,
      anon_sym_LPAREN,
    ACTIONS(1509), 1,
      sym_variable_name,
    STATE(208), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24090] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(918), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24101] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24112] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24123] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24134] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOLLAR,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      sym_variable_name,
    STATE(556), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24151] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(910), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24162] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(914), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24173] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1517), 1,
      anon_sym_DOLLAR,
    ACTIONS(1519), 1,
      anon_sym_LPAREN,
    ACTIONS(1521), 1,
      sym_variable_name,
    STATE(541), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24190] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(926), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24201] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1489), 1,
      anon_sym_DOLLAR,
    ACTIONS(1523), 1,
      anon_sym_LPAREN,
    ACTIONS(1525), 1,
      sym_variable_name,
    STATE(493), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24218] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1527), 1,
      sym__concat_list,
    STATE(602), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(855), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24233] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1529), 1,
      anon_sym_end,
    ACTIONS(1531), 1,
      anon_sym_else,
    STATE(725), 1,
      sym_else_clause,
    STATE(625), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
  [24250] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(602), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(855), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24263] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(898), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24274] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOLLAR,
    ACTIONS(1533), 1,
      anon_sym_LPAREN,
    ACTIONS(1535), 1,
      sym_variable_name,
    STATE(591), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24291] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(894), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24302] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1473), 1,
      anon_sym_DOLLAR,
    ACTIONS(1537), 1,
      anon_sym_LPAREN,
    ACTIONS(1539), 1,
      sym_variable_name,
    STATE(135), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24319] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1501), 1,
      anon_sym_DOLLAR,
    ACTIONS(1541), 1,
      anon_sym_LPAREN,
    ACTIONS(1543), 1,
      sym_variable_name,
    STATE(270), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24336] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(906), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24347] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1527), 1,
      sym__concat_list,
    STATE(582), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(842), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24362] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24373] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1545), 1,
      anon_sym_DOLLAR,
    ACTIONS(1547), 1,
      anon_sym_LPAREN,
    ACTIONS(1549), 1,
      sym_variable_name,
    STATE(192), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24390] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(863), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(861), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [24403] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1551), 1,
      anon_sym_DOLLAR,
    ACTIONS(1553), 1,
      anon_sym_LPAREN,
    ACTIONS(1555), 1,
      sym_variable_name,
    STATE(447), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24420] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(884), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(882), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [24433] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1545), 1,
      anon_sym_DOLLAR,
    ACTIONS(1557), 1,
      anon_sym_LPAREN,
    ACTIONS(1559), 1,
      sym_variable_name,
    STATE(194), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24450] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1551), 1,
      anon_sym_DOLLAR,
    ACTIONS(1561), 1,
      anon_sym_LPAREN,
    ACTIONS(1563), 1,
      sym_variable_name,
    STATE(444), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24467] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(890), 5,
      sym__concat,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24478] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(859), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(857), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [24491] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1531), 1,
      anon_sym_else,
    ACTIONS(1565), 1,
      anon_sym_end,
    STATE(724), 1,
      sym_else_clause,
    STATE(625), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
  [24508] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1567), 1,
      sym__concat_list,
    STATE(602), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(848), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24523] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1517), 1,
      anon_sym_DOLLAR,
    ACTIONS(1570), 1,
      anon_sym_LPAREN,
    ACTIONS(1572), 1,
      sym_variable_name,
    STATE(550), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [24540] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1574), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [24551] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(884), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(882), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [24563] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1576), 1,
      anon_sym_SQUOTE,
    ACTIONS(1578), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1580), 1,
      sym_escape_sequence,
    STATE(641), 1,
      aux_sym_single_quote_string_repeat1,
  [24579] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1582), 1,
      anon_sym_SQUOTE,
    ACTIONS(1584), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1586), 1,
      sym_escape_sequence,
    STATE(611), 1,
      aux_sym_single_quote_string_repeat1,
  [24595] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1588), 1,
      anon_sym_SQUOTE,
    ACTIONS(1590), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1592), 1,
      sym_escape_sequence,
    STATE(621), 1,
      aux_sym_single_quote_string_repeat1,
  [24611] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1596), 1,
      sym__brace_concat,
    STATE(618), 1,
      aux_sym_brace_concatenation_repeat1,
    ACTIONS(1594), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24625] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1598), 1,
      anon_sym_SQUOTE,
    ACTIONS(1600), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1602), 1,
      sym_escape_sequence,
    STATE(617), 1,
      aux_sym_single_quote_string_repeat1,
  [24641] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1590), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1592), 1,
      sym_escape_sequence,
    ACTIONS(1604), 1,
      anon_sym_SQUOTE,
    STATE(621), 1,
      aux_sym_single_quote_string_repeat1,
  [24657] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1606), 1,
      anon_sym_end,
    ACTIONS(1608), 1,
      anon_sym_case,
    STATE(622), 2,
      sym_case_clause,
      aux_sym_switch_statement_repeat1,
  [24671] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1610), 2,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
    ACTIONS(1612), 2,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24683] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1614), 4,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24693] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1616), 1,
      anon_sym_SQUOTE,
    ACTIONS(1618), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1620), 1,
      sym_escape_sequence,
    STATE(631), 1,
      aux_sym_single_quote_string_repeat1,
  [24709] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1622), 1,
      anon_sym_SQUOTE,
    ACTIONS(1624), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1626), 1,
      sym_escape_sequence,
    STATE(608), 1,
      aux_sym_single_quote_string_repeat1,
  [24725] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1590), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1592), 1,
      sym_escape_sequence,
    ACTIONS(1628), 1,
      anon_sym_SQUOTE,
    STATE(621), 1,
      aux_sym_single_quote_string_repeat1,
  [24741] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1596), 1,
      sym__brace_concat,
    STATE(632), 1,
      aux_sym_brace_concatenation_repeat1,
    ACTIONS(1630), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24755] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24765] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24775] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1632), 1,
      anon_sym_SQUOTE,
    ACTIONS(1634), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1637), 1,
      sym_escape_sequence,
    STATE(621), 1,
      aux_sym_single_quote_string_repeat1,
  [24791] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1608), 1,
      anon_sym_case,
    ACTIONS(1640), 1,
      anon_sym_end,
    STATE(637), 2,
      sym_case_clause,
      aux_sym_switch_statement_repeat1,
  [24805] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24815] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24825] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1642), 1,
      anon_sym_end,
    ACTIONS(1644), 1,
      anon_sym_else,
    STATE(625), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
  [24839] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1647), 4,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24849] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1612), 2,
      anon_sym_DASHa,
      anon_sym_DASHo,
    ACTIONS(1649), 2,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
  [24861] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1651), 4,
      aux_sym_test_command_token2,
      anon_sym_BSLASH_RPAREN,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [24871] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1590), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1592), 1,
      sym_escape_sequence,
    ACTIONS(1653), 1,
      anon_sym_SQUOTE,
    STATE(621), 1,
      aux_sym_single_quote_string_repeat1,
  [24887] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1655), 1,
      anon_sym_SQUOTE,
    ACTIONS(1657), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1659), 1,
      sym_escape_sequence,
    STATE(635), 1,
      aux_sym_single_quote_string_repeat1,
  [24903] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1590), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1592), 1,
      sym_escape_sequence,
    ACTIONS(1661), 1,
      anon_sym_SQUOTE,
    STATE(621), 1,
      aux_sym_single_quote_string_repeat1,
  [24919] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1665), 1,
      sym__brace_concat,
    STATE(632), 1,
      aux_sym_brace_concatenation_repeat1,
    ACTIONS(1663), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24933] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24943] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1668), 1,
      anon_sym_SQUOTE,
    ACTIONS(1670), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1672), 1,
      sym_escape_sequence,
    STATE(629), 1,
      aux_sym_single_quote_string_repeat1,
  [24959] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1590), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1592), 1,
      sym_escape_sequence,
    ACTIONS(1674), 1,
      anon_sym_SQUOTE,
    STATE(621), 1,
      aux_sym_single_quote_string_repeat1,
  [24975] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [24985] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1676), 1,
      anon_sym_end,
    ACTIONS(1678), 1,
      anon_sym_case,
    STATE(637), 2,
      sym_case_clause,
      aux_sym_switch_statement_repeat1,
  [24999] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1681), 1,
      anon_sym_SQUOTE,
    ACTIONS(1683), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1685), 1,
      sym_escape_sequence,
    STATE(640), 1,
      aux_sym_single_quote_string_repeat1,
  [25015] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1590), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1592), 1,
      sym_escape_sequence,
    ACTIONS(1687), 1,
      anon_sym_SQUOTE,
    STATE(621), 1,
      aux_sym_single_quote_string_repeat1,
  [25031] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1590), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1592), 1,
      sym_escape_sequence,
    ACTIONS(1689), 1,
      anon_sym_SQUOTE,
    STATE(621), 1,
      aux_sym_single_quote_string_repeat1,
  [25047] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1590), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1592), 1,
      sym_escape_sequence,
    ACTIONS(1691), 1,
      anon_sym_SQUOTE,
    STATE(621), 1,
      aux_sym_single_quote_string_repeat1,
  [25063] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(859), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(857), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [25075] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1693), 1,
      anon_sym_SQUOTE,
    ACTIONS(1695), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1697), 1,
      sym_escape_sequence,
    STATE(639), 1,
      aux_sym_single_quote_string_repeat1,
  [25091] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(863), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(861), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [25103] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1701), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25116] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(910), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25125] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1703), 1,
      anon_sym_RBRACE,
    STATE(683), 1,
      aux_sym_brace_expansion_repeat1,
  [25138] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1705), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25151] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1705), 1,
      anon_sym_RBRACE,
    ACTIONS(1707), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [25162] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25171] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1709), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1711), 1,
      anon_sym_RBRACE,
    ACTIONS(1707), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [25195] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25204] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1713), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25217] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1703), 1,
      anon_sym_RBRACE,
    STATE(700), 1,
      aux_sym_brace_expansion_repeat1,
  [25230] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1715), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25243] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1715), 1,
      anon_sym_RBRACE,
    ACTIONS(1707), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [25254] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1717), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25267] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1719), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25280] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(918), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25289] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25298] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1721), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25311] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1703), 1,
      anon_sym_RBRACE,
    STATE(672), 1,
      aux_sym_brace_expansion_repeat1,
  [25324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1721), 1,
      anon_sym_RBRACE,
    ACTIONS(1707), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [25335] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1711), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25348] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25357] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1703), 1,
      anon_sym_RBRACE,
    STATE(651), 1,
      aux_sym_brace_expansion_repeat1,
  [25370] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1723), 1,
      aux_sym_test_command_token2,
    ACTIONS(1612), 2,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [25381] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25390] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1725), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25403] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1727), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25416] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1729), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25429] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1663), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25438] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1731), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25451] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1703), 1,
      anon_sym_RBRACE,
    STATE(658), 1,
      aux_sym_brace_expansion_repeat1,
  [25464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1733), 1,
      anon_sym_RBRACE,
    ACTIONS(1707), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [25475] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1733), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25488] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25497] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25506] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(906), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25515] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1735), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25528] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1735), 1,
      anon_sym_RBRACE,
    ACTIONS(1707), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [25539] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1737), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25552] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(894), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25561] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1739), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25574] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(898), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25583] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1741), 1,
      anon_sym_RBRACE,
    ACTIONS(1707), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [25594] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1703), 1,
      anon_sym_RBRACE,
    ACTIONS(1743), 1,
      anon_sym_COMMA,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25607] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(926), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25616] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1746), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25629] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1748), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25642] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1703), 1,
      anon_sym_RBRACE,
    STATE(674), 1,
      aux_sym_brace_expansion_repeat1,
  [25655] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1750), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25668] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1752), 1,
      anon_sym_BSLASH_RPAREN,
    ACTIONS(1612), 2,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [25679] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1750), 1,
      anon_sym_RBRACE,
    ACTIONS(1707), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [25690] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1754), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25703] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1756), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25716] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1703), 1,
      anon_sym_RBRACE,
    STATE(645), 1,
      aux_sym_brace_expansion_repeat1,
  [25729] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1758), 1,
      anon_sym_BSLASH_RPAREN,
    ACTIONS(1612), 2,
      anon_sym_DASHa,
      anon_sym_DASHo,
  [25740] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1760), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25753] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1741), 1,
      anon_sym_RBRACE,
    STATE(688), 1,
      aux_sym_brace_expansion_repeat1,
  [25766] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(914), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25775] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1703), 1,
      anon_sym_RBRACE,
    STATE(696), 1,
      aux_sym_brace_expansion_repeat1,
  [25788] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    STATE(654), 1,
      aux_sym_brace_expansion_repeat1,
  [25798] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    STATE(691), 1,
      aux_sym_brace_expansion_repeat1,
  [25808] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    STATE(697), 1,
      aux_sym_brace_expansion_repeat1,
  [25818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    STATE(690), 1,
      aux_sym_brace_expansion_repeat1,
  [25828] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    STATE(670), 1,
      aux_sym_brace_expansion_repeat1,
  [25838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    STATE(685), 1,
      aux_sym_brace_expansion_repeat1,
  [25848] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1762), 1,
      anon_sym_LBRACK,
    STATE(570), 1,
      sym_list_element_access,
  [25858] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1764), 1,
      anon_sym_LBRACK,
    STATE(526), 1,
      sym_list_element_access,
  [25868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    STATE(659), 1,
      aux_sym_brace_expansion_repeat1,
  [25878] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1703), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [25886] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1766), 1,
      anon_sym_LBRACK,
    STATE(244), 1,
      sym_list_element_access,
  [25896] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1768), 1,
      anon_sym_LBRACK,
    STATE(294), 1,
      sym_list_element_access,
  [25906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1770), 1,
      anon_sym_LBRACK,
    STATE(140), 1,
      sym_list_element_access,
  [25916] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1772), 1,
      anon_sym_LBRACK,
    STATE(202), 1,
      sym_list_element_access,
  [25926] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1774), 1,
      anon_sym_LBRACK,
    STATE(636), 1,
      sym_list_element_access,
  [25936] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1776), 1,
      anon_sym_LBRACK,
    STATE(454), 1,
      sym_list_element_access,
  [25946] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1778), 1,
      anon_sym_LBRACK,
    STATE(436), 1,
      sym_list_element_access,
  [25956] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    STATE(671), 1,
      aux_sym_brace_expansion_repeat1,
  [25966] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1780), 1,
      anon_sym_LBRACK,
    STATE(510), 1,
      sym_list_element_access,
  [25976] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1782), 1,
      ts_builtin_sym_end,
  [25983] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1529), 1,
      anon_sym_end,
  [25990] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1784), 1,
      anon_sym_end,
  [25997] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1786), 1,
      anon_sym_if,
  [26004] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1788), 1,
      sym_variable_name,
  [26011] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1565), 1,
      anon_sym_end,
  [26018] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1790), 1,
      anon_sym_in,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(4)] = 0,
  [SMALL_STATE(5)] = 114,
  [SMALL_STATE(6)] = 228,
  [SMALL_STATE(7)] = 342,
  [SMALL_STATE(8)] = 455,
  [SMALL_STATE(9)] = 568,
  [SMALL_STATE(10)] = 681,
  [SMALL_STATE(11)] = 794,
  [SMALL_STATE(12)] = 907,
  [SMALL_STATE(13)] = 1020,
  [SMALL_STATE(14)] = 1133,
  [SMALL_STATE(15)] = 1245,
  [SMALL_STATE(16)] = 1357,
  [SMALL_STATE(17)] = 1469,
  [SMALL_STATE(18)] = 1581,
  [SMALL_STATE(19)] = 1693,
  [SMALL_STATE(20)] = 1805,
  [SMALL_STATE(21)] = 1917,
  [SMALL_STATE(22)] = 2029,
  [SMALL_STATE(23)] = 2141,
  [SMALL_STATE(24)] = 2253,
  [SMALL_STATE(25)] = 2365,
  [SMALL_STATE(26)] = 2477,
  [SMALL_STATE(27)] = 2589,
  [SMALL_STATE(28)] = 2701,
  [SMALL_STATE(29)] = 2813,
  [SMALL_STATE(30)] = 2925,
  [SMALL_STATE(31)] = 3037,
  [SMALL_STATE(32)] = 3149,
  [SMALL_STATE(33)] = 3261,
  [SMALL_STATE(34)] = 3373,
  [SMALL_STATE(35)] = 3485,
  [SMALL_STATE(36)] = 3597,
  [SMALL_STATE(37)] = 3709,
  [SMALL_STATE(38)] = 3821,
  [SMALL_STATE(39)] = 3933,
  [SMALL_STATE(40)] = 4045,
  [SMALL_STATE(41)] = 4157,
  [SMALL_STATE(42)] = 4269,
  [SMALL_STATE(43)] = 4381,
  [SMALL_STATE(44)] = 4493,
  [SMALL_STATE(45)] = 4605,
  [SMALL_STATE(46)] = 4717,
  [SMALL_STATE(47)] = 4829,
  [SMALL_STATE(48)] = 4941,
  [SMALL_STATE(49)] = 5053,
  [SMALL_STATE(50)] = 5165,
  [SMALL_STATE(51)] = 5277,
  [SMALL_STATE(52)] = 5389,
  [SMALL_STATE(53)] = 5501,
  [SMALL_STATE(54)] = 5613,
  [SMALL_STATE(55)] = 5725,
  [SMALL_STATE(56)] = 5837,
  [SMALL_STATE(57)] = 5949,
  [SMALL_STATE(58)] = 6061,
  [SMALL_STATE(59)] = 6173,
  [SMALL_STATE(60)] = 6285,
  [SMALL_STATE(61)] = 6397,
  [SMALL_STATE(62)] = 6509,
  [SMALL_STATE(63)] = 6621,
  [SMALL_STATE(64)] = 6733,
  [SMALL_STATE(65)] = 6845,
  [SMALL_STATE(66)] = 6957,
  [SMALL_STATE(67)] = 7069,
  [SMALL_STATE(68)] = 7181,
  [SMALL_STATE(69)] = 7293,
  [SMALL_STATE(70)] = 7405,
  [SMALL_STATE(71)] = 7517,
  [SMALL_STATE(72)] = 7629,
  [SMALL_STATE(73)] = 7741,
  [SMALL_STATE(74)] = 7853,
  [SMALL_STATE(75)] = 7965,
  [SMALL_STATE(76)] = 8074,
  [SMALL_STATE(77)] = 8183,
  [SMALL_STATE(78)] = 8292,
  [SMALL_STATE(79)] = 8400,
  [SMALL_STATE(80)] = 8508,
  [SMALL_STATE(81)] = 8616,
  [SMALL_STATE(82)] = 8724,
  [SMALL_STATE(83)] = 8832,
  [SMALL_STATE(84)] = 8940,
  [SMALL_STATE(85)] = 9048,
  [SMALL_STATE(86)] = 9156,
  [SMALL_STATE(87)] = 9264,
  [SMALL_STATE(88)] = 9372,
  [SMALL_STATE(89)] = 9480,
  [SMALL_STATE(90)] = 9588,
  [SMALL_STATE(91)] = 9696,
  [SMALL_STATE(92)] = 9804,
  [SMALL_STATE(93)] = 9912,
  [SMALL_STATE(94)] = 10020,
  [SMALL_STATE(95)] = 10128,
  [SMALL_STATE(96)] = 10236,
  [SMALL_STATE(97)] = 10344,
  [SMALL_STATE(98)] = 10452,
  [SMALL_STATE(99)] = 10560,
  [SMALL_STATE(100)] = 10668,
  [SMALL_STATE(101)] = 10776,
  [SMALL_STATE(102)] = 10880,
  [SMALL_STATE(103)] = 10984,
  [SMALL_STATE(104)] = 11088,
  [SMALL_STATE(105)] = 11189,
  [SMALL_STATE(106)] = 11290,
  [SMALL_STATE(107)] = 11391,
  [SMALL_STATE(108)] = 11492,
  [SMALL_STATE(109)] = 11567,
  [SMALL_STATE(110)] = 11607,
  [SMALL_STATE(111)] = 11647,
  [SMALL_STATE(112)] = 11708,
  [SMALL_STATE(113)] = 11749,
  [SMALL_STATE(114)] = 11810,
  [SMALL_STATE(115)] = 11849,
  [SMALL_STATE(116)] = 11910,
  [SMALL_STATE(117)] = 11949,
  [SMALL_STATE(118)] = 11988,
  [SMALL_STATE(119)] = 12046,
  [SMALL_STATE(120)] = 12111,
  [SMALL_STATE(121)] = 12173,
  [SMALL_STATE(122)] = 12235,
  [SMALL_STATE(123)] = 12297,
  [SMALL_STATE(124)] = 12359,
  [SMALL_STATE(125)] = 12421,
  [SMALL_STATE(126)] = 12483,
  [SMALL_STATE(127)] = 12520,
  [SMALL_STATE(128)] = 12556,
  [SMALL_STATE(129)] = 12609,
  [SMALL_STATE(130)] = 12664,
  [SMALL_STATE(131)] = 12719,
  [SMALL_STATE(132)] = 12782,
  [SMALL_STATE(133)] = 12845,
  [SMALL_STATE(134)] = 12898,
  [SMALL_STATE(135)] = 12953,
  [SMALL_STATE(136)] = 12991,
  [SMALL_STATE(137)] = 13029,
  [SMALL_STATE(138)] = 13065,
  [SMALL_STATE(139)] = 13103,
  [SMALL_STATE(140)] = 13139,
  [SMALL_STATE(141)] = 13172,
  [SMALL_STATE(142)] = 13205,
  [SMALL_STATE(143)] = 13238,
  [SMALL_STATE(144)] = 13273,
  [SMALL_STATE(145)] = 13308,
  [SMALL_STATE(146)] = 13341,
  [SMALL_STATE(147)] = 13376,
  [SMALL_STATE(148)] = 13411,
  [SMALL_STATE(149)] = 13444,
  [SMALL_STATE(150)] = 13477,
  [SMALL_STATE(151)] = 13509,
  [SMALL_STATE(152)] = 13541,
  [SMALL_STATE(153)] = 13573,
  [SMALL_STATE(154)] = 13605,
  [SMALL_STATE(155)] = 13637,
  [SMALL_STATE(156)] = 13669,
  [SMALL_STATE(157)] = 13701,
  [SMALL_STATE(158)] = 13733,
  [SMALL_STATE(159)] = 13765,
  [SMALL_STATE(160)] = 13797,
  [SMALL_STATE(161)] = 13829,
  [SMALL_STATE(162)] = 13861,
  [SMALL_STATE(163)] = 13893,
  [SMALL_STATE(164)] = 13925,
  [SMALL_STATE(165)] = 13957,
  [SMALL_STATE(166)] = 14008,
  [SMALL_STATE(167)] = 14059,
  [SMALL_STATE(168)] = 14110,
  [SMALL_STATE(169)] = 14161,
  [SMALL_STATE(170)] = 14212,
  [SMALL_STATE(171)] = 14263,
  [SMALL_STATE(172)] = 14292,
  [SMALL_STATE(173)] = 14343,
  [SMALL_STATE(174)] = 14394,
  [SMALL_STATE(175)] = 14444,
  [SMALL_STATE(176)] = 14494,
  [SMALL_STATE(177)] = 14544,
  [SMALL_STATE(178)] = 14594,
  [SMALL_STATE(179)] = 14640,
  [SMALL_STATE(180)] = 14690,
  [SMALL_STATE(181)] = 14740,
  [SMALL_STATE(182)] = 14790,
  [SMALL_STATE(183)] = 14838,
  [SMALL_STATE(184)] = 14888,
  [SMALL_STATE(185)] = 14938,
  [SMALL_STATE(186)] = 14985,
  [SMALL_STATE(187)] = 15032,
  [SMALL_STATE(188)] = 15079,
  [SMALL_STATE(189)] = 15126,
  [SMALL_STATE(190)] = 15173,
  [SMALL_STATE(191)] = 15220,
  [SMALL_STATE(192)] = 15267,
  [SMALL_STATE(193)] = 15299,
  [SMALL_STATE(194)] = 15331,
  [SMALL_STATE(195)] = 15361,
  [SMALL_STATE(196)] = 15393,
  [SMALL_STATE(197)] = 15423,
  [SMALL_STATE(198)] = 15464,
  [SMALL_STATE(199)] = 15491,
  [SMALL_STATE(200)] = 15532,
  [SMALL_STATE(201)] = 15573,
  [SMALL_STATE(202)] = 15600,
  [SMALL_STATE(203)] = 15627,
  [SMALL_STATE(204)] = 15668,
  [SMALL_STATE(205)] = 15709,
  [SMALL_STATE(206)] = 15750,
  [SMALL_STATE(207)] = 15777,
  [SMALL_STATE(208)] = 15808,
  [SMALL_STATE(209)] = 15837,
  [SMALL_STATE(210)] = 15866,
  [SMALL_STATE(211)] = 15893,
  [SMALL_STATE(212)] = 15922,
  [SMALL_STATE(213)] = 15951,
  [SMALL_STATE(214)] = 15978,
  [SMALL_STATE(215)] = 16009,
  [SMALL_STATE(216)] = 16038,
  [SMALL_STATE(217)] = 16067,
  [SMALL_STATE(218)] = 16108,
  [SMALL_STATE(219)] = 16139,
  [SMALL_STATE(220)] = 16165,
  [SMALL_STATE(221)] = 16191,
  [SMALL_STATE(222)] = 16219,
  [SMALL_STATE(223)] = 16245,
  [SMALL_STATE(224)] = 16273,
  [SMALL_STATE(225)] = 16299,
  [SMALL_STATE(226)] = 16325,
  [SMALL_STATE(227)] = 16351,
  [SMALL_STATE(228)] = 16377,
  [SMALL_STATE(229)] = 16403,
  [SMALL_STATE(230)] = 16431,
  [SMALL_STATE(231)] = 16469,
  [SMALL_STATE(232)] = 16495,
  [SMALL_STATE(233)] = 16521,
  [SMALL_STATE(234)] = 16547,
  [SMALL_STATE(235)] = 16573,
  [SMALL_STATE(236)] = 16599,
  [SMALL_STATE(237)] = 16627,
  [SMALL_STATE(238)] = 16653,
  [SMALL_STATE(239)] = 16679,
  [SMALL_STATE(240)] = 16705,
  [SMALL_STATE(241)] = 16731,
  [SMALL_STATE(242)] = 16757,
  [SMALL_STATE(243)] = 16783,
  [SMALL_STATE(244)] = 16809,
  [SMALL_STATE(245)] = 16835,
  [SMALL_STATE(246)] = 16860,
  [SMALL_STATE(247)] = 16885,
  [SMALL_STATE(248)] = 16910,
  [SMALL_STATE(249)] = 16935,
  [SMALL_STATE(250)] = 16960,
  [SMALL_STATE(251)] = 16985,
  [SMALL_STATE(252)] = 17008,
  [SMALL_STATE(253)] = 17033,
  [SMALL_STATE(254)] = 17058,
  [SMALL_STATE(255)] = 17083,
  [SMALL_STATE(256)] = 17108,
  [SMALL_STATE(257)] = 17131,
  [SMALL_STATE(258)] = 17156,
  [SMALL_STATE(259)] = 17181,
  [SMALL_STATE(260)] = 17206,
  [SMALL_STATE(261)] = 17231,
  [SMALL_STATE(262)] = 17256,
  [SMALL_STATE(263)] = 17298,
  [SMALL_STATE(264)] = 17340,
  [SMALL_STATE(265)] = 17366,
  [SMALL_STATE(266)] = 17408,
  [SMALL_STATE(267)] = 17436,
  [SMALL_STATE(268)] = 17478,
  [SMALL_STATE(269)] = 17520,
  [SMALL_STATE(270)] = 17562,
  [SMALL_STATE(271)] = 17588,
  [SMALL_STATE(272)] = 17630,
  [SMALL_STATE(273)] = 17672,
  [SMALL_STATE(274)] = 17714,
  [SMALL_STATE(275)] = 17756,
  [SMALL_STATE(276)] = 17798,
  [SMALL_STATE(277)] = 17840,
  [SMALL_STATE(278)] = 17882,
  [SMALL_STATE(279)] = 17924,
  [SMALL_STATE(280)] = 17966,
  [SMALL_STATE(281)] = 18008,
  [SMALL_STATE(282)] = 18050,
  [SMALL_STATE(283)] = 18092,
  [SMALL_STATE(284)] = 18116,
  [SMALL_STATE(285)] = 18144,
  [SMALL_STATE(286)] = 18186,
  [SMALL_STATE(287)] = 18228,
  [SMALL_STATE(288)] = 18256,
  [SMALL_STATE(289)] = 18298,
  [SMALL_STATE(290)] = 18321,
  [SMALL_STATE(291)] = 18346,
  [SMALL_STATE(292)] = 18371,
  [SMALL_STATE(293)] = 18396,
  [SMALL_STATE(294)] = 18419,
  [SMALL_STATE(295)] = 18442,
  [SMALL_STATE(296)] = 18465,
  [SMALL_STATE(297)] = 18488,
  [SMALL_STATE(298)] = 18513,
  [SMALL_STATE(299)] = 18536,
  [SMALL_STATE(300)] = 18558,
  [SMALL_STATE(301)] = 18580,
  [SMALL_STATE(302)] = 18616,
  [SMALL_STATE(303)] = 18638,
  [SMALL_STATE(304)] = 18660,
  [SMALL_STATE(305)] = 18682,
  [SMALL_STATE(306)] = 18718,
  [SMALL_STATE(307)] = 18740,
  [SMALL_STATE(308)] = 18762,
  [SMALL_STATE(309)] = 18784,
  [SMALL_STATE(310)] = 18806,
  [SMALL_STATE(311)] = 18828,
  [SMALL_STATE(312)] = 18850,
  [SMALL_STATE(313)] = 18872,
  [SMALL_STATE(314)] = 18894,
  [SMALL_STATE(315)] = 18916,
  [SMALL_STATE(316)] = 18938,
  [SMALL_STATE(317)] = 18959,
  [SMALL_STATE(318)] = 18978,
  [SMALL_STATE(319)] = 18997,
  [SMALL_STATE(320)] = 19016,
  [SMALL_STATE(321)] = 19037,
  [SMALL_STATE(322)] = 19058,
  [SMALL_STATE(323)] = 19088,
  [SMALL_STATE(324)] = 19118,
  [SMALL_STATE(325)] = 19148,
  [SMALL_STATE(326)] = 19178,
  [SMALL_STATE(327)] = 19208,
  [SMALL_STATE(328)] = 19238,
  [SMALL_STATE(329)] = 19268,
  [SMALL_STATE(330)] = 19298,
  [SMALL_STATE(331)] = 19328,
  [SMALL_STATE(332)] = 19358,
  [SMALL_STATE(333)] = 19388,
  [SMALL_STATE(334)] = 19418,
  [SMALL_STATE(335)] = 19448,
  [SMALL_STATE(336)] = 19478,
  [SMALL_STATE(337)] = 19508,
  [SMALL_STATE(338)] = 19538,
  [SMALL_STATE(339)] = 19568,
  [SMALL_STATE(340)] = 19598,
  [SMALL_STATE(341)] = 19628,
  [SMALL_STATE(342)] = 19658,
  [SMALL_STATE(343)] = 19688,
  [SMALL_STATE(344)] = 19718,
  [SMALL_STATE(345)] = 19748,
  [SMALL_STATE(346)] = 19778,
  [SMALL_STATE(347)] = 19808,
  [SMALL_STATE(348)] = 19838,
  [SMALL_STATE(349)] = 19868,
  [SMALL_STATE(350)] = 19898,
  [SMALL_STATE(351)] = 19928,
  [SMALL_STATE(352)] = 19958,
  [SMALL_STATE(353)] = 19988,
  [SMALL_STATE(354)] = 20018,
  [SMALL_STATE(355)] = 20048,
  [SMALL_STATE(356)] = 20078,
  [SMALL_STATE(357)] = 20108,
  [SMALL_STATE(358)] = 20138,
  [SMALL_STATE(359)] = 20168,
  [SMALL_STATE(360)] = 20198,
  [SMALL_STATE(361)] = 20228,
  [SMALL_STATE(362)] = 20258,
  [SMALL_STATE(363)] = 20288,
  [SMALL_STATE(364)] = 20316,
  [SMALL_STATE(365)] = 20346,
  [SMALL_STATE(366)] = 20376,
  [SMALL_STATE(367)] = 20400,
  [SMALL_STATE(368)] = 20430,
  [SMALL_STATE(369)] = 20460,
  [SMALL_STATE(370)] = 20490,
  [SMALL_STATE(371)] = 20520,
  [SMALL_STATE(372)] = 20550,
  [SMALL_STATE(373)] = 20580,
  [SMALL_STATE(374)] = 20610,
  [SMALL_STATE(375)] = 20638,
  [SMALL_STATE(376)] = 20668,
  [SMALL_STATE(377)] = 20698,
  [SMALL_STATE(378)] = 20724,
  [SMALL_STATE(379)] = 20754,
  [SMALL_STATE(380)] = 20784,
  [SMALL_STATE(381)] = 20814,
  [SMALL_STATE(382)] = 20844,
  [SMALL_STATE(383)] = 20874,
  [SMALL_STATE(384)] = 20904,
  [SMALL_STATE(385)] = 20921,
  [SMALL_STATE(386)] = 20938,
  [SMALL_STATE(387)] = 20965,
  [SMALL_STATE(388)] = 20982,
  [SMALL_STATE(389)] = 21009,
  [SMALL_STATE(390)] = 21026,
  [SMALL_STATE(391)] = 21043,
  [SMALL_STATE(392)] = 21060,
  [SMALL_STATE(393)] = 21077,
  [SMALL_STATE(394)] = 21104,
  [SMALL_STATE(395)] = 21121,
  [SMALL_STATE(396)] = 21138,
  [SMALL_STATE(397)] = 21155,
  [SMALL_STATE(398)] = 21172,
  [SMALL_STATE(399)] = 21189,
  [SMALL_STATE(400)] = 21206,
  [SMALL_STATE(401)] = 21223,
  [SMALL_STATE(402)] = 21240,
  [SMALL_STATE(403)] = 21257,
  [SMALL_STATE(404)] = 21284,
  [SMALL_STATE(405)] = 21301,
  [SMALL_STATE(406)] = 21318,
  [SMALL_STATE(407)] = 21345,
  [SMALL_STATE(408)] = 21372,
  [SMALL_STATE(409)] = 21399,
  [SMALL_STATE(410)] = 21416,
  [SMALL_STATE(411)] = 21433,
  [SMALL_STATE(412)] = 21450,
  [SMALL_STATE(413)] = 21467,
  [SMALL_STATE(414)] = 21484,
  [SMALL_STATE(415)] = 21501,
  [SMALL_STATE(416)] = 21518,
  [SMALL_STATE(417)] = 21535,
  [SMALL_STATE(418)] = 21552,
  [SMALL_STATE(419)] = 21569,
  [SMALL_STATE(420)] = 21586,
  [SMALL_STATE(421)] = 21613,
  [SMALL_STATE(422)] = 21630,
  [SMALL_STATE(423)] = 21647,
  [SMALL_STATE(424)] = 21664,
  [SMALL_STATE(425)] = 21681,
  [SMALL_STATE(426)] = 21698,
  [SMALL_STATE(427)] = 21715,
  [SMALL_STATE(428)] = 21732,
  [SMALL_STATE(429)] = 21749,
  [SMALL_STATE(430)] = 21769,
  [SMALL_STATE(431)] = 21791,
  [SMALL_STATE(432)] = 21811,
  [SMALL_STATE(433)] = 21833,
  [SMALL_STATE(434)] = 21855,
  [SMALL_STATE(435)] = 21872,
  [SMALL_STATE(436)] = 21891,
  [SMALL_STATE(437)] = 21908,
  [SMALL_STATE(438)] = 21929,
  [SMALL_STATE(439)] = 21946,
  [SMALL_STATE(440)] = 21967,
  [SMALL_STATE(441)] = 21988,
  [SMALL_STATE(442)] = 22005,
  [SMALL_STATE(443)] = 22026,
  [SMALL_STATE(444)] = 22043,
  [SMALL_STATE(445)] = 22060,
  [SMALL_STATE(446)] = 22077,
  [SMALL_STATE(447)] = 22096,
  [SMALL_STATE(448)] = 22115,
  [SMALL_STATE(449)] = 22132,
  [SMALL_STATE(450)] = 22152,
  [SMALL_STATE(451)] = 22170,
  [SMALL_STATE(452)] = 22184,
  [SMALL_STATE(453)] = 22200,
  [SMALL_STATE(454)] = 22216,
  [SMALL_STATE(455)] = 22230,
  [SMALL_STATE(456)] = 22246,
  [SMALL_STATE(457)] = 22260,
  [SMALL_STATE(458)] = 22274,
  [SMALL_STATE(459)] = 22290,
  [SMALL_STATE(460)] = 22304,
  [SMALL_STATE(461)] = 22318,
  [SMALL_STATE(462)] = 22334,
  [SMALL_STATE(463)] = 22354,
  [SMALL_STATE(464)] = 22370,
  [SMALL_STATE(465)] = 22386,
  [SMALL_STATE(466)] = 22406,
  [SMALL_STATE(467)] = 22424,
  [SMALL_STATE(468)] = 22440,
  [SMALL_STATE(469)] = 22456,
  [SMALL_STATE(470)] = 22472,
  [SMALL_STATE(471)] = 22488,
  [SMALL_STATE(472)] = 22504,
  [SMALL_STATE(473)] = 22520,
  [SMALL_STATE(474)] = 22536,
  [SMALL_STATE(475)] = 22552,
  [SMALL_STATE(476)] = 22573,
  [SMALL_STATE(477)] = 22590,
  [SMALL_STATE(478)] = 22611,
  [SMALL_STATE(479)] = 22628,
  [SMALL_STATE(480)] = 22649,
  [SMALL_STATE(481)] = 22662,
  [SMALL_STATE(482)] = 22675,
  [SMALL_STATE(483)] = 22688,
  [SMALL_STATE(484)] = 22701,
  [SMALL_STATE(485)] = 22718,
  [SMALL_STATE(486)] = 22737,
  [SMALL_STATE(487)] = 22758,
  [SMALL_STATE(488)] = 22779,
  [SMALL_STATE(489)] = 22796,
  [SMALL_STATE(490)] = 22811,
  [SMALL_STATE(491)] = 22832,
  [SMALL_STATE(492)] = 22845,
  [SMALL_STATE(493)] = 22866,
  [SMALL_STATE(494)] = 22881,
  [SMALL_STATE(495)] = 22894,
  [SMALL_STATE(496)] = 22915,
  [SMALL_STATE(497)] = 22936,
  [SMALL_STATE(498)] = 22949,
  [SMALL_STATE(499)] = 22962,
  [SMALL_STATE(500)] = 22975,
  [SMALL_STATE(501)] = 22988,
  [SMALL_STATE(502)] = 23009,
  [SMALL_STATE(503)] = 23030,
  [SMALL_STATE(504)] = 23051,
  [SMALL_STATE(505)] = 23072,
  [SMALL_STATE(506)] = 23093,
  [SMALL_STATE(507)] = 23110,
  [SMALL_STATE(508)] = 23131,
  [SMALL_STATE(509)] = 23148,
  [SMALL_STATE(510)] = 23163,
  [SMALL_STATE(511)] = 23178,
  [SMALL_STATE(512)] = 23199,
  [SMALL_STATE(513)] = 23220,
  [SMALL_STATE(514)] = 23235,
  [SMALL_STATE(515)] = 23248,
  [SMALL_STATE(516)] = 23261,
  [SMALL_STATE(517)] = 23274,
  [SMALL_STATE(518)] = 23289,
  [SMALL_STATE(519)] = 23304,
  [SMALL_STATE(520)] = 23321,
  [SMALL_STATE(521)] = 23334,
  [SMALL_STATE(522)] = 23349,
  [SMALL_STATE(523)] = 23370,
  [SMALL_STATE(524)] = 23385,
  [SMALL_STATE(525)] = 23406,
  [SMALL_STATE(526)] = 23420,
  [SMALL_STATE(527)] = 23432,
  [SMALL_STATE(528)] = 23444,
  [SMALL_STATE(529)] = 23456,
  [SMALL_STATE(530)] = 23470,
  [SMALL_STATE(531)] = 23484,
  [SMALL_STATE(532)] = 23498,
  [SMALL_STATE(533)] = 23514,
  [SMALL_STATE(534)] = 23528,
  [SMALL_STATE(535)] = 23542,
  [SMALL_STATE(536)] = 23556,
  [SMALL_STATE(537)] = 23570,
  [SMALL_STATE(538)] = 23584,
  [SMALL_STATE(539)] = 23600,
  [SMALL_STATE(540)] = 23614,
  [SMALL_STATE(541)] = 23632,
  [SMALL_STATE(542)] = 23648,
  [SMALL_STATE(543)] = 23662,
  [SMALL_STATE(544)] = 23678,
  [SMALL_STATE(545)] = 23696,
  [SMALL_STATE(546)] = 23710,
  [SMALL_STATE(547)] = 23724,
  [SMALL_STATE(548)] = 23740,
  [SMALL_STATE(549)] = 23756,
  [SMALL_STATE(550)] = 23768,
  [SMALL_STATE(551)] = 23786,
  [SMALL_STATE(552)] = 23800,
  [SMALL_STATE(553)] = 23814,
  [SMALL_STATE(554)] = 23826,
  [SMALL_STATE(555)] = 23838,
  [SMALL_STATE(556)] = 23852,
  [SMALL_STATE(557)] = 23865,
  [SMALL_STATE(558)] = 23878,
  [SMALL_STATE(559)] = 23895,
  [SMALL_STATE(560)] = 23906,
  [SMALL_STATE(561)] = 23923,
  [SMALL_STATE(562)] = 23936,
  [SMALL_STATE(563)] = 23953,
  [SMALL_STATE(564)] = 23970,
  [SMALL_STATE(565)] = 23981,
  [SMALL_STATE(566)] = 23998,
  [SMALL_STATE(567)] = 24009,
  [SMALL_STATE(568)] = 24026,
  [SMALL_STATE(569)] = 24043,
  [SMALL_STATE(570)] = 24060,
  [SMALL_STATE(571)] = 24073,
  [SMALL_STATE(572)] = 24090,
  [SMALL_STATE(573)] = 24101,
  [SMALL_STATE(574)] = 24112,
  [SMALL_STATE(575)] = 24123,
  [SMALL_STATE(576)] = 24134,
  [SMALL_STATE(577)] = 24151,
  [SMALL_STATE(578)] = 24162,
  [SMALL_STATE(579)] = 24173,
  [SMALL_STATE(580)] = 24190,
  [SMALL_STATE(581)] = 24201,
  [SMALL_STATE(582)] = 24218,
  [SMALL_STATE(583)] = 24233,
  [SMALL_STATE(584)] = 24250,
  [SMALL_STATE(585)] = 24263,
  [SMALL_STATE(586)] = 24274,
  [SMALL_STATE(587)] = 24291,
  [SMALL_STATE(588)] = 24302,
  [SMALL_STATE(589)] = 24319,
  [SMALL_STATE(590)] = 24336,
  [SMALL_STATE(591)] = 24347,
  [SMALL_STATE(592)] = 24362,
  [SMALL_STATE(593)] = 24373,
  [SMALL_STATE(594)] = 24390,
  [SMALL_STATE(595)] = 24403,
  [SMALL_STATE(596)] = 24420,
  [SMALL_STATE(597)] = 24433,
  [SMALL_STATE(598)] = 24450,
  [SMALL_STATE(599)] = 24467,
  [SMALL_STATE(600)] = 24478,
  [SMALL_STATE(601)] = 24491,
  [SMALL_STATE(602)] = 24508,
  [SMALL_STATE(603)] = 24523,
  [SMALL_STATE(604)] = 24540,
  [SMALL_STATE(605)] = 24551,
  [SMALL_STATE(606)] = 24563,
  [SMALL_STATE(607)] = 24579,
  [SMALL_STATE(608)] = 24595,
  [SMALL_STATE(609)] = 24611,
  [SMALL_STATE(610)] = 24625,
  [SMALL_STATE(611)] = 24641,
  [SMALL_STATE(612)] = 24657,
  [SMALL_STATE(613)] = 24671,
  [SMALL_STATE(614)] = 24683,
  [SMALL_STATE(615)] = 24693,
  [SMALL_STATE(616)] = 24709,
  [SMALL_STATE(617)] = 24725,
  [SMALL_STATE(618)] = 24741,
  [SMALL_STATE(619)] = 24755,
  [SMALL_STATE(620)] = 24765,
  [SMALL_STATE(621)] = 24775,
  [SMALL_STATE(622)] = 24791,
  [SMALL_STATE(623)] = 24805,
  [SMALL_STATE(624)] = 24815,
  [SMALL_STATE(625)] = 24825,
  [SMALL_STATE(626)] = 24839,
  [SMALL_STATE(627)] = 24849,
  [SMALL_STATE(628)] = 24861,
  [SMALL_STATE(629)] = 24871,
  [SMALL_STATE(630)] = 24887,
  [SMALL_STATE(631)] = 24903,
  [SMALL_STATE(632)] = 24919,
  [SMALL_STATE(633)] = 24933,
  [SMALL_STATE(634)] = 24943,
  [SMALL_STATE(635)] = 24959,
  [SMALL_STATE(636)] = 24975,
  [SMALL_STATE(637)] = 24985,
  [SMALL_STATE(638)] = 24999,
  [SMALL_STATE(639)] = 25015,
  [SMALL_STATE(640)] = 25031,
  [SMALL_STATE(641)] = 25047,
  [SMALL_STATE(642)] = 25063,
  [SMALL_STATE(643)] = 25075,
  [SMALL_STATE(644)] = 25091,
  [SMALL_STATE(645)] = 25103,
  [SMALL_STATE(646)] = 25116,
  [SMALL_STATE(647)] = 25125,
  [SMALL_STATE(648)] = 25138,
  [SMALL_STATE(649)] = 25151,
  [SMALL_STATE(650)] = 25162,
  [SMALL_STATE(651)] = 25171,
  [SMALL_STATE(652)] = 25184,
  [SMALL_STATE(653)] = 25195,
  [SMALL_STATE(654)] = 25204,
  [SMALL_STATE(655)] = 25217,
  [SMALL_STATE(656)] = 25230,
  [SMALL_STATE(657)] = 25243,
  [SMALL_STATE(658)] = 25254,
  [SMALL_STATE(659)] = 25267,
  [SMALL_STATE(660)] = 25280,
  [SMALL_STATE(661)] = 25289,
  [SMALL_STATE(662)] = 25298,
  [SMALL_STATE(663)] = 25311,
  [SMALL_STATE(664)] = 25324,
  [SMALL_STATE(665)] = 25335,
  [SMALL_STATE(666)] = 25348,
  [SMALL_STATE(667)] = 25357,
  [SMALL_STATE(668)] = 25370,
  [SMALL_STATE(669)] = 25381,
  [SMALL_STATE(670)] = 25390,
  [SMALL_STATE(671)] = 25403,
  [SMALL_STATE(672)] = 25416,
  [SMALL_STATE(673)] = 25429,
  [SMALL_STATE(674)] = 25438,
  [SMALL_STATE(675)] = 25451,
  [SMALL_STATE(676)] = 25464,
  [SMALL_STATE(677)] = 25475,
  [SMALL_STATE(678)] = 25488,
  [SMALL_STATE(679)] = 25497,
  [SMALL_STATE(680)] = 25506,
  [SMALL_STATE(681)] = 25515,
  [SMALL_STATE(682)] = 25528,
  [SMALL_STATE(683)] = 25539,
  [SMALL_STATE(684)] = 25552,
  [SMALL_STATE(685)] = 25561,
  [SMALL_STATE(686)] = 25574,
  [SMALL_STATE(687)] = 25583,
  [SMALL_STATE(688)] = 25594,
  [SMALL_STATE(689)] = 25607,
  [SMALL_STATE(690)] = 25616,
  [SMALL_STATE(691)] = 25629,
  [SMALL_STATE(692)] = 25642,
  [SMALL_STATE(693)] = 25655,
  [SMALL_STATE(694)] = 25668,
  [SMALL_STATE(695)] = 25679,
  [SMALL_STATE(696)] = 25690,
  [SMALL_STATE(697)] = 25703,
  [SMALL_STATE(698)] = 25716,
  [SMALL_STATE(699)] = 25729,
  [SMALL_STATE(700)] = 25740,
  [SMALL_STATE(701)] = 25753,
  [SMALL_STATE(702)] = 25766,
  [SMALL_STATE(703)] = 25775,
  [SMALL_STATE(704)] = 25788,
  [SMALL_STATE(705)] = 25798,
  [SMALL_STATE(706)] = 25808,
  [SMALL_STATE(707)] = 25818,
  [SMALL_STATE(708)] = 25828,
  [SMALL_STATE(709)] = 25838,
  [SMALL_STATE(710)] = 25848,
  [SMALL_STATE(711)] = 25858,
  [SMALL_STATE(712)] = 25868,
  [SMALL_STATE(713)] = 25878,
  [SMALL_STATE(714)] = 25886,
  [SMALL_STATE(715)] = 25896,
  [SMALL_STATE(716)] = 25906,
  [SMALL_STATE(717)] = 25916,
  [SMALL_STATE(718)] = 25926,
  [SMALL_STATE(719)] = 25936,
  [SMALL_STATE(720)] = 25946,
  [SMALL_STATE(721)] = 25956,
  [SMALL_STATE(722)] = 25966,
  [SMALL_STATE(723)] = 25976,
  [SMALL_STATE(724)] = 25983,
  [SMALL_STATE(725)] = 25990,
  [SMALL_STATE(726)] = 25997,
  [SMALL_STATE(727)] = 26004,
  [SMALL_STATE(728)] = 26011,
  [SMALL_STATE(729)] = 26018,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(588),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(187),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(407),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(727),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(477),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(607),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(395),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(406),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(552),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(2),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(421),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [63] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_clause, 3, .production_id = 15),
  [65] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_clause, 4, .production_id = 15),
  [67] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(105),
  [70] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(6),
  [73] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(107),
  [76] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(588),
  [79] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(40),
  [82] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(187),
  [85] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2),
  [87] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(143),
  [90] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(118),
  [93] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(189),
  [96] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(406),
  [99] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(727),
  [102] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(102),
  [105] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(101),
  [108] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(7),
  [111] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(119),
  [114] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(108),
  [117] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(174),
  [120] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(477),
  [123] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(607),
  [126] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(146),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(409),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [135] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 2),
  [139] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [141] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 3),
  [143] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(10),
  [146] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(393),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(390),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(396),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(387),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [159] = {.entry = {.count = 1, .reusable = false}}, SHIFT(537),
  [161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(461),
  [165] = {.entry = {.count = 1, .reusable = false}}, SHIFT(373),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(623),
  [171] = {.entry = {.count = 1, .reusable = false}}, SHIFT(326),
  [173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(620),
  [175] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [177] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(594),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(328),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(596),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(549),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(331),
  [193] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [199] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [205] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [207] = {.entry = {.count = 1, .reusable = false}}, SHIFT(359),
  [209] = {.entry = {.count = 1, .reusable = false}}, SHIFT(240),
  [211] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [215] = {.entry = {.count = 1, .reusable = false}}, SHIFT(535),
  [217] = {.entry = {.count = 1, .reusable = false}}, SHIFT(376),
  [219] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [221] = {.entry = {.count = 1, .reusable = false}}, SHIFT(253),
  [223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(379),
  [225] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [227] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [229] = {.entry = {.count = 1, .reusable = false}}, SHIFT(330),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1),
  [233] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [235] = {.entry = {.count = 1, .reusable = false}}, SHIFT(546),
  [237] = {.entry = {.count = 1, .reusable = false}}, SHIFT(380),
  [239] = {.entry = {.count = 1, .reusable = false}}, SHIFT(260),
  [241] = {.entry = {.count = 1, .reusable = false}}, SHIFT(382),
  [243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [245] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [247] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(553),
  [251] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [253] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [255] = {.entry = {.count = 1, .reusable = false}}, SHIFT(464),
  [257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(378),
  [259] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [263] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [267] = {.entry = {.count = 1, .reusable = false}}, SHIFT(358),
  [269] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(533),
  [273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(375),
  [275] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [277] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [279] = {.entry = {.count = 1, .reusable = false}}, SHIFT(332),
  [281] = {.entry = {.count = 1, .reusable = false}}, SHIFT(303),
  [283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(327),
  [285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(680),
  [289] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [291] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [295] = {.entry = {.count = 1, .reusable = false}}, SHIFT(381),
  [297] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [299] = {.entry = {.count = 1, .reusable = false}}, SHIFT(467),
  [301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(364),
  [303] = {.entry = {.count = 1, .reusable = false}}, SHIFT(689),
  [305] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [307] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(369),
  [311] = {.entry = {.count = 1, .reusable = false}}, SHIFT(574),
  [313] = {.entry = {.count = 1, .reusable = false}}, SHIFT(365),
  [315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(455),
  [317] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [321] = {.entry = {.count = 1, .reusable = false}}, SHIFT(590),
  [323] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [325] = {.entry = {.count = 1, .reusable = false}}, SHIFT(50),
  [327] = {.entry = {.count = 1, .reusable = false}}, SHIFT(669),
  [329] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [331] = {.entry = {.count = 1, .reusable = false}}, SHIFT(580),
  [333] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [335] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [337] = {.entry = {.count = 1, .reusable = false}}, SHIFT(482),
  [339] = {.entry = {.count = 1, .reusable = false}}, SHIFT(371),
  [341] = {.entry = {.count = 1, .reusable = false}}, SHIFT(650),
  [343] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [345] = {.entry = {.count = 1, .reusable = false}}, SHIFT(481),
  [347] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [349] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [351] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [353] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [355] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [357] = {.entry = {.count = 1, .reusable = false}}, SHIFT(644),
  [359] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [361] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [363] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [365] = {.entry = {.count = 1, .reusable = false}}, SHIFT(605),
  [367] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [369] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [371] = {.entry = {.count = 1, .reusable = false}}, SHIFT(491),
  [373] = {.entry = {.count = 1, .reusable = false}}, SHIFT(329),
  [375] = {.entry = {.count = 1, .reusable = false}}, SHIFT(59),
  [377] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [379] = {.entry = {.count = 1, .reusable = false}}, SHIFT(370),
  [381] = {.entry = {.count = 1, .reusable = false}}, SHIFT(498),
  [383] = {.entry = {.count = 1, .reusable = false}}, SHIFT(333),
  [385] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [387] = {.entry = {.count = 1, .reusable = false}}, SHIFT(334),
  [389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [391] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [395] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [397] = {.entry = {.count = 1, .reusable = false}}, SHIFT(340),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [401] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [403] = {.entry = {.count = 1, .reusable = false}}, SHIFT(341),
  [405] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [407] = {.entry = {.count = 1, .reusable = false}}, SHIFT(335),
  [409] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [411] = {.entry = {.count = 1, .reusable = false}}, SHIFT(518),
  [413] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(523),
  [417] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [419] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [421] = {.entry = {.count = 1, .reusable = false}}, SHIFT(457),
  [423] = {.entry = {.count = 1, .reusable = false}}, SHIFT(383),
  [425] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [427] = {.entry = {.count = 1, .reusable = false}}, SHIFT(573),
  [429] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [431] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [433] = {.entry = {.count = 1, .reusable = false}}, SHIFT(434),
  [435] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [437] = {.entry = {.count = 1, .reusable = false}}, SHIFT(441),
  [439] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [441] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(323),
  [445] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(105),
  [448] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(71),
  [451] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(107),
  [454] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(588),
  [457] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(40),
  [460] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2),
  [462] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(187),
  [465] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(143),
  [468] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(118),
  [471] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(189),
  [474] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(386),
  [477] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(727),
  [480] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(102),
  [483] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(101),
  [486] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(7),
  [489] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(119),
  [492] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(108),
  [495] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(174),
  [498] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(477),
  [501] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(607),
  [504] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(146),
  [507] = {.entry = {.count = 1, .reusable = false}}, SHIFT(459),
  [509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [511] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [513] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [515] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2),
  [517] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(74),
  [520] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(407),
  [523] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_clause, 3),
  [525] = {.entry = {.count = 1, .reusable = false}}, SHIFT(408),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [529] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_clause, 4),
  [531] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(105),
  [534] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(107),
  [537] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(588),
  [540] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(40),
  [543] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(187),
  [546] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2),
  [548] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(143),
  [551] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(118),
  [554] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(189),
  [557] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(408),
  [560] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(727),
  [563] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(102),
  [566] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(101),
  [569] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(7),
  [572] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(119),
  [575] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(108),
  [578] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(174),
  [581] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(477),
  [584] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(607),
  [587] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(143),
  [590] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(146),
  [593] = {.entry = {.count = 1, .reusable = false}}, SHIFT(401),
  [595] = {.entry = {.count = 1, .reusable = false}}, SHIFT(388),
  [597] = {.entry = {.count = 1, .reusable = false}}, SHIFT(412),
  [599] = {.entry = {.count = 1, .reusable = false}}, SHIFT(405),
  [601] = {.entry = {.count = 1, .reusable = false}}, SHIFT(400),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(389),
  [605] = {.entry = {.count = 1, .reusable = false}}, SHIFT(398),
  [607] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [609] = {.entry = {.count = 1, .reusable = false}}, SHIFT(404),
  [611] = {.entry = {.count = 1, .reusable = false}}, SHIFT(384),
  [613] = {.entry = {.count = 1, .reusable = false}}, SHIFT(418),
  [615] = {.entry = {.count = 1, .reusable = false}}, SHIFT(417),
  [617] = {.entry = {.count = 1, .reusable = false}}, SHIFT(422),
  [619] = {.entry = {.count = 1, .reusable = false}}, SHIFT(423),
  [621] = {.entry = {.count = 1, .reusable = false}}, SHIFT(413),
  [623] = {.entry = {.count = 1, .reusable = false}}, SHIFT(402),
  [625] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(388),
  [628] = {.entry = {.count = 1, .reusable = false}}, SHIFT(419),
  [630] = {.entry = {.count = 1, .reusable = false}}, SHIFT(415),
  [632] = {.entry = {.count = 1, .reusable = false}}, SHIFT(416),
  [634] = {.entry = {.count = 1, .reusable = false}}, SHIFT(394),
  [636] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [638] = {.entry = {.count = 1, .reusable = false}}, SHIFT(392),
  [640] = {.entry = {.count = 1, .reusable = false}}, SHIFT(397),
  [642] = {.entry = {.count = 1, .reusable = false}}, SHIFT(403),
  [644] = {.entry = {.count = 1, .reusable = false}}, SHIFT(420),
  [646] = {.entry = {.count = 1, .reusable = false}}, SHIFT(366),
  [648] = {.entry = {.count = 1, .reusable = false}}, SHIFT(374),
  [650] = {.entry = {.count = 1, .reusable = false}}, SHIFT(363),
  [652] = {.entry = {.count = 1, .reusable = false}}, SHIFT(377),
  [654] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_test_command, 1),
  [656] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [658] = {.entry = {.count = 1, .reusable = false}}, SHIFT(568),
  [660] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [662] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [664] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [666] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [668] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [670] = {.entry = {.count = 1, .reusable = false}}, SHIFT(502),
  [672] = {.entry = {.count = 1, .reusable = false}}, SHIFT(615),
  [674] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [676] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__terminated_statement, 2),
  [678] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__terminated_opt_statement, 2),
  [680] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command, 2, .production_id = 4),
  [682] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 8),
  [684] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 8), SHIFT_REPEAT(588),
  [687] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 8), SHIFT_REPEAT(40),
  [690] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 8), SHIFT_REPEAT(143),
  [693] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 8), SHIFT_REPEAT(174),
  [696] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 8), SHIFT_REPEAT(477),
  [699] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 8), SHIFT_REPEAT(607),
  [702] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 8), SHIFT_REPEAT(146),
  [705] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command, 1, .production_id = 2),
  [707] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return, 1),
  [709] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [711] = {.entry = {.count = 1, .reusable = false}}, SHIFT(565),
  [713] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [715] = {.entry = {.count = 1, .reusable = false}}, SHIFT(440),
  [717] = {.entry = {.count = 1, .reusable = false}}, SHIFT(424),
  [719] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [721] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [723] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [725] = {.entry = {.count = 1, .reusable = false}}, SHIFT(475),
  [727] = {.entry = {.count = 1, .reusable = false}}, SHIFT(643),
  [729] = {.entry = {.count = 1, .reusable = false}}, SHIFT(437),
  [731] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__terminated_statement, 2),
  [733] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2),
  [735] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(593),
  [738] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(62),
  [741] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(211),
  [744] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(180),
  [747] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(501),
  [750] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(616),
  [753] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(212),
  [756] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [758] = {.entry = {.count = 1, .reusable = false}}, SHIFT(593),
  [760] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [762] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [764] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [766] = {.entry = {.count = 1, .reusable = false}}, SHIFT(501),
  [768] = {.entry = {.count = 1, .reusable = false}}, SHIFT(616),
  [770] = {.entry = {.count = 1, .reusable = false}}, SHIFT(212),
  [772] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 10),
  [774] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 10), SHIFT_REPEAT(593),
  [777] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 10), SHIFT_REPEAT(62),
  [780] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 10), SHIFT_REPEAT(211),
  [783] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 10), SHIFT_REPEAT(180),
  [786] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 10), SHIFT_REPEAT(501),
  [789] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 10), SHIFT_REPEAT(616),
  [792] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 10), SHIFT_REPEAT(212),
  [795] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [797] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [799] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [801] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [803] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [805] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [807] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [809] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [811] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [813] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [815] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [817] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 14),
  [819] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 14), SHIFT_REPEAT(593),
  [822] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 14), SHIFT_REPEAT(62),
  [825] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 14), SHIFT_REPEAT(211),
  [828] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 14), SHIFT_REPEAT(180),
  [831] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 14), SHIFT_REPEAT(501),
  [834] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 14), SHIFT_REPEAT(616),
  [837] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 14), SHIFT_REPEAT(212),
  [840] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_expansion, 2),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_expansion, 2),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(716),
  [846] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_variable_expansion_repeat1, 2),
  [848] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2),
  [850] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(716),
  [853] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_expansion, 3),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_expansion, 3),
  [857] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution_dollar, 5),
  [859] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution_dollar, 5),
  [861] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution_dollar, 3),
  [863] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution_dollar, 3),
  [865] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [869] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2),
  [871] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(203),
  [874] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_element_access, 3),
  [876] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_element_access, 3),
  [878] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1, .production_id = 1),
  [880] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_concatenation, 2),
  [882] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution_dollar, 4),
  [884] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution_dollar, 4),
  [886] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_element_access, 2),
  [888] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_element_access, 2),
  [890] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2),
  [892] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_double_quote_string, 2),
  [894] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_double_quote_string, 2),
  [896] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_single_quote_string, 2),
  [898] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_single_quote_string, 2),
  [900] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution, 1),
  [902] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution, 1),
  [904] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution_fish, 2),
  [906] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution_fish, 2),
  [908] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_double_quote_string, 3),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_double_quote_string, 3),
  [912] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_brace_expansion, 3),
  [914] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_brace_expansion, 3),
  [916] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_single_quote_string, 3),
  [918] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_single_quote_string, 3),
  [920] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_brace_expansion, 4),
  [922] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_brace_expansion, 4),
  [924] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution_fish, 3),
  [926] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution_fish, 3),
  [928] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution_fish, 4),
  [930] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution_fish, 4),
  [932] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_brace_expansion, 5),
  [934] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_brace_expansion, 5),
  [936] = {.entry = {.count = 1, .reusable = false}}, SHIFT(586),
  [938] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [940] = {.entry = {.count = 1, .reusable = false}}, SHIFT(609),
  [942] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [944] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [946] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_brace_expansion_repeat1, 1),
  [948] = {.entry = {.count = 1, .reusable = false}}, SHIFT(522),
  [950] = {.entry = {.count = 1, .reusable = false}}, SHIFT(606),
  [952] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 1, .production_id = 3),
  [954] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [956] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [958] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [962] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [964] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [966] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [968] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [970] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [972] = {.entry = {.count = 1, .reusable = false}}, SHIFT(569),
  [974] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [976] = {.entry = {.count = 1, .reusable = false}}, SHIFT(292),
  [978] = {.entry = {.count = 1, .reusable = false}}, SHIFT(175),
  [980] = {.entry = {.count = 1, .reusable = false}}, SHIFT(479),
  [982] = {.entry = {.count = 1, .reusable = false}}, SHIFT(610),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [986] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [988] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [990] = {.entry = {.count = 1, .reusable = false}}, SHIFT(567),
  [992] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [994] = {.entry = {.count = 1, .reusable = false}}, SHIFT(538),
  [996] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [998] = {.entry = {.count = 1, .reusable = false}}, SHIFT(504),
  [1000] = {.entry = {.count = 1, .reusable = false}}, SHIFT(634),
  [1002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [1004] = {.entry = {.count = 1, .reusable = false}}, SHIFT(543),
  [1006] = {.entry = {.count = 1, .reusable = false}}, SHIFT(560),
  [1008] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [1010] = {.entry = {.count = 1, .reusable = false}}, SHIFT(484),
  [1012] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [1014] = {.entry = {.count = 1, .reusable = false}}, SHIFT(524),
  [1016] = {.entry = {.count = 1, .reusable = false}}, SHIFT(638),
  [1018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1020] = {.entry = {.count = 1, .reusable = false}}, SHIFT(508),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(717),
  [1024] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(717),
  [1027] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1031] = {.entry = {.count = 1, .reusable = false}}, SHIFT(551),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [1035] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [1039] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [1041] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [1043] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1047] = {.entry = {.count = 1, .reusable = false}}, SHIFT(463),
  [1049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(714),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1055] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(714),
  [1058] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(204),
  [1061] = {.entry = {.count = 1, .reusable = false}}, SHIFT(599),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [1065] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(200),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1070] = {.entry = {.count = 1, .reusable = false}}, SHIFT(673),
  [1072] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 1, .production_id = 5),
  [1074] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 1, .production_id = 12),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1092] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(595),
  [1095] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(56),
  [1098] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(515),
  [1101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2),
  [1103] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(301),
  [1106] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(496),
  [1109] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(630),
  [1112] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(715),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(624),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(633),
  [1145] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__test_expression, 1),
  [1147] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(715),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1159] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(197),
  [1162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 1),
  [1164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 2),
  [1166] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negated_expression, 2),
  [1168] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [1170] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__parenthesized_test_expression, 3),
  [1172] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [1174] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3),
  [1176] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_test_command, 2),
  [1178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional_expression, 3),
  [1180] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [1182] = {.entry = {.count = 1, .reusable = false}}, SHIFT(414),
  [1184] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [1186] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [1188] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [1190] = {.entry = {.count = 1, .reusable = false}}, SHIFT(480),
  [1192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(153),
  [1194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(445),
  [1196] = {.entry = {.count = 1, .reusable = false}}, SHIFT(600),
  [1198] = {.entry = {.count = 1, .reusable = false}}, SHIFT(302),
  [1200] = {.entry = {.count = 1, .reusable = false}}, SHIFT(514),
  [1202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [1204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(238),
  [1206] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [1208] = {.entry = {.count = 1, .reusable = false}}, SHIFT(642),
  [1210] = {.entry = {.count = 1, .reusable = false}}, SHIFT(306),
  [1212] = {.entry = {.count = 1, .reusable = false}}, SHIFT(226),
  [1214] = {.entry = {.count = 1, .reusable = false}}, SHIFT(521),
  [1216] = {.entry = {.count = 1, .reusable = false}}, SHIFT(554),
  [1218] = {.entry = {.count = 1, .reusable = false}}, SHIFT(653),
  [1220] = {.entry = {.count = 1, .reusable = false}}, SHIFT(566),
  [1222] = {.entry = {.count = 1, .reusable = false}}, SHIFT(460),
  [1224] = {.entry = {.count = 1, .reusable = false}}, SHIFT(619),
  [1226] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [1228] = {.entry = {.count = 1, .reusable = false}}, SHIFT(246),
  [1230] = {.entry = {.count = 1, .reusable = false}}, SHIFT(473),
  [1232] = {.entry = {.count = 1, .reusable = false}}, SHIFT(666),
  [1234] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [1236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional_execution, 3),
  [1238] = {.entry = {.count = 1, .reusable = false}}, SHIFT(575),
  [1240] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pipe, 3),
  [1242] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [1244] = {.entry = {.count = 1, .reusable = false}}, SHIFT(536),
  [1246] = {.entry = {.count = 1, .reusable = false}}, SHIFT(470),
  [1248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional_execution, 2),
  [1250] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negated_statement, 2),
  [1252] = {.entry = {.count = 1, .reusable = false}}, SHIFT(555),
  [1254] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [1256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 5, .production_id = 13),
  [1258] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 3, .production_id = 7),
  [1260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [1262] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 6, .production_id = 16),
  [1264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 4, .production_id = 7),
  [1266] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return, 2),
  [1268] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 7, .production_id = 16),
  [1270] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [1272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4, .production_id = 7),
  [1274] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_begin_statement, 3),
  [1276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 5, .production_id = 9),
  [1278] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [1280] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [1282] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [1284] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [1286] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_begin_statement, 2),
  [1288] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_file_redirect, 2, .production_id = 6),
  [1290] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_statement, 4, .production_id = 11),
  [1292] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_redirected_statement, 2),
  [1294] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 6, .production_id = 13),
  [1296] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [1298] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 3, .production_id = 7),
  [1300] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 4, .production_id = 9),
  [1302] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 7),
  [1304] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_test_command, 3),
  [1306] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 7),
  [1308] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_statement, 5, .production_id = 11),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(720),
  [1312] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(720),
  [1315] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(719),
  [1318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1, .production_id = 1),
  [1320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1322] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(205),
  [1325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [1327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_concatenation, 2),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(719),
  [1331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(722),
  [1333] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(722),
  [1336] = {.entry = {.count = 1, .reusable = false}}, SHIFT(603),
  [1338] = {.entry = {.count = 1, .reusable = false}}, SHIFT(458),
  [1340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1342] = {.entry = {.count = 1, .reusable = false}}, SHIFT(490),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(711),
  [1346] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1350] = {.entry = {.count = 1, .reusable = false}}, SHIFT(487),
  [1352] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(711),
  [1355] = {.entry = {.count = 1, .reusable = false}}, SHIFT(311),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1359] = {.entry = {.count = 1, .reusable = false}}, SHIFT(492),
  [1361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__test_expression, 1),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1367] = {.entry = {.count = 1, .reusable = false}}, SHIFT(190),
  [1369] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [1371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [1373] = {.entry = {.count = 1, .reusable = false}}, SHIFT(503),
  [1375] = {.entry = {.count = 1, .reusable = false}}, SHIFT(157),
  [1377] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(199),
  [1380] = {.entry = {.count = 1, .reusable = false}}, SHIFT(472),
  [1382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [1384] = {.entry = {.count = 1, .reusable = false}}, SHIFT(577),
  [1386] = {.entry = {.count = 1, .reusable = false}}, SHIFT(494),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [1390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(505),
  [1392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(486),
  [1398] = {.entry = {.count = 1, .reusable = false}}, SHIFT(254),
  [1400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1402] = {.entry = {.count = 1, .reusable = false}}, SHIFT(511),
  [1404] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_quote_string_repeat1, 2), SHIFT_REPEAT(603),
  [1407] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_double_quote_string_repeat1, 2),
  [1409] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_double_quote_string_repeat1, 2), SHIFT_REPEAT(503),
  [1412] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_quote_string_repeat1, 2), SHIFT_REPEAT(503),
  [1415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(587),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1419] = {.entry = {.count = 1, .reusable = false}}, SHIFT(495),
  [1421] = {.entry = {.count = 1, .reusable = false}}, SHIFT(499),
  [1423] = {.entry = {.count = 1, .reusable = false}}, SHIFT(529),
  [1425] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [1427] = {.entry = {.count = 1, .reusable = false}}, SHIFT(646),
  [1429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index, 1),
  [1431] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 3),
  [1433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 1),
  [1435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1437] = {.entry = {.count = 1, .reusable = false}}, SHIFT(684),
  [1439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1441] = {.entry = {.count = 1, .reusable = false}}, SHIFT(512),
  [1443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(542),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [1447] = {.entry = {.count = 1, .reusable = false}}, SHIFT(507),
  [1449] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(217),
  [1452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1454] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(710),
  [1457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(710),
  [1459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [1461] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [1463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [1479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [1483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [1491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(718),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [1537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [1539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [1541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [1567] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(718),
  [1570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [1574] = {.entry = {.count = 1, .reusable = false}}, SHIFT(612),
  [1576] = {.entry = {.count = 1, .reusable = false}}, SHIFT(686),
  [1578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(641),
  [1580] = {.entry = {.count = 1, .reusable = false}}, SHIFT(641),
  [1582] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [1584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [1586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(611),
  [1588] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [1590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [1592] = {.entry = {.count = 1, .reusable = false}}, SHIFT(621),
  [1594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__brace_expression, 1),
  [1596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1598] = {.entry = {.count = 1, .reusable = false}}, SHIFT(300),
  [1600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(617),
  [1602] = {.entry = {.count = 1, .reusable = false}}, SHIFT(617),
  [1604] = {.entry = {.count = 1, .reusable = false}}, SHIFT(159),
  [1606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [1608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_negated_expression, 2),
  [1612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1614] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [1616] = {.entry = {.count = 1, .reusable = false}}, SHIFT(255),
  [1618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(631),
  [1620] = {.entry = {.count = 1, .reusable = false}}, SHIFT(631),
  [1622] = {.entry = {.count = 1, .reusable = false}}, SHIFT(219),
  [1624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [1626] = {.entry = {.count = 1, .reusable = false}}, SHIFT(608),
  [1628] = {.entry = {.count = 1, .reusable = false}}, SHIFT(307),
  [1630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_brace_concatenation, 2),
  [1632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_single_quote_string_repeat1, 2),
  [1634] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_single_quote_string_repeat1, 2), SHIFT_REPEAT(621),
  [1637] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_single_quote_string_repeat1, 2), SHIFT_REPEAT(621),
  [1640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [1642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2),
  [1644] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2), SHIFT_REPEAT(726),
  [1647] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parenthesized_test_expression, 3),
  [1649] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional_expression, 3),
  [1651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3),
  [1653] = {.entry = {.count = 1, .reusable = false}}, SHIFT(572),
  [1655] = {.entry = {.count = 1, .reusable = false}}, SHIFT(497),
  [1657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(635),
  [1659] = {.entry = {.count = 1, .reusable = false}}, SHIFT(635),
  [1661] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [1663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_brace_concatenation_repeat1, 2),
  [1665] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_brace_concatenation_repeat1, 2), SHIFT_REPEAT(230),
  [1668] = {.entry = {.count = 1, .reusable = false}}, SHIFT(585),
  [1670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(629),
  [1672] = {.entry = {.count = 1, .reusable = false}}, SHIFT(629),
  [1674] = {.entry = {.count = 1, .reusable = false}}, SHIFT(500),
  [1676] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2),
  [1678] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2), SHIFT_REPEAT(182),
  [1681] = {.entry = {.count = 1, .reusable = false}}, SHIFT(545),
  [1683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(640),
  [1685] = {.entry = {.count = 1, .reusable = false}}, SHIFT(640),
  [1687] = {.entry = {.count = 1, .reusable = false}}, SHIFT(474),
  [1689] = {.entry = {.count = 1, .reusable = false}}, SHIFT(525),
  [1691] = {.entry = {.count = 1, .reusable = false}}, SHIFT(660),
  [1693] = {.entry = {.count = 1, .reusable = false}}, SHIFT(453),
  [1695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(639),
  [1697] = {.entry = {.count = 1, .reusable = false}}, SHIFT(639),
  [1699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [1703] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_brace_expansion_repeat1, 2),
  [1705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(702),
  [1707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__base_brace_expression, 1),
  [1709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [1723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [1725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(679),
  [1731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [1733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [1735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1743] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_brace_expansion_repeat1, 2), SHIFT_REPEAT(178),
  [1746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [1750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [1752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(626),
  [1754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [1758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [1762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [1770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [1774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [1778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [1780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [1782] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(729),
  [1790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_fish_external_scanner_create(void);
void tree_sitter_fish_external_scanner_destroy(void *);
bool tree_sitter_fish_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_fish_external_scanner_serialize(void *, char *);
void tree_sitter_fish_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_fish(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_fish_external_scanner_create,
      tree_sitter_fish_external_scanner_destroy,
      tree_sitter_fish_external_scanner_scan,
      tree_sitter_fish_external_scanner_serialize,
      tree_sitter_fish_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
