#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 5237
#define LARGE_STATE_COUNT 2353
#define SYMBOL_COUNT 179
#define ALIAS_COUNT 1
#define TOKEN_COUNT 87
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 7
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 24

enum {
  sym_identifier = 1,
  anon_sym_function = 2,
  anon_sym_end = 3,
  anon_sym_abstract = 4,
  anon_sym_type = 5,
  anon_sym_primitive = 6,
  aux_sym_primitive_definition_token1 = 7,
  anon_sym_mutable = 8,
  anon_sym_struct = 9,
  anon_sym_module = 10,
  anon_sym_macro = 11,
  anon_sym_LPAREN = 12,
  anon_sym_COMMA = 13,
  anon_sym_RPAREN = 14,
  anon_sym_SEMI = 15,
  anon_sym_EQ = 16,
  anon_sym_DOT_DOT_DOT = 17,
  anon_sym_COLON_COLON = 18,
  anon_sym_LBRACE = 19,
  anon_sym_RBRACE = 20,
  anon_sym_LT_COLON = 21,
  anon_sym_if = 22,
  anon_sym_elseif = 23,
  anon_sym_else = 24,
  anon_sym_try = 25,
  anon_sym_catch = 26,
  anon_sym_finally = 27,
  anon_sym_for = 28,
  anon_sym_while = 29,
  sym_break_statement = 30,
  sym_continue_statement = 31,
  anon_sym_return = 32,
  anon_sym_let = 33,
  anon_sym_const = 34,
  anon_sym_quote = 35,
  anon_sym_using = 36,
  anon_sym_import = 37,
  anon_sym_COLON = 38,
  anon_sym_DOT = 39,
  anon_sym_export = 40,
  anon_sym_COLON2 = 41,
  anon_sym_PLUS = 42,
  anon_sym_LBRACK = 43,
  anon_sym_RBRACK = 44,
  anon_sym_begin = 45,
  anon_sym_do = 46,
  anon_sym_GT_COLON = 47,
  anon_sym_DASH = 48,
  anon_sym_BANG = 49,
  anon_sym_TILDE = 50,
  anon_sym_ = 51,
  anon_sym_2 = 52,
  anon_sym_3 = 53,
  anon_sym_4 = 54,
  anon_sym_SQUOTE = 55,
  anon_sym_DOT_SQUOTE = 56,
  anon_sym_LT_PIPE = 57,
  anon_sym_PIPE_GT = 58,
  anon_sym_in = 59,
  anon_sym_isa = 60,
  anon_sym_PIPE_PIPE = 61,
  anon_sym_AMP_AMP = 62,
  anon_sym_QMARK = 63,
  anon_sym_EQ_GT = 64,
  anon_sym_LBRACK2 = 65,
  anon_sym_5 = 66,
  anon_sym_DASH_GT = 67,
  anon_sym_DOLLAR = 68,
  anon_sym_AT = 69,
  sym_number = 70,
  anon_sym_DQUOTE = 71,
  anon_sym_DQUOTE2 = 72,
  aux_sym_string_token1 = 73,
  sym_command_string = 74,
  sym_character = 75,
  sym__power_operator = 76,
  sym__times_operator = 77,
  sym__plus_operator = 78,
  sym__arrow_operator = 79,
  sym__comparison_operator = 80,
  sym__assign_operator = 81,
  anon_sym_LF = 82,
  sym_comment = 83,
  sym_block_comment = 84,
  sym_triple_string = 85,
  sym__immediate_paren = 86,
  sym_source_file = 87,
  sym__expression_list = 88,
  sym_function_definition = 89,
  sym_abstract_definition = 90,
  sym_primitive_definition = 91,
  sym_struct_definition = 92,
  sym_module_definition = 93,
  sym_macro_definition = 94,
  sym_parameter_list = 95,
  sym_keyword_parameters = 96,
  sym_optional_parameter = 97,
  sym_spread_parameter = 98,
  sym_typed_parameter = 99,
  sym_type_parameter_list = 100,
  sym_constrained_parameter = 101,
  sym_subtype_clause = 102,
  sym_if_statement = 103,
  sym_elseif_clause = 104,
  sym_else_clause = 105,
  sym_try_statement = 106,
  sym_catch_clause = 107,
  sym_finally_clause = 108,
  sym_for_statement = 109,
  sym_while_statement = 110,
  sym_return_statement = 111,
  sym_let_statement = 112,
  sym_const_statement = 113,
  sym_variable_declaration = 114,
  sym_quote_statement = 115,
  sym_import_statement = 116,
  sym_selected_import = 117,
  sym_scoped_identifier = 118,
  sym_export_statement = 119,
  sym__expression = 120,
  sym__primary_expression = 121,
  sym_bare_tuple_expression = 122,
  sym_operator = 123,
  sym_parenthesized_expression = 124,
  sym_field_expression = 125,
  sym_subscript_expression = 126,
  sym_typed_expression = 127,
  sym_parameterized_identifier = 128,
  sym_type_argument_list = 129,
  sym_compound_expression = 130,
  sym_call_expression = 131,
  sym_broadcast_call_expression = 132,
  sym_macro_expression = 133,
  sym_macro_argument_list = 134,
  sym_argument_list = 135,
  sym_do_clause = 136,
  sym_named_field = 137,
  sym_spread_expression = 138,
  sym_assignment_expression = 139,
  sym_unary_expression = 140,
  sym_binary_expression = 141,
  sym_ternary_expression = 142,
  sym_pair_expression = 143,
  sym_tuple_expression = 144,
  sym_array_expression = 145,
  sym_matrix_expression = 146,
  sym_matrix_row = 147,
  sym_generator_expression = 148,
  sym_array_comprehension_expression = 149,
  sym__comprehension_clause = 150,
  sym_if_clause = 151,
  sym_for_clause = 152,
  sym_for_binding = 153,
  sym_function_expression = 154,
  sym_range_expression = 155,
  sym_coefficient_expression = 156,
  sym_quote_expression = 157,
  sym_interpolation_expression = 158,
  sym_macro_identifier = 159,
  sym_string = 160,
  aux_sym__expression_list_repeat1 = 161,
  aux_sym_parameter_list_repeat1 = 162,
  aux_sym_type_parameter_list_repeat1 = 163,
  aux_sym_if_statement_repeat1 = 164,
  aux_sym_for_statement_repeat1 = 165,
  aux_sym_let_statement_repeat1 = 166,
  aux_sym_import_statement_repeat1 = 167,
  aux_sym_selected_import_repeat1 = 168,
  aux_sym_export_statement_repeat1 = 169,
  aux_sym_bare_tuple_expression_repeat1 = 170,
  aux_sym_subscript_expression_repeat1 = 171,
  aux_sym_type_argument_list_repeat1 = 172,
  aux_sym_macro_argument_list_repeat1 = 173,
  aux_sym_argument_list_repeat1 = 174,
  aux_sym_argument_list_repeat2 = 175,
  aux_sym_tuple_expression_repeat1 = 176,
  aux_sym_matrix_expression_repeat1 = 177,
  aux_sym__comprehension_clause_repeat1 = 178,
  alias_sym_named_argument = 179,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_function] = "function",
  [anon_sym_end] = "end",
  [anon_sym_abstract] = "abstract",
  [anon_sym_type] = "type",
  [anon_sym_primitive] = "primitive",
  [aux_sym_primitive_definition_token1] = "number",
  [anon_sym_mutable] = "mutable",
  [anon_sym_struct] = "struct",
  [anon_sym_module] = "module",
  [anon_sym_macro] = "macro",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI] = ";",
  [anon_sym_EQ] = "=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LT_COLON] = "<:",
  [anon_sym_if] = "if",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_for] = "for",
  [anon_sym_while] = "while",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [anon_sym_return] = "return",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_quote] = "quote",
  [anon_sym_using] = "using",
  [anon_sym_import] = "import",
  [anon_sym_COLON] = ":",
  [anon_sym_DOT] = ".",
  [anon_sym_export] = "export",
  [anon_sym_COLON2] = ":",
  [anon_sym_PLUS] = "+",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_begin] = "begin",
  [anon_sym_do] = "do",
  [anon_sym_GT_COLON] = ">:",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_] = "¬",
  [anon_sym_2] = "√",
  [anon_sym_3] = "∛",
  [anon_sym_4] = "∜",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DOT_SQUOTE] = ".'",
  [anon_sym_LT_PIPE] = "<|",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_in] = "in",
  [anon_sym_isa] = "isa",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_QMARK] = "\?",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_LBRACK2] = "[",
  [anon_sym_5] = "∈",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_AT] = "@",
  [sym_number] = "number",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE2] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [sym_command_string] = "command_string",
  [sym_character] = "character",
  [sym__power_operator] = "_power_operator",
  [sym__times_operator] = "_times_operator",
  [sym__plus_operator] = "_plus_operator",
  [sym__arrow_operator] = "_arrow_operator",
  [sym__comparison_operator] = "_comparison_operator",
  [sym__assign_operator] = "_assign_operator",
  [anon_sym_LF] = "\n",
  [sym_comment] = "comment",
  [sym_block_comment] = "block_comment",
  [sym_triple_string] = "triple_string",
  [sym__immediate_paren] = "_immediate_paren",
  [sym_source_file] = "source_file",
  [sym__expression_list] = "_expression_list",
  [sym_function_definition] = "function_definition",
  [sym_abstract_definition] = "abstract_definition",
  [sym_primitive_definition] = "primitive_definition",
  [sym_struct_definition] = "struct_definition",
  [sym_module_definition] = "module_definition",
  [sym_macro_definition] = "macro_definition",
  [sym_parameter_list] = "parameter_list",
  [sym_keyword_parameters] = "keyword_parameters",
  [sym_optional_parameter] = "optional_parameter",
  [sym_spread_parameter] = "spread_parameter",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type_parameter_list] = "type_parameter_list",
  [sym_constrained_parameter] = "constrained_parameter",
  [sym_subtype_clause] = "subtype_clause",
  [sym_if_statement] = "if_statement",
  [sym_elseif_clause] = "elseif_clause",
  [sym_else_clause] = "else_clause",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_return_statement] = "return_statement",
  [sym_let_statement] = "let_statement",
  [sym_const_statement] = "const_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_quote_statement] = "quote_statement",
  [sym_import_statement] = "import_statement",
  [sym_selected_import] = "selected_import",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_export_statement] = "export_statement",
  [sym__expression] = "_expression",
  [sym__primary_expression] = "_primary_expression",
  [sym_bare_tuple_expression] = "bare_tuple_expression",
  [sym_operator] = "operator",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_field_expression] = "field_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_typed_expression] = "typed_expression",
  [sym_parameterized_identifier] = "parameterized_identifier",
  [sym_type_argument_list] = "type_argument_list",
  [sym_compound_expression] = "compound_expression",
  [sym_call_expression] = "call_expression",
  [sym_broadcast_call_expression] = "broadcast_call_expression",
  [sym_macro_expression] = "macro_expression",
  [sym_macro_argument_list] = "macro_argument_list",
  [sym_argument_list] = "argument_list",
  [sym_do_clause] = "do_clause",
  [sym_named_field] = "named_field",
  [sym_spread_expression] = "spread_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_pair_expression] = "pair_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_array_expression] = "array_expression",
  [sym_matrix_expression] = "matrix_expression",
  [sym_matrix_row] = "matrix_row",
  [sym_generator_expression] = "generator_expression",
  [sym_array_comprehension_expression] = "array_comprehension_expression",
  [sym__comprehension_clause] = "_comprehension_clause",
  [sym_if_clause] = "if_clause",
  [sym_for_clause] = "for_clause",
  [sym_for_binding] = "for_binding",
  [sym_function_expression] = "function_expression",
  [sym_range_expression] = "range_expression",
  [sym_coefficient_expression] = "coefficient_expression",
  [sym_quote_expression] = "quote_expression",
  [sym_interpolation_expression] = "interpolation_expression",
  [sym_macro_identifier] = "macro_identifier",
  [sym_string] = "string",
  [aux_sym__expression_list_repeat1] = "_expression_list_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_type_parameter_list_repeat1] = "type_parameter_list_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_let_statement_repeat1] = "let_statement_repeat1",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [aux_sym_selected_import_repeat1] = "selected_import_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_bare_tuple_expression_repeat1] = "bare_tuple_expression_repeat1",
  [aux_sym_subscript_expression_repeat1] = "subscript_expression_repeat1",
  [aux_sym_type_argument_list_repeat1] = "type_argument_list_repeat1",
  [aux_sym_macro_argument_list_repeat1] = "macro_argument_list_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_argument_list_repeat2] = "argument_list_repeat2",
  [aux_sym_tuple_expression_repeat1] = "tuple_expression_repeat1",
  [aux_sym_matrix_expression_repeat1] = "matrix_expression_repeat1",
  [aux_sym__comprehension_clause_repeat1] = "_comprehension_clause_repeat1",
  [alias_sym_named_argument] = "named_argument",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_primitive] = anon_sym_primitive,
  [aux_sym_primitive_definition_token1] = sym_number,
  [anon_sym_mutable] = anon_sym_mutable,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_macro] = anon_sym_macro,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LT_COLON] = anon_sym_LT_COLON,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_while] = anon_sym_while,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_quote] = anon_sym_quote,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_COLON2] = anon_sym_COLON,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_begin] = anon_sym_begin,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_GT_COLON] = anon_sym_GT_COLON,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_] = anon_sym_,
  [anon_sym_2] = anon_sym_2,
  [anon_sym_3] = anon_sym_3,
  [anon_sym_4] = anon_sym_4,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DOT_SQUOTE] = anon_sym_DOT_SQUOTE,
  [anon_sym_LT_PIPE] = anon_sym_LT_PIPE,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_isa] = anon_sym_isa,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_LBRACK2] = anon_sym_LBRACK,
  [anon_sym_5] = anon_sym_5,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [sym_number] = sym_number,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [sym_command_string] = sym_command_string,
  [sym_character] = sym_character,
  [sym__power_operator] = sym__power_operator,
  [sym__times_operator] = sym__times_operator,
  [sym__plus_operator] = sym__plus_operator,
  [sym__arrow_operator] = sym__arrow_operator,
  [sym__comparison_operator] = sym__comparison_operator,
  [sym__assign_operator] = sym__assign_operator,
  [anon_sym_LF] = anon_sym_LF,
  [sym_comment] = sym_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_triple_string] = sym_triple_string,
  [sym__immediate_paren] = sym__immediate_paren,
  [sym_source_file] = sym_source_file,
  [sym__expression_list] = sym__expression_list,
  [sym_function_definition] = sym_function_definition,
  [sym_abstract_definition] = sym_abstract_definition,
  [sym_primitive_definition] = sym_primitive_definition,
  [sym_struct_definition] = sym_struct_definition,
  [sym_module_definition] = sym_module_definition,
  [sym_macro_definition] = sym_macro_definition,
  [sym_parameter_list] = sym_parameter_list,
  [sym_keyword_parameters] = sym_keyword_parameters,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym_spread_parameter] = sym_spread_parameter,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type_parameter_list] = sym_type_parameter_list,
  [sym_constrained_parameter] = sym_constrained_parameter,
  [sym_subtype_clause] = sym_subtype_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif_clause] = sym_elseif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_let_statement] = sym_let_statement,
  [sym_const_statement] = sym_const_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_quote_statement] = sym_quote_statement,
  [sym_import_statement] = sym_import_statement,
  [sym_selected_import] = sym_selected_import,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_export_statement] = sym_export_statement,
  [sym__expression] = sym__expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym_bare_tuple_expression] = sym_bare_tuple_expression,
  [sym_operator] = sym_operator,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_field_expression] = sym_field_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_typed_expression] = sym_typed_expression,
  [sym_parameterized_identifier] = sym_parameterized_identifier,
  [sym_type_argument_list] = sym_type_argument_list,
  [sym_compound_expression] = sym_compound_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_broadcast_call_expression] = sym_broadcast_call_expression,
  [sym_macro_expression] = sym_macro_expression,
  [sym_macro_argument_list] = sym_macro_argument_list,
  [sym_argument_list] = sym_argument_list,
  [sym_do_clause] = sym_do_clause,
  [sym_named_field] = sym_named_field,
  [sym_spread_expression] = sym_spread_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_pair_expression] = sym_pair_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_array_expression] = sym_array_expression,
  [sym_matrix_expression] = sym_matrix_expression,
  [sym_matrix_row] = sym_matrix_row,
  [sym_generator_expression] = sym_generator_expression,
  [sym_array_comprehension_expression] = sym_array_comprehension_expression,
  [sym__comprehension_clause] = sym__comprehension_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_for_clause] = sym_for_clause,
  [sym_for_binding] = sym_for_binding,
  [sym_function_expression] = sym_function_expression,
  [sym_range_expression] = sym_range_expression,
  [sym_coefficient_expression] = sym_coefficient_expression,
  [sym_quote_expression] = sym_quote_expression,
  [sym_interpolation_expression] = sym_interpolation_expression,
  [sym_macro_identifier] = sym_macro_identifier,
  [sym_string] = sym_string,
  [aux_sym__expression_list_repeat1] = aux_sym__expression_list_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_type_parameter_list_repeat1] = aux_sym_type_parameter_list_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_let_statement_repeat1] = aux_sym_let_statement_repeat1,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [aux_sym_selected_import_repeat1] = aux_sym_selected_import_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_bare_tuple_expression_repeat1] = aux_sym_bare_tuple_expression_repeat1,
  [aux_sym_subscript_expression_repeat1] = aux_sym_subscript_expression_repeat1,
  [aux_sym_type_argument_list_repeat1] = aux_sym_type_argument_list_repeat1,
  [aux_sym_macro_argument_list_repeat1] = aux_sym_macro_argument_list_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_argument_list_repeat2] = aux_sym_argument_list_repeat2,
  [aux_sym_tuple_expression_repeat1] = aux_sym_tuple_expression_repeat1,
  [aux_sym_matrix_expression_repeat1] = aux_sym_matrix_expression_repeat1,
  [aux_sym__comprehension_clause_repeat1] = aux_sym__comprehension_clause_repeat1,
  [alias_sym_named_argument] = alias_sym_named_argument,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_primitive] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_primitive_definition_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_mutable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_macro] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_quote] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_isa] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_command_string] = {
    .visible = true,
    .named = true,
  },
  [sym_character] = {
    .visible = true,
    .named = true,
  },
  [sym__power_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__times_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__plus_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__arrow_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__comparison_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__assign_operator] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_triple_string] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_paren] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_list] = {
    .visible = false,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_module_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_subtype_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_let_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_const_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_quote_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_selected_import] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_bare_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parameterized_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_broadcast_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_do_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_named_field] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_matrix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_matrix_row] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_comprehension_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_coefficient_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_quote_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_selected_import_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bare_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_macro_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_matrix_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_named_argument] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_condition = 2,
  field_name = 3,
  field_parameters = 4,
  field_prefix = 5,
  field_type_parameters = 6,
  field_value = 7,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_condition] = "condition",
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_prefix] = "prefix",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 2},
  [7] = {.index = 5, .length = 1},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 2},
  [10] = {.index = 10, .length = 3},
  [11] = {.index = 13, .length = 2},
  [12] = {.index = 15, .length = 2},
  [13] = {.index = 17, .length = 3},
  [15] = {.index = 20, .length = 2},
  [16] = {.index = 22, .length = 2},
  [17] = {.index = 24, .length = 3},
  [19] = {.index = 27, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
  [1] =
    {field_condition, 1},
  [2] =
    {field_prefix, 0},
  [3] =
    {field_name, 1},
    {field_parameters, 2},
  [5] =
    {field_name, 2},
  [6] =
    {field_name, 1},
    {field_type_parameters, 2},
  [8] =
    {field_alternative, 2},
    {field_condition, 1},
  [10] =
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [13] =
    {field_name, 2},
    {field_type_parameters, 3},
  [15] =
    {field_alternative, 3},
    {field_condition, 1},
  [17] =
    {field_alternative, 2},
    {field_alternative, 3},
    {field_condition, 1},
  [20] =
    {field_name, 0},
    {field_value, 2},
  [22] =
    {field_alternative, 4},
    {field_condition, 1},
  [24] =
    {field_alternative, 3},
    {field_alternative, 4},
    {field_condition, 1},
  [27] =
    {field_alternative, 4},
    {field_alternative, 5},
    {field_condition, 1},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_operator,
  },
  [2] = {
    [1] = sym_operator,
  },
  [14] = {
    [1] = alias_sym_named_argument,
  },
  [18] = {
    [2] = alias_sym_named_argument,
  },
  [20] = {
    [3] = alias_sym_named_argument,
  },
  [21] = {
    [1] = alias_sym_named_argument,
    [3] = alias_sym_named_argument,
  },
  [22] = {
    [4] = alias_sym_named_argument,
  },
  [23] = {
    [1] = alias_sym_named_argument,
    [4] = alias_sym_named_argument,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  sym_named_field, 2,
    sym_named_field,
    alias_sym_named_argument,
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 8862
    ? (c < 8640
      ? (c < 215
        ? (c < '$'
          ? (c < '\r'
            ? (c < '\t'
              ? c == 0
              : c <= '\n')
            : (c <= '\r' || (c < '"'
              ? c == ' '
              : c <= '"')))
          : (c <= '/' || (c < '{'
            ? (c < '['
              ? (c >= ':' && c <= '>')
              : c <= '^')
            : (c <= '}' || c == 177))))
        : (c <= 215 || (c < 8610
          ? (c < 8592
            ? (c < 8523
              ? c == 247
              : c <= 8523)
            : (c <= 8596 || (c < 8608
              ? (c >= 8602 && c <= 8606)
              : c <= 8608)))
          : (c <= 8612 || (c < 8622
            ? (c < 8617
              ? c == 8614
              : c <= 8620)
            : (c <= 8622 || (c >= 8636 && c <= 8637)))))))
      : (c <= 8641 || (c < 8712
        ? (c < 8660
          ? (c < 8649
            ? (c < 8646
              ? c == 8644
              : c <= 8647)
            : (c <= 8649 || (c < 8658
              ? (c >= 8651 && c <= 8656)
              : c <= 8658)))
          : (c <= 8660 || (c < 8674
            ? (c < 8672
              ? (c >= 8666 && c <= 8669)
              : c <= 8672)
            : (c <= 8674 || (c >= 8692 && c <= 8703)))))
        : (c <= 8717 || (c < 8759
          ? (c < 8733
            ? (c < 8727
              ? (c >= 8723 && c <= 8724)
              : c <= 8729)
            : (c <= 8733 || (c >= 8740 && c <= 8746)))
          : (c <= 8760 || (c < 8768
            ? (c < 8765
              ? (c >= 8762 && c <= 8763)
              : c <= 8766)
            : (c <= 8843 || (c >= 8845 && c <= 8860)))))))))
    : (c <= 8867 || (c < 10684
      ? (c < 10178
        ? (c < 8900
          ? (c < 8878
            ? (c < 8876
              ? c == 8873
              : c <= 8876)
            : (c <= 8878 || (c < 8891
              ? (c >= 8880 && c <= 8887)
              : c <= 8893)))
          : (c <= 8903 || (c < 8946
            ? (c < 8917
              ? (c >= 8905 && c <= 8915)
              : c <= 8941)
            : (c <= 8959 || c == 9655))))
        : (c <= 10178 || (c < 10233
          ? (c < 10197
            ? (c < 10193
              ? (c >= 10184 && c <= 10185)
              : c <= 10194)
            : (c <= 10199 || (c < 10229
              ? (c >= 10224 && c <= 10225)
              : c <= 10231)))
          : (c <= 10239 || (c < 10564
            ? (c < 10525
              ? (c >= 10496 && c <= 10520)
              : c <= 10528)
            : (c <= 10608 || (c >= 10679 && c <= 10680)))))))
      : (c <= 10684 || (c < 10816
        ? (c < 10746
          ? (c < 10723
            ? (c < 10721
              ? (c >= 10686 && c <= 10689)
              : c <= 10721)
            : (c <= 10725 || (c < 10742
              ? c == 10740
              : c <= 10743)))
          : (c <= 10747 || (c < 10786
            ? (c < 10781
              ? (c >= 10759 && c <= 10760)
              : c <= 10781)
            : (c <= 10798 || (c >= 10800 && c <= 10813)))))
        : (c <= 10821 || (c < 10971
          ? (c < 10854
            ? (c < 10842
              ? (c >= 10826 && c <= 10840)
              : c <= 10851)
            : (c <= 10855 || (c >= 10858 && c <= 10969)))
          : (c <= 10971 || (c < 11079
            ? (c < 11056
              ? (c >= 10999 && c <= 11002)
              : c <= 11076)
            : (c <= 11084 || (c >= 65513 && c <= 65516)))))))))));
}

static inline bool sym__power_operator_character_set_1(int32_t c) {
  return (c < 10577
    ? (c < 10504
      ? (c < 8595
        ? (c < 8593
          ? c == '^'
          : c <= 8593)
        : (c <= 8595 || (c < 10224
          ? c == 8693
          : c <= 10225)))
      : (c <= 10507 || (c < 10572
        ? (c < 10569
          ? (c >= 10514 && c <= 10515)
          : c <= 10569)
        : (c <= 10573 || c == 10575))))
    : (c <= 10577 || (c < 10595
      ? (c < 10588
        ? (c < 10584
          ? (c >= 10580 && c <= 10581)
          : c <= 10585)
        : (c <= 10589 || (c >= 10592 && c <= 10593)))
      : (c <= 10595 || (c < 65514
        ? (c < 10606
          ? c == 10597
          : c <= 10607)
        : (c <= 65514 || c == 65516))))));
}

static inline bool sym__times_operator_character_set_1(int32_t c) {
  return (c < 10680
    ? (c < 8855
      ? (c < 8743
        ? (c < 8523
          ? (c < 215
            ? c == '\\'
            : c <= 215)
          : (c <= 8523 || (c < 8740
            ? (c >= 8727 && c <= 8729)
            : c <= 8740)))
        : (c <= 8743 || (c < 8845
          ? (c < 8768
            ? c == 8745
            : c <= 8768)
          : (c <= 8845 || c == 8851))))
      : (c <= 8859 || (c < 8911
        ? (c < 8900
          ? (c < 8892
            ? (c >= 8864 && c <= 8865)
            : c <= 8892)
          : (c <= 8903 || (c >= 8905 && c <= 8908)))
        : (c <= 8911 || (c < 10193
          ? (c < 9655
            ? c == 8914
            : c <= 9655)
          : (c <= 10193 || (c >= 10197 && c <= 10199)))))))
    : (c <= 10680 || (c < 10827
      ? (c < 10781
        ? (c < 10742
          ? (c < 10686
            ? c == 10684
            : c <= 10687)
          : (c <= 10743 || c == 10759))
        : (c <= 10781 || (c < 10816
          ? (c < 10811
            ? (c >= 10800 && c <= 10808)
            : c <= 10813)
          : (c <= 10816 || (c >= 10819 && c <= 10820)))))
      : (c <= 10827 || (c < 10840
        ? (c < 10835
          ? (c < 10833
            ? (c >= 10829 && c <= 10830)
            : c <= 10833)
          : (c <= 10835 || c == 10837))
        : (c <= 10840 || (c < 10846
          ? (c < 10844
            ? c == 10842
            : c <= 10844)
          : (c <= 10848 || c == 10971))))))));
}

static inline bool sym__times_operator_character_set_2(int32_t c) {
  return (c < 10193
    ? (c < 8768
      ? (c < 247
        ? (c < '/'
          ? (c < '*'
            ? c == '%'
            : c <= '*')
          : (c <= '/' || (c < 215
            ? c == '\\'
            : c <= 215)))
        : (c <= 247 || (c < 8740
          ? (c < 8727
            ? c == 8523
            : c <= 8729)
          : (c <= 8740 || (c < 8745
            ? c == 8743
            : c <= 8745)))))
      : (c <= 8768 || (c < 8900
        ? (c < 8855
          ? (c < 8851
            ? c == 8845
            : c <= 8851)
          : (c <= 8859 || (c < 8892
            ? (c >= 8864 && c <= 8865)
            : c <= 8892)))
        : (c <= 8903 || (c < 8914
          ? (c < 8911
            ? (c >= 8905 && c <= 8908)
            : c <= 8911)
          : (c <= 8914 || c == 9655))))))
    : (c <= 10193 || (c < 10819
      ? (c < 10759
        ? (c < 10684
          ? (c < 10680
            ? (c >= 10197 && c <= 10199)
            : c <= 10680)
          : (c <= 10684 || (c < 10742
            ? (c >= 10686 && c <= 10687)
            : c <= 10743)))
        : (c <= 10759 || (c < 10811
          ? (c < 10800
            ? c == 10781
            : c <= 10808)
          : (c <= 10813 || c == 10816))))
      : (c <= 10820 || (c < 10840
        ? (c < 10833
          ? (c < 10829
            ? c == 10827
            : c <= 10830)
          : (c <= 10833 || (c < 10837
            ? c == 10835
            : c <= 10837)))
        : (c <= 10840 || (c < 10846
          ? (c < 10844
            ? c == 10842
            : c <= 10844)
          : (c <= 10848 || c == 10971))))))));
}

static inline bool sym__times_operator_character_set_3(int32_t c) {
  return (c < 10193
    ? (c < 8768
      ? (c < 247
        ? (c < '/'
          ? (c < '*'
            ? (c >= '%' && c <= '&')
            : c <= '*')
          : (c <= '/' || (c < 215
            ? c == '\\'
            : c <= 215)))
        : (c <= 247 || (c < 8740
          ? (c < 8727
            ? c == 8523
            : c <= 8729)
          : (c <= 8740 || (c < 8745
            ? c == 8743
            : c <= 8745)))))
      : (c <= 8768 || (c < 8900
        ? (c < 8855
          ? (c < 8851
            ? c == 8845
            : c <= 8851)
          : (c <= 8859 || (c < 8892
            ? (c >= 8864 && c <= 8865)
            : c <= 8892)))
        : (c <= 8903 || (c < 8914
          ? (c < 8911
            ? (c >= 8905 && c <= 8908)
            : c <= 8911)
          : (c <= 8914 || c == 9655))))))
    : (c <= 10193 || (c < 10819
      ? (c < 10759
        ? (c < 10684
          ? (c < 10680
            ? (c >= 10197 && c <= 10199)
            : c <= 10680)
          : (c <= 10684 || (c < 10742
            ? (c >= 10686 && c <= 10687)
            : c <= 10743)))
        : (c <= 10759 || (c < 10811
          ? (c < 10800
            ? c == 10781
            : c <= 10808)
          : (c <= 10813 || c == 10816))))
      : (c <= 10820 || (c < 10840
        ? (c < 10833
          ? (c < 10829
            ? c == 10827
            : c <= 10830)
          : (c <= 10833 || (c < 10837
            ? c == 10835
            : c <= 10837)))
        : (c <= 10840 || (c < 10846
          ? (c < 10844
            ? c == 10842
            : c <= 10844)
          : (c <= 10848 || c == 10971))))))));
}

static inline bool sym__times_operator_character_set_4(int32_t c) {
  return (c < 8905
    ? (c < 8740
      ? (c < 215
        ? (c < '/'
          ? (c < '*'
            ? c == '%'
            : c <= '*')
          : (c <= '/' || c == '\\'))
        : (c <= 215 || (c < 8523
          ? c == 247
          : (c <= 8523 || (c >= 8727 && c <= 8729)))))
      : (c <= 8740 || (c < 8851
        ? (c < 8768
          ? (c >= 8743 && c <= 8745)
          : (c <= 8768 || c == 8845))
        : (c <= 8859 || (c < 8892
          ? (c >= 8864 && c <= 8865)
          : (c <= 8892 || (c >= 8900 && c <= 8903)))))))
    : (c <= 8908 || (c < 10742
      ? (c < 10197
        ? (c < 9655
          ? (c < 8914
            ? c == 8911
            : c <= 8914)
          : (c <= 9655 || c == 10193))
        : (c <= 10199 || (c < 10684
          ? c == 10680
          : (c <= 10684 || (c >= 10686 && c <= 10687)))))
      : (c <= 10743 || (c < 10816
        ? (c < 10781
          ? c == 10759
          : (c <= 10781 || (c >= 10800 && c <= 10813)))
        : (c <= 10820 || (c < 10842
          ? (c >= 10827 && c <= 10840)
          : (c <= 10848 || c == 10971))))))));
}

static inline bool sym__times_operator_character_set_5(int32_t c) {
  return (c < 8905
    ? (c < 8740
      ? (c < 215
        ? (c < '/'
          ? (c < '*'
            ? (c >= '%' && c <= '&')
            : c <= '*')
          : (c <= '/' || c == '\\'))
        : (c <= 215 || (c < 8523
          ? c == 247
          : (c <= 8523 || (c >= 8727 && c <= 8729)))))
      : (c <= 8740 || (c < 8851
        ? (c < 8768
          ? (c >= 8743 && c <= 8745)
          : (c <= 8768 || c == 8845))
        : (c <= 8859 || (c < 8892
          ? (c >= 8864 && c <= 8865)
          : (c <= 8892 || (c >= 8900 && c <= 8903)))))))
    : (c <= 8908 || (c < 10742
      ? (c < 10197
        ? (c < 9655
          ? (c < 8914
            ? c == 8911
            : c <= 8914)
          : (c <= 9655 || c == 10193))
        : (c <= 10199 || (c < 10684
          ? c == 10680
          : (c <= 10684 || (c >= 10686 && c <= 10687)))))
      : (c <= 10743 || (c < 10816
        ? (c < 10781
          ? c == 10759
          : (c <= 10781 || (c >= 10800 && c <= 10813)))
        : (c <= 10820 || (c < 10842
          ? (c >= 10827 && c <= 10840)
          : (c <= 10848 || c == 10971))))))));
}

static inline bool sym__plus_operator_character_set_1(int32_t c) {
  return (c < 8910
    ? (c < 8783
      ? (c < 8744
        ? (c < 8723
          ? c == 177
          : c <= 8724)
        : (c <= 8746 || c == 8760))
      : (c <= 8783 || (c < 8862
        ? (c < 8852
          ? c == 8846
          : c <= 8854)
        : (c <= 8863 || c == 8893))))
    : (c <= 8910 || (c < 10809
      ? (c < 10760
        ? (c < 10746
          ? c == 8915
          : c <= 10747)
        : (c <= 10760 || (c >= 10786 && c <= 10798)))
      : (c <= 10810 || (c < 10826
        ? (c >= 10817 && c <= 10821)
        : (c <= 10839 || (c >= 10843 && c <= 10851)))))));
}

static inline bool sym__plus_operator_character_set_2(int32_t c) {
  return (c < 8910
    ? (c < 8783
      ? (c < 8744
        ? (c < 8723
          ? c == 177
          : c <= 8724)
        : (c <= 8746 || c == 8760))
      : (c <= 8783 || (c < 8862
        ? (c < 8852
          ? c == 8846
          : c <= 8854)
        : (c <= 8863 || (c >= 8891 && c <= 8893)))))
    : (c <= 8910 || (c < 10809
      ? (c < 10760
        ? (c < 10746
          ? c == 8915
          : c <= 10747)
        : (c <= 10760 || (c >= 10786 && c <= 10798)))
      : (c <= 10810 || (c < 10826
        ? (c >= 10817 && c <= 10821)
        : (c <= 10839 || (c >= 10843 && c <= 10851)))))));
}

static inline bool sym__plus_operator_character_set_3(int32_t c) {
  return (c < 8891
    ? (c < 8770
      ? (c < 8744
        ? (c < 8723
          ? c == 177
          : c <= 8724)
        : (c <= 8746 || c == 8760))
      : (c <= 8770 || (c < 8852
        ? (c < 8846
          ? c == 8783
          : c <= 8846)
        : (c <= 8854 || (c >= 8862 && c <= 8863)))))
    : (c <= 8893 || (c < 10786
      ? (c < 10746
        ? (c < 8915
          ? c == 8910
          : c <= 8915)
        : (c <= 10747 || c == 10760))
      : (c <= 10798 || (c < 10826
        ? (c < 10817
          ? (c >= 10809 && c <= 10810)
          : c <= 10821)
        : (c <= 10839 || (c >= 10843 && c <= 10851)))))));
}

static inline bool sym__plus_operator_character_set_4(int32_t c) {
  return (c < 10746
    ? (c < 8846
      ? (c < 8744
        ? (c < 177
          ? c == '$'
          : (c <= 177 || (c >= 8723 && c <= 8724)))
        : (c <= 8744 || (c < 8760
          ? c == 8746
          : (c <= 8760 || c == 8783))))
      : (c <= 8846 || (c < 8893
        ? (c < 8862
          ? (c >= 8852 && c <= 8854)
          : (c <= 8863 || c == 8891))
        : (c <= 8893 || (c < 8915
          ? c == 8910
          : c <= 8915)))))
    : (c <= 10747 || (c < 10831
      ? (c < 10817
        ? (c < 10786
          ? c == 10760
          : (c <= 10798 || (c >= 10809 && c <= 10810)))
        : (c <= 10818 || (c < 10826
          ? c == 10821
          : (c <= 10826 || c == 10828))))
      : (c <= 10832 || (c < 10843
        ? (c < 10836
          ? c == 10834
          : (c <= 10836 || (c >= 10838 && c <= 10839)))
        : (c <= 10843 || (c < 10849
          ? c == 10845
          : c <= 10851)))))));
}

static inline bool sym__plus_operator_character_set_5(int32_t c) {
  return (c < 8891
    ? (c < 8760
      ? (c < 177
        ? (c < '-'
          ? c == '+'
          : c <= '-')
        : (c <= 177 || (c < 8744
          ? (c >= 8723 && c <= 8724)
          : c <= 8746)))
      : (c <= 8760 || (c < 8852
        ? (c < 8846
          ? c == 8783
          : c <= 8846)
        : (c <= 8854 || (c >= 8862 && c <= 8863)))))
    : (c <= 8893 || (c < 10786
      ? (c < 10746
        ? (c < 8915
          ? c == 8910
          : c <= 8915)
        : (c <= 10747 || c == 10760))
      : (c <= 10798 || (c < 10826
        ? (c < 10817
          ? (c >= 10809 && c <= 10810)
          : c <= 10821)
        : (c <= 10839 || (c >= 10843 && c <= 10851)))))));
}

static inline bool sym__plus_operator_character_set_6(int32_t c) {
  return (c < 8915
    ? (c < 8770
      ? (c < 8723
        ? (c < '-'
          ? c == '$'
          : (c <= '-' || c == 177))
        : (c <= 8724 || (c < 8746
          ? c == 8744
          : (c <= 8746 || c == 8760))))
      : (c <= 8770 || (c < 8862
        ? (c < 8846
          ? c == 8783
          : (c <= 8846 || (c >= 8852 && c <= 8854)))
        : (c <= 8863 || (c < 8893
          ? c == 8891
          : (c <= 8893 || c == 8910))))))
    : (c <= 8915 || (c < 10828
      ? (c < 10809
        ? (c < 10760
          ? (c >= 10746 && c <= 10747)
          : (c <= 10760 || (c >= 10786 && c <= 10798)))
        : (c <= 10810 || (c < 10821
          ? (c >= 10817 && c <= 10818)
          : (c <= 10821 || c == 10826))))
      : (c <= 10828 || (c < 10838
        ? (c < 10834
          ? (c >= 10831 && c <= 10832)
          : (c <= 10834 || c == 10836))
        : (c <= 10839 || (c < 10845
          ? c == 10843
          : (c <= 10845 || (c >= 10849 && c <= 10851)))))))));
}

static inline bool sym__plus_operator_character_set_7(int32_t c) {
  return (c < 8862
    ? (c < 8760
      ? (c < 177
        ? (c < '-'
          ? c == '+'
          : c <= '-')
        : (c <= 177 || (c < 8744
          ? (c >= 8723 && c <= 8724)
          : c <= 8746)))
      : (c <= 8760 || (c < 8846
        ? (c < 8783
          ? c == 8770
          : c <= 8783)
        : (c <= 8846 || (c >= 8852 && c <= 8854)))))
    : (c <= 8863 || (c < 10786
      ? (c < 8915
        ? (c < 8910
          ? (c >= 8891 && c <= 8893)
          : c <= 8910)
        : (c <= 8915 || (c < 10760
          ? (c >= 10746 && c <= 10747)
          : c <= 10760)))
      : (c <= 10798 || (c < 10826
        ? (c < 10817
          ? (c >= 10809 && c <= 10810)
          : c <= 10821)
        : (c <= 10839 || (c >= 10843 && c <= 10851)))))));
}

static inline bool sym__arrow_operator_character_set_1(int32_t c) {
  return (c < 10229
    ? (c < 8644
      ? (c < 8610
        ? (c < 8596
          ? (c < 8594
            ? c == 8592
            : c <= 8594)
          : (c <= 8596 || (c < 8608
            ? (c >= 8602 && c <= 8606)
            : c <= 8608)))
        : (c <= 8612 || (c < 8622
          ? (c < 8617
            ? c == 8614
            : c <= 8620)
          : (c <= 8622 || (c < 8640
            ? (c >= 8636 && c <= 8637)
            : c <= 8641)))))
      : (c <= 8644 || (c < 8666
        ? (c < 8651
          ? (c < 8649
            ? (c >= 8646 && c <= 8647)
            : c <= 8649)
          : (c <= 8656 || (c < 8660
            ? c == 8658
            : c <= 8660)))
        : (c <= 8669 || (c < 8692
          ? (c < 8674
            ? c == 8672
            : c <= 8674)
          : (c <= 8692 || (c >= 8694 && c <= 8703)))))))
    : (c <= 10231 || (c < 10586
      ? (c < 10564
        ? (c < 10508
          ? (c < 10496
            ? (c >= 10233 && c <= 10239)
            : c <= 10503)
          : (c <= 10513 || (c < 10525
            ? (c >= 10516 && c <= 10520)
            : c <= 10528)))
        : (c <= 10568 || (c < 10576
          ? (c < 10574
            ? (c >= 10570 && c <= 10571)
            : c <= 10574)
          : (c <= 10576 || (c < 10582
            ? (c >= 10578 && c <= 10579)
            : c <= 10583)))))
      : (c <= 10587 || (c < 10740
        ? (c < 10596
          ? (c < 10594
            ? (c >= 10590 && c <= 10591)
            : c <= 10594)
          : (c <= 10596 || (c < 10608
            ? (c >= 10598 && c <= 10605)
            : c <= 10608)))
        : (c <= 10740 || (c < 65513
          ? (c < 11079
            ? (c >= 11056 && c <= 11076)
            : c <= 11084)
          : (c <= 65513 || c == 65515))))))));
}

static inline bool sym__arrow_operator_character_set_2(int32_t c) {
  return (c < 8660
    ? (c < 8636
      ? (c < 8610
        ? (c < 8602
          ? (c >= 8592 && c <= 8596)
          : (c <= 8606 || c == 8608))
        : (c <= 8612 || (c < 8617
          ? c == 8614
          : (c <= 8620 || c == 8622))))
      : (c <= 8637 || (c < 8649
        ? (c < 8644
          ? (c >= 8640 && c <= 8641)
          : (c <= 8644 || (c >= 8646 && c <= 8647)))
        : (c <= 8649 || (c < 8658
          ? (c >= 8651 && c <= 8656)
          : c <= 8658)))))
    : (c <= 8660 || (c < 10496
      ? (c < 8692
        ? (c < 8672
          ? (c >= 8666 && c <= 8669)
          : (c <= 8672 || c == 8674))
        : (c <= 8703 || (c < 10233
          ? (c >= 10229 && c <= 10231)
          : c <= 10239)))
      : (c <= 10520 || (c < 11056
        ? (c < 10564
          ? (c >= 10525 && c <= 10528)
          : (c <= 10608 || c == 10740))
        : (c <= 11076 || (c < 65513
          ? (c >= 11079 && c <= 11084)
          : c <= 65515)))))));
}

static inline bool sym__comparison_operator_character_set_1(int32_t c) {
  return (c < 8880
    ? (c < 8771
      ? (c < 8759
        ? (c < 8733
          ? (c >= 8713 && c <= 8717)
          : (c <= 8733 || (c >= 8741 && c <= 8742)))
        : (c <= 8759 || (c < 8765
          ? (c >= 8762 && c <= 8763)
          : (c <= 8766 || c == 8769))))
      : (c <= 8787 || (c < 8873
        ? (c < 8847
          ? (c >= 8790 && c <= 8843)
          : (c <= 8860 || (c >= 8866 && c <= 8867)))
        : (c <= 8873 || (c < 8878
          ? c == 8876
          : c <= 8878)))))
    : (c <= 8887 || (c < 10688
      ? (c < 10178
        ? (c < 8917
          ? (c >= 8909 && c <= 8913)
          : (c <= 8941 || (c >= 8946 && c <= 8959)))
        : (c <= 10178 || (c < 10194
          ? (c >= 10184 && c <= 10185)
          : (c <= 10194 || c == 10679))))
      : (c <= 10689 || (c < 10858
        ? (c < 10723
          ? c == 10721
          : (c <= 10725 || (c >= 10854 && c <= 10855)))
        : (c <= 10867 || (c < 10999
          ? (c >= 10869 && c <= 10969)
          : c <= 11002)))))));
}

static inline bool sym__comparison_operator_character_set_2(int32_t c) {
  return (c < 8880
    ? (c < 8771
      ? (c < 8759
        ? (c < 8733
          ? (c >= 8712 && c <= 8717)
          : (c <= 8733 || (c >= 8741 && c <= 8742)))
        : (c <= 8759 || (c < 8765
          ? (c >= 8762 && c <= 8763)
          : (c <= 8766 || c == 8769))))
      : (c <= 8787 || (c < 8873
        ? (c < 8847
          ? (c >= 8790 && c <= 8843)
          : (c <= 8860 || (c >= 8866 && c <= 8867)))
        : (c <= 8873 || (c < 8878
          ? c == 8876
          : c <= 8878)))))
    : (c <= 8887 || (c < 10688
      ? (c < 10178
        ? (c < 8917
          ? (c >= 8909 && c <= 8913)
          : (c <= 8941 || (c >= 8946 && c <= 8959)))
        : (c <= 10178 || (c < 10194
          ? (c >= 10184 && c <= 10185)
          : (c <= 10194 || c == 10679))))
      : (c <= 10689 || (c < 10858
        ? (c < 10723
          ? c == 10721
          : (c <= 10725 || (c >= 10854 && c <= 10855)))
        : (c <= 10867 || (c < 10999
          ? (c >= 10869 && c <= 10969)
          : c <= 11002)))))));
}

static inline bool sym__comparison_operator_character_set_3(int32_t c) {
  return (c < 8880
    ? (c < 8769
      ? (c < 8759
        ? (c < 8733
          ? (c >= 8712 && c <= 8717)
          : (c <= 8733 || (c >= 8741 && c <= 8742)))
        : (c <= 8759 || (c < 8765
          ? (c >= 8762 && c <= 8763)
          : c <= 8766)))
      : (c <= 8769 || (c < 8873
        ? (c < 8847
          ? (c >= 8771 && c <= 8843)
          : (c <= 8860 || (c >= 8866 && c <= 8867)))
        : (c <= 8873 || (c < 8878
          ? c == 8876
          : c <= 8878)))))
    : (c <= 8887 || (c < 10679
      ? (c < 10178
        ? (c < 8917
          ? (c >= 8909 && c <= 8913)
          : (c <= 8941 || (c >= 8946 && c <= 8959)))
        : (c <= 10178 || (c < 10194
          ? (c >= 10184 && c <= 10185)
          : c <= 10194)))
      : (c <= 10679 || (c < 10854
        ? (c < 10721
          ? (c >= 10688 && c <= 10689)
          : (c <= 10721 || (c >= 10723 && c <= 10725)))
        : (c <= 10855 || (c < 10999
          ? (c >= 10858 && c <= 10969)
          : c <= 11002)))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(127);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(142);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (lookahead == 8712) ADVANCE(180);
      if (sym__comparison_operator_character_set_1(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(125)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(141);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(162);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == '\'') ADVANCE(95);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(157);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(149);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '>') ADVANCE(84);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(78);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_3(lookahead)) ADVANCE(208);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(71)
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '\\') ADVANCE(107);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(197);
      if (lookahead != 0) ADVANCE(198);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 16:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 17:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(39)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 18:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 19:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(47)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 20:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(142);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 25:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 26:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 27:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 28:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 29:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 30:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 31:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 32:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(142);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 33:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 34:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 35:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 36:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 37:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 38:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(39)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 39:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(39)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 40:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 41:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(141);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 42:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 43:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 44:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 45:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(45)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 46:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(47)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 47:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(47)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 48:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 49:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(141);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 50:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 51:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 52:
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(161);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(208);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 53:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(213);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(210);
      if (lookahead == '.') ADVANCE(144);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(223);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(57)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 54:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(213);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(211);
      if (lookahead == '.') ADVANCE(144);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(223);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(60)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 55:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (sym__plus_operator_character_set_4(lookahead)) ADVANCE(208);
      if (sym__times_operator_character_set_4(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(209);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(222);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '[') ADVANCE(154);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(61)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 56:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (sym__plus_operator_character_set_4(lookahead)) ADVANCE(208);
      if (sym__times_operator_character_set_4(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(212);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(222);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '[') ADVANCE(154);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 57:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(213);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(210);
      if (lookahead == '.') ADVANCE(144);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(223);
      if (lookahead == '?') ADVANCE(177);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(57)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 58:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(213);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(210);
      if (lookahead == '.') ADVANCE(144);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == ':') ADVANCE(142);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(223);
      if (lookahead == '?') ADVANCE(177);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(59)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 59:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(213);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(210);
      if (lookahead == '.') ADVANCE(144);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(223);
      if (lookahead == '?') ADVANCE(177);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(59)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 60:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(213);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(211);
      if (lookahead == '.') ADVANCE(144);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(223);
      if (lookahead == '?') ADVANCE(177);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(60)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 61:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(227);
      if (sym__plus_operator_character_set_4(lookahead)) ADVANCE(208);
      if (sym__times_operator_character_set_4(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(209);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(222);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(61)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 62:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(227);
      if (sym__plus_operator_character_set_4(lookahead)) ADVANCE(208);
      if (sym__times_operator_character_set_4(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(209);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(222);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(62)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 63:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(227);
      if (sym__plus_operator_character_set_4(lookahead)) ADVANCE(208);
      if (sym__times_operator_character_set_4(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(209);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == ':') ADVANCE(141);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(222);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(62)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 64:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(227);
      if (sym__plus_operator_character_set_4(lookahead)) ADVANCE(208);
      if (sym__times_operator_character_set_4(lookahead)) ADVANCE(203);
      if (lookahead == '&') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(212);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(218);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(222);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(139);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 65:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(207);
      if (lookahead == '\'') ADVANCE(171);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(213);
      if (lookahead == '-') ADVANCE(213);
      if (lookahead == '.') ADVANCE(80);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '<') ADVANCE(221);
      if (lookahead == '=') ADVANCE(225);
      if (lookahead == '>') ADVANCE(223);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '|') ADVANCE(77);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(190);
      END_STATE();
    case 66:
      if (lookahead == '!') ADVANCE(89);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == '\'') ADVANCE(171);
      if (sym__plus_operator_character_set_5(lookahead)) ADVANCE(208);
      if (lookahead == '.') ADVANCE(80);
      if (lookahead == '<') ADVANCE(222);
      if (lookahead == '=') ADVANCE(89);
      if (lookahead == '>') ADVANCE(222);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '|') ADVANCE(78);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(190);
      END_STATE();
    case 67:
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '.') ADVANCE(143);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '[') ADVANCE(154);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(70)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 68:
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (sym__plus_operator_character_set_6(lookahead)) ADVANCE(208);
      if (sym__times_operator_character_set_5(lookahead)) ADVANCE(203);
      if (lookahead == '\'') ADVANCE(95);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '.') ADVANCE(103);
      if (lookahead == ':') ADVANCE(82);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '[') ADVANCE(179);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 69:
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(87);
      if (lookahead == '%') ADVANCE(87);
      if (lookahead == '&') ADVANCE(87);
      if (lookahead == '*') ADVANCE(87);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == ':') ADVANCE(87);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '|') ADVANCE(93);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 247) ADVANCE(87);
      if (lookahead == 8891) ADVANCE(87);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(69)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 70:
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '.') ADVANCE(143);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(70)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 71:
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(71)
      END_STATE();
    case 72:
      if (lookahead == '#') ADVANCE(227);
      if (sym__plus_operator_character_set_6(lookahead)) ADVANCE(208);
      if (sym__times_operator_character_set_5(lookahead)) ADVANCE(203);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == '.') ADVANCE(148);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '|') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(72)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 73:
      if (lookahead == '%') ADVANCE(87);
      if (lookahead == '&') ADVANCE(87);
      if (lookahead == '*') ADVANCE(87);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '=' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '|') ADVANCE(93);
      if (lookahead == 247) ADVANCE(87);
      if (lookahead == 8891) ADVANCE(87);
      END_STATE();
    case 74:
      if (lookahead == '\'') ADVANCE(200);
      END_STATE();
    case 75:
      if (lookahead == '+') ADVANCE(79);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '>') ADVANCE(173);
      if (lookahead == '|') ADVANCE(174);
      END_STATE();
    case 76:
      if (lookahead == '+') ADVANCE(79);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '>') ADVANCE(173);
      if (lookahead == '|') ADVANCE(175);
      END_STATE();
    case 77:
      if (lookahead == '+') ADVANCE(79);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '|') ADVANCE(92);
      END_STATE();
    case 78:
      if (lookahead == '+') ADVANCE(79);
      if (lookahead == '|') ADVANCE(97);
      END_STATE();
    case 79:
      if (lookahead == '+') ADVANCE(97);
      END_STATE();
    case 80:
      if (lookahead == '.') ADVANCE(136);
      END_STATE();
    case 81:
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 82:
      if (lookahead == ':') ADVANCE(137);
      END_STATE();
    case 83:
      if (lookahead == ':') ADVANCE(140);
      END_STATE();
    case 84:
      if (lookahead == ':') ADVANCE(156);
      END_STATE();
    case 85:
      if (lookahead == ':') ADVANCE(98);
      END_STATE();
    case 86:
      if (lookahead == '<') ADVANCE(87);
      END_STATE();
    case 87:
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 88:
      if (lookahead == '=') ADVANCE(224);
      if (lookahead == '>') ADVANCE(87);
      END_STATE();
    case 89:
      if (lookahead == '=') ADVANCE(222);
      END_STATE();
    case 90:
      if (lookahead == '=') ADVANCE(222);
      if (lookahead == '>') ADVANCE(178);
      END_STATE();
    case 91:
      if (lookahead == '=') ADVANCE(99);
      END_STATE();
    case 92:
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '|') ADVANCE(208);
      END_STATE();
    case 93:
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '|') ADVANCE(91);
      END_STATE();
    case 94:
      if (lookahead == '>') ADVANCE(88);
      END_STATE();
    case 95:
      if (lookahead == '\\') ADVANCE(106);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(74);
      END_STATE();
    case 96:
      if (lookahead == '\\') ADVANCE(105);
      if (lookahead == '`') ADVANCE(199);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(96);
      END_STATE();
    case 97:
      if (lookahead == '|') ADVANCE(208);
      END_STATE();
    case 98:
      if (lookahead == '|') ADVANCE(216);
      END_STATE();
    case 99:
      if (lookahead == '|') ADVANCE(224);
      END_STATE();
    case 100:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 101:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 102:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(192);
      END_STATE();
    case 103:
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(203);
      if (sym__plus_operator_character_set_7(lookahead)) ADVANCE(208);
      if (lookahead == '.') ADVANCE(80);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '|') ADVANCE(78);
      END_STATE();
    case 104:
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(203);
      if (sym__plus_operator_character_set_7(lookahead)) ADVANCE(208);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '|') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(190);
      END_STATE();
    case 105:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(96);
      END_STATE();
    case 106:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(74);
      END_STATE();
    case 107:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(198);
      END_STATE();
    case 108:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(111)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 109:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(115)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 110:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(112)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 111:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(111)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 112:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(112)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 113:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(142);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(116)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 114:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(115)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 115:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(115)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 116:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(116)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 117:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(117)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 118:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(213);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(210);
      if (lookahead == '.') ADVANCE(144);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(223);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(120)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 119:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(195);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(213);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(211);
      if (lookahead == '.') ADVANCE(144);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(223);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '[') ADVANCE(154);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(123)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 120:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(213);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(210);
      if (lookahead == '.') ADVANCE(144);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(223);
      if (lookahead == '?') ADVANCE(177);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(120)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 121:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(213);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(210);
      if (lookahead == '.') ADVANCE(144);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == ':') ADVANCE(142);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(223);
      if (lookahead == '?') ADVANCE(177);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(122)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 122:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(213);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(210);
      if (lookahead == '.') ADVANCE(144);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(223);
      if (lookahead == '?') ADVANCE(177);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(122)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 123:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(213);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(211);
      if (lookahead == '.') ADVANCE(144);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(223);
      if (lookahead == '?') ADVANCE(177);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(123)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 124:
      if (eof) ADVANCE(127);
      if (lookahead == '\n') ADVANCE(226);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(87);
      if (lookahead == '%') ADVANCE(87);
      if (lookahead == '&') ADVANCE(87);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(87);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == ':') ADVANCE(87);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '|') ADVANCE(93);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 247) ADVANCE(87);
      if (lookahead == 8891) ADVANCE(87);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(124)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 125:
      if (eof) ADVANCE(127);
      if (lookahead == '!') ADVANCE(163);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(183);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(205);
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(153);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(217);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(220);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (lookahead == 8712) ADVANCE(180);
      if (sym__comparison_operator_character_set_1(lookahead)) ADVANCE(216);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(125)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 126:
      if (eof) ADVANCE(127);
      if (lookahead == '!') ADVANCE(162);
      if (lookahead == '"') ADVANCE(194);
      if (lookahead == '#') ADVANCE(227);
      if (lookahead == '$') ADVANCE(182);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == '\'') ADVANCE(95);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '+') ADVANCE(152);
      if (lookahead == ',') ADVANCE(131);
      if (lookahead == '-') ADVANCE(157);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == ':') ADVANCE(149);
      if (lookahead == ';') ADVANCE(133);
      if (lookahead == '<') ADVANCE(83);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '>') ADVANCE(84);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == '[') ADVANCE(179);
      if (lookahead == ']') ADVANCE(155);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '`') ADVANCE(96);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(78);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 172) ADVANCE(165);
      if (sym__plus_operator_character_set_3(lookahead)) ADVANCE(208);
      if (lookahead == 8712) ADVANCE(180);
      if (lookahead == 8730) ADVANCE(166);
      if (lookahead == 8731) ADVANCE(167);
      if (lookahead == 8732) ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(126)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'z') ||
          (256 <= lookahead && lookahead <= 383) ||
          (880 <= lookahead && lookahead <= 1023) ||
          lookahead == 8711) ADVANCE(185);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_primitive_definition_token1);
      if (lookahead == '.') ADVANCE(189);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym_primitive_definition_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(222);
      if (lookahead == '>') ADVANCE(178);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_LT_COLON);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(137);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(207);
      if (lookahead == '\'') ADVANCE(171);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(213);
      if (lookahead == '-') ADVANCE(213);
      if (lookahead == '.') ADVANCE(80);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '<') ADVANCE(221);
      if (lookahead == '=') ADVANCE(225);
      if (lookahead == '>') ADVANCE(223);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '|') ADVANCE(77);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '%') ADVANCE(207);
      if (lookahead == '&') ADVANCE(207);
      if (lookahead == '\'') ADVANCE(171);
      if (lookahead == '*') ADVANCE(207);
      if (lookahead == '+') ADVANCE(213);
      if (lookahead == '-') ADVANCE(213);
      if (lookahead == '.') ADVANCE(80);
      if (lookahead == '/') ADVANCE(206);
      if (lookahead == '<') ADVANCE(221);
      if (lookahead == '=') ADVANCE(225);
      if (lookahead == '>') ADVANCE(223);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == '^') ADVANCE(202);
      if (lookahead == '|') ADVANCE(77);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(208);
      if (lookahead == 247) ADVANCE(207);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(214);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(224);
      if (lookahead == 8891) ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(190);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '!') ADVANCE(89);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == '\'') ADVANCE(171);
      if (sym__plus_operator_character_set_5(lookahead)) ADVANCE(208);
      if (lookahead == '.') ADVANCE(80);
      if (lookahead == '<') ADVANCE(222);
      if (lookahead == '=') ADVANCE(89);
      if (lookahead == '>') ADVANCE(222);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '|') ADVANCE(78);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '!') ADVANCE(89);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == '\'') ADVANCE(171);
      if (sym__plus_operator_character_set_5(lookahead)) ADVANCE(208);
      if (lookahead == '.') ADVANCE(80);
      if (lookahead == '<') ADVANCE(222);
      if (lookahead == '=') ADVANCE(89);
      if (lookahead == '>') ADVANCE(222);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '|') ADVANCE(78);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(214);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(216);
      if (lookahead == 8770) ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(190);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(203);
      if (sym__plus_operator_character_set_7(lookahead)) ADVANCE(208);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(201);
      if (lookahead == '|') ADVANCE(78);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_COLON2);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_COLON2);
      if (lookahead == ':') ADVANCE(137);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_COLON2);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_GT_COLON);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(215);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '=') ADVANCE(224);
      if (lookahead == '>') ADVANCE(181);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '>') ADVANCE(181);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(222);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_2);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_3);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_4);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '\\') ADVANCE(106);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(74);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_DOT_SQUOTE);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_LT_PIPE);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      if (lookahead == ':') ADVANCE(98);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '|') ADVANCE(208);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '|') ADVANCE(208);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_LBRACK2);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_5);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_identifier);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(185);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(189);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(100);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(187);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(189);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(187);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(101);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(192);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(190);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(192);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '"') ADVANCE(227);
      if (lookahead == '\\') ADVANCE(228);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '\\') ADVANCE(107);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(198);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\\') ADVANCE(107);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_command_string);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_character);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym__power_operator);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym__power_operator);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym__times_operator);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym__times_operator);
      if (lookahead == '&') ADVANCE(176);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym__times_operator);
      if (lookahead == '&') ADVANCE(176);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym__times_operator);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym__times_operator);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym__plus_operator);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '-') ADVANCE(215);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '=') ADVANCE(224);
      if (lookahead == '>') ADVANCE(181);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '>') ADVANCE(181);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym__arrow_operator);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym__arrow_operator);
      if (lookahead == '>') ADVANCE(214);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym__comparison_operator);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == ':') ADVANCE(140);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(216);
      if (lookahead == '|') ADVANCE(172);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == ':') ADVANCE(140);
      if (lookahead == '=') ADVANCE(216);
      if (lookahead == '|') ADVANCE(172);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == ':') ADVANCE(156);
      if (lookahead == '=') ADVANCE(216);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == ':') ADVANCE(156);
      if (lookahead == '=') ADVANCE(216);
      if (lookahead == '>') ADVANCE(88);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(216);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == '=') ADVANCE(216);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == '=') ADVANCE(216);
      if (lookahead == '>') ADVANCE(88);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym__assign_operator);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym__assign_operator);
      if (lookahead == '=') ADVANCE(222);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(226);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(227);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(196);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'p') ADVANCE(10);
      if (lookahead == 'q') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'w') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(17);
      END_STATE();
    case 2:
      if (lookahead == 'e') ADVANCE(18);
      if (lookahead == 'r') ADVANCE(19);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(20);
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 4:
      if (lookahead == 'o') ADVANCE(22);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'x') ADVANCE(25);
      END_STATE();
    case 6:
      if (lookahead == 'i') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      if (lookahead == 'u') ADVANCE(28);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(29);
      if (lookahead == 'm') ADVANCE(30);
      if (lookahead == 'n') ADVANCE(31);
      if (lookahead == 's') ADVANCE(32);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'o') ADVANCE(35);
      if (lookahead == 'u') ADVANCE(36);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(37);
      END_STATE();
    case 11:
      if (lookahead == 'u') ADVANCE(38);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 13:
      if (lookahead == 't') ADVANCE(40);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(41);
      if (lookahead == 'y') ADVANCE(42);
      END_STATE();
    case 15:
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 16:
      if (lookahead == 'h') ADVANCE(44);
      END_STATE();
    case 17:
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 18:
      if (lookahead == 'g') ADVANCE(46);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 20:
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 21:
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 23:
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 24:
      if (lookahead == 'd') ADVANCE(51);
      END_STATE();
    case 25:
      if (lookahead == 'p') ADVANCE(52);
      END_STATE();
    case 26:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 27:
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 28:
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 30:
      if (lookahead == 'p') ADVANCE(56);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(57);
      END_STATE();
    case 33:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 34:
      if (lookahead == 'c') ADVANCE(59);
      END_STATE();
    case 35:
      if (lookahead == 'd') ADVANCE(60);
      END_STATE();
    case 36:
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 37:
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 39:
      if (lookahead == 't') ADVANCE(64);
      END_STATE();
    case 40:
      if (lookahead == 'r') ADVANCE(65);
      END_STATE();
    case 41:
      if (lookahead == 'y') ADVANCE(66);
      END_STATE();
    case 42:
      if (lookahead == 'p') ADVANCE(67);
      END_STATE();
    case 43:
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 44:
      if (lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(71);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(72);
      END_STATE();
    case 48:
      if (lookahead == 'c') ADVANCE(73);
      END_STATE();
    case 49:
      if (lookahead == 's') ADVANCE(74);
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(76);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 52:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 53:
      if (lookahead == 'a') ADVANCE(78);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 55:
      if (lookahead == 'c') ADVANCE(79);
      END_STATE();
    case 56:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_isa);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 60:
      if (lookahead == 'u') ADVANCE(82);
      END_STATE();
    case 61:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 62:
      if (lookahead == 'm') ADVANCE(84);
      END_STATE();
    case 63:
      if (lookahead == 't') ADVANCE(85);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(86);
      END_STATE();
    case 65:
      if (lookahead == 'u') ADVANCE(87);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 68:
      if (lookahead == 'n') ADVANCE(89);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(90);
      END_STATE();
    case 70:
      if (lookahead == 'r') ADVANCE(91);
      END_STATE();
    case 71:
      if (lookahead == 'n') ADVANCE(92);
      END_STATE();
    case 72:
      if (lookahead == 'k') ADVANCE(93);
      END_STATE();
    case 73:
      if (lookahead == 'h') ADVANCE(94);
      END_STATE();
    case 74:
      if (lookahead == 't') ADVANCE(95);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(96);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 77:
      if (lookahead == 'r') ADVANCE(98);
      END_STATE();
    case 78:
      if (lookahead == 'l') ADVANCE(99);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(100);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(101);
      END_STATE();
    case 81:
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(103);
      END_STATE();
    case 83:
      if (lookahead == 'b') ADVANCE(104);
      END_STATE();
    case 84:
      if (lookahead == 'i') ADVANCE(105);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 86:
      if (lookahead == 'r') ADVANCE(107);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(108);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 89:
      if (lookahead == 'g') ADVANCE(109);
      END_STATE();
    case 90:
      if (lookahead == 'e') ADVANCE(110);
      END_STATE();
    case 91:
      if (lookahead == 'a') ADVANCE(111);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_begin);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 96:
      if (lookahead == 'n') ADVANCE(112);
      END_STATE();
    case 97:
      if (lookahead == 'f') ADVANCE(113);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(114);
      END_STATE();
    case 99:
      if (lookahead == 'l') ADVANCE(115);
      END_STATE();
    case 100:
      if (lookahead == 'i') ADVANCE(116);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_macro);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(119);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_quote);
      END_STATE();
    case 107:
      if (lookahead == 'n') ADVANCE(121);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 111:
      if (lookahead == 'c') ADVANCE(123);
      END_STATE();
    case 112:
      if (lookahead == 'u') ADVANCE(124);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 115:
      if (lookahead == 'y') ADVANCE(125);
      END_STATE();
    case 116:
      if (lookahead == 'o') ADVANCE(126);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(128);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 126:
      if (lookahead == 'n') ADVANCE(131);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_mutable);
      END_STATE();
    case 128:
      if (lookahead == 'v') ADVANCE(132);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_continue_statement);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_primitive);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 126, .external_lex_state = 2},
  [2] = {.lex_state = 108, .external_lex_state = 1},
  [3] = {.lex_state = 117, .external_lex_state = 1},
  [4] = {.lex_state = 117, .external_lex_state = 1},
  [5] = {.lex_state = 114, .external_lex_state = 1},
  [6] = {.lex_state = 114, .external_lex_state = 1},
  [7] = {.lex_state = 117, .external_lex_state = 2},
  [8] = {.lex_state = 117, .external_lex_state = 2},
  [9] = {.lex_state = 117, .external_lex_state = 2},
  [10] = {.lex_state = 117, .external_lex_state = 2},
  [11] = {.lex_state = 117, .external_lex_state = 2},
  [12] = {.lex_state = 114, .external_lex_state = 1},
  [13] = {.lex_state = 114, .external_lex_state = 1},
  [14] = {.lex_state = 3, .external_lex_state = 2},
  [15] = {.lex_state = 3, .external_lex_state = 2},
  [16] = {.lex_state = 3, .external_lex_state = 2},
  [17] = {.lex_state = 25, .external_lex_state = 1},
  [18] = {.lex_state = 114, .external_lex_state = 1},
  [19] = {.lex_state = 117, .external_lex_state = 2},
  [20] = {.lex_state = 114, .external_lex_state = 1},
  [21] = {.lex_state = 3, .external_lex_state = 2},
  [22] = {.lex_state = 3, .external_lex_state = 2},
  [23] = {.lex_state = 3, .external_lex_state = 2},
  [24] = {.lex_state = 28, .external_lex_state = 1},
  [25] = {.lex_state = 3, .external_lex_state = 2},
  [26] = {.lex_state = 3, .external_lex_state = 2},
  [27] = {.lex_state = 3, .external_lex_state = 2},
  [28] = {.lex_state = 3, .external_lex_state = 2},
  [29] = {.lex_state = 28, .external_lex_state = 1},
  [30] = {.lex_state = 25, .external_lex_state = 1},
  [31] = {.lex_state = 37, .external_lex_state = 1},
  [32] = {.lex_state = 38, .external_lex_state = 1},
  [33] = {.lex_state = 28, .external_lex_state = 2},
  [34] = {.lex_state = 28, .external_lex_state = 2},
  [35] = {.lex_state = 28, .external_lex_state = 2},
  [36] = {.lex_state = 114, .external_lex_state = 1},
  [37] = {.lex_state = 38, .external_lex_state = 1},
  [38] = {.lex_state = 3, .external_lex_state = 1},
  [39] = {.lex_state = 4, .external_lex_state = 1},
  [40] = {.lex_state = 117, .external_lex_state = 1},
  [41] = {.lex_state = 28, .external_lex_state = 2},
  [42] = {.lex_state = 114, .external_lex_state = 1},
  [43] = {.lex_state = 37, .external_lex_state = 1},
  [44] = {.lex_state = 117, .external_lex_state = 1},
  [45] = {.lex_state = 3, .external_lex_state = 2},
  [46] = {.lex_state = 4, .external_lex_state = 1},
  [47] = {.lex_state = 3, .external_lex_state = 1},
  [48] = {.lex_state = 28, .external_lex_state = 2},
  [49] = {.lex_state = 117, .external_lex_state = 2},
  [50] = {.lex_state = 28, .external_lex_state = 2},
  [51] = {.lex_state = 37, .external_lex_state = 1},
  [52] = {.lex_state = 37, .external_lex_state = 2},
  [53] = {.lex_state = 33, .external_lex_state = 1},
  [54] = {.lex_state = 3, .external_lex_state = 2},
  [55] = {.lex_state = 117, .external_lex_state = 2},
  [56] = {.lex_state = 37, .external_lex_state = 2},
  [57] = {.lex_state = 117, .external_lex_state = 2},
  [58] = {.lex_state = 3, .external_lex_state = 2},
  [59] = {.lex_state = 37, .external_lex_state = 2},
  [60] = {.lex_state = 38, .external_lex_state = 1},
  [61] = {.lex_state = 33, .external_lex_state = 1},
  [62] = {.lex_state = 36, .external_lex_state = 1},
  [63] = {.lex_state = 36, .external_lex_state = 1},
  [64] = {.lex_state = 117, .external_lex_state = 2},
  [65] = {.lex_state = 117, .external_lex_state = 2},
  [66] = {.lex_state = 3, .external_lex_state = 2},
  [67] = {.lex_state = 37, .external_lex_state = 2},
  [68] = {.lex_state = 3, .external_lex_state = 2},
  [69] = {.lex_state = 117, .external_lex_state = 2},
  [70] = {.lex_state = 3, .external_lex_state = 2},
  [71] = {.lex_state = 3, .external_lex_state = 2},
  [72] = {.lex_state = 3, .external_lex_state = 2},
  [73] = {.lex_state = 3, .external_lex_state = 2},
  [74] = {.lex_state = 37, .external_lex_state = 1},
  [75] = {.lex_state = 3, .external_lex_state = 2},
  [76] = {.lex_state = 3, .external_lex_state = 2},
  [77] = {.lex_state = 3, .external_lex_state = 2},
  [78] = {.lex_state = 37, .external_lex_state = 2},
  [79] = {.lex_state = 3, .external_lex_state = 2},
  [80] = {.lex_state = 37, .external_lex_state = 2},
  [81] = {.lex_state = 3, .external_lex_state = 2},
  [82] = {.lex_state = 3, .external_lex_state = 2},
  [83] = {.lex_state = 117, .external_lex_state = 2},
  [84] = {.lex_state = 3, .external_lex_state = 2},
  [85] = {.lex_state = 38, .external_lex_state = 1},
  [86] = {.lex_state = 3, .external_lex_state = 2},
  [87] = {.lex_state = 46, .external_lex_state = 1},
  [88] = {.lex_state = 3, .external_lex_state = 2},
  [89] = {.lex_state = 46, .external_lex_state = 1},
  [90] = {.lex_state = 36, .external_lex_state = 2},
  [91] = {.lex_state = 36, .external_lex_state = 2},
  [92] = {.lex_state = 45, .external_lex_state = 1},
  [93] = {.lex_state = 36, .external_lex_state = 2},
  [94] = {.lex_state = 45, .external_lex_state = 1},
  [95] = {.lex_state = 36, .external_lex_state = 2},
  [96] = {.lex_state = 37, .external_lex_state = 2},
  [97] = {.lex_state = 37, .external_lex_state = 2},
  [98] = {.lex_state = 45, .external_lex_state = 1},
  [99] = {.lex_state = 37, .external_lex_state = 2},
  [100] = {.lex_state = 46, .external_lex_state = 1},
  [101] = {.lex_state = 36, .external_lex_state = 2},
  [102] = {.lex_state = 46, .external_lex_state = 1},
  [103] = {.lex_state = 45, .external_lex_state = 1},
  [104] = {.lex_state = 36, .external_lex_state = 2},
  [105] = {.lex_state = 45, .external_lex_state = 2},
  [106] = {.lex_state = 45, .external_lex_state = 2},
  [107] = {.lex_state = 45, .external_lex_state = 2},
  [108] = {.lex_state = 45, .external_lex_state = 2},
  [109] = {.lex_state = 37, .external_lex_state = 2},
  [110] = {.lex_state = 45, .external_lex_state = 2},
  [111] = {.lex_state = 45, .external_lex_state = 2},
  [112] = {.lex_state = 45, .external_lex_state = 2},
  [113] = {.lex_state = 45, .external_lex_state = 2},
  [114] = {.lex_state = 45, .external_lex_state = 2},
  [115] = {.lex_state = 45, .external_lex_state = 2},
  [116] = {.lex_state = 126, .external_lex_state = 2},
  [117] = {.lex_state = 126, .external_lex_state = 2},
  [118] = {.lex_state = 126, .external_lex_state = 2},
  [119] = {.lex_state = 126, .external_lex_state = 2},
  [120] = {.lex_state = 126, .external_lex_state = 2},
  [121] = {.lex_state = 126, .external_lex_state = 2},
  [122] = {.lex_state = 126, .external_lex_state = 2},
  [123] = {.lex_state = 126, .external_lex_state = 2},
  [124] = {.lex_state = 126, .external_lex_state = 2},
  [125] = {.lex_state = 126, .external_lex_state = 2},
  [126] = {.lex_state = 126, .external_lex_state = 2},
  [127] = {.lex_state = 126, .external_lex_state = 2},
  [128] = {.lex_state = 126, .external_lex_state = 2},
  [129] = {.lex_state = 126, .external_lex_state = 2},
  [130] = {.lex_state = 126, .external_lex_state = 2},
  [131] = {.lex_state = 126, .external_lex_state = 2},
  [132] = {.lex_state = 126, .external_lex_state = 2},
  [133] = {.lex_state = 126, .external_lex_state = 2},
  [134] = {.lex_state = 126, .external_lex_state = 2},
  [135] = {.lex_state = 126, .external_lex_state = 2},
  [136] = {.lex_state = 11, .external_lex_state = 2},
  [137] = {.lex_state = 11, .external_lex_state = 2},
  [138] = {.lex_state = 11, .external_lex_state = 2},
  [139] = {.lex_state = 126, .external_lex_state = 2},
  [140] = {.lex_state = 126, .external_lex_state = 2},
  [141] = {.lex_state = 126, .external_lex_state = 2},
  [142] = {.lex_state = 126, .external_lex_state = 2},
  [143] = {.lex_state = 11, .external_lex_state = 2},
  [144] = {.lex_state = 11, .external_lex_state = 2},
  [145] = {.lex_state = 11, .external_lex_state = 2},
  [146] = {.lex_state = 126, .external_lex_state = 2},
  [147] = {.lex_state = 11, .external_lex_state = 2},
  [148] = {.lex_state = 126, .external_lex_state = 2},
  [149] = {.lex_state = 126, .external_lex_state = 2},
  [150] = {.lex_state = 126, .external_lex_state = 2},
  [151] = {.lex_state = 126, .external_lex_state = 2},
  [152] = {.lex_state = 11, .external_lex_state = 2},
  [153] = {.lex_state = 126, .external_lex_state = 2},
  [154] = {.lex_state = 11, .external_lex_state = 2},
  [155] = {.lex_state = 11, .external_lex_state = 2},
  [156] = {.lex_state = 126, .external_lex_state = 2},
  [157] = {.lex_state = 11, .external_lex_state = 2},
  [158] = {.lex_state = 11, .external_lex_state = 2},
  [159] = {.lex_state = 126, .external_lex_state = 2},
  [160] = {.lex_state = 126, .external_lex_state = 2},
  [161] = {.lex_state = 11, .external_lex_state = 2},
  [162] = {.lex_state = 11, .external_lex_state = 2},
  [163] = {.lex_state = 126, .external_lex_state = 2},
  [164] = {.lex_state = 11, .external_lex_state = 2},
  [165] = {.lex_state = 126, .external_lex_state = 2},
  [166] = {.lex_state = 11, .external_lex_state = 2},
  [167] = {.lex_state = 11, .external_lex_state = 2},
  [168] = {.lex_state = 11, .external_lex_state = 2},
  [169] = {.lex_state = 126, .external_lex_state = 2},
  [170] = {.lex_state = 126, .external_lex_state = 2},
  [171] = {.lex_state = 126, .external_lex_state = 2},
  [172] = {.lex_state = 11, .external_lex_state = 2},
  [173] = {.lex_state = 11, .external_lex_state = 2},
  [174] = {.lex_state = 11, .external_lex_state = 2},
  [175] = {.lex_state = 11, .external_lex_state = 2},
  [176] = {.lex_state = 126, .external_lex_state = 2},
  [177] = {.lex_state = 11, .external_lex_state = 2},
  [178] = {.lex_state = 11, .external_lex_state = 2},
  [179] = {.lex_state = 126, .external_lex_state = 2},
  [180] = {.lex_state = 126, .external_lex_state = 2},
  [181] = {.lex_state = 126, .external_lex_state = 2},
  [182] = {.lex_state = 126, .external_lex_state = 2},
  [183] = {.lex_state = 11, .external_lex_state = 2},
  [184] = {.lex_state = 126, .external_lex_state = 2},
  [185] = {.lex_state = 126, .external_lex_state = 2},
  [186] = {.lex_state = 11, .external_lex_state = 2},
  [187] = {.lex_state = 11, .external_lex_state = 2},
  [188] = {.lex_state = 11, .external_lex_state = 2},
  [189] = {.lex_state = 126, .external_lex_state = 2},
  [190] = {.lex_state = 11, .external_lex_state = 2},
  [191] = {.lex_state = 11, .external_lex_state = 2},
  [192] = {.lex_state = 11, .external_lex_state = 2},
  [193] = {.lex_state = 11, .external_lex_state = 2},
  [194] = {.lex_state = 11, .external_lex_state = 2},
  [195] = {.lex_state = 11, .external_lex_state = 2},
  [196] = {.lex_state = 11, .external_lex_state = 2},
  [197] = {.lex_state = 126, .external_lex_state = 2},
  [198] = {.lex_state = 126, .external_lex_state = 2},
  [199] = {.lex_state = 126, .external_lex_state = 2},
  [200] = {.lex_state = 126, .external_lex_state = 2},
  [201] = {.lex_state = 126, .external_lex_state = 2},
  [202] = {.lex_state = 11, .external_lex_state = 2},
  [203] = {.lex_state = 11, .external_lex_state = 2},
  [204] = {.lex_state = 11, .external_lex_state = 2},
  [205] = {.lex_state = 11, .external_lex_state = 2},
  [206] = {.lex_state = 126, .external_lex_state = 2},
  [207] = {.lex_state = 11, .external_lex_state = 2},
  [208] = {.lex_state = 11, .external_lex_state = 2},
  [209] = {.lex_state = 126, .external_lex_state = 2},
  [210] = {.lex_state = 126, .external_lex_state = 2},
  [211] = {.lex_state = 126, .external_lex_state = 2},
  [212] = {.lex_state = 126, .external_lex_state = 2},
  [213] = {.lex_state = 126, .external_lex_state = 2},
  [214] = {.lex_state = 126, .external_lex_state = 2},
  [215] = {.lex_state = 126, .external_lex_state = 2},
  [216] = {.lex_state = 11, .external_lex_state = 2},
  [217] = {.lex_state = 126, .external_lex_state = 2},
  [218] = {.lex_state = 126, .external_lex_state = 2},
  [219] = {.lex_state = 126, .external_lex_state = 2},
  [220] = {.lex_state = 126, .external_lex_state = 2},
  [221] = {.lex_state = 126, .external_lex_state = 2},
  [222] = {.lex_state = 126, .external_lex_state = 2},
  [223] = {.lex_state = 126, .external_lex_state = 2},
  [224] = {.lex_state = 126, .external_lex_state = 2},
  [225] = {.lex_state = 126, .external_lex_state = 2},
  [226] = {.lex_state = 126, .external_lex_state = 2},
  [227] = {.lex_state = 126, .external_lex_state = 2},
  [228] = {.lex_state = 126, .external_lex_state = 2},
  [229] = {.lex_state = 126, .external_lex_state = 2},
  [230] = {.lex_state = 126, .external_lex_state = 2},
  [231] = {.lex_state = 126, .external_lex_state = 2},
  [232] = {.lex_state = 126, .external_lex_state = 2},
  [233] = {.lex_state = 126, .external_lex_state = 2},
  [234] = {.lex_state = 126, .external_lex_state = 2},
  [235] = {.lex_state = 126, .external_lex_state = 2},
  [236] = {.lex_state = 126, .external_lex_state = 2},
  [237] = {.lex_state = 126, .external_lex_state = 2},
  [238] = {.lex_state = 126, .external_lex_state = 2},
  [239] = {.lex_state = 126, .external_lex_state = 2},
  [240] = {.lex_state = 126, .external_lex_state = 2},
  [241] = {.lex_state = 126, .external_lex_state = 2},
  [242] = {.lex_state = 126, .external_lex_state = 2},
  [243] = {.lex_state = 126, .external_lex_state = 2},
  [244] = {.lex_state = 126, .external_lex_state = 2},
  [245] = {.lex_state = 126, .external_lex_state = 2},
  [246] = {.lex_state = 126, .external_lex_state = 2},
  [247] = {.lex_state = 126, .external_lex_state = 2},
  [248] = {.lex_state = 126, .external_lex_state = 2},
  [249] = {.lex_state = 126, .external_lex_state = 2},
  [250] = {.lex_state = 126, .external_lex_state = 2},
  [251] = {.lex_state = 126, .external_lex_state = 2},
  [252] = {.lex_state = 126, .external_lex_state = 2},
  [253] = {.lex_state = 126, .external_lex_state = 2},
  [254] = {.lex_state = 126, .external_lex_state = 2},
  [255] = {.lex_state = 126, .external_lex_state = 2},
  [256] = {.lex_state = 126, .external_lex_state = 2},
  [257] = {.lex_state = 126, .external_lex_state = 2},
  [258] = {.lex_state = 126, .external_lex_state = 2},
  [259] = {.lex_state = 126, .external_lex_state = 2},
  [260] = {.lex_state = 126, .external_lex_state = 2},
  [261] = {.lex_state = 126, .external_lex_state = 2},
  [262] = {.lex_state = 126, .external_lex_state = 2},
  [263] = {.lex_state = 126, .external_lex_state = 2},
  [264] = {.lex_state = 126, .external_lex_state = 2},
  [265] = {.lex_state = 126, .external_lex_state = 2},
  [266] = {.lex_state = 126, .external_lex_state = 2},
  [267] = {.lex_state = 126, .external_lex_state = 2},
  [268] = {.lex_state = 126, .external_lex_state = 2},
  [269] = {.lex_state = 126, .external_lex_state = 2},
  [270] = {.lex_state = 126, .external_lex_state = 2},
  [271] = {.lex_state = 126, .external_lex_state = 2},
  [272] = {.lex_state = 126, .external_lex_state = 2},
  [273] = {.lex_state = 126, .external_lex_state = 2},
  [274] = {.lex_state = 126, .external_lex_state = 2},
  [275] = {.lex_state = 126, .external_lex_state = 2},
  [276] = {.lex_state = 126, .external_lex_state = 2},
  [277] = {.lex_state = 126, .external_lex_state = 2},
  [278] = {.lex_state = 126, .external_lex_state = 2},
  [279] = {.lex_state = 126, .external_lex_state = 2},
  [280] = {.lex_state = 126, .external_lex_state = 2},
  [281] = {.lex_state = 126, .external_lex_state = 2},
  [282] = {.lex_state = 126, .external_lex_state = 2},
  [283] = {.lex_state = 126, .external_lex_state = 2},
  [284] = {.lex_state = 126, .external_lex_state = 2},
  [285] = {.lex_state = 126, .external_lex_state = 2},
  [286] = {.lex_state = 126, .external_lex_state = 2},
  [287] = {.lex_state = 126, .external_lex_state = 2},
  [288] = {.lex_state = 126, .external_lex_state = 2},
  [289] = {.lex_state = 126, .external_lex_state = 2},
  [290] = {.lex_state = 126, .external_lex_state = 2},
  [291] = {.lex_state = 126, .external_lex_state = 2},
  [292] = {.lex_state = 126, .external_lex_state = 2},
  [293] = {.lex_state = 126, .external_lex_state = 2},
  [294] = {.lex_state = 126, .external_lex_state = 2},
  [295] = {.lex_state = 126, .external_lex_state = 2},
  [296] = {.lex_state = 126, .external_lex_state = 2},
  [297] = {.lex_state = 126, .external_lex_state = 2},
  [298] = {.lex_state = 126, .external_lex_state = 2},
  [299] = {.lex_state = 126, .external_lex_state = 2},
  [300] = {.lex_state = 126, .external_lex_state = 2},
  [301] = {.lex_state = 126, .external_lex_state = 2},
  [302] = {.lex_state = 126, .external_lex_state = 2},
  [303] = {.lex_state = 126, .external_lex_state = 2},
  [304] = {.lex_state = 126, .external_lex_state = 2},
  [305] = {.lex_state = 126, .external_lex_state = 2},
  [306] = {.lex_state = 126, .external_lex_state = 2},
  [307] = {.lex_state = 126, .external_lex_state = 2},
  [308] = {.lex_state = 126, .external_lex_state = 2},
  [309] = {.lex_state = 126, .external_lex_state = 2},
  [310] = {.lex_state = 126, .external_lex_state = 2},
  [311] = {.lex_state = 126, .external_lex_state = 2},
  [312] = {.lex_state = 126, .external_lex_state = 2},
  [313] = {.lex_state = 126, .external_lex_state = 2},
  [314] = {.lex_state = 126, .external_lex_state = 2},
  [315] = {.lex_state = 126, .external_lex_state = 2},
  [316] = {.lex_state = 126, .external_lex_state = 2},
  [317] = {.lex_state = 126, .external_lex_state = 2},
  [318] = {.lex_state = 126, .external_lex_state = 2},
  [319] = {.lex_state = 126, .external_lex_state = 2},
  [320] = {.lex_state = 126, .external_lex_state = 2},
  [321] = {.lex_state = 126, .external_lex_state = 2},
  [322] = {.lex_state = 126, .external_lex_state = 2},
  [323] = {.lex_state = 126, .external_lex_state = 2},
  [324] = {.lex_state = 126, .external_lex_state = 2},
  [325] = {.lex_state = 126, .external_lex_state = 2},
  [326] = {.lex_state = 126, .external_lex_state = 2},
  [327] = {.lex_state = 126, .external_lex_state = 2},
  [328] = {.lex_state = 126, .external_lex_state = 2},
  [329] = {.lex_state = 126, .external_lex_state = 2},
  [330] = {.lex_state = 126, .external_lex_state = 2},
  [331] = {.lex_state = 126, .external_lex_state = 2},
  [332] = {.lex_state = 126, .external_lex_state = 2},
  [333] = {.lex_state = 126, .external_lex_state = 2},
  [334] = {.lex_state = 126, .external_lex_state = 2},
  [335] = {.lex_state = 126, .external_lex_state = 2},
  [336] = {.lex_state = 126, .external_lex_state = 2},
  [337] = {.lex_state = 126, .external_lex_state = 2},
  [338] = {.lex_state = 126, .external_lex_state = 2},
  [339] = {.lex_state = 126, .external_lex_state = 2},
  [340] = {.lex_state = 126, .external_lex_state = 2},
  [341] = {.lex_state = 126, .external_lex_state = 2},
  [342] = {.lex_state = 126, .external_lex_state = 2},
  [343] = {.lex_state = 126, .external_lex_state = 2},
  [344] = {.lex_state = 126, .external_lex_state = 2},
  [345] = {.lex_state = 126, .external_lex_state = 2},
  [346] = {.lex_state = 126, .external_lex_state = 2},
  [347] = {.lex_state = 126, .external_lex_state = 2},
  [348] = {.lex_state = 126, .external_lex_state = 2},
  [349] = {.lex_state = 126, .external_lex_state = 2},
  [350] = {.lex_state = 126, .external_lex_state = 2},
  [351] = {.lex_state = 126, .external_lex_state = 2},
  [352] = {.lex_state = 126, .external_lex_state = 2},
  [353] = {.lex_state = 126, .external_lex_state = 2},
  [354] = {.lex_state = 126, .external_lex_state = 2},
  [355] = {.lex_state = 126, .external_lex_state = 2},
  [356] = {.lex_state = 126, .external_lex_state = 2},
  [357] = {.lex_state = 126, .external_lex_state = 2},
  [358] = {.lex_state = 126, .external_lex_state = 2},
  [359] = {.lex_state = 126, .external_lex_state = 2},
  [360] = {.lex_state = 126, .external_lex_state = 2},
  [361] = {.lex_state = 126, .external_lex_state = 2},
  [362] = {.lex_state = 126, .external_lex_state = 2},
  [363] = {.lex_state = 126, .external_lex_state = 2},
  [364] = {.lex_state = 126, .external_lex_state = 2},
  [365] = {.lex_state = 126, .external_lex_state = 2},
  [366] = {.lex_state = 126, .external_lex_state = 2},
  [367] = {.lex_state = 126, .external_lex_state = 2},
  [368] = {.lex_state = 126, .external_lex_state = 2},
  [369] = {.lex_state = 126, .external_lex_state = 2},
  [370] = {.lex_state = 126, .external_lex_state = 2},
  [371] = {.lex_state = 126, .external_lex_state = 2},
  [372] = {.lex_state = 126, .external_lex_state = 2},
  [373] = {.lex_state = 126, .external_lex_state = 2},
  [374] = {.lex_state = 126, .external_lex_state = 2},
  [375] = {.lex_state = 126, .external_lex_state = 2},
  [376] = {.lex_state = 126, .external_lex_state = 2},
  [377] = {.lex_state = 126, .external_lex_state = 2},
  [378] = {.lex_state = 126, .external_lex_state = 2},
  [379] = {.lex_state = 126, .external_lex_state = 2},
  [380] = {.lex_state = 126, .external_lex_state = 2},
  [381] = {.lex_state = 126, .external_lex_state = 2},
  [382] = {.lex_state = 126, .external_lex_state = 2},
  [383] = {.lex_state = 126, .external_lex_state = 2},
  [384] = {.lex_state = 126, .external_lex_state = 2},
  [385] = {.lex_state = 126, .external_lex_state = 2},
  [386] = {.lex_state = 126, .external_lex_state = 2},
  [387] = {.lex_state = 126, .external_lex_state = 2},
  [388] = {.lex_state = 126, .external_lex_state = 2},
  [389] = {.lex_state = 126, .external_lex_state = 2},
  [390] = {.lex_state = 126, .external_lex_state = 2},
  [391] = {.lex_state = 126, .external_lex_state = 2},
  [392] = {.lex_state = 126, .external_lex_state = 2},
  [393] = {.lex_state = 126, .external_lex_state = 2},
  [394] = {.lex_state = 126, .external_lex_state = 2},
  [395] = {.lex_state = 126, .external_lex_state = 2},
  [396] = {.lex_state = 126, .external_lex_state = 2},
  [397] = {.lex_state = 126, .external_lex_state = 2},
  [398] = {.lex_state = 126, .external_lex_state = 2},
  [399] = {.lex_state = 126, .external_lex_state = 2},
  [400] = {.lex_state = 126, .external_lex_state = 2},
  [401] = {.lex_state = 126, .external_lex_state = 2},
  [402] = {.lex_state = 126, .external_lex_state = 2},
  [403] = {.lex_state = 126, .external_lex_state = 2},
  [404] = {.lex_state = 126, .external_lex_state = 2},
  [405] = {.lex_state = 126, .external_lex_state = 2},
  [406] = {.lex_state = 126, .external_lex_state = 2},
  [407] = {.lex_state = 126, .external_lex_state = 2},
  [408] = {.lex_state = 126, .external_lex_state = 2},
  [409] = {.lex_state = 126, .external_lex_state = 2},
  [410] = {.lex_state = 126, .external_lex_state = 2},
  [411] = {.lex_state = 126, .external_lex_state = 2},
  [412] = {.lex_state = 126, .external_lex_state = 2},
  [413] = {.lex_state = 126, .external_lex_state = 2},
  [414] = {.lex_state = 126, .external_lex_state = 2},
  [415] = {.lex_state = 126, .external_lex_state = 2},
  [416] = {.lex_state = 126, .external_lex_state = 2},
  [417] = {.lex_state = 126, .external_lex_state = 2},
  [418] = {.lex_state = 126, .external_lex_state = 2},
  [419] = {.lex_state = 126, .external_lex_state = 2},
  [420] = {.lex_state = 126, .external_lex_state = 2},
  [421] = {.lex_state = 126, .external_lex_state = 2},
  [422] = {.lex_state = 126, .external_lex_state = 2},
  [423] = {.lex_state = 126, .external_lex_state = 2},
  [424] = {.lex_state = 126, .external_lex_state = 2},
  [425] = {.lex_state = 126, .external_lex_state = 2},
  [426] = {.lex_state = 126, .external_lex_state = 2},
  [427] = {.lex_state = 126, .external_lex_state = 2},
  [428] = {.lex_state = 126, .external_lex_state = 2},
  [429] = {.lex_state = 126, .external_lex_state = 2},
  [430] = {.lex_state = 126, .external_lex_state = 2},
  [431] = {.lex_state = 126, .external_lex_state = 2},
  [432] = {.lex_state = 126, .external_lex_state = 2},
  [433] = {.lex_state = 126, .external_lex_state = 2},
  [434] = {.lex_state = 126, .external_lex_state = 2},
  [435] = {.lex_state = 126, .external_lex_state = 2},
  [436] = {.lex_state = 126, .external_lex_state = 2},
  [437] = {.lex_state = 126, .external_lex_state = 2},
  [438] = {.lex_state = 126, .external_lex_state = 2},
  [439] = {.lex_state = 126, .external_lex_state = 2},
  [440] = {.lex_state = 126, .external_lex_state = 2},
  [441] = {.lex_state = 126, .external_lex_state = 2},
  [442] = {.lex_state = 126, .external_lex_state = 2},
  [443] = {.lex_state = 126, .external_lex_state = 2},
  [444] = {.lex_state = 126, .external_lex_state = 2},
  [445] = {.lex_state = 126, .external_lex_state = 2},
  [446] = {.lex_state = 126, .external_lex_state = 2},
  [447] = {.lex_state = 126, .external_lex_state = 2},
  [448] = {.lex_state = 126, .external_lex_state = 2},
  [449] = {.lex_state = 126, .external_lex_state = 2},
  [450] = {.lex_state = 126, .external_lex_state = 2},
  [451] = {.lex_state = 126, .external_lex_state = 2},
  [452] = {.lex_state = 126, .external_lex_state = 2},
  [453] = {.lex_state = 126, .external_lex_state = 2},
  [454] = {.lex_state = 126, .external_lex_state = 2},
  [455] = {.lex_state = 126, .external_lex_state = 2},
  [456] = {.lex_state = 126, .external_lex_state = 2},
  [457] = {.lex_state = 126, .external_lex_state = 2},
  [458] = {.lex_state = 126, .external_lex_state = 2},
  [459] = {.lex_state = 126, .external_lex_state = 2},
  [460] = {.lex_state = 126, .external_lex_state = 2},
  [461] = {.lex_state = 126, .external_lex_state = 2},
  [462] = {.lex_state = 126, .external_lex_state = 2},
  [463] = {.lex_state = 126, .external_lex_state = 2},
  [464] = {.lex_state = 126, .external_lex_state = 2},
  [465] = {.lex_state = 126, .external_lex_state = 2},
  [466] = {.lex_state = 126, .external_lex_state = 2},
  [467] = {.lex_state = 126, .external_lex_state = 2},
  [468] = {.lex_state = 126, .external_lex_state = 2},
  [469] = {.lex_state = 126, .external_lex_state = 2},
  [470] = {.lex_state = 126, .external_lex_state = 2},
  [471] = {.lex_state = 126, .external_lex_state = 2},
  [472] = {.lex_state = 126, .external_lex_state = 2},
  [473] = {.lex_state = 126, .external_lex_state = 2},
  [474] = {.lex_state = 126, .external_lex_state = 2},
  [475] = {.lex_state = 126, .external_lex_state = 2},
  [476] = {.lex_state = 126, .external_lex_state = 2},
  [477] = {.lex_state = 126, .external_lex_state = 2},
  [478] = {.lex_state = 126, .external_lex_state = 2},
  [479] = {.lex_state = 126, .external_lex_state = 2},
  [480] = {.lex_state = 126, .external_lex_state = 2},
  [481] = {.lex_state = 126, .external_lex_state = 2},
  [482] = {.lex_state = 126, .external_lex_state = 2},
  [483] = {.lex_state = 126, .external_lex_state = 2},
  [484] = {.lex_state = 126, .external_lex_state = 2},
  [485] = {.lex_state = 126, .external_lex_state = 2},
  [486] = {.lex_state = 126, .external_lex_state = 2},
  [487] = {.lex_state = 126, .external_lex_state = 2},
  [488] = {.lex_state = 126, .external_lex_state = 2},
  [489] = {.lex_state = 126, .external_lex_state = 2},
  [490] = {.lex_state = 126, .external_lex_state = 2},
  [491] = {.lex_state = 126, .external_lex_state = 2},
  [492] = {.lex_state = 126, .external_lex_state = 2},
  [493] = {.lex_state = 126, .external_lex_state = 2},
  [494] = {.lex_state = 126, .external_lex_state = 2},
  [495] = {.lex_state = 126, .external_lex_state = 2},
  [496] = {.lex_state = 126, .external_lex_state = 2},
  [497] = {.lex_state = 126, .external_lex_state = 2},
  [498] = {.lex_state = 126, .external_lex_state = 2},
  [499] = {.lex_state = 126, .external_lex_state = 2},
  [500] = {.lex_state = 126, .external_lex_state = 2},
  [501] = {.lex_state = 126, .external_lex_state = 2},
  [502] = {.lex_state = 126, .external_lex_state = 2},
  [503] = {.lex_state = 126, .external_lex_state = 2},
  [504] = {.lex_state = 126, .external_lex_state = 2},
  [505] = {.lex_state = 126, .external_lex_state = 2},
  [506] = {.lex_state = 126, .external_lex_state = 2},
  [507] = {.lex_state = 126, .external_lex_state = 2},
  [508] = {.lex_state = 126, .external_lex_state = 2},
  [509] = {.lex_state = 126, .external_lex_state = 2},
  [510] = {.lex_state = 126, .external_lex_state = 2},
  [511] = {.lex_state = 126, .external_lex_state = 2},
  [512] = {.lex_state = 126, .external_lex_state = 2},
  [513] = {.lex_state = 126, .external_lex_state = 2},
  [514] = {.lex_state = 126, .external_lex_state = 2},
  [515] = {.lex_state = 126, .external_lex_state = 2},
  [516] = {.lex_state = 126, .external_lex_state = 2},
  [517] = {.lex_state = 126, .external_lex_state = 2},
  [518] = {.lex_state = 126, .external_lex_state = 2},
  [519] = {.lex_state = 126, .external_lex_state = 2},
  [520] = {.lex_state = 126, .external_lex_state = 2},
  [521] = {.lex_state = 126, .external_lex_state = 2},
  [522] = {.lex_state = 126, .external_lex_state = 2},
  [523] = {.lex_state = 126, .external_lex_state = 2},
  [524] = {.lex_state = 126, .external_lex_state = 2},
  [525] = {.lex_state = 126, .external_lex_state = 2},
  [526] = {.lex_state = 126, .external_lex_state = 2},
  [527] = {.lex_state = 126, .external_lex_state = 2},
  [528] = {.lex_state = 126, .external_lex_state = 2},
  [529] = {.lex_state = 126, .external_lex_state = 2},
  [530] = {.lex_state = 126, .external_lex_state = 2},
  [531] = {.lex_state = 126, .external_lex_state = 2},
  [532] = {.lex_state = 126, .external_lex_state = 2},
  [533] = {.lex_state = 126, .external_lex_state = 2},
  [534] = {.lex_state = 126, .external_lex_state = 2},
  [535] = {.lex_state = 126, .external_lex_state = 2},
  [536] = {.lex_state = 126, .external_lex_state = 2},
  [537] = {.lex_state = 126, .external_lex_state = 2},
  [538] = {.lex_state = 126, .external_lex_state = 2},
  [539] = {.lex_state = 126, .external_lex_state = 2},
  [540] = {.lex_state = 126, .external_lex_state = 2},
  [541] = {.lex_state = 126, .external_lex_state = 2},
  [542] = {.lex_state = 126, .external_lex_state = 2},
  [543] = {.lex_state = 126, .external_lex_state = 2},
  [544] = {.lex_state = 126, .external_lex_state = 2},
  [545] = {.lex_state = 126, .external_lex_state = 2},
  [546] = {.lex_state = 126, .external_lex_state = 2},
  [547] = {.lex_state = 126, .external_lex_state = 2},
  [548] = {.lex_state = 126, .external_lex_state = 2},
  [549] = {.lex_state = 126, .external_lex_state = 2},
  [550] = {.lex_state = 126, .external_lex_state = 2},
  [551] = {.lex_state = 126, .external_lex_state = 2},
  [552] = {.lex_state = 126, .external_lex_state = 2},
  [553] = {.lex_state = 126, .external_lex_state = 2},
  [554] = {.lex_state = 126, .external_lex_state = 2},
  [555] = {.lex_state = 126, .external_lex_state = 2},
  [556] = {.lex_state = 126, .external_lex_state = 2},
  [557] = {.lex_state = 126, .external_lex_state = 2},
  [558] = {.lex_state = 126, .external_lex_state = 2},
  [559] = {.lex_state = 126, .external_lex_state = 2},
  [560] = {.lex_state = 126, .external_lex_state = 2},
  [561] = {.lex_state = 126, .external_lex_state = 2},
  [562] = {.lex_state = 126, .external_lex_state = 2},
  [563] = {.lex_state = 126, .external_lex_state = 2},
  [564] = {.lex_state = 126, .external_lex_state = 2},
  [565] = {.lex_state = 126, .external_lex_state = 2},
  [566] = {.lex_state = 126, .external_lex_state = 2},
  [567] = {.lex_state = 126, .external_lex_state = 2},
  [568] = {.lex_state = 126, .external_lex_state = 2},
  [569] = {.lex_state = 126, .external_lex_state = 2},
  [570] = {.lex_state = 126, .external_lex_state = 2},
  [571] = {.lex_state = 126, .external_lex_state = 2},
  [572] = {.lex_state = 126, .external_lex_state = 2},
  [573] = {.lex_state = 126, .external_lex_state = 2},
  [574] = {.lex_state = 126, .external_lex_state = 2},
  [575] = {.lex_state = 126, .external_lex_state = 2},
  [576] = {.lex_state = 126, .external_lex_state = 2},
  [577] = {.lex_state = 126, .external_lex_state = 2},
  [578] = {.lex_state = 126, .external_lex_state = 2},
  [579] = {.lex_state = 126, .external_lex_state = 2},
  [580] = {.lex_state = 126, .external_lex_state = 2},
  [581] = {.lex_state = 126, .external_lex_state = 2},
  [582] = {.lex_state = 126, .external_lex_state = 2},
  [583] = {.lex_state = 126, .external_lex_state = 2},
  [584] = {.lex_state = 126, .external_lex_state = 2},
  [585] = {.lex_state = 126, .external_lex_state = 2},
  [586] = {.lex_state = 126, .external_lex_state = 2},
  [587] = {.lex_state = 126, .external_lex_state = 2},
  [588] = {.lex_state = 126, .external_lex_state = 2},
  [589] = {.lex_state = 126, .external_lex_state = 2},
  [590] = {.lex_state = 126, .external_lex_state = 2},
  [591] = {.lex_state = 126, .external_lex_state = 2},
  [592] = {.lex_state = 126, .external_lex_state = 2},
  [593] = {.lex_state = 126, .external_lex_state = 2},
  [594] = {.lex_state = 126, .external_lex_state = 2},
  [595] = {.lex_state = 126, .external_lex_state = 2},
  [596] = {.lex_state = 126, .external_lex_state = 2},
  [597] = {.lex_state = 126, .external_lex_state = 2},
  [598] = {.lex_state = 126, .external_lex_state = 2},
  [599] = {.lex_state = 126, .external_lex_state = 2},
  [600] = {.lex_state = 126, .external_lex_state = 2},
  [601] = {.lex_state = 126, .external_lex_state = 2},
  [602] = {.lex_state = 126, .external_lex_state = 2},
  [603] = {.lex_state = 126, .external_lex_state = 2},
  [604] = {.lex_state = 126, .external_lex_state = 2},
  [605] = {.lex_state = 126, .external_lex_state = 2},
  [606] = {.lex_state = 126, .external_lex_state = 2},
  [607] = {.lex_state = 126, .external_lex_state = 2},
  [608] = {.lex_state = 126, .external_lex_state = 2},
  [609] = {.lex_state = 126, .external_lex_state = 2},
  [610] = {.lex_state = 126, .external_lex_state = 2},
  [611] = {.lex_state = 126, .external_lex_state = 2},
  [612] = {.lex_state = 126, .external_lex_state = 2},
  [613] = {.lex_state = 126, .external_lex_state = 2},
  [614] = {.lex_state = 126, .external_lex_state = 2},
  [615] = {.lex_state = 126, .external_lex_state = 2},
  [616] = {.lex_state = 126, .external_lex_state = 2},
  [617] = {.lex_state = 126, .external_lex_state = 2},
  [618] = {.lex_state = 126, .external_lex_state = 2},
  [619] = {.lex_state = 126, .external_lex_state = 2},
  [620] = {.lex_state = 126, .external_lex_state = 2},
  [621] = {.lex_state = 126, .external_lex_state = 2},
  [622] = {.lex_state = 126, .external_lex_state = 2},
  [623] = {.lex_state = 126, .external_lex_state = 2},
  [624] = {.lex_state = 126, .external_lex_state = 2},
  [625] = {.lex_state = 126, .external_lex_state = 2},
  [626] = {.lex_state = 126, .external_lex_state = 2},
  [627] = {.lex_state = 126, .external_lex_state = 2},
  [628] = {.lex_state = 126, .external_lex_state = 2},
  [629] = {.lex_state = 126, .external_lex_state = 2},
  [630] = {.lex_state = 126, .external_lex_state = 2},
  [631] = {.lex_state = 126, .external_lex_state = 2},
  [632] = {.lex_state = 126, .external_lex_state = 2},
  [633] = {.lex_state = 126, .external_lex_state = 2},
  [634] = {.lex_state = 126, .external_lex_state = 2},
  [635] = {.lex_state = 126, .external_lex_state = 2},
  [636] = {.lex_state = 126, .external_lex_state = 2},
  [637] = {.lex_state = 126, .external_lex_state = 2},
  [638] = {.lex_state = 126, .external_lex_state = 2},
  [639] = {.lex_state = 126, .external_lex_state = 2},
  [640] = {.lex_state = 126, .external_lex_state = 2},
  [641] = {.lex_state = 126, .external_lex_state = 2},
  [642] = {.lex_state = 126, .external_lex_state = 2},
  [643] = {.lex_state = 126, .external_lex_state = 2},
  [644] = {.lex_state = 126, .external_lex_state = 2},
  [645] = {.lex_state = 126, .external_lex_state = 2},
  [646] = {.lex_state = 126, .external_lex_state = 2},
  [647] = {.lex_state = 126, .external_lex_state = 2},
  [648] = {.lex_state = 126, .external_lex_state = 2},
  [649] = {.lex_state = 126, .external_lex_state = 2},
  [650] = {.lex_state = 126, .external_lex_state = 2},
  [651] = {.lex_state = 126, .external_lex_state = 2},
  [652] = {.lex_state = 126, .external_lex_state = 2},
  [653] = {.lex_state = 126, .external_lex_state = 2},
  [654] = {.lex_state = 126, .external_lex_state = 2},
  [655] = {.lex_state = 126, .external_lex_state = 2},
  [656] = {.lex_state = 126, .external_lex_state = 2},
  [657] = {.lex_state = 126, .external_lex_state = 2},
  [658] = {.lex_state = 126, .external_lex_state = 2},
  [659] = {.lex_state = 126, .external_lex_state = 2},
  [660] = {.lex_state = 126, .external_lex_state = 2},
  [661] = {.lex_state = 126, .external_lex_state = 2},
  [662] = {.lex_state = 126, .external_lex_state = 2},
  [663] = {.lex_state = 126, .external_lex_state = 2},
  [664] = {.lex_state = 126, .external_lex_state = 2},
  [665] = {.lex_state = 126, .external_lex_state = 2},
  [666] = {.lex_state = 126, .external_lex_state = 2},
  [667] = {.lex_state = 126, .external_lex_state = 2},
  [668] = {.lex_state = 126, .external_lex_state = 2},
  [669] = {.lex_state = 126, .external_lex_state = 2},
  [670] = {.lex_state = 126, .external_lex_state = 2},
  [671] = {.lex_state = 126, .external_lex_state = 2},
  [672] = {.lex_state = 126, .external_lex_state = 2},
  [673] = {.lex_state = 126, .external_lex_state = 2},
  [674] = {.lex_state = 126, .external_lex_state = 2},
  [675] = {.lex_state = 126, .external_lex_state = 2},
  [676] = {.lex_state = 126, .external_lex_state = 2},
  [677] = {.lex_state = 126, .external_lex_state = 2},
  [678] = {.lex_state = 126, .external_lex_state = 2},
  [679] = {.lex_state = 126, .external_lex_state = 2},
  [680] = {.lex_state = 126, .external_lex_state = 2},
  [681] = {.lex_state = 126, .external_lex_state = 2},
  [682] = {.lex_state = 126, .external_lex_state = 2},
  [683] = {.lex_state = 126, .external_lex_state = 2},
  [684] = {.lex_state = 126, .external_lex_state = 2},
  [685] = {.lex_state = 126, .external_lex_state = 2},
  [686] = {.lex_state = 126, .external_lex_state = 2},
  [687] = {.lex_state = 126, .external_lex_state = 2},
  [688] = {.lex_state = 126, .external_lex_state = 2},
  [689] = {.lex_state = 126, .external_lex_state = 2},
  [690] = {.lex_state = 126, .external_lex_state = 2},
  [691] = {.lex_state = 126, .external_lex_state = 2},
  [692] = {.lex_state = 126, .external_lex_state = 2},
  [693] = {.lex_state = 126, .external_lex_state = 2},
  [694] = {.lex_state = 126, .external_lex_state = 2},
  [695] = {.lex_state = 126, .external_lex_state = 2},
  [696] = {.lex_state = 126, .external_lex_state = 2},
  [697] = {.lex_state = 126, .external_lex_state = 2},
  [698] = {.lex_state = 126, .external_lex_state = 2},
  [699] = {.lex_state = 126, .external_lex_state = 2},
  [700] = {.lex_state = 126, .external_lex_state = 2},
  [701] = {.lex_state = 126, .external_lex_state = 2},
  [702] = {.lex_state = 126, .external_lex_state = 2},
  [703] = {.lex_state = 126, .external_lex_state = 2},
  [704] = {.lex_state = 126, .external_lex_state = 2},
  [705] = {.lex_state = 126, .external_lex_state = 2},
  [706] = {.lex_state = 126, .external_lex_state = 2},
  [707] = {.lex_state = 126, .external_lex_state = 2},
  [708] = {.lex_state = 126, .external_lex_state = 2},
  [709] = {.lex_state = 126, .external_lex_state = 2},
  [710] = {.lex_state = 126, .external_lex_state = 2},
  [711] = {.lex_state = 126, .external_lex_state = 2},
  [712] = {.lex_state = 126, .external_lex_state = 2},
  [713] = {.lex_state = 126, .external_lex_state = 2},
  [714] = {.lex_state = 126, .external_lex_state = 2},
  [715] = {.lex_state = 126, .external_lex_state = 2},
  [716] = {.lex_state = 126, .external_lex_state = 2},
  [717] = {.lex_state = 126, .external_lex_state = 2},
  [718] = {.lex_state = 126, .external_lex_state = 2},
  [719] = {.lex_state = 126, .external_lex_state = 2},
  [720] = {.lex_state = 126, .external_lex_state = 2},
  [721] = {.lex_state = 126, .external_lex_state = 2},
  [722] = {.lex_state = 126, .external_lex_state = 2},
  [723] = {.lex_state = 126, .external_lex_state = 2},
  [724] = {.lex_state = 126, .external_lex_state = 2},
  [725] = {.lex_state = 126, .external_lex_state = 2},
  [726] = {.lex_state = 126, .external_lex_state = 2},
  [727] = {.lex_state = 126, .external_lex_state = 2},
  [728] = {.lex_state = 126, .external_lex_state = 2},
  [729] = {.lex_state = 126, .external_lex_state = 2},
  [730] = {.lex_state = 126, .external_lex_state = 2},
  [731] = {.lex_state = 126, .external_lex_state = 2},
  [732] = {.lex_state = 126, .external_lex_state = 2},
  [733] = {.lex_state = 126, .external_lex_state = 2},
  [734] = {.lex_state = 126, .external_lex_state = 2},
  [735] = {.lex_state = 126, .external_lex_state = 2},
  [736] = {.lex_state = 126, .external_lex_state = 2},
  [737] = {.lex_state = 126, .external_lex_state = 2},
  [738] = {.lex_state = 126, .external_lex_state = 2},
  [739] = {.lex_state = 126, .external_lex_state = 2},
  [740] = {.lex_state = 126, .external_lex_state = 2},
  [741] = {.lex_state = 126, .external_lex_state = 2},
  [742] = {.lex_state = 126, .external_lex_state = 2},
  [743] = {.lex_state = 126, .external_lex_state = 2},
  [744] = {.lex_state = 126, .external_lex_state = 2},
  [745] = {.lex_state = 126, .external_lex_state = 2},
  [746] = {.lex_state = 126, .external_lex_state = 2},
  [747] = {.lex_state = 126, .external_lex_state = 2},
  [748] = {.lex_state = 126, .external_lex_state = 2},
  [749] = {.lex_state = 126, .external_lex_state = 2},
  [750] = {.lex_state = 126, .external_lex_state = 2},
  [751] = {.lex_state = 126, .external_lex_state = 2},
  [752] = {.lex_state = 126, .external_lex_state = 2},
  [753] = {.lex_state = 126, .external_lex_state = 2},
  [754] = {.lex_state = 126, .external_lex_state = 2},
  [755] = {.lex_state = 126, .external_lex_state = 2},
  [756] = {.lex_state = 126, .external_lex_state = 2},
  [757] = {.lex_state = 126, .external_lex_state = 2},
  [758] = {.lex_state = 126, .external_lex_state = 2},
  [759] = {.lex_state = 126, .external_lex_state = 2},
  [760] = {.lex_state = 126, .external_lex_state = 2},
  [761] = {.lex_state = 126, .external_lex_state = 2},
  [762] = {.lex_state = 126, .external_lex_state = 2},
  [763] = {.lex_state = 126, .external_lex_state = 2},
  [764] = {.lex_state = 126, .external_lex_state = 2},
  [765] = {.lex_state = 126, .external_lex_state = 2},
  [766] = {.lex_state = 126, .external_lex_state = 2},
  [767] = {.lex_state = 126, .external_lex_state = 2},
  [768] = {.lex_state = 126, .external_lex_state = 2},
  [769] = {.lex_state = 126, .external_lex_state = 2},
  [770] = {.lex_state = 126, .external_lex_state = 2},
  [771] = {.lex_state = 126, .external_lex_state = 2},
  [772] = {.lex_state = 126, .external_lex_state = 2},
  [773] = {.lex_state = 126, .external_lex_state = 2},
  [774] = {.lex_state = 126, .external_lex_state = 2},
  [775] = {.lex_state = 126, .external_lex_state = 2},
  [776] = {.lex_state = 126, .external_lex_state = 2},
  [777] = {.lex_state = 126, .external_lex_state = 2},
  [778] = {.lex_state = 126, .external_lex_state = 2},
  [779] = {.lex_state = 126, .external_lex_state = 2},
  [780] = {.lex_state = 126, .external_lex_state = 2},
  [781] = {.lex_state = 126, .external_lex_state = 2},
  [782] = {.lex_state = 126, .external_lex_state = 2},
  [783] = {.lex_state = 126, .external_lex_state = 2},
  [784] = {.lex_state = 126, .external_lex_state = 2},
  [785] = {.lex_state = 126, .external_lex_state = 2},
  [786] = {.lex_state = 126, .external_lex_state = 2},
  [787] = {.lex_state = 126, .external_lex_state = 2},
  [788] = {.lex_state = 126, .external_lex_state = 2},
  [789] = {.lex_state = 126, .external_lex_state = 2},
  [790] = {.lex_state = 126, .external_lex_state = 2},
  [791] = {.lex_state = 126, .external_lex_state = 2},
  [792] = {.lex_state = 126, .external_lex_state = 2},
  [793] = {.lex_state = 126, .external_lex_state = 2},
  [794] = {.lex_state = 126, .external_lex_state = 2},
  [795] = {.lex_state = 126, .external_lex_state = 2},
  [796] = {.lex_state = 126, .external_lex_state = 2},
  [797] = {.lex_state = 126, .external_lex_state = 2},
  [798] = {.lex_state = 126, .external_lex_state = 2},
  [799] = {.lex_state = 126, .external_lex_state = 2},
  [800] = {.lex_state = 126, .external_lex_state = 2},
  [801] = {.lex_state = 126, .external_lex_state = 2},
  [802] = {.lex_state = 126, .external_lex_state = 2},
  [803] = {.lex_state = 126, .external_lex_state = 2},
  [804] = {.lex_state = 126, .external_lex_state = 2},
  [805] = {.lex_state = 126, .external_lex_state = 2},
  [806] = {.lex_state = 126, .external_lex_state = 2},
  [807] = {.lex_state = 126, .external_lex_state = 2},
  [808] = {.lex_state = 126, .external_lex_state = 2},
  [809] = {.lex_state = 126, .external_lex_state = 2},
  [810] = {.lex_state = 126, .external_lex_state = 2},
  [811] = {.lex_state = 126, .external_lex_state = 2},
  [812] = {.lex_state = 126, .external_lex_state = 2},
  [813] = {.lex_state = 126, .external_lex_state = 2},
  [814] = {.lex_state = 126, .external_lex_state = 2},
  [815] = {.lex_state = 126, .external_lex_state = 2},
  [816] = {.lex_state = 126, .external_lex_state = 2},
  [817] = {.lex_state = 126, .external_lex_state = 2},
  [818] = {.lex_state = 126, .external_lex_state = 2},
  [819] = {.lex_state = 126, .external_lex_state = 2},
  [820] = {.lex_state = 126, .external_lex_state = 2},
  [821] = {.lex_state = 126, .external_lex_state = 2},
  [822] = {.lex_state = 126, .external_lex_state = 2},
  [823] = {.lex_state = 126, .external_lex_state = 2},
  [824] = {.lex_state = 126, .external_lex_state = 2},
  [825] = {.lex_state = 126, .external_lex_state = 2},
  [826] = {.lex_state = 126, .external_lex_state = 2},
  [827] = {.lex_state = 126, .external_lex_state = 2},
  [828] = {.lex_state = 126, .external_lex_state = 2},
  [829] = {.lex_state = 126, .external_lex_state = 2},
  [830] = {.lex_state = 126, .external_lex_state = 2},
  [831] = {.lex_state = 126, .external_lex_state = 2},
  [832] = {.lex_state = 126, .external_lex_state = 2},
  [833] = {.lex_state = 126, .external_lex_state = 2},
  [834] = {.lex_state = 126, .external_lex_state = 2},
  [835] = {.lex_state = 126, .external_lex_state = 2},
  [836] = {.lex_state = 126, .external_lex_state = 2},
  [837] = {.lex_state = 126, .external_lex_state = 2},
  [838] = {.lex_state = 126, .external_lex_state = 2},
  [839] = {.lex_state = 126, .external_lex_state = 2},
  [840] = {.lex_state = 126, .external_lex_state = 2},
  [841] = {.lex_state = 126, .external_lex_state = 2},
  [842] = {.lex_state = 126, .external_lex_state = 2},
  [843] = {.lex_state = 126, .external_lex_state = 2},
  [844] = {.lex_state = 126, .external_lex_state = 2},
  [845] = {.lex_state = 126, .external_lex_state = 2},
  [846] = {.lex_state = 126, .external_lex_state = 2},
  [847] = {.lex_state = 126, .external_lex_state = 2},
  [848] = {.lex_state = 126, .external_lex_state = 2},
  [849] = {.lex_state = 126, .external_lex_state = 2},
  [850] = {.lex_state = 126, .external_lex_state = 2},
  [851] = {.lex_state = 126, .external_lex_state = 2},
  [852] = {.lex_state = 126, .external_lex_state = 2},
  [853] = {.lex_state = 126, .external_lex_state = 2},
  [854] = {.lex_state = 126, .external_lex_state = 2},
  [855] = {.lex_state = 126, .external_lex_state = 2},
  [856] = {.lex_state = 126, .external_lex_state = 2},
  [857] = {.lex_state = 126, .external_lex_state = 2},
  [858] = {.lex_state = 126, .external_lex_state = 2},
  [859] = {.lex_state = 126, .external_lex_state = 2},
  [860] = {.lex_state = 126, .external_lex_state = 2},
  [861] = {.lex_state = 126, .external_lex_state = 2},
  [862] = {.lex_state = 126, .external_lex_state = 2},
  [863] = {.lex_state = 126, .external_lex_state = 2},
  [864] = {.lex_state = 126, .external_lex_state = 2},
  [865] = {.lex_state = 126, .external_lex_state = 2},
  [866] = {.lex_state = 126, .external_lex_state = 2},
  [867] = {.lex_state = 126, .external_lex_state = 2},
  [868] = {.lex_state = 126, .external_lex_state = 2},
  [869] = {.lex_state = 126, .external_lex_state = 2},
  [870] = {.lex_state = 126, .external_lex_state = 2},
  [871] = {.lex_state = 126, .external_lex_state = 2},
  [872] = {.lex_state = 126, .external_lex_state = 2},
  [873] = {.lex_state = 126, .external_lex_state = 2},
  [874] = {.lex_state = 126, .external_lex_state = 2},
  [875] = {.lex_state = 126, .external_lex_state = 2},
  [876] = {.lex_state = 126, .external_lex_state = 2},
  [877] = {.lex_state = 126, .external_lex_state = 2},
  [878] = {.lex_state = 126, .external_lex_state = 2},
  [879] = {.lex_state = 126, .external_lex_state = 2},
  [880] = {.lex_state = 126, .external_lex_state = 2},
  [881] = {.lex_state = 126, .external_lex_state = 2},
  [882] = {.lex_state = 126, .external_lex_state = 2},
  [883] = {.lex_state = 126, .external_lex_state = 2},
  [884] = {.lex_state = 126, .external_lex_state = 2},
  [885] = {.lex_state = 126, .external_lex_state = 2},
  [886] = {.lex_state = 126, .external_lex_state = 2},
  [887] = {.lex_state = 126, .external_lex_state = 2},
  [888] = {.lex_state = 126, .external_lex_state = 2},
  [889] = {.lex_state = 126, .external_lex_state = 2},
  [890] = {.lex_state = 126, .external_lex_state = 2},
  [891] = {.lex_state = 126, .external_lex_state = 2},
  [892] = {.lex_state = 126, .external_lex_state = 2},
  [893] = {.lex_state = 126, .external_lex_state = 2},
  [894] = {.lex_state = 126, .external_lex_state = 2},
  [895] = {.lex_state = 126, .external_lex_state = 2},
  [896] = {.lex_state = 126, .external_lex_state = 2},
  [897] = {.lex_state = 126, .external_lex_state = 2},
  [898] = {.lex_state = 126, .external_lex_state = 2},
  [899] = {.lex_state = 126, .external_lex_state = 2},
  [900] = {.lex_state = 126, .external_lex_state = 2},
  [901] = {.lex_state = 126, .external_lex_state = 2},
  [902] = {.lex_state = 126, .external_lex_state = 2},
  [903] = {.lex_state = 126, .external_lex_state = 2},
  [904] = {.lex_state = 126, .external_lex_state = 2},
  [905] = {.lex_state = 126, .external_lex_state = 2},
  [906] = {.lex_state = 126, .external_lex_state = 2},
  [907] = {.lex_state = 126, .external_lex_state = 2},
  [908] = {.lex_state = 126, .external_lex_state = 2},
  [909] = {.lex_state = 126, .external_lex_state = 2},
  [910] = {.lex_state = 126, .external_lex_state = 2},
  [911] = {.lex_state = 126, .external_lex_state = 2},
  [912] = {.lex_state = 126, .external_lex_state = 2},
  [913] = {.lex_state = 126, .external_lex_state = 2},
  [914] = {.lex_state = 126, .external_lex_state = 2},
  [915] = {.lex_state = 126, .external_lex_state = 2},
  [916] = {.lex_state = 126, .external_lex_state = 2},
  [917] = {.lex_state = 126, .external_lex_state = 2},
  [918] = {.lex_state = 126, .external_lex_state = 2},
  [919] = {.lex_state = 126, .external_lex_state = 2},
  [920] = {.lex_state = 126, .external_lex_state = 2},
  [921] = {.lex_state = 126, .external_lex_state = 2},
  [922] = {.lex_state = 126, .external_lex_state = 2},
  [923] = {.lex_state = 126, .external_lex_state = 2},
  [924] = {.lex_state = 126, .external_lex_state = 2},
  [925] = {.lex_state = 126, .external_lex_state = 2},
  [926] = {.lex_state = 126, .external_lex_state = 2},
  [927] = {.lex_state = 126, .external_lex_state = 2},
  [928] = {.lex_state = 126, .external_lex_state = 2},
  [929] = {.lex_state = 126, .external_lex_state = 2},
  [930] = {.lex_state = 126, .external_lex_state = 2},
  [931] = {.lex_state = 126, .external_lex_state = 2},
  [932] = {.lex_state = 126, .external_lex_state = 2},
  [933] = {.lex_state = 126, .external_lex_state = 2},
  [934] = {.lex_state = 126, .external_lex_state = 2},
  [935] = {.lex_state = 126, .external_lex_state = 2},
  [936] = {.lex_state = 126, .external_lex_state = 2},
  [937] = {.lex_state = 126, .external_lex_state = 2},
  [938] = {.lex_state = 126, .external_lex_state = 2},
  [939] = {.lex_state = 126, .external_lex_state = 2},
  [940] = {.lex_state = 126, .external_lex_state = 2},
  [941] = {.lex_state = 126, .external_lex_state = 2},
  [942] = {.lex_state = 126, .external_lex_state = 2},
  [943] = {.lex_state = 126, .external_lex_state = 2},
  [944] = {.lex_state = 126, .external_lex_state = 2},
  [945] = {.lex_state = 126, .external_lex_state = 2},
  [946] = {.lex_state = 126, .external_lex_state = 2},
  [947] = {.lex_state = 126, .external_lex_state = 2},
  [948] = {.lex_state = 126, .external_lex_state = 2},
  [949] = {.lex_state = 126, .external_lex_state = 2},
  [950] = {.lex_state = 126, .external_lex_state = 2},
  [951] = {.lex_state = 126, .external_lex_state = 2},
  [952] = {.lex_state = 126, .external_lex_state = 2},
  [953] = {.lex_state = 126, .external_lex_state = 2},
  [954] = {.lex_state = 126, .external_lex_state = 2},
  [955] = {.lex_state = 126, .external_lex_state = 2},
  [956] = {.lex_state = 126, .external_lex_state = 2},
  [957] = {.lex_state = 126, .external_lex_state = 2},
  [958] = {.lex_state = 126, .external_lex_state = 2},
  [959] = {.lex_state = 126, .external_lex_state = 2},
  [960] = {.lex_state = 126, .external_lex_state = 2},
  [961] = {.lex_state = 126, .external_lex_state = 2},
  [962] = {.lex_state = 126, .external_lex_state = 2},
  [963] = {.lex_state = 126, .external_lex_state = 2},
  [964] = {.lex_state = 126, .external_lex_state = 2},
  [965] = {.lex_state = 126, .external_lex_state = 2},
  [966] = {.lex_state = 126, .external_lex_state = 2},
  [967] = {.lex_state = 126, .external_lex_state = 2},
  [968] = {.lex_state = 126, .external_lex_state = 2},
  [969] = {.lex_state = 126, .external_lex_state = 2},
  [970] = {.lex_state = 126, .external_lex_state = 2},
  [971] = {.lex_state = 126, .external_lex_state = 2},
  [972] = {.lex_state = 126, .external_lex_state = 2},
  [973] = {.lex_state = 126, .external_lex_state = 2},
  [974] = {.lex_state = 126, .external_lex_state = 2},
  [975] = {.lex_state = 126, .external_lex_state = 2},
  [976] = {.lex_state = 126, .external_lex_state = 2},
  [977] = {.lex_state = 126, .external_lex_state = 2},
  [978] = {.lex_state = 126, .external_lex_state = 2},
  [979] = {.lex_state = 126, .external_lex_state = 2},
  [980] = {.lex_state = 126, .external_lex_state = 2},
  [981] = {.lex_state = 126, .external_lex_state = 2},
  [982] = {.lex_state = 126, .external_lex_state = 2},
  [983] = {.lex_state = 126, .external_lex_state = 2},
  [984] = {.lex_state = 126, .external_lex_state = 2},
  [985] = {.lex_state = 126, .external_lex_state = 2},
  [986] = {.lex_state = 126, .external_lex_state = 2},
  [987] = {.lex_state = 126, .external_lex_state = 2},
  [988] = {.lex_state = 126, .external_lex_state = 2},
  [989] = {.lex_state = 126, .external_lex_state = 2},
  [990] = {.lex_state = 126, .external_lex_state = 2},
  [991] = {.lex_state = 126, .external_lex_state = 2},
  [992] = {.lex_state = 126, .external_lex_state = 2},
  [993] = {.lex_state = 126, .external_lex_state = 2},
  [994] = {.lex_state = 126, .external_lex_state = 2},
  [995] = {.lex_state = 126, .external_lex_state = 2},
  [996] = {.lex_state = 126, .external_lex_state = 2},
  [997] = {.lex_state = 126, .external_lex_state = 2},
  [998] = {.lex_state = 126, .external_lex_state = 2},
  [999] = {.lex_state = 126, .external_lex_state = 2},
  [1000] = {.lex_state = 126, .external_lex_state = 2},
  [1001] = {.lex_state = 126, .external_lex_state = 2},
  [1002] = {.lex_state = 126, .external_lex_state = 2},
  [1003] = {.lex_state = 126, .external_lex_state = 2},
  [1004] = {.lex_state = 126, .external_lex_state = 2},
  [1005] = {.lex_state = 126, .external_lex_state = 2},
  [1006] = {.lex_state = 126, .external_lex_state = 2},
  [1007] = {.lex_state = 126, .external_lex_state = 2},
  [1008] = {.lex_state = 126, .external_lex_state = 2},
  [1009] = {.lex_state = 126, .external_lex_state = 2},
  [1010] = {.lex_state = 126, .external_lex_state = 2},
  [1011] = {.lex_state = 126, .external_lex_state = 2},
  [1012] = {.lex_state = 126, .external_lex_state = 2},
  [1013] = {.lex_state = 126, .external_lex_state = 2},
  [1014] = {.lex_state = 126, .external_lex_state = 2},
  [1015] = {.lex_state = 126, .external_lex_state = 2},
  [1016] = {.lex_state = 126, .external_lex_state = 2},
  [1017] = {.lex_state = 126, .external_lex_state = 2},
  [1018] = {.lex_state = 126, .external_lex_state = 2},
  [1019] = {.lex_state = 126, .external_lex_state = 2},
  [1020] = {.lex_state = 126, .external_lex_state = 2},
  [1021] = {.lex_state = 126, .external_lex_state = 2},
  [1022] = {.lex_state = 126, .external_lex_state = 2},
  [1023] = {.lex_state = 126, .external_lex_state = 2},
  [1024] = {.lex_state = 126, .external_lex_state = 2},
  [1025] = {.lex_state = 126, .external_lex_state = 2},
  [1026] = {.lex_state = 126, .external_lex_state = 2},
  [1027] = {.lex_state = 126, .external_lex_state = 2},
  [1028] = {.lex_state = 126, .external_lex_state = 2},
  [1029] = {.lex_state = 126, .external_lex_state = 2},
  [1030] = {.lex_state = 126, .external_lex_state = 2},
  [1031] = {.lex_state = 126, .external_lex_state = 2},
  [1032] = {.lex_state = 126, .external_lex_state = 2},
  [1033] = {.lex_state = 126, .external_lex_state = 2},
  [1034] = {.lex_state = 108, .external_lex_state = 1},
  [1035] = {.lex_state = 109, .external_lex_state = 1},
  [1036] = {.lex_state = 114, .external_lex_state = 1},
  [1037] = {.lex_state = 114, .external_lex_state = 1},
  [1038] = {.lex_state = 114, .external_lex_state = 1},
  [1039] = {.lex_state = 114, .external_lex_state = 1},
  [1040] = {.lex_state = 114, .external_lex_state = 1},
  [1041] = {.lex_state = 114, .external_lex_state = 1},
  [1042] = {.lex_state = 13, .external_lex_state = 1},
  [1043] = {.lex_state = 114, .external_lex_state = 1},
  [1044] = {.lex_state = 114, .external_lex_state = 1},
  [1045] = {.lex_state = 114, .external_lex_state = 1},
  [1046] = {.lex_state = 114, .external_lex_state = 1},
  [1047] = {.lex_state = 114, .external_lex_state = 1},
  [1048] = {.lex_state = 114, .external_lex_state = 1},
  [1049] = {.lex_state = 114, .external_lex_state = 1},
  [1050] = {.lex_state = 114, .external_lex_state = 1},
  [1051] = {.lex_state = 114, .external_lex_state = 1},
  [1052] = {.lex_state = 114, .external_lex_state = 1},
  [1053] = {.lex_state = 114, .external_lex_state = 1},
  [1054] = {.lex_state = 114, .external_lex_state = 1},
  [1055] = {.lex_state = 114, .external_lex_state = 1},
  [1056] = {.lex_state = 114, .external_lex_state = 1},
  [1057] = {.lex_state = 114, .external_lex_state = 1},
  [1058] = {.lex_state = 114, .external_lex_state = 1},
  [1059] = {.lex_state = 114, .external_lex_state = 1},
  [1060] = {.lex_state = 114, .external_lex_state = 1},
  [1061] = {.lex_state = 114, .external_lex_state = 1},
  [1062] = {.lex_state = 110, .external_lex_state = 1},
  [1063] = {.lex_state = 114, .external_lex_state = 1},
  [1064] = {.lex_state = 114, .external_lex_state = 1},
  [1065] = {.lex_state = 114, .external_lex_state = 1},
  [1066] = {.lex_state = 114, .external_lex_state = 1},
  [1067] = {.lex_state = 114, .external_lex_state = 1},
  [1068] = {.lex_state = 113, .external_lex_state = 2},
  [1069] = {.lex_state = 114, .external_lex_state = 1},
  [1070] = {.lex_state = 114, .external_lex_state = 1},
  [1071] = {.lex_state = 114, .external_lex_state = 1},
  [1072] = {.lex_state = 114, .external_lex_state = 1},
  [1073] = {.lex_state = 114, .external_lex_state = 1},
  [1074] = {.lex_state = 114, .external_lex_state = 1},
  [1075] = {.lex_state = 114, .external_lex_state = 1},
  [1076] = {.lex_state = 114, .external_lex_state = 1},
  [1077] = {.lex_state = 114, .external_lex_state = 1},
  [1078] = {.lex_state = 114, .external_lex_state = 1},
  [1079] = {.lex_state = 114, .external_lex_state = 1},
  [1080] = {.lex_state = 114, .external_lex_state = 1},
  [1081] = {.lex_state = 114, .external_lex_state = 1},
  [1082] = {.lex_state = 114, .external_lex_state = 1},
  [1083] = {.lex_state = 114, .external_lex_state = 1},
  [1084] = {.lex_state = 114, .external_lex_state = 1},
  [1085] = {.lex_state = 114, .external_lex_state = 1},
  [1086] = {.lex_state = 114, .external_lex_state = 1},
  [1087] = {.lex_state = 114, .external_lex_state = 1},
  [1088] = {.lex_state = 114, .external_lex_state = 1},
  [1089] = {.lex_state = 114, .external_lex_state = 1},
  [1090] = {.lex_state = 114, .external_lex_state = 1},
  [1091] = {.lex_state = 114, .external_lex_state = 1},
  [1092] = {.lex_state = 114, .external_lex_state = 1},
  [1093] = {.lex_state = 14, .external_lex_state = 1},
  [1094] = {.lex_state = 114, .external_lex_state = 1},
  [1095] = {.lex_state = 114, .external_lex_state = 1},
  [1096] = {.lex_state = 18, .external_lex_state = 1},
  [1097] = {.lex_state = 113, .external_lex_state = 2},
  [1098] = {.lex_state = 25, .external_lex_state = 1},
  [1099] = {.lex_state = 25, .external_lex_state = 1},
  [1100] = {.lex_state = 2, .external_lex_state = 1},
  [1101] = {.lex_state = 25, .external_lex_state = 1},
  [1102] = {.lex_state = 108, .external_lex_state = 1},
  [1103] = {.lex_state = 113, .external_lex_state = 2},
  [1104] = {.lex_state = 113, .external_lex_state = 2},
  [1105] = {.lex_state = 2, .external_lex_state = 1},
  [1106] = {.lex_state = 117, .external_lex_state = 2},
  [1107] = {.lex_state = 21, .external_lex_state = 1},
  [1108] = {.lex_state = 117, .external_lex_state = 1},
  [1109] = {.lex_state = 117, .external_lex_state = 1},
  [1110] = {.lex_state = 25, .external_lex_state = 1},
  [1111] = {.lex_state = 117, .external_lex_state = 2},
  [1112] = {.lex_state = 117, .external_lex_state = 2},
  [1113] = {.lex_state = 17, .external_lex_state = 1},
  [1114] = {.lex_state = 25, .external_lex_state = 1},
  [1115] = {.lex_state = 1, .external_lex_state = 1},
  [1116] = {.lex_state = 117, .external_lex_state = 2},
  [1117] = {.lex_state = 117, .external_lex_state = 2},
  [1118] = {.lex_state = 117, .external_lex_state = 2},
  [1119] = {.lex_state = 25, .external_lex_state = 1},
  [1120] = {.lex_state = 25, .external_lex_state = 1},
  [1121] = {.lex_state = 117, .external_lex_state = 2},
  [1122] = {.lex_state = 117, .external_lex_state = 2},
  [1123] = {.lex_state = 117, .external_lex_state = 2},
  [1124] = {.lex_state = 25, .external_lex_state = 1},
  [1125] = {.lex_state = 117, .external_lex_state = 2},
  [1126] = {.lex_state = 25, .external_lex_state = 1},
  [1127] = {.lex_state = 25, .external_lex_state = 1},
  [1128] = {.lex_state = 117, .external_lex_state = 2},
  [1129] = {.lex_state = 117, .external_lex_state = 2},
  [1130] = {.lex_state = 117, .external_lex_state = 1},
  [1131] = {.lex_state = 117, .external_lex_state = 2},
  [1132] = {.lex_state = 117, .external_lex_state = 2},
  [1133] = {.lex_state = 25, .external_lex_state = 1},
  [1134] = {.lex_state = 117, .external_lex_state = 2},
  [1135] = {.lex_state = 117, .external_lex_state = 2},
  [1136] = {.lex_state = 25, .external_lex_state = 1},
  [1137] = {.lex_state = 25, .external_lex_state = 1},
  [1138] = {.lex_state = 109, .external_lex_state = 1},
  [1139] = {.lex_state = 25, .external_lex_state = 1},
  [1140] = {.lex_state = 25, .external_lex_state = 1},
  [1141] = {.lex_state = 25, .external_lex_state = 1},
  [1142] = {.lex_state = 25, .external_lex_state = 1},
  [1143] = {.lex_state = 25, .external_lex_state = 1},
  [1144] = {.lex_state = 25, .external_lex_state = 1},
  [1145] = {.lex_state = 25, .external_lex_state = 1},
  [1146] = {.lex_state = 25, .external_lex_state = 1},
  [1147] = {.lex_state = 25, .external_lex_state = 1},
  [1148] = {.lex_state = 25, .external_lex_state = 1},
  [1149] = {.lex_state = 25, .external_lex_state = 1},
  [1150] = {.lex_state = 25, .external_lex_state = 1},
  [1151] = {.lex_state = 25, .external_lex_state = 1},
  [1152] = {.lex_state = 25, .external_lex_state = 1},
  [1153] = {.lex_state = 117, .external_lex_state = 2},
  [1154] = {.lex_state = 117, .external_lex_state = 2},
  [1155] = {.lex_state = 117, .external_lex_state = 2},
  [1156] = {.lex_state = 25, .external_lex_state = 1},
  [1157] = {.lex_state = 117, .external_lex_state = 2},
  [1158] = {.lex_state = 117, .external_lex_state = 2},
  [1159] = {.lex_state = 117, .external_lex_state = 2},
  [1160] = {.lex_state = 117, .external_lex_state = 2},
  [1161] = {.lex_state = 117, .external_lex_state = 2},
  [1162] = {.lex_state = 117, .external_lex_state = 2},
  [1163] = {.lex_state = 117, .external_lex_state = 2},
  [1164] = {.lex_state = 25, .external_lex_state = 1},
  [1165] = {.lex_state = 117, .external_lex_state = 2},
  [1166] = {.lex_state = 117, .external_lex_state = 2},
  [1167] = {.lex_state = 117, .external_lex_state = 2},
  [1168] = {.lex_state = 114, .external_lex_state = 1},
  [1169] = {.lex_state = 25, .external_lex_state = 1},
  [1170] = {.lex_state = 117, .external_lex_state = 2},
  [1171] = {.lex_state = 117, .external_lex_state = 2},
  [1172] = {.lex_state = 117, .external_lex_state = 2},
  [1173] = {.lex_state = 117, .external_lex_state = 2},
  [1174] = {.lex_state = 117, .external_lex_state = 2},
  [1175] = {.lex_state = 25, .external_lex_state = 1},
  [1176] = {.lex_state = 117, .external_lex_state = 2},
  [1177] = {.lex_state = 117, .external_lex_state = 2},
  [1178] = {.lex_state = 117, .external_lex_state = 2},
  [1179] = {.lex_state = 117, .external_lex_state = 2},
  [1180] = {.lex_state = 117, .external_lex_state = 2},
  [1181] = {.lex_state = 117, .external_lex_state = 2},
  [1182] = {.lex_state = 117, .external_lex_state = 2},
  [1183] = {.lex_state = 117, .external_lex_state = 2},
  [1184] = {.lex_state = 117, .external_lex_state = 2},
  [1185] = {.lex_state = 117, .external_lex_state = 2},
  [1186] = {.lex_state = 117, .external_lex_state = 2},
  [1187] = {.lex_state = 38, .external_lex_state = 1},
  [1188] = {.lex_state = 117, .external_lex_state = 2},
  [1189] = {.lex_state = 25, .external_lex_state = 1},
  [1190] = {.lex_state = 117, .external_lex_state = 2},
  [1191] = {.lex_state = 117, .external_lex_state = 2},
  [1192] = {.lex_state = 114, .external_lex_state = 1},
  [1193] = {.lex_state = 117, .external_lex_state = 2},
  [1194] = {.lex_state = 117, .external_lex_state = 2},
  [1195] = {.lex_state = 117, .external_lex_state = 2},
  [1196] = {.lex_state = 117, .external_lex_state = 2},
  [1197] = {.lex_state = 117, .external_lex_state = 2},
  [1198] = {.lex_state = 117, .external_lex_state = 2},
  [1199] = {.lex_state = 117, .external_lex_state = 2},
  [1200] = {.lex_state = 117, .external_lex_state = 2},
  [1201] = {.lex_state = 117, .external_lex_state = 2},
  [1202] = {.lex_state = 117, .external_lex_state = 2},
  [1203] = {.lex_state = 117, .external_lex_state = 2},
  [1204] = {.lex_state = 117, .external_lex_state = 2},
  [1205] = {.lex_state = 117, .external_lex_state = 2},
  [1206] = {.lex_state = 117, .external_lex_state = 2},
  [1207] = {.lex_state = 117, .external_lex_state = 2},
  [1208] = {.lex_state = 117, .external_lex_state = 2},
  [1209] = {.lex_state = 117, .external_lex_state = 2},
  [1210] = {.lex_state = 117, .external_lex_state = 2},
  [1211] = {.lex_state = 117, .external_lex_state = 2},
  [1212] = {.lex_state = 117, .external_lex_state = 2},
  [1213] = {.lex_state = 117, .external_lex_state = 2},
  [1214] = {.lex_state = 117, .external_lex_state = 2},
  [1215] = {.lex_state = 117, .external_lex_state = 2},
  [1216] = {.lex_state = 117, .external_lex_state = 2},
  [1217] = {.lex_state = 117, .external_lex_state = 2},
  [1218] = {.lex_state = 117, .external_lex_state = 2},
  [1219] = {.lex_state = 117, .external_lex_state = 2},
  [1220] = {.lex_state = 117, .external_lex_state = 2},
  [1221] = {.lex_state = 117, .external_lex_state = 2},
  [1222] = {.lex_state = 117, .external_lex_state = 2},
  [1223] = {.lex_state = 117, .external_lex_state = 2},
  [1224] = {.lex_state = 15, .external_lex_state = 1},
  [1225] = {.lex_state = 117, .external_lex_state = 2},
  [1226] = {.lex_state = 117, .external_lex_state = 2},
  [1227] = {.lex_state = 4, .external_lex_state = 1},
  [1228] = {.lex_state = 25, .external_lex_state = 1},
  [1229] = {.lex_state = 25, .external_lex_state = 1},
  [1230] = {.lex_state = 25, .external_lex_state = 1},
  [1231] = {.lex_state = 25, .external_lex_state = 1},
  [1232] = {.lex_state = 117, .external_lex_state = 2},
  [1233] = {.lex_state = 25, .external_lex_state = 1},
  [1234] = {.lex_state = 117, .external_lex_state = 2},
  [1235] = {.lex_state = 25, .external_lex_state = 1},
  [1236] = {.lex_state = 117, .external_lex_state = 2},
  [1237] = {.lex_state = 117, .external_lex_state = 2},
  [1238] = {.lex_state = 117, .external_lex_state = 2},
  [1239] = {.lex_state = 117, .external_lex_state = 2},
  [1240] = {.lex_state = 117, .external_lex_state = 2},
  [1241] = {.lex_state = 25, .external_lex_state = 1},
  [1242] = {.lex_state = 25, .external_lex_state = 1},
  [1243] = {.lex_state = 25, .external_lex_state = 1},
  [1244] = {.lex_state = 38, .external_lex_state = 1},
  [1245] = {.lex_state = 25, .external_lex_state = 1},
  [1246] = {.lex_state = 18, .external_lex_state = 1},
  [1247] = {.lex_state = 25, .external_lex_state = 1},
  [1248] = {.lex_state = 25, .external_lex_state = 1},
  [1249] = {.lex_state = 25, .external_lex_state = 1},
  [1250] = {.lex_state = 25, .external_lex_state = 1},
  [1251] = {.lex_state = 117, .external_lex_state = 2},
  [1252] = {.lex_state = 24, .external_lex_state = 2},
  [1253] = {.lex_state = 117, .external_lex_state = 2},
  [1254] = {.lex_state = 114, .external_lex_state = 1},
  [1255] = {.lex_state = 25, .external_lex_state = 1},
  [1256] = {.lex_state = 117, .external_lex_state = 2},
  [1257] = {.lex_state = 117, .external_lex_state = 2},
  [1258] = {.lex_state = 117, .external_lex_state = 2},
  [1259] = {.lex_state = 117, .external_lex_state = 2},
  [1260] = {.lex_state = 117, .external_lex_state = 2},
  [1261] = {.lex_state = 117, .external_lex_state = 2},
  [1262] = {.lex_state = 25, .external_lex_state = 1},
  [1263] = {.lex_state = 25, .external_lex_state = 1},
  [1264] = {.lex_state = 25, .external_lex_state = 1},
  [1265] = {.lex_state = 25, .external_lex_state = 1},
  [1266] = {.lex_state = 117, .external_lex_state = 2},
  [1267] = {.lex_state = 4, .external_lex_state = 1},
  [1268] = {.lex_state = 117, .external_lex_state = 2},
  [1269] = {.lex_state = 117, .external_lex_state = 2},
  [1270] = {.lex_state = 117, .external_lex_state = 2},
  [1271] = {.lex_state = 117, .external_lex_state = 2},
  [1272] = {.lex_state = 117, .external_lex_state = 2},
  [1273] = {.lex_state = 25, .external_lex_state = 1},
  [1274] = {.lex_state = 117, .external_lex_state = 2},
  [1275] = {.lex_state = 117, .external_lex_state = 2},
  [1276] = {.lex_state = 117, .external_lex_state = 2},
  [1277] = {.lex_state = 117, .external_lex_state = 2},
  [1278] = {.lex_state = 117, .external_lex_state = 2},
  [1279] = {.lex_state = 117, .external_lex_state = 2},
  [1280] = {.lex_state = 117, .external_lex_state = 2},
  [1281] = {.lex_state = 117, .external_lex_state = 2},
  [1282] = {.lex_state = 117, .external_lex_state = 2},
  [1283] = {.lex_state = 117, .external_lex_state = 2},
  [1284] = {.lex_state = 38, .external_lex_state = 1},
  [1285] = {.lex_state = 117, .external_lex_state = 2},
  [1286] = {.lex_state = 117, .external_lex_state = 2},
  [1287] = {.lex_state = 117, .external_lex_state = 2},
  [1288] = {.lex_state = 117, .external_lex_state = 2},
  [1289] = {.lex_state = 117, .external_lex_state = 2},
  [1290] = {.lex_state = 117, .external_lex_state = 2},
  [1291] = {.lex_state = 117, .external_lex_state = 2},
  [1292] = {.lex_state = 117, .external_lex_state = 2},
  [1293] = {.lex_state = 117, .external_lex_state = 2},
  [1294] = {.lex_state = 117, .external_lex_state = 2},
  [1295] = {.lex_state = 117, .external_lex_state = 2},
  [1296] = {.lex_state = 117, .external_lex_state = 2},
  [1297] = {.lex_state = 117, .external_lex_state = 2},
  [1298] = {.lex_state = 117, .external_lex_state = 2},
  [1299] = {.lex_state = 117, .external_lex_state = 2},
  [1300] = {.lex_state = 25, .external_lex_state = 1},
  [1301] = {.lex_state = 117, .external_lex_state = 2},
  [1302] = {.lex_state = 25, .external_lex_state = 1},
  [1303] = {.lex_state = 25, .external_lex_state = 1},
  [1304] = {.lex_state = 25, .external_lex_state = 1},
  [1305] = {.lex_state = 117, .external_lex_state = 2},
  [1306] = {.lex_state = 117, .external_lex_state = 2},
  [1307] = {.lex_state = 117, .external_lex_state = 2},
  [1308] = {.lex_state = 117, .external_lex_state = 2},
  [1309] = {.lex_state = 4, .external_lex_state = 1},
  [1310] = {.lex_state = 117, .external_lex_state = 2},
  [1311] = {.lex_state = 117, .external_lex_state = 2},
  [1312] = {.lex_state = 4, .external_lex_state = 1},
  [1313] = {.lex_state = 4, .external_lex_state = 1},
  [1314] = {.lex_state = 24, .external_lex_state = 2},
  [1315] = {.lex_state = 8, .external_lex_state = 1},
  [1316] = {.lex_state = 114, .external_lex_state = 1},
  [1317] = {.lex_state = 114, .external_lex_state = 1},
  [1318] = {.lex_state = 114, .external_lex_state = 1},
  [1319] = {.lex_state = 38, .external_lex_state = 1},
  [1320] = {.lex_state = 38, .external_lex_state = 1},
  [1321] = {.lex_state = 38, .external_lex_state = 1},
  [1322] = {.lex_state = 114, .external_lex_state = 1},
  [1323] = {.lex_state = 114, .external_lex_state = 1},
  [1324] = {.lex_state = 38, .external_lex_state = 1},
  [1325] = {.lex_state = 38, .external_lex_state = 1},
  [1326] = {.lex_state = 38, .external_lex_state = 1},
  [1327] = {.lex_state = 38, .external_lex_state = 1},
  [1328] = {.lex_state = 38, .external_lex_state = 1},
  [1329] = {.lex_state = 38, .external_lex_state = 1},
  [1330] = {.lex_state = 38, .external_lex_state = 1},
  [1331] = {.lex_state = 38, .external_lex_state = 1},
  [1332] = {.lex_state = 38, .external_lex_state = 1},
  [1333] = {.lex_state = 38, .external_lex_state = 1},
  [1334] = {.lex_state = 38, .external_lex_state = 1},
  [1335] = {.lex_state = 38, .external_lex_state = 1},
  [1336] = {.lex_state = 38, .external_lex_state = 1},
  [1337] = {.lex_state = 38, .external_lex_state = 1},
  [1338] = {.lex_state = 38, .external_lex_state = 1},
  [1339] = {.lex_state = 38, .external_lex_state = 1},
  [1340] = {.lex_state = 114, .external_lex_state = 1},
  [1341] = {.lex_state = 114, .external_lex_state = 1},
  [1342] = {.lex_state = 38, .external_lex_state = 1},
  [1343] = {.lex_state = 114, .external_lex_state = 1},
  [1344] = {.lex_state = 114, .external_lex_state = 1},
  [1345] = {.lex_state = 114, .external_lex_state = 1},
  [1346] = {.lex_state = 114, .external_lex_state = 1},
  [1347] = {.lex_state = 114, .external_lex_state = 1},
  [1348] = {.lex_state = 114, .external_lex_state = 1},
  [1349] = {.lex_state = 38, .external_lex_state = 1},
  [1350] = {.lex_state = 38, .external_lex_state = 1},
  [1351] = {.lex_state = 114, .external_lex_state = 1},
  [1352] = {.lex_state = 114, .external_lex_state = 1},
  [1353] = {.lex_state = 114, .external_lex_state = 1},
  [1354] = {.lex_state = 114, .external_lex_state = 1},
  [1355] = {.lex_state = 114, .external_lex_state = 1},
  [1356] = {.lex_state = 114, .external_lex_state = 1},
  [1357] = {.lex_state = 114, .external_lex_state = 1},
  [1358] = {.lex_state = 24, .external_lex_state = 2},
  [1359] = {.lex_state = 24, .external_lex_state = 2},
  [1360] = {.lex_state = 114, .external_lex_state = 1},
  [1361] = {.lex_state = 38, .external_lex_state = 1},
  [1362] = {.lex_state = 114, .external_lex_state = 1},
  [1363] = {.lex_state = 114, .external_lex_state = 1},
  [1364] = {.lex_state = 42, .external_lex_state = 1},
  [1365] = {.lex_state = 4, .external_lex_state = 1},
  [1366] = {.lex_state = 4, .external_lex_state = 1},
  [1367] = {.lex_state = 4, .external_lex_state = 1},
  [1368] = {.lex_state = 4, .external_lex_state = 1},
  [1369] = {.lex_state = 4, .external_lex_state = 1},
  [1370] = {.lex_state = 4, .external_lex_state = 1},
  [1371] = {.lex_state = 4, .external_lex_state = 1},
  [1372] = {.lex_state = 4, .external_lex_state = 1},
  [1373] = {.lex_state = 4, .external_lex_state = 1},
  [1374] = {.lex_state = 4, .external_lex_state = 1},
  [1375] = {.lex_state = 4, .external_lex_state = 1},
  [1376] = {.lex_state = 4, .external_lex_state = 1},
  [1377] = {.lex_state = 4, .external_lex_state = 1},
  [1378] = {.lex_state = 4, .external_lex_state = 1},
  [1379] = {.lex_state = 4, .external_lex_state = 1},
  [1380] = {.lex_state = 4, .external_lex_state = 1},
  [1381] = {.lex_state = 4, .external_lex_state = 1},
  [1382] = {.lex_state = 4, .external_lex_state = 1},
  [1383] = {.lex_state = 4, .external_lex_state = 1},
  [1384] = {.lex_state = 4, .external_lex_state = 1},
  [1385] = {.lex_state = 38, .external_lex_state = 1},
  [1386] = {.lex_state = 4, .external_lex_state = 1},
  [1387] = {.lex_state = 110, .external_lex_state = 1},
  [1388] = {.lex_state = 4, .external_lex_state = 1},
  [1389] = {.lex_state = 16, .external_lex_state = 1},
  [1390] = {.lex_state = 114, .external_lex_state = 1},
  [1391] = {.lex_state = 38, .external_lex_state = 1},
  [1392] = {.lex_state = 4, .external_lex_state = 1},
  [1393] = {.lex_state = 33, .external_lex_state = 1},
  [1394] = {.lex_state = 117, .external_lex_state = 2},
  [1395] = {.lex_state = 28, .external_lex_state = 2},
  [1396] = {.lex_state = 28, .external_lex_state = 2},
  [1397] = {.lex_state = 117, .external_lex_state = 2},
  [1398] = {.lex_state = 28, .external_lex_state = 2},
  [1399] = {.lex_state = 4, .external_lex_state = 1},
  [1400] = {.lex_state = 28, .external_lex_state = 2},
  [1401] = {.lex_state = 33, .external_lex_state = 1},
  [1402] = {.lex_state = 28, .external_lex_state = 2},
  [1403] = {.lex_state = 4, .external_lex_state = 1},
  [1404] = {.lex_state = 28, .external_lex_state = 2},
  [1405] = {.lex_state = 4, .external_lex_state = 1},
  [1406] = {.lex_state = 4, .external_lex_state = 1},
  [1407] = {.lex_state = 4, .external_lex_state = 1},
  [1408] = {.lex_state = 114, .external_lex_state = 1},
  [1409] = {.lex_state = 4, .external_lex_state = 1},
  [1410] = {.lex_state = 4, .external_lex_state = 1},
  [1411] = {.lex_state = 114, .external_lex_state = 1},
  [1412] = {.lex_state = 4, .external_lex_state = 1},
  [1413] = {.lex_state = 4, .external_lex_state = 1},
  [1414] = {.lex_state = 4, .external_lex_state = 1},
  [1415] = {.lex_state = 28, .external_lex_state = 2},
  [1416] = {.lex_state = 4, .external_lex_state = 1},
  [1417] = {.lex_state = 4, .external_lex_state = 1},
  [1418] = {.lex_state = 4, .external_lex_state = 1},
  [1419] = {.lex_state = 4, .external_lex_state = 1},
  [1420] = {.lex_state = 4, .external_lex_state = 1},
  [1421] = {.lex_state = 4, .external_lex_state = 1},
  [1422] = {.lex_state = 4, .external_lex_state = 1},
  [1423] = {.lex_state = 38, .external_lex_state = 1},
  [1424] = {.lex_state = 114, .external_lex_state = 1},
  [1425] = {.lex_state = 41, .external_lex_state = 2},
  [1426] = {.lex_state = 38, .external_lex_state = 1},
  [1427] = {.lex_state = 114, .external_lex_state = 1},
  [1428] = {.lex_state = 114, .external_lex_state = 1},
  [1429] = {.lex_state = 28, .external_lex_state = 2},
  [1430] = {.lex_state = 28, .external_lex_state = 2},
  [1431] = {.lex_state = 114, .external_lex_state = 1},
  [1432] = {.lex_state = 33, .external_lex_state = 1},
  [1433] = {.lex_state = 114, .external_lex_state = 1},
  [1434] = {.lex_state = 114, .external_lex_state = 1},
  [1435] = {.lex_state = 114, .external_lex_state = 1},
  [1436] = {.lex_state = 38, .external_lex_state = 1},
  [1437] = {.lex_state = 38, .external_lex_state = 1},
  [1438] = {.lex_state = 38, .external_lex_state = 1},
  [1439] = {.lex_state = 114, .external_lex_state = 1},
  [1440] = {.lex_state = 4, .external_lex_state = 1},
  [1441] = {.lex_state = 38, .external_lex_state = 1},
  [1442] = {.lex_state = 38, .external_lex_state = 1},
  [1443] = {.lex_state = 117, .external_lex_state = 2},
  [1444] = {.lex_state = 38, .external_lex_state = 1},
  [1445] = {.lex_state = 38, .external_lex_state = 1},
  [1446] = {.lex_state = 38, .external_lex_state = 1},
  [1447] = {.lex_state = 38, .external_lex_state = 1},
  [1448] = {.lex_state = 4, .external_lex_state = 1},
  [1449] = {.lex_state = 38, .external_lex_state = 1},
  [1450] = {.lex_state = 4, .external_lex_state = 1},
  [1451] = {.lex_state = 4, .external_lex_state = 1},
  [1452] = {.lex_state = 4, .external_lex_state = 1},
  [1453] = {.lex_state = 114, .external_lex_state = 1},
  [1454] = {.lex_state = 114, .external_lex_state = 1},
  [1455] = {.lex_state = 114, .external_lex_state = 1},
  [1456] = {.lex_state = 114, .external_lex_state = 1},
  [1457] = {.lex_state = 114, .external_lex_state = 1},
  [1458] = {.lex_state = 114, .external_lex_state = 1},
  [1459] = {.lex_state = 114, .external_lex_state = 1},
  [1460] = {.lex_state = 4, .external_lex_state = 1},
  [1461] = {.lex_state = 38, .external_lex_state = 1},
  [1462] = {.lex_state = 38, .external_lex_state = 1},
  [1463] = {.lex_state = 38, .external_lex_state = 1},
  [1464] = {.lex_state = 20, .external_lex_state = 1},
  [1465] = {.lex_state = 38, .external_lex_state = 1},
  [1466] = {.lex_state = 4, .external_lex_state = 1},
  [1467] = {.lex_state = 38, .external_lex_state = 1},
  [1468] = {.lex_state = 114, .external_lex_state = 1},
  [1469] = {.lex_state = 28, .external_lex_state = 2},
  [1470] = {.lex_state = 114, .external_lex_state = 1},
  [1471] = {.lex_state = 114, .external_lex_state = 1},
  [1472] = {.lex_state = 38, .external_lex_state = 1},
  [1473] = {.lex_state = 114, .external_lex_state = 1},
  [1474] = {.lex_state = 28, .external_lex_state = 2},
  [1475] = {.lex_state = 28, .external_lex_state = 2},
  [1476] = {.lex_state = 114, .external_lex_state = 1},
  [1477] = {.lex_state = 114, .external_lex_state = 1},
  [1478] = {.lex_state = 38, .external_lex_state = 1},
  [1479] = {.lex_state = 7, .external_lex_state = 2},
  [1480] = {.lex_state = 28, .external_lex_state = 2},
  [1481] = {.lex_state = 38, .external_lex_state = 1},
  [1482] = {.lex_state = 38, .external_lex_state = 1},
  [1483] = {.lex_state = 114, .external_lex_state = 1},
  [1484] = {.lex_state = 114, .external_lex_state = 1},
  [1485] = {.lex_state = 38, .external_lex_state = 1},
  [1486] = {.lex_state = 4, .external_lex_state = 1},
  [1487] = {.lex_state = 38, .external_lex_state = 1},
  [1488] = {.lex_state = 4, .external_lex_state = 1},
  [1489] = {.lex_state = 28, .external_lex_state = 2},
  [1490] = {.lex_state = 113, .external_lex_state = 2},
  [1491] = {.lex_state = 4, .external_lex_state = 1},
  [1492] = {.lex_state = 28, .external_lex_state = 2},
  [1493] = {.lex_state = 28, .external_lex_state = 2},
  [1494] = {.lex_state = 38, .external_lex_state = 1},
  [1495] = {.lex_state = 114, .external_lex_state = 1},
  [1496] = {.lex_state = 38, .external_lex_state = 1},
  [1497] = {.lex_state = 117, .external_lex_state = 2},
  [1498] = {.lex_state = 38, .external_lex_state = 1},
  [1499] = {.lex_state = 28, .external_lex_state = 2},
  [1500] = {.lex_state = 28, .external_lex_state = 2},
  [1501] = {.lex_state = 38, .external_lex_state = 1},
  [1502] = {.lex_state = 38, .external_lex_state = 1},
  [1503] = {.lex_state = 4, .external_lex_state = 1},
  [1504] = {.lex_state = 28, .external_lex_state = 1},
  [1505] = {.lex_state = 28, .external_lex_state = 1},
  [1506] = {.lex_state = 28, .external_lex_state = 1},
  [1507] = {.lex_state = 114, .external_lex_state = 1},
  [1508] = {.lex_state = 114, .external_lex_state = 1},
  [1509] = {.lex_state = 114, .external_lex_state = 1},
  [1510] = {.lex_state = 28, .external_lex_state = 2},
  [1511] = {.lex_state = 28, .external_lex_state = 2},
  [1512] = {.lex_state = 28, .external_lex_state = 2},
  [1513] = {.lex_state = 28, .external_lex_state = 2},
  [1514] = {.lex_state = 28, .external_lex_state = 2},
  [1515] = {.lex_state = 28, .external_lex_state = 2},
  [1516] = {.lex_state = 28, .external_lex_state = 2},
  [1517] = {.lex_state = 28, .external_lex_state = 2},
  [1518] = {.lex_state = 33, .external_lex_state = 1},
  [1519] = {.lex_state = 28, .external_lex_state = 2},
  [1520] = {.lex_state = 28, .external_lex_state = 2},
  [1521] = {.lex_state = 28, .external_lex_state = 2},
  [1522] = {.lex_state = 28, .external_lex_state = 2},
  [1523] = {.lex_state = 28, .external_lex_state = 2},
  [1524] = {.lex_state = 28, .external_lex_state = 2},
  [1525] = {.lex_state = 28, .external_lex_state = 2},
  [1526] = {.lex_state = 28, .external_lex_state = 2},
  [1527] = {.lex_state = 28, .external_lex_state = 2},
  [1528] = {.lex_state = 28, .external_lex_state = 2},
  [1529] = {.lex_state = 28, .external_lex_state = 2},
  [1530] = {.lex_state = 28, .external_lex_state = 2},
  [1531] = {.lex_state = 28, .external_lex_state = 2},
  [1532] = {.lex_state = 28, .external_lex_state = 2},
  [1533] = {.lex_state = 28, .external_lex_state = 2},
  [1534] = {.lex_state = 28, .external_lex_state = 2},
  [1535] = {.lex_state = 113, .external_lex_state = 2},
  [1536] = {.lex_state = 7, .external_lex_state = 2},
  [1537] = {.lex_state = 28, .external_lex_state = 2},
  [1538] = {.lex_state = 28, .external_lex_state = 2},
  [1539] = {.lex_state = 28, .external_lex_state = 2},
  [1540] = {.lex_state = 28, .external_lex_state = 2},
  [1541] = {.lex_state = 28, .external_lex_state = 2},
  [1542] = {.lex_state = 28, .external_lex_state = 2},
  [1543] = {.lex_state = 33, .external_lex_state = 1},
  [1544] = {.lex_state = 28, .external_lex_state = 2},
  [1545] = {.lex_state = 28, .external_lex_state = 2},
  [1546] = {.lex_state = 113, .external_lex_state = 2},
  [1547] = {.lex_state = 113, .external_lex_state = 2},
  [1548] = {.lex_state = 117, .external_lex_state = 2},
  [1549] = {.lex_state = 28, .external_lex_state = 2},
  [1550] = {.lex_state = 28, .external_lex_state = 2},
  [1551] = {.lex_state = 28, .external_lex_state = 2},
  [1552] = {.lex_state = 41, .external_lex_state = 2},
  [1553] = {.lex_state = 28, .external_lex_state = 2},
  [1554] = {.lex_state = 28, .external_lex_state = 2},
  [1555] = {.lex_state = 33, .external_lex_state = 1},
  [1556] = {.lex_state = 33, .external_lex_state = 1},
  [1557] = {.lex_state = 117, .external_lex_state = 2},
  [1558] = {.lex_state = 33, .external_lex_state = 1},
  [1559] = {.lex_state = 33, .external_lex_state = 1},
  [1560] = {.lex_state = 33, .external_lex_state = 1},
  [1561] = {.lex_state = 33, .external_lex_state = 1},
  [1562] = {.lex_state = 28, .external_lex_state = 2},
  [1563] = {.lex_state = 28, .external_lex_state = 2},
  [1564] = {.lex_state = 33, .external_lex_state = 1},
  [1565] = {.lex_state = 33, .external_lex_state = 1},
  [1566] = {.lex_state = 28, .external_lex_state = 2},
  [1567] = {.lex_state = 28, .external_lex_state = 2},
  [1568] = {.lex_state = 28, .external_lex_state = 2},
  [1569] = {.lex_state = 28, .external_lex_state = 2},
  [1570] = {.lex_state = 28, .external_lex_state = 2},
  [1571] = {.lex_state = 28, .external_lex_state = 2},
  [1572] = {.lex_state = 28, .external_lex_state = 2},
  [1573] = {.lex_state = 28, .external_lex_state = 2},
  [1574] = {.lex_state = 19, .external_lex_state = 1},
  [1575] = {.lex_state = 28, .external_lex_state = 2},
  [1576] = {.lex_state = 33, .external_lex_state = 1},
  [1577] = {.lex_state = 33, .external_lex_state = 1},
  [1578] = {.lex_state = 28, .external_lex_state = 2},
  [1579] = {.lex_state = 41, .external_lex_state = 2},
  [1580] = {.lex_state = 33, .external_lex_state = 1},
  [1581] = {.lex_state = 33, .external_lex_state = 1},
  [1582] = {.lex_state = 33, .external_lex_state = 1},
  [1583] = {.lex_state = 117, .external_lex_state = 2},
  [1584] = {.lex_state = 28, .external_lex_state = 2},
  [1585] = {.lex_state = 33, .external_lex_state = 1},
  [1586] = {.lex_state = 33, .external_lex_state = 1},
  [1587] = {.lex_state = 28, .external_lex_state = 2},
  [1588] = {.lex_state = 28, .external_lex_state = 2},
  [1589] = {.lex_state = 33, .external_lex_state = 1},
  [1590] = {.lex_state = 41, .external_lex_state = 2},
  [1591] = {.lex_state = 29, .external_lex_state = 1},
  [1592] = {.lex_state = 28, .external_lex_state = 2},
  [1593] = {.lex_state = 28, .external_lex_state = 2},
  [1594] = {.lex_state = 28, .external_lex_state = 2},
  [1595] = {.lex_state = 33, .external_lex_state = 1},
  [1596] = {.lex_state = 28, .external_lex_state = 2},
  [1597] = {.lex_state = 33, .external_lex_state = 1},
  [1598] = {.lex_state = 33, .external_lex_state = 1},
  [1599] = {.lex_state = 28, .external_lex_state = 2},
  [1600] = {.lex_state = 28, .external_lex_state = 2},
  [1601] = {.lex_state = 33, .external_lex_state = 1},
  [1602] = {.lex_state = 28, .external_lex_state = 2},
  [1603] = {.lex_state = 28, .external_lex_state = 2},
  [1604] = {.lex_state = 28, .external_lex_state = 2},
  [1605] = {.lex_state = 33, .external_lex_state = 1},
  [1606] = {.lex_state = 28, .external_lex_state = 2},
  [1607] = {.lex_state = 28, .external_lex_state = 2},
  [1608] = {.lex_state = 28, .external_lex_state = 2},
  [1609] = {.lex_state = 28, .external_lex_state = 2},
  [1610] = {.lex_state = 28, .external_lex_state = 2},
  [1611] = {.lex_state = 28, .external_lex_state = 2},
  [1612] = {.lex_state = 28, .external_lex_state = 2},
  [1613] = {.lex_state = 20, .external_lex_state = 1},
  [1614] = {.lex_state = 28, .external_lex_state = 2},
  [1615] = {.lex_state = 28, .external_lex_state = 2},
  [1616] = {.lex_state = 28, .external_lex_state = 2},
  [1617] = {.lex_state = 28, .external_lex_state = 2},
  [1618] = {.lex_state = 28, .external_lex_state = 2},
  [1619] = {.lex_state = 28, .external_lex_state = 2},
  [1620] = {.lex_state = 28, .external_lex_state = 2},
  [1621] = {.lex_state = 28, .external_lex_state = 2},
  [1622] = {.lex_state = 28, .external_lex_state = 2},
  [1623] = {.lex_state = 28, .external_lex_state = 2},
  [1624] = {.lex_state = 28, .external_lex_state = 2},
  [1625] = {.lex_state = 28, .external_lex_state = 2},
  [1626] = {.lex_state = 28, .external_lex_state = 2},
  [1627] = {.lex_state = 28, .external_lex_state = 2},
  [1628] = {.lex_state = 28, .external_lex_state = 2},
  [1629] = {.lex_state = 28, .external_lex_state = 2},
  [1630] = {.lex_state = 28, .external_lex_state = 2},
  [1631] = {.lex_state = 28, .external_lex_state = 2},
  [1632] = {.lex_state = 28, .external_lex_state = 2},
  [1633] = {.lex_state = 28, .external_lex_state = 2},
  [1634] = {.lex_state = 28, .external_lex_state = 2},
  [1635] = {.lex_state = 28, .external_lex_state = 2},
  [1636] = {.lex_state = 28, .external_lex_state = 2},
  [1637] = {.lex_state = 28, .external_lex_state = 2},
  [1638] = {.lex_state = 28, .external_lex_state = 2},
  [1639] = {.lex_state = 33, .external_lex_state = 1},
  [1640] = {.lex_state = 28, .external_lex_state = 2},
  [1641] = {.lex_state = 7, .external_lex_state = 2},
  [1642] = {.lex_state = 28, .external_lex_state = 2},
  [1643] = {.lex_state = 28, .external_lex_state = 2},
  [1644] = {.lex_state = 28, .external_lex_state = 2},
  [1645] = {.lex_state = 28, .external_lex_state = 2},
  [1646] = {.lex_state = 28, .external_lex_state = 2},
  [1647] = {.lex_state = 28, .external_lex_state = 2},
  [1648] = {.lex_state = 28, .external_lex_state = 2},
  [1649] = {.lex_state = 28, .external_lex_state = 2},
  [1650] = {.lex_state = 28, .external_lex_state = 2},
  [1651] = {.lex_state = 28, .external_lex_state = 2},
  [1652] = {.lex_state = 28, .external_lex_state = 2},
  [1653] = {.lex_state = 28, .external_lex_state = 2},
  [1654] = {.lex_state = 28, .external_lex_state = 2},
  [1655] = {.lex_state = 28, .external_lex_state = 2},
  [1656] = {.lex_state = 28, .external_lex_state = 2},
  [1657] = {.lex_state = 28, .external_lex_state = 2},
  [1658] = {.lex_state = 28, .external_lex_state = 2},
  [1659] = {.lex_state = 28, .external_lex_state = 2},
  [1660] = {.lex_state = 7, .external_lex_state = 2},
  [1661] = {.lex_state = 28, .external_lex_state = 2},
  [1662] = {.lex_state = 28, .external_lex_state = 2},
  [1663] = {.lex_state = 28, .external_lex_state = 2},
  [1664] = {.lex_state = 28, .external_lex_state = 2},
  [1665] = {.lex_state = 28, .external_lex_state = 2},
  [1666] = {.lex_state = 28, .external_lex_state = 2},
  [1667] = {.lex_state = 28, .external_lex_state = 2},
  [1668] = {.lex_state = 28, .external_lex_state = 2},
  [1669] = {.lex_state = 28, .external_lex_state = 2},
  [1670] = {.lex_state = 37, .external_lex_state = 1},
  [1671] = {.lex_state = 37, .external_lex_state = 1},
  [1672] = {.lex_state = 33, .external_lex_state = 1},
  [1673] = {.lex_state = 3, .external_lex_state = 2},
  [1674] = {.lex_state = 33, .external_lex_state = 1},
  [1675] = {.lex_state = 117, .external_lex_state = 2},
  [1676] = {.lex_state = 33, .external_lex_state = 1},
  [1677] = {.lex_state = 3, .external_lex_state = 2},
  [1678] = {.lex_state = 3, .external_lex_state = 2},
  [1679] = {.lex_state = 3, .external_lex_state = 2},
  [1680] = {.lex_state = 3, .external_lex_state = 2},
  [1681] = {.lex_state = 37, .external_lex_state = 2},
  [1682] = {.lex_state = 3, .external_lex_state = 2},
  [1683] = {.lex_state = 3, .external_lex_state = 2},
  [1684] = {.lex_state = 33, .external_lex_state = 1},
  [1685] = {.lex_state = 33, .external_lex_state = 1},
  [1686] = {.lex_state = 37, .external_lex_state = 2},
  [1687] = {.lex_state = 3, .external_lex_state = 2},
  [1688] = {.lex_state = 37, .external_lex_state = 2},
  [1689] = {.lex_state = 37, .external_lex_state = 2},
  [1690] = {.lex_state = 37, .external_lex_state = 2},
  [1691] = {.lex_state = 33, .external_lex_state = 1},
  [1692] = {.lex_state = 33, .external_lex_state = 1},
  [1693] = {.lex_state = 33, .external_lex_state = 1},
  [1694] = {.lex_state = 33, .external_lex_state = 1},
  [1695] = {.lex_state = 3, .external_lex_state = 1},
  [1696] = {.lex_state = 33, .external_lex_state = 1},
  [1697] = {.lex_state = 33, .external_lex_state = 1},
  [1698] = {.lex_state = 33, .external_lex_state = 1},
  [1699] = {.lex_state = 33, .external_lex_state = 1},
  [1700] = {.lex_state = 33, .external_lex_state = 1},
  [1701] = {.lex_state = 33, .external_lex_state = 1},
  [1702] = {.lex_state = 3, .external_lex_state = 1},
  [1703] = {.lex_state = 33, .external_lex_state = 1},
  [1704] = {.lex_state = 33, .external_lex_state = 1},
  [1705] = {.lex_state = 33, .external_lex_state = 1},
  [1706] = {.lex_state = 33, .external_lex_state = 1},
  [1707] = {.lex_state = 37, .external_lex_state = 2},
  [1708] = {.lex_state = 37, .external_lex_state = 2},
  [1709] = {.lex_state = 37, .external_lex_state = 2},
  [1710] = {.lex_state = 37, .external_lex_state = 2},
  [1711] = {.lex_state = 3, .external_lex_state = 2},
  [1712] = {.lex_state = 37, .external_lex_state = 2},
  [1713] = {.lex_state = 37, .external_lex_state = 2},
  [1714] = {.lex_state = 37, .external_lex_state = 2},
  [1715] = {.lex_state = 3, .external_lex_state = 2},
  [1716] = {.lex_state = 3, .external_lex_state = 2},
  [1717] = {.lex_state = 33, .external_lex_state = 1},
  [1718] = {.lex_state = 117, .external_lex_state = 1},
  [1719] = {.lex_state = 117, .external_lex_state = 1},
  [1720] = {.lex_state = 37, .external_lex_state = 2},
  [1721] = {.lex_state = 33, .external_lex_state = 1},
  [1722] = {.lex_state = 37, .external_lex_state = 2},
  [1723] = {.lex_state = 33, .external_lex_state = 1},
  [1724] = {.lex_state = 33, .external_lex_state = 1},
  [1725] = {.lex_state = 3, .external_lex_state = 2},
  [1726] = {.lex_state = 117, .external_lex_state = 2},
  [1727] = {.lex_state = 3, .external_lex_state = 1},
  [1728] = {.lex_state = 33, .external_lex_state = 1},
  [1729] = {.lex_state = 46, .external_lex_state = 1},
  [1730] = {.lex_state = 32, .external_lex_state = 2},
  [1731] = {.lex_state = 117, .external_lex_state = 1},
  [1732] = {.lex_state = 117, .external_lex_state = 2},
  [1733] = {.lex_state = 37, .external_lex_state = 2},
  [1734] = {.lex_state = 33, .external_lex_state = 1},
  [1735] = {.lex_state = 117, .external_lex_state = 2},
  [1736] = {.lex_state = 37, .external_lex_state = 2},
  [1737] = {.lex_state = 117, .external_lex_state = 2},
  [1738] = {.lex_state = 117, .external_lex_state = 2},
  [1739] = {.lex_state = 117, .external_lex_state = 2},
  [1740] = {.lex_state = 37, .external_lex_state = 1},
  [1741] = {.lex_state = 3, .external_lex_state = 2},
  [1742] = {.lex_state = 3, .external_lex_state = 2},
  [1743] = {.lex_state = 117, .external_lex_state = 2},
  [1744] = {.lex_state = 3, .external_lex_state = 2},
  [1745] = {.lex_state = 3, .external_lex_state = 2},
  [1746] = {.lex_state = 117, .external_lex_state = 2},
  [1747] = {.lex_state = 117, .external_lex_state = 2},
  [1748] = {.lex_state = 37, .external_lex_state = 2},
  [1749] = {.lex_state = 117, .external_lex_state = 2},
  [1750] = {.lex_state = 117, .external_lex_state = 2},
  [1751] = {.lex_state = 117, .external_lex_state = 2},
  [1752] = {.lex_state = 117, .external_lex_state = 2},
  [1753] = {.lex_state = 33, .external_lex_state = 1},
  [1754] = {.lex_state = 33, .external_lex_state = 1},
  [1755] = {.lex_state = 117, .external_lex_state = 2},
  [1756] = {.lex_state = 117, .external_lex_state = 2},
  [1757] = {.lex_state = 46, .external_lex_state = 1},
  [1758] = {.lex_state = 33, .external_lex_state = 1},
  [1759] = {.lex_state = 117, .external_lex_state = 2},
  [1760] = {.lex_state = 3, .external_lex_state = 2},
  [1761] = {.lex_state = 117, .external_lex_state = 2},
  [1762] = {.lex_state = 46, .external_lex_state = 1},
  [1763] = {.lex_state = 33, .external_lex_state = 1},
  [1764] = {.lex_state = 117, .external_lex_state = 2},
  [1765] = {.lex_state = 46, .external_lex_state = 1},
  [1766] = {.lex_state = 37, .external_lex_state = 2},
  [1767] = {.lex_state = 3, .external_lex_state = 2},
  [1768] = {.lex_state = 3, .external_lex_state = 2},
  [1769] = {.lex_state = 3, .external_lex_state = 2},
  [1770] = {.lex_state = 3, .external_lex_state = 2},
  [1771] = {.lex_state = 3, .external_lex_state = 2},
  [1772] = {.lex_state = 3, .external_lex_state = 2},
  [1773] = {.lex_state = 3, .external_lex_state = 2},
  [1774] = {.lex_state = 3, .external_lex_state = 2},
  [1775] = {.lex_state = 3, .external_lex_state = 2},
  [1776] = {.lex_state = 3, .external_lex_state = 2},
  [1777] = {.lex_state = 3, .external_lex_state = 2},
  [1778] = {.lex_state = 3, .external_lex_state = 2},
  [1779] = {.lex_state = 3, .external_lex_state = 2},
  [1780] = {.lex_state = 117, .external_lex_state = 2},
  [1781] = {.lex_state = 3, .external_lex_state = 2},
  [1782] = {.lex_state = 3, .external_lex_state = 2},
  [1783] = {.lex_state = 117, .external_lex_state = 2},
  [1784] = {.lex_state = 3, .external_lex_state = 2},
  [1785] = {.lex_state = 3, .external_lex_state = 2},
  [1786] = {.lex_state = 3, .external_lex_state = 2},
  [1787] = {.lex_state = 37, .external_lex_state = 2},
  [1788] = {.lex_state = 3, .external_lex_state = 2},
  [1789] = {.lex_state = 3, .external_lex_state = 2},
  [1790] = {.lex_state = 37, .external_lex_state = 2},
  [1791] = {.lex_state = 3, .external_lex_state = 2},
  [1792] = {.lex_state = 3, .external_lex_state = 2},
  [1793] = {.lex_state = 3, .external_lex_state = 2},
  [1794] = {.lex_state = 3, .external_lex_state = 2},
  [1795] = {.lex_state = 37, .external_lex_state = 2},
  [1796] = {.lex_state = 3, .external_lex_state = 2},
  [1797] = {.lex_state = 3, .external_lex_state = 2},
  [1798] = {.lex_state = 3, .external_lex_state = 2},
  [1799] = {.lex_state = 3, .external_lex_state = 2},
  [1800] = {.lex_state = 3, .external_lex_state = 2},
  [1801] = {.lex_state = 3, .external_lex_state = 2},
  [1802] = {.lex_state = 3, .external_lex_state = 2},
  [1803] = {.lex_state = 3, .external_lex_state = 2},
  [1804] = {.lex_state = 3, .external_lex_state = 2},
  [1805] = {.lex_state = 3, .external_lex_state = 2},
  [1806] = {.lex_state = 3, .external_lex_state = 2},
  [1807] = {.lex_state = 3, .external_lex_state = 2},
  [1808] = {.lex_state = 3, .external_lex_state = 2},
  [1809] = {.lex_state = 3, .external_lex_state = 2},
  [1810] = {.lex_state = 3, .external_lex_state = 2},
  [1811] = {.lex_state = 3, .external_lex_state = 2},
  [1812] = {.lex_state = 37, .external_lex_state = 2},
  [1813] = {.lex_state = 3, .external_lex_state = 2},
  [1814] = {.lex_state = 3, .external_lex_state = 2},
  [1815] = {.lex_state = 3, .external_lex_state = 2},
  [1816] = {.lex_state = 3, .external_lex_state = 2},
  [1817] = {.lex_state = 3, .external_lex_state = 2},
  [1818] = {.lex_state = 3, .external_lex_state = 2},
  [1819] = {.lex_state = 3, .external_lex_state = 2},
  [1820] = {.lex_state = 3, .external_lex_state = 2},
  [1821] = {.lex_state = 3, .external_lex_state = 2},
  [1822] = {.lex_state = 3, .external_lex_state = 2},
  [1823] = {.lex_state = 3, .external_lex_state = 2},
  [1824] = {.lex_state = 37, .external_lex_state = 2},
  [1825] = {.lex_state = 3, .external_lex_state = 2},
  [1826] = {.lex_state = 3, .external_lex_state = 2},
  [1827] = {.lex_state = 117, .external_lex_state = 2},
  [1828] = {.lex_state = 3, .external_lex_state = 2},
  [1829] = {.lex_state = 3, .external_lex_state = 2},
  [1830] = {.lex_state = 3, .external_lex_state = 2},
  [1831] = {.lex_state = 3, .external_lex_state = 2},
  [1832] = {.lex_state = 3, .external_lex_state = 2},
  [1833] = {.lex_state = 3, .external_lex_state = 2},
  [1834] = {.lex_state = 3, .external_lex_state = 2},
  [1835] = {.lex_state = 3, .external_lex_state = 2},
  [1836] = {.lex_state = 3, .external_lex_state = 2},
  [1837] = {.lex_state = 37, .external_lex_state = 2},
  [1838] = {.lex_state = 3, .external_lex_state = 2},
  [1839] = {.lex_state = 3, .external_lex_state = 2},
  [1840] = {.lex_state = 3, .external_lex_state = 2},
  [1841] = {.lex_state = 3, .external_lex_state = 2},
  [1842] = {.lex_state = 3, .external_lex_state = 2},
  [1843] = {.lex_state = 3, .external_lex_state = 2},
  [1844] = {.lex_state = 3, .external_lex_state = 2},
  [1845] = {.lex_state = 3, .external_lex_state = 2},
  [1846] = {.lex_state = 3, .external_lex_state = 2},
  [1847] = {.lex_state = 3, .external_lex_state = 2},
  [1848] = {.lex_state = 3, .external_lex_state = 2},
  [1849] = {.lex_state = 37, .external_lex_state = 2},
  [1850] = {.lex_state = 37, .external_lex_state = 2},
  [1851] = {.lex_state = 37, .external_lex_state = 2},
  [1852] = {.lex_state = 37, .external_lex_state = 2},
  [1853] = {.lex_state = 37, .external_lex_state = 2},
  [1854] = {.lex_state = 117, .external_lex_state = 2},
  [1855] = {.lex_state = 117, .external_lex_state = 2},
  [1856] = {.lex_state = 37, .external_lex_state = 2},
  [1857] = {.lex_state = 3, .external_lex_state = 2},
  [1858] = {.lex_state = 37, .external_lex_state = 2},
  [1859] = {.lex_state = 37, .external_lex_state = 2},
  [1860] = {.lex_state = 37, .external_lex_state = 2},
  [1861] = {.lex_state = 37, .external_lex_state = 2},
  [1862] = {.lex_state = 32, .external_lex_state = 2},
  [1863] = {.lex_state = 32, .external_lex_state = 2},
  [1864] = {.lex_state = 117, .external_lex_state = 2},
  [1865] = {.lex_state = 37, .external_lex_state = 2},
  [1866] = {.lex_state = 37, .external_lex_state = 2},
  [1867] = {.lex_state = 37, .external_lex_state = 2},
  [1868] = {.lex_state = 37, .external_lex_state = 2},
  [1869] = {.lex_state = 37, .external_lex_state = 2},
  [1870] = {.lex_state = 37, .external_lex_state = 2},
  [1871] = {.lex_state = 37, .external_lex_state = 2},
  [1872] = {.lex_state = 37, .external_lex_state = 2},
  [1873] = {.lex_state = 117, .external_lex_state = 2},
  [1874] = {.lex_state = 117, .external_lex_state = 2},
  [1875] = {.lex_state = 117, .external_lex_state = 2},
  [1876] = {.lex_state = 3, .external_lex_state = 2},
  [1877] = {.lex_state = 3, .external_lex_state = 2},
  [1878] = {.lex_state = 37, .external_lex_state = 2},
  [1879] = {.lex_state = 37, .external_lex_state = 2},
  [1880] = {.lex_state = 37, .external_lex_state = 2},
  [1881] = {.lex_state = 117, .external_lex_state = 2},
  [1882] = {.lex_state = 117, .external_lex_state = 2},
  [1883] = {.lex_state = 117, .external_lex_state = 2},
  [1884] = {.lex_state = 117, .external_lex_state = 2},
  [1885] = {.lex_state = 117, .external_lex_state = 2},
  [1886] = {.lex_state = 117, .external_lex_state = 2},
  [1887] = {.lex_state = 117, .external_lex_state = 2},
  [1888] = {.lex_state = 117, .external_lex_state = 2},
  [1889] = {.lex_state = 117, .external_lex_state = 2},
  [1890] = {.lex_state = 117, .external_lex_state = 2},
  [1891] = {.lex_state = 117, .external_lex_state = 2},
  [1892] = {.lex_state = 117, .external_lex_state = 2},
  [1893] = {.lex_state = 117, .external_lex_state = 2},
  [1894] = {.lex_state = 117, .external_lex_state = 2},
  [1895] = {.lex_state = 117, .external_lex_state = 2},
  [1896] = {.lex_state = 117, .external_lex_state = 2},
  [1897] = {.lex_state = 3, .external_lex_state = 2},
  [1898] = {.lex_state = 37, .external_lex_state = 2},
  [1899] = {.lex_state = 117, .external_lex_state = 2},
  [1900] = {.lex_state = 117, .external_lex_state = 2},
  [1901] = {.lex_state = 117, .external_lex_state = 2},
  [1902] = {.lex_state = 117, .external_lex_state = 2},
  [1903] = {.lex_state = 117, .external_lex_state = 2},
  [1904] = {.lex_state = 117, .external_lex_state = 2},
  [1905] = {.lex_state = 117, .external_lex_state = 2},
  [1906] = {.lex_state = 117, .external_lex_state = 2},
  [1907] = {.lex_state = 37, .external_lex_state = 2},
  [1908] = {.lex_state = 50, .external_lex_state = 1},
  [1909] = {.lex_state = 117, .external_lex_state = 2},
  [1910] = {.lex_state = 37, .external_lex_state = 2},
  [1911] = {.lex_state = 117, .external_lex_state = 2},
  [1912] = {.lex_state = 37, .external_lex_state = 2},
  [1913] = {.lex_state = 3, .external_lex_state = 2},
  [1914] = {.lex_state = 37, .external_lex_state = 2},
  [1915] = {.lex_state = 117, .external_lex_state = 2},
  [1916] = {.lex_state = 3, .external_lex_state = 2},
  [1917] = {.lex_state = 37, .external_lex_state = 2},
  [1918] = {.lex_state = 37, .external_lex_state = 2},
  [1919] = {.lex_state = 3, .external_lex_state = 2},
  [1920] = {.lex_state = 3, .external_lex_state = 2},
  [1921] = {.lex_state = 37, .external_lex_state = 2},
  [1922] = {.lex_state = 37, .external_lex_state = 2},
  [1923] = {.lex_state = 37, .external_lex_state = 2},
  [1924] = {.lex_state = 3, .external_lex_state = 2},
  [1925] = {.lex_state = 37, .external_lex_state = 2},
  [1926] = {.lex_state = 3, .external_lex_state = 2},
  [1927] = {.lex_state = 37, .external_lex_state = 2},
  [1928] = {.lex_state = 37, .external_lex_state = 2},
  [1929] = {.lex_state = 37, .external_lex_state = 2},
  [1930] = {.lex_state = 3, .external_lex_state = 2},
  [1931] = {.lex_state = 37, .external_lex_state = 2},
  [1932] = {.lex_state = 37, .external_lex_state = 2},
  [1933] = {.lex_state = 37, .external_lex_state = 2},
  [1934] = {.lex_state = 37, .external_lex_state = 2},
  [1935] = {.lex_state = 3, .external_lex_state = 2},
  [1936] = {.lex_state = 37, .external_lex_state = 2},
  [1937] = {.lex_state = 37, .external_lex_state = 2},
  [1938] = {.lex_state = 28, .external_lex_state = 2},
  [1939] = {.lex_state = 117, .external_lex_state = 2},
  [1940] = {.lex_state = 3, .external_lex_state = 2},
  [1941] = {.lex_state = 37, .external_lex_state = 2},
  [1942] = {.lex_state = 37, .external_lex_state = 2},
  [1943] = {.lex_state = 37, .external_lex_state = 2},
  [1944] = {.lex_state = 3, .external_lex_state = 2},
  [1945] = {.lex_state = 37, .external_lex_state = 2},
  [1946] = {.lex_state = 37, .external_lex_state = 2},
  [1947] = {.lex_state = 37, .external_lex_state = 2},
  [1948] = {.lex_state = 37, .external_lex_state = 2},
  [1949] = {.lex_state = 37, .external_lex_state = 2},
  [1950] = {.lex_state = 37, .external_lex_state = 2},
  [1951] = {.lex_state = 37, .external_lex_state = 2},
  [1952] = {.lex_state = 37, .external_lex_state = 2},
  [1953] = {.lex_state = 37, .external_lex_state = 2},
  [1954] = {.lex_state = 37, .external_lex_state = 2},
  [1955] = {.lex_state = 37, .external_lex_state = 2},
  [1956] = {.lex_state = 37, .external_lex_state = 2},
  [1957] = {.lex_state = 37, .external_lex_state = 2},
  [1958] = {.lex_state = 37, .external_lex_state = 2},
  [1959] = {.lex_state = 37, .external_lex_state = 2},
  [1960] = {.lex_state = 37, .external_lex_state = 2},
  [1961] = {.lex_state = 37, .external_lex_state = 2},
  [1962] = {.lex_state = 117, .external_lex_state = 2},
  [1963] = {.lex_state = 37, .external_lex_state = 2},
  [1964] = {.lex_state = 37, .external_lex_state = 2},
  [1965] = {.lex_state = 37, .external_lex_state = 2},
  [1966] = {.lex_state = 37, .external_lex_state = 2},
  [1967] = {.lex_state = 37, .external_lex_state = 2},
  [1968] = {.lex_state = 37, .external_lex_state = 2},
  [1969] = {.lex_state = 37, .external_lex_state = 2},
  [1970] = {.lex_state = 37, .external_lex_state = 2},
  [1971] = {.lex_state = 37, .external_lex_state = 2},
  [1972] = {.lex_state = 37, .external_lex_state = 2},
  [1973] = {.lex_state = 37, .external_lex_state = 2},
  [1974] = {.lex_state = 37, .external_lex_state = 2},
  [1975] = {.lex_state = 37, .external_lex_state = 2},
  [1976] = {.lex_state = 37, .external_lex_state = 2},
  [1977] = {.lex_state = 37, .external_lex_state = 2},
  [1978] = {.lex_state = 37, .external_lex_state = 2},
  [1979] = {.lex_state = 37, .external_lex_state = 2},
  [1980] = {.lex_state = 37, .external_lex_state = 2},
  [1981] = {.lex_state = 117, .external_lex_state = 2},
  [1982] = {.lex_state = 117, .external_lex_state = 2},
  [1983] = {.lex_state = 117, .external_lex_state = 2},
  [1984] = {.lex_state = 117, .external_lex_state = 2},
  [1985] = {.lex_state = 117, .external_lex_state = 2},
  [1986] = {.lex_state = 117, .external_lex_state = 2},
  [1987] = {.lex_state = 117, .external_lex_state = 2},
  [1988] = {.lex_state = 117, .external_lex_state = 2},
  [1989] = {.lex_state = 117, .external_lex_state = 2},
  [1990] = {.lex_state = 117, .external_lex_state = 2},
  [1991] = {.lex_state = 117, .external_lex_state = 2},
  [1992] = {.lex_state = 3, .external_lex_state = 2},
  [1993] = {.lex_state = 117, .external_lex_state = 2},
  [1994] = {.lex_state = 3, .external_lex_state = 2},
  [1995] = {.lex_state = 117, .external_lex_state = 2},
  [1996] = {.lex_state = 117, .external_lex_state = 2},
  [1997] = {.lex_state = 46, .external_lex_state = 1},
  [1998] = {.lex_state = 117, .external_lex_state = 2},
  [1999] = {.lex_state = 117, .external_lex_state = 2},
  [2000] = {.lex_state = 117, .external_lex_state = 2},
  [2001] = {.lex_state = 117, .external_lex_state = 2},
  [2002] = {.lex_state = 117, .external_lex_state = 2},
  [2003] = {.lex_state = 37, .external_lex_state = 2},
  [2004] = {.lex_state = 117, .external_lex_state = 2},
  [2005] = {.lex_state = 117, .external_lex_state = 2},
  [2006] = {.lex_state = 117, .external_lex_state = 2},
  [2007] = {.lex_state = 3, .external_lex_state = 2},
  [2008] = {.lex_state = 37, .external_lex_state = 2},
  [2009] = {.lex_state = 117, .external_lex_state = 2},
  [2010] = {.lex_state = 37, .external_lex_state = 2},
  [2011] = {.lex_state = 37, .external_lex_state = 2},
  [2012] = {.lex_state = 37, .external_lex_state = 2},
  [2013] = {.lex_state = 37, .external_lex_state = 2},
  [2014] = {.lex_state = 37, .external_lex_state = 2},
  [2015] = {.lex_state = 37, .external_lex_state = 2},
  [2016] = {.lex_state = 37, .external_lex_state = 2},
  [2017] = {.lex_state = 117, .external_lex_state = 2},
  [2018] = {.lex_state = 37, .external_lex_state = 2},
  [2019] = {.lex_state = 37, .external_lex_state = 2},
  [2020] = {.lex_state = 117, .external_lex_state = 2},
  [2021] = {.lex_state = 117, .external_lex_state = 2},
  [2022] = {.lex_state = 117, .external_lex_state = 2},
  [2023] = {.lex_state = 117, .external_lex_state = 2},
  [2024] = {.lex_state = 117, .external_lex_state = 2},
  [2025] = {.lex_state = 117, .external_lex_state = 2},
  [2026] = {.lex_state = 117, .external_lex_state = 2},
  [2027] = {.lex_state = 117, .external_lex_state = 2},
  [2028] = {.lex_state = 117, .external_lex_state = 2},
  [2029] = {.lex_state = 117, .external_lex_state = 2},
  [2030] = {.lex_state = 117, .external_lex_state = 2},
  [2031] = {.lex_state = 37, .external_lex_state = 2},
  [2032] = {.lex_state = 3, .external_lex_state = 2},
  [2033] = {.lex_state = 117, .external_lex_state = 2},
  [2034] = {.lex_state = 117, .external_lex_state = 2},
  [2035] = {.lex_state = 117, .external_lex_state = 2},
  [2036] = {.lex_state = 37, .external_lex_state = 2},
  [2037] = {.lex_state = 37, .external_lex_state = 2},
  [2038] = {.lex_state = 117, .external_lex_state = 2},
  [2039] = {.lex_state = 117, .external_lex_state = 2},
  [2040] = {.lex_state = 117, .external_lex_state = 2},
  [2041] = {.lex_state = 3, .external_lex_state = 2},
  [2042] = {.lex_state = 117, .external_lex_state = 2},
  [2043] = {.lex_state = 117, .external_lex_state = 2},
  [2044] = {.lex_state = 117, .external_lex_state = 2},
  [2045] = {.lex_state = 37, .external_lex_state = 2},
  [2046] = {.lex_state = 117, .external_lex_state = 2},
  [2047] = {.lex_state = 117, .external_lex_state = 2},
  [2048] = {.lex_state = 117, .external_lex_state = 2},
  [2049] = {.lex_state = 117, .external_lex_state = 2},
  [2050] = {.lex_state = 117, .external_lex_state = 2},
  [2051] = {.lex_state = 117, .external_lex_state = 2},
  [2052] = {.lex_state = 117, .external_lex_state = 2},
  [2053] = {.lex_state = 117, .external_lex_state = 2},
  [2054] = {.lex_state = 117, .external_lex_state = 2},
  [2055] = {.lex_state = 117, .external_lex_state = 2},
  [2056] = {.lex_state = 117, .external_lex_state = 2},
  [2057] = {.lex_state = 117, .external_lex_state = 2},
  [2058] = {.lex_state = 117, .external_lex_state = 2},
  [2059] = {.lex_state = 117, .external_lex_state = 2},
  [2060] = {.lex_state = 117, .external_lex_state = 2},
  [2061] = {.lex_state = 37, .external_lex_state = 2},
  [2062] = {.lex_state = 3, .external_lex_state = 2},
  [2063] = {.lex_state = 3, .external_lex_state = 2},
  [2064] = {.lex_state = 117, .external_lex_state = 2},
  [2065] = {.lex_state = 117, .external_lex_state = 2},
  [2066] = {.lex_state = 117, .external_lex_state = 2},
  [2067] = {.lex_state = 117, .external_lex_state = 2},
  [2068] = {.lex_state = 117, .external_lex_state = 2},
  [2069] = {.lex_state = 117, .external_lex_state = 2},
  [2070] = {.lex_state = 117, .external_lex_state = 2},
  [2071] = {.lex_state = 117, .external_lex_state = 2},
  [2072] = {.lex_state = 46, .external_lex_state = 1},
  [2073] = {.lex_state = 117, .external_lex_state = 2},
  [2074] = {.lex_state = 37, .external_lex_state = 2},
  [2075] = {.lex_state = 3, .external_lex_state = 2},
  [2076] = {.lex_state = 46, .external_lex_state = 1},
  [2077] = {.lex_state = 46, .external_lex_state = 1},
  [2078] = {.lex_state = 46, .external_lex_state = 1},
  [2079] = {.lex_state = 46, .external_lex_state = 1},
  [2080] = {.lex_state = 46, .external_lex_state = 1},
  [2081] = {.lex_state = 46, .external_lex_state = 1},
  [2082] = {.lex_state = 46, .external_lex_state = 1},
  [2083] = {.lex_state = 117, .external_lex_state = 2},
  [2084] = {.lex_state = 46, .external_lex_state = 1},
  [2085] = {.lex_state = 46, .external_lex_state = 1},
  [2086] = {.lex_state = 46, .external_lex_state = 1},
  [2087] = {.lex_state = 46, .external_lex_state = 1},
  [2088] = {.lex_state = 46, .external_lex_state = 1},
  [2089] = {.lex_state = 46, .external_lex_state = 1},
  [2090] = {.lex_state = 46, .external_lex_state = 1},
  [2091] = {.lex_state = 46, .external_lex_state = 1},
  [2092] = {.lex_state = 46, .external_lex_state = 1},
  [2093] = {.lex_state = 46, .external_lex_state = 1},
  [2094] = {.lex_state = 37, .external_lex_state = 2},
  [2095] = {.lex_state = 37, .external_lex_state = 2},
  [2096] = {.lex_state = 37, .external_lex_state = 2},
  [2097] = {.lex_state = 37, .external_lex_state = 2},
  [2098] = {.lex_state = 46, .external_lex_state = 1},
  [2099] = {.lex_state = 3, .external_lex_state = 2},
  [2100] = {.lex_state = 46, .external_lex_state = 1},
  [2101] = {.lex_state = 46, .external_lex_state = 1},
  [2102] = {.lex_state = 117, .external_lex_state = 2},
  [2103] = {.lex_state = 46, .external_lex_state = 1},
  [2104] = {.lex_state = 37, .external_lex_state = 2},
  [2105] = {.lex_state = 3, .external_lex_state = 2},
  [2106] = {.lex_state = 3, .external_lex_state = 2},
  [2107] = {.lex_state = 3, .external_lex_state = 2},
  [2108] = {.lex_state = 3, .external_lex_state = 2},
  [2109] = {.lex_state = 3, .external_lex_state = 2},
  [2110] = {.lex_state = 3, .external_lex_state = 2},
  [2111] = {.lex_state = 117, .external_lex_state = 2},
  [2112] = {.lex_state = 117, .external_lex_state = 2},
  [2113] = {.lex_state = 37, .external_lex_state = 2},
  [2114] = {.lex_state = 117, .external_lex_state = 2},
  [2115] = {.lex_state = 3, .external_lex_state = 2},
  [2116] = {.lex_state = 117, .external_lex_state = 2},
  [2117] = {.lex_state = 37, .external_lex_state = 2},
  [2118] = {.lex_state = 37, .external_lex_state = 2},
  [2119] = {.lex_state = 3, .external_lex_state = 2},
  [2120] = {.lex_state = 37, .external_lex_state = 2},
  [2121] = {.lex_state = 37, .external_lex_state = 2},
  [2122] = {.lex_state = 37, .external_lex_state = 2},
  [2123] = {.lex_state = 37, .external_lex_state = 2},
  [2124] = {.lex_state = 37, .external_lex_state = 2},
  [2125] = {.lex_state = 37, .external_lex_state = 2},
  [2126] = {.lex_state = 37, .external_lex_state = 2},
  [2127] = {.lex_state = 37, .external_lex_state = 2},
  [2128] = {.lex_state = 37, .external_lex_state = 2},
  [2129] = {.lex_state = 37, .external_lex_state = 2},
  [2130] = {.lex_state = 3, .external_lex_state = 2},
  [2131] = {.lex_state = 3, .external_lex_state = 2},
  [2132] = {.lex_state = 117, .external_lex_state = 2},
  [2133] = {.lex_state = 37, .external_lex_state = 2},
  [2134] = {.lex_state = 37, .external_lex_state = 2},
  [2135] = {.lex_state = 117, .external_lex_state = 2},
  [2136] = {.lex_state = 117, .external_lex_state = 2},
  [2137] = {.lex_state = 3, .external_lex_state = 2},
  [2138] = {.lex_state = 3, .external_lex_state = 2},
  [2139] = {.lex_state = 3, .external_lex_state = 2},
  [2140] = {.lex_state = 3, .external_lex_state = 2},
  [2141] = {.lex_state = 3, .external_lex_state = 2},
  [2142] = {.lex_state = 3, .external_lex_state = 2},
  [2143] = {.lex_state = 32, .external_lex_state = 2},
  [2144] = {.lex_state = 37, .external_lex_state = 2},
  [2145] = {.lex_state = 3, .external_lex_state = 2},
  [2146] = {.lex_state = 117, .external_lex_state = 2},
  [2147] = {.lex_state = 3, .external_lex_state = 2},
  [2148] = {.lex_state = 37, .external_lex_state = 2},
  [2149] = {.lex_state = 46, .external_lex_state = 1},
  [2150] = {.lex_state = 46, .external_lex_state = 1},
  [2151] = {.lex_state = 46, .external_lex_state = 1},
  [2152] = {.lex_state = 46, .external_lex_state = 1},
  [2153] = {.lex_state = 36, .external_lex_state = 2},
  [2154] = {.lex_state = 36, .external_lex_state = 2},
  [2155] = {.lex_state = 36, .external_lex_state = 2},
  [2156] = {.lex_state = 46, .external_lex_state = 1},
  [2157] = {.lex_state = 46, .external_lex_state = 1},
  [2158] = {.lex_state = 46, .external_lex_state = 1},
  [2159] = {.lex_state = 46, .external_lex_state = 1},
  [2160] = {.lex_state = 46, .external_lex_state = 1},
  [2161] = {.lex_state = 36, .external_lex_state = 2},
  [2162] = {.lex_state = 36, .external_lex_state = 2},
  [2163] = {.lex_state = 36, .external_lex_state = 2},
  [2164] = {.lex_state = 36, .external_lex_state = 2},
  [2165] = {.lex_state = 36, .external_lex_state = 2},
  [2166] = {.lex_state = 36, .external_lex_state = 2},
  [2167] = {.lex_state = 36, .external_lex_state = 2},
  [2168] = {.lex_state = 36, .external_lex_state = 1},
  [2169] = {.lex_state = 36, .external_lex_state = 1},
  [2170] = {.lex_state = 36, .external_lex_state = 2},
  [2171] = {.lex_state = 36, .external_lex_state = 1},
  [2172] = {.lex_state = 36, .external_lex_state = 2},
  [2173] = {.lex_state = 46, .external_lex_state = 1},
  [2174] = {.lex_state = 36, .external_lex_state = 2},
  [2175] = {.lex_state = 36, .external_lex_state = 2},
  [2176] = {.lex_state = 36, .external_lex_state = 2},
  [2177] = {.lex_state = 46, .external_lex_state = 1},
  [2178] = {.lex_state = 3, .external_lex_state = 2},
  [2179] = {.lex_state = 3, .external_lex_state = 2},
  [2180] = {.lex_state = 49, .external_lex_state = 2},
  [2181] = {.lex_state = 3, .external_lex_state = 2},
  [2182] = {.lex_state = 3, .external_lex_state = 2},
  [2183] = {.lex_state = 46, .external_lex_state = 1},
  [2184] = {.lex_state = 3, .external_lex_state = 2},
  [2185] = {.lex_state = 3, .external_lex_state = 2},
  [2186] = {.lex_state = 3, .external_lex_state = 2},
  [2187] = {.lex_state = 3, .external_lex_state = 2},
  [2188] = {.lex_state = 3, .external_lex_state = 2},
  [2189] = {.lex_state = 3, .external_lex_state = 2},
  [2190] = {.lex_state = 3, .external_lex_state = 2},
  [2191] = {.lex_state = 46, .external_lex_state = 1},
  [2192] = {.lex_state = 3, .external_lex_state = 2},
  [2193] = {.lex_state = 36, .external_lex_state = 2},
  [2194] = {.lex_state = 3, .external_lex_state = 2},
  [2195] = {.lex_state = 46, .external_lex_state = 1},
  [2196] = {.lex_state = 36, .external_lex_state = 2},
  [2197] = {.lex_state = 3, .external_lex_state = 2},
  [2198] = {.lex_state = 36, .external_lex_state = 2},
  [2199] = {.lex_state = 46, .external_lex_state = 1},
  [2200] = {.lex_state = 36, .external_lex_state = 2},
  [2201] = {.lex_state = 46, .external_lex_state = 1},
  [2202] = {.lex_state = 46, .external_lex_state = 1},
  [2203] = {.lex_state = 46, .external_lex_state = 1},
  [2204] = {.lex_state = 46, .external_lex_state = 1},
  [2205] = {.lex_state = 46, .external_lex_state = 1},
  [2206] = {.lex_state = 46, .external_lex_state = 1},
  [2207] = {.lex_state = 36, .external_lex_state = 2},
  [2208] = {.lex_state = 46, .external_lex_state = 1},
  [2209] = {.lex_state = 46, .external_lex_state = 1},
  [2210] = {.lex_state = 46, .external_lex_state = 1},
  [2211] = {.lex_state = 36, .external_lex_state = 2},
  [2212] = {.lex_state = 46, .external_lex_state = 1},
  [2213] = {.lex_state = 46, .external_lex_state = 1},
  [2214] = {.lex_state = 46, .external_lex_state = 1},
  [2215] = {.lex_state = 36, .external_lex_state = 2},
  [2216] = {.lex_state = 46, .external_lex_state = 1},
  [2217] = {.lex_state = 46, .external_lex_state = 1},
  [2218] = {.lex_state = 36, .external_lex_state = 2},
  [2219] = {.lex_state = 37, .external_lex_state = 2},
  [2220] = {.lex_state = 36, .external_lex_state = 2},
  [2221] = {.lex_state = 36, .external_lex_state = 2},
  [2222] = {.lex_state = 36, .external_lex_state = 2},
  [2223] = {.lex_state = 36, .external_lex_state = 2},
  [2224] = {.lex_state = 36, .external_lex_state = 2},
  [2225] = {.lex_state = 36, .external_lex_state = 2},
  [2226] = {.lex_state = 36, .external_lex_state = 2},
  [2227] = {.lex_state = 36, .external_lex_state = 2},
  [2228] = {.lex_state = 36, .external_lex_state = 2},
  [2229] = {.lex_state = 36, .external_lex_state = 2},
  [2230] = {.lex_state = 36, .external_lex_state = 2},
  [2231] = {.lex_state = 36, .external_lex_state = 2},
  [2232] = {.lex_state = 36, .external_lex_state = 2},
  [2233] = {.lex_state = 36, .external_lex_state = 2},
  [2234] = {.lex_state = 36, .external_lex_state = 2},
  [2235] = {.lex_state = 36, .external_lex_state = 2},
  [2236] = {.lex_state = 36, .external_lex_state = 2},
  [2237] = {.lex_state = 36, .external_lex_state = 2},
  [2238] = {.lex_state = 36, .external_lex_state = 2},
  [2239] = {.lex_state = 36, .external_lex_state = 2},
  [2240] = {.lex_state = 36, .external_lex_state = 2},
  [2241] = {.lex_state = 36, .external_lex_state = 2},
  [2242] = {.lex_state = 36, .external_lex_state = 2},
  [2243] = {.lex_state = 36, .external_lex_state = 2},
  [2244] = {.lex_state = 36, .external_lex_state = 2},
  [2245] = {.lex_state = 36, .external_lex_state = 2},
  [2246] = {.lex_state = 36, .external_lex_state = 2},
  [2247] = {.lex_state = 36, .external_lex_state = 2},
  [2248] = {.lex_state = 36, .external_lex_state = 2},
  [2249] = {.lex_state = 36, .external_lex_state = 2},
  [2250] = {.lex_state = 36, .external_lex_state = 2},
  [2251] = {.lex_state = 36, .external_lex_state = 2},
  [2252] = {.lex_state = 36, .external_lex_state = 2},
  [2253] = {.lex_state = 36, .external_lex_state = 2},
  [2254] = {.lex_state = 36, .external_lex_state = 2},
  [2255] = {.lex_state = 36, .external_lex_state = 2},
  [2256] = {.lex_state = 36, .external_lex_state = 2},
  [2257] = {.lex_state = 36, .external_lex_state = 2},
  [2258] = {.lex_state = 36, .external_lex_state = 2},
  [2259] = {.lex_state = 36, .external_lex_state = 2},
  [2260] = {.lex_state = 36, .external_lex_state = 2},
  [2261] = {.lex_state = 36, .external_lex_state = 2},
  [2262] = {.lex_state = 36, .external_lex_state = 2},
  [2263] = {.lex_state = 36, .external_lex_state = 2},
  [2264] = {.lex_state = 37, .external_lex_state = 2},
  [2265] = {.lex_state = 36, .external_lex_state = 2},
  [2266] = {.lex_state = 36, .external_lex_state = 2},
  [2267] = {.lex_state = 36, .external_lex_state = 2},
  [2268] = {.lex_state = 36, .external_lex_state = 2},
  [2269] = {.lex_state = 36, .external_lex_state = 2},
  [2270] = {.lex_state = 36, .external_lex_state = 2},
  [2271] = {.lex_state = 36, .external_lex_state = 2},
  [2272] = {.lex_state = 36, .external_lex_state = 2},
  [2273] = {.lex_state = 36, .external_lex_state = 2},
  [2274] = {.lex_state = 36, .external_lex_state = 2},
  [2275] = {.lex_state = 37, .external_lex_state = 2},
  [2276] = {.lex_state = 36, .external_lex_state = 2},
  [2277] = {.lex_state = 36, .external_lex_state = 2},
  [2278] = {.lex_state = 37, .external_lex_state = 2},
  [2279] = {.lex_state = 37, .external_lex_state = 2},
  [2280] = {.lex_state = 36, .external_lex_state = 2},
  [2281] = {.lex_state = 37, .external_lex_state = 2},
  [2282] = {.lex_state = 36, .external_lex_state = 2},
  [2283] = {.lex_state = 36, .external_lex_state = 2},
  [2284] = {.lex_state = 37, .external_lex_state = 2},
  [2285] = {.lex_state = 37, .external_lex_state = 2},
  [2286] = {.lex_state = 37, .external_lex_state = 2},
  [2287] = {.lex_state = 37, .external_lex_state = 2},
  [2288] = {.lex_state = 37, .external_lex_state = 2},
  [2289] = {.lex_state = 37, .external_lex_state = 2},
  [2290] = {.lex_state = 37, .external_lex_state = 2},
  [2291] = {.lex_state = 36, .external_lex_state = 2},
  [2292] = {.lex_state = 36, .external_lex_state = 2},
  [2293] = {.lex_state = 36, .external_lex_state = 2},
  [2294] = {.lex_state = 36, .external_lex_state = 2},
  [2295] = {.lex_state = 36, .external_lex_state = 2},
  [2296] = {.lex_state = 36, .external_lex_state = 2},
  [2297] = {.lex_state = 36, .external_lex_state = 2},
  [2298] = {.lex_state = 36, .external_lex_state = 2},
  [2299] = {.lex_state = 36, .external_lex_state = 2},
  [2300] = {.lex_state = 36, .external_lex_state = 2},
  [2301] = {.lex_state = 36, .external_lex_state = 2},
  [2302] = {.lex_state = 36, .external_lex_state = 2},
  [2303] = {.lex_state = 36, .external_lex_state = 2},
  [2304] = {.lex_state = 36, .external_lex_state = 2},
  [2305] = {.lex_state = 36, .external_lex_state = 2},
  [2306] = {.lex_state = 36, .external_lex_state = 2},
  [2307] = {.lex_state = 36, .external_lex_state = 2},
  [2308] = {.lex_state = 36, .external_lex_state = 2},
  [2309] = {.lex_state = 36, .external_lex_state = 2},
  [2310] = {.lex_state = 36, .external_lex_state = 2},
  [2311] = {.lex_state = 36, .external_lex_state = 2},
  [2312] = {.lex_state = 36, .external_lex_state = 2},
  [2313] = {.lex_state = 36, .external_lex_state = 2},
  [2314] = {.lex_state = 36, .external_lex_state = 2},
  [2315] = {.lex_state = 36, .external_lex_state = 2},
  [2316] = {.lex_state = 36, .external_lex_state = 2},
  [2317] = {.lex_state = 36, .external_lex_state = 2},
  [2318] = {.lex_state = 36, .external_lex_state = 2},
  [2319] = {.lex_state = 36, .external_lex_state = 2},
  [2320] = {.lex_state = 36, .external_lex_state = 2},
  [2321] = {.lex_state = 36, .external_lex_state = 2},
  [2322] = {.lex_state = 36, .external_lex_state = 2},
  [2323] = {.lex_state = 36, .external_lex_state = 2},
  [2324] = {.lex_state = 37, .external_lex_state = 2},
  [2325] = {.lex_state = 36, .external_lex_state = 2},
  [2326] = {.lex_state = 49, .external_lex_state = 2},
  [2327] = {.lex_state = 49, .external_lex_state = 2},
  [2328] = {.lex_state = 36, .external_lex_state = 2},
  [2329] = {.lex_state = 36, .external_lex_state = 2},
  [2330] = {.lex_state = 36, .external_lex_state = 2},
  [2331] = {.lex_state = 49, .external_lex_state = 2},
  [2332] = {.lex_state = 36, .external_lex_state = 2},
  [2333] = {.lex_state = 3, .external_lex_state = 2},
  [2334] = {.lex_state = 36, .external_lex_state = 2},
  [2335] = {.lex_state = 36, .external_lex_state = 2},
  [2336] = {.lex_state = 36, .external_lex_state = 2},
  [2337] = {.lex_state = 36, .external_lex_state = 2},
  [2338] = {.lex_state = 36, .external_lex_state = 2},
  [2339] = {.lex_state = 36, .external_lex_state = 2},
  [2340] = {.lex_state = 36, .external_lex_state = 2},
  [2341] = {.lex_state = 36, .external_lex_state = 2},
  [2342] = {.lex_state = 36, .external_lex_state = 2},
  [2343] = {.lex_state = 36, .external_lex_state = 2},
  [2344] = {.lex_state = 36, .external_lex_state = 2},
  [2345] = {.lex_state = 36, .external_lex_state = 2},
  [2346] = {.lex_state = 36, .external_lex_state = 2},
  [2347] = {.lex_state = 36, .external_lex_state = 2},
  [2348] = {.lex_state = 36, .external_lex_state = 2},
  [2349] = {.lex_state = 36, .external_lex_state = 2},
  [2350] = {.lex_state = 36, .external_lex_state = 2},
  [2351] = {.lex_state = 36, .external_lex_state = 2},
  [2352] = {.lex_state = 36, .external_lex_state = 2},
  [2353] = {.lex_state = 45, .external_lex_state = 2},
  [2354] = {.lex_state = 45, .external_lex_state = 2},
  [2355] = {.lex_state = 45, .external_lex_state = 2},
  [2356] = {.lex_state = 45, .external_lex_state = 2},
  [2357] = {.lex_state = 45, .external_lex_state = 2},
  [2358] = {.lex_state = 45, .external_lex_state = 2},
  [2359] = {.lex_state = 45, .external_lex_state = 2},
  [2360] = {.lex_state = 45, .external_lex_state = 2},
  [2361] = {.lex_state = 36, .external_lex_state = 2},
  [2362] = {.lex_state = 45, .external_lex_state = 1},
  [2363] = {.lex_state = 45, .external_lex_state = 2},
  [2364] = {.lex_state = 45, .external_lex_state = 2},
  [2365] = {.lex_state = 45, .external_lex_state = 2},
  [2366] = {.lex_state = 45, .external_lex_state = 2},
  [2367] = {.lex_state = 45, .external_lex_state = 2},
  [2368] = {.lex_state = 45, .external_lex_state = 1},
  [2369] = {.lex_state = 45, .external_lex_state = 2},
  [2370] = {.lex_state = 45, .external_lex_state = 2},
  [2371] = {.lex_state = 45, .external_lex_state = 2},
  [2372] = {.lex_state = 45, .external_lex_state = 2},
  [2373] = {.lex_state = 45, .external_lex_state = 1},
  [2374] = {.lex_state = 45, .external_lex_state = 2},
  [2375] = {.lex_state = 45, .external_lex_state = 2},
  [2376] = {.lex_state = 45, .external_lex_state = 2},
  [2377] = {.lex_state = 45, .external_lex_state = 2},
  [2378] = {.lex_state = 45, .external_lex_state = 2},
  [2379] = {.lex_state = 45, .external_lex_state = 2},
  [2380] = {.lex_state = 45, .external_lex_state = 2},
  [2381] = {.lex_state = 45, .external_lex_state = 2},
  [2382] = {.lex_state = 45, .external_lex_state = 2},
  [2383] = {.lex_state = 45, .external_lex_state = 2},
  [2384] = {.lex_state = 45, .external_lex_state = 2},
  [2385] = {.lex_state = 45, .external_lex_state = 2},
  [2386] = {.lex_state = 45, .external_lex_state = 2},
  [2387] = {.lex_state = 45, .external_lex_state = 2},
  [2388] = {.lex_state = 45, .external_lex_state = 2},
  [2389] = {.lex_state = 45, .external_lex_state = 2},
  [2390] = {.lex_state = 45, .external_lex_state = 2},
  [2391] = {.lex_state = 45, .external_lex_state = 2},
  [2392] = {.lex_state = 45, .external_lex_state = 2},
  [2393] = {.lex_state = 45, .external_lex_state = 2},
  [2394] = {.lex_state = 45, .external_lex_state = 2},
  [2395] = {.lex_state = 45, .external_lex_state = 2},
  [2396] = {.lex_state = 45, .external_lex_state = 2},
  [2397] = {.lex_state = 45, .external_lex_state = 2},
  [2398] = {.lex_state = 45, .external_lex_state = 2},
  [2399] = {.lex_state = 45, .external_lex_state = 2},
  [2400] = {.lex_state = 45, .external_lex_state = 2},
  [2401] = {.lex_state = 45, .external_lex_state = 2},
  [2402] = {.lex_state = 45, .external_lex_state = 2},
  [2403] = {.lex_state = 45, .external_lex_state = 2},
  [2404] = {.lex_state = 45, .external_lex_state = 2},
  [2405] = {.lex_state = 45, .external_lex_state = 2},
  [2406] = {.lex_state = 45, .external_lex_state = 2},
  [2407] = {.lex_state = 45, .external_lex_state = 2},
  [2408] = {.lex_state = 45, .external_lex_state = 2},
  [2409] = {.lex_state = 45, .external_lex_state = 2},
  [2410] = {.lex_state = 45, .external_lex_state = 2},
  [2411] = {.lex_state = 45, .external_lex_state = 2},
  [2412] = {.lex_state = 45, .external_lex_state = 2},
  [2413] = {.lex_state = 45, .external_lex_state = 2},
  [2414] = {.lex_state = 45, .external_lex_state = 2},
  [2415] = {.lex_state = 45, .external_lex_state = 2},
  [2416] = {.lex_state = 45, .external_lex_state = 2},
  [2417] = {.lex_state = 45, .external_lex_state = 2},
  [2418] = {.lex_state = 45, .external_lex_state = 2},
  [2419] = {.lex_state = 45, .external_lex_state = 2},
  [2420] = {.lex_state = 45, .external_lex_state = 2},
  [2421] = {.lex_state = 45, .external_lex_state = 2},
  [2422] = {.lex_state = 45, .external_lex_state = 2},
  [2423] = {.lex_state = 45, .external_lex_state = 2},
  [2424] = {.lex_state = 45, .external_lex_state = 2},
  [2425] = {.lex_state = 45, .external_lex_state = 2},
  [2426] = {.lex_state = 45, .external_lex_state = 2},
  [2427] = {.lex_state = 45, .external_lex_state = 2},
  [2428] = {.lex_state = 45, .external_lex_state = 2},
  [2429] = {.lex_state = 45, .external_lex_state = 2},
  [2430] = {.lex_state = 45, .external_lex_state = 2},
  [2431] = {.lex_state = 45, .external_lex_state = 2},
  [2432] = {.lex_state = 45, .external_lex_state = 2},
  [2433] = {.lex_state = 45, .external_lex_state = 2},
  [2434] = {.lex_state = 45, .external_lex_state = 2},
  [2435] = {.lex_state = 45, .external_lex_state = 2},
  [2436] = {.lex_state = 45, .external_lex_state = 2},
  [2437] = {.lex_state = 45, .external_lex_state = 2},
  [2438] = {.lex_state = 45, .external_lex_state = 2},
  [2439] = {.lex_state = 45, .external_lex_state = 2},
  [2440] = {.lex_state = 45, .external_lex_state = 2},
  [2441] = {.lex_state = 45, .external_lex_state = 2},
  [2442] = {.lex_state = 45, .external_lex_state = 2},
  [2443] = {.lex_state = 45, .external_lex_state = 2},
  [2444] = {.lex_state = 45, .external_lex_state = 2},
  [2445] = {.lex_state = 45, .external_lex_state = 2},
  [2446] = {.lex_state = 45, .external_lex_state = 2},
  [2447] = {.lex_state = 45, .external_lex_state = 2},
  [2448] = {.lex_state = 45, .external_lex_state = 2},
  [2449] = {.lex_state = 45, .external_lex_state = 2},
  [2450] = {.lex_state = 45, .external_lex_state = 2},
  [2451] = {.lex_state = 45, .external_lex_state = 2},
  [2452] = {.lex_state = 45, .external_lex_state = 2},
  [2453] = {.lex_state = 45, .external_lex_state = 2},
  [2454] = {.lex_state = 45, .external_lex_state = 2},
  [2455] = {.lex_state = 45, .external_lex_state = 2},
  [2456] = {.lex_state = 45, .external_lex_state = 2},
  [2457] = {.lex_state = 45, .external_lex_state = 2},
  [2458] = {.lex_state = 45, .external_lex_state = 2},
  [2459] = {.lex_state = 45, .external_lex_state = 2},
  [2460] = {.lex_state = 45, .external_lex_state = 2},
  [2461] = {.lex_state = 45, .external_lex_state = 2},
  [2462] = {.lex_state = 45, .external_lex_state = 2},
  [2463] = {.lex_state = 45, .external_lex_state = 2},
  [2464] = {.lex_state = 45, .external_lex_state = 2},
  [2465] = {.lex_state = 45, .external_lex_state = 2},
  [2466] = {.lex_state = 45, .external_lex_state = 2},
  [2467] = {.lex_state = 45, .external_lex_state = 2},
  [2468] = {.lex_state = 45, .external_lex_state = 2},
  [2469] = {.lex_state = 45, .external_lex_state = 2},
  [2470] = {.lex_state = 45, .external_lex_state = 2},
  [2471] = {.lex_state = 45, .external_lex_state = 2},
  [2472] = {.lex_state = 45, .external_lex_state = 2},
  [2473] = {.lex_state = 45, .external_lex_state = 2},
  [2474] = {.lex_state = 45, .external_lex_state = 2},
  [2475] = {.lex_state = 45, .external_lex_state = 2},
  [2476] = {.lex_state = 45, .external_lex_state = 2},
  [2477] = {.lex_state = 45, .external_lex_state = 2},
  [2478] = {.lex_state = 45, .external_lex_state = 2},
  [2479] = {.lex_state = 45, .external_lex_state = 2},
  [2480] = {.lex_state = 45, .external_lex_state = 2},
  [2481] = {.lex_state = 45, .external_lex_state = 2},
  [2482] = {.lex_state = 45, .external_lex_state = 2},
  [2483] = {.lex_state = 45, .external_lex_state = 2},
  [2484] = {.lex_state = 45, .external_lex_state = 2},
  [2485] = {.lex_state = 45, .external_lex_state = 2},
  [2486] = {.lex_state = 45, .external_lex_state = 2},
  [2487] = {.lex_state = 45, .external_lex_state = 2},
  [2488] = {.lex_state = 45, .external_lex_state = 2},
  [2489] = {.lex_state = 37, .external_lex_state = 2},
  [2490] = {.lex_state = 45, .external_lex_state = 2},
  [2491] = {.lex_state = 45, .external_lex_state = 2},
  [2492] = {.lex_state = 45, .external_lex_state = 2},
  [2493] = {.lex_state = 45, .external_lex_state = 2},
  [2494] = {.lex_state = 45, .external_lex_state = 2},
  [2495] = {.lex_state = 45, .external_lex_state = 2},
  [2496] = {.lex_state = 45, .external_lex_state = 2},
  [2497] = {.lex_state = 45, .external_lex_state = 2},
  [2498] = {.lex_state = 45, .external_lex_state = 2},
  [2499] = {.lex_state = 45, .external_lex_state = 2},
  [2500] = {.lex_state = 45, .external_lex_state = 2},
  [2501] = {.lex_state = 45, .external_lex_state = 2},
  [2502] = {.lex_state = 45, .external_lex_state = 2},
  [2503] = {.lex_state = 11, .external_lex_state = 2},
  [2504] = {.lex_state = 11, .external_lex_state = 2},
  [2505] = {.lex_state = 11, .external_lex_state = 2},
  [2506] = {.lex_state = 11, .external_lex_state = 2},
  [2507] = {.lex_state = 11, .external_lex_state = 2},
  [2508] = {.lex_state = 126, .external_lex_state = 2},
  [2509] = {.lex_state = 126, .external_lex_state = 2},
  [2510] = {.lex_state = 126, .external_lex_state = 2},
  [2511] = {.lex_state = 126, .external_lex_state = 2},
  [2512] = {.lex_state = 126, .external_lex_state = 2},
  [2513] = {.lex_state = 126, .external_lex_state = 2},
  [2514] = {.lex_state = 118, .external_lex_state = 3},
  [2515] = {.lex_state = 119, .external_lex_state = 3},
  [2516] = {.lex_state = 118, .external_lex_state = 3},
  [2517] = {.lex_state = 118, .external_lex_state = 3},
  [2518] = {.lex_state = 118, .external_lex_state = 3},
  [2519] = {.lex_state = 118, .external_lex_state = 3},
  [2520] = {.lex_state = 118, .external_lex_state = 3},
  [2521] = {.lex_state = 118, .external_lex_state = 3},
  [2522] = {.lex_state = 118, .external_lex_state = 3},
  [2523] = {.lex_state = 118, .external_lex_state = 3},
  [2524] = {.lex_state = 118, .external_lex_state = 3},
  [2525] = {.lex_state = 118, .external_lex_state = 3},
  [2526] = {.lex_state = 118, .external_lex_state = 3},
  [2527] = {.lex_state = 118, .external_lex_state = 3},
  [2528] = {.lex_state = 118, .external_lex_state = 3},
  [2529] = {.lex_state = 118, .external_lex_state = 3},
  [2530] = {.lex_state = 53, .external_lex_state = 3},
  [2531] = {.lex_state = 119, .external_lex_state = 3},
  [2532] = {.lex_state = 118, .external_lex_state = 3},
  [2533] = {.lex_state = 118, .external_lex_state = 3},
  [2534] = {.lex_state = 118, .external_lex_state = 3},
  [2535] = {.lex_state = 118, .external_lex_state = 3},
  [2536] = {.lex_state = 118, .external_lex_state = 3},
  [2537] = {.lex_state = 118, .external_lex_state = 3},
  [2538] = {.lex_state = 118, .external_lex_state = 3},
  [2539] = {.lex_state = 118, .external_lex_state = 3},
  [2540] = {.lex_state = 118, .external_lex_state = 3},
  [2541] = {.lex_state = 118, .external_lex_state = 3},
  [2542] = {.lex_state = 118, .external_lex_state = 3},
  [2543] = {.lex_state = 54, .external_lex_state = 3},
  [2544] = {.lex_state = 118, .external_lex_state = 3},
  [2545] = {.lex_state = 118, .external_lex_state = 3},
  [2546] = {.lex_state = 118, .external_lex_state = 3},
  [2547] = {.lex_state = 118, .external_lex_state = 3},
  [2548] = {.lex_state = 118, .external_lex_state = 3},
  [2549] = {.lex_state = 119, .external_lex_state = 3},
  [2550] = {.lex_state = 118, .external_lex_state = 3},
  [2551] = {.lex_state = 118, .external_lex_state = 3},
  [2552] = {.lex_state = 118, .external_lex_state = 3},
  [2553] = {.lex_state = 53, .external_lex_state = 3},
  [2554] = {.lex_state = 118, .external_lex_state = 3},
  [2555] = {.lex_state = 118, .external_lex_state = 3},
  [2556] = {.lex_state = 118, .external_lex_state = 3},
  [2557] = {.lex_state = 118, .external_lex_state = 3},
  [2558] = {.lex_state = 118, .external_lex_state = 3},
  [2559] = {.lex_state = 121, .external_lex_state = 4},
  [2560] = {.lex_state = 118, .external_lex_state = 3},
  [2561] = {.lex_state = 118, .external_lex_state = 3},
  [2562] = {.lex_state = 118, .external_lex_state = 3},
  [2563] = {.lex_state = 118, .external_lex_state = 3},
  [2564] = {.lex_state = 118, .external_lex_state = 3},
  [2565] = {.lex_state = 118, .external_lex_state = 3},
  [2566] = {.lex_state = 118, .external_lex_state = 3},
  [2567] = {.lex_state = 118, .external_lex_state = 3},
  [2568] = {.lex_state = 53, .external_lex_state = 3},
  [2569] = {.lex_state = 118, .external_lex_state = 3},
  [2570] = {.lex_state = 118, .external_lex_state = 3},
  [2571] = {.lex_state = 53, .external_lex_state = 3},
  [2572] = {.lex_state = 118, .external_lex_state = 3},
  [2573] = {.lex_state = 118, .external_lex_state = 3},
  [2574] = {.lex_state = 118, .external_lex_state = 3},
  [2575] = {.lex_state = 118, .external_lex_state = 3},
  [2576] = {.lex_state = 118, .external_lex_state = 3},
  [2577] = {.lex_state = 118, .external_lex_state = 3},
  [2578] = {.lex_state = 118, .external_lex_state = 3},
  [2579] = {.lex_state = 118, .external_lex_state = 3},
  [2580] = {.lex_state = 53, .external_lex_state = 3},
  [2581] = {.lex_state = 53, .external_lex_state = 3},
  [2582] = {.lex_state = 53, .external_lex_state = 3},
  [2583] = {.lex_state = 53, .external_lex_state = 3},
  [2584] = {.lex_state = 53, .external_lex_state = 3},
  [2585] = {.lex_state = 53, .external_lex_state = 3},
  [2586] = {.lex_state = 121, .external_lex_state = 4},
  [2587] = {.lex_state = 53, .external_lex_state = 3},
  [2588] = {.lex_state = 53, .external_lex_state = 3},
  [2589] = {.lex_state = 53, .external_lex_state = 3},
  [2590] = {.lex_state = 54, .external_lex_state = 3},
  [2591] = {.lex_state = 121, .external_lex_state = 4},
  [2592] = {.lex_state = 53, .external_lex_state = 3},
  [2593] = {.lex_state = 53, .external_lex_state = 3},
  [2594] = {.lex_state = 55, .external_lex_state = 3},
  [2595] = {.lex_state = 53, .external_lex_state = 3},
  [2596] = {.lex_state = 53, .external_lex_state = 3},
  [2597] = {.lex_state = 53, .external_lex_state = 3},
  [2598] = {.lex_state = 53, .external_lex_state = 3},
  [2599] = {.lex_state = 53, .external_lex_state = 3},
  [2600] = {.lex_state = 121, .external_lex_state = 4},
  [2601] = {.lex_state = 53, .external_lex_state = 3},
  [2602] = {.lex_state = 53, .external_lex_state = 3},
  [2603] = {.lex_state = 53, .external_lex_state = 3},
  [2604] = {.lex_state = 53, .external_lex_state = 3},
  [2605] = {.lex_state = 53, .external_lex_state = 3},
  [2606] = {.lex_state = 53, .external_lex_state = 3},
  [2607] = {.lex_state = 118, .external_lex_state = 4},
  [2608] = {.lex_state = 53, .external_lex_state = 3},
  [2609] = {.lex_state = 53, .external_lex_state = 3},
  [2610] = {.lex_state = 56, .external_lex_state = 3},
  [2611] = {.lex_state = 53, .external_lex_state = 3},
  [2612] = {.lex_state = 53, .external_lex_state = 3},
  [2613] = {.lex_state = 53, .external_lex_state = 3},
  [2614] = {.lex_state = 55, .external_lex_state = 3},
  [2615] = {.lex_state = 53, .external_lex_state = 3},
  [2616] = {.lex_state = 55, .external_lex_state = 3},
  [2617] = {.lex_state = 53, .external_lex_state = 3},
  [2618] = {.lex_state = 53, .external_lex_state = 3},
  [2619] = {.lex_state = 53, .external_lex_state = 3},
  [2620] = {.lex_state = 118, .external_lex_state = 4},
  [2621] = {.lex_state = 58, .external_lex_state = 4},
  [2622] = {.lex_state = 53, .external_lex_state = 3},
  [2623] = {.lex_state = 53, .external_lex_state = 3},
  [2624] = {.lex_state = 118, .external_lex_state = 4},
  [2625] = {.lex_state = 53, .external_lex_state = 3},
  [2626] = {.lex_state = 53, .external_lex_state = 3},
  [2627] = {.lex_state = 118, .external_lex_state = 4},
  [2628] = {.lex_state = 53, .external_lex_state = 3},
  [2629] = {.lex_state = 118, .external_lex_state = 4},
  [2630] = {.lex_state = 53, .external_lex_state = 3},
  [2631] = {.lex_state = 53, .external_lex_state = 3},
  [2632] = {.lex_state = 53, .external_lex_state = 3},
  [2633] = {.lex_state = 53, .external_lex_state = 4},
  [2634] = {.lex_state = 118, .external_lex_state = 4},
  [2635] = {.lex_state = 53, .external_lex_state = 3},
  [2636] = {.lex_state = 118, .external_lex_state = 4},
  [2637] = {.lex_state = 53, .external_lex_state = 3},
  [2638] = {.lex_state = 118, .external_lex_state = 4},
  [2639] = {.lex_state = 53, .external_lex_state = 3},
  [2640] = {.lex_state = 53, .external_lex_state = 3},
  [2641] = {.lex_state = 53, .external_lex_state = 3},
  [2642] = {.lex_state = 53, .external_lex_state = 3},
  [2643] = {.lex_state = 53, .external_lex_state = 3},
  [2644] = {.lex_state = 55, .external_lex_state = 3},
  [2645] = {.lex_state = 53, .external_lex_state = 3},
  [2646] = {.lex_state = 53, .external_lex_state = 3},
  [2647] = {.lex_state = 53, .external_lex_state = 3},
  [2648] = {.lex_state = 53, .external_lex_state = 3},
  [2649] = {.lex_state = 53, .external_lex_state = 3},
  [2650] = {.lex_state = 53, .external_lex_state = 3},
  [2651] = {.lex_state = 53, .external_lex_state = 3},
  [2652] = {.lex_state = 118, .external_lex_state = 4},
  [2653] = {.lex_state = 118, .external_lex_state = 4},
  [2654] = {.lex_state = 118, .external_lex_state = 4},
  [2655] = {.lex_state = 118, .external_lex_state = 4},
  [2656] = {.lex_state = 118, .external_lex_state = 4},
  [2657] = {.lex_state = 118, .external_lex_state = 4},
  [2658] = {.lex_state = 118, .external_lex_state = 4},
  [2659] = {.lex_state = 118, .external_lex_state = 4},
  [2660] = {.lex_state = 118, .external_lex_state = 4},
  [2661] = {.lex_state = 55, .external_lex_state = 3},
  [2662] = {.lex_state = 118, .external_lex_state = 4},
  [2663] = {.lex_state = 118, .external_lex_state = 4},
  [2664] = {.lex_state = 118, .external_lex_state = 4},
  [2665] = {.lex_state = 118, .external_lex_state = 4},
  [2666] = {.lex_state = 118, .external_lex_state = 4},
  [2667] = {.lex_state = 118, .external_lex_state = 4},
  [2668] = {.lex_state = 118, .external_lex_state = 4},
  [2669] = {.lex_state = 118, .external_lex_state = 4},
  [2670] = {.lex_state = 118, .external_lex_state = 4},
  [2671] = {.lex_state = 118, .external_lex_state = 4},
  [2672] = {.lex_state = 118, .external_lex_state = 4},
  [2673] = {.lex_state = 118, .external_lex_state = 4},
  [2674] = {.lex_state = 118, .external_lex_state = 4},
  [2675] = {.lex_state = 118, .external_lex_state = 4},
  [2676] = {.lex_state = 118, .external_lex_state = 4},
  [2677] = {.lex_state = 118, .external_lex_state = 4},
  [2678] = {.lex_state = 118, .external_lex_state = 4},
  [2679] = {.lex_state = 118, .external_lex_state = 4},
  [2680] = {.lex_state = 118, .external_lex_state = 4},
  [2681] = {.lex_state = 118, .external_lex_state = 4},
  [2682] = {.lex_state = 118, .external_lex_state = 4},
  [2683] = {.lex_state = 118, .external_lex_state = 4},
  [2684] = {.lex_state = 118, .external_lex_state = 4},
  [2685] = {.lex_state = 118, .external_lex_state = 4},
  [2686] = {.lex_state = 118, .external_lex_state = 4},
  [2687] = {.lex_state = 118, .external_lex_state = 4},
  [2688] = {.lex_state = 118, .external_lex_state = 4},
  [2689] = {.lex_state = 118, .external_lex_state = 4},
  [2690] = {.lex_state = 118, .external_lex_state = 4},
  [2691] = {.lex_state = 118, .external_lex_state = 4},
  [2692] = {.lex_state = 118, .external_lex_state = 4},
  [2693] = {.lex_state = 118, .external_lex_state = 4},
  [2694] = {.lex_state = 118, .external_lex_state = 4},
  [2695] = {.lex_state = 118, .external_lex_state = 4},
  [2696] = {.lex_state = 55, .external_lex_state = 3},
  [2697] = {.lex_state = 118, .external_lex_state = 4},
  [2698] = {.lex_state = 118, .external_lex_state = 4},
  [2699] = {.lex_state = 118, .external_lex_state = 4},
  [2700] = {.lex_state = 118, .external_lex_state = 4},
  [2701] = {.lex_state = 118, .external_lex_state = 4},
  [2702] = {.lex_state = 118, .external_lex_state = 4},
  [2703] = {.lex_state = 118, .external_lex_state = 4},
  [2704] = {.lex_state = 118, .external_lex_state = 4},
  [2705] = {.lex_state = 118, .external_lex_state = 4},
  [2706] = {.lex_state = 118, .external_lex_state = 4},
  [2707] = {.lex_state = 118, .external_lex_state = 4},
  [2708] = {.lex_state = 118, .external_lex_state = 4},
  [2709] = {.lex_state = 118, .external_lex_state = 4},
  [2710] = {.lex_state = 119, .external_lex_state = 3},
  [2711] = {.lex_state = 118, .external_lex_state = 4},
  [2712] = {.lex_state = 118, .external_lex_state = 4},
  [2713] = {.lex_state = 118, .external_lex_state = 4},
  [2714] = {.lex_state = 118, .external_lex_state = 4},
  [2715] = {.lex_state = 118, .external_lex_state = 4},
  [2716] = {.lex_state = 118, .external_lex_state = 4},
  [2717] = {.lex_state = 118, .external_lex_state = 4},
  [2718] = {.lex_state = 58, .external_lex_state = 4},
  [2719] = {.lex_state = 118, .external_lex_state = 4},
  [2720] = {.lex_state = 118, .external_lex_state = 4},
  [2721] = {.lex_state = 118, .external_lex_state = 4},
  [2722] = {.lex_state = 58, .external_lex_state = 4},
  [2723] = {.lex_state = 118, .external_lex_state = 4},
  [2724] = {.lex_state = 118, .external_lex_state = 4},
  [2725] = {.lex_state = 119, .external_lex_state = 3},
  [2726] = {.lex_state = 118, .external_lex_state = 4},
  [2727] = {.lex_state = 118, .external_lex_state = 4},
  [2728] = {.lex_state = 118, .external_lex_state = 4},
  [2729] = {.lex_state = 118, .external_lex_state = 4},
  [2730] = {.lex_state = 118, .external_lex_state = 4},
  [2731] = {.lex_state = 118, .external_lex_state = 4},
  [2732] = {.lex_state = 118, .external_lex_state = 4},
  [2733] = {.lex_state = 118, .external_lex_state = 4},
  [2734] = {.lex_state = 118, .external_lex_state = 4},
  [2735] = {.lex_state = 118, .external_lex_state = 4},
  [2736] = {.lex_state = 118, .external_lex_state = 4},
  [2737] = {.lex_state = 118, .external_lex_state = 4},
  [2738] = {.lex_state = 118, .external_lex_state = 4},
  [2739] = {.lex_state = 118, .external_lex_state = 4},
  [2740] = {.lex_state = 118, .external_lex_state = 4},
  [2741] = {.lex_state = 118, .external_lex_state = 4},
  [2742] = {.lex_state = 118, .external_lex_state = 4},
  [2743] = {.lex_state = 118, .external_lex_state = 4},
  [2744] = {.lex_state = 118, .external_lex_state = 4},
  [2745] = {.lex_state = 118, .external_lex_state = 4},
  [2746] = {.lex_state = 118, .external_lex_state = 4},
  [2747] = {.lex_state = 118, .external_lex_state = 4},
  [2748] = {.lex_state = 118, .external_lex_state = 4},
  [2749] = {.lex_state = 118, .external_lex_state = 4},
  [2750] = {.lex_state = 118, .external_lex_state = 4},
  [2751] = {.lex_state = 118, .external_lex_state = 4},
  [2752] = {.lex_state = 118, .external_lex_state = 4},
  [2753] = {.lex_state = 118, .external_lex_state = 4},
  [2754] = {.lex_state = 58, .external_lex_state = 4},
  [2755] = {.lex_state = 118, .external_lex_state = 4},
  [2756] = {.lex_state = 118, .external_lex_state = 4},
  [2757] = {.lex_state = 55, .external_lex_state = 3},
  [2758] = {.lex_state = 55, .external_lex_state = 3},
  [2759] = {.lex_state = 55, .external_lex_state = 3},
  [2760] = {.lex_state = 55, .external_lex_state = 3},
  [2761] = {.lex_state = 55, .external_lex_state = 3},
  [2762] = {.lex_state = 118, .external_lex_state = 4},
  [2763] = {.lex_state = 118, .external_lex_state = 4},
  [2764] = {.lex_state = 55, .external_lex_state = 3},
  [2765] = {.lex_state = 118, .external_lex_state = 4},
  [2766] = {.lex_state = 55, .external_lex_state = 3},
  [2767] = {.lex_state = 118, .external_lex_state = 4},
  [2768] = {.lex_state = 55, .external_lex_state = 3},
  [2769] = {.lex_state = 55, .external_lex_state = 3},
  [2770] = {.lex_state = 55, .external_lex_state = 3},
  [2771] = {.lex_state = 118, .external_lex_state = 4},
  [2772] = {.lex_state = 55, .external_lex_state = 3},
  [2773] = {.lex_state = 55, .external_lex_state = 3},
  [2774] = {.lex_state = 55, .external_lex_state = 3},
  [2775] = {.lex_state = 55, .external_lex_state = 3},
  [2776] = {.lex_state = 55, .external_lex_state = 3},
  [2777] = {.lex_state = 118, .external_lex_state = 4},
  [2778] = {.lex_state = 55, .external_lex_state = 3},
  [2779] = {.lex_state = 55, .external_lex_state = 3},
  [2780] = {.lex_state = 56, .external_lex_state = 3},
  [2781] = {.lex_state = 118, .external_lex_state = 4},
  [2782] = {.lex_state = 118, .external_lex_state = 4},
  [2783] = {.lex_state = 55, .external_lex_state = 3},
  [2784] = {.lex_state = 55, .external_lex_state = 3},
  [2785] = {.lex_state = 118, .external_lex_state = 4},
  [2786] = {.lex_state = 118, .external_lex_state = 4},
  [2787] = {.lex_state = 118, .external_lex_state = 4},
  [2788] = {.lex_state = 55, .external_lex_state = 3},
  [2789] = {.lex_state = 55, .external_lex_state = 3},
  [2790] = {.lex_state = 55, .external_lex_state = 3},
  [2791] = {.lex_state = 118, .external_lex_state = 4},
  [2792] = {.lex_state = 55, .external_lex_state = 3},
  [2793] = {.lex_state = 55, .external_lex_state = 3},
  [2794] = {.lex_state = 118, .external_lex_state = 4},
  [2795] = {.lex_state = 55, .external_lex_state = 3},
  [2796] = {.lex_state = 118, .external_lex_state = 4},
  [2797] = {.lex_state = 118, .external_lex_state = 4},
  [2798] = {.lex_state = 118, .external_lex_state = 4},
  [2799] = {.lex_state = 55, .external_lex_state = 3},
  [2800] = {.lex_state = 53, .external_lex_state = 4},
  [2801] = {.lex_state = 55, .external_lex_state = 3},
  [2802] = {.lex_state = 55, .external_lex_state = 3},
  [2803] = {.lex_state = 55, .external_lex_state = 3},
  [2804] = {.lex_state = 55, .external_lex_state = 3},
  [2805] = {.lex_state = 118, .external_lex_state = 4},
  [2806] = {.lex_state = 55, .external_lex_state = 3},
  [2807] = {.lex_state = 118, .external_lex_state = 4},
  [2808] = {.lex_state = 56, .external_lex_state = 3},
  [2809] = {.lex_state = 55, .external_lex_state = 3},
  [2810] = {.lex_state = 118, .external_lex_state = 4},
  [2811] = {.lex_state = 53, .external_lex_state = 4},
  [2812] = {.lex_state = 53, .external_lex_state = 4},
  [2813] = {.lex_state = 55, .external_lex_state = 3},
  [2814] = {.lex_state = 118, .external_lex_state = 4},
  [2815] = {.lex_state = 55, .external_lex_state = 3},
  [2816] = {.lex_state = 118, .external_lex_state = 4},
  [2817] = {.lex_state = 55, .external_lex_state = 3},
  [2818] = {.lex_state = 55, .external_lex_state = 3},
  [2819] = {.lex_state = 55, .external_lex_state = 3},
  [2820] = {.lex_state = 55, .external_lex_state = 3},
  [2821] = {.lex_state = 55, .external_lex_state = 3},
  [2822] = {.lex_state = 55, .external_lex_state = 3},
  [2823] = {.lex_state = 53, .external_lex_state = 4},
  [2824] = {.lex_state = 56, .external_lex_state = 3},
  [2825] = {.lex_state = 118, .external_lex_state = 4},
  [2826] = {.lex_state = 118, .external_lex_state = 4},
  [2827] = {.lex_state = 55, .external_lex_state = 3},
  [2828] = {.lex_state = 118, .external_lex_state = 4},
  [2829] = {.lex_state = 55, .external_lex_state = 3},
  [2830] = {.lex_state = 118, .external_lex_state = 4},
  [2831] = {.lex_state = 118, .external_lex_state = 4},
  [2832] = {.lex_state = 118, .external_lex_state = 4},
  [2833] = {.lex_state = 55, .external_lex_state = 3},
  [2834] = {.lex_state = 118, .external_lex_state = 4},
  [2835] = {.lex_state = 118, .external_lex_state = 4},
  [2836] = {.lex_state = 118, .external_lex_state = 4},
  [2837] = {.lex_state = 53, .external_lex_state = 4},
  [2838] = {.lex_state = 55, .external_lex_state = 3},
  [2839] = {.lex_state = 55, .external_lex_state = 3},
  [2840] = {.lex_state = 53, .external_lex_state = 4},
  [2841] = {.lex_state = 55, .external_lex_state = 3},
  [2842] = {.lex_state = 55, .external_lex_state = 3},
  [2843] = {.lex_state = 118, .external_lex_state = 4},
  [2844] = {.lex_state = 55, .external_lex_state = 3},
  [2845] = {.lex_state = 63, .external_lex_state = 4},
  [2846] = {.lex_state = 118, .external_lex_state = 4},
  [2847] = {.lex_state = 118, .external_lex_state = 4},
  [2848] = {.lex_state = 55, .external_lex_state = 4},
  [2849] = {.lex_state = 53, .external_lex_state = 4},
  [2850] = {.lex_state = 55, .external_lex_state = 3},
  [2851] = {.lex_state = 55, .external_lex_state = 3},
  [2852] = {.lex_state = 118, .external_lex_state = 4},
  [2853] = {.lex_state = 53, .external_lex_state = 4},
  [2854] = {.lex_state = 118, .external_lex_state = 4},
  [2855] = {.lex_state = 118, .external_lex_state = 4},
  [2856] = {.lex_state = 118, .external_lex_state = 4},
  [2857] = {.lex_state = 53, .external_lex_state = 4},
  [2858] = {.lex_state = 118, .external_lex_state = 4},
  [2859] = {.lex_state = 118, .external_lex_state = 4},
  [2860] = {.lex_state = 118, .external_lex_state = 4},
  [2861] = {.lex_state = 55, .external_lex_state = 3},
  [2862] = {.lex_state = 53, .external_lex_state = 4},
  [2863] = {.lex_state = 63, .external_lex_state = 4},
  [2864] = {.lex_state = 53, .external_lex_state = 4},
  [2865] = {.lex_state = 53, .external_lex_state = 4},
  [2866] = {.lex_state = 53, .external_lex_state = 4},
  [2867] = {.lex_state = 53, .external_lex_state = 4},
  [2868] = {.lex_state = 53, .external_lex_state = 4},
  [2869] = {.lex_state = 53, .external_lex_state = 4},
  [2870] = {.lex_state = 53, .external_lex_state = 4},
  [2871] = {.lex_state = 53, .external_lex_state = 4},
  [2872] = {.lex_state = 53, .external_lex_state = 4},
  [2873] = {.lex_state = 53, .external_lex_state = 4},
  [2874] = {.lex_state = 53, .external_lex_state = 4},
  [2875] = {.lex_state = 53, .external_lex_state = 4},
  [2876] = {.lex_state = 53, .external_lex_state = 4},
  [2877] = {.lex_state = 53, .external_lex_state = 4},
  [2878] = {.lex_state = 53, .external_lex_state = 4},
  [2879] = {.lex_state = 53, .external_lex_state = 4},
  [2880] = {.lex_state = 53, .external_lex_state = 4},
  [2881] = {.lex_state = 53, .external_lex_state = 4},
  [2882] = {.lex_state = 53, .external_lex_state = 4},
  [2883] = {.lex_state = 53, .external_lex_state = 4},
  [2884] = {.lex_state = 53, .external_lex_state = 4},
  [2885] = {.lex_state = 53, .external_lex_state = 4},
  [2886] = {.lex_state = 53, .external_lex_state = 4},
  [2887] = {.lex_state = 53, .external_lex_state = 4},
  [2888] = {.lex_state = 53, .external_lex_state = 4},
  [2889] = {.lex_state = 53, .external_lex_state = 4},
  [2890] = {.lex_state = 53, .external_lex_state = 4},
  [2891] = {.lex_state = 53, .external_lex_state = 4},
  [2892] = {.lex_state = 53, .external_lex_state = 4},
  [2893] = {.lex_state = 53, .external_lex_state = 4},
  [2894] = {.lex_state = 53, .external_lex_state = 4},
  [2895] = {.lex_state = 53, .external_lex_state = 4},
  [2896] = {.lex_state = 53, .external_lex_state = 4},
  [2897] = {.lex_state = 53, .external_lex_state = 4},
  [2898] = {.lex_state = 53, .external_lex_state = 4},
  [2899] = {.lex_state = 53, .external_lex_state = 4},
  [2900] = {.lex_state = 63, .external_lex_state = 4},
  [2901] = {.lex_state = 53, .external_lex_state = 4},
  [2902] = {.lex_state = 53, .external_lex_state = 4},
  [2903] = {.lex_state = 63, .external_lex_state = 4},
  [2904] = {.lex_state = 53, .external_lex_state = 4},
  [2905] = {.lex_state = 53, .external_lex_state = 4},
  [2906] = {.lex_state = 53, .external_lex_state = 4},
  [2907] = {.lex_state = 53, .external_lex_state = 4},
  [2908] = {.lex_state = 53, .external_lex_state = 4},
  [2909] = {.lex_state = 53, .external_lex_state = 4},
  [2910] = {.lex_state = 53, .external_lex_state = 4},
  [2911] = {.lex_state = 53, .external_lex_state = 4},
  [2912] = {.lex_state = 53, .external_lex_state = 4},
  [2913] = {.lex_state = 53, .external_lex_state = 4},
  [2914] = {.lex_state = 53, .external_lex_state = 4},
  [2915] = {.lex_state = 53, .external_lex_state = 4},
  [2916] = {.lex_state = 53, .external_lex_state = 4},
  [2917] = {.lex_state = 53, .external_lex_state = 4},
  [2918] = {.lex_state = 53, .external_lex_state = 4},
  [2919] = {.lex_state = 53, .external_lex_state = 4},
  [2920] = {.lex_state = 54, .external_lex_state = 3},
  [2921] = {.lex_state = 53, .external_lex_state = 4},
  [2922] = {.lex_state = 53, .external_lex_state = 4},
  [2923] = {.lex_state = 53, .external_lex_state = 4},
  [2924] = {.lex_state = 53, .external_lex_state = 4},
  [2925] = {.lex_state = 53, .external_lex_state = 4},
  [2926] = {.lex_state = 53, .external_lex_state = 4},
  [2927] = {.lex_state = 53, .external_lex_state = 4},
  [2928] = {.lex_state = 53, .external_lex_state = 4},
  [2929] = {.lex_state = 53, .external_lex_state = 4},
  [2930] = {.lex_state = 53, .external_lex_state = 4},
  [2931] = {.lex_state = 53, .external_lex_state = 4},
  [2932] = {.lex_state = 53, .external_lex_state = 4},
  [2933] = {.lex_state = 53, .external_lex_state = 4},
  [2934] = {.lex_state = 53, .external_lex_state = 4},
  [2935] = {.lex_state = 53, .external_lex_state = 4},
  [2936] = {.lex_state = 53, .external_lex_state = 4},
  [2937] = {.lex_state = 53, .external_lex_state = 4},
  [2938] = {.lex_state = 53, .external_lex_state = 4},
  [2939] = {.lex_state = 53, .external_lex_state = 4},
  [2940] = {.lex_state = 53, .external_lex_state = 4},
  [2941] = {.lex_state = 53, .external_lex_state = 4},
  [2942] = {.lex_state = 53, .external_lex_state = 4},
  [2943] = {.lex_state = 53, .external_lex_state = 4},
  [2944] = {.lex_state = 53, .external_lex_state = 4},
  [2945] = {.lex_state = 53, .external_lex_state = 4},
  [2946] = {.lex_state = 53, .external_lex_state = 4},
  [2947] = {.lex_state = 53, .external_lex_state = 4},
  [2948] = {.lex_state = 53, .external_lex_state = 4},
  [2949] = {.lex_state = 53, .external_lex_state = 4},
  [2950] = {.lex_state = 53, .external_lex_state = 4},
  [2951] = {.lex_state = 53, .external_lex_state = 4},
  [2952] = {.lex_state = 53, .external_lex_state = 4},
  [2953] = {.lex_state = 53, .external_lex_state = 4},
  [2954] = {.lex_state = 53, .external_lex_state = 4},
  [2955] = {.lex_state = 53, .external_lex_state = 4},
  [2956] = {.lex_state = 53, .external_lex_state = 4},
  [2957] = {.lex_state = 53, .external_lex_state = 4},
  [2958] = {.lex_state = 53, .external_lex_state = 4},
  [2959] = {.lex_state = 53, .external_lex_state = 4},
  [2960] = {.lex_state = 53, .external_lex_state = 4},
  [2961] = {.lex_state = 53, .external_lex_state = 4},
  [2962] = {.lex_state = 53, .external_lex_state = 4},
  [2963] = {.lex_state = 53, .external_lex_state = 4},
  [2964] = {.lex_state = 53, .external_lex_state = 4},
  [2965] = {.lex_state = 53, .external_lex_state = 4},
  [2966] = {.lex_state = 53, .external_lex_state = 4},
  [2967] = {.lex_state = 53, .external_lex_state = 4},
  [2968] = {.lex_state = 53, .external_lex_state = 4},
  [2969] = {.lex_state = 53, .external_lex_state = 4},
  [2970] = {.lex_state = 53, .external_lex_state = 4},
  [2971] = {.lex_state = 53, .external_lex_state = 4},
  [2972] = {.lex_state = 53, .external_lex_state = 4},
  [2973] = {.lex_state = 53, .external_lex_state = 4},
  [2974] = {.lex_state = 53, .external_lex_state = 4},
  [2975] = {.lex_state = 53, .external_lex_state = 4},
  [2976] = {.lex_state = 55, .external_lex_state = 4},
  [2977] = {.lex_state = 53, .external_lex_state = 4},
  [2978] = {.lex_state = 53, .external_lex_state = 4},
  [2979] = {.lex_state = 55, .external_lex_state = 4},
  [2980] = {.lex_state = 53, .external_lex_state = 4},
  [2981] = {.lex_state = 55, .external_lex_state = 4},
  [2982] = {.lex_state = 53, .external_lex_state = 4},
  [2983] = {.lex_state = 53, .external_lex_state = 4},
  [2984] = {.lex_state = 55, .external_lex_state = 4},
  [2985] = {.lex_state = 53, .external_lex_state = 4},
  [2986] = {.lex_state = 53, .external_lex_state = 4},
  [2987] = {.lex_state = 53, .external_lex_state = 4},
  [2988] = {.lex_state = 53, .external_lex_state = 4},
  [2989] = {.lex_state = 53, .external_lex_state = 4},
  [2990] = {.lex_state = 53, .external_lex_state = 4},
  [2991] = {.lex_state = 53, .external_lex_state = 4},
  [2992] = {.lex_state = 55, .external_lex_state = 4},
  [2993] = {.lex_state = 55, .external_lex_state = 4},
  [2994] = {.lex_state = 53, .external_lex_state = 4},
  [2995] = {.lex_state = 55, .external_lex_state = 4},
  [2996] = {.lex_state = 53, .external_lex_state = 4},
  [2997] = {.lex_state = 55, .external_lex_state = 4},
  [2998] = {.lex_state = 53, .external_lex_state = 4},
  [2999] = {.lex_state = 55, .external_lex_state = 4},
  [3000] = {.lex_state = 53, .external_lex_state = 4},
  [3001] = {.lex_state = 55, .external_lex_state = 4},
  [3002] = {.lex_state = 55, .external_lex_state = 4},
  [3003] = {.lex_state = 55, .external_lex_state = 4},
  [3004] = {.lex_state = 55, .external_lex_state = 4},
  [3005] = {.lex_state = 55, .external_lex_state = 4},
  [3006] = {.lex_state = 55, .external_lex_state = 4},
  [3007] = {.lex_state = 55, .external_lex_state = 4},
  [3008] = {.lex_state = 55, .external_lex_state = 4},
  [3009] = {.lex_state = 55, .external_lex_state = 4},
  [3010] = {.lex_state = 55, .external_lex_state = 4},
  [3011] = {.lex_state = 55, .external_lex_state = 4},
  [3012] = {.lex_state = 55, .external_lex_state = 4},
  [3013] = {.lex_state = 55, .external_lex_state = 4},
  [3014] = {.lex_state = 55, .external_lex_state = 4},
  [3015] = {.lex_state = 55, .external_lex_state = 4},
  [3016] = {.lex_state = 55, .external_lex_state = 4},
  [3017] = {.lex_state = 56, .external_lex_state = 3},
  [3018] = {.lex_state = 55, .external_lex_state = 4},
  [3019] = {.lex_state = 55, .external_lex_state = 4},
  [3020] = {.lex_state = 55, .external_lex_state = 4},
  [3021] = {.lex_state = 55, .external_lex_state = 4},
  [3022] = {.lex_state = 55, .external_lex_state = 4},
  [3023] = {.lex_state = 55, .external_lex_state = 4},
  [3024] = {.lex_state = 55, .external_lex_state = 4},
  [3025] = {.lex_state = 55, .external_lex_state = 4},
  [3026] = {.lex_state = 55, .external_lex_state = 4},
  [3027] = {.lex_state = 55, .external_lex_state = 4},
  [3028] = {.lex_state = 53, .external_lex_state = 4},
  [3029] = {.lex_state = 55, .external_lex_state = 4},
  [3030] = {.lex_state = 55, .external_lex_state = 4},
  [3031] = {.lex_state = 55, .external_lex_state = 4},
  [3032] = {.lex_state = 55, .external_lex_state = 4},
  [3033] = {.lex_state = 55, .external_lex_state = 4},
  [3034] = {.lex_state = 55, .external_lex_state = 4},
  [3035] = {.lex_state = 55, .external_lex_state = 4},
  [3036] = {.lex_state = 55, .external_lex_state = 4},
  [3037] = {.lex_state = 55, .external_lex_state = 4},
  [3038] = {.lex_state = 55, .external_lex_state = 4},
  [3039] = {.lex_state = 55, .external_lex_state = 4},
  [3040] = {.lex_state = 55, .external_lex_state = 4},
  [3041] = {.lex_state = 55, .external_lex_state = 4},
  [3042] = {.lex_state = 55, .external_lex_state = 4},
  [3043] = {.lex_state = 55, .external_lex_state = 4},
  [3044] = {.lex_state = 55, .external_lex_state = 4},
  [3045] = {.lex_state = 55, .external_lex_state = 4},
  [3046] = {.lex_state = 55, .external_lex_state = 4},
  [3047] = {.lex_state = 55, .external_lex_state = 4},
  [3048] = {.lex_state = 55, .external_lex_state = 4},
  [3049] = {.lex_state = 55, .external_lex_state = 4},
  [3050] = {.lex_state = 55, .external_lex_state = 4},
  [3051] = {.lex_state = 118, .external_lex_state = 4},
  [3052] = {.lex_state = 55, .external_lex_state = 4},
  [3053] = {.lex_state = 55, .external_lex_state = 4},
  [3054] = {.lex_state = 55, .external_lex_state = 4},
  [3055] = {.lex_state = 55, .external_lex_state = 4},
  [3056] = {.lex_state = 55, .external_lex_state = 4},
  [3057] = {.lex_state = 55, .external_lex_state = 4},
  [3058] = {.lex_state = 55, .external_lex_state = 4},
  [3059] = {.lex_state = 55, .external_lex_state = 4},
  [3060] = {.lex_state = 55, .external_lex_state = 4},
  [3061] = {.lex_state = 55, .external_lex_state = 4},
  [3062] = {.lex_state = 55, .external_lex_state = 4},
  [3063] = {.lex_state = 55, .external_lex_state = 4},
  [3064] = {.lex_state = 55, .external_lex_state = 4},
  [3065] = {.lex_state = 55, .external_lex_state = 4},
  [3066] = {.lex_state = 55, .external_lex_state = 4},
  [3067] = {.lex_state = 55, .external_lex_state = 4},
  [3068] = {.lex_state = 55, .external_lex_state = 4},
  [3069] = {.lex_state = 55, .external_lex_state = 4},
  [3070] = {.lex_state = 55, .external_lex_state = 4},
  [3071] = {.lex_state = 55, .external_lex_state = 4},
  [3072] = {.lex_state = 55, .external_lex_state = 4},
  [3073] = {.lex_state = 55, .external_lex_state = 4},
  [3074] = {.lex_state = 55, .external_lex_state = 4},
  [3075] = {.lex_state = 55, .external_lex_state = 4},
  [3076] = {.lex_state = 55, .external_lex_state = 4},
  [3077] = {.lex_state = 53, .external_lex_state = 4},
  [3078] = {.lex_state = 55, .external_lex_state = 4},
  [3079] = {.lex_state = 55, .external_lex_state = 4},
  [3080] = {.lex_state = 55, .external_lex_state = 4},
  [3081] = {.lex_state = 55, .external_lex_state = 4},
  [3082] = {.lex_state = 55, .external_lex_state = 4},
  [3083] = {.lex_state = 55, .external_lex_state = 4},
  [3084] = {.lex_state = 55, .external_lex_state = 4},
  [3085] = {.lex_state = 55, .external_lex_state = 4},
  [3086] = {.lex_state = 55, .external_lex_state = 4},
  [3087] = {.lex_state = 55, .external_lex_state = 4},
  [3088] = {.lex_state = 55, .external_lex_state = 4},
  [3089] = {.lex_state = 55, .external_lex_state = 4},
  [3090] = {.lex_state = 55, .external_lex_state = 4},
  [3091] = {.lex_state = 55, .external_lex_state = 4},
  [3092] = {.lex_state = 55, .external_lex_state = 4},
  [3093] = {.lex_state = 55, .external_lex_state = 4},
  [3094] = {.lex_state = 55, .external_lex_state = 4},
  [3095] = {.lex_state = 55, .external_lex_state = 4},
  [3096] = {.lex_state = 55, .external_lex_state = 4},
  [3097] = {.lex_state = 55, .external_lex_state = 4},
  [3098] = {.lex_state = 55, .external_lex_state = 4},
  [3099] = {.lex_state = 118, .external_lex_state = 4},
  [3100] = {.lex_state = 55, .external_lex_state = 4},
  [3101] = {.lex_state = 55, .external_lex_state = 4},
  [3102] = {.lex_state = 55, .external_lex_state = 4},
  [3103] = {.lex_state = 55, .external_lex_state = 4},
  [3104] = {.lex_state = 55, .external_lex_state = 4},
  [3105] = {.lex_state = 55, .external_lex_state = 4},
  [3106] = {.lex_state = 55, .external_lex_state = 4},
  [3107] = {.lex_state = 55, .external_lex_state = 4},
  [3108] = {.lex_state = 55, .external_lex_state = 4},
  [3109] = {.lex_state = 55, .external_lex_state = 4},
  [3110] = {.lex_state = 55, .external_lex_state = 4},
  [3111] = {.lex_state = 118, .external_lex_state = 4},
  [3112] = {.lex_state = 55, .external_lex_state = 4},
  [3113] = {.lex_state = 55, .external_lex_state = 4},
  [3114] = {.lex_state = 55, .external_lex_state = 4},
  [3115] = {.lex_state = 55, .external_lex_state = 4},
  [3116] = {.lex_state = 55, .external_lex_state = 4},
  [3117] = {.lex_state = 55, .external_lex_state = 4},
  [3118] = {.lex_state = 55, .external_lex_state = 4},
  [3119] = {.lex_state = 55, .external_lex_state = 4},
  [3120] = {.lex_state = 56, .external_lex_state = 3},
  [3121] = {.lex_state = 55, .external_lex_state = 4},
  [3122] = {.lex_state = 55, .external_lex_state = 4},
  [3123] = {.lex_state = 55, .external_lex_state = 4},
  [3124] = {.lex_state = 55, .external_lex_state = 4},
  [3125] = {.lex_state = 55, .external_lex_state = 4},
  [3126] = {.lex_state = 55, .external_lex_state = 4},
  [3127] = {.lex_state = 55, .external_lex_state = 4},
  [3128] = {.lex_state = 118, .external_lex_state = 4},
  [3129] = {.lex_state = 55, .external_lex_state = 4},
  [3130] = {.lex_state = 55, .external_lex_state = 4},
  [3131] = {.lex_state = 118, .external_lex_state = 4},
  [3132] = {.lex_state = 118, .external_lex_state = 4},
  [3133] = {.lex_state = 118, .external_lex_state = 4},
  [3134] = {.lex_state = 118, .external_lex_state = 4},
  [3135] = {.lex_state = 118, .external_lex_state = 4},
  [3136] = {.lex_state = 55, .external_lex_state = 4},
  [3137] = {.lex_state = 118, .external_lex_state = 4},
  [3138] = {.lex_state = 55, .external_lex_state = 4},
  [3139] = {.lex_state = 118, .external_lex_state = 4},
  [3140] = {.lex_state = 53, .external_lex_state = 4},
  [3141] = {.lex_state = 118, .external_lex_state = 4},
  [3142] = {.lex_state = 55, .external_lex_state = 4},
  [3143] = {.lex_state = 118, .external_lex_state = 4},
  [3144] = {.lex_state = 55, .external_lex_state = 4},
  [3145] = {.lex_state = 118, .external_lex_state = 4},
  [3146] = {.lex_state = 118, .external_lex_state = 4},
  [3147] = {.lex_state = 118, .external_lex_state = 4},
  [3148] = {.lex_state = 55, .external_lex_state = 4},
  [3149] = {.lex_state = 118, .external_lex_state = 4},
  [3150] = {.lex_state = 55, .external_lex_state = 4},
  [3151] = {.lex_state = 118, .external_lex_state = 4},
  [3152] = {.lex_state = 55, .external_lex_state = 4},
  [3153] = {.lex_state = 118, .external_lex_state = 4},
  [3154] = {.lex_state = 118, .external_lex_state = 4},
  [3155] = {.lex_state = 55, .external_lex_state = 4},
  [3156] = {.lex_state = 118, .external_lex_state = 4},
  [3157] = {.lex_state = 118, .external_lex_state = 4},
  [3158] = {.lex_state = 118, .external_lex_state = 4},
  [3159] = {.lex_state = 55, .external_lex_state = 4},
  [3160] = {.lex_state = 118, .external_lex_state = 4},
  [3161] = {.lex_state = 118, .external_lex_state = 4},
  [3162] = {.lex_state = 118, .external_lex_state = 4},
  [3163] = {.lex_state = 118, .external_lex_state = 4},
  [3164] = {.lex_state = 118, .external_lex_state = 4},
  [3165] = {.lex_state = 118, .external_lex_state = 4},
  [3166] = {.lex_state = 118, .external_lex_state = 4},
  [3167] = {.lex_state = 118, .external_lex_state = 4},
  [3168] = {.lex_state = 118, .external_lex_state = 4},
  [3169] = {.lex_state = 118, .external_lex_state = 4},
  [3170] = {.lex_state = 118, .external_lex_state = 4},
  [3171] = {.lex_state = 118, .external_lex_state = 4},
  [3172] = {.lex_state = 118, .external_lex_state = 4},
  [3173] = {.lex_state = 118, .external_lex_state = 4},
  [3174] = {.lex_state = 118, .external_lex_state = 4},
  [3175] = {.lex_state = 118, .external_lex_state = 4},
  [3176] = {.lex_state = 118, .external_lex_state = 4},
  [3177] = {.lex_state = 118, .external_lex_state = 4},
  [3178] = {.lex_state = 118, .external_lex_state = 4},
  [3179] = {.lex_state = 118, .external_lex_state = 4},
  [3180] = {.lex_state = 118, .external_lex_state = 4},
  [3181] = {.lex_state = 118, .external_lex_state = 4},
  [3182] = {.lex_state = 118, .external_lex_state = 4},
  [3183] = {.lex_state = 118, .external_lex_state = 4},
  [3184] = {.lex_state = 118, .external_lex_state = 4},
  [3185] = {.lex_state = 118, .external_lex_state = 4},
  [3186] = {.lex_state = 118, .external_lex_state = 4},
  [3187] = {.lex_state = 118, .external_lex_state = 4},
  [3188] = {.lex_state = 118, .external_lex_state = 4},
  [3189] = {.lex_state = 53, .external_lex_state = 4},
  [3190] = {.lex_state = 55, .external_lex_state = 4},
  [3191] = {.lex_state = 53, .external_lex_state = 4},
  [3192] = {.lex_state = 53, .external_lex_state = 4},
  [3193] = {.lex_state = 55, .external_lex_state = 4},
  [3194] = {.lex_state = 55, .external_lex_state = 4},
  [3195] = {.lex_state = 55, .external_lex_state = 4},
  [3196] = {.lex_state = 53, .external_lex_state = 4},
  [3197] = {.lex_state = 53, .external_lex_state = 4},
  [3198] = {.lex_state = 53, .external_lex_state = 4},
  [3199] = {.lex_state = 55, .external_lex_state = 4},
  [3200] = {.lex_state = 53, .external_lex_state = 4},
  [3201] = {.lex_state = 53, .external_lex_state = 4},
  [3202] = {.lex_state = 53, .external_lex_state = 4},
  [3203] = {.lex_state = 53, .external_lex_state = 4},
  [3204] = {.lex_state = 53, .external_lex_state = 4},
  [3205] = {.lex_state = 55, .external_lex_state = 4},
  [3206] = {.lex_state = 53, .external_lex_state = 4},
  [3207] = {.lex_state = 53, .external_lex_state = 4},
  [3208] = {.lex_state = 55, .external_lex_state = 4},
  [3209] = {.lex_state = 55, .external_lex_state = 4},
  [3210] = {.lex_state = 53, .external_lex_state = 4},
  [3211] = {.lex_state = 53, .external_lex_state = 4},
  [3212] = {.lex_state = 53, .external_lex_state = 4},
  [3213] = {.lex_state = 53, .external_lex_state = 4},
  [3214] = {.lex_state = 53, .external_lex_state = 4},
  [3215] = {.lex_state = 53, .external_lex_state = 4},
  [3216] = {.lex_state = 55, .external_lex_state = 4},
  [3217] = {.lex_state = 55, .external_lex_state = 4},
  [3218] = {.lex_state = 53, .external_lex_state = 4},
  [3219] = {.lex_state = 53, .external_lex_state = 4},
  [3220] = {.lex_state = 55, .external_lex_state = 4},
  [3221] = {.lex_state = 55, .external_lex_state = 4},
  [3222] = {.lex_state = 55, .external_lex_state = 4},
  [3223] = {.lex_state = 55, .external_lex_state = 4},
  [3224] = {.lex_state = 53, .external_lex_state = 4},
  [3225] = {.lex_state = 53, .external_lex_state = 4},
  [3226] = {.lex_state = 53, .external_lex_state = 4},
  [3227] = {.lex_state = 68, .external_lex_state = 2},
  [3228] = {.lex_state = 68, .external_lex_state = 2},
  [3229] = {.lex_state = 53, .external_lex_state = 4},
  [3230] = {.lex_state = 68, .external_lex_state = 2},
  [3231] = {.lex_state = 68, .external_lex_state = 2},
  [3232] = {.lex_state = 68, .external_lex_state = 2},
  [3233] = {.lex_state = 55, .external_lex_state = 4},
  [3234] = {.lex_state = 53, .external_lex_state = 4},
  [3235] = {.lex_state = 68, .external_lex_state = 2},
  [3236] = {.lex_state = 53, .external_lex_state = 4},
  [3237] = {.lex_state = 55, .external_lex_state = 4},
  [3238] = {.lex_state = 55, .external_lex_state = 4},
  [3239] = {.lex_state = 55, .external_lex_state = 4},
  [3240] = {.lex_state = 68, .external_lex_state = 2},
  [3241] = {.lex_state = 55, .external_lex_state = 4},
  [3242] = {.lex_state = 53, .external_lex_state = 4},
  [3243] = {.lex_state = 55, .external_lex_state = 4},
  [3244] = {.lex_state = 53, .external_lex_state = 4},
  [3245] = {.lex_state = 55, .external_lex_state = 4},
  [3246] = {.lex_state = 53, .external_lex_state = 4},
  [3247] = {.lex_state = 53, .external_lex_state = 4},
  [3248] = {.lex_state = 53, .external_lex_state = 4},
  [3249] = {.lex_state = 68, .external_lex_state = 2},
  [3250] = {.lex_state = 53, .external_lex_state = 4},
  [3251] = {.lex_state = 53, .external_lex_state = 4},
  [3252] = {.lex_state = 53, .external_lex_state = 4},
  [3253] = {.lex_state = 53, .external_lex_state = 4},
  [3254] = {.lex_state = 53, .external_lex_state = 4},
  [3255] = {.lex_state = 68, .external_lex_state = 2},
  [3256] = {.lex_state = 68, .external_lex_state = 2},
  [3257] = {.lex_state = 68, .external_lex_state = 2},
  [3258] = {.lex_state = 55, .external_lex_state = 4},
  [3259] = {.lex_state = 53, .external_lex_state = 4},
  [3260] = {.lex_state = 55, .external_lex_state = 4},
  [3261] = {.lex_state = 55, .external_lex_state = 4},
  [3262] = {.lex_state = 53, .external_lex_state = 4},
  [3263] = {.lex_state = 53, .external_lex_state = 4},
  [3264] = {.lex_state = 55, .external_lex_state = 4},
  [3265] = {.lex_state = 53, .external_lex_state = 4},
  [3266] = {.lex_state = 55, .external_lex_state = 4},
  [3267] = {.lex_state = 55, .external_lex_state = 4},
  [3268] = {.lex_state = 55, .external_lex_state = 4},
  [3269] = {.lex_state = 53, .external_lex_state = 4},
  [3270] = {.lex_state = 55, .external_lex_state = 4},
  [3271] = {.lex_state = 55, .external_lex_state = 4},
  [3272] = {.lex_state = 55, .external_lex_state = 4},
  [3273] = {.lex_state = 55, .external_lex_state = 4},
  [3274] = {.lex_state = 55, .external_lex_state = 4},
  [3275] = {.lex_state = 55, .external_lex_state = 4},
  [3276] = {.lex_state = 55, .external_lex_state = 4},
  [3277] = {.lex_state = 55, .external_lex_state = 4},
  [3278] = {.lex_state = 55, .external_lex_state = 4},
  [3279] = {.lex_state = 55, .external_lex_state = 4},
  [3280] = {.lex_state = 55, .external_lex_state = 4},
  [3281] = {.lex_state = 55, .external_lex_state = 4},
  [3282] = {.lex_state = 55, .external_lex_state = 4},
  [3283] = {.lex_state = 55, .external_lex_state = 4},
  [3284] = {.lex_state = 55, .external_lex_state = 4},
  [3285] = {.lex_state = 55, .external_lex_state = 4},
  [3286] = {.lex_state = 55, .external_lex_state = 4},
  [3287] = {.lex_state = 55, .external_lex_state = 4},
  [3288] = {.lex_state = 55, .external_lex_state = 4},
  [3289] = {.lex_state = 55, .external_lex_state = 4},
  [3290] = {.lex_state = 55, .external_lex_state = 4},
  [3291] = {.lex_state = 55, .external_lex_state = 4},
  [3292] = {.lex_state = 55, .external_lex_state = 4},
  [3293] = {.lex_state = 55, .external_lex_state = 4},
  [3294] = {.lex_state = 55, .external_lex_state = 4},
  [3295] = {.lex_state = 55, .external_lex_state = 4},
  [3296] = {.lex_state = 55, .external_lex_state = 4},
  [3297] = {.lex_state = 55, .external_lex_state = 4},
  [3298] = {.lex_state = 55, .external_lex_state = 4},
  [3299] = {.lex_state = 55, .external_lex_state = 4},
  [3300] = {.lex_state = 55, .external_lex_state = 4},
  [3301] = {.lex_state = 55, .external_lex_state = 4},
  [3302] = {.lex_state = 55, .external_lex_state = 4},
  [3303] = {.lex_state = 55, .external_lex_state = 4},
  [3304] = {.lex_state = 55, .external_lex_state = 4},
  [3305] = {.lex_state = 55, .external_lex_state = 4},
  [3306] = {.lex_state = 55, .external_lex_state = 4},
  [3307] = {.lex_state = 55, .external_lex_state = 4},
  [3308] = {.lex_state = 55, .external_lex_state = 4},
  [3309] = {.lex_state = 55, .external_lex_state = 4},
  [3310] = {.lex_state = 55, .external_lex_state = 4},
  [3311] = {.lex_state = 55, .external_lex_state = 4},
  [3312] = {.lex_state = 55, .external_lex_state = 4},
  [3313] = {.lex_state = 55, .external_lex_state = 4},
  [3314] = {.lex_state = 55, .external_lex_state = 4},
  [3315] = {.lex_state = 55, .external_lex_state = 4},
  [3316] = {.lex_state = 55, .external_lex_state = 4},
  [3317] = {.lex_state = 55, .external_lex_state = 4},
  [3318] = {.lex_state = 55, .external_lex_state = 4},
  [3319] = {.lex_state = 55, .external_lex_state = 4},
  [3320] = {.lex_state = 55, .external_lex_state = 4},
  [3321] = {.lex_state = 55, .external_lex_state = 4},
  [3322] = {.lex_state = 55, .external_lex_state = 4},
  [3323] = {.lex_state = 55, .external_lex_state = 4},
  [3324] = {.lex_state = 55, .external_lex_state = 4},
  [3325] = {.lex_state = 55, .external_lex_state = 4},
  [3326] = {.lex_state = 55, .external_lex_state = 4},
  [3327] = {.lex_state = 55, .external_lex_state = 4},
  [3328] = {.lex_state = 55, .external_lex_state = 4},
  [3329] = {.lex_state = 55, .external_lex_state = 4},
  [3330] = {.lex_state = 55, .external_lex_state = 4},
  [3331] = {.lex_state = 55, .external_lex_state = 4},
  [3332] = {.lex_state = 55, .external_lex_state = 4},
  [3333] = {.lex_state = 55, .external_lex_state = 4},
  [3334] = {.lex_state = 55, .external_lex_state = 4},
  [3335] = {.lex_state = 55, .external_lex_state = 4},
  [3336] = {.lex_state = 55, .external_lex_state = 4},
  [3337] = {.lex_state = 55, .external_lex_state = 4},
  [3338] = {.lex_state = 55, .external_lex_state = 4},
  [3339] = {.lex_state = 55, .external_lex_state = 4},
  [3340] = {.lex_state = 55, .external_lex_state = 4},
  [3341] = {.lex_state = 55, .external_lex_state = 4},
  [3342] = {.lex_state = 55, .external_lex_state = 4},
  [3343] = {.lex_state = 55, .external_lex_state = 4},
  [3344] = {.lex_state = 55, .external_lex_state = 4},
  [3345] = {.lex_state = 55, .external_lex_state = 4},
  [3346] = {.lex_state = 55, .external_lex_state = 4},
  [3347] = {.lex_state = 55, .external_lex_state = 4},
  [3348] = {.lex_state = 55, .external_lex_state = 4},
  [3349] = {.lex_state = 55, .external_lex_state = 4},
  [3350] = {.lex_state = 55, .external_lex_state = 4},
  [3351] = {.lex_state = 55, .external_lex_state = 4},
  [3352] = {.lex_state = 55, .external_lex_state = 4},
  [3353] = {.lex_state = 124, .external_lex_state = 4},
  [3354] = {.lex_state = 124, .external_lex_state = 4},
  [3355] = {.lex_state = 124, .external_lex_state = 4},
  [3356] = {.lex_state = 124, .external_lex_state = 4},
  [3357] = {.lex_state = 67, .external_lex_state = 3},
  [3358] = {.lex_state = 124, .external_lex_state = 4},
  [3359] = {.lex_state = 108, .external_lex_state = 4},
  [3360] = {.lex_state = 108, .external_lex_state = 4},
  [3361] = {.lex_state = 108, .external_lex_state = 4},
  [3362] = {.lex_state = 108, .external_lex_state = 4},
  [3363] = {.lex_state = 68, .external_lex_state = 4},
  [3364] = {.lex_state = 72, .external_lex_state = 4},
  [3365] = {.lex_state = 0, .external_lex_state = 4},
  [3366] = {.lex_state = 72, .external_lex_state = 4},
  [3367] = {.lex_state = 72, .external_lex_state = 4},
  [3368] = {.lex_state = 72, .external_lex_state = 4},
  [3369] = {.lex_state = 0, .external_lex_state = 4},
  [3370] = {.lex_state = 72, .external_lex_state = 4},
  [3371] = {.lex_state = 72, .external_lex_state = 4},
  [3372] = {.lex_state = 0, .external_lex_state = 4},
  [3373] = {.lex_state = 72, .external_lex_state = 4},
  [3374] = {.lex_state = 72, .external_lex_state = 4},
  [3375] = {.lex_state = 124, .external_lex_state = 4},
  [3376] = {.lex_state = 124, .external_lex_state = 4},
  [3377] = {.lex_state = 72, .external_lex_state = 4},
  [3378] = {.lex_state = 67, .external_lex_state = 3},
  [3379] = {.lex_state = 72, .external_lex_state = 4},
  [3380] = {.lex_state = 72, .external_lex_state = 4},
  [3381] = {.lex_state = 67, .external_lex_state = 3},
  [3382] = {.lex_state = 72, .external_lex_state = 4},
  [3383] = {.lex_state = 72, .external_lex_state = 4},
  [3384] = {.lex_state = 67, .external_lex_state = 3},
  [3385] = {.lex_state = 67, .external_lex_state = 3},
  [3386] = {.lex_state = 72, .external_lex_state = 4},
  [3387] = {.lex_state = 72, .external_lex_state = 4},
  [3388] = {.lex_state = 72, .external_lex_state = 4},
  [3389] = {.lex_state = 0, .external_lex_state = 4},
  [3390] = {.lex_state = 72, .external_lex_state = 4},
  [3391] = {.lex_state = 0, .external_lex_state = 4},
  [3392] = {.lex_state = 0, .external_lex_state = 4},
  [3393] = {.lex_state = 0, .external_lex_state = 4},
  [3394] = {.lex_state = 0, .external_lex_state = 4},
  [3395] = {.lex_state = 0, .external_lex_state = 4},
  [3396] = {.lex_state = 68, .external_lex_state = 4},
  [3397] = {.lex_state = 68, .external_lex_state = 4},
  [3398] = {.lex_state = 68, .external_lex_state = 4},
  [3399] = {.lex_state = 0, .external_lex_state = 4},
  [3400] = {.lex_state = 0, .external_lex_state = 4},
  [3401] = {.lex_state = 0, .external_lex_state = 4},
  [3402] = {.lex_state = 0, .external_lex_state = 4},
  [3403] = {.lex_state = 0, .external_lex_state = 4},
  [3404] = {.lex_state = 0, .external_lex_state = 4},
  [3405] = {.lex_state = 0, .external_lex_state = 4},
  [3406] = {.lex_state = 68, .external_lex_state = 4},
  [3407] = {.lex_state = 0, .external_lex_state = 4},
  [3408] = {.lex_state = 0, .external_lex_state = 4},
  [3409] = {.lex_state = 0, .external_lex_state = 4},
  [3410] = {.lex_state = 0, .external_lex_state = 4},
  [3411] = {.lex_state = 68, .external_lex_state = 4},
  [3412] = {.lex_state = 0, .external_lex_state = 4},
  [3413] = {.lex_state = 0, .external_lex_state = 4},
  [3414] = {.lex_state = 0, .external_lex_state = 4},
  [3415] = {.lex_state = 124, .external_lex_state = 4},
  [3416] = {.lex_state = 0, .external_lex_state = 4},
  [3417] = {.lex_state = 0, .external_lex_state = 4},
  [3418] = {.lex_state = 68, .external_lex_state = 4},
  [3419] = {.lex_state = 126, .external_lex_state = 4},
  [3420] = {.lex_state = 0, .external_lex_state = 4},
  [3421] = {.lex_state = 0, .external_lex_state = 4},
  [3422] = {.lex_state = 0, .external_lex_state = 4},
  [3423] = {.lex_state = 126, .external_lex_state = 4},
  [3424] = {.lex_state = 0, .external_lex_state = 4},
  [3425] = {.lex_state = 68, .external_lex_state = 4},
  [3426] = {.lex_state = 68, .external_lex_state = 4},
  [3427] = {.lex_state = 0, .external_lex_state = 4},
  [3428] = {.lex_state = 0, .external_lex_state = 4},
  [3429] = {.lex_state = 0, .external_lex_state = 4},
  [3430] = {.lex_state = 0, .external_lex_state = 4},
  [3431] = {.lex_state = 0, .external_lex_state = 4},
  [3432] = {.lex_state = 0, .external_lex_state = 4},
  [3433] = {.lex_state = 68, .external_lex_state = 4},
  [3434] = {.lex_state = 0, .external_lex_state = 4},
  [3435] = {.lex_state = 0, .external_lex_state = 4},
  [3436] = {.lex_state = 0, .external_lex_state = 4},
  [3437] = {.lex_state = 68, .external_lex_state = 4},
  [3438] = {.lex_state = 0, .external_lex_state = 4},
  [3439] = {.lex_state = 68, .external_lex_state = 4},
  [3440] = {.lex_state = 0, .external_lex_state = 4},
  [3441] = {.lex_state = 0, .external_lex_state = 4},
  [3442] = {.lex_state = 0, .external_lex_state = 4},
  [3443] = {.lex_state = 0, .external_lex_state = 4},
  [3444] = {.lex_state = 68, .external_lex_state = 4},
  [3445] = {.lex_state = 0, .external_lex_state = 4},
  [3446] = {.lex_state = 0, .external_lex_state = 4},
  [3447] = {.lex_state = 0, .external_lex_state = 4},
  [3448] = {.lex_state = 0, .external_lex_state = 4},
  [3449] = {.lex_state = 0, .external_lex_state = 4},
  [3450] = {.lex_state = 0, .external_lex_state = 4},
  [3451] = {.lex_state = 0, .external_lex_state = 4},
  [3452] = {.lex_state = 0, .external_lex_state = 4},
  [3453] = {.lex_state = 0, .external_lex_state = 4},
  [3454] = {.lex_state = 0, .external_lex_state = 4},
  [3455] = {.lex_state = 0, .external_lex_state = 4},
  [3456] = {.lex_state = 0, .external_lex_state = 4},
  [3457] = {.lex_state = 0, .external_lex_state = 4},
  [3458] = {.lex_state = 0, .external_lex_state = 4},
  [3459] = {.lex_state = 0, .external_lex_state = 4},
  [3460] = {.lex_state = 0, .external_lex_state = 4},
  [3461] = {.lex_state = 0, .external_lex_state = 4},
  [3462] = {.lex_state = 0, .external_lex_state = 4},
  [3463] = {.lex_state = 0, .external_lex_state = 4},
  [3464] = {.lex_state = 67, .external_lex_state = 3},
  [3465] = {.lex_state = 67, .external_lex_state = 3},
  [3466] = {.lex_state = 67, .external_lex_state = 3},
  [3467] = {.lex_state = 53, .external_lex_state = 4},
  [3468] = {.lex_state = 0, .external_lex_state = 4},
  [3469] = {.lex_state = 53, .external_lex_state = 4},
  [3470] = {.lex_state = 69, .external_lex_state = 4},
  [3471] = {.lex_state = 0, .external_lex_state = 4},
  [3472] = {.lex_state = 53, .external_lex_state = 4},
  [3473] = {.lex_state = 124, .external_lex_state = 4},
  [3474] = {.lex_state = 67, .external_lex_state = 3},
  [3475] = {.lex_state = 69, .external_lex_state = 4},
  [3476] = {.lex_state = 0, .external_lex_state = 4},
  [3477] = {.lex_state = 0, .external_lex_state = 4},
  [3478] = {.lex_state = 53, .external_lex_state = 4},
  [3479] = {.lex_state = 0, .external_lex_state = 4},
  [3480] = {.lex_state = 0, .external_lex_state = 4},
  [3481] = {.lex_state = 0, .external_lex_state = 4},
  [3482] = {.lex_state = 0, .external_lex_state = 4},
  [3483] = {.lex_state = 0, .external_lex_state = 4},
  [3484] = {.lex_state = 53, .external_lex_state = 4},
  [3485] = {.lex_state = 67, .external_lex_state = 3},
  [3486] = {.lex_state = 67, .external_lex_state = 3},
  [3487] = {.lex_state = 67, .external_lex_state = 3},
  [3488] = {.lex_state = 67, .external_lex_state = 3},
  [3489] = {.lex_state = 0, .external_lex_state = 4},
  [3490] = {.lex_state = 0, .external_lex_state = 4},
  [3491] = {.lex_state = 53, .external_lex_state = 4},
  [3492] = {.lex_state = 67, .external_lex_state = 3},
  [3493] = {.lex_state = 0, .external_lex_state = 4},
  [3494] = {.lex_state = 0, .external_lex_state = 4},
  [3495] = {.lex_state = 0, .external_lex_state = 4},
  [3496] = {.lex_state = 0, .external_lex_state = 4},
  [3497] = {.lex_state = 53, .external_lex_state = 4},
  [3498] = {.lex_state = 67, .external_lex_state = 3},
  [3499] = {.lex_state = 0, .external_lex_state = 4},
  [3500] = {.lex_state = 67, .external_lex_state = 3},
  [3501] = {.lex_state = 67, .external_lex_state = 3},
  [3502] = {.lex_state = 67, .external_lex_state = 3},
  [3503] = {.lex_state = 0, .external_lex_state = 4},
  [3504] = {.lex_state = 53, .external_lex_state = 4},
  [3505] = {.lex_state = 0, .external_lex_state = 4},
  [3506] = {.lex_state = 0, .external_lex_state = 4},
  [3507] = {.lex_state = 0, .external_lex_state = 4},
  [3508] = {.lex_state = 124, .external_lex_state = 4},
  [3509] = {.lex_state = 0, .external_lex_state = 4},
  [3510] = {.lex_state = 53, .external_lex_state = 4},
  [3511] = {.lex_state = 53, .external_lex_state = 4},
  [3512] = {.lex_state = 0, .external_lex_state = 4},
  [3513] = {.lex_state = 0, .external_lex_state = 4},
  [3514] = {.lex_state = 0, .external_lex_state = 4},
  [3515] = {.lex_state = 0, .external_lex_state = 4},
  [3516] = {.lex_state = 0, .external_lex_state = 4},
  [3517] = {.lex_state = 0, .external_lex_state = 4},
  [3518] = {.lex_state = 0, .external_lex_state = 4},
  [3519] = {.lex_state = 53, .external_lex_state = 4},
  [3520] = {.lex_state = 126, .external_lex_state = 4},
  [3521] = {.lex_state = 108, .external_lex_state = 4},
  [3522] = {.lex_state = 0, .external_lex_state = 4},
  [3523] = {.lex_state = 67, .external_lex_state = 3},
  [3524] = {.lex_state = 0, .external_lex_state = 4},
  [3525] = {.lex_state = 0, .external_lex_state = 4},
  [3526] = {.lex_state = 0, .external_lex_state = 4},
  [3527] = {.lex_state = 67, .external_lex_state = 4},
  [3528] = {.lex_state = 67, .external_lex_state = 4},
  [3529] = {.lex_state = 0, .external_lex_state = 4},
  [3530] = {.lex_state = 0, .external_lex_state = 4},
  [3531] = {.lex_state = 0, .external_lex_state = 4},
  [3532] = {.lex_state = 0, .external_lex_state = 4},
  [3533] = {.lex_state = 0, .external_lex_state = 4},
  [3534] = {.lex_state = 67, .external_lex_state = 4},
  [3535] = {.lex_state = 0, .external_lex_state = 4},
  [3536] = {.lex_state = 67, .external_lex_state = 4},
  [3537] = {.lex_state = 0, .external_lex_state = 4},
  [3538] = {.lex_state = 0, .external_lex_state = 4},
  [3539] = {.lex_state = 0, .external_lex_state = 4},
  [3540] = {.lex_state = 0, .external_lex_state = 4},
  [3541] = {.lex_state = 0, .external_lex_state = 4},
  [3542] = {.lex_state = 0, .external_lex_state = 4},
  [3543] = {.lex_state = 0, .external_lex_state = 4},
  [3544] = {.lex_state = 0, .external_lex_state = 4},
  [3545] = {.lex_state = 0, .external_lex_state = 4},
  [3546] = {.lex_state = 0, .external_lex_state = 4},
  [3547] = {.lex_state = 67, .external_lex_state = 4},
  [3548] = {.lex_state = 0, .external_lex_state = 4},
  [3549] = {.lex_state = 0, .external_lex_state = 4},
  [3550] = {.lex_state = 0, .external_lex_state = 4},
  [3551] = {.lex_state = 67, .external_lex_state = 4},
  [3552] = {.lex_state = 0, .external_lex_state = 4},
  [3553] = {.lex_state = 0, .external_lex_state = 4},
  [3554] = {.lex_state = 0, .external_lex_state = 4},
  [3555] = {.lex_state = 0, .external_lex_state = 4},
  [3556] = {.lex_state = 0, .external_lex_state = 4},
  [3557] = {.lex_state = 0, .external_lex_state = 4},
  [3558] = {.lex_state = 0, .external_lex_state = 4},
  [3559] = {.lex_state = 0, .external_lex_state = 4},
  [3560] = {.lex_state = 0, .external_lex_state = 4},
  [3561] = {.lex_state = 0, .external_lex_state = 4},
  [3562] = {.lex_state = 0, .external_lex_state = 4},
  [3563] = {.lex_state = 0, .external_lex_state = 4},
  [3564] = {.lex_state = 0, .external_lex_state = 4},
  [3565] = {.lex_state = 0, .external_lex_state = 4},
  [3566] = {.lex_state = 0, .external_lex_state = 4},
  [3567] = {.lex_state = 67, .external_lex_state = 4},
  [3568] = {.lex_state = 0, .external_lex_state = 4},
  [3569] = {.lex_state = 0, .external_lex_state = 4},
  [3570] = {.lex_state = 0, .external_lex_state = 4},
  [3571] = {.lex_state = 0, .external_lex_state = 4},
  [3572] = {.lex_state = 67, .external_lex_state = 3},
  [3573] = {.lex_state = 67, .external_lex_state = 3},
  [3574] = {.lex_state = 67, .external_lex_state = 3},
  [3575] = {.lex_state = 0, .external_lex_state = 4},
  [3576] = {.lex_state = 67, .external_lex_state = 3},
  [3577] = {.lex_state = 67, .external_lex_state = 3},
  [3578] = {.lex_state = 67, .external_lex_state = 3},
  [3579] = {.lex_state = 0, .external_lex_state = 4},
  [3580] = {.lex_state = 67, .external_lex_state = 4},
  [3581] = {.lex_state = 67, .external_lex_state = 3},
  [3582] = {.lex_state = 67, .external_lex_state = 3},
  [3583] = {.lex_state = 0, .external_lex_state = 4},
  [3584] = {.lex_state = 67, .external_lex_state = 3},
  [3585] = {.lex_state = 0, .external_lex_state = 4},
  [3586] = {.lex_state = 67, .external_lex_state = 4},
  [3587] = {.lex_state = 67, .external_lex_state = 3},
  [3588] = {.lex_state = 0, .external_lex_state = 4},
  [3589] = {.lex_state = 67, .external_lex_state = 3},
  [3590] = {.lex_state = 0, .external_lex_state = 4},
  [3591] = {.lex_state = 67, .external_lex_state = 3},
  [3592] = {.lex_state = 0, .external_lex_state = 4},
  [3593] = {.lex_state = 0, .external_lex_state = 4},
  [3594] = {.lex_state = 67, .external_lex_state = 3},
  [3595] = {.lex_state = 67, .external_lex_state = 3},
  [3596] = {.lex_state = 67, .external_lex_state = 3},
  [3597] = {.lex_state = 67, .external_lex_state = 3},
  [3598] = {.lex_state = 67, .external_lex_state = 3},
  [3599] = {.lex_state = 67, .external_lex_state = 3},
  [3600] = {.lex_state = 0, .external_lex_state = 4},
  [3601] = {.lex_state = 0, .external_lex_state = 4},
  [3602] = {.lex_state = 67, .external_lex_state = 3},
  [3603] = {.lex_state = 67, .external_lex_state = 3},
  [3604] = {.lex_state = 0, .external_lex_state = 4},
  [3605] = {.lex_state = 67, .external_lex_state = 4},
  [3606] = {.lex_state = 67, .external_lex_state = 3},
  [3607] = {.lex_state = 67, .external_lex_state = 4},
  [3608] = {.lex_state = 0, .external_lex_state = 4},
  [3609] = {.lex_state = 67, .external_lex_state = 3},
  [3610] = {.lex_state = 67, .external_lex_state = 3},
  [3611] = {.lex_state = 0, .external_lex_state = 4},
  [3612] = {.lex_state = 67, .external_lex_state = 4},
  [3613] = {.lex_state = 0, .external_lex_state = 4},
  [3614] = {.lex_state = 0, .external_lex_state = 4},
  [3615] = {.lex_state = 67, .external_lex_state = 4},
  [3616] = {.lex_state = 0, .external_lex_state = 4},
  [3617] = {.lex_state = 0, .external_lex_state = 4},
  [3618] = {.lex_state = 67, .external_lex_state = 4},
  [3619] = {.lex_state = 0, .external_lex_state = 4},
  [3620] = {.lex_state = 0, .external_lex_state = 4},
  [3621] = {.lex_state = 0, .external_lex_state = 4},
  [3622] = {.lex_state = 0, .external_lex_state = 4},
  [3623] = {.lex_state = 0, .external_lex_state = 4},
  [3624] = {.lex_state = 0, .external_lex_state = 4},
  [3625] = {.lex_state = 0, .external_lex_state = 4},
  [3626] = {.lex_state = 0, .external_lex_state = 4},
  [3627] = {.lex_state = 0, .external_lex_state = 4},
  [3628] = {.lex_state = 108, .external_lex_state = 4},
  [3629] = {.lex_state = 0, .external_lex_state = 4},
  [3630] = {.lex_state = 0, .external_lex_state = 4},
  [3631] = {.lex_state = 0, .external_lex_state = 4},
  [3632] = {.lex_state = 67, .external_lex_state = 4},
  [3633] = {.lex_state = 67, .external_lex_state = 4},
  [3634] = {.lex_state = 53, .external_lex_state = 4},
  [3635] = {.lex_state = 0, .external_lex_state = 4},
  [3636] = {.lex_state = 0, .external_lex_state = 4},
  [3637] = {.lex_state = 0, .external_lex_state = 4},
  [3638] = {.lex_state = 0, .external_lex_state = 4},
  [3639] = {.lex_state = 0, .external_lex_state = 4},
  [3640] = {.lex_state = 0, .external_lex_state = 4},
  [3641] = {.lex_state = 67, .external_lex_state = 4},
  [3642] = {.lex_state = 0, .external_lex_state = 4},
  [3643] = {.lex_state = 0, .external_lex_state = 4},
  [3644] = {.lex_state = 108, .external_lex_state = 4},
  [3645] = {.lex_state = 67, .external_lex_state = 4},
  [3646] = {.lex_state = 0, .external_lex_state = 4},
  [3647] = {.lex_state = 0, .external_lex_state = 4},
  [3648] = {.lex_state = 67, .external_lex_state = 4},
  [3649] = {.lex_state = 67, .external_lex_state = 4},
  [3650] = {.lex_state = 0, .external_lex_state = 4},
  [3651] = {.lex_state = 0, .external_lex_state = 4},
  [3652] = {.lex_state = 0, .external_lex_state = 4},
  [3653] = {.lex_state = 126, .external_lex_state = 4},
  [3654] = {.lex_state = 0, .external_lex_state = 4},
  [3655] = {.lex_state = 0, .external_lex_state = 4},
  [3656] = {.lex_state = 0, .external_lex_state = 4},
  [3657] = {.lex_state = 67, .external_lex_state = 3},
  [3658] = {.lex_state = 0, .external_lex_state = 4},
  [3659] = {.lex_state = 0, .external_lex_state = 4},
  [3660] = {.lex_state = 0, .external_lex_state = 4},
  [3661] = {.lex_state = 67, .external_lex_state = 3},
  [3662] = {.lex_state = 0, .external_lex_state = 4},
  [3663] = {.lex_state = 67, .external_lex_state = 3},
  [3664] = {.lex_state = 0, .external_lex_state = 4},
  [3665] = {.lex_state = 0, .external_lex_state = 4},
  [3666] = {.lex_state = 67, .external_lex_state = 3},
  [3667] = {.lex_state = 0, .external_lex_state = 4},
  [3668] = {.lex_state = 0, .external_lex_state = 4},
  [3669] = {.lex_state = 0, .external_lex_state = 4},
  [3670] = {.lex_state = 67, .external_lex_state = 3},
  [3671] = {.lex_state = 0, .external_lex_state = 4},
  [3672] = {.lex_state = 0, .external_lex_state = 4},
  [3673] = {.lex_state = 67, .external_lex_state = 3},
  [3674] = {.lex_state = 0, .external_lex_state = 4},
  [3675] = {.lex_state = 0, .external_lex_state = 4},
  [3676] = {.lex_state = 67, .external_lex_state = 3},
  [3677] = {.lex_state = 0, .external_lex_state = 4},
  [3678] = {.lex_state = 67, .external_lex_state = 3},
  [3679] = {.lex_state = 67, .external_lex_state = 3},
  [3680] = {.lex_state = 67, .external_lex_state = 3},
  [3681] = {.lex_state = 67, .external_lex_state = 3},
  [3682] = {.lex_state = 67, .external_lex_state = 3},
  [3683] = {.lex_state = 67, .external_lex_state = 3},
  [3684] = {.lex_state = 67, .external_lex_state = 3},
  [3685] = {.lex_state = 67, .external_lex_state = 3},
  [3686] = {.lex_state = 67, .external_lex_state = 3},
  [3687] = {.lex_state = 0, .external_lex_state = 4},
  [3688] = {.lex_state = 67, .external_lex_state = 3},
  [3689] = {.lex_state = 0, .external_lex_state = 4},
  [3690] = {.lex_state = 67, .external_lex_state = 3},
  [3691] = {.lex_state = 67, .external_lex_state = 3},
  [3692] = {.lex_state = 67, .external_lex_state = 3},
  [3693] = {.lex_state = 67, .external_lex_state = 3},
  [3694] = {.lex_state = 67, .external_lex_state = 3},
  [3695] = {.lex_state = 0, .external_lex_state = 4},
  [3696] = {.lex_state = 0, .external_lex_state = 4},
  [3697] = {.lex_state = 67, .external_lex_state = 3},
  [3698] = {.lex_state = 0, .external_lex_state = 4},
  [3699] = {.lex_state = 53, .external_lex_state = 4},
  [3700] = {.lex_state = 67, .external_lex_state = 3},
  [3701] = {.lex_state = 53, .external_lex_state = 4},
  [3702] = {.lex_state = 0, .external_lex_state = 4},
  [3703] = {.lex_state = 0, .external_lex_state = 4},
  [3704] = {.lex_state = 0, .external_lex_state = 4},
  [3705] = {.lex_state = 0, .external_lex_state = 4},
  [3706] = {.lex_state = 67, .external_lex_state = 3},
  [3707] = {.lex_state = 0, .external_lex_state = 4},
  [3708] = {.lex_state = 0, .external_lex_state = 4},
  [3709] = {.lex_state = 53, .external_lex_state = 4},
  [3710] = {.lex_state = 0, .external_lex_state = 4},
  [3711] = {.lex_state = 53, .external_lex_state = 4},
  [3712] = {.lex_state = 0, .external_lex_state = 4},
  [3713] = {.lex_state = 0, .external_lex_state = 4},
  [3714] = {.lex_state = 0, .external_lex_state = 4},
  [3715] = {.lex_state = 0, .external_lex_state = 4},
  [3716] = {.lex_state = 0, .external_lex_state = 4},
  [3717] = {.lex_state = 0, .external_lex_state = 4},
  [3718] = {.lex_state = 0, .external_lex_state = 4},
  [3719] = {.lex_state = 0, .external_lex_state = 4},
  [3720] = {.lex_state = 0, .external_lex_state = 4},
  [3721] = {.lex_state = 0, .external_lex_state = 4},
  [3722] = {.lex_state = 0, .external_lex_state = 4},
  [3723] = {.lex_state = 0, .external_lex_state = 4},
  [3724] = {.lex_state = 0, .external_lex_state = 4},
  [3725] = {.lex_state = 0, .external_lex_state = 4},
  [3726] = {.lex_state = 0, .external_lex_state = 4},
  [3727] = {.lex_state = 0, .external_lex_state = 4},
  [3728] = {.lex_state = 0, .external_lex_state = 4},
  [3729] = {.lex_state = 0, .external_lex_state = 4},
  [3730] = {.lex_state = 0, .external_lex_state = 4},
  [3731] = {.lex_state = 0, .external_lex_state = 4},
  [3732] = {.lex_state = 0, .external_lex_state = 4},
  [3733] = {.lex_state = 0, .external_lex_state = 4},
  [3734] = {.lex_state = 0, .external_lex_state = 4},
  [3735] = {.lex_state = 53, .external_lex_state = 4},
  [3736] = {.lex_state = 0, .external_lex_state = 4},
  [3737] = {.lex_state = 0, .external_lex_state = 4},
  [3738] = {.lex_state = 0, .external_lex_state = 4},
  [3739] = {.lex_state = 0, .external_lex_state = 4},
  [3740] = {.lex_state = 0, .external_lex_state = 4},
  [3741] = {.lex_state = 126, .external_lex_state = 4},
  [3742] = {.lex_state = 0, .external_lex_state = 4},
  [3743] = {.lex_state = 0, .external_lex_state = 4},
  [3744] = {.lex_state = 0, .external_lex_state = 4},
  [3745] = {.lex_state = 0, .external_lex_state = 4},
  [3746] = {.lex_state = 0, .external_lex_state = 4},
  [3747] = {.lex_state = 0, .external_lex_state = 4},
  [3748] = {.lex_state = 53, .external_lex_state = 4},
  [3749] = {.lex_state = 0, .external_lex_state = 4},
  [3750] = {.lex_state = 0, .external_lex_state = 4},
  [3751] = {.lex_state = 53, .external_lex_state = 4},
  [3752] = {.lex_state = 0, .external_lex_state = 4},
  [3753] = {.lex_state = 0, .external_lex_state = 4},
  [3754] = {.lex_state = 0, .external_lex_state = 4},
  [3755] = {.lex_state = 0, .external_lex_state = 4},
  [3756] = {.lex_state = 0, .external_lex_state = 4},
  [3757] = {.lex_state = 0, .external_lex_state = 4},
  [3758] = {.lex_state = 53, .external_lex_state = 4},
  [3759] = {.lex_state = 0, .external_lex_state = 4},
  [3760] = {.lex_state = 0, .external_lex_state = 4},
  [3761] = {.lex_state = 0, .external_lex_state = 4},
  [3762] = {.lex_state = 0, .external_lex_state = 4},
  [3763] = {.lex_state = 0, .external_lex_state = 4},
  [3764] = {.lex_state = 0, .external_lex_state = 4},
  [3765] = {.lex_state = 0, .external_lex_state = 4},
  [3766] = {.lex_state = 0, .external_lex_state = 4},
  [3767] = {.lex_state = 0, .external_lex_state = 4},
  [3768] = {.lex_state = 0, .external_lex_state = 4},
  [3769] = {.lex_state = 0, .external_lex_state = 4},
  [3770] = {.lex_state = 0, .external_lex_state = 4},
  [3771] = {.lex_state = 0, .external_lex_state = 4},
  [3772] = {.lex_state = 0, .external_lex_state = 4},
  [3773] = {.lex_state = 0, .external_lex_state = 4},
  [3774] = {.lex_state = 0, .external_lex_state = 4},
  [3775] = {.lex_state = 0, .external_lex_state = 4},
  [3776] = {.lex_state = 0, .external_lex_state = 4},
  [3777] = {.lex_state = 0, .external_lex_state = 4},
  [3778] = {.lex_state = 0, .external_lex_state = 4},
  [3779] = {.lex_state = 0, .external_lex_state = 4},
  [3780] = {.lex_state = 0, .external_lex_state = 4},
  [3781] = {.lex_state = 0, .external_lex_state = 4},
  [3782] = {.lex_state = 0, .external_lex_state = 4},
  [3783] = {.lex_state = 0, .external_lex_state = 4},
  [3784] = {.lex_state = 0, .external_lex_state = 4},
  [3785] = {.lex_state = 0, .external_lex_state = 4},
  [3786] = {.lex_state = 0, .external_lex_state = 4},
  [3787] = {.lex_state = 0, .external_lex_state = 4},
  [3788] = {.lex_state = 0, .external_lex_state = 4},
  [3789] = {.lex_state = 0, .external_lex_state = 4},
  [3790] = {.lex_state = 0, .external_lex_state = 4},
  [3791] = {.lex_state = 0, .external_lex_state = 4},
  [3792] = {.lex_state = 0, .external_lex_state = 4},
  [3793] = {.lex_state = 0, .external_lex_state = 4},
  [3794] = {.lex_state = 0, .external_lex_state = 4},
  [3795] = {.lex_state = 0, .external_lex_state = 4},
  [3796] = {.lex_state = 0, .external_lex_state = 4},
  [3797] = {.lex_state = 0, .external_lex_state = 4},
  [3798] = {.lex_state = 0, .external_lex_state = 4},
  [3799] = {.lex_state = 0, .external_lex_state = 4},
  [3800] = {.lex_state = 0, .external_lex_state = 4},
  [3801] = {.lex_state = 0, .external_lex_state = 4},
  [3802] = {.lex_state = 0, .external_lex_state = 4},
  [3803] = {.lex_state = 0, .external_lex_state = 4},
  [3804] = {.lex_state = 0, .external_lex_state = 4},
  [3805] = {.lex_state = 0, .external_lex_state = 4},
  [3806] = {.lex_state = 126, .external_lex_state = 4},
  [3807] = {.lex_state = 0, .external_lex_state = 4},
  [3808] = {.lex_state = 0, .external_lex_state = 4},
  [3809] = {.lex_state = 0, .external_lex_state = 4},
  [3810] = {.lex_state = 0, .external_lex_state = 4},
  [3811] = {.lex_state = 0, .external_lex_state = 4},
  [3812] = {.lex_state = 0, .external_lex_state = 4},
  [3813] = {.lex_state = 0, .external_lex_state = 4},
  [3814] = {.lex_state = 0, .external_lex_state = 4},
  [3815] = {.lex_state = 0, .external_lex_state = 4},
  [3816] = {.lex_state = 0, .external_lex_state = 4},
  [3817] = {.lex_state = 0, .external_lex_state = 4},
  [3818] = {.lex_state = 0, .external_lex_state = 4},
  [3819] = {.lex_state = 0, .external_lex_state = 4},
  [3820] = {.lex_state = 0, .external_lex_state = 4},
  [3821] = {.lex_state = 0, .external_lex_state = 4},
  [3822] = {.lex_state = 0, .external_lex_state = 4},
  [3823] = {.lex_state = 0, .external_lex_state = 4},
  [3824] = {.lex_state = 126, .external_lex_state = 4},
  [3825] = {.lex_state = 0, .external_lex_state = 4},
  [3826] = {.lex_state = 0, .external_lex_state = 4},
  [3827] = {.lex_state = 0, .external_lex_state = 4},
  [3828] = {.lex_state = 0, .external_lex_state = 4},
  [3829] = {.lex_state = 0, .external_lex_state = 4},
  [3830] = {.lex_state = 0, .external_lex_state = 4},
  [3831] = {.lex_state = 0, .external_lex_state = 4},
  [3832] = {.lex_state = 0, .external_lex_state = 4},
  [3833] = {.lex_state = 0, .external_lex_state = 4},
  [3834] = {.lex_state = 0, .external_lex_state = 4},
  [3835] = {.lex_state = 0, .external_lex_state = 4},
  [3836] = {.lex_state = 0, .external_lex_state = 4},
  [3837] = {.lex_state = 0, .external_lex_state = 4},
  [3838] = {.lex_state = 0, .external_lex_state = 4},
  [3839] = {.lex_state = 0, .external_lex_state = 4},
  [3840] = {.lex_state = 0, .external_lex_state = 4},
  [3841] = {.lex_state = 0, .external_lex_state = 4},
  [3842] = {.lex_state = 0, .external_lex_state = 4},
  [3843] = {.lex_state = 0, .external_lex_state = 4},
  [3844] = {.lex_state = 0, .external_lex_state = 4},
  [3845] = {.lex_state = 0, .external_lex_state = 4},
  [3846] = {.lex_state = 0, .external_lex_state = 4},
  [3847] = {.lex_state = 0, .external_lex_state = 4},
  [3848] = {.lex_state = 0, .external_lex_state = 4},
  [3849] = {.lex_state = 0, .external_lex_state = 4},
  [3850] = {.lex_state = 0, .external_lex_state = 4},
  [3851] = {.lex_state = 0, .external_lex_state = 4},
  [3852] = {.lex_state = 0, .external_lex_state = 4},
  [3853] = {.lex_state = 0, .external_lex_state = 4},
  [3854] = {.lex_state = 0, .external_lex_state = 4},
  [3855] = {.lex_state = 0, .external_lex_state = 4},
  [3856] = {.lex_state = 0, .external_lex_state = 4},
  [3857] = {.lex_state = 0, .external_lex_state = 4},
  [3858] = {.lex_state = 0, .external_lex_state = 4},
  [3859] = {.lex_state = 0, .external_lex_state = 4},
  [3860] = {.lex_state = 0, .external_lex_state = 4},
  [3861] = {.lex_state = 0, .external_lex_state = 4},
  [3862] = {.lex_state = 0, .external_lex_state = 4},
  [3863] = {.lex_state = 0, .external_lex_state = 4},
  [3864] = {.lex_state = 126, .external_lex_state = 4},
  [3865] = {.lex_state = 0, .external_lex_state = 4},
  [3866] = {.lex_state = 0, .external_lex_state = 4},
  [3867] = {.lex_state = 0, .external_lex_state = 4},
  [3868] = {.lex_state = 0, .external_lex_state = 4},
  [3869] = {.lex_state = 67, .external_lex_state = 3},
  [3870] = {.lex_state = 0, .external_lex_state = 4},
  [3871] = {.lex_state = 0, .external_lex_state = 4},
  [3872] = {.lex_state = 0, .external_lex_state = 4},
  [3873] = {.lex_state = 0, .external_lex_state = 4},
  [3874] = {.lex_state = 0, .external_lex_state = 4},
  [3875] = {.lex_state = 0, .external_lex_state = 4},
  [3876] = {.lex_state = 53, .external_lex_state = 4},
  [3877] = {.lex_state = 0, .external_lex_state = 4},
  [3878] = {.lex_state = 0, .external_lex_state = 4},
  [3879] = {.lex_state = 0, .external_lex_state = 4},
  [3880] = {.lex_state = 69, .external_lex_state = 4},
  [3881] = {.lex_state = 0, .external_lex_state = 4},
  [3882] = {.lex_state = 0, .external_lex_state = 4},
  [3883] = {.lex_state = 0, .external_lex_state = 4},
  [3884] = {.lex_state = 0, .external_lex_state = 4},
  [3885] = {.lex_state = 0, .external_lex_state = 4},
  [3886] = {.lex_state = 0, .external_lex_state = 4},
  [3887] = {.lex_state = 0, .external_lex_state = 4},
  [3888] = {.lex_state = 0, .external_lex_state = 4},
  [3889] = {.lex_state = 0, .external_lex_state = 4},
  [3890] = {.lex_state = 0, .external_lex_state = 4},
  [3891] = {.lex_state = 0, .external_lex_state = 4},
  [3892] = {.lex_state = 0, .external_lex_state = 4},
  [3893] = {.lex_state = 0, .external_lex_state = 4},
  [3894] = {.lex_state = 0, .external_lex_state = 4},
  [3895] = {.lex_state = 0, .external_lex_state = 4},
  [3896] = {.lex_state = 0, .external_lex_state = 4},
  [3897] = {.lex_state = 0, .external_lex_state = 4},
  [3898] = {.lex_state = 0, .external_lex_state = 4},
  [3899] = {.lex_state = 0, .external_lex_state = 4},
  [3900] = {.lex_state = 126, .external_lex_state = 4},
  [3901] = {.lex_state = 0, .external_lex_state = 4},
  [3902] = {.lex_state = 0, .external_lex_state = 4},
  [3903] = {.lex_state = 0, .external_lex_state = 4},
  [3904] = {.lex_state = 0, .external_lex_state = 4},
  [3905] = {.lex_state = 0, .external_lex_state = 4},
  [3906] = {.lex_state = 0, .external_lex_state = 4},
  [3907] = {.lex_state = 0, .external_lex_state = 4},
  [3908] = {.lex_state = 0, .external_lex_state = 4},
  [3909] = {.lex_state = 0, .external_lex_state = 4},
  [3910] = {.lex_state = 0, .external_lex_state = 4},
  [3911] = {.lex_state = 0, .external_lex_state = 4},
  [3912] = {.lex_state = 0, .external_lex_state = 4},
  [3913] = {.lex_state = 0, .external_lex_state = 4},
  [3914] = {.lex_state = 0, .external_lex_state = 4},
  [3915] = {.lex_state = 0, .external_lex_state = 4},
  [3916] = {.lex_state = 0, .external_lex_state = 4},
  [3917] = {.lex_state = 0, .external_lex_state = 4},
  [3918] = {.lex_state = 0, .external_lex_state = 4},
  [3919] = {.lex_state = 0, .external_lex_state = 4},
  [3920] = {.lex_state = 0, .external_lex_state = 4},
  [3921] = {.lex_state = 0, .external_lex_state = 4},
  [3922] = {.lex_state = 0, .external_lex_state = 4},
  [3923] = {.lex_state = 0, .external_lex_state = 4},
  [3924] = {.lex_state = 0, .external_lex_state = 4},
  [3925] = {.lex_state = 0, .external_lex_state = 4},
  [3926] = {.lex_state = 0, .external_lex_state = 4},
  [3927] = {.lex_state = 0, .external_lex_state = 4},
  [3928] = {.lex_state = 0, .external_lex_state = 4},
  [3929] = {.lex_state = 0, .external_lex_state = 4},
  [3930] = {.lex_state = 0, .external_lex_state = 4},
  [3931] = {.lex_state = 0, .external_lex_state = 4},
  [3932] = {.lex_state = 0, .external_lex_state = 4},
  [3933] = {.lex_state = 0, .external_lex_state = 4},
  [3934] = {.lex_state = 0, .external_lex_state = 4},
  [3935] = {.lex_state = 0, .external_lex_state = 4},
  [3936] = {.lex_state = 0, .external_lex_state = 4},
  [3937] = {.lex_state = 0, .external_lex_state = 4},
  [3938] = {.lex_state = 0, .external_lex_state = 4},
  [3939] = {.lex_state = 0, .external_lex_state = 4},
  [3940] = {.lex_state = 0, .external_lex_state = 4},
  [3941] = {.lex_state = 0, .external_lex_state = 4},
  [3942] = {.lex_state = 0, .external_lex_state = 4},
  [3943] = {.lex_state = 0, .external_lex_state = 4},
  [3944] = {.lex_state = 0, .external_lex_state = 4},
  [3945] = {.lex_state = 0, .external_lex_state = 4},
  [3946] = {.lex_state = 0, .external_lex_state = 4},
  [3947] = {.lex_state = 0, .external_lex_state = 4},
  [3948] = {.lex_state = 0, .external_lex_state = 4},
  [3949] = {.lex_state = 0, .external_lex_state = 4},
  [3950] = {.lex_state = 0, .external_lex_state = 4},
  [3951] = {.lex_state = 0, .external_lex_state = 4},
  [3952] = {.lex_state = 0, .external_lex_state = 4},
  [3953] = {.lex_state = 0, .external_lex_state = 4},
  [3954] = {.lex_state = 0, .external_lex_state = 4},
  [3955] = {.lex_state = 0, .external_lex_state = 4},
  [3956] = {.lex_state = 0, .external_lex_state = 4},
  [3957] = {.lex_state = 0, .external_lex_state = 4},
  [3958] = {.lex_state = 0, .external_lex_state = 4},
  [3959] = {.lex_state = 0, .external_lex_state = 4},
  [3960] = {.lex_state = 0, .external_lex_state = 4},
  [3961] = {.lex_state = 0, .external_lex_state = 4},
  [3962] = {.lex_state = 0, .external_lex_state = 4},
  [3963] = {.lex_state = 0, .external_lex_state = 4},
  [3964] = {.lex_state = 0, .external_lex_state = 4},
  [3965] = {.lex_state = 0, .external_lex_state = 4},
  [3966] = {.lex_state = 0, .external_lex_state = 4},
  [3967] = {.lex_state = 0, .external_lex_state = 4},
  [3968] = {.lex_state = 0, .external_lex_state = 4},
  [3969] = {.lex_state = 0, .external_lex_state = 4},
  [3970] = {.lex_state = 0, .external_lex_state = 4},
  [3971] = {.lex_state = 0, .external_lex_state = 4},
  [3972] = {.lex_state = 0, .external_lex_state = 4},
  [3973] = {.lex_state = 0, .external_lex_state = 4},
  [3974] = {.lex_state = 0, .external_lex_state = 4},
  [3975] = {.lex_state = 0, .external_lex_state = 4},
  [3976] = {.lex_state = 0, .external_lex_state = 4},
  [3977] = {.lex_state = 0, .external_lex_state = 4},
  [3978] = {.lex_state = 0, .external_lex_state = 4},
  [3979] = {.lex_state = 0, .external_lex_state = 4},
  [3980] = {.lex_state = 0, .external_lex_state = 4},
  [3981] = {.lex_state = 0, .external_lex_state = 4},
  [3982] = {.lex_state = 0, .external_lex_state = 4},
  [3983] = {.lex_state = 0, .external_lex_state = 4},
  [3984] = {.lex_state = 53, .external_lex_state = 4},
  [3985] = {.lex_state = 0, .external_lex_state = 4},
  [3986] = {.lex_state = 0, .external_lex_state = 4},
  [3987] = {.lex_state = 0, .external_lex_state = 4},
  [3988] = {.lex_state = 0, .external_lex_state = 4},
  [3989] = {.lex_state = 126, .external_lex_state = 4},
  [3990] = {.lex_state = 0, .external_lex_state = 4},
  [3991] = {.lex_state = 0, .external_lex_state = 4},
  [3992] = {.lex_state = 0, .external_lex_state = 4},
  [3993] = {.lex_state = 0, .external_lex_state = 4},
  [3994] = {.lex_state = 0, .external_lex_state = 4},
  [3995] = {.lex_state = 0, .external_lex_state = 4},
  [3996] = {.lex_state = 0, .external_lex_state = 4},
  [3997] = {.lex_state = 0, .external_lex_state = 4},
  [3998] = {.lex_state = 0, .external_lex_state = 4},
  [3999] = {.lex_state = 0, .external_lex_state = 4},
  [4000] = {.lex_state = 0, .external_lex_state = 4},
  [4001] = {.lex_state = 0, .external_lex_state = 4},
  [4002] = {.lex_state = 0, .external_lex_state = 4},
  [4003] = {.lex_state = 0, .external_lex_state = 4},
  [4004] = {.lex_state = 0, .external_lex_state = 4},
  [4005] = {.lex_state = 0, .external_lex_state = 4},
  [4006] = {.lex_state = 0, .external_lex_state = 4},
  [4007] = {.lex_state = 0, .external_lex_state = 4},
  [4008] = {.lex_state = 0, .external_lex_state = 4},
  [4009] = {.lex_state = 0, .external_lex_state = 4},
  [4010] = {.lex_state = 0, .external_lex_state = 4},
  [4011] = {.lex_state = 0, .external_lex_state = 4},
  [4012] = {.lex_state = 0, .external_lex_state = 4},
  [4013] = {.lex_state = 0, .external_lex_state = 4},
  [4014] = {.lex_state = 0, .external_lex_state = 4},
  [4015] = {.lex_state = 0, .external_lex_state = 4},
  [4016] = {.lex_state = 0, .external_lex_state = 4},
  [4017] = {.lex_state = 0, .external_lex_state = 4},
  [4018] = {.lex_state = 0, .external_lex_state = 4},
  [4019] = {.lex_state = 0, .external_lex_state = 4},
  [4020] = {.lex_state = 0, .external_lex_state = 4},
  [4021] = {.lex_state = 0, .external_lex_state = 4},
  [4022] = {.lex_state = 0, .external_lex_state = 4},
  [4023] = {.lex_state = 0, .external_lex_state = 4},
  [4024] = {.lex_state = 0, .external_lex_state = 4},
  [4025] = {.lex_state = 0, .external_lex_state = 4},
  [4026] = {.lex_state = 0, .external_lex_state = 4},
  [4027] = {.lex_state = 0, .external_lex_state = 4},
  [4028] = {.lex_state = 0, .external_lex_state = 4},
  [4029] = {.lex_state = 0, .external_lex_state = 4},
  [4030] = {.lex_state = 0, .external_lex_state = 4},
  [4031] = {.lex_state = 0, .external_lex_state = 4},
  [4032] = {.lex_state = 0, .external_lex_state = 4},
  [4033] = {.lex_state = 0, .external_lex_state = 4},
  [4034] = {.lex_state = 0, .external_lex_state = 4},
  [4035] = {.lex_state = 0, .external_lex_state = 4},
  [4036] = {.lex_state = 0, .external_lex_state = 4},
  [4037] = {.lex_state = 0, .external_lex_state = 4},
  [4038] = {.lex_state = 0, .external_lex_state = 4},
  [4039] = {.lex_state = 0, .external_lex_state = 4},
  [4040] = {.lex_state = 0, .external_lex_state = 4},
  [4041] = {.lex_state = 0, .external_lex_state = 4},
  [4042] = {.lex_state = 0, .external_lex_state = 4},
  [4043] = {.lex_state = 0, .external_lex_state = 4},
  [4044] = {.lex_state = 0, .external_lex_state = 4},
  [4045] = {.lex_state = 0, .external_lex_state = 4},
  [4046] = {.lex_state = 0, .external_lex_state = 4},
  [4047] = {.lex_state = 0, .external_lex_state = 4},
  [4048] = {.lex_state = 0, .external_lex_state = 4},
  [4049] = {.lex_state = 0, .external_lex_state = 4},
  [4050] = {.lex_state = 0, .external_lex_state = 4},
  [4051] = {.lex_state = 0, .external_lex_state = 4},
  [4052] = {.lex_state = 0, .external_lex_state = 4},
  [4053] = {.lex_state = 0, .external_lex_state = 4},
  [4054] = {.lex_state = 0, .external_lex_state = 4},
  [4055] = {.lex_state = 0, .external_lex_state = 4},
  [4056] = {.lex_state = 0, .external_lex_state = 4},
  [4057] = {.lex_state = 0, .external_lex_state = 4},
  [4058] = {.lex_state = 0, .external_lex_state = 4},
  [4059] = {.lex_state = 0, .external_lex_state = 4},
  [4060] = {.lex_state = 0, .external_lex_state = 4},
  [4061] = {.lex_state = 0, .external_lex_state = 4},
  [4062] = {.lex_state = 0, .external_lex_state = 4},
  [4063] = {.lex_state = 0, .external_lex_state = 4},
  [4064] = {.lex_state = 0, .external_lex_state = 4},
  [4065] = {.lex_state = 0, .external_lex_state = 4},
  [4066] = {.lex_state = 0, .external_lex_state = 4},
  [4067] = {.lex_state = 0, .external_lex_state = 4},
  [4068] = {.lex_state = 0, .external_lex_state = 4},
  [4069] = {.lex_state = 0, .external_lex_state = 4},
  [4070] = {.lex_state = 0, .external_lex_state = 4},
  [4071] = {.lex_state = 0, .external_lex_state = 4},
  [4072] = {.lex_state = 0, .external_lex_state = 4},
  [4073] = {.lex_state = 0, .external_lex_state = 4},
  [4074] = {.lex_state = 0, .external_lex_state = 4},
  [4075] = {.lex_state = 0, .external_lex_state = 4},
  [4076] = {.lex_state = 0, .external_lex_state = 4},
  [4077] = {.lex_state = 0, .external_lex_state = 4},
  [4078] = {.lex_state = 0, .external_lex_state = 4},
  [4079] = {.lex_state = 0, .external_lex_state = 4},
  [4080] = {.lex_state = 0, .external_lex_state = 4},
  [4081] = {.lex_state = 0, .external_lex_state = 4},
  [4082] = {.lex_state = 0, .external_lex_state = 4},
  [4083] = {.lex_state = 0, .external_lex_state = 4},
  [4084] = {.lex_state = 0, .external_lex_state = 4},
  [4085] = {.lex_state = 0, .external_lex_state = 4},
  [4086] = {.lex_state = 0, .external_lex_state = 4},
  [4087] = {.lex_state = 0, .external_lex_state = 4},
  [4088] = {.lex_state = 0, .external_lex_state = 4},
  [4089] = {.lex_state = 0, .external_lex_state = 4},
  [4090] = {.lex_state = 0, .external_lex_state = 4},
  [4091] = {.lex_state = 0, .external_lex_state = 4},
  [4092] = {.lex_state = 0, .external_lex_state = 4},
  [4093] = {.lex_state = 0, .external_lex_state = 4},
  [4094] = {.lex_state = 0, .external_lex_state = 4},
  [4095] = {.lex_state = 0, .external_lex_state = 4},
  [4096] = {.lex_state = 0, .external_lex_state = 4},
  [4097] = {.lex_state = 0, .external_lex_state = 4},
  [4098] = {.lex_state = 0, .external_lex_state = 4},
  [4099] = {.lex_state = 0, .external_lex_state = 4},
  [4100] = {.lex_state = 0, .external_lex_state = 4},
  [4101] = {.lex_state = 0, .external_lex_state = 4},
  [4102] = {.lex_state = 0, .external_lex_state = 4},
  [4103] = {.lex_state = 0, .external_lex_state = 4},
  [4104] = {.lex_state = 0, .external_lex_state = 4},
  [4105] = {.lex_state = 0, .external_lex_state = 4},
  [4106] = {.lex_state = 0, .external_lex_state = 4},
  [4107] = {.lex_state = 0, .external_lex_state = 4},
  [4108] = {.lex_state = 0, .external_lex_state = 4},
  [4109] = {.lex_state = 0, .external_lex_state = 4},
  [4110] = {.lex_state = 0, .external_lex_state = 4},
  [4111] = {.lex_state = 0, .external_lex_state = 4},
  [4112] = {.lex_state = 0, .external_lex_state = 4},
  [4113] = {.lex_state = 0, .external_lex_state = 4},
  [4114] = {.lex_state = 0, .external_lex_state = 4},
  [4115] = {.lex_state = 0, .external_lex_state = 4},
  [4116] = {.lex_state = 0, .external_lex_state = 4},
  [4117] = {.lex_state = 0, .external_lex_state = 4},
  [4118] = {.lex_state = 0, .external_lex_state = 4},
  [4119] = {.lex_state = 0, .external_lex_state = 4},
  [4120] = {.lex_state = 0, .external_lex_state = 4},
  [4121] = {.lex_state = 0, .external_lex_state = 4},
  [4122] = {.lex_state = 0, .external_lex_state = 4},
  [4123] = {.lex_state = 0, .external_lex_state = 4},
  [4124] = {.lex_state = 0, .external_lex_state = 4},
  [4125] = {.lex_state = 0, .external_lex_state = 4},
  [4126] = {.lex_state = 0, .external_lex_state = 4},
  [4127] = {.lex_state = 0, .external_lex_state = 4},
  [4128] = {.lex_state = 0, .external_lex_state = 4},
  [4129] = {.lex_state = 0, .external_lex_state = 4},
  [4130] = {.lex_state = 0, .external_lex_state = 4},
  [4131] = {.lex_state = 0, .external_lex_state = 4},
  [4132] = {.lex_state = 0, .external_lex_state = 4},
  [4133] = {.lex_state = 0, .external_lex_state = 4},
  [4134] = {.lex_state = 0, .external_lex_state = 4},
  [4135] = {.lex_state = 0, .external_lex_state = 4},
  [4136] = {.lex_state = 0, .external_lex_state = 4},
  [4137] = {.lex_state = 0, .external_lex_state = 4},
  [4138] = {.lex_state = 0, .external_lex_state = 4},
  [4139] = {.lex_state = 0, .external_lex_state = 4},
  [4140] = {.lex_state = 0, .external_lex_state = 4},
  [4141] = {.lex_state = 0, .external_lex_state = 4},
  [4142] = {.lex_state = 0, .external_lex_state = 4},
  [4143] = {.lex_state = 0, .external_lex_state = 4},
  [4144] = {.lex_state = 0, .external_lex_state = 4},
  [4145] = {.lex_state = 0, .external_lex_state = 4},
  [4146] = {.lex_state = 0, .external_lex_state = 4},
  [4147] = {.lex_state = 0, .external_lex_state = 4},
  [4148] = {.lex_state = 0, .external_lex_state = 4},
  [4149] = {.lex_state = 0, .external_lex_state = 4},
  [4150] = {.lex_state = 0, .external_lex_state = 4},
  [4151] = {.lex_state = 0, .external_lex_state = 4},
  [4152] = {.lex_state = 0, .external_lex_state = 4},
  [4153] = {.lex_state = 0, .external_lex_state = 4},
  [4154] = {.lex_state = 0, .external_lex_state = 4},
  [4155] = {.lex_state = 0, .external_lex_state = 4},
  [4156] = {.lex_state = 0, .external_lex_state = 4},
  [4157] = {.lex_state = 0, .external_lex_state = 4},
  [4158] = {.lex_state = 0, .external_lex_state = 4},
  [4159] = {.lex_state = 0, .external_lex_state = 4},
  [4160] = {.lex_state = 0, .external_lex_state = 4},
  [4161] = {.lex_state = 0, .external_lex_state = 4},
  [4162] = {.lex_state = 0, .external_lex_state = 4},
  [4163] = {.lex_state = 0, .external_lex_state = 4},
  [4164] = {.lex_state = 0, .external_lex_state = 4},
  [4165] = {.lex_state = 0, .external_lex_state = 4},
  [4166] = {.lex_state = 0, .external_lex_state = 4},
  [4167] = {.lex_state = 0, .external_lex_state = 4},
  [4168] = {.lex_state = 0, .external_lex_state = 4},
  [4169] = {.lex_state = 0, .external_lex_state = 4},
  [4170] = {.lex_state = 0, .external_lex_state = 4},
  [4171] = {.lex_state = 0, .external_lex_state = 4},
  [4172] = {.lex_state = 0, .external_lex_state = 4},
  [4173] = {.lex_state = 0, .external_lex_state = 4},
  [4174] = {.lex_state = 0, .external_lex_state = 4},
  [4175] = {.lex_state = 0, .external_lex_state = 4},
  [4176] = {.lex_state = 0, .external_lex_state = 4},
  [4177] = {.lex_state = 0, .external_lex_state = 4},
  [4178] = {.lex_state = 0, .external_lex_state = 4},
  [4179] = {.lex_state = 0, .external_lex_state = 4},
  [4180] = {.lex_state = 0, .external_lex_state = 4},
  [4181] = {.lex_state = 0, .external_lex_state = 4},
  [4182] = {.lex_state = 0, .external_lex_state = 4},
  [4183] = {.lex_state = 0, .external_lex_state = 4},
  [4184] = {.lex_state = 0, .external_lex_state = 4},
  [4185] = {.lex_state = 0, .external_lex_state = 4},
  [4186] = {.lex_state = 0, .external_lex_state = 4},
  [4187] = {.lex_state = 0, .external_lex_state = 4},
  [4188] = {.lex_state = 0, .external_lex_state = 4},
  [4189] = {.lex_state = 0, .external_lex_state = 4},
  [4190] = {.lex_state = 0, .external_lex_state = 4},
  [4191] = {.lex_state = 0, .external_lex_state = 4},
  [4192] = {.lex_state = 0, .external_lex_state = 4},
  [4193] = {.lex_state = 0, .external_lex_state = 4},
  [4194] = {.lex_state = 0, .external_lex_state = 4},
  [4195] = {.lex_state = 0, .external_lex_state = 4},
  [4196] = {.lex_state = 0, .external_lex_state = 4},
  [4197] = {.lex_state = 0, .external_lex_state = 4},
  [4198] = {.lex_state = 0, .external_lex_state = 4},
  [4199] = {.lex_state = 0, .external_lex_state = 4},
  [4200] = {.lex_state = 0, .external_lex_state = 4},
  [4201] = {.lex_state = 0, .external_lex_state = 4},
  [4202] = {.lex_state = 0, .external_lex_state = 4},
  [4203] = {.lex_state = 0, .external_lex_state = 4},
  [4204] = {.lex_state = 0, .external_lex_state = 4},
  [4205] = {.lex_state = 0, .external_lex_state = 4},
  [4206] = {.lex_state = 0, .external_lex_state = 4},
  [4207] = {.lex_state = 0, .external_lex_state = 4},
  [4208] = {.lex_state = 0, .external_lex_state = 4},
  [4209] = {.lex_state = 0, .external_lex_state = 4},
  [4210] = {.lex_state = 0, .external_lex_state = 4},
  [4211] = {.lex_state = 0, .external_lex_state = 4},
  [4212] = {.lex_state = 0, .external_lex_state = 4},
  [4213] = {.lex_state = 0, .external_lex_state = 4},
  [4214] = {.lex_state = 0, .external_lex_state = 4},
  [4215] = {.lex_state = 0, .external_lex_state = 4},
  [4216] = {.lex_state = 0, .external_lex_state = 4},
  [4217] = {.lex_state = 0, .external_lex_state = 4},
  [4218] = {.lex_state = 0, .external_lex_state = 4},
  [4219] = {.lex_state = 0, .external_lex_state = 4},
  [4220] = {.lex_state = 0, .external_lex_state = 4},
  [4221] = {.lex_state = 0, .external_lex_state = 4},
  [4222] = {.lex_state = 0, .external_lex_state = 4},
  [4223] = {.lex_state = 0, .external_lex_state = 4},
  [4224] = {.lex_state = 0, .external_lex_state = 4},
  [4225] = {.lex_state = 0, .external_lex_state = 4},
  [4226] = {.lex_state = 0, .external_lex_state = 4},
  [4227] = {.lex_state = 0, .external_lex_state = 4},
  [4228] = {.lex_state = 0, .external_lex_state = 4},
  [4229] = {.lex_state = 0, .external_lex_state = 4},
  [4230] = {.lex_state = 0, .external_lex_state = 4},
  [4231] = {.lex_state = 0, .external_lex_state = 4},
  [4232] = {.lex_state = 0, .external_lex_state = 4},
  [4233] = {.lex_state = 0, .external_lex_state = 4},
  [4234] = {.lex_state = 0, .external_lex_state = 4},
  [4235] = {.lex_state = 0, .external_lex_state = 4},
  [4236] = {.lex_state = 0, .external_lex_state = 4},
  [4237] = {.lex_state = 0, .external_lex_state = 4},
  [4238] = {.lex_state = 0, .external_lex_state = 4},
  [4239] = {.lex_state = 0, .external_lex_state = 4},
  [4240] = {.lex_state = 0, .external_lex_state = 4},
  [4241] = {.lex_state = 0, .external_lex_state = 4},
  [4242] = {.lex_state = 0, .external_lex_state = 4},
  [4243] = {.lex_state = 0, .external_lex_state = 4},
  [4244] = {.lex_state = 0, .external_lex_state = 4},
  [4245] = {.lex_state = 0, .external_lex_state = 4},
  [4246] = {.lex_state = 0, .external_lex_state = 4},
  [4247] = {.lex_state = 0, .external_lex_state = 4},
  [4248] = {.lex_state = 0, .external_lex_state = 4},
  [4249] = {.lex_state = 0, .external_lex_state = 4},
  [4250] = {.lex_state = 0, .external_lex_state = 4},
  [4251] = {.lex_state = 0, .external_lex_state = 4},
  [4252] = {.lex_state = 0, .external_lex_state = 4},
  [4253] = {.lex_state = 0, .external_lex_state = 4},
  [4254] = {.lex_state = 0, .external_lex_state = 4},
  [4255] = {.lex_state = 0, .external_lex_state = 4},
  [4256] = {.lex_state = 0, .external_lex_state = 4},
  [4257] = {.lex_state = 0, .external_lex_state = 4},
  [4258] = {.lex_state = 0, .external_lex_state = 4},
  [4259] = {.lex_state = 0, .external_lex_state = 4},
  [4260] = {.lex_state = 0, .external_lex_state = 4},
  [4261] = {.lex_state = 0, .external_lex_state = 4},
  [4262] = {.lex_state = 0, .external_lex_state = 4},
  [4263] = {.lex_state = 0, .external_lex_state = 4},
  [4264] = {.lex_state = 0, .external_lex_state = 4},
  [4265] = {.lex_state = 0, .external_lex_state = 4},
  [4266] = {.lex_state = 0, .external_lex_state = 4},
  [4267] = {.lex_state = 0, .external_lex_state = 4},
  [4268] = {.lex_state = 0, .external_lex_state = 4},
  [4269] = {.lex_state = 0, .external_lex_state = 4},
  [4270] = {.lex_state = 0, .external_lex_state = 4},
  [4271] = {.lex_state = 0, .external_lex_state = 4},
  [4272] = {.lex_state = 0, .external_lex_state = 4},
  [4273] = {.lex_state = 0, .external_lex_state = 4},
  [4274] = {.lex_state = 0, .external_lex_state = 4},
  [4275] = {.lex_state = 0, .external_lex_state = 4},
  [4276] = {.lex_state = 0, .external_lex_state = 4},
  [4277] = {.lex_state = 0, .external_lex_state = 4},
  [4278] = {.lex_state = 0, .external_lex_state = 4},
  [4279] = {.lex_state = 0, .external_lex_state = 4},
  [4280] = {.lex_state = 0, .external_lex_state = 4},
  [4281] = {.lex_state = 0, .external_lex_state = 4},
  [4282] = {.lex_state = 0, .external_lex_state = 4},
  [4283] = {.lex_state = 0, .external_lex_state = 4},
  [4284] = {.lex_state = 0, .external_lex_state = 4},
  [4285] = {.lex_state = 0, .external_lex_state = 4},
  [4286] = {.lex_state = 0, .external_lex_state = 4},
  [4287] = {.lex_state = 69, .external_lex_state = 4},
  [4288] = {.lex_state = 0, .external_lex_state = 4},
  [4289] = {.lex_state = 0, .external_lex_state = 4},
  [4290] = {.lex_state = 0, .external_lex_state = 4},
  [4291] = {.lex_state = 0, .external_lex_state = 4},
  [4292] = {.lex_state = 0, .external_lex_state = 4},
  [4293] = {.lex_state = 0, .external_lex_state = 4},
  [4294] = {.lex_state = 0, .external_lex_state = 4},
  [4295] = {.lex_state = 0, .external_lex_state = 4},
  [4296] = {.lex_state = 0, .external_lex_state = 4},
  [4297] = {.lex_state = 0, .external_lex_state = 4},
  [4298] = {.lex_state = 0, .external_lex_state = 4},
  [4299] = {.lex_state = 0, .external_lex_state = 4},
  [4300] = {.lex_state = 0, .external_lex_state = 4},
  [4301] = {.lex_state = 0, .external_lex_state = 4},
  [4302] = {.lex_state = 0, .external_lex_state = 4},
  [4303] = {.lex_state = 0, .external_lex_state = 4},
  [4304] = {.lex_state = 0, .external_lex_state = 4},
  [4305] = {.lex_state = 0, .external_lex_state = 4},
  [4306] = {.lex_state = 0, .external_lex_state = 4},
  [4307] = {.lex_state = 0, .external_lex_state = 4},
  [4308] = {.lex_state = 0, .external_lex_state = 4},
  [4309] = {.lex_state = 0, .external_lex_state = 4},
  [4310] = {.lex_state = 0, .external_lex_state = 4},
  [4311] = {.lex_state = 0, .external_lex_state = 3},
  [4312] = {.lex_state = 0, .external_lex_state = 4},
  [4313] = {.lex_state = 0, .external_lex_state = 4},
  [4314] = {.lex_state = 0, .external_lex_state = 4},
  [4315] = {.lex_state = 0, .external_lex_state = 4},
  [4316] = {.lex_state = 12, .external_lex_state = 4},
  [4317] = {.lex_state = 0, .external_lex_state = 4},
  [4318] = {.lex_state = 0, .external_lex_state = 4},
  [4319] = {.lex_state = 69, .external_lex_state = 4},
  [4320] = {.lex_state = 0, .external_lex_state = 4},
  [4321] = {.lex_state = 0, .external_lex_state = 4},
  [4322] = {.lex_state = 0, .external_lex_state = 4},
  [4323] = {.lex_state = 0, .external_lex_state = 4},
  [4324] = {.lex_state = 0, .external_lex_state = 3},
  [4325] = {.lex_state = 0, .external_lex_state = 4},
  [4326] = {.lex_state = 12, .external_lex_state = 4},
  [4327] = {.lex_state = 0, .external_lex_state = 4},
  [4328] = {.lex_state = 69, .external_lex_state = 4},
  [4329] = {.lex_state = 0, .external_lex_state = 4},
  [4330] = {.lex_state = 0, .external_lex_state = 4},
  [4331] = {.lex_state = 0, .external_lex_state = 4},
  [4332] = {.lex_state = 0, .external_lex_state = 4},
  [4333] = {.lex_state = 0, .external_lex_state = 4},
  [4334] = {.lex_state = 12, .external_lex_state = 4},
  [4335] = {.lex_state = 0, .external_lex_state = 4},
  [4336] = {.lex_state = 69, .external_lex_state = 4},
  [4337] = {.lex_state = 0, .external_lex_state = 4},
  [4338] = {.lex_state = 0, .external_lex_state = 4},
  [4339] = {.lex_state = 0, .external_lex_state = 4},
  [4340] = {.lex_state = 0, .external_lex_state = 4},
  [4341] = {.lex_state = 0, .external_lex_state = 4},
  [4342] = {.lex_state = 0, .external_lex_state = 4},
  [4343] = {.lex_state = 69, .external_lex_state = 4},
  [4344] = {.lex_state = 0, .external_lex_state = 4},
  [4345] = {.lex_state = 0, .external_lex_state = 4},
  [4346] = {.lex_state = 0, .external_lex_state = 4},
  [4347] = {.lex_state = 0, .external_lex_state = 4},
  [4348] = {.lex_state = 0, .external_lex_state = 4},
  [4349] = {.lex_state = 0, .external_lex_state = 4},
  [4350] = {.lex_state = 69, .external_lex_state = 4},
  [4351] = {.lex_state = 0, .external_lex_state = 4},
  [4352] = {.lex_state = 0, .external_lex_state = 4},
  [4353] = {.lex_state = 0, .external_lex_state = 4},
  [4354] = {.lex_state = 0, .external_lex_state = 4},
  [4355] = {.lex_state = 0, .external_lex_state = 4},
  [4356] = {.lex_state = 0, .external_lex_state = 4},
  [4357] = {.lex_state = 0, .external_lex_state = 4},
  [4358] = {.lex_state = 69, .external_lex_state = 4},
  [4359] = {.lex_state = 0, .external_lex_state = 4},
  [4360] = {.lex_state = 0, .external_lex_state = 4},
  [4361] = {.lex_state = 0, .external_lex_state = 4},
  [4362] = {.lex_state = 0, .external_lex_state = 4},
  [4363] = {.lex_state = 0, .external_lex_state = 4},
  [4364] = {.lex_state = 0, .external_lex_state = 4},
  [4365] = {.lex_state = 69, .external_lex_state = 4},
  [4366] = {.lex_state = 0, .external_lex_state = 4},
  [4367] = {.lex_state = 0, .external_lex_state = 4},
  [4368] = {.lex_state = 0, .external_lex_state = 4},
  [4369] = {.lex_state = 0, .external_lex_state = 4},
  [4370] = {.lex_state = 0, .external_lex_state = 4},
  [4371] = {.lex_state = 0, .external_lex_state = 4},
  [4372] = {.lex_state = 0, .external_lex_state = 4},
  [4373] = {.lex_state = 69, .external_lex_state = 4},
  [4374] = {.lex_state = 12, .external_lex_state = 4},
  [4375] = {.lex_state = 0, .external_lex_state = 4},
  [4376] = {.lex_state = 0, .external_lex_state = 4},
  [4377] = {.lex_state = 0, .external_lex_state = 4},
  [4378] = {.lex_state = 12, .external_lex_state = 4},
  [4379] = {.lex_state = 0, .external_lex_state = 4},
  [4380] = {.lex_state = 12, .external_lex_state = 4},
  [4381] = {.lex_state = 0, .external_lex_state = 4},
  [4382] = {.lex_state = 0, .external_lex_state = 4},
  [4383] = {.lex_state = 0, .external_lex_state = 4},
  [4384] = {.lex_state = 0, .external_lex_state = 4},
  [4385] = {.lex_state = 0, .external_lex_state = 4},
  [4386] = {.lex_state = 0, .external_lex_state = 4},
  [4387] = {.lex_state = 69, .external_lex_state = 4},
  [4388] = {.lex_state = 0, .external_lex_state = 4},
  [4389] = {.lex_state = 0, .external_lex_state = 4},
  [4390] = {.lex_state = 0, .external_lex_state = 4},
  [4391] = {.lex_state = 0, .external_lex_state = 4},
  [4392] = {.lex_state = 0, .external_lex_state = 4},
  [4393] = {.lex_state = 12, .external_lex_state = 4},
  [4394] = {.lex_state = 0, .external_lex_state = 4},
  [4395] = {.lex_state = 0, .external_lex_state = 4},
  [4396] = {.lex_state = 0, .external_lex_state = 4},
  [4397] = {.lex_state = 0, .external_lex_state = 4},
  [4398] = {.lex_state = 0, .external_lex_state = 4},
  [4399] = {.lex_state = 0, .external_lex_state = 3},
  [4400] = {.lex_state = 69, .external_lex_state = 4},
  [4401] = {.lex_state = 0, .external_lex_state = 4},
  [4402] = {.lex_state = 0, .external_lex_state = 4},
  [4403] = {.lex_state = 0, .external_lex_state = 4},
  [4404] = {.lex_state = 69, .external_lex_state = 4},
  [4405] = {.lex_state = 0, .external_lex_state = 4},
  [4406] = {.lex_state = 0, .external_lex_state = 4},
  [4407] = {.lex_state = 0, .external_lex_state = 4},
  [4408] = {.lex_state = 0, .external_lex_state = 4},
  [4409] = {.lex_state = 0, .external_lex_state = 4},
  [4410] = {.lex_state = 0, .external_lex_state = 4},
  [4411] = {.lex_state = 0, .external_lex_state = 4},
  [4412] = {.lex_state = 0, .external_lex_state = 4},
  [4413] = {.lex_state = 0, .external_lex_state = 4},
  [4414] = {.lex_state = 0, .external_lex_state = 4},
  [4415] = {.lex_state = 69, .external_lex_state = 4},
  [4416] = {.lex_state = 0, .external_lex_state = 4},
  [4417] = {.lex_state = 0, .external_lex_state = 4},
  [4418] = {.lex_state = 0, .external_lex_state = 4},
  [4419] = {.lex_state = 0, .external_lex_state = 4},
  [4420] = {.lex_state = 0, .external_lex_state = 4},
  [4421] = {.lex_state = 0, .external_lex_state = 4},
  [4422] = {.lex_state = 0, .external_lex_state = 4},
  [4423] = {.lex_state = 0, .external_lex_state = 4},
  [4424] = {.lex_state = 0, .external_lex_state = 4},
  [4425] = {.lex_state = 0, .external_lex_state = 4},
  [4426] = {.lex_state = 0, .external_lex_state = 4},
  [4427] = {.lex_state = 0, .external_lex_state = 4},
  [4428] = {.lex_state = 0, .external_lex_state = 4},
  [4429] = {.lex_state = 69, .external_lex_state = 4},
  [4430] = {.lex_state = 0, .external_lex_state = 4},
  [4431] = {.lex_state = 0, .external_lex_state = 4},
  [4432] = {.lex_state = 0, .external_lex_state = 4},
  [4433] = {.lex_state = 0, .external_lex_state = 3},
  [4434] = {.lex_state = 0, .external_lex_state = 4},
  [4435] = {.lex_state = 0, .external_lex_state = 4},
  [4436] = {.lex_state = 0, .external_lex_state = 4},
  [4437] = {.lex_state = 12, .external_lex_state = 4},
  [4438] = {.lex_state = 0, .external_lex_state = 4},
  [4439] = {.lex_state = 0, .external_lex_state = 4},
  [4440] = {.lex_state = 0, .external_lex_state = 4},
  [4441] = {.lex_state = 0, .external_lex_state = 3},
  [4442] = {.lex_state = 0, .external_lex_state = 4},
  [4443] = {.lex_state = 12, .external_lex_state = 4},
  [4444] = {.lex_state = 0, .external_lex_state = 4},
  [4445] = {.lex_state = 12, .external_lex_state = 4},
  [4446] = {.lex_state = 0, .external_lex_state = 4},
  [4447] = {.lex_state = 69, .external_lex_state = 4},
  [4448] = {.lex_state = 0, .external_lex_state = 4},
  [4449] = {.lex_state = 0, .external_lex_state = 4},
  [4450] = {.lex_state = 0, .external_lex_state = 4},
  [4451] = {.lex_state = 0, .external_lex_state = 4},
  [4452] = {.lex_state = 0, .external_lex_state = 4},
  [4453] = {.lex_state = 0, .external_lex_state = 4},
  [4454] = {.lex_state = 0, .external_lex_state = 4},
  [4455] = {.lex_state = 0, .external_lex_state = 4},
  [4456] = {.lex_state = 0, .external_lex_state = 4},
  [4457] = {.lex_state = 69, .external_lex_state = 4},
  [4458] = {.lex_state = 0, .external_lex_state = 4},
  [4459] = {.lex_state = 0, .external_lex_state = 4},
  [4460] = {.lex_state = 0, .external_lex_state = 4},
  [4461] = {.lex_state = 0, .external_lex_state = 4},
  [4462] = {.lex_state = 0, .external_lex_state = 4},
  [4463] = {.lex_state = 12, .external_lex_state = 4},
  [4464] = {.lex_state = 0, .external_lex_state = 4},
  [4465] = {.lex_state = 0, .external_lex_state = 4},
  [4466] = {.lex_state = 0, .external_lex_state = 4},
  [4467] = {.lex_state = 0, .external_lex_state = 4},
  [4468] = {.lex_state = 12, .external_lex_state = 4},
  [4469] = {.lex_state = 0, .external_lex_state = 4},
  [4470] = {.lex_state = 69, .external_lex_state = 4},
  [4471] = {.lex_state = 0, .external_lex_state = 4},
  [4472] = {.lex_state = 0, .external_lex_state = 4},
  [4473] = {.lex_state = 0, .external_lex_state = 4},
  [4474] = {.lex_state = 0, .external_lex_state = 4},
  [4475] = {.lex_state = 12, .external_lex_state = 4},
  [4476] = {.lex_state = 0, .external_lex_state = 4},
  [4477] = {.lex_state = 0, .external_lex_state = 4},
  [4478] = {.lex_state = 0, .external_lex_state = 4},
  [4479] = {.lex_state = 0, .external_lex_state = 4},
  [4480] = {.lex_state = 0, .external_lex_state = 3},
  [4481] = {.lex_state = 12, .external_lex_state = 4},
  [4482] = {.lex_state = 0, .external_lex_state = 4},
  [4483] = {.lex_state = 0, .external_lex_state = 3},
  [4484] = {.lex_state = 0, .external_lex_state = 4},
  [4485] = {.lex_state = 12, .external_lex_state = 4},
  [4486] = {.lex_state = 0, .external_lex_state = 4},
  [4487] = {.lex_state = 12, .external_lex_state = 4},
  [4488] = {.lex_state = 0, .external_lex_state = 4},
  [4489] = {.lex_state = 0, .external_lex_state = 4},
  [4490] = {.lex_state = 69, .external_lex_state = 4},
  [4491] = {.lex_state = 12, .external_lex_state = 4},
  [4492] = {.lex_state = 0, .external_lex_state = 3},
  [4493] = {.lex_state = 0, .external_lex_state = 4},
  [4494] = {.lex_state = 0, .external_lex_state = 4},
  [4495] = {.lex_state = 0, .external_lex_state = 4},
  [4496] = {.lex_state = 0, .external_lex_state = 4},
  [4497] = {.lex_state = 0, .external_lex_state = 4},
  [4498] = {.lex_state = 0, .external_lex_state = 4},
  [4499] = {.lex_state = 0, .external_lex_state = 4},
  [4500] = {.lex_state = 0, .external_lex_state = 4},
  [4501] = {.lex_state = 12, .external_lex_state = 4},
  [4502] = {.lex_state = 0, .external_lex_state = 4},
  [4503] = {.lex_state = 0, .external_lex_state = 4},
  [4504] = {.lex_state = 0, .external_lex_state = 4},
  [4505] = {.lex_state = 12, .external_lex_state = 4},
  [4506] = {.lex_state = 12, .external_lex_state = 4},
  [4507] = {.lex_state = 0, .external_lex_state = 3},
  [4508] = {.lex_state = 0, .external_lex_state = 4},
  [4509] = {.lex_state = 0, .external_lex_state = 3},
  [4510] = {.lex_state = 0, .external_lex_state = 4},
  [4511] = {.lex_state = 0, .external_lex_state = 4},
  [4512] = {.lex_state = 0, .external_lex_state = 4},
  [4513] = {.lex_state = 0, .external_lex_state = 4},
  [4514] = {.lex_state = 0, .external_lex_state = 4},
  [4515] = {.lex_state = 69, .external_lex_state = 4},
  [4516] = {.lex_state = 0, .external_lex_state = 4},
  [4517] = {.lex_state = 0, .external_lex_state = 4},
  [4518] = {.lex_state = 0, .external_lex_state = 4},
  [4519] = {.lex_state = 0, .external_lex_state = 4},
  [4520] = {.lex_state = 0, .external_lex_state = 4},
  [4521] = {.lex_state = 0, .external_lex_state = 4},
  [4522] = {.lex_state = 0, .external_lex_state = 4},
  [4523] = {.lex_state = 0, .external_lex_state = 4},
  [4524] = {.lex_state = 0, .external_lex_state = 4},
  [4525] = {.lex_state = 12, .external_lex_state = 4},
  [4526] = {.lex_state = 0, .external_lex_state = 4},
  [4527] = {.lex_state = 12, .external_lex_state = 4},
  [4528] = {.lex_state = 0, .external_lex_state = 3},
  [4529] = {.lex_state = 0, .external_lex_state = 4},
  [4530] = {.lex_state = 0, .external_lex_state = 4},
  [4531] = {.lex_state = 0, .external_lex_state = 4},
  [4532] = {.lex_state = 0, .external_lex_state = 4},
  [4533] = {.lex_state = 0, .external_lex_state = 4},
  [4534] = {.lex_state = 0, .external_lex_state = 4},
  [4535] = {.lex_state = 0, .external_lex_state = 4},
  [4536] = {.lex_state = 0, .external_lex_state = 4},
  [4537] = {.lex_state = 0, .external_lex_state = 4},
  [4538] = {.lex_state = 0, .external_lex_state = 4},
  [4539] = {.lex_state = 0, .external_lex_state = 4},
  [4540] = {.lex_state = 0, .external_lex_state = 4},
  [4541] = {.lex_state = 53, .external_lex_state = 4},
  [4542] = {.lex_state = 0, .external_lex_state = 4},
  [4543] = {.lex_state = 0, .external_lex_state = 4},
  [4544] = {.lex_state = 0, .external_lex_state = 4},
  [4545] = {.lex_state = 0, .external_lex_state = 4},
  [4546] = {.lex_state = 0, .external_lex_state = 4},
  [4547] = {.lex_state = 0, .external_lex_state = 4},
  [4548] = {.lex_state = 0, .external_lex_state = 4},
  [4549] = {.lex_state = 0, .external_lex_state = 4},
  [4550] = {.lex_state = 0, .external_lex_state = 4},
  [4551] = {.lex_state = 0, .external_lex_state = 4},
  [4552] = {.lex_state = 0, .external_lex_state = 4},
  [4553] = {.lex_state = 0, .external_lex_state = 4},
  [4554] = {.lex_state = 0, .external_lex_state = 4},
  [4555] = {.lex_state = 53, .external_lex_state = 4},
  [4556] = {.lex_state = 0, .external_lex_state = 4},
  [4557] = {.lex_state = 0, .external_lex_state = 4},
  [4558] = {.lex_state = 0, .external_lex_state = 4},
  [4559] = {.lex_state = 0, .external_lex_state = 4},
  [4560] = {.lex_state = 0, .external_lex_state = 4},
  [4561] = {.lex_state = 0, .external_lex_state = 4},
  [4562] = {.lex_state = 0, .external_lex_state = 4},
  [4563] = {.lex_state = 0, .external_lex_state = 4},
  [4564] = {.lex_state = 0, .external_lex_state = 4},
  [4565] = {.lex_state = 0, .external_lex_state = 4},
  [4566] = {.lex_state = 0, .external_lex_state = 4},
  [4567] = {.lex_state = 0, .external_lex_state = 4},
  [4568] = {.lex_state = 0, .external_lex_state = 4},
  [4569] = {.lex_state = 0, .external_lex_state = 4},
  [4570] = {.lex_state = 0, .external_lex_state = 4},
  [4571] = {.lex_state = 126, .external_lex_state = 4},
  [4572] = {.lex_state = 0, .external_lex_state = 4},
  [4573] = {.lex_state = 0, .external_lex_state = 4},
  [4574] = {.lex_state = 0, .external_lex_state = 4},
  [4575] = {.lex_state = 0, .external_lex_state = 4},
  [4576] = {.lex_state = 0, .external_lex_state = 4},
  [4577] = {.lex_state = 0, .external_lex_state = 4},
  [4578] = {.lex_state = 0, .external_lex_state = 4},
  [4579] = {.lex_state = 0, .external_lex_state = 4},
  [4580] = {.lex_state = 0, .external_lex_state = 4},
  [4581] = {.lex_state = 0, .external_lex_state = 4},
  [4582] = {.lex_state = 0, .external_lex_state = 4},
  [4583] = {.lex_state = 0, .external_lex_state = 4},
  [4584] = {.lex_state = 0, .external_lex_state = 4},
  [4585] = {.lex_state = 0, .external_lex_state = 4},
  [4586] = {.lex_state = 0, .external_lex_state = 4},
  [4587] = {.lex_state = 0, .external_lex_state = 4},
  [4588] = {.lex_state = 0, .external_lex_state = 4},
  [4589] = {.lex_state = 0, .external_lex_state = 4},
  [4590] = {.lex_state = 0, .external_lex_state = 4},
  [4591] = {.lex_state = 0, .external_lex_state = 4},
  [4592] = {.lex_state = 0, .external_lex_state = 4},
  [4593] = {.lex_state = 0, .external_lex_state = 4},
  [4594] = {.lex_state = 0, .external_lex_state = 4},
  [4595] = {.lex_state = 0, .external_lex_state = 4},
  [4596] = {.lex_state = 0, .external_lex_state = 4},
  [4597] = {.lex_state = 0, .external_lex_state = 4},
  [4598] = {.lex_state = 0, .external_lex_state = 4},
  [4599] = {.lex_state = 0, .external_lex_state = 4},
  [4600] = {.lex_state = 0, .external_lex_state = 4},
  [4601] = {.lex_state = 0, .external_lex_state = 4},
  [4602] = {.lex_state = 0, .external_lex_state = 4},
  [4603] = {.lex_state = 0, .external_lex_state = 4},
  [4604] = {.lex_state = 0, .external_lex_state = 4},
  [4605] = {.lex_state = 0, .external_lex_state = 4},
  [4606] = {.lex_state = 0, .external_lex_state = 4},
  [4607] = {.lex_state = 0, .external_lex_state = 4},
  [4608] = {.lex_state = 0, .external_lex_state = 4},
  [4609] = {.lex_state = 0, .external_lex_state = 4},
  [4610] = {.lex_state = 0, .external_lex_state = 4},
  [4611] = {.lex_state = 0, .external_lex_state = 4},
  [4612] = {.lex_state = 0, .external_lex_state = 4},
  [4613] = {.lex_state = 0, .external_lex_state = 4},
  [4614] = {.lex_state = 0, .external_lex_state = 4},
  [4615] = {.lex_state = 0, .external_lex_state = 4},
  [4616] = {.lex_state = 0, .external_lex_state = 4},
  [4617] = {.lex_state = 0, .external_lex_state = 4},
  [4618] = {.lex_state = 0, .external_lex_state = 4},
  [4619] = {.lex_state = 0, .external_lex_state = 4},
  [4620] = {.lex_state = 0, .external_lex_state = 4},
  [4621] = {.lex_state = 0, .external_lex_state = 4},
  [4622] = {.lex_state = 0, .external_lex_state = 4},
  [4623] = {.lex_state = 0, .external_lex_state = 4},
  [4624] = {.lex_state = 0, .external_lex_state = 4},
  [4625] = {.lex_state = 0, .external_lex_state = 4},
  [4626] = {.lex_state = 0, .external_lex_state = 4},
  [4627] = {.lex_state = 0, .external_lex_state = 4},
  [4628] = {.lex_state = 0, .external_lex_state = 4},
  [4629] = {.lex_state = 0, .external_lex_state = 4},
  [4630] = {.lex_state = 0, .external_lex_state = 4},
  [4631] = {.lex_state = 0, .external_lex_state = 4},
  [4632] = {.lex_state = 0, .external_lex_state = 4},
  [4633] = {.lex_state = 0, .external_lex_state = 4},
  [4634] = {.lex_state = 0, .external_lex_state = 4},
  [4635] = {.lex_state = 0, .external_lex_state = 4},
  [4636] = {.lex_state = 0, .external_lex_state = 4},
  [4637] = {.lex_state = 0, .external_lex_state = 4},
  [4638] = {.lex_state = 0, .external_lex_state = 4},
  [4639] = {.lex_state = 0, .external_lex_state = 4},
  [4640] = {.lex_state = 0, .external_lex_state = 4},
  [4641] = {.lex_state = 0, .external_lex_state = 4},
  [4642] = {.lex_state = 0, .external_lex_state = 4},
  [4643] = {.lex_state = 0, .external_lex_state = 4},
  [4644] = {.lex_state = 0, .external_lex_state = 4},
  [4645] = {.lex_state = 0, .external_lex_state = 4},
  [4646] = {.lex_state = 0, .external_lex_state = 4},
  [4647] = {.lex_state = 0, .external_lex_state = 4},
  [4648] = {.lex_state = 0, .external_lex_state = 4},
  [4649] = {.lex_state = 0, .external_lex_state = 4},
  [4650] = {.lex_state = 0, .external_lex_state = 4},
  [4651] = {.lex_state = 0, .external_lex_state = 4},
  [4652] = {.lex_state = 0, .external_lex_state = 4},
  [4653] = {.lex_state = 0, .external_lex_state = 4},
  [4654] = {.lex_state = 0, .external_lex_state = 4},
  [4655] = {.lex_state = 0, .external_lex_state = 4},
  [4656] = {.lex_state = 0, .external_lex_state = 4},
  [4657] = {.lex_state = 0, .external_lex_state = 4},
  [4658] = {.lex_state = 0, .external_lex_state = 4},
  [4659] = {.lex_state = 0, .external_lex_state = 4},
  [4660] = {.lex_state = 0, .external_lex_state = 4},
  [4661] = {.lex_state = 0, .external_lex_state = 4},
  [4662] = {.lex_state = 0, .external_lex_state = 4},
  [4663] = {.lex_state = 0, .external_lex_state = 4},
  [4664] = {.lex_state = 0, .external_lex_state = 4},
  [4665] = {.lex_state = 0, .external_lex_state = 4},
  [4666] = {.lex_state = 53, .external_lex_state = 4},
  [4667] = {.lex_state = 0, .external_lex_state = 4},
  [4668] = {.lex_state = 0, .external_lex_state = 4},
  [4669] = {.lex_state = 53, .external_lex_state = 4},
  [4670] = {.lex_state = 0, .external_lex_state = 4},
  [4671] = {.lex_state = 0, .external_lex_state = 4},
  [4672] = {.lex_state = 0, .external_lex_state = 4},
  [4673] = {.lex_state = 0, .external_lex_state = 4},
  [4674] = {.lex_state = 0, .external_lex_state = 4},
  [4675] = {.lex_state = 0, .external_lex_state = 4},
  [4676] = {.lex_state = 0, .external_lex_state = 4},
  [4677] = {.lex_state = 0, .external_lex_state = 4},
  [4678] = {.lex_state = 0, .external_lex_state = 4},
  [4679] = {.lex_state = 0, .external_lex_state = 4},
  [4680] = {.lex_state = 0, .external_lex_state = 4},
  [4681] = {.lex_state = 0, .external_lex_state = 4},
  [4682] = {.lex_state = 0, .external_lex_state = 4},
  [4683] = {.lex_state = 0, .external_lex_state = 4},
  [4684] = {.lex_state = 0, .external_lex_state = 4},
  [4685] = {.lex_state = 0, .external_lex_state = 4},
  [4686] = {.lex_state = 0, .external_lex_state = 4},
  [4687] = {.lex_state = 0, .external_lex_state = 4},
  [4688] = {.lex_state = 0, .external_lex_state = 4},
  [4689] = {.lex_state = 0, .external_lex_state = 4},
  [4690] = {.lex_state = 0, .external_lex_state = 4},
  [4691] = {.lex_state = 0, .external_lex_state = 4},
  [4692] = {.lex_state = 0, .external_lex_state = 4},
  [4693] = {.lex_state = 0, .external_lex_state = 4},
  [4694] = {.lex_state = 0, .external_lex_state = 4},
  [4695] = {.lex_state = 0, .external_lex_state = 4},
  [4696] = {.lex_state = 0, .external_lex_state = 4},
  [4697] = {.lex_state = 0, .external_lex_state = 4},
  [4698] = {.lex_state = 0, .external_lex_state = 4},
  [4699] = {.lex_state = 0, .external_lex_state = 4},
  [4700] = {.lex_state = 0, .external_lex_state = 4},
  [4701] = {.lex_state = 0, .external_lex_state = 4},
  [4702] = {.lex_state = 0, .external_lex_state = 4},
  [4703] = {.lex_state = 0, .external_lex_state = 4},
  [4704] = {.lex_state = 0, .external_lex_state = 4},
  [4705] = {.lex_state = 0, .external_lex_state = 4},
  [4706] = {.lex_state = 0, .external_lex_state = 4},
  [4707] = {.lex_state = 0, .external_lex_state = 4},
  [4708] = {.lex_state = 0, .external_lex_state = 4},
  [4709] = {.lex_state = 0, .external_lex_state = 4},
  [4710] = {.lex_state = 0, .external_lex_state = 4},
  [4711] = {.lex_state = 0, .external_lex_state = 4},
  [4712] = {.lex_state = 0, .external_lex_state = 4},
  [4713] = {.lex_state = 0, .external_lex_state = 4},
  [4714] = {.lex_state = 0, .external_lex_state = 4},
  [4715] = {.lex_state = 0, .external_lex_state = 4},
  [4716] = {.lex_state = 0, .external_lex_state = 4},
  [4717] = {.lex_state = 0, .external_lex_state = 4},
  [4718] = {.lex_state = 0, .external_lex_state = 4},
  [4719] = {.lex_state = 0, .external_lex_state = 4},
  [4720] = {.lex_state = 0, .external_lex_state = 4},
  [4721] = {.lex_state = 0, .external_lex_state = 4},
  [4722] = {.lex_state = 0, .external_lex_state = 4},
  [4723] = {.lex_state = 0, .external_lex_state = 4},
  [4724] = {.lex_state = 0, .external_lex_state = 4},
  [4725] = {.lex_state = 0, .external_lex_state = 4},
  [4726] = {.lex_state = 0, .external_lex_state = 4},
  [4727] = {.lex_state = 0, .external_lex_state = 4},
  [4728] = {.lex_state = 0, .external_lex_state = 4},
  [4729] = {.lex_state = 0, .external_lex_state = 4},
  [4730] = {.lex_state = 0, .external_lex_state = 4},
  [4731] = {.lex_state = 0, .external_lex_state = 4},
  [4732] = {.lex_state = 0, .external_lex_state = 4},
  [4733] = {.lex_state = 0, .external_lex_state = 4},
  [4734] = {.lex_state = 0, .external_lex_state = 4},
  [4735] = {.lex_state = 0, .external_lex_state = 4},
  [4736] = {.lex_state = 0, .external_lex_state = 4},
  [4737] = {.lex_state = 0, .external_lex_state = 4},
  [4738] = {.lex_state = 0, .external_lex_state = 4},
  [4739] = {.lex_state = 0, .external_lex_state = 4},
  [4740] = {.lex_state = 0, .external_lex_state = 4},
  [4741] = {.lex_state = 0, .external_lex_state = 4},
  [4742] = {.lex_state = 0, .external_lex_state = 4},
  [4743] = {.lex_state = 0, .external_lex_state = 4},
  [4744] = {.lex_state = 0, .external_lex_state = 4},
  [4745] = {.lex_state = 0, .external_lex_state = 4},
  [4746] = {.lex_state = 0, .external_lex_state = 4},
  [4747] = {.lex_state = 0, .external_lex_state = 4},
  [4748] = {.lex_state = 0, .external_lex_state = 4},
  [4749] = {.lex_state = 0, .external_lex_state = 4},
  [4750] = {.lex_state = 0, .external_lex_state = 4},
  [4751] = {.lex_state = 0, .external_lex_state = 4},
  [4752] = {.lex_state = 0, .external_lex_state = 4},
  [4753] = {.lex_state = 0, .external_lex_state = 4},
  [4754] = {.lex_state = 0, .external_lex_state = 4},
  [4755] = {.lex_state = 0, .external_lex_state = 4},
  [4756] = {.lex_state = 0, .external_lex_state = 4},
  [4757] = {.lex_state = 0, .external_lex_state = 4},
  [4758] = {.lex_state = 0, .external_lex_state = 4},
  [4759] = {.lex_state = 0, .external_lex_state = 4},
  [4760] = {.lex_state = 0, .external_lex_state = 4},
  [4761] = {.lex_state = 0, .external_lex_state = 4},
  [4762] = {.lex_state = 0, .external_lex_state = 4},
  [4763] = {.lex_state = 0, .external_lex_state = 4},
  [4764] = {.lex_state = 0, .external_lex_state = 4},
  [4765] = {.lex_state = 0, .external_lex_state = 4},
  [4766] = {.lex_state = 0, .external_lex_state = 4},
  [4767] = {.lex_state = 0, .external_lex_state = 4},
  [4768] = {.lex_state = 0, .external_lex_state = 4},
  [4769] = {.lex_state = 0, .external_lex_state = 4},
  [4770] = {.lex_state = 0, .external_lex_state = 4},
  [4771] = {.lex_state = 0, .external_lex_state = 4},
  [4772] = {.lex_state = 0, .external_lex_state = 4},
  [4773] = {.lex_state = 0, .external_lex_state = 4},
  [4774] = {.lex_state = 0, .external_lex_state = 4},
  [4775] = {.lex_state = 0, .external_lex_state = 4},
  [4776] = {.lex_state = 0, .external_lex_state = 4},
  [4777] = {.lex_state = 0, .external_lex_state = 4},
  [4778] = {.lex_state = 0, .external_lex_state = 4},
  [4779] = {.lex_state = 0, .external_lex_state = 4},
  [4780] = {.lex_state = 0, .external_lex_state = 4},
  [4781] = {.lex_state = 0, .external_lex_state = 4},
  [4782] = {.lex_state = 0, .external_lex_state = 4},
  [4783] = {.lex_state = 0, .external_lex_state = 4},
  [4784] = {.lex_state = 0, .external_lex_state = 4},
  [4785] = {.lex_state = 0, .external_lex_state = 4},
  [4786] = {.lex_state = 0, .external_lex_state = 4},
  [4787] = {.lex_state = 0, .external_lex_state = 4},
  [4788] = {.lex_state = 0, .external_lex_state = 4},
  [4789] = {.lex_state = 0, .external_lex_state = 4},
  [4790] = {.lex_state = 0, .external_lex_state = 4},
  [4791] = {.lex_state = 0, .external_lex_state = 4},
  [4792] = {.lex_state = 0, .external_lex_state = 4},
  [4793] = {.lex_state = 0, .external_lex_state = 4},
  [4794] = {.lex_state = 0, .external_lex_state = 4},
  [4795] = {.lex_state = 0, .external_lex_state = 4},
  [4796] = {.lex_state = 0, .external_lex_state = 4},
  [4797] = {.lex_state = 0, .external_lex_state = 4},
  [4798] = {.lex_state = 0, .external_lex_state = 4},
  [4799] = {.lex_state = 0, .external_lex_state = 4},
  [4800] = {.lex_state = 0, .external_lex_state = 4},
  [4801] = {.lex_state = 0, .external_lex_state = 4},
  [4802] = {.lex_state = 0, .external_lex_state = 4},
  [4803] = {.lex_state = 0, .external_lex_state = 4},
  [4804] = {.lex_state = 0, .external_lex_state = 4},
  [4805] = {.lex_state = 0, .external_lex_state = 4},
  [4806] = {.lex_state = 0, .external_lex_state = 4},
  [4807] = {.lex_state = 0, .external_lex_state = 4},
  [4808] = {.lex_state = 0, .external_lex_state = 4},
  [4809] = {.lex_state = 0, .external_lex_state = 4},
  [4810] = {.lex_state = 0, .external_lex_state = 4},
  [4811] = {.lex_state = 0, .external_lex_state = 4},
  [4812] = {.lex_state = 0, .external_lex_state = 4},
  [4813] = {.lex_state = 0, .external_lex_state = 4},
  [4814] = {.lex_state = 0, .external_lex_state = 4},
  [4815] = {.lex_state = 0, .external_lex_state = 4},
  [4816] = {.lex_state = 0, .external_lex_state = 4},
  [4817] = {.lex_state = 0, .external_lex_state = 4},
  [4818] = {.lex_state = 0, .external_lex_state = 4},
  [4819] = {.lex_state = 0, .external_lex_state = 4},
  [4820] = {.lex_state = 0, .external_lex_state = 4},
  [4821] = {.lex_state = 0, .external_lex_state = 4},
  [4822] = {.lex_state = 0, .external_lex_state = 4},
  [4823] = {.lex_state = 0, .external_lex_state = 4},
  [4824] = {.lex_state = 0, .external_lex_state = 4},
  [4825] = {.lex_state = 0, .external_lex_state = 4},
  [4826] = {.lex_state = 0, .external_lex_state = 4},
  [4827] = {.lex_state = 0, .external_lex_state = 4},
  [4828] = {.lex_state = 0, .external_lex_state = 4},
  [4829] = {.lex_state = 0, .external_lex_state = 4},
  [4830] = {.lex_state = 0, .external_lex_state = 4},
  [4831] = {.lex_state = 0, .external_lex_state = 4},
  [4832] = {.lex_state = 0, .external_lex_state = 4},
  [4833] = {.lex_state = 0, .external_lex_state = 4},
  [4834] = {.lex_state = 0, .external_lex_state = 4},
  [4835] = {.lex_state = 0, .external_lex_state = 4},
  [4836] = {.lex_state = 0, .external_lex_state = 4},
  [4837] = {.lex_state = 0, .external_lex_state = 4},
  [4838] = {.lex_state = 0, .external_lex_state = 4},
  [4839] = {.lex_state = 0, .external_lex_state = 4},
  [4840] = {.lex_state = 0, .external_lex_state = 4},
  [4841] = {.lex_state = 0, .external_lex_state = 4},
  [4842] = {.lex_state = 0, .external_lex_state = 4},
  [4843] = {.lex_state = 0, .external_lex_state = 4},
  [4844] = {.lex_state = 0, .external_lex_state = 4},
  [4845] = {.lex_state = 0, .external_lex_state = 4},
  [4846] = {.lex_state = 0, .external_lex_state = 4},
  [4847] = {.lex_state = 0, .external_lex_state = 4},
  [4848] = {.lex_state = 0, .external_lex_state = 4},
  [4849] = {.lex_state = 0, .external_lex_state = 4},
  [4850] = {.lex_state = 0, .external_lex_state = 4},
  [4851] = {.lex_state = 0, .external_lex_state = 4},
  [4852] = {.lex_state = 0, .external_lex_state = 4},
  [4853] = {.lex_state = 0, .external_lex_state = 4},
  [4854] = {.lex_state = 0, .external_lex_state = 4},
  [4855] = {.lex_state = 0, .external_lex_state = 4},
  [4856] = {.lex_state = 0, .external_lex_state = 4},
  [4857] = {.lex_state = 0, .external_lex_state = 4},
  [4858] = {.lex_state = 0, .external_lex_state = 4},
  [4859] = {.lex_state = 0, .external_lex_state = 4},
  [4860] = {.lex_state = 0, .external_lex_state = 4},
  [4861] = {.lex_state = 0, .external_lex_state = 4},
  [4862] = {.lex_state = 0, .external_lex_state = 4},
  [4863] = {.lex_state = 0, .external_lex_state = 4},
  [4864] = {.lex_state = 0, .external_lex_state = 4},
  [4865] = {.lex_state = 0, .external_lex_state = 4},
  [4866] = {.lex_state = 0, .external_lex_state = 4},
  [4867] = {.lex_state = 0, .external_lex_state = 4},
  [4868] = {.lex_state = 0, .external_lex_state = 4},
  [4869] = {.lex_state = 0, .external_lex_state = 4},
  [4870] = {.lex_state = 0, .external_lex_state = 4},
  [4871] = {.lex_state = 0, .external_lex_state = 4},
  [4872] = {.lex_state = 53, .external_lex_state = 4},
  [4873] = {.lex_state = 0, .external_lex_state = 4},
  [4874] = {.lex_state = 0, .external_lex_state = 4},
  [4875] = {.lex_state = 53, .external_lex_state = 4},
  [4876] = {.lex_state = 0, .external_lex_state = 4},
  [4877] = {.lex_state = 0, .external_lex_state = 4},
  [4878] = {.lex_state = 0, .external_lex_state = 4},
  [4879] = {.lex_state = 0, .external_lex_state = 4},
  [4880] = {.lex_state = 0, .external_lex_state = 4},
  [4881] = {.lex_state = 0, .external_lex_state = 4},
  [4882] = {.lex_state = 0, .external_lex_state = 4},
  [4883] = {.lex_state = 0, .external_lex_state = 4},
  [4884] = {.lex_state = 0, .external_lex_state = 4},
  [4885] = {.lex_state = 0, .external_lex_state = 4},
  [4886] = {.lex_state = 0, .external_lex_state = 4},
  [4887] = {.lex_state = 0, .external_lex_state = 4},
  [4888] = {.lex_state = 0, .external_lex_state = 4},
  [4889] = {.lex_state = 0, .external_lex_state = 4},
  [4890] = {.lex_state = 0, .external_lex_state = 4},
  [4891] = {.lex_state = 0, .external_lex_state = 4},
  [4892] = {.lex_state = 0, .external_lex_state = 4},
  [4893] = {.lex_state = 0, .external_lex_state = 4},
  [4894] = {.lex_state = 0, .external_lex_state = 4},
  [4895] = {.lex_state = 0, .external_lex_state = 4},
  [4896] = {.lex_state = 0, .external_lex_state = 4},
  [4897] = {.lex_state = 0, .external_lex_state = 4},
  [4898] = {.lex_state = 0, .external_lex_state = 4},
  [4899] = {.lex_state = 0, .external_lex_state = 4},
  [4900] = {.lex_state = 0, .external_lex_state = 4},
  [4901] = {.lex_state = 0, .external_lex_state = 4},
  [4902] = {.lex_state = 0, .external_lex_state = 4},
  [4903] = {.lex_state = 0, .external_lex_state = 4},
  [4904] = {.lex_state = 0, .external_lex_state = 4},
  [4905] = {.lex_state = 0, .external_lex_state = 4},
  [4906] = {.lex_state = 53, .external_lex_state = 4},
  [4907] = {.lex_state = 0, .external_lex_state = 4},
  [4908] = {.lex_state = 0, .external_lex_state = 4},
  [4909] = {.lex_state = 53, .external_lex_state = 4},
  [4910] = {.lex_state = 0, .external_lex_state = 4},
  [4911] = {.lex_state = 0, .external_lex_state = 4},
  [4912] = {.lex_state = 0, .external_lex_state = 4},
  [4913] = {.lex_state = 0, .external_lex_state = 4},
  [4914] = {.lex_state = 0, .external_lex_state = 4},
  [4915] = {.lex_state = 0, .external_lex_state = 4},
  [4916] = {.lex_state = 0, .external_lex_state = 4},
  [4917] = {.lex_state = 0, .external_lex_state = 4},
  [4918] = {.lex_state = 0, .external_lex_state = 4},
  [4919] = {.lex_state = 0, .external_lex_state = 4},
  [4920] = {.lex_state = 0, .external_lex_state = 4},
  [4921] = {.lex_state = 0, .external_lex_state = 4},
  [4922] = {.lex_state = 0, .external_lex_state = 4},
  [4923] = {.lex_state = 0, .external_lex_state = 4},
  [4924] = {.lex_state = 0, .external_lex_state = 4},
  [4925] = {.lex_state = 0, .external_lex_state = 4},
  [4926] = {.lex_state = 0, .external_lex_state = 4},
  [4927] = {.lex_state = 0, .external_lex_state = 4},
  [4928] = {.lex_state = 0, .external_lex_state = 4},
  [4929] = {.lex_state = 0, .external_lex_state = 4},
  [4930] = {.lex_state = 0, .external_lex_state = 4},
  [4931] = {.lex_state = 0, .external_lex_state = 4},
  [4932] = {.lex_state = 0, .external_lex_state = 4},
  [4933] = {.lex_state = 0, .external_lex_state = 4},
  [4934] = {.lex_state = 0, .external_lex_state = 4},
  [4935] = {.lex_state = 0, .external_lex_state = 4},
  [4936] = {.lex_state = 0, .external_lex_state = 4},
  [4937] = {.lex_state = 53, .external_lex_state = 4},
  [4938] = {.lex_state = 0, .external_lex_state = 4},
  [4939] = {.lex_state = 0, .external_lex_state = 4},
  [4940] = {.lex_state = 53, .external_lex_state = 4},
  [4941] = {.lex_state = 0, .external_lex_state = 4},
  [4942] = {.lex_state = 0, .external_lex_state = 4},
  [4943] = {.lex_state = 0, .external_lex_state = 4},
  [4944] = {.lex_state = 0, .external_lex_state = 4},
  [4945] = {.lex_state = 0, .external_lex_state = 4},
  [4946] = {.lex_state = 0, .external_lex_state = 4},
  [4947] = {.lex_state = 0, .external_lex_state = 4},
  [4948] = {.lex_state = 0, .external_lex_state = 4},
  [4949] = {.lex_state = 0, .external_lex_state = 4},
  [4950] = {.lex_state = 0, .external_lex_state = 4},
  [4951] = {.lex_state = 0, .external_lex_state = 4},
  [4952] = {.lex_state = 0, .external_lex_state = 4},
  [4953] = {.lex_state = 0, .external_lex_state = 4},
  [4954] = {.lex_state = 0, .external_lex_state = 4},
  [4955] = {.lex_state = 0, .external_lex_state = 4},
  [4956] = {.lex_state = 0, .external_lex_state = 4},
  [4957] = {.lex_state = 0, .external_lex_state = 4},
  [4958] = {.lex_state = 0, .external_lex_state = 4},
  [4959] = {.lex_state = 0, .external_lex_state = 4},
  [4960] = {.lex_state = 0, .external_lex_state = 4},
  [4961] = {.lex_state = 0, .external_lex_state = 4},
  [4962] = {.lex_state = 0, .external_lex_state = 4},
  [4963] = {.lex_state = 0, .external_lex_state = 4},
  [4964] = {.lex_state = 0, .external_lex_state = 4},
  [4965] = {.lex_state = 0, .external_lex_state = 4},
  [4966] = {.lex_state = 0, .external_lex_state = 4},
  [4967] = {.lex_state = 53, .external_lex_state = 4},
  [4968] = {.lex_state = 0, .external_lex_state = 4},
  [4969] = {.lex_state = 0, .external_lex_state = 4},
  [4970] = {.lex_state = 53, .external_lex_state = 4},
  [4971] = {.lex_state = 0, .external_lex_state = 4},
  [4972] = {.lex_state = 0, .external_lex_state = 4},
  [4973] = {.lex_state = 0, .external_lex_state = 4},
  [4974] = {.lex_state = 0, .external_lex_state = 4},
  [4975] = {.lex_state = 0, .external_lex_state = 4},
  [4976] = {.lex_state = 0, .external_lex_state = 4},
  [4977] = {.lex_state = 0, .external_lex_state = 4},
  [4978] = {.lex_state = 0, .external_lex_state = 4},
  [4979] = {.lex_state = 0, .external_lex_state = 4},
  [4980] = {.lex_state = 0, .external_lex_state = 4},
  [4981] = {.lex_state = 0, .external_lex_state = 4},
  [4982] = {.lex_state = 0, .external_lex_state = 4},
  [4983] = {.lex_state = 0, .external_lex_state = 4},
  [4984] = {.lex_state = 0, .external_lex_state = 4},
  [4985] = {.lex_state = 0, .external_lex_state = 4},
  [4986] = {.lex_state = 0, .external_lex_state = 4},
  [4987] = {.lex_state = 0, .external_lex_state = 4},
  [4988] = {.lex_state = 0, .external_lex_state = 4},
  [4989] = {.lex_state = 0, .external_lex_state = 4},
  [4990] = {.lex_state = 0, .external_lex_state = 4},
  [4991] = {.lex_state = 0, .external_lex_state = 4},
  [4992] = {.lex_state = 0, .external_lex_state = 4},
  [4993] = {.lex_state = 0, .external_lex_state = 4},
  [4994] = {.lex_state = 0, .external_lex_state = 4},
  [4995] = {.lex_state = 0, .external_lex_state = 4},
  [4996] = {.lex_state = 0, .external_lex_state = 4},
  [4997] = {.lex_state = 53, .external_lex_state = 4},
  [4998] = {.lex_state = 0, .external_lex_state = 4},
  [4999] = {.lex_state = 0, .external_lex_state = 4},
  [5000] = {.lex_state = 53, .external_lex_state = 4},
  [5001] = {.lex_state = 0, .external_lex_state = 4},
  [5002] = {.lex_state = 0, .external_lex_state = 4},
  [5003] = {.lex_state = 0, .external_lex_state = 4},
  [5004] = {.lex_state = 0, .external_lex_state = 4},
  [5005] = {.lex_state = 0, .external_lex_state = 4},
  [5006] = {.lex_state = 0, .external_lex_state = 4},
  [5007] = {.lex_state = 0, .external_lex_state = 4},
  [5008] = {.lex_state = 0, .external_lex_state = 4},
  [5009] = {.lex_state = 0, .external_lex_state = 4},
  [5010] = {.lex_state = 0, .external_lex_state = 4},
  [5011] = {.lex_state = 0, .external_lex_state = 4},
  [5012] = {.lex_state = 0, .external_lex_state = 4},
  [5013] = {.lex_state = 0, .external_lex_state = 4},
  [5014] = {.lex_state = 0, .external_lex_state = 4},
  [5015] = {.lex_state = 0, .external_lex_state = 4},
  [5016] = {.lex_state = 0, .external_lex_state = 4},
  [5017] = {.lex_state = 0, .external_lex_state = 4},
  [5018] = {.lex_state = 0, .external_lex_state = 4},
  [5019] = {.lex_state = 0, .external_lex_state = 4},
  [5020] = {.lex_state = 0, .external_lex_state = 4},
  [5021] = {.lex_state = 0, .external_lex_state = 4},
  [5022] = {.lex_state = 0, .external_lex_state = 4},
  [5023] = {.lex_state = 0, .external_lex_state = 4},
  [5024] = {.lex_state = 0, .external_lex_state = 4},
  [5025] = {.lex_state = 0, .external_lex_state = 4},
  [5026] = {.lex_state = 53, .external_lex_state = 4},
  [5027] = {.lex_state = 0, .external_lex_state = 4},
  [5028] = {.lex_state = 0, .external_lex_state = 4},
  [5029] = {.lex_state = 53, .external_lex_state = 4},
  [5030] = {.lex_state = 0, .external_lex_state = 4},
  [5031] = {.lex_state = 0, .external_lex_state = 4},
  [5032] = {.lex_state = 0, .external_lex_state = 4},
  [5033] = {.lex_state = 0, .external_lex_state = 4},
  [5034] = {.lex_state = 0, .external_lex_state = 4},
  [5035] = {.lex_state = 0, .external_lex_state = 4},
  [5036] = {.lex_state = 0, .external_lex_state = 4},
  [5037] = {.lex_state = 0, .external_lex_state = 4},
  [5038] = {.lex_state = 0, .external_lex_state = 4},
  [5039] = {.lex_state = 0, .external_lex_state = 4},
  [5040] = {.lex_state = 0, .external_lex_state = 4},
  [5041] = {.lex_state = 0, .external_lex_state = 4},
  [5042] = {.lex_state = 0, .external_lex_state = 4},
  [5043] = {.lex_state = 0, .external_lex_state = 4},
  [5044] = {.lex_state = 0, .external_lex_state = 4},
  [5045] = {.lex_state = 0, .external_lex_state = 4},
  [5046] = {.lex_state = 0, .external_lex_state = 4},
  [5047] = {.lex_state = 0, .external_lex_state = 4},
  [5048] = {.lex_state = 0, .external_lex_state = 4},
  [5049] = {.lex_state = 0, .external_lex_state = 4},
  [5050] = {.lex_state = 0, .external_lex_state = 4},
  [5051] = {.lex_state = 0, .external_lex_state = 4},
  [5052] = {.lex_state = 0, .external_lex_state = 4},
  [5053] = {.lex_state = 0, .external_lex_state = 4},
  [5054] = {.lex_state = 0, .external_lex_state = 4},
  [5055] = {.lex_state = 53, .external_lex_state = 4},
  [5056] = {.lex_state = 0, .external_lex_state = 4},
  [5057] = {.lex_state = 0, .external_lex_state = 4},
  [5058] = {.lex_state = 53, .external_lex_state = 4},
  [5059] = {.lex_state = 0, .external_lex_state = 4},
  [5060] = {.lex_state = 0, .external_lex_state = 4},
  [5061] = {.lex_state = 0, .external_lex_state = 4},
  [5062] = {.lex_state = 0, .external_lex_state = 4},
  [5063] = {.lex_state = 0, .external_lex_state = 4},
  [5064] = {.lex_state = 0, .external_lex_state = 4},
  [5065] = {.lex_state = 0, .external_lex_state = 4},
  [5066] = {.lex_state = 0, .external_lex_state = 4},
  [5067] = {.lex_state = 0, .external_lex_state = 4},
  [5068] = {.lex_state = 0, .external_lex_state = 4},
  [5069] = {.lex_state = 0, .external_lex_state = 4},
  [5070] = {.lex_state = 0, .external_lex_state = 4},
  [5071] = {.lex_state = 0, .external_lex_state = 4},
  [5072] = {.lex_state = 0, .external_lex_state = 4},
  [5073] = {.lex_state = 0, .external_lex_state = 4},
  [5074] = {.lex_state = 0, .external_lex_state = 4},
  [5075] = {.lex_state = 0, .external_lex_state = 4},
  [5076] = {.lex_state = 0, .external_lex_state = 4},
  [5077] = {.lex_state = 0, .external_lex_state = 4},
  [5078] = {.lex_state = 0, .external_lex_state = 4},
  [5079] = {.lex_state = 0, .external_lex_state = 4},
  [5080] = {.lex_state = 0, .external_lex_state = 4},
  [5081] = {.lex_state = 0, .external_lex_state = 4},
  [5082] = {.lex_state = 0, .external_lex_state = 4},
  [5083] = {.lex_state = 0, .external_lex_state = 4},
  [5084] = {.lex_state = 53, .external_lex_state = 4},
  [5085] = {.lex_state = 0, .external_lex_state = 4},
  [5086] = {.lex_state = 0, .external_lex_state = 4},
  [5087] = {.lex_state = 53, .external_lex_state = 4},
  [5088] = {.lex_state = 0, .external_lex_state = 4},
  [5089] = {.lex_state = 0, .external_lex_state = 4},
  [5090] = {.lex_state = 0, .external_lex_state = 4},
  [5091] = {.lex_state = 0, .external_lex_state = 4},
  [5092] = {.lex_state = 0, .external_lex_state = 4},
  [5093] = {.lex_state = 0, .external_lex_state = 4},
  [5094] = {.lex_state = 0, .external_lex_state = 4},
  [5095] = {.lex_state = 0, .external_lex_state = 4},
  [5096] = {.lex_state = 0, .external_lex_state = 4},
  [5097] = {.lex_state = 0, .external_lex_state = 4},
  [5098] = {.lex_state = 0, .external_lex_state = 4},
  [5099] = {.lex_state = 0, .external_lex_state = 4},
  [5100] = {.lex_state = 0, .external_lex_state = 4},
  [5101] = {.lex_state = 0, .external_lex_state = 4},
  [5102] = {.lex_state = 0, .external_lex_state = 4},
  [5103] = {.lex_state = 0, .external_lex_state = 4},
  [5104] = {.lex_state = 0, .external_lex_state = 4},
  [5105] = {.lex_state = 0, .external_lex_state = 4},
  [5106] = {.lex_state = 0, .external_lex_state = 4},
  [5107] = {.lex_state = 0, .external_lex_state = 4},
  [5108] = {.lex_state = 0, .external_lex_state = 4},
  [5109] = {.lex_state = 0, .external_lex_state = 4},
  [5110] = {.lex_state = 0, .external_lex_state = 4},
  [5111] = {.lex_state = 0, .external_lex_state = 4},
  [5112] = {.lex_state = 0, .external_lex_state = 4},
  [5113] = {.lex_state = 0, .external_lex_state = 4},
  [5114] = {.lex_state = 0, .external_lex_state = 4},
  [5115] = {.lex_state = 0, .external_lex_state = 4},
  [5116] = {.lex_state = 0, .external_lex_state = 4},
  [5117] = {.lex_state = 0, .external_lex_state = 4},
  [5118] = {.lex_state = 0, .external_lex_state = 4},
  [5119] = {.lex_state = 0, .external_lex_state = 4},
  [5120] = {.lex_state = 0, .external_lex_state = 4},
  [5121] = {.lex_state = 0, .external_lex_state = 4},
  [5122] = {.lex_state = 0, .external_lex_state = 4},
  [5123] = {.lex_state = 0, .external_lex_state = 4},
  [5124] = {.lex_state = 0, .external_lex_state = 4},
  [5125] = {.lex_state = 0, .external_lex_state = 4},
  [5126] = {.lex_state = 0, .external_lex_state = 4},
  [5127] = {.lex_state = 0, .external_lex_state = 4},
  [5128] = {.lex_state = 0, .external_lex_state = 4},
  [5129] = {.lex_state = 0, .external_lex_state = 4},
  [5130] = {.lex_state = 0, .external_lex_state = 4},
  [5131] = {.lex_state = 0, .external_lex_state = 4},
  [5132] = {.lex_state = 0, .external_lex_state = 4},
  [5133] = {.lex_state = 0, .external_lex_state = 4},
  [5134] = {.lex_state = 0, .external_lex_state = 4},
  [5135] = {.lex_state = 0, .external_lex_state = 4},
  [5136] = {.lex_state = 0, .external_lex_state = 4},
  [5137] = {.lex_state = 0, .external_lex_state = 4},
  [5138] = {.lex_state = 0, .external_lex_state = 4},
  [5139] = {.lex_state = 0, .external_lex_state = 4},
  [5140] = {.lex_state = 0, .external_lex_state = 4},
  [5141] = {.lex_state = 0, .external_lex_state = 4},
  [5142] = {.lex_state = 0, .external_lex_state = 4},
  [5143] = {.lex_state = 0, .external_lex_state = 4},
  [5144] = {.lex_state = 0, .external_lex_state = 4},
  [5145] = {.lex_state = 0, .external_lex_state = 4},
  [5146] = {.lex_state = 0, .external_lex_state = 4},
  [5147] = {.lex_state = 0, .external_lex_state = 4},
  [5148] = {.lex_state = 0, .external_lex_state = 4},
  [5149] = {.lex_state = 0, .external_lex_state = 4},
  [5150] = {.lex_state = 0, .external_lex_state = 4},
  [5151] = {.lex_state = 0, .external_lex_state = 4},
  [5152] = {.lex_state = 0, .external_lex_state = 4},
  [5153] = {.lex_state = 0, .external_lex_state = 4},
  [5154] = {.lex_state = 0, .external_lex_state = 4},
  [5155] = {.lex_state = 0, .external_lex_state = 4},
  [5156] = {.lex_state = 0, .external_lex_state = 4},
  [5157] = {.lex_state = 0, .external_lex_state = 4},
  [5158] = {.lex_state = 0, .external_lex_state = 4},
  [5159] = {.lex_state = 0, .external_lex_state = 4},
  [5160] = {.lex_state = 0, .external_lex_state = 4},
  [5161] = {.lex_state = 0, .external_lex_state = 4},
  [5162] = {.lex_state = 0, .external_lex_state = 4},
  [5163] = {.lex_state = 0, .external_lex_state = 4},
  [5164] = {.lex_state = 0, .external_lex_state = 4},
  [5165] = {.lex_state = 0, .external_lex_state = 4},
  [5166] = {.lex_state = 0, .external_lex_state = 4},
  [5167] = {.lex_state = 0, .external_lex_state = 4},
  [5168] = {.lex_state = 0, .external_lex_state = 4},
  [5169] = {.lex_state = 0, .external_lex_state = 4},
  [5170] = {.lex_state = 0, .external_lex_state = 4},
  [5171] = {.lex_state = 0, .external_lex_state = 4},
  [5172] = {.lex_state = 0, .external_lex_state = 4},
  [5173] = {.lex_state = 0, .external_lex_state = 4},
  [5174] = {.lex_state = 0, .external_lex_state = 4},
  [5175] = {.lex_state = 0, .external_lex_state = 4},
  [5176] = {.lex_state = 0, .external_lex_state = 4},
  [5177] = {.lex_state = 0, .external_lex_state = 4},
  [5178] = {.lex_state = 0, .external_lex_state = 4},
  [5179] = {.lex_state = 0, .external_lex_state = 4},
  [5180] = {.lex_state = 0, .external_lex_state = 4},
  [5181] = {.lex_state = 0, .external_lex_state = 4},
  [5182] = {.lex_state = 0, .external_lex_state = 4},
  [5183] = {.lex_state = 0, .external_lex_state = 4},
  [5184] = {.lex_state = 0, .external_lex_state = 4},
  [5185] = {.lex_state = 0, .external_lex_state = 4},
  [5186] = {.lex_state = 0, .external_lex_state = 4},
  [5187] = {.lex_state = 0, .external_lex_state = 4},
  [5188] = {.lex_state = 0, .external_lex_state = 4},
  [5189] = {.lex_state = 0, .external_lex_state = 4},
  [5190] = {.lex_state = 0, .external_lex_state = 4},
  [5191] = {.lex_state = 0, .external_lex_state = 4},
  [5192] = {.lex_state = 0, .external_lex_state = 4},
  [5193] = {.lex_state = 0, .external_lex_state = 4},
  [5194] = {.lex_state = 0, .external_lex_state = 4},
  [5195] = {.lex_state = 0, .external_lex_state = 4},
  [5196] = {.lex_state = 0, .external_lex_state = 4},
  [5197] = {.lex_state = 0, .external_lex_state = 4},
  [5198] = {.lex_state = 0, .external_lex_state = 4},
  [5199] = {.lex_state = 0, .external_lex_state = 4},
  [5200] = {.lex_state = 0, .external_lex_state = 4},
  [5201] = {.lex_state = 0, .external_lex_state = 4},
  [5202] = {.lex_state = 0, .external_lex_state = 4},
  [5203] = {.lex_state = 0, .external_lex_state = 4},
  [5204] = {.lex_state = 0, .external_lex_state = 4},
  [5205] = {.lex_state = 0, .external_lex_state = 4},
  [5206] = {.lex_state = 0, .external_lex_state = 4},
  [5207] = {.lex_state = 0, .external_lex_state = 4},
  [5208] = {.lex_state = 0, .external_lex_state = 4},
  [5209] = {.lex_state = 0, .external_lex_state = 4},
  [5210] = {.lex_state = 0, .external_lex_state = 4},
  [5211] = {.lex_state = 0, .external_lex_state = 4},
  [5212] = {.lex_state = 0, .external_lex_state = 4},
  [5213] = {.lex_state = 0, .external_lex_state = 4},
  [5214] = {.lex_state = 0, .external_lex_state = 4},
  [5215] = {.lex_state = 0, .external_lex_state = 4},
  [5216] = {.lex_state = 0, .external_lex_state = 4},
  [5217] = {.lex_state = 0, .external_lex_state = 4},
  [5218] = {.lex_state = 0, .external_lex_state = 4},
  [5219] = {.lex_state = 0, .external_lex_state = 4},
  [5220] = {.lex_state = 0, .external_lex_state = 4},
  [5221] = {.lex_state = 0, .external_lex_state = 4},
  [5222] = {.lex_state = 0, .external_lex_state = 4},
  [5223] = {.lex_state = 0, .external_lex_state = 4},
  [5224] = {.lex_state = 0, .external_lex_state = 4},
  [5225] = {.lex_state = 0, .external_lex_state = 4},
  [5226] = {.lex_state = 0, .external_lex_state = 4},
  [5227] = {.lex_state = 0, .external_lex_state = 4},
  [5228] = {.lex_state = 0, .external_lex_state = 4},
  [5229] = {.lex_state = 0, .external_lex_state = 4},
  [5230] = {.lex_state = 0, .external_lex_state = 4},
  [5231] = {.lex_state = 0, .external_lex_state = 4},
  [5232] = {.lex_state = 0, .external_lex_state = 4},
  [5233] = {.lex_state = 0, .external_lex_state = 4},
  [5234] = {.lex_state = 0, .external_lex_state = 4},
  [5235] = {.lex_state = 0, .external_lex_state = 4},
  [5236] = {.lex_state = 0, .external_lex_state = 4},
};

enum {
  ts_external_token_block_comment = 0,
  ts_external_token_triple_string = 1,
  ts_external_token__immediate_paren = 2,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_block_comment] = sym_block_comment,
  [ts_external_token_triple_string] = sym_triple_string,
  [ts_external_token__immediate_paren] = sym__immediate_paren,
};

static bool ts_external_scanner_states[5][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_triple_string] = true,
    [ts_external_token__immediate_paren] = true,
  },
  [2] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_triple_string] = true,
  },
  [3] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__immediate_paren] = true,
  },
  [4] = {
    [ts_external_token_block_comment] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_primitive] = ACTIONS(1),
    [aux_sym_primitive_definition_token1] = ACTIONS(1),
    [anon_sym_mutable] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_macro] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LT_COLON] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [sym_continue_statement] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_quote] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_COLON2] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_begin] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_GT_COLON] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_] = ACTIONS(1),
    [anon_sym_2] = ACTIONS(1),
    [anon_sym_3] = ACTIONS(1),
    [anon_sym_4] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DOT_SQUOTE] = ACTIONS(1),
    [anon_sym_LT_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_isa] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_LBRACK2] = ACTIONS(1),
    [anon_sym_5] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [sym_command_string] = ACTIONS(1),
    [sym_character] = ACTIONS(1),
    [sym__power_operator] = ACTIONS(1),
    [sym__times_operator] = ACTIONS(1),
    [sym__plus_operator] = ACTIONS(1),
    [sym__arrow_operator] = ACTIONS(1),
    [sym__comparison_operator] = ACTIONS(1),
    [sym__assign_operator] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(1),
    [sym__immediate_paren] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(5065),
    [sym__expression_list] = STATE(5057),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5050),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(3111),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3415),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3521),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(40),
    [sym_string] = STATE(2565),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(35),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(39),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(47),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_BANG] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(53),
    [anon_sym_] = ACTIONS(53),
    [anon_sym_2] = ACTIONS(53),
    [anon_sym_3] = ACTIONS(53),
    [anon_sym_4] = ACTIONS(53),
    [anon_sym_LBRACK2] = ACTIONS(55),
    [anon_sym_DOLLAR] = ACTIONS(57),
    [anon_sym_AT] = ACTIONS(59),
    [sym_number] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [sym_command_string] = ACTIONS(65),
    [sym_character] = ACTIONS(65),
    [sym__power_operator] = ACTIONS(67),
    [sym__times_operator] = ACTIONS(67),
    [sym__plus_operator] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [2] = {
    [sym__expression_list] = STATE(4320),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_type_argument_list] = STATE(2564),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(73),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(79),
    [anon_sym_EQ] = ACTIONS(77),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(77),
    [anon_sym_COLON_COLON] = ACTIONS(77),
    [anon_sym_LBRACE] = ACTIONS(81),
    [anon_sym_LT_COLON] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_finally] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_DOT] = ACTIONS(77),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [anon_sym_DOT_SQUOTE] = ACTIONS(77),
    [anon_sym_LT_PIPE] = ACTIONS(77),
    [anon_sym_PIPE_GT] = ACTIONS(77),
    [anon_sym_in] = ACTIONS(77),
    [anon_sym_isa] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(77),
    [anon_sym_AMP_AMP] = ACTIONS(77),
    [anon_sym_QMARK] = ACTIONS(77),
    [anon_sym_EQ_GT] = ACTIONS(77),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DASH_GT] = ACTIONS(97),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [anon_sym_DQUOTE2] = ACTIONS(107),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(69),
    [sym__plus_operator] = ACTIONS(69),
    [sym__arrow_operator] = ACTIONS(77),
    [sym__comparison_operator] = ACTIONS(77),
    [sym__assign_operator] = ACTIONS(77),
    [anon_sym_LF] = ACTIONS(111),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
    [sym__immediate_paren] = ACTIONS(91),
  },
  [3] = {
    [sym_function_definition] = STATE(1299),
    [sym_abstract_definition] = STATE(1299),
    [sym_primitive_definition] = STATE(1299),
    [sym_struct_definition] = STATE(1299),
    [sym_module_definition] = STATE(1299),
    [sym_macro_definition] = STATE(1299),
    [sym_parameter_list] = STATE(4829),
    [sym_if_statement] = STATE(1299),
    [sym_try_statement] = STATE(1299),
    [sym_for_statement] = STATE(1299),
    [sym_while_statement] = STATE(1299),
    [sym_return_statement] = STATE(1299),
    [sym_let_statement] = STATE(1299),
    [sym_const_statement] = STATE(1299),
    [sym_quote_statement] = STATE(1299),
    [sym_import_statement] = STATE(1299),
    [sym_export_statement] = STATE(1299),
    [sym__expression] = STATE(1251),
    [sym__primary_expression] = STATE(1067),
    [sym_operator] = STATE(1067),
    [sym_parenthesized_expression] = STATE(1067),
    [sym_field_expression] = STATE(1038),
    [sym_subscript_expression] = STATE(1067),
    [sym_typed_expression] = STATE(1299),
    [sym_parameterized_identifier] = STATE(1067),
    [sym_compound_expression] = STATE(1299),
    [sym_call_expression] = STATE(1067),
    [sym_broadcast_call_expression] = STATE(1067),
    [sym_macro_expression] = STATE(1299),
    [sym_macro_argument_list] = STATE(1223),
    [sym_spread_expression] = STATE(1299),
    [sym_unary_expression] = STATE(1299),
    [sym_binary_expression] = STATE(1299),
    [sym_ternary_expression] = STATE(1299),
    [sym_pair_expression] = STATE(1299),
    [sym_tuple_expression] = STATE(1067),
    [sym_array_expression] = STATE(1067),
    [sym_matrix_expression] = STATE(1067),
    [sym_generator_expression] = STATE(1299),
    [sym_array_comprehension_expression] = STATE(1067),
    [sym_function_expression] = STATE(1299),
    [sym_range_expression] = STATE(1299),
    [sym_coefficient_expression] = STATE(1299),
    [sym_quote_expression] = STATE(1299),
    [sym_interpolation_expression] = STATE(1299),
    [sym_macro_identifier] = STATE(3),
    [sym_string] = STATE(1067),
    [aux_sym_macro_argument_list_repeat1] = STATE(8),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_function] = ACTIONS(117),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_abstract] = ACTIONS(121),
    [anon_sym_primitive] = ACTIONS(123),
    [anon_sym_mutable] = ACTIONS(125),
    [anon_sym_struct] = ACTIONS(127),
    [anon_sym_module] = ACTIONS(129),
    [anon_sym_macro] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_COMMA] = ACTIONS(119),
    [anon_sym_RPAREN] = ACTIONS(119),
    [anon_sym_SEMI] = ACTIONS(119),
    [anon_sym_EQ] = ACTIONS(119),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(119),
    [anon_sym_COLON_COLON] = ACTIONS(119),
    [anon_sym_LT_COLON] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_elseif] = ACTIONS(119),
    [anon_sym_else] = ACTIONS(119),
    [anon_sym_try] = ACTIONS(137),
    [anon_sym_catch] = ACTIONS(119),
    [anon_sym_finally] = ACTIONS(119),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [sym_break_statement] = ACTIONS(143),
    [sym_continue_statement] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(147),
    [anon_sym_const] = ACTIONS(149),
    [anon_sym_quote] = ACTIONS(151),
    [anon_sym_using] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(153),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_COLON2] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_begin] = ACTIONS(161),
    [anon_sym_GT_COLON] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_] = ACTIONS(163),
    [anon_sym_2] = ACTIONS(163),
    [anon_sym_3] = ACTIONS(163),
    [anon_sym_4] = ACTIONS(163),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(119),
    [anon_sym_LT_PIPE] = ACTIONS(119),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(119),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(119),
    [anon_sym_LBRACK2] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(167),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_command_string] = ACTIONS(173),
    [sym_character] = ACTIONS(173),
    [sym__power_operator] = ACTIONS(175),
    [sym__times_operator] = ACTIONS(175),
    [sym__plus_operator] = ACTIONS(175),
    [sym__arrow_operator] = ACTIONS(119),
    [sym__comparison_operator] = ACTIONS(119),
    [sym__assign_operator] = ACTIONS(119),
    [anon_sym_LF] = ACTIONS(177),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(179),
    [sym__immediate_paren] = ACTIONS(181),
  },
  [4] = {
    [sym_function_definition] = STATE(1299),
    [sym_abstract_definition] = STATE(1299),
    [sym_primitive_definition] = STATE(1299),
    [sym_struct_definition] = STATE(1299),
    [sym_module_definition] = STATE(1299),
    [sym_macro_definition] = STATE(1299),
    [sym_parameter_list] = STATE(4829),
    [sym_if_statement] = STATE(1299),
    [sym_try_statement] = STATE(1299),
    [sym_for_statement] = STATE(1299),
    [sym_while_statement] = STATE(1299),
    [sym_return_statement] = STATE(1299),
    [sym_let_statement] = STATE(1299),
    [sym_const_statement] = STATE(1299),
    [sym_quote_statement] = STATE(1299),
    [sym_import_statement] = STATE(1299),
    [sym_export_statement] = STATE(1299),
    [sym__expression] = STATE(1251),
    [sym__primary_expression] = STATE(1067),
    [sym_operator] = STATE(1067),
    [sym_parenthesized_expression] = STATE(1067),
    [sym_field_expression] = STATE(1038),
    [sym_subscript_expression] = STATE(1067),
    [sym_typed_expression] = STATE(1299),
    [sym_parameterized_identifier] = STATE(1067),
    [sym_compound_expression] = STATE(1299),
    [sym_call_expression] = STATE(1067),
    [sym_broadcast_call_expression] = STATE(1067),
    [sym_macro_expression] = STATE(1299),
    [sym_macro_argument_list] = STATE(2716),
    [sym_spread_expression] = STATE(1299),
    [sym_unary_expression] = STATE(1299),
    [sym_binary_expression] = STATE(1299),
    [sym_ternary_expression] = STATE(1299),
    [sym_pair_expression] = STATE(1299),
    [sym_tuple_expression] = STATE(1067),
    [sym_array_expression] = STATE(1067),
    [sym_matrix_expression] = STATE(1067),
    [sym_generator_expression] = STATE(1299),
    [sym_array_comprehension_expression] = STATE(1067),
    [sym_function_expression] = STATE(1299),
    [sym_range_expression] = STATE(1299),
    [sym_coefficient_expression] = STATE(1299),
    [sym_quote_expression] = STATE(1299),
    [sym_interpolation_expression] = STATE(1299),
    [sym_macro_identifier] = STATE(3),
    [sym_string] = STATE(1067),
    [aux_sym_macro_argument_list_repeat1] = STATE(8),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_function] = ACTIONS(117),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_abstract] = ACTIONS(121),
    [anon_sym_primitive] = ACTIONS(123),
    [anon_sym_mutable] = ACTIONS(125),
    [anon_sym_struct] = ACTIONS(127),
    [anon_sym_module] = ACTIONS(129),
    [anon_sym_macro] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_COMMA] = ACTIONS(119),
    [anon_sym_RPAREN] = ACTIONS(119),
    [anon_sym_SEMI] = ACTIONS(119),
    [anon_sym_EQ] = ACTIONS(119),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(119),
    [anon_sym_COLON_COLON] = ACTIONS(119),
    [anon_sym_LT_COLON] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_elseif] = ACTIONS(119),
    [anon_sym_else] = ACTIONS(119),
    [anon_sym_try] = ACTIONS(137),
    [anon_sym_catch] = ACTIONS(119),
    [anon_sym_finally] = ACTIONS(119),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [sym_break_statement] = ACTIONS(143),
    [sym_continue_statement] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(147),
    [anon_sym_const] = ACTIONS(149),
    [anon_sym_quote] = ACTIONS(151),
    [anon_sym_using] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(153),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_COLON2] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_begin] = ACTIONS(161),
    [anon_sym_GT_COLON] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_] = ACTIONS(163),
    [anon_sym_2] = ACTIONS(163),
    [anon_sym_3] = ACTIONS(163),
    [anon_sym_4] = ACTIONS(163),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(119),
    [anon_sym_LT_PIPE] = ACTIONS(119),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(119),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(119),
    [anon_sym_LBRACK2] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(167),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_command_string] = ACTIONS(173),
    [sym_character] = ACTIONS(173),
    [sym__power_operator] = ACTIONS(175),
    [sym__times_operator] = ACTIONS(175),
    [sym__plus_operator] = ACTIONS(175),
    [sym__arrow_operator] = ACTIONS(119),
    [sym__comparison_operator] = ACTIONS(119),
    [sym__assign_operator] = ACTIONS(119),
    [anon_sym_LF] = ACTIONS(177),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(179),
    [sym__immediate_paren] = ACTIONS(183),
  },
  [5] = {
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2755),
    [sym__primary_expression] = STATE(2565),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_RPAREN] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(185),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [anon_sym_LT_COLON] = ACTIONS(185),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(185),
    [anon_sym_else] = ACTIONS(185),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_catch] = ACTIONS(185),
    [anon_sym_finally] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(185),
    [anon_sym_EQ_GT] = ACTIONS(185),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(69),
    [sym__plus_operator] = ACTIONS(69),
    [sym__arrow_operator] = ACTIONS(185),
    [sym__comparison_operator] = ACTIONS(185),
    [sym__assign_operator] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(187),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [6] = {
    [sym_function_definition] = STATE(1299),
    [sym_abstract_definition] = STATE(1299),
    [sym_primitive_definition] = STATE(1299),
    [sym_struct_definition] = STATE(1299),
    [sym_module_definition] = STATE(1299),
    [sym_macro_definition] = STATE(1299),
    [sym_parameter_list] = STATE(4829),
    [sym_if_statement] = STATE(1299),
    [sym_try_statement] = STATE(1299),
    [sym_for_statement] = STATE(1299),
    [sym_while_statement] = STATE(1299),
    [sym_return_statement] = STATE(1299),
    [sym_let_statement] = STATE(1299),
    [sym_const_statement] = STATE(1299),
    [sym_quote_statement] = STATE(1299),
    [sym_import_statement] = STATE(1299),
    [sym_export_statement] = STATE(1299),
    [sym__expression] = STATE(1287),
    [sym__primary_expression] = STATE(1067),
    [sym_operator] = STATE(1067),
    [sym_parenthesized_expression] = STATE(1067),
    [sym_field_expression] = STATE(1038),
    [sym_subscript_expression] = STATE(1067),
    [sym_typed_expression] = STATE(1299),
    [sym_parameterized_identifier] = STATE(1067),
    [sym_compound_expression] = STATE(1299),
    [sym_call_expression] = STATE(1067),
    [sym_broadcast_call_expression] = STATE(1067),
    [sym_macro_expression] = STATE(1299),
    [sym_spread_expression] = STATE(1299),
    [sym_unary_expression] = STATE(1299),
    [sym_binary_expression] = STATE(1299),
    [sym_ternary_expression] = STATE(1299),
    [sym_pair_expression] = STATE(1299),
    [sym_tuple_expression] = STATE(1067),
    [sym_array_expression] = STATE(1067),
    [sym_matrix_expression] = STATE(1067),
    [sym_generator_expression] = STATE(1299),
    [sym_array_comprehension_expression] = STATE(1067),
    [sym_function_expression] = STATE(1299),
    [sym_range_expression] = STATE(1299),
    [sym_coefficient_expression] = STATE(1299),
    [sym_quote_expression] = STATE(1299),
    [sym_interpolation_expression] = STATE(1299),
    [sym_macro_identifier] = STATE(3),
    [sym_string] = STATE(1067),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_function] = ACTIONS(117),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(121),
    [anon_sym_primitive] = ACTIONS(123),
    [anon_sym_mutable] = ACTIONS(125),
    [anon_sym_struct] = ACTIONS(127),
    [anon_sym_module] = ACTIONS(129),
    [anon_sym_macro] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_RPAREN] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(185),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [anon_sym_LT_COLON] = ACTIONS(185),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_elseif] = ACTIONS(185),
    [anon_sym_else] = ACTIONS(185),
    [anon_sym_try] = ACTIONS(137),
    [anon_sym_catch] = ACTIONS(185),
    [anon_sym_finally] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [sym_break_statement] = ACTIONS(143),
    [sym_continue_statement] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(147),
    [anon_sym_const] = ACTIONS(149),
    [anon_sym_quote] = ACTIONS(151),
    [anon_sym_using] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(153),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_COLON2] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(161),
    [anon_sym_GT_COLON] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_] = ACTIONS(163),
    [anon_sym_2] = ACTIONS(163),
    [anon_sym_3] = ACTIONS(163),
    [anon_sym_4] = ACTIONS(163),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(185),
    [anon_sym_EQ_GT] = ACTIONS(185),
    [anon_sym_LBRACK2] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(167),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_command_string] = ACTIONS(173),
    [sym_character] = ACTIONS(173),
    [sym__power_operator] = ACTIONS(175),
    [sym__times_operator] = ACTIONS(175),
    [sym__plus_operator] = ACTIONS(175),
    [sym__arrow_operator] = ACTIONS(185),
    [sym__comparison_operator] = ACTIONS(185),
    [sym__assign_operator] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(187),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(179),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [7] = {
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2737),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(2781),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(189),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(189),
    [anon_sym_RPAREN] = ACTIONS(189),
    [anon_sym_SEMI] = ACTIONS(189),
    [anon_sym_EQ] = ACTIONS(189),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(189),
    [anon_sym_COLON_COLON] = ACTIONS(189),
    [anon_sym_LT_COLON] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(189),
    [anon_sym_else] = ACTIONS(189),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_catch] = ACTIONS(189),
    [anon_sym_finally] = ACTIONS(189),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DOT_SQUOTE] = ACTIONS(189),
    [anon_sym_LT_PIPE] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_in] = ACTIONS(189),
    [anon_sym_isa] = ACTIONS(189),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(189),
    [anon_sym_QMARK] = ACTIONS(189),
    [anon_sym_EQ_GT] = ACTIONS(189),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(69),
    [sym__plus_operator] = ACTIONS(69),
    [sym__arrow_operator] = ACTIONS(189),
    [sym__comparison_operator] = ACTIONS(189),
    [sym__assign_operator] = ACTIONS(189),
    [anon_sym_LF] = ACTIONS(191),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [8] = {
    [sym_function_definition] = STATE(1299),
    [sym_abstract_definition] = STATE(1299),
    [sym_primitive_definition] = STATE(1299),
    [sym_struct_definition] = STATE(1299),
    [sym_module_definition] = STATE(1299),
    [sym_macro_definition] = STATE(1299),
    [sym_parameter_list] = STATE(4829),
    [sym_if_statement] = STATE(1299),
    [sym_try_statement] = STATE(1299),
    [sym_for_statement] = STATE(1299),
    [sym_while_statement] = STATE(1299),
    [sym_return_statement] = STATE(1299),
    [sym_let_statement] = STATE(1299),
    [sym_const_statement] = STATE(1299),
    [sym_quote_statement] = STATE(1299),
    [sym_import_statement] = STATE(1299),
    [sym_export_statement] = STATE(1299),
    [sym__expression] = STATE(1251),
    [sym__primary_expression] = STATE(1067),
    [sym_operator] = STATE(1067),
    [sym_parenthesized_expression] = STATE(1067),
    [sym_field_expression] = STATE(1038),
    [sym_subscript_expression] = STATE(1067),
    [sym_typed_expression] = STATE(1299),
    [sym_parameterized_identifier] = STATE(1067),
    [sym_compound_expression] = STATE(1299),
    [sym_call_expression] = STATE(1067),
    [sym_broadcast_call_expression] = STATE(1067),
    [sym_macro_expression] = STATE(1299),
    [sym_spread_expression] = STATE(1299),
    [sym_unary_expression] = STATE(1299),
    [sym_binary_expression] = STATE(1299),
    [sym_ternary_expression] = STATE(1299),
    [sym_pair_expression] = STATE(1299),
    [sym_tuple_expression] = STATE(1067),
    [sym_array_expression] = STATE(1067),
    [sym_matrix_expression] = STATE(1067),
    [sym_generator_expression] = STATE(1299),
    [sym_array_comprehension_expression] = STATE(1067),
    [sym_function_expression] = STATE(1299),
    [sym_range_expression] = STATE(1299),
    [sym_coefficient_expression] = STATE(1299),
    [sym_quote_expression] = STATE(1299),
    [sym_interpolation_expression] = STATE(1299),
    [sym_macro_identifier] = STATE(3),
    [sym_string] = STATE(1067),
    [aux_sym_macro_argument_list_repeat1] = STATE(10),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_function] = ACTIONS(117),
    [anon_sym_end] = ACTIONS(193),
    [anon_sym_abstract] = ACTIONS(121),
    [anon_sym_primitive] = ACTIONS(123),
    [anon_sym_mutable] = ACTIONS(125),
    [anon_sym_struct] = ACTIONS(127),
    [anon_sym_module] = ACTIONS(129),
    [anon_sym_macro] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_COMMA] = ACTIONS(193),
    [anon_sym_RPAREN] = ACTIONS(193),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym_EQ] = ACTIONS(193),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [anon_sym_LT_COLON] = ACTIONS(193),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_elseif] = ACTIONS(193),
    [anon_sym_else] = ACTIONS(193),
    [anon_sym_try] = ACTIONS(137),
    [anon_sym_catch] = ACTIONS(193),
    [anon_sym_finally] = ACTIONS(193),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [sym_break_statement] = ACTIONS(143),
    [sym_continue_statement] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(147),
    [anon_sym_const] = ACTIONS(149),
    [anon_sym_quote] = ACTIONS(151),
    [anon_sym_using] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(153),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_COLON2] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_begin] = ACTIONS(161),
    [anon_sym_GT_COLON] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_] = ACTIONS(163),
    [anon_sym_2] = ACTIONS(163),
    [anon_sym_3] = ACTIONS(163),
    [anon_sym_4] = ACTIONS(163),
    [anon_sym_SQUOTE] = ACTIONS(193),
    [anon_sym_DOT_SQUOTE] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_QMARK] = ACTIONS(193),
    [anon_sym_EQ_GT] = ACTIONS(193),
    [anon_sym_LBRACK2] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(167),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_command_string] = ACTIONS(173),
    [sym_character] = ACTIONS(173),
    [sym__power_operator] = ACTIONS(175),
    [sym__times_operator] = ACTIONS(175),
    [sym__plus_operator] = ACTIONS(175),
    [sym__arrow_operator] = ACTIONS(193),
    [sym__comparison_operator] = ACTIONS(193),
    [sym__assign_operator] = ACTIONS(193),
    [anon_sym_LF] = ACTIONS(195),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(179),
  },
  [9] = {
    [sym_function_definition] = STATE(1299),
    [sym_abstract_definition] = STATE(1299),
    [sym_primitive_definition] = STATE(1299),
    [sym_struct_definition] = STATE(1299),
    [sym_module_definition] = STATE(1299),
    [sym_macro_definition] = STATE(1299),
    [sym_parameter_list] = STATE(4829),
    [sym_if_statement] = STATE(1299),
    [sym_try_statement] = STATE(1299),
    [sym_for_statement] = STATE(1299),
    [sym_while_statement] = STATE(1299),
    [sym_return_statement] = STATE(1299),
    [sym_let_statement] = STATE(1299),
    [sym_const_statement] = STATE(1299),
    [sym_quote_statement] = STATE(1299),
    [sym_import_statement] = STATE(1299),
    [sym_export_statement] = STATE(1299),
    [sym__expression] = STATE(1128),
    [sym__primary_expression] = STATE(1067),
    [sym_bare_tuple_expression] = STATE(1295),
    [sym_operator] = STATE(1067),
    [sym_parenthesized_expression] = STATE(1067),
    [sym_field_expression] = STATE(1038),
    [sym_subscript_expression] = STATE(1067),
    [sym_typed_expression] = STATE(1299),
    [sym_parameterized_identifier] = STATE(1067),
    [sym_compound_expression] = STATE(1299),
    [sym_call_expression] = STATE(1067),
    [sym_broadcast_call_expression] = STATE(1067),
    [sym_macro_expression] = STATE(1299),
    [sym_spread_expression] = STATE(1299),
    [sym_unary_expression] = STATE(1299),
    [sym_binary_expression] = STATE(1299),
    [sym_ternary_expression] = STATE(1299),
    [sym_pair_expression] = STATE(1299),
    [sym_tuple_expression] = STATE(1067),
    [sym_array_expression] = STATE(1067),
    [sym_matrix_expression] = STATE(1067),
    [sym_generator_expression] = STATE(1299),
    [sym_array_comprehension_expression] = STATE(1067),
    [sym_function_expression] = STATE(1299),
    [sym_range_expression] = STATE(1299),
    [sym_coefficient_expression] = STATE(1299),
    [sym_quote_expression] = STATE(1299),
    [sym_interpolation_expression] = STATE(1299),
    [sym_macro_identifier] = STATE(3),
    [sym_string] = STATE(1067),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_function] = ACTIONS(117),
    [anon_sym_end] = ACTIONS(189),
    [anon_sym_abstract] = ACTIONS(121),
    [anon_sym_primitive] = ACTIONS(123),
    [anon_sym_mutable] = ACTIONS(125),
    [anon_sym_struct] = ACTIONS(127),
    [anon_sym_module] = ACTIONS(129),
    [anon_sym_macro] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_COMMA] = ACTIONS(189),
    [anon_sym_RPAREN] = ACTIONS(189),
    [anon_sym_SEMI] = ACTIONS(189),
    [anon_sym_EQ] = ACTIONS(189),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(189),
    [anon_sym_COLON_COLON] = ACTIONS(189),
    [anon_sym_LT_COLON] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_elseif] = ACTIONS(189),
    [anon_sym_else] = ACTIONS(189),
    [anon_sym_try] = ACTIONS(137),
    [anon_sym_catch] = ACTIONS(189),
    [anon_sym_finally] = ACTIONS(189),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [sym_break_statement] = ACTIONS(143),
    [sym_continue_statement] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(147),
    [anon_sym_const] = ACTIONS(149),
    [anon_sym_quote] = ACTIONS(151),
    [anon_sym_using] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(153),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_COLON2] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_begin] = ACTIONS(161),
    [anon_sym_GT_COLON] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_] = ACTIONS(163),
    [anon_sym_2] = ACTIONS(163),
    [anon_sym_3] = ACTIONS(163),
    [anon_sym_4] = ACTIONS(163),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DOT_SQUOTE] = ACTIONS(189),
    [anon_sym_LT_PIPE] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_in] = ACTIONS(189),
    [anon_sym_isa] = ACTIONS(189),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(189),
    [anon_sym_QMARK] = ACTIONS(189),
    [anon_sym_EQ_GT] = ACTIONS(189),
    [anon_sym_LBRACK2] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(167),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_command_string] = ACTIONS(173),
    [sym_character] = ACTIONS(173),
    [sym__power_operator] = ACTIONS(175),
    [sym__times_operator] = ACTIONS(175),
    [sym__plus_operator] = ACTIONS(175),
    [sym__arrow_operator] = ACTIONS(189),
    [sym__comparison_operator] = ACTIONS(189),
    [sym__assign_operator] = ACTIONS(189),
    [anon_sym_LF] = ACTIONS(191),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(179),
  },
  [10] = {
    [sym_function_definition] = STATE(1299),
    [sym_abstract_definition] = STATE(1299),
    [sym_primitive_definition] = STATE(1299),
    [sym_struct_definition] = STATE(1299),
    [sym_module_definition] = STATE(1299),
    [sym_macro_definition] = STATE(1299),
    [sym_parameter_list] = STATE(4829),
    [sym_if_statement] = STATE(1299),
    [sym_try_statement] = STATE(1299),
    [sym_for_statement] = STATE(1299),
    [sym_while_statement] = STATE(1299),
    [sym_return_statement] = STATE(1299),
    [sym_let_statement] = STATE(1299),
    [sym_const_statement] = STATE(1299),
    [sym_quote_statement] = STATE(1299),
    [sym_import_statement] = STATE(1299),
    [sym_export_statement] = STATE(1299),
    [sym__expression] = STATE(1251),
    [sym__primary_expression] = STATE(1067),
    [sym_operator] = STATE(1067),
    [sym_parenthesized_expression] = STATE(1067),
    [sym_field_expression] = STATE(1038),
    [sym_subscript_expression] = STATE(1067),
    [sym_typed_expression] = STATE(1299),
    [sym_parameterized_identifier] = STATE(1067),
    [sym_compound_expression] = STATE(1299),
    [sym_call_expression] = STATE(1067),
    [sym_broadcast_call_expression] = STATE(1067),
    [sym_macro_expression] = STATE(1299),
    [sym_spread_expression] = STATE(1299),
    [sym_unary_expression] = STATE(1299),
    [sym_binary_expression] = STATE(1299),
    [sym_ternary_expression] = STATE(1299),
    [sym_pair_expression] = STATE(1299),
    [sym_tuple_expression] = STATE(1067),
    [sym_array_expression] = STATE(1067),
    [sym_matrix_expression] = STATE(1067),
    [sym_generator_expression] = STATE(1299),
    [sym_array_comprehension_expression] = STATE(1067),
    [sym_function_expression] = STATE(1299),
    [sym_range_expression] = STATE(1299),
    [sym_coefficient_expression] = STATE(1299),
    [sym_quote_expression] = STATE(1299),
    [sym_interpolation_expression] = STATE(1299),
    [sym_macro_identifier] = STATE(3),
    [sym_string] = STATE(1067),
    [aux_sym_macro_argument_list_repeat1] = STATE(10),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_function] = ACTIONS(200),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_abstract] = ACTIONS(205),
    [anon_sym_primitive] = ACTIONS(208),
    [anon_sym_mutable] = ACTIONS(211),
    [anon_sym_struct] = ACTIONS(214),
    [anon_sym_module] = ACTIONS(217),
    [anon_sym_macro] = ACTIONS(220),
    [anon_sym_LPAREN] = ACTIONS(223),
    [anon_sym_COMMA] = ACTIONS(203),
    [anon_sym_RPAREN] = ACTIONS(203),
    [anon_sym_SEMI] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_COLON_COLON] = ACTIONS(203),
    [anon_sym_LT_COLON] = ACTIONS(203),
    [anon_sym_if] = ACTIONS(226),
    [anon_sym_elseif] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(203),
    [anon_sym_try] = ACTIONS(229),
    [anon_sym_catch] = ACTIONS(203),
    [anon_sym_finally] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(232),
    [anon_sym_while] = ACTIONS(235),
    [sym_break_statement] = ACTIONS(238),
    [sym_continue_statement] = ACTIONS(238),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_let] = ACTIONS(244),
    [anon_sym_const] = ACTIONS(247),
    [anon_sym_quote] = ACTIONS(250),
    [anon_sym_using] = ACTIONS(253),
    [anon_sym_import] = ACTIONS(253),
    [anon_sym_export] = ACTIONS(256),
    [anon_sym_COLON2] = ACTIONS(259),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_begin] = ACTIONS(265),
    [anon_sym_GT_COLON] = ACTIONS(268),
    [anon_sym_DASH] = ACTIONS(268),
    [anon_sym_BANG] = ACTIONS(268),
    [anon_sym_TILDE] = ACTIONS(268),
    [anon_sym_] = ACTIONS(268),
    [anon_sym_2] = ACTIONS(268),
    [anon_sym_3] = ACTIONS(268),
    [anon_sym_4] = ACTIONS(268),
    [anon_sym_SQUOTE] = ACTIONS(203),
    [anon_sym_DOT_SQUOTE] = ACTIONS(203),
    [anon_sym_LT_PIPE] = ACTIONS(203),
    [anon_sym_PIPE_GT] = ACTIONS(203),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(203),
    [anon_sym_EQ_GT] = ACTIONS(203),
    [anon_sym_LBRACK2] = ACTIONS(271),
    [anon_sym_DOLLAR] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(277),
    [sym_number] = ACTIONS(280),
    [anon_sym_DQUOTE] = ACTIONS(283),
    [sym_command_string] = ACTIONS(286),
    [sym_character] = ACTIONS(286),
    [sym__power_operator] = ACTIONS(289),
    [sym__times_operator] = ACTIONS(289),
    [sym__plus_operator] = ACTIONS(289),
    [sym__arrow_operator] = ACTIONS(203),
    [sym__comparison_operator] = ACTIONS(203),
    [sym__assign_operator] = ACTIONS(203),
    [anon_sym_LF] = ACTIONS(292),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(294),
  },
  [11] = {
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2859),
    [sym__primary_expression] = STATE(2565),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(297),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(297),
    [anon_sym_RPAREN] = ACTIONS(297),
    [anon_sym_SEMI] = ACTIONS(297),
    [anon_sym_EQ] = ACTIONS(297),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(297),
    [anon_sym_COLON_COLON] = ACTIONS(297),
    [anon_sym_LT_COLON] = ACTIONS(297),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(297),
    [anon_sym_else] = ACTIONS(297),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_catch] = ACTIONS(297),
    [anon_sym_finally] = ACTIONS(297),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(297),
    [anon_sym_DOT_SQUOTE] = ACTIONS(297),
    [anon_sym_LT_PIPE] = ACTIONS(297),
    [anon_sym_PIPE_GT] = ACTIONS(297),
    [anon_sym_in] = ACTIONS(297),
    [anon_sym_isa] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(297),
    [anon_sym_EQ_GT] = ACTIONS(297),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(69),
    [sym__plus_operator] = ACTIONS(69),
    [sym__arrow_operator] = ACTIONS(297),
    [sym__comparison_operator] = ACTIONS(297),
    [sym__assign_operator] = ACTIONS(297),
    [anon_sym_LF] = ACTIONS(299),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [12] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4821),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(2182),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(47),
    [sym_string] = STATE(1466),
    [sym_identifier] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_primitive] = ACTIONS(307),
    [anon_sym_mutable] = ACTIONS(309),
    [anon_sym_struct] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(313),
    [anon_sym_macro] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(185),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [anon_sym_LT_COLON] = ACTIONS(185),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_elseif] = ACTIONS(185),
    [anon_sym_else] = ACTIONS(185),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [sym_break_statement] = ACTIONS(327),
    [sym_continue_statement] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_quote] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(337),
    [anon_sym_import] = ACTIONS(337),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(339),
    [anon_sym_COLON2] = ACTIONS(341),
    [anon_sym_PLUS] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(345),
    [anon_sym_GT_COLON] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(347),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_] = ACTIONS(347),
    [anon_sym_2] = ACTIONS(347),
    [anon_sym_3] = ACTIONS(347),
    [anon_sym_4] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(185),
    [anon_sym_EQ_GT] = ACTIONS(185),
    [anon_sym_LBRACK2] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_command_string] = ACTIONS(359),
    [sym_character] = ACTIONS(359),
    [sym__power_operator] = ACTIONS(361),
    [sym__times_operator] = ACTIONS(361),
    [sym__plus_operator] = ACTIONS(361),
    [sym__arrow_operator] = ACTIONS(185),
    [sym__comparison_operator] = ACTIONS(185),
    [sym__assign_operator] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(187),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(363),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [13] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4821),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(2190),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(47),
    [sym_string] = STATE(1466),
    [sym_identifier] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_primitive] = ACTIONS(307),
    [anon_sym_mutable] = ACTIONS(309),
    [anon_sym_struct] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(313),
    [anon_sym_macro] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(185),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [anon_sym_LT_COLON] = ACTIONS(185),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_elseif] = ACTIONS(185),
    [anon_sym_else] = ACTIONS(185),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [sym_break_statement] = ACTIONS(327),
    [sym_continue_statement] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_quote] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(337),
    [anon_sym_import] = ACTIONS(337),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(339),
    [anon_sym_COLON2] = ACTIONS(341),
    [anon_sym_PLUS] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(345),
    [anon_sym_GT_COLON] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(347),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_] = ACTIONS(347),
    [anon_sym_2] = ACTIONS(347),
    [anon_sym_3] = ACTIONS(347),
    [anon_sym_4] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(185),
    [anon_sym_EQ_GT] = ACTIONS(185),
    [anon_sym_LBRACK2] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_command_string] = ACTIONS(359),
    [sym_character] = ACTIONS(359),
    [sym__power_operator] = ACTIONS(361),
    [sym__times_operator] = ACTIONS(361),
    [sym__plus_operator] = ACTIONS(361),
    [sym__arrow_operator] = ACTIONS(185),
    [sym__comparison_operator] = ACTIONS(185),
    [sym__assign_operator] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(187),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(363),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [14] = {
    [sym__expression_list] = STATE(3401),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_elseif_clause] = STATE(3410),
    [sym_else_clause] = STATE(4777),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [aux_sym_if_statement_repeat1] = STATE(3410),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(365),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(367),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(373),
    [anon_sym_else] = ACTIONS(375),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(405),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [15] = {
    [sym__expression_list] = STATE(3435),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_elseif_clause] = STATE(3457),
    [sym_else_clause] = STATE(4675),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [aux_sym_if_statement_repeat1] = STATE(3457),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(407),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(409),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(373),
    [anon_sym_else] = ACTIONS(375),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(411),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [16] = {
    [sym__expression_list] = STATE(3407),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_elseif_clause] = STATE(3402),
    [sym_else_clause] = STATE(5226),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [aux_sym_if_statement_repeat1] = STATE(3402),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(413),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(415),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(373),
    [anon_sym_else] = ACTIONS(375),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(417),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [17] = {
    [sym_function_definition] = STATE(1578),
    [sym_abstract_definition] = STATE(1578),
    [sym_primitive_definition] = STATE(1578),
    [sym_struct_definition] = STATE(1578),
    [sym_module_definition] = STATE(1578),
    [sym_macro_definition] = STATE(1578),
    [sym_parameter_list] = STATE(5156),
    [sym_if_statement] = STATE(1578),
    [sym_try_statement] = STATE(1578),
    [sym_for_statement] = STATE(1578),
    [sym_while_statement] = STATE(1578),
    [sym_return_statement] = STATE(1578),
    [sym_let_statement] = STATE(1578),
    [sym_const_statement] = STATE(1578),
    [sym_quote_statement] = STATE(1578),
    [sym_import_statement] = STATE(1578),
    [sym_export_statement] = STATE(1578),
    [sym__expression] = STATE(1514),
    [sym__primary_expression] = STATE(1255),
    [sym_operator] = STATE(1255),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_field_expression] = STATE(1099),
    [sym_subscript_expression] = STATE(1255),
    [sym_typed_expression] = STATE(1578),
    [sym_parameterized_identifier] = STATE(1255),
    [sym_compound_expression] = STATE(1578),
    [sym_call_expression] = STATE(1255),
    [sym_broadcast_call_expression] = STATE(1255),
    [sym_macro_expression] = STATE(1578),
    [sym_spread_expression] = STATE(1578),
    [sym_unary_expression] = STATE(1578),
    [sym_binary_expression] = STATE(1578),
    [sym_ternary_expression] = STATE(1578),
    [sym_pair_expression] = STATE(1578),
    [sym_tuple_expression] = STATE(1255),
    [sym_array_expression] = STATE(1255),
    [sym_matrix_expression] = STATE(1255),
    [sym_generator_expression] = STATE(1578),
    [sym_array_comprehension_expression] = STATE(1255),
    [sym_function_expression] = STATE(1578),
    [sym_range_expression] = STATE(1578),
    [sym_coefficient_expression] = STATE(1578),
    [sym_quote_expression] = STATE(1578),
    [sym_interpolation_expression] = STATE(1578),
    [sym_macro_identifier] = STATE(24),
    [sym_string] = STATE(1255),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(421),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(423),
    [anon_sym_primitive] = ACTIONS(425),
    [anon_sym_mutable] = ACTIONS(427),
    [anon_sym_struct] = ACTIONS(429),
    [anon_sym_module] = ACTIONS(431),
    [anon_sym_macro] = ACTIONS(433),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(187),
    [anon_sym_RPAREN] = ACTIONS(187),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(187),
    [anon_sym_COLON_COLON] = ACTIONS(187),
    [anon_sym_RBRACE] = ACTIONS(187),
    [anon_sym_LT_COLON] = ACTIONS(187),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_try] = ACTIONS(439),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(443),
    [sym_break_statement] = ACTIONS(445),
    [sym_continue_statement] = ACTIONS(445),
    [anon_sym_return] = ACTIONS(447),
    [anon_sym_let] = ACTIONS(449),
    [anon_sym_const] = ACTIONS(451),
    [anon_sym_quote] = ACTIONS(453),
    [anon_sym_using] = ACTIONS(455),
    [anon_sym_import] = ACTIONS(455),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(457),
    [anon_sym_COLON2] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_RBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(463),
    [anon_sym_GT_COLON] = ACTIONS(465),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_] = ACTIONS(465),
    [anon_sym_2] = ACTIONS(465),
    [anon_sym_3] = ACTIONS(465),
    [anon_sym_4] = ACTIONS(465),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(187),
    [anon_sym_LT_PIPE] = ACTIONS(187),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(187),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_EQ_GT] = ACTIONS(187),
    [anon_sym_LBRACK2] = ACTIONS(469),
    [anon_sym_DOLLAR] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(473),
    [sym_number] = ACTIONS(475),
    [anon_sym_DQUOTE] = ACTIONS(477),
    [sym_command_string] = ACTIONS(479),
    [sym_character] = ACTIONS(479),
    [sym__power_operator] = ACTIONS(481),
    [sym__times_operator] = ACTIONS(481),
    [sym__plus_operator] = ACTIONS(481),
    [sym__arrow_operator] = ACTIONS(187),
    [sym__comparison_operator] = ACTIONS(185),
    [sym__assign_operator] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(479),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [18] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4821),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(1791),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(47),
    [sym_string] = STATE(1466),
    [sym_identifier] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_primitive] = ACTIONS(307),
    [anon_sym_mutable] = ACTIONS(309),
    [anon_sym_struct] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(313),
    [anon_sym_macro] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(185),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [anon_sym_LT_COLON] = ACTIONS(185),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_elseif] = ACTIONS(185),
    [anon_sym_else] = ACTIONS(185),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [sym_break_statement] = ACTIONS(327),
    [sym_continue_statement] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_quote] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(337),
    [anon_sym_import] = ACTIONS(337),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(339),
    [anon_sym_COLON2] = ACTIONS(341),
    [anon_sym_PLUS] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(345),
    [anon_sym_GT_COLON] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(347),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_] = ACTIONS(347),
    [anon_sym_2] = ACTIONS(347),
    [anon_sym_3] = ACTIONS(347),
    [anon_sym_4] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(185),
    [anon_sym_EQ_GT] = ACTIONS(185),
    [anon_sym_LBRACK2] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_command_string] = ACTIONS(359),
    [sym_character] = ACTIONS(359),
    [sym__power_operator] = ACTIONS(361),
    [sym__times_operator] = ACTIONS(361),
    [sym__plus_operator] = ACTIONS(361),
    [sym__arrow_operator] = ACTIONS(185),
    [sym__comparison_operator] = ACTIONS(185),
    [sym__assign_operator] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(187),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(363),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [19] = {
    [sym_function_definition] = STATE(1299),
    [sym_abstract_definition] = STATE(1299),
    [sym_primitive_definition] = STATE(1299),
    [sym_struct_definition] = STATE(1299),
    [sym_module_definition] = STATE(1299),
    [sym_macro_definition] = STATE(1299),
    [sym_parameter_list] = STATE(4829),
    [sym_if_statement] = STATE(1299),
    [sym_try_statement] = STATE(1299),
    [sym_for_statement] = STATE(1299),
    [sym_while_statement] = STATE(1299),
    [sym_return_statement] = STATE(1299),
    [sym_let_statement] = STATE(1299),
    [sym_const_statement] = STATE(1299),
    [sym_quote_statement] = STATE(1299),
    [sym_import_statement] = STATE(1299),
    [sym_export_statement] = STATE(1299),
    [sym__expression] = STATE(1288),
    [sym__primary_expression] = STATE(1067),
    [sym_operator] = STATE(1067),
    [sym_parenthesized_expression] = STATE(1067),
    [sym_field_expression] = STATE(1038),
    [sym_subscript_expression] = STATE(1067),
    [sym_typed_expression] = STATE(1299),
    [sym_parameterized_identifier] = STATE(1067),
    [sym_compound_expression] = STATE(1299),
    [sym_call_expression] = STATE(1067),
    [sym_broadcast_call_expression] = STATE(1067),
    [sym_macro_expression] = STATE(1299),
    [sym_spread_expression] = STATE(1299),
    [sym_unary_expression] = STATE(1299),
    [sym_binary_expression] = STATE(1299),
    [sym_ternary_expression] = STATE(1299),
    [sym_pair_expression] = STATE(1299),
    [sym_tuple_expression] = STATE(1067),
    [sym_array_expression] = STATE(1067),
    [sym_matrix_expression] = STATE(1067),
    [sym_generator_expression] = STATE(1299),
    [sym_array_comprehension_expression] = STATE(1067),
    [sym_function_expression] = STATE(1299),
    [sym_range_expression] = STATE(1299),
    [sym_coefficient_expression] = STATE(1299),
    [sym_quote_expression] = STATE(1299),
    [sym_interpolation_expression] = STATE(1299),
    [sym_macro_identifier] = STATE(3),
    [sym_string] = STATE(1067),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_function] = ACTIONS(117),
    [anon_sym_end] = ACTIONS(297),
    [anon_sym_abstract] = ACTIONS(121),
    [anon_sym_primitive] = ACTIONS(123),
    [anon_sym_mutable] = ACTIONS(125),
    [anon_sym_struct] = ACTIONS(127),
    [anon_sym_module] = ACTIONS(129),
    [anon_sym_macro] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_COMMA] = ACTIONS(297),
    [anon_sym_RPAREN] = ACTIONS(297),
    [anon_sym_SEMI] = ACTIONS(297),
    [anon_sym_EQ] = ACTIONS(297),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(297),
    [anon_sym_COLON_COLON] = ACTIONS(297),
    [anon_sym_LT_COLON] = ACTIONS(297),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_elseif] = ACTIONS(297),
    [anon_sym_else] = ACTIONS(297),
    [anon_sym_try] = ACTIONS(137),
    [anon_sym_catch] = ACTIONS(297),
    [anon_sym_finally] = ACTIONS(297),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [sym_break_statement] = ACTIONS(143),
    [sym_continue_statement] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(147),
    [anon_sym_const] = ACTIONS(149),
    [anon_sym_quote] = ACTIONS(151),
    [anon_sym_using] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(153),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_COLON2] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_begin] = ACTIONS(161),
    [anon_sym_GT_COLON] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_] = ACTIONS(163),
    [anon_sym_2] = ACTIONS(163),
    [anon_sym_3] = ACTIONS(163),
    [anon_sym_4] = ACTIONS(163),
    [anon_sym_SQUOTE] = ACTIONS(297),
    [anon_sym_DOT_SQUOTE] = ACTIONS(297),
    [anon_sym_LT_PIPE] = ACTIONS(297),
    [anon_sym_PIPE_GT] = ACTIONS(297),
    [anon_sym_in] = ACTIONS(297),
    [anon_sym_isa] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(297),
    [anon_sym_EQ_GT] = ACTIONS(297),
    [anon_sym_LBRACK2] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(167),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_command_string] = ACTIONS(173),
    [sym_character] = ACTIONS(173),
    [sym__power_operator] = ACTIONS(175),
    [sym__times_operator] = ACTIONS(175),
    [sym__plus_operator] = ACTIONS(175),
    [sym__arrow_operator] = ACTIONS(297),
    [sym__comparison_operator] = ACTIONS(297),
    [sym__assign_operator] = ACTIONS(297),
    [anon_sym_LF] = ACTIONS(299),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(179),
  },
  [20] = {
    [sym_function_definition] = STATE(1299),
    [sym_abstract_definition] = STATE(1299),
    [sym_primitive_definition] = STATE(1299),
    [sym_struct_definition] = STATE(1299),
    [sym_module_definition] = STATE(1299),
    [sym_macro_definition] = STATE(1299),
    [sym_parameter_list] = STATE(4829),
    [sym_if_statement] = STATE(1299),
    [sym_try_statement] = STATE(1299),
    [sym_for_statement] = STATE(1299),
    [sym_while_statement] = STATE(1299),
    [sym_return_statement] = STATE(1299),
    [sym_let_statement] = STATE(1299),
    [sym_const_statement] = STATE(1299),
    [sym_quote_statement] = STATE(1299),
    [sym_import_statement] = STATE(1299),
    [sym_export_statement] = STATE(1299),
    [sym__expression] = STATE(1583),
    [sym__primary_expression] = STATE(1067),
    [sym_operator] = STATE(1067),
    [sym_parenthesized_expression] = STATE(1067),
    [sym_field_expression] = STATE(1038),
    [sym_subscript_expression] = STATE(1067),
    [sym_typed_expression] = STATE(1299),
    [sym_parameterized_identifier] = STATE(1067),
    [sym_compound_expression] = STATE(1299),
    [sym_call_expression] = STATE(1067),
    [sym_broadcast_call_expression] = STATE(1067),
    [sym_macro_expression] = STATE(1299),
    [sym_spread_expression] = STATE(1299),
    [sym_unary_expression] = STATE(1299),
    [sym_binary_expression] = STATE(1299),
    [sym_ternary_expression] = STATE(1299),
    [sym_pair_expression] = STATE(1299),
    [sym_tuple_expression] = STATE(1067),
    [sym_array_expression] = STATE(1067),
    [sym_matrix_expression] = STATE(1067),
    [sym_generator_expression] = STATE(1299),
    [sym_array_comprehension_expression] = STATE(1067),
    [sym_function_expression] = STATE(1299),
    [sym_range_expression] = STATE(1299),
    [sym_coefficient_expression] = STATE(1299),
    [sym_quote_expression] = STATE(1299),
    [sym_interpolation_expression] = STATE(1299),
    [sym_macro_identifier] = STATE(3),
    [sym_string] = STATE(1067),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_function] = ACTIONS(117),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(121),
    [anon_sym_primitive] = ACTIONS(123),
    [anon_sym_mutable] = ACTIONS(125),
    [anon_sym_struct] = ACTIONS(127),
    [anon_sym_module] = ACTIONS(129),
    [anon_sym_macro] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(185),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [anon_sym_LT_COLON] = ACTIONS(185),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_elseif] = ACTIONS(185),
    [anon_sym_else] = ACTIONS(185),
    [anon_sym_try] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [sym_break_statement] = ACTIONS(143),
    [sym_continue_statement] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(147),
    [anon_sym_const] = ACTIONS(149),
    [anon_sym_quote] = ACTIONS(151),
    [anon_sym_using] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(153),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_COLON2] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(161),
    [anon_sym_GT_COLON] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_] = ACTIONS(163),
    [anon_sym_2] = ACTIONS(163),
    [anon_sym_3] = ACTIONS(163),
    [anon_sym_4] = ACTIONS(163),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(185),
    [anon_sym_EQ_GT] = ACTIONS(185),
    [anon_sym_LBRACK2] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(167),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_command_string] = ACTIONS(173),
    [sym_character] = ACTIONS(173),
    [sym__power_operator] = ACTIONS(175),
    [sym__times_operator] = ACTIONS(175),
    [sym__plus_operator] = ACTIONS(175),
    [sym__arrow_operator] = ACTIONS(185),
    [sym__comparison_operator] = ACTIONS(185),
    [sym__assign_operator] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(187),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(179),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [21] = {
    [sym__expression_list] = STATE(3447),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_elseif_clause] = STATE(3449),
    [sym_else_clause] = STATE(4806),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [aux_sym_if_statement_repeat1] = STATE(3449),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(483),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(485),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(373),
    [anon_sym_else] = ACTIONS(375),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(487),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [22] = {
    [sym__expression_list] = STATE(3416),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_elseif_clause] = STATE(3417),
    [sym_else_clause] = STATE(4587),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [aux_sym_if_statement_repeat1] = STATE(3417),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(489),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(373),
    [anon_sym_else] = ACTIONS(375),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(493),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [23] = {
    [sym__expression_list] = STATE(3414),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_elseif_clause] = STATE(3412),
    [sym_else_clause] = STATE(4795),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [aux_sym_if_statement_repeat1] = STATE(3412),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(495),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(497),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(373),
    [anon_sym_else] = ACTIONS(375),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(499),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [24] = {
    [sym_function_definition] = STATE(1578),
    [sym_abstract_definition] = STATE(1578),
    [sym_primitive_definition] = STATE(1578),
    [sym_struct_definition] = STATE(1578),
    [sym_module_definition] = STATE(1578),
    [sym_macro_definition] = STATE(1578),
    [sym_parameter_list] = STATE(5156),
    [sym_if_statement] = STATE(1578),
    [sym_try_statement] = STATE(1578),
    [sym_for_statement] = STATE(1578),
    [sym_while_statement] = STATE(1578),
    [sym_return_statement] = STATE(1578),
    [sym_let_statement] = STATE(1578),
    [sym_const_statement] = STATE(1578),
    [sym_quote_statement] = STATE(1578),
    [sym_import_statement] = STATE(1578),
    [sym_export_statement] = STATE(1578),
    [sym__expression] = STATE(1516),
    [sym__primary_expression] = STATE(1255),
    [sym_operator] = STATE(1255),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_field_expression] = STATE(1099),
    [sym_subscript_expression] = STATE(1255),
    [sym_typed_expression] = STATE(1578),
    [sym_parameterized_identifier] = STATE(1255),
    [sym_compound_expression] = STATE(1578),
    [sym_call_expression] = STATE(1255),
    [sym_broadcast_call_expression] = STATE(1255),
    [sym_macro_expression] = STATE(1578),
    [sym_macro_argument_list] = STATE(1549),
    [sym_spread_expression] = STATE(1578),
    [sym_unary_expression] = STATE(1578),
    [sym_binary_expression] = STATE(1578),
    [sym_ternary_expression] = STATE(1578),
    [sym_pair_expression] = STATE(1578),
    [sym_tuple_expression] = STATE(1255),
    [sym_array_expression] = STATE(1255),
    [sym_matrix_expression] = STATE(1255),
    [sym_generator_expression] = STATE(1578),
    [sym_array_comprehension_expression] = STATE(1255),
    [sym_function_expression] = STATE(1578),
    [sym_range_expression] = STATE(1578),
    [sym_coefficient_expression] = STATE(1578),
    [sym_quote_expression] = STATE(1578),
    [sym_interpolation_expression] = STATE(1578),
    [sym_macro_identifier] = STATE(24),
    [sym_string] = STATE(1255),
    [aux_sym_macro_argument_list_repeat1] = STATE(41),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(421),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_abstract] = ACTIONS(423),
    [anon_sym_primitive] = ACTIONS(425),
    [anon_sym_mutable] = ACTIONS(427),
    [anon_sym_struct] = ACTIONS(429),
    [anon_sym_module] = ACTIONS(431),
    [anon_sym_macro] = ACTIONS(433),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_EQ] = ACTIONS(119),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(177),
    [anon_sym_COLON_COLON] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(177),
    [anon_sym_LT_COLON] = ACTIONS(177),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_try] = ACTIONS(439),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(443),
    [sym_break_statement] = ACTIONS(445),
    [sym_continue_statement] = ACTIONS(445),
    [anon_sym_return] = ACTIONS(447),
    [anon_sym_let] = ACTIONS(449),
    [anon_sym_const] = ACTIONS(451),
    [anon_sym_quote] = ACTIONS(453),
    [anon_sym_using] = ACTIONS(455),
    [anon_sym_import] = ACTIONS(455),
    [anon_sym_export] = ACTIONS(457),
    [anon_sym_COLON2] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_RBRACK] = ACTIONS(177),
    [anon_sym_begin] = ACTIONS(463),
    [anon_sym_GT_COLON] = ACTIONS(465),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_] = ACTIONS(465),
    [anon_sym_2] = ACTIONS(465),
    [anon_sym_3] = ACTIONS(465),
    [anon_sym_4] = ACTIONS(465),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(177),
    [anon_sym_LT_PIPE] = ACTIONS(177),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_QMARK] = ACTIONS(177),
    [anon_sym_EQ_GT] = ACTIONS(177),
    [anon_sym_LBRACK2] = ACTIONS(501),
    [anon_sym_DOLLAR] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(473),
    [sym_number] = ACTIONS(475),
    [anon_sym_DQUOTE] = ACTIONS(477),
    [sym_command_string] = ACTIONS(479),
    [sym_character] = ACTIONS(479),
    [sym__power_operator] = ACTIONS(481),
    [sym__times_operator] = ACTIONS(481),
    [sym__plus_operator] = ACTIONS(481),
    [sym__arrow_operator] = ACTIONS(177),
    [sym__comparison_operator] = ACTIONS(119),
    [sym__assign_operator] = ACTIONS(119),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(479),
    [sym__immediate_paren] = ACTIONS(503),
  },
  [25] = {
    [sym__expression_list] = STATE(3422),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_elseif_clause] = STATE(3392),
    [sym_else_clause] = STATE(4988),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [aux_sym_if_statement_repeat1] = STATE(3392),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(505),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(507),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(373),
    [anon_sym_else] = ACTIONS(375),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(509),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [26] = {
    [sym__expression_list] = STATE(3421),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_elseif_clause] = STATE(3429),
    [sym_else_clause] = STATE(5160),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [aux_sym_if_statement_repeat1] = STATE(3429),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(511),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(513),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(373),
    [anon_sym_else] = ACTIONS(375),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(515),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [27] = {
    [sym__expression_list] = STATE(3448),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_elseif_clause] = STATE(3442),
    [sym_else_clause] = STATE(4539),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [aux_sym_if_statement_repeat1] = STATE(3442),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(517),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(519),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(373),
    [anon_sym_else] = ACTIONS(375),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(521),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [28] = {
    [sym__expression_list] = STATE(3404),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_elseif_clause] = STATE(3403),
    [sym_else_clause] = STATE(4963),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [aux_sym_if_statement_repeat1] = STATE(3403),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(523),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(525),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(373),
    [anon_sym_else] = ACTIONS(375),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(527),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [29] = {
    [sym_function_definition] = STATE(1578),
    [sym_abstract_definition] = STATE(1578),
    [sym_primitive_definition] = STATE(1578),
    [sym_struct_definition] = STATE(1578),
    [sym_module_definition] = STATE(1578),
    [sym_macro_definition] = STATE(1578),
    [sym_parameter_list] = STATE(5156),
    [sym_if_statement] = STATE(1578),
    [sym_try_statement] = STATE(1578),
    [sym_for_statement] = STATE(1578),
    [sym_while_statement] = STATE(1578),
    [sym_return_statement] = STATE(1578),
    [sym_let_statement] = STATE(1578),
    [sym_const_statement] = STATE(1578),
    [sym_quote_statement] = STATE(1578),
    [sym_import_statement] = STATE(1578),
    [sym_export_statement] = STATE(1578),
    [sym__expression] = STATE(1516),
    [sym__primary_expression] = STATE(1255),
    [sym_operator] = STATE(1255),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_field_expression] = STATE(1099),
    [sym_subscript_expression] = STATE(1255),
    [sym_typed_expression] = STATE(1578),
    [sym_parameterized_identifier] = STATE(1255),
    [sym_compound_expression] = STATE(1578),
    [sym_call_expression] = STATE(1255),
    [sym_broadcast_call_expression] = STATE(1255),
    [sym_macro_expression] = STATE(1578),
    [sym_macro_argument_list] = STATE(2942),
    [sym_spread_expression] = STATE(1578),
    [sym_unary_expression] = STATE(1578),
    [sym_binary_expression] = STATE(1578),
    [sym_ternary_expression] = STATE(1578),
    [sym_pair_expression] = STATE(1578),
    [sym_tuple_expression] = STATE(1255),
    [sym_array_expression] = STATE(1255),
    [sym_matrix_expression] = STATE(1255),
    [sym_generator_expression] = STATE(1578),
    [sym_array_comprehension_expression] = STATE(1255),
    [sym_function_expression] = STATE(1578),
    [sym_range_expression] = STATE(1578),
    [sym_coefficient_expression] = STATE(1578),
    [sym_quote_expression] = STATE(1578),
    [sym_interpolation_expression] = STATE(1578),
    [sym_macro_identifier] = STATE(24),
    [sym_string] = STATE(1255),
    [aux_sym_macro_argument_list_repeat1] = STATE(41),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(421),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_abstract] = ACTIONS(423),
    [anon_sym_primitive] = ACTIONS(425),
    [anon_sym_mutable] = ACTIONS(427),
    [anon_sym_struct] = ACTIONS(429),
    [anon_sym_module] = ACTIONS(431),
    [anon_sym_macro] = ACTIONS(433),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_EQ] = ACTIONS(119),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(177),
    [anon_sym_COLON_COLON] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(177),
    [anon_sym_LT_COLON] = ACTIONS(177),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_try] = ACTIONS(439),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(443),
    [sym_break_statement] = ACTIONS(445),
    [sym_continue_statement] = ACTIONS(445),
    [anon_sym_return] = ACTIONS(447),
    [anon_sym_let] = ACTIONS(449),
    [anon_sym_const] = ACTIONS(451),
    [anon_sym_quote] = ACTIONS(453),
    [anon_sym_using] = ACTIONS(455),
    [anon_sym_import] = ACTIONS(455),
    [anon_sym_export] = ACTIONS(457),
    [anon_sym_COLON2] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_RBRACK] = ACTIONS(177),
    [anon_sym_begin] = ACTIONS(463),
    [anon_sym_GT_COLON] = ACTIONS(465),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_] = ACTIONS(465),
    [anon_sym_2] = ACTIONS(465),
    [anon_sym_3] = ACTIONS(465),
    [anon_sym_4] = ACTIONS(465),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(177),
    [anon_sym_LT_PIPE] = ACTIONS(177),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_QMARK] = ACTIONS(177),
    [anon_sym_EQ_GT] = ACTIONS(177),
    [anon_sym_LBRACK2] = ACTIONS(501),
    [anon_sym_DOLLAR] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(473),
    [sym_number] = ACTIONS(475),
    [anon_sym_DQUOTE] = ACTIONS(477),
    [sym_command_string] = ACTIONS(479),
    [sym_character] = ACTIONS(479),
    [sym__power_operator] = ACTIONS(481),
    [sym__times_operator] = ACTIONS(481),
    [sym__plus_operator] = ACTIONS(481),
    [sym__arrow_operator] = ACTIONS(177),
    [sym__comparison_operator] = ACTIONS(119),
    [sym__assign_operator] = ACTIONS(119),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(479),
    [sym__immediate_paren] = ACTIONS(529),
  },
  [30] = {
    [sym_function_definition] = STATE(2907),
    [sym_abstract_definition] = STATE(2907),
    [sym_primitive_definition] = STATE(2907),
    [sym_struct_definition] = STATE(2907),
    [sym_module_definition] = STATE(2907),
    [sym_macro_definition] = STATE(2907),
    [sym_parameter_list] = STATE(4876),
    [sym_if_statement] = STATE(2907),
    [sym_try_statement] = STATE(2907),
    [sym_for_statement] = STATE(2907),
    [sym_while_statement] = STATE(2907),
    [sym_return_statement] = STATE(2907),
    [sym_let_statement] = STATE(2907),
    [sym_const_statement] = STATE(2907),
    [sym_quote_statement] = STATE(2907),
    [sym_import_statement] = STATE(2907),
    [sym_export_statement] = STATE(2907),
    [sym__expression] = STATE(2932),
    [sym__primary_expression] = STATE(2646),
    [sym_operator] = STATE(2646),
    [sym_parenthesized_expression] = STATE(2646),
    [sym_field_expression] = STATE(2568),
    [sym_subscript_expression] = STATE(2646),
    [sym_typed_expression] = STATE(2907),
    [sym_parameterized_identifier] = STATE(2646),
    [sym_compound_expression] = STATE(2907),
    [sym_call_expression] = STATE(2646),
    [sym_broadcast_call_expression] = STATE(2646),
    [sym_macro_expression] = STATE(2907),
    [sym_spread_expression] = STATE(2907),
    [sym_unary_expression] = STATE(2907),
    [sym_binary_expression] = STATE(2907),
    [sym_ternary_expression] = STATE(2907),
    [sym_pair_expression] = STATE(2907),
    [sym_tuple_expression] = STATE(2646),
    [sym_array_expression] = STATE(2646),
    [sym_matrix_expression] = STATE(2646),
    [sym_generator_expression] = STATE(2907),
    [sym_array_comprehension_expression] = STATE(2646),
    [sym_function_expression] = STATE(2907),
    [sym_range_expression] = STATE(2907),
    [sym_coefficient_expression] = STATE(2907),
    [sym_quote_expression] = STATE(2907),
    [sym_interpolation_expression] = STATE(2907),
    [sym_macro_identifier] = STATE(29),
    [sym_string] = STATE(2646),
    [sym_identifier] = ACTIONS(531),
    [anon_sym_function] = ACTIONS(533),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(535),
    [anon_sym_primitive] = ACTIONS(537),
    [anon_sym_mutable] = ACTIONS(539),
    [anon_sym_struct] = ACTIONS(541),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_macro] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_COMMA] = ACTIONS(187),
    [anon_sym_RPAREN] = ACTIONS(187),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(187),
    [anon_sym_COLON_COLON] = ACTIONS(187),
    [anon_sym_RBRACE] = ACTIONS(187),
    [anon_sym_LT_COLON] = ACTIONS(187),
    [anon_sym_if] = ACTIONS(549),
    [anon_sym_try] = ACTIONS(551),
    [anon_sym_for] = ACTIONS(553),
    [anon_sym_while] = ACTIONS(555),
    [sym_break_statement] = ACTIONS(557),
    [sym_continue_statement] = ACTIONS(557),
    [anon_sym_return] = ACTIONS(559),
    [anon_sym_let] = ACTIONS(561),
    [anon_sym_const] = ACTIONS(563),
    [anon_sym_quote] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(567),
    [anon_sym_import] = ACTIONS(567),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(569),
    [anon_sym_COLON2] = ACTIONS(571),
    [anon_sym_PLUS] = ACTIONS(573),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_RBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(575),
    [anon_sym_GT_COLON] = ACTIONS(577),
    [anon_sym_DASH] = ACTIONS(579),
    [anon_sym_BANG] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(577),
    [anon_sym_] = ACTIONS(577),
    [anon_sym_2] = ACTIONS(577),
    [anon_sym_3] = ACTIONS(577),
    [anon_sym_4] = ACTIONS(577),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(187),
    [anon_sym_LT_PIPE] = ACTIONS(187),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(187),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_EQ_GT] = ACTIONS(187),
    [anon_sym_LBRACK2] = ACTIONS(581),
    [anon_sym_DOLLAR] = ACTIONS(583),
    [anon_sym_AT] = ACTIONS(473),
    [sym_number] = ACTIONS(585),
    [anon_sym_DQUOTE] = ACTIONS(587),
    [sym_command_string] = ACTIONS(589),
    [sym_character] = ACTIONS(589),
    [sym__power_operator] = ACTIONS(591),
    [sym__times_operator] = ACTIONS(591),
    [sym__plus_operator] = ACTIONS(591),
    [sym__arrow_operator] = ACTIONS(187),
    [sym__comparison_operator] = ACTIONS(185),
    [sym__assign_operator] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(589),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [31] = {
    [sym_function_definition] = STATE(1850),
    [sym_abstract_definition] = STATE(1850),
    [sym_primitive_definition] = STATE(1850),
    [sym_struct_definition] = STATE(1850),
    [sym_module_definition] = STATE(1850),
    [sym_macro_definition] = STATE(1850),
    [sym_parameter_list] = STATE(4697),
    [sym_if_statement] = STATE(1850),
    [sym_try_statement] = STATE(1850),
    [sym_for_statement] = STATE(1850),
    [sym_while_statement] = STATE(1850),
    [sym_return_statement] = STATE(1850),
    [sym_let_statement] = STATE(1850),
    [sym_const_statement] = STATE(1850),
    [sym_quote_statement] = STATE(1850),
    [sym_import_statement] = STATE(1850),
    [sym_export_statement] = STATE(1850),
    [sym__expression] = STATE(1766),
    [sym__primary_expression] = STATE(1423),
    [sym_operator] = STATE(1423),
    [sym_parenthesized_expression] = STATE(1423),
    [sym_field_expression] = STATE(1284),
    [sym_subscript_expression] = STATE(1423),
    [sym_typed_expression] = STATE(1850),
    [sym_parameterized_identifier] = STATE(1423),
    [sym_compound_expression] = STATE(1850),
    [sym_call_expression] = STATE(1423),
    [sym_broadcast_call_expression] = STATE(1423),
    [sym_macro_expression] = STATE(1850),
    [sym_macro_argument_list] = STATE(3001),
    [sym_spread_expression] = STATE(1850),
    [sym_unary_expression] = STATE(1850),
    [sym_binary_expression] = STATE(1850),
    [sym_ternary_expression] = STATE(1850),
    [sym_pair_expression] = STATE(1850),
    [sym_tuple_expression] = STATE(1423),
    [sym_array_expression] = STATE(1423),
    [sym_matrix_expression] = STATE(1423),
    [sym_generator_expression] = STATE(1850),
    [sym_array_comprehension_expression] = STATE(1423),
    [sym_function_expression] = STATE(1850),
    [sym_range_expression] = STATE(1850),
    [sym_coefficient_expression] = STATE(1850),
    [sym_quote_expression] = STATE(1850),
    [sym_interpolation_expression] = STATE(1850),
    [sym_macro_identifier] = STATE(43),
    [sym_string] = STATE(1423),
    [aux_sym_macro_argument_list_repeat1] = STATE(67),
    [sym_identifier] = ACTIONS(593),
    [anon_sym_function] = ACTIONS(595),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_primitive] = ACTIONS(599),
    [anon_sym_mutable] = ACTIONS(601),
    [anon_sym_struct] = ACTIONS(603),
    [anon_sym_module] = ACTIONS(605),
    [anon_sym_macro] = ACTIONS(607),
    [anon_sym_LPAREN] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(177),
    [anon_sym_COLON_COLON] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(177),
    [anon_sym_LT_COLON] = ACTIONS(177),
    [anon_sym_if] = ACTIONS(611),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_for] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(617),
    [sym_break_statement] = ACTIONS(619),
    [sym_continue_statement] = ACTIONS(619),
    [anon_sym_return] = ACTIONS(621),
    [anon_sym_let] = ACTIONS(623),
    [anon_sym_const] = ACTIONS(625),
    [anon_sym_quote] = ACTIONS(627),
    [anon_sym_using] = ACTIONS(629),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_export] = ACTIONS(631),
    [anon_sym_COLON2] = ACTIONS(633),
    [anon_sym_PLUS] = ACTIONS(635),
    [anon_sym_RBRACK] = ACTIONS(177),
    [anon_sym_begin] = ACTIONS(637),
    [anon_sym_GT_COLON] = ACTIONS(639),
    [anon_sym_DASH] = ACTIONS(641),
    [anon_sym_BANG] = ACTIONS(641),
    [anon_sym_TILDE] = ACTIONS(639),
    [anon_sym_] = ACTIONS(639),
    [anon_sym_2] = ACTIONS(639),
    [anon_sym_3] = ACTIONS(639),
    [anon_sym_4] = ACTIONS(639),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(177),
    [anon_sym_LT_PIPE] = ACTIONS(177),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_QMARK] = ACTIONS(177),
    [anon_sym_EQ_GT] = ACTIONS(177),
    [anon_sym_LBRACK2] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(645),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [sym_command_string] = ACTIONS(653),
    [sym_character] = ACTIONS(653),
    [sym__power_operator] = ACTIONS(655),
    [sym__times_operator] = ACTIONS(657),
    [sym__plus_operator] = ACTIONS(657),
    [sym__arrow_operator] = ACTIONS(177),
    [sym__comparison_operator] = ACTIONS(119),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(653),
    [sym__immediate_paren] = ACTIONS(659),
  },
  [32] = {
    [sym_function_definition] = STATE(3110),
    [sym_abstract_definition] = STATE(3110),
    [sym_primitive_definition] = STATE(3110),
    [sym_struct_definition] = STATE(3110),
    [sym_module_definition] = STATE(3110),
    [sym_macro_definition] = STATE(3110),
    [sym_parameter_list] = STATE(4631),
    [sym_if_statement] = STATE(3110),
    [sym_try_statement] = STATE(3110),
    [sym_for_statement] = STATE(3110),
    [sym_while_statement] = STATE(3110),
    [sym_return_statement] = STATE(3110),
    [sym_let_statement] = STATE(3110),
    [sym_const_statement] = STATE(3110),
    [sym_quote_statement] = STATE(3110),
    [sym_import_statement] = STATE(3110),
    [sym_export_statement] = STATE(3110),
    [sym__expression] = STATE(3083),
    [sym__primary_expression] = STATE(2793),
    [sym_operator] = STATE(2793),
    [sym_parenthesized_expression] = STATE(2793),
    [sym_field_expression] = STATE(2614),
    [sym_subscript_expression] = STATE(2793),
    [sym_typed_expression] = STATE(3110),
    [sym_parameterized_identifier] = STATE(2793),
    [sym_compound_expression] = STATE(3110),
    [sym_call_expression] = STATE(2793),
    [sym_broadcast_call_expression] = STATE(2793),
    [sym_macro_expression] = STATE(3110),
    [sym_spread_expression] = STATE(3110),
    [sym_unary_expression] = STATE(3110),
    [sym_binary_expression] = STATE(3110),
    [sym_ternary_expression] = STATE(3110),
    [sym_pair_expression] = STATE(3110),
    [sym_tuple_expression] = STATE(2793),
    [sym_array_expression] = STATE(2793),
    [sym_matrix_expression] = STATE(2793),
    [sym_generator_expression] = STATE(3110),
    [sym_array_comprehension_expression] = STATE(2793),
    [sym_function_expression] = STATE(3110),
    [sym_range_expression] = STATE(3110),
    [sym_coefficient_expression] = STATE(3110),
    [sym_quote_expression] = STATE(3110),
    [sym_interpolation_expression] = STATE(3110),
    [sym_macro_identifier] = STATE(31),
    [sym_string] = STATE(2793),
    [sym_identifier] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(665),
    [anon_sym_primitive] = ACTIONS(667),
    [anon_sym_mutable] = ACTIONS(669),
    [anon_sym_struct] = ACTIONS(671),
    [anon_sym_module] = ACTIONS(673),
    [anon_sym_macro] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(677),
    [anon_sym_COMMA] = ACTIONS(187),
    [anon_sym_RPAREN] = ACTIONS(187),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(187),
    [anon_sym_COLON_COLON] = ACTIONS(187),
    [anon_sym_RBRACE] = ACTIONS(187),
    [anon_sym_LT_COLON] = ACTIONS(187),
    [anon_sym_if] = ACTIONS(679),
    [anon_sym_try] = ACTIONS(681),
    [anon_sym_for] = ACTIONS(683),
    [anon_sym_while] = ACTIONS(685),
    [sym_break_statement] = ACTIONS(687),
    [sym_continue_statement] = ACTIONS(687),
    [anon_sym_return] = ACTIONS(689),
    [anon_sym_let] = ACTIONS(691),
    [anon_sym_const] = ACTIONS(693),
    [anon_sym_quote] = ACTIONS(695),
    [anon_sym_using] = ACTIONS(697),
    [anon_sym_import] = ACTIONS(697),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(699),
    [anon_sym_COLON2] = ACTIONS(701),
    [anon_sym_PLUS] = ACTIONS(703),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_RBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(705),
    [anon_sym_GT_COLON] = ACTIONS(707),
    [anon_sym_DASH] = ACTIONS(709),
    [anon_sym_BANG] = ACTIONS(709),
    [anon_sym_TILDE] = ACTIONS(707),
    [anon_sym_] = ACTIONS(707),
    [anon_sym_2] = ACTIONS(707),
    [anon_sym_3] = ACTIONS(707),
    [anon_sym_4] = ACTIONS(707),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(187),
    [anon_sym_LT_PIPE] = ACTIONS(187),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(187),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_EQ_GT] = ACTIONS(187),
    [anon_sym_LBRACK2] = ACTIONS(711),
    [anon_sym_DOLLAR] = ACTIONS(713),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(715),
    [anon_sym_DQUOTE] = ACTIONS(717),
    [sym_command_string] = ACTIONS(719),
    [sym_character] = ACTIONS(719),
    [sym__power_operator] = ACTIONS(721),
    [sym__times_operator] = ACTIONS(723),
    [sym__plus_operator] = ACTIONS(723),
    [sym__arrow_operator] = ACTIONS(187),
    [sym__comparison_operator] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(719),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [33] = {
    [sym_function_definition] = STATE(1578),
    [sym_abstract_definition] = STATE(1578),
    [sym_primitive_definition] = STATE(1578),
    [sym_struct_definition] = STATE(1578),
    [sym_module_definition] = STATE(1578),
    [sym_macro_definition] = STATE(1578),
    [sym_parameter_list] = STATE(5156),
    [sym_if_statement] = STATE(1578),
    [sym_try_statement] = STATE(1578),
    [sym_for_statement] = STATE(1578),
    [sym_while_statement] = STATE(1578),
    [sym_return_statement] = STATE(1578),
    [sym_let_statement] = STATE(1578),
    [sym_const_statement] = STATE(1578),
    [sym_quote_statement] = STATE(1578),
    [sym_import_statement] = STATE(1578),
    [sym_export_statement] = STATE(1578),
    [sym__expression] = STATE(1516),
    [sym__primary_expression] = STATE(1255),
    [sym_operator] = STATE(1255),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_field_expression] = STATE(1099),
    [sym_subscript_expression] = STATE(1255),
    [sym_typed_expression] = STATE(1578),
    [sym_parameterized_identifier] = STATE(1255),
    [sym_compound_expression] = STATE(1578),
    [sym_call_expression] = STATE(1255),
    [sym_broadcast_call_expression] = STATE(1255),
    [sym_macro_expression] = STATE(1578),
    [sym_spread_expression] = STATE(1578),
    [sym_unary_expression] = STATE(1578),
    [sym_binary_expression] = STATE(1578),
    [sym_ternary_expression] = STATE(1578),
    [sym_pair_expression] = STATE(1578),
    [sym_tuple_expression] = STATE(1255),
    [sym_array_expression] = STATE(1255),
    [sym_matrix_expression] = STATE(1255),
    [sym_generator_expression] = STATE(1578),
    [sym_array_comprehension_expression] = STATE(1255),
    [sym_function_expression] = STATE(1578),
    [sym_range_expression] = STATE(1578),
    [sym_coefficient_expression] = STATE(1578),
    [sym_quote_expression] = STATE(1578),
    [sym_interpolation_expression] = STATE(1578),
    [sym_macro_identifier] = STATE(24),
    [sym_string] = STATE(1255),
    [aux_sym_macro_argument_list_repeat1] = STATE(33),
    [sym_identifier] = ACTIONS(725),
    [anon_sym_function] = ACTIONS(728),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_abstract] = ACTIONS(731),
    [anon_sym_primitive] = ACTIONS(734),
    [anon_sym_mutable] = ACTIONS(737),
    [anon_sym_struct] = ACTIONS(740),
    [anon_sym_module] = ACTIONS(743),
    [anon_sym_macro] = ACTIONS(746),
    [anon_sym_LPAREN] = ACTIONS(749),
    [anon_sym_COMMA] = ACTIONS(292),
    [anon_sym_RPAREN] = ACTIONS(292),
    [anon_sym_SEMI] = ACTIONS(292),
    [anon_sym_EQ] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(292),
    [anon_sym_COLON_COLON] = ACTIONS(292),
    [anon_sym_RBRACE] = ACTIONS(292),
    [anon_sym_LT_COLON] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(752),
    [anon_sym_try] = ACTIONS(755),
    [anon_sym_for] = ACTIONS(758),
    [anon_sym_while] = ACTIONS(761),
    [sym_break_statement] = ACTIONS(764),
    [sym_continue_statement] = ACTIONS(764),
    [anon_sym_return] = ACTIONS(767),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_const] = ACTIONS(773),
    [anon_sym_quote] = ACTIONS(776),
    [anon_sym_using] = ACTIONS(779),
    [anon_sym_import] = ACTIONS(779),
    [anon_sym_export] = ACTIONS(782),
    [anon_sym_COLON2] = ACTIONS(785),
    [anon_sym_PLUS] = ACTIONS(788),
    [anon_sym_RBRACK] = ACTIONS(292),
    [anon_sym_begin] = ACTIONS(791),
    [anon_sym_GT_COLON] = ACTIONS(794),
    [anon_sym_DASH] = ACTIONS(797),
    [anon_sym_BANG] = ACTIONS(797),
    [anon_sym_TILDE] = ACTIONS(794),
    [anon_sym_] = ACTIONS(794),
    [anon_sym_2] = ACTIONS(794),
    [anon_sym_3] = ACTIONS(794),
    [anon_sym_4] = ACTIONS(794),
    [anon_sym_SQUOTE] = ACTIONS(203),
    [anon_sym_DOT_SQUOTE] = ACTIONS(292),
    [anon_sym_LT_PIPE] = ACTIONS(292),
    [anon_sym_PIPE_GT] = ACTIONS(203),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(292),
    [anon_sym_QMARK] = ACTIONS(292),
    [anon_sym_EQ_GT] = ACTIONS(292),
    [anon_sym_LBRACK2] = ACTIONS(800),
    [anon_sym_DOLLAR] = ACTIONS(803),
    [anon_sym_AT] = ACTIONS(806),
    [sym_number] = ACTIONS(809),
    [anon_sym_DQUOTE] = ACTIONS(812),
    [sym_command_string] = ACTIONS(815),
    [sym_character] = ACTIONS(815),
    [sym__power_operator] = ACTIONS(818),
    [sym__times_operator] = ACTIONS(818),
    [sym__plus_operator] = ACTIONS(818),
    [sym__arrow_operator] = ACTIONS(292),
    [sym__comparison_operator] = ACTIONS(203),
    [sym__assign_operator] = ACTIONS(203),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(815),
  },
  [34] = {
    [sym_function_definition] = STATE(2907),
    [sym_abstract_definition] = STATE(2907),
    [sym_primitive_definition] = STATE(2907),
    [sym_struct_definition] = STATE(2907),
    [sym_module_definition] = STATE(2907),
    [sym_macro_definition] = STATE(2907),
    [sym_parameter_list] = STATE(4876),
    [sym_if_statement] = STATE(2907),
    [sym_try_statement] = STATE(2907),
    [sym_for_statement] = STATE(2907),
    [sym_while_statement] = STATE(2907),
    [sym_return_statement] = STATE(2907),
    [sym_let_statement] = STATE(2907),
    [sym_const_statement] = STATE(2907),
    [sym_quote_statement] = STATE(2907),
    [sym_import_statement] = STATE(2907),
    [sym_export_statement] = STATE(2907),
    [sym__expression] = STATE(2918),
    [sym__primary_expression] = STATE(2646),
    [sym_bare_tuple_expression] = STATE(2919),
    [sym_operator] = STATE(2646),
    [sym_parenthesized_expression] = STATE(2646),
    [sym_field_expression] = STATE(2568),
    [sym_subscript_expression] = STATE(2646),
    [sym_typed_expression] = STATE(2907),
    [sym_parameterized_identifier] = STATE(2646),
    [sym_compound_expression] = STATE(2907),
    [sym_call_expression] = STATE(2646),
    [sym_broadcast_call_expression] = STATE(2646),
    [sym_macro_expression] = STATE(2907),
    [sym_spread_expression] = STATE(2907),
    [sym_unary_expression] = STATE(2907),
    [sym_binary_expression] = STATE(2907),
    [sym_ternary_expression] = STATE(2907),
    [sym_pair_expression] = STATE(2907),
    [sym_tuple_expression] = STATE(2646),
    [sym_array_expression] = STATE(2646),
    [sym_matrix_expression] = STATE(2646),
    [sym_generator_expression] = STATE(2907),
    [sym_array_comprehension_expression] = STATE(2646),
    [sym_function_expression] = STATE(2907),
    [sym_range_expression] = STATE(2907),
    [sym_coefficient_expression] = STATE(2907),
    [sym_quote_expression] = STATE(2907),
    [sym_interpolation_expression] = STATE(2907),
    [sym_macro_identifier] = STATE(29),
    [sym_string] = STATE(2646),
    [sym_identifier] = ACTIONS(531),
    [anon_sym_function] = ACTIONS(533),
    [anon_sym_end] = ACTIONS(189),
    [anon_sym_abstract] = ACTIONS(535),
    [anon_sym_primitive] = ACTIONS(537),
    [anon_sym_mutable] = ACTIONS(539),
    [anon_sym_struct] = ACTIONS(541),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_macro] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_COMMA] = ACTIONS(191),
    [anon_sym_RPAREN] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(191),
    [anon_sym_EQ] = ACTIONS(189),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(191),
    [anon_sym_RBRACE] = ACTIONS(191),
    [anon_sym_LT_COLON] = ACTIONS(191),
    [anon_sym_if] = ACTIONS(549),
    [anon_sym_try] = ACTIONS(551),
    [anon_sym_for] = ACTIONS(553),
    [anon_sym_while] = ACTIONS(555),
    [sym_break_statement] = ACTIONS(557),
    [sym_continue_statement] = ACTIONS(557),
    [anon_sym_return] = ACTIONS(559),
    [anon_sym_let] = ACTIONS(561),
    [anon_sym_const] = ACTIONS(563),
    [anon_sym_quote] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(567),
    [anon_sym_import] = ACTIONS(567),
    [anon_sym_export] = ACTIONS(569),
    [anon_sym_COLON2] = ACTIONS(571),
    [anon_sym_PLUS] = ACTIONS(573),
    [anon_sym_RBRACK] = ACTIONS(191),
    [anon_sym_begin] = ACTIONS(575),
    [anon_sym_GT_COLON] = ACTIONS(577),
    [anon_sym_DASH] = ACTIONS(579),
    [anon_sym_BANG] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(577),
    [anon_sym_] = ACTIONS(577),
    [anon_sym_2] = ACTIONS(577),
    [anon_sym_3] = ACTIONS(577),
    [anon_sym_4] = ACTIONS(577),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DOT_SQUOTE] = ACTIONS(191),
    [anon_sym_LT_PIPE] = ACTIONS(191),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_in] = ACTIONS(189),
    [anon_sym_isa] = ACTIONS(189),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(191),
    [anon_sym_QMARK] = ACTIONS(191),
    [anon_sym_EQ_GT] = ACTIONS(191),
    [anon_sym_LBRACK2] = ACTIONS(821),
    [anon_sym_DOLLAR] = ACTIONS(583),
    [anon_sym_AT] = ACTIONS(473),
    [sym_number] = ACTIONS(585),
    [anon_sym_DQUOTE] = ACTIONS(587),
    [sym_command_string] = ACTIONS(589),
    [sym_character] = ACTIONS(589),
    [sym__power_operator] = ACTIONS(591),
    [sym__times_operator] = ACTIONS(591),
    [sym__plus_operator] = ACTIONS(591),
    [sym__arrow_operator] = ACTIONS(191),
    [sym__comparison_operator] = ACTIONS(189),
    [sym__assign_operator] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(589),
  },
  [35] = {
    [sym_function_definition] = STATE(1578),
    [sym_abstract_definition] = STATE(1578),
    [sym_primitive_definition] = STATE(1578),
    [sym_struct_definition] = STATE(1578),
    [sym_module_definition] = STATE(1578),
    [sym_macro_definition] = STATE(1578),
    [sym_parameter_list] = STATE(5156),
    [sym_if_statement] = STATE(1578),
    [sym_try_statement] = STATE(1578),
    [sym_for_statement] = STATE(1578),
    [sym_while_statement] = STATE(1578),
    [sym_return_statement] = STATE(1578),
    [sym_let_statement] = STATE(1578),
    [sym_const_statement] = STATE(1578),
    [sym_quote_statement] = STATE(1578),
    [sym_import_statement] = STATE(1578),
    [sym_export_statement] = STATE(1578),
    [sym__expression] = STATE(1489),
    [sym__primary_expression] = STATE(1255),
    [sym_bare_tuple_expression] = STATE(1524),
    [sym_operator] = STATE(1255),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_field_expression] = STATE(1099),
    [sym_subscript_expression] = STATE(1255),
    [sym_typed_expression] = STATE(1578),
    [sym_parameterized_identifier] = STATE(1255),
    [sym_compound_expression] = STATE(1578),
    [sym_call_expression] = STATE(1255),
    [sym_broadcast_call_expression] = STATE(1255),
    [sym_macro_expression] = STATE(1578),
    [sym_spread_expression] = STATE(1578),
    [sym_unary_expression] = STATE(1578),
    [sym_binary_expression] = STATE(1578),
    [sym_ternary_expression] = STATE(1578),
    [sym_pair_expression] = STATE(1578),
    [sym_tuple_expression] = STATE(1255),
    [sym_array_expression] = STATE(1255),
    [sym_matrix_expression] = STATE(1255),
    [sym_generator_expression] = STATE(1578),
    [sym_array_comprehension_expression] = STATE(1255),
    [sym_function_expression] = STATE(1578),
    [sym_range_expression] = STATE(1578),
    [sym_coefficient_expression] = STATE(1578),
    [sym_quote_expression] = STATE(1578),
    [sym_interpolation_expression] = STATE(1578),
    [sym_macro_identifier] = STATE(24),
    [sym_string] = STATE(1255),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(421),
    [anon_sym_end] = ACTIONS(189),
    [anon_sym_abstract] = ACTIONS(423),
    [anon_sym_primitive] = ACTIONS(425),
    [anon_sym_mutable] = ACTIONS(427),
    [anon_sym_struct] = ACTIONS(429),
    [anon_sym_module] = ACTIONS(431),
    [anon_sym_macro] = ACTIONS(433),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(191),
    [anon_sym_RPAREN] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(191),
    [anon_sym_EQ] = ACTIONS(189),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(191),
    [anon_sym_RBRACE] = ACTIONS(191),
    [anon_sym_LT_COLON] = ACTIONS(191),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_try] = ACTIONS(439),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(443),
    [sym_break_statement] = ACTIONS(445),
    [sym_continue_statement] = ACTIONS(445),
    [anon_sym_return] = ACTIONS(447),
    [anon_sym_let] = ACTIONS(449),
    [anon_sym_const] = ACTIONS(451),
    [anon_sym_quote] = ACTIONS(453),
    [anon_sym_using] = ACTIONS(455),
    [anon_sym_import] = ACTIONS(455),
    [anon_sym_export] = ACTIONS(457),
    [anon_sym_COLON2] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_RBRACK] = ACTIONS(191),
    [anon_sym_begin] = ACTIONS(463),
    [anon_sym_GT_COLON] = ACTIONS(465),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_] = ACTIONS(465),
    [anon_sym_2] = ACTIONS(465),
    [anon_sym_3] = ACTIONS(465),
    [anon_sym_4] = ACTIONS(465),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DOT_SQUOTE] = ACTIONS(191),
    [anon_sym_LT_PIPE] = ACTIONS(191),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_in] = ACTIONS(189),
    [anon_sym_isa] = ACTIONS(189),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(191),
    [anon_sym_QMARK] = ACTIONS(191),
    [anon_sym_EQ_GT] = ACTIONS(191),
    [anon_sym_LBRACK2] = ACTIONS(501),
    [anon_sym_DOLLAR] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(473),
    [sym_number] = ACTIONS(475),
    [anon_sym_DQUOTE] = ACTIONS(477),
    [sym_command_string] = ACTIONS(479),
    [sym_character] = ACTIONS(479),
    [sym__power_operator] = ACTIONS(481),
    [sym__times_operator] = ACTIONS(481),
    [sym__plus_operator] = ACTIONS(481),
    [sym__arrow_operator] = ACTIONS(191),
    [sym__comparison_operator] = ACTIONS(189),
    [sym__assign_operator] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(479),
  },
  [36] = {
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5050),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2755),
    [sym__primary_expression] = STATE(2565),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(40),
    [sym_string] = STATE(2565),
    [ts_builtin_sym_end] = ACTIONS(187),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(185),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [anon_sym_LT_COLON] = ACTIONS(185),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(35),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(39),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(823),
    [anon_sym_PLUS] = ACTIONS(825),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(827),
    [anon_sym_DASH] = ACTIONS(827),
    [anon_sym_BANG] = ACTIONS(827),
    [anon_sym_TILDE] = ACTIONS(827),
    [anon_sym_] = ACTIONS(827),
    [anon_sym_2] = ACTIONS(827),
    [anon_sym_3] = ACTIONS(827),
    [anon_sym_4] = ACTIONS(827),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(185),
    [anon_sym_EQ_GT] = ACTIONS(185),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [anon_sym_AT] = ACTIONS(831),
    [sym_number] = ACTIONS(833),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(69),
    [sym__plus_operator] = ACTIONS(69),
    [sym__arrow_operator] = ACTIONS(185),
    [sym__comparison_operator] = ACTIONS(185),
    [sym__assign_operator] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(187),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [37] = {
    [sym_function_definition] = STATE(1850),
    [sym_abstract_definition] = STATE(1850),
    [sym_primitive_definition] = STATE(1850),
    [sym_struct_definition] = STATE(1850),
    [sym_module_definition] = STATE(1850),
    [sym_macro_definition] = STATE(1850),
    [sym_parameter_list] = STATE(4697),
    [sym_if_statement] = STATE(1850),
    [sym_try_statement] = STATE(1850),
    [sym_for_statement] = STATE(1850),
    [sym_while_statement] = STATE(1850),
    [sym_return_statement] = STATE(1850),
    [sym_let_statement] = STATE(1850),
    [sym_const_statement] = STATE(1850),
    [sym_quote_statement] = STATE(1850),
    [sym_import_statement] = STATE(1850),
    [sym_export_statement] = STATE(1850),
    [sym__expression] = STATE(1861),
    [sym__primary_expression] = STATE(1423),
    [sym_operator] = STATE(1423),
    [sym_parenthesized_expression] = STATE(1423),
    [sym_field_expression] = STATE(1284),
    [sym_subscript_expression] = STATE(1423),
    [sym_typed_expression] = STATE(1850),
    [sym_parameterized_identifier] = STATE(1423),
    [sym_compound_expression] = STATE(1850),
    [sym_call_expression] = STATE(1423),
    [sym_broadcast_call_expression] = STATE(1423),
    [sym_macro_expression] = STATE(1850),
    [sym_spread_expression] = STATE(1850),
    [sym_unary_expression] = STATE(1850),
    [sym_binary_expression] = STATE(1850),
    [sym_ternary_expression] = STATE(1850),
    [sym_pair_expression] = STATE(1850),
    [sym_tuple_expression] = STATE(1423),
    [sym_array_expression] = STATE(1423),
    [sym_matrix_expression] = STATE(1423),
    [sym_generator_expression] = STATE(1850),
    [sym_array_comprehension_expression] = STATE(1423),
    [sym_function_expression] = STATE(1850),
    [sym_range_expression] = STATE(1850),
    [sym_coefficient_expression] = STATE(1850),
    [sym_quote_expression] = STATE(1850),
    [sym_interpolation_expression] = STATE(1850),
    [sym_macro_identifier] = STATE(43),
    [sym_string] = STATE(1423),
    [sym_identifier] = ACTIONS(593),
    [anon_sym_function] = ACTIONS(595),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_primitive] = ACTIONS(599),
    [anon_sym_mutable] = ACTIONS(601),
    [anon_sym_struct] = ACTIONS(603),
    [anon_sym_module] = ACTIONS(605),
    [anon_sym_macro] = ACTIONS(607),
    [anon_sym_LPAREN] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(187),
    [anon_sym_RPAREN] = ACTIONS(187),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(187),
    [anon_sym_COLON_COLON] = ACTIONS(187),
    [anon_sym_RBRACE] = ACTIONS(187),
    [anon_sym_LT_COLON] = ACTIONS(187),
    [anon_sym_if] = ACTIONS(611),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_for] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(617),
    [sym_break_statement] = ACTIONS(619),
    [sym_continue_statement] = ACTIONS(619),
    [anon_sym_return] = ACTIONS(621),
    [anon_sym_let] = ACTIONS(623),
    [anon_sym_const] = ACTIONS(625),
    [anon_sym_quote] = ACTIONS(627),
    [anon_sym_using] = ACTIONS(629),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(631),
    [anon_sym_COLON2] = ACTIONS(633),
    [anon_sym_PLUS] = ACTIONS(635),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_RBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(637),
    [anon_sym_GT_COLON] = ACTIONS(639),
    [anon_sym_DASH] = ACTIONS(641),
    [anon_sym_BANG] = ACTIONS(641),
    [anon_sym_TILDE] = ACTIONS(639),
    [anon_sym_] = ACTIONS(639),
    [anon_sym_2] = ACTIONS(639),
    [anon_sym_3] = ACTIONS(639),
    [anon_sym_4] = ACTIONS(639),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(187),
    [anon_sym_LT_PIPE] = ACTIONS(187),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(187),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_EQ_GT] = ACTIONS(187),
    [anon_sym_LBRACK2] = ACTIONS(835),
    [anon_sym_DOLLAR] = ACTIONS(645),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [sym_command_string] = ACTIONS(653),
    [sym_character] = ACTIONS(653),
    [sym__power_operator] = ACTIONS(655),
    [sym__times_operator] = ACTIONS(657),
    [sym__plus_operator] = ACTIONS(657),
    [sym__arrow_operator] = ACTIONS(187),
    [sym__comparison_operator] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(653),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [38] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4936),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(1913),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_macro_argument_list] = STATE(1775),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(38),
    [sym_string] = STATE(1466),
    [aux_sym_macro_argument_list_repeat1] = STATE(58),
    [sym_identifier] = ACTIONS(837),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_primitive] = ACTIONS(307),
    [anon_sym_mutable] = ACTIONS(309),
    [anon_sym_struct] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(313),
    [anon_sym_macro] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(119),
    [anon_sym_SEMI] = ACTIONS(119),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(119),
    [anon_sym_COLON_COLON] = ACTIONS(119),
    [anon_sym_LT_COLON] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_elseif] = ACTIONS(119),
    [anon_sym_else] = ACTIONS(119),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [sym_break_statement] = ACTIONS(327),
    [sym_continue_statement] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_quote] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(337),
    [anon_sym_import] = ACTIONS(337),
    [anon_sym_export] = ACTIONS(339),
    [anon_sym_COLON2] = ACTIONS(839),
    [anon_sym_PLUS] = ACTIONS(841),
    [anon_sym_begin] = ACTIONS(345),
    [anon_sym_GT_COLON] = ACTIONS(843),
    [anon_sym_DASH] = ACTIONS(843),
    [anon_sym_BANG] = ACTIONS(843),
    [anon_sym_TILDE] = ACTIONS(843),
    [anon_sym_] = ACTIONS(843),
    [anon_sym_2] = ACTIONS(843),
    [anon_sym_3] = ACTIONS(843),
    [anon_sym_4] = ACTIONS(843),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(119),
    [anon_sym_LT_PIPE] = ACTIONS(119),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(119),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(119),
    [anon_sym_LBRACK2] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(845),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_command_string] = ACTIONS(359),
    [sym_character] = ACTIONS(359),
    [sym__power_operator] = ACTIONS(361),
    [sym__times_operator] = ACTIONS(361),
    [sym__plus_operator] = ACTIONS(361),
    [sym__arrow_operator] = ACTIONS(119),
    [sym__comparison_operator] = ACTIONS(119),
    [anon_sym_LF] = ACTIONS(177),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(363),
    [sym__immediate_paren] = ACTIONS(847),
  },
  [39] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4936),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(1779),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(38),
    [sym_string] = STATE(1466),
    [sym_identifier] = ACTIONS(837),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_primitive] = ACTIONS(307),
    [anon_sym_mutable] = ACTIONS(309),
    [anon_sym_struct] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(313),
    [anon_sym_macro] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(185),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [anon_sym_LT_COLON] = ACTIONS(185),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_elseif] = ACTIONS(185),
    [anon_sym_else] = ACTIONS(185),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [sym_break_statement] = ACTIONS(327),
    [sym_continue_statement] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_quote] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(337),
    [anon_sym_import] = ACTIONS(337),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(339),
    [anon_sym_COLON2] = ACTIONS(839),
    [anon_sym_PLUS] = ACTIONS(841),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(345),
    [anon_sym_GT_COLON] = ACTIONS(843),
    [anon_sym_DASH] = ACTIONS(843),
    [anon_sym_BANG] = ACTIONS(843),
    [anon_sym_TILDE] = ACTIONS(843),
    [anon_sym_] = ACTIONS(843),
    [anon_sym_2] = ACTIONS(843),
    [anon_sym_3] = ACTIONS(843),
    [anon_sym_4] = ACTIONS(843),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(185),
    [anon_sym_EQ_GT] = ACTIONS(185),
    [anon_sym_LBRACK2] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(845),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_command_string] = ACTIONS(359),
    [sym_character] = ACTIONS(359),
    [sym__power_operator] = ACTIONS(361),
    [sym__times_operator] = ACTIONS(361),
    [sym__plus_operator] = ACTIONS(361),
    [sym__arrow_operator] = ACTIONS(185),
    [sym__comparison_operator] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(187),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(363),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [40] = {
    [sym_function_definition] = STATE(1982),
    [sym_abstract_definition] = STATE(1982),
    [sym_primitive_definition] = STATE(1982),
    [sym_struct_definition] = STATE(1982),
    [sym_module_definition] = STATE(1982),
    [sym_macro_definition] = STATE(1982),
    [sym_parameter_list] = STATE(5092),
    [sym_if_statement] = STATE(1982),
    [sym_try_statement] = STATE(1982),
    [sym_for_statement] = STATE(1982),
    [sym_while_statement] = STATE(1982),
    [sym_return_statement] = STATE(1982),
    [sym_let_statement] = STATE(1982),
    [sym_const_statement] = STATE(1982),
    [sym_quote_statement] = STATE(1982),
    [sym_import_statement] = STATE(1982),
    [sym_export_statement] = STATE(1982),
    [sym__expression] = STATE(1981),
    [sym__primary_expression] = STATE(1495),
    [sym_operator] = STATE(1495),
    [sym_parenthesized_expression] = STATE(1495),
    [sym_field_expression] = STATE(1192),
    [sym_subscript_expression] = STATE(1495),
    [sym_typed_expression] = STATE(1982),
    [sym_parameterized_identifier] = STATE(1495),
    [sym_compound_expression] = STATE(1982),
    [sym_call_expression] = STATE(1495),
    [sym_broadcast_call_expression] = STATE(1495),
    [sym_macro_expression] = STATE(1982),
    [sym_macro_argument_list] = STATE(2716),
    [sym_spread_expression] = STATE(1982),
    [sym_unary_expression] = STATE(1982),
    [sym_binary_expression] = STATE(1982),
    [sym_ternary_expression] = STATE(1982),
    [sym_pair_expression] = STATE(1982),
    [sym_tuple_expression] = STATE(1495),
    [sym_array_expression] = STATE(1495),
    [sym_matrix_expression] = STATE(1495),
    [sym_generator_expression] = STATE(1982),
    [sym_array_comprehension_expression] = STATE(1495),
    [sym_function_expression] = STATE(1982),
    [sym_range_expression] = STATE(1982),
    [sym_coefficient_expression] = STATE(1982),
    [sym_quote_expression] = STATE(1982),
    [sym_interpolation_expression] = STATE(1982),
    [sym_macro_identifier] = STATE(44),
    [sym_string] = STATE(1495),
    [aux_sym_macro_argument_list_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(177),
    [sym_identifier] = ACTIONS(849),
    [anon_sym_function] = ACTIONS(851),
    [anon_sym_abstract] = ACTIONS(853),
    [anon_sym_primitive] = ACTIONS(855),
    [anon_sym_mutable] = ACTIONS(857),
    [anon_sym_struct] = ACTIONS(859),
    [anon_sym_module] = ACTIONS(861),
    [anon_sym_macro] = ACTIONS(863),
    [anon_sym_LPAREN] = ACTIONS(865),
    [anon_sym_COMMA] = ACTIONS(119),
    [anon_sym_SEMI] = ACTIONS(119),
    [anon_sym_EQ] = ACTIONS(119),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(119),
    [anon_sym_COLON_COLON] = ACTIONS(119),
    [anon_sym_LT_COLON] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(867),
    [anon_sym_try] = ACTIONS(869),
    [anon_sym_for] = ACTIONS(871),
    [anon_sym_while] = ACTIONS(873),
    [sym_break_statement] = ACTIONS(875),
    [sym_continue_statement] = ACTIONS(875),
    [anon_sym_return] = ACTIONS(877),
    [anon_sym_let] = ACTIONS(879),
    [anon_sym_const] = ACTIONS(881),
    [anon_sym_quote] = ACTIONS(883),
    [anon_sym_using] = ACTIONS(885),
    [anon_sym_import] = ACTIONS(885),
    [anon_sym_export] = ACTIONS(887),
    [anon_sym_COLON2] = ACTIONS(889),
    [anon_sym_PLUS] = ACTIONS(891),
    [anon_sym_begin] = ACTIONS(893),
    [anon_sym_GT_COLON] = ACTIONS(895),
    [anon_sym_DASH] = ACTIONS(895),
    [anon_sym_BANG] = ACTIONS(895),
    [anon_sym_TILDE] = ACTIONS(895),
    [anon_sym_] = ACTIONS(895),
    [anon_sym_2] = ACTIONS(895),
    [anon_sym_3] = ACTIONS(895),
    [anon_sym_4] = ACTIONS(895),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(119),
    [anon_sym_LT_PIPE] = ACTIONS(119),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(119),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(119),
    [anon_sym_LBRACK2] = ACTIONS(897),
    [anon_sym_DOLLAR] = ACTIONS(899),
    [anon_sym_AT] = ACTIONS(831),
    [sym_number] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(903),
    [sym_command_string] = ACTIONS(905),
    [sym_character] = ACTIONS(905),
    [sym__power_operator] = ACTIONS(907),
    [sym__times_operator] = ACTIONS(907),
    [sym__plus_operator] = ACTIONS(907),
    [sym__arrow_operator] = ACTIONS(119),
    [sym__comparison_operator] = ACTIONS(119),
    [sym__assign_operator] = ACTIONS(119),
    [anon_sym_LF] = ACTIONS(177),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(909),
    [sym__immediate_paren] = ACTIONS(183),
  },
  [41] = {
    [sym_function_definition] = STATE(1578),
    [sym_abstract_definition] = STATE(1578),
    [sym_primitive_definition] = STATE(1578),
    [sym_struct_definition] = STATE(1578),
    [sym_module_definition] = STATE(1578),
    [sym_macro_definition] = STATE(1578),
    [sym_parameter_list] = STATE(5156),
    [sym_if_statement] = STATE(1578),
    [sym_try_statement] = STATE(1578),
    [sym_for_statement] = STATE(1578),
    [sym_while_statement] = STATE(1578),
    [sym_return_statement] = STATE(1578),
    [sym_let_statement] = STATE(1578),
    [sym_const_statement] = STATE(1578),
    [sym_quote_statement] = STATE(1578),
    [sym_import_statement] = STATE(1578),
    [sym_export_statement] = STATE(1578),
    [sym__expression] = STATE(1516),
    [sym__primary_expression] = STATE(1255),
    [sym_operator] = STATE(1255),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_field_expression] = STATE(1099),
    [sym_subscript_expression] = STATE(1255),
    [sym_typed_expression] = STATE(1578),
    [sym_parameterized_identifier] = STATE(1255),
    [sym_compound_expression] = STATE(1578),
    [sym_call_expression] = STATE(1255),
    [sym_broadcast_call_expression] = STATE(1255),
    [sym_macro_expression] = STATE(1578),
    [sym_spread_expression] = STATE(1578),
    [sym_unary_expression] = STATE(1578),
    [sym_binary_expression] = STATE(1578),
    [sym_ternary_expression] = STATE(1578),
    [sym_pair_expression] = STATE(1578),
    [sym_tuple_expression] = STATE(1255),
    [sym_array_expression] = STATE(1255),
    [sym_matrix_expression] = STATE(1255),
    [sym_generator_expression] = STATE(1578),
    [sym_array_comprehension_expression] = STATE(1255),
    [sym_function_expression] = STATE(1578),
    [sym_range_expression] = STATE(1578),
    [sym_coefficient_expression] = STATE(1578),
    [sym_quote_expression] = STATE(1578),
    [sym_interpolation_expression] = STATE(1578),
    [sym_macro_identifier] = STATE(24),
    [sym_string] = STATE(1255),
    [aux_sym_macro_argument_list_repeat1] = STATE(33),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(421),
    [anon_sym_end] = ACTIONS(193),
    [anon_sym_abstract] = ACTIONS(423),
    [anon_sym_primitive] = ACTIONS(425),
    [anon_sym_mutable] = ACTIONS(427),
    [anon_sym_struct] = ACTIONS(429),
    [anon_sym_module] = ACTIONS(431),
    [anon_sym_macro] = ACTIONS(433),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(195),
    [anon_sym_RPAREN] = ACTIONS(195),
    [anon_sym_SEMI] = ACTIONS(195),
    [anon_sym_EQ] = ACTIONS(193),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(195),
    [anon_sym_COLON_COLON] = ACTIONS(195),
    [anon_sym_RBRACE] = ACTIONS(195),
    [anon_sym_LT_COLON] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_try] = ACTIONS(439),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(443),
    [sym_break_statement] = ACTIONS(445),
    [sym_continue_statement] = ACTIONS(445),
    [anon_sym_return] = ACTIONS(447),
    [anon_sym_let] = ACTIONS(449),
    [anon_sym_const] = ACTIONS(451),
    [anon_sym_quote] = ACTIONS(453),
    [anon_sym_using] = ACTIONS(455),
    [anon_sym_import] = ACTIONS(455),
    [anon_sym_export] = ACTIONS(457),
    [anon_sym_COLON2] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_RBRACK] = ACTIONS(195),
    [anon_sym_begin] = ACTIONS(463),
    [anon_sym_GT_COLON] = ACTIONS(465),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_] = ACTIONS(465),
    [anon_sym_2] = ACTIONS(465),
    [anon_sym_3] = ACTIONS(465),
    [anon_sym_4] = ACTIONS(465),
    [anon_sym_SQUOTE] = ACTIONS(193),
    [anon_sym_DOT_SQUOTE] = ACTIONS(195),
    [anon_sym_LT_PIPE] = ACTIONS(195),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(195),
    [anon_sym_QMARK] = ACTIONS(195),
    [anon_sym_EQ_GT] = ACTIONS(195),
    [anon_sym_LBRACK2] = ACTIONS(501),
    [anon_sym_DOLLAR] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(473),
    [sym_number] = ACTIONS(475),
    [anon_sym_DQUOTE] = ACTIONS(477),
    [sym_command_string] = ACTIONS(479),
    [sym_character] = ACTIONS(479),
    [sym__power_operator] = ACTIONS(481),
    [sym__times_operator] = ACTIONS(481),
    [sym__plus_operator] = ACTIONS(481),
    [sym__arrow_operator] = ACTIONS(195),
    [sym__comparison_operator] = ACTIONS(193),
    [sym__assign_operator] = ACTIONS(193),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(479),
  },
  [42] = {
    [sym_function_definition] = STATE(1982),
    [sym_abstract_definition] = STATE(1982),
    [sym_primitive_definition] = STATE(1982),
    [sym_struct_definition] = STATE(1982),
    [sym_module_definition] = STATE(1982),
    [sym_macro_definition] = STATE(1982),
    [sym_parameter_list] = STATE(5092),
    [sym_if_statement] = STATE(1982),
    [sym_try_statement] = STATE(1982),
    [sym_for_statement] = STATE(1982),
    [sym_while_statement] = STATE(1982),
    [sym_return_statement] = STATE(1982),
    [sym_let_statement] = STATE(1982),
    [sym_const_statement] = STATE(1982),
    [sym_quote_statement] = STATE(1982),
    [sym_import_statement] = STATE(1982),
    [sym_export_statement] = STATE(1982),
    [sym__expression] = STATE(1987),
    [sym__primary_expression] = STATE(1495),
    [sym_operator] = STATE(1495),
    [sym_parenthesized_expression] = STATE(1495),
    [sym_field_expression] = STATE(1192),
    [sym_subscript_expression] = STATE(1495),
    [sym_typed_expression] = STATE(1982),
    [sym_parameterized_identifier] = STATE(1495),
    [sym_compound_expression] = STATE(1982),
    [sym_call_expression] = STATE(1495),
    [sym_broadcast_call_expression] = STATE(1495),
    [sym_macro_expression] = STATE(1982),
    [sym_spread_expression] = STATE(1982),
    [sym_unary_expression] = STATE(1982),
    [sym_binary_expression] = STATE(1982),
    [sym_ternary_expression] = STATE(1982),
    [sym_pair_expression] = STATE(1982),
    [sym_tuple_expression] = STATE(1495),
    [sym_array_expression] = STATE(1495),
    [sym_matrix_expression] = STATE(1495),
    [sym_generator_expression] = STATE(1982),
    [sym_array_comprehension_expression] = STATE(1495),
    [sym_function_expression] = STATE(1982),
    [sym_range_expression] = STATE(1982),
    [sym_coefficient_expression] = STATE(1982),
    [sym_quote_expression] = STATE(1982),
    [sym_interpolation_expression] = STATE(1982),
    [sym_macro_identifier] = STATE(44),
    [sym_string] = STATE(1495),
    [ts_builtin_sym_end] = ACTIONS(187),
    [sym_identifier] = ACTIONS(849),
    [anon_sym_function] = ACTIONS(851),
    [anon_sym_abstract] = ACTIONS(853),
    [anon_sym_primitive] = ACTIONS(855),
    [anon_sym_mutable] = ACTIONS(857),
    [anon_sym_struct] = ACTIONS(859),
    [anon_sym_module] = ACTIONS(861),
    [anon_sym_macro] = ACTIONS(863),
    [anon_sym_LPAREN] = ACTIONS(865),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(185),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [anon_sym_LT_COLON] = ACTIONS(185),
    [anon_sym_if] = ACTIONS(867),
    [anon_sym_try] = ACTIONS(869),
    [anon_sym_for] = ACTIONS(871),
    [anon_sym_while] = ACTIONS(873),
    [sym_break_statement] = ACTIONS(875),
    [sym_continue_statement] = ACTIONS(875),
    [anon_sym_return] = ACTIONS(877),
    [anon_sym_let] = ACTIONS(879),
    [anon_sym_const] = ACTIONS(881),
    [anon_sym_quote] = ACTIONS(883),
    [anon_sym_using] = ACTIONS(885),
    [anon_sym_import] = ACTIONS(885),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(887),
    [anon_sym_COLON2] = ACTIONS(889),
    [anon_sym_PLUS] = ACTIONS(891),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(893),
    [anon_sym_GT_COLON] = ACTIONS(895),
    [anon_sym_DASH] = ACTIONS(895),
    [anon_sym_BANG] = ACTIONS(895),
    [anon_sym_TILDE] = ACTIONS(895),
    [anon_sym_] = ACTIONS(895),
    [anon_sym_2] = ACTIONS(895),
    [anon_sym_3] = ACTIONS(895),
    [anon_sym_4] = ACTIONS(895),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(185),
    [anon_sym_EQ_GT] = ACTIONS(185),
    [anon_sym_LBRACK2] = ACTIONS(897),
    [anon_sym_DOLLAR] = ACTIONS(899),
    [anon_sym_AT] = ACTIONS(831),
    [sym_number] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(903),
    [sym_command_string] = ACTIONS(905),
    [sym_character] = ACTIONS(905),
    [sym__power_operator] = ACTIONS(907),
    [sym__times_operator] = ACTIONS(907),
    [sym__plus_operator] = ACTIONS(907),
    [sym__arrow_operator] = ACTIONS(185),
    [sym__comparison_operator] = ACTIONS(185),
    [sym__assign_operator] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(187),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(909),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [43] = {
    [sym_function_definition] = STATE(1850),
    [sym_abstract_definition] = STATE(1850),
    [sym_primitive_definition] = STATE(1850),
    [sym_struct_definition] = STATE(1850),
    [sym_module_definition] = STATE(1850),
    [sym_macro_definition] = STATE(1850),
    [sym_parameter_list] = STATE(4697),
    [sym_if_statement] = STATE(1850),
    [sym_try_statement] = STATE(1850),
    [sym_for_statement] = STATE(1850),
    [sym_while_statement] = STATE(1850),
    [sym_return_statement] = STATE(1850),
    [sym_let_statement] = STATE(1850),
    [sym_const_statement] = STATE(1850),
    [sym_quote_statement] = STATE(1850),
    [sym_import_statement] = STATE(1850),
    [sym_export_statement] = STATE(1850),
    [sym__expression] = STATE(1766),
    [sym__primary_expression] = STATE(1423),
    [sym_operator] = STATE(1423),
    [sym_parenthesized_expression] = STATE(1423),
    [sym_field_expression] = STATE(1284),
    [sym_subscript_expression] = STATE(1423),
    [sym_typed_expression] = STATE(1850),
    [sym_parameterized_identifier] = STATE(1423),
    [sym_compound_expression] = STATE(1850),
    [sym_call_expression] = STATE(1423),
    [sym_broadcast_call_expression] = STATE(1423),
    [sym_macro_expression] = STATE(1850),
    [sym_macro_argument_list] = STATE(1865),
    [sym_spread_expression] = STATE(1850),
    [sym_unary_expression] = STATE(1850),
    [sym_binary_expression] = STATE(1850),
    [sym_ternary_expression] = STATE(1850),
    [sym_pair_expression] = STATE(1850),
    [sym_tuple_expression] = STATE(1423),
    [sym_array_expression] = STATE(1423),
    [sym_matrix_expression] = STATE(1423),
    [sym_generator_expression] = STATE(1850),
    [sym_array_comprehension_expression] = STATE(1423),
    [sym_function_expression] = STATE(1850),
    [sym_range_expression] = STATE(1850),
    [sym_coefficient_expression] = STATE(1850),
    [sym_quote_expression] = STATE(1850),
    [sym_interpolation_expression] = STATE(1850),
    [sym_macro_identifier] = STATE(43),
    [sym_string] = STATE(1423),
    [aux_sym_macro_argument_list_repeat1] = STATE(67),
    [sym_identifier] = ACTIONS(593),
    [anon_sym_function] = ACTIONS(595),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_primitive] = ACTIONS(599),
    [anon_sym_mutable] = ACTIONS(601),
    [anon_sym_struct] = ACTIONS(603),
    [anon_sym_module] = ACTIONS(605),
    [anon_sym_macro] = ACTIONS(607),
    [anon_sym_LPAREN] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(177),
    [anon_sym_COLON_COLON] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(177),
    [anon_sym_LT_COLON] = ACTIONS(177),
    [anon_sym_if] = ACTIONS(611),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_for] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(617),
    [sym_break_statement] = ACTIONS(619),
    [sym_continue_statement] = ACTIONS(619),
    [anon_sym_return] = ACTIONS(621),
    [anon_sym_let] = ACTIONS(623),
    [anon_sym_const] = ACTIONS(625),
    [anon_sym_quote] = ACTIONS(627),
    [anon_sym_using] = ACTIONS(629),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_export] = ACTIONS(631),
    [anon_sym_COLON2] = ACTIONS(633),
    [anon_sym_PLUS] = ACTIONS(635),
    [anon_sym_RBRACK] = ACTIONS(177),
    [anon_sym_begin] = ACTIONS(637),
    [anon_sym_GT_COLON] = ACTIONS(639),
    [anon_sym_DASH] = ACTIONS(641),
    [anon_sym_BANG] = ACTIONS(641),
    [anon_sym_TILDE] = ACTIONS(639),
    [anon_sym_] = ACTIONS(639),
    [anon_sym_2] = ACTIONS(639),
    [anon_sym_3] = ACTIONS(639),
    [anon_sym_4] = ACTIONS(639),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(177),
    [anon_sym_LT_PIPE] = ACTIONS(177),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_QMARK] = ACTIONS(177),
    [anon_sym_EQ_GT] = ACTIONS(177),
    [anon_sym_LBRACK2] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(645),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [sym_command_string] = ACTIONS(653),
    [sym_character] = ACTIONS(653),
    [sym__power_operator] = ACTIONS(655),
    [sym__times_operator] = ACTIONS(657),
    [sym__plus_operator] = ACTIONS(657),
    [sym__arrow_operator] = ACTIONS(177),
    [sym__comparison_operator] = ACTIONS(119),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(653),
    [sym__immediate_paren] = ACTIONS(911),
  },
  [44] = {
    [sym_function_definition] = STATE(1982),
    [sym_abstract_definition] = STATE(1982),
    [sym_primitive_definition] = STATE(1982),
    [sym_struct_definition] = STATE(1982),
    [sym_module_definition] = STATE(1982),
    [sym_macro_definition] = STATE(1982),
    [sym_parameter_list] = STATE(5092),
    [sym_if_statement] = STATE(1982),
    [sym_try_statement] = STATE(1982),
    [sym_for_statement] = STATE(1982),
    [sym_while_statement] = STATE(1982),
    [sym_return_statement] = STATE(1982),
    [sym_let_statement] = STATE(1982),
    [sym_const_statement] = STATE(1982),
    [sym_quote_statement] = STATE(1982),
    [sym_import_statement] = STATE(1982),
    [sym_export_statement] = STATE(1982),
    [sym__expression] = STATE(1981),
    [sym__primary_expression] = STATE(1495),
    [sym_operator] = STATE(1495),
    [sym_parenthesized_expression] = STATE(1495),
    [sym_field_expression] = STATE(1192),
    [sym_subscript_expression] = STATE(1495),
    [sym_typed_expression] = STATE(1982),
    [sym_parameterized_identifier] = STATE(1495),
    [sym_compound_expression] = STATE(1982),
    [sym_call_expression] = STATE(1495),
    [sym_broadcast_call_expression] = STATE(1495),
    [sym_macro_expression] = STATE(1982),
    [sym_macro_argument_list] = STATE(1993),
    [sym_spread_expression] = STATE(1982),
    [sym_unary_expression] = STATE(1982),
    [sym_binary_expression] = STATE(1982),
    [sym_ternary_expression] = STATE(1982),
    [sym_pair_expression] = STATE(1982),
    [sym_tuple_expression] = STATE(1495),
    [sym_array_expression] = STATE(1495),
    [sym_matrix_expression] = STATE(1495),
    [sym_generator_expression] = STATE(1982),
    [sym_array_comprehension_expression] = STATE(1495),
    [sym_function_expression] = STATE(1982),
    [sym_range_expression] = STATE(1982),
    [sym_coefficient_expression] = STATE(1982),
    [sym_quote_expression] = STATE(1982),
    [sym_interpolation_expression] = STATE(1982),
    [sym_macro_identifier] = STATE(44),
    [sym_string] = STATE(1495),
    [aux_sym_macro_argument_list_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(177),
    [sym_identifier] = ACTIONS(849),
    [anon_sym_function] = ACTIONS(851),
    [anon_sym_abstract] = ACTIONS(853),
    [anon_sym_primitive] = ACTIONS(855),
    [anon_sym_mutable] = ACTIONS(857),
    [anon_sym_struct] = ACTIONS(859),
    [anon_sym_module] = ACTIONS(861),
    [anon_sym_macro] = ACTIONS(863),
    [anon_sym_LPAREN] = ACTIONS(865),
    [anon_sym_COMMA] = ACTIONS(119),
    [anon_sym_SEMI] = ACTIONS(119),
    [anon_sym_EQ] = ACTIONS(119),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(119),
    [anon_sym_COLON_COLON] = ACTIONS(119),
    [anon_sym_LT_COLON] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(867),
    [anon_sym_try] = ACTIONS(869),
    [anon_sym_for] = ACTIONS(871),
    [anon_sym_while] = ACTIONS(873),
    [sym_break_statement] = ACTIONS(875),
    [sym_continue_statement] = ACTIONS(875),
    [anon_sym_return] = ACTIONS(877),
    [anon_sym_let] = ACTIONS(879),
    [anon_sym_const] = ACTIONS(881),
    [anon_sym_quote] = ACTIONS(883),
    [anon_sym_using] = ACTIONS(885),
    [anon_sym_import] = ACTIONS(885),
    [anon_sym_export] = ACTIONS(887),
    [anon_sym_COLON2] = ACTIONS(889),
    [anon_sym_PLUS] = ACTIONS(891),
    [anon_sym_begin] = ACTIONS(893),
    [anon_sym_GT_COLON] = ACTIONS(895),
    [anon_sym_DASH] = ACTIONS(895),
    [anon_sym_BANG] = ACTIONS(895),
    [anon_sym_TILDE] = ACTIONS(895),
    [anon_sym_] = ACTIONS(895),
    [anon_sym_2] = ACTIONS(895),
    [anon_sym_3] = ACTIONS(895),
    [anon_sym_4] = ACTIONS(895),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(119),
    [anon_sym_LT_PIPE] = ACTIONS(119),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(119),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(119),
    [anon_sym_LBRACK2] = ACTIONS(897),
    [anon_sym_DOLLAR] = ACTIONS(899),
    [anon_sym_AT] = ACTIONS(831),
    [sym_number] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(903),
    [sym_command_string] = ACTIONS(905),
    [sym_character] = ACTIONS(905),
    [sym__power_operator] = ACTIONS(907),
    [sym__times_operator] = ACTIONS(907),
    [sym__plus_operator] = ACTIONS(907),
    [sym__arrow_operator] = ACTIONS(119),
    [sym__comparison_operator] = ACTIONS(119),
    [sym__assign_operator] = ACTIONS(119),
    [anon_sym_LF] = ACTIONS(177),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(909),
    [sym__immediate_paren] = ACTIONS(913),
  },
  [45] = {
    [sym__expression_list] = STATE(4043),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(915),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(917),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_elseif] = ACTIONS(915),
    [anon_sym_else] = ACTIONS(915),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(919),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [46] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4821),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(1779),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(47),
    [sym_string] = STATE(1466),
    [sym_identifier] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_primitive] = ACTIONS(307),
    [anon_sym_mutable] = ACTIONS(309),
    [anon_sym_struct] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(313),
    [anon_sym_macro] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(185),
    [anon_sym_COLON_COLON] = ACTIONS(185),
    [anon_sym_LT_COLON] = ACTIONS(185),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_elseif] = ACTIONS(185),
    [anon_sym_else] = ACTIONS(185),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [sym_break_statement] = ACTIONS(327),
    [sym_continue_statement] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_quote] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(337),
    [anon_sym_import] = ACTIONS(337),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(339),
    [anon_sym_COLON2] = ACTIONS(341),
    [anon_sym_PLUS] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(345),
    [anon_sym_GT_COLON] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(347),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_] = ACTIONS(347),
    [anon_sym_2] = ACTIONS(347),
    [anon_sym_3] = ACTIONS(347),
    [anon_sym_4] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(185),
    [anon_sym_LT_PIPE] = ACTIONS(185),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(185),
    [anon_sym_EQ_GT] = ACTIONS(185),
    [anon_sym_LBRACK2] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_command_string] = ACTIONS(359),
    [sym_character] = ACTIONS(359),
    [sym__power_operator] = ACTIONS(361),
    [sym__times_operator] = ACTIONS(361),
    [sym__plus_operator] = ACTIONS(361),
    [sym__arrow_operator] = ACTIONS(185),
    [sym__comparison_operator] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(187),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(363),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [47] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4821),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(2192),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_macro_argument_list] = STATE(1775),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(47),
    [sym_string] = STATE(1466),
    [aux_sym_macro_argument_list_repeat1] = STATE(86),
    [sym_identifier] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_primitive] = ACTIONS(307),
    [anon_sym_mutable] = ACTIONS(309),
    [anon_sym_struct] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(313),
    [anon_sym_macro] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(119),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(119),
    [anon_sym_COLON_COLON] = ACTIONS(119),
    [anon_sym_LT_COLON] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_elseif] = ACTIONS(119),
    [anon_sym_else] = ACTIONS(119),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [sym_break_statement] = ACTIONS(327),
    [sym_continue_statement] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_quote] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(337),
    [anon_sym_import] = ACTIONS(337),
    [anon_sym_export] = ACTIONS(339),
    [anon_sym_COLON2] = ACTIONS(341),
    [anon_sym_PLUS] = ACTIONS(343),
    [anon_sym_begin] = ACTIONS(345),
    [anon_sym_GT_COLON] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(347),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_] = ACTIONS(347),
    [anon_sym_2] = ACTIONS(347),
    [anon_sym_3] = ACTIONS(347),
    [anon_sym_4] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(119),
    [anon_sym_LT_PIPE] = ACTIONS(119),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(119),
    [anon_sym_QMARK] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(119),
    [anon_sym_LBRACK2] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_command_string] = ACTIONS(359),
    [sym_character] = ACTIONS(359),
    [sym__power_operator] = ACTIONS(361),
    [sym__times_operator] = ACTIONS(361),
    [sym__plus_operator] = ACTIONS(361),
    [sym__arrow_operator] = ACTIONS(119),
    [sym__comparison_operator] = ACTIONS(119),
    [anon_sym_LF] = ACTIONS(177),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(363),
    [sym__immediate_paren] = ACTIONS(847),
  },
  [48] = {
    [sym_function_definition] = STATE(2907),
    [sym_abstract_definition] = STATE(2907),
    [sym_primitive_definition] = STATE(2907),
    [sym_struct_definition] = STATE(2907),
    [sym_module_definition] = STATE(2907),
    [sym_macro_definition] = STATE(2907),
    [sym_parameter_list] = STATE(4876),
    [sym_if_statement] = STATE(2907),
    [sym_try_statement] = STATE(2907),
    [sym_for_statement] = STATE(2907),
    [sym_while_statement] = STATE(2907),
    [sym_return_statement] = STATE(2907),
    [sym_let_statement] = STATE(2907),
    [sym_const_statement] = STATE(2907),
    [sym_quote_statement] = STATE(2907),
    [sym_import_statement] = STATE(2907),
    [sym_export_statement] = STATE(2907),
    [sym__expression] = STATE(2974),
    [sym__primary_expression] = STATE(2646),
    [sym_operator] = STATE(2646),
    [sym_parenthesized_expression] = STATE(2646),
    [sym_field_expression] = STATE(2568),
    [sym_subscript_expression] = STATE(2646),
    [sym_typed_expression] = STATE(2907),
    [sym_parameterized_identifier] = STATE(2646),
    [sym_compound_expression] = STATE(2907),
    [sym_call_expression] = STATE(2646),
    [sym_broadcast_call_expression] = STATE(2646),
    [sym_macro_expression] = STATE(2907),
    [sym_spread_expression] = STATE(2907),
    [sym_unary_expression] = STATE(2907),
    [sym_binary_expression] = STATE(2907),
    [sym_ternary_expression] = STATE(2907),
    [sym_pair_expression] = STATE(2907),
    [sym_tuple_expression] = STATE(2646),
    [sym_array_expression] = STATE(2646),
    [sym_matrix_expression] = STATE(2646),
    [sym_generator_expression] = STATE(2907),
    [sym_array_comprehension_expression] = STATE(2646),
    [sym_function_expression] = STATE(2907),
    [sym_range_expression] = STATE(2907),
    [sym_coefficient_expression] = STATE(2907),
    [sym_quote_expression] = STATE(2907),
    [sym_interpolation_expression] = STATE(2907),
    [sym_macro_identifier] = STATE(29),
    [sym_string] = STATE(2646),
    [sym_identifier] = ACTIONS(531),
    [anon_sym_function] = ACTIONS(533),
    [anon_sym_end] = ACTIONS(297),
    [anon_sym_abstract] = ACTIONS(535),
    [anon_sym_primitive] = ACTIONS(537),
    [anon_sym_mutable] = ACTIONS(539),
    [anon_sym_struct] = ACTIONS(541),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_macro] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_COMMA] = ACTIONS(299),
    [anon_sym_RPAREN] = ACTIONS(299),
    [anon_sym_SEMI] = ACTIONS(299),
    [anon_sym_EQ] = ACTIONS(297),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(299),
    [anon_sym_COLON_COLON] = ACTIONS(299),
    [anon_sym_RBRACE] = ACTIONS(299),
    [anon_sym_LT_COLON] = ACTIONS(299),
    [anon_sym_if] = ACTIONS(549),
    [anon_sym_try] = ACTIONS(551),
    [anon_sym_for] = ACTIONS(553),
    [anon_sym_while] = ACTIONS(555),
    [sym_break_statement] = ACTIONS(557),
    [sym_continue_statement] = ACTIONS(557),
    [anon_sym_return] = ACTIONS(559),
    [anon_sym_let] = ACTIONS(561),
    [anon_sym_const] = ACTIONS(563),
    [anon_sym_quote] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(567),
    [anon_sym_import] = ACTIONS(567),
    [anon_sym_export] = ACTIONS(569),
    [anon_sym_COLON2] = ACTIONS(571),
    [anon_sym_PLUS] = ACTIONS(573),
    [anon_sym_RBRACK] = ACTIONS(299),
    [anon_sym_begin] = ACTIONS(575),
    [anon_sym_GT_COLON] = ACTIONS(577),
    [anon_sym_DASH] = ACTIONS(579),
    [anon_sym_BANG] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(577),
    [anon_sym_] = ACTIONS(577),
    [anon_sym_2] = ACTIONS(577),
    [anon_sym_3] = ACTIONS(577),
    [anon_sym_4] = ACTIONS(577),
    [anon_sym_SQUOTE] = ACTIONS(297),
    [anon_sym_DOT_SQUOTE] = ACTIONS(299),
    [anon_sym_LT_PIPE] = ACTIONS(299),
    [anon_sym_PIPE_GT] = ACTIONS(297),
    [anon_sym_in] = ACTIONS(297),
    [anon_sym_isa] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(299),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_EQ_GT] = ACTIONS(299),
    [anon_sym_LBRACK2] = ACTIONS(821),
    [anon_sym_DOLLAR] = ACTIONS(583),
    [anon_sym_AT] = ACTIONS(473),
    [sym_number] = ACTIONS(585),
    [anon_sym_DQUOTE] = ACTIONS(587),
    [sym_command_string] = ACTIONS(589),
    [sym_character] = ACTIONS(589),
    [sym__power_operator] = ACTIONS(591),
    [sym__times_operator] = ACTIONS(591),
    [sym__plus_operator] = ACTIONS(591),
    [sym__arrow_operator] = ACTIONS(299),
    [sym__comparison_operator] = ACTIONS(297),
    [sym__assign_operator] = ACTIONS(297),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(589),
  },
  [49] = {
    [sym_function_definition] = STATE(1299),
    [sym_abstract_definition] = STATE(1299),
    [sym_primitive_definition] = STATE(1299),
    [sym_struct_definition] = STATE(1299),
    [sym_module_definition] = STATE(1299),
    [sym_macro_definition] = STATE(1299),
    [sym_parameter_list] = STATE(4829),
    [sym_if_statement] = STATE(1299),
    [sym_try_statement] = STATE(1299),
    [sym_for_statement] = STATE(1299),
    [sym_while_statement] = STATE(1299),
    [sym_return_statement] = STATE(1299),
    [sym_let_statement] = STATE(1299),
    [sym_const_statement] = STATE(1299),
    [sym_quote_statement] = STATE(1299),
    [sym_import_statement] = STATE(1299),
    [sym_export_statement] = STATE(1299),
    [sym__expression] = STATE(1548),
    [sym__primary_expression] = STATE(1067),
    [sym_operator] = STATE(1067),
    [sym_parenthesized_expression] = STATE(1067),
    [sym_field_expression] = STATE(1038),
    [sym_subscript_expression] = STATE(1067),
    [sym_typed_expression] = STATE(1299),
    [sym_parameterized_identifier] = STATE(1067),
    [sym_compound_expression] = STATE(1299),
    [sym_call_expression] = STATE(1067),
    [sym_broadcast_call_expression] = STATE(1067),
    [sym_macro_expression] = STATE(1299),
    [sym_spread_expression] = STATE(1299),
    [sym_unary_expression] = STATE(1299),
    [sym_binary_expression] = STATE(1299),
    [sym_ternary_expression] = STATE(1299),
    [sym_pair_expression] = STATE(1299),
    [sym_tuple_expression] = STATE(1067),
    [sym_array_expression] = STATE(1067),
    [sym_matrix_expression] = STATE(1067),
    [sym_generator_expression] = STATE(1299),
    [sym_array_comprehension_expression] = STATE(1067),
    [sym_function_expression] = STATE(1299),
    [sym_range_expression] = STATE(1299),
    [sym_coefficient_expression] = STATE(1299),
    [sym_quote_expression] = STATE(1299),
    [sym_interpolation_expression] = STATE(1299),
    [sym_macro_identifier] = STATE(3),
    [sym_string] = STATE(1067),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_function] = ACTIONS(117),
    [anon_sym_end] = ACTIONS(297),
    [anon_sym_abstract] = ACTIONS(121),
    [anon_sym_primitive] = ACTIONS(123),
    [anon_sym_mutable] = ACTIONS(125),
    [anon_sym_struct] = ACTIONS(127),
    [anon_sym_module] = ACTIONS(129),
    [anon_sym_macro] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_COMMA] = ACTIONS(297),
    [anon_sym_SEMI] = ACTIONS(297),
    [anon_sym_EQ] = ACTIONS(297),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(297),
    [anon_sym_COLON_COLON] = ACTIONS(297),
    [anon_sym_LT_COLON] = ACTIONS(297),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_elseif] = ACTIONS(297),
    [anon_sym_else] = ACTIONS(297),
    [anon_sym_try] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [sym_break_statement] = ACTIONS(143),
    [sym_continue_statement] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(147),
    [anon_sym_const] = ACTIONS(149),
    [anon_sym_quote] = ACTIONS(151),
    [anon_sym_using] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(153),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_COLON2] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_begin] = ACTIONS(161),
    [anon_sym_GT_COLON] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_] = ACTIONS(163),
    [anon_sym_2] = ACTIONS(163),
    [anon_sym_3] = ACTIONS(163),
    [anon_sym_4] = ACTIONS(163),
    [anon_sym_SQUOTE] = ACTIONS(297),
    [anon_sym_DOT_SQUOTE] = ACTIONS(297),
    [anon_sym_LT_PIPE] = ACTIONS(297),
    [anon_sym_PIPE_GT] = ACTIONS(297),
    [anon_sym_in] = ACTIONS(297),
    [anon_sym_isa] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(297),
    [anon_sym_EQ_GT] = ACTIONS(297),
    [anon_sym_LBRACK2] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(167),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_command_string] = ACTIONS(173),
    [sym_character] = ACTIONS(173),
    [sym__power_operator] = ACTIONS(175),
    [sym__times_operator] = ACTIONS(175),
    [sym__plus_operator] = ACTIONS(175),
    [sym__arrow_operator] = ACTIONS(297),
    [sym__comparison_operator] = ACTIONS(297),
    [sym__assign_operator] = ACTIONS(297),
    [anon_sym_LF] = ACTIONS(299),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(179),
  },
  [50] = {
    [sym_function_definition] = STATE(1578),
    [sym_abstract_definition] = STATE(1578),
    [sym_primitive_definition] = STATE(1578),
    [sym_struct_definition] = STATE(1578),
    [sym_module_definition] = STATE(1578),
    [sym_macro_definition] = STATE(1578),
    [sym_parameter_list] = STATE(5156),
    [sym_if_statement] = STATE(1578),
    [sym_try_statement] = STATE(1578),
    [sym_for_statement] = STATE(1578),
    [sym_while_statement] = STATE(1578),
    [sym_return_statement] = STATE(1578),
    [sym_let_statement] = STATE(1578),
    [sym_const_statement] = STATE(1578),
    [sym_quote_statement] = STATE(1578),
    [sym_import_statement] = STATE(1578),
    [sym_export_statement] = STATE(1578),
    [sym__expression] = STATE(1554),
    [sym__primary_expression] = STATE(1255),
    [sym_operator] = STATE(1255),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_field_expression] = STATE(1099),
    [sym_subscript_expression] = STATE(1255),
    [sym_typed_expression] = STATE(1578),
    [sym_parameterized_identifier] = STATE(1255),
    [sym_compound_expression] = STATE(1578),
    [sym_call_expression] = STATE(1255),
    [sym_broadcast_call_expression] = STATE(1255),
    [sym_macro_expression] = STATE(1578),
    [sym_spread_expression] = STATE(1578),
    [sym_unary_expression] = STATE(1578),
    [sym_binary_expression] = STATE(1578),
    [sym_ternary_expression] = STATE(1578),
    [sym_pair_expression] = STATE(1578),
    [sym_tuple_expression] = STATE(1255),
    [sym_array_expression] = STATE(1255),
    [sym_matrix_expression] = STATE(1255),
    [sym_generator_expression] = STATE(1578),
    [sym_array_comprehension_expression] = STATE(1255),
    [sym_function_expression] = STATE(1578),
    [sym_range_expression] = STATE(1578),
    [sym_coefficient_expression] = STATE(1578),
    [sym_quote_expression] = STATE(1578),
    [sym_interpolation_expression] = STATE(1578),
    [sym_macro_identifier] = STATE(24),
    [sym_string] = STATE(1255),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(421),
    [anon_sym_end] = ACTIONS(297),
    [anon_sym_abstract] = ACTIONS(423),
    [anon_sym_primitive] = ACTIONS(425),
    [anon_sym_mutable] = ACTIONS(427),
    [anon_sym_struct] = ACTIONS(429),
    [anon_sym_module] = ACTIONS(431),
    [anon_sym_macro] = ACTIONS(433),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(299),
    [anon_sym_RPAREN] = ACTIONS(299),
    [anon_sym_SEMI] = ACTIONS(299),
    [anon_sym_EQ] = ACTIONS(297),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(299),
    [anon_sym_COLON_COLON] = ACTIONS(299),
    [anon_sym_RBRACE] = ACTIONS(299),
    [anon_sym_LT_COLON] = ACTIONS(299),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_try] = ACTIONS(439),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(443),
    [sym_break_statement] = ACTIONS(445),
    [sym_continue_statement] = ACTIONS(445),
    [anon_sym_return] = ACTIONS(447),
    [anon_sym_let] = ACTIONS(449),
    [anon_sym_const] = ACTIONS(451),
    [anon_sym_quote] = ACTIONS(453),
    [anon_sym_using] = ACTIONS(455),
    [anon_sym_import] = ACTIONS(455),
    [anon_sym_export] = ACTIONS(457),
    [anon_sym_COLON2] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_RBRACK] = ACTIONS(299),
    [anon_sym_begin] = ACTIONS(463),
    [anon_sym_GT_COLON] = ACTIONS(465),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_] = ACTIONS(465),
    [anon_sym_2] = ACTIONS(465),
    [anon_sym_3] = ACTIONS(465),
    [anon_sym_4] = ACTIONS(465),
    [anon_sym_SQUOTE] = ACTIONS(297),
    [anon_sym_DOT_SQUOTE] = ACTIONS(299),
    [anon_sym_LT_PIPE] = ACTIONS(299),
    [anon_sym_PIPE_GT] = ACTIONS(297),
    [anon_sym_in] = ACTIONS(297),
    [anon_sym_isa] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(299),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_EQ_GT] = ACTIONS(299),
    [anon_sym_LBRACK2] = ACTIONS(501),
    [anon_sym_DOLLAR] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(473),
    [sym_number] = ACTIONS(475),
    [anon_sym_DQUOTE] = ACTIONS(477),
    [sym_command_string] = ACTIONS(479),
    [sym_character] = ACTIONS(479),
    [sym__power_operator] = ACTIONS(481),
    [sym__times_operator] = ACTIONS(481),
    [sym__plus_operator] = ACTIONS(481),
    [sym__arrow_operator] = ACTIONS(299),
    [sym__comparison_operator] = ACTIONS(297),
    [sym__assign_operator] = ACTIONS(297),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(479),
  },
  [51] = {
    [sym_function_definition] = STATE(1850),
    [sym_abstract_definition] = STATE(1850),
    [sym_primitive_definition] = STATE(1850),
    [sym_struct_definition] = STATE(1850),
    [sym_module_definition] = STATE(1850),
    [sym_macro_definition] = STATE(1850),
    [sym_parameter_list] = STATE(4877),
    [sym_if_statement] = STATE(1850),
    [sym_try_statement] = STATE(1850),
    [sym_for_statement] = STATE(1850),
    [sym_while_statement] = STATE(1850),
    [sym_return_statement] = STATE(1850),
    [sym_let_statement] = STATE(1850),
    [sym_const_statement] = STATE(1850),
    [sym_quote_statement] = STATE(1850),
    [sym_import_statement] = STATE(1850),
    [sym_export_statement] = STATE(1850),
    [sym__expression] = STATE(2275),
    [sym__primary_expression] = STATE(1423),
    [sym_operator] = STATE(1423),
    [sym_parenthesized_expression] = STATE(1423),
    [sym_field_expression] = STATE(1284),
    [sym_subscript_expression] = STATE(1423),
    [sym_typed_expression] = STATE(1850),
    [sym_parameterized_identifier] = STATE(1423),
    [sym_compound_expression] = STATE(1850),
    [sym_call_expression] = STATE(1423),
    [sym_broadcast_call_expression] = STATE(1423),
    [sym_macro_expression] = STATE(1850),
    [sym_macro_argument_list] = STATE(1865),
    [sym_spread_expression] = STATE(1850),
    [sym_unary_expression] = STATE(1850),
    [sym_binary_expression] = STATE(1850),
    [sym_ternary_expression] = STATE(1850),
    [sym_pair_expression] = STATE(1850),
    [sym_tuple_expression] = STATE(1423),
    [sym_array_expression] = STATE(1423),
    [sym_matrix_expression] = STATE(1423),
    [sym_generator_expression] = STATE(1850),
    [sym_array_comprehension_expression] = STATE(1423),
    [sym_function_expression] = STATE(1850),
    [sym_range_expression] = STATE(1850),
    [sym_coefficient_expression] = STATE(1850),
    [sym_quote_expression] = STATE(1850),
    [sym_interpolation_expression] = STATE(1850),
    [sym_macro_identifier] = STATE(51),
    [sym_string] = STATE(1423),
    [aux_sym_macro_argument_list_repeat1] = STATE(97),
    [sym_identifier] = ACTIONS(921),
    [anon_sym_function] = ACTIONS(595),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_primitive] = ACTIONS(599),
    [anon_sym_mutable] = ACTIONS(601),
    [anon_sym_struct] = ACTIONS(603),
    [anon_sym_module] = ACTIONS(605),
    [anon_sym_macro] = ACTIONS(607),
    [anon_sym_LPAREN] = ACTIONS(609),
    [anon_sym_RPAREN] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(177),
    [anon_sym_COLON_COLON] = ACTIONS(177),
    [anon_sym_LT_COLON] = ACTIONS(177),
    [anon_sym_if] = ACTIONS(611),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_for] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(617),
    [sym_break_statement] = ACTIONS(619),
    [sym_continue_statement] = ACTIONS(619),
    [anon_sym_return] = ACTIONS(621),
    [anon_sym_let] = ACTIONS(623),
    [anon_sym_const] = ACTIONS(625),
    [anon_sym_quote] = ACTIONS(627),
    [anon_sym_using] = ACTIONS(629),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_export] = ACTIONS(631),
    [anon_sym_COLON2] = ACTIONS(923),
    [anon_sym_PLUS] = ACTIONS(925),
    [anon_sym_RBRACK] = ACTIONS(177),
    [anon_sym_begin] = ACTIONS(637),
    [anon_sym_GT_COLON] = ACTIONS(927),
    [anon_sym_DASH] = ACTIONS(929),
    [anon_sym_BANG] = ACTIONS(929),
    [anon_sym_TILDE] = ACTIONS(927),
    [anon_sym_] = ACTIONS(927),
    [anon_sym_2] = ACTIONS(927),
    [anon_sym_3] = ACTIONS(927),
    [anon_sym_4] = ACTIONS(927),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(177),
    [anon_sym_LT_PIPE] = ACTIONS(177),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_QMARK] = ACTIONS(177),
    [anon_sym_EQ_GT] = ACTIONS(177),
    [anon_sym_LBRACK2] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(931),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [sym_command_string] = ACTIONS(653),
    [sym_character] = ACTIONS(653),
    [sym__power_operator] = ACTIONS(655),
    [sym__times_operator] = ACTIONS(657),
    [sym__plus_operator] = ACTIONS(657),
    [sym__arrow_operator] = ACTIONS(177),
    [sym__comparison_operator] = ACTIONS(119),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(653),
    [sym__immediate_paren] = ACTIONS(911),
  },
  [52] = {
    [sym_function_definition] = STATE(1850),
    [sym_abstract_definition] = STATE(1850),
    [sym_primitive_definition] = STATE(1850),
    [sym_struct_definition] = STATE(1850),
    [sym_module_definition] = STATE(1850),
    [sym_macro_definition] = STATE(1850),
    [sym_parameter_list] = STATE(4697),
    [sym_if_statement] = STATE(1850),
    [sym_try_statement] = STATE(1850),
    [sym_for_statement] = STATE(1850),
    [sym_while_statement] = STATE(1850),
    [sym_return_statement] = STATE(1850),
    [sym_let_statement] = STATE(1850),
    [sym_const_statement] = STATE(1850),
    [sym_quote_statement] = STATE(1850),
    [sym_import_statement] = STATE(1850),
    [sym_export_statement] = STATE(1850),
    [sym__expression] = STATE(1766),
    [sym__primary_expression] = STATE(1423),
    [sym_operator] = STATE(1423),
    [sym_parenthesized_expression] = STATE(1423),
    [sym_field_expression] = STATE(1284),
    [sym_subscript_expression] = STATE(1423),
    [sym_typed_expression] = STATE(1850),
    [sym_parameterized_identifier] = STATE(1423),
    [sym_compound_expression] = STATE(1850),
    [sym_call_expression] = STATE(1423),
    [sym_broadcast_call_expression] = STATE(1423),
    [sym_macro_expression] = STATE(1850),
    [sym_spread_expression] = STATE(1850),
    [sym_unary_expression] = STATE(1850),
    [sym_binary_expression] = STATE(1850),
    [sym_ternary_expression] = STATE(1850),
    [sym_pair_expression] = STATE(1850),
    [sym_tuple_expression] = STATE(1423),
    [sym_array_expression] = STATE(1423),
    [sym_matrix_expression] = STATE(1423),
    [sym_generator_expression] = STATE(1850),
    [sym_array_comprehension_expression] = STATE(1423),
    [sym_function_expression] = STATE(1850),
    [sym_range_expression] = STATE(1850),
    [sym_coefficient_expression] = STATE(1850),
    [sym_quote_expression] = STATE(1850),
    [sym_interpolation_expression] = STATE(1850),
    [sym_macro_identifier] = STATE(43),
    [sym_string] = STATE(1423),
    [aux_sym_macro_argument_list_repeat1] = STATE(52),
    [sym_identifier] = ACTIONS(933),
    [anon_sym_function] = ACTIONS(936),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_abstract] = ACTIONS(939),
    [anon_sym_primitive] = ACTIONS(942),
    [anon_sym_mutable] = ACTIONS(945),
    [anon_sym_struct] = ACTIONS(948),
    [anon_sym_module] = ACTIONS(951),
    [anon_sym_macro] = ACTIONS(954),
    [anon_sym_LPAREN] = ACTIONS(957),
    [anon_sym_COMMA] = ACTIONS(292),
    [anon_sym_RPAREN] = ACTIONS(292),
    [anon_sym_SEMI] = ACTIONS(292),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(292),
    [anon_sym_COLON_COLON] = ACTIONS(292),
    [anon_sym_RBRACE] = ACTIONS(292),
    [anon_sym_LT_COLON] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(960),
    [anon_sym_try] = ACTIONS(963),
    [anon_sym_for] = ACTIONS(966),
    [anon_sym_while] = ACTIONS(969),
    [sym_break_statement] = ACTIONS(972),
    [sym_continue_statement] = ACTIONS(972),
    [anon_sym_return] = ACTIONS(975),
    [anon_sym_let] = ACTIONS(978),
    [anon_sym_const] = ACTIONS(981),
    [anon_sym_quote] = ACTIONS(984),
    [anon_sym_using] = ACTIONS(987),
    [anon_sym_import] = ACTIONS(987),
    [anon_sym_export] = ACTIONS(990),
    [anon_sym_COLON2] = ACTIONS(993),
    [anon_sym_PLUS] = ACTIONS(996),
    [anon_sym_RBRACK] = ACTIONS(292),
    [anon_sym_begin] = ACTIONS(999),
    [anon_sym_GT_COLON] = ACTIONS(1002),
    [anon_sym_DASH] = ACTIONS(1005),
    [anon_sym_BANG] = ACTIONS(1005),
    [anon_sym_TILDE] = ACTIONS(1002),
    [anon_sym_] = ACTIONS(1002),
    [anon_sym_2] = ACTIONS(1002),
    [anon_sym_3] = ACTIONS(1002),
    [anon_sym_4] = ACTIONS(1002),
    [anon_sym_SQUOTE] = ACTIONS(203),
    [anon_sym_DOT_SQUOTE] = ACTIONS(292),
    [anon_sym_LT_PIPE] = ACTIONS(292),
    [anon_sym_PIPE_GT] = ACTIONS(203),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(292),
    [anon_sym_QMARK] = ACTIONS(292),
    [anon_sym_EQ_GT] = ACTIONS(292),
    [anon_sym_LBRACK2] = ACTIONS(1008),
    [anon_sym_DOLLAR] = ACTIONS(1011),
    [anon_sym_AT] = ACTIONS(1014),
    [sym_number] = ACTIONS(1017),
    [anon_sym_DQUOTE] = ACTIONS(1020),
    [sym_command_string] = ACTIONS(1023),
    [sym_character] = ACTIONS(1023),
    [sym__power_operator] = ACTIONS(1026),
    [sym__times_operator] = ACTIONS(1029),
    [sym__plus_operator] = ACTIONS(1029),
    [sym__arrow_operator] = ACTIONS(292),
    [sym__comparison_operator] = ACTIONS(203),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(1023),
  },
  [53] = {
    [sym_function_definition] = STATE(2238),
    [sym_abstract_definition] = STATE(2238),
    [sym_primitive_definition] = STATE(2238),
    [sym_struct_definition] = STATE(2238),
    [sym_module_definition] = STATE(2238),
    [sym_macro_definition] = STATE(2238),
    [sym_parameter_list] = STATE(4667),
    [sym_if_statement] = STATE(2238),
    [sym_try_statement] = STATE(2238),
    [sym_for_statement] = STATE(2238),
    [sym_while_statement] = STATE(2238),
    [sym_return_statement] = STATE(2238),
    [sym_let_statement] = STATE(2238),
    [sym_const_statement] = STATE(2238),
    [sym_quote_statement] = STATE(2238),
    [sym_import_statement] = STATE(2238),
    [sym_export_statement] = STATE(2238),
    [sym__expression] = STATE(2254),
    [sym__primary_expression] = STATE(1728),
    [sym_operator] = STATE(1728),
    [sym_parenthesized_expression] = STATE(1728),
    [sym_field_expression] = STATE(1401),
    [sym_subscript_expression] = STATE(1728),
    [sym_typed_expression] = STATE(2238),
    [sym_parameterized_identifier] = STATE(1728),
    [sym_compound_expression] = STATE(2238),
    [sym_call_expression] = STATE(1728),
    [sym_broadcast_call_expression] = STATE(1728),
    [sym_macro_expression] = STATE(2238),
    [sym_spread_expression] = STATE(2238),
    [sym_unary_expression] = STATE(2238),
    [sym_binary_expression] = STATE(2238),
    [sym_ternary_expression] = STATE(2238),
    [sym_pair_expression] = STATE(2238),
    [sym_tuple_expression] = STATE(1728),
    [sym_array_expression] = STATE(1728),
    [sym_matrix_expression] = STATE(1728),
    [sym_generator_expression] = STATE(2238),
    [sym_array_comprehension_expression] = STATE(1728),
    [sym_function_expression] = STATE(2238),
    [sym_range_expression] = STATE(2238),
    [sym_coefficient_expression] = STATE(2238),
    [sym_quote_expression] = STATE(2238),
    [sym_interpolation_expression] = STATE(2238),
    [sym_macro_identifier] = STATE(62),
    [sym_string] = STATE(1728),
    [sym_identifier] = ACTIONS(1032),
    [anon_sym_function] = ACTIONS(1034),
    [anon_sym_abstract] = ACTIONS(1036),
    [anon_sym_primitive] = ACTIONS(1038),
    [aux_sym_primitive_definition_token1] = ACTIONS(185),
    [anon_sym_mutable] = ACTIONS(1040),
    [anon_sym_struct] = ACTIONS(1042),
    [anon_sym_module] = ACTIONS(1044),
    [anon_sym_macro] = ACTIONS(1046),
    [anon_sym_LPAREN] = ACTIONS(1048),
    [anon_sym_COMMA] = ACTIONS(187),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(187),
    [anon_sym_COLON_COLON] = ACTIONS(187),
    [anon_sym_LT_COLON] = ACTIONS(187),
    [anon_sym_if] = ACTIONS(1050),
    [anon_sym_try] = ACTIONS(1052),
    [anon_sym_for] = ACTIONS(1054),
    [anon_sym_while] = ACTIONS(1056),
    [sym_break_statement] = ACTIONS(1058),
    [sym_continue_statement] = ACTIONS(1058),
    [anon_sym_return] = ACTIONS(1060),
    [anon_sym_let] = ACTIONS(1062),
    [anon_sym_const] = ACTIONS(1064),
    [anon_sym_quote] = ACTIONS(1066),
    [anon_sym_using] = ACTIONS(1068),
    [anon_sym_import] = ACTIONS(1068),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(1070),
    [anon_sym_COLON2] = ACTIONS(1072),
    [anon_sym_PLUS] = ACTIONS(1074),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(1076),
    [anon_sym_GT_COLON] = ACTIONS(1078),
    [anon_sym_DASH] = ACTIONS(1080),
    [anon_sym_BANG] = ACTIONS(1080),
    [anon_sym_TILDE] = ACTIONS(1078),
    [anon_sym_] = ACTIONS(1078),
    [anon_sym_2] = ACTIONS(1078),
    [anon_sym_3] = ACTIONS(1078),
    [anon_sym_4] = ACTIONS(1078),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(187),
    [anon_sym_LT_PIPE] = ACTIONS(187),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(187),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_EQ_GT] = ACTIONS(187),
    [anon_sym_LBRACK2] = ACTIONS(1082),
    [anon_sym_DOLLAR] = ACTIONS(1084),
    [anon_sym_AT] = ACTIONS(1086),
    [sym_number] = ACTIONS(1088),
    [anon_sym_DQUOTE] = ACTIONS(1090),
    [sym_command_string] = ACTIONS(1092),
    [sym_character] = ACTIONS(1092),
    [sym__power_operator] = ACTIONS(1094),
    [sym__times_operator] = ACTIONS(1094),
    [sym__plus_operator] = ACTIONS(1094),
    [sym__arrow_operator] = ACTIONS(187),
    [sym__comparison_operator] = ACTIONS(185),
    [sym__assign_operator] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(1092),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [54] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4936),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(1745),
    [sym__primary_expression] = STATE(1466),
    [sym_bare_tuple_expression] = STATE(1767),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(38),
    [sym_string] = STATE(1466),
    [sym_identifier] = ACTIONS(837),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(189),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_primitive] = ACTIONS(307),
    [anon_sym_mutable] = ACTIONS(309),
    [anon_sym_struct] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(313),
    [anon_sym_macro] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(189),
    [anon_sym_SEMI] = ACTIONS(189),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(189),
    [anon_sym_COLON_COLON] = ACTIONS(189),
    [anon_sym_LT_COLON] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_elseif] = ACTIONS(189),
    [anon_sym_else] = ACTIONS(189),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [sym_break_statement] = ACTIONS(327),
    [sym_continue_statement] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_quote] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(337),
    [anon_sym_import] = ACTIONS(337),
    [anon_sym_export] = ACTIONS(339),
    [anon_sym_COLON2] = ACTIONS(839),
    [anon_sym_PLUS] = ACTIONS(841),
    [anon_sym_begin] = ACTIONS(345),
    [anon_sym_GT_COLON] = ACTIONS(843),
    [anon_sym_DASH] = ACTIONS(843),
    [anon_sym_BANG] = ACTIONS(843),
    [anon_sym_TILDE] = ACTIONS(843),
    [anon_sym_] = ACTIONS(843),
    [anon_sym_2] = ACTIONS(843),
    [anon_sym_3] = ACTIONS(843),
    [anon_sym_4] = ACTIONS(843),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DOT_SQUOTE] = ACTIONS(189),
    [anon_sym_LT_PIPE] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_in] = ACTIONS(189),
    [anon_sym_isa] = ACTIONS(189),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(189),
    [anon_sym_QMARK] = ACTIONS(189),
    [anon_sym_EQ_GT] = ACTIONS(189),
    [anon_sym_LBRACK2] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(845),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_command_string] = ACTIONS(359),
    [sym_character] = ACTIONS(359),
    [sym__power_operator] = ACTIONS(361),
    [sym__times_operator] = ACTIONS(361),
    [sym__plus_operator] = ACTIONS(361),
    [sym__arrow_operator] = ACTIONS(189),
    [sym__comparison_operator] = ACTIONS(189),
    [anon_sym_LF] = ACTIONS(191),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(363),
  },
  [55] = {
    [sym_function_definition] = STATE(1982),
    [sym_abstract_definition] = STATE(1982),
    [sym_primitive_definition] = STATE(1982),
    [sym_struct_definition] = STATE(1982),
    [sym_module_definition] = STATE(1982),
    [sym_macro_definition] = STATE(1982),
    [sym_parameter_list] = STATE(5092),
    [sym_if_statement] = STATE(1982),
    [sym_try_statement] = STATE(1982),
    [sym_for_statement] = STATE(1982),
    [sym_while_statement] = STATE(1982),
    [sym_return_statement] = STATE(1982),
    [sym_let_statement] = STATE(1982),
    [sym_const_statement] = STATE(1982),
    [sym_quote_statement] = STATE(1982),
    [sym_import_statement] = STATE(1982),
    [sym_export_statement] = STATE(1982),
    [sym__expression] = STATE(1735),
    [sym__primary_expression] = STATE(1495),
    [sym_bare_tuple_expression] = STATE(1984),
    [sym_operator] = STATE(1495),
    [sym_parenthesized_expression] = STATE(1495),
    [sym_field_expression] = STATE(1192),
    [sym_subscript_expression] = STATE(1495),
    [sym_typed_expression] = STATE(1982),
    [sym_parameterized_identifier] = STATE(1495),
    [sym_compound_expression] = STATE(1982),
    [sym_call_expression] = STATE(1495),
    [sym_broadcast_call_expression] = STATE(1495),
    [sym_macro_expression] = STATE(1982),
    [sym_spread_expression] = STATE(1982),
    [sym_unary_expression] = STATE(1982),
    [sym_binary_expression] = STATE(1982),
    [sym_ternary_expression] = STATE(1982),
    [sym_pair_expression] = STATE(1982),
    [sym_tuple_expression] = STATE(1495),
    [sym_array_expression] = STATE(1495),
    [sym_matrix_expression] = STATE(1495),
    [sym_generator_expression] = STATE(1982),
    [sym_array_comprehension_expression] = STATE(1495),
    [sym_function_expression] = STATE(1982),
    [sym_range_expression] = STATE(1982),
    [sym_coefficient_expression] = STATE(1982),
    [sym_quote_expression] = STATE(1982),
    [sym_interpolation_expression] = STATE(1982),
    [sym_macro_identifier] = STATE(44),
    [sym_string] = STATE(1495),
    [ts_builtin_sym_end] = ACTIONS(191),
    [sym_identifier] = ACTIONS(849),
    [anon_sym_function] = ACTIONS(851),
    [anon_sym_abstract] = ACTIONS(853),
    [anon_sym_primitive] = ACTIONS(855),
    [anon_sym_mutable] = ACTIONS(857),
    [anon_sym_struct] = ACTIONS(859),
    [anon_sym_module] = ACTIONS(861),
    [anon_sym_macro] = ACTIONS(863),
    [anon_sym_LPAREN] = ACTIONS(865),
    [anon_sym_COMMA] = ACTIONS(189),
    [anon_sym_SEMI] = ACTIONS(189),
    [anon_sym_EQ] = ACTIONS(189),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(189),
    [anon_sym_COLON_COLON] = ACTIONS(189),
    [anon_sym_LT_COLON] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(867),
    [anon_sym_try] = ACTIONS(869),
    [anon_sym_for] = ACTIONS(871),
    [anon_sym_while] = ACTIONS(873),
    [sym_break_statement] = ACTIONS(875),
    [sym_continue_statement] = ACTIONS(875),
    [anon_sym_return] = ACTIONS(877),
    [anon_sym_let] = ACTIONS(879),
    [anon_sym_const] = ACTIONS(881),
    [anon_sym_quote] = ACTIONS(883),
    [anon_sym_using] = ACTIONS(885),
    [anon_sym_import] = ACTIONS(885),
    [anon_sym_export] = ACTIONS(887),
    [anon_sym_COLON2] = ACTIONS(889),
    [anon_sym_PLUS] = ACTIONS(891),
    [anon_sym_begin] = ACTIONS(893),
    [anon_sym_GT_COLON] = ACTIONS(895),
    [anon_sym_DASH] = ACTIONS(895),
    [anon_sym_BANG] = ACTIONS(895),
    [anon_sym_TILDE] = ACTIONS(895),
    [anon_sym_] = ACTIONS(895),
    [anon_sym_2] = ACTIONS(895),
    [anon_sym_3] = ACTIONS(895),
    [anon_sym_4] = ACTIONS(895),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DOT_SQUOTE] = ACTIONS(189),
    [anon_sym_LT_PIPE] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_in] = ACTIONS(189),
    [anon_sym_isa] = ACTIONS(189),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(189),
    [anon_sym_QMARK] = ACTIONS(189),
    [anon_sym_EQ_GT] = ACTIONS(189),
    [anon_sym_LBRACK2] = ACTIONS(897),
    [anon_sym_DOLLAR] = ACTIONS(899),
    [anon_sym_AT] = ACTIONS(831),
    [sym_number] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(903),
    [sym_command_string] = ACTIONS(905),
    [sym_character] = ACTIONS(905),
    [sym__power_operator] = ACTIONS(907),
    [sym__times_operator] = ACTIONS(907),
    [sym__plus_operator] = ACTIONS(907),
    [sym__arrow_operator] = ACTIONS(189),
    [sym__comparison_operator] = ACTIONS(189),
    [sym__assign_operator] = ACTIONS(189),
    [anon_sym_LF] = ACTIONS(191),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(909),
  },
  [56] = {
    [sym_function_definition] = STATE(3110),
    [sym_abstract_definition] = STATE(3110),
    [sym_primitive_definition] = STATE(3110),
    [sym_struct_definition] = STATE(3110),
    [sym_module_definition] = STATE(3110),
    [sym_macro_definition] = STATE(3110),
    [sym_parameter_list] = STATE(4631),
    [sym_if_statement] = STATE(3110),
    [sym_try_statement] = STATE(3110),
    [sym_for_statement] = STATE(3110),
    [sym_while_statement] = STATE(3110),
    [sym_return_statement] = STATE(3110),
    [sym_let_statement] = STATE(3110),
    [sym_const_statement] = STATE(3110),
    [sym_quote_statement] = STATE(3110),
    [sym_import_statement] = STATE(3110),
    [sym_export_statement] = STATE(3110),
    [sym__expression] = STATE(3082),
    [sym__primary_expression] = STATE(2793),
    [sym_bare_tuple_expression] = STATE(3069),
    [sym_operator] = STATE(2793),
    [sym_parenthesized_expression] = STATE(2793),
    [sym_field_expression] = STATE(2614),
    [sym_subscript_expression] = STATE(2793),
    [sym_typed_expression] = STATE(3110),
    [sym_parameterized_identifier] = STATE(2793),
    [sym_compound_expression] = STATE(3110),
    [sym_call_expression] = STATE(2793),
    [sym_broadcast_call_expression] = STATE(2793),
    [sym_macro_expression] = STATE(3110),
    [sym_spread_expression] = STATE(3110),
    [sym_unary_expression] = STATE(3110),
    [sym_binary_expression] = STATE(3110),
    [sym_ternary_expression] = STATE(3110),
    [sym_pair_expression] = STATE(3110),
    [sym_tuple_expression] = STATE(2793),
    [sym_array_expression] = STATE(2793),
    [sym_matrix_expression] = STATE(2793),
    [sym_generator_expression] = STATE(3110),
    [sym_array_comprehension_expression] = STATE(2793),
    [sym_function_expression] = STATE(3110),
    [sym_range_expression] = STATE(3110),
    [sym_coefficient_expression] = STATE(3110),
    [sym_quote_expression] = STATE(3110),
    [sym_interpolation_expression] = STATE(3110),
    [sym_macro_identifier] = STATE(31),
    [sym_string] = STATE(2793),
    [sym_identifier] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_end] = ACTIONS(189),
    [anon_sym_abstract] = ACTIONS(665),
    [anon_sym_primitive] = ACTIONS(667),
    [anon_sym_mutable] = ACTIONS(669),
    [anon_sym_struct] = ACTIONS(671),
    [anon_sym_module] = ACTIONS(673),
    [anon_sym_macro] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(677),
    [anon_sym_COMMA] = ACTIONS(191),
    [anon_sym_RPAREN] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(191),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(191),
    [anon_sym_RBRACE] = ACTIONS(191),
    [anon_sym_LT_COLON] = ACTIONS(191),
    [anon_sym_if] = ACTIONS(679),
    [anon_sym_try] = ACTIONS(681),
    [anon_sym_for] = ACTIONS(683),
    [anon_sym_while] = ACTIONS(685),
    [sym_break_statement] = ACTIONS(687),
    [sym_continue_statement] = ACTIONS(687),
    [anon_sym_return] = ACTIONS(689),
    [anon_sym_let] = ACTIONS(691),
    [anon_sym_const] = ACTIONS(693),
    [anon_sym_quote] = ACTIONS(695),
    [anon_sym_using] = ACTIONS(697),
    [anon_sym_import] = ACTIONS(697),
    [anon_sym_export] = ACTIONS(699),
    [anon_sym_COLON2] = ACTIONS(701),
    [anon_sym_PLUS] = ACTIONS(703),
    [anon_sym_RBRACK] = ACTIONS(191),
    [anon_sym_begin] = ACTIONS(705),
    [anon_sym_GT_COLON] = ACTIONS(707),
    [anon_sym_DASH] = ACTIONS(709),
    [anon_sym_BANG] = ACTIONS(709),
    [anon_sym_TILDE] = ACTIONS(707),
    [anon_sym_] = ACTIONS(707),
    [anon_sym_2] = ACTIONS(707),
    [anon_sym_3] = ACTIONS(707),
    [anon_sym_4] = ACTIONS(707),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DOT_SQUOTE] = ACTIONS(191),
    [anon_sym_LT_PIPE] = ACTIONS(191),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_in] = ACTIONS(189),
    [anon_sym_isa] = ACTIONS(189),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(191),
    [anon_sym_QMARK] = ACTIONS(191),
    [anon_sym_EQ_GT] = ACTIONS(191),
    [anon_sym_LBRACK2] = ACTIONS(1096),
    [anon_sym_DOLLAR] = ACTIONS(713),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(715),
    [anon_sym_DQUOTE] = ACTIONS(717),
    [sym_command_string] = ACTIONS(719),
    [sym_character] = ACTIONS(719),
    [sym__power_operator] = ACTIONS(721),
    [sym__times_operator] = ACTIONS(723),
    [sym__plus_operator] = ACTIONS(723),
    [sym__arrow_operator] = ACTIONS(191),
    [sym__comparison_operator] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(719),
  },
  [57] = {
    [sym_function_definition] = STATE(1982),
    [sym_abstract_definition] = STATE(1982),
    [sym_primitive_definition] = STATE(1982),
    [sym_struct_definition] = STATE(1982),
    [sym_module_definition] = STATE(1982),
    [sym_macro_definition] = STATE(1982),
    [sym_parameter_list] = STATE(5092),
    [sym_if_statement] = STATE(1982),
    [sym_try_statement] = STATE(1982),
    [sym_for_statement] = STATE(1982),
    [sym_while_statement] = STATE(1982),
    [sym_return_statement] = STATE(1982),
    [sym_let_statement] = STATE(1982),
    [sym_const_statement] = STATE(1982),
    [sym_quote_statement] = STATE(1982),
    [sym_import_statement] = STATE(1982),
    [sym_export_statement] = STATE(1982),
    [sym__expression] = STATE(1981),
    [sym__primary_expression] = STATE(1495),
    [sym_operator] = STATE(1495),
    [sym_parenthesized_expression] = STATE(1495),
    [sym_field_expression] = STATE(1192),
    [sym_subscript_expression] = STATE(1495),
    [sym_typed_expression] = STATE(1982),
    [sym_parameterized_identifier] = STATE(1495),
    [sym_compound_expression] = STATE(1982),
    [sym_call_expression] = STATE(1495),
    [sym_broadcast_call_expression] = STATE(1495),
    [sym_macro_expression] = STATE(1982),
    [sym_spread_expression] = STATE(1982),
    [sym_unary_expression] = STATE(1982),
    [sym_binary_expression] = STATE(1982),
    [sym_ternary_expression] = STATE(1982),
    [sym_pair_expression] = STATE(1982),
    [sym_tuple_expression] = STATE(1495),
    [sym_array_expression] = STATE(1495),
    [sym_matrix_expression] = STATE(1495),
    [sym_generator_expression] = STATE(1982),
    [sym_array_comprehension_expression] = STATE(1495),
    [sym_function_expression] = STATE(1982),
    [sym_range_expression] = STATE(1982),
    [sym_coefficient_expression] = STATE(1982),
    [sym_quote_expression] = STATE(1982),
    [sym_interpolation_expression] = STATE(1982),
    [sym_macro_identifier] = STATE(44),
    [sym_string] = STATE(1495),
    [aux_sym_macro_argument_list_repeat1] = STATE(57),
    [ts_builtin_sym_end] = ACTIONS(292),
    [sym_identifier] = ACTIONS(1098),
    [anon_sym_function] = ACTIONS(1101),
    [anon_sym_abstract] = ACTIONS(1104),
    [anon_sym_primitive] = ACTIONS(1107),
    [anon_sym_mutable] = ACTIONS(1110),
    [anon_sym_struct] = ACTIONS(1113),
    [anon_sym_module] = ACTIONS(1116),
    [anon_sym_macro] = ACTIONS(1119),
    [anon_sym_LPAREN] = ACTIONS(1122),
    [anon_sym_COMMA] = ACTIONS(203),
    [anon_sym_SEMI] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_COLON_COLON] = ACTIONS(203),
    [anon_sym_LT_COLON] = ACTIONS(203),
    [anon_sym_if] = ACTIONS(1125),
    [anon_sym_try] = ACTIONS(1128),
    [anon_sym_for] = ACTIONS(1131),
    [anon_sym_while] = ACTIONS(1134),
    [sym_break_statement] = ACTIONS(1137),
    [sym_continue_statement] = ACTIONS(1137),
    [anon_sym_return] = ACTIONS(1140),
    [anon_sym_let] = ACTIONS(1143),
    [anon_sym_const] = ACTIONS(1146),
    [anon_sym_quote] = ACTIONS(1149),
    [anon_sym_using] = ACTIONS(1152),
    [anon_sym_import] = ACTIONS(1152),
    [anon_sym_export] = ACTIONS(1155),
    [anon_sym_COLON2] = ACTIONS(1158),
    [anon_sym_PLUS] = ACTIONS(1161),
    [anon_sym_begin] = ACTIONS(1164),
    [anon_sym_GT_COLON] = ACTIONS(1167),
    [anon_sym_DASH] = ACTIONS(1167),
    [anon_sym_BANG] = ACTIONS(1167),
    [anon_sym_TILDE] = ACTIONS(1167),
    [anon_sym_] = ACTIONS(1167),
    [anon_sym_2] = ACTIONS(1167),
    [anon_sym_3] = ACTIONS(1167),
    [anon_sym_4] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(203),
    [anon_sym_DOT_SQUOTE] = ACTIONS(203),
    [anon_sym_LT_PIPE] = ACTIONS(203),
    [anon_sym_PIPE_GT] = ACTIONS(203),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(203),
    [anon_sym_EQ_GT] = ACTIONS(203),
    [anon_sym_LBRACK2] = ACTIONS(1170),
    [anon_sym_DOLLAR] = ACTIONS(1173),
    [anon_sym_AT] = ACTIONS(1176),
    [sym_number] = ACTIONS(1179),
    [anon_sym_DQUOTE] = ACTIONS(1182),
    [sym_command_string] = ACTIONS(1185),
    [sym_character] = ACTIONS(1185),
    [sym__power_operator] = ACTIONS(1188),
    [sym__times_operator] = ACTIONS(1188),
    [sym__plus_operator] = ACTIONS(1188),
    [sym__arrow_operator] = ACTIONS(203),
    [sym__comparison_operator] = ACTIONS(203),
    [sym__assign_operator] = ACTIONS(203),
    [anon_sym_LF] = ACTIONS(292),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(1191),
  },
  [58] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4936),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(1913),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(38),
    [sym_string] = STATE(1466),
    [aux_sym_macro_argument_list_repeat1] = STATE(66),
    [sym_identifier] = ACTIONS(837),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(193),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_primitive] = ACTIONS(307),
    [anon_sym_mutable] = ACTIONS(309),
    [anon_sym_struct] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(313),
    [anon_sym_macro] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(193),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [anon_sym_LT_COLON] = ACTIONS(193),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_elseif] = ACTIONS(193),
    [anon_sym_else] = ACTIONS(193),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [sym_break_statement] = ACTIONS(327),
    [sym_continue_statement] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_quote] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(337),
    [anon_sym_import] = ACTIONS(337),
    [anon_sym_export] = ACTIONS(339),
    [anon_sym_COLON2] = ACTIONS(839),
    [anon_sym_PLUS] = ACTIONS(841),
    [anon_sym_begin] = ACTIONS(345),
    [anon_sym_GT_COLON] = ACTIONS(843),
    [anon_sym_DASH] = ACTIONS(843),
    [anon_sym_BANG] = ACTIONS(843),
    [anon_sym_TILDE] = ACTIONS(843),
    [anon_sym_] = ACTIONS(843),
    [anon_sym_2] = ACTIONS(843),
    [anon_sym_3] = ACTIONS(843),
    [anon_sym_4] = ACTIONS(843),
    [anon_sym_SQUOTE] = ACTIONS(193),
    [anon_sym_DOT_SQUOTE] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_QMARK] = ACTIONS(193),
    [anon_sym_EQ_GT] = ACTIONS(193),
    [anon_sym_LBRACK2] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(845),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_command_string] = ACTIONS(359),
    [sym_character] = ACTIONS(359),
    [sym__power_operator] = ACTIONS(361),
    [sym__times_operator] = ACTIONS(361),
    [sym__plus_operator] = ACTIONS(361),
    [sym__arrow_operator] = ACTIONS(193),
    [sym__comparison_operator] = ACTIONS(193),
    [anon_sym_LF] = ACTIONS(195),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(363),
  },
  [59] = {
    [sym_function_definition] = STATE(1850),
    [sym_abstract_definition] = STATE(1850),
    [sym_primitive_definition] = STATE(1850),
    [sym_struct_definition] = STATE(1850),
    [sym_module_definition] = STATE(1850),
    [sym_macro_definition] = STATE(1850),
    [sym_parameter_list] = STATE(4697),
    [sym_if_statement] = STATE(1850),
    [sym_try_statement] = STATE(1850),
    [sym_for_statement] = STATE(1850),
    [sym_while_statement] = STATE(1850),
    [sym_return_statement] = STATE(1850),
    [sym_let_statement] = STATE(1850),
    [sym_const_statement] = STATE(1850),
    [sym_quote_statement] = STATE(1850),
    [sym_import_statement] = STATE(1850),
    [sym_export_statement] = STATE(1850),
    [sym__expression] = STATE(1686),
    [sym__primary_expression] = STATE(1423),
    [sym_bare_tuple_expression] = STATE(1852),
    [sym_operator] = STATE(1423),
    [sym_parenthesized_expression] = STATE(1423),
    [sym_field_expression] = STATE(1284),
    [sym_subscript_expression] = STATE(1423),
    [sym_typed_expression] = STATE(1850),
    [sym_parameterized_identifier] = STATE(1423),
    [sym_compound_expression] = STATE(1850),
    [sym_call_expression] = STATE(1423),
    [sym_broadcast_call_expression] = STATE(1423),
    [sym_macro_expression] = STATE(1850),
    [sym_spread_expression] = STATE(1850),
    [sym_unary_expression] = STATE(1850),
    [sym_binary_expression] = STATE(1850),
    [sym_ternary_expression] = STATE(1850),
    [sym_pair_expression] = STATE(1850),
    [sym_tuple_expression] = STATE(1423),
    [sym_array_expression] = STATE(1423),
    [sym_matrix_expression] = STATE(1423),
    [sym_generator_expression] = STATE(1850),
    [sym_array_comprehension_expression] = STATE(1423),
    [sym_function_expression] = STATE(1850),
    [sym_range_expression] = STATE(1850),
    [sym_coefficient_expression] = STATE(1850),
    [sym_quote_expression] = STATE(1850),
    [sym_interpolation_expression] = STATE(1850),
    [sym_macro_identifier] = STATE(43),
    [sym_string] = STATE(1423),
    [sym_identifier] = ACTIONS(593),
    [anon_sym_function] = ACTIONS(595),
    [anon_sym_end] = ACTIONS(189),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_primitive] = ACTIONS(599),
    [anon_sym_mutable] = ACTIONS(601),
    [anon_sym_struct] = ACTIONS(603),
    [anon_sym_module] = ACTIONS(605),
    [anon_sym_macro] = ACTIONS(607),
    [anon_sym_LPAREN] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(191),
    [anon_sym_RPAREN] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(191),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(191),
    [anon_sym_RBRACE] = ACTIONS(191),
    [anon_sym_LT_COLON] = ACTIONS(191),
    [anon_sym_if] = ACTIONS(611),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_for] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(617),
    [sym_break_statement] = ACTIONS(619),
    [sym_continue_statement] = ACTIONS(619),
    [anon_sym_return] = ACTIONS(621),
    [anon_sym_let] = ACTIONS(623),
    [anon_sym_const] = ACTIONS(625),
    [anon_sym_quote] = ACTIONS(627),
    [anon_sym_using] = ACTIONS(629),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_export] = ACTIONS(631),
    [anon_sym_COLON2] = ACTIONS(633),
    [anon_sym_PLUS] = ACTIONS(635),
    [anon_sym_RBRACK] = ACTIONS(191),
    [anon_sym_begin] = ACTIONS(637),
    [anon_sym_GT_COLON] = ACTIONS(639),
    [anon_sym_DASH] = ACTIONS(641),
    [anon_sym_BANG] = ACTIONS(641),
    [anon_sym_TILDE] = ACTIONS(639),
    [anon_sym_] = ACTIONS(639),
    [anon_sym_2] = ACTIONS(639),
    [anon_sym_3] = ACTIONS(639),
    [anon_sym_4] = ACTIONS(639),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DOT_SQUOTE] = ACTIONS(191),
    [anon_sym_LT_PIPE] = ACTIONS(191),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_in] = ACTIONS(189),
    [anon_sym_isa] = ACTIONS(189),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(191),
    [anon_sym_QMARK] = ACTIONS(191),
    [anon_sym_EQ_GT] = ACTIONS(191),
    [anon_sym_LBRACK2] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(645),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [sym_command_string] = ACTIONS(653),
    [sym_character] = ACTIONS(653),
    [sym__power_operator] = ACTIONS(655),
    [sym__times_operator] = ACTIONS(657),
    [sym__plus_operator] = ACTIONS(657),
    [sym__arrow_operator] = ACTIONS(191),
    [sym__comparison_operator] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(653),
  },
  [60] = {
    [sym_function_definition] = STATE(1850),
    [sym_abstract_definition] = STATE(1850),
    [sym_primitive_definition] = STATE(1850),
    [sym_struct_definition] = STATE(1850),
    [sym_module_definition] = STATE(1850),
    [sym_macro_definition] = STATE(1850),
    [sym_parameter_list] = STATE(4877),
    [sym_if_statement] = STATE(1850),
    [sym_try_statement] = STATE(1850),
    [sym_for_statement] = STATE(1850),
    [sym_while_statement] = STATE(1850),
    [sym_return_statement] = STATE(1850),
    [sym_let_statement] = STATE(1850),
    [sym_const_statement] = STATE(1850),
    [sym_quote_statement] = STATE(1850),
    [sym_import_statement] = STATE(1850),
    [sym_export_statement] = STATE(1850),
    [sym__expression] = STATE(1861),
    [sym__primary_expression] = STATE(1423),
    [sym_operator] = STATE(1423),
    [sym_parenthesized_expression] = STATE(1423),
    [sym_field_expression] = STATE(1284),
    [sym_subscript_expression] = STATE(1423),
    [sym_typed_expression] = STATE(1850),
    [sym_parameterized_identifier] = STATE(1423),
    [sym_compound_expression] = STATE(1850),
    [sym_call_expression] = STATE(1423),
    [sym_broadcast_call_expression] = STATE(1423),
    [sym_macro_expression] = STATE(1850),
    [sym_spread_expression] = STATE(1850),
    [sym_unary_expression] = STATE(1850),
    [sym_binary_expression] = STATE(1850),
    [sym_ternary_expression] = STATE(1850),
    [sym_pair_expression] = STATE(1850),
    [sym_tuple_expression] = STATE(1423),
    [sym_array_expression] = STATE(1423),
    [sym_matrix_expression] = STATE(1423),
    [sym_generator_expression] = STATE(1850),
    [sym_array_comprehension_expression] = STATE(1423),
    [sym_function_expression] = STATE(1850),
    [sym_range_expression] = STATE(1850),
    [sym_coefficient_expression] = STATE(1850),
    [sym_quote_expression] = STATE(1850),
    [sym_interpolation_expression] = STATE(1850),
    [sym_macro_identifier] = STATE(51),
    [sym_string] = STATE(1423),
    [sym_identifier] = ACTIONS(921),
    [anon_sym_function] = ACTIONS(595),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_primitive] = ACTIONS(599),
    [anon_sym_mutable] = ACTIONS(601),
    [anon_sym_struct] = ACTIONS(603),
    [anon_sym_module] = ACTIONS(605),
    [anon_sym_macro] = ACTIONS(607),
    [anon_sym_LPAREN] = ACTIONS(609),
    [anon_sym_RPAREN] = ACTIONS(187),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(187),
    [anon_sym_COLON_COLON] = ACTIONS(187),
    [anon_sym_LT_COLON] = ACTIONS(187),
    [anon_sym_if] = ACTIONS(611),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_for] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(617),
    [sym_break_statement] = ACTIONS(619),
    [sym_continue_statement] = ACTIONS(619),
    [anon_sym_return] = ACTIONS(621),
    [anon_sym_let] = ACTIONS(623),
    [anon_sym_const] = ACTIONS(625),
    [anon_sym_quote] = ACTIONS(627),
    [anon_sym_using] = ACTIONS(629),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(631),
    [anon_sym_COLON2] = ACTIONS(923),
    [anon_sym_PLUS] = ACTIONS(925),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_RBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(637),
    [anon_sym_GT_COLON] = ACTIONS(927),
    [anon_sym_DASH] = ACTIONS(929),
    [anon_sym_BANG] = ACTIONS(929),
    [anon_sym_TILDE] = ACTIONS(927),
    [anon_sym_] = ACTIONS(927),
    [anon_sym_2] = ACTIONS(927),
    [anon_sym_3] = ACTIONS(927),
    [anon_sym_4] = ACTIONS(927),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(187),
    [anon_sym_LT_PIPE] = ACTIONS(187),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(187),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_EQ_GT] = ACTIONS(187),
    [anon_sym_LBRACK2] = ACTIONS(835),
    [anon_sym_DOLLAR] = ACTIONS(931),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [sym_command_string] = ACTIONS(653),
    [sym_character] = ACTIONS(653),
    [sym__power_operator] = ACTIONS(655),
    [sym__times_operator] = ACTIONS(657),
    [sym__plus_operator] = ACTIONS(657),
    [sym__arrow_operator] = ACTIONS(187),
    [sym__comparison_operator] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(653),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [61] = {
    [sym_function_definition] = STATE(2907),
    [sym_abstract_definition] = STATE(2907),
    [sym_primitive_definition] = STATE(2907),
    [sym_struct_definition] = STATE(2907),
    [sym_module_definition] = STATE(2907),
    [sym_macro_definition] = STATE(2907),
    [sym_parameter_list] = STATE(4723),
    [sym_if_statement] = STATE(2907),
    [sym_try_statement] = STATE(2907),
    [sym_for_statement] = STATE(2907),
    [sym_while_statement] = STATE(2907),
    [sym_return_statement] = STATE(2907),
    [sym_let_statement] = STATE(2907),
    [sym_const_statement] = STATE(2907),
    [sym_quote_statement] = STATE(2907),
    [sym_import_statement] = STATE(2907),
    [sym_export_statement] = STATE(2907),
    [sym__expression] = STATE(2932),
    [sym__primary_expression] = STATE(2646),
    [sym_operator] = STATE(2646),
    [sym_parenthesized_expression] = STATE(2646),
    [sym_field_expression] = STATE(2568),
    [sym_subscript_expression] = STATE(2646),
    [sym_typed_expression] = STATE(2907),
    [sym_parameterized_identifier] = STATE(2646),
    [sym_compound_expression] = STATE(2907),
    [sym_call_expression] = STATE(2646),
    [sym_broadcast_call_expression] = STATE(2646),
    [sym_macro_expression] = STATE(2907),
    [sym_spread_expression] = STATE(2907),
    [sym_unary_expression] = STATE(2907),
    [sym_binary_expression] = STATE(2907),
    [sym_ternary_expression] = STATE(2907),
    [sym_pair_expression] = STATE(2907),
    [sym_tuple_expression] = STATE(2646),
    [sym_array_expression] = STATE(2646),
    [sym_matrix_expression] = STATE(2646),
    [sym_generator_expression] = STATE(2907),
    [sym_array_comprehension_expression] = STATE(2646),
    [sym_function_expression] = STATE(2907),
    [sym_range_expression] = STATE(2907),
    [sym_coefficient_expression] = STATE(2907),
    [sym_quote_expression] = STATE(2907),
    [sym_interpolation_expression] = STATE(2907),
    [sym_macro_identifier] = STATE(63),
    [sym_string] = STATE(2646),
    [sym_identifier] = ACTIONS(1194),
    [anon_sym_function] = ACTIONS(533),
    [anon_sym_abstract] = ACTIONS(535),
    [anon_sym_primitive] = ACTIONS(537),
    [aux_sym_primitive_definition_token1] = ACTIONS(185),
    [anon_sym_mutable] = ACTIONS(539),
    [anon_sym_struct] = ACTIONS(541),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_macro] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_COMMA] = ACTIONS(187),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(187),
    [anon_sym_COLON_COLON] = ACTIONS(187),
    [anon_sym_LT_COLON] = ACTIONS(187),
    [anon_sym_if] = ACTIONS(549),
    [anon_sym_try] = ACTIONS(551),
    [anon_sym_for] = ACTIONS(553),
    [anon_sym_while] = ACTIONS(555),
    [sym_break_statement] = ACTIONS(557),
    [sym_continue_statement] = ACTIONS(557),
    [anon_sym_return] = ACTIONS(1196),
    [anon_sym_let] = ACTIONS(561),
    [anon_sym_const] = ACTIONS(1198),
    [anon_sym_quote] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(567),
    [anon_sym_import] = ACTIONS(567),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(569),
    [anon_sym_COLON2] = ACTIONS(1200),
    [anon_sym_PLUS] = ACTIONS(1202),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(575),
    [anon_sym_GT_COLON] = ACTIONS(1204),
    [anon_sym_DASH] = ACTIONS(1206),
    [anon_sym_BANG] = ACTIONS(1206),
    [anon_sym_TILDE] = ACTIONS(1204),
    [anon_sym_] = ACTIONS(1204),
    [anon_sym_2] = ACTIONS(1204),
    [anon_sym_3] = ACTIONS(1204),
    [anon_sym_4] = ACTIONS(1204),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(187),
    [anon_sym_LT_PIPE] = ACTIONS(187),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(187),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_EQ_GT] = ACTIONS(187),
    [anon_sym_LBRACK2] = ACTIONS(581),
    [anon_sym_DOLLAR] = ACTIONS(1208),
    [anon_sym_AT] = ACTIONS(1086),
    [sym_number] = ACTIONS(1210),
    [anon_sym_DQUOTE] = ACTIONS(587),
    [sym_command_string] = ACTIONS(589),
    [sym_character] = ACTIONS(589),
    [sym__power_operator] = ACTIONS(591),
    [sym__times_operator] = ACTIONS(591),
    [sym__plus_operator] = ACTIONS(591),
    [sym__arrow_operator] = ACTIONS(187),
    [sym__comparison_operator] = ACTIONS(185),
    [sym__assign_operator] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(589),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [62] = {
    [sym_function_definition] = STATE(2238),
    [sym_abstract_definition] = STATE(2238),
    [sym_primitive_definition] = STATE(2238),
    [sym_struct_definition] = STATE(2238),
    [sym_module_definition] = STATE(2238),
    [sym_macro_definition] = STATE(2238),
    [sym_parameter_list] = STATE(4667),
    [sym_if_statement] = STATE(2238),
    [sym_try_statement] = STATE(2238),
    [sym_for_statement] = STATE(2238),
    [sym_while_statement] = STATE(2238),
    [sym_return_statement] = STATE(2238),
    [sym_let_statement] = STATE(2238),
    [sym_const_statement] = STATE(2238),
    [sym_quote_statement] = STATE(2238),
    [sym_import_statement] = STATE(2238),
    [sym_export_statement] = STATE(2238),
    [sym__expression] = STATE(2352),
    [sym__primary_expression] = STATE(1728),
    [sym_operator] = STATE(1728),
    [sym_parenthesized_expression] = STATE(1728),
    [sym_field_expression] = STATE(1401),
    [sym_subscript_expression] = STATE(1728),
    [sym_typed_expression] = STATE(2238),
    [sym_parameterized_identifier] = STATE(1728),
    [sym_compound_expression] = STATE(2238),
    [sym_call_expression] = STATE(1728),
    [sym_broadcast_call_expression] = STATE(1728),
    [sym_macro_expression] = STATE(2238),
    [sym_macro_argument_list] = STATE(2262),
    [sym_spread_expression] = STATE(2238),
    [sym_unary_expression] = STATE(2238),
    [sym_binary_expression] = STATE(2238),
    [sym_ternary_expression] = STATE(2238),
    [sym_pair_expression] = STATE(2238),
    [sym_tuple_expression] = STATE(1728),
    [sym_array_expression] = STATE(1728),
    [sym_matrix_expression] = STATE(1728),
    [sym_generator_expression] = STATE(2238),
    [sym_array_comprehension_expression] = STATE(1728),
    [sym_function_expression] = STATE(2238),
    [sym_range_expression] = STATE(2238),
    [sym_coefficient_expression] = STATE(2238),
    [sym_quote_expression] = STATE(2238),
    [sym_interpolation_expression] = STATE(2238),
    [sym_macro_identifier] = STATE(62),
    [sym_string] = STATE(1728),
    [aux_sym_macro_argument_list_repeat1] = STATE(91),
    [sym_identifier] = ACTIONS(1032),
    [anon_sym_function] = ACTIONS(1034),
    [anon_sym_abstract] = ACTIONS(1036),
    [anon_sym_primitive] = ACTIONS(1038),
    [aux_sym_primitive_definition_token1] = ACTIONS(119),
    [anon_sym_mutable] = ACTIONS(1040),
    [anon_sym_struct] = ACTIONS(1042),
    [anon_sym_module] = ACTIONS(1044),
    [anon_sym_macro] = ACTIONS(1046),
    [anon_sym_LPAREN] = ACTIONS(1048),
    [anon_sym_COMMA] = ACTIONS(177),
    [anon_sym_EQ] = ACTIONS(119),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(177),
    [anon_sym_COLON_COLON] = ACTIONS(177),
    [anon_sym_LT_COLON] = ACTIONS(177),
    [anon_sym_if] = ACTIONS(1050),
    [anon_sym_try] = ACTIONS(1052),
    [anon_sym_for] = ACTIONS(1054),
    [anon_sym_while] = ACTIONS(1056),
    [sym_break_statement] = ACTIONS(1058),
    [sym_continue_statement] = ACTIONS(1058),
    [anon_sym_return] = ACTIONS(1060),
    [anon_sym_let] = ACTIONS(1062),
    [anon_sym_const] = ACTIONS(1064),
    [anon_sym_quote] = ACTIONS(1066),
    [anon_sym_using] = ACTIONS(1068),
    [anon_sym_import] = ACTIONS(1068),
    [anon_sym_export] = ACTIONS(1070),
    [anon_sym_COLON2] = ACTIONS(1072),
    [anon_sym_PLUS] = ACTIONS(1074),
    [anon_sym_begin] = ACTIONS(1076),
    [anon_sym_GT_COLON] = ACTIONS(1078),
    [anon_sym_DASH] = ACTIONS(1080),
    [anon_sym_BANG] = ACTIONS(1080),
    [anon_sym_TILDE] = ACTIONS(1078),
    [anon_sym_] = ACTIONS(1078),
    [anon_sym_2] = ACTIONS(1078),
    [anon_sym_3] = ACTIONS(1078),
    [anon_sym_4] = ACTIONS(1078),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(177),
    [anon_sym_LT_PIPE] = ACTIONS(177),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_QMARK] = ACTIONS(177),
    [anon_sym_EQ_GT] = ACTIONS(177),
    [anon_sym_LBRACK2] = ACTIONS(1212),
    [anon_sym_DOLLAR] = ACTIONS(1084),
    [anon_sym_AT] = ACTIONS(1086),
    [sym_number] = ACTIONS(1088),
    [anon_sym_DQUOTE] = ACTIONS(1090),
    [sym_command_string] = ACTIONS(1092),
    [sym_character] = ACTIONS(1092),
    [sym__power_operator] = ACTIONS(1094),
    [sym__times_operator] = ACTIONS(1094),
    [sym__plus_operator] = ACTIONS(1094),
    [sym__arrow_operator] = ACTIONS(177),
    [sym__comparison_operator] = ACTIONS(119),
    [sym__assign_operator] = ACTIONS(119),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(1092),
    [sym__immediate_paren] = ACTIONS(1214),
  },
  [63] = {
    [sym_function_definition] = STATE(2238),
    [sym_abstract_definition] = STATE(2238),
    [sym_primitive_definition] = STATE(2238),
    [sym_struct_definition] = STATE(2238),
    [sym_module_definition] = STATE(2238),
    [sym_macro_definition] = STATE(2238),
    [sym_parameter_list] = STATE(4667),
    [sym_if_statement] = STATE(2238),
    [sym_try_statement] = STATE(2238),
    [sym_for_statement] = STATE(2238),
    [sym_while_statement] = STATE(2238),
    [sym_return_statement] = STATE(2238),
    [sym_let_statement] = STATE(2238),
    [sym_const_statement] = STATE(2238),
    [sym_quote_statement] = STATE(2238),
    [sym_import_statement] = STATE(2238),
    [sym_export_statement] = STATE(2238),
    [sym__expression] = STATE(2352),
    [sym__primary_expression] = STATE(1728),
    [sym_operator] = STATE(1728),
    [sym_parenthesized_expression] = STATE(1728),
    [sym_field_expression] = STATE(1401),
    [sym_subscript_expression] = STATE(1728),
    [sym_typed_expression] = STATE(2238),
    [sym_parameterized_identifier] = STATE(1728),
    [sym_compound_expression] = STATE(2238),
    [sym_call_expression] = STATE(1728),
    [sym_broadcast_call_expression] = STATE(1728),
    [sym_macro_expression] = STATE(2238),
    [sym_macro_argument_list] = STATE(2942),
    [sym_spread_expression] = STATE(2238),
    [sym_unary_expression] = STATE(2238),
    [sym_binary_expression] = STATE(2238),
    [sym_ternary_expression] = STATE(2238),
    [sym_pair_expression] = STATE(2238),
    [sym_tuple_expression] = STATE(1728),
    [sym_array_expression] = STATE(1728),
    [sym_matrix_expression] = STATE(1728),
    [sym_generator_expression] = STATE(2238),
    [sym_array_comprehension_expression] = STATE(1728),
    [sym_function_expression] = STATE(2238),
    [sym_range_expression] = STATE(2238),
    [sym_coefficient_expression] = STATE(2238),
    [sym_quote_expression] = STATE(2238),
    [sym_interpolation_expression] = STATE(2238),
    [sym_macro_identifier] = STATE(62),
    [sym_string] = STATE(1728),
    [aux_sym_macro_argument_list_repeat1] = STATE(91),
    [sym_identifier] = ACTIONS(1032),
    [anon_sym_function] = ACTIONS(1034),
    [anon_sym_abstract] = ACTIONS(1036),
    [anon_sym_primitive] = ACTIONS(1038),
    [aux_sym_primitive_definition_token1] = ACTIONS(119),
    [anon_sym_mutable] = ACTIONS(1040),
    [anon_sym_struct] = ACTIONS(1042),
    [anon_sym_module] = ACTIONS(1044),
    [anon_sym_macro] = ACTIONS(1046),
    [anon_sym_LPAREN] = ACTIONS(1048),
    [anon_sym_COMMA] = ACTIONS(177),
    [anon_sym_EQ] = ACTIONS(119),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(177),
    [anon_sym_COLON_COLON] = ACTIONS(177),
    [anon_sym_LT_COLON] = ACTIONS(177),
    [anon_sym_if] = ACTIONS(1050),
    [anon_sym_try] = ACTIONS(1052),
    [anon_sym_for] = ACTIONS(1054),
    [anon_sym_while] = ACTIONS(1056),
    [sym_break_statement] = ACTIONS(1058),
    [sym_continue_statement] = ACTIONS(1058),
    [anon_sym_return] = ACTIONS(1060),
    [anon_sym_let] = ACTIONS(1062),
    [anon_sym_const] = ACTIONS(1064),
    [anon_sym_quote] = ACTIONS(1066),
    [anon_sym_using] = ACTIONS(1068),
    [anon_sym_import] = ACTIONS(1068),
    [anon_sym_export] = ACTIONS(1070),
    [anon_sym_COLON2] = ACTIONS(1072),
    [anon_sym_PLUS] = ACTIONS(1074),
    [anon_sym_begin] = ACTIONS(1076),
    [anon_sym_GT_COLON] = ACTIONS(1078),
    [anon_sym_DASH] = ACTIONS(1080),
    [anon_sym_BANG] = ACTIONS(1080),
    [anon_sym_TILDE] = ACTIONS(1078),
    [anon_sym_] = ACTIONS(1078),
    [anon_sym_2] = ACTIONS(1078),
    [anon_sym_3] = ACTIONS(1078),
    [anon_sym_4] = ACTIONS(1078),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(177),
    [anon_sym_LT_PIPE] = ACTIONS(177),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_QMARK] = ACTIONS(177),
    [anon_sym_EQ_GT] = ACTIONS(177),
    [anon_sym_LBRACK2] = ACTIONS(1212),
    [anon_sym_DOLLAR] = ACTIONS(1084),
    [anon_sym_AT] = ACTIONS(1086),
    [sym_number] = ACTIONS(1088),
    [anon_sym_DQUOTE] = ACTIONS(1090),
    [sym_command_string] = ACTIONS(1092),
    [sym_character] = ACTIONS(1092),
    [sym__power_operator] = ACTIONS(1094),
    [sym__times_operator] = ACTIONS(1094),
    [sym__plus_operator] = ACTIONS(1094),
    [sym__arrow_operator] = ACTIONS(177),
    [sym__comparison_operator] = ACTIONS(119),
    [sym__assign_operator] = ACTIONS(119),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(1092),
    [sym__immediate_paren] = ACTIONS(529),
  },
  [64] = {
    [sym_function_definition] = STATE(1982),
    [sym_abstract_definition] = STATE(1982),
    [sym_primitive_definition] = STATE(1982),
    [sym_struct_definition] = STATE(1982),
    [sym_module_definition] = STATE(1982),
    [sym_macro_definition] = STATE(1982),
    [sym_parameter_list] = STATE(5092),
    [sym_if_statement] = STATE(1982),
    [sym_try_statement] = STATE(1982),
    [sym_for_statement] = STATE(1982),
    [sym_while_statement] = STATE(1982),
    [sym_return_statement] = STATE(1982),
    [sym_let_statement] = STATE(1982),
    [sym_const_statement] = STATE(1982),
    [sym_quote_statement] = STATE(1982),
    [sym_import_statement] = STATE(1982),
    [sym_export_statement] = STATE(1982),
    [sym__expression] = STATE(1981),
    [sym__primary_expression] = STATE(1495),
    [sym_operator] = STATE(1495),
    [sym_parenthesized_expression] = STATE(1495),
    [sym_field_expression] = STATE(1192),
    [sym_subscript_expression] = STATE(1495),
    [sym_typed_expression] = STATE(1982),
    [sym_parameterized_identifier] = STATE(1495),
    [sym_compound_expression] = STATE(1982),
    [sym_call_expression] = STATE(1495),
    [sym_broadcast_call_expression] = STATE(1495),
    [sym_macro_expression] = STATE(1982),
    [sym_spread_expression] = STATE(1982),
    [sym_unary_expression] = STATE(1982),
    [sym_binary_expression] = STATE(1982),
    [sym_ternary_expression] = STATE(1982),
    [sym_pair_expression] = STATE(1982),
    [sym_tuple_expression] = STATE(1495),
    [sym_array_expression] = STATE(1495),
    [sym_matrix_expression] = STATE(1495),
    [sym_generator_expression] = STATE(1982),
    [sym_array_comprehension_expression] = STATE(1495),
    [sym_function_expression] = STATE(1982),
    [sym_range_expression] = STATE(1982),
    [sym_coefficient_expression] = STATE(1982),
    [sym_quote_expression] = STATE(1982),
    [sym_interpolation_expression] = STATE(1982),
    [sym_macro_identifier] = STATE(44),
    [sym_string] = STATE(1495),
    [aux_sym_macro_argument_list_repeat1] = STATE(57),
    [ts_builtin_sym_end] = ACTIONS(195),
    [sym_identifier] = ACTIONS(849),
    [anon_sym_function] = ACTIONS(851),
    [anon_sym_abstract] = ACTIONS(853),
    [anon_sym_primitive] = ACTIONS(855),
    [anon_sym_mutable] = ACTIONS(857),
    [anon_sym_struct] = ACTIONS(859),
    [anon_sym_module] = ACTIONS(861),
    [anon_sym_macro] = ACTIONS(863),
    [anon_sym_LPAREN] = ACTIONS(865),
    [anon_sym_COMMA] = ACTIONS(193),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym_EQ] = ACTIONS(193),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [anon_sym_LT_COLON] = ACTIONS(193),
    [anon_sym_if] = ACTIONS(867),
    [anon_sym_try] = ACTIONS(869),
    [anon_sym_for] = ACTIONS(871),
    [anon_sym_while] = ACTIONS(873),
    [sym_break_statement] = ACTIONS(875),
    [sym_continue_statement] = ACTIONS(875),
    [anon_sym_return] = ACTIONS(877),
    [anon_sym_let] = ACTIONS(879),
    [anon_sym_const] = ACTIONS(881),
    [anon_sym_quote] = ACTIONS(883),
    [anon_sym_using] = ACTIONS(885),
    [anon_sym_import] = ACTIONS(885),
    [anon_sym_export] = ACTIONS(887),
    [anon_sym_COLON2] = ACTIONS(889),
    [anon_sym_PLUS] = ACTIONS(891),
    [anon_sym_begin] = ACTIONS(893),
    [anon_sym_GT_COLON] = ACTIONS(895),
    [anon_sym_DASH] = ACTIONS(895),
    [anon_sym_BANG] = ACTIONS(895),
    [anon_sym_TILDE] = ACTIONS(895),
    [anon_sym_] = ACTIONS(895),
    [anon_sym_2] = ACTIONS(895),
    [anon_sym_3] = ACTIONS(895),
    [anon_sym_4] = ACTIONS(895),
    [anon_sym_SQUOTE] = ACTIONS(193),
    [anon_sym_DOT_SQUOTE] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_QMARK] = ACTIONS(193),
    [anon_sym_EQ_GT] = ACTIONS(193),
    [anon_sym_LBRACK2] = ACTIONS(897),
    [anon_sym_DOLLAR] = ACTIONS(899),
    [anon_sym_AT] = ACTIONS(831),
    [sym_number] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(903),
    [sym_command_string] = ACTIONS(905),
    [sym_character] = ACTIONS(905),
    [sym__power_operator] = ACTIONS(907),
    [sym__times_operator] = ACTIONS(907),
    [sym__plus_operator] = ACTIONS(907),
    [sym__arrow_operator] = ACTIONS(193),
    [sym__comparison_operator] = ACTIONS(193),
    [sym__assign_operator] = ACTIONS(193),
    [anon_sym_LF] = ACTIONS(195),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(909),
  },
  [65] = {
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5050),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(3139),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(2781),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(40),
    [sym_string] = STATE(2565),
    [ts_builtin_sym_end] = ACTIONS(191),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(189),
    [anon_sym_SEMI] = ACTIONS(189),
    [anon_sym_EQ] = ACTIONS(189),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(189),
    [anon_sym_COLON_COLON] = ACTIONS(189),
    [anon_sym_LT_COLON] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(35),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(39),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(823),
    [anon_sym_PLUS] = ACTIONS(825),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(827),
    [anon_sym_DASH] = ACTIONS(827),
    [anon_sym_BANG] = ACTIONS(827),
    [anon_sym_TILDE] = ACTIONS(827),
    [anon_sym_] = ACTIONS(827),
    [anon_sym_2] = ACTIONS(827),
    [anon_sym_3] = ACTIONS(827),
    [anon_sym_4] = ACTIONS(827),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym_DOT_SQUOTE] = ACTIONS(189),
    [anon_sym_LT_PIPE] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_in] = ACTIONS(189),
    [anon_sym_isa] = ACTIONS(189),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(189),
    [anon_sym_QMARK] = ACTIONS(189),
    [anon_sym_EQ_GT] = ACTIONS(189),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [anon_sym_AT] = ACTIONS(831),
    [sym_number] = ACTIONS(833),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(69),
    [sym__plus_operator] = ACTIONS(69),
    [sym__arrow_operator] = ACTIONS(189),
    [sym__comparison_operator] = ACTIONS(189),
    [sym__assign_operator] = ACTIONS(189),
    [anon_sym_LF] = ACTIONS(191),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [66] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4936),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(1913),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(38),
    [sym_string] = STATE(1466),
    [aux_sym_macro_argument_list_repeat1] = STATE(66),
    [sym_identifier] = ACTIONS(1216),
    [anon_sym_function] = ACTIONS(1219),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_abstract] = ACTIONS(1222),
    [anon_sym_primitive] = ACTIONS(1225),
    [anon_sym_mutable] = ACTIONS(1228),
    [anon_sym_struct] = ACTIONS(1231),
    [anon_sym_module] = ACTIONS(1234),
    [anon_sym_macro] = ACTIONS(1237),
    [anon_sym_LPAREN] = ACTIONS(1240),
    [anon_sym_COMMA] = ACTIONS(203),
    [anon_sym_SEMI] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_COLON_COLON] = ACTIONS(203),
    [anon_sym_LT_COLON] = ACTIONS(203),
    [anon_sym_if] = ACTIONS(1243),
    [anon_sym_elseif] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(203),
    [anon_sym_try] = ACTIONS(1246),
    [anon_sym_for] = ACTIONS(1249),
    [anon_sym_while] = ACTIONS(1252),
    [sym_break_statement] = ACTIONS(1255),
    [sym_continue_statement] = ACTIONS(1255),
    [anon_sym_return] = ACTIONS(1258),
    [anon_sym_let] = ACTIONS(1261),
    [anon_sym_const] = ACTIONS(1264),
    [anon_sym_quote] = ACTIONS(1267),
    [anon_sym_using] = ACTIONS(1270),
    [anon_sym_import] = ACTIONS(1270),
    [anon_sym_export] = ACTIONS(1273),
    [anon_sym_COLON2] = ACTIONS(1276),
    [anon_sym_PLUS] = ACTIONS(1279),
    [anon_sym_begin] = ACTIONS(1282),
    [anon_sym_GT_COLON] = ACTIONS(1285),
    [anon_sym_DASH] = ACTIONS(1285),
    [anon_sym_BANG] = ACTIONS(1285),
    [anon_sym_TILDE] = ACTIONS(1285),
    [anon_sym_] = ACTIONS(1285),
    [anon_sym_2] = ACTIONS(1285),
    [anon_sym_3] = ACTIONS(1285),
    [anon_sym_4] = ACTIONS(1285),
    [anon_sym_SQUOTE] = ACTIONS(203),
    [anon_sym_DOT_SQUOTE] = ACTIONS(203),
    [anon_sym_LT_PIPE] = ACTIONS(203),
    [anon_sym_PIPE_GT] = ACTIONS(203),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(203),
    [anon_sym_EQ_GT] = ACTIONS(203),
    [anon_sym_LBRACK2] = ACTIONS(1288),
    [anon_sym_DOLLAR] = ACTIONS(1291),
    [anon_sym_AT] = ACTIONS(1294),
    [sym_number] = ACTIONS(1297),
    [anon_sym_DQUOTE] = ACTIONS(1300),
    [sym_command_string] = ACTIONS(1303),
    [sym_character] = ACTIONS(1303),
    [sym__power_operator] = ACTIONS(1306),
    [sym__times_operator] = ACTIONS(1306),
    [sym__plus_operator] = ACTIONS(1306),
    [sym__arrow_operator] = ACTIONS(203),
    [sym__comparison_operator] = ACTIONS(203),
    [anon_sym_LF] = ACTIONS(292),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(1309),
  },
  [67] = {
    [sym_function_definition] = STATE(1850),
    [sym_abstract_definition] = STATE(1850),
    [sym_primitive_definition] = STATE(1850),
    [sym_struct_definition] = STATE(1850),
    [sym_module_definition] = STATE(1850),
    [sym_macro_definition] = STATE(1850),
    [sym_parameter_list] = STATE(4697),
    [sym_if_statement] = STATE(1850),
    [sym_try_statement] = STATE(1850),
    [sym_for_statement] = STATE(1850),
    [sym_while_statement] = STATE(1850),
    [sym_return_statement] = STATE(1850),
    [sym_let_statement] = STATE(1850),
    [sym_const_statement] = STATE(1850),
    [sym_quote_statement] = STATE(1850),
    [sym_import_statement] = STATE(1850),
    [sym_export_statement] = STATE(1850),
    [sym__expression] = STATE(1766),
    [sym__primary_expression] = STATE(1423),
    [sym_operator] = STATE(1423),
    [sym_parenthesized_expression] = STATE(1423),
    [sym_field_expression] = STATE(1284),
    [sym_subscript_expression] = STATE(1423),
    [sym_typed_expression] = STATE(1850),
    [sym_parameterized_identifier] = STATE(1423),
    [sym_compound_expression] = STATE(1850),
    [sym_call_expression] = STATE(1423),
    [sym_broadcast_call_expression] = STATE(1423),
    [sym_macro_expression] = STATE(1850),
    [sym_spread_expression] = STATE(1850),
    [sym_unary_expression] = STATE(1850),
    [sym_binary_expression] = STATE(1850),
    [sym_ternary_expression] = STATE(1850),
    [sym_pair_expression] = STATE(1850),
    [sym_tuple_expression] = STATE(1423),
    [sym_array_expression] = STATE(1423),
    [sym_matrix_expression] = STATE(1423),
    [sym_generator_expression] = STATE(1850),
    [sym_array_comprehension_expression] = STATE(1423),
    [sym_function_expression] = STATE(1850),
    [sym_range_expression] = STATE(1850),
    [sym_coefficient_expression] = STATE(1850),
    [sym_quote_expression] = STATE(1850),
    [sym_interpolation_expression] = STATE(1850),
    [sym_macro_identifier] = STATE(43),
    [sym_string] = STATE(1423),
    [aux_sym_macro_argument_list_repeat1] = STATE(52),
    [sym_identifier] = ACTIONS(593),
    [anon_sym_function] = ACTIONS(595),
    [anon_sym_end] = ACTIONS(193),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_primitive] = ACTIONS(599),
    [anon_sym_mutable] = ACTIONS(601),
    [anon_sym_struct] = ACTIONS(603),
    [anon_sym_module] = ACTIONS(605),
    [anon_sym_macro] = ACTIONS(607),
    [anon_sym_LPAREN] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(195),
    [anon_sym_RPAREN] = ACTIONS(195),
    [anon_sym_SEMI] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(195),
    [anon_sym_COLON_COLON] = ACTIONS(195),
    [anon_sym_RBRACE] = ACTIONS(195),
    [anon_sym_LT_COLON] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(611),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_for] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(617),
    [sym_break_statement] = ACTIONS(619),
    [sym_continue_statement] = ACTIONS(619),
    [anon_sym_return] = ACTIONS(621),
    [anon_sym_let] = ACTIONS(623),
    [anon_sym_const] = ACTIONS(625),
    [anon_sym_quote] = ACTIONS(627),
    [anon_sym_using] = ACTIONS(629),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_export] = ACTIONS(631),
    [anon_sym_COLON2] = ACTIONS(633),
    [anon_sym_PLUS] = ACTIONS(635),
    [anon_sym_RBRACK] = ACTIONS(195),
    [anon_sym_begin] = ACTIONS(637),
    [anon_sym_GT_COLON] = ACTIONS(639),
    [anon_sym_DASH] = ACTIONS(641),
    [anon_sym_BANG] = ACTIONS(641),
    [anon_sym_TILDE] = ACTIONS(639),
    [anon_sym_] = ACTIONS(639),
    [anon_sym_2] = ACTIONS(639),
    [anon_sym_3] = ACTIONS(639),
    [anon_sym_4] = ACTIONS(639),
    [anon_sym_SQUOTE] = ACTIONS(193),
    [anon_sym_DOT_SQUOTE] = ACTIONS(195),
    [anon_sym_LT_PIPE] = ACTIONS(195),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(195),
    [anon_sym_QMARK] = ACTIONS(195),
    [anon_sym_EQ_GT] = ACTIONS(195),
    [anon_sym_LBRACK2] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(645),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [sym_command_string] = ACTIONS(653),
    [sym_character] = ACTIONS(653),
    [sym__power_operator] = ACTIONS(655),
    [sym__times_operator] = ACTIONS(657),
    [sym__plus_operator] = ACTIONS(657),
    [sym__arrow_operator] = ACTIONS(195),
    [sym__comparison_operator] = ACTIONS(193),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(653),
  },
  [68] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4821),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(2192),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(47),
    [sym_string] = STATE(1466),
    [aux_sym_macro_argument_list_repeat1] = STATE(68),
    [sym_identifier] = ACTIONS(1312),
    [anon_sym_function] = ACTIONS(1219),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_abstract] = ACTIONS(1222),
    [anon_sym_primitive] = ACTIONS(1225),
    [anon_sym_mutable] = ACTIONS(1228),
    [anon_sym_struct] = ACTIONS(1231),
    [anon_sym_module] = ACTIONS(1234),
    [anon_sym_macro] = ACTIONS(1237),
    [anon_sym_LPAREN] = ACTIONS(1240),
    [anon_sym_SEMI] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_COLON_COLON] = ACTIONS(203),
    [anon_sym_LT_COLON] = ACTIONS(203),
    [anon_sym_if] = ACTIONS(1243),
    [anon_sym_elseif] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(203),
    [anon_sym_try] = ACTIONS(1246),
    [anon_sym_for] = ACTIONS(1249),
    [anon_sym_while] = ACTIONS(1252),
    [sym_break_statement] = ACTIONS(1255),
    [sym_continue_statement] = ACTIONS(1255),
    [anon_sym_return] = ACTIONS(1258),
    [anon_sym_let] = ACTIONS(1261),
    [anon_sym_const] = ACTIONS(1264),
    [anon_sym_quote] = ACTIONS(1267),
    [anon_sym_using] = ACTIONS(1270),
    [anon_sym_import] = ACTIONS(1270),
    [anon_sym_export] = ACTIONS(1273),
    [anon_sym_COLON2] = ACTIONS(1315),
    [anon_sym_PLUS] = ACTIONS(1318),
    [anon_sym_begin] = ACTIONS(1282),
    [anon_sym_GT_COLON] = ACTIONS(1321),
    [anon_sym_DASH] = ACTIONS(1321),
    [anon_sym_BANG] = ACTIONS(1321),
    [anon_sym_TILDE] = ACTIONS(1321),
    [anon_sym_] = ACTIONS(1321),
    [anon_sym_2] = ACTIONS(1321),
    [anon_sym_3] = ACTIONS(1321),
    [anon_sym_4] = ACTIONS(1321),
    [anon_sym_SQUOTE] = ACTIONS(203),
    [anon_sym_DOT_SQUOTE] = ACTIONS(203),
    [anon_sym_LT_PIPE] = ACTIONS(203),
    [anon_sym_PIPE_GT] = ACTIONS(203),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(203),
    [anon_sym_EQ_GT] = ACTIONS(203),
    [anon_sym_LBRACK2] = ACTIONS(1288),
    [anon_sym_DOLLAR] = ACTIONS(1324),
    [anon_sym_AT] = ACTIONS(1294),
    [sym_number] = ACTIONS(1297),
    [anon_sym_DQUOTE] = ACTIONS(1300),
    [sym_command_string] = ACTIONS(1303),
    [sym_character] = ACTIONS(1303),
    [sym__power_operator] = ACTIONS(1306),
    [sym__times_operator] = ACTIONS(1306),
    [sym__plus_operator] = ACTIONS(1306),
    [sym__arrow_operator] = ACTIONS(203),
    [sym__comparison_operator] = ACTIONS(203),
    [anon_sym_LF] = ACTIONS(292),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(1309),
  },
  [69] = {
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5050),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(3175),
    [sym__primary_expression] = STATE(2565),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(40),
    [sym_string] = STATE(2565),
    [ts_builtin_sym_end] = ACTIONS(299),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(297),
    [anon_sym_SEMI] = ACTIONS(297),
    [anon_sym_EQ] = ACTIONS(297),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(297),
    [anon_sym_COLON_COLON] = ACTIONS(297),
    [anon_sym_LT_COLON] = ACTIONS(297),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(35),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(39),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(823),
    [anon_sym_PLUS] = ACTIONS(825),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(827),
    [anon_sym_DASH] = ACTIONS(827),
    [anon_sym_BANG] = ACTIONS(827),
    [anon_sym_TILDE] = ACTIONS(827),
    [anon_sym_] = ACTIONS(827),
    [anon_sym_2] = ACTIONS(827),
    [anon_sym_3] = ACTIONS(827),
    [anon_sym_4] = ACTIONS(827),
    [anon_sym_SQUOTE] = ACTIONS(297),
    [anon_sym_DOT_SQUOTE] = ACTIONS(297),
    [anon_sym_LT_PIPE] = ACTIONS(297),
    [anon_sym_PIPE_GT] = ACTIONS(297),
    [anon_sym_in] = ACTIONS(297),
    [anon_sym_isa] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(297),
    [anon_sym_EQ_GT] = ACTIONS(297),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [anon_sym_AT] = ACTIONS(831),
    [sym_number] = ACTIONS(833),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(69),
    [sym__plus_operator] = ACTIONS(69),
    [sym__arrow_operator] = ACTIONS(297),
    [sym__comparison_operator] = ACTIONS(297),
    [sym__assign_operator] = ACTIONS(297),
    [anon_sym_LF] = ACTIONS(299),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [70] = {
    [sym__expression_list] = STATE(4659),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1327),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(1329),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(1331),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [71] = {
    [sym__expression_list] = STATE(4794),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1333),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(1335),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(1337),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [72] = {
    [sym__expression_list] = STATE(4749),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1339),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(1341),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(1343),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [73] = {
    [sym__expression_list] = STATE(4552),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1345),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(1347),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(1349),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [74] = {
    [sym_function_definition] = STATE(1850),
    [sym_abstract_definition] = STATE(1850),
    [sym_primitive_definition] = STATE(1850),
    [sym_struct_definition] = STATE(1850),
    [sym_module_definition] = STATE(1850),
    [sym_macro_definition] = STATE(1850),
    [sym_parameter_list] = STATE(4877),
    [sym_if_statement] = STATE(1850),
    [sym_try_statement] = STATE(1850),
    [sym_for_statement] = STATE(1850),
    [sym_while_statement] = STATE(1850),
    [sym_return_statement] = STATE(1850),
    [sym_let_statement] = STATE(1850),
    [sym_const_statement] = STATE(1850),
    [sym_quote_statement] = STATE(1850),
    [sym_import_statement] = STATE(1850),
    [sym_export_statement] = STATE(1850),
    [sym__expression] = STATE(2275),
    [sym__primary_expression] = STATE(1423),
    [sym_operator] = STATE(1423),
    [sym_parenthesized_expression] = STATE(1423),
    [sym_field_expression] = STATE(1284),
    [sym_subscript_expression] = STATE(1423),
    [sym_typed_expression] = STATE(1850),
    [sym_parameterized_identifier] = STATE(1423),
    [sym_compound_expression] = STATE(1850),
    [sym_call_expression] = STATE(1423),
    [sym_broadcast_call_expression] = STATE(1423),
    [sym_macro_expression] = STATE(1850),
    [sym_macro_argument_list] = STATE(3001),
    [sym_spread_expression] = STATE(1850),
    [sym_unary_expression] = STATE(1850),
    [sym_binary_expression] = STATE(1850),
    [sym_ternary_expression] = STATE(1850),
    [sym_pair_expression] = STATE(1850),
    [sym_tuple_expression] = STATE(1423),
    [sym_array_expression] = STATE(1423),
    [sym_matrix_expression] = STATE(1423),
    [sym_generator_expression] = STATE(1850),
    [sym_array_comprehension_expression] = STATE(1423),
    [sym_function_expression] = STATE(1850),
    [sym_range_expression] = STATE(1850),
    [sym_coefficient_expression] = STATE(1850),
    [sym_quote_expression] = STATE(1850),
    [sym_interpolation_expression] = STATE(1850),
    [sym_macro_identifier] = STATE(51),
    [sym_string] = STATE(1423),
    [aux_sym_macro_argument_list_repeat1] = STATE(97),
    [sym_identifier] = ACTIONS(921),
    [anon_sym_function] = ACTIONS(595),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_primitive] = ACTIONS(599),
    [anon_sym_mutable] = ACTIONS(601),
    [anon_sym_struct] = ACTIONS(603),
    [anon_sym_module] = ACTIONS(605),
    [anon_sym_macro] = ACTIONS(607),
    [anon_sym_LPAREN] = ACTIONS(609),
    [anon_sym_RPAREN] = ACTIONS(177),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(177),
    [anon_sym_COLON_COLON] = ACTIONS(177),
    [anon_sym_LT_COLON] = ACTIONS(177),
    [anon_sym_if] = ACTIONS(611),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_for] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(617),
    [sym_break_statement] = ACTIONS(619),
    [sym_continue_statement] = ACTIONS(619),
    [anon_sym_return] = ACTIONS(621),
    [anon_sym_let] = ACTIONS(623),
    [anon_sym_const] = ACTIONS(625),
    [anon_sym_quote] = ACTIONS(627),
    [anon_sym_using] = ACTIONS(629),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_export] = ACTIONS(631),
    [anon_sym_COLON2] = ACTIONS(923),
    [anon_sym_PLUS] = ACTIONS(925),
    [anon_sym_RBRACK] = ACTIONS(177),
    [anon_sym_begin] = ACTIONS(637),
    [anon_sym_GT_COLON] = ACTIONS(927),
    [anon_sym_DASH] = ACTIONS(929),
    [anon_sym_BANG] = ACTIONS(929),
    [anon_sym_TILDE] = ACTIONS(927),
    [anon_sym_] = ACTIONS(927),
    [anon_sym_2] = ACTIONS(927),
    [anon_sym_3] = ACTIONS(927),
    [anon_sym_4] = ACTIONS(927),
    [anon_sym_SQUOTE] = ACTIONS(119),
    [anon_sym_DOT_SQUOTE] = ACTIONS(177),
    [anon_sym_LT_PIPE] = ACTIONS(177),
    [anon_sym_PIPE_GT] = ACTIONS(119),
    [anon_sym_in] = ACTIONS(119),
    [anon_sym_isa] = ACTIONS(119),
    [anon_sym_PIPE_PIPE] = ACTIONS(119),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_QMARK] = ACTIONS(177),
    [anon_sym_EQ_GT] = ACTIONS(177),
    [anon_sym_LBRACK2] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(931),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [sym_command_string] = ACTIONS(653),
    [sym_character] = ACTIONS(653),
    [sym__power_operator] = ACTIONS(655),
    [sym__times_operator] = ACTIONS(657),
    [sym__plus_operator] = ACTIONS(657),
    [sym__arrow_operator] = ACTIONS(177),
    [sym__comparison_operator] = ACTIONS(119),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(653),
    [sym__immediate_paren] = ACTIONS(659),
  },
  [75] = {
    [sym__expression_list] = STATE(4973),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1351),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(1353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(1355),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [76] = {
    [sym__expression_list] = STATE(4979),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1357),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(1359),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(1361),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [77] = {
    [sym__expression_list] = STATE(5174),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1363),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(1365),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(1367),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [78] = {
    [sym_function_definition] = STATE(1850),
    [sym_abstract_definition] = STATE(1850),
    [sym_primitive_definition] = STATE(1850),
    [sym_struct_definition] = STATE(1850),
    [sym_module_definition] = STATE(1850),
    [sym_macro_definition] = STATE(1850),
    [sym_parameter_list] = STATE(4697),
    [sym_if_statement] = STATE(1850),
    [sym_try_statement] = STATE(1850),
    [sym_for_statement] = STATE(1850),
    [sym_while_statement] = STATE(1850),
    [sym_return_statement] = STATE(1850),
    [sym_let_statement] = STATE(1850),
    [sym_const_statement] = STATE(1850),
    [sym_quote_statement] = STATE(1850),
    [sym_import_statement] = STATE(1850),
    [sym_export_statement] = STATE(1850),
    [sym__expression] = STATE(1856),
    [sym__primary_expression] = STATE(1423),
    [sym_operator] = STATE(1423),
    [sym_parenthesized_expression] = STATE(1423),
    [sym_field_expression] = STATE(1284),
    [sym_subscript_expression] = STATE(1423),
    [sym_typed_expression] = STATE(1850),
    [sym_parameterized_identifier] = STATE(1423),
    [sym_compound_expression] = STATE(1850),
    [sym_call_expression] = STATE(1423),
    [sym_broadcast_call_expression] = STATE(1423),
    [sym_macro_expression] = STATE(1850),
    [sym_spread_expression] = STATE(1850),
    [sym_unary_expression] = STATE(1850),
    [sym_binary_expression] = STATE(1850),
    [sym_ternary_expression] = STATE(1850),
    [sym_pair_expression] = STATE(1850),
    [sym_tuple_expression] = STATE(1423),
    [sym_array_expression] = STATE(1423),
    [sym_matrix_expression] = STATE(1423),
    [sym_generator_expression] = STATE(1850),
    [sym_array_comprehension_expression] = STATE(1423),
    [sym_function_expression] = STATE(1850),
    [sym_range_expression] = STATE(1850),
    [sym_coefficient_expression] = STATE(1850),
    [sym_quote_expression] = STATE(1850),
    [sym_interpolation_expression] = STATE(1850),
    [sym_macro_identifier] = STATE(43),
    [sym_string] = STATE(1423),
    [sym_identifier] = ACTIONS(593),
    [anon_sym_function] = ACTIONS(595),
    [anon_sym_end] = ACTIONS(297),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_primitive] = ACTIONS(599),
    [anon_sym_mutable] = ACTIONS(601),
    [anon_sym_struct] = ACTIONS(603),
    [anon_sym_module] = ACTIONS(605),
    [anon_sym_macro] = ACTIONS(607),
    [anon_sym_LPAREN] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(299),
    [anon_sym_RPAREN] = ACTIONS(299),
    [anon_sym_SEMI] = ACTIONS(299),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(299),
    [anon_sym_COLON_COLON] = ACTIONS(299),
    [anon_sym_RBRACE] = ACTIONS(299),
    [anon_sym_LT_COLON] = ACTIONS(299),
    [anon_sym_if] = ACTIONS(611),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_for] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(617),
    [sym_break_statement] = ACTIONS(619),
    [sym_continue_statement] = ACTIONS(619),
    [anon_sym_return] = ACTIONS(621),
    [anon_sym_let] = ACTIONS(623),
    [anon_sym_const] = ACTIONS(625),
    [anon_sym_quote] = ACTIONS(627),
    [anon_sym_using] = ACTIONS(629),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_export] = ACTIONS(631),
    [anon_sym_COLON2] = ACTIONS(633),
    [anon_sym_PLUS] = ACTIONS(635),
    [anon_sym_RBRACK] = ACTIONS(299),
    [anon_sym_begin] = ACTIONS(637),
    [anon_sym_GT_COLON] = ACTIONS(639),
    [anon_sym_DASH] = ACTIONS(641),
    [anon_sym_BANG] = ACTIONS(641),
    [anon_sym_TILDE] = ACTIONS(639),
    [anon_sym_] = ACTIONS(639),
    [anon_sym_2] = ACTIONS(639),
    [anon_sym_3] = ACTIONS(639),
    [anon_sym_4] = ACTIONS(639),
    [anon_sym_SQUOTE] = ACTIONS(297),
    [anon_sym_DOT_SQUOTE] = ACTIONS(299),
    [anon_sym_LT_PIPE] = ACTIONS(299),
    [anon_sym_PIPE_GT] = ACTIONS(297),
    [anon_sym_in] = ACTIONS(297),
    [anon_sym_isa] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(299),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_EQ_GT] = ACTIONS(299),
    [anon_sym_LBRACK2] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(645),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [sym_command_string] = ACTIONS(653),
    [sym_character] = ACTIONS(653),
    [sym__power_operator] = ACTIONS(655),
    [sym__times_operator] = ACTIONS(657),
    [sym__plus_operator] = ACTIONS(657),
    [sym__arrow_operator] = ACTIONS(299),
    [sym__comparison_operator] = ACTIONS(297),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(653),
  },
  [79] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4936),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(2032),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(38),
    [sym_string] = STATE(1466),
    [sym_identifier] = ACTIONS(837),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(297),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_primitive] = ACTIONS(307),
    [anon_sym_mutable] = ACTIONS(309),
    [anon_sym_struct] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(313),
    [anon_sym_macro] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(297),
    [anon_sym_SEMI] = ACTIONS(297),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(297),
    [anon_sym_COLON_COLON] = ACTIONS(297),
    [anon_sym_LT_COLON] = ACTIONS(297),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_elseif] = ACTIONS(297),
    [anon_sym_else] = ACTIONS(297),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [sym_break_statement] = ACTIONS(327),
    [sym_continue_statement] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_quote] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(337),
    [anon_sym_import] = ACTIONS(337),
    [anon_sym_export] = ACTIONS(339),
    [anon_sym_COLON2] = ACTIONS(839),
    [anon_sym_PLUS] = ACTIONS(841),
    [anon_sym_begin] = ACTIONS(345),
    [anon_sym_GT_COLON] = ACTIONS(843),
    [anon_sym_DASH] = ACTIONS(843),
    [anon_sym_BANG] = ACTIONS(843),
    [anon_sym_TILDE] = ACTIONS(843),
    [anon_sym_] = ACTIONS(843),
    [anon_sym_2] = ACTIONS(843),
    [anon_sym_3] = ACTIONS(843),
    [anon_sym_4] = ACTIONS(843),
    [anon_sym_SQUOTE] = ACTIONS(297),
    [anon_sym_DOT_SQUOTE] = ACTIONS(297),
    [anon_sym_LT_PIPE] = ACTIONS(297),
    [anon_sym_PIPE_GT] = ACTIONS(297),
    [anon_sym_in] = ACTIONS(297),
    [anon_sym_isa] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(297),
    [anon_sym_EQ_GT] = ACTIONS(297),
    [anon_sym_LBRACK2] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(845),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_command_string] = ACTIONS(359),
    [sym_character] = ACTIONS(359),
    [sym__power_operator] = ACTIONS(361),
    [sym__times_operator] = ACTIONS(361),
    [sym__plus_operator] = ACTIONS(361),
    [sym__arrow_operator] = ACTIONS(297),
    [sym__comparison_operator] = ACTIONS(297),
    [anon_sym_LF] = ACTIONS(299),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(363),
  },
  [80] = {
    [sym_function_definition] = STATE(3110),
    [sym_abstract_definition] = STATE(3110),
    [sym_primitive_definition] = STATE(3110),
    [sym_struct_definition] = STATE(3110),
    [sym_module_definition] = STATE(3110),
    [sym_macro_definition] = STATE(3110),
    [sym_parameter_list] = STATE(4631),
    [sym_if_statement] = STATE(3110),
    [sym_try_statement] = STATE(3110),
    [sym_for_statement] = STATE(3110),
    [sym_while_statement] = STATE(3110),
    [sym_return_statement] = STATE(3110),
    [sym_let_statement] = STATE(3110),
    [sym_const_statement] = STATE(3110),
    [sym_quote_statement] = STATE(3110),
    [sym_import_statement] = STATE(3110),
    [sym_export_statement] = STATE(3110),
    [sym__expression] = STATE(3116),
    [sym__primary_expression] = STATE(2793),
    [sym_operator] = STATE(2793),
    [sym_parenthesized_expression] = STATE(2793),
    [sym_field_expression] = STATE(2614),
    [sym_subscript_expression] = STATE(2793),
    [sym_typed_expression] = STATE(3110),
    [sym_parameterized_identifier] = STATE(2793),
    [sym_compound_expression] = STATE(3110),
    [sym_call_expression] = STATE(2793),
    [sym_broadcast_call_expression] = STATE(2793),
    [sym_macro_expression] = STATE(3110),
    [sym_spread_expression] = STATE(3110),
    [sym_unary_expression] = STATE(3110),
    [sym_binary_expression] = STATE(3110),
    [sym_ternary_expression] = STATE(3110),
    [sym_pair_expression] = STATE(3110),
    [sym_tuple_expression] = STATE(2793),
    [sym_array_expression] = STATE(2793),
    [sym_matrix_expression] = STATE(2793),
    [sym_generator_expression] = STATE(3110),
    [sym_array_comprehension_expression] = STATE(2793),
    [sym_function_expression] = STATE(3110),
    [sym_range_expression] = STATE(3110),
    [sym_coefficient_expression] = STATE(3110),
    [sym_quote_expression] = STATE(3110),
    [sym_interpolation_expression] = STATE(3110),
    [sym_macro_identifier] = STATE(31),
    [sym_string] = STATE(2793),
    [sym_identifier] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_end] = ACTIONS(297),
    [anon_sym_abstract] = ACTIONS(665),
    [anon_sym_primitive] = ACTIONS(667),
    [anon_sym_mutable] = ACTIONS(669),
    [anon_sym_struct] = ACTIONS(671),
    [anon_sym_module] = ACTIONS(673),
    [anon_sym_macro] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(677),
    [anon_sym_COMMA] = ACTIONS(299),
    [anon_sym_RPAREN] = ACTIONS(299),
    [anon_sym_SEMI] = ACTIONS(299),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(299),
    [anon_sym_COLON_COLON] = ACTIONS(299),
    [anon_sym_RBRACE] = ACTIONS(299),
    [anon_sym_LT_COLON] = ACTIONS(299),
    [anon_sym_if] = ACTIONS(679),
    [anon_sym_try] = ACTIONS(681),
    [anon_sym_for] = ACTIONS(683),
    [anon_sym_while] = ACTIONS(685),
    [sym_break_statement] = ACTIONS(687),
    [sym_continue_statement] = ACTIONS(687),
    [anon_sym_return] = ACTIONS(689),
    [anon_sym_let] = ACTIONS(691),
    [anon_sym_const] = ACTIONS(693),
    [anon_sym_quote] = ACTIONS(695),
    [anon_sym_using] = ACTIONS(697),
    [anon_sym_import] = ACTIONS(697),
    [anon_sym_export] = ACTIONS(699),
    [anon_sym_COLON2] = ACTIONS(701),
    [anon_sym_PLUS] = ACTIONS(703),
    [anon_sym_RBRACK] = ACTIONS(299),
    [anon_sym_begin] = ACTIONS(705),
    [anon_sym_GT_COLON] = ACTIONS(707),
    [anon_sym_DASH] = ACTIONS(709),
    [anon_sym_BANG] = ACTIONS(709),
    [anon_sym_TILDE] = ACTIONS(707),
    [anon_sym_] = ACTIONS(707),
    [anon_sym_2] = ACTIONS(707),
    [anon_sym_3] = ACTIONS(707),
    [anon_sym_4] = ACTIONS(707),
    [anon_sym_SQUOTE] = ACTIONS(297),
    [anon_sym_DOT_SQUOTE] = ACTIONS(299),
    [anon_sym_LT_PIPE] = ACTIONS(299),
    [anon_sym_PIPE_GT] = ACTIONS(297),
    [anon_sym_in] = ACTIONS(297),
    [anon_sym_isa] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(299),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_EQ_GT] = ACTIONS(299),
    [anon_sym_LBRACK2] = ACTIONS(1096),
    [anon_sym_DOLLAR] = ACTIONS(713),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(715),
    [anon_sym_DQUOTE] = ACTIONS(717),
    [sym_command_string] = ACTIONS(719),
    [sym_character] = ACTIONS(719),
    [sym__power_operator] = ACTIONS(721),
    [sym__times_operator] = ACTIONS(723),
    [sym__plus_operator] = ACTIONS(723),
    [sym__arrow_operator] = ACTIONS(299),
    [sym__comparison_operator] = ACTIONS(297),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(719),
  },
  [81] = {
    [sym__expression_list] = STATE(4574),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1369),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(1371),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(1373),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [82] = {
    [sym__expression_list] = STATE(5216),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1375),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(1377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(1379),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [83] = {
    [sym_function_definition] = STATE(1982),
    [sym_abstract_definition] = STATE(1982),
    [sym_primitive_definition] = STATE(1982),
    [sym_struct_definition] = STATE(1982),
    [sym_module_definition] = STATE(1982),
    [sym_macro_definition] = STATE(1982),
    [sym_parameter_list] = STATE(5092),
    [sym_if_statement] = STATE(1982),
    [sym_try_statement] = STATE(1982),
    [sym_for_statement] = STATE(1982),
    [sym_while_statement] = STATE(1982),
    [sym_return_statement] = STATE(1982),
    [sym_let_statement] = STATE(1982),
    [sym_const_statement] = STATE(1982),
    [sym_quote_statement] = STATE(1982),
    [sym_import_statement] = STATE(1982),
    [sym_export_statement] = STATE(1982),
    [sym__expression] = STATE(1986),
    [sym__primary_expression] = STATE(1495),
    [sym_operator] = STATE(1495),
    [sym_parenthesized_expression] = STATE(1495),
    [sym_field_expression] = STATE(1192),
    [sym_subscript_expression] = STATE(1495),
    [sym_typed_expression] = STATE(1982),
    [sym_parameterized_identifier] = STATE(1495),
    [sym_compound_expression] = STATE(1982),
    [sym_call_expression] = STATE(1495),
    [sym_broadcast_call_expression] = STATE(1495),
    [sym_macro_expression] = STATE(1982),
    [sym_spread_expression] = STATE(1982),
    [sym_unary_expression] = STATE(1982),
    [sym_binary_expression] = STATE(1982),
    [sym_ternary_expression] = STATE(1982),
    [sym_pair_expression] = STATE(1982),
    [sym_tuple_expression] = STATE(1495),
    [sym_array_expression] = STATE(1495),
    [sym_matrix_expression] = STATE(1495),
    [sym_generator_expression] = STATE(1982),
    [sym_array_comprehension_expression] = STATE(1495),
    [sym_function_expression] = STATE(1982),
    [sym_range_expression] = STATE(1982),
    [sym_coefficient_expression] = STATE(1982),
    [sym_quote_expression] = STATE(1982),
    [sym_interpolation_expression] = STATE(1982),
    [sym_macro_identifier] = STATE(44),
    [sym_string] = STATE(1495),
    [ts_builtin_sym_end] = ACTIONS(299),
    [sym_identifier] = ACTIONS(849),
    [anon_sym_function] = ACTIONS(851),
    [anon_sym_abstract] = ACTIONS(853),
    [anon_sym_primitive] = ACTIONS(855),
    [anon_sym_mutable] = ACTIONS(857),
    [anon_sym_struct] = ACTIONS(859),
    [anon_sym_module] = ACTIONS(861),
    [anon_sym_macro] = ACTIONS(863),
    [anon_sym_LPAREN] = ACTIONS(865),
    [anon_sym_COMMA] = ACTIONS(297),
    [anon_sym_SEMI] = ACTIONS(297),
    [anon_sym_EQ] = ACTIONS(297),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(297),
    [anon_sym_COLON_COLON] = ACTIONS(297),
    [anon_sym_LT_COLON] = ACTIONS(297),
    [anon_sym_if] = ACTIONS(867),
    [anon_sym_try] = ACTIONS(869),
    [anon_sym_for] = ACTIONS(871),
    [anon_sym_while] = ACTIONS(873),
    [sym_break_statement] = ACTIONS(875),
    [sym_continue_statement] = ACTIONS(875),
    [anon_sym_return] = ACTIONS(877),
    [anon_sym_let] = ACTIONS(879),
    [anon_sym_const] = ACTIONS(881),
    [anon_sym_quote] = ACTIONS(883),
    [anon_sym_using] = ACTIONS(885),
    [anon_sym_import] = ACTIONS(885),
    [anon_sym_export] = ACTIONS(887),
    [anon_sym_COLON2] = ACTIONS(889),
    [anon_sym_PLUS] = ACTIONS(891),
    [anon_sym_begin] = ACTIONS(893),
    [anon_sym_GT_COLON] = ACTIONS(895),
    [anon_sym_DASH] = ACTIONS(895),
    [anon_sym_BANG] = ACTIONS(895),
    [anon_sym_TILDE] = ACTIONS(895),
    [anon_sym_] = ACTIONS(895),
    [anon_sym_2] = ACTIONS(895),
    [anon_sym_3] = ACTIONS(895),
    [anon_sym_4] = ACTIONS(895),
    [anon_sym_SQUOTE] = ACTIONS(297),
    [anon_sym_DOT_SQUOTE] = ACTIONS(297),
    [anon_sym_LT_PIPE] = ACTIONS(297),
    [anon_sym_PIPE_GT] = ACTIONS(297),
    [anon_sym_in] = ACTIONS(297),
    [anon_sym_isa] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(297),
    [anon_sym_EQ_GT] = ACTIONS(297),
    [anon_sym_LBRACK2] = ACTIONS(897),
    [anon_sym_DOLLAR] = ACTIONS(899),
    [anon_sym_AT] = ACTIONS(831),
    [sym_number] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(903),
    [sym_command_string] = ACTIONS(905),
    [sym_character] = ACTIONS(905),
    [sym__power_operator] = ACTIONS(907),
    [sym__times_operator] = ACTIONS(907),
    [sym__plus_operator] = ACTIONS(907),
    [sym__arrow_operator] = ACTIONS(297),
    [sym__comparison_operator] = ACTIONS(297),
    [sym__assign_operator] = ACTIONS(297),
    [anon_sym_LF] = ACTIONS(299),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(909),
  },
  [84] = {
    [sym__expression_list] = STATE(4787),
    [sym_function_definition] = STATE(2677),
    [sym_abstract_definition] = STATE(2677),
    [sym_primitive_definition] = STATE(2677),
    [sym_struct_definition] = STATE(2677),
    [sym_module_definition] = STATE(2677),
    [sym_macro_definition] = STATE(2677),
    [sym_parameter_list] = STATE(5071),
    [sym_if_statement] = STATE(2677),
    [sym_try_statement] = STATE(2677),
    [sym_for_statement] = STATE(2677),
    [sym_while_statement] = STATE(2677),
    [sym_return_statement] = STATE(2677),
    [sym_let_statement] = STATE(2677),
    [sym_const_statement] = STATE(2677),
    [sym_quote_statement] = STATE(2677),
    [sym_import_statement] = STATE(2677),
    [sym_export_statement] = STATE(2677),
    [sym__expression] = STATE(2719),
    [sym__primary_expression] = STATE(2565),
    [sym_bare_tuple_expression] = STATE(3355),
    [sym_operator] = STATE(2565),
    [sym_parenthesized_expression] = STATE(2565),
    [sym_field_expression] = STATE(2516),
    [sym_subscript_expression] = STATE(2565),
    [sym_typed_expression] = STATE(2677),
    [sym_parameterized_identifier] = STATE(2565),
    [sym_compound_expression] = STATE(2677),
    [sym_call_expression] = STATE(2565),
    [sym_broadcast_call_expression] = STATE(2565),
    [sym_macro_expression] = STATE(2677),
    [sym_spread_expression] = STATE(2677),
    [sym_assignment_expression] = STATE(3361),
    [sym_unary_expression] = STATE(2677),
    [sym_binary_expression] = STATE(2677),
    [sym_ternary_expression] = STATE(2677),
    [sym_pair_expression] = STATE(2677),
    [sym_tuple_expression] = STATE(2565),
    [sym_array_expression] = STATE(2565),
    [sym_matrix_expression] = STATE(2565),
    [sym_generator_expression] = STATE(2677),
    [sym_array_comprehension_expression] = STATE(2565),
    [sym_function_expression] = STATE(2677),
    [sym_range_expression] = STATE(2677),
    [sym_coefficient_expression] = STATE(2677),
    [sym_quote_expression] = STATE(2677),
    [sym_interpolation_expression] = STATE(2677),
    [sym_macro_identifier] = STATE(4),
    [sym_string] = STATE(2565),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1381),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [anon_sym_mutable] = ACTIONS(15),
    [anon_sym_struct] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_macro] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(1383),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(369),
    [anon_sym_COLON_COLON] = ACTIONS(371),
    [anon_sym_LT_COLON] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_try] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [sym_break_statement] = ACTIONS(33),
    [sym_continue_statement] = ACTIONS(33),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_const] = ACTIONS(85),
    [anon_sym_quote] = ACTIONS(41),
    [anon_sym_using] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(43),
    [anon_sym_export] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_GT_COLON] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_BANG] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_] = ACTIONS(93),
    [anon_sym_2] = ACTIONS(93),
    [anon_sym_3] = ACTIONS(93),
    [anon_sym_4] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [anon_sym_DOT_SQUOTE] = ACTIONS(381),
    [anon_sym_LT_PIPE] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(385),
    [anon_sym_in] = ACTIONS(387),
    [anon_sym_isa] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_EQ_GT] = ACTIONS(395),
    [anon_sym_LBRACK2] = ACTIONS(95),
    [anon_sym_DOLLAR] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [sym_number] = ACTIONS(103),
    [anon_sym_DQUOTE] = ACTIONS(105),
    [sym_command_string] = ACTIONS(109),
    [sym_character] = ACTIONS(109),
    [sym__power_operator] = ACTIONS(397),
    [sym__times_operator] = ACTIONS(399),
    [sym__plus_operator] = ACTIONS(401),
    [sym__arrow_operator] = ACTIONS(403),
    [sym__comparison_operator] = ACTIONS(387),
    [anon_sym_LF] = ACTIONS(1385),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(65),
  },
  [85] = {
    [sym_function_definition] = STATE(3110),
    [sym_abstract_definition] = STATE(3110),
    [sym_primitive_definition] = STATE(3110),
    [sym_struct_definition] = STATE(3110),
    [sym_module_definition] = STATE(3110),
    [sym_macro_definition] = STATE(3110),
    [sym_parameter_list] = STATE(5128),
    [sym_if_statement] = STATE(3110),
    [sym_try_statement] = STATE(3110),
    [sym_for_statement] = STATE(3110),
    [sym_while_statement] = STATE(3110),
    [sym_return_statement] = STATE(3110),
    [sym_let_statement] = STATE(3110),
    [sym_const_statement] = STATE(3110),
    [sym_quote_statement] = STATE(3110),
    [sym_import_statement] = STATE(3110),
    [sym_export_statement] = STATE(3110),
    [sym__expression] = STATE(3083),
    [sym__primary_expression] = STATE(2793),
    [sym_operator] = STATE(2793),
    [sym_parenthesized_expression] = STATE(2793),
    [sym_field_expression] = STATE(2614),
    [sym_subscript_expression] = STATE(2793),
    [sym_typed_expression] = STATE(3110),
    [sym_parameterized_identifier] = STATE(2793),
    [sym_compound_expression] = STATE(3110),
    [sym_call_expression] = STATE(2793),
    [sym_broadcast_call_expression] = STATE(2793),
    [sym_macro_expression] = STATE(3110),
    [sym_spread_expression] = STATE(3110),
    [sym_unary_expression] = STATE(3110),
    [sym_binary_expression] = STATE(3110),
    [sym_ternary_expression] = STATE(3110),
    [sym_pair_expression] = STATE(3110),
    [sym_tuple_expression] = STATE(2793),
    [sym_array_expression] = STATE(2793),
    [sym_matrix_expression] = STATE(2793),
    [sym_generator_expression] = STATE(3110),
    [sym_array_comprehension_expression] = STATE(2793),
    [sym_function_expression] = STATE(3110),
    [sym_range_expression] = STATE(3110),
    [sym_coefficient_expression] = STATE(3110),
    [sym_quote_expression] = STATE(3110),
    [sym_interpolation_expression] = STATE(3110),
    [sym_macro_identifier] = STATE(74),
    [sym_string] = STATE(2793),
    [sym_identifier] = ACTIONS(1387),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_end] = ACTIONS(185),
    [anon_sym_abstract] = ACTIONS(665),
    [anon_sym_primitive] = ACTIONS(667),
    [anon_sym_mutable] = ACTIONS(669),
    [anon_sym_struct] = ACTIONS(671),
    [anon_sym_module] = ACTIONS(673),
    [anon_sym_macro] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(677),
    [anon_sym_RPAREN] = ACTIONS(187),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(187),
    [anon_sym_COLON_COLON] = ACTIONS(187),
    [anon_sym_LT_COLON] = ACTIONS(187),
    [anon_sym_if] = ACTIONS(679),
    [anon_sym_try] = ACTIONS(681),
    [anon_sym_for] = ACTIONS(683),
    [anon_sym_while] = ACTIONS(685),
    [sym_break_statement] = ACTIONS(687),
    [sym_continue_statement] = ACTIONS(687),
    [anon_sym_return] = ACTIONS(689),
    [anon_sym_let] = ACTIONS(691),
    [anon_sym_const] = ACTIONS(693),
    [anon_sym_quote] = ACTIONS(695),
    [anon_sym_using] = ACTIONS(697),
    [anon_sym_import] = ACTIONS(697),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(699),
    [anon_sym_COLON2] = ACTIONS(1389),
    [anon_sym_PLUS] = ACTIONS(1391),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_RBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(705),
    [anon_sym_GT_COLON] = ACTIONS(1393),
    [anon_sym_DASH] = ACTIONS(1395),
    [anon_sym_BANG] = ACTIONS(1395),
    [anon_sym_TILDE] = ACTIONS(1393),
    [anon_sym_] = ACTIONS(1393),
    [anon_sym_2] = ACTIONS(1393),
    [anon_sym_3] = ACTIONS(1393),
    [anon_sym_4] = ACTIONS(1393),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(187),
    [anon_sym_LT_PIPE] = ACTIONS(187),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(187),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_EQ_GT] = ACTIONS(187),
    [anon_sym_LBRACK2] = ACTIONS(711),
    [anon_sym_DOLLAR] = ACTIONS(1397),
    [anon_sym_AT] = ACTIONS(647),
    [sym_number] = ACTIONS(715),
    [anon_sym_DQUOTE] = ACTIONS(717),
    [sym_command_string] = ACTIONS(719),
    [sym_character] = ACTIONS(719),
    [sym__power_operator] = ACTIONS(721),
    [sym__times_operator] = ACTIONS(723),
    [sym__plus_operator] = ACTIONS(723),
    [sym__arrow_operator] = ACTIONS(187),
    [sym__comparison_operator] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(719),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [86] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4821),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(2192),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(47),
    [sym_string] = STATE(1466),
    [aux_sym_macro_argument_list_repeat1] = STATE(68),
    [sym_identifier] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(193),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_primitive] = ACTIONS(307),
    [anon_sym_mutable] = ACTIONS(309),
    [anon_sym_struct] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(313),
    [anon_sym_macro] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [anon_sym_LT_COLON] = ACTIONS(193),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_elseif] = ACTIONS(193),
    [anon_sym_else] = ACTIONS(193),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [sym_break_statement] = ACTIONS(327),
    [sym_continue_statement] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_quote] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(337),
    [anon_sym_import] = ACTIONS(337),
    [anon_sym_export] = ACTIONS(339),
    [anon_sym_COLON2] = ACTIONS(341),
    [anon_sym_PLUS] = ACTIONS(343),
    [anon_sym_begin] = ACTIONS(345),
    [anon_sym_GT_COLON] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(347),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_] = ACTIONS(347),
    [anon_sym_2] = ACTIONS(347),
    [anon_sym_3] = ACTIONS(347),
    [anon_sym_4] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(193),
    [anon_sym_DOT_SQUOTE] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_QMARK] = ACTIONS(193),
    [anon_sym_EQ_GT] = ACTIONS(193),
    [anon_sym_LBRACK2] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_command_string] = ACTIONS(359),
    [sym_character] = ACTIONS(359),
    [sym__power_operator] = ACTIONS(361),
    [sym__times_operator] = ACTIONS(361),
    [sym__plus_operator] = ACTIONS(361),
    [sym__arrow_operator] = ACTIONS(193),
    [sym__comparison_operator] = ACTIONS(193),
    [anon_sym_LF] = ACTIONS(195),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(363),
  },
  [87] = {
    [sym_function_definition] = STATE(2430),
    [sym_abstract_definition] = STATE(2430),
    [sym_primitive_definition] = STATE(2430),
    [sym_struct_definition] = STATE(2430),
    [sym_module_definition] = STATE(2430),
    [sym_macro_definition] = STATE(2430),
    [sym_parameter_list] = STATE(4938),
    [sym_if_statement] = STATE(2430),
    [sym_try_statement] = STATE(2430),
    [sym_for_statement] = STATE(2430),
    [sym_while_statement] = STATE(2430),
    [sym_return_statement] = STATE(2430),
    [sym_let_statement] = STATE(2430),
    [sym_const_statement] = STATE(2430),
    [sym_quote_statement] = STATE(2430),
    [sym_import_statement] = STATE(2430),
    [sym_export_statement] = STATE(2430),
    [sym__expression] = STATE(2375),
    [sym__primary_expression] = STATE(2183),
    [sym_operator] = STATE(2183),
    [sym_parenthesized_expression] = STATE(2183),
    [sym_field_expression] = STATE(1729),
    [sym_subscript_expression] = STATE(2183),
    [sym_typed_expression] = STATE(2430),
    [sym_parameterized_identifier] = STATE(2183),
    [sym_compound_expression] = STATE(2430),
    [sym_call_expression] = STATE(2183),
    [sym_broadcast_call_expression] = STATE(2183),
    [sym_macro_expression] = STATE(2430),
    [sym_spread_expression] = STATE(2430),
    [sym_unary_expression] = STATE(2430),
    [sym_binary_expression] = STATE(2430),
    [sym_ternary_expression] = STATE(2430),
    [sym_pair_expression] = STATE(2430),
    [sym_tuple_expression] = STATE(2183),
    [sym_array_expression] = STATE(2183),
    [sym_matrix_expression] = STATE(2183),
    [sym_generator_expression] = STATE(2430),
    [sym_array_comprehension_expression] = STATE(2183),
    [sym_function_expression] = STATE(2430),
    [sym_range_expression] = STATE(2430),
    [sym_coefficient_expression] = STATE(2430),
    [sym_quote_expression] = STATE(2430),
    [sym_interpolation_expression] = STATE(2430),
    [sym_macro_identifier] = STATE(92),
    [sym_string] = STATE(2183),
    [sym_identifier] = ACTIONS(1399),
    [anon_sym_function] = ACTIONS(1401),
    [anon_sym_abstract] = ACTIONS(1403),
    [anon_sym_primitive] = ACTIONS(1405),
    [aux_sym_primitive_definition_token1] = ACTIONS(185),
    [anon_sym_mutable] = ACTIONS(1407),
    [anon_sym_struct] = ACTIONS(1409),
    [anon_sym_module] = ACTIONS(1411),
    [anon_sym_macro] = ACTIONS(1413),
    [anon_sym_LPAREN] = ACTIONS(1415),
    [anon_sym_COMMA] = ACTIONS(187),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(187),
    [anon_sym_COLON_COLON] = ACTIONS(187),
    [anon_sym_LT_COLON] = ACTIONS(187),
    [anon_sym_if] = ACTIONS(1417),
    [anon_sym_try] = ACTIONS(1419),
    [anon_sym_for] = ACTIONS(1421),
    [anon_sym_while] = ACTIONS(1423),
    [sym_break_statement] = ACTIONS(1425),
    [sym_continue_statement] = ACTIONS(1425),
    [anon_sym_return] = ACTIONS(1427),
    [anon_sym_let] = ACTIONS(1429),
    [anon_sym_const] = ACTIONS(1431),
    [anon_sym_quote] = ACTIONS(1433),
    [anon_sym_using] = ACTIONS(1435),
    [anon_sym_import] = ACTIONS(1435),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(1437),
    [anon_sym_COLON2] = ACTIONS(1439),
    [anon_sym_PLUS] = ACTIONS(1441),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(1443),
    [anon_sym_GT_COLON] = ACTIONS(1445),
    [anon_sym_DASH] = ACTIONS(1447),
    [anon_sym_BANG] = ACTIONS(1447),
    [anon_sym_TILDE] = ACTIONS(1445),
    [anon_sym_] = ACTIONS(1445),
    [anon_sym_2] = ACTIONS(1445),
    [anon_sym_3] = ACTIONS(1445),
    [anon_sym_4] = ACTIONS(1445),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(187),
    [anon_sym_LT_PIPE] = ACTIONS(187),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(187),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_EQ_GT] = ACTIONS(187),
    [anon_sym_LBRACK2] = ACTIONS(1449),
    [anon_sym_DOLLAR] = ACTIONS(1451),
    [anon_sym_AT] = ACTIONS(1453),
    [sym_number] = ACTIONS(1455),
    [anon_sym_DQUOTE] = ACTIONS(1457),
    [sym_command_string] = ACTIONS(1459),
    [sym_character] = ACTIONS(1459),
    [sym__power_operator] = ACTIONS(1461),
    [sym__times_operator] = ACTIONS(1463),
    [sym__plus_operator] = ACTIONS(1463),
    [sym__arrow_operator] = ACTIONS(187),
    [sym__comparison_operator] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(1459),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [88] = {
    [sym_function_definition] = STATE(1778),
    [sym_abstract_definition] = STATE(1778),
    [sym_primitive_definition] = STATE(1778),
    [sym_struct_definition] = STATE(1778),
    [sym_module_definition] = STATE(1778),
    [sym_macro_definition] = STATE(1778),
    [sym_parameter_list] = STATE(4821),
    [sym_if_statement] = STATE(1778),
    [sym_try_statement] = STATE(1778),
    [sym_for_statement] = STATE(1778),
    [sym_while_statement] = STATE(1778),
    [sym_return_statement] = STATE(1778),
    [sym_let_statement] = STATE(1778),
    [sym_const_statement] = STATE(1778),
    [sym_quote_statement] = STATE(1778),
    [sym_import_statement] = STATE(1778),
    [sym_export_statement] = STATE(1778),
    [sym__expression] = STATE(2197),
    [sym__primary_expression] = STATE(1466),
    [sym_operator] = STATE(1466),
    [sym_parenthesized_expression] = STATE(1466),
    [sym_field_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1466),
    [sym_typed_expression] = STATE(1778),
    [sym_parameterized_identifier] = STATE(1466),
    [sym_compound_expression] = STATE(1778),
    [sym_call_expression] = STATE(1466),
    [sym_broadcast_call_expression] = STATE(1466),
    [sym_macro_expression] = STATE(1778),
    [sym_spread_expression] = STATE(1778),
    [sym_unary_expression] = STATE(1778),
    [sym_binary_expression] = STATE(1778),
    [sym_ternary_expression] = STATE(1778),
    [sym_pair_expression] = STATE(1778),
    [sym_tuple_expression] = STATE(1466),
    [sym_array_expression] = STATE(1466),
    [sym_matrix_expression] = STATE(1466),
    [sym_generator_expression] = STATE(1778),
    [sym_array_comprehension_expression] = STATE(1466),
    [sym_function_expression] = STATE(1778),
    [sym_range_expression] = STATE(1778),
    [sym_coefficient_expression] = STATE(1778),
    [sym_quote_expression] = STATE(1778),
    [sym_interpolation_expression] = STATE(1778),
    [sym_macro_identifier] = STATE(47),
    [sym_string] = STATE(1466),
    [sym_identifier] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(297),
    [anon_sym_abstract] = ACTIONS(305),
    [anon_sym_primitive] = ACTIONS(307),
    [anon_sym_mutable] = ACTIONS(309),
    [anon_sym_struct] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(313),
    [anon_sym_macro] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(297),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(297),
    [anon_sym_COLON_COLON] = ACTIONS(297),
    [anon_sym_LT_COLON] = ACTIONS(297),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_elseif] = ACTIONS(297),
    [anon_sym_else] = ACTIONS(297),
    [anon_sym_try] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [sym_break_statement] = ACTIONS(327),
    [sym_continue_statement] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_quote] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(337),
    [anon_sym_import] = ACTIONS(337),
    [anon_sym_export] = ACTIONS(339),
    [anon_sym_COLON2] = ACTIONS(341),
    [anon_sym_PLUS] = ACTIONS(343),
    [anon_sym_begin] = ACTIONS(345),
    [anon_sym_GT_COLON] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(347),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_] = ACTIONS(347),
    [anon_sym_2] = ACTIONS(347),
    [anon_sym_3] = ACTIONS(347),
    [anon_sym_4] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(297),
    [anon_sym_DOT_SQUOTE] = ACTIONS(297),
    [anon_sym_LT_PIPE] = ACTIONS(297),
    [anon_sym_PIPE_GT] = ACTIONS(297),
    [anon_sym_in] = ACTIONS(297),
    [anon_sym_isa] = ACTIONS(297),
    [anon_sym_PIPE_PIPE] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(297),
    [anon_sym_EQ_GT] = ACTIONS(297),
    [anon_sym_LBRACK2] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [sym_command_string] = ACTIONS(359),
    [sym_character] = ACTIONS(359),
    [sym__power_operator] = ACTIONS(361),
    [sym__times_operator] = ACTIONS(361),
    [sym__plus_operator] = ACTIONS(361),
    [sym__arrow_operator] = ACTIONS(297),
    [sym__comparison_operator] = ACTIONS(297),
    [anon_sym_LF] = ACTIONS(299),
    [sym_comment] = ACTIONS(113),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(363),
  },
  [89] = {
    [sym_function_definition] = STATE(3110),
    [sym_abstract_definition] = STATE(3110),
    [sym_primitive_definition] = STATE(3110),
    [sym_struct_definition] = STATE(3110),
    [sym_module_definition] = STATE(3110),
    [sym_macro_definition] = STATE(3110),
    [sym_parameter_list] = STATE(5080),
    [sym_if_statement] = STATE(3110),
    [sym_try_statement] = STATE(3110),
    [sym_for_statement] = STATE(3110),
    [sym_while_statement] = STATE(3110),
    [sym_return_statement] = STATE(3110),
    [sym_let_statement] = STATE(3110),
    [sym_const_statement] = STATE(3110),
    [sym_quote_statement] = STATE(3110),
    [sym_import_statement] = STATE(3110),
    [sym_export_statement] = STATE(3110),
    [sym__expression] = STATE(3083),
    [sym__primary_expression] = STATE(2793),
    [sym_operator] = STATE(2793),
    [sym_parenthesized_expression] = STATE(2793),
    [sym_field_expression] = STATE(2614),
    [sym_subscript_expression] = STATE(2793),
    [sym_typed_expression] = STATE(3110),
    [sym_parameterized_identifier] = STATE(2793),
    [sym_compound_expression] = STATE(3110),
    [sym_call_expression] = STATE(2793),
    [sym_broadcast_call_expression] = STATE(2793),
    [sym_macro_expression] = STATE(3110),
    [sym_spread_expression] = STATE(3110),
    [sym_unary_expression] = STATE(3110),
    [sym_binary_expression] = STATE(3110),
    [sym_ternary_expression] = STATE(3110),
    [sym_pair_expression] = STATE(3110),
    [sym_tuple_expression] = STATE(2793),
    [sym_array_expression] = STATE(2793),
    [sym_matrix_expression] = STATE(2793),
    [sym_generator_expression] = STATE(3110),
    [sym_array_comprehension_expression] = STATE(2793),
    [sym_function_expression] = STATE(3110),
    [sym_range_expression] = STATE(3110),
    [sym_coefficient_expression] = STATE(3110),
    [sym_quote_expression] = STATE(3110),
    [sym_interpolation_expression] = STATE(3110),
    [sym_macro_identifier] = STATE(94),
    [sym_string] = STATE(2793),
    [sym_identifier] = ACTIONS(1465),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_abstract] = ACTIONS(665),
    [anon_sym_primitive] = ACTIONS(667),
    [aux_sym_primitive_definition_token1] = ACTIONS(185),
    [anon_sym_mutable] = ACTIONS(669),
    [anon_sym_struct] = ACTIONS(671),
    [anon_sym_module] = ACTIONS(673),
    [anon_sym_macro] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(677),
    [anon_sym_COMMA] = ACTIONS(187),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(187),
    [anon_sym_COLON_COLON] = ACTIONS(187),
    [anon_sym_LT_COLON] = ACTIONS(187),
    [anon_sym_if] = ACTIONS(679),
    [anon_sym_try] = ACTIONS(681),
    [anon_sym_for] = ACTIONS(683),
    [anon_sym_while] = ACTIONS(685),
    [sym_break_statement] = ACTIONS(687),
    [sym_continue_statement] = ACTIONS(687),
    [anon_sym_return] = ACTIONS(1467),
    [anon_sym_let] = ACTIONS(691),
    [anon_sym_const] = ACTIONS(1469),
    [anon_sym_quote] = ACTIONS(695),
    [anon_sym_using] = ACTIONS(697),
    [anon_sym_import] = ACTIONS(697),
    [anon_sym_DOT] = ACTIONS(185),
    [anon_sym_export] = ACTIONS(699),
    [anon_sym_COLON2] = ACTIONS(1471),
    [anon_sym_PLUS] = ACTIONS(1473),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_begin] = ACTIONS(705),
    [anon_sym_GT_COLON] = ACTIONS(1475),
    [anon_sym_DASH] = ACTIONS(1477),
    [anon_sym_BANG] = ACTIONS(1477),
    [anon_sym_TILDE] = ACTIONS(1475),
    [anon_sym_] = ACTIONS(1475),
    [anon_sym_2] = ACTIONS(1475),
    [anon_sym_3] = ACTIONS(1475),
    [anon_sym_4] = ACTIONS(1475),
    [anon_sym_SQUOTE] = ACTIONS(185),
    [anon_sym_DOT_SQUOTE] = ACTIONS(187),
    [anon_sym_LT_PIPE] = ACTIONS(187),
    [anon_sym_PIPE_GT] = ACTIONS(185),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_isa] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(185),
    [anon_sym_AMP_AMP] = ACTIONS(187),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_EQ_GT] = ACTIONS(187),
    [anon_sym_LBRACK2] = ACTIONS(711),
    [anon_sym_DOLLAR] = ACTIONS(1479),
    [anon_sym_AT] = ACTIONS(1453),
    [sym_number] = ACTIONS(1481),
    [anon_sym_DQUOTE] = ACTIONS(717),
    [sym_command_string] = ACTIONS(719),
    [sym_character] = ACTIONS(719),
    [sym__power_operator] = ACTIONS(721),
    [sym__times_operator] = ACTIONS(723),
    [sym__plus_operator] = ACTIONS(723),
    [sym__arrow_operator] = ACTIONS(187),
    [sym__comparison_operator] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_triple_string] = ACTIONS(719),
    [sym__immediate_paren] = ACTIONS(187),
  },
  [90] = {
    [sym_function_definition] = STATE(2907),
    [sym_abstract_definition] = STATE(2907),
    [sym_primitive_definition] = STATE(2907),
    [sym_struct_definition] = STATE(2907),
    [sym_module_definition] = STATE(2907),
    [sym_macro_definition] = STATE(2907),
    [sym_parameter_list] = STATE(4723),
    [sym_if_statement] = STATE(2907),
    [sym_try_statement] = STATE(2907),
    [sym_for_statement] = STATE(2907),
    [sym_while_statement] = STATE(2907),
    [sym_return_statement] = STATE(2907),
    [sym_let_statement] = STATE(2907),
    [sym_const_statement] = STATE(2907),
    [sym_quote_statement] = STATE(2907),
    [sym_import_statement] = STATE(2907),
    [sym_export_statement] = STATE(2907),
    [sym__expression] = STATE(3212),
    [sym__primary_expression] = STATE(2646),
    [sym_bare_tuple_expression] = STATE(2919),
    [sym_operator] = STATE(2646),
    [sym_parenthesized_expression] = STATE(2646),
    [sym_field_expression] = STATE(2568),
    [sym_subscript_expression] = STATE(2646),
    [sym_typed_expression] = STATE(2907),
    [sym_parameterized_identifier] = STATE(2646),
    [sym_compound_expression] = STATE(2907),
    [sym_call_expression] = STATE(2646),
    [sym_broadcast_call_expression] = STATE(2646),
    [sym_macro_expression] = STATE(2907),
    [sym_spread_expression] = STATE(2907),
    [sym_unary_expression] = STATE(2907),
    [sym_binary_expression] = STATE(2907),
    [sym_ternary_expression] = STATE(2907),
    [sym_pair_expression] = STATE(2907),
    [sym_tuple_expression] = STATE(2646),
    [sym_array_expression] = STATE(2646),
    [sym_matrix_expression] = STATE(2646),
    [sym_generator_expression] = STATE(2907),
    [sym_array_comprehension_expression] = STATE(2646),
    [sym_function_expression] = STATE(2907),
    [sym_range_expression] = STATE(2907),
    [sym_coefficient_expression] = STATE(2907),
    [sym_quote_expression] = STATE(2907),
    [sym_interpolation_expression] = STATE(2907),
    [sym_macro_identifier] = STATE(63),
    [sym_string] = STATE(2646),
    [sym_identifier] = ACTIONS(1194),
    [anon_sym_function] = ACTIONS(533),
    [anon_sym_abstract] = ACTIONS(535),
    [anon_sym_primitive] = ACTIONS(537),
    [aux_sym_primitive_definition_token1] = ACTIONS(189),
    [anon_sym_mutable] = ACTIONS(539),
    [anon_sym_struct] = ACTIONS(541),
    [anon_sym_module] = ACTIONS(543),
    [anon_sym_macro] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_COMMA] = ACTIONS(191),
    [anon_sym_EQ] = ACTIONS(189),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(191),
    [anon_sym_LT_COLON] = ACTIONS(191),
    [anon_sym_if] = ACTIONS(549),
    [anon_sym_try] = ACTIONS(551),
    [anon_sym_for] = 