#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1836
#define LARGE_STATE_COUNT 656
#define SYMBOL_COUNT 508
#define ALIAS_COUNT 0
#define TOKEN_COUNT 350
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 5
#define MAX_ALIAS_SEQUENCE_LENGTH 13
#define PRODUCTION_ID_COUNT 18

enum {
  sym_comment = 1,
  sym_attr_ref = 2,
  sym_comdat_ref = 3,
  sym_global_var = 4,
  sym_local_var = 5,
  sym_label = 6,
  aux_sym_metadata_ref_token1 = 7,
  sym_summary_ref = 8,
  sym_string = 9,
  aux_sym_number_token1 = 10,
  aux_sym_number_token2 = 11,
  sym_float = 12,
  sym_cstring = 13,
  anon_sym_target = 14,
  anon_sym_triple = 15,
  anon_sym_EQ = 16,
  anon_sym_datalayout = 17,
  anon_sym_source_filename = 18,
  anon_sym_declare = 19,
  anon_sym_define = 20,
  anon_sym_no_cfi = 21,
  anon_sym_private = 22,
  anon_sym_internal = 23,
  anon_sym_weak = 24,
  anon_sym_weak_odr = 25,
  anon_sym_linkonce = 26,
  anon_sym_linkonce_odr = 27,
  anon_sym_available_externally = 28,
  anon_sym_appending = 29,
  anon_sym_common = 30,
  anon_sym_extern_weak = 31,
  anon_sym_external = 32,
  anon_sym_dso_local = 33,
  anon_sym_dso_local_equivalent = 34,
  anon_sym_dso_preemptable = 35,
  anon_sym_default = 36,
  anon_sym_hidden = 37,
  anon_sym_protected = 38,
  anon_sym_dllimport = 39,
  anon_sym_dllexport = 40,
  anon_sym_ccc = 41,
  anon_sym_fastcc = 42,
  anon_sym_coldcc = 43,
  anon_sym_webkit_jscc = 44,
  anon_sym_anyregcc = 45,
  anon_sym_preserve_mostcc = 46,
  anon_sym_preserve_allcc = 47,
  anon_sym_cxx_fast_tlscc = 48,
  anon_sym_tailcc = 49,
  anon_sym_swiftcc = 50,
  anon_sym_swifttailcc = 51,
  anon_sym_cfguard_checkcc = 52,
  aux_sym_calling_conv_token1 = 53,
  aux_sym_calling_conv_token2 = 54,
  aux_sym_calling_conv_token3 = 55,
  aux_sym_calling_conv_token4 = 56,
  aux_sym_calling_conv_token5 = 57,
  aux_sym_calling_conv_token6 = 58,
  aux_sym_calling_conv_token7 = 59,
  aux_sym_calling_conv_token8 = 60,
  aux_sym_calling_conv_token9 = 61,
  aux_sym_calling_conv_token10 = 62,
  anon_sym_ghccc = 63,
  aux_sym_calling_conv_token11 = 64,
  aux_sym_calling_conv_token12 = 65,
  aux_sym_calling_conv_token13 = 66,
  aux_sym_calling_conv_token14 = 67,
  anon_sym_cc = 68,
  anon_sym_unnamed_addr = 69,
  anon_sym_local_unnamed_addr = 70,
  anon_sym_STAR = 71,
  anon_sym_void = 72,
  anon_sym_half = 73,
  anon_sym_bfloat = 74,
  anon_sym_float = 75,
  anon_sym_double = 76,
  anon_sym_x86_fp80 = 77,
  anon_sym_fp128 = 78,
  anon_sym_ppc_fp128 = 79,
  anon_sym_label = 80,
  anon_sym_metadata = 81,
  anon_sym_x86_mmx = 82,
  anon_sym_x86_amx = 83,
  anon_sym_token = 84,
  anon_sym_opaque = 85,
  anon_sym_ptr = 86,
  aux_sym_type_keyword_token1 = 87,
  anon_sym_LBRACE = 88,
  anon_sym_RBRACE = 89,
  anon_sym_LT_LBRACE = 90,
  anon_sym_RBRACE_GT = 91,
  anon_sym_LBRACK = 92,
  anon_sym_RBRACK = 93,
  anon_sym_LT = 94,
  anon_sym_GT = 95,
  anon_sym_COMMA = 96,
  anon_sym_vscale = 97,
  anon_sym_x = 98,
  anon_sym_addrspace = 99,
  anon_sym_LPAREN = 100,
  anon_sym_RPAREN = 101,
  anon_sym_DOT_DOT_DOT = 102,
  anon_sym_align = 103,
  anon_sym_section = 104,
  anon_sym_partition = 105,
  anon_sym_comdat = 106,
  anon_sym_gc = 107,
  anon_sym_prefix = 108,
  anon_sym_prologue = 109,
  anon_sym_personality = 110,
  anon_sym_alignstack = 111,
  anon_sym_allocsize = 112,
  anon_sym_alwaysinline = 113,
  anon_sym_builtin = 114,
  anon_sym_cold = 115,
  anon_sym_convergent = 116,
  anon_sym_disable_sanitizer_instrumentation = 117,
  anon_sym_hot = 118,
  anon_sym_inaccessiblememonly = 119,
  anon_sym_inaccessiblemem_or_argmemonly = 120,
  anon_sym_inlinehint = 121,
  anon_sym_jumptable = 122,
  anon_sym_minsize = 123,
  anon_sym_naked = 124,
  anon_sym_no_DASHjump_DASHtables = 125,
  anon_sym_nobuiltin = 126,
  anon_sym_noduplicate = 127,
  anon_sym_nofree = 128,
  anon_sym_noimplicitfloat = 129,
  anon_sym_noinline = 130,
  anon_sym_nomerge = 131,
  anon_sym_nonlazybind = 132,
  anon_sym_noprofile = 133,
  anon_sym_noredzone = 134,
  anon_sym_indirect_DASHtls_DASHseg_DASHrefs = 135,
  anon_sym_noreturn = 136,
  anon_sym_norecurse = 137,
  anon_sym_willreturn = 138,
  anon_sym_nosync = 139,
  anon_sym_nounwind = 140,
  anon_sym_nosanitize_coverage = 141,
  anon_sym_null_pointer_is_valid = 142,
  anon_sym_optforfuzzing = 143,
  anon_sym_optnone = 144,
  anon_sym_optsize = 145,
  anon_sym_readnone = 146,
  anon_sym_readonly = 147,
  anon_sym_writeonly = 148,
  anon_sym_argmemonly = 149,
  anon_sym_returns_twice = 150,
  anon_sym_safestack = 151,
  anon_sym_sanitize_address = 152,
  anon_sym_sanitize_memory = 153,
  anon_sym_sanitize_thread = 154,
  anon_sym_sanitize_hwaddress = 155,
  anon_sym_sanitize_memtag = 156,
  anon_sym_speculative_load_hardening = 157,
  anon_sym_speculatable = 158,
  anon_sym_ssp = 159,
  anon_sym_sspstrong = 160,
  anon_sym_sspreq = 161,
  anon_sym_strictfp = 162,
  anon_sym_uwtable = 163,
  anon_sym_nocf_check = 164,
  anon_sym_shadowcallstack = 165,
  anon_sym_mustprogress = 166,
  anon_sym_vscale_range = 167,
  anon_sym_preallocated = 168,
  anon_sym_zeroext = 169,
  anon_sym_signext = 170,
  anon_sym_inreg = 171,
  anon_sym_byval = 172,
  anon_sym_byref = 173,
  anon_sym_inalloca = 174,
  anon_sym_sret = 175,
  anon_sym_elementtype = 176,
  anon_sym_noalias = 177,
  anon_sym_nocapture = 178,
  anon_sym_nest = 179,
  anon_sym_returned = 180,
  anon_sym_nonnull = 181,
  anon_sym_dereferenceable = 182,
  anon_sym_dereferenceable_or_null = 183,
  anon_sym_swiftself = 184,
  anon_sym_swiftasync = 185,
  anon_sym_swifterror = 186,
  anon_sym_immarg = 187,
  anon_sym_noundef = 188,
  anon_sym_unreachable = 189,
  anon_sym_ret = 190,
  anon_sym_br = 191,
  anon_sym_resume = 192,
  anon_sym_freeze = 193,
  anon_sym_indirectbr = 194,
  anon_sym_extractelement = 195,
  anon_sym_insertelement = 196,
  anon_sym_select = 197,
  anon_sym_shufflevector = 198,
  anon_sym_fneg = 199,
  anon_sym_nsw = 200,
  anon_sym_nuw = 201,
  anon_sym_exact = 202,
  anon_sym_switch = 203,
  anon_sym_invoke = 204,
  anon_sym_to = 205,
  anon_sym_unwind = 206,
  anon_sym_cleanupret = 207,
  anon_sym_from = 208,
  anon_sym_catchret = 209,
  anon_sym_catchswitch = 210,
  anon_sym_catchpad = 211,
  anon_sym_cleanuppad = 212,
  anon_sym_callbr = 213,
  anon_sym_icmp = 214,
  anon_sym_fcmp = 215,
  anon_sym_va_arg = 216,
  anon_sym_phi = 217,
  anon_sym_landingpad = 218,
  anon_sym_cleanup = 219,
  anon_sym_tail = 220,
  anon_sym_musttail = 221,
  anon_sym_notail = 222,
  anon_sym_call = 223,
  anon_sym_alloca = 224,
  anon_sym_load = 225,
  anon_sym_atomic = 226,
  anon_sym_volatile = 227,
  anon_sym_store = 228,
  anon_sym_cmpxchg = 229,
  anon_sym_atomicrmw = 230,
  anon_sym_fence = 231,
  anon_sym_getelementptr = 232,
  anon_sym_inbounds = 233,
  anon_sym_inrange = 234,
  anon_sym_extractvalue = 235,
  anon_sym_insertvalue = 236,
  anon_sym_true = 237,
  anon_sym_false = 238,
  anon_sym_null = 239,
  anon_sym_none = 240,
  anon_sym_undef = 241,
  anon_sym_poison = 242,
  anon_sym_zeroinitializer = 243,
  anon_sym_catch = 244,
  anon_sym_filter = 245,
  anon_sym_blockaddress = 246,
  anon_sym_mul = 247,
  anon_sym_urem = 248,
  anon_sym_srem = 249,
  anon_sym_shl = 250,
  anon_sym_udiv = 251,
  anon_sym_sdiv = 252,
  anon_sym_lshr = 253,
  anon_sym_ashr = 254,
  anon_sym_fmul = 255,
  anon_sym_fdiv = 256,
  anon_sym_frem = 257,
  anon_sym_xchg = 258,
  anon_sym_add = 259,
  anon_sym_sub = 260,
  anon_sym_and = 261,
  anon_sym_nand = 262,
  anon_sym_or = 263,
  anon_sym_xor = 264,
  anon_sym_max = 265,
  anon_sym_min = 266,
  anon_sym_umax = 267,
  anon_sym_umin = 268,
  anon_sym_fadd = 269,
  anon_sym_fsub = 270,
  anon_sym_eq = 271,
  anon_sym_ne = 272,
  anon_sym_ugt = 273,
  anon_sym_uge = 274,
  anon_sym_ult = 275,
  anon_sym_ule = 276,
  anon_sym_sgt = 277,
  anon_sym_sge = 278,
  anon_sym_slt = 279,
  anon_sym_sle = 280,
  anon_sym_oeq = 281,
  anon_sym_ogt = 282,
  anon_sym_oge = 283,
  anon_sym_olt = 284,
  anon_sym_ole = 285,
  anon_sym_one = 286,
  anon_sym_ord = 287,
  anon_sym_ueq = 288,
  anon_sym_une = 289,
  anon_sym_uno = 290,
  anon_sym_bitcast = 291,
  anon_sym_trunc = 292,
  anon_sym_zext = 293,
  anon_sym_sext = 294,
  anon_sym_fptrunc = 295,
  anon_sym_fpext = 296,
  anon_sym_addrspacecast = 297,
  anon_sym_uitofp = 298,
  anon_sym_sitofp = 299,
  anon_sym_fptoui = 300,
  anon_sym_fptosi = 301,
  anon_sym_inttoptr = 302,
  anon_sym_ptrtoint = 303,
  anon_sym_unordered = 304,
  anon_sym_monotonic = 305,
  anon_sym_acquire = 306,
  anon_sym_release = 307,
  anon_sym_acq_rel = 308,
  anon_sym_seq_cst = 309,
  anon_sym_syncscope = 310,
  anon_sym_nnan = 311,
  anon_sym_ninf = 312,
  anon_sym_nsz = 313,
  anon_sym_arcp = 314,
  anon_sym_contract = 315,
  anon_sym_afn = 316,
  anon_sym_reassoc = 317,
  anon_sym_fast = 318,
  anon_sym_within = 319,
  anon_sym_caller = 320,
  anon_sym_uselistorder = 321,
  anon_sym_uselistorder_bb = 322,
  anon_sym_module = 323,
  anon_sym_asm = 324,
  anon_sym_sideeffect = 325,
  anon_sym_inteldialect = 326,
  anon_sym_type = 327,
  anon_sym_externally_initialized = 328,
  anon_sym_global = 329,
  anon_sym_constant = 330,
  anon_sym_alias = 331,
  anon_sym_ifunc = 332,
  anon_sym_thread_local = 333,
  anon_sym_localdynamic = 334,
  anon_sym_initialexec = 335,
  anon_sym_localexec = 336,
  anon_sym_any = 337,
  anon_sym_exactmatch = 338,
  anon_sym_largest = 339,
  anon_sym_nodeduplicate = 340,
  anon_sym_samesize = 341,
  anon_sym_distinct = 342,
  anon_sym_BANG = 343,
  anon_sym_LBRACE2 = 344,
  anon_sym_LPAREN2 = 345,
  aux_sym_specialized_md_value_token1 = 346,
  anon_sym_PIPE = 347,
  anon_sym_COLON = 348,
  anon_sym_attributes = 349,
  sym_module = 350,
  sym_metadata_ref = 351,
  sym_metadata_name = 352,
  sym_number = 353,
  sym_var = 354,
  sym_target_definition = 355,
  sym_target_triple = 356,
  sym_data_layout = 357,
  sym_source_file_name = 358,
  sym_declare = 359,
  sym_define = 360,
  sym_metadata_attachment = 361,
  sym_function_header = 362,
  sym_linkage = 363,
  sym_linkage_aux = 364,
  sym_dso_local = 365,
  sym_visibility = 366,
  sym_dll_storage_class = 367,
  sym_calling_conv = 368,
  sym_unnamed_addr = 369,
  sym_type = 370,
  sym_type_keyword = 371,
  sym_struct_type = 372,
  sym_packed_struct_type = 373,
  sym_array_type = 374,
  sym_vector_type = 375,
  sym_struct_body = 376,
  sym_array_vector_body = 377,
  sym_addrspace = 378,
  sym_argument_list = 379,
  sym_argument = 380,
  sym_param_or_return_attrs = 381,
  sym_attribute = 382,
  sym_attribute_name = 383,
  sym_function_body = 384,
  sym_instruction = 385,
  sym__instruction_body = 386,
  sym_instruction_unreachable = 387,
  sym_instruction_ret = 388,
  sym_instruction_br = 389,
  sym_instruction_resume = 390,
  sym_instruction_freeze = 391,
  sym_instruction_indirectbr = 392,
  sym_instruction_extractelement = 393,
  sym_instruction_insertelement = 394,
  sym_instruction_select = 395,
  sym_instruction_shufflevector = 396,
  sym_instruction_fneg = 397,
  sym_instruction_bin_op = 398,
  sym_instruction_switch = 399,
  sym_instruction_invoke = 400,
  sym_instruction_cleanupret = 401,
  sym_instruction_catchret = 402,
  sym_instruction_catchswitch = 403,
  sym_instruction_catchpad = 404,
  sym_instruction_cleanuppad = 405,
  sym_instruction_callbr = 406,
  sym_instruction_icmp = 407,
  sym_instruction_fcmp = 408,
  sym_instruction_cast = 409,
  sym_instruction_va_arg = 410,
  sym_instruction_phi = 411,
  sym_instruction_landingpad = 412,
  sym_instruction_call = 413,
  sym_instruction_alloca = 414,
  sym_instruction_load = 415,
  sym_instruction_store = 416,
  sym_instruction_cmpxchg = 417,
  sym_instruction_atomicrmw = 418,
  sym_instruction_fence = 419,
  sym_instruction_getelementptr = 420,
  sym_instruction_extractvalue = 421,
  sym_instruction_insertvalue = 422,
  sym__call_part = 423,
  sym_type_and_value = 424,
  sym_value = 425,
  sym__primitive_value = 426,
  sym_struct_value = 427,
  sym_packed_struct_value = 428,
  sym_array_value = 429,
  sym_vector_value = 430,
  sym_metadata_refs = 431,
  sym_operand_bundles = 432,
  sym_landingpad_clause = 433,
  sym_blockaddress = 434,
  sym_constant_expr = 435,
  sym_constant_cast = 436,
  sym_constant_getelementptr = 437,
  sym_constant_select = 438,
  sym_constant_icmp = 439,
  sym_constant_fcmp = 440,
  sym_constant_extractelement = 441,
  sym_constant_insertelement = 442,
  sym_constant_shufflevector = 443,
  sym_constant_extractvalue = 444,
  sym_constant_insertvalue = 445,
  sym_constant_fneg = 446,
  sym_constant_bin_op = 447,
  sym_bin_op_keyword = 448,
  sym_atomic_bin_op_keyword = 449,
  sym_icmp_cond = 450,
  sym_fcmp_cond = 451,
  sym_cast_inst = 452,
  sym_atomic_ordering = 453,
  sym_alignment = 454,
  sym__load_store_suffix = 455,
  sym_syncscope = 456,
  sym_fast_math = 457,
  sym__value_array = 458,
  sym__within = 459,
  sym__unwind_label = 460,
  sym_use_list_order = 461,
  sym_use_list_order_bb = 462,
  sym_module_asm = 463,
  sym_inline_asm = 464,
  sym_asm = 465,
  sym_global_type = 466,
  sym__global_prefix = 467,
  sym_global_global = 468,
  sym_alias = 469,
  sym_ifunc = 470,
  sym_thread_local = 471,
  sym_comdat = 472,
  sym_global_metadata = 473,
  sym_metadata = 474,
  sym_metadata_tuple = 475,
  sym_specialized_md = 476,
  sym_specialized_md_value = 477,
  sym_summary_entry = 478,
  sym_summary_value = 479,
  sym_unnamed_attr_grp = 480,
  aux_sym_module_repeat1 = 481,
  aux_sym_declare_repeat1 = 482,
  aux_sym_function_header_repeat1 = 483,
  aux_sym_function_header_repeat2 = 484,
  aux_sym_function_header_repeat3 = 485,
  aux_sym_type_repeat1 = 486,
  aux_sym_type_repeat2 = 487,
  aux_sym_struct_body_repeat1 = 488,
  aux_sym_argument_list_repeat1 = 489,
  aux_sym_attribute_repeat1 = 490,
  aux_sym_function_body_repeat1 = 491,
  aux_sym_function_body_repeat2 = 492,
  aux_sym_instruction_repeat1 = 493,
  aux_sym_instruction_select_repeat1 = 494,
  aux_sym_instruction_bin_op_repeat1 = 495,
  aux_sym_instruction_switch_repeat1 = 496,
  aux_sym_instruction_callbr_repeat1 = 497,
  aux_sym_instruction_phi_repeat1 = 498,
  aux_sym_instruction_landingpad_repeat1 = 499,
  aux_sym_instruction_alloca_repeat1 = 500,
  aux_sym_instruction_getelementptr_repeat1 = 501,
  aux_sym_instruction_extractvalue_repeat1 = 502,
  aux_sym_operand_bundles_repeat1 = 503,
  aux_sym_global_global_repeat1 = 504,
  aux_sym_metadata_tuple_repeat1 = 505,
  aux_sym_specialized_md_repeat1 = 506,
  aux_sym_summary_entry_repeat1 = 507,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_comment] = "comment",
  [sym_attr_ref] = "attr_ref",
  [sym_comdat_ref] = "comdat_ref",
  [sym_global_var] = "global_var",
  [sym_local_var] = "local_var",
  [sym_label] = "label",
  [aux_sym_metadata_ref_token1] = "metadata_ref_token1",
  [sym_summary_ref] = "summary_ref",
  [sym_string] = "string",
  [aux_sym_number_token1] = "number_token1",
  [aux_sym_number_token2] = "number_token2",
  [sym_float] = "float",
  [sym_cstring] = "cstring",
  [anon_sym_target] = "target",
  [anon_sym_triple] = "triple",
  [anon_sym_EQ] = "=",
  [anon_sym_datalayout] = "datalayout",
  [anon_sym_source_filename] = "source_filename",
  [anon_sym_declare] = "declare",
  [anon_sym_define] = "define",
  [anon_sym_no_cfi] = "no_cfi",
  [anon_sym_private] = "private",
  [anon_sym_internal] = "internal",
  [anon_sym_weak] = "weak",
  [anon_sym_weak_odr] = "weak_odr",
  [anon_sym_linkonce] = "linkonce",
  [anon_sym_linkonce_odr] = "linkonce_odr",
  [anon_sym_available_externally] = "available_externally",
  [anon_sym_appending] = "appending",
  [anon_sym_common] = "common",
  [anon_sym_extern_weak] = "extern_weak",
  [anon_sym_external] = "external",
  [anon_sym_dso_local] = "dso_local",
  [anon_sym_dso_local_equivalent] = "dso_local_equivalent",
  [anon_sym_dso_preemptable] = "dso_preemptable",
  [anon_sym_default] = "default",
  [anon_sym_hidden] = "hidden",
  [anon_sym_protected] = "protected",
  [anon_sym_dllimport] = "dllimport",
  [anon_sym_dllexport] = "dllexport",
  [anon_sym_ccc] = "ccc",
  [anon_sym_fastcc] = "fastcc",
  [anon_sym_coldcc] = "coldcc",
  [anon_sym_webkit_jscc] = "webkit_jscc",
  [anon_sym_anyregcc] = "anyregcc",
  [anon_sym_preserve_mostcc] = "preserve_mostcc",
  [anon_sym_preserve_allcc] = "preserve_allcc",
  [anon_sym_cxx_fast_tlscc] = "cxx_fast_tlscc",
  [anon_sym_tailcc] = "tailcc",
  [anon_sym_swiftcc] = "swiftcc",
  [anon_sym_swifttailcc] = "swifttailcc",
  [anon_sym_cfguard_checkcc] = "cfguard_checkcc",
  [aux_sym_calling_conv_token1] = "calling_conv_token1",
  [aux_sym_calling_conv_token2] = "calling_conv_token2",
  [aux_sym_calling_conv_token3] = "calling_conv_token3",
  [aux_sym_calling_conv_token4] = "calling_conv_token4",
  [aux_sym_calling_conv_token5] = "calling_conv_token5",
  [aux_sym_calling_conv_token6] = "calling_conv_token6",
  [aux_sym_calling_conv_token7] = "calling_conv_token7",
  [aux_sym_calling_conv_token8] = "calling_conv_token8",
  [aux_sym_calling_conv_token9] = "calling_conv_token9",
  [aux_sym_calling_conv_token10] = "calling_conv_token10",
  [anon_sym_ghccc] = "ghccc",
  [aux_sym_calling_conv_token11] = "calling_conv_token11",
  [aux_sym_calling_conv_token12] = "calling_conv_token12",
  [aux_sym_calling_conv_token13] = "calling_conv_token13",
  [aux_sym_calling_conv_token14] = "calling_conv_token14",
  [anon_sym_cc] = "cc",
  [anon_sym_unnamed_addr] = "unnamed_addr",
  [anon_sym_local_unnamed_addr] = "local_unnamed_addr",
  [anon_sym_STAR] = "*",
  [anon_sym_void] = "void",
  [anon_sym_half] = "half",
  [anon_sym_bfloat] = "bfloat",
  [anon_sym_float] = "float",
  [anon_sym_double] = "double",
  [anon_sym_x86_fp80] = "x86_fp80",
  [anon_sym_fp128] = "fp128",
  [anon_sym_ppc_fp128] = "ppc_fp128",
  [anon_sym_label] = "label",
  [anon_sym_metadata] = "metadata",
  [anon_sym_x86_mmx] = "x86_mmx",
  [anon_sym_x86_amx] = "x86_amx",
  [anon_sym_token] = "token",
  [anon_sym_opaque] = "opaque",
  [anon_sym_ptr] = "ptr",
  [aux_sym_type_keyword_token1] = "type_keyword_token1",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LT_LBRACE] = "<{",
  [anon_sym_RBRACE_GT] = "}>",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_COMMA] = ",",
  [anon_sym_vscale] = "vscale",
  [anon_sym_x] = "x",
  [anon_sym_addrspace] = "addrspace",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_align] = "align",
  [anon_sym_section] = "section",
  [anon_sym_partition] = "partition",
  [anon_sym_comdat] = "comdat",
  [anon_sym_gc] = "gc",
  [anon_sym_prefix] = "prefix",
  [anon_sym_prologue] = "prologue",
  [anon_sym_personality] = "personality",
  [anon_sym_alignstack] = "alignstack",
  [anon_sym_allocsize] = "allocsize",
  [anon_sym_alwaysinline] = "alwaysinline",
  [anon_sym_builtin] = "builtin",
  [anon_sym_cold] = "cold",
  [anon_sym_convergent] = "convergent",
  [anon_sym_disable_sanitizer_instrumentation] = "disable_sanitizer_instrumentation",
  [anon_sym_hot] = "hot",
  [anon_sym_inaccessiblememonly] = "inaccessiblememonly",
  [anon_sym_inaccessiblemem_or_argmemonly] = "inaccessiblemem_or_argmemonly",
  [anon_sym_inlinehint] = "inlinehint",
  [anon_sym_jumptable] = "jumptable",
  [anon_sym_minsize] = "minsize",
  [anon_sym_naked] = "naked",
  [anon_sym_no_DASHjump_DASHtables] = "no-jump-tables",
  [anon_sym_nobuiltin] = "nobuiltin",
  [anon_sym_noduplicate] = "noduplicate",
  [anon_sym_nofree] = "nofree",
  [anon_sym_noimplicitfloat] = "noimplicitfloat",
  [anon_sym_noinline] = "noinline",
  [anon_sym_nomerge] = "nomerge",
  [anon_sym_nonlazybind] = "nonlazybind",
  [anon_sym_noprofile] = "noprofile",
  [anon_sym_noredzone] = "noredzone",
  [anon_sym_indirect_DASHtls_DASHseg_DASHrefs] = "indirect-tls-seg-refs",
  [anon_sym_noreturn] = "noreturn",
  [anon_sym_norecurse] = "norecurse",
  [anon_sym_willreturn] = "willreturn",
  [anon_sym_nosync] = "nosync",
  [anon_sym_nounwind] = "nounwind",
  [anon_sym_nosanitize_coverage] = "nosanitize_coverage",
  [anon_sym_null_pointer_is_valid] = "null_pointer_is_valid",
  [anon_sym_optforfuzzing] = "optforfuzzing",
  [anon_sym_optnone] = "optnone",
  [anon_sym_optsize] = "optsize",
  [anon_sym_readnone] = "readnone",
  [anon_sym_readonly] = "readonly",
  [anon_sym_writeonly] = "writeonly",
  [anon_sym_argmemonly] = "argmemonly",
  [anon_sym_returns_twice] = "returns_twice",
  [anon_sym_safestack] = "safestack",
  [anon_sym_sanitize_address] = "sanitize_address",
  [anon_sym_sanitize_memory] = "sanitize_memory",
  [anon_sym_sanitize_thread] = "sanitize_thread",
  [anon_sym_sanitize_hwaddress] = "sanitize_hwaddress",
  [anon_sym_sanitize_memtag] = "sanitize_memtag",
  [anon_sym_speculative_load_hardening] = "speculative_load_hardening",
  [anon_sym_speculatable] = "speculatable",
  [anon_sym_ssp] = "ssp",
  [anon_sym_sspstrong] = "sspstrong",
  [anon_sym_sspreq] = "sspreq",
  [anon_sym_strictfp] = "strictfp",
  [anon_sym_uwtable] = "uwtable",
  [anon_sym_nocf_check] = "nocf_check",
  [anon_sym_shadowcallstack] = "shadowcallstack",
  [anon_sym_mustprogress] = "mustprogress",
  [anon_sym_vscale_range] = "vscale_range",
  [anon_sym_preallocated] = "preallocated",
  [anon_sym_zeroext] = "zeroext",
  [anon_sym_signext] = "signext",
  [anon_sym_inreg] = "inreg",
  [anon_sym_byval] = "byval",
  [anon_sym_byref] = "byref",
  [anon_sym_inalloca] = "inalloca",
  [anon_sym_sret] = "sret",
  [anon_sym_elementtype] = "elementtype",
  [anon_sym_noalias] = "noalias",
  [anon_sym_nocapture] = "nocapture",
  [anon_sym_nest] = "nest",
  [anon_sym_returned] = "returned",
  [anon_sym_nonnull] = "nonnull",
  [anon_sym_dereferenceable] = "dereferenceable",
  [anon_sym_dereferenceable_or_null] = "dereferenceable_or_null",
  [anon_sym_swiftself] = "swiftself",
  [anon_sym_swiftasync] = "swiftasync",
  [anon_sym_swifterror] = "swifterror",
  [anon_sym_immarg] = "immarg",
  [anon_sym_noundef] = "noundef",
  [anon_sym_unreachable] = "unreachable",
  [anon_sym_ret] = "ret",
  [anon_sym_br] = "br",
  [anon_sym_resume] = "resume",
  [anon_sym_freeze] = "freeze",
  [anon_sym_indirectbr] = "indirectbr",
  [anon_sym_extractelement] = "extractelement",
  [anon_sym_insertelement] = "insertelement",
  [anon_sym_select] = "select",
  [anon_sym_shufflevector] = "shufflevector",
  [anon_sym_fneg] = "fneg",
  [anon_sym_nsw] = "nsw",
  [anon_sym_nuw] = "nuw",
  [anon_sym_exact] = "exact",
  [anon_sym_switch] = "switch",
  [anon_sym_invoke] = "invoke",
  [anon_sym_to] = "to",
  [anon_sym_unwind] = "unwind",
  [anon_sym_cleanupret] = "cleanupret",
  [anon_sym_from] = "from",
  [anon_sym_catchret] = "catchret",
  [anon_sym_catchswitch] = "catchswitch",
  [anon_sym_catchpad] = "catchpad",
  [anon_sym_cleanuppad] = "cleanuppad",
  [anon_sym_callbr] = "callbr",
  [anon_sym_icmp] = "icmp",
  [anon_sym_fcmp] = "fcmp",
  [anon_sym_va_arg] = "va_arg",
  [anon_sym_phi] = "phi",
  [anon_sym_landingpad] = "landingpad",
  [anon_sym_cleanup] = "cleanup",
  [anon_sym_tail] = "tail",
  [anon_sym_musttail] = "musttail",
  [anon_sym_notail] = "notail",
  [anon_sym_call] = "call",
  [anon_sym_alloca] = "alloca",
  [anon_sym_load] = "load",
  [anon_sym_atomic] = "atomic",
  [anon_sym_volatile] = "volatile",
  [anon_sym_store] = "store",
  [anon_sym_cmpxchg] = "cmpxchg",
  [anon_sym_atomicrmw] = "atomicrmw",
  [anon_sym_fence] = "fence",
  [anon_sym_getelementptr] = "getelementptr",
  [anon_sym_inbounds] = "inbounds",
  [anon_sym_inrange] = "inrange",
  [anon_sym_extractvalue] = "extractvalue",
  [anon_sym_insertvalue] = "insertvalue",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_null] = "null",
  [anon_sym_none] = "none",
  [anon_sym_undef] = "undef",
  [anon_sym_poison] = "poison",
  [anon_sym_zeroinitializer] = "zeroinitializer",
  [anon_sym_catch] = "catch",
  [anon_sym_filter] = "filter",
  [anon_sym_blockaddress] = "blockaddress",
  [anon_sym_mul] = "mul",
  [anon_sym_urem] = "urem",
  [anon_sym_srem] = "srem",
  [anon_sym_shl] = "shl",
  [anon_sym_udiv] = "udiv",
  [anon_sym_sdiv] = "sdiv",
  [anon_sym_lshr] = "lshr",
  [anon_sym_ashr] = "ashr",
  [anon_sym_fmul] = "fmul",
  [anon_sym_fdiv] = "fdiv",
  [anon_sym_frem] = "frem",
  [anon_sym_xchg] = "xchg",
  [anon_sym_add] = "add",
  [anon_sym_sub] = "sub",
  [anon_sym_and] = "and",
  [anon_sym_nand] = "nand",
  [anon_sym_or] = "or",
  [anon_sym_xor] = "xor",
  [anon_sym_max] = "max",
  [anon_sym_min] = "min",
  [anon_sym_umax] = "umax",
  [anon_sym_umin] = "umin",
  [anon_sym_fadd] = "fadd",
  [anon_sym_fsub] = "fsub",
  [anon_sym_eq] = "eq",
  [anon_sym_ne] = "ne",
  [anon_sym_ugt] = "ugt",
  [anon_sym_uge] = "uge",
  [anon_sym_ult] = "ult",
  [anon_sym_ule] = "ule",
  [anon_sym_sgt] = "sgt",
  [anon_sym_sge] = "sge",
  [anon_sym_slt] = "slt",
  [anon_sym_sle] = "sle",
  [anon_sym_oeq] = "oeq",
  [anon_sym_ogt] = "ogt",
  [anon_sym_oge] = "oge",
  [anon_sym_olt] = "olt",
  [anon_sym_ole] = "ole",
  [anon_sym_one] = "one",
  [anon_sym_ord] = "ord",
  [anon_sym_ueq] = "ueq",
  [anon_sym_une] = "une",
  [anon_sym_uno] = "uno",
  [anon_sym_bitcast] = "bitcast",
  [anon_sym_trunc] = "trunc",
  [anon_sym_zext] = "zext",
  [anon_sym_sext] = "sext",
  [anon_sym_fptrunc] = "fptrunc",
  [anon_sym_fpext] = "fpext",
  [anon_sym_addrspacecast] = "addrspacecast",
  [anon_sym_uitofp] = "uitofp",
  [anon_sym_sitofp] = "sitofp",
  [anon_sym_fptoui] = "fptoui",
  [anon_sym_fptosi] = "fptosi",
  [anon_sym_inttoptr] = "inttoptr",
  [anon_sym_ptrtoint] = "ptrtoint",
  [anon_sym_unordered] = "unordered",
  [anon_sym_monotonic] = "monotonic",
  [anon_sym_acquire] = "acquire",
  [anon_sym_release] = "release",
  [anon_sym_acq_rel] = "acq_rel",
  [anon_sym_seq_cst] = "seq_cst",
  [anon_sym_syncscope] = "syncscope",
  [anon_sym_nnan] = "nnan",
  [anon_sym_ninf] = "ninf",
  [anon_sym_nsz] = "nsz",
  [anon_sym_arcp] = "arcp",
  [anon_sym_contract] = "contract",
  [anon_sym_afn] = "afn",
  [anon_sym_reassoc] = "reassoc",
  [anon_sym_fast] = "fast",
  [anon_sym_within] = "within",
  [anon_sym_caller] = "caller",
  [anon_sym_uselistorder] = "uselistorder",
  [anon_sym_uselistorder_bb] = "uselistorder_bb",
  [anon_sym_module] = "module",
  [anon_sym_asm] = "asm",
  [anon_sym_sideeffect] = "sideeffect",
  [anon_sym_inteldialect] = "inteldialect",
  [anon_sym_type] = "type",
  [anon_sym_externally_initialized] = "externally_initialized",
  [anon_sym_global] = "global",
  [anon_sym_constant] = "constant",
  [anon_sym_alias] = "alias",
  [anon_sym_ifunc] = "ifunc",
  [anon_sym_thread_local] = "thread_local",
  [anon_sym_localdynamic] = "localdynamic",
  [anon_sym_initialexec] = "initialexec",
  [anon_sym_localexec] = "localexec",
  [anon_sym_any] = "any",
  [anon_sym_exactmatch] = "exactmatch",
  [anon_sym_largest] = "largest",
  [anon_sym_nodeduplicate] = "nodeduplicate",
  [anon_sym_samesize] = "samesize",
  [anon_sym_distinct] = "distinct",
  [anon_sym_BANG] = "!",
  [anon_sym_LBRACE2] = "{",
  [anon_sym_LPAREN2] = "(",
  [aux_sym_specialized_md_value_token1] = "specialized_md_value_token1",
  [anon_sym_PIPE] = "|",
  [anon_sym_COLON] = ":",
  [anon_sym_attributes] = "attributes",
  [sym_module] = "module",
  [sym_metadata_ref] = "metadata_ref",
  [sym_metadata_name] = "metadata_name",
  [sym_number] = "number",
  [sym_var] = "var",
  [sym_target_definition] = "target_definition",
  [sym_target_triple] = "target_triple",
  [sym_data_layout] = "data_layout",
  [sym_source_file_name] = "source_file_name",
  [sym_declare] = "declare",
  [sym_define] = "define",
  [sym_metadata_attachment] = "metadata_attachment",
  [sym_function_header] = "function_header",
  [sym_linkage] = "linkage",
  [sym_linkage_aux] = "linkage_aux",
  [sym_dso_local] = "dso_local",
  [sym_visibility] = "visibility",
  [sym_dll_storage_class] = "dll_storage_class",
  [sym_calling_conv] = "calling_conv",
  [sym_unnamed_addr] = "unnamed_addr",
  [sym_type] = "type",
  [sym_type_keyword] = "type_keyword",
  [sym_struct_type] = "struct_type",
  [sym_packed_struct_type] = "packed_struct_type",
  [sym_array_type] = "array_type",
  [sym_vector_type] = "vector_type",
  [sym_struct_body] = "struct_body",
  [sym_array_vector_body] = "array_vector_body",
  [sym_addrspace] = "addrspace",
  [sym_argument_list] = "argument_list",
  [sym_argument] = "argument",
  [sym_param_or_return_attrs] = "param_or_return_attrs",
  [sym_attribute] = "attribute",
  [sym_attribute_name] = "attribute_name",
  [sym_function_body] = "function_body",
  [sym_instruction] = "instruction",
  [sym__instruction_body] = "_instruction_body",
  [sym_instruction_unreachable] = "instruction_unreachable",
  [sym_instruction_ret] = "instruction_ret",
  [sym_instruction_br] = "instruction_br",
  [sym_instruction_resume] = "instruction_resume",
  [sym_instruction_freeze] = "instruction_freeze",
  [sym_instruction_indirectbr] = "instruction_indirectbr",
  [sym_instruction_extractelement] = "instruction_extractelement",
  [sym_instruction_insertelement] = "instruction_insertelement",
  [sym_instruction_select] = "instruction_select",
  [sym_instruction_shufflevector] = "instruction_shufflevector",
  [sym_instruction_fneg] = "instruction_fneg",
  [sym_instruction_bin_op] = "instruction_bin_op",
  [sym_instruction_switch] = "instruction_switch",
  [sym_instruction_invoke] = "instruction_invoke",
  [sym_instruction_cleanupret] = "instruction_cleanupret",
  [sym_instruction_catchret] = "instruction_catchret",
  [sym_instruction_catchswitch] = "instruction_catchswitch",
  [sym_instruction_catchpad] = "instruction_catchpad",
  [sym_instruction_cleanuppad] = "instruction_cleanuppad",
  [sym_instruction_callbr] = "instruction_callbr",
  [sym_instruction_icmp] = "instruction_icmp",
  [sym_instruction_fcmp] = "instruction_fcmp",
  [sym_instruction_cast] = "instruction_cast",
  [sym_instruction_va_arg] = "instruction_va_arg",
  [sym_instruction_phi] = "instruction_phi",
  [sym_instruction_landingpad] = "instruction_landingpad",
  [sym_instruction_call] = "instruction_call",
  [sym_instruction_alloca] = "instruction_alloca",
  [sym_instruction_load] = "instruction_load",
  [sym_instruction_store] = "instruction_store",
  [sym_instruction_cmpxchg] = "instruction_cmpxchg",
  [sym_instruction_atomicrmw] = "instruction_atomicrmw",
  [sym_instruction_fence] = "instruction_fence",
  [sym_instruction_getelementptr] = "instruction_getelementptr",
  [sym_instruction_extractvalue] = "instruction_extractvalue",
  [sym_instruction_insertvalue] = "instruction_insertvalue",
  [sym__call_part] = "_call_part",
  [sym_type_and_value] = "type_and_value",
  [sym_value] = "value",
  [sym__primitive_value] = "_primitive_value",
  [sym_struct_value] = "struct_value",
  [sym_packed_struct_value] = "packed_struct_value",
  [sym_array_value] = "array_value",
  [sym_vector_value] = "vector_value",
  [sym_metadata_refs] = "metadata_refs",
  [sym_operand_bundles] = "operand_bundles",
  [sym_landingpad_clause] = "landingpad_clause",
  [sym_blockaddress] = "blockaddress",
  [sym_constant_expr] = "constant_expr",
  [sym_constant_cast] = "constant_cast",
  [sym_constant_getelementptr] = "constant_getelementptr",
  [sym_constant_select] = "constant_select",
  [sym_constant_icmp] = "constant_icmp",
  [sym_constant_fcmp] = "constant_fcmp",
  [sym_constant_extractelement] = "constant_extractelement",
  [sym_constant_insertelement] = "constant_insertelement",
  [sym_constant_shufflevector] = "constant_shufflevector",
  [sym_constant_extractvalue] = "constant_extractvalue",
  [sym_constant_insertvalue] = "constant_insertvalue",
  [sym_constant_fneg] = "constant_fneg",
  [sym_constant_bin_op] = "constant_bin_op",
  [sym_bin_op_keyword] = "bin_op_keyword",
  [sym_atomic_bin_op_keyword] = "atomic_bin_op_keyword",
  [sym_icmp_cond] = "icmp_cond",
  [sym_fcmp_cond] = "fcmp_cond",
  [sym_cast_inst] = "cast_inst",
  [sym_atomic_ordering] = "atomic_ordering",
  [sym_alignment] = "alignment",
  [sym__load_store_suffix] = "_load_store_suffix",
  [sym_syncscope] = "syncscope",
  [sym_fast_math] = "fast_math",
  [sym__value_array] = "_value_array",
  [sym__within] = "_within",
  [sym__unwind_label] = "_unwind_label",
  [sym_use_list_order] = "use_list_order",
  [sym_use_list_order_bb] = "use_list_order_bb",
  [sym_module_asm] = "module_asm",
  [sym_inline_asm] = "inline_asm",
  [sym_asm] = "asm",
  [sym_global_type] = "global_type",
  [sym__global_prefix] = "_global_prefix",
  [sym_global_global] = "global_global",
  [sym_alias] = "alias",
  [sym_ifunc] = "ifunc",
  [sym_thread_local] = "thread_local",
  [sym_comdat] = "comdat",
  [sym_global_metadata] = "global_metadata",
  [sym_metadata] = "metadata",
  [sym_metadata_tuple] = "metadata_tuple",
  [sym_specialized_md] = "specialized_md",
  [sym_specialized_md_value] = "specialized_md_value",
  [sym_summary_entry] = "summary_entry",
  [sym_summary_value] = "summary_value",
  [sym_unnamed_attr_grp] = "unnamed_attr_grp",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_declare_repeat1] = "declare_repeat1",
  [aux_sym_function_header_repeat1] = "function_header_repeat1",
  [aux_sym_function_header_repeat2] = "function_header_repeat2",
  [aux_sym_function_header_repeat3] = "function_header_repeat3",
  [aux_sym_type_repeat1] = "type_repeat1",
  [aux_sym_type_repeat2] = "type_repeat2",
  [aux_sym_struct_body_repeat1] = "struct_body_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [aux_sym_function_body_repeat1] = "function_body_repeat1",
  [aux_sym_function_body_repeat2] = "function_body_repeat2",
  [aux_sym_instruction_repeat1] = "instruction_repeat1",
  [aux_sym_instruction_select_repeat1] = "instruction_select_repeat1",
  [aux_sym_instruction_bin_op_repeat1] = "instruction_bin_op_repeat1",
  [aux_sym_instruction_switch_repeat1] = "instruction_switch_repeat1",
  [aux_sym_instruction_callbr_repeat1] = "instruction_callbr_repeat1",
  [aux_sym_instruction_phi_repeat1] = "instruction_phi_repeat1",
  [aux_sym_instruction_landingpad_repeat1] = "instruction_landingpad_repeat1",
  [aux_sym_instruction_alloca_repeat1] = "instruction_alloca_repeat1",
  [aux_sym_instruction_getelementptr_repeat1] = "instruction_getelementptr_repeat1",
  [aux_sym_instruction_extractvalue_repeat1] = "instruction_extractvalue_repeat1",
  [aux_sym_operand_bundles_repeat1] = "operand_bundles_repeat1",
  [aux_sym_global_global_repeat1] = "global_global_repeat1",
  [aux_sym_metadata_tuple_repeat1] = "metadata_tuple_repeat1",
  [aux_sym_specialized_md_repeat1] = "specialized_md_repeat1",
  [aux_sym_summary_entry_repeat1] = "summary_entry_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_comment] = sym_comment,
  [sym_attr_ref] = sym_attr_ref,
  [sym_comdat_ref] = sym_comdat_ref,
  [sym_global_var] = sym_global_var,
  [sym_local_var] = sym_local_var,
  [sym_label] = sym_label,
  [aux_sym_metadata_ref_token1] = aux_sym_metadata_ref_token1,
  [sym_summary_ref] = sym_summary_ref,
  [sym_string] = sym_string,
  [aux_sym_number_token1] = aux_sym_number_token1,
  [aux_sym_number_token2] = aux_sym_number_token2,
  [sym_float] = sym_float,
  [sym_cstring] = sym_cstring,
  [anon_sym_target] = anon_sym_target,
  [anon_sym_triple] = anon_sym_triple,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_datalayout] = anon_sym_datalayout,
  [anon_sym_source_filename] = anon_sym_source_filename,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_define] = anon_sym_define,
  [anon_sym_no_cfi] = anon_sym_no_cfi,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_internal] = anon_sym_internal,
  [anon_sym_weak] = anon_sym_weak,
  [anon_sym_weak_odr] = anon_sym_weak_odr,
  [anon_sym_linkonce] = anon_sym_linkonce,
  [anon_sym_linkonce_odr] = anon_sym_linkonce_odr,
  [anon_sym_available_externally] = anon_sym_available_externally,
  [anon_sym_appending] = anon_sym_appending,
  [anon_sym_common] = anon_sym_common,
  [anon_sym_extern_weak] = anon_sym_extern_weak,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_dso_local] = anon_sym_dso_local,
  [anon_sym_dso_local_equivalent] = anon_sym_dso_local_equivalent,
  [anon_sym_dso_preemptable] = anon_sym_dso_preemptable,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_hidden] = anon_sym_hidden,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_dllimport] = anon_sym_dllimport,
  [anon_sym_dllexport] = anon_sym_dllexport,
  [anon_sym_ccc] = anon_sym_ccc,
  [anon_sym_fastcc] = anon_sym_fastcc,
  [anon_sym_coldcc] = anon_sym_coldcc,
  [anon_sym_webkit_jscc] = anon_sym_webkit_jscc,
  [anon_sym_anyregcc] = anon_sym_anyregcc,
  [anon_sym_preserve_mostcc] = anon_sym_preserve_mostcc,
  [anon_sym_preserve_allcc] = anon_sym_preserve_allcc,
  [anon_sym_cxx_fast_tlscc] = anon_sym_cxx_fast_tlscc,
  [anon_sym_tailcc] = anon_sym_tailcc,
  [anon_sym_swiftcc] = anon_sym_swiftcc,
  [anon_sym_swifttailcc] = anon_sym_swifttailcc,
  [anon_sym_cfguard_checkcc] = anon_sym_cfguard_checkcc,
  [aux_sym_calling_conv_token1] = aux_sym_calling_conv_token1,
  [aux_sym_calling_conv_token2] = aux_sym_calling_conv_token2,
  [aux_sym_calling_conv_token3] = aux_sym_calling_conv_token3,
  [aux_sym_calling_conv_token4] = aux_sym_calling_conv_token4,
  [aux_sym_calling_conv_token5] = aux_sym_calling_conv_token5,
  [aux_sym_calling_conv_token6] = aux_sym_calling_conv_token6,
  [aux_sym_calling_conv_token7] = aux_sym_calling_conv_token7,
  [aux_sym_calling_conv_token8] = aux_sym_calling_conv_token8,
  [aux_sym_calling_conv_token9] = aux_sym_calling_conv_token9,
  [aux_sym_calling_conv_token10] = aux_sym_calling_conv_token10,
  [anon_sym_ghccc] = anon_sym_ghccc,
  [aux_sym_calling_conv_token11] = aux_sym_calling_conv_token11,
  [aux_sym_calling_conv_token12] = aux_sym_calling_conv_token12,
  [aux_sym_calling_conv_token13] = aux_sym_calling_conv_token13,
  [aux_sym_calling_conv_token14] = aux_sym_calling_conv_token14,
  [anon_sym_cc] = anon_sym_cc,
  [anon_sym_unnamed_addr] = anon_sym_unnamed_addr,
  [anon_sym_local_unnamed_addr] = anon_sym_local_unnamed_addr,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_half] = anon_sym_half,
  [anon_sym_bfloat] = anon_sym_bfloat,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_double] = anon_sym_double,
  [anon_sym_x86_fp80] = anon_sym_x86_fp80,
  [anon_sym_fp128] = anon_sym_fp128,
  [anon_sym_ppc_fp128] = anon_sym_ppc_fp128,
  [anon_sym_label] = anon_sym_label,
  [anon_sym_metadata] = anon_sym_metadata,
  [anon_sym_x86_mmx] = anon_sym_x86_mmx,
  [anon_sym_x86_amx] = anon_sym_x86_amx,
  [anon_sym_token] = anon_sym_token,
  [anon_sym_opaque] = anon_sym_opaque,
  [anon_sym_ptr] = anon_sym_ptr,
  [aux_sym_type_keyword_token1] = aux_sym_type_keyword_token1,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LT_LBRACE] = anon_sym_LT_LBRACE,
  [anon_sym_RBRACE_GT] = anon_sym_RBRACE_GT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_vscale] = anon_sym_vscale,
  [anon_sym_x] = anon_sym_x,
  [anon_sym_addrspace] = anon_sym_addrspace,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_align] = anon_sym_align,
  [anon_sym_section] = anon_sym_section,
  [anon_sym_partition] = anon_sym_partition,
  [anon_sym_comdat] = anon_sym_comdat,
  [anon_sym_gc] = anon_sym_gc,
  [anon_sym_prefix] = anon_sym_prefix,
  [anon_sym_prologue] = anon_sym_prologue,
  [anon_sym_personality] = anon_sym_personality,
  [anon_sym_alignstack] = anon_sym_alignstack,
  [anon_sym_allocsize] = anon_sym_allocsize,
  [anon_sym_alwaysinline] = anon_sym_alwaysinline,
  [anon_sym_builtin] = anon_sym_builtin,
  [anon_sym_cold] = anon_sym_cold,
  [anon_sym_convergent] = anon_sym_convergent,
  [anon_sym_disable_sanitizer_instrumentation] = anon_sym_disable_sanitizer_instrumentation,
  [anon_sym_hot] = anon_sym_hot,
  [anon_sym_inaccessiblememonly] = anon_sym_inaccessiblememonly,
  [anon_sym_inaccessiblemem_or_argmemonly] = anon_sym_inaccessiblemem_or_argmemonly,
  [anon_sym_inlinehint] = anon_sym_inlinehint,
  [anon_sym_jumptable] = anon_sym_jumptable,
  [anon_sym_minsize] = anon_sym_minsize,
  [anon_sym_naked] = anon_sym_naked,
  [anon_sym_no_DASHjump_DASHtables] = anon_sym_no_DASHjump_DASHtables,
  [anon_sym_nobuiltin] = anon_sym_nobuiltin,
  [anon_sym_noduplicate] = anon_sym_noduplicate,
  [anon_sym_nofree] = anon_sym_nofree,
  [anon_sym_noimplicitfloat] = anon_sym_noimplicitfloat,
  [anon_sym_noinline] = anon_sym_noinline,
  [anon_sym_nomerge] = anon_sym_nomerge,
  [anon_sym_nonlazybind] = anon_sym_nonlazybind,
  [anon_sym_noprofile] = anon_sym_noprofile,
  [anon_sym_noredzone] = anon_sym_noredzone,
  [anon_sym_indirect_DASHtls_DASHseg_DASHrefs] = anon_sym_indirect_DASHtls_DASHseg_DASHrefs,
  [anon_sym_noreturn] = anon_sym_noreturn,
  [anon_sym_norecurse] = anon_sym_norecurse,
  [anon_sym_willreturn] = anon_sym_willreturn,
  [anon_sym_nosync] = anon_sym_nosync,
  [anon_sym_nounwind] = anon_sym_nounwind,
  [anon_sym_nosanitize_coverage] = anon_sym_nosanitize_coverage,
  [anon_sym_null_pointer_is_valid] = anon_sym_null_pointer_is_valid,
  [anon_sym_optforfuzzing] = anon_sym_optforfuzzing,
  [anon_sym_optnone] = anon_sym_optnone,
  [anon_sym_optsize] = anon_sym_optsize,
  [anon_sym_readnone] = anon_sym_readnone,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_writeonly] = anon_sym_writeonly,
  [anon_sym_argmemonly] = anon_sym_argmemonly,
  [anon_sym_returns_twice] = anon_sym_returns_twice,
  [anon_sym_safestack] = anon_sym_safestack,
  [anon_sym_sanitize_address] = anon_sym_sanitize_address,
  [anon_sym_sanitize_memory] = anon_sym_sanitize_memory,
  [anon_sym_sanitize_thread] = anon_sym_sanitize_thread,
  [anon_sym_sanitize_hwaddress] = anon_sym_sanitize_hwaddress,
  [anon_sym_sanitize_memtag] = anon_sym_sanitize_memtag,
  [anon_sym_speculative_load_hardening] = anon_sym_speculative_load_hardening,
  [anon_sym_speculatable] = anon_sym_speculatable,
  [anon_sym_ssp] = anon_sym_ssp,
  [anon_sym_sspstrong] = anon_sym_sspstrong,
  [anon_sym_sspreq] = anon_sym_sspreq,
  [anon_sym_strictfp] = anon_sym_strictfp,
  [anon_sym_uwtable] = anon_sym_uwtable,
  [anon_sym_nocf_check] = anon_sym_nocf_check,
  [anon_sym_shadowcallstack] = anon_sym_shadowcallstack,
  [anon_sym_mustprogress] = anon_sym_mustprogress,
  [anon_sym_vscale_range] = anon_sym_vscale_range,
  [anon_sym_preallocated] = anon_sym_preallocated,
  [anon_sym_zeroext] = anon_sym_zeroext,
  [anon_sym_signext] = anon_sym_signext,
  [anon_sym_inreg] = anon_sym_inreg,
  [anon_sym_byval] = anon_sym_byval,
  [anon_sym_byref] = anon_sym_byref,
  [anon_sym_inalloca] = anon_sym_inalloca,
  [anon_sym_sret] = anon_sym_sret,
  [anon_sym_elementtype] = anon_sym_elementtype,
  [anon_sym_noalias] = anon_sym_noalias,
  [anon_sym_nocapture] = anon_sym_nocapture,
  [anon_sym_nest] = anon_sym_nest,
  [anon_sym_returned] = anon_sym_returned,
  [anon_sym_nonnull] = anon_sym_nonnull,
  [anon_sym_dereferenceable] = anon_sym_dereferenceable,
  [anon_sym_dereferenceable_or_null] = anon_sym_dereferenceable_or_null,
  [anon_sym_swiftself] = anon_sym_swiftself,
  [anon_sym_swiftasync] = anon_sym_swiftasync,
  [anon_sym_swifterror] = anon_sym_swifterror,
  [anon_sym_immarg] = anon_sym_immarg,
  [anon_sym_noundef] = anon_sym_noundef,
  [anon_sym_unreachable] = anon_sym_unreachable,
  [anon_sym_ret] = anon_sym_ret,
  [anon_sym_br] = anon_sym_br,
  [anon_sym_resume] = anon_sym_resume,
  [anon_sym_freeze] = anon_sym_freeze,
  [anon_sym_indirectbr] = anon_sym_indirectbr,
  [anon_sym_extractelement] = anon_sym_extractelement,
  [anon_sym_insertelement] = anon_sym_insertelement,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_shufflevector] = anon_sym_shufflevector,
  [anon_sym_fneg] = anon_sym_fneg,
  [anon_sym_nsw] = anon_sym_nsw,
  [anon_sym_nuw] = anon_sym_nuw,
  [anon_sym_exact] = anon_sym_exact,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_invoke] = anon_sym_invoke,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_unwind] = anon_sym_unwind,
  [anon_sym_cleanupret] = anon_sym_cleanupret,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_catchret] = anon_sym_catchret,
  [anon_sym_catchswitch] = anon_sym_catchswitch,
  [anon_sym_catchpad] = anon_sym_catchpad,
  [anon_sym_cleanuppad] = anon_sym_cleanuppad,
  [anon_sym_callbr] = anon_sym_callbr,
  [anon_sym_icmp] = anon_sym_icmp,
  [anon_sym_fcmp] = anon_sym_fcmp,
  [anon_sym_va_arg] = anon_sym_va_arg,
  [anon_sym_phi] = anon_sym_phi,
  [anon_sym_landingpad] = anon_sym_landingpad,
  [anon_sym_cleanup] = anon_sym_cleanup,
  [anon_sym_tail] = anon_sym_tail,
  [anon_sym_musttail] = anon_sym_musttail,
  [anon_sym_notail] = anon_sym_notail,
  [anon_sym_call] = anon_sym_call,
  [anon_sym_alloca] = anon_sym_alloca,
  [anon_sym_load] = anon_sym_load,
  [anon_sym_atomic] = anon_sym_atomic,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_store] = anon_sym_store,
  [anon_sym_cmpxchg] = anon_sym_cmpxchg,
  [anon_sym_atomicrmw] = anon_sym_atomicrmw,
  [anon_sym_fence] = anon_sym_fence,
  [anon_sym_getelementptr] = anon_sym_getelementptr,
  [anon_sym_inbounds] = anon_sym_inbounds,
  [anon_sym_inrange] = anon_sym_inrange,
  [anon_sym_extractvalue] = anon_sym_extractvalue,
  [anon_sym_insertvalue] = anon_sym_insertvalue,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_null] = anon_sym_null,
  [anon_sym_none] = anon_sym_none,
  [anon_sym_undef] = anon_sym_undef,
  [anon_sym_poison] = anon_sym_poison,
  [anon_sym_zeroinitializer] = anon_sym_zeroinitializer,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_filter] = anon_sym_filter,
  [anon_sym_blockaddress] = anon_sym_blockaddress,
  [anon_sym_mul] = anon_sym_mul,
  [anon_sym_urem] = anon_sym_urem,
  [anon_sym_srem] = anon_sym_srem,
  [anon_sym_shl] = anon_sym_shl,
  [anon_sym_udiv] = anon_sym_udiv,
  [anon_sym_sdiv] = anon_sym_sdiv,
  [anon_sym_lshr] = anon_sym_lshr,
  [anon_sym_ashr] = anon_sym_ashr,
  [anon_sym_fmul] = anon_sym_fmul,
  [anon_sym_fdiv] = anon_sym_fdiv,
  [anon_sym_frem] = anon_sym_frem,
  [anon_sym_xchg] = anon_sym_xchg,
  [anon_sym_add] = anon_sym_add,
  [anon_sym_sub] = anon_sym_sub,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_nand] = anon_sym_nand,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_max] = anon_sym_max,
  [anon_sym_min] = anon_sym_min,
  [anon_sym_umax] = anon_sym_umax,
  [anon_sym_umin] = anon_sym_umin,
  [anon_sym_fadd] = anon_sym_fadd,
  [anon_sym_fsub] = anon_sym_fsub,
  [anon_sym_eq] = anon_sym_eq,
  [anon_sym_ne] = anon_sym_ne,
  [anon_sym_ugt] = anon_sym_ugt,
  [anon_sym_uge] = anon_sym_uge,
  [anon_sym_ult] = anon_sym_ult,
  [anon_sym_ule] = anon_sym_ule,
  [anon_sym_sgt] = anon_sym_sgt,
  [anon_sym_sge] = anon_sym_sge,
  [anon_sym_slt] = anon_sym_slt,
  [anon_sym_sle] = anon_sym_sle,
  [anon_sym_oeq] = anon_sym_oeq,
  [anon_sym_ogt] = anon_sym_ogt,
  [anon_sym_oge] = anon_sym_oge,
  [anon_sym_olt] = anon_sym_olt,
  [anon_sym_ole] = anon_sym_ole,
  [anon_sym_one] = anon_sym_one,
  [anon_sym_ord] = anon_sym_ord,
  [anon_sym_ueq] = anon_sym_ueq,
  [anon_sym_une] = anon_sym_une,
  [anon_sym_uno] = anon_sym_uno,
  [anon_sym_bitcast] = anon_sym_bitcast,
  [anon_sym_trunc] = anon_sym_trunc,
  [anon_sym_zext] = anon_sym_zext,
  [anon_sym_sext] = anon_sym_sext,
  [anon_sym_fptrunc] = anon_sym_fptrunc,
  [anon_sym_fpext] = anon_sym_fpext,
  [anon_sym_addrspacecast] = anon_sym_addrspacecast,
  [anon_sym_uitofp] = anon_sym_uitofp,
  [anon_sym_sitofp] = anon_sym_sitofp,
  [anon_sym_fptoui] = anon_sym_fptoui,
  [anon_sym_fptosi] = anon_sym_fptosi,
  [anon_sym_inttoptr] = anon_sym_inttoptr,
  [anon_sym_ptrtoint] = anon_sym_ptrtoint,
  [anon_sym_unordered] = anon_sym_unordered,
  [anon_sym_monotonic] = anon_sym_monotonic,
  [anon_sym_acquire] = anon_sym_acquire,
  [anon_sym_release] = anon_sym_release,
  [anon_sym_acq_rel] = anon_sym_acq_rel,
  [anon_sym_seq_cst] = anon_sym_seq_cst,
  [anon_sym_syncscope] = anon_sym_syncscope,
  [anon_sym_nnan] = anon_sym_nnan,
  [anon_sym_ninf] = anon_sym_ninf,
  [anon_sym_nsz] = anon_sym_nsz,
  [anon_sym_arcp] = anon_sym_arcp,
  [anon_sym_contract] = anon_sym_contract,
  [anon_sym_afn] = anon_sym_afn,
  [anon_sym_reassoc] = anon_sym_reassoc,
  [anon_sym_fast] = anon_sym_fast,
  [anon_sym_within] = anon_sym_within,
  [anon_sym_caller] = anon_sym_caller,
  [anon_sym_uselistorder] = anon_sym_uselistorder,
  [anon_sym_uselistorder_bb] = anon_sym_uselistorder_bb,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_asm] = anon_sym_asm,
  [anon_sym_sideeffect] = anon_sym_sideeffect,
  [anon_sym_inteldialect] = anon_sym_inteldialect,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_externally_initialized] = anon_sym_externally_initialized,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_constant] = anon_sym_constant,
  [anon_sym_alias] = anon_sym_alias,
  [anon_sym_ifunc] = anon_sym_ifunc,
  [anon_sym_thread_local] = anon_sym_thread_local,
  [anon_sym_localdynamic] = anon_sym_localdynamic,
  [anon_sym_initialexec] = anon_sym_initialexec,
  [anon_sym_localexec] = anon_sym_localexec,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_exactmatch] = anon_sym_exactmatch,
  [anon_sym_largest] = anon_sym_largest,
  [anon_sym_nodeduplicate] = anon_sym_nodeduplicate,
  [anon_sym_samesize] = anon_sym_samesize,
  [anon_sym_distinct] = anon_sym_distinct,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_LBRACE2] = anon_sym_LBRACE,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [aux_sym_specialized_md_value_token1] = aux_sym_specialized_md_value_token1,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_attributes] = anon_sym_attributes,
  [sym_module] = sym_module,
  [sym_metadata_ref] = sym_metadata_ref,
  [sym_metadata_name] = sym_metadata_name,
  [sym_number] = sym_number,
  [sym_var] = sym_var,
  [sym_target_definition] = sym_target_definition,
  [sym_target_triple] = sym_target_triple,
  [sym_data_layout] = sym_data_layout,
  [sym_source_file_name] = sym_source_file_name,
  [sym_declare] = sym_declare,
  [sym_define] = sym_define,
  [sym_metadata_attachment] = sym_metadata_attachment,
  [sym_function_header] = sym_function_header,
  [sym_linkage] = sym_linkage,
  [sym_linkage_aux] = sym_linkage_aux,
  [sym_dso_local] = sym_dso_local,
  [sym_visibility] = sym_visibility,
  [sym_dll_storage_class] = sym_dll_storage_class,
  [sym_calling_conv] = sym_calling_conv,
  [sym_unnamed_addr] = sym_unnamed_addr,
  [sym_type] = sym_type,
  [sym_type_keyword] = sym_type_keyword,
  [sym_struct_type] = sym_struct_type,
  [sym_packed_struct_type] = sym_packed_struct_type,
  [sym_array_type] = sym_array_type,
  [sym_vector_type] = sym_vector_type,
  [sym_struct_body] = sym_struct_body,
  [sym_array_vector_body] = sym_array_vector_body,
  [sym_addrspace] = sym_addrspace,
  [sym_argument_list] = sym_argument_list,
  [sym_argument] = sym_argument,
  [sym_param_or_return_attrs] = sym_param_or_return_attrs,
  [sym_attribute] = sym_attribute,
  [sym_attribute_name] = sym_attribute_name,
  [sym_function_body] = sym_function_body,
  [sym_instruction] = sym_instruction,
  [sym__instruction_body] = sym__instruction_body,
  [sym_instruction_unreachable] = sym_instruction_unreachable,
  [sym_instruction_ret] = sym_instruction_ret,
  [sym_instruction_br] = sym_instruction_br,
  [sym_instruction_resume] = sym_instruction_resume,
  [sym_instruction_freeze] = sym_instruction_freeze,
  [sym_instruction_indirectbr] = sym_instruction_indirectbr,
  [sym_instruction_extractelement] = sym_instruction_extractelement,
  [sym_instruction_insertelement] = sym_instruction_insertelement,
  [sym_instruction_select] = sym_instruction_select,
  [sym_instruction_shufflevector] = sym_instruction_shufflevector,
  [sym_instruction_fneg] = sym_instruction_fneg,
  [sym_instruction_bin_op] = sym_instruction_bin_op,
  [sym_instruction_switch] = sym_instruction_switch,
  [sym_instruction_invoke] = sym_instruction_invoke,
  [sym_instruction_cleanupret] = sym_instruction_cleanupret,
  [sym_instruction_catchret] = sym_instruction_catchret,
  [sym_instruction_catchswitch] = sym_instruction_catchswitch,
  [sym_instruction_catchpad] = sym_instruction_catchpad,
  [sym_instruction_cleanuppad] = sym_instruction_cleanuppad,
  [sym_instruction_callbr] = sym_instruction_callbr,
  [sym_instruction_icmp] = sym_instruction_icmp,
  [sym_instruction_fcmp] = sym_instruction_fcmp,
  [sym_instruction_cast] = sym_instruction_cast,
  [sym_instruction_va_arg] = sym_instruction_va_arg,
  [sym_instruction_phi] = sym_instruction_phi,
  [sym_instruction_landingpad] = sym_instruction_landingpad,
  [sym_instruction_call] = sym_instruction_call,
  [sym_instruction_alloca] = sym_instruction_alloca,
  [sym_instruction_load] = sym_instruction_load,
  [sym_instruction_store] = sym_instruction_store,
  [sym_instruction_cmpxchg] = sym_instruction_cmpxchg,
  [sym_instruction_atomicrmw] = sym_instruction_atomicrmw,
  [sym_instruction_fence] = sym_instruction_fence,
  [sym_instruction_getelementptr] = sym_instruction_getelementptr,
  [sym_instruction_extractvalue] = sym_instruction_extractvalue,
  [sym_instruction_insertvalue] = sym_instruction_insertvalue,
  [sym__call_part] = sym__call_part,
  [sym_type_and_value] = sym_type_and_value,
  [sym_value] = sym_value,
  [sym__primitive_value] = sym__primitive_value,
  [sym_struct_value] = sym_struct_value,
  [sym_packed_struct_value] = sym_packed_struct_value,
  [sym_array_value] = sym_array_value,
  [sym_vector_value] = sym_vector_value,
  [sym_metadata_refs] = sym_metadata_refs,
  [sym_operand_bundles] = sym_operand_bundles,
  [sym_landingpad_clause] = sym_landingpad_clause,
  [sym_blockaddress] = sym_blockaddress,
  [sym_constant_expr] = sym_constant_expr,
  [sym_constant_cast] = sym_constant_cast,
  [sym_constant_getelementptr] = sym_constant_getelementptr,
  [sym_constant_select] = sym_constant_select,
  [sym_constant_icmp] = sym_constant_icmp,
  [sym_constant_fcmp] = sym_constant_fcmp,
  [sym_constant_extractelement] = sym_constant_extractelement,
  [sym_constant_insertelement] = sym_constant_insertelement,
  [sym_constant_shufflevector] = sym_constant_shufflevector,
  [sym_constant_extractvalue] = sym_constant_extractvalue,
  [sym_constant_insertvalue] = sym_constant_insertvalue,
  [sym_constant_fneg] = sym_constant_fneg,
  [sym_constant_bin_op] = sym_constant_bin_op,
  [sym_bin_op_keyword] = sym_bin_op_keyword,
  [sym_atomic_bin_op_keyword] = sym_atomic_bin_op_keyword,
  [sym_icmp_cond] = sym_icmp_cond,
  [sym_fcmp_cond] = sym_fcmp_cond,
  [sym_cast_inst] = sym_cast_inst,
  [sym_atomic_ordering] = sym_atomic_ordering,
  [sym_alignment] = sym_alignment,
  [sym__load_store_suffix] = sym__load_store_suffix,
  [sym_syncscope] = sym_syncscope,
  [sym_fast_math] = sym_fast_math,
  [sym__value_array] = sym__value_array,
  [sym__within] = sym__within,
  [sym__unwind_label] = sym__unwind_label,
  [sym_use_list_order] = sym_use_list_order,
  [sym_use_list_order_bb] = sym_use_list_order_bb,
  [sym_module_asm] = sym_module_asm,
  [sym_inline_asm] = sym_inline_asm,
  [sym_asm] = sym_asm,
  [sym_global_type] = sym_global_type,
  [sym__global_prefix] = sym__global_prefix,
  [sym_global_global] = sym_global_global,
  [sym_alias] = sym_alias,
  [sym_ifunc] = sym_ifunc,
  [sym_thread_local] = sym_thread_local,
  [sym_comdat] = sym_comdat,
  [sym_global_metadata] = sym_global_metadata,
  [sym_metadata] = sym_metadata,
  [sym_metadata_tuple] = sym_metadata_tuple,
  [sym_specialized_md] = sym_specialized_md,
  [sym_specialized_md_value] = sym_specialized_md_value,
  [sym_summary_entry] = sym_summary_entry,
  [sym_summary_value] = sym_summary_value,
  [sym_unnamed_attr_grp] = sym_unnamed_attr_grp,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_declare_repeat1] = aux_sym_declare_repeat1,
  [aux_sym_function_header_repeat1] = aux_sym_function_header_repeat1,
  [aux_sym_function_header_repeat2] = aux_sym_function_header_repeat2,
  [aux_sym_function_header_repeat3] = aux_sym_function_header_repeat3,
  [aux_sym_type_repeat1] = aux_sym_type_repeat1,
  [aux_sym_type_repeat2] = aux_sym_type_repeat2,
  [aux_sym_struct_body_repeat1] = aux_sym_struct_body_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [aux_sym_function_body_repeat1] = aux_sym_function_body_repeat1,
  [aux_sym_function_body_repeat2] = aux_sym_function_body_repeat2,
  [aux_sym_instruction_repeat1] = aux_sym_instruction_repeat1,
  [aux_sym_instruction_select_repeat1] = aux_sym_instruction_select_repeat1,
  [aux_sym_instruction_bin_op_repeat1] = aux_sym_instruction_bin_op_repeat1,
  [aux_sym_instruction_switch_repeat1] = aux_sym_instruction_switch_repeat1,
  [aux_sym_instruction_callbr_repeat1] = aux_sym_instruction_callbr_repeat1,
  [aux_sym_instruction_phi_repeat1] = aux_sym_instruction_phi_repeat1,
  [aux_sym_instruction_landingpad_repeat1] = aux_sym_instruction_landingpad_repeat1,
  [aux_sym_instruction_alloca_repeat1] = aux_sym_instruction_alloca_repeat1,
  [aux_sym_instruction_getelementptr_repeat1] = aux_sym_instruction_getelementptr_repeat1,
  [aux_sym_instruction_extractvalue_repeat1] = aux_sym_instruction_extractvalue_repeat1,
  [aux_sym_operand_bundles_repeat1] = aux_sym_operand_bundles_repeat1,
  [aux_sym_global_global_repeat1] = aux_sym_global_global_repeat1,
  [aux_sym_metadata_tuple_repeat1] = aux_sym_metadata_tuple_repeat1,
  [aux_sym_specialized_md_repeat1] = aux_sym_specialized_md_repeat1,
  [aux_sym_summary_entry_repeat1] = aux_sym_summary_entry_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_attr_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_comdat_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_global_var] = {
    .visible = true,
    .named = true,
  },
  [sym_local_var] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_metadata_ref_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_summary_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_cstring] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_triple] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_datalayout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_source_filename] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_define] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_no_cfi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_internal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_weak] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_weak_odr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_linkonce] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_linkonce_odr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_available_externally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_appending] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_common] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern_weak] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dso_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dso_local_equivalent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dso_preemptable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hidden] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dllimport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dllexport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ccc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fastcc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_coldcc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_webkit_jscc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_anyregcc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_preserve_mostcc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_preserve_allcc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cxx_fast_tlscc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tailcc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_swiftcc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_swifttailcc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cfguard_checkcc] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_calling_conv_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_calling_conv_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_calling_conv_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_calling_conv_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_calling_conv_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_calling_conv_token6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_calling_conv_token7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_calling_conv_token8] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_calling_conv_token9] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_calling_conv_token10] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_ghccc] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_calling_conv_token11] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_calling_conv_token12] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_calling_conv_token13] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_calling_conv_token14] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_cc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unnamed_addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local_unnamed_addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_half] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_x86_fp80] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fp128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ppc_fp128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_label] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_metadata] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_x86_mmx] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_x86_amx] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_token] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_opaque] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ptr] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_keyword_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vscale] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_x] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_addrspace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_align] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_section] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_partition] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_comdat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_prefix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_prologue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_personality] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alignstack] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_allocsize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alwaysinline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_builtin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cold] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_convergent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_disable_sanitizer_instrumentation] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inaccessiblememonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inaccessiblemem_or_argmemonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inlinehint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_jumptable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_minsize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_naked] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_no_DASHjump_DASHtables] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nobuiltin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noduplicate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nofree] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noimplicitfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noinline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nomerge] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonlazybind] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noprofile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noredzone] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_indirect_DASHtls_DASHseg_DASHrefs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_norecurse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_willreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nosync] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nounwind] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nosanitize_coverage] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_null_pointer_is_valid] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_optforfuzzing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_optnone] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_optsize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readnone] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_writeonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_argmemonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_returns_twice] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_safestack] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sanitize_address] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sanitize_memory] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sanitize_thread] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sanitize_hwaddress] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sanitize_memtag] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_speculative_load_hardening] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_speculatable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ssp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sspstrong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sspreq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uwtable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nocf_check] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shadowcallstack] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mustprogress] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vscale_range] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_preallocated] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_zeroext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inreg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byval] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inalloca] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sret] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elementtype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noalias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nocapture] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nest] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_returned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonnull] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dereferenceable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dereferenceable_or_null] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_swiftself] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_swiftasync] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_swifterror] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_immarg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noundef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unreachable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ret] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_br] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_resume] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_freeze] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_indirectbr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extractelement] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_insertelement] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shufflevector] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fneg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nsw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nuw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exact] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unwind] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cleanupret] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catchret] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catchswitch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catchpad] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cleanuppad] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_callbr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_icmp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fcmp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_va_arg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_phi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_landingpad] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cleanup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tail] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_musttail] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_notail] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_call] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alloca] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_load] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_atomic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_store] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cmpxchg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_atomicrmw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fence] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getelementptr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inbounds] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extractvalue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_insertvalue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_none] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_undef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_poison] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_zeroinitializer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_filter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_blockaddress] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_urem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_srem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_udiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sdiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lshr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ashr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fmul] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fdiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_frem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xchg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_max] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_min] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_umax] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_umin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fadd] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fsub] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ne] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ugt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uge] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ult] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ule] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sgt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sge] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_slt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_oeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ogt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_oge] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_olt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ole] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_one] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ord] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ueq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_une] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uno] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bitcast] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_trunc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_zext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fptrunc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fpext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_addrspacecast] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uitofp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sitofp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fptoui] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fptosi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inttoptr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ptrtoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unordered] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_monotonic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_acquire] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_release] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_acq_rel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_seq_cst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_syncscope] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nnan] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ninf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nsz] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_arcp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_contract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_afn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_reassoc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fast] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_within] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_caller] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uselistorder] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uselistorder_bb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sideeffect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inteldialect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_externally_initialized] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constant] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ifunc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thread_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_localdynamic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_initialexec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_localexec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exactmatch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_largest] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nodeduplicate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_samesize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_distinct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_specialized_md_value_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_attributes] = {
    .visible = true,
    .named = false,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_metadata_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_metadata_name] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_var] = {
    .visible = true,
    .named = true,
  },
  [sym_target_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_target_triple] = {
    .visible = true,
    .named = true,
  },
  [sym_data_layout] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file_name] = {
    .visible = true,
    .named = true,
  },
  [sym_declare] = {
    .visible = true,
    .named = true,
  },
  [sym_define] = {
    .visible = true,
    .named = true,
  },
  [sym_metadata_attachment] = {
    .visible = true,
    .named = true,
  },
  [sym_function_header] = {
    .visible = true,
    .named = true,
  },
  [sym_linkage] = {
    .visible = true,
    .named = true,
  },
  [sym_linkage_aux] = {
    .visible = true,
    .named = true,
  },
  [sym_dso_local] = {
    .visible = true,
    .named = true,
  },
  [sym_visibility] = {
    .visible = true,
    .named = true,
  },
  [sym_dll_storage_class] = {
    .visible = true,
    .named = true,
  },
  [sym_calling_conv] = {
    .visible = true,
    .named = true,
  },
  [sym_unnamed_addr] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_type] = {
    .visible = true,
    .named = true,
  },
  [sym_packed_struct_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_vector_type] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_body] = {
    .visible = true,
    .named = true,
  },
  [sym_array_vector_body] = {
    .visible = true,
    .named = true,
  },
  [sym_addrspace] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_param_or_return_attrs] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction] = {
    .visible = true,
    .named = true,
  },
  [sym__instruction_body] = {
    .visible = false,
    .named = true,
  },
  [sym_instruction_unreachable] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_ret] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_br] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_resume] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_freeze] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_indirectbr] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_extractelement] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_insertelement] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_select] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_shufflevector] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_fneg] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_bin_op] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_switch] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_invoke] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_cleanupret] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_catchret] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_catchswitch] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_catchpad] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_cleanuppad] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_callbr] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_icmp] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_fcmp] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_va_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_phi] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_landingpad] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_call] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_alloca] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_load] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_store] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_cmpxchg] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_atomicrmw] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_fence] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_getelementptr] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_extractvalue] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction_insertvalue] = {
    .visible = true,
    .named = true,
  },
  [sym__call_part] = {
    .visible = false,
    .named = true,
  },
  [sym_type_and_value] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym__primitive_value] = {
    .visible = false,
    .named = true,
  },
  [sym_struct_value] = {
    .visible = true,
    .named = true,
  },
  [sym_packed_struct_value] = {
    .visible = true,
    .named = true,
  },
  [sym_array_value] = {
    .visible = true,
    .named = true,
  },
  [sym_vector_value] = {
    .visible = true,
    .named = true,
  },
  [sym_metadata_refs] = {
    .visible = true,
    .named = true,
  },
  [sym_operand_bundles] = {
    .visible = true,
    .named = true,
  },
  [sym_landingpad_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_blockaddress] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_getelementptr] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_select] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_icmp] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_fcmp] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_extractelement] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_insertelement] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_shufflevector] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_extractvalue] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_insertvalue] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_fneg] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bin_op] = {
    .visible = true,
    .named = true,
  },
  [sym_bin_op_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_atomic_bin_op_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_icmp_cond] = {
    .visible = true,
    .named = true,
  },
  [sym_fcmp_cond] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_inst] = {
    .visible = true,
    .named = true,
  },
  [sym_atomic_ordering] = {
    .visible = true,
    .named = true,
  },
  [sym_alignment] = {
    .visible = true,
    .named = true,
  },
  [sym__load_store_suffix] = {
    .visible = false,
    .named = true,
  },
  [sym_syncscope] = {
    .visible = true,
    .named = true,
  },
  [sym_fast_math] = {
    .visible = true,
    .named = true,
  },
  [sym__value_array] = {
    .visible = false,
    .named = true,
  },
  [sym__within] = {
    .visible = false,
    .named = true,
  },
  [sym__unwind_label] = {
    .visible = false,
    .named = true,
  },
  [sym_use_list_order] = {
    .visible = true,
    .named = true,
  },
  [sym_use_list_order_bb] = {
    .visible = true,
    .named = true,
  },
  [sym_module_asm] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_asm] = {
    .visible = true,
    .named = true,
  },
  [sym_asm] = {
    .visible = true,
    .named = true,
  },
  [sym_global_type] = {
    .visible = true,
    .named = true,
  },
  [sym__global_prefix] = {
    .visible = false,
    .named = true,
  },
  [sym_global_global] = {
    .visible = true,
    .named = true,
  },
  [sym_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_ifunc] = {
    .visible = true,
    .named = true,
  },
  [sym_thread_local] = {
    .visible = true,
    .named = true,
  },
  [sym_comdat] = {
    .visible = true,
    .named = true,
  },
  [sym_global_metadata] = {
    .visible = true,
    .named = true,
  },
  [sym_metadata] = {
    .visible = true,
    .named = true,
  },
  [sym_metadata_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_specialized_md] = {
    .visible = true,
    .named = true,
  },
  [sym_specialized_md_value] = {
    .visible = true,
    .named = true,
  },
  [sym_summary_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_summary_value] = {
    .visible = true,
    .named = true,
  },
  [sym_unnamed_attr_grp] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declare_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_header_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_header_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_header_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_body_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instruction_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instruction_select_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instruction_bin_op_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instruction_switch_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instruction_callbr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instruction_phi_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instruction_landingpad_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instruction_alloca_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instruction_getelementptr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instruction_extractvalue_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operand_bundles_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_global_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_metadata_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_specialized_md_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_summary_entry_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_arguments = 1,
  field_body = 2,
  field_callee = 3,
  field_inst_name = 4,
  field_name = 5,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_callee] = "callee",
  [field_inst_name] = "inst_name",
  [field_name] = "name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 6, .length = 2},
  [7] = {.index = 8, .length = 3},
  [8] = {.index = 11, .length = 2},
  [9] = {.index = 13, .length = 3},
  [10] = {.index = 16, .length = 3},
  [11] = {.index = 19, .length = 2},
  [12] = {.index = 21, .length = 2},
  [13] = {.index = 23, .length = 3},
  [14] = {.index = 26, .length = 2},
  [15] = {.index = 28, .length = 2},
  [16] = {.index = 30, .length = 2},
  [17] = {.index = 32, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 2},
  [1] =
    {field_arguments, 2},
    {field_name, 1},
  [3] =
    {field_inst_name, 0},
  [4] =
    {field_body, 3},
  [5] =
    {field_name, 2},
  [6] =
    {field_arguments, 3},
    {field_name, 2},
  [8] =
    {field_arguments, 1, .inherited = true},
    {field_callee, 1, .inherited = true},
    {field_inst_name, 0},
  [11] =
    {field_arguments, 4},
    {field_name, 3},
  [13] =
    {field_arguments, 2, .inherited = true},
    {field_callee, 2, .inherited = true},
    {field_inst_name, 1},
  [16] =
    {field_arguments, 2, .inherited = true},
    {field_callee, 2, .inherited = true},
    {field_inst_name, 0},
  [19] =
    {field_arguments, 5},
    {field_name, 4},
  [21] =
    {field_arguments, 2},
    {field_callee, 1},
  [23] =
    {field_arguments, 3, .inherited = true},
    {field_callee, 3, .inherited = true},
    {field_inst_name, 1},
  [26] =
    {field_arguments, 6},
    {field_name, 5},
  [28] =
    {field_arguments, 3},
    {field_callee, 2},
  [30] =
    {field_arguments, 4},
    {field_callee, 3},
  [32] =
    {field_arguments, 5},
    {field_callee, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(3036);
      if (lookahead == '!') ADVANCE(3805);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '#') ADVANCE(3010);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3807);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '0') ADVANCE(3059);
      if (lookahead == ':') ADVANCE(4542);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '=') ADVANCE(3083);
      if (lookahead == '>') ADVANCE(3268);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(1339);
      if (lookahead == 'b') ADVANCE(2015);
      if (lookahead == 'c') ADVANCE(29);
      if (lookahead == 'd') ADVANCE(1383);
      if (lookahead == 'e') ADVANCE(2257);
      if (lookahead == 'f') ADVANCE(1344);
      if (lookahead == 'g') ADVANCE(1576);
      if (lookahead == 'h') ADVANCE(1404);
      if (lookahead == 'i') ADVANCE(1656);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1345);
      if (lookahead == 'm') ADVANCE(1384);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1852);
      if (lookahead == 'p') ADVANCE(1379);
      if (lookahead == 'r') ADVANCE(1772);
      if (lookahead == 's') ADVANCE(73);
      if (lookahead == 't') ADVANCE(1351);
      if (lookahead == 'u') ADVANCE(84);
      if (lookahead == 'v') ADVANCE(1353);
      if (lookahead == 'w') ADVANCE(1773);
      if (lookahead == 'x') ADVANCE(3273);
      if (lookahead == 'z') ADVANCE(1856);
      if (lookahead == '{') ADVANCE(3806);
      if (lookahead == '|') ADVANCE(4541);
      if (lookahead == '}') ADVANCE(3261);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3009);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3025)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(3805);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3807);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == '+') ADVANCE(3009);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '-') ADVANCE(4536);
      if (lookahead == '0') ADVANCE(3062);
      if (lookahead == ':') ADVANCE(4542);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3266);
      if (lookahead == '>') ADVANCE(3268);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == 'a') ADVANCE(3964);
      if (lookahead == 'b') ADVANCE(4085);
      if (lookahead == 'c') ADVANCE(3808);
      if (lookahead == 'd') ADVANCE(4303);
      if (lookahead == 'f') ADVANCE(3881);
      if (lookahead == 'h') ADVANCE(3882);
      if (lookahead == 'i') ADVANCE(4537);
      if (lookahead == 'l') ADVANCE(3859);
      if (lookahead == 'm') ADVANCE(4044);
      if (lookahead == 'n') ADVANCE(4330);
      if (lookahead == 'o') ADVANCE(4343);
      if (lookahead == 'p') ADVANCE(4321);
      if (lookahead == 's') ADVANCE(3818);
      if (lookahead == 't') ADVANCE(4317);
      if (lookahead == 'u') ADVANCE(3816);
      if (lookahead == 'v') ADVANCE(4323);
      if (lookahead == 'x') ADVANCE(3825);
      if (lookahead == 'z') ADVANCE(4062);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '|') ADVANCE(4541);
      if (lookahead == '}') ADVANCE(3261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3063);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= '\\') ||
          lookahead == '_' ||
          ('e' <= lookahead && lookahead <= 'y')) ADVANCE(4540);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(3805);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == '+') ADVANCE(3009);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '-') ADVANCE(4536);
      if (lookahead == '0') ADVANCE(3062);
      if (lookahead == ':') ADVANCE(4542);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3266);
      if (lookahead == '>') ADVANCE(3268);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == 'a') ADVANCE(3964);
      if (lookahead == 'b') ADVANCE(4085);
      if (lookahead == 'c') ADVANCE(3808);
      if (lookahead == 'd') ADVANCE(4303);
      if (lookahead == 'f') ADVANCE(3881);
      if (lookahead == 'h') ADVANCE(3882);
      if (lookahead == 'i') ADVANCE(4537);
      if (lookahead == 'l') ADVANCE(3859);
      if (lookahead == 'm') ADVANCE(4044);
      if (lookahead == 'n') ADVANCE(4330);
      if (lookahead == 'o') ADVANCE(4343);
      if (lookahead == 'p') ADVANCE(4321);
      if (lookahead == 's') ADVANCE(3818);
      if (lookahead == 't') ADVANCE(4317);
      if (lookahead == 'u') ADVANCE(3816);
      if (lookahead == 'v') ADVANCE(4323);
      if (lookahead == 'x') ADVANCE(3825);
      if (lookahead == 'z') ADVANCE(4062);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '|') ADVANCE(4541);
      if (lookahead == '}') ADVANCE(3261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3063);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= '\\') ||
          lookahead == '_' ||
          ('e' <= lookahead && lookahead <= 'y')) ADVANCE(4540);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(3805);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '0') ADVANCE(3059);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(1343);
      if (lookahead == 'b') ADVANCE(2016);
      if (lookahead == 'c') ADVANCE(30);
      if (lookahead == 'd') ADVANCE(1846);
      if (lookahead == 'e') ADVANCE(2259);
      if (lookahead == 'f') ADVANCE(1394);
      if (lookahead == 'g') ADVANCE(1865);
      if (lookahead == 'h') ADVANCE(1404);
      if (lookahead == 'i') ADVANCE(1658);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1419);
      if (lookahead == 'm') ADVANCE(1389);
      if (lookahead == 'n') ADVANCE(1348);
      if (lookahead == 'o') ADVANCE(2592);
      if (lookahead == 'p') ADVANCE(2509);
      if (lookahead == 'r') ADVANCE(1867);
      if (lookahead == 's') ADVANCE(77);
      if (lookahead == 't') ADVANCE(1504);
      if (lookahead == 'u') ADVANCE(90);
      if (lookahead == 'v') ADVANCE(2536);
      if (lookahead == 'w') ADVANCE(1774);
      if (lookahead == 'x') ADVANCE(119);
      if (lookahead == 'z') ADVANCE(1856);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(1292);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3009);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(3805);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '0') ADVANCE(3059);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(1690);
      if (lookahead == 'b') ADVANCE(2014);
      if (lookahead == 'c') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(1909);
      if (lookahead == 'e') ADVANCE(2971);
      if (lookahead == 'f') ADVANCE(1376);
      if (lookahead == 'g') ADVANCE(1864);
      if (lookahead == 'h') ADVANCE(1405);
      if (lookahead == 'i') ADVANCE(1662);
      if (lookahead == 'l') ADVANCE(1420);
      if (lookahead == 'm') ADVANCE(1391);
      if (lookahead == 'n') ADVANCE(1470);
      if (lookahead == 'o') ADVANCE(2606);
      if (lookahead == 'p') ADVANCE(2508);
      if (lookahead == 's') ADVANCE(83);
      if (lookahead == 't') ADVANCE(2550);
      if (lookahead == 'u') ADVANCE(91);
      if (lookahead == 'v') ADVANCE(2535);
      if (lookahead == 'w') ADVANCE(1928);
      if (lookahead == 'x') ADVANCE(122);
      if (lookahead == 'z') ADVANCE(1956);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(1292);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3009);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(3805);
      if (lookahead == '"') ADVANCE(20);
      if (lookahead == '#') ADVANCE(3010);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == '+') ADVANCE(3009);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '-') ADVANCE(1286);
      if (lookahead == '0') ADVANCE(3057);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(341);
      if (lookahead == 'b') ADVANCE(555);
      if (lookahead == 'c') ADVANCE(26);
      if (lookahead == 'd') ADVANCE(390);
      if (lookahead == 'e') ADVANCE(729);
      if (lookahead == 'f') ADVANCE(150);
      if (lookahead == 'g') ADVANCE(277);
      if (lookahead == 'h') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(321);
      if (lookahead == 'j') ADVANCE(1219);
      if (lookahead == 'l') ADVANCE(151);
      if (lookahead == 'm') ADVANCE(152);
      if (lookahead == 'n') ADVANCE(157);
      if (lookahead == 'o') ADVANCE(963);
      if (lookahead == 'p') ADVANCE(159);
      if (lookahead == 'r') ADVANCE(392);
      if (lookahead == 's') ADVANCE(65);
      if (lookahead == 't') ADVANCE(214);
      if (lookahead == 'u') ADVANCE(68);
      if (lookahead == 'v') ADVANCE(162);
      if (lookahead == 'w') ADVANCE(448);
      if (lookahead == 'x') ADVANCE(114);
      if (lookahead == 'z') ADVANCE(393);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3058);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('k' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(3805);
      if (lookahead == '"') ADVANCE(20);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == '+') ADVANCE(3009);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '-') ADVANCE(1286);
      if (lookahead == '0') ADVANCE(3057);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(287);
      if (lookahead == 'b') ADVANCE(556);
      if (lookahead == 'c') ADVANCE(28);
      if (lookahead == 'd') ADVANCE(486);
      if (lookahead == 'e') ADVANCE(1254);
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'g') ADVANCE(450);
      if (lookahead == 'h') ADVANCE(177);
      if (lookahead == 'i') ADVANCE(324);
      if (lookahead == 'l') ADVANCE(151);
      if (lookahead == 'm') ADVANCE(153);
      if (lookahead == 'n') ADVANCE(212);
      if (lookahead == 'o') ADVANCE(980);
      if (lookahead == 'p') ADVANCE(606);
      if (lookahead == 'r') ADVANCE(443);
      if (lookahead == 's') ADVANCE(67);
      if (lookahead == 't') ADVANCE(214);
      if (lookahead == 'u') ADVANCE(70);
      if (lookahead == 'v') ADVANCE(163);
      if (lookahead == 'w') ADVANCE(449);
      if (lookahead == 'x') ADVANCE(114);
      if (lookahead == 'z') ADVANCE(524);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3058);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('j' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(3805);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == '0') ADVANCE(3067);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(1744);
      if (lookahead == 'b') ADVANCE(2013);
      if (lookahead == 'c') ADVANCE(2569);
      if (lookahead == 'd') ADVANCE(2141);
      if (lookahead == 'e') ADVANCE(2974);
      if (lookahead == 'f') ADVANCE(1395);
      if (lookahead == 'h') ADVANCE(1403);
      if (lookahead == 'i') ADVANCE(3011);
      if (lookahead == 'l') ADVANCE(1417);
      if (lookahead == 'm') ADVANCE(1952);
      if (lookahead == 'n') ADVANCE(2115);
      if (lookahead == 'o') ADVANCE(1854);
      if (lookahead == 'p') ADVANCE(2594);
      if (lookahead == 'r') ADVANCE(1940);
      if (lookahead == 's') ADVANCE(72);
      if (lookahead == 't') ADVANCE(2551);
      if (lookahead == 'u') ADVANCE(92);
      if (lookahead == 'v') ADVANCE(2537);
      if (lookahead == 'x') ADVANCE(121);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(3013);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3069);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3807);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '0') ADVANCE(3059);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(1342);
      if (lookahead == 'b') ADVANCE(2016);
      if (lookahead == 'c') ADVANCE(31);
      if (lookahead == 'd') ADVANCE(1846);
      if (lookahead == 'e') ADVANCE(2259);
      if (lookahead == 'f') ADVANCE(1393);
      if (lookahead == 'g') ADVANCE(1865);
      if (lookahead == 'h') ADVANCE(1404);
      if (lookahead == 'i') ADVANCE(1657);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1419);
      if (lookahead == 'm') ADVANCE(1388);
      if (lookahead == 'n') ADVANCE(1348);
      if (lookahead == 'o') ADVANCE(2592);
      if (lookahead == 'p') ADVANCE(2509);
      if (lookahead == 'r') ADVANCE(1847);
      if (lookahead == 's') ADVANCE(76);
      if (lookahead == 't') ADVANCE(1504);
      if (lookahead == 'u') ADVANCE(86);
      if (lookahead == 'v') ADVANCE(2536);
      if (lookahead == 'w') ADVANCE(1774);
      if (lookahead == 'x') ADVANCE(119);
      if (lookahead == 'z') ADVANCE(1856);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(1292);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3009);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '0') ADVANCE(3059);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(1342);
      if (lookahead == 'b') ADVANCE(2016);
      if (lookahead == 'c') ADVANCE(31);
      if (lookahead == 'd') ADVANCE(1846);
      if (lookahead == 'e') ADVANCE(2259);
      if (lookahead == 'f') ADVANCE(1393);
      if (lookahead == 'g') ADVANCE(1865);
      if (lookahead == 'h') ADVANCE(1404);
      if (lookahead == 'i') ADVANCE(1657);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1419);
      if (lookahead == 'm') ADVANCE(1388);
      if (lookahead == 'n') ADVANCE(1348);
      if (lookahead == 'o') ADVANCE(2592);
      if (lookahead == 'p') ADVANCE(2509);
      if (lookahead == 'r') ADVANCE(1847);
      if (lookahead == 's') ADVANCE(76);
      if (lookahead == 't') ADVANCE(1504);
      if (lookahead == 'u') ADVANCE(86);
      if (lookahead == 'v') ADVANCE(2536);
      if (lookahead == 'w') ADVANCE(1774);
      if (lookahead == 'x') ADVANCE(119);
      if (lookahead == 'z') ADVANCE(1856);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(1292);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3009);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '0') ADVANCE(3059);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(1770);
      if (lookahead == 'b') ADVANCE(2102);
      if (lookahead == 'c') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(1910);
      if (lookahead == 'e') ADVANCE(2971);
      if (lookahead == 'f') ADVANCE(1377);
      if (lookahead == 'g') ADVANCE(1864);
      if (lookahead == 'h') ADVANCE(2111);
      if (lookahead == 'i') ADVANCE(1661);
      if (lookahead == 'l') ADVANCE(2112);
      if (lookahead == 'm') ADVANCE(1392);
      if (lookahead == 'n') ADVANCE(1470);
      if (lookahead == 'o') ADVANCE(2633);
      if (lookahead == 'p') ADVANCE(2510);
      if (lookahead == 's') ADVANCE(83);
      if (lookahead == 't') ADVANCE(2671);
      if (lookahead == 'u') ADVANCE(91);
      if (lookahead == 'w') ADVANCE(1928);
      if (lookahead == 'x') ADVANCE(1599);
      if (lookahead == 'z') ADVANCE(1956);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(1292);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3009);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '+') ADVANCE(3013);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '-') ADVANCE(4535);
      if (lookahead == '0') ADVANCE(3068);
      if (lookahead == ':') ADVANCE(4542);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(4166);
      if (lookahead == 'b') ADVANCE(4479);
      if (lookahead == 'c') ADVANCE(4296);
      if (lookahead == 'd') ADVANCE(4004);
      if (lookahead == 'e') ADVANCE(4176);
      if (lookahead == 'h') ADVANCE(4298);
      if (lookahead == 'i') ADVANCE(4225);
      if (lookahead == 'j') ADVANCE(4480);
      if (lookahead == 'l') ADVANCE(4107);
      if (lookahead == 'm') ADVANCE(4110);
      if (lookahead == 'n') ADVANCE(3848);
      if (lookahead == 'o') ADVANCE(4338);
      if (lookahead == 'p') ADVANCE(4358);
      if (lookahead == 'r') ADVANCE(3970);
      if (lookahead == 's') ADVANCE(3815);
      if (lookahead == 'u') ADVANCE(3817);
      if (lookahead == 'v') ADVANCE(4401);
      if (lookahead == 'w') ADVANCE(4009);
      if (lookahead == 'z') ADVANCE(4013);
      if (lookahead == '{') ADVANCE(3806);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3070);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= '_') ||
          ('f' <= lookahead && lookahead <= 'y')) ADVANCE(4540);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '+') ADVANCE(3013);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '-') ADVANCE(4535);
      if (lookahead == '0') ADVANCE(3068);
      if (lookahead == ':') ADVANCE(4542);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(4166);
      if (lookahead == 'b') ADVANCE(4479);
      if (lookahead == 'c') ADVANCE(4296);
      if (lookahead == 'd') ADVANCE(4004);
      if (lookahead == 'e') ADVANCE(4176);
      if (lookahead == 'h') ADVANCE(4298);
      if (lookahead == 'i') ADVANCE(4225);
      if (lookahead == 'j') ADVANCE(4480);
      if (lookahead == 'l') ADVANCE(4107);
      if (lookahead == 'm') ADVANCE(4110);
      if (lookahead == 'n') ADVANCE(3848);
      if (lookahead == 'o') ADVANCE(4338);
      if (lookahead == 'p') ADVANCE(4358);
      if (lookahead == 'r') ADVANCE(3970);
      if (lookahead == 's') ADVANCE(3815);
      if (lookahead == 'u') ADVANCE(3817);
      if (lookahead == 'v') ADVANCE(4401);
      if (lookahead == 'w') ADVANCE(4009);
      if (lookahead == 'z') ADVANCE(4013);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3070);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= '_') ||
          ('f' <= lookahead && lookahead <= 'y')) ADVANCE(4540);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(3055);
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(3049);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(3039);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '"') ADVANCE(3045);
      if (lookahead != 0) ADVANCE(16);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(3042);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(3052);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(3080);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 20:
      if (lookahead == '"') ADVANCE(3056);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 21:
      if (lookahead == '"') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3050);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3051);
      END_STATE();
    case 22:
      if (lookahead == '"') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3040);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3041);
      END_STATE();
    case 23:
      if (lookahead == '"') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3046);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3047);
      END_STATE();
    case 24:
      if (lookahead == '"') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3043);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3044);
      END_STATE();
    case 25:
      if (lookahead == '"') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3053);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3054);
      END_STATE();
    case 26:
      if (lookahead == '"') ADVANCE(19);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(733);
      if (lookahead == 'l') ADVANCE(457);
      if (lookahead == 'm') ADVANCE(974);
      if (lookahead == 'o') ADVANCE(731);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 27:
      if (lookahead == '"') ADVANCE(19);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(734);
      if (lookahead == 'l') ADVANCE(457);
      if (lookahead == 'm') ADVANCE(974);
      if (lookahead == 'o') ADVANCE(731);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 28:
      if (lookahead == '"') ADVANCE(19);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(734);
      if (lookahead == 'l') ADVANCE(457);
      if (lookahead == 'm') ADVANCE(974);
      if (lookahead == 'o') ADVANCE(826);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 29:
      if (lookahead == '"') ADVANCE(19);
      if (lookahead == 'a') ADVANCE(2266);
      if (lookahead == 'c') ADVANCE(3204);
      if (lookahead == 'f') ADVANCE(2064);
      if (lookahead == 'l') ADVANCE(1950);
      if (lookahead == 'm') ADVANCE(2597);
      if (lookahead == 'o') ADVANCE(2263);
      if (lookahead == 'x') ADVANCE(2965);
      END_STATE();
    case 30:
      if (lookahead == '"') ADVANCE(19);
      if (lookahead == 'a') ADVANCE(2347);
      if (lookahead == 'c') ADVANCE(3204);
      if (lookahead == 'f') ADVANCE(2064);
      if (lookahead == 'o') ADVANCE(2265);
      if (lookahead == 'x') ADVANCE(2965);
      END_STATE();
    case 31:
      if (lookahead == '"') ADVANCE(19);
      if (lookahead == 'a') ADVANCE(2306);
      if (lookahead == 'c') ADVANCE(3204);
      if (lookahead == 'f') ADVANCE(2064);
      if (lookahead == 'l') ADVANCE(1950);
      if (lookahead == 'o') ADVANCE(2265);
      if (lookahead == 'x') ADVANCE(2965);
      END_STATE();
    case 32:
      if (lookahead == '"') ADVANCE(19);
      if (lookahead == 'a') ADVANCE(2267);
      if (lookahead == 'l') ADVANCE(1983);
      if (lookahead == 'm') ADVANCE(2597);
      if (lookahead == 'o') ADVANCE(2300);
      END_STATE();
    case 33:
      if (lookahead == '"') ADVANCE(19);
      if (lookahead == 'a') ADVANCE(2883);
      if (lookahead == 'l') ADVANCE(1950);
      if (lookahead == 'o') ADVANCE(2301);
      END_STATE();
    case 34:
      if (lookahead == '"') ADVANCE(19);
      if (lookahead == 'a') ADVANCE(2883);
      if (lookahead == 'l') ADVANCE(1950);
      if (lookahead == 'o') ADVANCE(2404);
      END_STATE();
    case 35:
      if (lookahead == '"') ADVANCE(19);
      if (lookahead == 'o') ADVANCE(2404);
      END_STATE();
    case 36:
      if (lookahead == '"') ADVANCE(20);
      if (lookahead == '#') ADVANCE(3010);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3807);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == '+') ADVANCE(3009);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '-') ADVANCE(1286);
      if (lookahead == '0') ADVANCE(3057);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(288);
      if (lookahead == 'b') ADVANCE(617);
      if (lookahead == 'c') ADVANCE(27);
      if (lookahead == 'd') ADVANCE(391);
      if (lookahead == 'e') ADVANCE(729);
      if (lookahead == 'f') ADVANCE(149);
      if (lookahead == 'g') ADVANCE(277);
      if (lookahead == 'h') ADVANCE(627);
      if (lookahead == 'i') ADVANCE(322);
      if (lookahead == 'j') ADVANCE(1219);
      if (lookahead == 'l') ADVANCE(245);
      if (lookahead == 'm') ADVANCE(154);
      if (lookahead == 'n') ADVANCE(157);
      if (lookahead == 'o') ADVANCE(981);
      if (lookahead == 'p') ADVANCE(160);
      if (lookahead == 'r') ADVANCE(439);
      if (lookahead == 's') ADVANCE(66);
      if (lookahead == 't') ADVANCE(215);
      if (lookahead == 'u') ADVANCE(69);
      if (lookahead == 'v') ADVANCE(164);
      if (lookahead == 'w') ADVANCE(448);
      if (lookahead == 'x') ADVANCE(284);
      if (lookahead == 'z') ADVANCE(393);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(39)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3058);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('k' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 37:
      if (lookahead == '"') ADVANCE(20);
      if (lookahead == '#') ADVANCE(3010);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == '+') ADVANCE(3013);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '-') ADVANCE(1288);
      if (lookahead == '0') ADVANCE(3064);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '=') ADVANCE(3083);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(389);
      if (lookahead == 'b') ADVANCE(619);
      if (lookahead == 'c') ADVANCE(147);
      if (lookahead == 'd') ADVANCE(546);
      if (lookahead == 'e') ADVANCE(730);
      if (lookahead == 'f') ADVANCE(224);
      if (lookahead == 'g') ADVANCE(277);
      if (lookahead == 'h') ADVANCE(910);
      if (lookahead == 'i') ADVANCE(323);
      if (lookahead == 'j') ADVANCE(1219);
      if (lookahead == 'l') ADVANCE(246);
      if (lookahead == 'm') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(158);
      if (lookahead == 'o') ADVANCE(981);
      if (lookahead == 'p') ADVANCE(161);
      if (lookahead == 'r') ADVANCE(392);
      if (lookahead == 's') ADVANCE(65);
      if (lookahead == 't') ADVANCE(216);
      if (lookahead == 'u') ADVANCE(71);
      if (lookahead == 'v') ADVANCE(164);
      if (lookahead == 'w') ADVANCE(664);
      if (lookahead == 'x') ADVANCE(284);
      if (lookahead == 'z') ADVANCE(512);
      if (lookahead == '{') ADVANCE(3806);
      if (lookahead == '}') ADVANCE(3261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(38)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3065);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('k' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 38:
      if (lookahead == '"') ADVANCE(20);
      if (lookahead == '#') ADVANCE(3010);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == '+') ADVANCE(3013);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '-') ADVANCE(1288);
      if (lookahead == '0') ADVANCE(3064);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '=') ADVANCE(3083);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(389);
      if (lookahead == 'b') ADVANCE(619);
      if (lookahead == 'c') ADVANCE(147);
      if (lookahead == 'd') ADVANCE(546);
      if (lookahead == 'e') ADVANCE(730);
      if (lookahead == 'f') ADVANCE(224);
      if (lookahead == 'g') ADVANCE(277);
      if (lookahead == 'h') ADVANCE(910);
      if (lookahead == 'i') ADVANCE(323);
      if (lookahead == 'j') ADVANCE(1219);
      if (lookahead == 'l') ADVANCE(246);
      if (lookahead == 'm') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(158);
      if (lookahead == 'o') ADVANCE(981);
      if (lookahead == 'p') ADVANCE(161);
      if (lookahead == 'r') ADVANCE(392);
      if (lookahead == 's') ADVANCE(65);
      if (lookahead == 't') ADVANCE(216);
      if (lookahead == 'u') ADVANCE(71);
      if (lookahead == 'v') ADVANCE(164);
      if (lookahead == 'w') ADVANCE(664);
      if (lookahead == 'x') ADVANCE(284);
      if (lookahead == 'z') ADVANCE(512);
      if (lookahead == '}') ADVANCE(3261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(38)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3065);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('k' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 39:
      if (lookahead == '"') ADVANCE(20);
      if (lookahead == '#') ADVANCE(3010);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == '+') ADVANCE(3009);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '-') ADVANCE(1286);
      if (lookahead == '0') ADVANCE(3057);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(288);
      if (lookahead == 'b') ADVANCE(617);
      if (lookahead == 'c') ADVANCE(27);
      if (lookahead == 'd') ADVANCE(391);
      if (lookahead == 'e') ADVANCE(729);
      if (lookahead == 'f') ADVANCE(149);
      if (lookahead == 'g') ADVANCE(277);
      if (lookahead == 'h') ADVANCE(627);
      if (lookahead == 'i') ADVANCE(322);
      if (lookahead == 'j') ADVANCE(1219);
      if (lookahead == 'l') ADVANCE(245);
      if (lookahead == 'm') ADVANCE(154);
      if (lookahead == 'n') ADVANCE(157);
      if (lookahead == 'o') ADVANCE(981);
      if (lookahead == 'p') ADVANCE(160);
      if (lookahead == 'r') ADVANCE(439);
      if (lookahead == 's') ADVANCE(66);
      if (lookahead == 't') ADVANCE(215);
      if (lookahead == 'u') ADVANCE(69);
      if (lookahead == 'v') ADVANCE(164);
      if (lookahead == 'w') ADVANCE(448);
      if (lookahead == 'x') ADVANCE(284);
      if (lookahead == 'z') ADVANCE(393);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(39)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3058);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('k' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 40:
      if (lookahead == '"') ADVANCE(20);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == '+') ADVANCE(3009);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '-') ADVANCE(1286);
      if (lookahead == '0') ADVANCE(3057);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'a') ADVANCE(289);
      if (lookahead == 'b') ADVANCE(618);
      if (lookahead == 'c') ADVANCE(28);
      if (lookahead == 'd') ADVANCE(487);
      if (lookahead == 'e') ADVANCE(1254);
      if (lookahead == 'f') ADVANCE(149);
      if (lookahead == 'g') ADVANCE(450);
      if (lookahead == 'h') ADVANCE(628);
      if (lookahead == 'i') ADVANCE(325);
      if (lookahead == 'l') ADVANCE(245);
      if (lookahead == 'm') ADVANCE(156);
      if (lookahead == 'n') ADVANCE(212);
      if (lookahead == 'o') ADVANCE(1000);
      if (lookahead == 'p') ADVANCE(607);
      if (lookahead == 'r') ADVANCE(443);
      if (lookahead == 's') ADVANCE(67);
      if (lookahead == 't') ADVANCE(215);
      if (lookahead == 'u') ADVANCE(70);
      if (lookahead == 'v') ADVANCE(165);
      if (lookahead == 'w') ADVANCE(449);
      if (lookahead == 'x') ADVANCE(284);
      if (lookahead == 'z') ADVANCE(524);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3058);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('j' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 41:
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == 'b') ADVANCE(2013);
      if (lookahead == 'd') ADVANCE(2506);
      if (lookahead == 'f') ADVANCE(2255);
      if (lookahead == 'h') ADVANCE(1403);
      if (lookahead == 'i') ADVANCE(3011);
      if (lookahead == 'l') ADVANCE(1417);
      if (lookahead == 'm') ADVANCE(1952);
      if (lookahead == 'o') ADVANCE(2605);
      if (lookahead == 'p') ADVANCE(2594);
      if (lookahead == 't') ADVANCE(2549);
      if (lookahead == 'v') ADVANCE(2535);
      if (lookahead == 'x') ADVANCE(121);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(41)
      END_STATE();
    case 42:
      if (lookahead == '+') ADVANCE(3012);
      if (lookahead == '-') ADVANCE(1287);
      if (lookahead == ':') ADVANCE(3048);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3075);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 43:
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == 'x') ADVANCE(3272);
      if (lookahead == '}') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      END_STATE();
    case 44:
      if (lookahead == '-') ADVANCE(2211);
      if (lookahead == '_') ADVANCE(1611);
      if (lookahead == 'a') ADVANCE(2285);
      if (lookahead == 'b') ADVANCE(2938);
      if (lookahead == 'c') ADVANCE(1426);
      if (lookahead == 'd') ADVANCE(1896);
      if (lookahead == 'f') ADVANCE(2699);
      if (lookahead == 'i') ADVANCE(2401);
      if (lookahead == 'm') ADVANCE(1893);
      if (lookahead == 'n') ADVANCE(1790);
      if (lookahead == 'p') ADVANCE(2666);
      if (lookahead == 'r') ADVANCE(1791);
      if (lookahead == 's') ADVANCE(1436);
      if (lookahead == 't') ADVANCE(1482);
      if (lookahead == 'u') ADVANCE(2412);
      END_STATE();
    case 45:
      if (lookahead == '-') ADVANCE(2211);
      if (lookahead == '_') ADVANCE(1611);
      if (lookahead == 'a') ADVANCE(2285);
      if (lookahead == 'b') ADVANCE(2938);
      if (lookahead == 'c') ADVANCE(1426);
      if (lookahead == 'd') ADVANCE(1896);
      if (lookahead == 'f') ADVANCE(2699);
      if (lookahead == 'i') ADVANCE(2401);
      if (lookahead == 'm') ADVANCE(1893);
      if (lookahead == 'n') ADVANCE(1790);
      if (lookahead == 'p') ADVANCE(2666);
      if (lookahead == 'r') ADVANCE(1791);
      if (lookahead == 's') ADVANCE(1436);
      if (lookahead == 'u') ADVANCE(2412);
      END_STATE();
    case 46:
      if (lookahead == '-') ADVANCE(2211);
      if (lookahead == '_') ADVANCE(1611);
      if (lookahead == 'a') ADVANCE(2285);
      if (lookahead == 'b') ADVANCE(2938);
      if (lookahead == 'c') ADVANCE(1426);
      if (lookahead == 'd') ADVANCE(2906);
      if (lookahead == 'f') ADVANCE(2699);
      if (lookahead == 'i') ADVANCE(2401);
      if (lookahead == 'm') ADVANCE(1893);
      if (lookahead == 'n') ADVANCE(1790);
      if (lookahead == 'p') ADVANCE(2666);
      if (lookahead == 'r') ADVANCE(1791);
      if (lookahead == 's') ADVANCE(1436);
      if (lookahead == 't') ADVANCE(1482);
      if (lookahead == 'u') ADVANCE(2412);
      END_STATE();
    case 47:
      if (lookahead == '-') ADVANCE(2211);
      if (lookahead == '_') ADVANCE(1611);
      if (lookahead == 'a') ADVANCE(2285);
      if (lookahead == 'b') ADVANCE(2938);
      if (lookahead == 'c') ADVANCE(1426);
      if (lookahead == 'd') ADVANCE(2906);
      if (lookahead == 'f') ADVANCE(2699);
      if (lookahead == 'i') ADVANCE(2401);
      if (lookahead == 'm') ADVANCE(1893);
      if (lookahead == 'n') ADVANCE(1790);
      if (lookahead == 'p') ADVANCE(2666);
      if (lookahead == 'r') ADVANCE(1791);
      if (lookahead == 's') ADVANCE(1436);
      if (lookahead == 'u') ADVANCE(2412);
      END_STATE();
    case 48:
      if (lookahead == '-') ADVANCE(2211);
      if (lookahead == '_') ADVANCE(1611);
      if (lookahead == 'a') ADVANCE(2285);
      if (lookahead == 'b') ADVANCE(2938);
      if (lookahead == 'c') ADVANCE(1426);
      if (lookahead == 'd') ADVANCE(2906);
      if (lookahead == 'f') ADVANCE(2699);
      if (lookahead == 'i') ADVANCE(2401);
      if (lookahead == 'm') ADVANCE(1893);
      if (lookahead == 'n') ADVANCE(2279);
      if (lookahead == 'p') ADVANCE(2666);
      if (lookahead == 'r') ADVANCE(1791);
      if (lookahead == 's') ADVANCE(1436);
      if (lookahead == 'u') ADVANCE(2412);
      END_STATE();
    case 49:
      if (lookahead == '-') ADVANCE(2211);
      if (lookahead == 'a') ADVANCE(2285);
      if (lookahead == 'b') ADVANCE(2938);
      if (lookahead == 'c') ADVANCE(1426);
      if (lookahead == 'd') ADVANCE(2906);
      if (lookahead == 'f') ADVANCE(2699);
      if (lookahead == 'i') ADVANCE(2401);
      if (lookahead == 'm') ADVANCE(1893);
      if (lookahead == 'n') ADVANCE(2279);
      if (lookahead == 'p') ADVANCE(2666);
      if (lookahead == 'r') ADVANCE(1791);
      if (lookahead == 's') ADVANCE(1436);
      if (lookahead == 'u') ADVANCE(2412);
      END_STATE();
    case 50:
      if (lookahead == '-') ADVANCE(696);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(293);
      if (lookahead == 'a') ADVANCE(747);
      if (lookahead == 'b') ADVANCE(1231);
      if (lookahead == 'c') ADVANCE(220);
      if (lookahead == 'd') ADVANCE(1209);
      if (lookahead == 'f') ADVANCE(1041);
      if (lookahead == 'i') ADVANCE(823);
      if (lookahead == 'm') ADVANCE(478);
      if (lookahead == 'n') ADVANCE(397);
      if (lookahead == 'p') ADVANCE(1059);
      if (lookahead == 'r') ADVANCE(399);
      if (lookahead == 's') ADVANCE(188);
      if (lookahead == 't') ADVANCE(229);
      if (lookahead == 'u') ADVANCE(832);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('e' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 51:
      if (lookahead == '-') ADVANCE(696);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(747);
      if (lookahead == 'b') ADVANCE(1231);
      if (lookahead == 'c') ADVANCE(220);
      if (lookahead == 'd') ADVANCE(1209);
      if (lookahead == 'f') ADVANCE(1041);
      if (lookahead == 'i') ADVANCE(823);
      if (lookahead == 'm') ADVANCE(478);
      if (lookahead == 'n') ADVANCE(746);
      if (lookahead == 'p') ADVANCE(1059);
      if (lookahead == 'r') ADVANCE(399);
      if (lookahead == 's') ADVANCE(188);
      if (lookahead == 't') ADVANCE(229);
      if (lookahead == 'u') ADVANCE(832);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('e' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 52:
      if (lookahead == '-') ADVANCE(1164);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(1008);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 53:
      if (lookahead == '-') ADVANCE(2850);
      END_STATE();
    case 54:
      if (lookahead == '-') ADVANCE(2850);
      if (lookahead == 'b') ADVANCE(2642);
      END_STATE();
    case 55:
      if (lookahead == '-') ADVANCE(1102);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 56:
      if (lookahead == '-') ADVANCE(2766);
      END_STATE();
    case 57:
      if (lookahead == '-') ADVANCE(1053);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 58:
      if (lookahead == '-') ADVANCE(2694);
      END_STATE();
    case 59:
      if (lookahead == '-') ADVANCE(2899);
      END_STATE();
    case 60:
      if (lookahead == '-') ADVANCE(1203);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 61:
      if (lookahead == '.') ADVANCE(3280);
      END_STATE();
    case 62:
      if (lookahead == '.') ADVANCE(61);
      END_STATE();
    case 63:
      if (lookahead == '0') ADVANCE(3224);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 64:
      if (lookahead == '0') ADVANCE(3223);
      END_STATE();
    case 65:
      if (lookahead == '0') ADVANCE(1249);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(573);
      if (lookahead == 'd') ADVANCE(630);
      if (lookahead == 'e') ADVANCE(330);
      if (lookahead == 'h') ADVANCE(190);
      if (lookahead == 'i') ADVANCE(592);
      if (lookahead == 'p') ADVANCE(462);
      if (lookahead == 'r') ADVANCE(395);
      if (lookahead == 's') ADVANCE(964);
      if (lookahead == 't') ADVANCE(936);
      if (lookahead == 'u') ADVANCE(261);
      if (lookahead == 'w') ADVANCE(621);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 66:
      if (lookahead == '0') ADVANCE(1249);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(573);
      if (lookahead == 'd') ADVANCE(630);
      if (lookahead == 'e') ADVANCE(329);
      if (lookahead == 'h') ADVANCE(190);
      if (lookahead == 'i') ADVANCE(592);
      if (lookahead == 'p') ADVANCE(462);
      if (lookahead == 'r') ADVANCE(395);
      if (lookahead == 's') ADVANCE(964);
      if (lookahead == 't') ADVANCE(936);
      if (lookahead == 'u') ADVANCE(261);
      if (lookahead == 'w') ADVANCE(621);
      if (lookahead == 'y') ADVANCE(868);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 67:
      if (lookahead == '0') ADVANCE(1249);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(630);
      if (lookahead == 'e') ADVANCE(773);
      if (lookahead == 'h') ADVANCE(712);
      if (lookahead == 'i') ADVANCE(1148);
      if (lookahead == 'r') ADVANCE(477);
      if (lookahead == 't') ADVANCE(937);
      if (lookahead == 'u') ADVANCE(261);
      if (lookahead == 'w') ADVANCE(668);
      if (lookahead == 'y') ADVANCE(868);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 68:
      if (lookahead == '0') ADVANCE(1249);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(632);
      if (lookahead == 'i') ADVANCE(1189);
      if (lookahead == 'm') ADVANCE(179);
      if (lookahead == 'n') ADVANCE(371);
      if (lookahead == 'r') ADVANCE(456);
      if (lookahead == 's') ADVANCE(520);
      if (lookahead == 'w') ADVANCE(1201);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 69:
      if (lookahead == '0') ADVANCE(1249);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(632);
      if (lookahead == 'i') ADVANCE(1189);
      if (lookahead == 'm') ADVANCE(179);
      if (lookahead == 'n') ADVANCE(370);
      if (lookahead == 'r') ADVANCE(456);
      if (lookahead == 's') ADVANCE(520);
      if (lookahead == 'w') ADVANCE(1201);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 70:
      if (lookahead == '0') ADVANCE(1249);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(632);
      if (lookahead == 'i') ADVANCE(1189);
      if (lookahead == 'm') ADVANCE(179);
      if (lookahead == 'n') ADVANCE(370);
      if (lookahead == 'r') ADVANCE(456);
      if (lookahead == 's') ADVANCE(520);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 71:
      if (lookahead == '0') ADVANCE(1249);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(632);
      if (lookahead == 'i') ADVANCE(1189);
      if (lookahead == 'm') ADVANCE(179);
      if (lookahead == 'n') ADVANCE(1056);
      if (lookahead == 'r') ADVANCE(456);
      if (lookahead == 's') ADVANCE(520);
      if (lookahead == 'w') ADVANCE(1201);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 72:
      if (lookahead == '0') ADVANCE(2959);
      END_STATE();
    case 73:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'a') ADVANCE(2034);
      if (lookahead == 'd') ADVANCE(2114);
      if (lookahead == 'e') ADVANCE(1670);
      if (lookahead == 'g') ADVANCE(1781);
      if (lookahead == 'h') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1733);
      if (lookahead == 'l') ADVANCE(1782);
      if (lookahead == 'o') ADVANCE(2920);
      if (lookahead == 'p') ADVANCE(1881);
      if (lookahead == 'r') ADVANCE(1783);
      if (lookahead == 's') ADVANCE(2581);
      if (lookahead == 't') ADVANCE(2558);
      if (lookahead == 'u') ADVANCE(1547);
      if (lookahead == 'w') ADVANCE(2106);
      if (lookahead == 'y') ADVANCE(2436);
      END_STATE();
    case 74:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'a') ADVANCE(2034);
      if (lookahead == 'd') ADVANCE(2114);
      if (lookahead == 'e') ADVANCE(1671);
      if (lookahead == 'h') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(2066);
      if (lookahead == 'o') ADVANCE(2920);
      if (lookahead == 'p') ADVANCE(1880);
      if (lookahead == 'r') ADVANCE(1783);
      if (lookahead == 's') ADVANCE(2581);
      if (lookahead == 't') ADVANCE(2662);
      if (lookahead == 'u') ADVANCE(1547);
      if (lookahead == 'w') ADVANCE(2167);
      END_STATE();
    case 75:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'a') ADVANCE(2035);
      if (lookahead == 'd') ADVANCE(2114);
      if (lookahead == 'e') ADVANCE(1671);
      if (lookahead == 'h') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(2066);
      if (lookahead == 'o') ADVANCE(2920);
      if (lookahead == 'p') ADVANCE(1880);
      if (lookahead == 'r') ADVANCE(1783);
      if (lookahead == 's') ADVANCE(2581);
      if (lookahead == 't') ADVANCE(2558);
      if (lookahead == 'u') ADVANCE(1547);
      if (lookahead == 'w') ADVANCE(2159);
      END_STATE();
    case 76:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'a') ADVANCE(2035);
      if (lookahead == 'd') ADVANCE(2114);
      if (lookahead == 'e') ADVANCE(2290);
      if (lookahead == 'h') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(2066);
      if (lookahead == 'p') ADVANCE(1881);
      if (lookahead == 'r') ADVANCE(1783);
      if (lookahead == 's') ADVANCE(2581);
      if (lookahead == 't') ADVANCE(2662);
      if (lookahead == 'u') ADVANCE(1547);
      if (lookahead == 'w') ADVANCE(2124);
      if (lookahead == 'y') ADVANCE(2436);
      END_STATE();
    case 77:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'a') ADVANCE(2035);
      if (lookahead == 'd') ADVANCE(2114);
      if (lookahead == 'e') ADVANCE(2291);
      if (lookahead == 'h') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(2066);
      if (lookahead == 'p') ADVANCE(1881);
      if (lookahead == 'r') ADVANCE(1783);
      if (lookahead == 's') ADVANCE(2581);
      if (lookahead == 't') ADVANCE(2662);
      if (lookahead == 'u') ADVANCE(1547);
      if (lookahead == 'w') ADVANCE(2124);
      END_STATE();
    case 78:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'a') ADVANCE(2035);
      if (lookahead == 'e') ADVANCE(1672);
      if (lookahead == 'h') ADVANCE(1423);
      if (lookahead == 'i') ADVANCE(2065);
      if (lookahead == 'o') ADVANCE(2920);
      if (lookahead == 'p') ADVANCE(1880);
      if (lookahead == 'r') ADVANCE(1948);
      if (lookahead == 's') ADVANCE(2581);
      if (lookahead == 't') ADVANCE(2662);
      if (lookahead == 'w') ADVANCE(2167);
      if (lookahead == 'y') ADVANCE(2436);
      END_STATE();
    case 79:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'a') ADVANCE(2035);
      if (lookahead == 'e') ADVANCE(2630);
      if (lookahead == 'h') ADVANCE(1423);
      if (lookahead == 'i') ADVANCE(2065);
      if (lookahead == 'o') ADVANCE(2920);
      if (lookahead == 'p') ADVANCE(1881);
      if (lookahead == 'r') ADVANCE(1948);
      if (lookahead == 's') ADVANCE(2581);
      if (lookahead == 't') ADVANCE(2662);
      if (lookahead == 'u') ADVANCE(1547);
      if (lookahead == 'w') ADVANCE(2124);
      if (lookahead == 'y') ADVANCE(2436);
      END_STATE();
    case 80:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'a') ADVANCE(2035);
      if (lookahead == 'e') ADVANCE(2630);
      if (lookahead == 'h') ADVANCE(1423);
      if (lookahead == 'i') ADVANCE(2065);
      if (lookahead == 'o') ADVANCE(2920);
      if (lookahead == 'p') ADVANCE(1881);
      if (lookahead == 'r') ADVANCE(1948);
      if (lookahead == 's') ADVANCE(2581);
      if (lookahead == 't') ADVANCE(2662);
      if (lookahead == 'w') ADVANCE(2124);
      if (lookahead == 'y') ADVANCE(2436);
      END_STATE();
    case 81:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'd') ADVANCE(2114);
      if (lookahead == 'e') ADVANCE(2290);
      if (lookahead == 'g') ADVANCE(1781);
      if (lookahead == 'h') ADVANCE(2231);
      if (lookahead == 'i') ADVANCE(2830);
      if (lookahead == 'l') ADVANCE(1782);
      if (lookahead == 'o') ADVANCE(2920);
      if (lookahead == 'r') ADVANCE(1905);
      if (lookahead == 'u') ADVANCE(1547);
      if (lookahead == 'y') ADVANCE(2436);
      END_STATE();
    case 82:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'd') ADVANCE(2114);
      if (lookahead == 'e') ADVANCE(2290);
      if (lookahead == 'h') ADVANCE(2231);
      if (lookahead == 'i') ADVANCE(2830);
      if (lookahead == 'o') ADVANCE(2920);
      if (lookahead == 'r') ADVANCE(1905);
      if (lookahead == 'u') ADVANCE(1547);
      if (lookahead == 'y') ADVANCE(2436);
      END_STATE();
    case 83:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'd') ADVANCE(2114);
      if (lookahead == 'e') ADVANCE(2291);
      if (lookahead == 'h') ADVANCE(2231);
      if (lookahead == 'i') ADVANCE(2830);
      if (lookahead == 'r') ADVANCE(1905);
      if (lookahead == 'u') ADVANCE(1547);
      END_STATE();
    case 84:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'd') ADVANCE(2116);
      if (lookahead == 'e') ADVANCE(2628);
      if (lookahead == 'g') ADVANCE(1784);
      if (lookahead == 'i') ADVANCE(2886);
      if (lookahead == 'l') ADVANCE(1785);
      if (lookahead == 'm') ADVANCE(1410);
      if (lookahead == 'n') ADVANCE(1736);
      if (lookahead == 'r') ADVANCE(1877);
      if (lookahead == 's') ADVANCE(1966);
      if (lookahead == 'w') ADVANCE(2831);
      END_STATE();
    case 85:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'd') ADVANCE(2116);
      if (lookahead == 'g') ADVANCE(1784);
      if (lookahead == 'i') ADVANCE(2886);
      if (lookahead == 'l') ADVANCE(1785);
      if (lookahead == 'm') ADVANCE(1410);
      if (lookahead == 'n') ADVANCE(1739);
      if (lookahead == 'r') ADVANCE(1877);
      if (lookahead == 's') ADVANCE(1966);
      END_STATE();
    case 86:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'd') ADVANCE(2116);
      if (lookahead == 'i') ADVANCE(2886);
      if (lookahead == 'm') ADVANCE(1410);
      if (lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'r') ADVANCE(1877);
      if (lookahead == 'w') ADVANCE(2831);
      END_STATE();
    case 87:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'd') ADVANCE(2116);
      if (lookahead == 'i') ADVANCE(2886);
      if (lookahead == 'm') ADVANCE(1410);
      if (lookahead == 'n') ADVANCE(1740);
      if (lookahead == 'r') ADVANCE(1877);
      if (lookahead == 's') ADVANCE(1966);
      if (lookahead == 'w') ADVANCE(2831);
      END_STATE();
    case 88:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'd') ADVANCE(2116);
      if (lookahead == 'i') ADVANCE(2886);
      if (lookahead == 'm') ADVANCE(1410);
      if (lookahead == 'n') ADVANCE(1739);
      if (lookahead == 'r') ADVANCE(1877);
      if (lookahead == 's') ADVANCE(1966);
      END_STATE();
    case 89:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'd') ADVANCE(2116);
      if (lookahead == 'i') ADVANCE(2886);
      if (lookahead == 'm') ADVANCE(1410);
      if (lookahead == 'n') ADVANCE(1737);
      if (lookahead == 'r') ADVANCE(1877);
      if (lookahead == 's') ADVANCE(1966);
      if (lookahead == 'w') ADVANCE(2831);
      END_STATE();
    case 90:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'd') ADVANCE(2116);
      if (lookahead == 'i') ADVANCE(2886);
      if (lookahead == 'm') ADVANCE(1410);
      if (lookahead == 'n') ADVANCE(1737);
      if (lookahead == 'r') ADVANCE(1877);
      if (lookahead == 'w') ADVANCE(2831);
      END_STATE();
    case 91:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'd') ADVANCE(2116);
      if (lookahead == 'i') ADVANCE(2886);
      if (lookahead == 'm') ADVANCE(1410);
      if (lookahead == 'n') ADVANCE(1735);
      if (lookahead == 'r') ADVANCE(1877);
      END_STATE();
    case 92:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'e') ADVANCE(2628);
      if (lookahead == 'g') ADVANCE(1784);
      if (lookahead == 'l') ADVANCE(1785);
      if (lookahead == 'n') ADVANCE(1786);
      END_STATE();
    case 93:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'm') ADVANCE(1410);
      if (lookahead == 'n') ADVANCE(2434);
      if (lookahead == 's') ADVANCE(1966);
      if (lookahead == 'w') ADVANCE(2831);
      END_STATE();
    case 94:
      if (lookahead == '0') ADVANCE(2959);
      if (lookahead == 'n') ADVANCE(2434);
      if (lookahead == 's') ADVANCE(1966);
      if (lookahead == 'w') ADVANCE(2831);
      END_STATE();
    case 95:
      if (lookahead == '0') ADVANCE(1311);
      END_STATE();
    case 96:
      if (lookahead == '1') ADVANCE(101);
      END_STATE();
    case 97:
      if (lookahead == '1') ADVANCE(101);
      if (lookahead == 'e') ADVANCE(2968);
      if (lookahead == 't') ADVANCE(2504);
      END_STATE();
    case 98:
      if (lookahead == '1') ADVANCE(102);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1257);
      if (lookahead == 't') ADVANCE(905);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 99:
      if (lookahead == '1') ADVANCE(103);
      END_STATE();
    case 100:
      if (lookahead == '1') ADVANCE(104);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 101:
      if (lookahead == '2') ADVANCE(112);
      END_STATE();
    case 102:
      if (lookahead == '2') ADVANCE(115);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 103:
      if (lookahead == '2') ADVANCE(113);
      END_STATE();
    case 104:
      if (lookahead == '2') ADVANCE(117);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 105:
      if (lookahead == '3') ADVANCE(95);
      END_STATE();
    case 106:
      if (lookahead == '4') ADVANCE(105);
      END_STATE();
    case 107:
      if (lookahead == '4') ADVANCE(1313);
      END_STATE();
    case 108:
      if (lookahead == '6') ADVANCE(107);
      END_STATE();
    case 109:
      if (lookahead == '6') ADVANCE(124);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 110:
      if (lookahead == '6') ADVANCE(1298);
      END_STATE();
    case 111:
      if (lookahead == '6') ADVANCE(1299);
      END_STATE();
    case 112:
      if (lookahead == '8') ADVANCE(3227);
      END_STATE();
    case 113:
      if (lookahead == '8') ADVANCE(3230);
      END_STATE();
    case 114:
      if (lookahead == '8') ADVANCE(109);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(608);
      if (lookahead == 'o') ADVANCE(1002);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 115:
      if (lookahead == '8') ADVANCE(3228);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 116:
      if (lookahead == '8') ADVANCE(63);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 117:
      if (lookahead == '8') ADVANCE(3231);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 118:
      if (lookahead == '8') ADVANCE(110);
      END_STATE();
    case 119:
      if (lookahead == '8') ADVANCE(110);
      if (lookahead == 'c') ADVANCE(2092);
      if (lookahead == 'o') ADVANCE(2650);
      END_STATE();
    case 120:
      if (lookahead == '8') ADVANCE(64);
      END_STATE();
    case 121:
      if (lookahead == '8') ADVANCE(111);
      END_STATE();
    case 122:
      if (lookahead == '8') ADVANCE(111);
      if (lookahead == 'c') ADVANCE(2092);
      if (lookahead == 'o') ADVANCE(2650);
      END_STATE();
    case 123:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(776);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 124:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(180);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 125:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(249);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 126:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(1245);
      if (lookahead == 'a') ADVANCE(721);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 127:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(293);
      if (lookahead == 'n') ADVANCE(398);
      if (lookahead == 't') ADVANCE(229);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 128:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(565);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 129:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(294);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 130:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(1060);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 131:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 132:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(335);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 133:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(900);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 134:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(1179);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 135:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(471);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 136:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(1107);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 137:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(639);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 138:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(613);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 139:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(991);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 140:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 141:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(750);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 142:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(211);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 143:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(930);
      if (lookahead == 'o') ADVANCE(872);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 144:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(1069);
      if (lookahead == 'u') ADVANCE(687);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 145:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(655);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 146:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(1239);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 147:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(733);
      if (lookahead == 'l') ADVANCE(457);
      if (lookahead == 'm') ADVANCE(974);
      if (lookahead == 'o') ADVANCE(732);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 148:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(362);
      if (lookahead == 'c') ADVANCE(806);
      if (lookahead == 'd') ADVANCE(626);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'i') ADVANCE(786);
      if (lookahead == 'l') ADVANCE(914);
      if (lookahead == 'm') ADVANCE(1210);
      if (lookahead == 'n') ADVANCE(447);
      if (lookahead == 'p') ADVANCE(98);
      if (lookahead == 'r') ADVANCE(394);
      if (lookahead == 's') ADVANCE(1207);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 149:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(362);
      if (lookahead == 'c') ADVANCE(806);
      if (lookahead == 'd') ADVANCE(626);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'i') ADVANCE(786);
      if (lookahead == 'm') ADVANCE(1210);
      if (lookahead == 'n') ADVANCE(447);
      if (lookahead == 'p') ADVANCE(452);
      if (lookahead == 'r') ADVANCE(394);
      if (lookahead == 's') ADVANCE(1207);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 150:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(362);
      if (lookahead == 'c') ADVANCE(806);
      if (lookahead == 'd') ADVANCE(626);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'l') ADVANCE(914);
      if (lookahead == 'm') ADVANCE(1210);
      if (lookahead == 'n') ADVANCE(447);
      if (lookahead == 'p') ADVANCE(98);
      if (lookahead == 'r') ADVANCE(394);
      if (lookahead == 's') ADVANCE(1207);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 151:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(265);
      if (lookahead == 'i') ADVANCE(849);
      if (lookahead == 'o') ADVANCE(181);
      if (lookahead == 's') ADVANCE(610);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 152:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1248);
      if (lookahead == 'e') ADVANCE(1177);
      if (lookahead == 'i') ADVANCE(831);
      if (lookahead == 'u') ADVANCE(710);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 153:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1248);
      if (lookahead == 'e') ADVANCE(1177);
      if (lookahead == 'i') ADVANCE(848);
      if (lookahead == 'o') ADVANCE(862);
      if (lookahead == 'u') ADVANCE(711);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 154:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1248);
      if (lookahead == 'i') ADVANCE(831);
      if (lookahead == 'o') ADVANCE(862);
      if (lookahead == 'u') ADVANCE(710);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 155:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1248);
      if (lookahead == 'i') ADVANCE(831);
      if (lookahead == 'u') ADVANCE(710);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 156:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1248);
      if (lookahead == 'i') ADVANCE(848);
      if (lookahead == 'o') ADVANCE(862);
      if (lookahead == 'u') ADVANCE(711);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 157:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(704);
      if (lookahead == 'e') ADVANCE(1087);
      if (lookahead == 'o') ADVANCE(50);
      if (lookahead == 'u') ADVANCE(737);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 158:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(704);
      if (lookahead == 'e') ADVANCE(1087);
      if (lookahead == 'o') ADVANCE(51);
      if (lookahead == 'u') ADVANCE(758);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 159:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1023);
      if (lookahead == 'e') ADVANCE(1016);
      if (lookahead == 'h') ADVANCE(620);
      if (lookahead == 'o') ADVANCE(688);
      if (lookahead == 'p') ADVANCE(286);
      if (lookahead == 'r') ADVANCE(444);
      if (lookahead == 't') ADVANCE(1001);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 160:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1023);
      if (lookahead == 'e') ADVANCE(1016);
      if (lookahead == 'h') ADVANCE(620);
      if (lookahead == 'o') ADVANCE(688);
      if (lookahead == 'r') ADVANCE(444);
      if (lookahead == 't') ADVANCE(1048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 161:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1023);
      if (lookahead == 'e') ADVANCE(1016);
      if (lookahead == 'h') ADVANCE(620);
      if (lookahead == 'r') ADVANCE(445);
      if (lookahead == 't') ADVANCE(1048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 162:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(140);
      if (lookahead == 'o') ADVANCE(636);
      if (lookahead == 's') ADVANCE(327);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 163:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(140);
      if (lookahead == 'o') ADVANCE(636);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 164:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(140);
      if (lookahead == 's') ADVANCE(327);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 165:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(140);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 166:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(328);
      if (lookahead == 'd') ADVANCE(635);
      if (lookahead == 'l') ADVANCE(665);
      if (lookahead == 'r') ADVANCE(454);
      if (lookahead == 's') ADVANCE(511);
      if (lookahead == 't') ADVANCE(521);
      if (lookahead == 'v') ADVANCE(934);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 167:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(328);
      if (lookahead == 'd') ADVANCE(635);
      if (lookahead == 'l') ADVANCE(665);
      if (lookahead == 'r') ADVANCE(454);
      if (lookahead == 's') ADVANCE(511);
      if (lookahead == 't') ADVANCE(1150);
      if (lookahead == 'v') ADVANCE(934);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 168:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(998);
      if (lookahead == 't') ADVANCE(567);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 169:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(998);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 170:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1270);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 171:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(3603);
      if (lookahead == 's') ADVANCE(675);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 172:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(3603);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 173:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(3490);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 174:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(3237);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 175:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1273);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 176:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(709);
      if (lookahead == 'i') ADVANCE(364);
      if (lookahead == 'o') ADVANCE(1114);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 177:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(709);
      if (lookahead == 'i') ADVANCE(364);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 178:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(697);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 179:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1250);
      if (lookahead == 'i') ADVANCE(833);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 180:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(811);
      if (lookahead == 'f') ADVANCE(973);
      if (lookahead == 'm') ADVANCE(812);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 181:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(346);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 182:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1076);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 183:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(701);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 184:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1084);
      if (lookahead == 'e') ADVANCE(1036);
      if (lookahead == 's') ADVANCE(495);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 185:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(887);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 186:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(348);
      if (lookahead == 'l') ADVANCE(494);
      if (lookahead == 's') ADVANCE(1221);
      if (lookahead == 't') ADVANCE(3539);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 187:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(348);
      if (lookahead == 's') ADVANCE(1221);
      if (lookahead == 't') ADVANCE(3539);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 188:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(903);
      if (lookahead == 'y') ADVANCE(858);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 189:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1017);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 190:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(367);
      if (lookahead == 'l') ADVANCE(3662);
      if (lookahead == 'u') ADVANCE(564);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 191:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(369);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 192:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(717);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 193:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1120);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 194:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1021);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 195:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(588);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 196:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(351);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 197:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(790);
      if (lookahead == 'f') ADVANCE(633);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 198:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1123);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 199:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(296);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 200:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1124);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 201:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(355);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 202:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(356);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 203:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(722);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 204:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(359);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 205:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(366);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 206:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(724);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 207:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(778);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 208:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(890);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 209:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(772);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 210:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1145);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 211:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1075);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 212:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(852);
      if (lookahead == 'o') ADVANCE(127);
      if (lookahead == 'u') ADVANCE(759);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 213:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1142);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 214:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(634);
      if (lookahead == 'o') ADVANCE(705);
      if (lookahead == 'r') ADVANCE(1205);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 215:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(634);
      if (lookahead == 'r') ADVANCE(1205);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 216:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(634);
      if (lookahead == 'r') ADVANCE(1230);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 217:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1218);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 218:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(368);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 219:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(292);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 220:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(979);
      if (lookahead == 'f') ADVANCE(129);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 221:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(760);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 222:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(637);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 223:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1094);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 224:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(363);
      if (lookahead == 'c') ADVANCE(806);
      if (lookahead == 'd') ADVANCE(626);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 'm') ADVANCE(1210);
      if (lookahead == 'n') ADVANCE(447);
      if (lookahead == 'p') ADVANCE(452);
      if (lookahead == 'r') ADVANCE(394);
      if (lookahead == 's') ADVANCE(1207);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 225:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1169);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 226:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(295);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 227:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1161);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 228:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(340);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 229:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(642);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 230:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1103);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 231:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(754);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 232:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(318);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 233:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(597);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 234:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(646);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 235:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1099);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 236:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1172);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 237:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(301);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 238:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(755);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 239:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(320);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 240:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(775);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 241:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1174);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 242:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(796);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 243:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(795);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 244:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(266);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 245:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(851);
      if (lookahead == 'i') ADVANCE(849);
      if (lookahead == 'o') ADVANCE(181);
      if (lookahead == 's') ADVANCE(610);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 246:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(851);
      if (lookahead == 'o') ADVANCE(181);
      if (lookahead == 's') ADVANCE(610);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 247:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1064);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 248:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(781);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 249:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(384);
      if (lookahead == 'h') ADVANCE(1247);
      if (lookahead == 'm') ADVANCE(466);
      if (lookahead == 't') ADVANCE(615);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 250:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(267);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 251:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(386);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 252:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(1196);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 253:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(268);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 254:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(269);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 255:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(270);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 256:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(272);
      if (lookahead == 'i') ADVANCE(1236);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 257:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(273);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 258:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(274);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 259:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(275);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 260:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'a') ADVANCE(904);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 261:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(3685);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 262:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(3707);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 263:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(756);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 264:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(1008);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 265:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(488);
      if (lookahead == 'n') ADVANCE(365);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 266:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(761);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 267:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(763);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 268:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(764);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 269:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(765);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 270:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(767);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 271:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(653);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 272:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(768);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 273:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(769);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 274:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(770);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 275:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(771);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 276:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(792);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 277:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(3292);
      if (lookahead == 'e') ADVANCE(1154);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 278:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(171);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 279:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(3733);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 280:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(3385);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 281:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(3739);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 282:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(3524);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 283:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(3759);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 284:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(608);
      if (lookahead == 'o') ADVANCE(1002);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 285:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(602);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 286:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(128);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 287:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(997);
      if (lookahead == 'd') ADVANCE(342);
      if (lookahead == 'l') ADVANCE(791);
      if (lookahead == 'n') ADVANCE(343);
      if (lookahead == 'p') ADVANCE(975);
      if (lookahead == 's') ADVANCE(609);
      if (lookahead == 't') ADVANCE(911);
      if (lookahead == 'v') ADVANCE(222);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 288:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(997);
      if (lookahead == 'd') ADVANCE(388);
      if (lookahead == 'l') ADVANCE(625);
      if (lookahead == 'n') ADVANCE(343);
      if (lookahead == 'p') ADVANCE(975);
      if (lookahead == 'r') ADVANCE(590);
      if (lookahead == 's') ADVANCE(609);
      if (lookahead == 't') ADVANCE(911);
      if (lookahead == 'v') ADVANCE(222);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 289:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(997);
      if (lookahead == 'd') ADVANCE(388);
      if (lookahead == 'l') ADVANCE(791);
      if (lookahead == 'n') ADVANCE(343);
      if (lookahead == 'p') ADVANCE(975);
      if (lookahead == 's') ADVANCE(609);
      if (lookahead == 't') ADVANCE(911);
      if (lookahead == 'v') ADVANCE(222);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 290:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(603);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 291:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(707);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 292:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(698);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 293:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(574);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 294:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(612);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 295:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(699);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 296:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(616);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 297:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(700);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 298:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(604);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 299:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1217);
      if (lookahead == 'd') ADVANCE(1284);
      if (lookahead == 't') ADVANCE(1224);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 300:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(605);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 301:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(702);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 302:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(223);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 303:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1020);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 304:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(949);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 305:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1098);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 306:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(173);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 307:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1126);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 308:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(941);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 309:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(231);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 310:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1184);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 311:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(657);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 312:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(402);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 313:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(172);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 314:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1132);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 315:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(461);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 316:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(416);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 317:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1146);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 318:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(420);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 319:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(435);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 320:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(548);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 321:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(808);
      if (lookahead == 'm') ADVANCE(813);
      if (lookahead == 'n') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3257);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 322:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(808);
      if (lookahead == 'm') ADVANCE(813);
      if (lookahead == 'n') ADVANCE(166);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 323:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(808);
      if (lookahead == 'm') ADVANCE(813);
      if (lookahead == 'n') ADVANCE(167);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 324:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(808);
      if (lookahead == 'n') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3257);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 325:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(808);
      if (lookahead == 'n') ADVANCE(387);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 326:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(611);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 327:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(221);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 328:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(315);
      if (lookahead == 'l') ADVANCE(780);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 329:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1156);
      if (lookahead == 'l') ADVANCE(472);
      if (lookahead == 'q') ADVANCE(132);
      if (lookahead == 'x') ADVANCE(1118);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 330:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1156);
      if (lookahead == 'l') ADVANCE(472);
      if (lookahead == 'x') ADVANCE(1118);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 331:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1212);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 332:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(551);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 333:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1171);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 334:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(206);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 335:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1100);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 336:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(235);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 337:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(236);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 338:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1185);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 339:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(241);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 340:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(1200);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 341:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(342);
      if (lookahead == 'l') ADVANCE(625);
      if (lookahead == 'n') ADVANCE(343);
      if (lookahead == 'p') ADVANCE(975);
      if (lookahead == 'r') ADVANCE(590);
      if (lookahead == 's') ADVANCE(609);
      if (lookahead == 't') ADVANCE(911);
      if (lookahead == 'v') ADVANCE(222);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 342:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3680);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 343:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3687);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 344:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3312);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 345:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3705);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 346:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3605);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 347:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3689);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 348:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(898);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 349:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3209);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 350:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3340);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 351:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3577);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 352:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3388);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 353:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3508);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 354:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3136);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 355:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3579);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 356:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3591);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 357:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3364);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 358:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3472);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 359:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3430);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 360:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3394);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 361:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3757);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 362:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(345);
      if (lookahead == 'l') ADVANCE(1096);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 363:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(345);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 364:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(373);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 365:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(641);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 366:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(138);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 367:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(906);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 368:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(380);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 369:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(227);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 370:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(465);
      if (lookahead == 'o') ADVANCE(1067);
      if (lookahead == 'r') ADVANCE(483);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 371:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(465);
      if (lookahead == 'r') ADVANCE(483);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 372:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(1007);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 373:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(485);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 374:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(1010);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 375:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(474);
      if (lookahead == 'w') ADVANCE(645);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 376:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(499);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 377:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(506);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 378:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(200);
      if (lookahead == 'm') ADVANCE(917);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 379:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(200);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 380:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(1051);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 381:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(648);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 382:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(1066);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 383:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(1070);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 384:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(382);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 385:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(545);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 386:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(383);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 387:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(693);
      if (lookahead == 's') ADVANCE(511);
      if (lookahead == 't') ADVANCE(521);
      if (lookahead == 'v') ADVANCE(934);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 388:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(3681);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 389:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'd') ADVANCE(388);
      if (lookahead == 'l') ADVANCE(625);
      if (lookahead == 'n') ADVANCE(343);
      if (lookahead == 'r') ADVANCE(590);
      if (lookahead == 's') ADVANCE(609);
      if (lookahead == 't') ADVANCE(911);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 390:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(562);
      if (lookahead == 'i') ADVANCE(1086);
      if (lookahead == 'l') ADVANCE(708);
      if (lookahead == 'o') ADVANCE(1206);
      if (lookahead == 's') ADVANCE(907);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 391:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(562);
      if (lookahead == 'i') ADVANCE(1086);
      if (lookahead == 'l') ADVANCE(708);
      if (lookahead == 's') ADVANCE(907);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 392:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(187);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 393:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1019);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 394:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(396);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 395:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(801);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 396:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1275);
      if (lookahead == 'm') ADVANCE(3676);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 397:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3637);
      if (lookahead == 'l') ADVANCE(175);
      if (lookahead == 'n') ADVANCE(1222);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 398:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3637);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 399:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(299);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 400:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3626);
      if (lookahead == 'n') ADVANCE(279);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 401:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3629);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 402:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3616);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 403:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3610);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 404:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3221);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 405:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3547);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 406:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3566);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 407:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3352);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 408:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3251);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 409:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3545);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 410:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3337);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 411:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3361);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 412:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3400);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 413:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3403);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 414:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3091);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 415:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3457);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 416:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3103);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 417:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3358);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 418:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3296);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 419:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3406);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 420:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3275);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 421:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3303);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 422:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3334);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 423:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3502);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 424:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3367);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 425:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3379);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 426:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3370);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 427:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3496);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 428:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3624);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 429:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3349);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 430:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3538);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 431:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3306);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 432:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3622);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 433:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3442);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 434:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3469);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 435:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3418);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 436:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3513);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 437:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3130);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 438:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3391);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 439:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(186);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 440:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3761);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 441:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3763);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 442:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(3769);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 443:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(784);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 444:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(197);
      if (lookahead == 'i') ADVANCE(1235);
      if (lookahead == 'o') ADVANCE(744);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 445:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(197);
      if (lookahead == 'o') ADVANCE(745);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 446:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(996);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 447:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(579);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 448:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(178);
      if (lookahead == 'i') ADVANCE(739);
      if (lookahead == 'r') ADVANCE(662);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 449:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(178);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 450:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1154);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 451:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(558);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 452:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1257);
      if (lookahead == 't') ADVANCE(905);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 453:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(575);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 454:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(581);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 455:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(614);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 456:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(803);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 457:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(185);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 458:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(821);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 459:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1255);
      if (lookahead == 'i') ADVANCE(829);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 460:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(130);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 461:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1104);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 462:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(331);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 463:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(136);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 464:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(897);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 465:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(559);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 466:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(804);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 467:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1029);
      if (lookahead == 'r') ADVANCE(228);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 468:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(125);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 469:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1088);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 470:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(805);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 471:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1260);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 472:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(307);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 473:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(135);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 474:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(560);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 475:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(835);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 476:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(141);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 477:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 478:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1018);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 479:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(867);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 480:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(350);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 481:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1079);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 482:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(572);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 483:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(199);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 484:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(787);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 485:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(838);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 486:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(563);
      if (lookahead == 'l') ADVANCE(708);
      if (lookahead == 'o') ADVANCE(1206);
      if (lookahead == 's') ADVANCE(907);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 487:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(563);
      if (lookahead == 'l') ADVANCE(708);
      if (lookahead == 's') ADVANCE(907);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 488:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(718);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 489:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(333);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 490:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(591);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 491:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(353);
      if (lookahead == 's') ADVANCE(134);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 492:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(354);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 493:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(358);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 494:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(230);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 495:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(742);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 496:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(361);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 497:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1190);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 498:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1027);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 499:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1011);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 500:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1131);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 501:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1014);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 502:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1038);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 503:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1030);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 504:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(726);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 505:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1136);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 506:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(896);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 507:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(407);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 508:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(893);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 509:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1015);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 510:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(554);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 511:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1034);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 512:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1037);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 513:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1241);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 514:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(999);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 515:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1105);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 516:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(183);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 517:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(817);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 518:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1258);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 519:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(131);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 520:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(749);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 521:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1031);
      if (lookahead == 't') ADVANCE(945);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 522:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1089);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 523:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1061);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 524:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1039);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 525:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1259);
      if (lookahead == 'i') ADVANCE(901);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 526:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1259);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 527:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1091);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 528:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(876);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 529:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(864);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 530:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(825);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 531:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(297);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 532:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1049);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 533:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1092);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 534:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(314);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 535:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(877);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 536:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(819);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 537:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(940);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 538:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 539:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1045);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 540:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(317);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 541:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(879);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 542:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(204);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 543:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(880);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 544:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(882);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 545:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1055);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 546:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(1028);
      if (lookahead == 'i') ADVANCE(1086);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 547:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(822);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 548:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(336);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 549:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(827);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 550:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(828);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 551:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(258);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 552:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(798);
      if (lookahead == 'v') ADVANCE(207);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 553:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(800);
      if (lookahead == 'v') ADVANCE(248);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 554:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'e') ADVANCE(830);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 555:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(788);
      if (lookahead == 'i') ADVANCE(1178);
      if (lookahead == 'l') ADVANCE(909);
      if (lookahead == 'r') ADVANCE(3543);
      if (lookahead == 'u') ADVANCE(631);
      if (lookahead == 'y') ADVANCE(1025);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 556:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(788);
      if (lookahead == 'i') ADVANCE(1178);
      if (lookahead == 'l') ADVANCE(909);
      if (lookahead == 'r') ADVANCE(3543);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 557:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(3212);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 558:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(3487);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 559:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(3640);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 560:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(3535);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 561:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(3520);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 562:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(217);
      if (lookahead == 'r') ADVANCE(453);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 563:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(217);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 564:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(576);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 565:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(967);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 566:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(968);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 567:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(919);
      if (lookahead == 'n') ADVANCE(944);
      if (lookahead == 's') ADVANCE(669);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 568:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(1208);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 569:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(969);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 570:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(1122);
      if (lookahead == 't') ADVANCE(290);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 571:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(971);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 572:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(1082);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 573:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(515);
      if (lookahead == 'n') ADVANCE(674);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 574:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(624);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 575:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(532);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 576:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(762);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 577:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(685);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 578:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'f') ADVANCE(793);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 579:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(3559);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 580:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(3678);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 581:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(3481);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 582:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(3532);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 583:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(3587);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 584:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(3612);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 585:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(3113);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 586:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(3448);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 587:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(3397);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 588:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(3436);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 589:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(3439);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 590:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(816);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 591:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(57);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 592:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(871);
      if (lookahead == 't') ADVANCE(935);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 593:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(834);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 594:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(990);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 595:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(411);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 596:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(434);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 597:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(438);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 598:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(1214);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 599:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(528);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 600:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(1063);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 601:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'g') ADVANCE(824);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 602:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(986);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 603:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(3564);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 604:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(3575);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 605:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(3649);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 606:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(620);
      if (lookahead == 'o') ADVANCE(688);
      if (lookahead == 'p') ADVANCE(286);
      if (lookahead == 'r') ADVANCE(629);
      if (lookahead == 't') ADVANCE(1001);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 607:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(620);
      if (lookahead == 'o') ADVANCE(688);
      if (lookahead == 'r') ADVANCE(629);
      if (lookahead == 't') ADVANCE(1048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 608:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(580);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 609:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(1003);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 610:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(1004);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 611:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(584);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 612:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(531);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 613:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(247);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 614:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(678);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 615:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(1052);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 616:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'h') ADVANCE(255);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 617:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1178);
      if (lookahead == 'l') ADVANCE(909);
      if (lookahead == 'r') ADVANCE(3543);
      if (lookahead == 'u') ADVANCE(631);
      if (lookahead == 'y') ADVANCE(1025);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 618:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1178);
      if (lookahead == 'l') ADVANCE(909);
      if (lookahead == 'r') ADVANCE(3543);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 619:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1178);
      if (lookahead == 'r') ADVANCE(3543);
      if (lookahead == 'u') ADVANCE(631);
      if (lookahead == 'y') ADVANCE(1025);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 620:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(3589);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 621:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(570);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 622:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(3751);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 623:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(3749);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 624:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(3089);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 625:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(593);
      if (lookahead == 'l') ADVANCE(913);
      if (lookahead == 'w') ADVANCE(170);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 626:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1232);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 627:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(364);
      if (lookahead == 'o') ADVANCE(1114);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 628:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(364);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 629:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1235);
      if (lookahead == 'o') ADVANCE(1182);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 630:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1233);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 631:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(779);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 632:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1234);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 633:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1251);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 634:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(716);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 635:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1068);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 636:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(349);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 637:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(799);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 638:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(303);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 639:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1090);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 640:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(182);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 641:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(853);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 642:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(719);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 643:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(311);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 644:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(841);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 645:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(859);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 646:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(723);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 647:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(902);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 648:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(855);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 649:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(360);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 650:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(844);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 651:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(283);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 652:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(895);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 653:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(866);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 654:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(857);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 655:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(894);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 656:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(860);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 657:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1153);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 658:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1149);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 659:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1160);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 660:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1276);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 661:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(276);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 662:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1166);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 663:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1240);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 664:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(739);
      if (lookahead == 'r') ADVANCE(662);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 665:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(875);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 666:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(310);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 667:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(873);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 668:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1152);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 669:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1277);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 670:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1278);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 671:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1097);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 672:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(883);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 673:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(921);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 674:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1195);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 675:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1279);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 676:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(337);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 677:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(319);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 678:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(878);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 679:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1280);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 680:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1162);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 681:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1281);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 682:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(886);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 683:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1282);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 684:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(926);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 685:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(766);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 686:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(931);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 687:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1054);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 688:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1108);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 689:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(785);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 690:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(901);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 691:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1192);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 692:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(242);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 693:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1074);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 694:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1198);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 695:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'i') ADVANCE(1199);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 696:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'j') ADVANCE(1225);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 697:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'k') ADVANCE(3097);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 698:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'k') ADVANCE(3421);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 699:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'k') ADVANCE(3300);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 700:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'k') ADVANCE(3460);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 701:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'k') ADVANCE(3119);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 702:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'k') ADVANCE(3463);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 703:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'k') ADVANCE(958);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 704:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'k') ADVANCE(480);
      if (lookahead == 'n') ADVANCE(347);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 705:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'k') ADVANCE(475);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 706:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'k') ADVANCE(406);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 707:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'k') ADVANCE(218);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 708:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(459);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 709:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(557);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 710:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3656);
      if (lookahead == 's') ADVANCE(1116);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 711:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3656);
      if (lookahead == 's') ADVANCE(1170);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 712:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3662);
      if (lookahead == 'u') ADVANCE(564);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 713:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3600);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 714:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3672);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 715:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3632);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 716:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3594);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 717:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3484);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 718:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3234);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 719:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3598);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 720:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3511);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 721:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3122);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 722:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3094);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 723:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3596);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 724:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3125);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 725:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3517);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 726:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3765);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 727:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(3633);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 728:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1261);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 729:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'x') ADVANCE(1113);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 730:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'x') ADVANCE(1168);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 731:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(344);
      if (lookahead == 'm') ADVANCE(378);
      if (lookahead == 'n') ADVANCE(1238);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 732:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(344);
      if (lookahead == 'm') ADVANCE(379);
      if (lookahead == 'n') ADVANCE(1238);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 733:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(713);
      if (lookahead == 't') ADVANCE(285);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 734:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(713);
      if (lookahead == 't') ADVANCE(300);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 735:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1262);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 736:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1263);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 737:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(715);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 738:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1266);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 739:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(777);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 740:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 741:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1083);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 742:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(561);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 743:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1268);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 744:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(912);
      if (lookahead == 't') ADVANCE(489);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 745:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(912);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 746:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(175);
      if (lookahead == 'n') ADVANCE(1222);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 747:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(640);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 748:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(139);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 749:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(671);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 750:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(956);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 751:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(720);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 752:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(676);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 753:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1128);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 754:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(797);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 755:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(740);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 756:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(404);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 757:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(725);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 758:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(748);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 759:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(727);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 760:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(460);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 761:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(463);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 762:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(513);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 763:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(415);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 764:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(473);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 765:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(422);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 766:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(424);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 767:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(430);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 768:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(433);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 769:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(481);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 770:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(436);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 771:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(437);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 772:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(649);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 773:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(472);
      if (lookahead == 'q') ADVANCE(132);
      if (lookahead == 'x') ADVANCE(1118);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 774:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(643);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 775:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(658);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 776:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(959);
      if (lookahead == 'p') ADVANCE(1062);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 777:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1047);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 778:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1215);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 779:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1181);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 780:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(943);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 781:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1216);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 782:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(210);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 783:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(962);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 784:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(494);
      if (lookahead == 's') ADVANCE(1221);
      if (lookahead == 't') ADVANCE(3540);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 785:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1187);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 786:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1176);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 787:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(530);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 788:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(938);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 789:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(672);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 790:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(783);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 791:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(954);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 792:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(536);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 793:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(952);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 794:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(682);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 795:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(544);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 796:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(681);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 797:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(1111);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 798:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(549);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 799:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(253);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 800:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'l') ADVANCE(550);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 801:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(3660);
      if (lookahead == 't') ADVANCE(3493);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 802:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(3660);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 803:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(3658);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 804:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(928);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 805:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(143);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 806:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(965);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 807:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(1242);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 808:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(966);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 809:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(994);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 810:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(917);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 811:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(1252);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 812:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(1253);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 813:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(189);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 814:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(638);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 815:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(970);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 816:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(458);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 817:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(479);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 818:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(409);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 819:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(470);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 820:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(508);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 821:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(947);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 822:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(953);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 823:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(989);
      if (lookahead == 'n') ADVANCE(789);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 824:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(547);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 825:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(535);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 826:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(810);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 827:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(541);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 828:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(543);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 829:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(992);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 830:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'm') ADVANCE(995);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 831:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3697);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 832:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(375);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 833:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3703);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 834:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3282);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 835:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3248);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 836:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3116);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 837:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(126);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 838:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3134);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 839:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3643);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 840:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(491);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 841:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3309);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 842:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3286);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 843:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3376);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 844:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3346);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 845:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3288);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 846:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3382);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 847:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3319);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 848:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(3698);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 849:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(703);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 850:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(312);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 851:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(365);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 852:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(347);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 853:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(594);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 854:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(279);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 855:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(585);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 856:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(586);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 857:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(587);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 858:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(280);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 859:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(352);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 860:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(589);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 861:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(281);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 862:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(933);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 863:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(728);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 864:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(332);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 865:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(282);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 866:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(357);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 867:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1165);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 868:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(305);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 869:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(735);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 870:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(736);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 871:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(518);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 872:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(738);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 873:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 874:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(743);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 875:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(455);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 876:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1137);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 877:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1183);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 878:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1138);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 879:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1140);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 880:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1141);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 881:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(412);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 882:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1143);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 883:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(417);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 884:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(419);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 885:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(426);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 886:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(431);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 887:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1211);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 888:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(203);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 889:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(316);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 890:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(596);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 891:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(651);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 892:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(240);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 893:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1186);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 894:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1109);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 895:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1173);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 896:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(656);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 897:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(381);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 898:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(951);
      if (lookahead == 'o') ADVANCE(863);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 899:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(238);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 900:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(1229);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 901:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(680);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 902:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(794);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 903:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(694);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 904:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'n') ADVANCE(695);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 905:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1093);
      if (lookahead == 'r') ADVANCE(1220);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 906:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1246);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 907:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(123);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 908:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(525);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 909:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(291);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 910:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1114);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 911:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(814);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 912:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(598);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 913:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(278);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 914:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(193);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 915:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(577);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 916:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(600);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 917:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(836);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 918:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(372);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 919:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1024);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 920:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(839);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 921:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(842);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 922:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1058);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 923:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1009);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 924:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(856);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 925:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(690);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 926:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(845);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 927:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1013);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 928:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1022);
      if (lookahead == 't') ADVANCE(195);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 929:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1032);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 930:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1072);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 931:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(847);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 932:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(891);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 933:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1188);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 934:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(706);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 935:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(566);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 936:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1042);
      if (lookahead == 'r') ADVANCE(666);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 937:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1042);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 938:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(198);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 939:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(374);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 940:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(869);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 941:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(983);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 942:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1044);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 943:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(306);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 944:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(881);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 945:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(984);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 946:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(569);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 947:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(870);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 948:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1046);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 949:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(1237);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 950:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(667);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 951:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(884);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 952:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(213);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 953:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(874);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 954:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(313);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 955:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(885);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 956:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(205);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 957:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(652);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 958:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(889);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 959:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(334);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 960:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(892);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 961:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(526);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 962:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'o') ADVANCE(339);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 963:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(168);
      if (lookahead == 'r') ADVANCE(3691);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 964:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(3444);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 965:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(3585);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 966:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(3583);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 967:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(100);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 968:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(3747);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 969:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(3745);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 970:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(60);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 971:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(3454);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 972:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(988);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 973:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(116);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 974:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(1256);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 975:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(464);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 976:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(1033);
      if (lookahead == 't') ADVANCE(234);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 977:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(942);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 978:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(232);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 979:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(1151);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 980:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(169);
      if (lookahead == 'r') ADVANCE(3691);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 981:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(1115);
      if (lookahead == 'r') ADVANCE(3691);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 982:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(427);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 983:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(442);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 984:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(1159);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 985:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(1163);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 986:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(196);
      if (lookahead == 'r') ADVANCE(500);
      if (lookahead == 's') ADVANCE(1243);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 987:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(752);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 988:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(201);
      if (lookahead == 'r') ADVANCE(505);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 989:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(774);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 990:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(202);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 991:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(957);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 992:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(948);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 993:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(239);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 994:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(1202);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 995:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'p') ADVANCE(1204);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 996:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'q') ADVANCE(3451);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 997:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'q') ADVANCE(144);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 998:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'q') ADVANCE(1213);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 999:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'q') ADVANCE(1223);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1000:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3691);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1001:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3254);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1002:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3693);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1003:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3670);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1004:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3668);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1005:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3581);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1006:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3753);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1007:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3101);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1008:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3549);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1009:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3528);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1010:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3107);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1011:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3781);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1012:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3618);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1013:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3557);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1014:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3646);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1015:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(3652);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1016:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(1106);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1017:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(582);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1018:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(595);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1019:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(908);
      if (lookahead == 'x') ADVANCE(1119);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1020:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(807);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1021:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(583);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1022:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(1265);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1023:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(1191);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1024:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(568);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1025:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(451);
      if (lookahead == 'v') ADVANCE(192);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1026:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(228);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1027:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(137);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1028:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(453);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1029:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(837);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1030:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1031:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(888);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1032:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(133);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1033:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(916);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1034:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(1125);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1035:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(840);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1036:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(1065);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1037:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(961);
      if (lookahead == 'x') ADVANCE(1119);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1038:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(233);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1039:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(925);
      if (lookahead == 'x') ADVANCE(1119);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1040:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(843);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1041:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(507);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1042:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(403);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1043:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(846);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1044:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(1134);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1045:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(899);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1046:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(1135);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1047:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(497);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1048:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(1155);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1049:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(529);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1050:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(423);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1051:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(469);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1052:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(542);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1053:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(482);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1054:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(440);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1055:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(496);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1056:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(483);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1057:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(1101);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1058:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(376);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1059:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(915);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1060:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(208);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1061:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(599);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1062:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(510);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1063:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(522);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1064:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(377);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1065:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(923);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1066:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(527);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1067:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(385);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1068:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(534);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1069:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(504);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1070:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(533);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1071:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(924);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1072:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(142);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1073:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(1228);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1074:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(540);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1075:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(601);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1076:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(3499);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1077:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(3654);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1078:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(3466);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1079:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(3343);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1080:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(3424);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1081:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(3433);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1082:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(3373);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1083:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(55);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1084:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1272);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1085:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(978);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1086:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(244);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1087:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1117);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1088:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1077);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1089:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1078);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1090:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(146);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1091:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1080);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1092:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1081);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1093:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(622);
      if (lookahead == 'u') ADVANCE(623);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1094:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1127);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1095:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(661);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1096:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(401);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1097:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1180);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1098:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(308);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1099:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1139);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1100:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1144);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1101:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(425);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1102:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(490);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1103:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(441);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1104:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1095);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1105:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1158);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1106:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(960);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1107:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(260);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1108:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(920);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1109:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1167);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1110:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(647);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1111:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1197);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1112:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(993);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1113:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(467);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1114:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3322);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1115:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(567);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1116:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(976);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1117:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3505);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1118:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3737);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1119:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3735);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1120:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3218);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1121:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3741);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1122:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(184);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1123:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3215);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1124:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3290);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1125:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(552);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1126:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3555);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1127:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3731);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1128:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3132);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1129:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3478);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1130:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3475);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1131:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3573);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1132:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(52);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1133:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3755);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1134:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3140);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1135:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3138);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1136:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3570);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1137:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3316);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1138:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3331);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1139:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3743);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1140:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3553);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1141:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3551);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1142:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3355);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1143:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3128);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1144:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(3767);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1145:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(256);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1146:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(264);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1147:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(1271);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1148:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(935);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1149:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(1264);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1150:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(945);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1151:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(1226);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1152:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(290);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1153:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(578);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1154:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(484);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1155:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(950);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1156:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(673);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1157:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(1071);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1158:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(219);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1159:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(1006);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1160:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(298);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1161:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(174);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1162:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(692);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1163:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(1012);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1164:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(741);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1165:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(1147);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1166:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(537);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1167:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(1073);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1168:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(1026);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1169:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(414);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1170:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(1194);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1171:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(492);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1172:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(429);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1173:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(498);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1174:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(493);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1175:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(539);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1176:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(509);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1177:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(191);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1178:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(302);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1179:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(1244);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1180:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(922);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1181:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(644);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1182:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(489);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1183:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(985);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1184:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1185:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(927);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1186:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(252);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1187:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(650);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1188:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(932);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1189:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(946);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1190:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(1227);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1191:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(691);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1192:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(684);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1193:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(226);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1194:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(234);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1195:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(670);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1196:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(686);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1197:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(237);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1198:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(679);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1199:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(683);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1200:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(553);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1201:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(250);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1202:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(254);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1203:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(257);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1204:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(259);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1205:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(400);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1206:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(263);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1207:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(262);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1208:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(1274);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1209:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(987);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1210:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(714);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1211:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(972);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1212:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(782);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1213:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(408);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1214:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(418);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1215:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(428);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1216:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(432);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1217:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(1057);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1218:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(753);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1219:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(809);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1220:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(861);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1221:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(818);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1222:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(751);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1223:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(663);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1224:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(1040);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1225:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(815);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1226:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(1050);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1227:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(1043);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1228:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(820);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1229:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(757);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1230:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(854);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1231:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(689);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1232:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'v') ADVANCE(3674);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1233:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'v') ADVANCE(3666);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1234:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'v') ADVANCE(3664);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1235:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'v') ADVANCE(225);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1236:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'v') ADVANCE(476);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1237:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'v') ADVANCE(502);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1238:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'v') ADVANCE(523);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1239:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'v') ADVANCE(209);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1240:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'v') ADVANCE(243);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1241:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'v') ADVANCE(538);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1242:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'w') ADVANCE(3614);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1243:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'w') ADVANCE(659);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1244:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'w') ADVANCE(677);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1245:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'w') ADVANCE(516);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1246:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'w') ADVANCE(309);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1247:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'w') ADVANCE(251);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1248:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(3695);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1249:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(1285);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1250:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(3701);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1251:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(3294);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1252:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(3244);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1253:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(3240);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1254:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(1113);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1255:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(977);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1256:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(326);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1257:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(1121);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1258:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(1129);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1259:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(1130);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1260:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(1175);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1261:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'y') ADVANCE(3409);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1262:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'y') ADVANCE(3412);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1263:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'y') ADVANCE(3415);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1264:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'y') ADVANCE(3298);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1265:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'y') ADVANCE(3427);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1266:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'y') ADVANCE(3325);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1267:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'y') ADVANCE(3110);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1268:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'y') ADVANCE(3328);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1269:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'y') ADVANCE(271);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1270:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'y') ADVANCE(1110);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1271:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'y') ADVANCE(982);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1272:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'y') ADVANCE(865);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1273:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'z') ADVANCE(1269);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 1274:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'z') ADVANCE(1283);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 1275:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'z') ADVANCE(405);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 1276:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'z') ADVANCE(410);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 1277:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'z') ADVANCE(413);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 1278:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'z') ADVANCE(468);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 1279:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'z') ADVANCE(421);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 1280:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'z') ADVANCE(519);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 1281:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'z') ADVANCE(501);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 1282:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'z') ADVANCE(503);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 1283:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'z') ADVANCE(654);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 1284:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'z') ADVANCE(955);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1290);
      END_STATE();
    case 1285:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'H' ||
          ('K' <= lookahead && lookahead <= 'M') ||
          lookahead == 'R') ADVANCE(1289);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(3071);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1286:
      if (lookahead == ':') ADVANCE(3048);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3061);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1287:
      if (lookahead == ':') ADVANCE(3048);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3075);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1288:
      if (lookahead == ':') ADVANCE(3048);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3066);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1289:
      if (lookahead == ':') ADVANCE(3048);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(3071);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1290:
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 1291:
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1291)
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 1292:
      if (lookahead == '>') ADVANCE(3263);
      END_STATE();
    case 1293:
      if (lookahead == '_') ADVANCE(2021);
      END_STATE();
    case 1294:
      if (lookahead == '_') ADVANCE(2334);
      END_STATE();
    case 1295:
      if (lookahead == '_') ADVANCE(2210);
      END_STATE();
    case 1296:
      if (lookahead == '_') ADVANCE(1490);
      END_STATE();
    case 1297:
      if (lookahead == '_') ADVANCE(1528);
      END_STATE();
    case 1298:
      if (lookahead == '_') ADVANCE(1373);
      END_STATE();
    case 1299:
      if (lookahead == '_') ADVANCE(1434);
      END_STATE();
    case 1300:
      if (lookahead == '_') ADVANCE(3016);
      END_STATE();
    case 1301:
      if (lookahead == '_') ADVANCE(3017);
      END_STATE();
    case 1302:
      if (lookahead == '_') ADVANCE(2956);
      if (lookahead == 'a') ADVANCE(2244);
      END_STATE();
    case 1303:
      if (lookahead == '_') ADVANCE(2956);
      if (lookahead == 'a') ADVANCE(2251);
      END_STATE();
    case 1304:
      if (lookahead == '_') ADVANCE(3019);
      END_STATE();
    case 1305:
      if (lookahead == '_') ADVANCE(3020);
      END_STATE();
    case 1306:
      if (lookahead == '_') ADVANCE(2028);
      END_STATE();
    case 1307:
      if (lookahead == '_') ADVANCE(3021);
      END_STATE();
    case 1308:
      if (lookahead == '_') ADVANCE(3021);
      if (lookahead == 'd') ADVANCE(2200);
      END_STATE();
    case 1309:
      if (lookahead == '_') ADVANCE(1611);
      if (lookahead == 'n') ADVANCE(1789);
      END_STATE();
    case 1310:
      if (lookahead == '_') ADVANCE(3022);
      END_STATE();
    case 1311:
      if (lookahead == '_') ADVANCE(3023);
      END_STATE();
    case 1312:
      if (lookahead == '_') ADVANCE(2098);
      END_STATE();
    case 1313:
      if (lookahead == '_') ADVANCE(3024);
      END_STATE();
    case 1314:
      if (lookahead == '_') ADVANCE(2774);
      END_STATE();
    case 1315:
      if (lookahead == '_') ADVANCE(1673);
      END_STATE();
    case 1316:
      if (lookahead == '_') ADVANCE(2707);
      END_STATE();
    case 1317:
      if (lookahead == '_') ADVANCE(2133);
      END_STATE();
    case 1318:
      if (lookahead == '_') ADVANCE(1633);
      END_STATE();
    case 1319:
      if (lookahead == '_') ADVANCE(2864);
      END_STATE();
    case 1320:
      if (lookahead == '_') ADVANCE(2483);
      END_STATE();
    case 1321:
      if (lookahead == '_') ADVANCE(1883);
      END_STATE();
    case 1322:
      if (lookahead == '_') ADVANCE(1435);
      END_STATE();
    case 1323:
      if (lookahead == '_') ADVANCE(2913);
      END_STATE();
    case 1324:
      if (lookahead == '_') ADVANCE(2913);
      if (lookahead == 'd') ADVANCE(2986);
      if (lookahead == 'e') ADVANCE(2972);
      END_STATE();
    case 1325:
      if (lookahead == '_') ADVANCE(2618);
      END_STATE();
    case 1326:
      if (lookahead == '_') ADVANCE(2704);
      if (lookahead == 'u') ADVANCE(2184);
      END_STATE();
    case 1327:
      if (lookahead == '_') ADVANCE(1613);
      END_STATE();
    case 1328:
      if (lookahead == '_') ADVANCE(1464);
      END_STATE();
    case 1329:
      if (lookahead == '_') ADVANCE(2540);
      if (lookahead == 'o') ADVANCE(2455);
      END_STATE();
    case 1330:
      if (lookahead == '_') ADVANCE(1666);
      END_STATE();
    case 1331:
      if (lookahead == '_') ADVANCE(2209);
      END_STATE();
    case 1332:
      if (lookahead == '_') ADVANCE(2154);
      END_STATE();
    case 1333:
      if (lookahead == '_') ADVANCE(2332);
      END_STATE();
    case 1334:
      if (lookahead == '_') ADVANCE(2045);
      END_STATE();
    case 1335:
      if (lookahead == '_') ADVANCE(1485);
      END_STATE();
    case 1336:
      if (lookahead == '_') ADVANCE(2950);
      END_STATE();
    case 1337:
      if (lookahead == '_') ADVANCE(1529);
      END_STATE();
    case 1338:
      if (lookahead == '_') ADVANCE(2362);
      END_STATE();
    case 1339:
      if (lookahead == 'a') ADVANCE(2656);
      if (lookahead == 'c') ADVANCE(2626);
      if (lookahead == 'd') ADVANCE(1691);
      if (lookahead == 'f') ADVANCE(2408);
      if (lookahead == 'l') ADVANCE(2103);
      if (lookahead == 'm') ADVANCE(1720);
      if (lookahead == 'n') ADVANCE(1693);
      if (lookahead == 'p') ADVANCE(2599);
      if (lookahead == 'r') ADVANCE(1604);
      if (lookahead == 's') ADVANCE(2091);
      if (lookahead == 't') ADVANCE(2511);
      if (lookahead == 'v') ADVANCE(1473);
      END_STATE();
    case 1340:
      if (lookahead == 'a') ADVANCE(2656);
      if (lookahead == 'c') ADVANCE(2626);
      if (lookahead == 'd') ADVANCE(1750);
      if (lookahead == 'f') ADVANCE(2408);
      if (lookahead == 'l') ADVANCE(2128);
      if (lookahead == 'm') ADVANCE(1720);
      if (lookahead == 'n') ADVANCE(2991);
      if (lookahead == 'p') ADVANCE(2599);
      if (lookahead == 'r') ADVANCE(1604);
      if (lookahead == 't') ADVANCE(2827);
      if (lookahead == 'v') ADVANCE(1473);
      END_STATE();
    case 1341:
      if (lookahead == 'a') ADVANCE(2656);
      if (lookahead == 'c') ADVANCE(2626);
      if (lookahead == 'd') ADVANCE(1718);
      if (lookahead == 'l') ADVANCE(2128);
      if (lookahead == 'm') ADVANCE(1720);
      if (lookahead == 'n') ADVANCE(1695);
      if (lookahead == 'p') ADVANCE(2599);
      if (lookahead == 'r') ADVANCE(2062);
      if (lookahead == 't') ADVANCE(2827);
      if (lookahead == 'v') ADVANCE(1473);
      END_STATE();
    case 1342:
      if (lookahead == 'a') ADVANCE(2656);
      if (lookahead == 'c') ADVANCE(2626);
      if (lookahead == 'd') ADVANCE(1768);
      if (lookahead == 'l') ADVANCE(2128);
      if (lookahead == 'm') ADVANCE(1720);
      if (lookahead == 'n') ADVANCE(1695);
      if (lookahead == 'p') ADVANCE(2599);
      if (lookahead == 'r') ADVANCE(2062);
      if (lookahead == 's') ADVANCE(2090);
      if (lookahead == 'v') ADVANCE(1473);
      END_STATE();
    case 1343:
      if (lookahead == 'a') ADVANCE(2656);
      if (lookahead == 'd') ADVANCE(1691);
      if (lookahead == 'l') ADVANCE(2128);
      if (lookahead == 'm') ADVANCE(1720);
      if (lookahead == 'n') ADVANCE(1695);
      if (lookahead == 'p') ADVANCE(2599);
      if (lookahead == 'r') ADVANCE(2062);
      if (lookahead == 's') ADVANCE(2090);
      if (lookahead == 'v') ADVANCE(1473);
      END_STATE();
    case 1344:
      if (lookahead == 'a') ADVANCE(1722);
      if (lookahead == 'c') ADVANCE(2378);
      if (lookahead == 'd') ADVANCE(2110);
      if (lookahead == 'e') ADVANCE(2433);
      if (lookahead == 'i') ADVANCE(2331);
      if (lookahead == 'l') ADVANCE(2512);
      if (lookahead == 'm') ADVANCE(2905);
      if (lookahead == 'n') ADVANCE(1866);
      if (lookahead == 'p') ADVANCE(97);
      if (lookahead == 'r') ADVANCE(1776);
      if (lookahead == 's') ADVANCE(2903);
      END_STATE();
    case 1345:
      if (lookahead == 'a') ADVANCE(1555);
      if (lookahead == 'i') ADVANCE(2409);
      if (lookahead == 'o') ADVANCE(1416);
      if (lookahead == 's') ADVANCE(2093);
      END_STATE();
    case 1346:
      if (lookahead == 'a') ADVANCE(2221);
      if (lookahead == 'e') ADVANCE(3710);
      if (lookahead == 'i') ADVANCE(2431);
      if (lookahead == 'n') ADVANCE(1409);
      if (lookahead == 'o') ADVANCE(44);
      if (lookahead == 's') ADVANCE(2952);
      if (lookahead == 'u') ADVANCE(2272);
      END_STATE();
    case 1347:
      if (lookahead == 'a') ADVANCE(2221);
      if (lookahead == 'e') ADVANCE(2742);
      if (lookahead == 'i') ADVANCE(2431);
      if (lookahead == 'n') ADVANCE(1409);
      if (lookahead == 'o') ADVANCE(46);
      if (lookahead == 's') ADVANCE(2952);
      if (lookahead == 'u') ADVANCE(2272);
      END_STATE();
    case 1348:
      if (lookahead == 'a') ADVANCE(2221);
      if (lookahead == 'e') ADVANCE(2742);
      if (lookahead == 'o') ADVANCE(47);
      if (lookahead == 'u') ADVANCE(2271);
      END_STATE();
    case 1349:
      if (lookahead == 'a') ADVANCE(2221);
      if (lookahead == 'e') ADVANCE(2742);
      if (lookahead == 'o') ADVANCE(45);
      if (lookahead == 'u') ADVANCE(2271);
      END_STATE();
    case 1350:
      if (lookahead == 'a') ADVANCE(2221);
      if (lookahead == 'e') ADVANCE(2742);
      if (lookahead == 'o') ADVANCE(48);
      if (lookahead == 'u') ADVANCE(2309);
      END_STATE();
    case 1351:
      if (lookahead == 'a') ADVANCE(2120);
      if (lookahead == 'h') ADVANCE(2677);
      if (lookahead == 'o') ADVANCE(3567);
      if (lookahead == 'r') ADVANCE(2119);
      if (lookahead == 'y') ADVANCE(2603);
      END_STATE();
    case 1352:
      if (lookahead == 'a') ADVANCE(2120);
      if (lookahead == 'o') ADVANCE(3567);
      if (lookahead == 'r') ADVANCE(2901);
      END_STATE();
    case 1353:
      if (lookahead == 'a') ADVANCE(1322);
      if (lookahead == 'o') ADVANCE(2122);
      if (lookahead == 's') ADVANCE(1674);
      END_STATE();
    case 1354:
      if (lookahead == 'a') ADVANCE(1322);
      if (lookahead == 'o') ADVANCE(2121);
      if (lookahead == 's') ADVANCE(1685);
      END_STATE();
    case 1355:
      if (lookahead == 'a') ADVANCE(1665);
      if (lookahead == 'b') ADVANCE(2518);
      if (lookahead == 'd') ADVANCE(2177);
      if (lookahead == 'i') ADVANCE(2840);
      if (lookahead == 'l') ADVANCE(2171);
      if (lookahead == 'r') ADVANCE(1432);
      if (lookahead == 's') ADVANCE(1951);
      if (lookahead == 't') ADVANCE(1788);
      if (lookahead == 'v') ADVANCE(2516);
      END_STATE();
    case 1356:
      if (lookahead == 'a') ADVANCE(1665);
      if (lookahead == 'b') ADVANCE(2518);
      if (lookahead == 'd') ADVANCE(2203);
      if (lookahead == 'l') ADVANCE(2171);
      if (lookahead == 'r') ADVANCE(1432);
      END_STATE();
    case 1357:
      if (lookahead == 'a') ADVANCE(1665);
      if (lookahead == 'b') ADVANCE(2518);
      if (lookahead == 'd') ADVANCE(2203);
      if (lookahead == 'l') ADVANCE(2171);
      if (lookahead == 'r') ADVANCE(1872);
      if (lookahead == 's') ADVANCE(1951);
      if (lookahead == 't') ADVANCE(1860);
      END_STATE();
    case 1358:
      if (lookahead == 'a') ADVANCE(1665);
      if (lookahead == 'd') ADVANCE(2177);
      if (lookahead == 'l') ADVANCE(2171);
      if (lookahead == 'r') ADVANCE(1872);
      if (lookahead == 's') ADVANCE(1951);
      if (lookahead == 't') ADVANCE(2002);
      if (lookahead == 'v') ADVANCE(2516);
      END_STATE();
    case 1359:
      if (lookahead == 'a') ADVANCE(1665);
      if (lookahead == 'd') ADVANCE(2203);
      if (lookahead == 'l') ADVANCE(2171);
      if (lookahead == 'r') ADVANCE(1872);
      END_STATE();
    case 1360:
      if (lookahead == 'a') ADVANCE(1665);
      if (lookahead == 'd') ADVANCE(2203);
      if (lookahead == 'l') ADVANCE(2171);
      if (lookahead == 'r') ADVANCE(1872);
      if (lookahead == 's') ADVANCE(1951);
      if (lookahead == 't') ADVANCE(1860);
      END_STATE();
    case 1361:
      if (lookahead == 'a') ADVANCE(1665);
      if (lookahead == 'd') ADVANCE(2203);
      if (lookahead == 'l') ADVANCE(2171);
      if (lookahead == 'r') ADVANCE(1872);
      if (lookahead == 's') ADVANCE(1951);
      if (lookahead == 't') ADVANCE(2002);
      END_STATE();
    case 1362:
      if (lookahead == 'a') ADVANCE(1665);
      if (lookahead == 'd') ADVANCE(2203);
      if (lookahead == 'l') ADVANCE(2171);
      if (lookahead == 'r') ADVANCE(1872);
      if (lookahead == 't') ADVANCE(1859);
      END_STATE();
    case 1363:
      if (lookahead == 'a') ADVANCE(1701);
      if (lookahead == 'l') ADVANCE(1902);
      if (lookahead == 's') ADVANCE(2926);
      if (lookahead == 't') ADVANCE(3541);
      END_STATE();
    case 1364:
      if (lookahead == 'a') ADVANCE(1701);
      if (lookahead == 'l') ADVANCE(1902);
      if (lookahead == 't') ADVANCE(2921);
      END_STATE();
    case 1365:
      if (lookahead == 'a') ADVANCE(1701);
      if (lookahead == 's') ADVANCE(2926);
      if (lookahead == 't') ADVANCE(3541);
      END_STATE();
    case 1366:
      if (lookahead == 'a') ADVANCE(1701);
      if (lookahead == 't') ADVANCE(2921);
      END_STATE();
    case 1367:
      if (lookahead == 'a') ADVANCE(2988);
      END_STATE();
    case 1368:
      if (lookahead == 'a') ADVANCE(3602);
      if (lookahead == 's') ADVANCE(2181);
      END_STATE();
    case 1369:
      if (lookahead == 'a') ADVANCE(3189);
      if (lookahead == 'c') ADVANCE(3175);
      if (lookahead == 'e') ADVANCE(3188);
      if (lookahead == 's') ADVANCE(3179);
      if (lookahead == 't') ADVANCE(3174);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 1370:
      if (lookahead == 'a') ADVANCE(3489);
      END_STATE();
    case 1371:
      if (lookahead == 'a') ADVANCE(3236);
      END_STATE();
    case 1372:
      if (lookahead == 'a') ADVANCE(2035);
      if (lookahead == 'e') ADVANCE(1669);
      if (lookahead == 'h') ADVANCE(1423);
      if (lookahead == 'i') ADVANCE(2065);
      if (lookahead == 'o') ADVANCE(2920);
      if (lookahead == 'p') ADVANCE(1880);
      if (lookahead == 'r') ADVANCE(1948);
      if (lookahead == 's') ADVANCE(2581);
      if (lookahead == 't') ADVANCE(2662);
      if (lookahead == 'w') ADVANCE(2167);
      END_STATE();
    case 1373:
      if (lookahead == 'a') ADVANCE(3155);
      if (lookahead == 'f') ADVANCE(3157);
      if (lookahead == 'm') ADVANCE(3156);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(3160);
      END_STATE();
    case 1374:
      if (lookahead == 'a') ADVANCE(1554);
      if (lookahead == 'i') ADVANCE(2409);
      if (lookahead == 'o') ADVANCE(1415);
      if (lookahead == 's') ADVANCE(2093);
      END_STATE();
    case 1375:
      if (lookahead == 'a') ADVANCE(1721);
      if (lookahead == 'c') ADVANCE(2378);
      if (lookahead == 'd') ADVANCE(2110);
      if (lookahead == 'i') ADVANCE(2331);
      if (lookahead == 'l') ADVANCE(2512);
      if (lookahead == 'm') ADVANCE(2905);
      if (lookahead == 'n') ADVANCE(1866);
      if (lookahead == 'p') ADVANCE(97);
      if (lookahead == 'r') ADVANCE(1891);
      if (lookahead == 's') ADVANCE(2903);
      END_STATE();
    case 1376:
      if (lookahead == 'a') ADVANCE(1721);
      if (lookahead == 'c') ADVANCE(2378);
      if (lookahead == 'd') ADVANCE(2110);
      if (lookahead == 'l') ADVANCE(2512);
      if (lookahead == 'm') ADVANCE(2905);
      if (lookahead == 'n') ADVANCE(1866);
      if (lookahead == 'p') ADVANCE(97);
      if (lookahead == 'r') ADVANCE(1891);
      if (lookahead == 's') ADVANCE(2903);
      END_STATE();
    case 1377:
      if (lookahead == 'a') ADVANCE(1721);
      if (lookahead == 'c') ADVANCE(2378);
      if (lookahead == 'd') ADVANCE(2110);
      if (lookahead == 'm') ADVANCE(2905);
      if (lookahead == 'n') ADVANCE(1866);
      if (lookahead == 'p') ADVANCE(1870);
      if (lookahead == 'r') ADVANCE(1891);
      if (lookahead == 's') ADVANCE(2903);
      END_STATE();
    case 1378:
      if (lookahead == 'a') ADVANCE(1556);
      if (lookahead == 'i') ADVANCE(2409);
      if (lookahead == 'o') ADVANCE(1681);
      if (lookahead == 's') ADVANCE(2093);
      END_STATE();
    case 1379:
      if (lookahead == 'a') ADVANCE(2697);
      if (lookahead == 'e') ADVANCE(2655);
      if (lookahead == 'h') ADVANCE(2105);
      if (lookahead == 'o') ADVANCE(2195);
      if (lookahead == 'p') ADVANCE(1606);
      if (lookahead == 'r') ADVANCE(1780);
      if (lookahead == 't') ADVANCE(2635);
      END_STATE();
    case 1380:
      if (lookahead == 'a') ADVANCE(2697);
      if (lookahead == 'e') ADVANCE(2655);
      if (lookahead == 'h') ADVANCE(2105);
      if (lookahead == 'o') ADVANCE(2195);
      if (lookahead == 'p') ADVANCE(1606);
      if (lookahead == 'r') ADVANCE(1857);
      if (lookahead == 't') ADVANCE(2634);
      END_STATE();
    case 1381:
      if (lookahead == 'a') ADVANCE(2697);
      if (lookahead == 'e') ADVANCE(2655);
      if (lookahead == 'o') ADVANCE(2195);
      if (lookahead == 'p') ADVANCE(1606);
      if (lookahead == 'r') ADVANCE(1857);
      if (lookahead == 't') ADVANCE(2634);
      END_STATE();
    case 1382:
      if (lookahead == 'a') ADVANCE(2697);
      if (lookahead == 'e') ADVANCE(2655);
      if (lookahead == 'p') ADVANCE(1606);
      if (lookahead == 'r') ADVANCE(1858);
      if (lookahead == 't') ADVANCE(2653);
      END_STATE();
    case 1383:
      if (lookahead == 'a') ADVANCE(2866);
      if (lookahead == 'e') ADVANCE(1608);
      if (lookahead == 'i') ADVANCE(2739);
      if (lookahead == 'l') ADVANCE(2254);
      if (lookahead == 'o') ADVANCE(2902);
      if (lookahead == 's') ADVANCE(2514);
      END_STATE();
    case 1384:
      if (lookahead == 'a') ADVANCE(2960);
      if (lookahead == 'e') ADVANCE(2828);
      if (lookahead == 'i') ADVANCE(2410);
      if (lookahead == 'o') ADVANCE(1749);
      if (lookahead == 's') ADVANCE(2580);
      if (lookahead == 'u') ADVANCE(2229);
      END_STATE();
    case 1385:
      if (lookahead == 'a') ADVANCE(2960);
      if (lookahead == 'e') ADVANCE(2828);
      if (lookahead == 'i') ADVANCE(2410);
      if (lookahead == 'o') ADVANCE(1749);
      if (lookahead == 's') ADVANCE(2580);
      if (lookahead == 'u') ADVANCE(2762);
      END_STATE();
    case 1386:
      if (lookahead == 'a') ADVANCE(2960);
      if (lookahead == 'e') ADVANCE(2828);
      if (lookahead == 'i') ADVANCE(2410);
      if (lookahead == 'o') ADVANCE(1748);
      if (lookahead == 'u') ADVANCE(2229);
      END_STATE();
    case 1387:
      if (lookahead == 'a') ADVANCE(2960);
      if (lookahead == 'e') ADVANCE(2828);
      if (lookahead == 'i') ADVANCE(2410);
      if (lookahead == 'o') ADVANCE(1748);
      if (lookahead == 'u') ADVANCE(2230);
      END_STATE();
    case 1388:
      if (lookahead == 'a') ADVANCE(2960);
      if (lookahead == 'e') ADVANCE(2828);
      if (lookahead == 'i') ADVANCE(2410);
      if (lookahead == 'o') ADVANCE(2432);
      if (lookahead == 's') ADVANCE(2580);
      if (lookahead == 'u') ADVANCE(2230);
      END_STATE();
    case 1389:
      if (lookahead == 'a') ADVANCE(2960);
      if (lookahead == 'e') ADVANCE(2828);
      if (lookahead == 'i') ADVANCE(2410);
      if (lookahead == 's') ADVANCE(2580);
      if (lookahead == 'u') ADVANCE(2230);
      END_STATE();
    case 1390:
      if (lookahead == 'a') ADVANCE(2960);
      if (lookahead == 'e') ADVANCE(2828);
      if (lookahead == 'i') ADVANCE(2429);
      if (lookahead == 'o') ADVANCE(1749);
      if (lookahead == 'u') ADVANCE(2228);
      END_STATE();
    case 1391:
      if (lookahead == 'a') ADVANCE(2960);
      if (lookahead == 'e') ADVANCE(2828);
      if (lookahead == 'i') ADVANCE(2429);
      if (lookahead == 'u') ADVANCE(2228);
      END_STATE();
    case 1392:
      if (lookahead == 'a') ADVANCE(2960);
      if (lookahead == 'i') ADVANCE(2429);
      if (lookahead == 'u') ADVANCE(2228);
      END_STATE();
    case 1393:
      if (lookahead == 'a') ADVANCE(1724);
      if (lookahead == 'c') ADVANCE(2378);
      if (lookahead == 'd') ADVANCE(2110);
      if (lookahead == 'i') ADVANCE(2331);
      if (lookahead == 'l') ADVANCE(2512);
      if (lookahead == 'm') ADVANCE(2905);
      if (lookahead == 'n') ADVANCE(1866);
      if (lookahead == 'p') ADVANCE(97);
      if (lookahead == 'r') ADVANCE(1891);
      if (lookahead == 's') ADVANCE(2903);
      END_STATE();
    case 1394:
      if (lookahead == 'a') ADVANCE(1724);
      if (lookahead == 'c') ADVANCE(2378);
      if (lookahead == 'd') ADVANCE(2110);
      if (lookahead == 'l') ADVANCE(2512);
      if (lookahead == 'm') ADVANCE(2905);
      if (lookahead == 'n') ADVANCE(1866);
      if (lookahead == 'p') ADVANCE(97);
      if (lookahead == 'r') ADVANCE(1891);
      if (lookahead == 's') ADVANCE(2903);
      END_STATE();
    case 1395:
      if (lookahead == 'a') ADVANCE(2253);
      if (lookahead == 'l') ADVANCE(2512);
      if (lookahead == 'p') ADVANCE(96);
      END_STATE();
    case 1396:
      if (lookahead == 'a') ADVANCE(2212);
      END_STATE();
    case 1397:
      if (lookahead == 'a') ADVANCE(2212);
      if (lookahead == 'b') ADVANCE(2223);
      END_STATE();
    case 1398:
      if (lookahead == 'a') ADVANCE(1725);
      if (lookahead == 'l') ADVANCE(2512);
      if (lookahead == 'p') ADVANCE(96);
      if (lookahead == 's') ADVANCE(2903);
      END_STATE();
    case 1399:
      if (lookahead == 'a') ADVANCE(2987);
      END_STATE();
    case 1400:
      if (lookahead == 'a') ADVANCE(2993);
      END_STATE();
    case 1401:
      if (lookahead == 'a') ADVANCE(2631);
      END_STATE();
    case 1402:
      if (lookahead == 'a') ADVANCE(2631);
      if (lookahead == 't') ADVANCE(2027);
      END_STATE();
    case 1403:
      if (lookahead == 'a') ADVANCE(2227);
      END_STATE();
    case 1404:
      if (lookahead == 'a') ADVANCE(2227);
      if (lookahead == 'h') ADVANCE(2943);
      if (lookahead == 'i') ADVANCE(1726);
      if (lookahead == 'o') ADVANCE(2783);
      END_STATE();
    case 1405:
      if (lookahead == 'a') ADVANCE(2227);
      if (lookahead == 'i') ADVANCE(1726);
      END_STATE();
    case 1406:
      if (lookahead == 'a') ADVANCE(2227);
      if (lookahead == 'i') ADVANCE(1726);
      if (lookahead == 'o') ADVANCE(2783);
      END_STATE();
    case 1407:
      if (lookahead == 'a') ADVANCE(2227);
      if (lookahead == 'o') ADVANCE(2783);
      END_STATE();
    case 1408:
      if (lookahead == 'a') ADVANCE(2728);
      if (lookahead == 'g') ADVANCE(2414);
      END_STATE();
    case 1409:
      if (lookahead == 'a') ADVANCE(2411);
      END_STATE();
    case 1410:
      if (lookahead == 'a') ADVANCE(2961);
      if (lookahead == 'i') ADVANCE(2413);
      END_STATE();
    case 1411:
      if (lookahead == 'a') ADVANCE(1625);
      END_STATE();
    case 1412:
      if (lookahead == 'a') ADVANCE(1625);
      if (lookahead == 't') ADVANCE(1886);
      END_STATE();
    case 1413:
      if (lookahead == 'a') ADVANCE(1625);
      if (lookahead == 't') ADVANCE(1998);
      END_STATE();
    case 1414:
      if (lookahead == 'a') ADVANCE(1625);
      if (lookahead == 't') ADVANCE(2006);
      END_STATE();
    case 1415:
      if (lookahead == 'a') ADVANCE(1698);
      END_STATE();
    case 1416:
      if (lookahead == 'a') ADVANCE(1698);
      if (lookahead == 'c') ADVANCE(1441);
      END_STATE();
    case 1417:
      if (lookahead == 'a') ADVANCE(1553);
      END_STATE();
    case 1418:
      if (lookahead == 'a') ADVANCE(1553);
      if (lookahead == 'i') ADVANCE(2409);
      if (lookahead == 'o') ADVANCE(1681);
      END_STATE();
    case 1419:
      if (lookahead == 'a') ADVANCE(1553);
      if (lookahead == 'i') ADVANCE(2409);
      if (lookahead == 'o') ADVANCE(1681);
      if (lookahead == 's') ADVANCE(2093);
      END_STATE();
    case 1420:
      if (lookahead == 'a') ADVANCE(1553);
      if (lookahead == 'i') ADVANCE(2409);
      if (lookahead == 's') ADVANCE(2093);
      END_STATE();
    case 1421:
      if (lookahead == 'a') ADVANCE(1553);
      if (lookahead == 'o') ADVANCE(1681);
      END_STATE();
    case 1422:
      if (lookahead == 'a') ADVANCE(2216);
      END_STATE();
    case 1423:
      if (lookahead == 'a') ADVANCE(1729);
      END_STATE();
    case 1424:
      if (lookahead == 'a') ADVANCE(1729);
      if (lookahead == 'l') ADVANCE(3661);
      if (lookahead == 'u') ADVANCE(2026);
      END_STATE();
    case 1425:
      if (lookahead == 'a') ADVANCE(2755);
      END_STATE();
    case 1426:
      if (lookahead == 'a') ADVANCE(2602);
      if (lookahead == 'f') ADVANCE(1327);
      END_STATE();
    case 1427:
      if (lookahead == 'a') ADVANCE(2658);
      END_STATE();
    case 1428:
      if (lookahead == 'a') ADVANCE(1731);
      END_STATE();
    case 1429:
      if (lookahead == 'a') ADVANCE(2437);
      END_STATE();
    case 1430:
      if (lookahead == 'a') ADVANCE(2236);
      END_STATE();
    case 1431:
      if (lookahead == 'a') ADVANCE(2218);
      END_STATE();
    case 1432:
      if (lookahead == 'a') ADVANCE(2478);
      if (lookahead == 'e') ADVANCE(2052);
      END_STATE();
    case 1433:
      if (lookahead == 'a') ADVANCE(2729);
      END_STATE();
    case 1434:
      if (lookahead == 'a') ADVANCE(2382);
      if (lookahead == 'f') ADVANCE(2596);
      if (lookahead == 'm') ADVANCE(2384);
      END_STATE();
    case 1435:
      if (lookahead == 'a') ADVANCE(2660);
      END_STATE();
    case 1436:
      if (lookahead == 'a') ADVANCE(2499);
      if (lookahead == 'y') ADVANCE(2445);
      END_STATE();
    case 1437:
      if (lookahead == 'a') ADVANCE(2791);
      END_STATE();
    case 1438:
      if (lookahead == 'a') ADVANCE(1727);
      END_STATE();
    case 1439:
      if (lookahead == 'a') ADVANCE(2059);
      END_STATE();
    case 1440:
      if (lookahead == 'a') ADVANCE(2669);
      END_STATE();
    case 1441:
      if (lookahead == 'a') ADVANCE(2239);
      END_STATE();
    case 1442:
      if (lookahead == 'a') ADVANCE(2352);
      if (lookahead == 'f') ADVANCE(2118);
      END_STATE();
    case 1443:
      if (lookahead == 'a') ADVANCE(2352);
      if (lookahead == 'f') ADVANCE(2118);
      if (lookahead == 's') ADVANCE(1912);
      END_STATE();
    case 1444:
      if (lookahead == 'a') ADVANCE(2352);
      if (lookahead == 's') ADVANCE(1912);
      END_STATE();
    case 1445:
      if (lookahead == 'a') ADVANCE(2240);
      END_STATE();
    case 1446:
      if (lookahead == 'a') ADVANCE(2875);
      END_STATE();
    case 1447:
      if (lookahead == 'a') ADVANCE(2794);
      END_STATE();
    case 1448:
      if (lookahead == 'a') ADVANCE(2795);
      END_STATE();
    case 1449:
      if (lookahead == 'a') ADVANCE(1705);
      END_STATE();
    case 1450:
      if (lookahead == 'a') ADVANCE(2245);
      END_STATE();
    case 1451:
      if (lookahead == 'a') ADVANCE(1710);
      END_STATE();
    case 1452:
      if (lookahead == 'a') ADVANCE(1612);
      END_STATE();
    case 1453:
      if (lookahead == 'a') ADVANCE(1614);
      END_STATE();
    case 1454:
      if (lookahead == 'a') ADVANCE(2746);
      if (lookahead == 'e') ADVANCE(2710);
      if (lookahead == 's') ADVANCE(1943);
      END_STATE();
    case 1455:
      if (lookahead == 'a') ADVANCE(1713);
      END_STATE();
    case 1456:
      if (lookahead == 'a') ADVANCE(2247);
      END_STATE();
    case 1457:
      if (lookahead == 'a') ADVANCE(2740);
      if (lookahead == 'l') ADVANCE(2512);
      if (lookahead == 'p') ADVANCE(96);
      END_STATE();
    case 1458:
      if (lookahead == 'a') ADVANCE(1730);
      END_STATE();
    case 1459:
      if (lookahead == 'a') ADVANCE(2335);
      END_STATE();
    case 1460:
      if (lookahead == 'a') ADVANCE(2741);
      END_STATE();
    case 1461:
      if (lookahead == 'a') ADVANCE(1700);
      if (lookahead == 'l') ADVANCE(1902);
      if (lookahead == 't') ADVANCE(2921);
      END_STATE();
    case 1462:
      if (lookahead == 'a') ADVANCE(1700);
      if (lookahead == 't') ADVANCE(2921);
      END_STATE();
    case 1463:
      if (lookahead == 'a') ADVANCE(2248);
      END_STATE();
    case 1464:
      if (lookahead == 'a') ADVANCE(2670);
      END_STATE();
    case 1465:
      if (lookahead == 'a') ADVANCE(1717);
      END_STATE();
    case 1466:
      if (lookahead == 'a') ADVANCE(1622);
      END_STATE();
    case 1467:
      if (lookahead == 'a') ADVANCE(2292);
      END_STATE();
    case 1468:
      if (lookahead == 'a') ADVANCE(2826);
      END_STATE();
    case 1469:
      if (lookahead == 'a') ADVANCE(2435);
      if (lookahead == 'e') ADVANCE(3709);
      if (lookahead == 'o') ADVANCE(1309);
      if (lookahead == 'u') ADVANCE(2311);
      END_STATE();
    case 1470:
      if (lookahead == 'a') ADVANCE(2435);
      if (lookahead == 'o') ADVANCE(1309);
      if (lookahead == 'u') ADVANCE(2311);
      END_STATE();
    case 1471:
      if (lookahead == 'a') ADVANCE(2821);
      END_STATE();
    case 1472:
      if (lookahead == 'a') ADVANCE(2164);
      END_STATE();
    case 1473:
      if (lookahead == 'a') ADVANCE(2164);
      if (lookahead == 'r') ADVANCE(1301);
      END_STATE();
    case 1474:
      if (lookahead == 'a') ADVANCE(1723);
      if (lookahead == 'c') ADVANCE(2378);
      if (lookahead == 'd') ADVANCE(2110);
      if (lookahead == 'e') ADVANCE(2433);
      if (lookahead == 'l') ADVANCE(2512);
      if (lookahead == 'm') ADVANCE(2905);
      if (lookahead == 'n') ADVANCE(1866);
      if (lookahead == 'p') ADVANCE(97);
      if (lookahead == 'r') ADVANCE(1775);
      if (lookahead == 's') ADVANCE(2903);
      END_STATE();
    case 1475:
      if (lookahead == 'a') ADVANCE(2197);
      if (lookahead == 'o') ADVANCE(3567);
      END_STATE();
    case 1476:
      if (lookahead == 'a') ADVANCE(2764);
      END_STATE();
    case 1477:
      if (lookahead == 'a') ADVANCE(1732);
      END_STATE();
    case 1478:
      if (lookahead == 'a') ADVANCE(2479);
      END_STATE();
    case 1479:
      if (lookahead == 'a') ADVANCE(2456);
      END_STATE();
    case 1480:
      if (lookahead == 'a') ADVANCE(2298);
      END_STATE();
    case 1481:
      if (lookahead == 'a') ADVANCE(2717);
      END_STATE();
    case 1482:
      if (lookahead == 'a') ADVANCE(2129);
      END_STATE();
    case 1483:
      if (lookahead == 'a') ADVANCE(2925);
      END_STATE();
    case 1484:
      if (lookahead == 'a') ADVANCE(2925);
      if (lookahead == 'i') ADVANCE(2459);
      END_STATE();
    case 1485:
      if (lookahead == 'a') ADVANCE(1753);
      END_STATE();
    case 1486:
      if (lookahead == 'a') ADVANCE(2220);
      if (lookahead == 'e') ADVANCE(2742);
      if (lookahead == 'i') ADVANCE(2431);
      if (lookahead == 'n') ADVANCE(1409);
      if (lookahead == 'o') ADVANCE(49);
      if (lookahead == 's') ADVANCE(2952);
      if (lookahead == 'u') ADVANCE(2272);
      END_STATE();
    case 1487:
      if (lookahead == 'a') ADVANCE(2220);
      if (lookahead == 'e') ADVANCE(2742);
      if (lookahead == 'i') ADVANCE(2431);
      if (lookahead == 'n') ADVANCE(1409);
      if (lookahead == 'o') ADVANCE(49);
      if (lookahead == 's') ADVANCE(2992);
      if (lookahead == 'u') ADVANCE(2309);
      END_STATE();
    case 1488:
      if (lookahead == 'a') ADVANCE(2220);
      if (lookahead == 'e') ADVANCE(2742);
      if (lookahead == 'i') ADVANCE(2431);
      if (lookahead == 'n') ADVANCE(1409);
      if (lookahead == 'o') ADVANCE(48);
      if (lookahead == 's') ADVANCE(2992);
      if (lookahead == 'u') ADVANCE(2309);
      END_STATE();
    case 1489:
      if (lookahead == 'a') ADVANCE(2287);
      END_STATE();
    case 1490:
      if (lookahead == 'a') ADVANCE(2299);
      if (lookahead == 'm') ADVANCE(2526);
      END_STATE();
    case 1491:
      if (lookahead == 'a') ADVANCE(2854);
      END_STATE();
    case 1492:
      if (lookahead == 'a') ADVANCE(2389);
      END_STATE();
    case 1493:
      if (lookahead == 'a') ADVANCE(1688);
      END_STATE();
    case 1494:
      if (lookahead == 'a') ADVANCE(2760);
      END_STATE();
    case 1495:
      if (lookahead == 'a') ADVANCE(2314);
      END_STATE();
    case 1496:
      if (lookahead == 'a') ADVANCE(2304);
      END_STATE();
    case 1497:
      if (lookahead == 'a') ADVANCE(2137);
      END_STATE();
    case 1498:
      if (lookahead == 'a') ADVANCE(1615);
      END_STATE();
    case 1499:
      if (lookahead == 'a') ADVANCE(1637);
      END_STATE();
    case 1500:
      if (lookahead == 'a') ADVANCE(1651);
      END_STATE();
    case 1501:
      if (lookahead == 'a') ADVANCE(2846);
      END_STATE();
    case 1502:
      if (lookahead == 'a') ADVANCE(2391);
      END_STATE();
    case 1503:
      if (lookahead == 'a') ADVANCE(2336);
      END_STATE();
    case 1504:
      if (lookahead == 'a') ADVANCE(2196);
      if (lookahead == 'o') ADVANCE(2225);
      if (lookahead == 'r') ADVANCE(2901);
      END_STATE();
    case 1505:
      if (lookahead == 'a') ADVANCE(2857);
      END_STATE();
    case 1506:
      if (lookahead == 'a') ADVANCE(2076);
      END_STATE();
    case 1507:
      if (lookahead == 'a') ADVANCE(2358);
      END_STATE();
    case 1508:
      if (lookahead == 'a') ADVANCE(2763);
      if (lookahead == 'i') ADVANCE(2331);
      if (lookahead == 'l') ADVANCE(2512);
      if (lookahead == 'p') ADVANCE(96);
      END_STATE();
    case 1509:
      if (lookahead == 'a') ADVANCE(2310);
      END_STATE();
    case 1510:
      if (lookahead == 'a') ADVANCE(2689);
      END_STATE();
    case 1511:
      if (lookahead == 'a') ADVANCE(1654);
      END_STATE();
    case 1512:
      if (lookahead == 'a') ADVANCE(2297);
      END_STATE();
    case 1513:
      if (lookahead == 'a') ADVANCE(2318);
      END_STATE();
    case 1514:
      if (lookahead == 'a') ADVANCE(2859);
      END_STATE();
    case 1515:
      if (lookahead == 'a') ADVANCE(1655);
      END_STATE();
    case 1516:
      if (lookahead == 'a') ADVANCE(2860);
      END_STATE();
    case 1517:
      if (lookahead == 'a') ADVANCE(1649);
      if (lookahead == 't') ADVANCE(1998);
      END_STATE();
    case 1518:
      if (lookahead == 'a') ADVANCE(2357);
      END_STATE();
    case 1519:
      if (lookahead == 'a') ADVANCE(2328);
      END_STATE();
    case 1520:
      if (lookahead == 'a') ADVANCE(2330);
      END_STATE();
    case 1521:
      if (lookahead == 'a') ADVANCE(1558);
      END_STATE();
    case 1522:
      if (lookahead == 'a') ADVANCE(1558);
      if (lookahead == 't') ADVANCE(2176);
      END_STATE();
    case 1523:
      if (lookahead == 'a') ADVANCE(2393);
      END_STATE();
    case 1524:
      if (lookahead == 'a') ADVANCE(2485);
      END_STATE();
    case 1525:
      if (lookahead == 'a') ADVANCE(2340);
      END_STATE();
    case 1526:
      if (lookahead == 'a') ADVANCE(2356);
      END_STATE();
    case 1527:
      if (lookahead == 'a') ADVANCE(2883);
      if (lookahead == 'l') ADVANCE(1950);
      if (lookahead == 'o') ADVANCE(2302);
      END_STATE();
    case 1528:
      if (lookahead == 'a') ADVANCE(1764);
      if (lookahead == 'h') ADVANCE(2958);
      if (lookahead == 'm') ADVANCE(1884);
      if (lookahead == 't') ADVANCE(2100);
      END_STATE();
    case 1529:
      if (lookahead == 'a') ADVANCE(1757);
      END_STATE();
    case 1530:
      if (lookahead == 'a') ADVANCE(1559);
      END_STATE();
    case 1531:
      if (lookahead == 'a') ADVANCE(2695);
      if (lookahead == 'o') ADVANCE(3567);
      END_STATE();
    case 1532:
      if (lookahead == 'a') ADVANCE(2695);
      if (lookahead == 'o') ADVANCE(3567);
      if (lookahead == 'r') ADVANCE(2901);
      END_STATE();
    case 1533:
      if (lookahead == 'a') ADVANCE(2695);
      if (lookahead == 'o') ADVANCE(3567);
      if (lookahead == 'r') ADVANCE(2919);
      END_STATE();
    case 1534:
      if (lookahead == 'a') ADVANCE(2884);
      END_STATE();
    case 1535:
      if (lookahead == 'a') ADVANCE(1766);
      END_STATE();
    case 1536:
      if (lookahead == 'a') ADVANCE(2891);
      END_STATE();
    case 1537:
      if (lookahead == 'a') ADVANCE(1560);
      END_STATE();
    case 1538:
      if (lookahead == 'a') ADVANCE(1561);
      END_STATE();
    case 1539:
      if (lookahead == 'a') ADVANCE(1563);
      END_STATE();
    case 1540:
      if (lookahead == 'a') ADVANCE(1564);
      if (lookahead == 'i') ADVANCE(2947);
      END_STATE();
    case 1541:
      if (lookahead == 'a') ADVANCE(1565);
      END_STATE();
    case 1542:
      if (lookahead == 'a') ADVANCE(1566);
      END_STATE();
    case 1543:
      if (lookahead == 'a') ADVANCE(1567);
      END_STATE();
    case 1544:
      if (lookahead == 'a') ADVANCE(2359);
      END_STATE();
    case 1545:
      if (lookahead == 'a') ADVANCE(2406);
      END_STATE();
    case 1546:
      if (lookahead == 'a') ADVANCE(2501);
      END_STATE();
    case 1547:
      if (lookahead == 'b') ADVANCE(3684);
      END_STATE();
    case 1548:
      if (lookahead == 'b') ADVANCE(3706);
      END_STATE();
    case 1549:
      if (lookahead == 'b') ADVANCE(3783);
      END_STATE();
    case 1550:
      if (lookahead == 'b') ADVANCE(1549);
      END_STATE();
    case 1551:
      if (lookahead == 'b') ADVANCE(2307);
      END_STATE();
    case 1552:
      if (lookahead == 'b') ADVANCE(2935);
      END_STATE();
    case 1553:
      if (lookahead == 'b') ADVANCE(1901);
      END_STATE();
    case 1554:
      if (lookahead == 'b') ADVANCE(1901);
      if (lookahead == 'n') ADVANCE(1752);
      END_STATE();
    case 1555:
      if (lookahead == 'b') ADVANCE(1901);
      if (lookahead == 'n') ADVANCE(1752);
      if (lookahead == 'r') ADVANCE(2070);
      END_STATE();
    case 1556:
      if (lookahead == 'b') ADVANCE(1901);
      if (lookahead == 'r') ADVANCE(2070);
      END_STATE();
    case 1557:
      if (lookahead == 'b') ADVANCE(1445);
      END_STATE();
    case 1558:
      if (lookahead == 'b') ADVANCE(2315);
      END_STATE();
    case 1559:
      if (lookahead == 'b') ADVANCE(2317);
      END_STATE();
    case 1560:
      if (lookahead == 'b') ADVANCE(2320);
      END_STATE();
    case 1561:
      if (lookahead == 'b') ADVANCE(2321);
      END_STATE();
    case 1562:
      if (lookahead == 'b') ADVANCE(2150);
      END_STATE();
    case 1563:
      if (lookahead == 'b') ADVANCE(2323);
      END_STATE();
    case 1564:
      if (lookahead == 'b') ADVANCE(2324);
      END_STATE();
    case 1565:
      if (lookahead == 'b') ADVANCE(2325);
      END_STATE();
    case 1566:
      if (lookahead == 'b') ADVANCE(2326);
      END_STATE();
    case 1567:
      if (lookahead == 'b') ADVANCE(2327);
      END_STATE();
    case 1568:
      if (lookahead == 'b') ADVANCE(2349);
      END_STATE();
    case 1569:
      if (lookahead == 'c') ADVANCE(2626);
      if (lookahead == 'd') ADVANCE(1691);
      if (lookahead == 'l') ADVANCE(2131);
      if (lookahead == 'n') ADVANCE(1692);
      if (lookahead == 'p') ADVANCE(2599);
      if (lookahead == 's') ADVANCE(2091);
      if (lookahead == 't') ADVANCE(2827);
      if (lookahead == 'v') ADVANCE(1472);
      END_STATE();
    case 1570:
      if (lookahead == 'c') ADVANCE(2626);
      if (lookahead == 'd') ADVANCE(1750);
      if (lookahead == 'f') ADVANCE(2408);
      if (lookahead == 'l') ADVANCE(2104);
      if (lookahead == 'r') ADVANCE(1603);
      if (lookahead == 't') ADVANCE(2577);
      END_STATE();
    case 1571:
      if (lookahead == 'c') ADVANCE(2626);
      if (lookahead == 'd') ADVANCE(1768);
      if (lookahead == 'n') ADVANCE(1692);
      if (lookahead == 'p') ADVANCE(2599);
      if (lookahead == 's') ADVANCE(2091);
      if (lookahead == 't') ADVANCE(2827);
      if (lookahead == 'v') ADVANCE(1472);
      END_STATE();
    case 1572:
      if (lookahead == 'c') ADVANCE(3204);
      if (lookahead == 'f') ADVANCE(2064);
      if (lookahead == 'o') ADVANCE(2265);
      if (lookahead == 'x') ADVANCE(2965);
      END_STATE();
    case 1573:
      if (lookahead == 'c') ADVANCE(3204);
      if (lookahead == 'f') ADVANCE(2064);
      if (lookahead == 'o') ADVANCE(2264);
      if (lookahead == 'x') ADVANCE(2965);
      END_STATE();
    case 1574:
      if (lookahead == 'c') ADVANCE(3291);
      END_STATE();
    case 1575:
      if (lookahead == 'c') ADVANCE(3291);
      if (lookahead == 'e') ADVANCE(2836);
      END_STATE();
    case 1576:
      if (lookahead == 'c') ADVANCE(3291);
      if (lookahead == 'e') ADVANCE(2836);
      if (lookahead == 'h') ADVANCE(1663);
      if (lookahead == 'l') ADVANCE(2513);
      END_STATE();
    case 1577:
      if (lookahead == 'c') ADVANCE(3291);
      if (lookahead == 'l') ADVANCE(2513);
      END_STATE();
    case 1578:
      if (lookahead == 'c') ADVANCE(1368);
      END_STATE();
    case 1579:
      if (lookahead == 'c') ADVANCE(3173);
      END_STATE();
    case 1580:
      if (lookahead == 'c') ADVANCE(3793);
      END_STATE();
    case 1581:
      if (lookahead == 'c') ADVANCE(3732);
      END_STATE();
    case 1582:
      if (lookahead == 'c') ADVANCE(3607);
      END_STATE();
    case 1583:
      if (lookahead == 'c') ADVANCE(3143);
      END_STATE();
    case 1584:
      if (lookahead == 'c') ADVANCE(3142);
      END_STATE();
    case 1585:
      if (lookahead == 'c') ADVANCE(3384);
      END_STATE();
    case 1586:
      if (lookahead == 'c') ADVANCE(3738);
      END_STATE();
    case 1587:
      if (lookahead == 'c') ADVANCE(3776);
      END_STATE();
    case 1588:
      if (lookahead == 'c') ADVANCE(3145);
      END_STATE();
    case 1589:
      if (lookahead == 'c') ADVANCE(3797);
      END_STATE();
    case 1590:
      if (lookahead == 'c') ADVANCE(3758);
      END_STATE();
    case 1591:
      if (lookahead == 'c') ADVANCE(3796);
      END_STATE();
    case 1592:
      if (lookahead == 'c') ADVANCE(3795);
      END_STATE();
    case 1593:
      if (lookahead == 'c') ADVANCE(3147);
      END_STATE();
    case 1594:
      if (lookahead == 'c') ADVANCE(3152);
      END_STATE();
    case 1595:
      if (lookahead == 'c') ADVANCE(3146);
      END_STATE();
    case 1596:
      if (lookahead == 'c') ADVANCE(3149);
      END_STATE();
    case 1597:
      if (lookahead == 'c') ADVANCE(3523);
      END_STATE();
    case 1598:
      if (lookahead == 'c') ADVANCE(3606);
      END_STATE();
    case 1599:
      if (lookahead == 'c') ADVANCE(2092);
      if (lookahead == 'o') ADVANCE(2650);
      END_STATE();
    case 1600:
      if (lookahead == 'c') ADVANCE(2083);
      END_STATE();
    case 1601:
      if (lookahead == 'c') ADVANCE(2222);
      END_STATE();
    case 1602:
      if (lookahead == 'c') ADVANCE(2582);
      END_STATE();
    case 1603:
      if (lookahead == 'c') ADVANCE(2582);
      if (lookahead == 'g') ADVANCE(2386);
      END_STATE();
    case 1604:
      if (lookahead == 'c') ADVANCE(2582);
      if (lookahead == 'g') ADVANCE(2386);
      if (lookahead == 'm') ADVANCE(1300);
      END_STATE();
    case 1605:
      if (lookahead == 'c') ADVANCE(2084);
      END_STATE();
    case 1606:
      if (lookahead == 'c') ADVANCE(1306);
      END_STATE();
    case 1607:
      if (lookahead == 'c') ADVANCE(2277);
      if (lookahead == 'f') ADVANCE(1484);
      END_STATE();
    case 1608:
      if (lookahead == 'c') ADVANCE(2277);
      if (lookahead == 'f') ADVANCE(1484);
      if (lookahead == 'r') ADVANCE(1871);
      END_STATE();
    case 1609:
      if (lookahead == 'c') ADVANCE(2277);
      if (lookahead == 'f') ADVANCE(2165);
      if (lookahead == 'r') ADVANCE(1871);
      END_STATE();
    case 1610:
      if (lookahead == 'c') ADVANCE(2085);
      END_STATE();
    case 1611:
      if (lookahead == 'c') ADVANCE(2037);
      END_STATE();
    case 1612:
      if (lookahead == 'c') ADVANCE(2213);
      END_STATE();
    case 1613:
      if (lookahead == 'c') ADVANCE(2095);
      END_STATE();
    case 1614:
      if (lookahead == 'c') ADVANCE(2214);
      END_STATE();
    case 1615:
      if (lookahead == 'c') ADVANCE(2101);
      END_STATE();
    case 1616:
      if (lookahead == 'c') ADVANCE(2215);
      END_STATE();
    case 1617:
      if (lookahead == 'c') ADVANCE(2752);
      END_STATE();
    case 1618:
      if (lookahead == 'c') ADVANCE(2086);
      END_STATE();
    case 1619:
      if (lookahead == 'c') ADVANCE(1425);
      END_STATE();
    case 1620:
      if (lookahead == 'c') ADVANCE(2226);
      END_STATE();
    case 1621:
      if (lookahead == 'c') ADVANCE(2087);
      END_STATE();
    case 1622:
      if (lookahead == 'c') ADVANCE(2217);
      END_STATE();
    case 1623:
      if (lookahead == 'c') ADVANCE(2909);
      if (lookahead == 'd') ADVANCE(3006);
      if (lookahead == 't') ADVANCE(2928);
      END_STATE();
    case 1624:
      if (lookahead == 'c') ADVANCE(2088);
      END_STATE();
    case 1625:
      if (lookahead == 'c') ADVANCE(2790);
      END_STATE();
    case 1626:
      if (lookahead == 'c') ADVANCE(1579);
      END_STATE();
    case 1627:
      if (lookahead == 'c') ADVANCE(2089);
      END_STATE();
    case 1628:
      if (lookahead == 'c') ADVANCE(1584);
      END_STATE();
    case 1629:
      if (lookahead == 'c') ADVANCE(2555);
      END_STATE();
    case 1630:
      if (lookahead == 'c') ADVANCE(2797);
      END_STATE();
    case 1631:
      if (lookahead == 'c') ADVANCE(1370);
      END_STATE();
    case 1632:
      if (lookahead == 'c') ADVANCE(2876);
      END_STATE();
    case 1633:
      if (lookahead == 'c') ADVANCE(2562);
      END_STATE();
    case 1634:
      if (lookahead == 'c') ADVANCE(1588);
      END_STATE();
    case 1635:
      if (lookahead == 'c') ADVANCE(1796);
      END_STATE();
    case 1636:
      if (lookahead == 'c') ADVANCE(1593);
      END_STATE();
    case 1637:
      if (lookahead == 'c') ADVANCE(2807);
      END_STATE();
    case 1638:
      if (lookahead == 'c') ADVANCE(2808);
      END_STATE();
    case 1639:
      if (lookahead == 'c') ADVANCE(1594);
      END_STATE();
    case 1640:
      if (lookahead == 'c') ADVANCE(1595);
      END_STATE();
    case 1641:
      if (lookahead == 'c') ADVANCE(2809);
      END_STATE();
    case 1642:
      if (lookahead == 'c') ADVANCE(1596);
      END_STATE();
    case 1643:
      if (lookahead == 'c') ADVANCE(2661);
      END_STATE();
    case 1644:
      if (lookahead == 'c') ADVANCE(1890);
      END_STATE();
    case 1645:
      if (lookahead == 'c') ADVANCE(1961);
      END_STATE();
    case 1646:
      if (lookahead == 'c') ADVANCE(2816);
      END_STATE();
    case 1647:
      if (lookahead == 'c') ADVANCE(2817);
      END_STATE();
    case 1648:
      if (lookahead == 'c') ADVANCE(2862);
      END_STATE();
    case 1649:
      if (lookahead == 'c') ADVANCE(2863);
      END_STATE();
    case 1650:
      if (lookahead == 'c') ADVANCE(1818);
      END_STATE();
    case 1651:
      if (lookahead == 'c') ADVANCE(1824);
      END_STATE();
    case 1652:
      if (lookahead == 'c') ADVANCE(2007);
      END_STATE();
    case 1653:
      if (lookahead == 'c') ADVANCE(1841);
      END_STATE();
    case 1654:
      if (lookahead == 'c') ADVANCE(1978);
      END_STATE();
    case 1655:
      if (lookahead == 'c') ADVANCE(1849);
      END_STATE();
    case 1656:
      if (lookahead == 'c') ADVANCE(2379);
      if (lookahead == 'f') ADVANCE(2924);
      if (lookahead == 'm') ADVANCE(2377);
      if (lookahead == 'n') ADVANCE(1355);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3258);
      END_STATE();
    case 1657:
      if (lookahead == 'c') ADVANCE(2379);
      if (lookahead == 'm') ADVANCE(2377);
      if (lookahead == 'n') ADVANCE(1360);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3258);
      END_STATE();
    case 1658:
      if (lookahead == 'c') ADVANCE(2379);
      if (lookahead == 'm') ADVANCE(2377);
      if (lookahead == 'n') ADVANCE(1357);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3258);
      END_STATE();
    case 1659:
      if (lookahead == 'c') ADVANCE(2379);
      if (lookahead == 'm') ADVANCE(2377);
      if (lookahead == 'n') ADVANCE(1358);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3258);
      END_STATE();
    case 1660:
      if (lookahead == 'c') ADVANCE(2379);
      if (lookahead == 'm') ADVANCE(2377);
      if (lookahead == 'n') ADVANCE(1361);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3258);
      END_STATE();
    case 1661:
      if (lookahead == 'c') ADVANCE(2379);
      if (lookahead == 'n') ADVANCE(2745);
      END_STATE();
    case 1662:
      if (lookahead == 'c') ADVANCE(2379);
      if (lookahead == 'n') ADVANCE(2745);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3258);
      END_STATE();
    case 1663:
      if (lookahead == 'c') ADVANCE(1626);
      END_STATE();
    case 1664:
      if (lookahead == 'c') ADVANCE(2094);
      END_STATE();
    case 1665:
      if (lookahead == 'c') ADVANCE(1644);
      if (lookahead == 'l') ADVANCE(2337);
      END_STATE();
    case 1666:
      if (lookahead == 'c') ADVANCE(2096);
      END_STATE();
    case 1667:
      if (lookahead == 'c') ADVANCE(1494);
      END_STATE();
    case 1668:
      if (lookahead == 'c') ADVANCE(2156);
      END_STATE();
    case 1669:
      if (lookahead == 'c') ADVANCE(2842);
      END_STATE();
    case 1670:
      if (lookahead == 'c') ADVANCE(2842);
      if (lookahead == 'l') ADVANCE(1962);
      if (lookahead == 'q') ADVANCE(1315);
      if (lookahead == 'x') ADVANCE(2787);
      END_STATE();
    case 1671:
      if (lookahead == 'c') ADVANCE(2842);
      if (lookahead == 'l') ADVANCE(1962);
      if (lookahead == 'x') ADVANCE(2787);
      END_STATE();
    case 1672:
      if (lookahead == 'c') ADVANCE(2842);
      if (lookahead == 'q') ADVANCE(1315);
      END_STATE();
    case 1673:
      if (lookahead == 'c') ADVANCE(2759);
      END_STATE();
    case 1674:
      if (lookahead == 'c') ADVANCE(1495);
      END_STATE();
    case 1675:
      if (lookahead == 'c') ADVANCE(2873);
      END_STATE();
    case 1676:
      if (lookahead == 'c') ADVANCE(2911);
      END_STATE();
    case 1677:
      if (lookahead == 'c') ADVANCE(2855);
      END_STATE();
    case 1678:
      if (lookahead == 'c') ADVANCE(1456);
      END_STATE();
    case 1679:
      if (lookahead == 'c') ADVANCE(1480);
      END_STATE();
    case 1680:
      if (lookahead == 'c') ADVANCE(1463);
      END_STATE();
    case 1681:
      if (lookahead == 'c') ADVANCE(1467);
      END_STATE();
    case 1682:
      if (lookahead == 'c') ADVANCE(1505);
      END_STATE();
    case 1683:
      if (lookahead == 'c') ADVANCE(1514);
      END_STATE();
    case 1684:
      if (lookahead == 'c') ADVANCE(1516);
      END_STATE();
    case 1685:
      if (lookahead == 'c') ADVANCE(1519);
      END_STATE();
    case 1686:
      if (lookahead == 'c') ADVANCE(1520);
      END_STATE();
    case 1687:
      if (lookahead == 'c') ADVANCE(2779);
      END_STATE();
    case 1688:
      if (lookahead == 'c') ADVANCE(2896);
      END_STATE();
    case 1689:
      if (lookahead == 'd') ADVANCE(1691);
      if (lookahead == 'l') ADVANCE(2128);
      if (lookahead == 'n') ADVANCE(1694);
      if (lookahead == 'p') ADVANCE(2599);
      if (lookahead == 'r') ADVANCE(2061);
      if (lookahead == 's') ADVANCE(2090);
      if (lookahead == 't') ADVANCE(2827);
      if (lookahead == 'v') ADVANCE(1472);
      END_STATE();
    case 1690:
      if (lookahead == 'd') ADVANCE(1691);
      if (lookahead == 'n') ADVANCE(1692);
      if (lookahead == 'p') ADVANCE(2599);
      if (lookahead == 's') ADVANCE(2090);
      if (lookahead == 'v') ADVANCE(1472);
      END_STATE();
    case 1691:
      if (lookahead == 'd') ADVANCE(3682);
      END_STATE();
    case 1692:
      if (lookahead == 'd') ADVANCE(3686);
      END_STATE();
    case 1693:
      if (lookahead == 'd') ADVANCE(3686);
      if (lookahead == 'y') ADVANCE(3799);
      END_STATE();
    case 1694:
      if (lookahead == 'd') ADVANCE(3686);
      if (lookahead == 'y') ADVANCE(3798);
      END_STATE();
    case 1695:
      if (lookahead == 'd') ADVANCE(3686);
      if (lookahead == 'y') ADVANCE(2680);
      END_STATE();
    case 1696:
      if (lookahead == 'd') ADVANCE(3313);
      END_STATE();
    case 1697:
      if (lookahead == 'd') ADVANCE(3704);
      END_STATE();
    case 1698:
      if (lookahead == 'd') ADVANCE(3604);
      END_STATE();
    case 1699:
      if (lookahead == 'd') ADVANCE(3688);
      END_STATE();
    case 1700:
      if (lookahead == 'd') ADVANCE(2496);
      END_STATE();
    case 1701:
      if (lookahead == 'd') ADVANCE(2496);
      if (lookahead == 's') ADVANCE(2773);
      END_STATE();
    case 1702:
      if (lookahead == 'd') ADVANCE(3208);
      END_STATE();
    case 1703:
      if (lookahead == 'd') ADVANCE(3339);
      END_STATE();
    case 1704:
      if (lookahead == 'd') ADVANCE(3568);
      END_STATE();
    case 1705:
      if (lookahead == 'd') ADVANCE(3576);
      END_STATE();
    case 1706:
      if (lookahead == 'd') ADVANCE(3387);
      END_STATE();
    case 1707:
      if (lookahead == 'd') ADVANCE(3507);
      END_STATE();
    case 1708:
      if (lookahead == 'd') ADVANCE(3135);
      END_STATE();
    case 1709:
      if (lookahead == 'd') ADVANCE(3756);
      END_STATE();
    case 1710:
      if (lookahead == 'd') ADVANCE(3590);
      END_STATE();
    case 1711:
      if (lookahead == 'd') ADVANCE(3363);
      END_STATE();
    case 1712:
      if (lookahead == 'd') ADVANCE(3471);
      END_STATE();
    case 1713:
      if (lookahead == 'd') ADVANCE(3429);
      END_STATE();
    case 1714:
      if (lookahead == 'd') ADVANCE(3393);
      END_STATE();
    case 1715:
      if (lookahead == 'd') ADVANCE(3789);
      END_STATE();
    case 1716:
      if (lookahead == 'd') ADVANCE(3311);
      END_STATE();
    case 1717:
      if (lookahead == 'd') ADVANCE(3578);
      END_STATE();
    case 1718:
      if (lookahead == 'd') ADVANCE(3679);
      END_STATE();
    case 1719:
      if (lookahead == 'd') ADVANCE(3725);
      END_STATE();
    case 1720:
      if (lookahead == 'd') ADVANCE(2068);
      END_STATE();
    case 1721:
      if (lookahead == 'd') ADVANCE(1697);
      if (lookahead == 'l') ADVANCE(2757);
      END_STATE();
    case 1722:
      if (lookahead == 'd') ADVANCE(1697);
      if (lookahead == 'l') ADVANCE(2757);
      if (lookahead == 's') ADVANCE(2784);
      END_STATE();
    case 1723:
      if (lookahead == 'd') ADVANCE(1697);
      if (lookahead == 'l') ADVANCE(2757);
      if (lookahead == 's') ADVANCE(2823);
      END_STATE();
    case 1724:
      if (lookahead == 'd') ADVANCE(1697);
      if (lookahead == 'l') ADVANCE(2757);
      if (lookahead == 's') ADVANCE(2880);
      END_STATE();
    case 1725:
      if (lookahead == 'd') ADVANCE(1697);
      if (lookahead == 's') ADVANCE(2880);
      END_STATE();
    case 1726:
      if (lookahead == 'd') ADVANCE(1756);
      END_STATE();
    case 1727:
      if (lookahead == 'd') ADVANCE(1338);
      END_STATE();
    case 1728:
      if (lookahead == 'd') ADVANCE(2730);
      END_STATE();
    case 1729:
      if (lookahead == 'd') ADVANCE(2505);
      END_STATE();
    case 1730:
      if (lookahead == 'd') ADVANCE(1312);
      END_STATE();
    case 1731:
      if (lookahead == 'd') ADVANCE(1501);
      END_STATE();
    case 1732:
      if (lookahead == 'd') ADVANCE(1760);
      END_STATE();
    case 1733:
      if (lookahead == 'd') ADVANCE(1939);
      if (lookahead == 'g') ADVANCE(2454);
      if (lookahead == 't') ADVANCE(2552);
      END_STATE();
    case 1734:
      if (lookahead == 'd') ADVANCE(2641);
      END_STATE();
    case 1735:
      if (lookahead == 'd') ADVANCE(1882);
      END_STATE();
    case 1736:
      if (lookahead == 'd') ADVANCE(1882);
      if (lookahead == 'e') ADVANCE(3727);
      if (lookahead == 'n') ADVANCE(1492);
      if (lookahead == 'o') ADVANCE(3729);
      if (lookahead == 'r') ADVANCE(1906);
      if (lookahead == 'w') ADVANCE(2125);
      END_STATE();
    case 1737:
      if (lookahead == 'd') ADVANCE(1882);
      if (lookahead == 'n') ADVANCE(1492);
      END_STATE();
    case 1738:
      if (lookahead == 'd') ADVANCE(1882);
      if (lookahead == 'n') ADVANCE(1492);
      if (lookahead == 'o') ADVANCE(2696);
      END_STATE();
    case 1739:
      if (lookahead == 'd') ADVANCE(1882);
      if (lookahead == 'o') ADVANCE(2696);
      if (lookahead == 'w') ADVANCE(2125);
      END_STATE();
    case 1740:
      if (lookahead == 'd') ADVANCE(1882);
      if (lookahead == 'r') ADVANCE(1906);
      END_STATE();
    case 1741:
      if (lookahead == 'd') ADVANCE(2643);
      END_STATE();
    case 1742:
      if (lookahead == 'd') ADVANCE(2644);
      END_STATE();
    case 1743:
      if (lookahead == 'd') ADVANCE(2649);
      END_STATE();
    case 1744:
      if (lookahead == 'd') ADVANCE(1750);
      if (lookahead == 'f') ADVANCE(2408);
      if (lookahead == 'l') ADVANCE(2131);
      if (lookahead == 'r') ADVANCE(1602);
      END_STATE();
    case 1745:
      if (lookahead == 'd') ADVANCE(1889);
      if (lookahead == 'w') ADVANCE(2139);
      END_STATE();
    case 1746:
      if (lookahead == 'd') ADVANCE(1925);
      END_STATE();
    case 1747:
      if (lookahead == 'd') ADVANCE(1335);
      END_STATE();
    case 1748:
      if (lookahead == 'd') ADVANCE(2922);
      END_STATE();
    case 1749:
      if (lookahead == 'd') ADVANCE(2922);
      if (lookahead == 'n') ADVANCE(2548);
      END_STATE();
    case 1750:
      if (lookahead == 'd') ADVANCE(2727);
      END_STATE();
    case 1751:
      if (lookahead == 'd') ADVANCE(2939);
      END_STATE();
    case 1752:
      if (lookahead == 'd') ADVANCE(2132);
      END_STATE();
    case 1753:
      if (lookahead == 'd') ADVANCE(1742);
      END_STATE();
    case 1754:
      if (lookahead == 'd') ADVANCE(1448);
      END_STATE();
    case 1755:
      if (lookahead == 'd') ADVANCE(1448);
      if (lookahead == 'm') ADVANCE(2523);
      END_STATE();
    case 1756:
      if (lookahead == 'd') ADVANCE(1914);
      END_STATE();
    case 1757:
      if (lookahead == 'd') ADVANCE(1743);
      END_STATE();
    case 1758:
      if (lookahead == 'd') ADVANCE(2145);
      END_STATE();
    case 1759:
      if (lookahead == 'd') ADVANCE(1945);
      END_STATE();
    case 1760:
      if (lookahead == 'd') ADVANCE(2693);
      END_STATE();
    case 1761:
      if (lookahead == 'd') ADVANCE(2706);
      END_STATE();
    case 1762:
      if (lookahead == 'd') ADVANCE(2711);
      END_STATE();
    case 1763:
      if (lookahead == 'd') ADVANCE(1330);
      END_STATE();
    case 1764:
      if (lookahead == 'd') ADVANCE(1761);
      END_STATE();
    case 1765:
      if (lookahead == 'd') ADVANCE(1992);
      END_STATE();
    case 1766:
      if (lookahead == 'd') ADVANCE(1762);
      END_STATE();
    case 1767:
      if (lookahead == 'd') ADVANCE(1337);
      END_STATE();
    case 1768:
      if (lookahead == 'd') ADVANCE(3683);
      END_STATE();
    case 1769:
      if (lookahead == 'd') ADVANCE(1768);
      if (lookahead == 'f') ADVANCE(2408);
      if (lookahead == 'l') ADVANCE(2127);
      if (lookahead == 'n') ADVANCE(1692);
      if (lookahead == 'p') ADVANCE(2599);
      if (lookahead == 'r') ADVANCE(1603);
      if (lookahead == 's') ADVANCE(2090);
      if (lookahead == 't') ADVANCE(2575);
      if (lookahead == 'v') ADVANCE(1472);
      END_STATE();
    case 1770:
      if (lookahead == 'd') ADVANCE(1768);
      if (lookahead == 'n') ADVANCE(1692);
      if (lookahead == 'p') ADVANCE(2599);
      if (lookahead == 's') ADVANCE(2090);
      if (lookahead == 'v') ADVANCE(1472);
      END_STATE();
    case 1771:
      if (lookahead == 'e') ADVANCE(1608);
      if (lookahead == 'i') ADVANCE(2782);
      if (lookahead == 'l') ADVANCE(2254);
      if (lookahead == 'o') ADVANCE(2902);
      if (lookahead == 's') ADVANCE(2514);
      END_STATE();
    case 1772:
      if (lookahead == 'e') ADVANCE(1363);
      END_STATE();
    case 1773:
      if (lookahead == 'e') ADVANCE(1397);
      if (lookahead == 'i') ADVANCE(2276);
      if (lookahead == 'r') ADVANCE(2169);
      END_STATE();
    case 1774:
      if (lookahead == 'e') ADVANCE(1397);
      if (lookahead == 'i') ADVANCE(2275);
      if (lookahead == 'r') ADVANCE(2169);
      END_STATE();
    case 1775:
      if (lookahead == 'e') ADVANCE(1787);
      END_STATE();
    case 1776:
      if (lookahead == 'e') ADVANCE(1787);
      if (lookahead == 'o') ADVANCE(2367);
      END_STATE();
    case 1777:
      if (lookahead == 'e') ADVANCE(3721);
      if (lookahead == 't') ADVANCE(3720);
      END_STATE();
    case 1778:
      if (lookahead == 'e') ADVANCE(3723);
      if (lookahead == 't') ADVANCE(3722);
      END_STATE();
    case 1779:
      if (lookahead == 'e') ADVANCE(3724);
      END_STATE();
    case 1780:
      if (lookahead == 'e') ADVANCE(1443);
      if (lookahead == 'i') ADVANCE(2944);
      if (lookahead == 'o') ADVANCE(2283);
      END_STATE();
    case 1781:
      if (lookahead == 'e') ADVANCE(3716);
      if (lookahead == 't') ADVANCE(3715);
      END_STATE();
    case 1782:
      if (lookahead == 'e') ADVANCE(3718);
      if (lookahead == 't') ADVANCE(3717);
      END_STATE();
    case 1783:
      if (lookahead == 'e') ADVANCE(2369);
      END_STATE();
    case 1784:
      if (lookahead == 'e') ADVANCE(3712);
      if (lookahead == 't') ADVANCE(3711);
      END_STATE();
    case 1785:
      if (lookahead == 'e') ADVANCE(3714);
      if (lookahead == 't') ADVANCE(3713);
      END_STATE();
    case 1786:
      if (lookahead == 'e') ADVANCE(3727);
      if (lookahead == 'o') ADVANCE(3728);
      END_STATE();
    case 1787:
      if (lookahead == 'e') ADVANCE(2995);
      if (lookahead == 'm') ADVANCE(3675);
      END_STATE();
    case 1788:
      if (lookahead == 'e') ADVANCE(2237);
      if (lookahead == 't') ADVANCE(2553);
      END_STATE();
    case 1789:
      if (lookahead == 'e') ADVANCE(3636);
      END_STATE();
    case 1790:
      if (lookahead == 'e') ADVANCE(3636);
      if (lookahead == 'l') ADVANCE(1400);
      if (lookahead == 'n') ADVANCE(2908);
      END_STATE();
    case 1791:
      if (lookahead == 'e') ADVANCE(1623);
      END_STATE();
    case 1792:
      if (lookahead == 'e') ADVANCE(3625);
      END_STATE();
    case 1793:
      if (lookahead == 'e') ADVANCE(3625);
      if (lookahead == 'n') ADVANCE(1581);
      END_STATE();
    case 1794:
      if (lookahead == 'e') ADVANCE(3788);
      END_STATE();
    case 1795:
      if (lookahead == 'e') ADVANCE(3628);
      END_STATE();
    case 1796:
      if (lookahead == 'e') ADVANCE(3615);
      END_STATE();
    case 1797:
      if (lookahead == 'e') ADVANCE(3609);
      END_STATE();
    case 1798:
      if (lookahead == 'e') ADVANCE(3087);
      END_STATE();
    case 1799:
      if (lookahead == 'e') ADVANCE(3220);
      END_STATE();
    case 1800:
      if (lookahead == 'e') ADVANCE(3546);
      END_STATE();
    case 1801:
      if (lookahead == 'e') ADVANCE(3565);
      END_STATE();
    case 1802:
      if (lookahead == 'e') ADVANCE(3784);
      END_STATE();
    case 1803:
      if (lookahead == 'e') ADVANCE(3351);
      END_STATE();
    case 1804:
      if (lookahead == 'e') ADVANCE(3250);
      END_STATE();
    case 1805:
      if (lookahead == 'e') ADVANCE(3544);
      END_STATE();
    case 1806:
      if (lookahead == 'e') ADVANCE(3082);
      END_STATE();
    case 1807:
      if (lookahead == 'e') ADVANCE(3271);
      END_STATE();
    case 1808:
      if (lookahead == 'e') ADVANCE(3760);
      END_STATE();
    case 1809:
      if (lookahead == 'e') ADVANCE(3086);
      END_STATE();
    case 1810:
      if (lookahead == 'e') ADVANCE(3620);
      END_STATE();
    case 1811:
      if (lookahead == 'e') ADVANCE(3336);
      END_STATE();
    case 1812:
      if (lookahead == 'e') ADVANCE(3360);
      END_STATE();
    case 1813:
      if (lookahead == 'e') ADVANCE(3399);
      END_STATE();
    case 1814:
      if (lookahead == 'e') ADVANCE(3402);
      END_STATE();
    case 1815:
      if (lookahead == 'e') ADVANCE(3090);
      END_STATE();
    case 1816:
      if (lookahead == 'e') ADVANCE(3762);
      END_STATE();
    case 1817:
      if (lookahead == 'e') ADVANCE(3456);
      END_STATE();
    case 1818:
      if (lookahead == 'e') ADVANCE(3105);
      END_STATE();
    case 1819:
      if (lookahead == 'e') ADVANCE(3357);
      END_STATE();
    case 1820:
      if (lookahead == 'e') ADVANCE(3295);
      END_STATE();
    case 1821:
      if (lookahead == 'e') ADVANCE(3405);
      END_STATE();
    case 1822:
      if (lookahead == 'e') ADVANCE(3803);
      END_STATE();
    case 1823:
      if (lookahead == 'e') ADVANCE(3608);
      END_STATE();
    case 1824:
      if (lookahead == 'e') ADVANCE(3276);
      END_STATE();
    case 1825:
      if (lookahead == 'e') ADVANCE(3302);
      END_STATE();
    case 1826:
      if (lookahead == 'e') ADVANCE(3333);
      END_STATE();
    case 1827:
      if (lookahead == 'e') ADVANCE(3501);
      END_STATE();
    case 1828:
      if (lookahead == 'e') ADVANCE(3366);
      END_STATE();
    case 1829:
      if (lookahead == 'e') ADVANCE(3378);
      END_STATE();
    case 1830:
      if (lookahead == 'e') ADVANCE(3369);
      END_STATE();
    case 1831:
      if (lookahead == 'e') ADVANCE(3768);
      END_STATE();
    case 1832:
      if (lookahead == 'e') ADVANCE(3495);
      END_STATE();
    case 1833:
      if (lookahead == 'e') ADVANCE(3623);
      END_STATE();
    case 1834:
      if (lookahead == 'e') ADVANCE(3348);
      END_STATE();
    case 1835:
      if (lookahead == 'e') ADVANCE(3537);
      END_STATE();
    case 1836:
      if (lookahead == 'e') ADVANCE(3305);
      END_STATE();
    case 1837:
      if (lookahead == 'e') ADVANCE(3621);
      END_STATE();
    case 1838:
      if (lookahead == 'e') ADVANCE(3441);
      END_STATE();
    case 1839:
      if (lookahead == 'e') ADVANCE(3468);
      END_STATE();
    case 1840:
      if (lookahead == 'e') ADVANCE(3802);
      END_STATE();
    case 1841:
      if (lookahead == 'e') ADVANCE(3417);
      END_STATE();
    case 1842:
      if (lookahead == 'e') ADVANCE(3515);
      END_STATE();
    case 1843:
      if (lookahead == 'e') ADVANCE(3129);
      END_STATE();
    case 1844:
      if (lookahead == 'e') ADVANCE(3085);
      END_STATE();
    case 1845:
      if (lookahead == 'e') ADVANCE(3390);
      END_STATE();
    case 1846:
      if (lookahead == 'e') ADVANCE(2040);
      if (lookahead == 'i') ADVANCE(2782);
      if (lookahead == 'l') ADVANCE(2254);
      if (lookahead == 'o') ADVANCE(2902);
      if (lookahead == 's') ADVANCE(2514);
      END_STATE();
    case 1847:
      if (lookahead == 'e') ADVANCE(1461);
      END_STATE();
    case 1848:
      if (lookahead == 'e') ADVANCE(1365);
      END_STATE();
    case 1849:
      if (lookahead == 'e') ADVANCE(3274);
      END_STATE();
    case 1850:
      if (lookahead == 'e') ADVANCE(1607);
      if (lookahead == 'l') ADVANCE(2254);
      if (lookahead == 'o') ADVANCE(2902);
      if (lookahead == 's') ADVANCE(2514);
      END_STATE();
    case 1851:
      if (lookahead == 'e') ADVANCE(3270);
      END_STATE();
    case 1852:
      if (lookahead == 'e') ADVANCE(2627);
      if (lookahead == 'g') ADVANCE(1777);
      if (lookahead == 'l') ADVANCE(1778);
      if (lookahead == 'n') ADVANCE(1779);
      if (lookahead == 'p') ADVANCE(1402);
      if (lookahead == 'r') ADVANCE(3690);
      END_STATE();
    case 1853:
      if (lookahead == 'e') ADVANCE(2627);
      if (lookahead == 'g') ADVANCE(1777);
      if (lookahead == 'l') ADVANCE(1778);
      if (lookahead == 'n') ADVANCE(1779);
      if (lookahead == 'p') ADVANCE(1402);
      if (lookahead == 'r') ADVANCE(1719);
      END_STATE();
    case 1854:
      if (lookahead == 'e') ADVANCE(2627);
      if (lookahead == 'g') ADVANCE(1777);
      if (lookahead == 'l') ADVANCE(1778);
      if (lookahead == 'n') ADVANCE(1779);
      if (lookahead == 'p') ADVANCE(1401);
      if (lookahead == 'r') ADVANCE(1719);
      END_STATE();
    case 1855:
      if (lookahead == 'e') ADVANCE(1609);
      if (lookahead == 'i') ADVANCE(2782);
      if (lookahead == 'o') ADVANCE(2902);
      END_STATE();
    case 1856:
      if (lookahead == 'e') ADVANCE(2659);
      END_STATE();
    case 1857:
      if (lookahead == 'e') ADVANCE(1442);
      if (lookahead == 'i') ADVANCE(2944);
      if (lookahead == 'o') ADVANCE(2283);
      END_STATE();
    case 1858:
      if (lookahead == 'e') ADVANCE(1442);
      if (lookahead == 'o') ADVANCE(2282);
      END_STATE();
    case 1859:
      if (lookahead == 'e') ADVANCE(2345);
      END_STATE();
    case 1860:
      if (lookahead == 'e') ADVANCE(2345);
      if (lookahead == 't') ADVANCE(2553);
      END_STATE();
    case 1861:
      if (lookahead == 'e') ADVANCE(1444);
      if (lookahead == 'i') ADVANCE(2944);
      if (lookahead == 'o') ADVANCE(2849);
      END_STATE();
    case 1862:
      if (lookahead == 'e') ADVANCE(1364);
      END_STATE();
    case 1863:
      if (lookahead == 'e') ADVANCE(2628);
      if (lookahead == 'g') ADVANCE(1784);
      if (lookahead == 'l') ADVANCE(1785);
      if (lookahead == 'n') ADVANCE(1786);
      if (lookahead == 's') ADVANCE(1966);
      if (lookahead == 'w') ADVANCE(2831);
      END_STATE();
    case 1864:
      if (lookahead == 'e') ADVANCE(2836);
      END_STATE();
    case 1865:
      if (lookahead == 'e') ADVANCE(2836);
      if (lookahead == 'h') ADVANCE(1663);
      END_STATE();
    case 1866:
      if (lookahead == 'e') ADVANCE(2050);
      END_STATE();
    case 1867:
      if (lookahead == 'e') ADVANCE(1462);
      END_STATE();
    case 1868:
      if (lookahead == 'e') ADVANCE(2020);
      END_STATE();
    case 1869:
      if (lookahead == 'e') ADVANCE(2629);
      END_STATE();
    case 1870:
      if (lookahead == 'e') ADVANCE(2968);
      if (lookahead == 't') ADVANCE(2504);
      END_STATE();
    case 1871:
      if (lookahead == 'e') ADVANCE(2041);
      END_STATE();
    case 1872:
      if (lookahead == 'e') ADVANCE(2052);
      END_STATE();
    case 1873:
      if (lookahead == 'e') ADVANCE(1366);
      END_STATE();
    case 1874:
      if (lookahead == 'e') ADVANCE(2078);
      END_STATE();
    case 1875:
      if (lookahead == 'e') ADVANCE(2967);
      if (lookahead == 'i') ADVANCE(2405);
      END_STATE();
    case 1876:
      if (lookahead == 'e') ADVANCE(2772);
      END_STATE();
    case 1877:
      if (lookahead == 'e') ADVANCE(2370);
      END_STATE();
    case 1878:
      if (lookahead == 'e') ADVANCE(2778);
      END_STATE();
    case 1879:
      if (lookahead == 'e') ADVANCE(2398);
      END_STATE();
    case 1880:
      if (lookahead == 'e') ADVANCE(1676);
      END_STATE();
    case 1881:
      if (lookahead == 'e') ADVANCE(1676);
      if (lookahead == 'i') ADVANCE(2708);
      END_STATE();
    case 1882:
      if (lookahead == 'e') ADVANCE(2022);
      END_STATE();
    case 1883:
      if (lookahead == 'e') ADVANCE(2975);
      END_STATE();
    case 1884:
      if (lookahead == 'e') ADVANCE(2372);
      END_STATE();
    case 1885:
      if (lookahead == 'e') ADVANCE(1314);
      END_STATE();
    case 1886:
      if (lookahead == 'e') ADVANCE(2672);
      if (lookahead == 'r') ADVANCE(1493);
      END_STATE();
    case 1887:
      if (lookahead == 'e') ADVANCE(2494);
      END_STATE();
    case 1888:
      if (lookahead == 'e') ADVANCE(2371);
      END_STATE();
    case 1889:
      if (lookahead == 'e') ADVANCE(2023);
      END_STATE();
    case 1890:
      if (lookahead == 'e') ADVANCE(2770);
      END_STATE();
    case 1891:
      if (lookahead == 'e') ADVANCE(2366);
      END_STATE();
    case 1892:
      if (lookahead == 'e') ADVANCE(1296);
      END_STATE();
    case 1893:
      if (lookahead == 'e') ADVANCE(2709);
      END_STATE();
    case 1894:
      if (lookahead == 'e') ADVANCE(1703);
      END_STATE();
    case 1895:
      if (lookahead == 'e') ADVANCE(1297);
      END_STATE();
    case 1896:
      if (lookahead == 'e') ADVANCE(1751);
      if (lookahead == 'u') ADVANCE(2615);
      END_STATE();
    case 1897:
      if (lookahead == 'e') ADVANCE(2360);
      END_STATE();
    case 1898:
      if (lookahead == 'e') ADVANCE(1321);
      END_STATE();
    case 1899:
      if (lookahead == 'e') ADVANCE(2038);
      END_STATE();
    case 1900:
      if (lookahead == 'e') ADVANCE(2415);
      END_STATE();
    case 1901:
      if (lookahead == 'e') ADVANCE(2238);
      END_STATE();
    case 1902:
      if (lookahead == 'e') ADVANCE(1476);
      END_STATE();
    case 1903:
      if (lookahead == 'e') ADVANCE(2063);
      END_STATE();
    case 1904:
      if (lookahead == 'e') ADVANCE(2731);
      END_STATE();
    case 1905:
      if (lookahead == 'e') ADVANCE(2368);
      END_STATE();
    case 1906:
      if (lookahead == 'e') ADVANCE(1498);
      END_STATE();
    case 1907:
      if (lookahead == 'e') ADVANCE(2639);
      END_STATE();
    case 1908:
      if (lookahead == 'e') ADVANCE(2749);
      END_STATE();
    case 1909:
      if (lookahead == 'e') ADVANCE(2039);
      if (lookahead == 'l') ADVANCE(2254);
      if (lookahead == 'o') ADVANCE(2902);
      if (lookahead == 's') ADVANCE(2514);
      END_STATE();
    case 1910:
      if (lookahead == 'e') ADVANCE(2039);
      if (lookahead == 'l') ADVANCE(2254);
      if (lookahead == 's') ADVANCE(2514);
      END_STATE();
    case 1911:
      if (lookahead == 'e') ADVANCE(2453);
      END_STATE();
    case 1912:
      if (lookahead == 'e') ADVANCE(2657);
      END_STATE();
    case 1913:
      if (lookahead == 'e') ADVANCE(1747);
      END_STATE();
    case 1914:
      if (lookahead == 'e') ADVANCE(2418);
      END_STATE();
    case 1915:
      if (lookahead == 'e') ADVANCE(1677);
      END_STATE();
    case 1916:
      if (lookahead == 'e') ADVANCE(2242);
      END_STATE();
    case 1917:
      if (lookahead == 'e') ADVANCE(2734);
      END_STATE();
    case 1918:
      if (lookahead == 'e') ADVANCE(1316);
      END_STATE();
    case 1919:
      if (lookahead == 'e') ADVANCE(1707);
      if (lookahead == 's') ADVANCE(1319);
      END_STATE();
    case 1920:
      if (lookahead == 'e') ADVANCE(1708);
      END_STATE();
    case 1921:
      if (lookahead == 'e') ADVANCE(2798);
      END_STATE();
    case 1922:
      if (lookahead == 'e') ADVANCE(1709);
      END_STATE();
    case 1923:
      if (lookahead == 'e') ADVANCE(1422);
      END_STATE();
    case 1924:
      if (lookahead == 'e') ADVANCE(2668);
      END_STATE();
    case 1925:
      if (lookahead == 'e') ADVANCE(2645);
      END_STATE();
    case 1926:
      if (lookahead == 'e') ADVANCE(1712);
      END_STATE();
    case 1927:
      if (lookahead == 'e') ADVANCE(1589);
      END_STATE();
    case 1928:
      if (lookahead == 'e') ADVANCE(1396);
      END_STATE();
    case 1929:
      if (lookahead == 'e') ADVANCE(1396);
      if (lookahead == 'i') ADVANCE(2274);
      if (lookahead == 'r') ADVANCE(2169);
      END_STATE();
    case 1930:
      if (lookahead == 'e') ADVANCE(1616);
      END_STATE();
    case 1931:
      if (lookahead == 'e') ADVANCE(1675);
      END_STATE();
    case 1932:
      if (lookahead == 'e') ADVANCE(1431);
      if (lookahead == 'i') ADVANCE(2274);
      if (lookahead == 'r') ADVANCE(2169);
      END_STATE();
    case 1933:
      if (lookahead == 'e') ADVANCE(2648);
      END_STATE();
    case 1934:
      if (lookahead == 'e') ADVANCE(1715);
      END_STATE();
    case 1935:
      if (lookahead == 'e') ADVANCE(1591);
      END_STATE();
    case 1936:
      if (lookahead == 'e') ADVANCE(2719);
      END_STATE();
    case 1937:
      if (lookahead == 'e') ADVANCE(2888);
      END_STATE();
    case 1938:
      if (lookahead == 'e') ADVANCE(1620);
      END_STATE();
    case 1939:
      if (lookahead == 'e') ADVANCE(1958);
      END_STATE();
    case 1940:
      if (lookahead == 'e') ADVANCE(1460);
      END_STATE();
    case 1941:
      if (lookahead == 'e') ADVANCE(2805);
      END_STATE();
    case 1942:
      if (lookahead == 'e') ADVANCE(2651);
      END_STATE();
    case 1943:
      if (lookahead == 'e') ADVANCE(2284);
      END_STATE();
    case 1944:
      if (lookahead == 'e') ADVANCE(1803);
      END_STATE();
    case 1945:
      if (lookahead == 'e') ADVANCE(2492);
      END_STATE();
    case 1946:
      if (lookahead == 'e') ADVANCE(2489);
      END_STATE();
    case 1947:
      if (lookahead == 'e') ADVANCE(2825);
      END_STATE();
    case 1948:
      if (lookahead == 'e') ADVANCE(2788);
      END_STATE();
    case 1949:
      if (lookahead == 'e') ADVANCE(2011);
      END_STATE();
    case 1950:
      if (lookahead == 'e') ADVANCE(1429);
      END_STATE();
    case 1951:
      if (lookahead == 'e') ADVANCE(2674);
      END_STATE();
    case 1952:
      if (lookahead == 'e') ADVANCE(2828);
      END_STATE();
    case 1953:
      if (lookahead == 'e') ADVANCE(2828);
      if (lookahead == 'i') ADVANCE(2498);
      if (lookahead == 'o') ADVANCE(1749);
      if (lookahead == 's') ADVANCE(2580);
      if (lookahead == 'u') ADVANCE(2762);
      END_STATE();
    case 1954:
      if (lookahead == 'e') ADVANCE(2828);
      if (lookahead == 'i') ADVANCE(2498);
      if (lookahead == 'o') ADVANCE(1749);
      if (lookahead == 'u') ADVANCE(2762);
      END_STATE();
    case 1955:
      if (lookahead == 'e') ADVANCE(2828);
      if (lookahead == 'i') ADVANCE(2498);
      if (lookahead == 'o') ADVANCE(1748);
      if (lookahead == 'u') ADVANCE(2762);
      END_STATE();
    case 1956:
      if (lookahead == 'e') ADVANCE(2723);
      END_STATE();
    case 1957:
      if (lookahead == 'e') ADVANCE(2392);
      END_STATE();
    case 1958:
      if (lookahead == 'e') ADVANCE(2044);
      END_STATE();
    case 1959:
      if (lookahead == 'e') ADVANCE(2632);
      END_STATE();
    case 1960:
      if (lookahead == 'e') ADVANCE(2969);
      END_STATE();
    case 1961:
      if (lookahead == 'e') ADVANCE(1334);
      END_STATE();
    case 1962:
      if (lookahead == 'e') ADVANCE(1630);
      END_STATE();
    case 1963:
      if (lookahead == 'e') ADVANCE(2946);
      END_STATE();
    case 1964:
      if (lookahead == 'e') ADVANCE(1438);
      END_STATE();
    case 1965:
      if (lookahead == 'e') ADVANCE(1318);
      END_STATE();
    case 1966:
      if (lookahead == 'e') ADVANCE(2289);
      END_STATE();
    case 1967:
      if (lookahead == 'e') ADVANCE(1333);
      END_STATE();
    case 1968:
      if (lookahead == 'e') ADVANCE(2973);
      END_STATE();
    case 1969:
      if (lookahead == 'e') ADVANCE(2681);
      END_STATE();
    case 1970:
      if (lookahead == 'e') ADVANCE(2758);
      END_STATE();
    case 1971:
      if (lookahead == 'e') ADVANCE(2750);
      END_STATE();
    case 1972:
      if (lookahead == 'e') ADVANCE(2970);
      END_STATE();
    case 1973:
      if (lookahead == 'e') ADVANCE(2970);
      if (lookahead == 'i') ADVANCE(2477);
      END_STATE();
    case 1974:
      if (lookahead == 'e') ADVANCE(2753);
      END_STATE();
    case 1975:
      if (lookahead == 'e') ADVANCE(2754);
      END_STATE();
    case 1976:
      if (lookahead == 'e') ADVANCE(2463);
      END_STATE();
    case 1977:
      if (lookahead == 'e') ADVANCE(2390);
      END_STATE();
    case 1978:
      if (lookahead == 'e') ADVANCE(1667);
      END_STATE();
    case 1979:
      if (lookahead == 'e') ADVANCE(1455);
      END_STATE();
    case 1980:
      if (lookahead == 'e') ADVANCE(2678);
      END_STATE();
    case 1981:
      if (lookahead == 'e') ADVANCE(2724);
      END_STATE();
    case 1982:
      if (lookahead == 'e') ADVANCE(2464);
      END_STATE();
    case 1983:
      if (lookahead == 'e') ADVANCE(1478);
      END_STATE();
    case 1984:
      if (lookahead == 'e') ADVANCE(2534);
      END_STATE();
    case 1985:
      if (lookahead == 'e') ADVANCE(1641);
      END_STATE();
    case 1986:
      if (lookahead == 'e') ADVANCE(2466);
      END_STATE();
    case 1987:
      if (lookahead == 'e') ADVANCE(1646);
      END_STATE();
    case 1988:
      if (lookahead == 'e') ADVANCE(2467);
      END_STATE();
    case 1989:
      if (lookahead == 'e') ADVANCE(2690);
      END_STATE();
    case 1990:
      if (lookahead == 'e') ADVANCE(1647);
      END_STATE();
    case 1991:
      if (lookahead == 'e') ADVANCE(2468);
      END_STATE();
    case 1992:
      if (lookahead == 'e') ADVANCE(2691);
      END_STATE();
    case 1993:
      if (lookahead == 'e') ADVANCE(1648);
      END_STATE();
    case 1994:
      if (lookahead == 'e') ADVANCE(2286);
      END_STATE();
    case 1995:
      if (lookahead == 'e') ADVANCE(2099);
      END_STATE();
    case 1996:
      if (lookahead == 'e') ADVANCE(2400);
      END_STATE();
    case 1997:
      if (lookahead == 'e') ADVANCE(2698);
      END_STATE();
    case 1998:
      if (lookahead == 'e') ADVANCE(2698);
      if (lookahead == 'r') ADVANCE(1493);
      END_STATE();
    case 1999:
      if (lookahead == 'e') ADVANCE(2712);
      END_STATE();
    case 2000:
      if (lookahead == 'e') ADVANCE(2495);
      END_STATE();
    case 2001:
      if (lookahead == 'e') ADVANCE(2395);
      END_STATE();
    case 2002:
      if (lookahead == 'e') ADVANCE(2676);
      if (lookahead == 't') ADVANCE(2553);
      END_STATE();
    case 2003:
      if (lookahead == 'e') ADVANCE(2487);
      END_STATE();
    case 2004:
      if (lookahead == 'e') ADVANCE(2397);
      END_STATE();
    case 2005:
      if (lookahead == 'e') ADVANCE(2403);
      END_STATE();
    case 2006:
      if (lookahead == 'e') ADVANCE(2725);
      END_STATE();
    case 2007:
      if (lookahead == 'e') ADVANCE(1542);
      END_STATE();
    case 2008:
      if (lookahead == 'e') ADVANCE(2363);
      if (lookahead == 'v') ADVANCE(1459);
      END_STATE();
    case 2009:
      if (lookahead == 'e') ADVANCE(1767);
      END_STATE();
    case 2010:
      if (lookahead == 'e') ADVANCE(2364);
      if (lookahead == 'v') ADVANCE(1525);
      END_STATE();
    case 2011:
      if (lookahead == 'e') ADVANCE(2407);
      END_STATE();
    case 2012:
      if (lookahead == 'f') ADVANCE(2408);
      if (lookahead == 'l') ADVANCE(2128);
      if (lookahead == 'r') ADVANCE(1603);
      if (lookahead == 't') ADVANCE(2827);
      END_STATE();
    case 2013:
      if (lookahead == 'f') ADVANCE(2348);
      END_STATE();
    case 2014:
      if (lookahead == 'f') ADVANCE(2348);
      if (lookahead == 'i') ADVANCE(2865);
      if (lookahead == 'l') ADVANCE(2515);
      END_STATE();
    case 2015:
      if (lookahead == 'f') ADVANCE(2348);
      if (lookahead == 'i') ADVANCE(2865);
      if (lookahead == 'l') ADVANCE(2515);
      if (lookahead == 'r') ADVANCE(3542);
      if (lookahead == 'u') ADVANCE(2162);
      if (lookahead == 'y') ADVANCE(2663);
      END_STATE();
    case 2016:
      if (lookahead == 'f') ADVANCE(2348);
      if (lookahead == 'i') ADVANCE(2865);
      if (lookahead == 'l') ADVANCE(2515);
      if (lookahead == 'u') ADVANCE(2162);
      if (lookahead == 'y') ADVANCE(2663);
      END_STATE();
    case 2017:
      if (lookahead == 'f') ADVANCE(2348);
      if (lookahead == 'u') ADVANCE(2162);
      if (lookahead == 'y') ADVANCE(2663);
      END_STATE();
    case 2018:
      if (lookahead == 'f') ADVANCE(3211);
      END_STATE();
    case 2019:
      if (lookahead == 'f') ADVANCE(3771);
      END_STATE();
    case 2020:
      if (lookahead == 'f') ADVANCE(3486);
      END_STATE();
    case 2021:
      if (lookahead == 'f') ADVANCE(3194);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3202);
      END_STATE();
    case 2022:
      if (lookahead == 'f') ADVANCE(3639);
      END_STATE();
    case 2023:
      if (lookahead == 'f') ADVANCE(3534);
      END_STATE();
    case 2024:
      if (lookahead == 'f') ADVANCE(3519);
      END_STATE();
    case 2025:
      if (lookahead == 'f') ADVANCE(2924);
      if (lookahead == 'm') ADVANCE(2377);
      if (lookahead == 'n') ADVANCE(1356);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3258);
      END_STATE();
    case 2026:
      if (lookahead == 'f') ADVANCE(2046);
      END_STATE();
    case 2027:
      if (lookahead == 'f') ADVANCE(2524);
      if (lookahead == 'n') ADVANCE(2563);
      if (lookahead == 's') ADVANCE(2168);
      END_STATE();
    case 2028:
      if (lookahead == 'f') ADVANCE(2585);
      END_STATE();
    case 2029:
      if (lookahead == 'f') ADVANCE(2904);
      END_STATE();
    case 2030:
      if (lookahead == 'f') ADVANCE(2586);
      END_STATE();
    case 2031:
      if (lookahead == 'f') ADVANCE(2587);
      END_STATE();
    case 2032:
      if (lookahead == 'f') ADVANCE(2793);
      END_STATE();
    case 2033:
      if (lookahead == 'f') ADVANCE(2793);
      if (lookahead == 't') ADVANCE(1610);
      END_STATE();
    case 2034:
      if (lookahead == 'f') ADVANCE(1876);
      if (lookahead == 'm') ADVANCE(1878);
      if (lookahead == 'n') ADVANCE(2178);
      END_STATE();
    case 2035:
      if (lookahead == 'f') ADVANCE(1876);
      if (lookahead == 'n') ADVANCE(2178);
      END_STATE();
    case 2036:
      if (lookahead == 'f') ADVANCE(2590);
      END_STATE();
    case 2037:
      if (lookahead == 'f') ADVANCE(2109);
      END_STATE();
    case 2038:
      if (lookahead == 'f') ADVANCE(2737);
      END_STATE();
    case 2039:
      if (lookahead == 'f') ADVANCE(1483);
      END_STATE();
    case 2040:
      if (lookahead == 'f') ADVANCE(1483);
      if (lookahead == 'r') ADVANCE(1871);
      END_STATE();
    case 2041:
      if (lookahead == 'f') ADVANCE(1989);
      END_STATE();
    case 2042:
      if (lookahead == 'f') ADVANCE(2824);
      END_STATE();
    case 2043:
      if (lookahead == 'f') ADVANCE(2824);
      if (lookahead == 't') ADVANCE(1610);
      END_STATE();
    case 2044:
      if (lookahead == 'f') ADVANCE(2048);
      END_STATE();
    case 2045:
      if (lookahead == 'f') ADVANCE(2144);
      END_STATE();
    case 2046:
      if (lookahead == 'f') ADVANCE(2316);
      END_STATE();
    case 2047:
      if (lookahead == 'f') ADVANCE(2194);
      END_STATE();
    case 2048:
      if (lookahead == 'f') ADVANCE(1987);
      END_STATE();
    case 2049:
      if (lookahead == 'f') ADVANCE(2354);
      END_STATE();
    case 2050:
      if (lookahead == 'g') ADVANCE(3558);
      END_STATE();
    case 2051:
      if (lookahead == 'g') ADVANCE(3677);
      END_STATE();
    case 2052:
      if (lookahead == 'g') ADVANCE(3480);
      END_STATE();
    case 2053:
      if (lookahead == 'g') ADVANCE(3531);
      END_STATE();
    case 2054:
      if (lookahead == 'g') ADVANCE(3586);
      END_STATE();
    case 2055:
      if (lookahead == 'g') ADVANCE(3611);
      END_STATE();
    case 2056:
      if (lookahead == 'g') ADVANCE(3112);
      END_STATE();
    case 2057:
      if (lookahead == 'g') ADVANCE(3447);
      END_STATE();
    case 2058:
      if (lookahead == 'g') ADVANCE(3396);
      END_STATE();
    case 2059:
      if (lookahead == 'g') ADVANCE(3435);
      END_STATE();
    case 2060:
      if (lookahead == 'g') ADVANCE(3438);
      END_STATE();
    case 2061:
      if (lookahead == 'g') ADVANCE(2386);
      END_STATE();
    case 2062:
      if (lookahead == 'g') ADVANCE(2386);
      if (lookahead == 'm') ADVANCE(1300);
      END_STATE();
    case 2063:
      if (lookahead == 'g') ADVANCE(58);
      END_STATE();
    case 2064:
      if (lookahead == 'g') ADVANCE(2927);
      END_STATE();
    case 2065:
      if (lookahead == 'g') ADVANCE(2454);
      END_STATE();
    case 2066:
      if (lookahead == 'g') ADVANCE(2454);
      if (lookahead == 't') ADVANCE(2552);
      END_STATE();
    case 2067:
      if (lookahead == 'g') ADVANCE(2414);
      END_STATE();
    case 2068:
      if (lookahead == 'g') ADVANCE(2598);
      END_STATE();
    case 2069:
      if (lookahead == 'g') ADVANCE(2614);
      END_STATE();
    case 2070:
      if (lookahead == 'g') ADVANCE(1970);
      END_STATE();
    case 2071:
      if (lookahead == 'g') ADVANCE(1921);
      END_STATE();
    case 2072:
      if (lookahead == 'g') ADVANCE(2430);
      END_STATE();
    case 2073:
      if (lookahead == 'g') ADVANCE(1810);
      END_STATE();
    case 2074:
      if (lookahead == 'g') ADVANCE(1812);
      END_STATE();
    case 2075:
      if (lookahead == 'g') ADVANCE(1839);
      END_STATE();
    case 2076:
      if (lookahead == 'g') ADVANCE(1845);
      END_STATE();
    case 2077:
      if (lookahead == 'g') ADVANCE(2916);
      END_STATE();
    case 2078:
      if (lookahead == 'g') ADVANCE(1634);
      END_STATE();
    case 2079:
      if (lookahead == 'g') ADVANCE(1976);
      END_STATE();
    case 2080:
      if (lookahead == 'g') ADVANCE(2700);
      END_STATE();
    case 2081:
      if (lookahead == 'g') ADVANCE(2402);
      END_STATE();
    case 2082:
      if (lookahead == 'h') ADVANCE(1663);
      END_STATE();
    case 2083:
      if (lookahead == 'h') ADVANCE(108);
      END_STATE();
    case 2084:
      if (lookahead == 'h') ADVANCE(3650);
      END_STATE();
    case 2085:
      if (lookahead == 'h') ADVANCE(3563);
      END_STATE();
    case 2086:
      if (lookahead == 'h') ADVANCE(3574);
      END_STATE();
    case 2087:
      if (lookahead == 'h') ADVANCE(3648);
      END_STATE();
    case 2088:
      if (lookahead == 'h') ADVANCE(2612);
      END_STATE();
    case 2089:
      if (lookahead == 'h') ADVANCE(3800);
      END_STATE();
    case 2090:
      if (lookahead == 'h') ADVANCE(2636);
      END_STATE();
    case 2091:
      if (lookahead == 'h') ADVANCE(2636);
      if (lookahead == 'm') ADVANCE(3785);
      END_STATE();
    case 2092:
      if (lookahead == 'h') ADVANCE(2051);
      END_STATE();
    case 2093:
      if (lookahead == 'h') ADVANCE(2637);
      END_STATE();
    case 2094:
      if (lookahead == 'h') ADVANCE(2055);
      END_STATE();
    case 2095:
      if (lookahead == 'h') ADVANCE(1930);
      END_STATE();
    case 2096:
      if (lookahead == 'h') ADVANCE(1938);
      END_STATE();
    case 2097:
      if (lookahead == 'h') ADVANCE(2136);
      END_STATE();
    case 2098:
      if (lookahead == 'h') ADVANCE(1481);
      END_STATE();
    case 2099:
      if (lookahead == 'h') ADVANCE(2182);
      END_STATE();
    case 2100:
      if (lookahead == 'h') ADVANCE(2721);
      END_STATE();
    case 2101:
      if (lookahead == 'h') ADVANCE(1539);
      END_STATE();
    case 2102:
      if (lookahead == 'i') ADVANCE(2865);
      if (lookahead == 'l') ADVANCE(2515);
      END_STATE();
    case 2103:
      if (lookahead == 'i') ADVANCE(1408);
      if (lookahead == 'l') ADVANCE(2521);
      if (lookahead == 'w') ADVANCE(1367);
      END_STATE();
    case 2104:
      if (lookahead == 'i') ADVANCE(1408);
      if (lookahead == 'l') ADVANCE(2542);
      if (lookahead == 'w') ADVANCE(1367);
      END_STATE();
    case 2105:
      if (lookahead == 'i') ADVANCE(3588);
      END_STATE();
    case 2106:
      if (lookahead == 'i') ADVANCE(2033);
      END_STATE();
    case 2107:
      if (lookahead == 'i') ADVANCE(3750);
      END_STATE();
    case 2108:
      if (lookahead == 'i') ADVANCE(3748);
      END_STATE();
    case 2109:
      if (lookahead == 'i') ADVANCE(3088);
      END_STATE();
    case 2110:
      if (lookahead == 'i') ADVANCE(2940);
      END_STATE();
    case 2111:
      if (lookahead == 'i') ADVANCE(1726);
      END_STATE();
    case 2112:
      if (lookahead == 'i') ADVANCE(2409);
      if (lookahead == 's') ADVANCE(2093);
      END_STATE();
    case 2113:
      if (lookahead == 'i') ADVANCE(2944);
      if (lookahead == 'o') ADVANCE(2849);
      END_STATE();
    case 2114:
      if (lookahead == 'i') ADVANCE(2941);
      END_STATE();
    case 2115:
      if (lookahead == 'i') ADVANCE(2431);
      if (lookahead == 'n') ADVANCE(1409);
      if (lookahead == 's') ADVANCE(2952);
      if (lookahead == 'u') ADVANCE(2312);
      END_STATE();
    case 2116:
      if (lookahead == 'i') ADVANCE(2942);
      END_STATE();
    case 2117:
      if (lookahead == 'i') ADVANCE(1552);
      END_STATE();
    case 2118:
      if (lookahead == 'i') ADVANCE(2962);
      END_STATE();
    case 2119:
      if (lookahead == 'i') ADVANCE(2613);
      if (lookahead == 'u') ADVANCE(1793);
      END_STATE();
    case 2120:
      if (lookahead == 'i') ADVANCE(2235);
      if (lookahead == 'r') ADVANCE(2071);
      END_STATE();
    case 2121:
      if (lookahead == 'i') ADVANCE(1702);
      END_STATE();
    case 2122:
      if (lookahead == 'i') ADVANCE(1702);
      if (lookahead == 'l') ADVANCE(1446);
      END_STATE();
    case 2123:
      if (lookahead == 'i') ADVANCE(2769);
      END_STATE();
    case 2124:
      if (lookahead == 'i') ADVANCE(2032);
      END_STATE();
    case 2125:
      if (lookahead == 'i') ADVANCE(2442);
      END_STATE();
    case 2126:
      if (lookahead == 'i') ADVANCE(1582);
      END_STATE();
    case 2127:
      if (lookahead == 'i') ADVANCE(2067);
      if (lookahead == 'l') ADVANCE(2521);
      if (lookahead == 'w') ADVANCE(1367);
      END_STATE();
    case 2128:
      if (lookahead == 'i') ADVANCE(2067);
      if (lookahead == 'l') ADVANCE(2542);
      if (lookahead == 'w') ADVANCE(1367);
      END_STATE();
    case 2129:
      if (lookahead == 'i') ADVANCE(2241);
      END_STATE();
    case 2130:
      if (lookahead == 'i') ADVANCE(1433);
      END_STATE();
    case 2131:
      if (lookahead == 'i') ADVANCE(2072);
      END_STATE();
    case 2132:
      if (lookahead == 'i') ADVANCE(2476);
      END_STATE();
    case 2133:
      if (lookahead == 'i') ADVANCE(2748);
      END_STATE();
    case 2134:
      if (lookahead == 'i') ADVANCE(2832);
      END_STATE();
    case 2135:
      if (lookahead == 'i') ADVANCE(1668);
      END_STATE();
    case 2136:
      if (lookahead == 'i') ADVANCE(2421);
      END_STATE();
    case 2137:
      if (lookahead == 'i') ADVANCE(2246);
      END_STATE();
    case 2138:
      if (lookahead == 'i') ADVANCE(2422);
      END_STATE();
    case 2139:
      if (lookahead == 'i') ADVANCE(2446);
      END_STATE();
    case 2140:
      if (lookahead == 'i') ADVANCE(1590);
      END_STATE();
    case 2141:
      if (lookahead == 'i') ADVANCE(2775);
      if (lookahead == 'o') ADVANCE(2902);
      END_STATE();
    case 2142:
      if (lookahead == 'i') ADVANCE(1714);
      END_STATE();
    case 2143:
      if (lookahead == 'i') ADVANCE(2497);
      END_STATE();
    case 2144:
      if (lookahead == 'i') ADVANCE(2346);
      END_STATE();
    case 2145:
      if (lookahead == 'i') ADVANCE(2438);
      END_STATE();
    case 2146:
      if (lookahead == 'i') ADVANCE(1592);
      END_STATE();
    case 2147:
      if (lookahead == 'i') ADVANCE(2425);
      END_STATE();
    case 2148:
      if (lookahead == 'i') ADVANCE(2490);
      END_STATE();
    case 2149:
      if (lookahead == 'i') ADVANCE(1643);
      END_STATE();
    case 2150:
      if (lookahead == 'i') ADVANCE(2450);
      END_STATE();
    case 2151:
      if (lookahead == 'i') ADVANCE(1598);
      END_STATE();
    case 2152:
      if (lookahead == 'i') ADVANCE(2440);
      END_STATE();
    case 2153:
      if (lookahead == 'i') ADVANCE(2274);
      if (lookahead == 'r') ADVANCE(2169);
      END_STATE();
    case 2154:
      if (lookahead == 'i') ADVANCE(2482);
      END_STATE();
    case 2155:
      if (lookahead == 'i') ADVANCE(2444);
      END_STATE();
    case 2156:
      if (lookahead == 'i') ADVANCE(2837);
      END_STATE();
    case 2157:
      if (lookahead == 'i') ADVANCE(2835);
      END_STATE();
    case 2158:
      if (lookahead == 'i') ADVANCE(2881);
      END_STATE();
    case 2159:
      if (lookahead == 'i') ADVANCE(2043);
      END_STATE();
    case 2160:
      if (lookahead == 'i') ADVANCE(2996);
      END_STATE();
    case 2161:
      if (lookahead == 'i') ADVANCE(1568);
      END_STATE();
    case 2162:
      if (lookahead == 'i') ADVANCE(2339);
      END_STATE();
    case 2163:
      if (lookahead == 'i') ADVANCE(2949);
      END_STATE();
    case 2164:
      if (lookahead == 'i') ADVANCE(2361);
      END_STATE();
    case 2165:
      if (lookahead == 'i') ADVANCE(2459);
      END_STATE();
    case 2166:
      if (lookahead == 'i') ADVANCE(2477);
      END_STATE();
    case 2167:
      if (lookahead == 'i') ADVANCE(2042);
      END_STATE();
    case 2168:
      if (lookahead == 'i') ADVANCE(2997);
      END_STATE();
    case 2169:
      if (lookahead == 'i') ADVANCE(2852);
      END_STATE();
    case 2170:
      if (lookahead == 'i') ADVANCE(1632);
      END_STATE();
    case 2171:
      if (lookahead == 'i') ADVANCE(2462);
      END_STATE();
    case 2172:
      if (lookahead == 'i') ADVANCE(2460);
      END_STATE();
    case 2173:
      if (lookahead == 'i') ADVANCE(2998);
      END_STATE();
    case 2174:
      if (lookahead == 'i') ADVANCE(1682);
      END_STATE();
    case 2175:
      if (lookahead == 'i') ADVANCE(2999);
      END_STATE();
    case 2176:
      if (lookahead == 'i') ADVANCE(2486);
      END_STATE();
    case 2177:
      if (lookahead == 'i') ADVANCE(2720);
      END_STATE();
    case 2178:
      if (lookahead == 'i') ADVANCE(2892);
      END_STATE();
    case 2179:
      if (lookahead == 'i') ADVANCE(2471);
      END_STATE();
    case 2180:
      if (lookahead == 'i') ADVANCE(2532);
      END_STATE();
    case 2181:
      if (lookahead == 'i') ADVANCE(3000);
      END_STATE();
    case 2182:
      if (lookahead == 'i') ADVANCE(2465);
      END_STATE();
    case 2183:
      if (lookahead == 'i') ADVANCE(3001);
      END_STATE();
    case 2184:
      if (lookahead == 'i') ADVANCE(2688);
      END_STATE();
    case 2185:
      if (lookahead == 'i') ADVANCE(1653);
      END_STATE();
    case 2186:
      if (lookahead == 'i') ADVANCE(3002);
      END_STATE();
    case 2187:
      if (lookahead == 'i') ADVANCE(2474);
      END_STATE();
    case 2188:
      if (lookahead == 'i') ADVANCE(3003);
      END_STATE();
    case 2189:
      if (lookahead == 'i') ADVANCE(2543);
      END_STATE();
    case 2190:
      if (lookahead == 'i') ADVANCE(2319);
      END_STATE();
    case 2191:
      if (lookahead == 'i') ADVANCE(3004);
      END_STATE();
    case 2192:
      if (lookahead == 'i') ADVANCE(1507);
      END_STATE();
    case 2193:
      if (lookahead == 'i') ADVANCE(2546);
      END_STATE();
    case 2194:
      if (lookahead == 'i') ADVANCE(2322);
      END_STATE();
    case 2195:
      if (lookahead == 'i') ADVANCE(2771);
      END_STATE();
    case 2196:
      if (lookahead == 'i') ADVANCE(2344);
      END_STATE();
    case 2197:
      if (lookahead == 'i') ADVANCE(2344);
      if (lookahead == 'r') ADVANCE(2071);
      END_STATE();
    case 2198:
      if (lookahead == 'i') ADVANCE(2890);
      END_STATE();
    case 2199:
      if (lookahead == 'i') ADVANCE(1513);
      END_STATE();
    case 2200:
      if (lookahead == 'i') ADVANCE(1518);
      END_STATE();
    case 2201:
      if (lookahead == 'i') ADVANCE(2889);
      END_STATE();
    case 2202:
      if (lookahead == 'i') ADVANCE(2353);
      END_STATE();
    case 2203:
      if (lookahead == 'i') ADVANCE(2726);
      END_STATE();
    case 2204:
      if (lookahead == 'i') ADVANCE(2893);
      END_STATE();
    case 2205:
      if (lookahead == 'i') ADVANCE(1544);
      END_STATE();
    case 2206:
      if (lookahead == 'i') ADVANCE(2897);
      END_STATE();
    case 2207:
      if (lookahead == 'i') ADVANCE(1684);
      END_STATE();
    case 2208:
      if (lookahead == 'i') ADVANCE(2894);
      END_STATE();
    case 2209:
      if (lookahead == 'i') ADVANCE(2500);
      END_STATE();
    case 2210:
      if (lookahead == 'j') ADVANCE(3171);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3172);
      END_STATE();
    case 2211:
      if (lookahead == 'j') ADVANCE(2931);
      END_STATE();
    case 2212:
      if (lookahead == 'k') ADVANCE(3099);
      END_STATE();
    case 2213:
      if (lookahead == 'k') ADVANCE(3420);
      END_STATE();
    case 2214:
      if (lookahead == 'k') ADVANCE(3299);
      END_STATE();
    case 2215:
      if (lookahead == 'k') ADVANCE(3459);
      END_STATE();
    case 2216:
      if (lookahead == 'k') ADVANCE(3118);
      END_STATE();
    case 2217:
      if (lookahead == 'k') ADVANCE(3462);
      END_STATE();
    case 2218:
      if (lookahead == 'k') ADVANCE(3096);
      END_STATE();
    case 2219:
      if (lookahead == 'k') ADVANCE(2571);
      END_STATE();
    case 2220:
      if (lookahead == 'k') ADVANCE(1894);
      END_STATE();
    case 2221:
      if (lookahead == 'k') ADVANCE(1894);
      if (lookahead == 'n') ADVANCE(1699);
      END_STATE();
    case 2222:
      if (lookahead == 'k') ADVANCE(1477);
      END_STATE();
    case 2223:
      if (lookahead == 'k') ADVANCE(2134);
      END_STATE();
    case 2224:
      if (lookahead == 'k') ADVANCE(1801);
      END_STATE();
    case 2225:
      if (lookahead == 'k') ADVANCE(1900);
      END_STATE();
    case 2226:
      if (lookahead == 'k') ADVANCE(1639);
      END_STATE();
    case 2227:
      if (lookahead == 'l') ADVANCE(2018);
      END_STATE();
    case 2228:
      if (lookahead == 'l') ADVANCE(3655);
      END_STATE();
    case 2229:
      if (lookahead == 'l') ADVANCE(3655);
      if (lookahead == 's') ADVANCE(2785);
      END_STATE();
    case 2230:
      if (lookahead == 'l') ADVANCE(3655);
      if (lookahead == 's') ADVANCE(2844);
      END_STATE();
    case 2231:
      if (lookahead == 'l') ADVANCE(3661);
      if (lookahead == 'u') ADVANCE(2026);
      END_STATE();
    case 2232:
      if (lookahead == 'l') ADVANCE(3601);
      END_STATE();
    case 2233:
      if (lookahead == 'l') ADVANCE(3671);
      END_STATE();
    case 2234:
      if (lookahead == 'l') ADVANCE(3634);
      END_STATE();
    case 2235:
      if (lookahead == 'l') ADVANCE(3593);
      END_STATE();
    case 2236:
      if (lookahead == 'l') ADVANCE(3483);
      END_STATE();
    case 2237:
      if (lookahead == 'l') ADVANCE(1308);
      if (lookahead == 'r') ADVANCE(2484);
      END_STATE();
    case 2238:
      if (lookahead == 'l') ADVANCE(3233);
      END_STATE();
    case 2239:
      if (lookahead == 'l') ADVANCE(1324);
      END_STATE();
    case 2240:
      if (lookahead == 'l') ADVANCE(3790);
      END_STATE();
    case 2241:
      if (lookahead == 'l') ADVANCE(3597);
      END_STATE();
    case 2242:
      if (lookahead == 'l') ADVANCE(3764);
      END_STATE();
    case 2243:
      if (lookahead == 'l') ADVANCE(3510);
      END_STATE();
    case 2244:
      if (lookahead == 'l') ADVANCE(3123);
      END_STATE();
    case 2245:
      if (lookahead == 'l') ADVANCE(3093);
      END_STATE();
    case 2246:
      if (lookahead == 'l') ADVANCE(3595);
      END_STATE();
    case 2247:
      if (lookahead == 'l') ADVANCE(3126);
      END_STATE();
    case 2248:
      if (lookahead == 'l') ADVANCE(3794);
      END_STATE();
    case 2249:
      if (lookahead == 'l') ADVANCE(3516);
      END_STATE();
    case 2250:
      if (lookahead == 'l') ADVANCE(3599);
      END_STATE();
    case 2251:
      if (lookahead == 'l') ADVANCE(3121);
      END_STATE();
    case 2252:
      if (lookahead == 'l') ADVANCE(3631);
      END_STATE();
    case 2253:
      if (lookahead == 'l') ADVANCE(2757);
      if (lookahead == 's') ADVANCE(2823);
      END_STATE();
    case 2254:
      if (lookahead == 'l') ADVANCE(1875);
      END_STATE();
    case 2255:
      if (lookahead == 'l') ADVANCE(2512);
      if (lookahead == 'p') ADVANCE(96);
      END_STATE();
    case 2256:
      if (lookahead == 'l') ADVANCE(1957);
      END_STATE();
    case 2257:
      if (lookahead == 'l') ADVANCE(1957);
      if (lookahead == 'q') ADVANCE(3708);
      if (lookahead == 'x') ADVANCE(1412);
      END_STATE();
    case 2258:
      if (lookahead == 'l') ADVANCE(1957);
      if (lookahead == 'x') ADVANCE(1414);
      END_STATE();
    case 2259:
      if (lookahead == 'l') ADVANCE(1957);
      if (lookahead == 'x') ADVANCE(2895);
      END_STATE();
    case 2260:
      if (lookahead == 'l') ADVANCE(1957);
      if (lookahead == 'x') ADVANCE(2869);
      END_STATE();
    case 2261:
      if (lookahead == 'l') ADVANCE(1957);
      if (lookahead == 'x') ADVANCE(1517);
      END_STATE();
    case 2262:
      if (lookahead == 'l') ADVANCE(1957);
      if (lookahead == 'x') ADVANCE(1413);
      END_STATE();
    case 2263:
      if (lookahead == 'l') ADVANCE(1696);
      if (lookahead == 'm') ADVANCE(1755);
      if (lookahead == 'n') ADVANCE(2743);
      END_STATE();
    case 2264:
      if (lookahead == 'l') ADVANCE(1696);
      if (lookahead == 'm') ADVANCE(2381);
      if (lookahead == 'n') ADVANCE(2834);
      END_STATE();
    case 2265:
      if (lookahead == 'l') ADVANCE(1696);
      if (lookahead == 'm') ADVANCE(2381);
      if (lookahead == 'n') ADVANCE(2951);
      END_STATE();
    case 2266:
      if (lookahead == 'l') ADVANCE(2232);
      if (lookahead == 't') ADVANCE(1605);
      END_STATE();
    case 2267:
      if (lookahead == 'l') ADVANCE(2232);
      if (lookahead == 't') ADVANCE(1624);
      END_STATE();
    case 2268:
      if (lookahead == 'l') ADVANCE(2976);
      END_STATE();
    case 2269:
      if (lookahead == 'l') ADVANCE(2977);
      END_STATE();
    case 2270:
      if (lookahead == 'l') ADVANCE(2978);
      END_STATE();
    case 2271:
      if (lookahead == 'l') ADVANCE(2234);
      END_STATE();
    case 2272:
      if (lookahead == 'l') ADVANCE(2234);
      if (lookahead == 'w') ADVANCE(3561);
      END_STATE();
    case 2273:
      if (lookahead == 'l') ADVANCE(2985);
      END_STATE();
    case 2274:
      if (lookahead == 'l') ADVANCE(2343);
      END_STATE();
    case 2275:
      if (lookahead == 'l') ADVANCE(2343);
      if (lookahead == 'n') ADVANCE(3015);
      END_STATE();
    case 2276:
      if (lookahead == 'l') ADVANCE(2343);
      if (lookahead == 'n') ADVANCE(3015);
      if (lookahead == 't') ADVANCE(2097);
      END_STATE();
    case 2277:
      if (lookahead == 'l') ADVANCE(1510);
      END_STATE();
    case 2278:
      if (lookahead == 'l') ADVANCE(2981);
      END_STATE();
    case 2279:
      if (lookahead == 'l') ADVANCE(1400);
      if (lookahead == 'n') ADVANCE(2908);
      END_STATE();
    case 2280:
      if (lookahead == 'l') ADVANCE(2982);
      END_STATE();
    case 2281:
      if (lookahead == 'l') ADVANCE(2983);
      END_STATE();
    case 2282:
      if (lookahead == 'l') ADVANCE(2547);
      END_STATE();
    case 2283:
      if (lookahead == 'l') ADVANCE(2547);
      if (lookahead == 't') ADVANCE(1915);
      END_STATE();
    case 2284:
      if (lookahead == 'l') ADVANCE(2024);
      END_STATE();
    case 2285:
      if (lookahead == 'l') ADVANCE(2130);
      END_STATE();
    case 2286:
      if (lookahead == 'l') ADVANCE(1902);
      END_STATE();
    case 2287:
      if (lookahead == 'l') ADVANCE(1399);
      END_STATE();
    case 2288:
      if (lookahead == 'l') ADVANCE(2738);
      END_STATE();
    case 2289:
      if (lookahead == 'l') ADVANCE(2123);
      END_STATE();
    case 2290:
      if (lookahead == 'l') ADVANCE(1962);
      if (lookahead == 'q') ADVANCE(1315);
      if (lookahead == 'x') ADVANCE(2787);
      END_STATE();
    case 2291:
      if (lookahead == 'l') ADVANCE(1962);
      if (lookahead == 'x') ADVANCE(2787);
      END_STATE();
    case 2292:
      if (lookahead == 'l') ADVANCE(1323);
      END_STATE();
    case 2293:
      if (lookahead == 'l') ADVANCE(2243);
      END_STATE();
    case 2294:
      if (lookahead == 'l') ADVANCE(1325);
      END_STATE();
    case 2295:
      if (lookahead == 'l') ADVANCE(2174);
      END_STATE();
    case 2296:
      if (lookahead == 'l') ADVANCE(2800);
      END_STATE();
    case 2297:
      if (lookahead == 'l') ADVANCE(2142);
      END_STATE();
    case 2298:
      if (lookahead == 'l') ADVANCE(2350);
      END_STATE();
    case 2299:
      if (lookahead == 'l') ADVANCE(2338);
      END_STATE();
    case 2300:
      if (lookahead == 'l') ADVANCE(1716);
      if (lookahead == 'm') ADVANCE(1755);
      if (lookahead == 'n') ADVANCE(2834);
      END_STATE();
    case 2301:
      if (lookahead == 'l') ADVANCE(1716);
      if (lookahead == 'm') ADVANCE(1755);
      if (lookahead == 'n') ADVANCE(2951);
      END_STATE();
    case 2302:
      if (lookahead == 'l') ADVANCE(1716);
      if (lookahead == 'm') ADVANCE(1754);
      if (lookahead == 'n') ADVANCE(2743);
      END_STATE();
    case 2303:
      if (lookahead == 'l') ADVANCE(1716);
      if (lookahead == 'm') ADVANCE(1754);
      if (lookahead == 'n') ADVANCE(2834);
      END_STATE();
    case 2304:
      if (lookahead == 'l') ADVANCE(2280);
      END_STATE();
    case 2305:
      if (lookahead == 'l') ADVANCE(2249);
      END_STATE();
    case 2306:
      if (lookahead == 'l') ADVANCE(2250);
      if (lookahead == 't') ADVANCE(1621);
      END_STATE();
    case 2307:
      if (lookahead == 'l') ADVANCE(1799);
      END_STATE();
    case 2308:
      if (lookahead == 'l') ADVANCE(1802);
      END_STATE();
    case 2309:
      if (lookahead == 'l') ADVANCE(2294);
      END_STATE();
    case 2310:
      if (lookahead == 'l') ADVANCE(2273);
      END_STATE();
    case 2311:
      if (lookahead == 'l') ADVANCE(2252);
      END_STATE();
    case 2312:
      if (lookahead == 'l') ADVANCE(2252);
      if (lookahead == 'w') ADVANCE(3561);
      END_STATE();
    case 2313:
      if (lookahead == 'l') ADVANCE(1806);
      END_STATE();
    case 2314:
      if (lookahead == 'l') ADVANCE(1807);
      END_STATE();
    case 2315:
      if (lookahead == 'l') ADVANCE(1885);
      END_STATE();
    case 2316:
      if (lookahead == 'l') ADVANCE(1963);
      END_STATE();
    case 2317:
      if (lookahead == 'l') ADVANCE(1817);
      END_STATE();
    case 2318:
      if (lookahead == 'l') ADVANCE(1968);
      END_STATE();
    case 2319:
      if (lookahead == 'l') ADVANCE(1823);
      END_STATE();
    case 2320:
      if (lookahead == 'l') ADVANCE(1898);
      END_STATE();
    case 2321:
      if (lookahead == 'l') ADVANCE(1826);
      END_STATE();
    case 2322:
      if (lookahead == 'l') ADVANCE(1828);
      END_STATE();
    case 2323:
      if (lookahead == 'l') ADVANCE(1835);
      END_STATE();
    case 2324:
      if (lookahead == 'l') ADVANCE(1838);
      END_STATE();
    case 2325:
      if (lookahead == 'l') ADVANCE(1917);
      END_STATE();
    case 2326:
      if (lookahead == 'l') ADVANCE(1842);
      END_STATE();
    case 2327:
      if (lookahead == 'l') ADVANCE(1843);
      END_STATE();
    case 2328:
      if (lookahead == 'l') ADVANCE(1918);
      END_STATE();
    case 2329:
      if (lookahead == 'l') ADVANCE(1942);
      END_STATE();
    case 2330:
      if (lookahead == 'l') ADVANCE(1851);
      END_STATE();
    case 2331:
      if (lookahead == 'l') ADVANCE(2848);
      END_STATE();
    case 2332:
      if (lookahead == 'l') ADVANCE(2565);
      END_STATE();
    case 2333:
      if (lookahead == 'l') ADVANCE(2135);
      END_STATE();
    case 2334:
      if (lookahead == 'l') ADVANCE(2572);
      if (lookahead == 'p') ADVANCE(2705);
      END_STATE();
    case 2335:
      if (lookahead == 'l') ADVANCE(2917);
      END_STATE();
    case 2336:
      if (lookahead == 'l') ADVANCE(2157);
      END_STATE();
    case 2337:
      if (lookahead == 'l') ADVANCE(2557);
      END_STATE();
    case 2338:
      if (lookahead == 'l') ADVANCE(1636);
      END_STATE();
    case 2339:
      if (lookahead == 'l') ADVANCE(2878);
      END_STATE();
    case 2340:
      if (lookahead == 'l') ADVANCE(2918);
      END_STATE();
    case 2341:
      if (lookahead == 'l') ADVANCE(1468);
      END_STATE();
    case 2342:
      if (lookahead == 'l') ADVANCE(2578);
      END_STATE();
    case 2343:
      if (lookahead == 'l') ADVANCE(2687);
      END_STATE();
    case 2344:
      if (lookahead == 'l') ADVANCE(1642);
      END_STATE();
    case 2345:
      if (lookahead == 'l') ADVANCE(1307);
      if (lookahead == 'r') ADVANCE(2484);
      END_STATE();
    case 2346:
      if (lookahead == 'l') ADVANCE(2000);
      END_STATE();
    case 2347:
      if (lookahead == 'l') ADVANCE(2329);
      END_STATE();
    case 2348:
      if (lookahead == 'l') ADVANCE(2559);
      END_STATE();
    case 2349:
      if (lookahead == 'l') ADVANCE(1977);
      END_STATE();
    case 2350:
      if (lookahead == 'l') ADVANCE(2776);
      END_STATE();
    case 2351:
      if (lookahead == 'l') ADVANCE(2179);
      END_STATE();
    case 2352:
      if (lookahead == 'l') ADVANCE(2342);
      END_STATE();
    case 2353:
      if (lookahead == 'l') ADVANCE(2885);
      END_STATE();
    case 2354:
      if (lookahead == 'l') ADVANCE(2564);
      END_STATE();
    case 2355:
      if (lookahead == 'l') ADVANCE(2187);
      END_STATE();
    case 2356:
      if (lookahead == 'l') ADVANCE(1991);
      END_STATE();
    case 2357:
      if (lookahead == 'l') ADVANCE(1990);
      END_STATE();
    case 2358:
      if (lookahead == 'l') ADVANCE(2186);
      END_STATE();
    case 2359:
      if (lookahead == 'l') ADVANCE(2191);
      END_STATE();
    case 2360:
      if (lookahead == 'l') ADVANCE(2001);
      END_STATE();
    case 2361:
      if (lookahead == 'l') ADVANCE(1537);
      END_STATE();
    case 2362:
      if (lookahead == 'l') ADVANCE(2576);
      END_STATE();
    case 2363:
      if (lookahead == 'l') ADVANCE(2004);
      END_STATE();
    case 2364:
      if (lookahead == 'l') ADVANCE(2005);
      END_STATE();
    case 2365:
      if (lookahead == 'l') ADVANCE(2207);
      END_STATE();
    case 2366:
      if (lookahead == 'm') ADVANCE(3675);
      END_STATE();
    case 2367:
      if (lookahead == 'm') ADVANCE(3571);
      END_STATE();
    case 2368:
      if (lookahead == 'm') ADVANCE(3659);
      END_STATE();
    case 2369:
      if (lookahead == 'm') ADVANCE(3659);
      if (lookahead == 't') ADVANCE(3492);
      END_STATE();
    case 2370:
      if (lookahead == 'm') ADVANCE(3657);
      END_STATE();
    case 2371:
      if (lookahead == 'm') ADVANCE(1329);
      END_STATE();
    case 2372:
      if (lookahead == 'm') ADVANCE(2533);
      END_STATE();
    case 2373:
      if (lookahead == 'm') ADVANCE(2377);
      if (lookahead == 'n') ADVANCE(1362);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3258);
      END_STATE();
    case 2374:
      if (lookahead == 'm') ADVANCE(2377);
      if (lookahead == 'n') ADVANCE(1359);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3258);
      END_STATE();
    case 2375:
      if (lookahead == 'm') ADVANCE(3018);
      END_STATE();
    case 2376:
      if (lookahead == 'm') ADVANCE(2953);
      END_STATE();
    case 2377:
      if (lookahead == 'm') ADVANCE(1427);
      END_STATE();
    case 2378:
      if (lookahead == 'm') ADVANCE(2583);
      END_STATE();
    case 2379:
      if (lookahead == 'm') ADVANCE(2584);
      END_STATE();
    case 2380:
      if (lookahead == 'm') ADVANCE(2622);
      END_STATE();
    case 2381:
      if (lookahead == 'm') ADVANCE(2523);
      END_STATE();
    case 2382:
      if (lookahead == 'm') ADVANCE(2963);
      END_STATE();
    case 2383:
      if (lookahead == 'm') ADVANCE(2126);
      END_STATE();
    case 2384:
      if (lookahead == 'm') ADVANCE(2964);
      END_STATE();
    case 2385:
      if (lookahead == 'm') ADVANCE(2589);
      END_STATE();
    case 2386:
      if (lookahead == 'm') ADVANCE(1879);
      END_STATE();
    case 2387:
      if (lookahead == 'm') ADVANCE(1534);
      END_STATE();
    case 2388:
      if (lookahead == 'm') ADVANCE(1805);
      END_STATE();
    case 2389:
      if (lookahead == 'm') ADVANCE(1913);
      END_STATE();
    case 2390:
      if (lookahead == 'm') ADVANCE(1888);
      END_STATE();
    case 2391:
      if (lookahead == 'm') ADVANCE(1844);
      END_STATE();
    case 2392:
      if (lookahead == 'm') ADVANCE(1911);
      END_STATE();
    case 2393:
      if (lookahead == 'm') ADVANCE(2146);
      END_STATE();
    case 2394:
      if (lookahead == 'm') ADVANCE(2149);
      END_STATE();
    case 2395:
      if (lookahead == 'm') ADVANCE(1982);
      END_STATE();
    case 2396:
      if (lookahead == 'm') ADVANCE(2151);
      END_STATE();
    case 2397:
      if (lookahead == 'm') ADVANCE(1986);
      END_STATE();
    case 2398:
      if (lookahead == 'm') ADVANCE(2539);
      END_STATE();
    case 2399:
      if (lookahead == 'm') ADVANCE(1946);
      END_STATE();
    case 2400:
      if (lookahead == 'm') ADVANCE(2545);
      END_STATE();
    case 2401:
      if (lookahead == 'm') ADVANCE(2616);
      if (lookahead == 'n') ADVANCE(2351);
      END_STATE();
    case 2402:
      if (lookahead == 'm') ADVANCE(1996);
      END_STATE();
    case 2403:
      if (lookahead == 'm') ADVANCE(1988);
      END_STATE();
    case 2404:
      if (lookahead == 'm') ADVANCE(2381);
      END_STATE();
    case 2405:
      if (lookahead == 'm') ADVANCE(2619);
      END_STATE();
    case 2406:
      if (lookahead == 'm') ADVANCE(2009);
      END_STATE();
    case 2407:
      if (lookahead == 'm') ADVANCE(2624);
      END_STATE();
    case 2408:
      if (lookahead == 'n') ADVANCE(3775);
      END_STATE();
    case 2409:
      if (lookahead == 'n') ADVANCE(2219);
      END_STATE();
    case 2410:
      if (lookahead == 'n') ADVANCE(3699);
      END_STATE();
    case 2411:
      if (lookahead == 'n') ADVANCE(3770);
      END_STATE();
    case 2412:
      if (lookahead == 'n') ADVANCE(1745);
      END_STATE();
    case 2413:
      if (lookahead == 'n') ADVANCE(3702);
      END_STATE();
    case 2414:
      if (lookahead == 'n') ADVANCE(3284);
      END_STATE();
    case 2415:
      if (lookahead == 'n') ADVANCE(3247);
      END_STATE();
    case 2416:
      if (lookahead == 'n') ADVANCE(3115);
      END_STATE();
    case 2417:
      if (lookahead == 'n') ADVANCE(1302);
      END_STATE();
    case 2418:
      if (lookahead == 'n') ADVANCE(3133);
      END_STATE();
    case 2419:
      if (lookahead == 'n') ADVANCE(3642);
      END_STATE();
    case 2420:
      if (lookahead == 'n') ADVANCE(1919);
      END_STATE();
    case 2421:
      if (lookahead == 'n') ADVANCE(3779);
      END_STATE();
    case 2422:
      if (lookahead == 'n') ADVANCE(3308);
      END_STATE();
    case 2423:
      if (lookahead == 'n') ADVANCE(3285);
      END_STATE();
    case 2424:
      if (lookahead == 'n') ADVANCE(3375);
      END_STATE();
    case 2425:
      if (lookahead == 'n') ADVANCE(3345);
      END_STATE();
    case 2426:
      if (lookahead == 'n') ADVANCE(3287);
      END_STATE();
    case 2427:
      if (lookahead == 'n') ADVANCE(3381);
      END_STATE();
    case 2428:
      if (lookahead == 'n') ADVANCE(3318);
      END_STATE();
    case 2429:
      if (lookahead == 'n') ADVANCE(3696);
      END_STATE();
    case 2430:
      if (lookahead == 'n') ADVANCE(3281);
      END_STATE();
    case 2431:
      if (lookahead == 'n') ADVANCE(2019);
      END_STATE();
    case 2432:
      if (lookahead == 'n') ADVANCE(2548);
      END_STATE();
    case 2433:
      if (lookahead == 'n') ADVANCE(1635);
      END_STATE();
    case 2434:
      if (lookahead == 'n') ADVANCE(1492);
      if (lookahead == 'o') ADVANCE(2696);
      if (lookahead == 'w') ADVANCE(2125);
      END_STATE();
    case 2435:
      if (lookahead == 'n') ADVANCE(1699);
      END_STATE();
    case 2436:
      if (lookahead == 'n') ADVANCE(1617);
      END_STATE();
    case 2437:
      if (lookahead == 'n') ADVANCE(2907);
      END_STATE();
    case 2438:
      if (lookahead == 'n') ADVANCE(2056);
      END_STATE();
    case 2439:
      if (lookahead == 'n') ADVANCE(2057);
      END_STATE();
    case 2440:
      if (lookahead == 'n') ADVANCE(2058);
      END_STATE();
    case 2441:
      if (lookahead == 'n') ADVANCE(1580);
      END_STATE();
    case 2442:
      if (lookahead == 'n') ADVANCE(1704);
      END_STATE();
    case 2443:
      if (lookahead == 'n') ADVANCE(1728);
      END_STATE();
    case 2444:
      if (lookahead == 'n') ADVANCE(2060);
      END_STATE();
    case 2445:
      if (lookahead == 'n') ADVANCE(1585);
      END_STATE();
    case 2446:
      if (lookahead == 'n') ADVANCE(1706);
      END_STATE();
    case 2447:
      if (lookahead == 'n') ADVANCE(1586);
      END_STATE();
    case 2448:
      if (lookahead == 'n') ADVANCE(2268);
      END_STATE();
    case 2449:
      if (lookahead == 'n') ADVANCE(1523);
      END_STATE();
    case 2450:
      if (lookahead == 'n') ADVANCE(1711);
      END_STATE();
    case 2451:
      if (lookahead == 'n') ADVANCE(2269);
      END_STATE();
    case 2452:
      if (lookahead == 'n') ADVANCE(2270);
      END_STATE();
    case 2453:
      if (lookahead == 'n') ADVANCE(2853);
      END_STATE();
    case 2454:
      if (lookahead == 'n') ADVANCE(1960);
      END_STATE();
    case 2455:
      if (lookahead == 'n') ADVANCE(2278);
      END_STATE();
    case 2456:
      if (lookahead == 'n') ADVANCE(2806);
      END_STATE();
    case 2457:
      if (lookahead == 'n') ADVANCE(2502);
      END_STATE();
    case 2458:
      if (lookahead == 'n') ADVANCE(2281);
      END_STATE();
    case 2459:
      if (lookahead == 'n') ADVANCE(1798);
      END_STATE();
    case 2460:
      if (lookahead == 'n') ADVANCE(2810);
      END_STATE();
    case 2461:
      if (lookahead == 'n') ADVANCE(1597);
      END_STATE();
    case 2462:
      if (lookahead == 'n') ADVANCE(1995);
      END_STATE();
    case 2463:
      if (lookahead == 'n') ADVANCE(2813);
      END_STATE();
    case 2464:
      if (lookahead == 'n') ADVANCE(2872);
      END_STATE();
    case 2465:
      if (lookahead == 'n') ADVANCE(2815);
      END_STATE();
    case 2466:
      if (lookahead == 'n') ADVANCE(2819);
      END_STATE();
    case 2467:
      if (lookahead == 'n') ADVANCE(2820);
      END_STATE();
    case 2468:
      if (lookahead == 'n') ADVANCE(2822);
      END_STATE();
    case 2469:
      if (lookahead == 'n') ADVANCE(1813);
      END_STATE();
    case 2470:
      if (lookahead == 'n') ADVANCE(2833);
      END_STATE();
    case 2471:
      if (lookahead == 'n') ADVANCE(1819);
      END_STATE();
    case 2472:
      if (lookahead == 'n') ADVANCE(1821);
      END_STATE();
    case 2473:
      if (lookahead == 'n') ADVANCE(1830);
      END_STATE();
    case 2474:
      if (lookahead == 'n') ADVANCE(1836);
      END_STATE();
    case 2475:
      if (lookahead == 'n') ADVANCE(1303);
      END_STATE();
    case 2476:
      if (lookahead == 'n') ADVANCE(2069);
      END_STATE();
    case 2477:
      if (lookahead == 'n') ADVANCE(2201);
      END_STATE();
    case 2478:
      if (lookahead == 'n') ADVANCE(2073);
      END_STATE();
    case 2479:
      if (lookahead == 'n') ADVANCE(2912);
      END_STATE();
    case 2480:
      if (lookahead == 'n') ADVANCE(2140);
      END_STATE();
    case 2481:
      if (lookahead == 'n') ADVANCE(1650);
      END_STATE();
    case 2482:
      if (lookahead == 'n') ADVANCE(2761);
      END_STATE();
    case 2483:
      if (lookahead == 'n') ADVANCE(2933);
      END_STATE();
    case 2484:
      if (lookahead == 'n') ADVANCE(1450);
      END_STATE();
    case 2485:
      if (lookahead == 'n') ADVANCE(2075);
      END_STATE();
    case 2486:
      if (lookahead == 'n') ADVANCE(1638);
      END_STATE();
    case 2487:
      if (lookahead == 'n') ADVANCE(1652);
      END_STATE();
    case 2488:
      if (lookahead == 'n') ADVANCE(1503);
      END_STATE();
    case 2489:
      if (lookahead == 'n') ADVANCE(2882);
      END_STATE();
    case 2490:
      if (lookahead == 'n') ADVANCE(2858);
      END_STATE();
    case 2491:
      if (lookahead == 'n') ADVANCE(1496);
      END_STATE();
    case 2492:
      if (lookahead == 'n') ADVANCE(2155);
      END_STATE();
    case 2493:
      if (lookahead == 'n') ADVANCE(1509);
      END_STATE();
    case 2494:
      if (lookahead == 'n') ADVANCE(1758);
      END_STATE();
    case 2495:
      if (lookahead == 'n') ADVANCE(1502);
      END_STATE();
    case 2496:
      if (lookahead == 'n') ADVANCE(2566);
      if (lookahead == 'o') ADVANCE(2448);
      END_STATE();
    case 2497:
      if (lookahead == 'n') ADVANCE(2355);
      END_STATE();
    case 2498:
      if (lookahead == 'n') ADVANCE(2747);
      END_STATE();
    case 2499:
      if (lookahead == 'n') ADVANCE(2204);
      END_STATE();
    case 2500:
      if (lookahead == 'n') ADVANCE(2206);
      END_STATE();
    case 2501:
      if (lookahead == 'n') ADVANCE(2208);
      END_STATE();
    case 2502:
      if (lookahead == 'n') ADVANCE(1545);
      END_STATE();
    case 2503:
      if (lookahead == 'o') ADVANCE(2122);
      if (lookahead == 's') ADVANCE(1685);
      END_STATE();
    case 2504:
      if (lookahead == 'o') ADVANCE(2751);
      if (lookahead == 'r') ADVANCE(2934);
      END_STATE();
    case 2505:
      if (lookahead == 'o') ADVANCE(2957);
      END_STATE();
    case 2506:
      if (lookahead == 'o') ADVANCE(2902);
      END_STATE();
    case 2507:
      if (lookahead == 'o') ADVANCE(1973);
      END_STATE();
    case 2508:
      if (lookahead == 'o') ADVANCE(2195);
      if (lookahead == 'p') ADVANCE(1606);
      if (lookahead == 'r') ADVANCE(2113);
      if (lookahead == 't') ADVANCE(2634);
      END_STATE();
    case 2509:
      if (lookahead == 'o') ADVANCE(2195);
      if (lookahead == 'p') ADVANCE(1606);
      if (lookahead == 'r') ADVANCE(1861);
      if (lookahead == 't') ADVANCE(2635);
      END_STATE();
    case 2510:
      if (lookahead == 'o') ADVANCE(2195);
      if (lookahead == 'r') ADVANCE(2113);
      if (lookahead == 't') ADVANCE(2713);
      END_STATE();
    case 2511:
      if (lookahead == 'o') ADVANCE(2383);
      if (lookahead == 't') ADVANCE(2667);
      END_STATE();
    case 2512:
      if (lookahead == 'o') ADVANCE(1437);
      END_STATE();
    case 2513:
      if (lookahead == 'o') ADVANCE(1557);
      END_STATE();
    case 2514:
      if (lookahead == 'o') ADVANCE(1294);
      END_STATE();
    case 2515:
      if (lookahead == 'o') ADVANCE(1601);
      END_STATE();
    case 2516:
      if (lookahead == 'o') ADVANCE(2224);
      END_STATE();
    case 2517:
      if (lookahead == 'o') ADVANCE(2303);
      END_STATE();
    case 2518:
      if (lookahead == 'o') ADVANCE(2910);
      END_STATE();
    case 2519:
      if (lookahead == 'o') ADVANCE(2047);
      END_STATE();
    case 2520:
      if (lookahead == 'o') ADVANCE(2080);
      END_STATE();
    case 2521:
      if (lookahead == 'o') ADVANCE(1578);
      END_STATE();
    case 2522:
      if (lookahead == 'o') ADVANCE(2914);
      END_STATE();
    case 2523:
      if (lookahead == 'o') ADVANCE(2416);
      END_STATE();
    case 2524:
      if (lookahead == 'o') ADVANCE(2665);
      END_STATE();
    case 2525:
      if (lookahead == 'o') ADVANCE(1734);
      END_STATE();
    case 2526:
      if (lookahead == 'o') ADVANCE(2768);
      END_STATE();
    case 2527:
      if (lookahead == 'o') ADVANCE(2702);
      END_STATE();
    case 2528:
      if (lookahead == 'o') ADVANCE(2419);
      END_STATE();
    case 2529:
      if (lookahead == 'o') ADVANCE(1587);
      END_STATE();
    case 2530:
      if (lookahead == 'o') ADVANCE(2480);
      END_STATE();
    case 2531:
      if (lookahead == 'o') ADVANCE(2647);
      END_STATE();
    case 2532:
      if (lookahead == 'o') ADVANCE(2423);
      END_STATE();
    case 2533:
      if (lookahead == 'o') ADVANCE(2664);
      if (lookahead == 't') ADVANCE(1439);
      END_STATE();
    case 2534:
      if (lookahead == 'o') ADVANCE(2451);
      END_STATE();
    case 2535:
      if (lookahead == 'o') ADVANCE(2121);
      END_STATE();
    case 2536:
      if (lookahead == 'o') ADVANCE(2121);
      if (lookahead == 's') ADVANCE(1685);
      END_STATE();
    case 2537:
      if (lookahead == 'o') ADVANCE(2121);
      if (lookahead == 's') ADVANCE(1686);
      END_STATE();
    case 2538:
      if (lookahead == 'o') ADVANCE(2673);
      END_STATE();
    case 2539:
      if (lookahead == 'o') ADVANCE(2452);
      END_STATE();
    case 2540:
      if (lookahead == 'o') ADVANCE(2716);
      END_STATE();
    case 2541:
      if (lookahead == 'o') ADVANCE(2439);
      END_STATE();
    case 2542:
      if (lookahead == 'o') ADVANCE(1687);
      END_STATE();
    case 2543:
      if (lookahead == 'o') ADVANCE(2426);
      END_STATE();
    case 2544:
      if (lookahead == 'o') ADVANCE(2652);
      END_STATE();
    case 2545:
      if (lookahead == 'o') ADVANCE(2458);
      END_STATE();
    case 2546:
      if (lookahead == 'o') ADVANCE(2428);
      END_STATE();
    case 2547:
      if (lookahead == 'o') ADVANCE(2077);
      END_STATE();
    case 2548:
      if (lookahead == 'o') ADVANCE(2877);
      END_STATE();
    case 2549:
      if (lookahead == 'o') ADVANCE(2225);
      END_STATE();
    case 2550:
      if (lookahead == 'o') ADVANCE(2225);
      if (lookahead == 'r') ADVANCE(2901);
      END_STATE();
    case 2551:
      if (lookahead == 'o') ADVANCE(2225);
      if (lookahead == 'r') ADVANCE(2919);
      END_STATE();
    case 2552:
      if (lookahead == 'o') ADVANCE(2030);
      END_STATE();
    case 2553:
      if (lookahead == 'o') ADVANCE(2604);
      END_STATE();
    case 2554:
      if (lookahead == 'o') ADVANCE(1741);
      END_STATE();
    case 2555:
      if (lookahead == 'o') ADVANCE(2608);
      END_STATE();
    case 2556:
      if (lookahead == 'o') ADVANCE(2684);
      END_STATE();
    case 2557:
      if (lookahead == 'o') ADVANCE(1631);
      END_STATE();
    case 2558:
      if (lookahead == 'o') ADVANCE(2682);
      if (lookahead == 'r') ADVANCE(2170);
      END_STATE();
    case 2559:
      if (lookahead == 'o') ADVANCE(1447);
      END_STATE();
    case 2560:
      if (lookahead == 'o') ADVANCE(2031);
      END_STATE();
    case 2561:
      if (lookahead == 'o') ADVANCE(2686);
      END_STATE();
    case 2562:
      if (lookahead == 'o') ADVANCE(2948);
      END_STATE();
    case 2563:
      if (lookahead == 'o') ADVANCE(2469);
      END_STATE();
    case 2564:
      if (lookahead == 'o') ADVANCE(1471);
      END_STATE();
    case 2565:
      if (lookahead == 'o') ADVANCE(1458);
      END_STATE();
    case 2566:
      if (lookahead == 'o') ADVANCE(2472);
      END_STATE();
    case 2567:
      if (lookahead == 'o') ADVANCE(2172);
      END_STATE();
    case 2568:
      if (lookahead == 'o') ADVANCE(2473);
      END_STATE();
    case 2569:
      if (lookahead == 'o') ADVANCE(2470);
      END_STATE();
    case 2570:
      if (lookahead == 'o') ADVANCE(2148);
      END_STATE();
    case 2571:
      if (lookahead == 'o') ADVANCE(2481);
      END_STATE();
    case 2572:
      if (lookahead == 'o') ADVANCE(1678);
      END_STATE();
    case 2573:
      if (lookahead == 'o') ADVANCE(2488);
      END_STATE();
    case 2574:
      if (lookahead == 'o') ADVANCE(1972);
      END_STATE();
    case 2575:
      if (lookahead == 'o') ADVANCE(2394);
      if (lookahead == 't') ADVANCE(2667);
      END_STATE();
    case 2576:
      if (lookahead == 'o') ADVANCE(1680);
      END_STATE();
    case 2577:
      if (lookahead == 'o') ADVANCE(2396);
      if (lookahead == 't') ADVANCE(2667);
      END_STATE();
    case 2578:
      if (lookahead == 'o') ADVANCE(1683);
      END_STATE();
    case 2579:
      if (lookahead == 'o') ADVANCE(2166);
      END_STATE();
    case 2580:
      if (lookahead == 'p') ADVANCE(106);
      END_STATE();
    case 2581:
      if (lookahead == 'p') ADVANCE(3446);
      END_STATE();
    case 2582:
      if (lookahead == 'p') ADVANCE(3773);
      END_STATE();
    case 2583:
      if (lookahead == 'p') ADVANCE(3584);
      END_STATE();
    case 2584:
      if (lookahead == 'p') ADVANCE(3582);
      END_STATE();
    case 2585:
      if (lookahead == 'p') ADVANCE(99);
      END_STATE();
    case 2586:
      if (lookahead == 'p') ADVANCE(3746);
      END_STATE();
    case 2587:
      if (lookahead == 'p') ADVANCE(3744);
      END_STATE();
    case 2588:
      if (lookahead == 'p') ADVANCE(3592);
      END_STATE();
    case 2589:
      if (lookahead == 'p') ADVANCE(59);
      END_STATE();
    case 2590:
      if (lookahead == 'p') ADVANCE(3453);
      END_STATE();
    case 2591:
      if (lookahead == 'p') ADVANCE(1402);
      END_STATE();
    case 2592:
      if (lookahead == 'p') ADVANCE(1402);
      if (lookahead == 'r') ADVANCE(3690);
      END_STATE();
    case 2593:
      if (lookahead == 'p') ADVANCE(1606);
      if (lookahead == 'r') ADVANCE(1861);
      if (lookahead == 't') ADVANCE(2654);
      END_STATE();
    case 2594:
      if (lookahead == 'p') ADVANCE(1606);
      if (lookahead == 't') ADVANCE(2653);
      END_STATE();
    case 2595:
      if (lookahead == 'p') ADVANCE(2617);
      END_STATE();
    case 2596:
      if (lookahead == 'p') ADVANCE(120);
      END_STATE();
    case 2597:
      if (lookahead == 'p') ADVANCE(2966);
      END_STATE();
    case 2598:
      if (lookahead == 'p') ADVANCE(2932);
      END_STATE();
    case 2599:
      if (lookahead == 'p') ADVANCE(1887);
      END_STATE();
    case 2600:
      if (lookahead == 'p') ADVANCE(2556);
      END_STATE();
    case 2601:
      if (lookahead == 'p') ADVANCE(1500);
      END_STATE();
    case 2602:
      if (lookahead == 'p') ADVANCE(2839);
      END_STATE();
    case 2603:
      if (lookahead == 'p') ADVANCE(1794);
      END_STATE();
    case 2604:
      if (lookahead == 'p') ADVANCE(2843);
      END_STATE();
    case 2605:
      if (lookahead == 'p') ADVANCE(1401);
      END_STATE();
    case 2606:
      if (lookahead == 'p') ADVANCE(1401);
      if (lookahead == 'r') ADVANCE(3690);
      END_STATE();
    case 2607:
      if (lookahead == 'p') ADVANCE(2847);
      END_STATE();
    case 2608:
      if (lookahead == 'p') ADVANCE(1831);
      END_STATE();
    case 2609:
      if (lookahead == 'p') ADVANCE(1832);
      END_STATE();
    case 2610:
      if (lookahead == 'p') ADVANCE(2675);
      END_STATE();
    case 2611:
      if (lookahead == 'p') ADVANCE(2675);
      if (lookahead == 't') ADVANCE(1497);
      END_STATE();
    case 2612:
      if (lookahead == 'p') ADVANCE(1449);
      if (lookahead == 'r') ADVANCE(1941);
      if (lookahead == 's') ADVANCE(2954);
      END_STATE();
    case 2613:
      if (lookahead == 'p') ADVANCE(2313);
      END_STATE();
    case 2614:
      if (lookahead == 'p') ADVANCE(1451);
      END_STATE();
    case 2615:
      if (lookahead == 'p') ADVANCE(2295);
      END_STATE();
    case 2616:
      if (lookahead == 'p') ADVANCE(2333);
      END_STATE();
    case 2617:
      if (lookahead == 'p') ADVANCE(1465);
      if (lookahead == 'r') ADVANCE(1947);
      END_STATE();
    case 2618:
      if (lookahead == 'p') ADVANCE(2570);
      END_STATE();
    case 2619:
      if (lookahead == 'p') ADVANCE(2561);
      END_STATE();
    case 2620:
      if (lookahead == 'p') ADVANCE(1511);
      END_STATE();
    case 2621:
      if (lookahead == 'p') ADVANCE(1515);
      END_STATE();
    case 2622:
      if (lookahead == 'p') ADVANCE(2898);
      END_STATE();
    case 2623:
      if (lookahead == 'p') ADVANCE(2365);
      END_STATE();
    case 2624:
      if (lookahead == 'p') ADVANCE(2900);
      END_STATE();
    case 2625:
      if (lookahead == 'q') ADVANCE(3708);
      if (lookahead == 'x') ADVANCE(2895);
      END_STATE();
    case 2626:
      if (lookahead == 'q') ADVANCE(1326);
      END_STATE();
    case 2627:
      if (lookahead == 'q') ADVANCE(3719);
      END_STATE();
    case 2628:
      if (lookahead == 'q') ADVANCE(3726);
      END_STATE();
    case 2629:
      if (lookahead == 'q') ADVANCE(3450);
      END_STATE();
    case 2630:
      if (lookahead == 'q') ADVANCE(1315);
      END_STATE();
    case 2631:
      if (lookahead == 'q') ADVANCE(2915);
      END_STATE();
    case 2632:
      if (lookahead == 'q') ADVANCE(2929);
      END_STATE();
    case 2633:
      if (lookahead == 'r') ADVANCE(3690);
      END_STATE();
    case 2634:
      if (lookahead == 'r') ADVANCE(3255);
      END_STATE();
    case 2635:
      if (lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'x') ADVANCE(1304);
      END_STATE();
    case 2636:
      if (lookahead == 'r') ADVANCE(3669);
      END_STATE();
    case 2637:
      if (lookahead == 'r') ADVANCE(3667);
      END_STATE();
    case 2638:
      if (lookahead == 'r') ADVANCE(3580);
      END_STATE();
    case 2639:
      if (lookahead == 'r') ADVANCE(3651);
      END_STATE();
    case 2640:
      if (lookahead == 'r') ADVANCE(3752);
      END_STATE();
    case 2641:
      if (lookahead == 'r') ADVANCE(3100);
      END_STATE();
    case 2642:
      if (lookahead == 'r') ADVANCE(3548);
      END_STATE();
    case 2643:
      if (lookahead == 'r') ADVANCE(3106);
      END_STATE();
    case 2644:
      if (lookahead == 'r') ADVANCE(3205);
      END_STATE();
    case 2645:
      if (lookahead == 'r') ADVANCE(3782);
      END_STATE();
    case 2646:
      if (lookahead == 'r') ADVANCE(3617);
      END_STATE();
    case 2647:
      if (lookahead == 'r') ADVANCE(3556);
      END_STATE();
    case 2648:
      if (lookahead == 'r') ADVANCE(3645);
      END_STATE();
    case 2649:
      if (lookahead == 'r') ADVANCE(3206);
      END_STATE();
    case 2650:
      if (lookahead == 'r') ADVANCE(3692);
      END_STATE();
    case 2651:
      if (lookahead == 'r') ADVANCE(3780);
      END_STATE();
    case 2652:
      if (lookahead == 'r') ADVANCE(3527);
      END_STATE();
    case 2653:
      if (lookahead == 'r') ADVANCE(3253);
      END_STATE();
    case 2654:
      if (lookahead == 'r') ADVANCE(3253);
      if (lookahead == 'x') ADVANCE(1304);
      END_STATE();
    case 2655:
      if (lookahead == 'r') ADVANCE(2767);
      END_STATE();
    case 2656:
      if (lookahead == 'r') ADVANCE(1600);
      END_STATE();
    case 2657:
      if (lookahead == 'r') ADVANCE(2945);
      END_STATE();
    case 2658:
      if (lookahead == 'r') ADVANCE(2053);
      END_STATE();
    case 2659:
      if (lookahead == 'r') ADVANCE(2507);
      if (lookahead == 'x') ADVANCE(2789);
      END_STATE();
    case 2660:
      if (lookahead == 'r') ADVANCE(2054);
      END_STATE();
    case 2661:
      if (lookahead == 'r') ADVANCE(2376);
      END_STATE();
    case 2662:
      if (lookahead == 'r') ADVANCE(2170);
      END_STATE();
    case 2663:
      if (lookahead == 'r') ADVANCE(1868);
      if (lookahead == 'v') ADVANCE(1430);
      END_STATE();
    case 2664:
      if (lookahead == 'r') ADVANCE(2980);
      END_STATE();
    case 2665:
      if (lookahead == 'r') ADVANCE(2029);
      END_STATE();
    case 2666:
      if (lookahead == 'r') ADVANCE(2519);
      END_STATE();
    case 2667:
      if (lookahead == 'r') ADVANCE(2117);
      END_STATE();
    case 2668:
      if (lookahead == 'r') ADVANCE(1317);
      END_STATE();
    case 2669:
      if (lookahead == 'r') ADVANCE(1763);
      END_STATE();
    case 2670:
      if (lookahead == 'r') ADVANCE(2081);
      END_STATE();
    case 2671:
      if (lookahead == 'r') ADVANCE(2901);
      END_STATE();
    case 2672:
      if (lookahead == 'r') ADVANCE(2417);
      END_STATE();
    case 2673:
      if (lookahead == 'r') ADVANCE(1320);
      END_STATE();
    case 2674:
      if (lookahead == 'r') ADVANCE(2796);
      END_STATE();
    case 2675:
      if (lookahead == 'r') ADVANCE(2520);
      END_STATE();
    case 2676:
      if (lookahead == 'r') ADVANCE(2484);
      END_STATE();
    case 2677:
      if (lookahead == 'r') ADVANCE(1964);
      END_STATE();
    case 2678:
      if (lookahead == 'r') ADVANCE(2574);
      END_STATE();
    case 2679:
      if (lookahead == 'r') ADVANCE(2420);
      END_STATE();
    case 2680:
      if (lookahead == 'r') ADVANCE(1874);
      END_STATE();
    case 2681:
      if (lookahead == 'r') ADVANCE(1506);
      END_STATE();
    case 2682:
      if (lookahead == 'r') ADVANCE(1797);
      END_STATE();
    case 2683:
      if (lookahead == 'r') ADVANCE(2424);
      END_STATE();
    case 2684:
      if (lookahead == 'r') ADVANCE(2811);
      END_STATE();
    case 2685:
      if (lookahead == 'r') ADVANCE(2427);
      END_STATE();
    case 2686:
      if (lookahead == 'r') ADVANCE(2812);
      END_STATE();
    case 2687:
      if (lookahead == 'r') ADVANCE(1937);
      END_STATE();
    case 2688:
      if (lookahead == 'r') ADVANCE(1808);
      END_STATE();
    case 2689:
      if (lookahead == 'r') ADVANCE(1809);
      END_STATE();
    case 2690:
      if (lookahead == 'r') ADVANCE(2003);
      END_STATE();
    case 2691:
      if (lookahead == 'r') ADVANCE(1922);
      END_STATE();
    case 2692:
      if (lookahead == 'r') ADVANCE(1827);
      END_STATE();
    case 2693:
      if (lookahead == 'r') ADVANCE(1908);
      END_STATE();
    case 2694:
      if (lookahead == 'r') ADVANCE(1899);
      END_STATE();
    case 2695:
      if (lookahead == 'r') ADVANCE(2071);
      END_STATE();
    case 2696:
      if (lookahead == 'r') ADVANCE(1765);
      END_STATE();
    case 2697:
      if (lookahead == 'r') ADVANCE(2887);
      END_STATE();
    case 2698:
      if (lookahead == 'r') ADVANCE(2475);
      END_STATE();
    case 2699:
      if (lookahead == 'r') ADVANCE(1944);
      END_STATE();
    case 2700:
      if (lookahead == 'r') ADVANCE(1971);
      END_STATE();
    case 2701:
      if (lookahead == 'r') ADVANCE(2765);
      END_STATE();
    case 2702:
      if (lookahead == 'r') ADVANCE(1746);
      END_STATE();
    case 2703:
      if (lookahead == 'r') ADVANCE(1645);
      END_STATE();
    case 2704:
      if (lookahead == 'r') ADVANCE(1916);
      END_STATE();
    case 2705:
      if (lookahead == 'r') ADVANCE(1949);
      END_STATE();
    case 2706:
      if (lookahead == 'r') ADVANCE(1974);
      END_STATE();
    case 2707:
      if (lookahead == 'r') ADVANCE(1524);
      END_STATE();
    case 2708:
      if (lookahead == 'r') ADVANCE(1305);
      END_STATE();
    case 2709:
      if (lookahead == 'r') ADVANCE(2074);
      END_STATE();
    case 2710:
      if (lookahead == 'r') ADVANCE(2714);
      END_STATE();
    case 2711:
      if (lookahead == 'r') ADVANCE(1975);
      END_STATE();
    case 2712:
      if (lookahead == 'r') ADVANCE(2079);
      END_STATE();
    case 2713:
      if (lookahead == 'r') ADVANCE(2841);
      END_STATE();
    case 2714:
      if (lookahead == 'r') ADVANCE(2544);
      END_STATE();
    case 2715:
      if (lookahead == 'r') ADVANCE(2541);
      END_STATE();
    case 2716:
      if (lookahead == 'r') ADVANCE(1328);
      END_STATE();
    case 2717:
      if (lookahead == 'r') ADVANCE(1759);
      END_STATE();
    case 2718:
      if (lookahead == 'r') ADVANCE(1499);
      END_STATE();
    case 2719:
      if (lookahead == 'r') ADVANCE(1332);
      END_STATE();
    case 2720:
      if (lookahead == 'r') ADVANCE(1985);
      END_STATE();
    case 2721:
      if (lookahead == 'r') ADVANCE(1979);
      END_STATE();
    case 2722:
      if (lookahead == 'r') ADVANCE(2937);
      END_STATE();
    case 2723:
      if (lookahead == 'r') ADVANCE(2579);
      if (lookahead == 'x') ADVANCE(2789);
      END_STATE();
    case 2724:
      if (lookahead == 'r') ADVANCE(2491);
      END_STATE();
    case 2725:
      if (lookahead == 'r') ADVANCE(2493);
      END_STATE();
    case 2726:
      if (lookahead == 'r') ADVANCE(1993);
      END_STATE();
    case 2727:
      if (lookahead == 'r') ADVANCE(2781);
      END_STATE();
    case 2728:
      if (lookahead == 's') ADVANCE(3792);
      END_STATE();
    case 2729:
      if (lookahead == 's') ADVANCE(3498);
      END_STATE();
    case 2730:
      if (lookahead == 's') ADVANCE(3619);
      END_STATE();
    case 2731:
      if (lookahead == 's') ADVANCE(4543);
      END_STATE();
    case 2732:
      if (lookahead == 's') ADVANCE(3653);
      END_STATE();
    case 2733:
      if (lookahead == 's') ADVANCE(3465);
      END_STATE();
    case 2734:
      if (lookahead == 's') ADVANCE(3342);
      END_STATE();
    case 2735:
      if (lookahead == 's') ADVANCE(3423);
      END_STATE();
    case 2736:
      if (lookahead == 's') ADVANCE(3432);
      END_STATE();
    case 2737:
      if (lookahead == 's') ADVANCE(3372);
      END_STATE();
    case 2738:
      if (lookahead == 's') ADVANCE(56);
      END_STATE();
    case 2739:
      if (lookahead == 's') ADVANCE(1522);
      END_STATE();
    case 2740:
      if (lookahead == 's') ADVANCE(2784);
      END_STATE();
    case 2741:
      if (lookahead == 's') ADVANCE(2773);
      END_STATE();
    case 2742:
      if (lookahead == 's') ADVANCE(2786);
      END_STATE();
    case 2743:
      if (lookahead == 's') ADVANCE(2870);
      if (lookahead == 't') ADVANCE(2718);
      if (lookahead == 'v') ADVANCE(1999);
      END_STATE();
    case 2744:
      if (lookahead == 's') ADVANCE(2601);
      END_STATE();
    case 2745:
      if (lookahead == 's') ADVANCE(1951);
      if (lookahead == 't') ADVANCE(2002);
      END_STATE();
    case 2746:
      if (lookahead == 's') ADVANCE(2990);
      END_STATE();
    case 2747:
      if (lookahead == 's') ADVANCE(2160);
      END_STATE();
    case 2748:
      if (lookahead == 's') ADVANCE(1336);
      END_STATE();
    case 2749:
      if (lookahead == 's') ADVANCE(2732);
      END_STATE();
    case 2750:
      if (lookahead == 's') ADVANCE(2733);
      END_STATE();
    case 2751:
      if (lookahead == 's') ADVANCE(2107);
      if (lookahead == 'u') ADVANCE(2108);
      END_STATE();
    case 2752:
      if (lookahead == 's') ADVANCE(1629);
      END_STATE();
    case 2753:
      if (lookahead == 's') ADVANCE(2735);
      END_STATE();
    case 2754:
      if (lookahead == 's') ADVANCE(2736);
      END_STATE();
    case 2755:
      if (lookahead == 's') ADVANCE(2799);
      END_STATE();
    case 2756:
      if (lookahead == 's') ADVANCE(2161);
      END_STATE();
    case 2757:
      if (lookahead == 's') ADVANCE(1795);
      END_STATE();
    case 2758:
      if (lookahead == 's') ADVANCE(2801);
      END_STATE();
    case 2759:
      if (lookahead == 's') ADVANCE(2802);
      END_STATE();
    case 2760:
      if (lookahead == 's') ADVANCE(2818);
      END_STATE();
    case 2761:
      if (lookahead == 's') ADVANCE(2851);
      END_STATE();
    case 2762:
      if (lookahead == 's') ADVANCE(2844);
      END_STATE();
    case 2763:
      if (lookahead == 's') ADVANCE(2823);
      END_STATE();
    case 2764:
      if (lookahead == 's') ADVANCE(1816);
      END_STATE();
    case 2765:
      if (lookahead == 's') ADVANCE(1829);
      END_STATE();
    case 2766:
      if (lookahead == 's') ADVANCE(1903);
      END_STATE();
    case 2767:
      if (lookahead == 's') ADVANCE(2573);
      END_STATE();
    case 2768:
      if (lookahead == 's') ADVANCE(2879);
      END_STATE();
    case 2769:
      if (lookahead == 's') ADVANCE(2867);
      END_STATE();
    case 2770:
      if (lookahead == 's') ADVANCE(2756);
      END_STATE();
    case 2771:
      if (lookahead == 's') ADVANCE(2528);
      END_STATE();
    case 2772:
      if (lookahead == 's') ADVANCE(2845);
      END_STATE();
    case 2773:
      if (lookahead == 's') ADVANCE(2529);
      END_STATE();
    case 2774:
      if (lookahead == 's') ADVANCE(1546);
      END_STATE();
    case 2775:
      if (lookahead == 's') ADVANCE(2838);
      END_STATE();
    case 2776:
      if (lookahead == 's') ADVANCE(2874);
      END_STATE();
    case 2777:
      if (lookahead == 's') ADVANCE(2143);
      END_STATE();
    case 2778:
      if (lookahead == 's') ADVANCE(2173);
      END_STATE();
    case 2779:
      if (lookahead == 's') ADVANCE(2181);
      END_STATE();
    case 2780:
      if (lookahead == 's') ADVANCE(2620);
      END_STATE();
    case 2781:
      if (lookahead == 's') ADVANCE(2621);
      END_STATE();
    case 2782:
      if (lookahead == 's') ADVANCE(1521);
      END_STATE();
    case 2783:
      if (lookahead == 't') ADVANCE(3321);
      END_STATE();
    case 2784:
      if (lookahead == 't') ADVANCE(3778);
      END_STATE();
    case 2785:
      if (lookahead == 't') ADVANCE(2611);
      END_STATE();
    case 2786:
      if (lookahead == 't') ADVANCE(3504);
      END_STATE();
    case 2787:
      if (lookahead == 't') ADVANCE(3736);
      END_STATE();
    case 2788:
      if (lookahead == 't') ADVANCE(3492);
      END_STATE();
    case 2789:
      if (lookahead == 't') ADVANCE(3734);
      END_STATE();
    case 2790:
      if (lookahead == 't') ADVANCE(3562);
      END_STATE();
    case 2791:
      if (lookahead == 't') ADVANCE(3217);
      END_STATE();
    case 2792:
      if (lookahead == 't') ADVANCE(3740);
      END_STATE();
    case 2793:
      if (lookahead == 't') ADVANCE(1369);
      END_STATE();
    case 2794:
      if (lookahead == 't') ADVANCE(3214);
      END_STATE();
    case 2795:
      if (lookahead == 't') ADVANCE(3289);
      END_STATE();
    case 2796:
      if (lookahead == 't') ADVANCE(2008);
      END_STATE();
    case 2797:
      if (lookahead == 't') ADVANCE(3554);
      END_STATE();
    case 2798:
      if (lookahead == 't') ADVANCE(3081);
      END_STATE();
    case 2799:
      if (lookahead == 't') ADVANCE(3730);
      END_STATE();
    case 2800:
      if (lookahead == 't') ADVANCE(3131);
      END_STATE();
    case 2801:
      if (lookahead == 't') ADVANCE(3801);
      END_STATE();
    case 2802:
      if (lookahead == 't') ADVANCE(3766);
      END_STATE();
    case 2803:
      if (lookahead == 't') ADVANCE(3477);
      END_STATE();
    case 2804:
      if (lookahead == 't') ADVANCE(3474);
      END_STATE();
    case 2805:
      if (lookahead == 't') ADVANCE(3572);
      END_STATE();
    case 2806:
      if (lookahead == 't') ADVANCE(3791);
      END_STATE();
    case 2807:
      if (lookahead == 't') ADVANCE(3774);
      END_STATE();
    case 2808:
      if (lookahead == 't') ADVANCE(3804);
      END_STATE();
    case 2809:
      if (lookahead == 't') ADVANCE(54);
      END_STATE();
    case 2810:
      if (lookahead == 't') ADVANCE(3754);
      END_STATE();
    case 2811:
      if (lookahead == 't') ADVANCE(3139);
      END_STATE();
    case 2812:
      if (lookahead == 't') ADVANCE(3137);
      END_STATE();
    case 2813:
      if (lookahead == 't') ADVANCE(3315);
      END_STATE();
    case 2814:
      if (lookahead == 't') ADVANCE(3084);
      END_STATE();
    case 2815:
      if (lookahead == 't') ADVANCE(3330);
      END_STATE();
    case 2816:
      if (lookahead == 't') ADVANCE(3786);
      END_STATE();
    case 2817:
      if (lookahead == 't') ADVANCE(3787);
      END_STATE();
    case 2818:
      if (lookahead == 't') ADVANCE(3742);
      END_STATE();
    case 2819:
      if (lookahead == 't') ADVANCE(3552);
      END_STATE();
    case 2820:
      if (lookahead == 't') ADVANCE(3550);
      END_STATE();
    case 2821:
      if (lookahead == 't') ADVANCE(3354);
      END_STATE();
    case 2822:
      if (lookahead == 't') ADVANCE(3127);
      END_STATE();
    case 2823:
      if (lookahead == 't') ADVANCE(3777);
      END_STATE();
    case 2824:
      if (lookahead == 't') ADVANCE(1454);
      END_STATE();
    case 2825:
      if (lookahead == 't') ADVANCE(3569);
      END_STATE();
    case 2826:
      if (lookahead == 't') ADVANCE(1540);
      END_STATE();
    case 2827:
      if (lookahead == 't') ADVANCE(2667);
      END_STATE();
    case 2828:
      if (lookahead == 't') ADVANCE(1428);
      END_STATE();
    case 2829:
      if (lookahead == 't') ADVANCE(2989);
      END_STATE();
    case 2830:
      if (lookahead == 't') ADVANCE(2552);
      END_STATE();
    case 2831:
      if (lookahead == 't') ADVANCE(1530);
      END_STATE();
    case 2832:
      if (lookahead == 't') ADVANCE(1295);
      END_STATE();
    case 2833:
      if (lookahead == 't') ADVANCE(2718);
      END_STATE();
    case 2834:
      if (lookahead == 't') ADVANCE(2718);
      if (lookahead == 'v') ADVANCE(1999);
      END_STATE();
    case 2835:
      if (lookahead == 't') ADVANCE(2979);
      END_STATE();
    case 2836:
      if (lookahead == 't') ADVANCE(1897);
      END_STATE();
    case 2837:
      if (lookahead == 't') ADVANCE(2049);
      END_STATE();
    case 2838:
      if (lookahead == 't') ADVANCE(2176);
      END_STATE();
    case 2839:
      if (lookahead == 't') ADVANCE(2936);
      END_STATE();
    case 2840:
      if (lookahead == 't') ADVANCE(2199);
      END_STATE();
    case 2841:
      if (lookahead == 't') ADVANCE(2567);
      END_STATE();
    case 2842:
      if (lookahead == 't') ADVANCE(2180);
      END_STATE();
    case 2843:
      if (lookahead == 't') ADVANCE(2640);
      END_STATE();
    case 2844:
      if (lookahead == 't') ADVANCE(2610);
      END_STATE();
    case 2845:
      if (lookahead == 't') ADVANCE(1452);
      END_STATE();
    case 2846:
      if (lookahead == 't') ADVANCE(1371);
      END_STATE();
    case 2847:
      if (lookahead == 't') ADVANCE(2646);
      END_STATE();
    case 2848:
      if (lookahead == 't') ADVANCE(1907);
      END_STATE();
    case 2849:
      if (lookahead == 't') ADVANCE(1915);
      END_STATE();
    case 2850:
      if (lookahead == 't') ADVANCE(2288);
      END_STATE();
    case 2851:
      if (lookahead == 't') ADVANCE(2722);
      END_STATE();
    case 2852:
      if (lookahead == 't') ADVANCE(1984);
      END_STATE();
    case 2853:
      if (lookahead == 't') ADVANCE(2829);
      END_STATE();
    case 2854:
      if (lookahead == 't') ADVANCE(1815);
      END_STATE();
    case 2855:
      if (lookahead == 't') ADVANCE(1920);
      END_STATE();
    case 2856:
      if (lookahead == 't') ADVANCE(1904);
      END_STATE();
    case 2857:
      if (lookahead == 't') ADVANCE(1834);
      END_STATE();
    case 2858:
      if (lookahead == 't') ADVANCE(1924);
      END_STATE();
    case 2859:
      if (lookahead == 't') ADVANCE(1926);
      END_STATE();
    case 2860:
      if (lookahead == 't') ADVANCE(1840);
      END_STATE();
    case 2861:
      if (lookahead == 't') ADVANCE(1981);
      END_STATE();
    case 2862:
      if (lookahead == 't') ADVANCE(53);
      END_STATE();
    case 2863:
      if (lookahead == 't') ADVANCE(2387);
      END_STATE();
    case 2864:
      if (lookahead == 't') ADVANCE(2955);
      END_STATE();
    case 2865:
      if (lookahead == 't') ADVANCE(1619);
      END_STATE();
    case 2866:
      if (lookahead == 't') ADVANCE(1489);
      END_STATE();
    case 2867:
      if (lookahead == 't') ADVANCE(2527);
      END_STATE();
    case 2868:
      if (lookahead == 't') ADVANCE(1453);
      END_STATE();
    case 2869:
      if (lookahead == 't') ADVANCE(1997);
      END_STATE();
    case 2870:
      if (lookahead == 't') ADVANCE(1479);
      END_STATE();
    case 2871:
      if (lookahead == 't') ADVANCE(2715);
      END_STATE();
    case 2872:
      if (lookahead == 't') ADVANCE(2607);
      END_STATE();
    case 2873:
      if (lookahead == 't') ADVANCE(2531);
      END_STATE();
    case 2874:
      if (lookahead == 't') ADVANCE(1466);
      END_STATE();
    case 2875:
      if (lookahead == 't') ADVANCE(2190);
      END_STATE();
    case 2876:
      if (lookahead == 't') ADVANCE(2036);
      END_STATE();
    case 2877:
      if (lookahead == 't') ADVANCE(2530);
      END_STATE();
    case 2878:
      if (lookahead == 't') ADVANCE(2138);
      END_STATE();
    case 2879:
      if (lookahead == 't') ADVANCE(1640);
      END_STATE();
    case 2880:
      if (lookahead == 't') ADVANCE(1628);
      END_STATE();
    case 2881:
      if (lookahead == 't') ADVANCE(1618);
      END_STATE();
    case 2882:
      if (lookahead == 't') ADVANCE(1536);
      END_STATE();
    case 2883:
      if (lookahead == 't') ADVANCE(1621);
      END_STATE();
    case 2884:
      if (lookahead == 't') ADVANCE(1627);
      END_STATE();
    case 2885:
      if (lookahead == 't') ADVANCE(2147);
      END_STATE();
    case 2886:
      if (lookahead == 't') ADVANCE(2560);
      END_STATE();
    case 2887:
      if (lookahead == 't') ADVANCE(2198);
      END_STATE();
    case 2888:
      if (lookahead == 't') ADVANCE(2930);
      END_STATE();
    case 2889:
      if (lookahead == 't') ADVANCE(2192);
      END_STATE();
    case 2890:
      if (lookahead == 't') ADVANCE(2189);
      END_STATE();
    case 2891:
      if (lookahead == 't') ADVANCE(2193);
      END_STATE();
    case 2892:
      if (lookahead == 't') ADVANCE(2175);
      END_STATE();
    case 2893:
      if (lookahead == 't') ADVANCE(2183);
      END_STATE();
    case 2894:
      if (lookahead == 't') ADVANCE(2188);
      END_STATE();
    case 2895:
      if (lookahead == 't') ADVANCE(1998);
      END_STATE();
    case 2896:
      if (lookahead == 't') ADVANCE(2010);
      END_STATE();
    case 2897:
      if (lookahead == 't') ADVANCE(2205);
      END_STATE();
    case 2898:
      if (lookahead == 't') ADVANCE(1538);
      END_STATE();
    case 2899:
      if (lookahead == 't') ADVANCE(1541);
      END_STATE();
    case 2900:
      if (lookahead == 't') ADVANCE(1543);
      END_STATE();
    case 2901:
      if (lookahead == 'u') ADVANCE(1793);
      END_STATE();
    case 2902:
      if (lookahead == 'u') ADVANCE(1551);
      END_STATE();
    case 2903:
      if (lookahead == 'u') ADVANCE(1548);
      END_STATE();
    case 2904:
      if (lookahead == 'u') ADVANCE(2994);
      END_STATE();
    case 2905:
      if (lookahead == 'u') ADVANCE(2233);
      END_STATE();
    case 2906:
      if (lookahead == 'u') ADVANCE(2615);
      END_STATE();
    case 2907:
      if (lookahead == 'u') ADVANCE(2588);
      END_STATE();
    case 2908:
      if (lookahead == 'u') ADVANCE(2293);
      END_STATE();
    case 2909:
      if (lookahead == 'u') ADVANCE(2701);
      END_STATE();
    case 2910:
      if (lookahead == 'u') ADVANCE(2443);
      END_STATE();
    case 2911:
      if (lookahead == 'u') ADVANCE(2341);
      END_STATE();
    case 2912:
      if (lookahead == 'u') ADVANCE(2595);
      END_STATE();
    case 2913:
      if (lookahead == 'u') ADVANCE(2457);
      END_STATE();
    case 2914:
      if (lookahead == 'u') ADVANCE(2814);
      END_STATE();
    case 2915:
      if (lookahead == 'u') ADVANCE(1804);
      END_STATE();
    case 2916:
      if (lookahead == 'u') ADVANCE(1820);
      END_STATE();
    case 2917:
      if (lookahead == 'u') ADVANCE(1833);
      END_STATE();
    case 2918:
      if (lookahead == 'u') ADVANCE(1837);
      END_STATE();
    case 2919:
      if (lookahead == 'u') ADVANCE(1792);
      END_STATE();
    case 2920:
      if (lookahead == 'u') ADVANCE(2703);
      END_STATE();
    case 2921:
      if (lookahead == 'u') ADVANCE(2679);
      END_STATE();
    case 2922:
      if (lookahead == 'u') ADVANCE(2308);
      END_STATE();
    case 2923:
      if (lookahead == 'u') ADVANCE(2380);
      END_STATE();
    case 2924:
      if (lookahead == 'u') ADVANCE(2441);
      END_STATE();
    case 2925:
      if (lookahead == 'u') ADVANCE(2296);
      END_STATE();
    case 2926:
      if (lookahead == 'u') ADVANCE(2388);
      END_STATE();
    case 2927:
      if (lookahead == 'u') ADVANCE(1440);
      END_STATE();
    case 2928:
      if (lookahead == 'u') ADVANCE(2683);
      END_STATE();
    case 2929:
      if (lookahead == 'u') ADVANCE(2163);
      END_STATE();
    case 2930:
      if (lookahead == 'u') ADVANCE(2685);
      END_STATE();
    case 2931:
      if (lookahead == 'u') ADVANCE(2385);
      END_STATE();
    case 2932:
      if (lookahead == 'u') ADVANCE(1310);
      END_STATE();
    case 2933:
      if (lookahead == 'u') ADVANCE(2305);
      END_STATE();
    case 2934:
      if (lookahead == 'u') ADVANCE(2447);
      END_STATE();
    case 2935:
      if (lookahead == 'u') ADVANCE(2856);
      END_STATE();
    case 2936:
      if (lookahead == 'u') ADVANCE(2692);
      END_STATE();
    case 2937:
      if (lookahead == 'u') ADVANCE(2399);
      END_STATE();
    case 2938:
      if (lookahead == 'u') ADVANCE(2202);
      END_STATE();
    case 2939:
      if (lookahead == 'u') ADVANCE(2623);
      END_STATE();
    case 2940:
      if (lookahead == 'v') ADVANCE(3673);
      END_STATE();
    case 2941:
      if (lookahead == 'v') ADVANCE(3665);
      END_STATE();
    case 2942:
      if (lookahead == 'v') ADVANCE(3663);
      END_STATE();
    case 2943:
      if (lookahead == 'v') ADVANCE(2375);
      END_STATE();
    case 2944:
      if (lookahead == 'v') ADVANCE(1491);
      END_STATE();
    case 2945:
      if (lookahead == 'v') ADVANCE(1892);
      END_STATE();
    case 2946:
      if (lookahead == 'v') ADVANCE(1931);
      END_STATE();
    case 2947:
      if (lookahead == 'v') ADVANCE(1967);
      END_STATE();
    case 2948:
      if (lookahead == 'v') ADVANCE(1969);
      END_STATE();
    case 2949:
      if (lookahead == 'v') ADVANCE(1526);
      END_STATE();
    case 2950:
      if (lookahead == 'v') ADVANCE(1512);
      END_STATE();
    case 2951:
      if (lookahead == 'v') ADVANCE(1999);
      END_STATE();
    case 2952:
      if (lookahead == 'w') ADVANCE(3560);
      if (lookahead == 'z') ADVANCE(3772);
      END_STATE();
    case 2953:
      if (lookahead == 'w') ADVANCE(3613);
      END_STATE();
    case 2954:
      if (lookahead == 'w') ADVANCE(2158);
      END_STATE();
    case 2955:
      if (lookahead == 'w') ADVANCE(2185);
      END_STATE();
    case 2956:
      if (lookahead == 'w') ADVANCE(1923);
      END_STATE();
    case 2957:
      if (lookahead == 'w') ADVANCE(1679);
      END_STATE();
    case 2958:
      if (lookahead == 'w') ADVANCE(1535);
      END_STATE();
    case 2959:
      if (lookahead == 'x') ADVANCE(3008);
      END_STATE();
    case 2960:
      if (lookahead == 'x') ADVANCE(3694);
      END_STATE();
    case 2961:
      if (lookahead == 'x') ADVANCE(3700);
      END_STATE();
    case 2962:
      if (lookahead == 'x') ADVANCE(3293);
      END_STATE();
    case 2963:
      if (lookahead == 'x') ADVANCE(3243);
      END_STATE();
    case 2964:
      if (lookahead == 'x') ADVANCE(3239);
      END_STATE();
    case 2965:
      if (lookahead == 'x') ADVANCE(1293);
      END_STATE();
    case 2966:
      if (lookahead == 'x') ADVANCE(1664);
      END_STATE();
    case 2967:
      if (lookahead == 'x') ADVANCE(2600);
      END_STATE();
    case 2968:
      if (lookahead == 'x') ADVANCE(2792);
      END_STATE();
    case 2969:
      if (lookahead == 'x') ADVANCE(2803);
      END_STATE();
    case 2970:
      if (lookahead == 'x') ADVANCE(2804);
      END_STATE();
    case 2971:
      if (lookahead == 'x') ADVANCE(2895);
      END_STATE();
    case 2972:
      if (lookahead == 'x') ADVANCE(1927);
      END_STATE();
    case 2973:
      if (lookahead == 'x') ADVANCE(1935);
      END_STATE();
    case 2974:
      if (lookahead == 'x') ADVANCE(1411);
      END_STATE();
    case 2975:
      if (lookahead == 'x') ADVANCE(2861);
      END_STATE();
    case 2976:
      if (lookahead == 'y') ADVANCE(3408);
      END_STATE();
    case 2977:
      if (lookahead == 'y') ADVANCE(3411);
      END_STATE();
    case 2978:
      if (lookahead == 'y') ADVANCE(3414);
      END_STATE();
    case 2979:
      if (lookahead == 'y') ADVANCE(3297);
      END_STATE();
    case 2980:
      if (lookahead == 'y') ADVANCE(3426);
      END_STATE();
    case 2981:
      if (lookahead == 'y') ADVANCE(3324);
      END_STATE();
    case 2982:
      if (lookahead == 'y') ADVANCE(3109);
      END_STATE();
    case 2983:
      if (lookahead == 'y') ADVANCE(3327);
      END_STATE();
    case 2984:
      if (lookahead == 'y') ADVANCE(1562);
      END_STATE();
    case 2985:
      if (lookahead == 'y') ADVANCE(1331);
      END_STATE();
    case 2986:
      if (lookahead == 'y') ADVANCE(2449);
      END_STATE();
    case 2987:
      if (lookahead == 'y') ADVANCE(2522);
      END_STATE();
    case 2988:
      if (lookahead == 'y') ADVANCE(2777);
      END_STATE();
    case 2989:
      if (lookahead == 'y') ADVANCE(2609);
      END_STATE();
    case 2990:
      if (lookahead == 'y') ADVANCE(2461);
      END_STATE();
    case 2991:
      if (lookahead == 'y') ADVANCE(2680);
      END_STATE();
    case 2992:
      if (lookahead == 'z') ADVANCE(3772);
      END_STATE();
    case 2993:
      if (lookahead == 'z') ADVANCE(2984);
      END_STATE();
    case 2994:
      if (lookahead == 'z') ADVANCE(3005);
      END_STATE();
    case 2995:
      if (lookahead == 'z') ADVANCE(1800);
      END_STATE();
    case 2996:
      if (lookahead == 'z') ADVANCE(1811);
      END_STATE();
    case 2997:
      if (lookahead == 'z') ADVANCE(1814);
      END_STATE();
    case 2998:
      if (lookahead == 'z') ADVANCE(1822);
      END_STATE();
    case 2999:
      if (lookahead == 'z') ADVANCE(1895);
      END_STATE();
    case 3000:
      if (lookahead == 'z') ADVANCE(1825);
      END_STATE();
    case 3001:
      if (lookahead == 'z') ADVANCE(1965);
      END_STATE();
    case 3002:
      if (lookahead == 'z') ADVANCE(1933);
      END_STATE();
    case 3003:
      if (lookahead == 'z') ADVANCE(1936);
      END_STATE();
    case 3004:
      if (lookahead == 'z') ADVANCE(1934);
      END_STATE();
    case 3005:
      if (lookahead == 'z') ADVANCE(2152);
      END_STATE();
    case 3006:
      if (lookahead == 'z') ADVANCE(2568);
      END_STATE();
    case 3007:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(3012);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3078);
      END_STATE();
    case 3008:
      if (lookahead == 'H' ||
          ('K' <= lookahead && lookahead <= 'M') ||
          lookahead == 'R') ADVANCE(3014);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(3072);
      END_STATE();
    case 3009:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 3010:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3038);
      END_STATE();
    case 3011:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3258);
      END_STATE();
    case 3012:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3078);
      END_STATE();
    case 3013:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3069);
      END_STATE();
    case 3014:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(3072);
      END_STATE();
    case 3015:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3168);
      END_STATE();
    case 3016:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3161);
      END_STATE();
    case 3017:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3164);
      END_STATE();
    case 3018:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3192);
      END_STATE();
    case 3019:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3165);
      END_STATE();
    case 3020:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3166);
      END_STATE();
    case 3021:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3167);
      END_STATE();
    case 3022:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3203);
      END_STATE();
    case 3023:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3163);
      END_STATE();
    case 3024:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3162);
      END_STATE();
    case 3025:
      if (eof) ADVANCE(3036);
      if (lookahead == '!') ADVANCE(3805);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '#') ADVANCE(3010);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '0') ADVANCE(3059);
      if (lookahead == ':') ADVANCE(4542);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '=') ADVANCE(3083);
      if (lookahead == '>') ADVANCE(3268);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(1339);
      if (lookahead == 'b') ADVANCE(2015);
      if (lookahead == 'c') ADVANCE(29);
      if (lookahead == 'd') ADVANCE(1383);
      if (lookahead == 'e') ADVANCE(2257);
      if (lookahead == 'f') ADVANCE(1344);
      if (lookahead == 'g') ADVANCE(1576);
      if (lookahead == 'h') ADVANCE(1404);
      if (lookahead == 'i') ADVANCE(1656);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1345);
      if (lookahead == 'm') ADVANCE(1384);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1852);
      if (lookahead == 'p') ADVANCE(1379);
      if (lookahead == 'r') ADVANCE(1772);
      if (lookahead == 's') ADVANCE(73);
      if (lookahead == 't') ADVANCE(1351);
      if (lookahead == 'u') ADVANCE(84);
      if (lookahead == 'v') ADVANCE(1353);
      if (lookahead == 'w') ADVANCE(1773);
      if (lookahead == 'x') ADVANCE(3273);
      if (lookahead == 'z') ADVANCE(1856);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '|') ADVANCE(4541);
      if (lookahead == '}') ADVANCE(3261);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3009);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3025)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 3026:
      if (eof) ADVANCE(3036);
      if (lookahead == '!') ADVANCE(3805);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '#') ADVANCE(3010);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '0') ADVANCE(3067);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '=') ADVANCE(3083);
      if (lookahead == '>') ADVANCE(3268);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(1570);
      if (lookahead == 'b') ADVANCE(2017);
      if (lookahead == 'c') ADVANCE(1527);
      if (lookahead == 'd') ADVANCE(1855);
      if (lookahead == 'e') ADVANCE(2258);
      if (lookahead == 'f') ADVANCE(1508);
      if (lookahead == 'g') ADVANCE(1577);
      if (lookahead == 'h') ADVANCE(1407);
      if (lookahead == 'i') ADVANCE(2025);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1421);
      if (lookahead == 'm') ADVANCE(1954);
      if (lookahead == 'n') ADVANCE(1486);
      if (lookahead == 'o') ADVANCE(2591);
      if (lookahead == 'p') ADVANCE(1382);
      if (lookahead == 'r') ADVANCE(1862);
      if (lookahead == 's') ADVANCE(78);
      if (lookahead == 't') ADVANCE(1531);
      if (lookahead == 'u') ADVANCE(94);
      if (lookahead == 'v') ADVANCE(2503);
      if (lookahead == 'w') ADVANCE(1932);
      if (lookahead == 'x') ADVANCE(121);
      if (lookahead == 'z') ADVANCE(1980);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3013);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3026)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3069);
      END_STATE();
    case 3027:
      if (eof) ADVANCE(3036);
      if (lookahead == '!') ADVANCE(3805);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '#') ADVANCE(3010);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '0') ADVANCE(3059);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '>') ADVANCE(3268);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(1689);
      if (lookahead == 'b') ADVANCE(2016);
      if (lookahead == 'c') ADVANCE(33);
      if (lookahead == 'd') ADVANCE(1771);
      if (lookahead == 'e') ADVANCE(2261);
      if (lookahead == 'f') ADVANCE(1375);
      if (lookahead == 'g') ADVANCE(1575);
      if (lookahead == 'h') ADVANCE(1406);
      if (lookahead == 'i') ADVANCE(1660);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1378);
      if (lookahead == 'm') ADVANCE(1387);
      if (lookahead == 'n') ADVANCE(1349);
      if (lookahead == 'o') ADVANCE(2592);
      if (lookahead == 'p') ADVANCE(1381);
      if (lookahead == 'r') ADVANCE(1867);
      if (lookahead == 's') ADVANCE(74);
      if (lookahead == 't') ADVANCE(1532);
      if (lookahead == 'u') ADVANCE(89);
      if (lookahead == 'v') ADVANCE(2536);
      if (lookahead == 'w') ADVANCE(1929);
      if (lookahead == 'x') ADVANCE(122);
      if (lookahead == 'z') ADVANCE(1856);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3009);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3027)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 3028:
      if (eof) ADVANCE(3036);
      if (lookahead == '!') ADVANCE(3805);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '0') ADVANCE(3059);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '>') ADVANCE(3268);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(1569);
      if (lookahead == 'b') ADVANCE(2014);
      if (lookahead == 'c') ADVANCE(34);
      if (lookahead == 'd') ADVANCE(1850);
      if (lookahead == 'e') ADVANCE(2625);
      if (lookahead == 'f') ADVANCE(1375);
      if (lookahead == 'g') ADVANCE(1864);
      if (lookahead == 'h') ADVANCE(1405);
      if (lookahead == 'i') ADVANCE(1662);
      if (lookahead == 'l') ADVANCE(1420);
      if (lookahead == 'm') ADVANCE(1390);
      if (lookahead == 'n') ADVANCE(1469);
      if (lookahead == 'o') ADVANCE(2606);
      if (lookahead == 'p') ADVANCE(2508);
      if (lookahead == 'r') ADVANCE(1994);
      if (lookahead == 's') ADVANCE(81);
      if (lookahead == 't') ADVANCE(1532);
      if (lookahead == 'u') ADVANCE(85);
      if (lookahead == 'v') ADVANCE(2535);
      if (lookahead == 'w') ADVANCE(1928);
      if (lookahead == 'x') ADVANCE(122);
      if (lookahead == 'z') ADVANCE(1956);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3009);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3028)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 3029:
      if (eof) ADVANCE(3036);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '#') ADVANCE(3010);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3807);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(2012);
      if (lookahead == 'b') ADVANCE(2017);
      if (lookahead == 'c') ADVANCE(2517);
      if (lookahead == 'd') ADVANCE(1855);
      if (lookahead == 'e') ADVANCE(2256);
      if (lookahead == 'f') ADVANCE(1395);
      if (lookahead == 'g') ADVANCE(1574);
      if (lookahead == 'h') ADVANCE(1407);
      if (lookahead == 'i') ADVANCE(2374);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1417);
      if (lookahead == 'm') ADVANCE(1955);
      if (lookahead == 'n') ADVANCE(1487);
      if (lookahead == 'o') ADVANCE(1853);
      if (lookahead == 'p') ADVANCE(1382);
      if (lookahead == 'r') ADVANCE(1873);
      if (lookahead == 's') ADVANCE(1372);
      if (lookahead == 't') ADVANCE(1533);
      if (lookahead == 'u') ADVANCE(1863);
      if (lookahead == 'v') ADVANCE(2536);
      if (lookahead == 'w') ADVANCE(2153);
      if (lookahead == 'x') ADVANCE(121);
      if (lookahead == 'z') ADVANCE(1980);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3031)
      END_STATE();
    case 3030:
      if (eof) ADVANCE(3036);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '#') ADVANCE(3010);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '0') ADVANCE(3059);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '=') ADVANCE(3083);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'b') ADVANCE(2015);
      if (lookahead == 'c') ADVANCE(32);
      if (lookahead == 'd') ADVANCE(1771);
      if (lookahead == 'e') ADVANCE(2262);
      if (lookahead == 'f') ADVANCE(1474);
      if (lookahead == 'g') ADVANCE(1575);
      if (lookahead == 'h') ADVANCE(1406);
      if (lookahead == 'i') ADVANCE(1659);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1374);
      if (lookahead == 'm') ADVANCE(1386);
      if (lookahead == 'n') ADVANCE(1347);
      if (lookahead == 'o') ADVANCE(2592);
      if (lookahead == 'p') ADVANCE(1380);
      if (lookahead == 'r') ADVANCE(1848);
      if (lookahead == 's') ADVANCE(75);
      if (lookahead == 't') ADVANCE(1352);
      if (lookahead == 'u') ADVANCE(87);
      if (lookahead == 'v') ADVANCE(1354);
      if (lookahead == 'w') ADVANCE(1929);
      if (lookahead == 'x') ADVANCE(122);
      if (lookahead == 'z') ADVANCE(1856);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3009);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3030)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 3031:
      if (eof) ADVANCE(3036);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '#') ADVANCE(3010);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(2012);
      if (lookahead == 'b') ADVANCE(2017);
      if (lookahead == 'c') ADVANCE(2517);
      if (lookahead == 'd') ADVANCE(1855);
      if (lookahead == 'e') ADVANCE(2256);
      if (lookahead == 'f') ADVANCE(1395);
      if (lookahead == 'g') ADVANCE(1574);
      if (lookahead == 'h') ADVANCE(1407);
      if (lookahead == 'i') ADVANCE(2374);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1417);
      if (lookahead == 'm') ADVANCE(1955);
      if (lookahead == 'n') ADVANCE(1487);
      if (lookahead == 'o') ADVANCE(1853);
      if (lookahead == 'p') ADVANCE(1382);
      if (lookahead == 'r') ADVANCE(1873);
      if (lookahead == 's') ADVANCE(1372);
      if (lookahead == 't') ADVANCE(1533);
      if (lookahead == 'u') ADVANCE(1863);
      if (lookahead == 'v') ADVANCE(2536);
      if (lookahead == 'w') ADVANCE(2153);
      if (lookahead == 'x') ADVANCE(121);
      if (lookahead == 'z') ADVANCE(1980);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3031)
      END_STATE();
    case 3032:
      if (eof) ADVANCE(3036);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3807);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '0') ADVANCE(3067);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '=') ADVANCE(3083);
      if (lookahead == '>') ADVANCE(3268);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(1340);
      if (lookahead == 'b') ADVANCE(2017);
      if (lookahead == 'c') ADVANCE(1573);
      if (lookahead == 'd') ADVANCE(1771);
      if (lookahead == 'e') ADVANCE(2260);
      if (lookahead == 'f') ADVANCE(1457);
      if (lookahead == 'g') ADVANCE(2082);
      if (lookahead == 'h') ADVANCE(1404);
      if (lookahead == 'i') ADVANCE(2373);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1418);
      if (lookahead == 'm') ADVANCE(1953);
      if (lookahead == 'n') ADVANCE(1488);
      if (lookahead == 'o') ADVANCE(2591);
      if (lookahead == 'p') ADVANCE(2593);
      if (lookahead == 'r') ADVANCE(1862);
      if (lookahead == 's') ADVANCE(80);
      if (lookahead == 't') ADVANCE(1475);
      if (lookahead == 'u') ADVANCE(94);
      if (lookahead == 'v') ADVANCE(2536);
      if (lookahead == 'w') ADVANCE(1774);
      if (lookahead == 'x') ADVANCE(118);
      if (lookahead == 'z') ADVANCE(1980);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3013);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3035)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3069);
      END_STATE();
    case 3033:
      if (eof) ADVANCE(3036);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == '(') ADVANCE(3278);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '0') ADVANCE(3067);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '>') ADVANCE(3268);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(1341);
      if (lookahead == 'b') ADVANCE(2017);
      if (lookahead == 'c') ADVANCE(1572);
      if (lookahead == 'd') ADVANCE(1771);
      if (lookahead == 'e') ADVANCE(2260);
      if (lookahead == 'f') ADVANCE(1398);
      if (lookahead == 'g') ADVANCE(2082);
      if (lookahead == 'h') ADVANCE(1404);
      if (lookahead == 'i') ADVANCE(2373);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1418);
      if (lookahead == 'm') ADVANCE(1385);
      if (lookahead == 'n') ADVANCE(1350);
      if (lookahead == 'o') ADVANCE(2592);
      if (lookahead == 'p') ADVANCE(2593);
      if (lookahead == 'r') ADVANCE(1847);
      if (lookahead == 's') ADVANCE(79);
      if (lookahead == 't') ADVANCE(1475);
      if (lookahead == 'u') ADVANCE(93);
      if (lookahead == 'v') ADVANCE(2503);
      if (lookahead == 'w') ADVANCE(1774);
      if (lookahead == 'x') ADVANCE(119);
      if (lookahead == 'z') ADVANCE(1980);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3013);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3033)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3069);
      END_STATE();
    case 3034:
      if (eof) ADVANCE(3036);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == '*') ADVANCE(3207);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '0') ADVANCE(3059);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '>') ADVANCE(3268);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(1571);
      if (lookahead == 'b') ADVANCE(2014);
      if (lookahead == 'c') ADVANCE(34);
      if (lookahead == 'd') ADVANCE(1850);
      if (lookahead == 'e') ADVANCE(2971);
      if (lookahead == 'f') ADVANCE(1375);
      if (lookahead == 'g') ADVANCE(1864);
      if (lookahead == 'h') ADVANCE(1405);
      if (lookahead == 'i') ADVANCE(1662);
      if (lookahead == 'l') ADVANCE(1420);
      if (lookahead == 'm') ADVANCE(1390);
      if (lookahead == 'n') ADVANCE(1470);
      if (lookahead == 'o') ADVANCE(2606);
      if (lookahead == 'p') ADVANCE(2508);
      if (lookahead == 'r') ADVANCE(1994);
      if (lookahead == 's') ADVANCE(82);
      if (lookahead == 't') ADVANCE(1532);
      if (lookahead == 'u') ADVANCE(88);
      if (lookahead == 'v') ADVANCE(2535);
      if (lookahead == 'w') ADVANCE(1928);
      if (lookahead == 'x') ADVANCE(122);
      if (lookahead == 'z') ADVANCE(1956);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3009);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3034)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 3035:
      if (eof) ADVANCE(3036);
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(23);
      if (lookahead == ')') ADVANCE(3279);
      if (lookahead == ',') ADVANCE(3269);
      if (lookahead == '0') ADVANCE(3067);
      if (lookahead == ';') ADVANCE(3037);
      if (lookahead == '<') ADVANCE(3267);
      if (lookahead == '=') ADVANCE(3083);
      if (lookahead == '>') ADVANCE(3268);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == '[') ADVANCE(3264);
      if (lookahead == ']') ADVANCE(3265);
      if (lookahead == '^') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(1340);
      if (lookahead == 'b') ADVANCE(2017);
      if (lookahead == 'c') ADVANCE(1573);
      if (lookahead == 'd') ADVANCE(1771);
      if (lookahead == 'e') ADVANCE(2260);
      if (lookahead == 'f') ADVANCE(1457);
      if (lookahead == 'g') ADVANCE(2082);
      if (lookahead == 'h') ADVANCE(1404);
      if (lookahead == 'i') ADVANCE(2373);
      if (lookahead == 'j') ADVANCE(2923);
      if (lookahead == 'l') ADVANCE(1418);
      if (lookahead == 'm') ADVANCE(1953);
      if (lookahead == 'n') ADVANCE(1488);
      if (lookahead == 'o') ADVANCE(2591);
      if (lookahead == 'p') ADVANCE(2593);
      if (lookahead == 'r') ADVANCE(1862);
      if (lookahead == 's') ADVANCE(80);
      if (lookahead == 't') ADVANCE(1475);
      if (lookahead == 'u') ADVANCE(94);
      if (lookahead == 'v') ADVANCE(2536);
      if (lookahead == 'w') ADVANCE(1774);
      if (lookahead == 'x') ADVANCE(118);
      if (lookahead == 'z') ADVANCE(1980);
      if (lookahead == '{') ADVANCE(3260);
      if (lookahead == '}') ADVANCE(3261);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(3013);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3035)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(3069);
      END_STATE();
    case 3036:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 3037:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(3037);
      END_STATE();
    case 3038:
      ACCEPT_TOKEN(sym_attr_ref);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3038);
      END_STATE();
    case 3039:
      ACCEPT_TOKEN(sym_comdat_ref);
      END_STATE();
    case 3040:
      ACCEPT_TOKEN(sym_comdat_ref);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3040);
      END_STATE();
    case 3041:
      ACCEPT_TOKEN(sym_comdat_ref);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3041);
      END_STATE();
    case 3042:
      ACCEPT_TOKEN(sym_global_var);
      END_STATE();
    case 3043:
      ACCEPT_TOKEN(sym_global_var);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3043);
      END_STATE();
    case 3044:
      ACCEPT_TOKEN(sym_global_var);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3044);
      END_STATE();
    case 3045:
      ACCEPT_TOKEN(sym_local_var);
      END_STATE();
    case 3046:
      ACCEPT_TOKEN(sym_local_var);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3046);
      END_STATE();
    case 3047:
      ACCEPT_TOKEN(sym_local_var);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3047);
      END_STATE();
    case 3048:
      ACCEPT_TOKEN(sym_label);
      END_STATE();
    case 3049:
      ACCEPT_TOKEN(aux_sym_metadata_ref_token1);
      END_STATE();
    case 3050:
      ACCEPT_TOKEN(aux_sym_metadata_ref_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3050);
      END_STATE();
    case 3051:
      ACCEPT_TOKEN(aux_sym_metadata_ref_token1);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3051);
      END_STATE();
    case 3052:
      ACCEPT_TOKEN(sym_summary_ref);
      END_STATE();
    case 3053:
      ACCEPT_TOKEN(sym_summary_ref);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3053);
      END_STATE();
    case 3054:
      ACCEPT_TOKEN(sym_summary_ref);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3054);
      END_STATE();
    case 3055:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 3056:
      ACCEPT_TOKEN(sym_string);
      if (lookahead == ':') ADVANCE(3048);
      END_STATE();
    case 3057:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(3076);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(3008);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3058);
      END_STATE();
    case 3058:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(3076);
      if (lookahead == ':') ADVANCE(3048);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3058);
      END_STATE();
    case 3059:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(3076);
      if (lookahead == 'x') ADVANCE(3008);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 3060:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(3076);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3060);
      END_STATE();
    case 3061:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(3074);
      if (lookahead == ':') ADVANCE(3048);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3061);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3062:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(3077);
      if (lookahead == 'x') ADVANCE(4534);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3063);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3063:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(3077);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3063);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3064:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'x') ADVANCE(3008);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3065);
      END_STATE();
    case 3065:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == ':') ADVANCE(3048);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3065);
      END_STATE();
    case 3066:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == ':') ADVANCE(3048);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3066);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3067:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == 'x') ADVANCE(3008);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3069);
      END_STATE();
    case 3068:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == 'x') ADVANCE(4534);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3070);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3069:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3069);
      END_STATE();
    case 3070:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3070);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3071:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (lookahead == ':') ADVANCE(3048);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(3071);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3072:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(3072);
      END_STATE();
    case 3073:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(3073);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3074:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3074);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3075:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == ':') ADVANCE(3048);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3075);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3076:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3007);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3076);
      END_STATE();
    case 3077:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3809);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3077);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3078:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3078);
      END_STATE();
    case 3079:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3079);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3080:
      ACCEPT_TOKEN(sym_cstring);
      END_STATE();
    case 3081:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 3082:
      ACCEPT_TOKEN(anon_sym_triple);
      END_STATE();
    case 3083:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 3084:
      ACCEPT_TOKEN(anon_sym_datalayout);
      END_STATE();
    case 3085:
      ACCEPT_TOKEN(anon_sym_source_filename);
      END_STATE();
    case 3086:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 3087:
      ACCEPT_TOKEN(anon_sym_define);
      END_STATE();
    case 3088:
      ACCEPT_TOKEN(anon_sym_no_cfi);
      END_STATE();
    case 3089:
      ACCEPT_TOKEN(anon_sym_no_cfi);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3090:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 3091:
      ACCEPT_TOKEN(anon_sym_private);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3092:
      ACCEPT_TOKEN(anon_sym_private);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3093:
      ACCEPT_TOKEN(anon_sym_internal);
      END_STATE();
    case 3094:
      ACCEPT_TOKEN(anon_sym_internal);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3095:
      ACCEPT_TOKEN(anon_sym_internal);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3096:
      ACCEPT_TOKEN(anon_sym_weak);
      END_STATE();
    case 3097:
      ACCEPT_TOKEN(anon_sym_weak);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(918);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3098:
      ACCEPT_TOKEN(anon_sym_weak);
      if (lookahead == '_') ADVANCE(4302);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3099:
      ACCEPT_TOKEN(anon_sym_weak);
      if (lookahead == '_') ADVANCE(2525);
      END_STATE();
    case 3100:
      ACCEPT_TOKEN(anon_sym_weak_odr);
      END_STATE();
    case 3101:
      ACCEPT_TOKEN(anon_sym_weak_odr);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3102:
      ACCEPT_TOKEN(anon_sym_weak_odr);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3103:
      ACCEPT_TOKEN(anon_sym_linkonce);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(939);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3104:
      ACCEPT_TOKEN(anon_sym_linkonce);
      if (lookahead == '_') ADVANCE(4319);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3105:
      ACCEPT_TOKEN(anon_sym_linkonce);
      if (lookahead == '_') ADVANCE(2554);
      END_STATE();
    case 3106:
      ACCEPT_TOKEN(anon_sym_linkonce_odr);
      END_STATE();
    case 3107:
      ACCEPT_TOKEN(anon_sym_linkonce_odr);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3108:
      ACCEPT_TOKEN(anon_sym_linkonce_odr);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3109:
      ACCEPT_TOKEN(anon_sym_available_externally);
      END_STATE();
    case 3110:
      ACCEPT_TOKEN(anon_sym_available_externally);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3111:
      ACCEPT_TOKEN(anon_sym_available_externally);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3112:
      ACCEPT_TOKEN(anon_sym_appending);
      END_STATE();
    case 3113:
      ACCEPT_TOKEN(anon_sym_appending);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3114:
      ACCEPT_TOKEN(anon_sym_appending);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3115:
      ACCEPT_TOKEN(anon_sym_common);
      END_STATE();
    case 3116:
      ACCEPT_TOKEN(anon_sym_common);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3117:
      ACCEPT_TOKEN(anon_sym_common);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3118:
      ACCEPT_TOKEN(anon_sym_extern_weak);
      END_STATE();
    case 3119:
      ACCEPT_TOKEN(anon_sym_extern_weak);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3120:
      ACCEPT_TOKEN(anon_sym_extern_weak);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3121:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 3122:
      ACCEPT_TOKEN(anon_sym_external);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3123:
      ACCEPT_TOKEN(anon_sym_external);
      if (lookahead == 'l') ADVANCE(2985);
      END_STATE();
    case 3124:
      ACCEPT_TOKEN(anon_sym_external);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3125:
      ACCEPT_TOKEN(anon_sym_dso_local);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(514);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3126:
      ACCEPT_TOKEN(anon_sym_dso_local);
      if (lookahead == '_') ADVANCE(1959);
      END_STATE();
    case 3127:
      ACCEPT_TOKEN(anon_sym_dso_local_equivalent);
      END_STATE();
    case 3128:
      ACCEPT_TOKEN(anon_sym_dso_local_equivalent);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3129:
      ACCEPT_TOKEN(anon_sym_dso_preemptable);
      END_STATE();
    case 3130:
      ACCEPT_TOKEN(anon_sym_dso_preemptable);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3131:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 3132:
      ACCEPT_TOKEN(anon_sym_default);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3133:
      ACCEPT_TOKEN(anon_sym_hidden);
      END_STATE();
    case 3134:
      ACCEPT_TOKEN(anon_sym_hidden);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3135:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 3136:
      ACCEPT_TOKEN(anon_sym_protected);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3137:
      ACCEPT_TOKEN(anon_sym_dllimport);
      END_STATE();
    case 3138:
      ACCEPT_TOKEN(anon_sym_dllimport);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3139:
      ACCEPT_TOKEN(anon_sym_dllexport);
      END_STATE();
    case 3140:
      ACCEPT_TOKEN(anon_sym_dllexport);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3141:
      ACCEPT_TOKEN(anon_sym_ccc);
      END_STATE();
    case 3142:
      ACCEPT_TOKEN(anon_sym_fastcc);
      END_STATE();
    case 3143:
      ACCEPT_TOKEN(anon_sym_coldcc);
      END_STATE();
    case 3144:
      ACCEPT_TOKEN(anon_sym_webkit_jscc);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3172);
      END_STATE();
    case 3145:
      ACCEPT_TOKEN(anon_sym_anyregcc);
      END_STATE();
    case 3146:
      ACCEPT_TOKEN(anon_sym_preserve_mostcc);
      END_STATE();
    case 3147:
      ACCEPT_TOKEN(anon_sym_preserve_allcc);
      END_STATE();
    case 3148:
      ACCEPT_TOKEN(anon_sym_cxx_fast_tlscc);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3202);
      END_STATE();
    case 3149:
      ACCEPT_TOKEN(anon_sym_tailcc);
      END_STATE();
    case 3150:
      ACCEPT_TOKEN(anon_sym_swiftcc);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3151:
      ACCEPT_TOKEN(anon_sym_swifttailcc);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3152:
      ACCEPT_TOKEN(anon_sym_cfguard_checkcc);
      END_STATE();
    case 3153:
      ACCEPT_TOKEN(aux_sym_calling_conv_token1);
      if (lookahead == '0') ADVANCE(3225);
      if (('1' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3160);
      END_STATE();
    case 3154:
      ACCEPT_TOKEN(aux_sym_calling_conv_token1);
      if (lookahead == '8') ADVANCE(3153);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3160);
      END_STATE();
    case 3155:
      ACCEPT_TOKEN(aux_sym_calling_conv_token1);
      if (lookahead == 'm') ADVANCE(3158);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3160);
      END_STATE();
    case 3156:
      ACCEPT_TOKEN(aux_sym_calling_conv_token1);
      if (lookahead == 'm') ADVANCE(3159);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3160);
      END_STATE();
    case 3157:
      ACCEPT_TOKEN(aux_sym_calling_conv_token1);
      if (lookahead == 'p') ADVANCE(3154);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3160);
      END_STATE();
    case 3158:
      ACCEPT_TOKEN(aux_sym_calling_conv_token1);
      if (lookahead == 'x') ADVANCE(3245);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3160);
      END_STATE();
    case 3159:
      ACCEPT_TOKEN(aux_sym_calling_conv_token1);
      if (lookahead == 'x') ADVANCE(3241);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3160);
      END_STATE();
    case 3160:
      ACCEPT_TOKEN(aux_sym_calling_conv_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3160);
      END_STATE();
    case 3161:
      ACCEPT_TOKEN(aux_sym_calling_conv_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3161);
      END_STATE();
    case 3162:
      ACCEPT_TOKEN(aux_sym_calling_conv_token3);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3162);
      END_STATE();
    case 3163:
      ACCEPT_TOKEN(aux_sym_calling_conv_token4);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3163);
      END_STATE();
    case 3164:
      ACCEPT_TOKEN(aux_sym_calling_conv_token5);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3164);
      END_STATE();
    case 3165:
      ACCEPT_TOKEN(aux_sym_calling_conv_token6);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3165);
      END_STATE();
    case 3166:
      ACCEPT_TOKEN(aux_sym_calling_conv_token7);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3166);
      END_STATE();
    case 3167:
      ACCEPT_TOKEN(aux_sym_calling_conv_token8);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3167);
      END_STATE();
    case 3168:
      ACCEPT_TOKEN(aux_sym_calling_conv_token9);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3168);
      END_STATE();
    case 3169:
      ACCEPT_TOKEN(aux_sym_calling_conv_token10);
      if (lookahead == 'c') ADVANCE(3144);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3172);
      END_STATE();
    case 3170:
      ACCEPT_TOKEN(aux_sym_calling_conv_token10);
      if (lookahead == 'c') ADVANCE(3169);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3172);
      END_STATE();
    case 3171:
      ACCEPT_TOKEN(aux_sym_calling_conv_token10);
      if (lookahead == 's') ADVANCE(3170);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3172);
      END_STATE();
    case 3172:
      ACCEPT_TOKEN(aux_sym_calling_conv_token10);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3172);
      END_STATE();
    case 3173:
      ACCEPT_TOKEN(anon_sym_ghccc);
      END_STATE();
    case 3174:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'a') ADVANCE(3181);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3175:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'c') ADVANCE(3150);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3176:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'c') ADVANCE(3525);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3177:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'c') ADVANCE(3151);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3178:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'c') ADVANCE(3177);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3179:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'e') ADVANCE(3182);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3180:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'f') ADVANCE(3521);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3181:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'i') ADVANCE(3183);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3182:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'l') ADVANCE(3180);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3183:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'l') ADVANCE(3178);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3184:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'n') ADVANCE(3176);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3185:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'o') ADVANCE(3187);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3186:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'r') ADVANCE(3185);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3187:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'r') ADVANCE(3529);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3188:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'r') ADVANCE(3186);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3189:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 's') ADVANCE(3190);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3190:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (lookahead == 'y') ADVANCE(3184);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3191:
      ACCEPT_TOKEN(aux_sym_calling_conv_token11);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3192:
      ACCEPT_TOKEN(aux_sym_calling_conv_token12);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3192);
      END_STATE();
    case 3193:
      ACCEPT_TOKEN(aux_sym_calling_conv_token13);
      if (lookahead == '_') ADVANCE(3201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3202);
      END_STATE();
    case 3194:
      ACCEPT_TOKEN(aux_sym_calling_conv_token13);
      if (lookahead == 'a') ADVANCE(3198);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(3202);
      END_STATE();
    case 3195:
      ACCEPT_TOKEN(aux_sym_calling_conv_token13);
      if (lookahead == 'c') ADVANCE(3148);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3202);
      END_STATE();
    case 3196:
      ACCEPT_TOKEN(aux_sym_calling_conv_token13);
      if (lookahead == 'c') ADVANCE(3195);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3202);
      END_STATE();
    case 3197:
      ACCEPT_TOKEN(aux_sym_calling_conv_token13);
      if (lookahead == 'l') ADVANCE(3199);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3202);
      END_STATE();
    case 3198:
      ACCEPT_TOKEN(aux_sym_calling_conv_token13);
      if (lookahead == 's') ADVANCE(3200);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3202);
      END_STATE();
    case 3199:
      ACCEPT_TOKEN(aux_sym_calling_conv_token13);
      if (lookahead == 's') ADVANCE(3196);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3202);
      END_STATE();
    case 3200:
      ACCEPT_TOKEN(aux_sym_calling_conv_token13);
      if (lookahead == 't') ADVANCE(3193);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3202);
      END_STATE();
    case 3201:
      ACCEPT_TOKEN(aux_sym_calling_conv_token13);
      if (lookahead == 't') ADVANCE(3197);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3202);
      END_STATE();
    case 3202:
      ACCEPT_TOKEN(aux_sym_calling_conv_token13);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3202);
      END_STATE();
    case 3203:
      ACCEPT_TOKEN(aux_sym_calling_conv_token14);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3203);
      END_STATE();
    case 3204:
      ACCEPT_TOKEN(anon_sym_cc);
      if (lookahead == 'c') ADVANCE(3141);
      END_STATE();
    case 3205:
      ACCEPT_TOKEN(anon_sym_unnamed_addr);
      END_STATE();
    case 3206:
      ACCEPT_TOKEN(anon_sym_local_unnamed_addr);
      END_STATE();
    case 3207:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 3208:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 3209:
      ACCEPT_TOKEN(anon_sym_void);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3210:
      ACCEPT_TOKEN(anon_sym_void);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3211:
      ACCEPT_TOKEN(anon_sym_half);
      END_STATE();
    case 3212:
      ACCEPT_TOKEN(anon_sym_half);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3213:
      ACCEPT_TOKEN(anon_sym_half);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3214:
      ACCEPT_TOKEN(anon_sym_bfloat);
      END_STATE();
    case 3215:
      ACCEPT_TOKEN(anon_sym_bfloat);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3216:
      ACCEPT_TOKEN(anon_sym_bfloat);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3217:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 3218:
      ACCEPT_TOKEN(anon_sym_float);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3219:
      ACCEPT_TOKEN(anon_sym_float);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3220:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 3221:
      ACCEPT_TOKEN(anon_sym_double);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3222:
      ACCEPT_TOKEN(anon_sym_double);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3223:
      ACCEPT_TOKEN(anon_sym_x86_fp80);
      END_STATE();
    case 3224:
      ACCEPT_TOKEN(anon_sym_x86_fp80);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3225:
      ACCEPT_TOKEN(anon_sym_x86_fp80);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3160);
      END_STATE();
    case 3226:
      ACCEPT_TOKEN(anon_sym_x86_fp80);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3227:
      ACCEPT_TOKEN(anon_sym_fp128);
      END_STATE();
    case 3228:
      ACCEPT_TOKEN(anon_sym_fp128);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3229:
      ACCEPT_TOKEN(anon_sym_fp128);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3230:
      ACCEPT_TOKEN(anon_sym_ppc_fp128);
      END_STATE();
    case 3231:
      ACCEPT_TOKEN(anon_sym_ppc_fp128);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3232:
      ACCEPT_TOKEN(anon_sym_ppc_fp128);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3233:
      ACCEPT_TOKEN(anon_sym_label);
      END_STATE();
    case 3234:
      ACCEPT_TOKEN(anon_sym_label);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3235:
      ACCEPT_TOKEN(anon_sym_label);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3236:
      ACCEPT_TOKEN(anon_sym_metadata);
      END_STATE();
    case 3237:
      ACCEPT_TOKEN(anon_sym_metadata);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3238:
      ACCEPT_TOKEN(anon_sym_metadata);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3239:
      ACCEPT_TOKEN(anon_sym_x86_mmx);
      END_STATE();
    case 3240:
      ACCEPT_TOKEN(anon_sym_x86_mmx);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3241:
      ACCEPT_TOKEN(anon_sym_x86_mmx);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3160);
      END_STATE();
    case 3242:
      ACCEPT_TOKEN(anon_sym_x86_mmx);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3243:
      ACCEPT_TOKEN(anon_sym_x86_amx);
      END_STATE();
    case 3244:
      ACCEPT_TOKEN(anon_sym_x86_amx);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3245:
      ACCEPT_TOKEN(anon_sym_x86_amx);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3160);
      END_STATE();
    case 3246:
      ACCEPT_TOKEN(anon_sym_x86_amx);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3247:
      ACCEPT_TOKEN(anon_sym_token);
      END_STATE();
    case 3248:
      ACCEPT_TOKEN(anon_sym_token);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3249:
      ACCEPT_TOKEN(anon_sym_token);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3250:
      ACCEPT_TOKEN(anon_sym_opaque);
      END_STATE();
    case 3251:
      ACCEPT_TOKEN(anon_sym_opaque);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3252:
      ACCEPT_TOKEN(anon_sym_opaque);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3253:
      ACCEPT_TOKEN(anon_sym_ptr);
      END_STATE();
    case 3254:
      ACCEPT_TOKEN(anon_sym_ptr);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 't') ADVANCE(950);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3255:
      ACCEPT_TOKEN(anon_sym_ptr);
      if (lookahead == 't') ADVANCE(2567);
      END_STATE();
    case 3256:
      ACCEPT_TOKEN(anon_sym_ptr);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3257:
      ACCEPT_TOKEN(aux_sym_type_keyword_token1);
      if (lookahead == ':') ADVANCE(3048);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3257);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3258:
      ACCEPT_TOKEN(aux_sym_type_keyword_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3258);
      END_STATE();
    case 3259:
      ACCEPT_TOKEN(aux_sym_type_keyword_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3259);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3260:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 3261:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 3262:
      ACCEPT_TOKEN(anon_sym_LT_LBRACE);
      END_STATE();
    case 3263:
      ACCEPT_TOKEN(anon_sym_RBRACE_GT);
      END_STATE();
    case 3264:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 3265:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 3266:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 3267:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '{') ADVANCE(3262);
      END_STATE();
    case 3268:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 3269:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 3270:
      ACCEPT_TOKEN(anon_sym_vscale);
      END_STATE();
    case 3271:
      ACCEPT_TOKEN(anon_sym_vscale);
      if (lookahead == '_') ADVANCE(2707);
      END_STATE();
    case 3272:
      ACCEPT_TOKEN(anon_sym_x);
      END_STATE();
    case 3273:
      ACCEPT_TOKEN(anon_sym_x);
      if (lookahead == 'c') ADVANCE(2092);
      END_STATE();
    case 3274:
      ACCEPT_TOKEN(anon_sym_addrspace);
      END_STATE();
    case 3275:
      ACCEPT_TOKEN(anon_sym_addrspace);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'c') ADVANCE(235);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3276:
      ACCEPT_TOKEN(anon_sym_addrspace);
      if (lookahead == 'c') ADVANCE(1494);
      END_STATE();
    case 3277:
      ACCEPT_TOKEN(anon_sym_addrspace);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3278:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 3279:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 3280:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 3281:
      ACCEPT_TOKEN(anon_sym_align);
      END_STATE();
    case 3282:
      ACCEPT_TOKEN(anon_sym_align);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 's') ADVANCE(1193);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3283:
      ACCEPT_TOKEN(anon_sym_align);
      if (lookahead == 's') ADVANCE(4452);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3284:
      ACCEPT_TOKEN(anon_sym_align);
      if (lookahead == 's') ADVANCE(2868);
      END_STATE();
    case 3285:
      ACCEPT_TOKEN(anon_sym_section);
      END_STATE();
    case 3286:
      ACCEPT_TOKEN(anon_sym_section);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3287:
      ACCEPT_TOKEN(anon_sym_partition);
      END_STATE();
    case 3288:
      ACCEPT_TOKEN(anon_sym_partition);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3289:
      ACCEPT_TOKEN(anon_sym_comdat);
      END_STATE();
    case 3290:
      ACCEPT_TOKEN(anon_sym_comdat);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3291:
      ACCEPT_TOKEN(anon_sym_gc);
      END_STATE();
    case 3292:
      ACCEPT_TOKEN(anon_sym_gc);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3293:
      ACCEPT_TOKEN(anon_sym_prefix);
      END_STATE();
    case 3294:
      ACCEPT_TOKEN(anon_sym_prefix);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3295:
      ACCEPT_TOKEN(anon_sym_prologue);
      END_STATE();
    case 3296:
      ACCEPT_TOKEN(anon_sym_prologue);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3297:
      ACCEPT_TOKEN(anon_sym_personality);
      END_STATE();
    case 3298:
      ACCEPT_TOKEN(anon_sym_personality);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3299:
      ACCEPT_TOKEN(anon_sym_alignstack);
      END_STATE();
    case 3300:
      ACCEPT_TOKEN(anon_sym_alignstack);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3301:
      ACCEPT_TOKEN(anon_sym_alignstack);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3302:
      ACCEPT_TOKEN(anon_sym_allocsize);
      END_STATE();
    case 3303:
      ACCEPT_TOKEN(anon_sym_allocsize);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3304:
      ACCEPT_TOKEN(anon_sym_allocsize);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3305:
      ACCEPT_TOKEN(anon_sym_alwaysinline);
      END_STATE();
    case 3306:
      ACCEPT_TOKEN(anon_sym_alwaysinline);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3307:
      ACCEPT_TOKEN(anon_sym_alwaysinline);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3308:
      ACCEPT_TOKEN(anon_sym_builtin);
      END_STATE();
    case 3309:
      ACCEPT_TOKEN(anon_sym_builtin);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3310:
      ACCEPT_TOKEN(anon_sym_builtin);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3311:
      ACCEPT_TOKEN(anon_sym_cold);
      END_STATE();
    case 3312:
      ACCEPT_TOKEN(anon_sym_cold);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3313:
      ACCEPT_TOKEN(anon_sym_cold);
      if (lookahead == 'c') ADVANCE(1583);
      END_STATE();
    case 3314:
      ACCEPT_TOKEN(anon_sym_cold);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3315:
      ACCEPT_TOKEN(anon_sym_convergent);
      END_STATE();
    case 3316:
      ACCEPT_TOKEN(anon_sym_convergent);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3317:
      ACCEPT_TOKEN(anon_sym_convergent);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3318:
      ACCEPT_TOKEN(anon_sym_disable_sanitizer_instrumentation);
      END_STATE();
    case 3319:
      ACCEPT_TOKEN(anon_sym_disable_sanitizer_instrumentation);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3320:
      ACCEPT_TOKEN(anon_sym_disable_sanitizer_instrumentation);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3321:
      ACCEPT_TOKEN(anon_sym_hot);
      END_STATE();
    case 3322:
      ACCEPT_TOKEN(anon_sym_hot);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3323:
      ACCEPT_TOKEN(anon_sym_hot);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3324:
      ACCEPT_TOKEN(anon_sym_inaccessiblememonly);
      END_STATE();
    case 3325:
      ACCEPT_TOKEN(anon_sym_inaccessiblememonly);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3326:
      ACCEPT_TOKEN(anon_sym_inaccessiblememonly);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3327:
      ACCEPT_TOKEN(anon_sym_inaccessiblemem_or_argmemonly);
      END_STATE();
    case 3328:
      ACCEPT_TOKEN(anon_sym_inaccessiblemem_or_argmemonly);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3329:
      ACCEPT_TOKEN(anon_sym_inaccessiblemem_or_argmemonly);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3330:
      ACCEPT_TOKEN(anon_sym_inlinehint);
      END_STATE();
    case 3331:
      ACCEPT_TOKEN(anon_sym_inlinehint);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3332:
      ACCEPT_TOKEN(anon_sym_inlinehint);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3333:
      ACCEPT_TOKEN(anon_sym_jumptable);
      END_STATE();
    case 3334:
      ACCEPT_TOKEN(anon_sym_jumptable);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3335:
      ACCEPT_TOKEN(anon_sym_jumptable);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3336:
      ACCEPT_TOKEN(anon_sym_minsize);
      END_STATE();
    case 3337:
      ACCEPT_TOKEN(anon_sym_minsize);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3338:
      ACCEPT_TOKEN(anon_sym_minsize);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3339:
      ACCEPT_TOKEN(anon_sym_naked);
      END_STATE();
    case 3340:
      ACCEPT_TOKEN(anon_sym_naked);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3341:
      ACCEPT_TOKEN(anon_sym_naked);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3342:
      ACCEPT_TOKEN(anon_sym_no_DASHjump_DASHtables);
      END_STATE();
    case 3343:
      ACCEPT_TOKEN(anon_sym_no_DASHjump_DASHtables);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3344:
      ACCEPT_TOKEN(anon_sym_no_DASHjump_DASHtables);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3345:
      ACCEPT_TOKEN(anon_sym_nobuiltin);
      END_STATE();
    case 3346:
      ACCEPT_TOKEN(anon_sym_nobuiltin);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3347:
      ACCEPT_TOKEN(anon_sym_nobuiltin);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3348:
      ACCEPT_TOKEN(anon_sym_noduplicate);
      END_STATE();
    case 3349:
      ACCEPT_TOKEN(anon_sym_noduplicate);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3350:
      ACCEPT_TOKEN(anon_sym_noduplicate);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3351:
      ACCEPT_TOKEN(anon_sym_nofree);
      END_STATE();
    case 3352:
      ACCEPT_TOKEN(anon_sym_nofree);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3353:
      ACCEPT_TOKEN(anon_sym_nofree);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3354:
      ACCEPT_TOKEN(anon_sym_noimplicitfloat);
      END_STATE();
    case 3355:
      ACCEPT_TOKEN(anon_sym_noimplicitfloat);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3356:
      ACCEPT_TOKEN(anon_sym_noimplicitfloat);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3357:
      ACCEPT_TOKEN(anon_sym_noinline);
      END_STATE();
    case 3358:
      ACCEPT_TOKEN(anon_sym_noinline);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3359:
      ACCEPT_TOKEN(anon_sym_noinline);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3360:
      ACCEPT_TOKEN(anon_sym_nomerge);
      END_STATE();
    case 3361:
      ACCEPT_TOKEN(anon_sym_nomerge);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3362:
      ACCEPT_TOKEN(anon_sym_nomerge);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3363:
      ACCEPT_TOKEN(anon_sym_nonlazybind);
      END_STATE();
    case 3364:
      ACCEPT_TOKEN(anon_sym_nonlazybind);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3365:
      ACCEPT_TOKEN(anon_sym_nonlazybind);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3366:
      ACCEPT_TOKEN(anon_sym_noprofile);
      END_STATE();
    case 3367:
      ACCEPT_TOKEN(anon_sym_noprofile);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3368:
      ACCEPT_TOKEN(anon_sym_noprofile);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3369:
      ACCEPT_TOKEN(anon_sym_noredzone);
      END_STATE();
    case 3370:
      ACCEPT_TOKEN(anon_sym_noredzone);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3371:
      ACCEPT_TOKEN(anon_sym_noredzone);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3372:
      ACCEPT_TOKEN(anon_sym_indirect_DASHtls_DASHseg_DASHrefs);
      END_STATE();
    case 3373:
      ACCEPT_TOKEN(anon_sym_indirect_DASHtls_DASHseg_DASHrefs);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3374:
      ACCEPT_TOKEN(anon_sym_indirect_DASHtls_DASHseg_DASHrefs);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3375:
      ACCEPT_TOKEN(anon_sym_noreturn);
      END_STATE();
    case 3376:
      ACCEPT_TOKEN(anon_sym_noreturn);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3377:
      ACCEPT_TOKEN(anon_sym_noreturn);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3378:
      ACCEPT_TOKEN(anon_sym_norecurse);
      END_STATE();
    case 3379:
      ACCEPT_TOKEN(anon_sym_norecurse);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3380:
      ACCEPT_TOKEN(anon_sym_norecurse);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3381:
      ACCEPT_TOKEN(anon_sym_willreturn);
      END_STATE();
    case 3382:
      ACCEPT_TOKEN(anon_sym_willreturn);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3383:
      ACCEPT_TOKEN(anon_sym_willreturn);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3384:
      ACCEPT_TOKEN(anon_sym_nosync);
      END_STATE();
    case 3385:
      ACCEPT_TOKEN(anon_sym_nosync);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3386:
      ACCEPT_TOKEN(anon_sym_nosync);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3387:
      ACCEPT_TOKEN(anon_sym_nounwind);
      END_STATE();
    case 3388:
      ACCEPT_TOKEN(anon_sym_nounwind);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3389:
      ACCEPT_TOKEN(anon_sym_nounwind);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3390:
      ACCEPT_TOKEN(anon_sym_nosanitize_coverage);
      END_STATE();
    case 3391:
      ACCEPT_TOKEN(anon_sym_nosanitize_coverage);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3392:
      ACCEPT_TOKEN(anon_sym_nosanitize_coverage);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3393:
      ACCEPT_TOKEN(anon_sym_null_pointer_is_valid);
      END_STATE();
    case 3394:
      ACCEPT_TOKEN(anon_sym_null_pointer_is_valid);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3395:
      ACCEPT_TOKEN(anon_sym_null_pointer_is_valid);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3396:
      ACCEPT_TOKEN(anon_sym_optforfuzzing);
      END_STATE();
    case 3397:
      ACCEPT_TOKEN(anon_sym_optforfuzzing);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3398:
      ACCEPT_TOKEN(anon_sym_optforfuzzing);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3399:
      ACCEPT_TOKEN(anon_sym_optnone);
      END_STATE();
    case 3400:
      ACCEPT_TOKEN(anon_sym_optnone);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3401:
      ACCEPT_TOKEN(anon_sym_optnone);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3402:
      ACCEPT_TOKEN(anon_sym_optsize);
      END_STATE();
    case 3403:
      ACCEPT_TOKEN(anon_sym_optsize);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3404:
      ACCEPT_TOKEN(anon_sym_optsize);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3405:
      ACCEPT_TOKEN(anon_sym_readnone);
      END_STATE();
    case 3406:
      ACCEPT_TOKEN(anon_sym_readnone);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3407:
      ACCEPT_TOKEN(anon_sym_readnone);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3408:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 3409:
      ACCEPT_TOKEN(anon_sym_readonly);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3410:
      ACCEPT_TOKEN(anon_sym_readonly);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3411:
      ACCEPT_TOKEN(anon_sym_writeonly);
      END_STATE();
    case 3412:
      ACCEPT_TOKEN(anon_sym_writeonly);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3413:
      ACCEPT_TOKEN(anon_sym_writeonly);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3414:
      ACCEPT_TOKEN(anon_sym_argmemonly);
      END_STATE();
    case 3415:
      ACCEPT_TOKEN(anon_sym_argmemonly);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3416:
      ACCEPT_TOKEN(anon_sym_argmemonly);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3417:
      ACCEPT_TOKEN(anon_sym_returns_twice);
      END_STATE();
    case 3418:
      ACCEPT_TOKEN(anon_sym_returns_twice);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3419:
      ACCEPT_TOKEN(anon_sym_returns_twice);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3420:
      ACCEPT_TOKEN(anon_sym_safestack);
      END_STATE();
    case 3421:
      ACCEPT_TOKEN(anon_sym_safestack);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3422:
      ACCEPT_TOKEN(anon_sym_safestack);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3423:
      ACCEPT_TOKEN(anon_sym_sanitize_address);
      END_STATE();
    case 3424:
      ACCEPT_TOKEN(anon_sym_sanitize_address);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3425:
      ACCEPT_TOKEN(anon_sym_sanitize_address);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3426:
      ACCEPT_TOKEN(anon_sym_sanitize_memory);
      END_STATE();
    case 3427:
      ACCEPT_TOKEN(anon_sym_sanitize_memory);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3428:
      ACCEPT_TOKEN(anon_sym_sanitize_memory);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3429:
      ACCEPT_TOKEN(anon_sym_sanitize_thread);
      END_STATE();
    case 3430:
      ACCEPT_TOKEN(anon_sym_sanitize_thread);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3431:
      ACCEPT_TOKEN(anon_sym_sanitize_thread);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3432:
      ACCEPT_TOKEN(anon_sym_sanitize_hwaddress);
      END_STATE();
    case 3433:
      ACCEPT_TOKEN(anon_sym_sanitize_hwaddress);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3434:
      ACCEPT_TOKEN(anon_sym_sanitize_hwaddress);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3435:
      ACCEPT_TOKEN(anon_sym_sanitize_memtag);
      END_STATE();
    case 3436:
      ACCEPT_TOKEN(anon_sym_sanitize_memtag);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3437:
      ACCEPT_TOKEN(anon_sym_sanitize_memtag);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3438:
      ACCEPT_TOKEN(anon_sym_speculative_load_hardening);
      END_STATE();
    case 3439:
      ACCEPT_TOKEN(anon_sym_speculative_load_hardening);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3440:
      ACCEPT_TOKEN(anon_sym_speculative_load_hardening);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3441:
      ACCEPT_TOKEN(anon_sym_speculatable);
      END_STATE();
    case 3442:
      ACCEPT_TOKEN(anon_sym_speculatable);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3443:
      ACCEPT_TOKEN(anon_sym_speculatable);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3444:
      ACCEPT_TOKEN(anon_sym_ssp);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'r') ADVANCE(446);
      if (lookahead == 's') ADVANCE(1157);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3445:
      ACCEPT_TOKEN(anon_sym_ssp);
      if (lookahead == 'r') ADVANCE(3972);
      if (lookahead == 's') ADVANCE(4450);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3446:
      ACCEPT_TOKEN(anon_sym_ssp);
      if (lookahead == 'r') ADVANCE(1869);
      if (lookahead == 's') ADVANCE(2871);
      END_STATE();
    case 3447:
      ACCEPT_TOKEN(anon_sym_sspstrong);
      END_STATE();
    case 3448:
      ACCEPT_TOKEN(anon_sym_sspstrong);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3449:
      ACCEPT_TOKEN(anon_sym_sspstrong);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3450:
      ACCEPT_TOKEN(anon_sym_sspreq);
      END_STATE();
    case 3451:
      ACCEPT_TOKEN(anon_sym_sspreq);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3452:
      ACCEPT_TOKEN(anon_sym_sspreq);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3453:
      ACCEPT_TOKEN(anon_sym_strictfp);
      END_STATE();
    case 3454:
      ACCEPT_TOKEN(anon_sym_strictfp);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3455:
      ACCEPT_TOKEN(anon_sym_strictfp);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3456:
      ACCEPT_TOKEN(anon_sym_uwtable);
      END_STATE();
    case 3457:
      ACCEPT_TOKEN(anon_sym_uwtable);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3458:
      ACCEPT_TOKEN(anon_sym_uwtable);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3459:
      ACCEPT_TOKEN(anon_sym_nocf_check);
      END_STATE();
    case 3460:
      ACCEPT_TOKEN(anon_sym_nocf_check);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3461:
      ACCEPT_TOKEN(anon_sym_nocf_check);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3462:
      ACCEPT_TOKEN(anon_sym_shadowcallstack);
      END_STATE();
    case 3463:
      ACCEPT_TOKEN(anon_sym_shadowcallstack);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3464:
      ACCEPT_TOKEN(anon_sym_shadowcallstack);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3465:
      ACCEPT_TOKEN(anon_sym_mustprogress);
      END_STATE();
    case 3466:
      ACCEPT_TOKEN(anon_sym_mustprogress);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3467:
      ACCEPT_TOKEN(anon_sym_mustprogress);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3468:
      ACCEPT_TOKEN(anon_sym_vscale_range);
      END_STATE();
    case 3469:
      ACCEPT_TOKEN(anon_sym_vscale_range);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3470:
      ACCEPT_TOKEN(anon_sym_vscale_range);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3471:
      ACCEPT_TOKEN(anon_sym_preallocated);
      END_STATE();
    case 3472:
      ACCEPT_TOKEN(anon_sym_preallocated);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3473:
      ACCEPT_TOKEN(anon_sym_preallocated);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3474:
      ACCEPT_TOKEN(anon_sym_zeroext);
      END_STATE();
    case 3475:
      ACCEPT_TOKEN(anon_sym_zeroext);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3476:
      ACCEPT_TOKEN(anon_sym_zeroext);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3477:
      ACCEPT_TOKEN(anon_sym_signext);
      END_STATE();
    case 3478:
      ACCEPT_TOKEN(anon_sym_signext);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3479:
      ACCEPT_TOKEN(anon_sym_signext);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3480:
      ACCEPT_TOKEN(anon_sym_inreg);
      END_STATE();
    case 3481:
      ACCEPT_TOKEN(anon_sym_inreg);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3482:
      ACCEPT_TOKEN(anon_sym_inreg);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3483:
      ACCEPT_TOKEN(anon_sym_byval);
      END_STATE();
    case 3484:
      ACCEPT_TOKEN(anon_sym_byval);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3485:
      ACCEPT_TOKEN(anon_sym_byval);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3486:
      ACCEPT_TOKEN(anon_sym_byref);
      END_STATE();
    case 3487:
      ACCEPT_TOKEN(anon_sym_byref);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3488:
      ACCEPT_TOKEN(anon_sym_byref);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3489:
      ACCEPT_TOKEN(anon_sym_inalloca);
      END_STATE();
    case 3490:
      ACCEPT_TOKEN(anon_sym_inalloca);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3491:
      ACCEPT_TOKEN(anon_sym_inalloca);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3492:
      ACCEPT_TOKEN(anon_sym_sret);
      END_STATE();
    case 3493:
      ACCEPT_TOKEN(anon_sym_sret);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3494:
      ACCEPT_TOKEN(anon_sym_sret);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3495:
      ACCEPT_TOKEN(anon_sym_elementtype);
      END_STATE();
    case 3496:
      ACCEPT_TOKEN(anon_sym_elementtype);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3497:
      ACCEPT_TOKEN(anon_sym_elementtype);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3498:
      ACCEPT_TOKEN(anon_sym_noalias);
      END_STATE();
    case 3499:
      ACCEPT_TOKEN(anon_sym_noalias);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3500:
      ACCEPT_TOKEN(anon_sym_noalias);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3501:
      ACCEPT_TOKEN(anon_sym_nocapture);
      END_STATE();
    case 3502:
      ACCEPT_TOKEN(anon_sym_nocapture);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3503:
      ACCEPT_TOKEN(anon_sym_nocapture);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3504:
      ACCEPT_TOKEN(anon_sym_nest);
      END_STATE();
    case 3505:
      ACCEPT_TOKEN(anon_sym_nest);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3506:
      ACCEPT_TOKEN(anon_sym_nest);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3507:
      ACCEPT_TOKEN(anon_sym_returned);
      END_STATE();
    case 3508:
      ACCEPT_TOKEN(anon_sym_returned);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3509:
      ACCEPT_TOKEN(anon_sym_returned);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3510:
      ACCEPT_TOKEN(anon_sym_nonnull);
      END_STATE();
    case 3511:
      ACCEPT_TOKEN(anon_sym_nonnull);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3512:
      ACCEPT_TOKEN(anon_sym_nonnull);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3513:
      ACCEPT_TOKEN(anon_sym_dereferenceable);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '_') ADVANCE(929);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3514:
      ACCEPT_TOKEN(anon_sym_dereferenceable);
      if (lookahead == '_') ADVANCE(4310);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3515:
      ACCEPT_TOKEN(anon_sym_dereferenceable);
      if (lookahead == '_') ADVANCE(2538);
      END_STATE();
    case 3516:
      ACCEPT_TOKEN(anon_sym_dereferenceable_or_null);
      END_STATE();
    case 3517:
      ACCEPT_TOKEN(anon_sym_dereferenceable_or_null);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3518:
      ACCEPT_TOKEN(anon_sym_dereferenceable_or_null);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3519:
      ACCEPT_TOKEN(anon_sym_swiftself);
      END_STATE();
    case 3520:
      ACCEPT_TOKEN(anon_sym_swiftself);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3521:
      ACCEPT_TOKEN(anon_sym_swiftself);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3522:
      ACCEPT_TOKEN(anon_sym_swiftself);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3523:
      ACCEPT_TOKEN(anon_sym_swiftasync);
      END_STATE();
    case 3524:
      ACCEPT_TOKEN(anon_sym_swiftasync);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3525:
      ACCEPT_TOKEN(anon_sym_swiftasync);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3526:
      ACCEPT_TOKEN(anon_sym_swiftasync);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3527:
      ACCEPT_TOKEN(anon_sym_swifterror);
      END_STATE();
    case 3528:
      ACCEPT_TOKEN(anon_sym_swifterror);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3529:
      ACCEPT_TOKEN(anon_sym_swifterror);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(3191);
      END_STATE();
    case 3530:
      ACCEPT_TOKEN(anon_sym_swifterror);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3531:
      ACCEPT_TOKEN(anon_sym_immarg);
      END_STATE();
    case 3532:
      ACCEPT_TOKEN(anon_sym_immarg);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3533:
      ACCEPT_TOKEN(anon_sym_immarg);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3534:
      ACCEPT_TOKEN(anon_sym_noundef);
      END_STATE();
    case 3535:
      ACCEPT_TOKEN(anon_sym_noundef);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3536:
      ACCEPT_TOKEN(anon_sym_noundef);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3537:
      ACCEPT_TOKEN(anon_sym_unreachable);
      END_STATE();
    case 3538:
      ACCEPT_TOKEN(anon_sym_unreachable);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3539:
      ACCEPT_TOKEN(anon_sym_ret);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'u') ADVANCE(1035);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3540:
      ACCEPT_TOKEN(anon_sym_ret);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3541:
      ACCEPT_TOKEN(anon_sym_ret);
      if (lookahead == 'u') ADVANCE(2679);
      END_STATE();
    case 3542:
      ACCEPT_TOKEN(anon_sym_br);
      END_STATE();
    case 3543:
      ACCEPT_TOKEN(anon_sym_br);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3544:
      ACCEPT_TOKEN(anon_sym_resume);
      END_STATE();
    case 3545:
      ACCEPT_TOKEN(anon_sym_resume);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3546:
      ACCEPT_TOKEN(anon_sym_freeze);
      END_STATE();
    case 3547:
      ACCEPT_TOKEN(anon_sym_freeze);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3548:
      ACCEPT_TOKEN(anon_sym_indirectbr);
      END_STATE();
    case 3549:
      ACCEPT_TOKEN(anon_sym_indirectbr);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3550:
      ACCEPT_TOKEN(anon_sym_extractelement);
      END_STATE();
    case 3551:
      ACCEPT_TOKEN(anon_sym_extractelement);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3552:
      ACCEPT_TOKEN(anon_sym_insertelement);
      END_STATE();
    case 3553:
      ACCEPT_TOKEN(anon_sym_insertelement);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3554:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 3555:
      ACCEPT_TOKEN(anon_sym_select);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3556:
      ACCEPT_TOKEN(anon_sym_shufflevector);
      END_STATE();
    case 3557:
      ACCEPT_TOKEN(anon_sym_shufflevector);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3558:
      ACCEPT_TOKEN(anon_sym_fneg);
      END_STATE();
    case 3559:
      ACCEPT_TOKEN(anon_sym_fneg);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3560:
      ACCEPT_TOKEN(anon_sym_nsw);
      END_STATE();
    case 3561:
      ACCEPT_TOKEN(anon_sym_nuw);
      END_STATE();
    case 3562:
      ACCEPT_TOKEN(anon_sym_exact);
      END_STATE();
    case 3563:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 3564:
      ACCEPT_TOKEN(anon_sym_switch);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3565:
      ACCEPT_TOKEN(anon_sym_invoke);
      END_STATE();
    case 3566:
      ACCEPT_TOKEN(anon_sym_invoke);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3567:
      ACCEPT_TOKEN(anon_sym_to);
      if (lookahead == 'k') ADVANCE(1900);
      END_STATE();
    case 3568:
      ACCEPT_TOKEN(anon_sym_unwind);
      END_STATE();
    case 3569:
      ACCEPT_TOKEN(anon_sym_cleanupret);
      END_STATE();
    case 3570:
      ACCEPT_TOKEN(anon_sym_cleanupret);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3571:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 3572:
      ACCEPT_TOKEN(anon_sym_catchret);
      END_STATE();
    case 3573:
      ACCEPT_TOKEN(anon_sym_catchret);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3574:
      ACCEPT_TOKEN(anon_sym_catchswitch);
      END_STATE();
    case 3575:
      ACCEPT_TOKEN(anon_sym_catchswitch);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3576:
      ACCEPT_TOKEN(anon_sym_catchpad);
      END_STATE();
    case 3577:
      ACCEPT_TOKEN(anon_sym_catchpad);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3578:
      ACCEPT_TOKEN(anon_sym_cleanuppad);
      END_STATE();
    case 3579:
      ACCEPT_TOKEN(anon_sym_cleanuppad);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3580:
      ACCEPT_TOKEN(anon_sym_callbr);
      END_STATE();
    case 3581:
      ACCEPT_TOKEN(anon_sym_callbr);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3582:
      ACCEPT_TOKEN(anon_sym_icmp);
      END_STATE();
    case 3583:
      ACCEPT_TOKEN(anon_sym_icmp);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3584:
      ACCEPT_TOKEN(anon_sym_fcmp);
      END_STATE();
    case 3585:
      ACCEPT_TOKEN(anon_sym_fcmp);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3586:
      ACCEPT_TOKEN(anon_sym_va_arg);
      END_STATE();
    case 3587:
      ACCEPT_TOKEN(anon_sym_va_arg);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3588:
      ACCEPT_TOKEN(anon_sym_phi);
      END_STATE();
    case 3589:
      ACCEPT_TOKEN(anon_sym_phi);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3590:
      ACCEPT_TOKEN(anon_sym_landingpad);
      END_STATE();
    case 3591:
      ACCEPT_TOKEN(anon_sym_landingpad);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3592:
      ACCEPT_TOKEN(anon_sym_cleanup);
      END_STATE();
    case 3593:
      ACCEPT_TOKEN(anon_sym_tail);
      END_STATE();
    case 3594:
      ACCEPT_TOKEN(anon_sym_tail);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3595:
      ACCEPT_TOKEN(anon_sym_musttail);
      END_STATE();
    case 3596:
      ACCEPT_TOKEN(anon_sym_musttail);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3597:
      ACCEPT_TOKEN(anon_sym_notail);
      END_STATE();
    case 3598:
      ACCEPT_TOKEN(anon_sym_notail);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3599:
      ACCEPT_TOKEN(anon_sym_call);
      END_STATE();
    case 3600:
      ACCEPT_TOKEN(anon_sym_call);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == 'b') ADVANCE(1005);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3601:
      ACCEPT_TOKEN(anon_sym_call);
      if (lookahead == 'b') ADVANCE(2638);
      END_STATE();
    case 3602:
      ACCEPT_TOKEN(anon_sym_alloca);
      END_STATE();
    case 3603:
      ACCEPT_TOKEN(anon_sym_alloca);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3604:
      ACCEPT_TOKEN(anon_sym_load);
      END_STATE();
    case 3605:
      ACCEPT_TOKEN(anon_sym_load);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3606:
      ACCEPT_TOKEN(anon_sym_atomic);
      END_STATE();
    case 3607:
      ACCEPT_TOKEN(anon_sym_atomic);
      if (lookahead == 'r') ADVANCE(2376);
      END_STATE();
    case 3608:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 3609:
      ACCEPT_TOKEN(anon_sym_store);
      END_STATE();
    case 3610:
      ACCEPT_TOKEN(anon_sym_store);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3611:
      ACCEPT_TOKEN(anon_sym_cmpxchg);
      END_STATE();
    case 3612:
      ACCEPT_TOKEN(anon_sym_cmpxchg);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3613:
      ACCEPT_TOKEN(anon_sym_atomicrmw);
      END_STATE();
    case 3614:
      ACCEPT_TOKEN(anon_sym_atomicrmw);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3615:
      ACCEPT_TOKEN(anon_sym_fence);
      END_STATE();
    case 3616:
      ACCEPT_TOKEN(anon_sym_fence);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3617:
      ACCEPT_TOKEN(anon_sym_getelementptr);
      END_STATE();
    case 3618:
      ACCEPT_TOKEN(anon_sym_getelementptr);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3619:
      ACCEPT_TOKEN(anon_sym_inbounds);
      END_STATE();
    case 3620:
      ACCEPT_TOKEN(anon_sym_inrange);
      END_STATE();
    case 3621:
      ACCEPT_TOKEN(anon_sym_extractvalue);
      END_STATE();
    case 3622:
      ACCEPT_TOKEN(anon_sym_extractvalue);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3623:
      ACCEPT_TOKEN(anon_sym_insertvalue);
      END_STATE();
    case 3624:
      ACCEPT_TOKEN(anon_sym_insertvalue);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3625:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 3626:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3627:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3628:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 3629:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == ':') ADVANCE(3048);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1290);
      END_STATE();
    case 3630:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(4540);
      END_STATE();
    case 3631:
      ACCEPT_TOKEN(anon_sym_nul