#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 260
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 82
#define ALIAS_COUNT 1
#define TOKEN_COUNT 39
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 3

enum {
  anon_sym_LT = 1,
  anon_sym_GT = 2,
  anon_sym_SLASH_GT = 3,
  anon_sym_LT_SLASH = 4,
  anon_sym_EQ = 5,
  aux_sym_attribute_name_token1 = 6,
  anon_sym_SQUOTE = 7,
  aux_sym_quoted_attribute_value_token1 = 8,
  anon_sym_DQUOTE = 9,
  aux_sym_quoted_attribute_value_token2 = 10,
  aux_sym__text_token1 = 11,
  anon_sym_LBRACE_RBRACE = 12,
  anon_sym_LBRACE = 13,
  anon_sym_RBRACE = 14,
  anon_sym_AT = 15,
  anon_sym_html = 16,
  anon_sym_POUND = 17,
  anon_sym_if = 18,
  anon_sym_COLON = 19,
  anon_sym_else = 20,
  anon_sym_SLASH = 21,
  anon_sym_each = 22,
  anon_sym_as = 23,
  anon_sym_await = 24,
  anon_sym_then = 25,
  anon_sym_catch = 26,
  anon_sym_key = 27,
  sym__start_tag_name = 28,
  sym__script_start_tag_name = 29,
  sym__style_start_tag_name = 30,
  sym__end_tag_name = 31,
  sym_erroneous_end_tag_name = 32,
  sym__implicit_end_tag = 33,
  sym_raw_text = 34,
  sym_raw_text_expr = 35,
  sym_raw_text_await = 36,
  sym_raw_text_each = 37,
  sym_comment = 38,
  sym_document = 39,
  sym__node = 40,
  sym__statement = 41,
  sym_element = 42,
  sym_start_tag = 43,
  sym_self_closing_tag = 44,
  sym_end_tag = 45,
  sym_script_element = 46,
  sym_script_start_tag = 47,
  sym_style_element = 48,
  sym_style_start_tag = 49,
  sym_attribute = 50,
  sym_attribute_name = 51,
  sym_attribute_value = 52,
  sym_expr_attribute_value = 53,
  sym_quoted_attribute_value = 54,
  sym__text = 55,
  sym__expression = 56,
  sym_expression = 57,
  sym_html_expr = 58,
  sym_if_statement = 59,
  sym_else_if_statement = 60,
  sym_else_statement = 61,
  sym_if_start_expr = 62,
  sym_else_expr = 63,
  sym_else_if_expr = 64,
  sym_if_end_expr = 65,
  sym_each_statement = 66,
  sym_each_start_expr = 67,
  sym_else_each_statement = 68,
  sym_each_end_expr = 69,
  sym_await_statement = 70,
  sym_then_statement = 71,
  sym_catch_statement = 72,
  sym_await_start_expr = 73,
  sym_then_expr = 74,
  sym_catch_expr = 75,
  sym_await_end_expr = 76,
  sym_key_statement = 77,
  sym_key_start_expr = 78,
  sym_key_end_expr = 79,
  aux_sym_document_repeat1 = 80,
  aux_sym_start_tag_repeat1 = 81,
  alias_sym_then = 82,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH_GT] = "/>",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_EQ] = "=",
  [aux_sym_attribute_name_token1] = "attribute_name_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_quoted_attribute_value_token1] = "attribute_value",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_quoted_attribute_value_token2] = "attribute_value",
  [aux_sym__text_token1] = "text",
  [anon_sym_LBRACE_RBRACE] = "expression",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_AT] = "@",
  [anon_sym_html] = "special_block_keyword",
  [anon_sym_POUND] = "#",
  [anon_sym_if] = "special_block_keyword",
  [anon_sym_COLON] = ":",
  [anon_sym_else] = "special_block_keyword",
  [anon_sym_SLASH] = "/",
  [anon_sym_each] = "special_block_keyword",
  [anon_sym_as] = "as",
  [anon_sym_await] = "special_block_keyword",
  [anon_sym_then] = "special_block_keyword",
  [anon_sym_catch] = "special_block_keyword",
  [anon_sym_key] = "special_block_keyword",
  [sym__start_tag_name] = "tag_name",
  [sym__script_start_tag_name] = "tag_name",
  [sym__style_start_tag_name] = "tag_name",
  [sym__end_tag_name] = "tag_name",
  [sym_erroneous_end_tag_name] = "erroneous_end_tag_name",
  [sym__implicit_end_tag] = "_implicit_end_tag",
  [sym_raw_text] = "raw_text",
  [sym_raw_text_expr] = "raw_text_expr",
  [sym_raw_text_await] = "raw_text_await",
  [sym_raw_text_each] = "raw_text_each",
  [sym_comment] = "comment",
  [sym_document] = "document",
  [sym__node] = "_node",
  [sym__statement] = "_statement",
  [sym_element] = "element",
  [sym_start_tag] = "start_tag",
  [sym_self_closing_tag] = "self_closing_tag",
  [sym_end_tag] = "end_tag",
  [sym_script_element] = "script_element",
  [sym_script_start_tag] = "start_tag",
  [sym_style_element] = "style_element",
  [sym_style_start_tag] = "start_tag",
  [sym_attribute] = "attribute",
  [sym_attribute_name] = "attribute_name",
  [sym_attribute_value] = "attribute_value",
  [sym_expr_attribute_value] = "expr_attribute_value",
  [sym_quoted_attribute_value] = "quoted_attribute_value",
  [sym__text] = "_text",
  [sym__expression] = "_expression",
  [sym_expression] = "expression",
  [sym_html_expr] = "html_expr",
  [sym_if_statement] = "if_statement",
  [sym_else_if_statement] = "else_if_statement",
  [sym_else_statement] = "else_statement",
  [sym_if_start_expr] = "if_start_expr",
  [sym_else_expr] = "else_expr",
  [sym_else_if_expr] = "else_if_expr",
  [sym_if_end_expr] = "if_end_expr",
  [sym_each_statement] = "each_statement",
  [sym_each_start_expr] = "each_start_expr",
  [sym_else_each_statement] = "else_each_statement",
  [sym_each_end_expr] = "each_end_expr",
  [sym_await_statement] = "await_statement",
  [sym_then_statement] = "then_statement",
  [sym_catch_statement] = "catch_statement",
  [sym_await_start_expr] = "await_start_expr",
  [sym_then_expr] = "then_expr",
  [sym_catch_expr] = "catch_expr",
  [sym_await_end_expr] = "await_end_expr",
  [sym_key_statement] = "key_statement",
  [sym_key_start_expr] = "key_start_expr",
  [sym_key_end_expr] = "key_end_expr",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_start_tag_repeat1] = "start_tag_repeat1",
  [alias_sym_then] = "then",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_EQ] = anon_sym_EQ,
  [aux_sym_attribute_name_token1] = aux_sym_attribute_name_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_quoted_attribute_value_token1] = sym_attribute_value,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_quoted_attribute_value_token2] = sym_attribute_value,
  [aux_sym__text_token1] = aux_sym__text_token1,
  [anon_sym_LBRACE_RBRACE] = sym_expression,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_html] = anon_sym_html,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_if] = anon_sym_html,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_else] = anon_sym_html,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_each] = anon_sym_html,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_await] = anon_sym_html,
  [anon_sym_then] = anon_sym_html,
  [anon_sym_catch] = anon_sym_html,
  [anon_sym_key] = anon_sym_html,
  [sym__start_tag_name] = sym__start_tag_name,
  [sym__script_start_tag_name] = sym__start_tag_name,
  [sym__style_start_tag_name] = sym__start_tag_name,
  [sym__end_tag_name] = sym__start_tag_name,
  [sym_erroneous_end_tag_name] = sym_erroneous_end_tag_name,
  [sym__implicit_end_tag] = sym__implicit_end_tag,
  [sym_raw_text] = sym_raw_text,
  [sym_raw_text_expr] = sym_raw_text_expr,
  [sym_raw_text_await] = sym_raw_text_await,
  [sym_raw_text_each] = sym_raw_text_each,
  [sym_comment] = sym_comment,
  [sym_document] = sym_document,
  [sym__node] = sym__node,
  [sym__statement] = sym__statement,
  [sym_element] = sym_element,
  [sym_start_tag] = sym_start_tag,
  [sym_self_closing_tag] = sym_self_closing_tag,
  [sym_end_tag] = sym_end_tag,
  [sym_script_element] = sym_script_element,
  [sym_script_start_tag] = sym_start_tag,
  [sym_style_element] = sym_style_element,
  [sym_style_start_tag] = sym_start_tag,
  [sym_attribute] = sym_attribute,
  [sym_attribute_name] = sym_attribute_name,
  [sym_attribute_value] = sym_attribute_value,
  [sym_expr_attribute_value] = sym_expr_attribute_value,
  [sym_quoted_attribute_value] = sym_quoted_attribute_value,
  [sym__text] = sym__text,
  [sym__expression] = sym__expression,
  [sym_expression] = sym_expression,
  [sym_html_expr] = sym_html_expr,
  [sym_if_statement] = sym_if_statement,
  [sym_else_if_statement] = sym_else_if_statement,
  [sym_else_statement] = sym_else_statement,
  [sym_if_start_expr] = sym_if_start_expr,
  [sym_else_expr] = sym_else_expr,
  [sym_else_if_expr] = sym_else_if_expr,
  [sym_if_end_expr] = sym_if_end_expr,
  [sym_each_statement] = sym_each_statement,
  [sym_each_start_expr] = sym_each_start_expr,
  [sym_else_each_statement] = sym_else_each_statement,
  [sym_each_end_expr] = sym_each_end_expr,
  [sym_await_statement] = sym_await_statement,
  [sym_then_statement] = sym_then_statement,
  [sym_catch_statement] = sym_catch_statement,
  [sym_await_start_expr] = sym_await_start_expr,
  [sym_then_expr] = sym_then_expr,
  [sym_catch_expr] = sym_catch_expr,
  [sym_await_end_expr] = sym_await_end_expr,
  [sym_key_statement] = sym_key_statement,
  [sym_key_start_expr] = sym_key_start_expr,
  [sym_key_end_expr] = sym_key_end_expr,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_start_tag_repeat1] = aux_sym_start_tag_repeat1,
  [alias_sym_then] = alias_sym_then,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_attribute_name_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_attribute_value_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_attribute_value_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__text_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE_RBRACE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_html] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_key] = {
    .visible = true,
    .named = true,
  },
  [sym__start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__script_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__style_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym_erroneous_end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__implicit_end_tag] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_text] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_text_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_text_await] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_text_each] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym__node] = {
    .visible = false,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_element] = {
    .visible = true,
    .named = true,
  },
  [sym_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_self_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_script_element] = {
    .visible = true,
    .named = true,
  },
  [sym_script_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_style_element] = {
    .visible = true,
    .named = true,
  },
  [sym_style_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym__text] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_html_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_start_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_else_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_if_end_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_each_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_each_start_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_else_each_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_each_end_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_await_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_then_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_await_start_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_then_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_await_end_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_key_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_key_start_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_key_end_expr] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_start_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_then] = {
    .visible = true,
    .named = true,
  },
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_attribute_name,
  },
  [2] = {
    [4] = alias_sym_then,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  sym_expression, 2,
    sym_expression,
    sym_attribute_name,
  0,
};

static inline bool aux_sym_attribute_name_token1_character_set_1(int32_t c) {
  return (c < '\''
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '"')))
    : (c <= '\'' || (c < '{'
      ? (c < '<'
        ? c == '/'
        : c <= '>')
      : (c <= '{' || c == '}'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(30);
      if (lookahead == '"') ADVANCE(40);
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '\'') ADVANCE(37);
      if (lookahead == '/') ADVANCE(55);
      if (lookahead == ':') ADVANCE(52);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '>') ADVANCE(32);
      if (lookahead == '@') ADVANCE(48);
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 'e') ADVANCE(6);
      if (lookahead == 'h') ADVANCE(24);
      if (lookahead == 'i') ADVANCE(14);
      if (lookahead == 'k') ADVANCE(11);
      if (lookahead == 't') ADVANCE(17);
      if (lookahead == '{') ADVANCE(46);
      if (lookahead == '}') ADVANCE(47);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(37);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '>') ADVANCE(32);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '}') ADVANCE(36);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(40);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == ':') ADVANCE(52);
      if (lookahead == '@') ADVANCE(48);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      END_STATE();
    case 4:
      if (lookahead == '\'') ADVANCE(37);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(38);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 5:
      if (lookahead == '>') ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(23);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(18);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(26);
      END_STATE();
    case 9:
      if (lookahead == 'c') ADVANCE(15);
      END_STATE();
    case 10:
      if (lookahead == 'c') ADVANCE(16);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(27);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(21);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 14:
      if (lookahead == 'f') ADVANCE(51);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(56);
      END_STATE();
    case 16:
      if (lookahead == 'h') ADVANCE(60);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(12);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(25);
      END_STATE();
    case 19:
      if (lookahead == 'l') ADVANCE(49);
      END_STATE();
    case 20:
      if (lookahead == 'm') ADVANCE(19);
      END_STATE();
    case 21:
      if (lookahead == 'n') ADVANCE(59);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(57);
      if (lookahead == 'w') ADVANCE(7);
      END_STATE();
    case 23:
      if (lookahead == 's') ADVANCE(13);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(20);
      END_STATE();
    case 25:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 26:
      if (lookahead == 't') ADVANCE(10);
      END_STATE();
    case 27:
      if (lookahead == 'y') ADVANCE(61);
      END_STATE();
    case 28:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(28);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(43);
      END_STATE();
    case 29:
      if (eof) ADVANCE(30);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '{') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(43);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(34);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(aux_sym_attribute_name_token1);
      if (!aux_sym_attribute_name_token1_character_set_1(lookahead)) ADVANCE(36);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(38);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(39);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(39);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(42);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(42);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(28);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(43);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_LBRACE_RBRACE);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '}') ADVANCE(44);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_html);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '>') ADVANCE(33);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_key);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 29, .external_lex_state = 2},
  [2] = {.lex_state = 29, .external_lex_state = 2},
  [3] = {.lex_state = 29, .external_lex_state = 2},
  [4] = {.lex_state = 29, .external_lex_state = 2},
  [5] = {.lex_state = 29, .external_lex_state = 2},
  [6] = {.lex_state = 29, .external_lex_state = 2},
  [7] = {.lex_state = 29, .external_lex_state = 2},
  [8] = {.lex_state = 29, .external_lex_state = 2},
  [9] = {.lex_state = 29, .external_lex_state = 2},
  [10] = {.lex_state = 29, .external_lex_state = 2},
  [11] = {.lex_state = 29, .external_lex_state = 2},
  [12] = {.lex_state = 29, .external_lex_state = 2},
  [13] = {.lex_state = 29, .external_lex_state = 2},
  [14] = {.lex_state = 29, .external_lex_state = 2},
  [15] = {.lex_state = 29, .external_lex_state = 3},
  [16] = {.lex_state = 29, .external_lex_state = 2},
  [17] = {.lex_state = 29, .external_lex_state = 2},
  [18] = {.lex_state = 29, .external_lex_state = 3},
  [19] = {.lex_state = 29, .external_lex_state = 2},
  [20] = {.lex_state = 29, .external_lex_state = 2},
  [21] = {.lex_state = 29, .external_lex_state = 2},
  [22] = {.lex_state = 29, .external_lex_state = 2},
  [23] = {.lex_state = 29, .external_lex_state = 3},
  [24] = {.lex_state = 29, .external_lex_state = 2},
  [25] = {.lex_state = 29, .external_lex_state = 3},
  [26] = {.lex_state = 29, .external_lex_state = 3},
  [27] = {.lex_state = 29, .external_lex_state = 2},
  [28] = {.lex_state = 29, .external_lex_state = 2},
  [29] = {.lex_state = 29, .external_lex_state = 2},
  [30] = {.lex_state = 29, .external_lex_state = 2},
  [31] = {.lex_state = 29, .external_lex_state = 2},
  [32] = {.lex_state = 29, .external_lex_state = 2},
  [33] = {.lex_state = 29, .external_lex_state = 2},
  [34] = {.lex_state = 29, .external_lex_state = 2},
  [35] = {.lex_state = 29, .external_lex_state = 2},
  [36] = {.lex_state = 29, .external_lex_state = 2},
  [37] = {.lex_state = 29, .external_lex_state = 2},
  [38] = {.lex_state = 29, .external_lex_state = 2},
  [39] = {.lex_state = 29, .external_lex_state = 2},
  [40] = {.lex_state = 29, .external_lex_state = 2},
  [41] = {.lex_state = 29, .external_lex_state = 2},
  [42] = {.lex_state = 29, .external_lex_state = 2},
  [43] = {.lex_state = 29, .external_lex_state = 2},
  [44] = {.lex_state = 29, .external_lex_state = 2},
  [45] = {.lex_state = 1, .external_lex_state = 4},
  [46] = {.lex_state = 1, .external_lex_state = 4},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1, .external_lex_state = 4},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 1, .external_lex_state = 4},
  [51] = {.lex_state = 1, .external_lex_state = 4},
  [52] = {.lex_state = 29, .external_lex_state = 3},
  [53] = {.lex_state = 1},
  [54] = {.lex_state = 29, .external_lex_state = 3},
  [55] = {.lex_state = 1},
  [56] = {.lex_state = 29, .external_lex_state = 3},
  [57] = {.lex_state = 29, .external_lex_state = 3},
  [58] = {.lex_state = 29, .external_lex_state = 3},
  [59] = {.lex_state = 29, .external_lex_state = 3},
  [60] = {.lex_state = 29, .external_lex_state = 3},
  [61] = {.lex_state = 1},
  [62] = {.lex_state = 29, .external_lex_state = 3},
  [63] = {.lex_state = 29, .external_lex_state = 3},
  [64] = {.lex_state = 29, .external_lex_state = 3},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 29, .external_lex_state = 3},
  [67] = {.lex_state = 29, .external_lex_state = 3},
  [68] = {.lex_state = 29, .external_lex_state = 3},
  [69] = {.lex_state = 29, .external_lex_state = 3},
  [70] = {.lex_state = 29, .external_lex_state = 3},
  [71] = {.lex_state = 29, .external_lex_state = 3},
  [72] = {.lex_state = 29, .external_lex_state = 3},
  [73] = {.lex_state = 29, .external_lex_state = 3},
  [74] = {.lex_state = 29, .external_lex_state = 3},
  [75] = {.lex_state = 29, .external_lex_state = 3},
  [76] = {.lex_state = 29, .external_lex_state = 3},
  [77] = {.lex_state = 29, .external_lex_state = 3},
  [78] = {.lex_state = 29, .external_lex_state = 3},
  [79] = {.lex_state = 29, .external_lex_state = 3},
  [80] = {.lex_state = 29, .external_lex_state = 3},
  [81] = {.lex_state = 29, .external_lex_state = 3},
  [82] = {.lex_state = 29, .external_lex_state = 3},
  [83] = {.lex_state = 29, .external_lex_state = 3},
  [84] = {.lex_state = 29, .external_lex_state = 3},
  [85] = {.lex_state = 29, .external_lex_state = 3},
  [86] = {.lex_state = 29, .external_lex_state = 3},
  [87] = {.lex_state = 29, .external_lex_state = 3},
  [88] = {.lex_state = 29, .external_lex_state = 3},
  [89] = {.lex_state = 29, .external_lex_state = 3},
  [90] = {.lex_state = 29, .external_lex_state = 3},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 29, .external_lex_state = 3},
  [93] = {.lex_state = 29, .external_lex_state = 3},
  [94] = {.lex_state = 29, .external_lex_state = 2},
  [95] = {.lex_state = 29, .external_lex_state = 2},
  [96] = {.lex_state = 29, .external_lex_state = 2},
  [97] = {.lex_state = 29, .external_lex_state = 2},
  [98] = {.lex_state = 29, .external_lex_state = 2},
  [99] = {.lex_state = 29, .external_lex_state = 2},
  [100] = {.lex_state = 29, .external_lex_state = 2},
  [101] = {.lex_state = 29, .external_lex_state = 2},
  [102] = {.lex_state = 29, .external_lex_state = 2},
  [103] = {.lex_state = 29, .external_lex_state = 2},
  [104] = {.lex_state = 29, .external_lex_state = 2},
  [105] = {.lex_state = 29, .external_lex_state = 2},
  [106] = {.lex_state = 29, .external_lex_state = 2},
  [107] = {.lex_state = 29, .external_lex_state = 2},
  [108] = {.lex_state = 29, .external_lex_state = 2},
  [109] = {.lex_state = 29, .external_lex_state = 2},
  [110] = {.lex_state = 29, .external_lex_state = 2},
  [111] = {.lex_state = 29, .external_lex_state = 2},
  [112] = {.lex_state = 29, .external_lex_state = 2},
  [113] = {.lex_state = 29, .external_lex_state = 2},
  [114] = {.lex_state = 29, .external_lex_state = 2},
  [115] = {.lex_state = 29, .external_lex_state = 2},
  [116] = {.lex_state = 29, .external_lex_state = 2},
  [117] = {.lex_state = 29, .external_lex_state = 2},
  [118] = {.lex_state = 29, .external_lex_state = 2},
  [119] = {.lex_state = 29, .external_lex_state = 2},
  [120] = {.lex_state = 29, .external_lex_state = 2},
  [121] = {.lex_state = 29, .external_lex_state = 2},
  [122] = {.lex_state = 29, .external_lex_state = 2},
  [123] = {.lex_state = 29, .external_lex_state = 2},
  [124] = {.lex_state = 29, .external_lex_state = 2},
  [125] = {.lex_state = 29, .external_lex_state = 2},
  [126] = {.lex_state = 29, .external_lex_state = 2},
  [127] = {.lex_state = 29, .external_lex_state = 2},
  [128] = {.lex_state = 29, .external_lex_state = 2},
  [129] = {.lex_state = 29, .external_lex_state = 2},
  [130] = {.lex_state = 29, .external_lex_state = 2},
  [131] = {.lex_state = 29, .external_lex_state = 2},
  [132] = {.lex_state = 29, .external_lex_state = 2},
  [133] = {.lex_state = 29, .external_lex_state = 2},
  [134] = {.lex_state = 29, .external_lex_state = 2},
  [135] = {.lex_state = 29, .external_lex_state = 2},
  [136] = {.lex_state = 29, .external_lex_state = 2},
  [137] = {.lex_state = 29, .external_lex_state = 2},
  [138] = {.lex_state = 1, .external_lex_state = 4},
  [139] = {.lex_state = 29, .external_lex_state = 2},
  [140] = {.lex_state = 1, .external_lex_state = 4},
  [141] = {.lex_state = 3, .external_lex_state = 5},
  [142] = {.lex_state = 3, .external_lex_state = 5},
  [143] = {.lex_state = 3, .external_lex_state = 5},
  [144] = {.lex_state = 3, .external_lex_state = 5},
  [145] = {.lex_state = 3, .external_lex_state = 5},
  [146] = {.lex_state = 3, .external_lex_state = 5},
  [147] = {.lex_state = 3, .external_lex_state = 5},
  [148] = {.lex_state = 29, .external_lex_state = 2},
  [149] = {.lex_state = 29, .external_lex_state = 2},
  [150] = {.lex_state = 29, .external_lex_state = 2},
  [151] = {.lex_state = 3, .external_lex_state = 5},
  [152] = {.lex_state = 3, .external_lex_state = 5},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 3, .external_lex_state = 5},
  [155] = {.lex_state = 3, .external_lex_state = 5},
  [156] = {.lex_state = 1, .external_lex_state = 4},
  [157] = {.lex_state = 3, .external_lex_state = 5},
  [158] = {.lex_state = 3, .external_lex_state = 5},
  [159] = {.lex_state = 1, .external_lex_state = 4},
  [160] = {.lex_state = 1, .external_lex_state = 4},
  [161] = {.lex_state = 1, .external_lex_state = 4},
  [162] = {.lex_state = 3, .external_lex_state = 5},
  [163] = {.lex_state = 1, .external_lex_state = 4},
  [164] = {.lex_state = 1, .external_lex_state = 4},
  [165] = {.lex_state = 1, .external_lex_state = 4},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 3, .external_lex_state = 5},
  [168] = {.lex_state = 3, .external_lex_state = 5},
  [169] = {.lex_state = 0},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 0, .external_lex_state = 6},
  [172] = {.lex_state = 0, .external_lex_state = 7},
  [173] = {.lex_state = 0, .external_lex_state = 7},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 0, .external_lex_state = 7},
  [176] = {.lex_state = 0, .external_lex_state = 7},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 0, .external_lex_state = 5},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 0, .external_lex_state = 5},
  [182] = {.lex_state = 0, .external_lex_state = 6},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 0, .external_lex_state = 5},
  [186] = {.lex_state = 0, .external_lex_state = 8},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 2},
  [189] = {.lex_state = 0, .external_lex_state = 7},
  [190] = {.lex_state = 0},
  [191] = {.lex_state = 0, .external_lex_state = 9},
  [192] = {.lex_state = 4},
  [193] = {.lex_state = 0, .external_lex_state = 7},
  [194] = {.lex_state = 2},
  [195] = {.lex_state = 4},
  [196] = {.lex_state = 0},
  [197] = {.lex_state = 0},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 0, .external_lex_state = 7},
  [200] = {.lex_state = 0},
  [201] = {.lex_state = 0, .external_lex_state = 5},
  [202] = {.lex_state = 0, .external_lex_state = 5},
  [203] = {.lex_state = 0, .external_lex_state = 7},
  [204] = {.lex_state = 0, .external_lex_state = 5},
  [205] = {.lex_state = 0, .external_lex_state = 5},
  [206] = {.lex_state = 0},
  [207] = {.lex_state = 0},
  [208] = {.lex_state = 0, .external_lex_state = 5},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 0},
  [212] = {.lex_state = 0},
  [213] = {.lex_state = 0, .external_lex_state = 5},
  [214] = {.lex_state = 0},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 0, .external_lex_state = 5},
  [217] = {.lex_state = 0, .external_lex_state = 5},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 0},
  [220] = {.lex_state = 0, .external_lex_state = 10},
  [221] = {.lex_state = 0},
  [222] = {.lex_state = 0},
  [223] = {.lex_state = 0},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 0},
  [226] = {.lex_state = 0},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 0},
  [229] = {.lex_state = 0},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 0},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 0},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 0},
  [241] = {.lex_state = 0},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 0, .external_lex_state = 10},
  [247] = {.lex_state = 0, .external_lex_state = 5},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 0},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 0, .external_lex_state = 5},
};

enum {
  ts_external_token__start_tag_name = 0,
  ts_external_token__script_start_tag_name = 1,
  ts_external_token__style_start_tag_name = 2,
  ts_external_token__end_tag_name = 3,
  ts_external_token_erroneous_end_tag_name = 4,
  ts_external_token_SLASH_GT = 5,
  ts_external_token__implicit_end_tag = 6,
  ts_external_token_raw_text = 7,
  ts_external_token_raw_text_expr = 8,
  ts_external_token_raw_text_await = 9,
  ts_external_token_raw_text_each = 10,
  ts_external_token_comment = 11,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__start_tag_name] = sym__start_tag_name,
  [ts_external_token__script_start_tag_name] = sym__script_start_tag_name,
  [ts_external_token__style_start_tag_name] = sym__style_start_tag_name,
  [ts_external_token__end_tag_name] = sym__end_tag_name,
  [ts_external_token_erroneous_end_tag_name] = sym_erroneous_end_tag_name,
  [ts_external_token_SLASH_GT] = anon_sym_SLASH_GT,
  [ts_external_token__implicit_end_tag] = sym__implicit_end_tag,
  [ts_external_token_raw_text] = sym_raw_text,
  [ts_external_token_raw_text_expr] = sym_raw_text_expr,
  [ts_external_token_raw_text_await] = sym_raw_text_await,
  [ts_external_token_raw_text_each] = sym_raw_text_each,
  [ts_external_token_comment] = sym_comment,
};

static bool ts_external_scanner_states[11][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__script_start_tag_name] = true,
    [ts_external_token__style_start_tag_name] = true,
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_erroneous_end_tag_name] = true,
    [ts_external_token_SLASH_GT] = true,
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_raw_text] = true,
    [ts_external_token_raw_text_expr] = true,
    [ts_external_token_raw_text_await] = true,
    [ts_external_token_raw_text_each] = true,
    [ts_external_token_comment] = true,
  },
  [2] = {
    [ts_external_token_comment] = true,
  },
  [3] = {
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_comment] = true,
  },
  [4] = {
    [ts_external_token_SLASH_GT] = true,
  },
  [5] = {
    [ts_external_token_raw_text_expr] = true,
  },
  [6] = {
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__script_start_tag_name] = true,
    [ts_external_token__style_start_tag_name] = true,
  },
  [7] = {
    [ts_external_token_raw_text] = true,
  },
  [8] = {
    [ts_external_token_raw_text_expr] = true,
    [ts_external_token_raw_text_each] = true,
  },
  [9] = {
    [ts_external_token_raw_text_expr] = true,
    [ts_external_token_raw_text_await] = true,
  },
  [10] = {
    [ts_external_token__end_tag_name] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH_GT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_LBRACE_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_html] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_key] = ACTIONS(1),
    [sym__start_tag_name] = ACTIONS(1),
    [sym__script_start_tag_name] = ACTIONS(1),
    [sym__style_start_tag_name] = ACTIONS(1),
    [sym__end_tag_name] = ACTIONS(1),
    [sym_erroneous_end_tag_name] = ACTIONS(1),
    [sym__implicit_end_tag] = ACTIONS(1),
    [sym_raw_text] = ACTIONS(1),
    [sym_raw_text_expr] = ACTIONS(1),
    [sym_raw_text_await] = ACTIONS(1),
    [sym_raw_text_each] = ACTIONS(1),
    [sym_comment] = ACTIONS(1),
  },
  [1] = {
    [sym_document] = STATE(230),
    [sym__node] = STATE(42),
    [sym__statement] = STATE(42),
    [sym_element] = STATE(42),
    [sym_start_tag] = STATE(18),
    [sym_self_closing_tag] = STATE(101),
    [sym_script_element] = STATE(42),
    [sym_script_start_tag] = STATE(172),
    [sym_style_element] = STATE(42),
    [sym_style_start_tag] = STATE(173),
    [sym__text] = STATE(42),
    [sym__expression] = STATE(42),
    [sym_expression] = STATE(42),
    [sym_html_expr] = STATE(42),
    [sym_if_statement] = STATE(42),
    [sym_if_start_expr] = STATE(9),
    [sym_each_statement] = STATE(42),
    [sym_each_start_expr] = STATE(21),
    [sym_await_statement] = STATE(42),
    [sym_await_start_expr] = STATE(11),
    [sym_key_statement] = STATE(42),
    [sym_key_start_expr] = STATE(30),
    [aux_sym_document_repeat1] = STATE(42),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(5),
    [aux_sym__text_token1] = ACTIONS(7),
    [anon_sym_LBRACE_RBRACE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(9),
    [sym_comment] = ACTIONS(7),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(12), 1,
      sym_else_if_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(44), 1,
      sym_else_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(71), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [63] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_else_if_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(29), 1,
      sym_else_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(109), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [126] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(12), 1,
      sym_else_if_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(44), 1,
      sym_else_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(17), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(86), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(2), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [189] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(14), 1,
      sym_then_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(31), 1,
      sym_catch_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(110), 3,
      sym_then_statement,
      sym_catch_statement,
      sym_await_end_expr,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [252] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(23), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(22), 1,
      sym_then_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(39), 1,
      sym_catch_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(21), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(83), 3,
      sym_then_statement,
      sym_catch_statement,
      sym_await_end_expr,
    STATE(13), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [315] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(12), 1,
      sym_else_if_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(44), 1,
      sym_else_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(57), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [378] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_else_if_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(29), 1,
      sym_else_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(128), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [441] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_else_if_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(29), 1,
      sym_else_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(25), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(107), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(8), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [504] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_else_if_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(29), 1,
      sym_else_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(27), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(120), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(3), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [567] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(14), 1,
      sym_then_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(31), 1,
      sym_catch_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(29), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(114), 3,
      sym_then_statement,
      sym_catch_statement,
      sym_await_end_expr,
    STATE(5), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [630] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(12), 1,
      sym_else_if_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(44), 1,
      sym_else_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(31), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(73), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(7), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [693] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(23), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(22), 1,
      sym_then_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(39), 1,
      sym_catch_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(64), 3,
      sym_then_statement,
      sym_catch_statement,
      sym_await_end_expr,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [756] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(31), 1,
      sym_catch_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    STATE(99), 2,
      sym_catch_statement,
      sym_await_end_expr,
    ACTIONS(33), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(16), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [815] = 15,
    ACTIONS(37), 1,
      anon_sym_LT,
    ACTIONS(39), 1,
      anon_sym_LT_SLASH,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym__implicit_end_tag,
    STATE(4), 1,
      sym_if_start_expr,
    STATE(6), 1,
      sym_await_start_expr,
    STATE(15), 1,
      sym_start_tag,
    STATE(19), 1,
      sym_each_start_expr,
    STATE(34), 1,
      sym_key_start_expr,
    STATE(90), 1,
      sym_end_tag,
    STATE(93), 1,
      sym_self_closing_tag,
    STATE(175), 1,
      sym_style_start_tag,
    STATE(176), 1,
      sym_script_start_tag,
    ACTIONS(41), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(25), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [876] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(31), 1,
      sym_catch_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    STATE(117), 2,
      sym_catch_statement,
      sym_await_end_expr,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [935] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(39), 1,
      sym_catch_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    STATE(54), 2,
      sym_catch_statement,
      sym_await_end_expr,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [994] = 15,
    ACTIONS(37), 1,
      anon_sym_LT,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_LT_SLASH,
    ACTIONS(53), 1,
      sym__implicit_end_tag,
    STATE(4), 1,
      sym_if_start_expr,
    STATE(6), 1,
      sym_await_start_expr,
    STATE(15), 1,
      sym_start_tag,
    STATE(19), 1,
      sym_each_start_expr,
    STATE(34), 1,
      sym_key_start_expr,
    STATE(93), 1,
      sym_self_closing_tag,
    STATE(102), 1,
      sym_end_tag,
    STATE(175), 1,
      sym_style_start_tag,
    STATE(176), 1,
      sym_script_start_tag,
    ACTIONS(51), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(23), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1055] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(28), 1,
      sym_else_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    STATE(85), 2,
      sym_else_each_statement,
      sym_each_end_expr,
    ACTIONS(55), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(24), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1114] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(59), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(33), 1,
      sym_else_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    STATE(97), 2,
      sym_else_each_statement,
      sym_each_end_expr,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1173] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(59), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(33), 1,
      sym_else_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    STATE(111), 2,
      sym_else_each_statement,
      sym_each_end_expr,
    ACTIONS(61), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(20), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1232] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(39), 1,
      sym_catch_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    STATE(67), 2,
      sym_catch_statement,
      sym_await_end_expr,
    ACTIONS(63), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(17), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1291] = 15,
    ACTIONS(37), 1,
      anon_sym_LT,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_LT_SLASH,
    ACTIONS(67), 1,
      sym__implicit_end_tag,
    STATE(4), 1,
      sym_if_start_expr,
    STATE(6), 1,
      sym_await_start_expr,
    STATE(15), 1,
      sym_start_tag,
    STATE(19), 1,
      sym_each_start_expr,
    STATE(34), 1,
      sym_key_start_expr,
    STATE(93), 1,
      sym_self_closing_tag,
    STATE(122), 1,
      sym_end_tag,
    STATE(175), 1,
      sym_style_start_tag,
    STATE(176), 1,
      sym_script_start_tag,
    ACTIONS(65), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(26), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1352] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(28), 1,
      sym_else_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    STATE(68), 2,
      sym_else_each_statement,
      sym_each_end_expr,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1411] = 15,
    ACTIONS(37), 1,
      anon_sym_LT,
    ACTIONS(39), 1,
      anon_sym_LT_SLASH,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      sym__implicit_end_tag,
    STATE(4), 1,
      sym_if_start_expr,
    STATE(6), 1,
      sym_await_start_expr,
    STATE(15), 1,
      sym_start_tag,
    STATE(19), 1,
      sym_each_start_expr,
    STATE(34), 1,
      sym_key_start_expr,
    STATE(77), 1,
      sym_end_tag,
    STATE(93), 1,
      sym_self_closing_tag,
    STATE(175), 1,
      sym_style_start_tag,
    STATE(176), 1,
      sym_script_start_tag,
    ACTIONS(65), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(26), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1472] = 13,
    ACTIONS(71), 1,
      anon_sym_LT,
    ACTIONS(79), 1,
      anon_sym_LBRACE,
    STATE(4), 1,
      sym_if_start_expr,
    STATE(6), 1,
      sym_await_start_expr,
    STATE(15), 1,
      sym_start_tag,
    STATE(19), 1,
      sym_each_start_expr,
    STATE(34), 1,
      sym_key_start_expr,
    STATE(93), 1,
      sym_self_closing_tag,
    STATE(175), 1,
      sym_style_start_tag,
    STATE(176), 1,
      sym_script_start_tag,
    ACTIONS(74), 2,
      sym__implicit_end_tag,
      anon_sym_LT_SLASH,
    ACTIONS(76), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(26), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1528] = 13,
    ACTIONS(74), 1,
      ts_builtin_sym_end,
    ACTIONS(82), 1,
      anon_sym_LT,
    ACTIONS(88), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(85), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1583] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(69), 1,
      sym_each_end_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(91), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(38), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1638] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(97), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(100), 1,
      sym_if_end_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(95), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(32), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1693] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(101), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(115), 1,
      sym_key_end_expr,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(99), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(43), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1748] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(105), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(106), 1,
      sym_await_end_expr,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(103), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(40), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1803] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(97), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(108), 1,
      sym_if_end_expr,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1858] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(109), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(96), 1,
      sym_each_end_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(107), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(37), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1913] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(113), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(82), 1,
      sym_key_end_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(111), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(35), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1968] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(113), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(63), 1,
      sym_key_end_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2023] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(115), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(70), 1,
      sym_await_end_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2078] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(109), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(112), 1,
      sym_each_end_expr,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2133] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(56), 1,
      sym_each_end_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2188] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(115), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(66), 1,
      sym_await_end_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(117), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(36), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2243] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(105), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(118), 1,
      sym_await_end_expr,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2298] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(119), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(58), 1,
      sym_if_end_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2353] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(9), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      ts_builtin_sym_end,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2408] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(101), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(123), 1,
      sym_key_end_expr,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2463] = 13,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(119), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(11), 1,
      sym_await_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(30), 1,
      sym_key_start_expr,
    STATE(74), 1,
      sym_if_end_expr,
    STATE(101), 1,
      sym_self_closing_tag,
    STATE(172), 1,
      sym_script_start_tag,
    STATE(173), 1,
      sym_style_start_tag,
    ACTIONS(123), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(41), 14,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2518] = 7,
    ACTIONS(125), 1,
      anon_sym_GT,
    ACTIONS(127), 1,
      anon_sym_SLASH_GT,
    ACTIONS(129), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(131), 1,
      anon_sym_LBRACE,
    STATE(138), 1,
      sym_attribute_name,
    STATE(161), 1,
      sym_expression,
    STATE(51), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [2541] = 6,
    ACTIONS(135), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(138), 1,
      anon_sym_LBRACE,
    STATE(138), 1,
      sym_attribute_name,
    STATE(161), 1,
      sym_expression,
    ACTIONS(133), 2,
      anon_sym_GT,
      anon_sym_SLASH_GT,
    STATE(46), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [2562] = 6,
    ACTIONS(141), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(143), 1,
      anon_sym_SQUOTE,
    ACTIONS(145), 1,
      anon_sym_DQUOTE,
    ACTIONS(147), 1,
      anon_sym_LBRACE,
    STATE(170), 1,
      sym_expression,
    STATE(183), 3,
      sym_attribute_value,
      sym_expr_attribute_value,
      sym_quoted_attribute_value,
  [2583] = 7,
    ACTIONS(129), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(131), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_GT,
    ACTIONS(151), 1,
      anon_sym_SLASH_GT,
    STATE(138), 1,
      sym_attribute_name,
    STATE(161), 1,
      sym_expression,
    STATE(46), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [2606] = 6,
    ACTIONS(131), 1,
      anon_sym_LBRACE,
    ACTIONS(153), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(155), 1,
      anon_sym_SQUOTE,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    STATE(164), 1,
      sym_expression,
    STATE(163), 3,
      sym_attribute_value,
      sym_expr_attribute_value,
      sym_quoted_attribute_value,
  [2627] = 7,
    ACTIONS(125), 1,
      anon_sym_GT,
    ACTIONS(129), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(131), 1,
      anon_sym_LBRACE,
    ACTIONS(159), 1,
      anon_sym_SLASH_GT,
    STATE(138), 1,
      sym_attribute_name,
    STATE(161), 1,
      sym_expression,
    STATE(48), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [2650] = 7,
    ACTIONS(129), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(131), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_GT,
    ACTIONS(161), 1,
      anon_sym_SLASH_GT,
    STATE(138), 1,
      sym_attribute_name,
    STATE(161), 1,
      sym_expression,
    STATE(46), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [2673] = 2,
    ACTIONS(163), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(165), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2685] = 6,
    ACTIONS(147), 1,
      anon_sym_LBRACE,
    ACTIONS(167), 1,
      anon_sym_GT,
    ACTIONS(169), 1,
      aux_sym_attribute_name_token1,
    STATE(166), 1,
      sym_attribute_name,
    STATE(174), 1,
      sym_expression,
    STATE(61), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [2705] = 2,
    ACTIONS(171), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(173), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2717] = 6,
    ACTIONS(147), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(175), 1,
      anon_sym_GT,
    STATE(166), 1,
      sym_attribute_name,
    STATE(174), 1,
      sym_expression,
    STATE(61), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [2737] = 2,
    ACTIONS(177), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(179), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2749] = 2,
    ACTIONS(181), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(183), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2761] = 2,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(187), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2773] = 2,
    ACTIONS(189), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(191), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2785] = 2,
    ACTIONS(193), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(195), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2797] = 6,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(197), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(200), 1,
      anon_sym_LBRACE,
    STATE(166), 1,
      sym_attribute_name,
    STATE(174), 1,
      sym_expression,
    STATE(61), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [2817] = 2,
    ACTIONS(203), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(205), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2829] = 2,
    ACTIONS(207), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(209), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2841] = 2,
    ACTIONS(211), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(213), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2853] = 6,
    ACTIONS(147), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(215), 1,
      anon_sym_GT,
    STATE(166), 1,
      sym_attribute_name,
    STATE(174), 1,
      sym_expression,
    STATE(53), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [2873] = 2,
    ACTIONS(217), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(219), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2885] = 2,
    ACTIONS(221), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(223), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2897] = 2,
    ACTIONS(225), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(227), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2909] = 2,
    ACTIONS(229), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(231), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2921] = 2,
    ACTIONS(233), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(235), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2933] = 2,
    ACTIONS(237), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(239), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2945] = 2,
    ACTIONS(241), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(243), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2957] = 2,
    ACTIONS(245), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(247), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2969] = 2,
    ACTIONS(249), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(251), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2981] = 2,
    ACTIONS(253), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(255), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [2993] = 2,
    ACTIONS(257), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(259), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3005] = 2,
    ACTIONS(261), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(263), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3017] = 2,
    ACTIONS(265), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(267), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3029] = 2,
    ACTIONS(269), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(271), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3041] = 2,
    ACTIONS(273), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(275), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3053] = 2,
    ACTIONS(277), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(279), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3065] = 2,
    ACTIONS(281), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(283), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3077] = 2,
    ACTIONS(285), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(287), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3089] = 2,
    ACTIONS(289), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(291), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3101] = 2,
    ACTIONS(293), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(295), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3113] = 2,
    ACTIONS(297), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(299), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3125] = 2,
    ACTIONS(301), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(303), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3137] = 2,
    ACTIONS(305), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(307), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3149] = 2,
    ACTIONS(309), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(311), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3161] = 2,
    ACTIONS(313), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(315), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3173] = 6,
    ACTIONS(147), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(317), 1,
      anon_sym_GT,
    STATE(166), 1,
      sym_attribute_name,
    STATE(174), 1,
      sym_expression,
    STATE(55), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [3193] = 2,
    ACTIONS(319), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(321), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3205] = 2,
    ACTIONS(323), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(325), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3217] = 2,
    ACTIONS(253), 1,
      anon_sym_LBRACE,
    ACTIONS(255), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3228] = 2,
    ACTIONS(257), 1,
      anon_sym_LBRACE,
    ACTIONS(259), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3239] = 2,
    ACTIONS(229), 1,
      anon_sym_LBRACE,
    ACTIONS(231), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3250] = 2,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3261] = 2,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(195), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3272] = 2,
    ACTIONS(221), 1,
      anon_sym_LBRACE,
    ACTIONS(223), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3283] = 2,
    ACTIONS(249), 1,
      anon_sym_LBRACE,
    ACTIONS(251), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3294] = 2,
    ACTIONS(323), 1,
      anon_sym_LBRACE,
    ACTIONS(325), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3305] = 2,
    ACTIONS(313), 1,
      anon_sym_LBRACE,
    ACTIONS(315), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3316] = 2,
    ACTIONS(309), 1,
      anon_sym_LBRACE,
    ACTIONS(311), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3327] = 2,
    ACTIONS(305), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3338] = 2,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3349] = 2,
    ACTIONS(217), 1,
      anon_sym_LBRACE,
    ACTIONS(219), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3360] = 2,
    ACTIONS(297), 1,
      anon_sym_LBRACE,
    ACTIONS(299), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3371] = 2,
    ACTIONS(185), 1,
      anon_sym_LBRACE,
    ACTIONS(187), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3382] = 2,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3393] = 2,
    ACTIONS(211), 1,
      anon_sym_LBRACE,
    ACTIONS(213), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3404] = 2,
    ACTIONS(293), 1,
      anon_sym_LBRACE,
    ACTIONS(295), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3415] = 2,
    ACTIONS(177), 1,
      anon_sym_LBRACE,
    ACTIONS(179), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3426] = 2,
    ACTIONS(163), 1,
      anon_sym_LBRACE,
    ACTIONS(165), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3437] = 2,
    ACTIONS(285), 1,
      anon_sym_LBRACE,
    ACTIONS(287), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3448] = 2,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(283), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3459] = 2,
    ACTIONS(273), 1,
      anon_sym_LBRACE,
    ACTIONS(275), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3470] = 2,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3481] = 2,
    ACTIONS(233), 1,
      anon_sym_LBRACE,
    ACTIONS(235), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3492] = 2,
    ACTIONS(289), 1,
      anon_sym_LBRACE,
    ACTIONS(291), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3503] = 2,
    ACTIONS(245), 1,
      anon_sym_LBRACE,
    ACTIONS(247), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3514] = 2,
    ACTIONS(269), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3525] = 2,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3536] = 2,
    ACTIONS(207), 1,
      anon_sym_LBRACE,
    ACTIONS(209), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3547] = 2,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3558] = 2,
    ACTIONS(241), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3569] = 2,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(267), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3580] = 2,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3591] = 2,
    ACTIONS(237), 1,
      anon_sym_LBRACE,
    ACTIONS(239), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3602] = 2,
    ACTIONS(329), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3612] = 2,
    ACTIONS(333), 1,
      anon_sym_LBRACE,
    ACTIONS(331), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3622] = 2,
    ACTIONS(337), 1,
      anon_sym_LBRACE,
    ACTIONS(335), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3632] = 2,
    ACTIONS(341), 1,
      anon_sym_LBRACE,
    ACTIONS(339), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3642] = 2,
    ACTIONS(345), 1,
      anon_sym_LBRACE,
    ACTIONS(343), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3652] = 2,
    ACTIONS(349), 1,
      anon_sym_LBRACE,
    ACTIONS(347), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3662] = 2,
    ACTIONS(353), 1,
      anon_sym_LBRACE,
    ACTIONS(351), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3672] = 2,
    ACTIONS(357), 1,
      anon_sym_LBRACE,
    ACTIONS(355), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3682] = 2,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    ACTIONS(359), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3692] = 2,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(363), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [3702] = 2,
    ACTIONS(369), 1,
      anon_sym_LBRACE,
    ACTIONS(367), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3712] = 1,
    ACTIONS(371), 5,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      anon_sym_EQ,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [3720] = 5,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(377), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      anon_sym_SLASH,
    ACTIONS(381), 1,
      sym_raw_text_expr,
  [3736] = 5,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(383), 1,
      anon_sym_COLON,
    ACTIONS(385), 1,
      anon_sym_SLASH,
  [3752] = 5,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(387), 1,
      anon_sym_COLON,
    ACTIONS(389), 1,
      anon_sym_SLASH,
  [3768] = 5,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(391), 1,
      anon_sym_COLON,
    ACTIONS(393), 1,
      anon_sym_SLASH,
  [3784] = 5,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(387), 1,
      anon_sym_COLON,
    ACTIONS(395), 1,
      anon_sym_SLASH,
  [3800] = 5,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      anon_sym_SLASH,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(391), 1,
      anon_sym_COLON,
  [3816] = 5,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(383), 1,
      anon_sym_COLON,
    ACTIONS(397), 1,
      anon_sym_SLASH,
  [3832] = 2,
    ACTIONS(401), 1,
      anon_sym_LBRACE,
    ACTIONS(399), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3842] = 2,
    ACTIONS(405), 1,
      anon_sym_LBRACE,
    ACTIONS(403), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3852] = 2,
    ACTIONS(409), 1,
      anon_sym_LBRACE,
    ACTIONS(407), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3862] = 5,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(377), 1,
      anon_sym_COLON,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(393), 1,
      anon_sym_SLASH,
  [3878] = 4,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(389), 1,
      anon_sym_SLASH,
  [3891] = 1,
    ACTIONS(371), 4,
      anon_sym_GT,
      anon_sym_EQ,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [3898] = 4,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(411), 1,
      anon_sym_SLASH,
  [3911] = 4,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(393), 1,
      anon_sym_SLASH,
  [3924] = 1,
    ACTIONS(271), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [3931] = 4,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(397), 1,
      anon_sym_SLASH,
  [3944] = 4,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(395), 1,
      anon_sym_SLASH,
  [3957] = 1,
    ACTIONS(413), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [3964] = 1,
    ACTIONS(415), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [3971] = 1,
    ACTIONS(417), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [3978] = 4,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(419), 1,
      anon_sym_SLASH,
  [3991] = 1,
    ACTIONS(421), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [3998] = 1,
    ACTIONS(423), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4005] = 1,
    ACTIONS(425), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4012] = 2,
    ACTIONS(427), 1,
      anon_sym_EQ,
    ACTIONS(363), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4021] = 4,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
    ACTIONS(385), 1,
      anon_sym_SLASH,
  [4034] = 4,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      anon_sym_SLASH,
    ACTIONS(381), 1,
      sym_raw_text_expr,
  [4047] = 4,
    ACTIONS(429), 1,
      anon_sym_if,
    ACTIONS(431), 1,
      anon_sym_each,
    ACTIONS(433), 1,
      anon_sym_await,
    ACTIONS(435), 1,
      anon_sym_key,
  [4060] = 1,
    ACTIONS(423), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4066] = 3,
    ACTIONS(437), 1,
      sym__start_tag_name,
    ACTIONS(439), 1,
      sym__script_start_tag_name,
    ACTIONS(441), 1,
      sym__style_start_tag_name,
  [4076] = 3,
    ACTIONS(49), 1,
      anon_sym_LT_SLASH,
    ACTIONS(443), 1,
      sym_raw_text,
    STATE(103), 1,
      sym_end_tag,
  [4086] = 3,
    ACTIONS(49), 1,
      anon_sym_LT_SLASH,
    ACTIONS(445), 1,
      sym_raw_text,
    STATE(104), 1,
      sym_end_tag,
  [4096] = 1,
    ACTIONS(417), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4102] = 3,
    ACTIONS(39), 1,
      anon_sym_LT_SLASH,
    ACTIONS(447), 1,
      sym_raw_text,
    STATE(88), 1,
      sym_end_tag,
  [4112] = 3,
    ACTIONS(39), 1,
      anon_sym_LT_SLASH,
    ACTIONS(449), 1,
      sym_raw_text,
    STATE(89), 1,
      sym_end_tag,
  [4122] = 1,
    ACTIONS(271), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4128] = 3,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(451), 1,
      anon_sym_AT,
    ACTIONS(453), 1,
      sym_raw_text_expr,
  [4138] = 1,
    ACTIONS(425), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4144] = 1,
    ACTIONS(413), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4150] = 3,
    ACTIONS(373), 1,
      anon_sym_AT,
    ACTIONS(375), 1,
      anon_sym_POUND,
    ACTIONS(381), 1,
      sym_raw_text_expr,
  [4160] = 3,
    ACTIONS(439), 1,
      sym__script_start_tag_name,
    ACTIONS(441), 1,
      sym__style_start_tag_name,
    ACTIONS(455), 1,
      sym__start_tag_name,
  [4170] = 1,
    ACTIONS(421), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4176] = 1,
    ACTIONS(415), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4182] = 2,
    ACTIONS(457), 1,
      anon_sym_RBRACE,
    ACTIONS(459), 1,
      sym_raw_text_expr,
  [4189] = 2,
    ACTIONS(461), 1,
      sym_raw_text_expr,
    ACTIONS(463), 1,
      sym_raw_text_each,
  [4196] = 2,
    ACTIONS(39), 1,
      anon_sym_LT_SLASH,
    STATE(75), 1,
      sym_end_tag,
  [4203] = 2,
    ACTIONS(465), 1,
      anon_sym_DQUOTE,
    ACTIONS(467), 1,
      aux_sym_quoted_attribute_value_token2,
  [4210] = 1,
    ACTIONS(469), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [4215] = 2,
    ACTIONS(471), 1,
      anon_sym_then,
    ACTIONS(473), 1,
      anon_sym_catch,
  [4222] = 2,
    ACTIONS(475), 1,
      sym_raw_text_expr,
    ACTIONS(477), 1,
      sym_raw_text_await,
  [4229] = 2,
    ACTIONS(479), 1,
      anon_sym_SQUOTE,
    ACTIONS(481), 1,
      aux_sym_quoted_attribute_value_token1,
  [4236] = 1,
    ACTIONS(483), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [4241] = 2,
    ACTIONS(479), 1,
      anon_sym_DQUOTE,
    ACTIONS(485), 1,
      aux_sym_quoted_attribute_value_token2,
  [4248] = 2,
    ACTIONS(465), 1,
      anon_sym_SQUOTE,
    ACTIONS(487), 1,
      aux_sym_quoted_attribute_value_token1,
  [4255] = 2,
    ACTIONS(39), 1,
      anon_sym_LT_SLASH,
    STATE(76), 1,
      sym_end_tag,
  [4262] = 2,
    ACTIONS(489), 1,
      anon_sym_RBRACE,
    ACTIONS(491), 1,
      anon_sym_if,
  [4269] = 2,
    ACTIONS(49), 1,
      anon_sym_LT_SLASH,
    STATE(94), 1,
      sym_end_tag,
  [4276] = 1,
    ACTIONS(493), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [4281] = 2,
    ACTIONS(49), 1,
      anon_sym_LT_SLASH,
    STATE(95), 1,
      sym_end_tag,
  [4288] = 2,
    ACTIONS(495), 1,
      anon_sym_RBRACE,
    ACTIONS(497), 1,
      sym_raw_text_expr,
  [4295] = 2,
    ACTIONS(499), 1,
      anon_sym_RBRACE,
    ACTIONS(501), 1,
      sym_raw_text_expr,
  [4302] = 1,
    ACTIONS(503), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [4307] = 2,
    ACTIONS(505), 1,
      anon_sym_RBRACE,
    ACTIONS(507), 1,
      sym_raw_text_expr,
  [4314] = 2,
    ACTIONS(509), 1,
      anon_sym_RBRACE,
    ACTIONS(511), 1,
      sym_raw_text_expr,
  [4321] = 1,
    ACTIONS(513), 1,
      anon_sym_if,
  [4325] = 1,
    ACTIONS(515), 1,
      anon_sym_RBRACE,
  [4329] = 1,
    ACTIONS(517), 1,
      sym_raw_text_expr,
  [4333] = 1,
    ACTIONS(473), 1,
      anon_sym_catch,
  [4337] = 1,
    ACTIONS(519), 1,
      anon_sym_RBRACE,
  [4341] = 1,
    ACTIONS(521), 1,
      anon_sym_RBRACE,
  [4345] = 1,
    ACTIONS(523), 1,
      anon_sym_RBRACE,
  [4349] = 1,
    ACTIONS(525), 1,
      sym_raw_text_expr,
  [4353] = 1,
    ACTIONS(489), 1,
      anon_sym_RBRACE,
  [4357] = 1,
    ACTIONS(527), 1,
      anon_sym_RBRACE,
  [4361] = 1,
    ACTIONS(529), 1,
      sym_raw_text_expr,
  [4365] = 1,
    ACTIONS(531), 1,
      sym_raw_text_expr,
  [4369] = 1,
    ACTIONS(533), 1,
      anon_sym_RBRACE,
  [4373] = 1,
    ACTIONS(535), 1,
      anon_sym_GT,
  [4377] = 1,
    ACTIONS(537), 1,
      sym__end_tag_name,
  [4381] = 1,
    ACTIONS(539), 1,
      anon_sym_then,
  [4385] = 1,
    ACTIONS(541), 1,
      anon_sym_else,
  [4389] = 1,
    ACTIONS(543), 1,
      anon_sym_html,
  [4393] = 1,
    ACTIONS(545), 1,
      anon_sym_else,
  [4397] = 1,
    ACTIONS(547), 1,
      anon_sym_GT,
  [4401] = 1,
    ACTIONS(549), 1,
      anon_sym_RBRACE,
  [4405] = 1,
    ACTIONS(551), 1,
      anon_sym_each,
  [4409] = 1,
    ACTIONS(553), 1,
      anon_sym_await,
  [4413] = 1,
    ACTIONS(555), 1,
      anon_sym_RBRACE,
  [4417] = 1,
    ACTIONS(557), 1,
      ts_builtin_sym_end,
  [4421] = 1,
    ACTIONS(559), 1,
      anon_sym_key,
  [4425] = 1,
    ACTIONS(561), 1,
      anon_sym_RBRACE,
  [4429] = 1,
    ACTIONS(563), 1,
      anon_sym_RBRACE,
  [4433] = 1,
    ACTIONS(565), 1,
      anon_sym_RBRACE,
  [4437] = 1,
    ACTIONS(567), 1,
      anon_sym_RBRACE,
  [4441] = 1,
    ACTIONS(569), 1,
      anon_sym_RBRACE,
  [4445] = 1,
    ACTIONS(571), 1,
      anon_sym_RBRACE,
  [4449] = 1,
    ACTIONS(573), 1,
      anon_sym_RBRACE,
  [4453] = 1,
    ACTIONS(575), 1,
      anon_sym_SQUOTE,
  [4457] = 1,
    ACTIONS(575), 1,
      anon_sym_DQUOTE,
  [4461] = 1,
    ACTIONS(577), 1,
      anon_sym_RBRACE,
  [4465] = 1,
    ACTIONS(579), 1,
      anon_sym_RBRACE,
  [4469] = 1,
    ACTIONS(581), 1,
      anon_sym_RBRACE,
  [4473] = 1,
    ACTIONS(583), 1,
      anon_sym_DQUOTE,
  [4477] = 1,
    ACTIONS(585), 1,
      anon_sym_html,
  [4481] = 1,
    ACTIONS(587), 1,
      sym__end_tag_name,
  [4485] = 1,
    ACTIONS(589), 1,
      sym_raw_text_expr,
  [4489] = 1,
    ACTIONS(591), 1,
      anon_sym_if,
  [4493] = 1,
    ACTIONS(583), 1,
      anon_sym_SQUOTE,
  [4497] = 1,
    ACTIONS(593), 1,
      anon_sym_each,
  [4501] = 1,
    ACTIONS(595), 1,
      anon_sym_RBRACE,
  [4505] = 1,
    ACTIONS(597), 1,
      anon_sym_await,
  [4509] = 1,
    ACTIONS(599), 1,
      anon_sym_as,
  [4513] = 1,
    ACTIONS(601), 1,
      anon_sym_RBRACE,
  [4517] = 1,
    ACTIONS(603), 1,
      anon_sym_key,
  [4521] = 1,
    ACTIONS(605), 1,
      anon_sym_RBRACE,
  [4525] = 1,
    ACTIONS(607), 1,
      anon_sym_RBRACE,
  [4529] = 1,
    ACTIONS(609), 1,
      anon_sym_RBRACE,
  [4533] = 1,
    ACTIONS(611), 1,
      sym_raw_text_expr,
};

static uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 63,
  [SMALL_STATE(4)] = 126,
  [SMALL_STATE(5)] = 189,
  [SMALL_STATE(6)] = 252,
  [SMALL_STATE(7)] = 315,
  [SMALL_STATE(8)] = 378,
  [SMALL_STATE(9)] = 441,
  [SMALL_STATE(10)] = 504,
  [SMALL_STATE(11)] = 567,
  [SMALL_STATE(12)] = 630,
  [SMALL_STATE(13)] = 693,
  [SMALL_STATE(14)] = 756,
  [SMALL_STATE(15)] = 815,
  [SMALL_STATE(16)] = 876,
  [SMALL_STATE(17)] = 935,
  [SMALL_STATE(18)] = 994,
  [SMALL_STATE(19)] = 1055,
  [SMALL_STATE(20)] = 1114,
  [SMALL_STATE(21)] = 1173,
  [SMALL_STATE(22)] = 1232,
  [SMALL_STATE(23)] = 1291,
  [SMALL_STATE(24)] = 1352,
  [SMALL_STATE(25)] = 1411,
  [SMALL_STATE(26)] = 1472,
  [SMALL_STATE(27)] = 1528,
  [SMALL_STATE(28)] = 1583,
  [SMALL_STATE(29)] = 1638,
  [SMALL_STATE(30)] = 1693,
  [SMALL_STATE(31)] = 1748,
  [SMALL_STATE(32)] = 1803,
  [SMALL_STATE(33)] = 1858,
  [SMALL_STATE(34)] = 1913,
  [SMALL_STATE(35)] = 1968,
  [SMALL_STATE(36)] = 2023,
  [SMALL_STATE(37)] = 2078,
  [SMALL_STATE(38)] = 2133,
  [SMALL_STATE(39)] = 2188,
  [SMALL_STATE(40)] = 2243,
  [SMALL_STATE(41)] = 2298,
  [SMALL_STATE(42)] = 2353,
  [SMALL_STATE(43)] = 2408,
  [SMALL_STATE(44)] = 2463,
  [SMALL_STATE(45)] = 2518,
  [SMALL_STATE(46)] = 2541,
  [SMALL_STATE(47)] = 2562,
  [SMALL_STATE(48)] = 2583,
  [SMALL_STATE(49)] = 2606,
  [SMALL_STATE(50)] = 2627,
  [SMALL_STATE(51)] = 2650,
  [SMALL_STATE(52)] = 2673,
  [SMALL_STATE(53)] = 2685,
  [SMALL_STATE(54)] = 2705,
  [SMALL_STATE(55)] = 2717,
  [SMALL_STATE(56)] = 2737,
  [SMALL_STATE(57)] = 2749,
  [SMALL_STATE(58)] = 2761,
  [SMALL_STATE(59)] = 2773,
  [SMALL_STATE(60)] = 2785,
  [SMALL_STATE(61)] = 2797,
  [SMALL_STATE(62)] = 2817,
  [SMALL_STATE(63)] = 2829,
  [SMALL_STATE(64)] = 2841,
  [SMALL_STATE(65)] = 2853,
  [SMALL_STATE(66)] = 2873,
  [SMALL_STATE(67)] = 2885,
  [SMALL_STATE(68)] = 2897,
  [SMALL_STATE(69)] = 2909,
  [SMALL_STATE(70)] = 2921,
  [SMALL_STATE(71)] = 2933,
  [SMALL_STATE(72)] = 2945,
  [SMALL_STATE(73)] = 2957,
  [SMALL_STATE(74)] = 2969,
  [SMALL_STATE(75)] = 2981,
  [SMALL_STATE(76)] = 2993,
  [SMALL_STATE(77)] = 3005,
  [SMALL_STATE(78)] = 3017,
  [SMALL_STATE(79)] = 3029,
  [SMALL_STATE(80)] = 3041,
  [SMALL_STATE(81)] = 3053,
  [SMALL_STATE(82)] = 3065,
  [SMALL_STATE(83)] = 3077,
  [SMALL_STATE(84)] = 3089,
  [SMALL_STATE(85)] = 3101,
  [SMALL_STATE(86)] = 3113,
  [SMALL_STATE(87)] = 3125,
  [SMALL_STATE(88)] = 3137,
  [SMALL_STATE(89)] = 3149,
  [SMALL_STATE(90)] = 3161,
  [SMALL_STATE(91)] = 3173,
  [SMALL_STATE(92)] = 3193,
  [SMALL_STATE(93)] = 3205,
  [SMALL_STATE(94)] = 3217,
  [SMALL_STATE(95)] = 3228,
  [SMALL_STATE(96)] = 3239,
  [SMALL_STATE(97)] = 3250,
  [SMALL_STATE(98)] = 3261,
  [SMALL_STATE(99)] = 3272,
  [SMALL_STATE(100)] = 3283,
  [SMALL_STATE(101)] = 3294,
  [SMALL_STATE(102)] = 3305,
  [SMALL_STATE(103)] = 3316,
  [SMALL_STATE(104)] = 3327,
  [SMALL_STATE(105)] = 3338,
  [SMALL_STATE(106)] = 3349,
  [SMALL_STATE(107)] = 3360,
  [SMALL_STATE(108)] = 3371,
  [SMALL_STATE(109)] = 3382,
  [SMALL_STATE(110)] = 3393,
  [SMALL_STATE(111)] = 3404,
  [SMALL_STATE(112)] = 3415,
  [SMALL_STATE(113)] = 3426,
  [SMALL_STATE(114)] = 3437,
  [SMALL_STATE(115)] = 3448,
  [SMALL_STATE(116)] = 3459,
  [SMALL_STATE(117)] = 3470,
  [SMALL_STATE(118)] = 3481,
  [SMALL_STATE(119)] = 3492,
  [SMALL_STATE(120)] = 3503,
  [SMALL_STATE(121)] = 3514,
  [SMALL_STATE(122)] = 3525,
  [SMALL_STATE(123)] = 3536,
  [SMALL_STATE(124)] = 3547,
  [SMALL_STATE(125)] = 3558,
  [SMALL_STATE(126)] = 3569,
  [SMALL_STATE(127)] = 3580,
  [SMALL_STATE(128)] = 3591,
  [SMALL_STATE(129)] = 3602,
  [SMALL_STATE(130)] = 3612,
  [SMALL_STATE(131)] = 3622,
  [SMALL_STATE(132)] = 3632,
  [SMALL_STATE(133)] = 3642,
  [SMALL_STATE(134)] = 3652,
  [SMALL_STATE(135)] = 3662,
  [SMALL_STATE(136)] = 3672,
  [SMALL_STATE(137)] = 3682,
  [SMALL_STATE(138)] = 3692,
  [SMALL_STATE(139)] = 3702,
  [SMALL_STATE(140)] = 3712,
  [SMALL_STATE(141)] = 3720,
  [SMALL_STATE(142)] = 3736,
  [SMALL_STATE(143)] = 3752,
  [SMALL_STATE(144)] = 3768,
  [SMALL_STATE(145)] = 3784,
  [SMALL_STATE(146)] = 3800,
  [SMALL_STATE(147)] = 3816,
  [SMALL_STATE(148)] = 3832,
  [SMALL_STATE(149)] = 3842,
  [SMALL_STATE(150)] = 3852,
  [SMALL_STATE(151)] = 3862,
  [SMALL_STATE(152)] = 3878,
  [SMALL_STATE(153)] = 3891,
  [SMALL_STATE(154)] = 3898,
  [SMALL_STATE(155)] = 3911,
  [SMALL_STATE(156)] = 3924,
  [SMALL_STATE(157)] = 3931,
  [SMALL_STATE(158)] = 3944,
  [SMALL_STATE(159)] = 3957,
  [SMALL_STATE(160)] = 3964,
  [SMALL_STATE(161)] = 3971,
  [SMALL_STATE(162)] = 3978,
  [SMALL_STATE(163)] = 3991,
  [SMALL_STATE(164)] = 3998,
  [SMALL_STATE(165)] = 4005,
  [SMALL_STATE(166)] = 4012,
  [SMALL_STATE(167)] = 4021,
  [SMALL_STATE(168)] = 4034,
  [SMALL_STATE(169)] = 4047,
  [SMALL_STATE(170)] = 4060,
  [SMALL_STATE(171)] = 4066,
  [SMALL_STATE(172)] = 4076,
  [SMALL_STATE(173)] = 4086,
  [SMALL_STATE(174)] = 4096,
  [SMALL_STATE(175)] = 4102,
  [SMALL_STATE(176)] = 4112,
  [SMALL_STATE(177)] = 4122,
  [SMALL_STATE(178)] = 4128,
  [SMALL_STATE(179)] = 4138,
  [SMALL_STATE(180)] = 4144,
  [SMALL_STATE(181)] = 4150,
  [SMALL_STATE(182)] = 4160,
  [SMALL_STATE(183)] = 4170,
  [SMALL_STATE(184)] = 4176,
  [SMALL_STATE(185)] = 4182,
  [SMALL_STATE(186)] = 4189,
  [SMALL_STATE(187)] = 4196,
  [SMALL_STATE(188)] = 4203,
  [SMALL_STATE(189)] = 4210,
  [SMALL_STATE(190)] = 4215,
  [SMALL_STATE(191)] = 4222,
  [SMALL_STATE(192)] = 4229,
  [SMALL_STATE(193)] = 4236,
  [SMALL_STATE(194)] = 4241,
  [SMALL_STATE(195)] = 4248,
  [SMALL_STATE(196)] = 4255,
  [SMALL_STATE(197)] = 4262,
  [SMALL_STATE(198)] = 4269,
  [SMALL_STATE(199)] = 4276,
  [SMALL_STATE(200)] = 4281,
  [SMALL_STATE(201)] = 4288,
  [SMALL_STATE(202)] = 4295,
  [SMALL_STATE(203)] = 4302,
  [SMALL_STATE(204)] = 4307,
  [SMALL_STATE(205)] = 4314,
  [SMALL_STATE(206)] = 4321,
  [SMALL_STATE(207)] = 4325,
  [SMALL_STATE(208)] = 4329,
  [SMALL_STATE(209)] = 4333,
  [SMALL_STATE(210)] = 4337,
  [SMALL_STATE(211)] = 4341,
  [SMALL_STATE(212)] = 4345,
  [SMALL_STATE(213)] = 4349,
  [SMALL_STATE(214)] = 4353,
  [SMALL_STATE(215)] = 4357,
  [SMALL_STATE(216)] = 4361,
  [SMALL_STATE(217)] = 4365,
  [SMALL_STATE(218)] = 4369,
  [SMALL_STATE(219)] = 4373,
  [SMALL_STATE(220)] = 4377,
  [SMALL_STATE(221)] = 4381,
  [SMALL_STATE(222)] = 4385,
  [SMALL_STATE(223)] = 4389,
  [SMALL_STATE(224)] = 4393,
  [SMALL_STATE(225)] = 4397,
  [SMALL_STATE(226)] = 4401,
  [SMALL_STATE(227)] = 4405,
  [SMALL_STATE(228)] = 4409,
  [SMALL_STATE(229)] = 4413,
  [SMALL_STATE(230)] = 4417,
  [SMALL_STATE(231)] = 4421,
  [SMALL_STATE(232)] = 4425,
  [SMALL_STATE(233)] = 4429,
  [SMALL_STATE(234)] = 4433,
  [SMALL_STATE(235)] = 4437,
  [SMALL_STATE(236)] = 4441,
  [SMALL_STATE(237)] = 4445,
  [SMALL_STATE(238)] = 4449,
  [SMALL_STATE(239)] = 4453,
  [SMALL_STATE(240)] = 4457,
  [SMALL_STATE(241)] = 4461,
  [SMALL_STATE(242)] = 4465,
  [SMALL_STATE(243)] = 4469,
  [SMALL_STATE(244)] = 4473,
  [SMALL_STATE(245)] = 4477,
  [SMALL_STATE(246)] = 4481,
  [SMALL_STATE(247)] = 4485,
  [SMALL_STATE(248)] = 4489,
  [SMALL_STATE(249)] = 4493,
  [SMALL_STATE(250)] = 4497,
  [SMALL_STATE(251)] = 4501,
  [SMALL_STATE(252)] = 4505,
  [SMALL_STATE(253)] = 4509,
  [SMALL_STATE(254)] = 4513,
  [SMALL_STATE(255)] = 4517,
  [SMALL_STATE(256)] = 4521,
  [SMALL_STATE(257)] = 4525,
  [SMALL_STATE(258)] = 4529,
  [SMALL_STATE(259)] = 4533,
};

static TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(144),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(147),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [71] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(182),
  [74] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2),
  [76] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(26),
  [79] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(178),
  [82] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(171),
  [85] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(27),
  [88] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(181),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [93] = {.entry = {.count = 1, .reusable = false}}, SHIFT(157),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [97] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(158),
  [121] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 1),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2),
  [135] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(140),
  [138] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(213),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [163] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_end_expr, 4),
  [165] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_end_expr, 4),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_then_statement, 3),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_then_statement, 3),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [177] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_each_statement, 3),
  [179] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_each_statement, 3),
  [181] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_statement, 3),
  [183] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_statement, 3),
  [185] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_statement, 3),
  [187] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 3),
  [189] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_end_tag, 3),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_end_tag, 3),
  [193] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_html_expr, 4),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_html_expr, 4),
  [197] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(153),
  [200] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(247),
  [203] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_self_closing_tag, 4),
  [205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_self_closing_tag, 4),
  [207] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_statement, 3),
  [209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_statement, 3),
  [211] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_statement, 3),
  [213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_statement, 3),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [217] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch_statement, 2),
  [219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch_statement, 2),
  [221] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_then_statement, 2),
  [223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_then_statement, 2),
  [225] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_statement, 3),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_statement, 3),
  [229] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_each_statement, 2),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_each_statement, 2),
  [233] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch_statement, 3),
  [235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch_statement, 3),
  [237] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 3),
  [239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 3),
  [241] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_html_expr, 5),
  [243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_html_expr, 5),
  [245] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_statement, 2),
  [247] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_statement, 2),
  [249] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_statement, 2),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 2),
  [253] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_element, 3),
  [255] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_element, 3),
  [257] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_element, 3),
  [259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_element, 3),
  [261] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 3),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 3),
  [265] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_end_expr, 4),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_end_expr, 4),
  [269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 3),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 3),
  [273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_self_closing_tag, 3),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_self_closing_tag, 3),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_end_expr, 4),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_end_expr, 4),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_statement, 2),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_statement, 2),
  [285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_statement, 2),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_statement, 2),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_end_expr, 4),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_end_expr, 4),
  [293] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_statement, 2),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_statement, 2),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 2),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 2),
  [301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_tag, 3),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_tag, 3),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_element, 2),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_element, 2),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_element, 2),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_element, 2),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 2),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 2),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [319] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_tag, 4),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_tag, 4),
  [323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 1),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 1),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_start_expr, 5),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_start_expr, 5),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_expr, 6),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_expr, 6),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_start_expr, 5),
  [337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_start_expr, 5),
  [339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_expr, 4),
  [341] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_expr, 4),
  [343] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_start_expr, 5),
  [345] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_start_expr, 5),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_start_expr, 5),
  [349] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_start_expr, 5),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_start_expr, 7, .production_id = 2),
  [353] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_start_expr, 7, .production_id = 2),
  [355] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_start_expr, 7),
  [357] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_start_expr, 7),
  [359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_then_expr, 4),
  [361] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_then_expr, 4),
  [363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1),
  [365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [367] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch_expr, 4),
  [369] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch_expr, 4),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_name, 1),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_expr, 5),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_expr, 5),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_then_expr, 5),
  [405] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_then_expr, 5),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch_expr, 5),
  [409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch_expr, 5),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [413] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_attribute_value, 2),
  [415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_value, 1),
  [417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1, .production_id = 1),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [421] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 3),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr_attribute_value, 1),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_attribute_value, 3),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [465] = {.entry = {.count = 1, .reusable = false}}, SHIFT(159),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [469] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_start_tag, 3),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [479] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [483] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_start_tag, 3),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_start_tag, 4),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [503] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_start_tag, 4),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [557] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_svelte_external_scanner_create(void);
void tree_sitter_svelte_external_scanner_destroy(void *);
bool tree_sitter_svelte_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_svelte_external_scanner_serialize(void *, char *);
void tree_sitter_svelte_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_svelte(void) {
  static TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = (const uint16_t *)ts_parse_table,
    .small_parse_table = (const uint16_t *)ts_small_parse_table,
    .small_parse_table_map = (const uint32_t *)ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = (const TSSymbol *)ts_alias_sequences,
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      (const bool *)ts_external_scanner_states,
      ts_external_scanner_symbol_map,
      tree_sitter_svelte_external_scanner_create,
      tree_sitter_svelte_external_scanner_destroy,
      tree_sitter_svelte_external_scanner_scan,
      tree_sitter_svelte_external_scanner_serialize,
      tree_sitter_svelte_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
