#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 322
#define LARGE_STATE_COUNT 41
#define SYMBOL_COUNT 209
#define ALIAS_COUNT 0
#define TOKEN_COUNT 143
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 13
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 25

enum {
  sym_identifier = 1,
  anon_sym_SLASH_SLASH = 2,
  aux_sym_comment_token1 = 3,
  anon_sym_SEMI = 4,
  anon_sym_EQ = 5,
  anon_sym_let = 6,
  anon_sym_type = 7,
  anon_sym_LPAREN = 8,
  anon_sym_COMMA = 9,
  anon_sym_RPAREN = 10,
  anon_sym_fn = 11,
  anon_sym_DASH_GT = 12,
  anon_sym_struct = 13,
  anon_sym_LBRACE = 14,
  anon_sym_RBRACE = 15,
  anon_sym_enable = 16,
  anon_sym_LBRACK_LBRACK = 17,
  anon_sym_RBRACK_RBRACK = 18,
  anon_sym_if = 19,
  anon_sym_elseif = 20,
  anon_sym_else = 21,
  anon_sym_switch = 22,
  anon_sym_case = 23,
  anon_sym_COLON = 24,
  anon_sym_default = 25,
  anon_sym_fallthrough = 26,
  anon_sym_loop = 27,
  anon_sym_for = 28,
  anon_sym_break = 29,
  anon_sym_continue = 30,
  anon_sym_continuing = 31,
  anon_sym_return = 32,
  anon_sym_discard = 33,
  anon_sym_var = 34,
  anon_sym_LT = 35,
  anon_sym_GT = 36,
  sym_int_literal = 37,
  sym_uint_literal = 38,
  aux_sym_float_literal_token1 = 39,
  aux_sym_float_literal_token2 = 40,
  sym_true = 41,
  sym_false = 42,
  anon_sym_bool = 43,
  anon_sym_u32 = 44,
  anon_sym_i32 = 45,
  anon_sym_f32 = 46,
  anon_sym_vec2 = 47,
  anon_sym_vec3 = 48,
  anon_sym_vec4 = 49,
  anon_sym_mat2x2 = 50,
  anon_sym_mat2x3 = 51,
  anon_sym_mat2x4 = 52,
  anon_sym_mat3x2 = 53,
  anon_sym_mat3x3 = 54,
  anon_sym_mat3x4 = 55,
  anon_sym_mat4x2 = 56,
  anon_sym_mat4x3 = 57,
  anon_sym_mat4x4 = 58,
  anon_sym_atomic = 59,
  anon_sym_array = 60,
  anon_sym_ptr = 61,
  anon_sym_sampler = 62,
  anon_sym_sampler_comparison = 63,
  anon_sym_texture_depth_2d = 64,
  anon_sym_texture_depth_2d_array = 65,
  anon_sym_texture_depth_cube = 66,
  anon_sym_texture_depth_cube_array = 67,
  anon_sym_texture_depth_multisampled_2d = 68,
  anon_sym_texture_1d = 69,
  anon_sym_texture_2d = 70,
  anon_sym_texture_2d_array = 71,
  anon_sym_texture_3d = 72,
  anon_sym_texture_cube = 73,
  anon_sym_texture_cube_array = 74,
  anon_sym_texture_multisampled_2d = 75,
  anon_sym_texture_storage_1d = 76,
  anon_sym_texture_storage_2d = 77,
  anon_sym_texture_storage_2d_array = 78,
  anon_sym_texture_storage_3d = 79,
  anon_sym_r8unorm = 80,
  anon_sym_r8snorm = 81,
  anon_sym_r8uint = 82,
  anon_sym_r8sint = 83,
  anon_sym_rg8unorm = 84,
  anon_sym_rg8snorm = 85,
  anon_sym_rg8uint = 86,
  anon_sym_rg8sint = 87,
  anon_sym_r16uint = 88,
  anon_sym_r16sint = 89,
  anon_sym_r16float = 90,
  anon_sym_rg16uint = 91,
  anon_sym_rg16sint = 92,
  anon_sym_rg16float = 93,
  anon_sym_rgba16uint = 94,
  anon_sym_rgba16sint = 95,
  anon_sym_rgba16float = 96,
  anon_sym_r32uint = 97,
  anon_sym_r32sint = 98,
  anon_sym_r32float = 99,
  anon_sym_rg32uint = 100,
  anon_sym_rg32sint = 101,
  anon_sym_rg32float = 102,
  anon_sym_rgba32uint = 103,
  anon_sym_rgba32sint = 104,
  anon_sym_rgba32float = 105,
  anon_sym_rgba8unorm = 106,
  anon_sym_rgba8unorm_srgb = 107,
  anon_sym_rgba8snorm = 108,
  anon_sym_rgba8uint = 109,
  anon_sym_rgba8sint = 110,
  anon_sym_rg10a2unorm = 111,
  anon_sym_rg11b10float = 112,
  anon_sym_function = 113,
  anon_sym_private = 114,
  anon_sym_workgroup = 115,
  anon_sym_uniform = 116,
  anon_sym_storage = 117,
  anon_sym_read = 118,
  anon_sym_write = 119,
  anon_sym_read_write = 120,
  anon_sym_bitcast = 121,
  anon_sym_PIPE_PIPE = 122,
  anon_sym_AMP_AMP = 123,
  anon_sym_PIPE = 124,
  anon_sym_CARET = 125,
  anon_sym_AMP = 126,
  anon_sym_EQ_EQ = 127,
  anon_sym_BANG_EQ = 128,
  anon_sym_LT_EQ = 129,
  anon_sym_GT_EQ = 130,
  anon_sym_LT_LT = 131,
  anon_sym_GT_GT = 132,
  anon_sym_PLUS = 133,
  anon_sym_DASH = 134,
  anon_sym_STAR = 135,
  anon_sym_SLASH = 136,
  anon_sym_PERCENT = 137,
  anon_sym_BANG = 138,
  anon_sym_TILDE = 139,
  anon_sym_LBRACK = 140,
  anon_sym_RBRACK = 141,
  anon_sym_DOT = 142,
  sym_source_file = 143,
  sym_comment = 144,
  sym__declaration = 145,
  sym_global_variable_declaration = 146,
  sym_global_constant_declaration = 147,
  sym_type_alias = 148,
  sym_const_expression = 149,
  sym_function_declaration = 150,
  sym_function_return_type_declaration = 151,
  sym_struct_declaration = 152,
  sym_struct_member_list = 153,
  sym_struct_member = 154,
  sym_enable_directive = 155,
  sym_attribute_list = 156,
  sym_attribute = 157,
  sym_literal_or_identifier = 158,
  sym_parameter_list = 159,
  sym_parameter = 160,
  sym__statement = 161,
  sym_compound_statement = 162,
  sym_assignment_statement = 163,
  sym_if_statement = 164,
  sym_elseif_statement = 165,
  sym_else_statement = 166,
  sym_switch_statement = 167,
  sym_switch_body = 168,
  sym_case_selectors = 169,
  sym_case_body = 170,
  sym_loop_statement = 171,
  sym_for_statement = 172,
  sym_for_header = 173,
  sym_break_statement = 174,
  sym_continue_statement = 175,
  sym_continuing_statement = 176,
  sym_return_statement = 177,
  sym_discard_statement = 178,
  sym_variable_statement = 179,
  sym_variable_declaration = 180,
  sym_variable_qualifier = 181,
  sym_variable_identifier_declaration = 182,
  sym__expression = 183,
  sym_const_literal = 184,
  sym_float_literal = 185,
  sym_parenthesized_expression = 186,
  sym_type_constructor_or_function_call_expression = 187,
  sym_type_declaration = 188,
  sym_texel_format = 189,
  sym_storage_class = 190,
  sym_access_mode = 191,
  sym_argument_list_expression = 192,
  sym_bitcast_expression = 193,
  sym_binary_expression = 194,
  sym_unary_expression = 195,
  sym_subscript_expression = 196,
  sym_composite_value_decomposition_expression = 197,
  aux_sym_source_file_repeat1 = 198,
  aux_sym_global_variable_declaration_repeat1 = 199,
  aux_sym_const_expression_repeat1 = 200,
  aux_sym_struct_member_list_repeat1 = 201,
  aux_sym_attribute_list_repeat1 = 202,
  aux_sym_parameter_list_repeat1 = 203,
  aux_sym_compound_statement_repeat1 = 204,
  aux_sym_if_statement_repeat1 = 205,
  aux_sym_switch_statement_repeat1 = 206,
  aux_sym_case_selectors_repeat1 = 207,
  aux_sym_argument_list_expression_repeat1 = 208,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SLASH_SLASH] = "//",
  [aux_sym_comment_token1] = "comment_token1",
  [anon_sym_SEMI] = ";",
  [anon_sym_EQ] = "=",
  [anon_sym_let] = "let",
  [anon_sym_type] = "type",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_fn] = "fn",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_struct] = "struct",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_enable] = "enable",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_if] = "if",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_COLON] = ":",
  [anon_sym_default] = "default",
  [anon_sym_fallthrough] = "fallthrough",
  [anon_sym_loop] = "loop",
  [anon_sym_for] = "for",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_continuing] = "continuing",
  [anon_sym_return] = "return",
  [anon_sym_discard] = "discard",
  [anon_sym_var] = "var",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [sym_int_literal] = "int_literal",
  [sym_uint_literal] = "uint_literal",
  [aux_sym_float_literal_token1] = "float_literal_token1",
  [aux_sym_float_literal_token2] = "float_literal_token2",
  [sym_true] = "true",
  [sym_false] = "false",
  [anon_sym_bool] = "bool",
  [anon_sym_u32] = "u32",
  [anon_sym_i32] = "i32",
  [anon_sym_f32] = "f32",
  [anon_sym_vec2] = "vec2",
  [anon_sym_vec3] = "vec3",
  [anon_sym_vec4] = "vec4",
  [anon_sym_mat2x2] = "mat2x2",
  [anon_sym_mat2x3] = "mat2x3",
  [anon_sym_mat2x4] = "mat2x4",
  [anon_sym_mat3x2] = "mat3x2",
  [anon_sym_mat3x3] = "mat3x3",
  [anon_sym_mat3x4] = "mat3x4",
  [anon_sym_mat4x2] = "mat4x2",
  [anon_sym_mat4x3] = "mat4x3",
  [anon_sym_mat4x4] = "mat4x4",
  [anon_sym_atomic] = "atomic",
  [anon_sym_array] = "array",
  [anon_sym_ptr] = "ptr",
  [anon_sym_sampler] = "sampler",
  [anon_sym_sampler_comparison] = "sampler_comparison",
  [anon_sym_texture_depth_2d] = "texture_depth_2d",
  [anon_sym_texture_depth_2d_array] = "texture_depth_2d_array",
  [anon_sym_texture_depth_cube] = "texture_depth_cube",
  [anon_sym_texture_depth_cube_array] = "texture_depth_cube_array",
  [anon_sym_texture_depth_multisampled_2d] = "texture_depth_multisampled_2d",
  [anon_sym_texture_1d] = "texture_1d",
  [anon_sym_texture_2d] = "texture_2d",
  [anon_sym_texture_2d_array] = "texture_2d_array",
  [anon_sym_texture_3d] = "texture_3d",
  [anon_sym_texture_cube] = "texture_cube",
  [anon_sym_texture_cube_array] = "texture_cube_array",
  [anon_sym_texture_multisampled_2d] = "texture_multisampled_2d",
  [anon_sym_texture_storage_1d] = "texture_storage_1d",
  [anon_sym_texture_storage_2d] = "texture_storage_2d",
  [anon_sym_texture_storage_2d_array] = "texture_storage_2d_array",
  [anon_sym_texture_storage_3d] = "texture_storage_3d",
  [anon_sym_r8unorm] = "r8unorm",
  [anon_sym_r8snorm] = "r8snorm",
  [anon_sym_r8uint] = "r8uint",
  [anon_sym_r8sint] = "r8sint",
  [anon_sym_rg8unorm] = "rg8unorm",
  [anon_sym_rg8snorm] = "rg8snorm",
  [anon_sym_rg8uint] = "rg8uint",
  [anon_sym_rg8sint] = "rg8sint",
  [anon_sym_r16uint] = "r16uint",
  [anon_sym_r16sint] = "r16sint",
  [anon_sym_r16float] = "r16float",
  [anon_sym_rg16uint] = "rg16uint",
  [anon_sym_rg16sint] = "rg16sint",
  [anon_sym_rg16float] = "rg16float",
  [anon_sym_rgba16uint] = "rgba16uint",
  [anon_sym_rgba16sint] = "rgba16sint",
  [anon_sym_rgba16float] = "rgba16float",
  [anon_sym_r32uint] = "r32uint",
  [anon_sym_r32sint] = "r32sint",
  [anon_sym_r32float] = "r32float",
  [anon_sym_rg32uint] = "rg32uint",
  [anon_sym_rg32sint] = "rg32sint",
  [anon_sym_rg32float] = "rg32float",
  [anon_sym_rgba32uint] = "rgba32uint",
  [anon_sym_rgba32sint] = "rgba32sint",
  [anon_sym_rgba32float] = "rgba32float",
  [anon_sym_rgba8unorm] = "rgba8unorm",
  [anon_sym_rgba8unorm_srgb] = "rgba8unorm_srgb",
  [anon_sym_rgba8snorm] = "rgba8snorm",
  [anon_sym_rgba8uint] = "rgba8uint",
  [anon_sym_rgba8sint] = "rgba8sint",
  [anon_sym_rg10a2unorm] = "rg10a2unorm",
  [anon_sym_rg11b10float] = "rg11b10float",
  [anon_sym_function] = "function",
  [anon_sym_private] = "private",
  [anon_sym_workgroup] = "workgroup",
  [anon_sym_uniform] = "uniform",
  [anon_sym_storage] = "storage",
  [anon_sym_read] = "read",
  [anon_sym_write] = "write",
  [anon_sym_read_write] = "read_write",
  [anon_sym_bitcast] = "bitcast",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [sym_source_file] = "source_file",
  [sym_comment] = "comment",
  [sym__declaration] = "_declaration",
  [sym_global_variable_declaration] = "global_variable_declaration",
  [sym_global_constant_declaration] = "global_constant_declaration",
  [sym_type_alias] = "type_alias",
  [sym_const_expression] = "const_expression",
  [sym_function_declaration] = "function_declaration",
  [sym_function_return_type_declaration] = "function_return_type_declaration",
  [sym_struct_declaration] = "struct_declaration",
  [sym_struct_member_list] = "struct_member_list",
  [sym_struct_member] = "struct_member",
  [sym_enable_directive] = "enable_directive",
  [sym_attribute_list] = "attribute_list",
  [sym_attribute] = "attribute",
  [sym_literal_or_identifier] = "literal_or_identifier",
  [sym_parameter_list] = "parameter_list",
  [sym_parameter] = "parameter",
  [sym__statement] = "_statement",
  [sym_compound_statement] = "compound_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym_if_statement] = "if_statement",
  [sym_elseif_statement] = "elseif_statement",
  [sym_else_statement] = "else_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_body] = "switch_body",
  [sym_case_selectors] = "case_selectors",
  [sym_case_body] = "case_body",
  [sym_loop_statement] = "loop_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_header] = "for_header",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_continuing_statement] = "continuing_statement",
  [sym_return_statement] = "return_statement",
  [sym_discard_statement] = "discard_statement",
  [sym_variable_statement] = "variable_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_variable_qualifier] = "variable_qualifier",
  [sym_variable_identifier_declaration] = "variable_identifier_declaration",
  [sym__expression] = "_expression",
  [sym_const_literal] = "const_literal",
  [sym_float_literal] = "float_literal",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_type_constructor_or_function_call_expression] = "type_constructor_or_function_call_expression",
  [sym_type_declaration] = "type_declaration",
  [sym_texel_format] = "texel_format",
  [sym_storage_class] = "storage_class",
  [sym_access_mode] = "access_mode",
  [sym_argument_list_expression] = "argument_list_expression",
  [sym_bitcast_expression] = "bitcast_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_composite_value_decomposition_expression] = "composite_value_decomposition_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_global_variable_declaration_repeat1] = "global_variable_declaration_repeat1",
  [aux_sym_const_expression_repeat1] = "const_expression_repeat1",
  [aux_sym_struct_member_list_repeat1] = "struct_member_list_repeat1",
  [aux_sym_attribute_list_repeat1] = "attribute_list_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_compound_statement_repeat1] = "compound_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym_case_selectors_repeat1] = "case_selectors_repeat1",
  [aux_sym_argument_list_expression_repeat1] = "argument_list_expression_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_enable] = anon_sym_enable,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_fallthrough] = anon_sym_fallthrough,
  [anon_sym_loop] = anon_sym_loop,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_continuing] = anon_sym_continuing,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_discard] = anon_sym_discard,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [sym_int_literal] = sym_int_literal,
  [sym_uint_literal] = sym_uint_literal,
  [aux_sym_float_literal_token1] = aux_sym_float_literal_token1,
  [aux_sym_float_literal_token2] = aux_sym_float_literal_token2,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_u32] = anon_sym_u32,
  [anon_sym_i32] = anon_sym_i32,
  [anon_sym_f32] = anon_sym_f32,
  [anon_sym_vec2] = anon_sym_vec2,
  [anon_sym_vec3] = anon_sym_vec3,
  [anon_sym_vec4] = anon_sym_vec4,
  [anon_sym_mat2x2] = anon_sym_mat2x2,
  [anon_sym_mat2x3] = anon_sym_mat2x3,
  [anon_sym_mat2x4] = anon_sym_mat2x4,
  [anon_sym_mat3x2] = anon_sym_mat3x2,
  [anon_sym_mat3x3] = anon_sym_mat3x3,
  [anon_sym_mat3x4] = anon_sym_mat3x4,
  [anon_sym_mat4x2] = anon_sym_mat4x2,
  [anon_sym_mat4x3] = anon_sym_mat4x3,
  [anon_sym_mat4x4] = anon_sym_mat4x4,
  [anon_sym_atomic] = anon_sym_atomic,
  [anon_sym_array] = anon_sym_array,
  [anon_sym_ptr] = anon_sym_ptr,
  [anon_sym_sampler] = anon_sym_sampler,
  [anon_sym_sampler_comparison] = anon_sym_sampler_comparison,
  [anon_sym_texture_depth_2d] = anon_sym_texture_depth_2d,
  [anon_sym_texture_depth_2d_array] = anon_sym_texture_depth_2d_array,
  [anon_sym_texture_depth_cube] = anon_sym_texture_depth_cube,
  [anon_sym_texture_depth_cube_array] = anon_sym_texture_depth_cube_array,
  [anon_sym_texture_depth_multisampled_2d] = anon_sym_texture_depth_multisampled_2d,
  [anon_sym_texture_1d] = anon_sym_texture_1d,
  [anon_sym_texture_2d] = anon_sym_texture_2d,
  [anon_sym_texture_2d_array] = anon_sym_texture_2d_array,
  [anon_sym_texture_3d] = anon_sym_texture_3d,
  [anon_sym_texture_cube] = anon_sym_texture_cube,
  [anon_sym_texture_cube_array] = anon_sym_texture_cube_array,
  [anon_sym_texture_multisampled_2d] = anon_sym_texture_multisampled_2d,
  [anon_sym_texture_storage_1d] = anon_sym_texture_storage_1d,
  [anon_sym_texture_storage_2d] = anon_sym_texture_storage_2d,
  [anon_sym_texture_storage_2d_array] = anon_sym_texture_storage_2d_array,
  [anon_sym_texture_storage_3d] = anon_sym_texture_storage_3d,
  [anon_sym_r8unorm] = anon_sym_r8unorm,
  [anon_sym_r8snorm] = anon_sym_r8snorm,
  [anon_sym_r8uint] = anon_sym_r8uint,
  [anon_sym_r8sint] = anon_sym_r8sint,
  [anon_sym_rg8unorm] = anon_sym_rg8unorm,
  [anon_sym_rg8snorm] = anon_sym_rg8snorm,
  [anon_sym_rg8uint] = anon_sym_rg8uint,
  [anon_sym_rg8sint] = anon_sym_rg8sint,
  [anon_sym_r16uint] = anon_sym_r16uint,
  [anon_sym_r16sint] = anon_sym_r16sint,
  [anon_sym_r16float] = anon_sym_r16float,
  [anon_sym_rg16uint] = anon_sym_rg16uint,
  [anon_sym_rg16sint] = anon_sym_rg16sint,
  [anon_sym_rg16float] = anon_sym_rg16float,
  [anon_sym_rgba16uint] = anon_sym_rgba16uint,
  [anon_sym_rgba16sint] = anon_sym_rgba16sint,
  [anon_sym_rgba16float] = anon_sym_rgba16float,
  [anon_sym_r32uint] = anon_sym_r32uint,
  [anon_sym_r32sint] = anon_sym_r32sint,
  [anon_sym_r32float] = anon_sym_r32float,
  [anon_sym_rg32uint] = anon_sym_rg32uint,
  [anon_sym_rg32sint] = anon_sym_rg32sint,
  [anon_sym_rg32float] = anon_sym_rg32float,
  [anon_sym_rgba32uint] = anon_sym_rgba32uint,
  [anon_sym_rgba32sint] = anon_sym_rgba32sint,
  [anon_sym_rgba32float] = anon_sym_rgba32float,
  [anon_sym_rgba8unorm] = anon_sym_rgba8unorm,
  [anon_sym_rgba8unorm_srgb] = anon_sym_rgba8unorm_srgb,
  [anon_sym_rgba8snorm] = anon_sym_rgba8snorm,
  [anon_sym_rgba8uint] = anon_sym_rgba8uint,
  [anon_sym_rgba8sint] = anon_sym_rgba8sint,
  [anon_sym_rg10a2unorm] = anon_sym_rg10a2unorm,
  [anon_sym_rg11b10float] = anon_sym_rg11b10float,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_workgroup] = anon_sym_workgroup,
  [anon_sym_uniform] = anon_sym_uniform,
  [anon_sym_storage] = anon_sym_storage,
  [anon_sym_read] = anon_sym_read,
  [anon_sym_write] = anon_sym_write,
  [anon_sym_read_write] = anon_sym_read_write,
  [anon_sym_bitcast] = anon_sym_bitcast,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_source_file] = sym_source_file,
  [sym_comment] = sym_comment,
  [sym__declaration] = sym__declaration,
  [sym_global_variable_declaration] = sym_global_variable_declaration,
  [sym_global_constant_declaration] = sym_global_constant_declaration,
  [sym_type_alias] = sym_type_alias,
  [sym_const_expression] = sym_const_expression,
  [sym_function_declaration] = sym_function_declaration,
  [sym_function_return_type_declaration] = sym_function_return_type_declaration,
  [sym_struct_declaration] = sym_struct_declaration,
  [sym_struct_member_list] = sym_struct_member_list,
  [sym_struct_member] = sym_struct_member,
  [sym_enable_directive] = sym_enable_directive,
  [sym_attribute_list] = sym_attribute_list,
  [sym_attribute] = sym_attribute,
  [sym_literal_or_identifier] = sym_literal_or_identifier,
  [sym_parameter_list] = sym_parameter_list,
  [sym_parameter] = sym_parameter,
  [sym__statement] = sym__statement,
  [sym_compound_statement] = sym_compound_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif_statement] = sym_elseif_statement,
  [sym_else_statement] = sym_else_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_case_selectors] = sym_case_selectors,
  [sym_case_body] = sym_case_body,
  [sym_loop_statement] = sym_loop_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_header] = sym_for_header,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_continuing_statement] = sym_continuing_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_discard_statement] = sym_discard_statement,
  [sym_variable_statement] = sym_variable_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_variable_qualifier] = sym_variable_qualifier,
  [sym_variable_identifier_declaration] = sym_variable_identifier_declaration,
  [sym__expression] = sym__expression,
  [sym_const_literal] = sym_const_literal,
  [sym_float_literal] = sym_float_literal,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_type_constructor_or_function_call_expression] = sym_type_constructor_or_function_call_expression,
  [sym_type_declaration] = sym_type_declaration,
  [sym_texel_format] = sym_texel_format,
  [sym_storage_class] = sym_storage_class,
  [sym_access_mode] = sym_access_mode,
  [sym_argument_list_expression] = sym_argument_list_expression,
  [sym_bitcast_expression] = sym_bitcast_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_composite_value_decomposition_expression] = sym_composite_value_decomposition_expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_global_variable_declaration_repeat1] = aux_sym_global_variable_declaration_repeat1,
  [aux_sym_const_expression_repeat1] = aux_sym_const_expression_repeat1,
  [aux_sym_struct_member_list_repeat1] = aux_sym_struct_member_list_repeat1,
  [aux_sym_attribute_list_repeat1] = aux_sym_attribute_list_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_compound_statement_repeat1] = aux_sym_compound_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym_case_selectors_repeat1] = aux_sym_case_selectors_repeat1,
  [aux_sym_argument_list_expression_repeat1] = aux_sym_argument_list_expression_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fallthrough] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_loop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continuing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_discard] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_uint_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_float_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_float_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_f32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vec2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vec3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vec4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mat2x2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mat2x3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mat2x4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mat3x2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mat3x3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mat3x4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mat4x2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mat4x3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mat4x4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_atomic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ptr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sampler] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sampler_comparison] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_depth_2d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_depth_2d_array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_depth_cube] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_depth_cube_array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_depth_multisampled_2d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_1d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_2d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_2d_array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_3d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_cube] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_cube_array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_multisampled_2d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_storage_1d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_storage_2d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_storage_2d_array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_texture_storage_3d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r8unorm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r8snorm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r8uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r8sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg8unorm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg8snorm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg8uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg8sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r16uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r16sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r16float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg16uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg16sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg16float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba16uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba16sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba16float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r32uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r32sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r32float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg32uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg32sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg32float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba32uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba32sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba32float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba8unorm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba8unorm_srgb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba8snorm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba8uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba8sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg10a2unorm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg11b10float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_workgroup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uniform] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_storage] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_read] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_write] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_read_write] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bitcast] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_global_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_global_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_const_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_function_return_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_member_list] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_member] = {
    .visible = true,
    .named = true,
  },
  [sym_enable_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_list] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_or_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_case_selectors] = {
    .visible = true,
    .named = true,
  },
  [sym_case_body] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_header] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continuing_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_discard_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_identifier_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_const_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_constructor_or_function_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_texel_format] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_class] = {
    .visible = true,
    .named = true,
  },
  [sym_access_mode] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitcast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_composite_value_decomposition_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_member_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_compound_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_selectors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_accessor = 1,
  field_alternative = 2,
  field_argument = 3,
  field_body = 4,
  field_condition = 5,
  field_consequence = 6,
  field_left = 7,
  field_name = 8,
  field_parameters = 9,
  field_right = 10,
  field_subscript = 11,
  field_type = 12,
  field_value = 13,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_accessor] = "accessor",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_left] = "left",
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_subscript] = "subscript",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 2},
  [5] = {.index = 7, .length = 2},
  [6] = {.index = 9, .length = 1},
  [7] = {.index = 10, .length = 3},
  [8] = {.index = 13, .length = 3},
  [9] = {.index = 16, .length = 2},
  [10] = {.index = 18, .length = 2},
  [11] = {.index = 20, .length = 1},
  [12] = {.index = 21, .length = 4},
  [13] = {.index = 25, .length = 3},
  [14] = {.index = 28, .length = 3},
  [15] = {.index = 31, .length = 2},
  [16] = {.index = 33, .length = 2},
  [17] = {.index = 35, .length = 2},
  [18] = {.index = 37, .length = 4},
  [19] = {.index = 41, .length = 1},
  [20] = {.index = 42, .length = 3},
  [21] = {.index = 45, .length = 3},
  [22] = {.index = 48, .length = 2},
  [23] = {.index = 50, .length = 4},
  [24] = {.index = 54, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
    {field_type, 2},
  [2] =
    {field_name, 1},
  [3] =
    {field_name, 0},
    {field_type, 3},
  [5] =
    {field_body, 4},
    {field_name, 1},
  [7] =
    {field_body, 3},
    {field_name, 1},
  [9] =
    {field_name, 2},
  [10] =
    {field_body, 5},
    {field_name, 1},
    {field_type, 4},
  [13] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 3},
  [16] =
    {field_body, 5},
    {field_name, 2},
  [18] =
    {field_body, 4},
    {field_name, 2},
  [20] =
    {field_argument, 1},
  [21] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 3},
    {field_type, 5},
  [25] =
    {field_body, 6},
    {field_name, 2},
    {field_type, 5},
  [28] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 4},
  [31] =
    {field_condition, 1},
    {field_consequence, 2},
  [33] =
    {field_left, 0},
    {field_right, 2},
  [35] =
    {field_accessor, 2},
    {field_value, 0},
  [37] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 4},
    {field_type, 6},
  [41] =
    {field_alternative, 0},
  [42] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [45] =
    {field_alternative, 3, .inherited = true},
    {field_condition, 1},
    {field_consequence, 2},
  [48] =
    {field_subscript, 2},
    {field_value, 0},
  [50] =
    {field_alternative, 3, .inherited = true},
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [54] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(22);
      if (lookahead == '!') ADVANCE(77);
      if (lookahead == '%') ADVANCE(75);
      if (lookahead == '&') ADVANCE(62);
      if (lookahead == '(') ADVANCE(31);
      if (lookahead == ')') ADVANCE(33);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == '+') ADVANCE(69);
      if (lookahead == ',') ADVANCE(32);
      if (lookahead == '-') ADVANCE(71);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '0') ADVANCE(44);
      if (lookahead == ':') ADVANCE(40);
      if (lookahead == ';') ADVANCE(28);
      if (lookahead == '<') ADVANCE(41);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(43);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == '^') ADVANCE(60);
      if (lookahead == '{') ADVANCE(35);
      if (lookahead == '|') ADVANCE(59);
      if (lookahead == '}') ADVANCE(36);
      if (lookahead == '~') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(45);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(39);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '%') ADVANCE(75);
      if (lookahead == '&') ADVANCE(62);
      if (lookahead == '(') ADVANCE(31);
      if (lookahead == ')') ADVANCE(33);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == '+') ADVANCE(69);
      if (lookahead == ',') ADVANCE(32);
      if (lookahead == '-') ADVANCE(70);
      if (lookahead == '.') ADVANCE(82);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == ':') ADVANCE(40);
      if (lookahead == ';') ADVANCE(28);
      if (lookahead == '<') ADVANCE(41);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(43);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == '^') ADVANCE(60);
      if (lookahead == '{') ADVANCE(35);
      if (lookahead == '|') ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1)
      END_STATE();
    case 2:
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(49);
      if (lookahead == '{') ADVANCE(35);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 3:
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == 'x') ADVANCE(6);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(4);
      END_STATE();
    case 4:
      if (lookahead == '.') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(4);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 6:
      if (lookahead == '.') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 7:
      if (lookahead == '/') ADVANCE(23);
      END_STATE();
    case 8:
      if (lookahead == '0') ADVANCE(12);
      if (lookahead == '>') ADVANCE(34);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 9:
      if (lookahead == '=') ADVANCE(64);
      END_STATE();
    case 10:
      if (lookahead == '[') ADVANCE(37);
      END_STATE();
    case 11:
      if (lookahead == ']') ADVANCE(38);
      END_STATE();
    case 12:
      if (lookahead == 'x') ADVANCE(20);
      END_STATE();
    case 13:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(55);
      END_STATE();
    case 14:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(56);
      END_STATE();
    case 15:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 16:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(54);
      END_STATE();
    case 17:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(55);
      END_STATE();
    case 18:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(56);
      END_STATE();
    case 19:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 20:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 21:
      if (eof) ADVANCE(22);
      if (lookahead == '!') ADVANCE(76);
      if (lookahead == '&') ADVANCE(61);
      if (lookahead == '(') ADVANCE(31);
      if (lookahead == ')') ADVANCE(33);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == ',') ADVANCE(32);
      if (lookahead == '-') ADVANCE(72);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(44);
      if (lookahead == ':') ADVANCE(40);
      if (lookahead == ';') ADVANCE(28);
      if (lookahead == '=') ADVANCE(29);
      if (lookahead == '>') ADVANCE(42);
      if (lookahead == '[') ADVANCE(10);
      if (lookahead == ']') ADVANCE(11);
      if (lookahead == '{') ADVANCE(35);
      if (lookahead == '}') ADVANCE(36);
      if (lookahead == '~') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(21)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(45);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(39);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(27);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '/') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(25);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(27);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(27);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(27);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(63);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(39);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(65);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(66);
      if (lookahead == '>') ADVANCE(68);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == 'u') ADVANCE(52);
      if (lookahead == 'x') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(4);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == 'u') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(45);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == 'u') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'x') ADVANCE(20);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_int_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_int_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_uint_literal);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_uint_literal);
      if (lookahead == 'u') ADVANCE(53);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(aux_sym_float_literal_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(54);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(aux_sym_float_literal_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(aux_sym_float_literal_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(56);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(57);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(58);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(3);
      if (lookahead == '>') ADVANCE(34);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(3);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(23);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(64);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(37);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(54);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'p') ADVANCE(10);
      if (lookahead == 'r') ADVANCE(11);
      if (lookahead == 's') ADVANCE(12);
      if (lookahead == 't') ADVANCE(13);
      if (lookahead == 'u') ADVANCE(14);
      if (lookahead == 'v') ADVANCE(15);
      if (lookahead == 'w') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'r') ADVANCE(17);
      if (lookahead == 't') ADVANCE(18);
      END_STATE();
    case 2:
      if (lookahead == 'i') ADVANCE(19);
      if (lookahead == 'o') ADVANCE(20);
      if (lookahead == 'r') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(24);
      if (lookahead == 'i') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(26);
      if (lookahead == 'n') ADVANCE(27);
      END_STATE();
    case 6:
      if (lookahead == '3') ADVANCE(28);
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      if (lookahead == 'u') ADVANCE(32);
      END_STATE();
    case 7:
      if (lookahead == '3') ADVANCE(33);
      if (lookahead == 'f') ADVANCE(34);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(37);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(38);
      if (lookahead == 't') ADVANCE(39);
      END_STATE();
    case 11:
      if (lookahead == '1') ADVANCE(40);
      if (lookahead == '3') ADVANCE(41);
      if (lookahead == '8') ADVANCE(42);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'g') ADVANCE(44);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(45);
      if (lookahead == 't') ADVANCE(46);
      if (lookahead == 'w') ADVANCE(47);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 14:
      if (lookahead == '3') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(52);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(53);
      if (lookahead == 'e') ADVANCE(54);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(55);
      if (lookahead == 'r') ADVANCE(56);
      END_STATE();
    case 17:
      if (lookahead == 'r') ADVANCE(57);
      END_STATE();
    case 18:
      if (lookahead == 'o') ADVANCE(58);
      END_STATE();
    case 19:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 20:
      if (lookahead == 'o') ADVANCE(60);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(62);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 24:
      if (lookahead == 'f') ADVANCE(64);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(65);
      END_STATE();
    case 26:
      if (lookahead == 's') ADVANCE(66);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 28:
      if (lookahead == '2') ADVANCE(68);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(69);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 33:
      if (lookahead == '2') ADVANCE(72);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(73);
      END_STATE();
    case 36:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 38:
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(77);
      END_STATE();
    case 40:
      if (lookahead == '6') ADVANCE(78);
      END_STATE();
    case 41:
      if (lookahead == '2') ADVANCE(79);
      END_STATE();
    case 42:
      if (lookahead == 's') ADVANCE(80);
      if (lookahead == 'u') ADVANCE(81);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 't') ADVANCE(83);
      END_STATE();
    case 44:
      if (lookahead == '1') ADVANCE(84);
      if (lookahead == '3') ADVANCE(85);
      if (lookahead == '8') ADVANCE(86);
      if (lookahead == 'b') ADVANCE(87);
      END_STATE();
    case 45:
      if (lookahead == 'm') ADVANCE(88);
      END_STATE();
    case 46:
      if (lookahead == 'o') ADVANCE(89);
      if (lookahead == 'r') ADVANCE(90);
      END_STATE();
    case 47:
      if (lookahead == 'i') ADVANCE(91);
      END_STATE();
    case 48:
      if (lookahead == 'x') ADVANCE(92);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 50:
      if (lookahead == 'p') ADVANCE(94);
      END_STATE();
    case 51:
      if (lookahead == '2') ADVANCE(95);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(96);
      END_STATE();
    case 53:
      if (lookahead == 'r') ADVANCE(97);
      END_STATE();
    case 54:
      if (lookahead == 'c') ADVANCE(98);
      END_STATE();
    case 55:
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(100);
      END_STATE();
    case 57:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 58:
      if (lookahead == 'm') ADVANCE(102);
      END_STATE();
    case 59:
      if (lookahead == 'c') ADVANCE(103);
      END_STATE();
    case 60:
      if (lookahead == 'l') ADVANCE(104);
      END_STATE();
    case 61:
      if (lookahead == 'a') ADVANCE(105);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 63:
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(108);
      END_STATE();
    case 65:
      if (lookahead == 'c') ADVANCE(109);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(110);
      END_STATE();
    case 67:
      if (lookahead == 'b') ADVANCE(111);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_f32);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(112);
      if (lookahead == 's') ADVANCE(113);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 71:
      if (lookahead == 'c') ADVANCE(114);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_i32);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 74:
      if (lookahead == 'p') ADVANCE(115);
      END_STATE();
    case 75:
      if (lookahead == '2') ADVANCE(116);
      if (lookahead == '3') ADVANCE(117);
      if (lookahead == '4') ADVANCE(118);
      END_STATE();
    case 76:
      if (lookahead == 'v') ADVANCE(119);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_ptr);
      END_STATE();
    case 78:
      if (lookahead == 'f') ADVANCE(120);
      if (lookahead == 's') ADVANCE(121);
      if (lookahead == 'u') ADVANCE(122);
      END_STATE();
    case 79:
      if (lookahead == 'f') ADVANCE(123);
      if (lookahead == 's') ADVANCE(124);
      if (lookahead == 'u') ADVANCE(125);
      END_STATE();
    case 80:
      if (lookahead == 'i') ADVANCE(126);
      if (lookahead == 'n') ADVANCE(127);
      END_STATE();
    case 81:
      if (lookahead == 'i') ADVANCE(128);
      if (lookahead == 'n') ADVANCE(129);
      END_STATE();
    case 82:
      if (lookahead == 'd') ADVANCE(130);
      END_STATE();
    case 83:
      if (lookahead == 'u') ADVANCE(131);
      END_STATE();
    case 84:
      if (lookahead == '0') ADVANCE(132);
      if (lookahead == '1') ADVANCE(133);
      if (lookahead == '6') ADVANCE(134);
      END_STATE();
    case 85:
      if (lookahead == '2') ADVANCE(135);
      END_STATE();
    case 86:
      if (lookahead == 's') ADVANCE(136);
      if (lookahead == 'u') ADVANCE(137);
      END_STATE();
    case 87:
      if (lookahead == 'a') ADVANCE(138);
      END_STATE();
    case 88:
      if (lookahead == 'p') ADVANCE(139);
      END_STATE();
    case 89:
      if (lookahead == 'r') ADVANCE(140);
      END_STATE();
    case 90:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 91:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 92:
      if (lookahead == 't') ADVANCE(143);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(144);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_u32);
      END_STATE();
    case 96:
      if (lookahead == 'f') ADVANCE(146);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 98:
      if (lookahead == '2') ADVANCE(147);
      if (lookahead == '3') ADVANCE(148);
      if (lookahead == '4') ADVANCE(149);
      END_STATE();
    case 99:
      if (lookahead == 'k') ADVANCE(150);
      END_STATE();
    case 100:
      if (lookahead == 't') ADVANCE(151);
      END_STATE();
    case 101:
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(153);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(154);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 105:
      if (lookahead == 'k') ADVANCE(155);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 107:
      if (lookahead == 'i') ADVANCE(156);
      END_STATE();
    case 108:
      if (lookahead == 'u') ADVANCE(157);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(158);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(159);
      END_STATE();
    case 111:
      if (lookahead == 'l') ADVANCE(160);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(163);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_loop);
      END_STATE();
    case 116:
      if (lookahead == 'x') ADVANCE(164);
      END_STATE();
    case 117:
      if (lookahead == 'x') ADVANCE(165);
      END_STATE();
    case 118:
      if (lookahead == 'x') ADVANCE(166);
      END_STATE();
    case 119:
      if (lookahead == 'a') ADVANCE(167);
      END_STATE();
    case 120:
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 121:
      if (lookahead == 'i') ADVANCE(169);
      END_STATE();
    case 122:
      if (lookahead == 'i') ADVANCE(170);
      END_STATE();
    case 123:
      if (lookahead == 'l') ADVANCE(171);
      END_STATE();
    case 124:
      if (lookahead == 'i') ADVANCE(172);
      END_STATE();
    case 125:
      if (lookahead == 'i') ADVANCE(173);
      END_STATE();
    case 126:
      if (lookahead == 'n') ADVANCE(174);
      END_STATE();
    case 127:
      if (lookahead == 'o') ADVANCE(175);
      END_STATE();
    case 128:
      if (lookahead == 'n') ADVANCE(176);
      END_STATE();
    case 129:
      if (lookahead == 'o') ADVANCE(177);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_read);
      if (lookahead == '_') ADVANCE(178);
      END_STATE();
    case 131:
      if (lookahead == 'r') ADVANCE(179);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(180);
      END_STATE();
    case 133:
      if (lookahead == 'b') ADVANCE(181);
      END_STATE();
    case 134:
      if (lookahead == 'f') ADVANCE(182);
      if (lookahead == 's') ADVANCE(183);
      if (lookahead == 'u') ADVANCE(184);
      END_STATE();
    case 135:
      if (lookahead == 'f') ADVANCE(185);
      if (lookahead == 's') ADVANCE(186);
      if (lookahead == 'u') ADVANCE(187);
      END_STATE();
    case 136:
      if (lookahead == 'i') ADVANCE(188);
      if (lookahead == 'n') ADVANCE(189);
      END_STATE();
    case 137:
      if (lookahead == 'i') ADVANCE(190);
      if (lookahead == 'n') ADVANCE(191);
      END_STATE();
    case 138:
      if (lookahead == '1') ADVANCE(192);
      if (lookahead == '3') ADVANCE(193);
      if (lookahead == '8') ADVANCE(194);
      END_STATE();
    case 139:
      if (lookahead == 'l') ADVANCE(195);
      END_STATE();
    case 140:
      if (lookahead == 'a') ADVANCE(196);
      END_STATE();
    case 141:
      if (lookahead == 'c') ADVANCE(197);
      END_STATE();
    case 142:
      if (lookahead == 'c') ADVANCE(198);
      END_STATE();
    case 143:
      if (lookahead == 'u') ADVANCE(199);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 146:
      if (lookahead == 'o') ADVANCE(200);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_vec2);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_vec3);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_vec4);
      END_STATE();
    case 150:
      if (lookahead == 'g') ADVANCE(201);
      END_STATE();
    case 151:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_array);
      END_STATE();
    case 153:
      if (lookahead == 'c') ADVANCE(203);
      END_STATE();
    case 154:
      if (lookahead == 's') ADVANCE(204);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 156:
      if (lookahead == 'n') ADVANCE(205);
      END_STATE();
    case 157:
      if (lookahead == 'l') ADVANCE(206);
      END_STATE();
    case 158:
      if (lookahead == 'r') ADVANCE(207);
      END_STATE();
    case 159:
      if (lookahead == 'f') ADVANCE(208);
      END_STATE();
    case 160:
      if (lookahead == 'e') ADVANCE(209);
      END_STATE();
    case 161:
      if (lookahead == 'h') ADVANCE(210);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 163:
      if (lookahead == 'i') ADVANCE(211);
      END_STATE();
    case 164:
      if (lookahead == '2') ADVANCE(212);
      if (lookahead == '3') ADVANCE(213);
      if (lookahead == '4') ADVANCE(214);
      END_STATE();
    case 165:
      if (lookahead == '2') ADVANCE(215);
      if (lookahead == '3') ADVANCE(216);
      if (lookahead == '4') ADVANCE(217);
      END_STATE();
    case 166:
      if (lookahead == '2') ADVANCE(218);
      if (lookahead == '3') ADVANCE(219);
      if (lookahead == '4') ADVANCE(220);
      END_STATE();
    case 167:
      if (lookahead == 't') ADVANCE(221);
      END_STATE();
    case 168:
      if (lookahead == 'o') ADVANCE(222);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(223);
      END_STATE();
    case 170:
      if (lookahead == 'n') ADVANCE(224);
      END_STATE();
    case 171:
      if (lookahead == 'o') ADVANCE(225);
      END_STATE();
    case 172:
      if (lookahead == 'n') ADVANCE(226);
      END_STATE();
    case 173:
      if (lookahead == 'n') ADVANCE(227);
      END_STATE();
    case 174:
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(229);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(230);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(231);
      END_STATE();
    case 178:
      if (lookahead == 'w') ADVANCE(232);
      END_STATE();
    case 179:
      if (lookahead == 'n') ADVANCE(233);
      END_STATE();
    case 180:
      if (lookahead == '2') ADVANCE(234);
      END_STATE();
    case 181:
      if (lookahead == '1') ADVANCE(235);
      END_STATE();
    case 182:
      if (lookahead == 'l') ADVANCE(236);
      END_STATE();
    case 183:
      if (lookahead == 'i') ADVANCE(237);
      END_STATE();
    case 184:
      if (lookahead == 'i') ADVANCE(238);
      END_STATE();
    case 185:
      if (lookahead == 'l') ADVANCE(239);
      END_STATE();
    case 186:
      if (lookahead == 'i') ADVANCE(240);
      END_STATE();
    case 187:
      if (lookahead == 'i') ADVANCE(241);
      END_STATE();
    case 188:
      if (lookahead == 'n') ADVANCE(242);
      END_STATE();
    case 189:
      if (lookahead == 'o') ADVANCE(243);
      END_STATE();
    case 190:
      if (lookahead == 'n') ADVANCE(244);
      END_STATE();
    case 191:
      if (lookahead == 'o') ADVANCE(245);
      END_STATE();
    case 192:
      if (lookahead == '6') ADVANCE(246);
      END_STATE();
    case 193:
      if (lookahead == '2') ADVANCE(247);
      END_STATE();
    case 194:
      if (lookahead == 's') ADVANCE(248);
      if (lookahead == 'u') ADVANCE(249);
      END_STATE();
    case 195:
      if (lookahead == 'e') ADVANCE(250);
      END_STATE();
    case 196:
      if (lookahead == 'g') ADVANCE(251);
      END_STATE();
    case 197:
      if (lookahead == 't') ADVANCE(252);
      END_STATE();
    case 198:
      if (lookahead == 'h') ADVANCE(253);
      END_STATE();
    case 199:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 200:
      if (lookahead == 'r') ADVANCE(255);
      END_STATE();
    case 201:
      if (lookahead == 'r') ADVANCE(256);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_write);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_atomic);
      END_STATE();
    case 204:
      if (lookahead == 't') ADVANCE(257);
      END_STATE();
    case 205:
      if (lookahead == 'u') ADVANCE(258);
      END_STATE();
    case 206:
      if (lookahead == 't') ADVANCE(259);
      END_STATE();
    case 207:
      if (lookahead == 'd') ADVANCE(260);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_enable);
      END_STATE();
    case 210:
      if (lookahead == 'r') ADVANCE(261);
      END_STATE();
    case 211:
      if (lookahead == 'o') ADVANCE(262);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_mat2x2);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_mat2x3);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_mat2x4);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_mat3x2);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_mat3x3);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_mat3x4);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_mat4x2);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_mat4x3);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_mat4x4);
      END_STATE();
    case 221:
      if (lookahead == 'e') ADVANCE(263);
      END_STATE();
    case 222:
      if (lookahead == 'a') ADVANCE(264);
      END_STATE();
    case 223:
      if (lookahead == 't') ADVANCE(265);
      END_STATE();
    case 224:
      if (lookahead == 't') ADVANCE(266);
      END_STATE();
    case 225:
      if (lookahead == 'a') ADVANCE(267);
      END_STATE();
    case 226:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 227:
      if (lookahead == 't') ADVANCE(269);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_r8sint);
      END_STATE();
    case 229:
      if (lookahead == 'm') ADVANCE(270);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_r8uint);
      END_STATE();
    case 231:
      if (lookahead == 'm') ADVANCE(271);
      END_STATE();
    case 232:
      if (lookahead == 'r') ADVANCE(272);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 234:
      if (lookahead == 'u') ADVANCE(273);
      END_STATE();
    case 235:
      if (lookahead == '0') ADVANCE(274);
      END_STATE();
    case 236:
      if (lookahead == 'o') ADVANCE(275);
      END_STATE();
    case 237:
      if (lookahead == 'n') ADVANCE(276);
      END_STATE();
    case 238:
      if (lookahead == 'n') ADVANCE(277);
      END_STATE();
    case 239:
      if (lookahead == 'o') ADVANCE(278);
      END_STATE();
    case 240:
      if (lookahead == 'n') ADVANCE(279);
      END_STATE();
    case 241:
      if (lookahead == 'n') ADVANCE(280);
      END_STATE();
    case 242:
      if (lookahead == 't') ADVANCE(281);
      END_STATE();
    case 243:
      if (lookahead == 'r') ADVANCE(282);
      END_STATE();
    case 244:
      if (lookahead == 't') ADVANCE(283);
      END_STATE();
    case 245:
      if (lookahead == 'r') ADVANCE(284);
      END_STATE();
    case 246:
      if (lookahead == 'f') ADVANCE(285);
      if (lookahead == 's') ADVANCE(286);
      if (lookahead == 'u') ADVANCE(287);
      END_STATE();
    case 247:
      if (lookahead == 'f') ADVANCE(288);
      if (lookahead == 's') ADVANCE(289);
      if (lookahead == 'u') ADVANCE(290);
      END_STATE();
    case 248:
      if (lookahead == 'i') ADVANCE(291);
      if (lookahead == 'n') ADVANCE(292);
      END_STATE();
    case 249:
      if (lookahead == 'i') ADVANCE(293);
      if (lookahead == 'n') ADVANCE(294);
      END_STATE();
    case 250:
      if (lookahead == 'r') ADVANCE(295);
      END_STATE();
    case 251:
      if (lookahead == 'e') ADVANCE(296);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(297);
      END_STATE();
    case 255:
      if (lookahead == 'm') ADVANCE(298);
      END_STATE();
    case 256:
      if (lookahead == 'o') ADVANCE(299);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_bitcast);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(300);
      if (lookahead == 'i') ADVANCE(301);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_discard);
      END_STATE();
    case 261:
      if (lookahead == 'o') ADVANCE(302);
      END_STATE();
    case 262:
      if (lookahead == 'n') ADVANCE(303);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 264:
      if (lookahead == 't') ADVANCE(304);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_r16sint);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_r16uint);
      END_STATE();
    case 267:
      if (lookahead == 't') ADVANCE(305);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_r32sint);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_r32uint);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_r8snorm);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_r8unorm);
      END_STATE();
    case 272:
      if (lookahead == 'i') ADVANCE(306);
      END_STATE();
    case 273:
      if (lookahead == 'n') ADVANCE(307);
      END_STATE();
    case 274:
      if (lookahead == 'f') ADVANCE(308);
      END_STATE();
    case 275:
      if (lookahead == 'a') ADVANCE(309);
      END_STATE();
    case 276:
      if (lookahead == 't') ADVANCE(310);
      END_STATE();
    case 277:
      if (lookahead == 't') ADVANCE(311);
      END_STATE();
    case 278:
      if (lookahead == 'a') ADVANCE(312);
      END_STATE();
    case 279:
      if (lookahead == 't') ADVANCE(313);
      END_STATE();
    case 280:
      if (lookahead == 't') ADVANCE(314);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_rg8sint);
      END_STATE();
    case 282:
      if (lookahead == 'm') ADVANCE(315);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_rg8uint);
      END_STATE();
    case 284:
      if (lookahead == 'm') ADVANCE(316);
      END_STATE();
    case 285:
      if (lookahead == 'l') ADVANCE(317);
      END_STATE();
    case 286:
      if (lookahead == 'i') ADVANCE(318);
      END_STATE();
    case 287:
      if (lookahead == 'i') ADVANCE(319);
      END_STATE();
    case 288:
      if (lookahead == 'l') ADVANCE(320);
      END_STATE();
    case 289:
      if (lookahead == 'i') ADVANCE(321);
      END_STATE();
    case 290:
      if (lookahead == 'i') ADVANCE(322);
      END_STATE();
    case 291:
      if (lookahead == 'n') ADVANCE(323);
      END_STATE();
    case 292:
      if (lookahead == 'o') ADVANCE(324);
      END_STATE();
    case 293:
      if (lookahead == 'n') ADVANCE(325);
      END_STATE();
    case 294:
      if (lookahead == 'o') ADVANCE(326);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_sampler);
      if (lookahead == '_') ADVANCE(327);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_storage);
      END_STATE();
    case 297:
      if (lookahead == '_') ADVANCE(328);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_uniform);
      END_STATE();
    case 299:
      if (lookahead == 'u') ADVANCE(329);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 301:
      if (lookahead == 'n') ADVANCE(330);
      END_STATE();
    case 302:
      if (lookahead == 'u') ADVANCE(331);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_r16float);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_r32float);
      END_STATE();
    case 306:
      if (lookahead == 't') ADVANCE(332);
      END_STATE();
    case 307:
      if (lookahead == 'o') ADVANCE(333);
      END_STATE();
    case 308:
      if (lookahead == 'l') ADVANCE(334);
      END_STATE();
    case 309:
      if (lookahead == 't') ADVANCE(335);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_rg16sint);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_rg16uint);
      END_STATE();
    case 312:
      if (lookahead == 't') ADVANCE(336);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_rg32sint);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_rg32uint);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_rg8snorm);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_rg8unorm);
      END_STATE();
    case 317:
      if (lookahead == 'o') ADVANCE(337);
      END_STATE();
    case 318:
      if (lookahead == 'n') ADVANCE(338);
      END_STATE();
    case 319:
      if (lookahead == 'n') ADVANCE(339);
      END_STATE();
    case 320:
      if (lookahead == 'o') ADVANCE(340);
      END_STATE();
    case 321:
      if (lookahead == 'n') ADVANCE(341);
      END_STATE();
    case 322:
      if (lookahead == 'n') ADVANCE(342);
      END_STATE();
    case 323:
      if (lookahead == 't') ADVANCE(343);
      END_STATE();
    case 324:
      if (lookahead == 'r') ADVANCE(344);
      END_STATE();
    case 325:
      if (lookahead == 't') ADVANCE(345);
      END_STATE();
    case 326:
      if (lookahead == 'r') ADVANCE(346);
      END_STATE();
    case 327:
      if (lookahead == 'c') ADVANCE(347);
      END_STATE();
    case 328:
      if (lookahead == '1') ADVANCE(348);
      if (lookahead == '2') ADVANCE(349);
      if (lookahead == '3') ADVANCE(350);
      if (lookahead == 'c') ADVANCE(351);
      if (lookahead == 'd') ADVANCE(352);
      if (lookahead == 'm') ADVANCE(353);
      if (lookahead == 's') ADVANCE(354);
      END_STATE();
    case 329:
      if (lookahead == 'p') ADVANCE(355);
      END_STATE();
    case 330:
      if (lookahead == 'g') ADVANCE(356);
      END_STATE();
    case 331:
      if (lookahead == 'g') ADVANCE(357);
      END_STATE();
    case 332:
      if (lookahead == 'e') ADVANCE(358);
      END_STATE();
    case 333:
      if (lookahead == 'r') ADVANCE(359);
      END_STATE();
    case 334:
      if (lookahead == 'o') ADVANCE(360);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_rg16float);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_rg32float);
      END_STATE();
    case 337:
      if (lookahead == 'a') ADVANCE(361);
      END_STATE();
    case 338:
      if (lookahead == 't') ADVANCE(362);
      END_STATE();
    case 339:
      if (lookahead == 't') ADVANCE(363);
      END_STATE();
    case 340:
      if (lookahead == 'a') ADVANCE(364);
      END_STATE();
    case 341:
      if (lookahead == 't') ADVANCE(365);
      END_STATE();
    case 342:
      if (lookahead == 't') ADVANCE(366);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_rgba8sint);
      END_STATE();
    case 344:
      if (lookahead == 'm') ADVANCE(367);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_rgba8uint);
      END_STATE();
    case 346:
      if (lookahead == 'm') ADVANCE(368);
      END_STATE();
    case 347:
      if (lookahead == 'o') ADVANCE(369);
      END_STATE();
    case 348:
      if (lookahead == 'd') ADVANCE(370);
      END_STATE();
    case 349:
      if (lookahead == 'd') ADVANCE(371);
      END_STATE();
    case 350:
      if (lookahead == 'd') ADVANCE(372);
      END_STATE();
    case 351:
      if (lookahead == 'u') ADVANCE(373);
      END_STATE();
    case 352:
      if (lookahead == 'e') ADVANCE(374);
      END_STATE();
    case 353:
      if (lookahead == 'u') ADVANCE(375);
      END_STATE();
    case 354:
      if (lookahead == 't') ADVANCE(376);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_workgroup);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_continuing);
      END_STATE();
    case 357:
      if (lookahead == 'h') ADVANCE(377);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_read_write);
      END_STATE();
    case 359:
      if (lookahead == 'm') ADVANCE(378);
      END_STATE();
    case 360:
      if (lookahead == 'a') ADVANCE(379);
      END_STATE();
    case 361:
      if (lookahead == 't') ADVANCE(380);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_rgba16sint);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_rgba16uint);
      END_STATE();
    case 364:
      if (lookahead == 't') ADVANCE(381);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_rgba32sint);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_rgba32uint);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_rgba8snorm);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_rgba8unorm);
      if (lookahead == '_') ADVANCE(382);
      END_STATE();
    case 369:
      if (lookahead == 'm') ADVANCE(383);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_texture_1d);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_texture_2d);
      if (lookahead == '_') ADVANCE(384);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_texture_3d);
      END_STATE();
    case 373:
      if (lookahead == 'b') ADVANCE(385);
      END_STATE();
    case 374:
      if (lookahead == 'p') ADVANCE(386);
      END_STATE();
    case 375:
      if (lookahead == 'l') ADVANCE(387);
      END_STATE();
    case 376:
      if (lookahead == 'o') ADVANCE(388);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_fallthrough);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_rg10a2unorm);
      END_STATE();
    case 379:
      if (lookahead == 't') ADVANCE(389);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_rgba16float);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(anon_sym_rgba32float);
      END_STATE();
    case 382:
      if (lookahead == 's') ADVANCE(390);
      END_STATE();
    case 383:
      if (lookahead == 'p') ADVANCE(391);
      END_STATE();
    case 384:
      if (lookahead == 'a') ADVANCE(392);
      END_STATE();
    case 385:
      if (lookahead == 'e') ADVANCE(393);
      END_STATE();
    case 386:
      if (lookahead == 't') ADVANCE(394);
      END_STATE();
    case 387:
      if (lookahead == 't') ADVANCE(395);
      END_STATE();
    case 388:
      if (lookahead == 'r') ADVANCE(396);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_rg11b10float);
      END_STATE();
    case 390:
      if (lookahead == 'r') ADVANCE(397);
      END_STATE();
    case 391:
      if (lookahead == 'a') ADVANCE(398);
      END_STATE();
    case 392:
      if (lookahead == 'r') ADVANCE(399);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_texture_cube);
      if (lookahead == '_') ADVANCE(400);
      END_STATE();
    case 394:
      if (lookahead == 'h') ADVANCE(401);
      END_STATE();
    case 395:
      if (lookahead == 'i') ADVANCE(402);
      END_STATE();
    case 396:
      if (lookahead == 'a') ADVANCE(403);
      END_STATE();
    case 397:
      if (lookahead == 'g') ADVANCE(404);
      END_STATE();
    case 398:
      if (lookahead == 'r') ADVANCE(405);
      END_STATE();
    case 399:
      if (lookahead == 'r') ADVANCE(406);
      END_STATE();
    case 400:
      if (lookahead == 'a') ADVANCE(407);
      END_STATE();
    case 401:
      if (lookahead == '_') ADVANCE(408);
      END_STATE();
    case 402:
      if (lookahead == 's') ADVANCE(409);
      END_STATE();
    case 403:
      if (lookahead == 'g') ADVANCE(410);
      END_STATE();
    case 404:
      if (lookahead == 'b') ADVANCE(411);
      END_STATE();
    case 405:
      if (lookahead == 'i') ADVANCE(412);
      END_STATE();
    case 406:
      if (lookahead == 'a') ADVANCE(413);
      END_STATE();
    case 407:
      if (lookahead == 'r') ADVANCE(414);
      END_STATE();
    case 408:
      if (lookahead == '2') ADVANCE(415);
      if (lookahead == 'c') ADVANCE(416);
      if (lookahead == 'm') ADVANCE(417);
      END_STATE();
    case 409:
      if (lookahead == 'a') ADVANCE(418);
      END_STATE();
    case 410:
      if (lookahead == 'e') ADVANCE(419);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_rgba8unorm_srgb);
      END_STATE();
    case 412:
      if (lookahead == 's') ADVANCE(420);
      END_STATE();
    case 413:
      if (lookahead == 'y') ADVANCE(421);
      END_STATE();
    case 414:
      if (lookahead == 'r') ADVANCE(422);
      END_STATE();
    case 415:
      if (lookahead == 'd') ADVANCE(423);
      END_STATE();
    case 416:
      if (lookahead == 'u') ADVANCE(424);
      END_STATE();
    case 417:
      if (lookahead == 'u') ADVANCE(425);
      END_STATE();
    case 418:
      if (lookahead == 'm') ADVANCE(426);
      END_STATE();
    case 419:
      if (lookahead == '_') ADVANCE(427);
      END_STATE();
    case 420:
      if (lookahead == 'o') ADVANCE(428);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_texture_2d_array);
      END_STATE();
    case 422:
      if (lookahead == 'a') ADVANCE(429);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_texture_depth_2d);
      if (lookahead == '_') ADVANCE(430);
      END_STATE();
    case 424:
      if (lookahead == 'b') ADVANCE(431);
      END_STATE();
    case 425:
      if (lookahead == 'l') ADVANCE(432);
      END_STATE();
    case 426:
      if (lookahead == 'p') ADVANCE(433);
      END_STATE();
    case 427:
      if (lookahead == '1') ADVANCE(434);
      if (lookahead == '2') ADVANCE(435);
      if (lookahead == '3') ADVANCE(436);
      END_STATE();
    case 428:
      if (lookahead == 'n') ADVANCE(437);
      END_STATE();
    case 429:
      if (lookahead == 'y') ADVANCE(438);
      END_STATE();
    case 430:
      if (lookahead == 'a') ADVANCE(439);
      END_STATE();
    case 431:
      if (lookahead == 'e') ADVANCE(440);
      END_STATE();
    case 432:
      if (lookahead == 't') ADVANCE(441);
      END_STATE();
    case 433:
      if (lookahead == 'l') ADVANCE(442);
      END_STATE();
    case 434:
      if (lookahead == 'd') ADVANCE(443);
      END_STATE();
    case 435:
      if (lookahead == 'd') ADVANCE(444);
      END_STATE();
    case 436:
      if (lookahead == 'd') ADVANCE(445);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_sampler_comparison);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_texture_cube_array);
      END_STATE();
    case 439:
      if (lookahead == 'r') ADVANCE(446);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_texture_depth_cube);
      if (lookahead == '_') ADVANCE(447);
      END_STATE();
    case 441:
      if (lookahead == 'i') ADVANCE(448);
      END_STATE();
    case 442:
      if (lookahead == 'e') ADVANCE(449);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_texture_storage_1d);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym_texture_storage_2d);
      if (lookahead == '_') ADVANCE(450);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_texture_storage_3d);
      END_STATE();
    case 446:
      if (lookahead == 'r') ADVANCE(451);
      END_STATE();
    case 447:
      if (lookahead == 'a') ADVANCE(452);
      END_STATE();
    case 448:
      if (lookahead == 's') ADVANCE(453);
      END_STATE();
    case 449:
      if (lookahead == 'd') ADVANCE(454);
      END_STATE();
    case 450:
      if (lookahead == 'a') ADVANCE(455);
      END_STATE();
    case 451:
      if (lookahead == 'a') ADVANCE(456);
      END_STATE();
    case 452:
      if (lookahead == 'r') ADVANCE(457);
      END_STATE();
    case 453:
      if (lookahead == 'a') ADVANCE(458);
      END_STATE();
    case 454:
      if (lookahead == '_') ADVANCE(459);
      END_STATE();
    case 455:
      if (lookahead == 'r') ADVANCE(460);
      END_STATE();
    case 456:
      if (lookahead == 'y') ADVANCE(461);
      END_STATE();
    case 457:
      if (lookahead == 'r') ADVANCE(462);
      END_STATE();
    case 458:
      if (lookahead == 'm') ADVANCE(463);
      END_STATE();
    case 459:
      if (lookahead == '2') ADVANCE(464);
      END_STATE();
    case 460:
      if (lookahead == 'r') ADVANCE(465);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(anon_sym_texture_depth_2d_array);
      END_STATE();
    case 462:
      if (lookahead == 'a') ADVANCE(466);
      END_STATE();
    case 463:
      if (lookahead == 'p') ADVANCE(467);
      END_STATE();
    case 464:
      if (lookahead == 'd') ADVANCE(468);
      END_STATE();
    case 465:
      if (lookahead == 'a') ADVANCE(469);
      END_STATE();
    case 466:
      if (lookahead == 'y') ADVANCE(470);
      END_STATE();
    case 467:
      if (lookahead == 'l') ADVANCE(471);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_texture_multisampled_2d);
      END_STATE();
    case 469:
      if (lookahead == 'y') ADVANCE(472);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_texture_depth_cube_array);
      END_STATE();
    case 471:
      if (lookahead == 'e') ADVANCE(473);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_texture_storage_2d_array);
      END_STATE();
    case 473:
      if (lookahead == 'd') ADVANCE(474);
      END_STATE();
    case 474:
      if (lookahead == '_') ADVANCE(475);
      END_STATE();
    case 475:
      if (lookahead == '2') ADVANCE(476);
      END_STATE();
    case 476:
      if (lookahead == 'd') ADVANCE(477);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_texture_depth_multisampled_2d);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 21},
  [2] = {.lex_state = 21},
  [3] = {.lex_state = 21},
  [4] = {.lex_state = 21},
  [5] = {.lex_state = 21},
  [6] = {.lex_state = 21},
  [7] = {.lex_state = 21},
  [8] = {.lex_state = 21},
  [9] = {.lex_state = 21},
  [10] = {.lex_state = 21},
  [11] = {.lex_state = 21},
  [12] = {.lex_state = 21},
  [13] = {.lex_state = 21},
  [14] = {.lex_state = 21},
  [15] = {.lex_state = 21},
  [16] = {.lex_state = 21},
  [17] = {.lex_state = 21},
  [18] = {.lex_state = 21},
  [19] = {.lex_state = 21},
  [20] = {.lex_state = 21},
  [21] = {.lex_state = 21},
  [22] = {.lex_state = 21},
  [23] = {.lex_state = 21},
  [24] = {.lex_state = 21},
  [25] = {.lex_state = 21},
  [26] = {.lex_state = 21},
  [27] = {.lex_state = 21},
  [28] = {.lex_state = 21},
  [29] = {.lex_state = 21},
  [30] = {.lex_state = 21},
  [31] = {.lex_state = 21},
  [32] = {.lex_state = 21},
  [33] = {.lex_state = 21},
  [34] = {.lex_state = 21},
  [35] = {.lex_state = 21},
  [36] = {.lex_state = 21},
  [37] = {.lex_state = 21},
  [38] = {.lex_state = 21},
  [39] = {.lex_state = 21},
  [40] = {.lex_state = 21},
  [41] = {.lex_state = 21},
  [42] = {.lex_state = 21},
  [43] = {.lex_state = 21},
  [44] = {.lex_state = 21},
  [45] = {.lex_state = 21},
  [46] = {.lex_state = 21},
  [47] = {.lex_state = 21},
  [48] = {.lex_state = 21},
  [49] = {.lex_state = 21},
  [50] = {.lex_state = 21},
  [51] = {.lex_state = 21},
  [52] = {.lex_state = 21},
  [53] = {.lex_state = 21},
  [54] = {.lex_state = 21},
  [55] = {.lex_state = 21},
  [56] = {.lex_state = 21},
  [57] = {.lex_state = 21},
  [58] = {.lex_state = 21},
  [59] = {.lex_state = 21},
  [60] = {.lex_state = 21},
  [61] = {.lex_state = 21},
  [62] = {.lex_state = 21},
  [63] = {.lex_state = 21},
  [64] = {.lex_state = 21},
  [65] = {.lex_state = 21},
  [66] = {.lex_state = 21},
  [67] = {.lex_state = 21},
  [68] = {.lex_state = 21},
  [69] = {.lex_state = 21},
  [70] = {.lex_state = 21},
  [71] = {.lex_state = 21},
  [72] = {.lex_state = 21},
  [73] = {.lex_state = 21},
  [74] = {.lex_state = 21},
  [75] = {.lex_state = 21},
  [76] = {.lex_state = 21},
  [77] = {.lex_state = 21},
  [78] = {.lex_state = 21},
  [79] = {.lex_state = 21},
  [80] = {.lex_state = 0},
  [81] = {.lex_state = 0},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 0},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 1},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 1},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 1},
  [97] = {.lex_state = 1},
  [98] = {.lex_state = 1},
  [99] = {.lex_state = 1},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 1},
  [103] = {.lex_state = 1},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 1},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 1},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 1},
  [112] = {.lex_state = 1},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 1},
  [115] = {.lex_state = 1},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 1},
  [118] = {.lex_state = 1},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 1},
  [122] = {.lex_state = 1},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 1},
  [125] = {.lex_state = 21},
  [126] = {.lex_state = 21},
  [127] = {.lex_state = 21},
  [128] = {.lex_state = 21},
  [129] = {.lex_state = 21},
  [130] = {.lex_state = 21},
  [131] = {.lex_state = 21},
  [132] = {.lex_state = 21},
  [133] = {.lex_state = 21},
  [134] = {.lex_state = 21},
  [135] = {.lex_state = 21},
  [136] = {.lex_state = 21},
  [137] = {.lex_state = 21},
  [138] = {.lex_state = 21},
  [139] = {.lex_state = 21},
  [140] = {.lex_state = 21},
  [141] = {.lex_state = 21},
  [142] = {.lex_state = 21},
  [143] = {.lex_state = 21},
  [144] = {.lex_state = 21},
  [145] = {.lex_state = 21},
  [146] = {.lex_state = 21},
  [147] = {.lex_state = 21},
  [148] = {.lex_state = 21},
  [149] = {.lex_state = 21},
  [150] = {.lex_state = 21},
  [151] = {.lex_state = 21},
  [152] = {.lex_state = 21},
  [153] = {.lex_state = 21},
  [154] = {.lex_state = 21},
  [155] = {.lex_state = 21},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 21},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 21},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 2},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 2},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0},
  [169] = {.lex_state = 2},
  [170] = {.lex_state = 0},
  [171] = {.lex_state = 2},
  [172] = {.lex_state = 0},
  [173] = {.lex_state = 21},
  [174] = {.lex_state = 0},
  [175] = {.lex_state = 0},
  [176] = {.lex_state = 0},
  [177] = {.lex_state = 0},
  [178] = {.lex_state = 0},
  [179] = {.lex_state = 0},
  [180] = {.lex_state = 21},
  [181] = {.lex_state = 21},
  [182] = {.lex_state = 0},
  [183] = {.lex_state = 0},
  [184] = {.lex_state = 0},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 0},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 0},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 0},
  [191] = {.lex_state = 21},
  [192] = {.lex_state = 21},
  [193] = {.lex_state = 21},
  [194] = {.lex_state = 0},
  [195] = {.lex_state = 0},
  [196] = {.lex_state = 0},
  [197] = {.lex_state = 0},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 0},
  [200] = {.lex_state = 0},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 0},
  [205] = {.lex_state = 0},
  [206] = {.lex_state = 0},
  [207] = {.lex_state = 21},
  [208] = {.lex_state = 0},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 0},
  [212] = {.lex_state = 0},
  [213] = {.lex_state = 0},
  [214] = {.lex_state = 21},
  [215] = {.lex_state = 21},
  [216] = {.lex_state = 0},
  [217] = {.lex_state = 21},
  [218] = {.lex_state = 21},
  [219] = {.lex_state = 21},
  [220] = {.lex_state = 0},
  [221] = {.lex_state = 0},
  [222] = {.lex_state = 21},
  [223] = {.lex_state = 0},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 0},
  [226] = {.lex_state = 21},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 0},
  [229] = {.lex_state = 0},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 0},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 0},
  [236] = {.lex_state = 21},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 0},
  [241] = {.lex_state = 0},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 0},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 0},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 21},
  [260] = {.lex_state = 0},
  [261] = {.lex_state = 0},
  [262] = {.lex_state = 0},
  [263] = {.lex_state = 21},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 0},
  [270] = {.lex_state = 21},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 21},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 21},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 25},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 0},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 2},
  [294] = {.lex_state = 0},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_enable] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_fallthrough] = ACTIONS(1),
    [anon_sym_loop] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_continuing] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_discard] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [sym_uint_literal] = ACTIONS(1),
    [aux_sym_float_literal_token1] = ACTIONS(1),
    [aux_sym_float_literal_token2] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_u32] = ACTIONS(1),
    [anon_sym_i32] = ACTIONS(1),
    [anon_sym_f32] = ACTIONS(1),
    [anon_sym_vec2] = ACTIONS(1),
    [anon_sym_vec3] = ACTIONS(1),
    [anon_sym_vec4] = ACTIONS(1),
    [anon_sym_mat2x2] = ACTIONS(1),
    [anon_sym_mat2x3] = ACTIONS(1),
    [anon_sym_mat2x4] = ACTIONS(1),
    [anon_sym_mat3x2] = ACTIONS(1),
    [anon_sym_mat3x3] = ACTIONS(1),
    [anon_sym_mat3x4] = ACTIONS(1),
    [anon_sym_mat4x2] = ACTIONS(1),
    [anon_sym_mat4x3] = ACTIONS(1),
    [anon_sym_mat4x4] = ACTIONS(1),
    [anon_sym_atomic] = ACTIONS(1),
    [anon_sym_array] = ACTIONS(1),
    [anon_sym_ptr] = ACTIONS(1),
    [anon_sym_sampler] = ACTIONS(1),
    [anon_sym_sampler_comparison] = ACTIONS(1),
    [anon_sym_texture_depth_2d] = ACTIONS(1),
    [anon_sym_texture_depth_2d_array] = ACTIONS(1),
    [anon_sym_texture_depth_cube] = ACTIONS(1),
    [anon_sym_texture_depth_cube_array] = ACTIONS(1),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(1),
    [anon_sym_texture_1d] = ACTIONS(1),
    [anon_sym_texture_2d] = ACTIONS(1),
    [anon_sym_texture_2d_array] = ACTIONS(1),
    [anon_sym_texture_3d] = ACTIONS(1),
    [anon_sym_texture_cube] = ACTIONS(1),
    [anon_sym_texture_cube_array] = ACTIONS(1),
    [anon_sym_texture_multisampled_2d] = ACTIONS(1),
    [anon_sym_texture_storage_1d] = ACTIONS(1),
    [anon_sym_texture_storage_2d] = ACTIONS(1),
    [anon_sym_texture_storage_2d_array] = ACTIONS(1),
    [anon_sym_texture_storage_3d] = ACTIONS(1),
    [anon_sym_r8unorm] = ACTIONS(1),
    [anon_sym_r8snorm] = ACTIONS(1),
    [anon_sym_r8uint] = ACTIONS(1),
    [anon_sym_r8sint] = ACTIONS(1),
    [anon_sym_rg8unorm] = ACTIONS(1),
    [anon_sym_rg8snorm] = ACTIONS(1),
    [anon_sym_rg8uint] = ACTIONS(1),
    [anon_sym_rg8sint] = ACTIONS(1),
    [anon_sym_r16uint] = ACTIONS(1),
    [anon_sym_r16sint] = ACTIONS(1),
    [anon_sym_r16float] = ACTIONS(1),
    [anon_sym_rg16uint] = ACTIONS(1),
    [anon_sym_rg16sint] = ACTIONS(1),
    [anon_sym_rg16float] = ACTIONS(1),
    [anon_sym_rgba16uint] = ACTIONS(1),
    [anon_sym_rgba16sint] = ACTIONS(1),
    [anon_sym_rgba16float] = ACTIONS(1),
    [anon_sym_r32uint] = ACTIONS(1),
    [anon_sym_r32sint] = ACTIONS(1),
    [anon_sym_r32float] = ACTIONS(1),
    [anon_sym_rg32uint] = ACTIONS(1),
    [anon_sym_rg32sint] = ACTIONS(1),
    [anon_sym_rg32float] = ACTIONS(1),
    [anon_sym_rgba32uint] = ACTIONS(1),
    [anon_sym_rgba32sint] = ACTIONS(1),
    [anon_sym_rgba32float] = ACTIONS(1),
    [anon_sym_rgba8unorm] = ACTIONS(1),
    [anon_sym_rgba8unorm_srgb] = ACTIONS(1),
    [anon_sym_rgba8snorm] = ACTIONS(1),
    [anon_sym_rgba8uint] = ACTIONS(1),
    [anon_sym_rgba8sint] = ACTIONS(1),
    [anon_sym_rg10a2unorm] = ACTIONS(1),
    [anon_sym_rg11b10float] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_workgroup] = ACTIONS(1),
    [anon_sym_uniform] = ACTIONS(1),
    [anon_sym_storage] = ACTIONS(1),
    [anon_sym_read] = ACTIONS(1),
    [anon_sym_write] = ACTIONS(1),
    [anon_sym_read_write] = ACTIONS(1),
    [anon_sym_bitcast] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(306),
    [sym_comment] = STATE(1),
    [sym__declaration] = STATE(132),
    [sym_global_variable_declaration] = STATE(305),
    [sym_global_constant_declaration] = STATE(305),
    [sym_type_alias] = STATE(305),
    [sym_function_declaration] = STATE(129),
    [sym_struct_declaration] = STATE(305),
    [sym_enable_directive] = STATE(305),
    [sym_attribute_list] = STATE(71),
    [sym_variable_declaration] = STATE(202),
    [aux_sym_source_file_repeat1] = STATE(125),
    [aux_sym_global_variable_declaration_repeat1] = STATE(146),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_let] = ACTIONS(9),
    [anon_sym_type] = ACTIONS(11),
    [anon_sym_fn] = ACTIONS(13),
    [anon_sym_struct] = ACTIONS(15),
    [anon_sym_enable] = ACTIONS(17),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
  },
  [2] = {
    [sym_comment] = STATE(2),
    [sym__statement] = STATE(32),
    [sym_compound_statement] = STATE(23),
    [sym_assignment_statement] = STATE(251),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_loop_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_continuing_statement] = STATE(266),
    [sym_return_statement] = STATE(251),
    [sym_discard_statement] = STATE(23),
    [sym_variable_statement] = STATE(251),
    [sym_variable_declaration] = STATE(197),
    [sym__expression] = STATE(121),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [aux_sym_compound_statement_repeat1] = STATE(5),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(33),
    [anon_sym_switch] = ACTIONS(35),
    [anon_sym_loop] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(41),
    [anon_sym_continue] = ACTIONS(43),
    [anon_sym_continuing] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_discard] = ACTIONS(49),
    [anon_sym_var] = ACTIONS(51),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [3] = {
    [sym_comment] = STATE(3),
    [sym__statement] = STATE(32),
    [sym_compound_statement] = STATE(23),
    [sym_assignment_statement] = STATE(251),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_loop_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_continuing_statement] = STATE(256),
    [sym_return_statement] = STATE(251),
    [sym_discard_statement] = STATE(23),
    [sym_variable_statement] = STATE(251),
    [sym_variable_declaration] = STATE(197),
    [sym__expression] = STATE(121),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [aux_sym_compound_statement_repeat1] = STATE(2),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(33),
    [anon_sym_switch] = ACTIONS(35),
    [anon_sym_loop] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(41),
    [anon_sym_continue] = ACTIONS(43),
    [anon_sym_continuing] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_discard] = ACTIONS(49),
    [anon_sym_var] = ACTIONS(51),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [4] = {
    [sym_comment] = STATE(4),
    [sym__statement] = STATE(8),
    [sym_compound_statement] = STATE(23),
    [sym_assignment_statement] = STATE(251),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_case_body] = STATE(318),
    [sym_loop_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_return_statement] = STATE(251),
    [sym_discard_statement] = STATE(23),
    [sym_variable_statement] = STATE(251),
    [sym_variable_declaration] = STATE(197),
    [sym__expression] = STATE(121),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(33),
    [anon_sym_switch] = ACTIONS(35),
    [anon_sym_fallthrough] = ACTIONS(83),
    [anon_sym_loop] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(41),
    [anon_sym_continue] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_discard] = ACTIONS(49),
    [anon_sym_var] = ACTIONS(51),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [5] = {
    [sym_comment] = STATE(5),
    [sym__statement] = STATE(32),
    [sym_compound_statement] = STATE(23),
    [sym_assignment_statement] = STATE(251),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_loop_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_return_statement] = STATE(251),
    [sym_discard_statement] = STATE(23),
    [sym_variable_statement] = STATE(251),
    [sym_variable_declaration] = STATE(197),
    [sym__expression] = STATE(121),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [aux_sym_compound_statement_repeat1] = STATE(5),
    [sym_identifier] = ACTIONS(85),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(88),
    [anon_sym_LPAREN] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(94),
    [anon_sym_RBRACE] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_switch] = ACTIONS(102),
    [anon_sym_loop] = ACTIONS(105),
    [anon_sym_for] = ACTIONS(108),
    [anon_sym_break] = ACTIONS(111),
    [anon_sym_continue] = ACTIONS(114),
    [anon_sym_continuing] = ACTIONS(117),
    [anon_sym_return] = ACTIONS(119),
    [anon_sym_discard] = ACTIONS(122),
    [anon_sym_var] = ACTIONS(125),
    [sym_int_literal] = ACTIONS(128),
    [sym_uint_literal] = ACTIONS(131),
    [aux_sym_float_literal_token1] = ACTIONS(134),
    [aux_sym_float_literal_token2] = ACTIONS(134),
    [sym_true] = ACTIONS(128),
    [sym_false] = ACTIONS(128),
    [anon_sym_bool] = ACTIONS(137),
    [anon_sym_u32] = ACTIONS(137),
    [anon_sym_i32] = ACTIONS(137),
    [anon_sym_f32] = ACTIONS(137),
    [anon_sym_vec2] = ACTIONS(140),
    [anon_sym_vec3] = ACTIONS(140),
    [anon_sym_vec4] = ACTIONS(140),
    [anon_sym_mat2x2] = ACTIONS(140),
    [anon_sym_mat2x3] = ACTIONS(140),
    [anon_sym_mat2x4] = ACTIONS(140),
    [anon_sym_mat3x2] = ACTIONS(140),
    [anon_sym_mat3x3] = ACTIONS(140),
    [anon_sym_mat3x4] = ACTIONS(140),
    [anon_sym_mat4x2] = ACTIONS(140),
    [anon_sym_mat4x3] = ACTIONS(140),
    [anon_sym_mat4x4] = ACTIONS(140),
    [anon_sym_atomic] = ACTIONS(143),
    [anon_sym_array] = ACTIONS(146),
    [anon_sym_ptr] = ACTIONS(149),
    [anon_sym_sampler] = ACTIONS(137),
    [anon_sym_sampler_comparison] = ACTIONS(137),
    [anon_sym_texture_depth_2d] = ACTIONS(137),
    [anon_sym_texture_depth_2d_array] = ACTIONS(137),
    [anon_sym_texture_depth_cube] = ACTIONS(137),
    [anon_sym_texture_depth_cube_array] = ACTIONS(137),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(137),
    [anon_sym_texture_1d] = ACTIONS(152),
    [anon_sym_texture_2d] = ACTIONS(152),
    [anon_sym_texture_2d_array] = ACTIONS(152),
    [anon_sym_texture_3d] = ACTIONS(152),
    [anon_sym_texture_cube] = ACTIONS(152),
    [anon_sym_texture_cube_array] = ACTIONS(152),
    [anon_sym_texture_multisampled_2d] = ACTIONS(152),
    [anon_sym_texture_storage_1d] = ACTIONS(155),
    [anon_sym_texture_storage_2d] = ACTIONS(155),
    [anon_sym_texture_storage_2d_array] = ACTIONS(155),
    [anon_sym_texture_storage_3d] = ACTIONS(155),
    [anon_sym_bitcast] = ACTIONS(158),
    [anon_sym_AMP] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(164),
    [anon_sym_STAR] = ACTIONS(161),
    [anon_sym_BANG] = ACTIONS(161),
    [anon_sym_TILDE] = ACTIONS(161),
  },
  [6] = {
    [sym_comment] = STATE(6),
    [sym__statement] = STATE(32),
    [sym_compound_statement] = STATE(23),
    [sym_assignment_statement] = STATE(251),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_loop_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_return_statement] = STATE(251),
    [sym_discard_statement] = STATE(23),
    [sym_variable_statement] = STATE(251),
    [sym_variable_declaration] = STATE(197),
    [sym__expression] = STATE(121),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [aux_sym_compound_statement_repeat1] = STATE(5),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(33),
    [anon_sym_switch] = ACTIONS(35),
    [anon_sym_loop] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(41),
    [anon_sym_continue] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_discard] = ACTIONS(49),
    [anon_sym_var] = ACTIONS(51),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [7] = {
    [sym_comment] = STATE(7),
    [sym__statement] = STATE(32),
    [sym_compound_statement] = STATE(23),
    [sym_assignment_statement] = STATE(251),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_loop_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_return_statement] = STATE(251),
    [sym_discard_statement] = STATE(23),
    [sym_variable_statement] = STATE(251),
    [sym_variable_declaration] = STATE(197),
    [sym__expression] = STATE(121),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [aux_sym_compound_statement_repeat1] = STATE(6),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(169),
    [anon_sym_if] = ACTIONS(33),
    [anon_sym_switch] = ACTIONS(35),
    [anon_sym_loop] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(41),
    [anon_sym_continue] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_discard] = ACTIONS(49),
    [anon_sym_var] = ACTIONS(51),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [8] = {
    [sym_comment] = STATE(8),
    [sym__statement] = STATE(8),
    [sym_compound_statement] = STATE(23),
    [sym_assignment_statement] = STATE(251),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_case_body] = STATE(320),
    [sym_loop_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_return_statement] = STATE(251),
    [sym_discard_statement] = STATE(23),
    [sym_variable_statement] = STATE(251),
    [sym_variable_declaration] = STATE(197),
    [sym__expression] = STATE(121),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(33),
    [anon_sym_switch] = ACTIONS(35),
    [anon_sym_fallthrough] = ACTIONS(83),
    [anon_sym_loop] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(41),
    [anon_sym_continue] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_discard] = ACTIONS(49),
    [anon_sym_var] = ACTIONS(51),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [9] = {
    [sym_comment] = STATE(9),
    [sym__statement] = STATE(8),
    [sym_compound_statement] = STATE(23),
    [sym_assignment_statement] = STATE(251),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_case_body] = STATE(314),
    [sym_loop_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_return_statement] = STATE(251),
    [sym_discard_statement] = STATE(23),
    [sym_variable_statement] = STATE(251),
    [sym_variable_declaration] = STATE(197),
    [sym__expression] = STATE(121),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(33),
    [anon_sym_switch] = ACTIONS(35),
    [anon_sym_fallthrough] = ACTIONS(83),
    [anon_sym_loop] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(41),
    [anon_sym_continue] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_discard] = ACTIONS(49),
    [anon_sym_var] = ACTIONS(51),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [10] = {
    [sym_comment] = STATE(10),
    [ts_builtin_sym_end] = ACTIONS(171),
    [sym_identifier] = ACTIONS(173),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_type] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(171),
    [anon_sym_fn] = ACTIONS(173),
    [anon_sym_struct] = ACTIONS(173),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(171),
    [anon_sym_enable] = ACTIONS(173),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(171),
    [anon_sym_if] = ACTIONS(173),
    [anon_sym_elseif] = ACTIONS(173),
    [anon_sym_else] = ACTIONS(173),
    [anon_sym_switch] = ACTIONS(173),
    [anon_sym_fallthrough] = ACTIONS(173),
    [anon_sym_loop] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(173),
    [anon_sym_continue] = ACTIONS(173),
    [anon_sym_continuing] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(173),
    [anon_sym_discard] = ACTIONS(173),
    [anon_sym_var] = ACTIONS(173),
    [sym_int_literal] = ACTIONS(173),
    [sym_uint_literal] = ACTIONS(171),
    [aux_sym_float_literal_token1] = ACTIONS(171),
    [aux_sym_float_literal_token2] = ACTIONS(171),
    [sym_true] = ACTIONS(173),
    [sym_false] = ACTIONS(173),
    [anon_sym_bool] = ACTIONS(173),
    [anon_sym_u32] = ACTIONS(173),
    [anon_sym_i32] = ACTIONS(173),
    [anon_sym_f32] = ACTIONS(173),
    [anon_sym_vec2] = ACTIONS(173),
    [anon_sym_vec3] = ACTIONS(173),
    [anon_sym_vec4] = ACTIONS(173),
    [anon_sym_mat2x2] = ACTIONS(173),
    [anon_sym_mat2x3] = ACTIONS(173),
    [anon_sym_mat2x4] = ACTIONS(173),
    [anon_sym_mat3x2] = ACTIONS(173),
    [anon_sym_mat3x3] = ACTIONS(173),
    [anon_sym_mat3x4] = ACTIONS(173),
    [anon_sym_mat4x2] = ACTIONS(173),
    [anon_sym_mat4x3] = ACTIONS(173),
    [anon_sym_mat4x4] = ACTIONS(173),
    [anon_sym_atomic] = ACTIONS(173),
    [anon_sym_array] = ACTIONS(173),
    [anon_sym_ptr] = ACTIONS(173),
    [anon_sym_sampler] = ACTIONS(173),
    [anon_sym_sampler_comparison] = ACTIONS(173),
    [anon_sym_texture_depth_2d] = ACTIONS(173),
    [anon_sym_texture_depth_2d_array] = ACTIONS(173),
    [anon_sym_texture_depth_cube] = ACTIONS(173),
    [anon_sym_texture_depth_cube_array] = ACTIONS(173),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(173),
    [anon_sym_texture_1d] = ACTIONS(173),
    [anon_sym_texture_2d] = ACTIONS(173),
    [anon_sym_texture_2d_array] = ACTIONS(173),
    [anon_sym_texture_3d] = ACTIONS(173),
    [anon_sym_texture_cube] = ACTIONS(173),
    [anon_sym_texture_cube_array] = ACTIONS(173),
    [anon_sym_texture_multisampled_2d] = ACTIONS(173),
    [anon_sym_texture_storage_1d] = ACTIONS(173),
    [anon_sym_texture_storage_2d] = ACTIONS(173),
    [anon_sym_texture_storage_2d_array] = ACTIONS(173),
    [anon_sym_texture_storage_3d] = ACTIONS(173),
    [anon_sym_bitcast] = ACTIONS(173),
    [anon_sym_AMP] = ACTIONS(171),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(171),
    [anon_sym_BANG] = ACTIONS(171),
    [anon_sym_TILDE] = ACTIONS(171),
  },
  [11] = {
    [sym_comment] = STATE(11),
    [ts_builtin_sym_end] = ACTIONS(175),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_let] = ACTIONS(177),
    [anon_sym_type] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_fn] = ACTIONS(177),
    [anon_sym_struct] = ACTIONS(177),
    [anon_sym_LBRACE] = ACTIONS(175),
    [anon_sym_RBRACE] = ACTIONS(175),
    [anon_sym_enable] = ACTIONS(177),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(175),
    [anon_sym_if] = ACTIONS(177),
    [anon_sym_elseif] = ACTIONS(177),
    [anon_sym_else] = ACTIONS(177),
    [anon_sym_switch] = ACTIONS(177),
    [anon_sym_fallthrough] = ACTIONS(177),
    [anon_sym_loop] = ACTIONS(177),
    [anon_sym_for] = ACTIONS(177),
    [anon_sym_break] = ACTIONS(177),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_continuing] = ACTIONS(177),
    [anon_sym_return] = ACTIONS(177),
    [anon_sym_discard] = ACTIONS(177),
    [anon_sym_var] = ACTIONS(177),
    [sym_int_literal] = ACTIONS(177),
    [sym_uint_literal] = ACTIONS(175),
    [aux_sym_float_literal_token1] = ACTIONS(175),
    [aux_sym_float_literal_token2] = ACTIONS(175),
    [sym_true] = ACTIONS(177),
    [sym_false] = ACTIONS(177),
    [anon_sym_bool] = ACTIONS(177),
    [anon_sym_u32] = ACTIONS(177),
    [anon_sym_i32] = ACTIONS(177),
    [anon_sym_f32] = ACTIONS(177),
    [anon_sym_vec2] = ACTIONS(177),
    [anon_sym_vec3] = ACTIONS(177),
    [anon_sym_vec4] = ACTIONS(177),
    [anon_sym_mat2x2] = ACTIONS(177),
    [anon_sym_mat2x3] = ACTIONS(177),
    [anon_sym_mat2x4] = ACTIONS(177),
    [anon_sym_mat3x2] = ACTIONS(177),
    [anon_sym_mat3x3] = ACTIONS(177),
    [anon_sym_mat3x4] = ACTIONS(177),
    [anon_sym_mat4x2] = ACTIONS(177),
    [anon_sym_mat4x3] = ACTIONS(177),
    [anon_sym_mat4x4] = ACTIONS(177),
    [anon_sym_atomic] = ACTIONS(177),
    [anon_sym_array] = ACTIONS(177),
    [anon_sym_ptr] = ACTIONS(177),
    [anon_sym_sampler] = ACTIONS(177),
    [anon_sym_sampler_comparison] = ACTIONS(177),
    [anon_sym_texture_depth_2d] = ACTIONS(177),
    [anon_sym_texture_depth_2d_array] = ACTIONS(177),
    [anon_sym_texture_depth_cube] = ACTIONS(177),
    [anon_sym_texture_depth_cube_array] = ACTIONS(177),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(177),
    [anon_sym_texture_1d] = ACTIONS(177),
    [anon_sym_texture_2d] = ACTIONS(177),
    [anon_sym_texture_2d_array] = ACTIONS(177),
    [anon_sym_texture_3d] = ACTIONS(177),
    [anon_sym_texture_cube] = ACTIONS(177),
    [anon_sym_texture_cube_array] = ACTIONS(177),
    [anon_sym_texture_multisampled_2d] = ACTIONS(177),
    [anon_sym_texture_storage_1d] = ACTIONS(177),
    [anon_sym_texture_storage_2d] = ACTIONS(177),
    [anon_sym_texture_storage_2d_array] = ACTIONS(177),
    [anon_sym_texture_storage_3d] = ACTIONS(177),
    [anon_sym_bitcast] = ACTIONS(177),
    [anon_sym_AMP] = ACTIONS(175),
    [anon_sym_DASH] = ACTIONS(177),
    [anon_sym_STAR] = ACTIONS(175),
    [anon_sym_BANG] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(175),
  },
  [12] = {
    [sym_comment] = STATE(12),
    [sym_elseif_statement] = STATE(16),
    [sym_else_statement] = STATE(26),
    [aux_sym_if_statement_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(179),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(179),
    [anon_sym_LPAREN] = ACTIONS(181),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_RBRACE] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(179),
    [anon_sym_elseif] = ACTIONS(183),
    [anon_sym_else] = ACTIONS(185),
    [anon_sym_switch] = ACTIONS(179),
    [anon_sym_fallthrough] = ACTIONS(179),
    [anon_sym_loop] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(179),
    [anon_sym_break] = ACTIONS(179),
    [anon_sym_continue] = ACTIONS(179),
    [anon_sym_continuing] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(179),
    [anon_sym_discard] = ACTIONS(179),
    [anon_sym_var] = ACTIONS(179),
    [sym_int_literal] = ACTIONS(179),
    [sym_uint_literal] = ACTIONS(181),
    [aux_sym_float_literal_token1] = ACTIONS(181),
    [aux_sym_float_literal_token2] = ACTIONS(181),
    [sym_true] = ACTIONS(179),
    [sym_false] = ACTIONS(179),
    [anon_sym_bool] = ACTIONS(179),
    [anon_sym_u32] = ACTIONS(179),
    [anon_sym_i32] = ACTIONS(179),
    [anon_sym_f32] = ACTIONS(179),
    [anon_sym_vec2] = ACTIONS(179),
    [anon_sym_vec3] = ACTIONS(179),
    [anon_sym_vec4] = ACTIONS(179),
    [anon_sym_mat2x2] = ACTIONS(179),
    [anon_sym_mat2x3] = ACTIONS(179),
    [anon_sym_mat2x4] = ACTIONS(179),
    [anon_sym_mat3x2] = ACTIONS(179),
    [anon_sym_mat3x3] = ACTIONS(179),
    [anon_sym_mat3x4] = ACTIONS(179),
    [anon_sym_mat4x2] = ACTIONS(179),
    [anon_sym_mat4x3] = ACTIONS(179),
    [anon_sym_mat4x4] = ACTIONS(179),
    [anon_sym_atomic] = ACTIONS(179),
    [anon_sym_array] = ACTIONS(179),
    [anon_sym_ptr] = ACTIONS(179),
    [anon_sym_sampler] = ACTIONS(179),
    [anon_sym_sampler_comparison] = ACTIONS(179),
    [anon_sym_texture_depth_2d] = ACTIONS(179),
    [anon_sym_texture_depth_2d_array] = ACTIONS(179),
    [anon_sym_texture_depth_cube] = ACTIONS(179),
    [anon_sym_texture_depth_cube_array] = ACTIONS(179),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(179),
    [anon_sym_texture_1d] = ACTIONS(179),
    [anon_sym_texture_2d] = ACTIONS(179),
    [anon_sym_texture_2d_array] = ACTIONS(179),
    [anon_sym_texture_3d] = ACTIONS(179),
    [anon_sym_texture_cube] = ACTIONS(179),
    [anon_sym_texture_cube_array] = ACTIONS(179),
    [anon_sym_texture_multisampled_2d] = ACTIONS(179),
    [anon_sym_texture_storage_1d] = ACTIONS(179),
    [anon_sym_texture_storage_2d] = ACTIONS(179),
    [anon_sym_texture_storage_2d_array] = ACTIONS(179),
    [anon_sym_texture_storage_3d] = ACTIONS(179),
    [anon_sym_bitcast] = ACTIONS(179),
    [anon_sym_AMP] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(179),
    [anon_sym_STAR] = ACTIONS(181),
    [anon_sym_BANG] = ACTIONS(181),
    [anon_sym_TILDE] = ACTIONS(181),
  },
  [13] = {
    [sym_comment] = STATE(13),
    [sym_elseif_statement] = STATE(16),
    [sym_else_statement] = STATE(19),
    [aux_sym_if_statement_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(187),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(187),
    [anon_sym_LPAREN] = ACTIONS(189),
    [anon_sym_LBRACE] = ACTIONS(189),
    [anon_sym_RBRACE] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(187),
    [anon_sym_elseif] = ACTIONS(183),
    [anon_sym_else] = ACTIONS(185),
    [anon_sym_switch] = ACTIONS(187),
    [anon_sym_fallthrough] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_continuing] = ACTIONS(187),
    [anon_sym_return] = ACTIONS(187),
    [anon_sym_discard] = ACTIONS(187),
    [anon_sym_var] = ACTIONS(187),
    [sym_int_literal] = ACTIONS(187),
    [sym_uint_literal] = ACTIONS(189),
    [aux_sym_float_literal_token1] = ACTIONS(189),
    [aux_sym_float_literal_token2] = ACTIONS(189),
    [sym_true] = ACTIONS(187),
    [sym_false] = ACTIONS(187),
    [anon_sym_bool] = ACTIONS(187),
    [anon_sym_u32] = ACTIONS(187),
    [anon_sym_i32] = ACTIONS(187),
    [anon_sym_f32] = ACTIONS(187),
    [anon_sym_vec2] = ACTIONS(187),
    [anon_sym_vec3] = ACTIONS(187),
    [anon_sym_vec4] = ACTIONS(187),
    [anon_sym_mat2x2] = ACTIONS(187),
    [anon_sym_mat2x3] = ACTIONS(187),
    [anon_sym_mat2x4] = ACTIONS(187),
    [anon_sym_mat3x2] = ACTIONS(187),
    [anon_sym_mat3x3] = ACTIONS(187),
    [anon_sym_mat3x4] = ACTIONS(187),
    [anon_sym_mat4x2] = ACTIONS(187),
    [anon_sym_mat4x3] = ACTIONS(187),
    [anon_sym_mat4x4] = ACTIONS(187),
    [anon_sym_atomic] = ACTIONS(187),
    [anon_sym_array] = ACTIONS(187),
    [anon_sym_ptr] = ACTIONS(187),
    [anon_sym_sampler] = ACTIONS(187),
    [anon_sym_sampler_comparison] = ACTIONS(187),
    [anon_sym_texture_depth_2d] = ACTIONS(187),
    [anon_sym_texture_depth_2d_array] = ACTIONS(187),
    [anon_sym_texture_depth_cube] = ACTIONS(187),
    [anon_sym_texture_depth_cube_array] = ACTIONS(187),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(187),
    [anon_sym_texture_1d] = ACTIONS(187),
    [anon_sym_texture_2d] = ACTIONS(187),
    [anon_sym_texture_2d_array] = ACTIONS(187),
    [anon_sym_texture_3d] = ACTIONS(187),
    [anon_sym_texture_cube] = ACTIONS(187),
    [anon_sym_texture_cube_array] = ACTIONS(187),
    [anon_sym_texture_multisampled_2d] = ACTIONS(187),
    [anon_sym_texture_storage_1d] = ACTIONS(187),
    [anon_sym_texture_storage_2d] = ACTIONS(187),
    [anon_sym_texture_storage_2d_array] = ACTIONS(187),
    [anon_sym_texture_storage_3d] = ACTIONS(187),
    [anon_sym_bitcast] = ACTIONS(187),
    [anon_sym_AMP] = ACTIONS(189),
    [anon_sym_DASH] = ACTIONS(187),
    [anon_sym_STAR] = ACTIONS(189),
    [anon_sym_BANG] = ACTIONS(189),
    [anon_sym_TILDE] = ACTIONS(189),
  },
  [14] = {
    [sym_comment] = STATE(14),
    [sym_elseif_statement] = STATE(16),
    [aux_sym_if_statement_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(191),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(191),
    [anon_sym_LPAREN] = ACTIONS(193),
    [anon_sym_LBRACE] = ACTIONS(193),
    [anon_sym_RBRACE] = ACTIONS(193),
    [anon_sym_if] = ACTIONS(191),
    [anon_sym_elseif] = ACTIONS(195),
    [anon_sym_else] = ACTIONS(191),
    [anon_sym_switch] = ACTIONS(191),
    [anon_sym_fallthrough] = ACTIONS(191),
    [anon_sym_loop] = ACTIONS(191),
    [anon_sym_for] = ACTIONS(191),
    [anon_sym_break] = ACTIONS(191),
    [anon_sym_continue] = ACTIONS(191),
    [anon_sym_continuing] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(191),
    [anon_sym_discard] = ACTIONS(191),
    [anon_sym_var] = ACTIONS(191),
    [sym_int_literal] = ACTIONS(191),
    [sym_uint_literal] = ACTIONS(193),
    [aux_sym_float_literal_token1] = ACTIONS(193),
    [aux_sym_float_literal_token2] = ACTIONS(193),
    [sym_true] = ACTIONS(191),
    [sym_false] = ACTIONS(191),
    [anon_sym_bool] = ACTIONS(191),
    [anon_sym_u32] = ACTIONS(191),
    [anon_sym_i32] = ACTIONS(191),
    [anon_sym_f32] = ACTIONS(191),
    [anon_sym_vec2] = ACTIONS(191),
    [anon_sym_vec3] = ACTIONS(191),
    [anon_sym_vec4] = ACTIONS(191),
    [anon_sym_mat2x2] = ACTIONS(191),
    [anon_sym_mat2x3] = ACTIONS(191),
    [anon_sym_mat2x4] = ACTIONS(191),
    [anon_sym_mat3x2] = ACTIONS(191),
    [anon_sym_mat3x3] = ACTIONS(191),
    [anon_sym_mat3x4] = ACTIONS(191),
    [anon_sym_mat4x2] = ACTIONS(191),
    [anon_sym_mat4x3] = ACTIONS(191),
    [anon_sym_mat4x4] = ACTIONS(191),
    [anon_sym_atomic] = ACTIONS(191),
    [anon_sym_array] = ACTIONS(191),
    [anon_sym_ptr] = ACTIONS(191),
    [anon_sym_sampler] = ACTIONS(191),
    [anon_sym_sampler_comparison] = ACTIONS(191),
    [anon_sym_texture_depth_2d] = ACTIONS(191),
    [anon_sym_texture_depth_2d_array] = ACTIONS(191),
    [anon_sym_texture_depth_cube] = ACTIONS(191),
    [anon_sym_texture_depth_cube_array] = ACTIONS(191),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(191),
    [anon_sym_texture_1d] = ACTIONS(191),
    [anon_sym_texture_2d] = ACTIONS(191),
    [anon_sym_texture_2d_array] = ACTIONS(191),
    [anon_sym_texture_3d] = ACTIONS(191),
    [anon_sym_texture_cube] = ACTIONS(191),
    [anon_sym_texture_cube_array] = ACTIONS(191),
    [anon_sym_texture_multisampled_2d] = ACTIONS(191),
    [anon_sym_texture_storage_1d] = ACTIONS(191),
    [anon_sym_texture_storage_2d] = ACTIONS(191),
    [anon_sym_texture_storage_2d_array] = ACTIONS(191),
    [anon_sym_texture_storage_3d] = ACTIONS(191),
    [anon_sym_bitcast] = ACTIONS(191),
    [anon_sym_AMP] = ACTIONS(193),
    [anon_sym_DASH] = ACTIONS(191),
    [anon_sym_STAR] = ACTIONS(193),
    [anon_sym_BANG] = ACTIONS(193),
    [anon_sym_TILDE] = ACTIONS(193),
  },
  [15] = {
    [sym_comment] = STATE(15),
    [sym_assignment_statement] = STATE(247),
    [sym_for_header] = STATE(239),
    [sym_variable_statement] = STATE(247),
    [sym_variable_declaration] = STATE(197),
    [sym__expression] = STATE(121),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(110),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(198),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_var] = ACTIONS(51),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [16] = {
    [sym_comment] = STATE(16),
    [sym_identifier] = ACTIONS(200),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(200),
    [anon_sym_LPAREN] = ACTIONS(202),
    [anon_sym_LBRACE] = ACTIONS(202),
    [anon_sym_RBRACE] = ACTIONS(202),
    [anon_sym_if] = ACTIONS(200),
    [anon_sym_elseif] = ACTIONS(200),
    [anon_sym_else] = ACTIONS(200),
    [anon_sym_switch] = ACTIONS(200),
    [anon_sym_fallthrough] = ACTIONS(200),
    [anon_sym_loop] = ACTIONS(200),
    [anon_sym_for] = ACTIONS(200),
    [anon_sym_break] = ACTIONS(200),
    [anon_sym_continue] = ACTIONS(200),
    [anon_sym_continuing] = ACTIONS(200),
    [anon_sym_return] = ACTIONS(200),
    [anon_sym_discard] = ACTIONS(200),
    [anon_sym_var] = ACTIONS(200),
    [sym_int_literal] = ACTIONS(200),
    [sym_uint_literal] = ACTIONS(202),
    [aux_sym_float_literal_token1] = ACTIONS(202),
    [aux_sym_float_literal_token2] = ACTIONS(202),
    [sym_true] = ACTIONS(200),
    [sym_false] = ACTIONS(200),
    [anon_sym_bool] = ACTIONS(200),
    [anon_sym_u32] = ACTIONS(200),
    [anon_sym_i32] = ACTIONS(200),
    [anon_sym_f32] = ACTIONS(200),
    [anon_sym_vec2] = ACTIONS(200),
    [anon_sym_vec3] = ACTIONS(200),
    [anon_sym_vec4] = ACTIONS(200),
    [anon_sym_mat2x2] = ACTIONS(200),
    [anon_sym_mat2x3] = ACTIONS(200),
    [anon_sym_mat2x4] = ACTIONS(200),
    [anon_sym_mat3x2] = ACTIONS(200),
    [anon_sym_mat3x3] = ACTIONS(200),
    [anon_sym_mat3x4] = ACTIONS(200),
    [anon_sym_mat4x2] = ACTIONS(200),
    [anon_sym_mat4x3] = ACTIONS(200),
    [anon_sym_mat4x4] = ACTIONS(200),
    [anon_sym_atomic] = ACTIONS(200),
    [anon_sym_array] = ACTIONS(200),
    [anon_sym_ptr] = ACTIONS(200),
    [anon_sym_sampler] = ACTIONS(200),
    [anon_sym_sampler_comparison] = ACTIONS(200),
    [anon_sym_texture_depth_2d] = ACTIONS(200),
    [anon_sym_texture_depth_2d_array] = ACTIONS(200),
    [anon_sym_texture_depth_cube] = ACTIONS(200),
    [anon_sym_texture_depth_cube_array] = ACTIONS(200),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(200),
    [anon_sym_texture_1d] = ACTIONS(200),
    [anon_sym_texture_2d] = ACTIONS(200),
    [anon_sym_texture_2d_array] = ACTIONS(200),
    [anon_sym_texture_3d] = ACTIONS(200),
    [anon_sym_texture_cube] = ACTIONS(200),
    [anon_sym_texture_cube_array] = ACTIONS(200),
    [anon_sym_texture_multisampled_2d] = ACTIONS(200),
    [anon_sym_texture_storage_1d] = ACTIONS(200),
    [anon_sym_texture_storage_2d] = ACTIONS(200),
    [anon_sym_texture_storage_2d_array] = ACTIONS(200),
    [anon_sym_texture_storage_3d] = ACTIONS(200),
    [anon_sym_bitcast] = ACTIONS(200),
    [anon_sym_AMP] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(200),
    [anon_sym_STAR] = ACTIONS(202),
    [anon_sym_BANG] = ACTIONS(202),
    [anon_sym_TILDE] = ACTIONS(202),
  },
  [17] = {
    [sym_comment] = STATE(17),
    [sym_identifier] = ACTIONS(204),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(204),
    [anon_sym_LPAREN] = ACTIONS(206),
    [anon_sym_LBRACE] = ACTIONS(206),
    [anon_sym_RBRACE] = ACTIONS(206),
    [anon_sym_if] = ACTIONS(204),
    [anon_sym_elseif] = ACTIONS(204),
    [anon_sym_else] = ACTIONS(204),
    [anon_sym_switch] = ACTIONS(204),
    [anon_sym_fallthrough] = ACTIONS(204),
    [anon_sym_loop] = ACTIONS(204),
    [anon_sym_for] = ACTIONS(204),
    [anon_sym_break] = ACTIONS(204),
    [anon_sym_continue] = ACTIONS(204),
    [anon_sym_continuing] = ACTIONS(204),
    [anon_sym_return] = ACTIONS(204),
    [anon_sym_discard] = ACTIONS(204),
    [anon_sym_var] = ACTIONS(204),
    [sym_int_literal] = ACTIONS(204),
    [sym_uint_literal] = ACTIONS(206),
    [aux_sym_float_literal_token1] = ACTIONS(206),
    [aux_sym_float_literal_token2] = ACTIONS(206),
    [sym_true] = ACTIONS(204),
    [sym_false] = ACTIONS(204),
    [anon_sym_bool] = ACTIONS(204),
    [anon_sym_u32] = ACTIONS(204),
    [anon_sym_i32] = ACTIONS(204),
    [anon_sym_f32] = ACTIONS(204),
    [anon_sym_vec2] = ACTIONS(204),
    [anon_sym_vec3] = ACTIONS(204),
    [anon_sym_vec4] = ACTIONS(204),
    [anon_sym_mat2x2] = ACTIONS(204),
    [anon_sym_mat2x3] = ACTIONS(204),
    [anon_sym_mat2x4] = ACTIONS(204),
    [anon_sym_mat3x2] = ACTIONS(204),
    [anon_sym_mat3x3] = ACTIONS(204),
    [anon_sym_mat3x4] = ACTIONS(204),
    [anon_sym_mat4x2] = ACTIONS(204),
    [anon_sym_mat4x3] = ACTIONS(204),
    [anon_sym_mat4x4] = ACTIONS(204),
    [anon_sym_atomic] = ACTIONS(204),
    [anon_sym_array] = ACTIONS(204),
    [anon_sym_ptr] = ACTIONS(204),
    [anon_sym_sampler] = ACTIONS(204),
    [anon_sym_sampler_comparison] = ACTIONS(204),
    [anon_sym_texture_depth_2d] = ACTIONS(204),
    [anon_sym_texture_depth_2d_array] = ACTIONS(204),
    [anon_sym_texture_depth_cube] = ACTIONS(204),
    [anon_sym_texture_depth_cube_array] = ACTIONS(204),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(204),
    [anon_sym_texture_1d] = ACTIONS(204),
    [anon_sym_texture_2d] = ACTIONS(204),
    [anon_sym_texture_2d_array] = ACTIONS(204),
    [anon_sym_texture_3d] = ACTIONS(204),
    [anon_sym_texture_cube] = ACTIONS(204),
    [anon_sym_texture_cube_array] = ACTIONS(204),
    [anon_sym_texture_multisampled_2d] = ACTIONS(204),
    [anon_sym_texture_storage_1d] = ACTIONS(204),
    [anon_sym_texture_storage_2d] = ACTIONS(204),
    [anon_sym_texture_storage_2d_array] = ACTIONS(204),
    [anon_sym_texture_storage_3d] = ACTIONS(204),
    [anon_sym_bitcast] = ACTIONS(204),
    [anon_sym_AMP] = ACTIONS(206),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_STAR] = ACTIONS(206),
    [anon_sym_BANG] = ACTIONS(206),
    [anon_sym_TILDE] = ACTIONS(206),
  },
  [18] = {
    [sym_comment] = STATE(18),
    [sym_identifier] = ACTIONS(208),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(210),
    [anon_sym_LBRACE] = ACTIONS(210),
    [anon_sym_RBRACE] = ACTIONS(210),
    [anon_sym_if] = ACTIONS(208),
    [anon_sym_switch] = ACTIONS(208),
    [anon_sym_fallthrough] = ACTIONS(208),
    [anon_sym_loop] = ACTIONS(208),
    [anon_sym_for] = ACTIONS(208),
    [anon_sym_break] = ACTIONS(208),
    [anon_sym_continue] = ACTIONS(208),
    [anon_sym_continuing] = ACTIONS(208),
    [anon_sym_return] = ACTIONS(208),
    [anon_sym_discard] = ACTIONS(208),
    [anon_sym_var] = ACTIONS(208),
    [sym_int_literal] = ACTIONS(208),
    [sym_uint_literal] = ACTIONS(210),
    [aux_sym_float_literal_token1] = ACTIONS(210),
    [aux_sym_float_literal_token2] = ACTIONS(210),
    [sym_true] = ACTIONS(208),
    [sym_false] = ACTIONS(208),
    [anon_sym_bool] = ACTIONS(208),
    [anon_sym_u32] = ACTIONS(208),
    [anon_sym_i32] = ACTIONS(208),
    [anon_sym_f32] = ACTIONS(208),
    [anon_sym_vec2] = ACTIONS(208),
    [anon_sym_vec3] = ACTIONS(208),
    [anon_sym_vec4] = ACTIONS(208),
    [anon_sym_mat2x2] = ACTIONS(208),
    [anon_sym_mat2x3] = ACTIONS(208),
    [anon_sym_mat2x4] = ACTIONS(208),
    [anon_sym_mat3x2] = ACTIONS(208),
    [anon_sym_mat3x3] = ACTIONS(208),
    [anon_sym_mat3x4] = ACTIONS(208),
    [anon_sym_mat4x2] = ACTIONS(208),
    [anon_sym_mat4x3] = ACTIONS(208),
    [anon_sym_mat4x4] = ACTIONS(208),
    [anon_sym_atomic] = ACTIONS(208),
    [anon_sym_array] = ACTIONS(208),
    [anon_sym_ptr] = ACTIONS(208),
    [anon_sym_sampler] = ACTIONS(208),
    [anon_sym_sampler_comparison] = ACTIONS(208),
    [anon_sym_texture_depth_2d] = ACTIONS(208),
    [anon_sym_texture_depth_2d_array] = ACTIONS(208),
    [anon_sym_texture_depth_cube] = ACTIONS(208),
    [anon_sym_texture_depth_cube_array] = ACTIONS(208),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(208),
    [anon_sym_texture_1d] = ACTIONS(208),
    [anon_sym_texture_2d] = ACTIONS(208),
    [anon_sym_texture_2d_array] = ACTIONS(208),
    [anon_sym_texture_3d] = ACTIONS(208),
    [anon_sym_texture_cube] = ACTIONS(208),
    [anon_sym_texture_cube_array] = ACTIONS(208),
    [anon_sym_texture_multisampled_2d] = ACTIONS(208),
    [anon_sym_texture_storage_1d] = ACTIONS(208),
    [anon_sym_texture_storage_2d] = ACTIONS(208),
    [anon_sym_texture_storage_2d_array] = ACTIONS(208),
    [anon_sym_texture_storage_3d] = ACTIONS(208),
    [anon_sym_bitcast] = ACTIONS(208),
    [anon_sym_AMP] = ACTIONS(210),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_STAR] = ACTIONS(210),
    [anon_sym_BANG] = ACTIONS(210),
    [anon_sym_TILDE] = ACTIONS(210),
  },
  [19] = {
    [sym_comment] = STATE(19),
    [sym_identifier] = ACTIONS(212),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(212),
    [anon_sym_LPAREN] = ACTIONS(214),
    [anon_sym_LBRACE] = ACTIONS(214),
    [anon_sym_RBRACE] = ACTIONS(214),
    [anon_sym_if] = ACTIONS(212),
    [anon_sym_switch] = ACTIONS(212),
    [anon_sym_fallthrough] = ACTIONS(212),
    [anon_sym_loop] = ACTIONS(212),
    [anon_sym_for] = ACTIONS(212),
    [anon_sym_break] = ACTIONS(212),
    [anon_sym_continue] = ACTIONS(212),
    [anon_sym_continuing] = ACTIONS(212),
    [anon_sym_return] = ACTIONS(212),
    [anon_sym_discard] = ACTIONS(212),
    [anon_sym_var] = ACTIONS(212),
    [sym_int_literal] = ACTIONS(212),
    [sym_uint_literal] = ACTIONS(214),
    [aux_sym_float_literal_token1] = ACTIONS(214),
    [aux_sym_float_literal_token2] = ACTIONS(214),
    [sym_true] = ACTIONS(212),
    [sym_false] = ACTIONS(212),
    [anon_sym_bool] = ACTIONS(212),
    [anon_sym_u32] = ACTIONS(212),
    [anon_sym_i32] = ACTIONS(212),
    [anon_sym_f32] = ACTIONS(212),
    [anon_sym_vec2] = ACTIONS(212),
    [anon_sym_vec3] = ACTIONS(212),
    [anon_sym_vec4] = ACTIONS(212),
    [anon_sym_mat2x2] = ACTIONS(212),
    [anon_sym_mat2x3] = ACTIONS(212),
    [anon_sym_mat2x4] = ACTIONS(212),
    [anon_sym_mat3x2] = ACTIONS(212),
    [anon_sym_mat3x3] = ACTIONS(212),
    [anon_sym_mat3x4] = ACTIONS(212),
    [anon_sym_mat4x2] = ACTIONS(212),
    [anon_sym_mat4x3] = ACTIONS(212),
    [anon_sym_mat4x4] = ACTIONS(212),
    [anon_sym_atomic] = ACTIONS(212),
    [anon_sym_array] = ACTIONS(212),
    [anon_sym_ptr] = ACTIONS(212),
    [anon_sym_sampler] = ACTIONS(212),
    [anon_sym_sampler_comparison] = ACTIONS(212),
    [anon_sym_texture_depth_2d] = ACTIONS(212),
    [anon_sym_texture_depth_2d_array] = ACTIONS(212),
    [anon_sym_texture_depth_cube] = ACTIONS(212),
    [anon_sym_texture_depth_cube_array] = ACTIONS(212),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(212),
    [anon_sym_texture_1d] = ACTIONS(212),
    [anon_sym_texture_2d] = ACTIONS(212),
    [anon_sym_texture_2d_array] = ACTIONS(212),
    [anon_sym_texture_3d] = ACTIONS(212),
    [anon_sym_texture_cube] = ACTIONS(212),
    [anon_sym_texture_cube_array] = ACTIONS(212),
    [anon_sym_texture_multisampled_2d] = ACTIONS(212),
    [anon_sym_texture_storage_1d] = ACTIONS(212),
    [anon_sym_texture_storage_2d] = ACTIONS(212),
    [anon_sym_texture_storage_2d_array] = ACTIONS(212),
    [anon_sym_texture_storage_3d] = ACTIONS(212),
    [anon_sym_bitcast] = ACTIONS(212),
    [anon_sym_AMP] = ACTIONS(214),
    [anon_sym_DASH] = ACTIONS(212),
    [anon_sym_STAR] = ACTIONS(214),
    [anon_sym_BANG] = ACTIONS(214),
    [anon_sym_TILDE] = ACTIONS(214),
  },
  [20] = {
    [sym_comment] = STATE(20),
    [sym_identifier] = ACTIONS(216),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(216),
    [anon_sym_LPAREN] = ACTIONS(218),
    [anon_sym_LBRACE] = ACTIONS(218),
    [anon_sym_RBRACE] = ACTIONS(218),
    [anon_sym_if] = ACTIONS(216),
    [anon_sym_switch] = ACTIONS(216),
    [anon_sym_fallthrough] = ACTIONS(216),
    [anon_sym_loop] = ACTIONS(216),
    [anon_sym_for] = ACTIONS(216),
    [anon_sym_break] = ACTIONS(216),
    [anon_sym_continue] = ACTIONS(216),
    [anon_sym_continuing] = ACTIONS(216),
    [anon_sym_return] = ACTIONS(216),
    [anon_sym_discard] = ACTIONS(216),
    [anon_sym_var] = ACTIONS(216),
    [sym_int_literal] = ACTIONS(216),
    [sym_uint_literal] = ACTIONS(218),
    [aux_sym_float_literal_token1] = ACTIONS(218),
    [aux_sym_float_literal_token2] = ACTIONS(218),
    [sym_true] = ACTIONS(216),
    [sym_false] = ACTIONS(216),
    [anon_sym_bool] = ACTIONS(216),
    [anon_sym_u32] = ACTIONS(216),
    [anon_sym_i32] = ACTIONS(216),
    [anon_sym_f32] = ACTIONS(216),
    [anon_sym_vec2] = ACTIONS(216),
    [anon_sym_vec3] = ACTIONS(216),
    [anon_sym_vec4] = ACTIONS(216),
    [anon_sym_mat2x2] = ACTIONS(216),
    [anon_sym_mat2x3] = ACTIONS(216),
    [anon_sym_mat2x4] = ACTIONS(216),
    [anon_sym_mat3x2] = ACTIONS(216),
    [anon_sym_mat3x3] = ACTIONS(216),
    [anon_sym_mat3x4] = ACTIONS(216),
    [anon_sym_mat4x2] = ACTIONS(216),
    [anon_sym_mat4x3] = ACTIONS(216),
    [anon_sym_mat4x4] = ACTIONS(216),
    [anon_sym_atomic] = ACTIONS(216),
    [anon_sym_array] = ACTIONS(216),
    [anon_sym_ptr] = ACTIONS(216),
    [anon_sym_sampler] = ACTIONS(216),
    [anon_sym_sampler_comparison] = ACTIONS(216),
    [anon_sym_texture_depth_2d] = ACTIONS(216),
    [anon_sym_texture_depth_2d_array] = ACTIONS(216),
    [anon_sym_texture_depth_cube] = ACTIONS(216),
    [anon_sym_texture_depth_cube_array] = ACTIONS(216),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(216),
    [anon_sym_texture_1d] = ACTIONS(216),
    [anon_sym_texture_2d] = ACTIONS(216),
    [anon_sym_texture_2d_array] = ACTIONS(216),
    [anon_sym_texture_3d] = ACTIONS(216),
    [anon_sym_texture_cube] = ACTIONS(216),
    [anon_sym_texture_cube_array] = ACTIONS(216),
    [anon_sym_texture_multisampled_2d] = ACTIONS(216),
    [anon_sym_texture_storage_1d] = ACTIONS(216),
    [anon_sym_texture_storage_2d] = ACTIONS(216),
    [anon_sym_texture_storage_2d_array] = ACTIONS(216),
    [anon_sym_texture_storage_3d] = ACTIONS(216),
    [anon_sym_bitcast] = ACTIONS(216),
    [anon_sym_AMP] = ACTIONS(218),
    [anon_sym_DASH] = ACTIONS(216),
    [anon_sym_STAR] = ACTIONS(218),
    [anon_sym_BANG] = ACTIONS(218),
    [anon_sym_TILDE] = ACTIONS(218),
  },
  [21] = {
    [sym_comment] = STATE(21),
    [sym_identifier] = ACTIONS(220),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(220),
    [anon_sym_LPAREN] = ACTIONS(222),
    [anon_sym_LBRACE] = ACTIONS(222),
    [anon_sym_RBRACE] = ACTIONS(222),
    [anon_sym_if] = ACTIONS(220),
    [anon_sym_switch] = ACTIONS(220),
    [anon_sym_fallthrough] = ACTIONS(220),
    [anon_sym_loop] = ACTIONS(220),
    [anon_sym_for] = ACTIONS(220),
    [anon_sym_break] = ACTIONS(220),
    [anon_sym_continue] = ACTIONS(220),
    [anon_sym_continuing] = ACTIONS(220),
    [anon_sym_return] = ACTIONS(220),
    [anon_sym_discard] = ACTIONS(220),
    [anon_sym_var] = ACTIONS(220),
    [sym_int_literal] = ACTIONS(220),
    [sym_uint_literal] = ACTIONS(222),
    [aux_sym_float_literal_token1] = ACTIONS(222),
    [aux_sym_float_literal_token2] = ACTIONS(222),
    [sym_true] = ACTIONS(220),
    [sym_false] = ACTIONS(220),
    [anon_sym_bool] = ACTIONS(220),
    [anon_sym_u32] = ACTIONS(220),
    [anon_sym_i32] = ACTIONS(220),
    [anon_sym_f32] = ACTIONS(220),
    [anon_sym_vec2] = ACTIONS(220),
    [anon_sym_vec3] = ACTIONS(220),
    [anon_sym_vec4] = ACTIONS(220),
    [anon_sym_mat2x2] = ACTIONS(220),
    [anon_sym_mat2x3] = ACTIONS(220),
    [anon_sym_mat2x4] = ACTIONS(220),
    [anon_sym_mat3x2] = ACTIONS(220),
    [anon_sym_mat3x3] = ACTIONS(220),
    [anon_sym_mat3x4] = ACTIONS(220),
    [anon_sym_mat4x2] = ACTIONS(220),
    [anon_sym_mat4x3] = ACTIONS(220),
    [anon_sym_mat4x4] = ACTIONS(220),
    [anon_sym_atomic] = ACTIONS(220),
    [anon_sym_array] = ACTIONS(220),
    [anon_sym_ptr] = ACTIONS(220),
    [anon_sym_sampler] = ACTIONS(220),
    [anon_sym_sampler_comparison] = ACTIONS(220),
    [anon_sym_texture_depth_2d] = ACTIONS(220),
    [anon_sym_texture_depth_2d_array] = ACTIONS(220),
    [anon_sym_texture_depth_cube] = ACTIONS(220),
    [anon_sym_texture_depth_cube_array] = ACTIONS(220),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(220),
    [anon_sym_texture_1d] = ACTIONS(220),
    [anon_sym_texture_2d] = ACTIONS(220),
    [anon_sym_texture_2d_array] = ACTIONS(220),
    [anon_sym_texture_3d] = ACTIONS(220),
    [anon_sym_texture_cube] = ACTIONS(220),
    [anon_sym_texture_cube_array] = ACTIONS(220),
    [anon_sym_texture_multisampled_2d] = ACTIONS(220),
    [anon_sym_texture_storage_1d] = ACTIONS(220),
    [anon_sym_texture_storage_2d] = ACTIONS(220),
    [anon_sym_texture_storage_2d_array] = ACTIONS(220),
    [anon_sym_texture_storage_3d] = ACTIONS(220),
    [anon_sym_bitcast] = ACTIONS(220),
    [anon_sym_AMP] = ACTIONS(222),
    [anon_sym_DASH] = ACTIONS(220),
    [anon_sym_STAR] = ACTIONS(222),
    [anon_sym_BANG] = ACTIONS(222),
    [anon_sym_TILDE] = ACTIONS(222),
  },
  [22] = {
    [sym_comment] = STATE(22),
    [sym_identifier] = ACTIONS(224),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(224),
    [anon_sym_LPAREN] = ACTIONS(226),
    [anon_sym_LBRACE] = ACTIONS(226),
    [anon_sym_RBRACE] = ACTIONS(226),
    [anon_sym_if] = ACTIONS(224),
    [anon_sym_switch] = ACTIONS(224),
    [anon_sym_fallthrough] = ACTIONS(224),
    [anon_sym_loop] = ACTIONS(224),
    [anon_sym_for] = ACTIONS(224),
    [anon_sym_break] = ACTIONS(224),
    [anon_sym_continue] = ACTIONS(224),
    [anon_sym_continuing] = ACTIONS(224),
    [anon_sym_return] = ACTIONS(224),
    [anon_sym_discard] = ACTIONS(224),
    [anon_sym_var] = ACTIONS(224),
    [sym_int_literal] = ACTIONS(224),
    [sym_uint_literal] = ACTIONS(226),
    [aux_sym_float_literal_token1] = ACTIONS(226),
    [aux_sym_float_literal_token2] = ACTIONS(226),
    [sym_true] = ACTIONS(224),
    [sym_false] = ACTIONS(224),
    [anon_sym_bool] = ACTIONS(224),
    [anon_sym_u32] = ACTIONS(224),
    [anon_sym_i32] = ACTIONS(224),
    [anon_sym_f32] = ACTIONS(224),
    [anon_sym_vec2] = ACTIONS(224),
    [anon_sym_vec3] = ACTIONS(224),
    [anon_sym_vec4] = ACTIONS(224),
    [anon_sym_mat2x2] = ACTIONS(224),
    [anon_sym_mat2x3] = ACTIONS(224),
    [anon_sym_mat2x4] = ACTIONS(224),
    [anon_sym_mat3x2] = ACTIONS(224),
    [anon_sym_mat3x3] = ACTIONS(224),
    [anon_sym_mat3x4] = ACTIONS(224),
    [anon_sym_mat4x2] = ACTIONS(224),
    [anon_sym_mat4x3] = ACTIONS(224),
    [anon_sym_mat4x4] = ACTIONS(224),
    [anon_sym_atomic] = ACTIONS(224),
    [anon_sym_array] = ACTIONS(224),
    [anon_sym_ptr] = ACTIONS(224),
    [anon_sym_sampler] = ACTIONS(224),
    [anon_sym_sampler_comparison] = ACTIONS(224),
    [anon_sym_texture_depth_2d] = ACTIONS(224),
    [anon_sym_texture_depth_2d_array] = ACTIONS(224),
    [anon_sym_texture_depth_cube] = ACTIONS(224),
    [anon_sym_texture_depth_cube_array] = ACTIONS(224),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(224),
    [anon_sym_texture_1d] = ACTIONS(224),
    [anon_sym_texture_2d] = ACTIONS(224),
    [anon_sym_texture_2d_array] = ACTIONS(224),
    [anon_sym_texture_3d] = ACTIONS(224),
    [anon_sym_texture_cube] = ACTIONS(224),
    [anon_sym_texture_cube_array] = ACTIONS(224),
    [anon_sym_texture_multisampled_2d] = ACTIONS(224),
    [anon_sym_texture_storage_1d] = ACTIONS(224),
    [anon_sym_texture_storage_2d] = ACTIONS(224),
    [anon_sym_texture_storage_2d_array] = ACTIONS(224),
    [anon_sym_texture_storage_3d] = ACTIONS(224),
    [anon_sym_bitcast] = ACTIONS(224),
    [anon_sym_AMP] = ACTIONS(226),
    [anon_sym_DASH] = ACTIONS(224),
    [anon_sym_STAR] = ACTIONS(226),
    [anon_sym_BANG] = ACTIONS(226),
    [anon_sym_TILDE] = ACTIONS(226),
  },
  [23] = {
    [sym_comment] = STATE(23),
    [sym_identifier] = ACTIONS(228),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(228),
    [anon_sym_LPAREN] = ACTIONS(230),
    [anon_sym_LBRACE] = ACTIONS(230),
    [anon_sym_RBRACE] = ACTIONS(230),
    [anon_sym_if] = ACTIONS(228),
    [anon_sym_switch] = ACTIONS(228),
    [anon_sym_fallthrough] = ACTIONS(228),
    [anon_sym_loop] = ACTIONS(228),
    [anon_sym_for] = ACTIONS(228),
    [anon_sym_break] = ACTIONS(228),
    [anon_sym_continue] = ACTIONS(228),
    [anon_sym_continuing] = ACTIONS(228),
    [anon_sym_return] = ACTIONS(228),
    [anon_sym_discard] = ACTIONS(228),
    [anon_sym_var] = ACTIONS(228),
    [sym_int_literal] = ACTIONS(228),
    [sym_uint_literal] = ACTIONS(230),
    [aux_sym_float_literal_token1] = ACTIONS(230),
    [aux_sym_float_literal_token2] = ACTIONS(230),
    [sym_true] = ACTIONS(228),
    [sym_false] = ACTIONS(228),
    [anon_sym_bool] = ACTIONS(228),
    [anon_sym_u32] = ACTIONS(228),
    [anon_sym_i32] = ACTIONS(228),
    [anon_sym_f32] = ACTIONS(228),
    [anon_sym_vec2] = ACTIONS(228),
    [anon_sym_vec3] = ACTIONS(228),
    [anon_sym_vec4] = ACTIONS(228),
    [anon_sym_mat2x2] = ACTIONS(228),
    [anon_sym_mat2x3] = ACTIONS(228),
    [anon_sym_mat2x4] = ACTIONS(228),
    [anon_sym_mat3x2] = ACTIONS(228),
    [anon_sym_mat3x3] = ACTIONS(228),
    [anon_sym_mat3x4] = ACTIONS(228),
    [anon_sym_mat4x2] = ACTIONS(228),
    [anon_sym_mat4x3] = ACTIONS(228),
    [anon_sym_mat4x4] = ACTIONS(228),
    [anon_sym_atomic] = ACTIONS(228),
    [anon_sym_array] = ACTIONS(228),
    [anon_sym_ptr] = ACTIONS(228),
    [anon_sym_sampler] = ACTIONS(228),
    [anon_sym_sampler_comparison] = ACTIONS(228),
    [anon_sym_texture_depth_2d] = ACTIONS(228),
    [anon_sym_texture_depth_2d_array] = ACTIONS(228),
    [anon_sym_texture_depth_cube] = ACTIONS(228),
    [anon_sym_texture_depth_cube_array] = ACTIONS(228),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(228),
    [anon_sym_texture_1d] = ACTIONS(228),
    [anon_sym_texture_2d] = ACTIONS(228),
    [anon_sym_texture_2d_array] = ACTIONS(228),
    [anon_sym_texture_3d] = ACTIONS(228),
    [anon_sym_texture_cube] = ACTIONS(228),
    [anon_sym_texture_cube_array] = ACTIONS(228),
    [anon_sym_texture_multisampled_2d] = ACTIONS(228),
    [anon_sym_texture_storage_1d] = ACTIONS(228),
    [anon_sym_texture_storage_2d] = ACTIONS(228),
    [anon_sym_texture_storage_2d_array] = ACTIONS(228),
    [anon_sym_texture_storage_3d] = ACTIONS(228),
    [anon_sym_bitcast] = ACTIONS(228),
    [anon_sym_AMP] = ACTIONS(230),
    [anon_sym_DASH] = ACTIONS(228),
    [anon_sym_STAR] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(230),
    [anon_sym_TILDE] = ACTIONS(230),
  },
  [24] = {
    [sym_comment] = STATE(24),
    [sym_identifier] = ACTIONS(232),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(232),
    [anon_sym_LPAREN] = ACTIONS(234),
    [anon_sym_LBRACE] = ACTIONS(234),
    [anon_sym_RBRACE] = ACTIONS(234),
    [anon_sym_if] = ACTIONS(232),
    [anon_sym_switch] = ACTIONS(232),
    [anon_sym_fallthrough] = ACTIONS(232),
    [anon_sym_loop] = ACTIONS(232),
    [anon_sym_for] = ACTIONS(232),
    [anon_sym_break] = ACTIONS(232),
    [anon_sym_continue] = ACTIONS(232),
    [anon_sym_continuing] = ACTIONS(232),
    [anon_sym_return] = ACTIONS(232),
    [anon_sym_discard] = ACTIONS(232),
    [anon_sym_var] = ACTIONS(232),
    [sym_int_literal] = ACTIONS(232),
    [sym_uint_literal] = ACTIONS(234),
    [aux_sym_float_literal_token1] = ACTIONS(234),
    [aux_sym_float_literal_token2] = ACTIONS(234),
    [sym_true] = ACTIONS(232),
    [sym_false] = ACTIONS(232),
    [anon_sym_bool] = ACTIONS(232),
    [anon_sym_u32] = ACTIONS(232),
    [anon_sym_i32] = ACTIONS(232),
    [anon_sym_f32] = ACTIONS(232),
    [anon_sym_vec2] = ACTIONS(232),
    [anon_sym_vec3] = ACTIONS(232),
    [anon_sym_vec4] = ACTIONS(232),
    [anon_sym_mat2x2] = ACTIONS(232),
    [anon_sym_mat2x3] = ACTIONS(232),
    [anon_sym_mat2x4] = ACTIONS(232),
    [anon_sym_mat3x2] = ACTIONS(232),
    [anon_sym_mat3x3] = ACTIONS(232),
    [anon_sym_mat3x4] = ACTIONS(232),
    [anon_sym_mat4x2] = ACTIONS(232),
    [anon_sym_mat4x3] = ACTIONS(232),
    [anon_sym_mat4x4] = ACTIONS(232),
    [anon_sym_atomic] = ACTIONS(232),
    [anon_sym_array] = ACTIONS(232),
    [anon_sym_ptr] = ACTIONS(232),
    [anon_sym_sampler] = ACTIONS(232),
    [anon_sym_sampler_comparison] = ACTIONS(232),
    [anon_sym_texture_depth_2d] = ACTIONS(232),
    [anon_sym_texture_depth_2d_array] = ACTIONS(232),
    [anon_sym_texture_depth_cube] = ACTIONS(232),
    [anon_sym_texture_depth_cube_array] = ACTIONS(232),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(232),
    [anon_sym_texture_1d] = ACTIONS(232),
    [anon_sym_texture_2d] = ACTIONS(232),
    [anon_sym_texture_2d_array] = ACTIONS(232),
    [anon_sym_texture_3d] = ACTIONS(232),
    [anon_sym_texture_cube] = ACTIONS(232),
    [anon_sym_texture_cube_array] = ACTIONS(232),
    [anon_sym_texture_multisampled_2d] = ACTIONS(232),
    [anon_sym_texture_storage_1d] = ACTIONS(232),
    [anon_sym_texture_storage_2d] = ACTIONS(232),
    [anon_sym_texture_storage_2d_array] = ACTIONS(232),
    [anon_sym_texture_storage_3d] = ACTIONS(232),
    [anon_sym_bitcast] = ACTIONS(232),
    [anon_sym_AMP] = ACTIONS(234),
    [anon_sym_DASH] = ACTIONS(232),
    [anon_sym_STAR] = ACTIONS(234),
    [anon_sym_BANG] = ACTIONS(234),
    [anon_sym_TILDE] = ACTIONS(234),
  },
  [25] = {
    [sym_comment] = STATE(25),
    [sym_identifier] = ACTIONS(236),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(236),
    [anon_sym_LPAREN] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_RBRACE] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_switch] = ACTIONS(236),
    [anon_sym_fallthrough] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(236),
    [anon_sym_for] = ACTIONS(236),
    [anon_sym_break] = ACTIONS(236),
    [anon_sym_continue] = ACTIONS(236),
    [anon_sym_continuing] = ACTIONS(236),
    [anon_sym_return] = ACTIONS(236),
    [anon_sym_discard] = ACTIONS(236),
    [anon_sym_var] = ACTIONS(236),
    [sym_int_literal] = ACTIONS(236),
    [sym_uint_literal] = ACTIONS(238),
    [aux_sym_float_literal_token1] = ACTIONS(238),
    [aux_sym_float_literal_token2] = ACTIONS(238),
    [sym_true] = ACTIONS(236),
    [sym_false] = ACTIONS(236),
    [anon_sym_bool] = ACTIONS(236),
    [anon_sym_u32] = ACTIONS(236),
    [anon_sym_i32] = ACTIONS(236),
    [anon_sym_f32] = ACTIONS(236),
    [anon_sym_vec2] = ACTIONS(236),
    [anon_sym_vec3] = ACTIONS(236),
    [anon_sym_vec4] = ACTIONS(236),
    [anon_sym_mat2x2] = ACTIONS(236),
    [anon_sym_mat2x3] = ACTIONS(236),
    [anon_sym_mat2x4] = ACTIONS(236),
    [anon_sym_mat3x2] = ACTIONS(236),
    [anon_sym_mat3x3] = ACTIONS(236),
    [anon_sym_mat3x4] = ACTIONS(236),
    [anon_sym_mat4x2] = ACTIONS(236),
    [anon_sym_mat4x3] = ACTIONS(236),
    [anon_sym_mat4x4] = ACTIONS(236),
    [anon_sym_atomic] = ACTIONS(236),
    [anon_sym_array] = ACTIONS(236),
    [anon_sym_ptr] = ACTIONS(236),
    [anon_sym_sampler] = ACTIONS(236),
    [anon_sym_sampler_comparison] = ACTIONS(236),
    [anon_sym_texture_depth_2d] = ACTIONS(236),
    [anon_sym_texture_depth_2d_array] = ACTIONS(236),
    [anon_sym_texture_depth_cube] = ACTIONS(236),
    [anon_sym_texture_depth_cube_array] = ACTIONS(236),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(236),
    [anon_sym_texture_1d] = ACTIONS(236),
    [anon_sym_texture_2d] = ACTIONS(236),
    [anon_sym_texture_2d_array] = ACTIONS(236),
    [anon_sym_texture_3d] = ACTIONS(236),
    [anon_sym_texture_cube] = ACTIONS(236),
    [anon_sym_texture_cube_array] = ACTIONS(236),
    [anon_sym_texture_multisampled_2d] = ACTIONS(236),
    [anon_sym_texture_storage_1d] = ACTIONS(236),
    [anon_sym_texture_storage_2d] = ACTIONS(236),
    [anon_sym_texture_storage_2d_array] = ACTIONS(236),
    [anon_sym_texture_storage_3d] = ACTIONS(236),
    [anon_sym_bitcast] = ACTIONS(236),
    [anon_sym_AMP] = ACTIONS(238),
    [anon_sym_DASH] = ACTIONS(236),
    [anon_sym_STAR] = ACTIONS(238),
    [anon_sym_BANG] = ACTIONS(238),
    [anon_sym_TILDE] = ACTIONS(238),
  },
  [26] = {
    [sym_comment] = STATE(26),
    [sym_identifier] = ACTIONS(240),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(242),
    [anon_sym_LBRACE] = ACTIONS(242),
    [anon_sym_RBRACE] = ACTIONS(242),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_switch] = ACTIONS(240),
    [anon_sym_fallthrough] = ACTIONS(240),
    [anon_sym_loop] = ACTIONS(240),
    [anon_sym_for] = ACTIONS(240),
    [anon_sym_break] = ACTIONS(240),
    [anon_sym_continue] = ACTIONS(240),
    [anon_sym_continuing] = ACTIONS(240),
    [anon_sym_return] = ACTIONS(240),
    [anon_sym_discard] = ACTIONS(240),
    [anon_sym_var] = ACTIONS(240),
    [sym_int_literal] = ACTIONS(240),
    [sym_uint_literal] = ACTIONS(242),
    [aux_sym_float_literal_token1] = ACTIONS(242),
    [aux_sym_float_literal_token2] = ACTIONS(242),
    [sym_true] = ACTIONS(240),
    [sym_false] = ACTIONS(240),
    [anon_sym_bool] = ACTIONS(240),
    [anon_sym_u32] = ACTIONS(240),
    [anon_sym_i32] = ACTIONS(240),
    [anon_sym_f32] = ACTIONS(240),
    [anon_sym_vec2] = ACTIONS(240),
    [anon_sym_vec3] = ACTIONS(240),
    [anon_sym_vec4] = ACTIONS(240),
    [anon_sym_mat2x2] = ACTIONS(240),
    [anon_sym_mat2x3] = ACTIONS(240),
    [anon_sym_mat2x4] = ACTIONS(240),
    [anon_sym_mat3x2] = ACTIONS(240),
    [anon_sym_mat3x3] = ACTIONS(240),
    [anon_sym_mat3x4] = ACTIONS(240),
    [anon_sym_mat4x2] = ACTIONS(240),
    [anon_sym_mat4x3] = ACTIONS(240),
    [anon_sym_mat4x4] = ACTIONS(240),
    [anon_sym_atomic] = ACTIONS(240),
    [anon_sym_array] = ACTIONS(240),
    [anon_sym_ptr] = ACTIONS(240),
    [anon_sym_sampler] = ACTIONS(240),
    [anon_sym_sampler_comparison] = ACTIONS(240),
    [anon_sym_texture_depth_2d] = ACTIONS(240),
    [anon_sym_texture_depth_2d_array] = ACTIONS(240),
    [anon_sym_texture_depth_cube] = ACTIONS(240),
    [anon_sym_texture_depth_cube_array] = ACTIONS(240),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(240),
    [anon_sym_texture_1d] = ACTIONS(240),
    [anon_sym_texture_2d] = ACTIONS(240),
    [anon_sym_texture_2d_array] = ACTIONS(240),
    [anon_sym_texture_3d] = ACTIONS(240),
    [anon_sym_texture_cube] = ACTIONS(240),
    [anon_sym_texture_cube_array] = ACTIONS(240),
    [anon_sym_texture_multisampled_2d] = ACTIONS(240),
    [anon_sym_texture_storage_1d] = ACTIONS(240),
    [anon_sym_texture_storage_2d] = ACTIONS(240),
    [anon_sym_texture_storage_2d_array] = ACTIONS(240),
    [anon_sym_texture_storage_3d] = ACTIONS(240),
    [anon_sym_bitcast] = ACTIONS(240),
    [anon_sym_AMP] = ACTIONS(242),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(242),
    [anon_sym_BANG] = ACTIONS(242),
    [anon_sym_TILDE] = ACTIONS(242),
  },
  [27] = {
    [sym_comment] = STATE(27),
    [sym_identifier] = ACTIONS(244),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(244),
    [anon_sym_LPAREN] = ACTIONS(246),
    [anon_sym_LBRACE] = ACTIONS(246),
    [anon_sym_RBRACE] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_switch] = ACTIONS(244),
    [anon_sym_fallthrough] = ACTIONS(244),
    [anon_sym_loop] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(244),
    [anon_sym_break] = ACTIONS(244),
    [anon_sym_continue] = ACTIONS(244),
    [anon_sym_continuing] = ACTIONS(244),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_discard] = ACTIONS(244),
    [anon_sym_var] = ACTIONS(244),
    [sym_int_literal] = ACTIONS(244),
    [sym_uint_literal] = ACTIONS(246),
    [aux_sym_float_literal_token1] = ACTIONS(246),
    [aux_sym_float_literal_token2] = ACTIONS(246),
    [sym_true] = ACTIONS(244),
    [sym_false] = ACTIONS(244),
    [anon_sym_bool] = ACTIONS(244),
    [anon_sym_u32] = ACTIONS(244),
    [anon_sym_i32] = ACTIONS(244),
    [anon_sym_f32] = ACTIONS(244),
    [anon_sym_vec2] = ACTIONS(244),
    [anon_sym_vec3] = ACTIONS(244),
    [anon_sym_vec4] = ACTIONS(244),
    [anon_sym_mat2x2] = ACTIONS(244),
    [anon_sym_mat2x3] = ACTIONS(244),
    [anon_sym_mat2x4] = ACTIONS(244),
    [anon_sym_mat3x2] = ACTIONS(244),
    [anon_sym_mat3x3] = ACTIONS(244),
    [anon_sym_mat3x4] = ACTIONS(244),
    [anon_sym_mat4x2] = ACTIONS(244),
    [anon_sym_mat4x3] = ACTIONS(244),
    [anon_sym_mat4x4] = ACTIONS(244),
    [anon_sym_atomic] = ACTIONS(244),
    [anon_sym_array] = ACTIONS(244),
    [anon_sym_ptr] = ACTIONS(244),
    [anon_sym_sampler] = ACTIONS(244),
    [anon_sym_sampler_comparison] = ACTIONS(244),
    [anon_sym_texture_depth_2d] = ACTIONS(244),
    [anon_sym_texture_depth_2d_array] = ACTIONS(244),
    [anon_sym_texture_depth_cube] = ACTIONS(244),
    [anon_sym_texture_depth_cube_array] = ACTIONS(244),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(244),
    [anon_sym_texture_1d] = ACTIONS(244),
    [anon_sym_texture_2d] = ACTIONS(244),
    [anon_sym_texture_2d_array] = ACTIONS(244),
    [anon_sym_texture_3d] = ACTIONS(244),
    [anon_sym_texture_cube] = ACTIONS(244),
    [anon_sym_texture_cube_array] = ACTIONS(244),
    [anon_sym_texture_multisampled_2d] = ACTIONS(244),
    [anon_sym_texture_storage_1d] = ACTIONS(244),
    [anon_sym_texture_storage_2d] = ACTIONS(244),
    [anon_sym_texture_storage_2d_array] = ACTIONS(244),
    [anon_sym_texture_storage_3d] = ACTIONS(244),
    [anon_sym_bitcast] = ACTIONS(244),
    [anon_sym_AMP] = ACTIONS(246),
    [anon_sym_DASH] = ACTIONS(244),
    [anon_sym_STAR] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(246),
    [anon_sym_TILDE] = ACTIONS(246),
  },
  [28] = {
    [sym_comment] = STATE(28),
    [sym_identifier] = ACTIONS(248),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(248),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_LBRACE] = ACTIONS(250),
    [anon_sym_RBRACE] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(248),
    [anon_sym_switch] = ACTIONS(248),
    [anon_sym_fallthrough] = ACTIONS(248),
    [anon_sym_loop] = ACTIONS(248),
    [anon_sym_for] = ACTIONS(248),
    [anon_sym_break] = ACTIONS(248),
    [anon_sym_continue] = ACTIONS(248),
    [anon_sym_continuing] = ACTIONS(248),
    [anon_sym_return] = ACTIONS(248),
    [anon_sym_discard] = ACTIONS(248),
    [anon_sym_var] = ACTIONS(248),
    [sym_int_literal] = ACTIONS(248),
    [sym_uint_literal] = ACTIONS(250),
    [aux_sym_float_literal_token1] = ACTIONS(250),
    [aux_sym_float_literal_token2] = ACTIONS(250),
    [sym_true] = ACTIONS(248),
    [sym_false] = ACTIONS(248),
    [anon_sym_bool] = ACTIONS(248),
    [anon_sym_u32] = ACTIONS(248),
    [anon_sym_i32] = ACTIONS(248),
    [anon_sym_f32] = ACTIONS(248),
    [anon_sym_vec2] = ACTIONS(248),
    [anon_sym_vec3] = ACTIONS(248),
    [anon_sym_vec4] = ACTIONS(248),
    [anon_sym_mat2x2] = ACTIONS(248),
    [anon_sym_mat2x3] = ACTIONS(248),
    [anon_sym_mat2x4] = ACTIONS(248),
    [anon_sym_mat3x2] = ACTIONS(248),
    [anon_sym_mat3x3] = ACTIONS(248),
    [anon_sym_mat3x4] = ACTIONS(248),
    [anon_sym_mat4x2] = ACTIONS(248),
    [anon_sym_mat4x3] = ACTIONS(248),
    [anon_sym_mat4x4] = ACTIONS(248),
    [anon_sym_atomic] = ACTIONS(248),
    [anon_sym_array] = ACTIONS(248),
    [anon_sym_ptr] = ACTIONS(248),
    [anon_sym_sampler] = ACTIONS(248),
    [anon_sym_sampler_comparison] = ACTIONS(248),
    [anon_sym_texture_depth_2d] = ACTIONS(248),
    [anon_sym_texture_depth_2d_array] = ACTIONS(248),
    [anon_sym_texture_depth_cube] = ACTIONS(248),
    [anon_sym_texture_depth_cube_array] = ACTIONS(248),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(248),
    [anon_sym_texture_1d] = ACTIONS(248),
    [anon_sym_texture_2d] = ACTIONS(248),
    [anon_sym_texture_2d_array] = ACTIONS(248),
    [anon_sym_texture_3d] = ACTIONS(248),
    [anon_sym_texture_cube] = ACTIONS(248),
    [anon_sym_texture_cube_array] = ACTIONS(248),
    [anon_sym_texture_multisampled_2d] = ACTIONS(248),
    [anon_sym_texture_storage_1d] = ACTIONS(248),
    [anon_sym_texture_storage_2d] = ACTIONS(248),
    [anon_sym_texture_storage_2d_array] = ACTIONS(248),
    [anon_sym_texture_storage_3d] = ACTIONS(248),
    [anon_sym_bitcast] = ACTIONS(248),
    [anon_sym_AMP] = ACTIONS(250),
    [anon_sym_DASH] = ACTIONS(248),
    [anon_sym_STAR] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(250),
    [anon_sym_TILDE] = ACTIONS(250),
  },
  [29] = {
    [sym_comment] = STATE(29),
    [sym_identifier] = ACTIONS(252),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(252),
    [anon_sym_LPAREN] = ACTIONS(254),
    [anon_sym_LBRACE] = ACTIONS(254),
    [anon_sym_RBRACE] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_switch] = ACTIONS(252),
    [anon_sym_fallthrough] = ACTIONS(252),
    [anon_sym_loop] = ACTIONS(252),
    [anon_sym_for] = ACTIONS(252),
    [anon_sym_break] = ACTIONS(252),
    [anon_sym_continue] = ACTIONS(252),
    [anon_sym_continuing] = ACTIONS(252),
    [anon_sym_return] = ACTIONS(252),
    [anon_sym_discard] = ACTIONS(252),
    [anon_sym_var] = ACTIONS(252),
    [sym_int_literal] = ACTIONS(252),
    [sym_uint_literal] = ACTIONS(254),
    [aux_sym_float_literal_token1] = ACTIONS(254),
    [aux_sym_float_literal_token2] = ACTIONS(254),
    [sym_true] = ACTIONS(252),
    [sym_false] = ACTIONS(252),
    [anon_sym_bool] = ACTIONS(252),
    [anon_sym_u32] = ACTIONS(252),
    [anon_sym_i32] = ACTIONS(252),
    [anon_sym_f32] = ACTIONS(252),
    [anon_sym_vec2] = ACTIONS(252),
    [anon_sym_vec3] = ACTIONS(252),
    [anon_sym_vec4] = ACTIONS(252),
    [anon_sym_mat2x2] = ACTIONS(252),
    [anon_sym_mat2x3] = ACTIONS(252),
    [anon_sym_mat2x4] = ACTIONS(252),
    [anon_sym_mat3x2] = ACTIONS(252),
    [anon_sym_mat3x3] = ACTIONS(252),
    [anon_sym_mat3x4] = ACTIONS(252),
    [anon_sym_mat4x2] = ACTIONS(252),
    [anon_sym_mat4x3] = ACTIONS(252),
    [anon_sym_mat4x4] = ACTIONS(252),
    [anon_sym_atomic] = ACTIONS(252),
    [anon_sym_array] = ACTIONS(252),
    [anon_sym_ptr] = ACTIONS(252),
    [anon_sym_sampler] = ACTIONS(252),
    [anon_sym_sampler_comparison] = ACTIONS(252),
    [anon_sym_texture_depth_2d] = ACTIONS(252),
    [anon_sym_texture_depth_2d_array] = ACTIONS(252),
    [anon_sym_texture_depth_cube] = ACTIONS(252),
    [anon_sym_texture_depth_cube_array] = ACTIONS(252),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(252),
    [anon_sym_texture_1d] = ACTIONS(252),
    [anon_sym_texture_2d] = ACTIONS(252),
    [anon_sym_texture_2d_array] = ACTIONS(252),
    [anon_sym_texture_3d] = ACTIONS(252),
    [anon_sym_texture_cube] = ACTIONS(252),
    [anon_sym_texture_cube_array] = ACTIONS(252),
    [anon_sym_texture_multisampled_2d] = ACTIONS(252),
    [anon_sym_texture_storage_1d] = ACTIONS(252),
    [anon_sym_texture_storage_2d] = ACTIONS(252),
    [anon_sym_texture_storage_2d_array] = ACTIONS(252),
    [anon_sym_texture_storage_3d] = ACTIONS(252),
    [anon_sym_bitcast] = ACTIONS(252),
    [anon_sym_AMP] = ACTIONS(254),
    [anon_sym_DASH] = ACTIONS(252),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(254),
    [anon_sym_TILDE] = ACTIONS(254),
  },
  [30] = {
    [sym_comment] = STATE(30),
    [sym_identifier] = ACTIONS(256),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(256),
    [anon_sym_LPAREN] = ACTIONS(258),
    [anon_sym_LBRACE] = ACTIONS(258),
    [anon_sym_RBRACE] = ACTIONS(258),
    [anon_sym_if] = ACTIONS(256),
    [anon_sym_switch] = ACTIONS(256),
    [anon_sym_fallthrough] = ACTIONS(256),
    [anon_sym_loop] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_break] = ACTIONS(256),
    [anon_sym_continue] = ACTIONS(256),
    [anon_sym_continuing] = ACTIONS(256),
    [anon_sym_return] = ACTIONS(256),
    [anon_sym_discard] = ACTIONS(256),
    [anon_sym_var] = ACTIONS(256),
    [sym_int_literal] = ACTIONS(256),
    [sym_uint_literal] = ACTIONS(258),
    [aux_sym_float_literal_token1] = ACTIONS(258),
    [aux_sym_float_literal_token2] = ACTIONS(258),
    [sym_true] = ACTIONS(256),
    [sym_false] = ACTIONS(256),
    [anon_sym_bool] = ACTIONS(256),
    [anon_sym_u32] = ACTIONS(256),
    [anon_sym_i32] = ACTIONS(256),
    [anon_sym_f32] = ACTIONS(256),
    [anon_sym_vec2] = ACTIONS(256),
    [anon_sym_vec3] = ACTIONS(256),
    [anon_sym_vec4] = ACTIONS(256),
    [anon_sym_mat2x2] = ACTIONS(256),
    [anon_sym_mat2x3] = ACTIONS(256),
    [anon_sym_mat2x4] = ACTIONS(256),
    [anon_sym_mat3x2] = ACTIONS(256),
    [anon_sym_mat3x3] = ACTIONS(256),
    [anon_sym_mat3x4] = ACTIONS(256),
    [anon_sym_mat4x2] = ACTIONS(256),
    [anon_sym_mat4x3] = ACTIONS(256),
    [anon_sym_mat4x4] = ACTIONS(256),
    [anon_sym_atomic] = ACTIONS(256),
    [anon_sym_array] = ACTIONS(256),
    [anon_sym_ptr] = ACTIONS(256),
    [anon_sym_sampler] = ACTIONS(256),
    [anon_sym_sampler_comparison] = ACTIONS(256),
    [anon_sym_texture_depth_2d] = ACTIONS(256),
    [anon_sym_texture_depth_2d_array] = ACTIONS(256),
    [anon_sym_texture_depth_cube] = ACTIONS(256),
    [anon_sym_texture_depth_cube_array] = ACTIONS(256),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(256),
    [anon_sym_texture_1d] = ACTIONS(256),
    [anon_sym_texture_2d] = ACTIONS(256),
    [anon_sym_texture_2d_array] = ACTIONS(256),
    [anon_sym_texture_3d] = ACTIONS(256),
    [anon_sym_texture_cube] = ACTIONS(256),
    [anon_sym_texture_cube_array] = ACTIONS(256),
    [anon_sym_texture_multisampled_2d] = ACTIONS(256),
    [anon_sym_texture_storage_1d] = ACTIONS(256),
    [anon_sym_texture_storage_2d] = ACTIONS(256),
    [anon_sym_texture_storage_2d_array] = ACTIONS(256),
    [anon_sym_texture_storage_3d] = ACTIONS(256),
    [anon_sym_bitcast] = ACTIONS(256),
    [anon_sym_AMP] = ACTIONS(258),
    [anon_sym_DASH] = ACTIONS(256),
    [anon_sym_STAR] = ACTIONS(258),
    [anon_sym_BANG] = ACTIONS(258),
    [anon_sym_TILDE] = ACTIONS(258),
  },
  [31] = {
    [sym_comment] = STATE(31),
    [sym_assignment_statement] = STATE(288),
    [sym__expression] = STATE(121),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(112),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(260),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [32] = {
    [sym_comment] = STATE(32),
    [sym_identifier] = ACTIONS(262),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_let] = ACTIONS(262),
    [anon_sym_LPAREN] = ACTIONS(264),
    [anon_sym_LBRACE] = ACTIONS(264),
    [anon_sym_RBRACE] = ACTIONS(264),
    [anon_sym_if] = ACTIONS(262),
    [anon_sym_switch] = ACTIONS(262),
    [anon_sym_loop] = ACTIONS(262),
    [anon_sym_for] = ACTIONS(262),
    [anon_sym_break] = ACTIONS(262),
    [anon_sym_continue] = ACTIONS(262),
    [anon_sym_continuing] = ACTIONS(262),
    [anon_sym_return] = ACTIONS(262),
    [anon_sym_discard] = ACTIONS(262),
    [anon_sym_var] = ACTIONS(262),
    [sym_int_literal] = ACTIONS(262),
    [sym_uint_literal] = ACTIONS(264),
    [aux_sym_float_literal_token1] = ACTIONS(264),
    [aux_sym_float_literal_token2] = ACTIONS(264),
    [sym_true] = ACTIONS(262),
    [sym_false] = ACTIONS(262),
    [anon_sym_bool] = ACTIONS(262),
    [anon_sym_u32] = ACTIONS(262),
    [anon_sym_i32] = ACTIONS(262),
    [anon_sym_f32] = ACTIONS(262),
    [anon_sym_vec2] = ACTIONS(262),
    [anon_sym_vec3] = ACTIONS(262),
    [anon_sym_vec4] = ACTIONS(262),
    [anon_sym_mat2x2] = ACTIONS(262),
    [anon_sym_mat2x3] = ACTIONS(262),
    [anon_sym_mat2x4] = ACTIONS(262),
    [anon_sym_mat3x2] = ACTIONS(262),
    [anon_sym_mat3x3] = ACTIONS(262),
    [anon_sym_mat3x4] = ACTIONS(262),
    [anon_sym_mat4x2] = ACTIONS(262),
    [anon_sym_mat4x3] = ACTIONS(262),
    [anon_sym_mat4x4] = ACTIONS(262),
    [anon_sym_atomic] = ACTIONS(262),
    [anon_sym_array] = ACTIONS(262),
    [anon_sym_ptr] = ACTIONS(262),
    [anon_sym_sampler] = ACTIONS(262),
    [anon_sym_sampler_comparison] = ACTIONS(262),
    [anon_sym_texture_depth_2d] = ACTIONS(262),
    [anon_sym_texture_depth_2d_array] = ACTIONS(262),
    [anon_sym_texture_depth_cube] = ACTIONS(262),
    [anon_sym_texture_depth_cube_array] = ACTIONS(262),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(262),
    [anon_sym_texture_1d] = ACTIONS(262),
    [anon_sym_texture_2d] = ACTIONS(262),
    [anon_sym_texture_2d_array] = ACTIONS(262),
    [anon_sym_texture_3d] = ACTIONS(262),
    [anon_sym_texture_cube] = ACTIONS(262),
    [anon_sym_texture_cube_array] = ACTIONS(262),
    [anon_sym_texture_multisampled_2d] = ACTIONS(262),
    [anon_sym_texture_storage_1d] = ACTIONS(262),
    [anon_sym_texture_storage_2d] = ACTIONS(262),
    [anon_sym_texture_storage_2d_array] = ACTIONS(262),
    [anon_sym_texture_storage_3d] = ACTIONS(262),
    [anon_sym_bitcast] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(264),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_STAR] = ACTIONS(264),
    [anon_sym_BANG] = ACTIONS(264),
    [anon_sym_TILDE] = ACTIONS(264),
  },
  [33] = {
    [sym_comment] = STATE(33),
    [sym_assignment_statement] = STATE(315),
    [sym__expression] = STATE(121),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(115),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [34] = {
    [sym_comment] = STATE(34),
    [sym_assignment_statement] = STATE(303),
    [sym__expression] = STATE(121),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(113),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(268),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [35] = {
    [sym_comment] = STATE(35),
    [sym__expression] = STATE(114),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [aux_sym_argument_list_expression_repeat1] = STATE(37),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(270),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [36] = {
    [sym_comment] = STATE(36),
    [sym__expression] = STATE(122),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [37] = {
    [sym_comment] = STATE(37),
    [sym__expression] = STATE(109),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [aux_sym_argument_list_expression_repeat1] = STATE(40),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [38] = {
    [sym_comment] = STATE(38),
    [sym__expression] = STATE(117),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [39] = {
    [sym_comment] = STATE(39),
    [sym__expression] = STATE(116),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [sym_identifier] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(276),
    [anon_sym_LPAREN] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(53),
    [sym_uint_literal] = ACTIONS(55),
    [aux_sym_float_literal_token1] = ACTIONS(57),
    [aux_sym_float_literal_token2] = ACTIONS(57),
    [sym_true] = ACTIONS(53),
    [sym_false] = ACTIONS(53),
    [anon_sym_bool] = ACTIONS(59),
    [anon_sym_u32] = ACTIONS(59),
    [anon_sym_i32] = ACTIONS(59),
    [anon_sym_f32] = ACTIONS(59),
    [anon_sym_vec2] = ACTIONS(61),
    [anon_sym_vec3] = ACTIONS(61),
    [anon_sym_vec4] = ACTIONS(61),
    [anon_sym_mat2x2] = ACTIONS(61),
    [anon_sym_mat2x3] = ACTIONS(61),
    [anon_sym_mat2x4] = ACTIONS(61),
    [anon_sym_mat3x2] = ACTIONS(61),
    [anon_sym_mat3x3] = ACTIONS(61),
    [anon_sym_mat3x4] = ACTIONS(61),
    [anon_sym_mat4x2] = ACTIONS(61),
    [anon_sym_mat4x3] = ACTIONS(61),
    [anon_sym_mat4x4] = ACTIONS(61),
    [anon_sym_atomic] = ACTIONS(63),
    [anon_sym_array] = ACTIONS(65),
    [anon_sym_ptr] = ACTIONS(67),
    [anon_sym_sampler] = ACTIONS(59),
    [anon_sym_sampler_comparison] = ACTIONS(59),
    [anon_sym_texture_depth_2d] = ACTIONS(59),
    [anon_sym_texture_depth_2d_array] = ACTIONS(59),
    [anon_sym_texture_depth_cube] = ACTIONS(59),
    [anon_sym_texture_depth_cube_array] = ACTIONS(59),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(59),
    [anon_sym_texture_1d] = ACTIONS(69),
    [anon_sym_texture_2d] = ACTIONS(69),
    [anon_sym_texture_2d_array] = ACTIONS(69),
    [anon_sym_texture_3d] = ACTIONS(69),
    [anon_sym_texture_cube] = ACTIONS(69),
    [anon_sym_texture_cube_array] = ACTIONS(69),
    [anon_sym_texture_multisampled_2d] = ACTIONS(69),
    [anon_sym_texture_storage_1d] = ACTIONS(71),
    [anon_sym_texture_storage_2d] = ACTIONS(71),
    [anon_sym_texture_storage_2d_array] = ACTIONS(71),
    [anon_sym_texture_storage_3d] = ACTIONS(71),
    [anon_sym_bitcast] = ACTIONS(73),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(75),
  },
  [40] = {
    [sym_comment] = STATE(40),
    [sym__expression] = STATE(120),
    [sym_const_literal] = STATE(99),
    [sym_float_literal] = STATE(87),
    [sym_parenthesized_expression] = STATE(99),
    [sym_type_constructor_or_function_call_expression] = STATE(99),
    [sym_type_declaration] = STATE(199),
    [sym_bitcast_expression] = STATE(99),
    [sym_binary_expression] = STATE(99),
    [sym_unary_expression] = STATE(99),
    [sym_subscript_expression] = STATE(99),
    [sym_composite_value_decomposition_expression] = STATE(99),
    [aux_sym_argument_list_expression_repeat1] = STATE(40),
    [sym_identifier] = ACTIONS(278),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(281),
    [sym_int_literal] = ACTIONS(284),
    [sym_uint_literal] = ACTIONS(287),
    [aux_sym_float_literal_token1] = ACTIONS(290),
    [aux_sym_float_literal_token2] = ACTIONS(290),
    [sym_true] = ACTIONS(284),
    [sym_false] = ACTIONS(284),
    [anon_sym_bool] = ACTIONS(293),
    [anon_sym_u32] = ACTIONS(293),
    [anon_sym_i32] = ACTIONS(293),
    [anon_sym_f32] = ACTIONS(293),
    [anon_sym_vec2] = ACTIONS(296),
    [anon_sym_vec3] = ACTIONS(296),
    [anon_sym_vec4] = ACTIONS(296),
    [anon_sym_mat2x2] = ACTIONS(296),
    [anon_sym_mat2x3] = ACTIONS(296),
    [anon_sym_mat2x4] = ACTIONS(296),
    [anon_sym_mat3x2] = ACTIONS(296),
    [anon_sym_mat3x3] = ACTIONS(296),
    [anon_sym_mat3x4] = ACTIONS(296),
    [anon_sym_mat4x2] = ACTIONS(296),
    [anon_sym_mat4x3] = ACTIONS(296),
    [anon_sym_mat4x4] = ACTIONS(296),
    [anon_sym_atomic] = ACTIONS(299),
    [anon_sym_array] = ACTIONS(302),
    [anon_sym_ptr] = ACTIONS(305),
    [anon_sym_sampler] = ACTIONS(293),
    [anon_sym_sampler_comparison] = ACTIONS(293),
    [anon_sym_texture_depth_2d] = ACTIONS(293),
    [anon_sym_texture_depth_2d_array] = ACTIONS(293),
    [anon_sym_texture_depth_cube] = ACTIONS(293),
    [anon_sym_texture_depth_cube_array] = ACTIONS(293),
    [anon_sym_texture_depth_multisampled_2d] = ACTIONS(293),
    [anon_sym_texture_1d] = ACTIONS(308),
    [anon_sym_texture_2d] = ACTIONS(308),
    [anon_sym_texture_2d_array] = ACTIONS(308),
    [anon_sym_texture_3d] = ACTIONS(308),
    [anon_sym_texture_cube] = ACTIONS(308),
    [anon_sym_texture_cube_array] = ACTIONS(308),
    [anon_sym_texture_multisampled_2d] = ACTIONS(308),
    [anon_sym_texture_storage_1d] = ACTIONS(311),
    [anon_sym_texture_storage_2d] = ACTIONS(311),
    [anon_sym_texture_storage_2d_array] = ACTIONS(311),
    [anon_sym_texture_storage_3d] = ACTIONS(311),
    [anon_sym_bitcast] = ACTIONS(314),
    [anon_sym_AMP] = ACTIONS(317),
    [anon_sym_DASH] = ACTIONS(320),
    [anon_sym_STAR] = ACTIONS(317),
    [anon_sym_BANG] = ACTIONS(317),
    [anon_sym_TILDE] = ACTIONS(317),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(41), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(104), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [107] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(42), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(92), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [214] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(43), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(118), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [321] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(44), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(91), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [428] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(45), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(96), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [535] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(46), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(103), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [642] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(47), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(101), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [749] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(48), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(123), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [856] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(49), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(106), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [963] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(50), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(89), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [1070] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(51), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(119), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [1177] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(52), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(97), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [1284] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(53), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(124), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [1391] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(54), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(111), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [1498] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(55), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(95), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [1605] = 21,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(73), 1,
      anon_sym_bitcast,
    ACTIONS(77), 1,
      anon_sym_DASH,
    STATE(56), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(98), 1,
      sym__expression,
    STATE(199), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(75), 4,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    STATE(99), 8,
      sym_const_literal,
      sym_parenthesized_expression,
      sym_type_constructor_or_function_call_expression,
      sym_bitcast_expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_subscript_expression,
      sym_composite_value_decomposition_expression,
    ACTIONS(59), 11,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [1712] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(327), 1,
      anon_sym_RPAREN,
    STATE(57), 1,
      sym_comment,
    ACTIONS(325), 8,
      anon_sym_LPAREN,
      sym_uint_literal,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(323), 43,
      sym_identifier,
      sym_int_literal,
      sym_true,
      sym_false,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
      anon_sym_atomic,
      anon_sym_array,
      anon_sym_ptr,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
      anon_sym_bitcast,
      anon_sym_DASH,
  [1777] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(329), 1,
      anon_sym_RPAREN,
    STATE(58), 1,
      sym_comment,
    ACTIONS(325), 8,
      anon_sym_LPAREN,
      sym_uint_literal,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(323), 43,
      sym_identifier,
      sym_int_literal,
      sym_true,
      sym_false,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
      anon_sym_atomic,
      anon_sym_array,
      anon_sym_ptr,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
      anon_sym_bitcast,
      anon_sym_DASH,
  [1842] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(59), 1,
      sym_comment,
    ACTIONS(325), 8,
      anon_sym_LPAREN,
      sym_uint_literal,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(323), 43,
      sym_identifier,
      sym_int_literal,
      sym_true,
      sym_false,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
      anon_sym_atomic,
      anon_sym_array,
      anon_sym_ptr,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
      anon_sym_bitcast,
      anon_sym_DASH,
  [1904] = 18,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    ACTIONS(331), 1,
      anon_sym_RPAREN,
    STATE(60), 1,
      sym_comment,
    STATE(61), 1,
      aux_sym_const_expression_repeat1,
    STATE(87), 1,
      sym_float_literal,
    STATE(187), 1,
      sym_const_literal,
    STATE(213), 1,
      sym_const_expression,
    STATE(258), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [1993] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(61), 1,
      sym_comment,
    STATE(62), 1,
      aux_sym_const_expression_repeat1,
    STATE(87), 1,
      sym_float_literal,
    STATE(187), 1,
      sym_const_literal,
    STATE(208), 1,
      sym_const_expression,
    STATE(258), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [2079] = 16,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      sym_uint_literal,
    ACTIONS(348), 1,
      anon_sym_atomic,
    ACTIONS(351), 1,
      anon_sym_array,
    ACTIONS(354), 1,
      anon_sym_ptr,
    STATE(87), 1,
      sym_float_literal,
    STATE(187), 1,
      sym_const_literal,
    STATE(258), 1,
      sym_type_declaration,
    STATE(274), 1,
      sym_const_expression,
    ACTIONS(342), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    STATE(62), 2,
      sym_comment,
      aux_sym_const_expression_repeat1,
    ACTIONS(336), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(360), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(357), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(333), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(345), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [2163] = 16,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(63), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(187), 1,
      sym_const_literal,
    STATE(252), 1,
      sym_const_expression,
    STATE(258), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [2246] = 16,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(64), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(187), 1,
      sym_const_literal,
    STATE(258), 1,
      sym_type_declaration,
    STATE(260), 1,
      sym_const_expression,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [2329] = 16,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(65), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(187), 1,
      sym_const_literal,
    STATE(258), 1,
      sym_type_declaration,
    STATE(281), 1,
      sym_const_expression,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [2412] = 16,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(55), 1,
      sym_uint_literal,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(66), 1,
      sym_comment,
    STATE(87), 1,
      sym_float_literal,
    STATE(187), 1,
      sym_const_literal,
    STATE(238), 1,
      sym_const_expression,
    STATE(258), 1,
      sym_type_declaration,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(53), 3,
      sym_int_literal,
      sym_true,
      sym_false,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [2495] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(365), 1,
      anon_sym_RPAREN,
    STATE(67), 1,
      sym_comment,
    ACTIONS(367), 3,
      sym_uint_literal,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(363), 41,
      sym_identifier,
      sym_int_literal,
      sym_true,
      sym_false,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
      anon_sym_atomic,
      anon_sym_array,
      anon_sym_ptr,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
  [2553] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(371), 1,
      anon_sym_LBRACK_LBRACK,
    STATE(71), 1,
      sym_attribute_list,
    STATE(68), 2,
      sym_comment,
      aux_sym_global_variable_declaration_repeat1,
    ACTIONS(369), 42,
      anon_sym_let,
      anon_sym_fn,
      anon_sym_struct,
      sym_identifier,
      anon_sym_var,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
      anon_sym_atomic,
      anon_sym_array,
      anon_sym_ptr,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
  [2611] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(374), 1,
      anon_sym_RPAREN,
    STATE(69), 1,
      sym_comment,
    ACTIONS(367), 3,
      sym_uint_literal,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(363), 41,
      sym_identifier,
      sym_int_literal,
      sym_true,
      sym_false,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
      anon_sym_atomic,
      anon_sym_array,
      anon_sym_ptr,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
  [2669] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(70), 1,
      sym_comment,
    ACTIONS(367), 3,
      sym_uint_literal,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(363), 41,
      sym_identifier,
      sym_int_literal,
      sym_true,
      sym_false,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
      anon_sym_atomic,
      anon_sym_array,
      anon_sym_ptr,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
  [2724] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(378), 1,
      anon_sym_LBRACK_LBRACK,
    STATE(71), 1,
      sym_comment,
    ACTIONS(376), 42,
      anon_sym_let,
      anon_sym_fn,
      anon_sym_struct,
      sym_identifier,
      anon_sym_var,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
      anon_sym_atomic,
      anon_sym_array,
      anon_sym_ptr,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
  [2778] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(382), 1,
      anon_sym_LBRACK_LBRACK,
    STATE(72), 1,
      sym_comment,
    ACTIONS(380), 42,
      anon_sym_let,
      anon_sym_fn,
      anon_sym_struct,
      sym_identifier,
      anon_sym_var,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
      anon_sym_atomic,
      anon_sym_array,
      anon_sym_ptr,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
  [2832] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(386), 1,
      anon_sym_LBRACK_LBRACK,
    STATE(73), 1,
      sym_comment,
    ACTIONS(384), 42,
      anon_sym_let,
      anon_sym_fn,
      anon_sym_struct,
      sym_identifier,
      anon_sym_var,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
      anon_sym_atomic,
      anon_sym_array,
      anon_sym_ptr,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
  [2886] = 13,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(68), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(71), 1,
      sym_attribute_list,
    STATE(74), 1,
      sym_comment,
    STATE(262), 1,
      sym_type_declaration,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [2957] = 13,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(71), 1,
      sym_attribute_list,
    STATE(75), 1,
      sym_comment,
    STATE(76), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(166), 1,
      sym_type_declaration,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [3028] = 13,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(68), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(71), 1,
      sym_attribute_list,
    STATE(76), 1,
      sym_comment,
    STATE(172), 1,
      sym_type_declaration,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [3099] = 13,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(71), 1,
      sym_attribute_list,
    STATE(74), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(77), 1,
      sym_comment,
    STATE(292), 1,
      sym_type_declaration,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [3170] = 13,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(71), 1,
      sym_attribute_list,
    STATE(78), 1,
      sym_comment,
    STATE(79), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(250), 1,
      sym_type_declaration,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [3241] = 13,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(68), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(71), 1,
      sym_attribute_list,
    STATE(79), 1,
      sym_comment,
    STATE(279), 1,
      sym_type_declaration,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [3312] = 10,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(80), 1,
      sym_comment,
    STATE(217), 1,
      sym_type_declaration,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [3374] = 10,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(81), 1,
      sym_comment,
    STATE(263), 1,
      sym_type_declaration,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [3436] = 10,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(82), 1,
      sym_comment,
    STATE(222), 1,
      sym_type_declaration,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [3498] = 10,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(63), 1,
      anon_sym_atomic,
    ACTIONS(65), 1,
      anon_sym_array,
    ACTIONS(67), 1,
      anon_sym_ptr,
    STATE(83), 1,
      sym_comment,
    STATE(280), 1,
      sym_type_declaration,
    ACTIONS(71), 4,
      anon_sym_texture_storage_1d,
      anon_sym_texture_storage_2d,
      anon_sym_texture_storage_2d_array,
      anon_sym_texture_storage_3d,
    ACTIONS(69), 7,
      anon_sym_texture_1d,
      anon_sym_texture_2d,
      anon_sym_texture_2d_array,
      anon_sym_texture_3d,
      anon_sym_texture_cube,
      anon_sym_texture_cube_array,
      anon_sym_texture_multisampled_2d,
    ACTIONS(59), 12,
      sym_identifier,
      anon_sym_bool,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
      anon_sym_sampler,
      anon_sym_sampler_comparison,
      anon_sym_texture_depth_2d,
      anon_sym_texture_depth_2d_array,
      anon_sym_texture_depth_cube,
      anon_sym_texture_depth_cube_array,
      anon_sym_texture_depth_multisampled_2d,
    ACTIONS(61), 12,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_mat2x2,
      anon_sym_mat2x3,
      anon_sym_mat2x4,
      anon_sym_mat3x2,
      anon_sym_mat3x3,
      anon_sym_mat3x4,
      anon_sym_mat4x2,
      anon_sym_mat4x3,
      anon_sym_mat4x4,
  [3560] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(390), 1,
      anon_sym_rgba8unorm,
    STATE(84), 1,
      sym_comment,
    STATE(317), 1,
      sym_texel_format,
    ACTIONS(388), 32,
      anon_sym_r8unorm,
      anon_sym_r8snorm,
      anon_sym_r8uint,
      anon_sym_r8sint,
      anon_sym_rg8unorm,
      anon_sym_rg8snorm,
      anon_sym_rg8uint,
      anon_sym_rg8sint,
      anon_sym_r16uint,
      anon_sym_r16sint,
      anon_sym_r16float,
      anon_sym_rg16uint,
      anon_sym_rg16sint,
      anon_sym_rg16float,
      anon_sym_rgba16uint,
      anon_sym_rgba16sint,
      anon_sym_rgba16float,
      anon_sym_r32uint,
      anon_sym_r32sint,
      anon_sym_r32float,
      anon_sym_rg32uint,
      anon_sym_rg32sint,
      anon_sym_rg32float,
      anon_sym_rgba32uint,
      anon_sym_rgba32sint,
      anon_sym_rgba32float,
      anon_sym_rgba8unorm_srgb,
      anon_sym_rgba8snorm,
      anon_sym_rgba8uint,
      anon_sym_rgba8sint,
      anon_sym_rg10a2unorm,
      anon_sym_rg11b10float,
  [3607] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(85), 1,
      sym_comment,
    ACTIONS(394), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(392), 20,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [3644] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(86), 1,
      sym_comment,
    ACTIONS(398), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(396), 20,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [3681] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(87), 1,
      sym_comment,
    ACTIONS(402), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(400), 20,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [3718] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    STATE(88), 1,
      sym_comment,
    ACTIONS(406), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(404), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [3757] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    STATE(89), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(412), 5,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(410), 13,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_RBRACK,
  [3803] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(90), 1,
      sym_comment,
    ACTIONS(426), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(424), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [3839] = 13,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    STATE(91), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(412), 3,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(410), 7,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_RBRACK,
  [3893] = 15,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    STATE(92), 1,
      sym_comment,
    ACTIONS(412), 2,
      anon_sym_EQ,
      anon_sym_PIPE,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(410), 6,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_RBRACK,
  [3951] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(93), 1,
      sym_comment,
    ACTIONS(442), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(440), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [3987] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(94), 1,
      sym_comment,
    ACTIONS(446), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(444), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [4023] = 16,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(412), 1,
      anon_sym_EQ,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    STATE(95), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(410), 6,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_RBRACK,
  [4083] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    STATE(96), 1,
      sym_comment,
    ACTIONS(412), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(410), 17,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
  [4123] = 12,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    STATE(97), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(412), 3,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(410), 9,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACK,
  [4175] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(98), 1,
      sym_comment,
    ACTIONS(452), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(450), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [4211] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(99), 1,
      sym_comment,
    ACTIONS(406), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(404), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [4247] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(100), 1,
      sym_comment,
    ACTIONS(456), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(454), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [4283] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(412), 1,
      anon_sym_EQ,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    STATE(101), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(410), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
  [4345] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(102), 1,
      sym_comment,
    ACTIONS(462), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(460), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [4381] = 10,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    STATE(103), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(412), 5,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(410), 11,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RBRACK,
  [4429] = 14,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(438), 1,
      anon_sym_AMP,
    STATE(104), 1,
      sym_comment,
    ACTIONS(412), 2,
      anon_sym_EQ,
      anon_sym_PIPE,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(410), 7,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_RBRACK,
  [4485] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(105), 1,
      sym_comment,
    ACTIONS(466), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(464), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [4521] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    STATE(106), 1,
      sym_comment,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(412), 5,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(410), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_RBRACK,
  [4565] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(107), 1,
      sym_comment,
    ACTIONS(470), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(468), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [4601] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(108), 1,
      sym_comment,
    ACTIONS(474), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(472), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
  [4637] = 18,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(329), 1,
      anon_sym_RPAREN,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    ACTIONS(476), 1,
      anon_sym_COMMA,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    STATE(109), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [4698] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(480), 1,
      anon_sym_SEMI,
    STATE(110), 1,
      sym_comment,
    ACTIONS(406), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(404), 15,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_DOT,
  [4733] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    STATE(111), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(482), 2,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [4792] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(268), 1,
      anon_sym_RPAREN,
    STATE(112), 1,
      sym_comment,
    ACTIONS(406), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(404), 15,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_DOT,
  [4827] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(266), 1,
      anon_sym_RPAREN,
    STATE(113), 1,
      sym_comment,
    ACTIONS(406), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(404), 15,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_DOT,
  [4862] = 18,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_COMMA,
    ACTIONS(486), 1,
      anon_sym_RPAREN,
    STATE(114), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [4923] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(488), 1,
      anon_sym_RPAREN,
    STATE(115), 1,
      sym_comment,
    ACTIONS(406), 6,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(404), 15,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_DOT,
  [4958] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(490), 1,
      anon_sym_SEMI,
    STATE(116), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [5016] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(276), 1,
      anon_sym_SEMI,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    STATE(117), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [5074] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(492), 1,
      anon_sym_RBRACK,
    STATE(118), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [5132] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(494), 1,
      anon_sym_RPAREN,
    STATE(119), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [5190] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(496), 1,
      anon_sym_COMMA,
    STATE(120), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [5248] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(498), 1,
      anon_sym_EQ,
    STATE(121), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [5306] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(500), 1,
      anon_sym_SEMI,
    STATE(122), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [5364] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(502), 1,
      anon_sym_SEMI,
    STATE(123), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [5422] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_DOT,
    ACTIONS(436), 1,
      anon_sym_CARET,
    ACTIONS(438), 1,
      anon_sym_AMP,
    ACTIONS(448), 1,
      anon_sym_PIPE,
    ACTIONS(458), 1,
      anon_sym_AMP_AMP,
    ACTIONS(478), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(504), 1,
      anon_sym_SEMI,
    STATE(124), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(416), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(430), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(434), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [5480] = 18,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(7), 1,
      anon_sym_SEMI,
    ACTIONS(9), 1,
      anon_sym_let,
    ACTIONS(11), 1,
      anon_sym_type,
    ACTIONS(13), 1,
      anon_sym_fn,
    ACTIONS(15), 1,
      anon_sym_struct,
    ACTIONS(17), 1,
      anon_sym_enable,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(21), 1,
      anon_sym_var,
    ACTIONS(506), 1,
      ts_builtin_sym_end,
    STATE(71), 1,
      sym_attribute_list,
    STATE(125), 1,
      sym_comment,
    STATE(126), 1,
      aux_sym_source_file_repeat1,
    STATE(129), 1,
      sym_function_declaration,
    STATE(132), 1,
      sym__declaration,
    STATE(146), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(202), 1,
      sym_variable_declaration,
    STATE(305), 5,
      sym_global_variable_declaration,
      sym_global_constant_declaration,
      sym_type_alias,
      sym_struct_declaration,
      sym_enable_directive,
  [5539] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(508), 1,
      ts_builtin_sym_end,
    ACTIONS(510), 1,
      anon_sym_SEMI,
    ACTIONS(513), 1,
      anon_sym_let,
    ACTIONS(516), 1,
      anon_sym_type,
    ACTIONS(519), 1,
      anon_sym_fn,
    ACTIONS(522), 1,
      anon_sym_struct,
    ACTIONS(525), 1,
      anon_sym_enable,
    ACTIONS(528), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(531), 1,
      anon_sym_var,
    STATE(71), 1,
      sym_attribute_list,
    STATE(129), 1,
      sym_function_declaration,
    STATE(132), 1,
      sym__declaration,
    STATE(146), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(202), 1,
      sym_variable_declaration,
    STATE(126), 2,
      sym_comment,
      aux_sym_source_file_repeat1,
    STATE(305), 5,
      sym_global_variable_declaration,
      sym_global_constant_declaration,
      sym_type_alias,
      sym_struct_declaration,
      sym_enable_directive,
  [5596] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(127), 1,
      sym_comment,
    ACTIONS(534), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_let,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_struct,
      anon_sym_enable,
      anon_sym_LBRACK_LBRACK,
      anon_sym_var,
  [5614] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(128), 1,
      sym_comment,
    ACTIONS(536), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_let,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_struct,
      anon_sym_enable,
      anon_sym_LBRACK_LBRACK,
      anon_sym_var,
  [5632] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(129), 1,
      sym_comment,
    ACTIONS(538), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_let,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_struct,
      anon_sym_enable,
      anon_sym_LBRACK_LBRACK,
      anon_sym_var,
  [5650] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(53), 1,
      sym_int_literal,
    ACTIONS(540), 1,
      anon_sym_COLON,
    STATE(87), 1,
      sym_float_literal,
    STATE(130), 1,
      sym_comment,
    STATE(201), 1,
      sym_const_literal,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(55), 3,
      sym_uint_literal,
      sym_true,
      sym_false,
  [5678] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(131), 1,
      sym_comment,
    ACTIONS(542), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_let,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_struct,
      anon_sym_enable,
      anon_sym_LBRACK_LBRACK,
      anon_sym_var,
  [5696] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(132), 1,
      sym_comment,
    ACTIONS(544), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_let,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_struct,
      anon_sym_enable,
      anon_sym_LBRACK_LBRACK,
      anon_sym_var,
  [5714] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(133), 1,
      sym_comment,
    ACTIONS(546), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_let,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_struct,
      anon_sym_enable,
      anon_sym_LBRACK_LBRACK,
      anon_sym_var,
  [5732] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(134), 1,
      sym_comment,
    ACTIONS(548), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_let,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_struct,
      anon_sym_enable,
      anon_sym_LBRACK_LBRACK,
      anon_sym_var,
  [5750] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(53), 1,
      sym_int_literal,
    STATE(87), 1,
      sym_float_literal,
    STATE(135), 1,
      sym_comment,
    STATE(184), 1,
      sym_const_literal,
    STATE(282), 1,
      sym_case_selectors,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(55), 3,
      sym_uint_literal,
      sym_true,
      sym_false,
  [5778] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(136), 1,
      sym_comment,
    ACTIONS(550), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_let,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_struct,
      anon_sym_enable,
      anon_sym_LBRACK_LBRACK,
      anon_sym_var,
  [5796] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(137), 1,
      sym_comment,
    ACTIONS(552), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_let,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_struct,
      anon_sym_enable,
      anon_sym_LBRACK_LBRACK,
      anon_sym_var,
  [5814] = 11,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(554), 1,
      sym_identifier,
    ACTIONS(556), 1,
      anon_sym_RBRACE,
    STATE(71), 1,
      sym_attribute_list,
    STATE(138), 1,
      sym_comment,
    STATE(145), 1,
      aux_sym_struct_member_list_repeat1,
    STATE(160), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(193), 1,
      sym_struct_member,
    STATE(244), 1,
      sym_variable_identifier_declaration,
    STATE(291), 1,
      sym_struct_member_list,
  [5848] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(53), 1,
      sym_int_literal,
    ACTIONS(558), 1,
      anon_sym_COLON,
    STATE(87), 1,
      sym_float_literal,
    STATE(139), 1,
      sym_comment,
    STATE(201), 1,
      sym_const_literal,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(55), 3,
      sym_uint_literal,
      sym_true,
      sym_false,
  [5876] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(140), 1,
      sym_comment,
    ACTIONS(560), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_let,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_struct,
      anon_sym_enable,
      anon_sym_LBRACK_LBRACK,
      anon_sym_var,
  [5894] = 11,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(554), 1,
      sym_identifier,
    ACTIONS(562), 1,
      anon_sym_RBRACE,
    STATE(71), 1,
      sym_attribute_list,
    STATE(141), 1,
      sym_comment,
    STATE(145), 1,
      aux_sym_struct_member_list_repeat1,
    STATE(160), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(193), 1,
      sym_struct_member,
    STATE(244), 1,
      sym_variable_identifier_declaration,
    STATE(245), 1,
      sym_struct_member_list,
  [5928] = 11,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(554), 1,
      sym_identifier,
    ACTIONS(564), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      sym_attribute_list,
    STATE(142), 1,
      sym_comment,
    STATE(149), 1,
      aux_sym_parameter_list_repeat1,
    STATE(158), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(194), 1,
      sym_parameter,
    STATE(231), 1,
      sym_variable_identifier_declaration,
    STATE(249), 1,
      sym_parameter_list,
  [5962] = 11,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(554), 1,
      sym_identifier,
    ACTIONS(566), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      sym_attribute_list,
    STATE(143), 1,
      sym_comment,
    STATE(149), 1,
      aux_sym_parameter_list_repeat1,
    STATE(158), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(194), 1,
      sym_parameter,
    STATE(231), 1,
      sym_variable_identifier_declaration,
    STATE(319), 1,
      sym_parameter_list,
  [5996] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(144), 1,
      sym_comment,
    ACTIONS(568), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_let,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_struct,
      anon_sym_enable,
      anon_sym_LBRACK_LBRACK,
      anon_sym_var,
  [6014] = 10,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(554), 1,
      sym_identifier,
    ACTIONS(570), 1,
      anon_sym_RBRACE,
    STATE(71), 1,
      sym_attribute_list,
    STATE(145), 1,
      sym_comment,
    STATE(147), 1,
      aux_sym_struct_member_list_repeat1,
    STATE(160), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(193), 1,
      sym_struct_member,
    STATE(244), 1,
      sym_variable_identifier_declaration,
  [6045] = 10,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(21), 1,
      anon_sym_var,
    ACTIONS(572), 1,
      anon_sym_let,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_struct,
    STATE(68), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(71), 1,
      sym_attribute_list,
    STATE(146), 1,
      sym_comment,
    STATE(212), 1,
      sym_variable_declaration,
  [6076] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(578), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_RBRACE,
    ACTIONS(583), 1,
      anon_sym_LBRACK_LBRACK,
    STATE(71), 1,
      sym_attribute_list,
    STATE(160), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(193), 1,
      sym_struct_member,
    STATE(244), 1,
      sym_variable_identifier_declaration,
    STATE(147), 2,
      sym_comment,
      aux_sym_struct_member_list_repeat1,
  [6105] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(53), 1,
      sym_int_literal,
    STATE(87), 1,
      sym_float_literal,
    STATE(148), 1,
      sym_comment,
    STATE(201), 1,
      sym_const_literal,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(55), 3,
      sym_uint_literal,
      sym_true,
      sym_false,
  [6130] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(554), 1,
      sym_identifier,
    STATE(71), 1,
      sym_attribute_list,
    STATE(149), 1,
      sym_comment,
    STATE(155), 1,
      aux_sym_parameter_list_repeat1,
    STATE(158), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(231), 1,
      sym_variable_identifier_declaration,
    STATE(233), 1,
      sym_parameter,
  [6158] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(588), 1,
      sym_int_literal,
    STATE(150), 1,
      sym_comment,
    STATE(242), 1,
      sym_literal_or_identifier,
    STATE(243), 1,
      sym_float_literal,
    ACTIONS(57), 2,
      aux_sym_float_literal_token1,
      aux_sym_float_literal_token2,
    ACTIONS(586), 2,
      sym_identifier,
      sym_uint_literal,
  [6182] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(151), 1,
      sym_comment,
    ACTIONS(590), 7,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_GT,
  [6198] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(152), 1,
      sym_comment,
    ACTIONS(592), 7,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_GT,
  [6214] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(153), 1,
      sym_comment,
    ACTIONS(408), 7,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_GT,
  [6230] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(154), 1,
      sym_comment,
    ACTIONS(594), 7,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_GT,
  [6246] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_LBRACK_LBRACK,
    STATE(71), 1,
      sym_attribute_list,
    STATE(158), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(231), 1,
      sym_variable_identifier_declaration,
    STATE(307), 1,
      sym_parameter,
    STATE(155), 2,
      sym_comment,
      aux_sym_parameter_list_repeat1,
  [6272] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(156), 1,
      sym_comment,
    STATE(273), 1,
      sym_storage_class,
    ACTIONS(602), 5,
      anon_sym_function,
      anon_sym_private,
      anon_sym_workgroup,
      anon_sym_uniform,
      anon_sym_storage,
  [6289] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(157), 1,
      sym_comment,
    STATE(219), 1,
      sym_storage_class,
    ACTIONS(602), 5,
      anon_sym_function,
      anon_sym_private,
      anon_sym_workgroup,
      anon_sym_uniform,
      anon_sym_storage,
  [6306] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(554), 1,
      sym_identifier,
    STATE(68), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(71), 1,
      sym_attribute_list,
    STATE(158), 1,
      sym_comment,
    STATE(235), 1,
      sym_variable_identifier_declaration,
  [6328] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(604), 1,
      anon_sym_RBRACE,
    ACTIONS(606), 1,
      anon_sym_case,
    ACTIONS(609), 1,
      anon_sym_default,
    STATE(186), 1,
      sym_switch_body,
    STATE(159), 2,
      sym_comment,
      aux_sym_switch_statement_repeat1,
  [6348] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(554), 1,
      sym_identifier,
    STATE(68), 1,
      aux_sym_global_variable_declaration_repeat1,
    STATE(71), 1,
      sym_attribute_list,
    STATE(160), 1,
      sym_comment,
    STATE(257), 1,
      sym_variable_identifier_declaration,
  [6370] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(612), 1,
      anon_sym_RBRACE,
    ACTIONS(614), 1,
      anon_sym_case,
    ACTIONS(616), 1,
      anon_sym_default,
    STATE(159), 1,
      aux_sym_switch_statement_repeat1,
    STATE(161), 1,
      sym_comment,
    STATE(186), 1,
      sym_switch_body,
  [6392] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(614), 1,
      anon_sym_case,
    ACTIONS(616), 1,
      anon_sym_default,
    STATE(161), 1,
      aux_sym_switch_statement_repeat1,
    STATE(162), 1,
      sym_comment,
    STATE(186), 1,
      sym_switch_body,
  [6411] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(618), 1,
      anon_sym_DASH_GT,
    STATE(140), 1,
      sym_compound_statement,
    STATE(163), 1,
      sym_comment,
    STATE(200), 1,
      sym_function_return_type_declaration,
  [6430] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(620), 1,
      anon_sym_read,
    STATE(164), 1,
      sym_comment,
    STATE(270), 1,
      sym_access_mode,
    ACTIONS(622), 2,
      anon_sym_write,
      anon_sym_read_write,
  [6447] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(618), 1,
      anon_sym_DASH_GT,
    STATE(137), 1,
      sym_compound_statement,
    STATE(165), 1,
      sym_comment,
    STATE(234), 1,
      sym_function_return_type_declaration,
  [6466] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(166), 1,
      sym_comment,
    ACTIONS(624), 4,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [6479] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(620), 1,
      anon_sym_read,
    STATE(167), 1,
      sym_comment,
    STATE(236), 1,
      sym_access_mode,
    ACTIONS(622), 2,
      anon_sym_write,
      anon_sym_read_write,
  [6496] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(554), 1,
      sym_identifier,
    ACTIONS(626), 1,
      anon_sym_LT,
    STATE(168), 1,
      sym_comment,
    STATE(195), 1,
      sym_variable_identifier_declaration,
    STATE(209), 1,
      sym_variable_qualifier,
  [6515] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(618), 1,
      anon_sym_DASH_GT,
    STATE(133), 1,
      sym_compound_statement,
    STATE(169), 1,
      sym_comment,
    STATE(211), 1,
      sym_function_return_type_declaration,
  [6534] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(620), 1,
      anon_sym_read,
    STATE(170), 1,
      sym_comment,
    STATE(277), 1,
      sym_access_mode,
    ACTIONS(622), 2,
      anon_sym_write,
      anon_sym_read_write,
  [6551] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(618), 1,
      anon_sym_DASH_GT,
    STATE(136), 1,
      sym_compound_statement,
    STATE(171), 1,
      sym_comment,
    STATE(221), 1,
      sym_function_return_type_declaration,
  [6570] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(172), 1,
      sym_comment,
    ACTIONS(628), 4,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [6583] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(632), 1,
      anon_sym_RPAREN,
    STATE(173), 1,
      sym_comment,
    ACTIONS(630), 2,
      anon_sym_LBRACK_LBRACK,
      sym_identifier,
  [6597] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(174), 1,
      sym_comment,
    ACTIONS(634), 3,
      anon_sym_u32,
      anon_sym_i32,
      anon_sym_f32,
  [6609] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(175), 1,
      sym_comment,
    ACTIONS(636), 3,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
  [6621] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(176), 1,
      sym_comment,
    ACTIONS(638), 3,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
  [6633] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(640), 1,
      anon_sym_COMMA,
    ACTIONS(643), 1,
      anon_sym_COLON,
    STATE(177), 2,
      sym_comment,
      aux_sym_case_selectors_repeat1,
  [6647] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(178), 1,
      sym_comment,
    STATE(182), 1,
      aux_sym_attribute_list_repeat1,
    STATE(207), 1,
      sym_attribute,
  [6663] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(558), 1,
      anon_sym_COLON,
    ACTIONS(647), 1,
      anon_sym_COMMA,
    STATE(177), 1,
      aux_sym_case_selectors_repeat1,
    STATE(179), 1,
      sym_comment,
  [6679] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(180), 1,
      sym_comment,
    ACTIONS(649), 3,
      anon_sym_RBRACE,
      anon_sym_LBRACK_LBRACK,
      sym_identifier,
  [6691] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(651), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_comment,
    ACTIONS(653), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK_RBRACK,
  [6705] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(182), 1,
      sym_comment,
    STATE(185), 1,
      aux_sym_attribute_list_repeat1,
    STATE(214), 1,
      sym_attribute,
  [6721] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(183), 1,
      sym_comment,
    ACTIONS(655), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [6733] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(657), 1,
      anon_sym_COMMA,
    ACTIONS(659), 1,
      anon_sym_COLON,
    STATE(179), 1,
      aux_sym_case_selectors_repeat1,
    STATE(184), 1,
      sym_comment,
  [6749] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(661), 1,
      sym_identifier,
    STATE(241), 1,
      sym_attribute,
    STATE(185), 2,
      sym_comment,
      aux_sym_attribute_list_repeat1,
  [6763] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(186), 1,
      sym_comment,
    ACTIONS(664), 3,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
  [6775] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(187), 1,
      sym_comment,
    ACTIONS(666), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [6787] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(188), 1,
      sym_comment,
    ACTIONS(668), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [6799] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(189), 1,
      sym_comment,
    ACTIONS(670), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [6811] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(190), 1,
      sym_comment,
    ACTIONS(672), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [6823] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(191), 1,
      sym_comment,
    ACTIONS(674), 3,
      anon_sym_RBRACE,
      anon_sym_LBRACK_LBRACK,
      sym_identifier,
  [6835] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(676), 1,
      anon_sym_RPAREN,
    STATE(192), 1,
      sym_comment,
    ACTIONS(630), 2,
      anon_sym_LBRACK_LBRACK,
      sym_identifier,
  [6849] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(193), 1,
      sym_comment,
    ACTIONS(678), 3,
      anon_sym_RBRACE,
      anon_sym_LBRACK_LBRACK,
      sym_identifier,
  [6861] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(680), 1,
      anon_sym_COMMA,
    ACTIONS(682), 1,
      anon_sym_RPAREN,
    STATE(194), 1,
      sym_comment,
  [6874] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(195), 1,
      sym_comment,
    ACTIONS(684), 2,
      anon_sym_SEMI,
      anon_sym_EQ,
  [6885] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    STATE(13), 1,
      sym_compound_statement,
    STATE(196), 1,
      sym_comment,
  [6898] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(686), 1,
      anon_sym_SEMI,
    ACTIONS(688), 1,
      anon_sym_EQ,
    STATE(197), 1,
      sym_comment,
  [6911] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(554), 1,
      sym_identifier,
    STATE(198), 1,
      sym_comment,
    STATE(203), 1,
      sym_variable_identifier_declaration,
  [6924] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(690), 1,
      anon_sym_LPAREN,
    STATE(108), 1,
      sym_argument_list_expression,
    STATE(199), 1,
      sym_comment,
  [6937] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    STATE(128), 1,
      sym_compound_statement,
    STATE(200), 1,
      sym_comment,
  [6950] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(201), 1,
      sym_comment,
    ACTIONS(643), 2,
      anon_sym_COMMA,
      anon_sym_COLON,
  [6961] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(692), 1,
      anon_sym_SEMI,
    ACTIONS(694), 1,
      anon_sym_EQ,
    STATE(202), 1,
      sym_comment,
  [6974] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(698), 1,
      anon_sym_EQ,
    STATE(203), 1,
      sym_comment,
  [6987] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    STATE(204), 1,
      sym_comment,
    STATE(302), 1,
      sym_parenthesized_expression,
  [7000] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    STATE(196), 1,
      sym_parenthesized_expression,
    STATE(205), 1,
      sym_comment,
  [7013] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(700), 1,
      sym_identifier,
    STATE(206), 1,
      sym_comment,
    STATE(289), 1,
      sym_variable_identifier_declaration,
  [7026] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(702), 1,
      anon_sym_COMMA,
    ACTIONS(704), 1,
      anon_sym_RBRACK_RBRACK,
    STATE(207), 1,
      sym_comment,
  [7039] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(374), 1,
      anon_sym_RPAREN,
    ACTIONS(706), 1,
      anon_sym_COMMA,
    STATE(208), 1,
      sym_comment,
  [7052] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(554), 1,
      sym_identifier,
    STATE(209), 1,
      sym_comment,
    STATE(220), 1,
      sym_variable_identifier_declaration,
  [7065] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(554), 1,
      sym_identifier,
    STATE(210), 1,
      sym_comment,
    STATE(227), 1,
      sym_variable_identifier_declaration,
  [7078] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    STATE(131), 1,
      sym_compound_statement,
    STATE(211), 1,
      sym_comment,
  [7091] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(708), 1,
      anon_sym_SEMI,
    ACTIONS(710), 1,
      anon_sym_EQ,
    STATE(212), 1,
      sym_comment,
  [7104] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(712), 1,
      anon_sym_COMMA,
    ACTIONS(714), 1,
      anon_sym_RPAREN,
    STATE(213), 1,
      sym_comment,
  [7117] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(702), 1,
      anon_sym_COMMA,
    ACTIONS(716), 1,
      anon_sym_RBRACK_RBRACK,
    STATE(214), 1,
      sym_comment,
  [7130] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(215), 1,
      sym_comment,
    ACTIONS(630), 2,
      anon_sym_LBRACK_LBRACK,
      sym_identifier,
  [7141] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    STATE(17), 1,
      sym_compound_statement,
    STATE(216), 1,
      sym_comment,
  [7154] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(718), 1,
      anon_sym_COMMA,
    ACTIONS(720), 1,
      anon_sym_GT,
    STATE(217), 1,
      sym_comment,
  [7167] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(218), 1,
      sym_comment,
    ACTIONS(722), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [7178] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(726), 1,
      anon_sym_GT,
    STATE(219), 1,
      sym_comment,
  [7191] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(220), 1,
      sym_comment,
    ACTIONS(728), 2,
      anon_sym_SEMI,
      anon_sym_EQ,
  [7202] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    STATE(134), 1,
      sym_compound_statement,
    STATE(221), 1,
      sym_comment,
  [7215] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(730), 1,
      anon_sym_COMMA,
    ACTIONS(732), 1,
      anon_sym_GT,
    STATE(222), 1,
      sym_comment,
  [7228] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    STATE(102), 1,
      sym_parenthesized_expression,
    STATE(223), 1,
      sym_comment,
  [7241] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    STATE(25), 1,
      sym_compound_statement,
    STATE(224), 1,
      sym_comment,
  [7254] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(734), 1,
      anon_sym_EQ,
    ACTIONS(736), 1,
      anon_sym_COLON,
    STATE(225), 1,
      sym_comment,
  [7267] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(226), 1,
      sym_comment,
    ACTIONS(738), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK_RBRACK,
  [7278] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(740), 1,
      anon_sym_SEMI,
    ACTIONS(742), 1,
      anon_sym_EQ,
    STATE(227), 1,
      sym_comment,
  [7291] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    STATE(228), 1,
      sym_comment,
    STATE(264), 1,
      sym_compound_statement,
  [7304] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    STATE(29), 1,
      sym_compound_statement,
    STATE(229), 1,
      sym_comment,
  [7317] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    STATE(216), 1,
      sym_parenthesized_expression,
    STATE(230), 1,
      sym_comment,
  [7330] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(231), 1,
      sym_comment,
    ACTIONS(744), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [7341] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(232), 1,
      sym_comment,
    ACTIONS(634), 2,
      anon_sym_u32,
      anon_sym_i32,
  [7352] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(676), 1,
      anon_sym_RPAREN,
    ACTIONS(746), 1,
      anon_sym_COMMA,
    STATE(233), 1,
      sym_comment,
  [7365] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    STATE(144), 1,
      sym_compound_statement,
    STATE(234), 1,
      sym_comment,
  [7378] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(235), 1,
      sym_comment,
    ACTIONS(748), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [7389] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(720), 1,
      anon_sym_GT,
    STATE(236), 1,
      sym_comment,
  [7399] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(750), 1,
      anon_sym_SEMI,
    STATE(237), 1,
      sym_comment,
  [7409] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(752), 1,
      anon_sym_SEMI,
    STATE(238), 1,
      sym_comment,
  [7419] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(754), 1,
      anon_sym_RPAREN,
    STATE(239), 1,
      sym_comment,
  [7429] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(756), 1,
      sym_identifier,
    STATE(240), 1,
      sym_comment,
  [7439] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(702), 1,
      anon_sym_COMMA,
    STATE(241), 1,
      sym_comment,
  [7449] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(758), 1,
      anon_sym_RPAREN,
    STATE(242), 1,
      sym_comment,
  [7459] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(760), 1,
      anon_sym_RPAREN,
    STATE(243), 1,
      sym_comment,
  [7469] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(762), 1,
      anon_sym_SEMI,
    STATE(244), 1,
      sym_comment,
  [7479] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(764), 1,
      anon_sym_RBRACE,
    STATE(245), 1,
      sym_comment,
  [7489] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(766), 1,
      anon_sym_SEMI,
    STATE(246), 1,
      sym_comment,
  [7499] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(480), 1,
      anon_sym_SEMI,
    STATE(247), 1,
      sym_comment,
  [7509] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(768), 1,
      anon_sym_LT,
    STATE(248), 1,
      sym_comment,
  [7519] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(770), 1,
      anon_sym_RPAREN,
    STATE(249), 1,
      sym_comment,
  [7529] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(772), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      sym_comment,
  [7539] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(774), 1,
      anon_sym_SEMI,
    STATE(251), 1,
      sym_comment,
  [7549] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(776), 1,
      anon_sym_SEMI,
    STATE(252), 1,
      sym_comment,
  [7559] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(778), 1,
      anon_sym_LBRACE,
    STATE(253), 1,
      sym_comment,
  [7569] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    STATE(254), 1,
      sym_comment,
  [7579] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(782), 1,
      anon_sym_SEMI,
    STATE(255), 1,
      sym_comment,
  [7589] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(31), 1,
      anon_sym_RBRACE,
    STATE(256), 1,
      sym_comment,
  [7599] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(784), 1,
      anon_sym_SEMI,
    STATE(257), 1,
      sym_comment,
  [7609] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(786), 1,
      anon_sym_LPAREN,
    STATE(258), 1,
      sym_comment,
  [7619] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(788), 1,
      anon_sym_GT,
    STATE(259), 1,
      sym_comment,
  [7629] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(790), 1,
      anon_sym_SEMI,
    STATE(260), 1,
      sym_comment,
  [7639] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(792), 1,
      anon_sym_COLON,
    STATE(261), 1,
      sym_comment,
  [7649] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(794), 1,
      anon_sym_LBRACE,
    STATE(262), 1,
      sym_comment,
  [7659] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(796), 1,
      anon_sym_GT,
    STATE(263), 1,
      sym_comment,
  [7669] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(798), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_comment,
  [7679] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(800), 1,
      anon_sym_LT,
    STATE(265), 1,
      sym_comment,
  [7689] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(802), 1,
      anon_sym_RBRACE,
    STATE(266), 1,
      sym_comment,
  [7699] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(804), 1,
      anon_sym_LT,
    STATE(267), 1,
      sym_comment,
  [7709] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(806), 1,
      anon_sym_LT,
    STATE(268), 1,
      sym_comment,
  [7719] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(808), 1,
      anon_sym_LT,
    STATE(269), 1,
      sym_comment,
  [7729] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(810), 1,
      anon_sym_GT,
    STATE(270), 1,
      sym_comment,
  [7739] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(812), 1,
      sym_identifier,
    STATE(271), 1,
      sym_comment,
  [7749] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(814), 1,
      anon_sym_LT,
    STATE(272), 1,
      sym_comment,
  [7759] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(816), 1,
      anon_sym_COMMA,
    STATE(273), 1,
      sym_comment,
  [7769] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(818), 1,
      anon_sym_COMMA,
    STATE(274), 1,
      sym_comment,
  [7779] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(820), 1,
      anon_sym_COMMA,
    STATE(275), 1,
      sym_comment,
  [7789] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(822), 1,
      anon_sym_SEMI,
    STATE(276), 1,
      sym_comment,
  [7799] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(824), 1,
      anon_sym_GT,
    STATE(277), 1,
      sym_comment,
  [7809] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(826), 1,
      anon_sym_LT,
    STATE(278), 1,
      sym_comment,
  [7819] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(828), 1,
      anon_sym_SEMI,
    STATE(279), 1,
      sym_comment,
  [7829] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(732), 1,
      anon_sym_GT,
    STATE(280), 1,
      sym_comment,
  [7839] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(830), 1,
      anon_sym_SEMI,
    STATE(281), 1,
      sym_comment,
  [7849] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(832), 1,
      anon_sym_COLON,
    STATE(282), 1,
      sym_comment,
  [7859] = 3,
    ACTIONS(834), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(836), 1,
      aux_sym_comment_token1,
    STATE(283), 1,
      sym_comment,
  [7869] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(838), 1,
      anon_sym_LBRACE,
    STATE(284), 1,
      sym_comment,
  [7879] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(840), 1,
      sym_identifier,
    STATE(285), 1,
      sym_comment,
  [7889] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(842), 1,
      sym_identifier,
    STATE(286), 1,
      sym_comment,
  [7899] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(844), 1,
      sym_identifier,
    STATE(287), 1,
      sym_comment,
  [7909] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(268), 1,
      anon_sym_RPAREN,
    STATE(288), 1,
      sym_comment,
  [7919] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(734), 1,
      anon_sym_EQ,
    STATE(289), 1,
      sym_comment,
  [7929] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(846), 1,
      anon_sym_SEMI,
    STATE(290), 1,
      sym_comment,
  [7939] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(848), 1,
      anon_sym_RBRACE,
    STATE(291), 1,
      sym_comment,
  [7949] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(850), 1,
      anon_sym_LBRACE,
    STATE(292), 1,
      sym_comment,
  [7959] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(852), 1,
      sym_int_literal,
    STATE(293), 1,
      sym_comment,
  [7969] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(854), 1,
      anon_sym_SEMI,
    STATE(294), 1,
      sym_comment,
  [7979] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(856), 1,
      anon_sym_LBRACE,
    STATE(295), 1,
      sym_comment,
  [7989] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(858), 1,
      anon_sym_LPAREN,
    STATE(296), 1,
      sym_comment,
  [7999] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(860), 1,
      anon_sym_EQ,
    STATE(297), 1,
      sym_comment,
  [8009] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(862), 1,
      anon_sym_LBRACE,
    STATE(298), 1,
      sym_comment,
  [8019] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(864), 1,
      anon_sym_LBRACE,
    STATE(299), 1,
      sym_comment,
  [8029] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(736), 1,
      anon_sym_COLON,
    STATE(300), 1,
      sym_comment,
  [8039] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(866), 1,
      sym_identifier,
    STATE(301), 1,
      sym_comment,
  [8049] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(302), 1,
      sym_comment,
  [8059] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(266), 1,
      anon_sym_RPAREN,
    STATE(303), 1,
      sym_comment,
  [8069] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(870), 1,
      anon_sym_LPAREN,
    STATE(304), 1,
      sym_comment,
  [8079] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(872), 1,
      anon_sym_SEMI,
    STATE(305), 1,
      sym_comment,
  [8089] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(874), 1,
      ts_builtin_sym_end,
    STATE(306), 1,
      sym_comment,
  [8099] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(876), 1,
      anon_sym_COMMA,
    STATE(307), 1,
      sym_comment,
  [8109] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(878), 1,
      sym_identifier,
    STATE(308), 1,
      sym_comment,
  [8119] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(880), 1,
      anon_sym_SEMI,
    STATE(309), 1,
      sym_comment,
  [8129] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(882), 1,
      sym_identifier,
    STATE(310), 1,
      sym_comment,
  [8139] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(884), 1,
      anon_sym_SEMI,
    STATE(311), 1,
      sym_comment,
  [8149] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(886), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      sym_comment,
  [8159] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(888), 1,
      sym_identifier,
    STATE(313), 1,
      sym_comment,
  [8169] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(81), 1,
      anon_sym_RBRACE,
    STATE(314), 1,
      sym_comment,
  [8179] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(488), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym_comment,
  [8189] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(890), 1,
      sym_identifier,
    STATE(316), 1,
      sym_comment,
  [8199] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(892), 1,
      anon_sym_COMMA,
    STATE(317), 1,
      sym_comment,
  [8209] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(894), 1,
      anon_sym_RBRACE,
    STATE(318), 1,
      sym_comment,
  [8219] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(896), 1,
      anon_sym_RPAREN,
    STATE(319), 1,
      sym_comment,
  [8229] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(898), 1,
      anon_sym_RBRACE,
    STATE(320), 1,
      sym_comment,
  [8239] = 1,
    ACTIONS(900), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(41)] = 0,
  [SMALL_STATE(42)] = 107,
  [SMALL_STATE(43)] = 214,
  [SMALL_STATE(44)] = 321,
  [SMALL_STATE(45)] = 428,
  [SMALL_STATE(46)] = 535,
  [SMALL_STATE(47)] = 642,
  [SMALL_STATE(48)] = 749,
  [SMALL_STATE(49)] = 856,
  [SMALL_STATE(50)] = 963,
  [SMALL_STATE(51)] = 1070,
  [SMALL_STATE(52)] = 1177,
  [SMALL_STATE(53)] = 1284,
  [SMALL_STATE(54)] = 1391,
  [SMALL_STATE(55)] = 1498,
  [SMALL_STATE(56)] = 1605,
  [SMALL_STATE(57)] = 1712,
  [SMALL_STATE(58)] = 1777,
  [SMALL_STATE(59)] = 1842,
  [SMALL_STATE(60)] = 1904,
  [SMALL_STATE(61)] = 1993,
  [SMALL_STATE(62)] = 2079,
  [SMALL_STATE(63)] = 2163,
  [SMALL_STATE(64)] = 2246,
  [SMALL_STATE(65)] = 2329,
  [SMALL_STATE(66)] = 2412,
  [SMALL_STATE(67)] = 2495,
  [SMALL_STATE(68)] = 2553,
  [SMALL_STATE(69)] = 2611,
  [SMALL_STATE(70)] = 2669,
  [SMALL_STATE(71)] = 2724,
  [SMALL_STATE(72)] = 2778,
  [SMALL_STATE(73)] = 2832,
  [SMALL_STATE(74)] = 2886,
  [SMALL_STATE(75)] = 2957,
  [SMALL_STATE(76)] = 3028,
  [SMALL_STATE(77)] = 3099,
  [SMALL_STATE(78)] = 3170,
  [SMALL_STATE(79)] = 3241,
  [SMALL_STATE(80)] = 3312,
  [SMALL_STATE(81)] = 3374,
  [SMALL_STATE(82)] = 3436,
  [SMALL_STATE(83)] = 3498,
  [SMALL_STATE(84)] = 3560,
  [SMALL_STATE(85)] = 3607,
  [SMALL_STATE(86)] = 3644,
  [SMALL_STATE(87)] = 3681,
  [SMALL_STATE(88)] = 3718,
  [SMALL_STATE(89)] = 3757,
  [SMALL_STATE(90)] = 3803,
  [SMALL_STATE(91)] = 3839,
  [SMALL_STATE(92)] = 3893,
  [SMALL_STATE(93)] = 3951,
  [SMALL_STATE(94)] = 3987,
  [SMALL_STATE(95)] = 4023,
  [SMALL_STATE(96)] = 4083,
  [SMALL_STATE(97)] = 4123,
  [SMALL_STATE(98)] = 4175,
  [SMALL_STATE(99)] = 4211,
  [SMALL_STATE(100)] = 4247,
  [SMALL_STATE(101)] = 4283,
  [SMALL_STATE(102)] = 4345,
  [SMALL_STATE(103)] = 4381,
  [SMALL_STATE(104)] = 4429,
  [SMALL_STATE(105)] = 4485,
  [SMALL_STATE(106)] = 4521,
  [SMALL_STATE(107)] = 4565,
  [SMALL_STATE(108)] = 4601,
  [SMALL_STATE(109)] = 4637,
  [SMALL_STATE(110)] = 4698,
  [SMALL_STATE(111)] = 4733,
  [SMALL_STATE(112)] = 4792,
  [SMALL_STATE(113)] = 4827,
  [SMALL_STATE(114)] = 4862,
  [SMALL_STATE(115)] = 4923,
  [SMALL_STATE(116)] = 4958,
  [SMALL_STATE(117)] = 5016,
  [SMALL_STATE(118)] = 5074,
  [SMALL_STATE(119)] = 5132,
  [SMALL_STATE(120)] = 5190,
  [SMALL_STATE(121)] = 5248,
  [SMALL_STATE(122)] = 5306,
  [SMALL_STATE(123)] = 5364,
  [SMALL_STATE(124)] = 5422,
  [SMALL_STATE(125)] = 5480,
  [SMALL_STATE(126)] = 5539,
  [SMALL_STATE(127)] = 5596,
  [SMALL_STATE(128)] = 5614,
  [SMALL_STATE(129)] = 5632,
  [SMALL_STATE(130)] = 5650,
  [SMALL_STATE(131)] = 5678,
  [SMALL_STATE(132)] = 5696,
  [SMALL_STATE(133)] = 5714,
  [SMALL_STATE(134)] = 5732,
  [SMALL_STATE(135)] = 5750,
  [SMALL_STATE(136)] = 5778,
  [SMALL_STATE(137)] = 5796,
  [SMALL_STATE(138)] = 5814,
  [SMALL_STATE(139)] = 5848,
  [SMALL_STATE(140)] = 5876,
  [SMALL_STATE(141)] = 5894,
  [SMALL_STATE(142)] = 5928,
  [SMALL_STATE(143)] = 5962,
  [SMALL_STATE(144)] = 5996,
  [SMALL_STATE(145)] = 6014,
  [SMALL_STATE(146)] = 6045,
  [SMALL_STATE(147)] = 6076,
  [SMALL_STATE(148)] = 6105,
  [SMALL_STATE(149)] = 6130,
  [SMALL_STATE(150)] = 6158,
  [SMALL_STATE(151)] = 6182,
  [SMALL_STATE(152)] = 6198,
  [SMALL_STATE(153)] = 6214,
  [SMALL_STATE(154)] = 6230,
  [SMALL_STATE(155)] = 6246,
  [SMALL_STATE(156)] = 6272,
  [SMALL_STATE(157)] = 6289,
  [SMALL_STATE(158)] = 6306,
  [SMALL_STATE(159)] = 6328,
  [SMALL_STATE(160)] = 6348,
  [SMALL_STATE(161)] = 6370,
  [SMALL_STATE(162)] = 6392,
  [SMALL_STATE(163)] = 6411,
  [SMALL_STATE(164)] = 6430,
  [SMALL_STATE(165)] = 6447,
  [SMALL_STATE(166)] = 6466,
  [SMALL_STATE(167)] = 6479,
  [SMALL_STATE(168)] = 6496,
  [SMALL_STATE(169)] = 6515,
  [SMALL_STATE(170)] = 6534,
  [SMALL_STATE(171)] = 6551,
  [SMALL_STATE(172)] = 6570,
  [SMALL_STATE(173)] = 6583,
  [SMALL_STATE(174)] = 6597,
  [SMALL_STATE(175)] = 6609,
  [SMALL_STATE(176)] = 6621,
  [SMALL_STATE(177)] = 6633,
  [SMALL_STATE(178)] = 6647,
  [SMALL_STATE(179)] = 6663,
  [SMALL_STATE(180)] = 6679,
  [SMALL_STATE(181)] = 6691,
  [SMALL_STATE(182)] = 6705,
  [SMALL_STATE(183)] = 6721,
  [SMALL_STATE(184)] = 6733,
  [SMALL_STATE(185)] = 6749,
  [SMALL_STATE(186)] = 6763,
  [SMALL_STATE(187)] = 6775,
  [SMALL_STATE(188)] = 6787,
  [SMALL_STATE(189)] = 6799,
  [SMALL_STATE(190)] = 6811,
  [SMALL_STATE(191)] = 6823,
  [SMALL_STATE(192)] = 6835,
  [SMALL_STATE(193)] = 6849,
  [SMALL_STATE(194)] = 6861,
  [SMALL_STATE(195)] = 6874,
  [SMALL_STATE(196)] = 6885,
  [SMALL_STATE(197)] = 6898,
  [SMALL_STATE(198)] = 6911,
  [SMALL_STATE(199)] = 6924,
  [SMALL_STATE(200)] = 6937,
  [SMALL_STATE(201)] = 6950,
  [SMALL_STATE(202)] = 6961,
  [SMALL_STATE(203)] = 6974,
  [SMALL_STATE(204)] = 6987,
  [SMALL_STATE(205)] = 7000,
  [SMALL_STATE(206)] = 7013,
  [SMALL_STATE(207)] = 7026,
  [SMALL_STATE(208)] = 7039,
  [SMALL_STATE(209)] = 7052,
  [SMALL_STATE(210)] = 7065,
  [SMALL_STATE(211)] = 7078,
  [SMALL_STATE(212)] = 7091,
  [SMALL_STATE(213)] = 7104,
  [SMALL_STATE(214)] = 7117,
  [SMALL_STATE(215)] = 7130,
  [SMALL_STATE(216)] = 7141,
  [SMALL_STATE(217)] = 7154,
  [SMALL_STATE(218)] = 7167,
  [SMALL_STATE(219)] = 7178,
  [SMALL_STATE(220)] = 7191,
  [SMALL_STATE(221)] = 7202,
  [SMALL_STATE(222)] = 7215,
  [SMALL_STATE(223)] = 7228,
  [SMALL_STATE(224)] = 7241,
  [SMALL_STATE(225)] = 7254,
  [SMALL_STATE(226)] = 7267,
  [SMALL_STATE(227)] = 7278,
  [SMALL_STATE(228)] = 7291,
  [SMALL_STATE(229)] = 7304,
  [SMALL_STATE(230)] = 7317,
  [SMALL_STATE(231)] = 7330,
  [SMALL_STATE(232)] = 7341,
  [SMALL_STATE(233)] = 7352,
  [SMALL_STATE(234)] = 7365,
  [SMALL_STATE(235)] = 7378,
  [SMALL_STATE(236)] = 7389,
  [SMALL_STATE(237)] = 7399,
  [SMALL_STATE(238)] = 7409,
  [SMALL_STATE(239)] = 7419,
  [SMALL_STATE(240)] = 7429,
  [SMALL_STATE(241)] = 7439,
  [SMALL_STATE(242)] = 7449,
  [SMALL_STATE(243)] = 7459,
  [SMALL_STATE(244)] = 7469,
  [SMALL_STATE(245)] = 7479,
  [SMALL_STATE(246)] = 7489,
  [SMALL_STATE(247)] = 7499,
  [SMALL_STATE(248)] = 7509,
  [SMALL_STATE(249)] = 7519,
  [SMALL_STATE(250)] = 7529,
  [SMALL_STATE(251)] = 7539,
  [SMALL_STATE(252)] = 7549,
  [SMALL_STATE(253)] = 7559,
  [SMALL_STATE(254)] = 7569,
  [SMALL_STATE(255)] = 7579,
  [SMALL_STATE(256)] = 7589,
  [SMALL_STATE(257)] = 7599,
  [SMALL_STATE(258)] = 7609,
  [SMALL_STATE(259)] = 7619,
  [SMALL_STATE(260)] = 7629,
  [SMALL_STATE(261)] = 7639,
  [SMALL_STATE(262)] = 7649,
  [SMALL_STATE(263)] = 7659,
  [SMALL_STATE(264)] = 7669,
  [SMALL_STATE(265)] = 7679,
  [SMALL_STATE(266)] = 7689,
  [SMALL_STATE(267)] = 7699,
  [SMALL_STATE(268)] = 7709,
  [SMALL_STATE(269)] = 7719,
  [SMALL_STATE(270)] = 7729,
  [SMALL_STATE(271)] = 7739,
  [SMALL_STATE(272)] = 7749,
  [SMALL_STATE(273)] = 7759,
  [SMALL_STATE(274)] = 7769,
  [SMALL_STATE(275)] = 7779,
  [SMALL_STATE(276)] = 7789,
  [SMALL_STATE(277)] = 7799,
  [SMALL_STATE(278)] = 7809,
  [SMALL_STATE(279)] = 7819,
  [SMALL_STATE(280)] = 7829,
  [SMALL_STATE(281)] = 7839,
  [SMALL_STATE(282)] = 7849,
  [SMALL_STATE(283)] = 7859,
  [SMALL_STATE(284)] = 7869,
  [SMALL_STATE(285)] = 7879,
  [SMALL_STATE(286)] = 7889,
  [SMALL_STATE(287)] = 7899,
  [SMALL_STATE(288)] = 7909,
  [SMALL_STATE(289)] = 7919,
  [SMALL_STATE(290)] = 7929,
  [SMALL_STATE(291)] = 7939,
  [SMALL_STATE(292)] = 7949,
  [SMALL_STATE(293)] = 7959,
  [SMALL_STATE(294)] = 7969,
  [SMALL_STATE(295)] = 7979,
  [SMALL_STATE(296)] = 7989,
  [SMALL_STATE(297)] = 7999,
  [SMALL_STATE(298)] = 8009,
  [SMALL_STATE(299)] = 8019,
  [SMALL_STATE(300)] = 8029,
  [SMALL_STATE(301)] = 8039,
  [SMALL_STATE(302)] = 8049,
  [SMALL_STATE(303)] = 8059,
  [SMALL_STATE(304)] = 8069,
  [SMALL_STATE(305)] = 8079,
  [SMALL_STATE(306)] = 8089,
  [SMALL_STATE(307)] = 8099,
  [SMALL_STATE(308)] = 8109,
  [SMALL_STATE(309)] = 8119,
  [SMALL_STATE(310)] = 8129,
  [SMALL_STATE(311)] = 8139,
  [SMALL_STATE(312)] = 8149,
  [SMALL_STATE(313)] = 8159,
  [SMALL_STATE(314)] = 8169,
  [SMALL_STATE(315)] = 8179,
  [SMALL_STATE(316)] = 8189,
  [SMALL_STATE(317)] = 8199,
  [SMALL_STATE(318)] = 8209,
  [SMALL_STATE(319)] = 8219,
  [SMALL_STATE(320)] = 8229,
  [SMALL_STATE(321)] = 8239,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(88),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(205),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(311),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(153),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(272),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(278),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [85] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(88),
  [88] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(206),
  [91] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(51),
  [94] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(7),
  [97] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2),
  [99] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(205),
  [102] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(204),
  [105] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(298),
  [108] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(304),
  [111] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(309),
  [114] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(311),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2),
  [119] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(36),
  [122] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(237),
  [125] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(168),
  [128] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(87),
  [131] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(87),
  [134] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(85),
  [137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(153),
  [140] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(272),
  [143] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(269),
  [146] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(268),
  [149] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(267),
  [152] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(265),
  [155] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(278),
  [158] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(248),
  [161] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(56),
  [164] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(56),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [171] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_statement, 2),
  [173] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_statement, 2),
  [175] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_statement, 3),
  [177] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_statement, 3),
  [179] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4, .production_id = 21),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 4, .production_id = 21),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(230),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [187] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 3, .production_id = 15),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 3, .production_id = 15),
  [191] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 24),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 24),
  [195] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 24), SHIFT_REPEAT(230),
  [198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [200] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 1, .production_id = 19),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 1, .production_id = 19),
  [204] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_statement, 3),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_statement, 3),
  [208] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 3),
  [210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 3),
  [212] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4, .production_id = 20),
  [214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 4, .production_id = 20),
  [216] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 2),
  [218] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 2),
  [220] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_discard_statement, 2),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_discard_statement, 2),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_continue_statement, 2),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_continue_statement, 2),
  [228] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 1),
  [230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 1),
  [232] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_break_statement, 2),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_break_statement, 2),
  [236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 5),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 5),
  [240] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 23),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 23),
  [244] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_statement, 5),
  [246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_statement, 5),
  [248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 4),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 4),
  [252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_statement, 2),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 2),
  [256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 5),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 5),
  [260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 2),
  [262] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 1),
  [264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 1),
  [266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 4),
  [268] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 3),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 1),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [278] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(88),
  [281] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(51),
  [284] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(87),
  [287] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(87),
  [290] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(85),
  [293] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(153),
  [296] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(272),
  [299] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(269),
  [302] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(268),
  [305] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(267),
  [308] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(265),
  [311] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(278),
  [314] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(248),
  [317] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(56),
  [320] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2), SHIFT_REPEAT(56),
  [323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_expression_repeat1, 2),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [333] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(153),
  [336] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(87),
  [339] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(87),
  [342] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(85),
  [345] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(272),
  [348] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(269),
  [351] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(268),
  [354] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(267),
  [357] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(265),
  [360] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(278),
  [363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2),
  [365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [367] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2),
  [369] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_global_variable_declaration_repeat1, 2),
  [371] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_global_variable_declaration_repeat1, 2), SHIFT_REPEAT(178),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [376] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_global_variable_declaration_repeat1, 1),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_global_variable_declaration_repeat1, 1),
  [380] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_list, 4),
  [382] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_list, 4),
  [384] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_list, 3),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_list, 3),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float_literal, 1),
  [394] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float_literal, 1),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [398] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_literal, 1),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_const_literal, 1),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [406] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 1),
  [410] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 16),
  [412] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 16),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [418] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list_expression, 3),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list_expression, 3),
  [428] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [438] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list_expression, 2),
  [442] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list_expression, 2),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list_expression, 5),
  [446] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list_expression, 5),
  [448] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [450] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 11),
  [452] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 11),
  [454] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list_expression, 4),
  [456] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list_expression, 4),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bitcast_expression, 5),
  [462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bitcast_expression, 5),
  [464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_composite_value_decomposition_expression, 3, .production_id = 17),
  [466] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_composite_value_decomposition_expression, 3, .production_id = 17),
  [468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript_expression, 4, .production_id = 22),
  [470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript_expression, 4, .production_id = 22),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_constructor_or_function_call_expression, 2),
  [474] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_constructor_or_function_call_expression, 2),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 3, .production_id = 16),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 5),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [502] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_statement, 3),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_statement, 4),
  [506] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [508] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [510] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(129),
  [513] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(198),
  [516] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(316),
  [519] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(313),
  [522] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(310),
  [525] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(308),
  [528] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(178),
  [531] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(168),
  [534] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__declaration, 2),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 7, .production_id = 12),
  [538] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__declaration, 1),
  [540] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selectors, 3),
  [542] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 7, .production_id = 13),
  [544] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 1),
  [546] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 6, .production_id = 9),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 8, .production_id = 18),
  [550] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 7, .production_id = 14),
  [552] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 5, .production_id = 4),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [558] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selectors, 2),
  [560] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 6, .production_id = 8),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [568] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 6, .production_id = 7),
  [570] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member_list, 1),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [578] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_member_list_repeat1, 2), SHIFT_REPEAT(300),
  [581] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_member_list_repeat1, 2),
  [583] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_member_list_repeat1, 2), SHIFT_REPEAT(178),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [588] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 6),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 4),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 8),
  [596] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2), SHIFT_REPEAT(300),
  [599] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2), SHIFT_REPEAT(178),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [604] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2),
  [606] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2), SHIFT_REPEAT(135),
  [609] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2), SHIFT_REPEAT(261),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [620] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [624] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_identifier_declaration, 3, .production_id = 1),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [628] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_identifier_declaration, 4, .production_id = 3),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2),
  [632] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 3),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [636] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 6),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 5),
  [640] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_case_selectors_repeat1, 2), SHIFT_REPEAT(148),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_case_selectors_repeat1, 2),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [649] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 3),
  [651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [653] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 4),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selectors, 1),
  [661] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attribute_list_repeat1, 2), SHIFT_REPEAT(181),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 1),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 1),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 6),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 5),
  [672] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 3),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 2),
  [676] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 2),
  [678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_member_list_repeat1, 1),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 1),
  [684] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_declaration, 2),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_statement, 1),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [692] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_declaration, 1),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [696] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_declaration, 2),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [708] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_declaration, 2),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [722] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_storage_class, 1),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [728] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_declaration, 3),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [738] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 4),
  [740] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_declaration, 3),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [744] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 1),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 2),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_declaration, 4),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_qualifier, 3),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [760] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal_or_identifier, 1),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [766] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_declaration, 4, .production_id = 2),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [772] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias, 4),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [776] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_declaration, 4),
  [778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_declaration, 5, .production_id = 5),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_access_mode, 1),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_declaration, 3),
  [792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [794] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_return_type_declaration, 3),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_continuing_statement, 2),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attribute_list_repeat1, 2),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [820] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texel_format, 1),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_declaration, 6, .production_id = 10),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [828] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias, 5),
  [830] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_declaration, 5),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [834] = {.entry = {.count = 1, .reusable = false}}, SHIFT(283),
  [836] = {.entry = {.count = 1, .reusable = false}}, SHIFT(321),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [846] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_declaration, 5, .production_id = 6),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [850] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_return_type_declaration, 2),
  [852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [854] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enable_directive, 2),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [866] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_qualifier, 5),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [874] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [888] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [892] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [894] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [896] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [898] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_body, 2),
  [900] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_wgsl(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
