/*========================== begin_copyright_notice ============================

Copyright (C) 2017-2021 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

/*
 * !!! DO NOT EDIT THIS FILE !!!
 *
 * This file was automagically crafted by GED's model parser.
 */


#ifndef GED_INS_FIELD_H
#define GED_INS_FIELD_H


/*!
 * This is an enumeration of all the instruction fields available for queries by GED. It is a consolidated list of all instruction
 * fields from all instruction formats of all supported models.
 *
 * @note        Some fields may not be available on all models.
 */
typedef enum
{

    /*!
     * Instruction Operation Code. This field contains the instruction operation code. Each opcode is given a unique mnemonic.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Opcode,

    /*!
     * Compaction Control. Indicates whether the instruction is compacted to the 64-bit compact instruction format. When this bit is
     * set, the 64-bit compact instruction format is used. The EU decodes the compact format using lookup tables internal to the
     * hardware, but documented for use by software tools. Only some instruction variations can be compacted, the variations supported
     * by those lookup tables and the compact format.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_CmptCtrl,

    /*!
     *
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_,

    /*!
     * Reserved. Not intended for use.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Reserved,

    /*!
     * Number of source operands in this instruction.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_NumOfSourceOperands,

    /*!
     * The presence of a destination operand in this instruction.
     *
     * If the value is 0, some GED API functions regarding Dst operand might still function correctly, but this means that the EU
     * ignores that operand.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_HasDestinationOperand,

    /*!
     * Access Mode. This field determines the operand access for the instruction. It applies to all source and destination operands.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_AccessMode,

    /*!
     * Mask Control (formerly Write Enable Control). This field determines if the per channel write enables are used to generate the
     * final write enable. This field should be normally "0".
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_MaskCtrl,

    /*!
     * Destination Dependency Control. This field selectively disables destination dependency check and clear for this instruction.
     *
     * @par     Models:     10, 11, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_DepCtrl,

    /*!
     * Execution mask offset - in charge of the QtrCtrl and NibCtrl values. This field provides explicit control for ARF selection.
     *
     * This field combined with ExecSize determines which channels are used for the ARF registers.
     *
     * Sets NibCtrl implicitly according to the selected QtrCtrl value.
     *
     * @par     Models:     10, 11, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_ExecMaskOffsetCtrl,

    /*!
     *
     *
     * @par 10, 11, TGL, XE.HP, XE.HPG, 7, 7.5, 8, 8.1, 9
     * TBD
     *
     * @par XE.HPC.A, XE.HPC
     * This field provides offset information for ARF selection. The can be thought of as a starting channel offset for the execution
     * mask and other ARF registers implicitly accessed
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_ChannelOffset,

    /*!
     * Thread Control. This field provides explicit control for thread switching.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_ThreadCtrl,

    /*!
     * Predicate Control. This field, together with PredInv, enables and controls the generation of the predication mask for the
     * instruction. It allows per-channel conditional execution of the instruction based on the content of the selected flag register.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_PredCtrl,

    /*!
     * Predicate Inverse. This field, together with PredCtrl, enables and controls the generation of the predication mask for the
     * instruction. When it is set, the predication uses the inverse of the predication bits generated according to setting of
     * Predicate Control. In other words, effect of PredInv happens after PredCtrl.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_PredInv,

    /*!
     * Execution Size. This field determines the number of channels operating in parallel for this instruction. The size cannot exceed
     * the maximum number of channels allowed for the given data type.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_ExecSize,

    /*!
     * Conditional Modifier. This field sets the flag register based on the internal conditional signals output from the execution
     * pipe such as sign, zero, overflow and NaNs, etc. If this field is set to 0000, no flag registers are updated. Flag registers
     * are not updated for instructions with embedded compares.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_CondModifier,

    /*!
     * This field allows per instruction accumulator write control.
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_AccWrCtrl,

    /*!
     * Debug Control. This field allows the insertion of a breakpoint at the current instruction. When the bit is set, hardware
     * automatically stores the current IP in CR register and jumps to the System IP (SIP) BEFORE executing the current instruction.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_DebugCtrl,

    /*!
     * Saturate. This field controls the destination saturation.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Saturate,

    /*!
     * Destination Register File. This field identifies the register file of the destination operand (dst). Note that it is obvious
     * that immediate cannot be a destination operand.
     *
     * For a send instruction, this field applies to the PostDst - the post destination operand.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_DstRegFile,

    /*!
     * Destination Data Type. This field specifies the numeric data type of the destination operand (dst). The bits of the destination
     * operand are interpreted as the identified numeric data type, rather than coerced into a type implied by the operator. For a
     * send instruction, this field applies to the CurrDst - the current destination operand.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_DstDataType,

    /*!
     * Source 0 Register File. This field identifies the register file of the first source operand (src0).
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src0RegFile,

    /*!
     * Source 0 Data Type. This field specifies the numeric data type of the first source operand (src0). The bits of a source operand
     * are interpreted as the identified numeric data type, rather than coerced into a type implied by the operator. Depending on
     * Src0RegFile, there are two different encodings for this field. If a source is a register operand, this field follows the Source
     * Register Type Encoding. If a source is an immediate operand, this field follows the Source Immediate Type Encoding.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src0DataType,

    /*!
     *
     *
     * @par TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     * Source 1 Register File. This field identifies the register file of the second source operand (src1).
     *
     * @par 10, 11, 7, 7.5, 8, 8.1, 9
     * Source 1 Register File. This field identifies the register file of the second source operand (src1). Note that ARF cannot be a
     * src1 operand
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src1RegFile,

    /*!
     * Source 1 Data Type. This field specifies the numeric data type of the second source operand (src1). The bits of a source
     * operand are interpreted as the identified numeric data type, rather than coerced into a type implied by the operator. Depending
     * on Src1RegFile, there are two different encodings for this field. If a source is a register operand, this field follows the
     * Source Register Type Encoding. If a source is an immediate operand, this field follows the Source Immediate Type Encoding.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src1DataType,

    /*!
     * Channel Enable. Four channel enables are defined for controlling which channels will be written into the destination region.
     * These channel mask bits are applied in a modulo-four manner to all ExecSize channels. There is 1-bit Channel Enable for each
     * channel within the group of 4. If the bit is cleared, the write for the corresponding channel is disabled. If the bit is set,
     * the write is enabled. Mnemonic for the bit being set for the group of 4 is "x", "y", "z", and "w", respectively, where "x"
     * corresponds to Channel 0 in the group and "w" corresponds to channel 3 in the group.
     *
     * For a send instruction, this field applies to the CurrDst.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_DstChanEn,

    /*!
     * Sub-Register Number. This field provides the sub-register number for the destination operand. For a GRF register operand, it
     * provides the byte address within a 256-bit register. For an ARF register operand, this field also provides the sub-register
     * number according to the encoding defined for the given architecture register.
     *
     * For a send instruction, this field applies to CurrDst.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_DstSubRegNum,

    /*!
     * Address Immediate. This field provides the immediate value in units of bytes added to the address register to compute the
     * register address (byte-aligned region origin) for the destination operand. It is a signed integer.
     *
     * For a send instruction, this field applies to PostDst.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_DstAddrImm,

    /*!
     * Register Number. This field provides the register number for the destination operand. For a GRF register operand, it provides
     * the portion of register address aligning to 256-bit. For an ARF register operand, this field is encoded such that MSBs identify
     * the architecture register type and LSBs provide its register number.
     *
     * For a send instruction, this field applies to PostDst.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_DstRegNum,

    /*!
     * Address Sub-Register Number. This field provides the subregister number for the destination address register. The address
     * register contains 8 sub-registers. The size of each subregister is one word. The address register contains the register address
     * of the operand, when the operand is in register-indirect addressing mode.
     *
     * For a send instruction, this field applies to PostDst.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_DstAddrSubRegNum,

    /*!
     * Horizontal Stride. This field provides the distance in unit of data elements between two adjacent data elements within a row
     * (horizontal) in the register region for the destination operand.
     *
     * For a send instruction, this field applies to CurrDst. PostDst only uses the register number.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_DstHorzStride,

    /*!
     * Addressing Mode. This field determines the addressing method of the destination operand.
     *
     * For a send instruction, this field applies to PostDst - the post destination operand. Addressing mode for CurrDst (current
     * destination operand) is fixed as Direct.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_DstAddrMode,

    /*!
     * Channel Select. This field controls the channel swizzle for the first source operand (src0). The normally sequential channel
     * assignment can be altered by explicitly identifying neighboring data elements for each channel. Out of the 8-bit field, 2 bits
     * are assigned for each channel within the group of 4. ChanSel[1:0], [3.2], [5.4] and [7,6] are for channel 0 ("x"), 1 ("y"), 2
     * ("z"), and 3 ("w") in the group, respectively.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_Src0ChanSel,

    /*!
     * Sub-Register Number. This field provides the sub-register number for the first source operand (src0). For a GRF register
     * operand, it provides the byte address within a 256-bit register. For an ARF register operand, this field also provides the
     * sub-register number according to the encoding defined for the given architecture register.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src0SubRegNum,

    /*!
     * Address Immediate. This field provides the immediate value in units of bytes added to the address register to compute the
     * register address (byte-aligned region origin) for the first source operand (src0). It is a signed integer.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src0AddrImm,

    /*!
     * Register Number. This field provides the register number for the first source operand (src0). For a GRF register operand, it
     * provides the portion of register address aligning to 256-bit. For an ARF register operand, this field is encoded such that MSBs
     * identify the architecture register type and LSBs provide its register number.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src0RegNum,

    /*!
     * Address Sub-Register Number. This field provides the subregister number for the first source (src0) address register. The
     * address register contains 8 sub-registers. The size of each subregister is one word. The address register contains the register
     * address of the operand, when the operand is in register-indirect addressing mode.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src0AddrSubRegNum,

    /*!
     * Source Modifier. This field specifies the numeric modification of the first source operand (src0). The value of each data
     * element of the source operand can optionally have its absolute value taken and/or its sign inverted prior to delivery to the
     * execution pipe. The absolute value is prior to negate such that a guaranteed negative value can be produced.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src0SrcMod,

    /*!
     * Addressing Mode. This field determines the addressing method of the first source operand (src0).
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src0AddrMode,

    /*!
     * Horizontal Stride. This field provides the distance in unit of data elements between two adjacent data elements within a row
     * (horizontal) in the register region for the first source operand (src0).
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src0HorzStride,

    /*!
     * Width. This field specifies the number of elements in the horizontal dimension of the region for the first source operand
     * (src0). This field cannot exceed the ExecSize field of the instruction.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src0Width,

    /*!
     * Vertical Stride. The field provides the vertical stride of the register region in unit of data elements for the first source
     * operand (src0).
     *
     * GED uses a (dummy) vertical stride to denote the special values Vx1 or VxH.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src0VertStride,

    /*!
     * Flag Subregister Number.
     *
     * @par 10, 11, TGL, XE.HP, XE.HPG, 8, 8.1, 9
     * This field contains the 16-bit flag subregister number (.0 or .1) for instructions with a non-zero Conditional Modifier. The
     * specified flag subregister is the source for any predication and the destination for new flag values produced by any enabled
     * conditional modifier. A flag subregister can be both a predication source and a conditional modifier destination in the same
     * instruction. The number of flag bits used or updated depends on the execution size.
     *
     * @par 7, 7.5
     * This field contains the flag subregister number for instructions with a non-zero Conditional Modifier.
     *
     * @par XE.HPC.A, XE.HPC
     * This field specifies the sub-register number for a flag register operand. There are two sub-registers in the flag register.
     * Each sub-register contains 16 flag bits. The selected flag sub-register is the source for predication if predication is enabled
     * for the instruction. It is the destination to store conditional flag bits if conditional modifier is enabled for the
     * instruction. The same flag sub-register can be both the predication source and conditional destination, if both predication and
     * conditional modifier are enabled.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_FlagSubRegNum,

    /*!
     * Flag Register Number.
     *
     * @par 10, 11, TGL, XE.HP, XE.HPG, 8, 8.1, 9
     * This field contains the 32-bit flag register number (f0 or f1) for instructions with a non-zero Conditional Modifier.
     *
     * @par 7, 7.5
     * This field contains the flag register number for instructions with a non-zero Conditional Modifier.
     *
     * @par XE.HPC.A, XE.HPC
     * This field specifies the register number for a flag register operand.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_FlagRegNum,

    /*!
     * Channel Select. This field controls the channel swizzle for the second source operand (src1). The normally sequential channel
     * assignment can be altered by explicitly identifying neighboring data elements for each channel. Out of the 8-bit field, 2 bits
     * are assigned for each channel within the group of 4. ChanSel[1:0], [3.2], [5.4] and [7,6] are for channel 0 ("x"), 1 ("y"), 2
     * ("z"), and 3 ("w") in the group, respectively.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_Src1ChanSel,

    /*!
     * Sub-Register Number. This field provides the sub-register number for the second source operand (src1). For a GRF register
     * operand, it provides the byte address within a 256-bit register.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src1SubRegNum,

    /*!
     * Address Immediate. This field provides the immediate value in units of bytes added to the address register to compute the
     * register address (byte-aligned region origin) for the second source operand (src1). It is a signed integer.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src1AddrImm,

    /*!
     * Register Number. This field provides the register number for the second source operand (src1). For a GRF register operand, it
     * provides the portion of register address aligning to 256-bit.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src1RegNum,

    /*!
     * Address Sub-Register Number. This field provides the subregister number for the second source (src1) address register. The
     * address register contains 8 sub-registers. The size of each subregister is one word. The address register contains the register
     * address of the operand, when the operand is in register-indirect addressing mode.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src1AddrSubRegNum,

    /*!
     * Source Modifier. This field specifies the numeric modification of the second source operand (src1). The value of each data
     * element of the source operand can optionally have its absolute value taken and/or its sign inverted prior to delivery to the
     * execution pipe. The absolute value is prior to negate such that a guaranteed negative value can be produced.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src1SrcMod,

    /*!
     * Addressing Mode. This field determines the addressing method of the second source operand (src1)
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src1AddrMode,

    /*!
     * Horizontal Stride. This field provides the distance in unit of data elements between two adjacent data elements within a row
     * (horizontal) in the register region for the second source operand (src1).
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src1HorzStride,

    /*!
     * Width. This field specifies the number of elements in the horizontal dimension of the region for the second source operand
     * (src1). This field cannot exceed the ExecSize field of the instruction.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src1Width,

    /*!
     * Vertical Stride. The field provides the vertical stride of the register region in unit of data elements for the second source
     * operand (src1).
     *
     * GED uses a (dummy) vertical stride to denote the special values Vx1 or VxH.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src1VertStride,

    /*!
     * 32-bit Immediate. The 32-bit immediate data field for the operand. It may contain any legal bit pattern for its associated
     * type. Only one 32-bit immediate value may be present in an instruction, therefore binary operations only support src1 as an
     * immediate value.
     *
     * The low order bits are directly used when fewer than 32-bits are needed to describe the desired type; the 32-bits are not
     * coerced into the designated type.
     *
     * For UW and W data types, programmer is required to replicate the lower word to the upper word of this field.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Imm,

    /*!
     * Source Modifier. This field specifies the numeric modification of the third source operand (src2). The value of each data
     * element of the source operand can optionally have its absolute value taken and/or its sign inverted prior to delivery to the
     * execution pipe. The absolute value is prior to negate such that a guaranteed negative value can be produced.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src2SrcMod,

    /*!
     * Source Data Type.
     *
     * @par 10
     * In Align16, this field is valid only for three-source instructions and contains the data type for all three source operands.
     * Three source instructions can use operands with mixed-mode precision. When the SrcDataType field is set to :f or :hf it defines
     * precision for source 0 only, and fields Src1DataType and Src2DataType define precision for other source operands.
     *
     * @par 7, 7.5, 8
     * This field is valid only for three-source instructions and contains the data type for all three source operands.
     *
     * @par 8.1, 9
     * This field is valid only for three-source instructions and contains the data type for all three source operands. Three source
     * instructions can use operands with mixed-mode precision. When the SrcDataType field is set to :f or :hf it defines precision
     * for source 0 only, and fields Src1DataType and Src2DataType define precision for other source operands.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_SrcDataType,

    /*!
     * Replicate Control. This field controls the replication of the starting channel to all channels in the execution size.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_Src0RepCtrl,

    /*!
     * Replicate Control. This field controls the replication of the starting channel to all channels in the execution size.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_Src1RepCtrl,

    /*!
     * Replicate Control. This field controls the replication of the starting channel to all channels in the execution size.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_Src2RepCtrl,

    /*!
     * Channel Select. This field controls the channel swizzle for the third source operand (src2). The normally sequential channel
     * assignment can be altered by explicitly identifying neighboring data elements for each channel. Out of the 8-bit field, 2 bits
     * are assigned for each channel within the group of 4. ChanSel[1:0], [3.2], [5.4] and [7,6] are for channel 0 ("x"), 1 ("y"), 2
     * ("z"), and 3 ("w") in the group, respectively.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_Src2ChanSel,

    /*!
     *
     *
     * @par TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     * Sub-Register Number. This field provides the sub-register number for the third source operand (src2). For a GRF register
     * operand, it provides the byte address within a 256-bit register.
     *
     * @par 10, 11, 7, 7.5, 8, 8.1, 9
     * Sub-Register Number. This field provides the sub-register number for the third source operand (src2). For a GRF register
     * operand, it provides the byte address within a 256-bit register. For an ARF register operand, this field also provides the
     * sub-register number according to the encoding defined for the given architecture register.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src2SubRegNum,

    /*!
     *
     *
     * @par TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     * Register Number. This field provides the register number for the third source operand (src2). For a GRF register operand, it
     * provides the portion of register address aligning to 256-bit.
     *
     * @par 10, 11, 7, 7.5, 8, 8.1, 9
     * Register Number. This field provides the register number for the third source operand (src2). For a GRF register operand, it
     * provides the portion of register address aligning to 256-bit. For an ARF register operand, this field is encoded such that MSBs
     * identify the architecture register type and LSBs provide its register number.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src2RegNum,

    /*!
     * Source 2 Register File. This field identifies the register file of the third source operand (src2).
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src2RegFile,

    /*!
     * Addressing Mode. This field determines the addressing method of the third source operand (src2)
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src2AddrMode,

    /*!
     * Vertical Stride. The field provides the vertical stride of the register region in unit of data elements for the third source
     * operand (src2).
     *
     * GED uses a (dummy) vertical stride to denote the special values Vx1 or VxH.
     *
     * @par     Models:     10, 11, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_Src2VertStride,

    /*!
     * Shared Function ID.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_SFID,

    /*!
     *
     *
     * @par TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 7, 7.5
     * Message Descriptor Register File. This field describes the message descriptor of the send instruction.
     *
     * @par 10, 11, 8, 8.1, 9
     * Message descriptor Register File. This field describes the message descriptor of the send instruction.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_DescRegFile,

    /*!
     *
     *
     * @par 7, 7.5
     * Message Descriptor Data Type. This field specifies the numeric data type of the message descriptor. The bits of a source
     * operand are interpreted as the identified numeric data type, rather than coerced into a type implied by the operator. Depending
     * on DescRegFile, there are two different encodings for this field. If a source is a register operand, this field follows the
     * Source Register Type Encoding. If a source is an immediate operand, this field follows the Source Immediate Type Encoding.
     *
     * @par 8, 8.1
     * Message descriptor Data Type. This field specifies the numeric data type of the message descriptor. The bits of a source
     * operand are interpreted as the identified numeric data type, rather than coerced into a type implied by the operator. Depending
     * on Src1RegFile, there are two different encodings for this field. If a source is a register operand, this field follows the
     * Source Register Type Encoding. If a source is an immediate operand, this field follows the Source Immediate Type Encoding.
     *
     * @par     Models:     7, 7.5, 8, 8.1
     */
    GED_INS_FIELD_DescDataType,

    /*!
     * Sub-Register Number. This field provides the sub-register number for the message descriptor. For a GRF register operand, it
     * provides the byte address within a 256-bit register. For an ARF register operand, this field also provides the sub-register
     * number according to the encoding defined for the given architecture register.
     *
     * @par     Models:     10, 11, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_DescAddrSubRegNum,

    /*!
     * Register Number. This field provides the register number for the message descriptor. For a GRF register operand, it provides
     * the portion of register address aligning to 256-bit. For an ARF register operand, this field is encoded such that MSBs identify
     * the architecture register type and LSBs provide its register number.
     *
     * @par     Models:     10, 11, 7, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_DescRegNum,

    /*!
     * Horizontal Stride. This field provides the distance in unit of data elements between two adjacent data elements within a row
     * (horizontal) in the register region for the message descriptor.
     *
     * @par     Models:     7
     */
    GED_INS_FIELD_DescHorzStride,

    /*!
     * Width. This field specifies the number of elements in the horizontal dimension of the region for the message descriptor. This
     * field cannot exceed the ExecSize field of the instruction.
     *
     * @par     Models:     7
     */
    GED_INS_FIELD_DescWidth,

    /*!
     * Vertical Stride. The field provides the vertical stride of the register region in unit of data elements for the message
     * descriptor.
     *
     * GED uses a (dummy) vertical stride to denote the special values Vx1 or VxH.
     *
     * @par     Models:     7
     */
    GED_INS_FIELD_DescVertStride,

    /*!
     * Message Description. This field provides the description of the message to be sent.
     *
     * The meaning of the field depends on the type of message as well as the message shared function target.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_MsgDesc,

    /*!
     * Extended Message Description. This field provides the extended description of the message to be sent.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_ExMsgDesc,

    /*!
     * End of Thread. This field controls the termination of the thread. For a send instruction, if this field is set, EU will
     * terminate the thread and also set the EOT bit in the message sideband.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_EOT,

    /*!
     * Function Control. The type of extended math function to apply.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_MathFC,

    /*!
     *
     *
     * @par 10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8, 8.1, 9
     * Jump Instruction Pointer. The byte aligned jump distance if a jump is taken for the instruction. JIP should reference the end
     * of the innermost conditional block.
     *
     * @par 7, 7.5
     * Jump Target Offset. The jump distance in number of eight-byte units if a jump is taken for the instruction.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_JIP,

    /*!
     *
     *
     * @par 7, 7.5
     * The jump distance in number of eight-byte units if a jump is taken for the channel.
     *
     * @par 10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8, 8.1, 9
     * Update Instruction Pointer. The byte aligned jump distance if a jump is taken for the instruction. UIP should reference the
     * instruction where all channels are expected to come together.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_UIP,

    /*!
     *
     *
     * @par XE.HPC.A, XE.HPC
     * Lookup one of 32 18-bit values. That value is used (from MSB to LSB) for the CondModifier[3:0], Saturate, AtomicCtrl, MaskCtrl,
     * PredInv, PredCtrl[1:0], ChOff[1:0], FlagRegNum[1:0], FlagSubRegNum, ExecSize[2:0] bit fields.
     *
     * @par 10, 11, 7, 7.5, 8, 8.1, 9
     * Lookup one of 32 19-bit values. That value is used (from MSB to LSB) for the FlagRegNum, FlagSubRegNum, Saturate, ExecSize,
     * PredInv, PredCtrl, ThreadCtrl, QtrCtrl, DepCtrl, MaskCtrl, and AccessMode bit fields.
     *
     * @par TGL, XE.HP, XE.HPG
     * Lookup one of 32 21-bit values. That value is used (from MSB to LSB) for the CondCtrl[3:0], Saturate, AccWrCtrl, AtomicCtrl,
     * MaskCtrl, PredInv, PredCtrl[3:0], FlagRegNum, FlagSubRegNum, ChOff[2:0], ExecSize[2:0] bit fields.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_ControlIndex,

    /*!
     *
     *
     * @par 7, 7.5
     * Lookup one of 32 18-bit values. That value is used (from MSB to LSB) for the Dst.AddrMode, Dst.HorzStride, Dst.DstType,
     * Dst.RegFile, Src0.SrcType, Src0.RegFile, Src1.SrcType, and Src1.RegType bit fields.
     *
     * @par TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     * Lookup one of 32 20-bit values. That value is used (from MSB to LSB) for the Src1.RegFile[0], Src1.SrcType[3:0],
     * Src0.RegFile[0], Dst.RegFile[0], Dst.HorzStride[1:0], Src1.IsImm, Src0.IsImm, Src0.SrcType[3:0], Dst.DstType[3:0], Dst.AddrMode
     * bit fields.
     *
     * @par 10, 11, 8, 8.1, 9
     * Lookup one of 32 21-bit values. That value is used (from MSB to LSB) for the Dst.AddrMode, Dst.HorzStride, Src1.SrcType,
     * Src1.RegFile, Src0.SrcType, Src0.RegFile, Dst.DstType, and Dst.RegFile bit fields.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_DataTypeIndex,

    /*!
     *
     *
     * @par XE.HPC.A, XE.HPC
     * Lookup one of 16 12-bit values. That value is used (from MSB to LSB) for .
     *
     * @par TGL, XE.HP, XE.HPG
     * Lookup one of 32 15-bit values. That value is used (from MSB to LSB) for .
     *
     * @par 10, 11, 7, 7.5, 8, 8.1, 9
     * Lookup one of 32 15-bit values. That value is used (from MSB to LSB) for various fields for Src1, Src0, and Dst, including
     * ChanEn/ChanSel, SubRegNum, and AddrImm[4] or AddrImm[4:0], depending on AddrMode and AccessMode.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_SubRegIndex,

    /*!
     *
     *
     * @par TGL, XE.HP, XE.HPG
     * Lookup one of 16 12-bit values. That value is used (from MSB to LSB) for the Src0.VertStride, various Src0 bit fields based on
     * AccessMode (Src0.ChanSel[7:4], Src0.Width, Src0.HorzStride), Src0.AddrMode, and Src0.SrcMod bit fields. Note that this field
     * spans a DWord boundary within the QWord compacted instruction.
     *
     * @par 7, 7.5
     * Lookup one of 32 12-bit values. That value is used (from MSB to LSB) for the Src0.AddrMode, Src0.ChanSel[7:4], Src0.HorzStride,
     * Src0.SrcMod, Src0.VertStride, and Src0.Width bit fields. Note that this field spans a DWord boundary within the QWord compacted
     * instruction.
     *
     * @par 10, 11, 8, 8.1, 9
     * Lookup one of 32 12-bit values. That value is used (from MSB to LSB) for the Src0.VertStride, various Src0 bit fields based on
     * AccessMode (Src0.ChanSel[7:4], Src0.Width, Src0.HorzStride), Src0.AddrMode, and Src0.SrcMod bit fields. Note that this field
     * spans a DWord boundary within the QWord compacted instruction.
     *
     * @par XE.HPC.A, XE.HPC
     * Lookup one of 8 11-bit values. That value is used (from MSB to LSB) for the Src0.VertStride, various Src0 bit fields based on
     * AccessMode (Src0.ChanSel[7:4], Src0.Width, Src0.HorzStride), Src0.AddrMode, and Src0.SrcMod bit fields. Note that this field
     * spans a DWord boundary within the QWord compacted instruction.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src0Index,

    /*!
     *
     *
     * @par 10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8, 8.1, 9
     * If not an immediate operand, lookup one of 32 12-bit values that maps to bits 120:109. That value is used (from MSB to LSB) for
     * the Src1.VertStride, various Src1 bit fields based on AccessMode (Src1.ChanSel[7:4], Src1.Width, Src1.HorzStride),
     * Src1.AddrMode, and Src1.SrcMod bit fields.
     *
     * If an immediate operand, there is no lookup. Determines bits 127:104 (Imm[31:8]) as follows: map bits 39:35 directly to bits
     * 108:104. Sign extend to fill bits 127:109. Compact format bit 39 is thus copied to all of bits 127:108 for an immediate
     * operand.
     *
     * @par 7, 7.5
     * Lookup one of 32 12-bit values. If not an immediate operand, maps to bits 120:109, covering the Src1.AddrMode,
     * Src1.ChanSel[7:4], Src1.HorzStride, Src1.SrcMod, Src1.VertStride, and Src1.Width bit fields. If an immediate operand, does not
     * do any lookup. The 5-bit value directly maps to bits 108:104 (Imm[12:8]) and the upper bit (bit 39 in the compact format, bit
     * 108 in the native format) is replicated to provide bits 127:109 (Imm[31:13]) in the native format.
     *
     * @par     Models:     all
     */
    GED_INS_FIELD_Src1Index,

    /*!
     *
     *
     * @par 8, 8.1
     * If not an immediate operand, lookup one of 32 12-bit values that maps to bits 120:109. That value is used (from MSB to LSB) for
     * various Desc bit fields.
     *
     * If an immediate operand, there is no lookup. Determines bits 127:104 (Imm[31:8]) as follows: map bits 39:35 directly to bits
     * 108:104. Sign extend to fill bits 127:109. Compact format bit 39 is thus copied to all of bits 127:108 for an immediate
     * operand.
     *
     * @par 7
     * Lookup one of 32 12-bit values. If not an immediate operand, maps to bits 120:109, covering the Src1.AddrMode,
     * Src1.ChanSel[7:4], Src1.HorzStride, Src1.SrcMod, Src1.VertStride, and Src1.Width bit fields. If an immediate operand, does not
     * do any lookup. The 5-bit value directly maps to bits 108:104 (Imm[12:8]) and the upper bit (bit 39 in the compact format, bit
     * 108 in the native format) is replicated to provide bits 127:109 (Imm[31:13]) in the native format.
     *
     * @par 7.5
     * Lookup one of 32 12-bit values. If not an immediate operand, maps to bits 120:109, for various Desc bit fields. If an immediate
     * operand, does not do any lookup. The 5-bit value directly maps to bits 108:104 (Imm[12:8]) and the upper bit (bit 39 in the
     * compact format, bit 108 in the native format) is replicated to provide bits 127:109 (Imm[31:13]) in the native format.
     *
     * @par     Models:     7, 7.5, 8, 8.1
     */
    GED_INS_FIELD_DescIndex,

    /*!
     * Extended Message Descriptor Register File. This field describes the extended message descriptor of the send instruction.
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 7.5, 8, 8.1, 9
     */
    GED_INS_FIELD_ExDescRegFile,

    /*!
     * Specifies the extra registers used by the math macro instructions (formerly SpecialAcc).
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8, 8.1, 9
     */
    GED_INS_FIELD_DstMathMacroExt,

    /*!
     * Specifies the extra registers used by the math macro instructions (formerly SpecialAcc).
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8, 8.1, 9
     */
    GED_INS_FIELD_Src0MathMacroExt,

    /*!
     * Specifies the extra registers used by the math macro instructions (formerly SpecialAcc).
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8, 8.1, 9
     */
    GED_INS_FIELD_Src1MathMacroExt,

    /*!
     * Specifies the extra registers used by the math macro instructions (formerly SpecialAcc).
     *
     * @par     Models:     10, 11, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8, 8.1, 9
     */
    GED_INS_FIELD_Src2MathMacroExt,

    /*!
     * Branch Control. The instruction directs the instruction pointer to the offset specified by the UIP offset or to the next IP
     * based on the BranchCtrl bit in the instruction. The active channels that are predicated on this instruction will take the IP +
     * UIP path when BranchCtrl is set else the channels take IP + 1. The active channels that are not predicated on this instruction
     * will be made inactive and waiting to be joined at the join IP. The join IP is IP + UIP when BranchCtrl is clear else it is the
     * next IP.
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8, 8.1, 9
     */
    GED_INS_FIELD_BranchCtrl,

    /*!
     *
     *
     * @par XE.HPC.A, XE.HPC
     * Lookup one of 16 21-bit values. That value is used (from MSB to LSB) for the Src1.RegFile[0], Src1.SrcType[3:0],
     * Src0.RegFile[0], Dst.RegFile[0], Dst.HorzStride[1:0], Src1.IsImm, Src0.IsImm, Src0.SrcType[3:0], Dst.DstType[3:0], Dst.AddrMode
     * bit fields.
     *
     * @par TGL, XE.HP, XE.HPG
     * Lookup one of 32 20-bit values. That value is used (from MSB to LSB) for the Src1.RegFile[0], Src1.SrcType[3:0],
     * Src0.RegFile[0], Dst.RegFile[0], Dst.HorzStride[1:0], Src1.IsImm, Src0.IsImm, Src0.SrcType[3:0], Dst.DstType[3:0], Dst.AddrMode
     * bit fields.
     *
     * @par 8, 8.1
     * Lookup one of four 46-bit values. That value is used (from MSB to LSB) for the Src2.RegNum[7], Src1.RegNum[7], Src0.RegNum[7],
     * Src2.ChanSel, Src1.ChanSel, Src0.ChanSel, Dst.SubRegNum, Dst.ChanEnable, Dst.DstType, SrcType, Src2.Modifier, Src1.Modifier,
     * and Src0.Modifier bit fields.
     *
     * @par 10, 9
     * Lookup one of four 49-bit values. That value is used (from MSB to LSB) for the Src2.SubRegNum, Src2.RegNum[7], Src1.RegNum,
     * Src1.RegNum[7], Src0.SubRegNum, Src0.RegNum[7], Src2.ChanSel, Src1.ChanSel, Src0.ChanSel, Dst.SubRegNum, Dst.ChanEnable,
     * Dst.DstType, SrcType, Src2.Modifier, Src1.Modifier, and Src0.Modifier bit fields.
     *
     * @par     Models:     10, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8, 8.1, 9
     */
    GED_INS_FIELD_SourceIndex,

    /*!
     * Source 2 Data Type.
     *
     * @par 10
     * In Align16 this field is only valid when the SrcDataType is :f or :hf and in which case it defines the data type for the third
     * source operand (src2), otherwise it is reserved and MBZ. In Align1 this field is always valid and it defines the data type for
     * the third source operand (src2).
     *
     * @par 8.1, 9
     * This field is only valid when the SrcDataType is :f or :hf and in which case it defines the data type for the third source
     * operand (src2). Otherwise it is reserved and MBZ.
     *
     * @par 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     * This field specifies the numeric data type of the third source operand (src2).
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8.1, 9
     */
    GED_INS_FIELD_Src2DataType,

    /*!
     * No Source Dependency Set. In send, sendc, sends and sendsc instruction, this bit controls the setting of GRF source dependency.
     * The source dependencies of both sources are considered together.
     *
     * @par     Models:     10, 11, 9
     */
    GED_INS_FIELD_NoSrcDepSet,

    /*!
     * Extended Function Control.
     *
     * This field is intended to control the target function unit.
     *
     * Refer to the section on the specific target function unit for details on the contents of this field.
     *
     * @par     Models:     10, 11, 9
     */
    GED_INS_FIELD_ExFuncCtrl,

    /*!
     * Specify the extended message length.
     *
     * @par     Models:     10, 11, 9
     */
    GED_INS_FIELD_ExMsgLength,

    /*!
     * Sub-Register Number. This field provides the sub-register number for the extended message descriptor.
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 9
     */
    GED_INS_FIELD_ExDescAddrSubRegNum,

    /*!
     * Register Number. This field provides the register number for the extended message descriptor. For an ARF register operand, this
     * field is encoded such that MSBs identify the architecture register type and LSBs provide its register number.
     *
     * @par     Models:     10, 11, 9
     */
    GED_INS_FIELD_ExDescRegNum,

    /*!
     *
     *
     * @par     Models:     9
     */
    GED_INS_FIELD_MsgDescCategory,

    /*!
     * Address offset (Hword based)
     *
     * @par     Models:     9
     */
    GED_INS_FIELD_MsgDescScratchAddrOffset,

    /*!
     *
     *
     * @par     Models:     9
     */
    GED_INS_FIELD_MsgDescScratchBlockSize,

    /*!
     *
     *
     * @par     Models:     9
     */
    GED_INS_FIELD_MsgDescScratchInvalidateAfterRead,

    /*!
     * Two modes of channel-enable are provided: a SIMD8 or SIMD16 Dword channel serial view of a register, and a SIMD4x2 view of a
     * register.
     *
     * @par     Models:     9
     */
    GED_INS_FIELD_MsgDescScratchChannelMode,

    /*!
     * Operation Type
     *
     * @par     Models:     9
     */
    GED_INS_FIELD_MsgDescScratchMessageType,

    /*!
     *
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_ExecutionDataType,

    /*!
     * 16-bit Immediate.
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_Src0TernaryImm,

    /*!
     * 16-bit Immediate.
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_Src2TernaryImm,

    /*!
     *
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_Src2HorzStride,

    /*!
     * SWSB.
     *
     * @par     Models:     TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_SWSB,

    /*!
     * Src1IsImm
     *
     * @par     Models:     TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_Src1IsImm,

    /*!
     * Src0IsImm
     *
     * @par     Models:     TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_Src0IsImm,

    /*!
     * TBD
     *
     * @par     Models:     TGL, XE.HP, XE.HPG
     */
    GED_INS_FIELD_Src0SubRegNumByte,

    /*!
     * Sync FC.
     *
     * @par     Models:     TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_SyncFC,

    /*!
     * Fusion Control. For send and sendc instruction, this field provides explicit control for EU fusion lock-step execution. When
     * this bit is set , the instruction is executed serially starting from the first EU to the last EU in the fused set.
     *
     * @par     Models:     TGL, XE.HP, XE.HPG
     */
    GED_INS_FIELD_FusionCtrl,

    /*!
     * Lookup one of 32 19-bit values. That value is used (from MSB to LSB) for the Src1.RegFile[0], Src1.SrcType[3:0],
     * Src0.RegFile[0], Dst.RegFile[0], Dst.HorzStride[1:0], Src1.IsImm, Src0.IsImm, Src0.SrcType[3:0], Dst.DstType[3:0], Dst.AddrMode
     * bit fields.
     *
     * @par     Models:     TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_DataTypeIndexNoDep,

    /*!
     * Compacted immediate
     *
     * @par     Models:     TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_CompactedImm,

    /*!
     * This field indicate the number of instructions to be created from a single macro instruction
     *
     * @par     Models:     XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_RepeatCount,

    /*!
     * This field describes the systolic depth of the operation
     *
     * @par     Models:     XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_SystolicDepth,

    /*!
     * Source 2 Operand Precision. This field specifies the number of bits per element of the third source operand (src2).
     *
     * @par     Models:     XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_Src2Precision,

    /*!
     * Source 2 Operand Precision. This field specifies the number of bits per element of the second source operand (src1).
     *
     * @par     Models:     XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_Src2SubBytePrecision,

    /*!
     * Source 1 Operand Precision. This field specifies the number of bits per element of the third source operand (src2).
     *
     * @par     Models:     XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_Src1Precision,

    /*!
     * Source 1 Operand Precision. This field specifies the number of bits per element of the second source operand (src1).
     *
     * @par     Models:     XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_Src1SubBytePrecision,

    /*!
     * Index of the lut8 lookup table for the bfn instruction
     *
     * @par     Models:     XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_BfnFC,

    /*!
     * This field indicates the Extended Bindless Surface Offset (ExBSO) mode.
     *
     * @par     Models:     XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_ExBSO,

    /*!
     * CPS LOD Compensation.
     *
     * @par     Models:     XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_CPS,

    /*!
     * This field specifies the number of 256-bit GRF registers starting from Src1RegNum to be sent out on the request message
     * payload.
     *
     * @par     Models:     XE.HP, XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_Src1Length,

    /*!
     * Src2IsImm
     *
     * @par     Models:     XE.HPC.A, XE.HPC
     */
    GED_INS_FIELD_Src2IsImm
} GED_INS_FIELD;

/*!
 * This is an enumeration of all the pseudo-fields representing interpretable attributes of instruction fields. It is a consolidated
 * list of all pseudo-fields from all supported models.
 *
 * @note        Some fields may not be available on all models.
 */
typedef enum
{

    /*!
     * Architecture register type, based on the register number when using the ARF register file.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_ArchReg,

    /*!
     * The architecture register number, based on the register number when using the ARF register file.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_ArchRegNum,

    /*!
     * Get the swizzle target for the X channel.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_PSEUDO_FIELD_SwizzleX,

    /*!
     * Get the swizzle target for the Y channel.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_PSEUDO_FIELD_SwizzleY,

    /*!
     * Get the swizzle target for the Z channel.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_PSEUDO_FIELD_SwizzleZ,

    /*!
     * Get the swizzle target for the W channel.
     *
     * @par     Models:     10, 7, 7.5, 8, 8.1, 9
     */
    GED_PSEUDO_FIELD_SwizzleW,

    /*!
     * This field specifies the number of 256-bit GRF registers starting from src0 to be sent out on the request message payload.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_MessageLength,

    /*!
     * This field indicates the number of 256-bit registers expected in the message response. A value 0 indicates that the request
     * message does not expect any response
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_ResponseLength,

    /*!
     * If set, indicates that the message includes a header.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_HeaderPresent,

    /*!
     * Message type of the send instruction.
     *
     * @par     Models:     7, 7.5, 8, 8.1
     */
    GED_PSEUDO_FIELD_MessageTypeDP_SAMPLER,

    /*!
     * Message type of the send instruction.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_MessageTypeDP_RC,

    /*!
     * Message type of the send instruction.
     *
     * @par     Models:     7, 7.5, 8, 8.1
     */
    GED_PSEUDO_FIELD_MessageTypeDP_CC,

    /*!
     * Message type of the send instruction.
     *
     * @par     Models:     7, 7.5
     */
    GED_PSEUDO_FIELD_MessageTypeDP_DC0,

    /*!
     * This field controls which 8 bits of Pixel/Sample Mask in the message header are ANDed with the execution mask to determine
     * which slots are accessed. This field is ignored if the header is not present.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_TypedSurfaceSlotGroup,

    /*!
     * This field controls which 8 bits of Pixel/Sample Mask in the message header are ANDed with the execution mask to determine
     * which slots are accessed.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_TypedAtomicSlotGroup,

    /*!
     * SIMD Mode.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_UntypedSurfaceSIMDMode,

    /*!
     * SIMD Mode.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_UntypedAtomicSIMDMode,

    /*!
     * This field, if enabled, causes all lines in the L3 cache accessed by the message to be invalidated after the read occurs,
     * regardless of whether the line contains modified data. It is intended as a performance hint indicating that the data will no
     * longer be used to avoid writing back data to memory. This field is ignored for write messages.
     *
     * Enabling this field is intended for scratch and spill/fill, where the memory is used only by a single thread and thus does not
     * need to be maintained after the thread completes.
     *
     * @par     Models:     7, 7.5
     */
    GED_PSEUDO_FIELD_InvalidateAfterRead,

    /*!
     * Specifies the number of contiguous OWords to be read or written.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_BlockSize,

    /*!
     * Red channel mask.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_RedChannel,

    /*!
     * Green channel mask.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_GreenChannel,

    /*!
     * Blue channel mask.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_BlueChannel,

    /*!
     * Alpha Channel Mask.
     *
     * For the read message, indicates that alpha will be included in the writeback message. For the write message, indicates that
     * alpha is included in the message payload, and that alpha will be written to the surface.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_AlphaChannel,

    /*!
     * Specifies whether return data is sent back to the thread.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_ReturnDataControl,

    /*!
     * Specifies the atomic operation to be performed.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_AtomicOperationType,

    /*!
     * Specifies the atomic operation to be performed.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_AtomicCounterOperationType,

    /*!
     * Identify the supported sub-functions by Message Gateway.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_SubFuncID,

    /*!
     * Specifies the index into the binding table for the specified surface.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_BindingTableIndex,

    /*!
     * Function Control.
     *
     * @par     Models:     all
     */
    GED_PSEUDO_FIELD_FuncControl,

    /*!
     * Message type of the send instruction.
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 7.5, 8, 8.1, 9
     */
    GED_PSEUDO_FIELD_MessageTypeDP_DC1,

    /*!
     * Category of the Data Cache Data Port 0.
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8, 8.1, 9
     */
    GED_PSEUDO_FIELD_MessageTypeDP0Category,

    /*!
     * Message type of the send instruction, legacy message.
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8, 8.1, 9
     */
    GED_PSEUDO_FIELD_MessageTypeDP_DC0Legacy,

    /*!
     * Message type of the send instruction, scratch block message.
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 8, 8.1, 9
     */
    GED_PSEUDO_FIELD_MessageTypeDP_DC0ScratchBlock,

    /*!
     * Message type of the send instruction.
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 9
     */
    GED_PSEUDO_FIELD_MessageTypeDP_DC2,

    /*!
     * Message type of the send instruction.
     *
     * @par     Models:     10, 11, TGL, XE.HP, XE.HPG, XE.HPC.A, XE.HPC, 9
     */
    GED_PSEUDO_FIELD_MessageTypeDP_DCRO,

    /*!
     * This field specifies the number of 256-bit GRF registers starting from src1 to be sent out on the request message payload.
     *
     * @par     Models:     TGL
     */
    GED_PSEUDO_FIELD_ExMessageLength,

    /*!
     * This field indicates the opcode of DP atomic operation
     *
     * @par     Models:     XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_PSEUDO_FIELD_DPOpcode,

    /*!
     * This field specifies the type of the address payload item in a DP message
     *
     * @par     Models:     XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_PSEUDO_FIELD_DPAddrSurfaceType,

    /*!
     * This field specifies the size of the vector in a DP message
     *
     * @par     Models:     XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_PSEUDO_FIELD_DPVectSize,

    /*!
     * Specifies the type of cache flush operation to perform after the fence is complete.
     *
     * @par     Models:     XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_PSEUDO_FIELD_DPFlushType,

    /*!
     * This field specifies if the data payload vector is packed into the register in the normal SIMT layout, or is packed transposed
     * in the SIMD layout.
     *
     * @par     Models:     XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_PSEUDO_FIELD_DPTranspose,

    /*!
     * This field specifies if flush operation is the full cache or over an address range.
     *
     * @par     Models:     XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_PSEUDO_FIELD_DPFlushRange,

    /*!
     * This field specifies the size of the data payload item in a DP message
     *
     * @par     Models:     XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_PSEUDO_FIELD_DPDataSize,

    /*!
     * This field specifies the scope of the fence
     *
     * @par     Models:     XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_PSEUDO_FIELD_DPFenceScope,

    /*!
     * This field specifies the size of the address payload item in a DP message
     *
     * @par     Models:     XE.HPG, XE.HPC.A, XE.HPC
     */
    GED_PSEUDO_FIELD_DPAddrSize
} GED_PSEUDO_FIELD;
#endif // GED_INS_FIELD_H
