/*
 *	This program written by Edward Der-Hua Liu,Taiwan for xcin-2.1b
 *		fix by Pa,Taiwan for zh-kcfonts-pre1
 *						     PM5:10 4/16/1997
 *
 */

#include <stdio.h>
#include <sys/types.h>

char head[]=
"STARTFONT 2.1\n"
"COMMENT 24x24 Font\n"
"FONT kc24f\n" 
"SIZE 24 100 100\n"
"FONTBOUNDINGBOX 24 24 0 -2\n"
"STARTPROPERTIES 12\n"
"FONT_ASCENT 22\n"
"FONT_DESCENT 2\n"
"DEFAULT_CHAR 41280\n"
"COPYRIGHT \"KC\"\n"
"POINT_SIZE 240\n"
"FONT \"kc24f\"\n"
"WEIGHT 10\n"
"RESOLUTION 103\n"
"RESOLUTION_X 100\n"
"RESOLUTION_Y 100\n"
"X_HEIGHT 4294967295\n"
"QUAD_WIDTH 24\n"
"ENDPROPERTIES\n"
"CHARS 13867\n";

FILE *fp,*fr1, *fr2, *fw=stdout;

int count, ofs;

void out(FILE *fp)
{
u_char tt[3],uu[3];
u_char bf[24][3];
int v,i,j,zc;


if ((v=fread(bf,1,72,fp)) != 72) return; 
fprintf(fw,"STARTCHAR %d\n", count);
tt[0]=ofs>>8;
tt[1]=ofs&255;
ser_b5(tt,uu);
fprintf(fw,"ENCODING %d\n", (u_short)uu[0]<<8 | uu[1]);
fprintf(fw,"SWIDTH 960 0\n");
fprintf(fw,"DWIDTH 24 0\n");
fprintf(fw,"BBX 24 24 0 -2\n");
fprintf(fw,"BITMAP\n");
zc=0;
for(i=0;i<24;i++) {
	v=(((u_int)bf[i][0]<<16) | ((u_int)bf[i][1]<<8)) | bf[i][2];
	fprintf(fw,"%06x\n", v);
}
fprintf(fw,"ENDCHAR\n");
}

main()
{

if ((fp=fopen("spcfont.24","r"))==NULL) {
  fprintf(stderr,"kc24 Error 1:Can't open spcfont.24\n"); exit(2); 
}
fputs(head,fw);

ofs=0x8400;
while (!feof(fp)) {
	out(fp);
	ofs++; count++;
}

fclose(fp);

if ((fr1=fopen("stdfont.24f","r"))==NULL) {
  fprintf(stderr,"kc24 Error 1:Can't open stdfont.24f\n"); exit(2); 
}
if ((fr2=fopen("spcfsupp.24","r"))==NULL) {
  fprintf(stderr,"kc24 Error 1:Can't open spcfsupp.24\n"); exit(2); 
}
ofs=0x8800;
while (!feof(fr1)) {
	out(fr1);
	ofs++; count++;
	if (ofs==0x9b81) {
		fp=fr2;
		ofs=0xe000+63;
		fseek(fr2,0,0);
		while (!feof(fr2)) {
			out(fr2);
			ofs++;
			count++;
		}
		ofs=0x9b81;
	}
}

fclose(fr1);
fclose(fr2);

fprintf(fw,"ENDFONT\n");

fclose(fp);
fclose(fw);
}
