; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -analyze -scalar-evolution %s -enable-new-pm=0 | FileCheck %s
; RUN: opt -passes='print<scalar-evolution>' -disable-output %s 2>&1 | FileCheck %s

; Tests for PR47904.

define void @test_trip_multiple_4(i32 %num) {
; CHECK-LABEL: @test_trip_multiple_4
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 1
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp uge i32 %num, 4
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_5(i32 %num) {
; CHECK-LABEL: @test_trip_multiple_5
; CHECK:       Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK:       Loop %for.body: Trip multiple is 1
;
entry:
  %u = urem i32 %num, 5
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp uge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

declare void @llvm.assume(i1)
