function(PreventInTreeBuilds)
  get_filename_component(srcdir "${CMAKE_SOURCE_DIR}" REALPATH)
  get_filename_component(bindir "${CMAKE_BINARY_DIR}" REALPATH)

  if("${srcdir}" STREQUAL "${bindir}")
    message("")
    message("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
    message("Neovim doesn't support in-tree builds.  It's recommended that you")
    message("use a build/ subdirectory:")
    message("    mkdir build")
    message("    cd build")
    message("    cmake <OPTIONS> ..")
    message("")
    message("Make sure to cleanup some CMake artifacts from this failed build")
    message("with:")
    message("    rm -rf CMakeFiles CMakeCache.txt")
    message("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
    message("")
    message(FATAL_ERROR "Stopping build.")
  endif()
endfunction()

PreventInTreeBuilds()
