/*
 * mount_xdr	XDR procedures for mountd.
 *
 * Originally generated by rpcgen; edited to get rid of warnings.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <mount.h>

inline bool_t
xdr_fhandle(XDR *xdrs, fhandle objp)
{
	return xdr_opaque(xdrs, objp, FHSIZE);
}

bool_t
xdr_fhstatus(XDR *xdrs, fhstatus *objp)
{
	return xdr_u_int(xdrs, &objp->fhs_status) &&
	       (objp->fhs_status != 0 ||
		xdr_fhandle(xdrs, objp->fhstatus_u.fhs_fhandle));
}

bool_t
xdr_dirpath(XDR *xdrs, dirpath *objp)
{
	return xdr_string(xdrs, objp, MNTPATHLEN);
}

inline bool_t
xdr_name(XDR *xdrs, name *objp)
{
	return xdr_string(xdrs, objp, MNTPATHLEN);
}

bool_t
xdr_mountlist(XDR *xdrs, mountlist *objp)
{
	return xdr_pointer(xdrs, (char **)objp, sizeof(struct mountbody),
			(xdrproc_t)xdr_mountbody);
}

bool_t
xdr_mountbody(XDR *xdrs, mountbody *objp)
{
	return xdr_name(xdrs, &objp->ml_hostname) &&
	       xdr_dirpath(xdrs, &objp->ml_directory) &&
	       xdr_mountlist(xdrs, &objp->ml_next);
}

bool_t
xdr_groups(XDR *xdrs, groups *objp)
{
	return xdr_pointer(xdrs, (char **)objp, sizeof(struct groupnode),
			(xdrproc_t)xdr_groupnode);
}

bool_t
xdr_groupnode(XDR *xdrs, groupnode *objp)
{
	return xdr_name(xdrs, &objp->gr_name) &&
	       xdr_groups(xdrs, &objp->gr_next);
}

bool_t
xdr_exports(XDR *xdrs, exports *objp)
{
	return xdr_pointer(xdrs, (char **)objp, sizeof(struct exportnode),
			(xdrproc_t)xdr_exportnode);
}

bool_t
xdr_exportnode(XDR *xdrs, exportnode *objp)
{
	return xdr_dirpath(xdrs, &objp->ex_dir) &&
	       xdr_groups(xdrs, &objp->ex_groups) &&
	       xdr_exports(xdrs, &objp->ex_next);
}
