//---------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
// This file is automatically generated.  Please do not edit it directly.
//
// File name: D2D1EffectAuthor.h
//---------------------------------------------------------------------------
#ifdef _MSC_VER
#pragma once
#endif // #ifdef _MSC_VER

#ifndef _D2D1_EFFECT_AUTHOR_H_
#define _D2D1_EFFECT_AUTHOR_H_

#ifndef _D2D1_1_H_
#include <d2d1_1.h>
#endif // #ifndef _D2D1_1_H_


//+-----------------------------------------------------------------------------
//
//  Function Pointer:
//      PD2D1_PROPERTY_SET_FUNCTION
//
//  Synopsis:
//      Function pointer that sets a property on an effect.
//
//------------------------------------------------------------------------------
typedef HRESULT (CALLBACK *PD2D1_PROPERTY_SET_FUNCTION)(
    _In_ IUnknown *effect,
    _In_reads_(dataSize) const BYTE *data,
    UINT32 dataSize
    );

//+-----------------------------------------------------------------------------
//
//  Function Pointer:
//      PD2D1_PROPERTY_GET_FUNCTION
//
//  Synopsis:
//      Function pointer that gets a property from an effect.
//
//------------------------------------------------------------------------------
typedef HRESULT (CALLBACK *PD2D1_PROPERTY_GET_FUNCTION)(
    _In_ const IUnknown *effect,
    _Out_writes_opt_(dataSize) BYTE *data,
    UINT32 dataSize,
    _Out_opt_ UINT32 *actualSize
    );

#ifndef D2D_USE_C_DEFINITIONS

interface ID2D1EffectContext;
interface ID2D1TransformNode;

#else

typedef interface ID2D1EffectContext ID2D1EffectContext;
typedef interface ID2D1TransformNode ID2D1TransformNode;

#endif


//+-----------------------------------------------------------------------------
//
//  Flag:
//      D2D1_CHANGE_TYPE
//
//  Synopsis:
//      Indicates what has changed since the last time the effect was asked to prepare
//      to render.
//
//------------------------------------------------------------------------------
typedef enum D2D1_CHANGE_TYPE
{
        
        //
        // Nothing has changed.
        //
        D2D1_CHANGE_TYPE_NONE = 0,
        
        //
        // The effect's properties have changed.
        //
        D2D1_CHANGE_TYPE_PROPERTIES = 1,
        
        //
        // The internal context has changed and should be inspected.
        //
        D2D1_CHANGE_TYPE_CONTEXT = 2,
        
        //
        // A new graph has been set due to a change in the input count.
        //
        D2D1_CHANGE_TYPE_GRAPH = 3,
        D2D1_CHANGE_TYPE_FORCE_DWORD = 0xffffffff

} D2D1_CHANGE_TYPE;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_CHANGE_TYPE);


//+-----------------------------------------------------------------------------
//
//  Flag:
//      D2D1_PIXEL_OPTIONS
//
//  Synopsis:
//      Indicates options for drawing using a pixel shader.
//
//------------------------------------------------------------------------------
typedef enum D2D1_PIXEL_OPTIONS
{
        
        //
        // Default pixel processing.
        //
        D2D1_PIXEL_OPTIONS_NONE = 0,
        
        //
        // Indicates that the shader samples its inputs only at exactly the same scene
        // coordinate as the output pixel, and that it returns transparent black whenever
        // the input pixels are also transparent black.
        //
        D2D1_PIXEL_OPTIONS_TRIVIAL_SAMPLING = 1,
        D2D1_PIXEL_OPTIONS_FORCE_DWORD = 0xffffffff

} D2D1_PIXEL_OPTIONS;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_PIXEL_OPTIONS);


//+-----------------------------------------------------------------------------
//
//  Flag:
//      D2D1_VERTEX_OPTIONS
//
//  Synopsis:
//      Indicates options for drawing custom vertices set by transforms.
//
//------------------------------------------------------------------------------
typedef enum D2D1_VERTEX_OPTIONS
{
        
        //
        // Default vertex processing.
        //
        D2D1_VERTEX_OPTIONS_NONE = 0,
        
        //
        // Indicates that the output rectangle does not need to be cleared before drawing
        // custom vertices. This must only be used by transforms whose custom vertices
        // completely cover their output rectangle.
        //
        D2D1_VERTEX_OPTIONS_DO_NOT_CLEAR = 1,
        
        //
        // Causes a depth buffer to be used while drawing custom vertices. This impacts
        // drawing behavior when primitives overlap one another.
        //
        D2D1_VERTEX_OPTIONS_USE_DEPTH_BUFFER = 2,
        
        //
        // Indicates that custom vertices do not form primitives which overlap one another.
        //
        D2D1_VERTEX_OPTIONS_ASSUME_NO_OVERLAP = 4,
        D2D1_VERTEX_OPTIONS_FORCE_DWORD = 0xffffffff

} D2D1_VERTEX_OPTIONS;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_VERTEX_OPTIONS);


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_VERTEX_USAGE
//
//  Synopsis:
//      Describes how a vertex buffer is to be managed.
//
//------------------------------------------------------------------------------
typedef enum D2D1_VERTEX_USAGE
{
        
        //
        // The vertex buffer content do not change frequently from frame to frame.
        //
        D2D1_VERTEX_USAGE_STATIC = 0,
        
        //
        // The vertex buffer is intended to be updated frequently.
        //
        D2D1_VERTEX_USAGE_DYNAMIC = 1,
        D2D1_VERTEX_USAGE_FORCE_DWORD = 0xffffffff

} D2D1_VERTEX_USAGE;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_BLEND_OPERATION
//
//  Synopsis:
//      Describes a particular blend in the D2D1_BLEND_DESCRIPTION structure.
//
//------------------------------------------------------------------------------
typedef enum D2D1_BLEND_OPERATION
{
        D2D1_BLEND_OPERATION_ADD = 1,
        D2D1_BLEND_OPERATION_SUBTRACT = 2,
        D2D1_BLEND_OPERATION_REV_SUBTRACT = 3,
        D2D1_BLEND_OPERATION_MIN = 4,
        D2D1_BLEND_OPERATION_MAX = 5,
        D2D1_BLEND_OPERATION_FORCE_DWORD = 0xffffffff

} D2D1_BLEND_OPERATION;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_BLEND
//
//  Synopsis:
//      Describes a particular blend in the D2D1_BLEND_DESCRIPTION structure.
//
//------------------------------------------------------------------------------
typedef enum D2D1_BLEND
{
        D2D1_BLEND_ZERO = 1,
        D2D1_BLEND_ONE = 2,
        D2D1_BLEND_SRC_COLOR = 3,
        D2D1_BLEND_INV_SRC_COLOR = 4,
        D2D1_BLEND_SRC_ALPHA = 5,
        D2D1_BLEND_INV_SRC_ALPHA = 6,
        D2D1_BLEND_DEST_ALPHA = 7,
        D2D1_BLEND_INV_DEST_ALPHA = 8,
        D2D1_BLEND_DEST_COLOR = 9,
        D2D1_BLEND_INV_DEST_COLOR = 10,
        D2D1_BLEND_SRC_ALPHA_SAT = 11,
        D2D1_BLEND_BLEND_FACTOR = 14,
        D2D1_BLEND_INV_BLEND_FACTOR = 15,
        D2D1_BLEND_FORCE_DWORD = 0xffffffff

} D2D1_BLEND;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_CHANNEL_DEPTH
//
//  Synopsis:
//      Allows a caller to control the channel depth of a stage in the rendering
//      pipeline.
//
//------------------------------------------------------------------------------
typedef enum D2D1_CHANNEL_DEPTH
{
        D2D1_CHANNEL_DEPTH_DEFAULT = 0,
        D2D1_CHANNEL_DEPTH_1 = 1,
        D2D1_CHANNEL_DEPTH_4 = 4,
        D2D1_CHANNEL_DEPTH_FORCE_DWORD = 0xffffffff

} D2D1_CHANNEL_DEPTH;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_FILTER
//
//  Synopsis:
//      Represents filtering modes transforms may select to use on their input textures.
//
//------------------------------------------------------------------------------
typedef enum D2D1_FILTER
{
        D2D1_FILTER_MIN_MAG_MIP_POINT = 0x00,
        D2D1_FILTER_MIN_MAG_POINT_MIP_LINEAR = 0x01,
        D2D1_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x04,
        D2D1_FILTER_MIN_POINT_MAG_MIP_LINEAR = 0x05,
        D2D1_FILTER_MIN_LINEAR_MAG_MIP_POINT = 0x10,
        D2D1_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x11,
        D2D1_FILTER_MIN_MAG_LINEAR_MIP_POINT = 0x14,
        D2D1_FILTER_MIN_MAG_MIP_LINEAR = 0x15,
        D2D1_FILTER_ANISOTROPIC = 0x55,
        D2D1_FILTER_FORCE_DWORD = 0xffffffff

} D2D1_FILTER;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_FEATURE
//
//  Synopsis:
//      Defines capabilities of the underlying D3D device which may be queried using
//      CheckFeatureSupport.
//
//------------------------------------------------------------------------------
typedef enum D2D1_FEATURE
{
        D2D1_FEATURE_DOUBLES = 0,
        D2D1_FEATURE_D3D10_X_HARDWARE_OPTIONS = 1,
        D2D1_FEATURE_FORCE_DWORD = 0xffffffff

} D2D1_FEATURE;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_PROPERTY_BINDING
//
//  Synopsis:
//      Defines a property binding to a function. The name must match the property
//      defined in the registration schema.
//
//------------------------------------------------------------------------------
typedef struct D2D1_PROPERTY_BINDING
{
    
    //
    // The name of the property.
    //
    PCWSTR propertyName;
    
    //
    // The function that will receive the data to set.
    //
    PD2D1_PROPERTY_SET_FUNCTION setFunction;
    
    //
    // The function that will be asked to write the output data.
    //
    PD2D1_PROPERTY_GET_FUNCTION getFunction;

} D2D1_PROPERTY_BINDING;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_RESOURCE_TEXTURE_PROPERTIES
//
//  Synopsis:
//      This is used to define a resource texture when that resource texture is created.
//
//------------------------------------------------------------------------------
typedef struct D2D1_RESOURCE_TEXTURE_PROPERTIES
{
    _Field_size_(dimensions) CONST UINT32 *extents;
    UINT32 dimensions;
    D2D1_BUFFER_PRECISION bufferPrecision;
    D2D1_CHANNEL_DEPTH channelDepth;
    D2D1_FILTER filter;
    _Field_size_(dimensions) CONST D2D1_EXTEND_MODE *extendModes;

} D2D1_RESOURCE_TEXTURE_PROPERTIES;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_INPUT_ELEMENT_DESC
//
//  Synopsis:
//      This defines a single element of the vertex layout.
//
//------------------------------------------------------------------------------
typedef struct D2D1_INPUT_ELEMENT_DESC
{
    PCSTR semanticName;
    UINT32 semanticIndex;
    DXGI_FORMAT format;
    UINT32 inputSlot;
    UINT32 alignedByteOffset;

} D2D1_INPUT_ELEMENT_DESC;


// 
// Set to alignedByteOffset within D2D1_INPUT_ELEMENT_DESC for elements that 
// immediately follow preceding elements in memory
//
#define D2D1_APPEND_ALIGNED_ELEMENT ( 0xffffffff )


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_VERTEX_BUFFER_PROPERTIES
//
//  Synopsis:
//      This defines the properties of a vertex buffer which uses the default vertex
//      layout.
//
//------------------------------------------------------------------------------
typedef struct D2D1_VERTEX_BUFFER_PROPERTIES
{
    UINT32 inputCount;
    D2D1_VERTEX_USAGE usage;
    _Field_size_opt_(byteWidth) CONST BYTE *data;
    UINT32 byteWidth;

} D2D1_VERTEX_BUFFER_PROPERTIES;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES
//
//  Synopsis:
//      This defines the input layout of vertices and the vertex shader which processes
//      them.
//
//------------------------------------------------------------------------------
typedef struct D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES
{
    _Field_size_(shaderBufferSize) CONST BYTE *shaderBufferWithInputSignature;
    UINT32 shaderBufferSize;
    _Field_size_opt_(elementCount) CONST D2D1_INPUT_ELEMENT_DESC *inputElements;
    UINT32 elementCount;
    UINT32 stride;

} D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_VERTEX_RANGE
//
//  Synopsis:
//      This defines the range of vertices from a vertex buffer to draw.
//
//------------------------------------------------------------------------------
typedef struct D2D1_VERTEX_RANGE
{
    UINT32 startVertex;
    UINT32 vertexCount;

} D2D1_VERTEX_RANGE;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_BLEND_DESCRIPTION
//
//  Synopsis:
//      Blend description which configures a blend transform object.
//
//------------------------------------------------------------------------------
typedef struct D2D1_BLEND_DESCRIPTION
{
    D2D1_BLEND sourceBlend;
    D2D1_BLEND destinationBlend;
    D2D1_BLEND_OPERATION blendOperation;
    D2D1_BLEND sourceBlendAlpha;
    D2D1_BLEND destinationBlendAlpha;
    D2D1_BLEND_OPERATION blendOperationAlpha;
    FLOAT blendFactor[4];

} D2D1_BLEND_DESCRIPTION;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_INPUT_DESCRIPTION
//
//  Synopsis:
//      Describes options transforms may select to use on their input textures.
//
//------------------------------------------------------------------------------
typedef struct D2D1_INPUT_DESCRIPTION
{
    D2D1_FILTER filter;
    UINT32 levelOfDetailCount;

} D2D1_INPUT_DESCRIPTION;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_FEATURE_DATA_DOUBLES
//
//  Synopsis:
//      Indicates whether shader support for doubles is present on the underlying
//      hardware.  This may be populated using CheckFeatureSupport.
//
//------------------------------------------------------------------------------
typedef struct D2D1_FEATURE_DATA_DOUBLES
{
    BOOL doublePrecisionFloatShaderOps;

} D2D1_FEATURE_DATA_DOUBLES;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS
//
//  Synopsis:
//      Indicates support for features which are optional on D3D10 feature levels.  This
//      may be populated using CheckFeatureSupport.
//
//------------------------------------------------------------------------------
typedef struct D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS
{
    BOOL computeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x;

} D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS;


#ifndef D2D_USE_C_DEFINITIONS



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1VertexBuffer
//
//  Synopsis:
//      A transform uses this interface to write new vertices to a vertex buffer.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("9b8b1336-00a5-4668-92b7-ced5d8bf9b7b") ID2D1VertexBuffer  : public IUnknown
{
    
    STDMETHOD(Map)(
        _Outptr_result_bytebuffer_(bufferSize) BYTE **data,
        UINT32 bufferSize 
        ) PURE;
    
    STDMETHOD(Unmap)(
        ) PURE;
}; // interface ID2D1VertexBuffer



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1ResourceTexture
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("688d15c3-02b0-438d-b13a-d1b44c32c39a") ID2D1ResourceTexture  : public IUnknown
{
    
    
    //
    // Update the vertex text.
    //
    STDMETHOD(Update)(
        _In_reads_opt_(dimensions) CONST UINT32 *minimumExtents,
        _In_reads_opt_(dimensions) CONST UINT32 *maximimumExtents,
        _In_reads_opt_(dimensions - 1) CONST UINT32 *strides,
        UINT32 dimensions,
        _In_reads_(dataCount) CONST BYTE *data,
        UINT32 dataCount 
        ) PURE;
}; // interface ID2D1ResourceTexture



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1RenderInfo
//
//  Synopsis:
//      A transform uses this interface to specify how to render a particular pass in
//      D2D.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("519ae1bd-d19a-420d-b849-364f594776b7") ID2D1RenderInfo  : public IUnknown
{
    
    
    //
    // Sets options for sampling the specified image input
    //
    STDMETHOD(SetInputDescription)(
        UINT32 inputIndex,
        D2D1_INPUT_DESCRIPTION inputDescription 
        ) PURE;
    
    
    //
    // Controls the output precision and channel-depth for the associated transform.
    //
    STDMETHOD(SetOutputBuffer)(
        D2D1_BUFFER_PRECISION bufferPrecision,
        D2D1_CHANNEL_DEPTH channelDepth 
        ) PURE;
    
    
    //
    // Controls whether the output of the associated transform is cached.
    //
    STDMETHOD_(void, SetCached)(
        BOOL isCached 
        ) PURE;
    
    
    //
    // Provides a hint of the approximate shader instruction count per pixel.  If
    // provided, it may improve performance when processing large images.  Instructions
    // should be counted multiple times if occurring within loops.
    //
    STDMETHOD_(void, SetInstructionCountHint)(
        UINT32 instructionCount 
        ) PURE;
}; // interface ID2D1RenderInfo



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1DrawInfo
//
//  Synopsis:
//      A transform uses this interface to specify how to render a particular pass using
//      pixel and vertex shaders.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("693ce632-7f2f-45de-93fe-18d88b37aa21") ID2D1DrawInfo  : public ID2D1RenderInfo
{
    
    
    //
    // Set the constant buffer for this transform's pixel shader.
    //
    STDMETHOD(SetPixelShaderConstantBuffer)(
        _In_reads_(bufferCount) CONST BYTE *buffer,
        UINT32 bufferCount 
        ) PURE;
    
    
    //
    // Sets the resource texture corresponding to the given shader texture index.
    //
    STDMETHOD(SetResourceTexture)(
        UINT32 textureIndex,
        _In_ ID2D1ResourceTexture *resourceTexture 
        ) PURE;
    
    
    //
    // Set the constant buffer for this transform's vertex shader.
    //
    STDMETHOD(SetVertexShaderConstantBuffer)(
        _In_reads_(bufferCount) CONST BYTE *buffer,
        UINT32 bufferCount 
        ) PURE;
    
    
    //
    // Set the shader instructions for this transform.
    //
    STDMETHOD(SetPixelShader)(
        _In_ REFGUID shaderId,
        D2D1_PIXEL_OPTIONS pixelOptions = D2D1_PIXEL_OPTIONS_NONE 
        ) PURE;
    
    
    //
    // Set custom vertices for the associated transform.  A blend mode if
    // foreground-over will be used if blendDescription is NULL.
    //
    STDMETHOD(SetVertexProcessing)(
        _In_opt_ ID2D1VertexBuffer *vertexBuffer,
        D2D1_VERTEX_OPTIONS vertexOptions,
        _In_opt_ CONST D2D1_BLEND_DESCRIPTION *blendDescription = NULL,
        _In_opt_ CONST D2D1_VERTEX_RANGE *vertexRange = NULL,
        _In_opt_ CONST GUID *vertexShader = NULL 
        ) PURE;
}; // interface ID2D1DrawInfo



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1ComputeInfo
//
//  Synopsis:
//      A transform uses this interface to specify how to render a particular pass using
//      compute shader.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("5598b14b-9fd7-48b7-9bdb-8f0964eb38bc") ID2D1ComputeInfo  : public ID2D1RenderInfo
{
    
    
    //
    // Set the constant buffer for this transform.
    //
    STDMETHOD(SetComputeShaderConstantBuffer)(
        _In_reads_(bufferCount) CONST BYTE *buffer,
        UINT32 bufferCount 
        ) PURE;
    
    
    //
    // Set the shader instructions for this transform.
    //
    STDMETHOD(SetComputeShader)(
        _In_ REFGUID shaderId 
        ) PURE;
    
    
    //
    // Sets the resource texture corresponding to the given shader texture index.
    //
    STDMETHOD(SetResourceTexture)(
        UINT32 textureIndex,
        _In_ ID2D1ResourceTexture *resourceTexture 
        ) PURE;
}; // interface ID2D1ComputeInfo



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1TransformNode
//
//  Synopsis:
//      A base object which can be inserted into a transform graph.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("b2efe1e7-729f-4102-949f-505fa21bf666") ID2D1TransformNode  : public IUnknown
{
    
    
    //
    // Return the number of input this node has.
    //
    STDMETHOD_(UINT32, GetInputCount)(
        ) CONST PURE;
}; // interface ID2D1TransformNode



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1TransformGraph
//
//  Synopsis:
//      The implementation of the actual graph.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("13d29038-c3e6-4034-9081-13b53a417992") ID2D1TransformGraph  : public IUnknown
{
    
    
    //
    // Return the number of input this graph has.
    //
    STDMETHOD_(UINT32, GetInputCount)(
        ) CONST PURE;
    
    
    //
    // Sets the graph to contain a single transform whose inputs map 1:1 with effect
    // inputs.
    //
    STDMETHOD(SetSingleTransformNode)(
        _In_ ID2D1TransformNode *node 
        ) PURE;
    
    
    //
    // Adds the given transform node to the graph.
    //
    STDMETHOD(AddNode)(
        _In_ ID2D1TransformNode *node 
        ) PURE;
    
    
    //
    // Removes the given transform node from the graph.
    //
    STDMETHOD(RemoveNode)(
        _In_ ID2D1TransformNode *node 
        ) PURE;
    
    
    //
    // Indicates that the given transform node should be considered to be the output
    // node of the graph.
    //
    STDMETHOD(SetOutputNode)(
        _In_ ID2D1TransformNode *node 
        ) PURE;
    
    
    //
    // Connects one node to another node inside the graph.
    //
    STDMETHOD(ConnectNode)(
        _In_ ID2D1TransformNode *fromNode,
        _In_ ID2D1TransformNode *toNode,
        UINT32 toNodeInputIndex 
        ) PURE;
    
    
    //
    // Connects a transform node inside the graph to the corresponding input of the
    // encapsulating effect.
    //
    STDMETHOD(ConnectToEffectInput)(
        UINT32 toEffectInputIndex,
        _In_ ID2D1TransformNode *node,
        UINT32 toNodeInputIndex 
        ) PURE;
    
    
    //
    // Clears all nodes and connections from the transform graph.
    //
    STDMETHOD_(void, Clear)(
        ) PURE;
    
    
    //
    // Uses the specified input as the effect output.
    //
    STDMETHOD(SetPassthroughGraph)(
        UINT32 effectInputIndex 
        ) PURE;
}; // interface ID2D1TransformGraph



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1Transform
//
//  Synopsis:
//      The interface implemented by a transform author.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("ef1a287d-342a-4f76-8fdb-da0d6ea9f92b") ID2D1Transform  : public ID2D1TransformNode
{
    
    STDMETHOD(MapOutputRectToInputRects)(
        _In_ CONST D2D1_RECT_L *outputRect,
        _Out_writes_(inputRectsCount) D2D1_RECT_L *inputRects,
        UINT32 inputRectsCount 
        ) CONST PURE;
    
    STDMETHOD(MapInputRectsToOutputRect)(
        _In_reads_(inputRectCount) CONST D2D1_RECT_L *inputRects,
        _In_reads_(inputRectCount) CONST D2D1_RECT_L *inputOpaqueSubRects,
        UINT32 inputRectCount,
        _Out_ D2D1_RECT_L *outputRect,
        _Out_ D2D1_RECT_L *outputOpaqueSubRect 
        ) PURE;
    
    STDMETHOD(MapInvalidRect)(
        UINT32 inputIndex,
        D2D1_RECT_L invalidInputRect,
        _Out_ D2D1_RECT_L *invalidOutputRect 
        ) CONST PURE;
}; // interface ID2D1Transform



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1DrawTransform
//
//  Synopsis:
//      The interface implemented by a transform author to provide a GPU-based effect.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("36bfdcb6-9739-435d-a30d-a653beff6a6f") ID2D1DrawTransform  : public ID2D1Transform
{
    
    STDMETHOD(SetDrawInfo)(
        _In_ ID2D1DrawInfo *drawInfo 
        ) PURE;
}; // interface ID2D1DrawTransform



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1ComputeTransform
//
//  Synopsis:
//      The interface implemented by a transform author to provide a Compute Shader
//      based effect.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("0d85573c-01e3-4f7d-bfd9-0d60608bf3c3") ID2D1ComputeTransform  : public ID2D1Transform
{
    
    STDMETHOD(SetComputeInfo)(
        _In_ ID2D1ComputeInfo *computeInfo 
        ) PURE;
    
    STDMETHOD(CalculateThreadgroups)(
        _In_ CONST D2D1_RECT_L *outputRect,
        _Out_ UINT32 *dimensionX,
        _Out_ UINT32 *dimensionY,
        _Out_ UINT32 *dimensionZ 
        ) PURE;
}; // interface ID2D1ComputeTransform



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1AnalysisTransform
//
//  Synopsis:
//      The interface implemented by a transform author to indicate that it should
//      receive an analysis result callback.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("0359dc30-95e6-4568-9055-27720d130e93") ID2D1AnalysisTransform  : public IUnknown
{
    
    STDMETHOD(ProcessAnalysisResults)(
        _In_reads_(analysisDataCount) CONST BYTE *analysisData,
        UINT32 analysisDataCount 
        ) PURE;
}; // interface ID2D1AnalysisTransform



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1SourceTransform
//
//  Synopsis:
//      The interface implemented by a transform author to provide a CPU based source
//      effect.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("db1800dd-0c34-4cf9-be90-31cc0a5653e1") ID2D1SourceTransform  : public ID2D1Transform
{
    
    STDMETHOD(SetRenderInfo)(
        _In_ ID2D1RenderInfo *renderInfo 
        ) PURE;
    
    STDMETHOD(Draw)(
        _In_ ID2D1Bitmap1 *target,
        _In_ CONST D2D1_RECT_L *drawRect,
        D2D1_POINT_2U targetOrigin 
        ) PURE;
}; // interface ID2D1SourceTransform



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1ConcreteTransform
//
//  Synopsis:
//      Base interface for built-in transforms on which precision and caching may be
//      controlled.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("1a799d8a-69f7-4e4c-9fed-437ccc6684cc") ID2D1ConcreteTransform  : public ID2D1TransformNode
{
    
    
    //
    // Controls the output precision and channel-depth for this transform.
    //
    STDMETHOD(SetOutputBuffer)(
        D2D1_BUFFER_PRECISION bufferPrecision,
        D2D1_CHANNEL_DEPTH channelDepth 
        ) PURE;
    
    
    //
    // Controls whether the output of this transform is cached.
    //
    STDMETHOD_(void, SetCached)(
        BOOL isCached 
        ) PURE;
}; // interface ID2D1ConcreteTransform



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1BlendTransform
//
//  Synopsis:
//      An effect uses this interface to configure a blending operation.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("63ac0b32-ba44-450f-8806-7f4ca1ff2f1b") ID2D1BlendTransform  : public ID2D1ConcreteTransform
{
    
    STDMETHOD_(void, SetDescription)(
        _In_ CONST D2D1_BLEND_DESCRIPTION *description 
        ) PURE;
    
    STDMETHOD_(void, GetDescription)(
        _Out_ D2D1_BLEND_DESCRIPTION *description 
        ) CONST PURE;
}; // interface ID2D1BlendTransform



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1BorderTransform
//
//  Synopsis:
//      An effect uses this interface to configure border generation.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("4998735c-3a19-473c-9781-656847e3a347") ID2D1BorderTransform  : public ID2D1ConcreteTransform
{
    
    STDMETHOD_(void, SetExtendModeX)(
        D2D1_EXTEND_MODE extendMode 
        ) PURE;
    
    STDMETHOD_(void, SetExtendModeY)(
        D2D1_EXTEND_MODE extendMode 
        ) PURE;
    
    STDMETHOD_(D2D1_EXTEND_MODE, GetExtendModeX)(
        ) CONST PURE;
    
    STDMETHOD_(D2D1_EXTEND_MODE, GetExtendModeY)(
        ) CONST PURE;
}; // interface ID2D1BorderTransform



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1OffsetTransform
//
//  Synopsis:
//      An effect uses this interface to offset an image without inserting a rendering
//      pass.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("3fe6adea-7643-4f53-bd14-a0ce63f24042") ID2D1OffsetTransform  : public ID2D1TransformNode
{
    
    STDMETHOD_(void, SetOffset)(
        D2D1_POINT_2L offset 
        ) PURE;
    
    STDMETHOD_(D2D1_POINT_2L, GetOffset)(
        ) CONST PURE;
}; // interface ID2D1OffsetTransform



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1BoundsAdjustmentTransform
//
//  Synopsis:
//      An effect uses this interface to alter the image rectangle of its input.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("90f732e2-5092-4606-a819-8651970baccd") ID2D1BoundsAdjustmentTransform  : public ID2D1TransformNode
{
    
    STDMETHOD_(void, SetOutputBounds)(
        _In_ CONST D2D1_RECT_L *outputBounds 
        ) PURE;
    
    STDMETHOD_(void, GetOutputBounds)(
        _Out_ D2D1_RECT_L *outputBounds 
        ) CONST PURE;
}; // interface ID2D1BoundsAdjustmentTransform



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1EffectImpl
//
//  Synopsis:
//      This is the interface implemented by an effect author, along with the
//      constructor and registration information.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("a248fd3f-3e6c-4e63-9f03-7f68ecc91db9") ID2D1EffectImpl  : public IUnknown
{
    
    
    //
    // Initialize the effect with a context and a transform graph. The effect must
    // populate the transform graph with a topology and can update it later.
    //
    STDMETHOD(Initialize)(
        _In_ ID2D1EffectContext *effectContext,
        _In_ ID2D1TransformGraph *transformGraph 
        ) PURE;
    
    
    //
    // Initialize the effect with a context and a transform graph. The effect must
    // populate the transform graph with a topology and can update it later.
    //
    STDMETHOD(PrepareForRender)(
        D2D1_CHANGE_TYPE changeType 
        ) PURE;
    
    
    //
    // Sets a new transform graph to the effect.  This happens when the number of
    // inputs to the effect changes, if the effect support a variable number of inputs.
    //
    STDMETHOD(SetGraph)(
        _In_ ID2D1TransformGraph *transformGraph 
        ) PURE;
}; // interface ID2D1EffectImpl



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1EffectContext
//
//  Synopsis:
//      The internal context handed to effect authors to create transforms from effects
//      and any other operation tied to context which is not useful to the application
//      facing API.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("3d9f916b-27dc-4ad7-b4f1-64945340f563") ID2D1EffectContext  : public IUnknown
{
    
    STDMETHOD_(void, GetDpi)(
        _Out_ FLOAT *dpiX,
        _Out_ FLOAT *dpiY 
        ) CONST PURE;
    
    
    //
    // Create a new effect, the effect must either be built in or previously registered
    // through ID2D1Factory1::RegisterEffect.
    //
    STDMETHOD(CreateEffect)(
        _In_ REFCLSID effectId,
        _Outptr_ ID2D1Effect **effect 
        ) PURE;
    
    STDMETHOD(GetMaximumSupportedFeatureLevel)(
        _In_reads_(featureLevelsCount) CONST D3D_FEATURE_LEVEL *featureLevels,
        UINT32 featureLevelsCount,
        _Out_ D3D_FEATURE_LEVEL *maximumSupportedFeatureLevel 
        ) CONST PURE;
    
    
    //
    // Create a transform node from the passed in effect.
    //
    STDMETHOD(CreateTransformNodeFromEffect)(
        _In_ ID2D1Effect *effect,
        _Outptr_ ID2D1TransformNode **transformNode 
        ) PURE;
    
    STDMETHOD(CreateBlendTransform)(
        UINT32 numInputs,
        _In_ CONST D2D1_BLEND_DESCRIPTION *blendDescription,
        _Outptr_ ID2D1BlendTransform **transform 
        ) PURE;
    
    STDMETHOD(CreateBorderTransform)(
        D2D1_EXTEND_MODE extendModeX,
        D2D1_EXTEND_MODE extendModeY,
        _Outptr_ ID2D1BorderTransform **transform 
        ) PURE;
    
    STDMETHOD(CreateOffsetTransform)(
        D2D1_POINT_2L offset,
        _Outptr_ ID2D1OffsetTransform **transform 
        ) PURE;
    
    STDMETHOD(CreateBoundsAdjustmentTransform)(
        _In_ CONST D2D1_RECT_L *outputRectangle,
        _Outptr_ ID2D1BoundsAdjustmentTransform **transform 
        ) PURE;
    
    STDMETHOD(LoadPixelShader)(
        REFGUID shaderId,
        _In_reads_(shaderBufferCount) CONST BYTE *shaderBuffer,
        UINT32 shaderBufferCount 
        ) PURE;
    
    STDMETHOD(LoadVertexShader)(
        REFGUID resourceId,
        _In_reads_(shaderBufferCount) CONST BYTE *shaderBuffer,
        UINT32 shaderBufferCount 
        ) PURE;
    
    STDMETHOD(LoadComputeShader)(
        REFGUID resourceId,
        _In_reads_(shaderBufferCount) CONST BYTE *shaderBuffer,
        UINT32 shaderBufferCount 
        ) PURE;
    
    STDMETHOD_(BOOL, IsShaderLoaded)(
        REFGUID shaderId 
        ) PURE;
    
    STDMETHOD(CreateResourceTexture)(
        _In_opt_ CONST GUID *resourceId,
        _In_ CONST D2D1_RESOURCE_TEXTURE_PROPERTIES *resourceTextureProperties,
        _In_reads_opt_(dataSize) CONST BYTE *data,
        _In_reads_opt_(resourceTextureProperties->dimensions - 1) CONST UINT32 *strides,
        UINT32 dataSize,
        _Outptr_ ID2D1ResourceTexture **resourceTexture 
        ) PURE;
    
    STDMETHOD(FindResourceTexture)(
        _In_ CONST GUID *resourceId,
        _Outptr_ ID2D1ResourceTexture **resourceTexture 
        ) PURE;
    
    STDMETHOD(CreateVertexBuffer)(
        _In_ CONST D2D1_VERTEX_BUFFER_PROPERTIES *vertexBufferProperties,
        _In_opt_ CONST GUID *resourceId,
        _In_opt_ CONST D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES *customVertexBufferProperties,
        _Outptr_ ID2D1VertexBuffer **buffer 
        ) PURE;
    
    STDMETHOD(FindVertexBuffer)(
        _In_ CONST GUID *resourceId,
        _Outptr_ ID2D1VertexBuffer **buffer 
        ) PURE;
    
    
    //
    // Creates a color context from a color space.  If the space is Custom, the context
    // is initialized from the profile/profileSize arguments.  Otherwise the context is
    // initialized with the profile bytes associated with the space and
    // profile/profileSize are ignored.
    //
    STDMETHOD(CreateColorContext)(
        D2D1_COLOR_SPACE space,
        _In_reads_opt_(profileSize) CONST BYTE *profile,
        UINT32 profileSize,
        _Outptr_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    STDMETHOD(CreateColorContextFromFilename)(
        _In_ PCWSTR filename,
        _Outptr_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    STDMETHOD(CreateColorContextFromWicColorContext)(
        _In_ IWICColorContext *wicColorContext,
        _Outptr_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    STDMETHOD(CheckFeatureSupport)(
        D2D1_FEATURE feature,
        _Out_writes_bytes_(featureSupportDataSize) void *featureSupportData,
        UINT32 featureSupportDataSize 
        ) CONST PURE;
    
    
    //
    // Indicates whether the buffer precision is supported by D2D.
    //
    STDMETHOD_(BOOL, IsBufferPrecisionSupported)(
        D2D1_BUFFER_PRECISION bufferPrecision 
        ) CONST PURE;
}; // interface ID2D1EffectContext



#endif


EXTERN_C CONST IID IID_ID2D1VertexBuffer;
EXTERN_C CONST IID IID_ID2D1ResourceTexture;
EXTERN_C CONST IID IID_ID2D1RenderInfo;
EXTERN_C CONST IID IID_ID2D1DrawInfo;
EXTERN_C CONST IID IID_ID2D1ComputeInfo;
EXTERN_C CONST IID IID_ID2D1TransformNode;
EXTERN_C CONST IID IID_ID2D1TransformGraph;
EXTERN_C CONST IID IID_ID2D1Transform;
EXTERN_C CONST IID IID_ID2D1DrawTransform;
EXTERN_C CONST IID IID_ID2D1ComputeTransform;
EXTERN_C CONST IID IID_ID2D1AnalysisTransform;
EXTERN_C CONST IID IID_ID2D1SourceTransform;
EXTERN_C CONST IID IID_ID2D1ConcreteTransform;
EXTERN_C CONST IID IID_ID2D1BlendTransform;
EXTERN_C CONST IID IID_ID2D1BorderTransform;
EXTERN_C CONST IID IID_ID2D1OffsetTransform;
EXTERN_C CONST IID IID_ID2D1BoundsAdjustmentTransform;
EXTERN_C CONST IID IID_ID2D1EffectImpl;
EXTERN_C CONST IID IID_ID2D1EffectContext;


#ifdef D2D_USE_C_DEFINITIONS


typedef interface ID2D1VertexBuffer ID2D1VertexBuffer;

typedef struct ID2D1VertexBufferVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD(Map)(
        ID2D1VertexBuffer *This,
        _Outptr_result_bytebuffer_(bufferSize) BYTE **data,
        UINT32 bufferSize 
        ) PURE;
    
    STDMETHOD(Unmap)(
        ID2D1VertexBuffer *This 
        ) PURE;
} ID2D1VertexBufferVtbl;

interface ID2D1VertexBuffer
{
    CONST struct ID2D1VertexBufferVtbl *lpVtbl;
};


#define ID2D1VertexBuffer_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1VertexBuffer_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1VertexBuffer_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1VertexBuffer_Map(This, data, bufferSize) \
    ((This)->lpVtbl->Map(This, data, bufferSize))

#define ID2D1VertexBuffer_Unmap(This) \
    ((This)->lpVtbl->Unmap(This))

typedef interface ID2D1ResourceTexture ID2D1ResourceTexture;

typedef struct ID2D1ResourceTextureVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD(Update)(
        ID2D1ResourceTexture *This,
        _In_reads_opt_(dimensions) CONST UINT32 *minimumExtents,
        _In_reads_opt_(dimensions) CONST UINT32 *maximimumExtents,
        _In_reads_opt_(dimensions - 1) CONST UINT32 *strides,
        UINT32 dimensions,
        _In_reads_(dataCount) CONST BYTE *data,
        UINT32 dataCount 
        ) PURE;
} ID2D1ResourceTextureVtbl;

interface ID2D1ResourceTexture
{
    CONST struct ID2D1ResourceTextureVtbl *lpVtbl;
};


#define ID2D1ResourceTexture_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1ResourceTexture_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1ResourceTexture_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1ResourceTexture_Update(This, minimumExtents, maximimumExtents, strides, dimensions, data, dataCount) \
    ((This)->lpVtbl->Update(This, minimumExtents, maximimumExtents, strides, dimensions, data, dataCount))

typedef interface ID2D1RenderInfo ID2D1RenderInfo;

typedef struct ID2D1RenderInfoVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD(SetInputDescription)(
        ID2D1RenderInfo *This,
        UINT32 inputIndex,
        D2D1_INPUT_DESCRIPTION inputDescription 
        ) PURE;
    
    STDMETHOD(SetOutputBuffer)(
        ID2D1RenderInfo *This,
        D2D1_BUFFER_PRECISION bufferPrecision,
        D2D1_CHANNEL_DEPTH channelDepth 
        ) PURE;
    
    STDMETHOD_(void, SetCached)(
        ID2D1RenderInfo *This,
        BOOL isCached 
        ) PURE;
    
    STDMETHOD_(void, SetInstructionCountHint)(
        ID2D1RenderInfo *This,
        UINT32 instructionCount 
        ) PURE;
} ID2D1RenderInfoVtbl;

interface ID2D1RenderInfo
{
    CONST struct ID2D1RenderInfoVtbl *lpVtbl;
};


#define ID2D1RenderInfo_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1RenderInfo_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1RenderInfo_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1RenderInfo_SetInputDescription(This, inputIndex, inputDescription) \
    ((This)->lpVtbl->SetInputDescription(This, inputIndex, inputDescription))

#define ID2D1RenderInfo_SetOutputBuffer(This, bufferPrecision, channelDepth) \
    ((This)->lpVtbl->SetOutputBuffer(This, bufferPrecision, channelDepth))

#define ID2D1RenderInfo_SetCached(This, isCached) \
    ((This)->lpVtbl->SetCached(This, isCached))

#define ID2D1RenderInfo_SetInstructionCountHint(This, instructionCount) \
    ((This)->lpVtbl->SetInstructionCountHint(This, instructionCount))

typedef interface ID2D1DrawInfo ID2D1DrawInfo;

typedef struct ID2D1DrawInfoVtbl
{
    
    ID2D1RenderInfoVtbl Base;
    
    
    STDMETHOD(SetPixelShaderConstantBuffer)(
        ID2D1DrawInfo *This,
        _In_reads_(bufferCount) CONST BYTE *buffer,
        UINT32 bufferCount 
        ) PURE;
    
    STDMETHOD(SetResourceTexture)(
        ID2D1DrawInfo *This,
        UINT32 textureIndex,
        _In_ ID2D1ResourceTexture *resourceTexture 
        ) PURE;
    
    STDMETHOD(SetVertexShaderConstantBuffer)(
        ID2D1DrawInfo *This,
        _In_reads_(bufferCount) CONST BYTE *buffer,
        UINT32 bufferCount 
        ) PURE;
    
    STDMETHOD(SetPixelShader)(
        ID2D1DrawInfo *This,
        _In_ REFGUID shaderId,
        D2D1_PIXEL_OPTIONS pixelOptions 
        ) PURE;
    
    STDMETHOD(SetVertexProcessing)(
        ID2D1DrawInfo *This,
        _In_opt_ ID2D1VertexBuffer *vertexBuffer,
        D2D1_VERTEX_OPTIONS vertexOptions,
        _In_opt_ CONST D2D1_BLEND_DESCRIPTION *blendDescription,
        _In_opt_ CONST D2D1_VERTEX_RANGE *vertexRange,
        _In_opt_ CONST GUID *vertexShader 
        ) PURE;
} ID2D1DrawInfoVtbl;

interface ID2D1DrawInfo
{
    CONST struct ID2D1DrawInfoVtbl *lpVtbl;
};


#define ID2D1DrawInfo_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1DrawInfo_AddRef(This) \
    ((This)->lpVtbl->Base.Base.AddRef((IUnknown *)This))

#define ID2D1DrawInfo_Release(This) \
    ((This)->lpVtbl->Base.Base.Release((IUnknown *)This))

#define ID2D1DrawInfo_SetInputDescription(This, inputIndex, inputDescription) \
    ((This)->lpVtbl->Base.SetInputDescription((ID2D1RenderInfo *)This, inputIndex, inputDescription))

#define ID2D1DrawInfo_SetOutputBuffer(This, bufferPrecision, channelDepth) \
    ((This)->lpVtbl->Base.SetOutputBuffer((ID2D1RenderInfo *)This, bufferPrecision, channelDepth))

#define ID2D1DrawInfo_SetCached(This, isCached) \
    ((This)->lpVtbl->Base.SetCached((ID2D1RenderInfo *)This, isCached))

#define ID2D1DrawInfo_SetInstructionCountHint(This, instructionCount) \
    ((This)->lpVtbl->Base.SetInstructionCountHint((ID2D1RenderInfo *)This, instructionCount))

#define ID2D1DrawInfo_SetPixelShaderConstantBuffer(This, buffer, bufferCount) \
    ((This)->lpVtbl->SetPixelShaderConstantBuffer(This, buffer, bufferCount))

#define ID2D1DrawInfo_SetResourceTexture(This, textureIndex, resourceTexture) \
    ((This)->lpVtbl->SetResourceTexture(This, textureIndex, resourceTexture))

#define ID2D1DrawInfo_SetVertexShaderConstantBuffer(This, buffer, bufferCount) \
    ((This)->lpVtbl->SetVertexShaderConstantBuffer(This, buffer, bufferCount))

#define ID2D1DrawInfo_SetPixelShader(This, shaderId, pixelOptions) \
    ((This)->lpVtbl->SetPixelShader(This, shaderId, pixelOptions))

#define ID2D1DrawInfo_SetVertexProcessing(This, vertexBuffer, vertexOptions, blendDescription, vertexRange, vertexShader) \
    ((This)->lpVtbl->SetVertexProcessing(This, vertexBuffer, vertexOptions, blendDescription, vertexRange, vertexShader))

typedef interface ID2D1ComputeInfo ID2D1ComputeInfo;

typedef struct ID2D1ComputeInfoVtbl
{
    
    ID2D1RenderInfoVtbl Base;
    
    
    STDMETHOD(SetComputeShaderConstantBuffer)(
        ID2D1ComputeInfo *This,
        _In_reads_(bufferCount) CONST BYTE *buffer,
        UINT32 bufferCount 
        ) PURE;
    
    STDMETHOD(SetComputeShader)(
        ID2D1ComputeInfo *This,
        _In_ REFGUID shaderId 
        ) PURE;
    
    STDMETHOD(SetResourceTexture)(
        ID2D1ComputeInfo *This,
        UINT32 textureIndex,
        _In_ ID2D1ResourceTexture *resourceTexture 
        ) PURE;
} ID2D1ComputeInfoVtbl;

interface ID2D1ComputeInfo
{
    CONST struct ID2D1ComputeInfoVtbl *lpVtbl;
};


#define ID2D1ComputeInfo_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1ComputeInfo_AddRef(This) \
    ((This)->lpVtbl->Base.Base.AddRef((IUnknown *)This))

#define ID2D1ComputeInfo_Release(This) \
    ((This)->lpVtbl->Base.Base.Release((IUnknown *)This))

#define ID2D1ComputeInfo_SetInputDescription(This, inputIndex, inputDescription) \
    ((This)->lpVtbl->Base.SetInputDescription((ID2D1RenderInfo *)This, inputIndex, inputDescription))

#define ID2D1ComputeInfo_SetOutputBuffer(This, bufferPrecision, channelDepth) \
    ((This)->lpVtbl->Base.SetOutputBuffer((ID2D1RenderInfo *)This, bufferPrecision, channelDepth))

#define ID2D1ComputeInfo_SetCached(This, isCached) \
    ((This)->lpVtbl->Base.SetCached((ID2D1RenderInfo *)This, isCached))

#define ID2D1ComputeInfo_SetInstructionCountHint(This, instructionCount) \
    ((This)->lpVtbl->Base.SetInstructionCountHint((ID2D1RenderInfo *)This, instructionCount))

#define ID2D1ComputeInfo_SetComputeShaderConstantBuffer(This, buffer, bufferCount) \
    ((This)->lpVtbl->SetComputeShaderConstantBuffer(This, buffer, bufferCount))

#define ID2D1ComputeInfo_SetComputeShader(This, shaderId) \
    ((This)->lpVtbl->SetComputeShader(This, shaderId))

#define ID2D1ComputeInfo_SetResourceTexture(This, textureIndex, resourceTexture) \
    ((This)->lpVtbl->SetResourceTexture(This, textureIndex, resourceTexture))

typedef interface ID2D1TransformNode ID2D1TransformNode;

typedef struct ID2D1TransformNodeVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD_(UINT32, GetInputCount)(
        ID2D1TransformNode *This 
        ) PURE;
} ID2D1TransformNodeVtbl;

interface ID2D1TransformNode
{
    CONST struct ID2D1TransformNodeVtbl *lpVtbl;
};


#define ID2D1TransformNode_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1TransformNode_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1TransformNode_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1TransformNode_GetInputCount(This) \
    ((This)->lpVtbl->GetInputCount(This))

typedef interface ID2D1TransformGraph ID2D1TransformGraph;

typedef struct ID2D1TransformGraphVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD_(UINT32, GetInputCount)(
        ID2D1TransformGraph *This 
        ) PURE;
    
    STDMETHOD(SetSingleTransformNode)(
        ID2D1TransformGraph *This,
        _In_ ID2D1TransformNode *node 
        ) PURE;
    
    STDMETHOD(AddNode)(
        ID2D1TransformGraph *This,
        _In_ ID2D1TransformNode *node 
        ) PURE;
    
    STDMETHOD(RemoveNode)(
        ID2D1TransformGraph *This,
        _In_ ID2D1TransformNode *node 
        ) PURE;
    
    STDMETHOD(SetOutputNode)(
        ID2D1TransformGraph *This,
        _In_ ID2D1TransformNode *node 
        ) PURE;
    
    STDMETHOD(ConnectNode)(
        ID2D1TransformGraph *This,
        _In_ ID2D1TransformNode *fromNode,
        _In_ ID2D1TransformNode *toNode,
        UINT32 toNodeInputIndex 
        ) PURE;
    
    STDMETHOD(ConnectToEffectInput)(
        ID2D1TransformGraph *This,
        UINT32 toEffectInputIndex,
        _In_ ID2D1TransformNode *node,
        UINT32 toNodeInputIndex 
        ) PURE;
    
    STDMETHOD_(void, Clear)(
        ID2D1TransformGraph *This 
        ) PURE;
    
    STDMETHOD(SetPassthroughGraph)(
        ID2D1TransformGraph *This,
        UINT32 effectInputIndex 
        ) PURE;
} ID2D1TransformGraphVtbl;

interface ID2D1TransformGraph
{
    CONST struct ID2D1TransformGraphVtbl *lpVtbl;
};


#define ID2D1TransformGraph_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1TransformGraph_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1TransformGraph_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1TransformGraph_GetInputCount(This) \
    ((This)->lpVtbl->GetInputCount(This))

#define ID2D1TransformGraph_SetSingleTransformNode(This, node) \
    ((This)->lpVtbl->SetSingleTransformNode(This, node))

#define ID2D1TransformGraph_AddNode(This, node) \
    ((This)->lpVtbl->AddNode(This, node))

#define ID2D1TransformGraph_RemoveNode(This, node) \
    ((This)->lpVtbl->RemoveNode(This, node))

#define ID2D1TransformGraph_SetOutputNode(This, node) \
    ((This)->lpVtbl->SetOutputNode(This, node))

#define ID2D1TransformGraph_ConnectNode(This, fromNode, toNode, toNodeInputIndex) \
    ((This)->lpVtbl->ConnectNode(This, fromNode, toNode, toNodeInputIndex))

#define ID2D1TransformGraph_ConnectToEffectInput(This, toEffectInputIndex, node, toNodeInputIndex) \
    ((This)->lpVtbl->ConnectToEffectInput(This, toEffectInputIndex, node, toNodeInputIndex))

#define ID2D1TransformGraph_Clear(This) \
    ((This)->lpVtbl->Clear(This))

#define ID2D1TransformGraph_SetPassthroughGraph(This, effectInputIndex) \
    ((This)->lpVtbl->SetPassthroughGraph(This, effectInputIndex))

typedef interface ID2D1Transform ID2D1Transform;

typedef struct ID2D1TransformVtbl
{
    
    ID2D1TransformNodeVtbl Base;
    
    
    STDMETHOD(MapOutputRectToInputRects)(
        ID2D1Transform *This,
        _In_ CONST D2D1_RECT_L *outputRect,
        _Out_writes_(inputRectsCount) D2D1_RECT_L *inputRects,
        UINT32 inputRectsCount 
        ) PURE;
    
    STDMETHOD(MapInputRectsToOutputRect)(
        ID2D1Transform *This,
        _In_reads_(inputRectCount) CONST D2D1_RECT_L *inputRects,
        _In_reads_(inputRectCount) CONST D2D1_RECT_L *inputOpaqueSubRects,
        UINT32 inputRectCount,
        _Out_ D2D1_RECT_L *outputRect,
        _Out_ D2D1_RECT_L *outputOpaqueSubRect 
        ) PURE;
    
    STDMETHOD(MapInvalidRect)(
        ID2D1Transform *This,
        UINT32 inputIndex,
        D2D1_RECT_L invalidInputRect,
        _Out_ D2D1_RECT_L *invalidOutputRect 
        ) PURE;
} ID2D1TransformVtbl;

interface ID2D1Transform
{
    CONST struct ID2D1TransformVtbl *lpVtbl;
};


#define ID2D1Transform_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1Transform_AddRef(This) \
    ((This)->lpVtbl->Base.Base.AddRef((IUnknown *)This))

#define ID2D1Transform_Release(This) \
    ((This)->lpVtbl->Base.Base.Release((IUnknown *)This))

#define ID2D1Transform_GetInputCount(This) \
    ((This)->lpVtbl->Base.GetInputCount((ID2D1TransformNode *)This))

#define ID2D1Transform_MapOutputRectToInputRects(This, outputRect, inputRects, inputRectsCount) \
    ((This)->lpVtbl->MapOutputRectToInputRects(This, outputRect, inputRects, inputRectsCount))

#define ID2D1Transform_MapInputRectsToOutputRect(This, inputRects, inputOpaqueSubRects, inputRectCount, outputRect, outputOpaqueSubRect) \
    ((This)->lpVtbl->MapInputRectsToOutputRect(This, inputRects, inputOpaqueSubRects, inputRectCount, outputRect, outputOpaqueSubRect))

#define ID2D1Transform_MapInvalidRect(This, inputIndex, invalidInputRect, invalidOutputRect) \
    ((This)->lpVtbl->MapInvalidRect(This, inputIndex, invalidInputRect, invalidOutputRect))

typedef interface ID2D1DrawTransform ID2D1DrawTransform;

typedef struct ID2D1DrawTransformVtbl
{
    
    ID2D1TransformVtbl Base;
    
    
    STDMETHOD(SetDrawInfo)(
        ID2D1DrawTransform *This,
        _In_ ID2D1DrawInfo *drawInfo 
        ) PURE;
} ID2D1DrawTransformVtbl;

interface ID2D1DrawTransform
{
    CONST struct ID2D1DrawTransformVtbl *lpVtbl;
};


#define ID2D1DrawTransform_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1DrawTransform_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1DrawTransform_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Release((IUnknown *)This))

#define ID2D1DrawTransform_GetInputCount(This) \
    ((This)->lpVtbl->Base.Base.GetInputCount((ID2D1TransformNode *)This))

#define ID2D1DrawTransform_MapOutputRectToInputRects(This, outputRect, inputRects, inputRectsCount) \
    ((This)->lpVtbl->Base.MapOutputRectToInputRects((ID2D1Transform *)This, outputRect, inputRects, inputRectsCount))

#define ID2D1DrawTransform_MapInputRectsToOutputRect(This, inputRects, inputOpaqueSubRects, inputRectCount, outputRect, outputOpaqueSubRect) \
    ((This)->lpVtbl->Base.MapInputRectsToOutputRect((ID2D1Transform *)This, inputRects, inputOpaqueSubRects, inputRectCount, outputRect, outputOpaqueSubRect))

#define ID2D1DrawTransform_MapInvalidRect(This, inputIndex, invalidInputRect, invalidOutputRect) \
    ((This)->lpVtbl->Base.MapInvalidRect((ID2D1Transform *)This, inputIndex, invalidInputRect, invalidOutputRect))

#define ID2D1DrawTransform_SetDrawInfo(This, drawInfo) \
    ((This)->lpVtbl->SetDrawInfo(This, drawInfo))

typedef interface ID2D1ComputeTransform ID2D1ComputeTransform;

typedef struct ID2D1ComputeTransformVtbl
{
    
    ID2D1TransformVtbl Base;
    
    
    STDMETHOD(SetComputeInfo)(
        ID2D1ComputeTransform *This,
        _In_ ID2D1ComputeInfo *computeInfo 
        ) PURE;
    
    STDMETHOD(CalculateThreadgroups)(
        ID2D1ComputeTransform *This,
        _In_ CONST D2D1_RECT_L *outputRect,
        _Out_ UINT32 *dimensionX,
        _Out_ UINT32 *dimensionY,
        _Out_ UINT32 *dimensionZ 
        ) PURE;
} ID2D1ComputeTransformVtbl;

interface ID2D1ComputeTransform
{
    CONST struct ID2D1ComputeTransformVtbl *lpVtbl;
};


#define ID2D1ComputeTransform_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1ComputeTransform_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1ComputeTransform_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Release((IUnknown *)This))

#define ID2D1ComputeTransform_GetInputCount(This) \
    ((This)->lpVtbl->Base.Base.GetInputCount((ID2D1TransformNode *)This))

#define ID2D1ComputeTransform_MapOutputRectToInputRects(This, outputRect, inputRects, inputRectsCount) \
    ((This)->lpVtbl->Base.MapOutputRectToInputRects((ID2D1Transform *)This, outputRect, inputRects, inputRectsCount))

#define ID2D1ComputeTransform_MapInputRectsToOutputRect(This, inputRects, inputOpaqueSubRects, inputRectCount, outputRect, outputOpaqueSubRect) \
    ((This)->lpVtbl->Base.MapInputRectsToOutputRect((ID2D1Transform *)This, inputRects, inputOpaqueSubRects, inputRectCount, outputRect, outputOpaqueSubRect))

#define ID2D1ComputeTransform_MapInvalidRect(This, inputIndex, invalidInputRect, invalidOutputRect) \
    ((This)->lpVtbl->Base.MapInvalidRect((ID2D1Transform *)This, inputIndex, invalidInputRect, invalidOutputRect))

#define ID2D1ComputeTransform_SetComputeInfo(This, computeInfo) \
    ((This)->lpVtbl->SetComputeInfo(This, computeInfo))

#define ID2D1ComputeTransform_CalculateThreadgroups(This, outputRect, dimensionX, dimensionY, dimensionZ) \
    ((This)->lpVtbl->CalculateThreadgroups(This, outputRect, dimensionX, dimensionY, dimensionZ))

typedef interface ID2D1AnalysisTransform ID2D1AnalysisTransform;

typedef struct ID2D1AnalysisTransformVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD(ProcessAnalysisResults)(
        ID2D1AnalysisTransform *This,
        _In_reads_(analysisDataCount) CONST BYTE *analysisData,
        UINT32 analysisDataCount 
        ) PURE;
} ID2D1AnalysisTransformVtbl;

interface ID2D1AnalysisTransform
{
    CONST struct ID2D1AnalysisTransformVtbl *lpVtbl;
};


#define ID2D1AnalysisTransform_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1AnalysisTransform_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1AnalysisTransform_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1AnalysisTransform_ProcessAnalysisResults(This, analysisData, analysisDataCount) \
    ((This)->lpVtbl->ProcessAnalysisResults(This, analysisData, analysisDataCount))

typedef interface ID2D1SourceTransform ID2D1SourceTransform;

typedef struct ID2D1SourceTransformVtbl
{
    
    ID2D1TransformVtbl Base;
    
    
    STDMETHOD(SetRenderInfo)(
        ID2D1SourceTransform *This,
        _In_ ID2D1RenderInfo *renderInfo 
        ) PURE;
    
    STDMETHOD(Draw)(
        ID2D1SourceTransform *This,
        _In_ ID2D1Bitmap1 *target,
        _In_ CONST D2D1_RECT_L *drawRect,
        D2D1_POINT_2U targetOrigin 
        ) PURE;
} ID2D1SourceTransformVtbl;

interface ID2D1SourceTransform
{
    CONST struct ID2D1SourceTransformVtbl *lpVtbl;
};


#define ID2D1SourceTransform_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1SourceTransform_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1SourceTransform_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Release((IUnknown *)This))

#define ID2D1SourceTransform_GetInputCount(This) \
    ((This)->lpVtbl->Base.Base.GetInputCount((ID2D1TransformNode *)This))

#define ID2D1SourceTransform_MapOutputRectToInputRects(This, outputRect, inputRects, inputRectsCount) \
    ((This)->lpVtbl->Base.MapOutputRectToInputRects((ID2D1Transform *)This, outputRect, inputRects, inputRectsCount))

#define ID2D1SourceTransform_MapInputRectsToOutputRect(This, inputRects, inputOpaqueSubRects, inputRectCount, outputRect, outputOpaqueSubRect) \
    ((This)->lpVtbl->Base.MapInputRectsToOutputRect((ID2D1Transform *)This, inputRects, inputOpaqueSubRects, inputRectCount, outputRect, outputOpaqueSubRect))

#define ID2D1SourceTransform_MapInvalidRect(This, inputIndex, invalidInputRect, invalidOutputRect) \
    ((This)->lpVtbl->Base.MapInvalidRect((ID2D1Transform *)This, inputIndex, invalidInputRect, invalidOutputRect))

#define ID2D1SourceTransform_SetRenderInfo(This, renderInfo) \
    ((This)->lpVtbl->SetRenderInfo(This, renderInfo))

#define ID2D1SourceTransform_Draw(This, target, drawRect, targetOrigin) \
    ((This)->lpVtbl->Draw(This, target, drawRect, targetOrigin))

typedef interface ID2D1ConcreteTransform ID2D1ConcreteTransform;

typedef struct ID2D1ConcreteTransformVtbl
{
    
    ID2D1TransformNodeVtbl Base;
    
    
    STDMETHOD(SetOutputBuffer)(
        ID2D1ConcreteTransform *This,
        D2D1_BUFFER_PRECISION bufferPrecision,
        D2D1_CHANNEL_DEPTH channelDepth 
        ) PURE;
    
    STDMETHOD_(void, SetCached)(
        ID2D1ConcreteTransform *This,
        BOOL isCached 
        ) PURE;
} ID2D1ConcreteTransformVtbl;

interface ID2D1ConcreteTransform
{
    CONST struct ID2D1ConcreteTransformVtbl *lpVtbl;
};


#define ID2D1ConcreteTransform_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1ConcreteTransform_AddRef(This) \
    ((This)->lpVtbl->Base.Base.AddRef((IUnknown *)This))

#define ID2D1ConcreteTransform_Release(This) \
    ((This)->lpVtbl->Base.Base.Release((IUnknown *)This))

#define ID2D1ConcreteTransform_GetInputCount(This) \
    ((This)->lpVtbl->Base.GetInputCount((ID2D1TransformNode *)This))

#define ID2D1ConcreteTransform_SetOutputBuffer(This, bufferPrecision, channelDepth) \
    ((This)->lpVtbl->SetOutputBuffer(This, bufferPrecision, channelDepth))

#define ID2D1ConcreteTransform_SetCached(This, isCached) \
    ((This)->lpVtbl->SetCached(This, isCached))

typedef interface ID2D1BlendTransform ID2D1BlendTransform;

typedef struct ID2D1BlendTransformVtbl
{
    
    ID2D1ConcreteTransformVtbl Base;
    
    
    STDMETHOD_(void, SetDescription)(
        ID2D1BlendTransform *This,
        _In_ CONST D2D1_BLEND_DESCRIPTION *description 
        ) PURE;
    
    STDMETHOD_(void, GetDescription)(
        ID2D1BlendTransform *This,
        _Out_ D2D1_BLEND_DESCRIPTION *description 
        ) PURE;
} ID2D1BlendTransformVtbl;

interface ID2D1BlendTransform
{
    CONST struct ID2D1BlendTransformVtbl *lpVtbl;
};


#define ID2D1BlendTransform_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1BlendTransform_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1BlendTransform_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Release((IUnknown *)This))

#define ID2D1BlendTransform_GetInputCount(This) \
    ((This)->lpVtbl->Base.Base.GetInputCount((ID2D1TransformNode *)This))

#define ID2D1BlendTransform_SetOutputBuffer(This, bufferPrecision, channelDepth) \
    ((This)->lpVtbl->Base.SetOutputBuffer((ID2D1ConcreteTransform *)This, bufferPrecision, channelDepth))

#define ID2D1BlendTransform_SetCached(This, isCached) \
    ((This)->lpVtbl->Base.SetCached((ID2D1ConcreteTransform *)This, isCached))

#define ID2D1BlendTransform_SetDescription(This, description) \
    ((This)->lpVtbl->SetDescription(This, description))

#define ID2D1BlendTransform_GetDescription(This, description) \
    ((This)->lpVtbl->GetDescription(This, description))

typedef interface ID2D1BorderTransform ID2D1BorderTransform;

typedef struct ID2D1BorderTransformVtbl
{
    
    ID2D1ConcreteTransformVtbl Base;
    
    
    STDMETHOD_(void, SetExtendModeX)(
        ID2D1BorderTransform *This,
        D2D1_EXTEND_MODE extendMode 
        ) PURE;
    
    STDMETHOD_(void, SetExtendModeY)(
        ID2D1BorderTransform *This,
        D2D1_EXTEND_MODE extendMode 
        ) PURE;
    
    STDMETHOD_(D2D1_EXTEND_MODE, GetExtendModeX)(
        ID2D1BorderTransform *This 
        ) PURE;
    
    STDMETHOD_(D2D1_EXTEND_MODE, GetExtendModeY)(
        ID2D1BorderTransform *This 
        ) PURE;
} ID2D1BorderTransformVtbl;

interface ID2D1BorderTransform
{
    CONST struct ID2D1BorderTransformVtbl *lpVtbl;
};


#define ID2D1BorderTransform_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1BorderTransform_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1BorderTransform_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Release((IUnknown *)This))

#define ID2D1BorderTransform_GetInputCount(This) \
    ((This)->lpVtbl->Base.Base.GetInputCount((ID2D1TransformNode *)This))

#define ID2D1BorderTransform_SetOutputBuffer(This, bufferPrecision, channelDepth) \
    ((This)->lpVtbl->Base.SetOutputBuffer((ID2D1ConcreteTransform *)This, bufferPrecision, channelDepth))

#define ID2D1BorderTransform_SetCached(This, isCached) \
    ((This)->lpVtbl->Base.SetCached((ID2D1ConcreteTransform *)This, isCached))

#define ID2D1BorderTransform_SetExtendModeX(This, extendMode) \
    ((This)->lpVtbl->SetExtendModeX(This, extendMode))

#define ID2D1BorderTransform_SetExtendModeY(This, extendMode) \
    ((This)->lpVtbl->SetExtendModeY(This, extendMode))

#define ID2D1BorderTransform_GetExtendModeX(This) \
    ((This)->lpVtbl->GetExtendModeX(This))

#define ID2D1BorderTransform_GetExtendModeY(This) \
    ((This)->lpVtbl->GetExtendModeY(This))

typedef interface ID2D1OffsetTransform ID2D1OffsetTransform;

typedef struct ID2D1OffsetTransformVtbl
{
    
    ID2D1TransformNodeVtbl Base;
    
    
    STDMETHOD_(void, SetOffset)(
        ID2D1OffsetTransform *This,
        D2D1_POINT_2L offset 
        ) PURE;
    
    STDMETHOD_(D2D1_POINT_2L, GetOffset)(
        ID2D1OffsetTransform *This 
        ) PURE;
} ID2D1OffsetTransformVtbl;

interface ID2D1OffsetTransform
{
    CONST struct ID2D1OffsetTransformVtbl *lpVtbl;
};


#define ID2D1OffsetTransform_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1OffsetTransform_AddRef(This) \
    ((This)->lpVtbl->Base.Base.AddRef((IUnknown *)This))

#define ID2D1OffsetTransform_Release(This) \
    ((This)->lpVtbl->Base.Base.Release((IUnknown *)This))

#define ID2D1OffsetTransform_GetInputCount(This) \
    ((This)->lpVtbl->Base.GetInputCount((ID2D1TransformNode *)This))

#define ID2D1OffsetTransform_SetOffset(This, offset) \
    ((This)->lpVtbl->SetOffset(This, offset))

#define ID2D1OffsetTransform_GetOffset(This) \
    ((This)->lpVtbl->GetOffset(This))

typedef interface ID2D1BoundsAdjustmentTransform ID2D1BoundsAdjustmentTransform;

typedef struct ID2D1BoundsAdjustmentTransformVtbl
{
    
    ID2D1TransformNodeVtbl Base;
    
    
    STDMETHOD_(void, SetOutputBounds)(
        ID2D1BoundsAdjustmentTransform *This,
        _In_ CONST D2D1_RECT_L *outputBounds 
        ) PURE;
    
    STDMETHOD_(void, GetOutputBounds)(
        ID2D1BoundsAdjustmentTransform *This,
        _Out_ D2D1_RECT_L *outputBounds 
        ) PURE;
} ID2D1BoundsAdjustmentTransformVtbl;

interface ID2D1BoundsAdjustmentTransform
{
    CONST struct ID2D1BoundsAdjustmentTransformVtbl *lpVtbl;
};


#define ID2D1BoundsAdjustmentTransform_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1BoundsAdjustmentTransform_AddRef(This) \
    ((This)->lpVtbl->Base.Base.AddRef((IUnknown *)This))

#define ID2D1BoundsAdjustmentTransform_Release(This) \
    ((This)->lpVtbl->Base.Base.Release((IUnknown *)This))

#define ID2D1BoundsAdjustmentTransform_GetInputCount(This) \
    ((This)->lpVtbl->Base.GetInputCount((ID2D1TransformNode *)This))

#define ID2D1BoundsAdjustmentTransform_SetOutputBounds(This, outputBounds) \
    ((This)->lpVtbl->SetOutputBounds(This, outputBounds))

#define ID2D1BoundsAdjustmentTransform_GetOutputBounds(This, outputBounds) \
    ((This)->lpVtbl->GetOutputBounds(This, outputBounds))

typedef interface ID2D1EffectImpl ID2D1EffectImpl;

typedef struct ID2D1EffectImplVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD(Initialize)(
        ID2D1EffectImpl *This,
        _In_ ID2D1EffectContext *effectContext,
        _In_ ID2D1TransformGraph *transformGraph 
        ) PURE;
    
    STDMETHOD(PrepareForRender)(
        ID2D1EffectImpl *This,
        D2D1_CHANGE_TYPE changeType 
        ) PURE;
    
    STDMETHOD(SetGraph)(
        ID2D1EffectImpl *This,
        _In_ ID2D1TransformGraph *transformGraph 
        ) PURE;
} ID2D1EffectImplVtbl;

interface ID2D1EffectImpl
{
    CONST struct ID2D1EffectImplVtbl *lpVtbl;
};


#define ID2D1EffectImpl_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1EffectImpl_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1EffectImpl_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1EffectImpl_Initialize(This, effectContext, transformGraph) \
    ((This)->lpVtbl->Initialize(This, effectContext, transformGraph))

#define ID2D1EffectImpl_PrepareForRender(This, changeType) \
    ((This)->lpVtbl->PrepareForRender(This, changeType))

#define ID2D1EffectImpl_SetGraph(This, transformGraph) \
    ((This)->lpVtbl->SetGraph(This, transformGraph))

typedef interface ID2D1EffectContext ID2D1EffectContext;

typedef struct ID2D1EffectContextVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD_(void, GetDpi)(
        ID2D1EffectContext *This,
        _Out_ FLOAT *dpiX,
        _Out_ FLOAT *dpiY 
        ) PURE;
    
    STDMETHOD(CreateEffect)(
        ID2D1EffectContext *This,
        _In_ REFCLSID effectId,
        _Outptr_ ID2D1Effect **effect 
        ) PURE;
    
    STDMETHOD(GetMaximumSupportedFeatureLevel)(
        ID2D1EffectContext *This,
        _In_reads_(featureLevelsCount) CONST D3D_FEATURE_LEVEL *featureLevels,
        UINT32 featureLevelsCount,
        _Out_ D3D_FEATURE_LEVEL *maximumSupportedFeatureLevel 
        ) PURE;
    
    STDMETHOD(CreateTransformNodeFromEffect)(
        ID2D1EffectContext *This,
        _In_ ID2D1Effect *effect,
        _Outptr_ ID2D1TransformNode **transformNode 
        ) PURE;
    
    STDMETHOD(CreateBlendTransform)(
        ID2D1EffectContext *This,
        UINT32 numInputs,
        _In_ CONST D2D1_BLEND_DESCRIPTION *blendDescription,
        _Outptr_ ID2D1BlendTransform **transform 
        ) PURE;
    
    STDMETHOD(CreateBorderTransform)(
        ID2D1EffectContext *This,
        D2D1_EXTEND_MODE extendModeX,
        D2D1_EXTEND_MODE extendModeY,
        _Outptr_ ID2D1BorderTransform **transform 
        ) PURE;
    
    STDMETHOD(CreateOffsetTransform)(
        ID2D1EffectContext *This,
        D2D1_POINT_2L offset,
        _Outptr_ ID2D1OffsetTransform **transform 
        ) PURE;
    
    STDMETHOD(CreateBoundsAdjustmentTransform)(
        ID2D1EffectContext *This,
        _In_ CONST D2D1_RECT_L *outputRectangle,
        _Outptr_ ID2D1BoundsAdjustmentTransform **transform 
        ) PURE;
    
    STDMETHOD(LoadPixelShader)(
        ID2D1EffectContext *This,
        REFGUID shaderId,
        _In_reads_(shaderBufferCount) CONST BYTE *shaderBuffer,
        UINT32 shaderBufferCount 
        ) PURE;
    
    STDMETHOD(LoadVertexShader)(
        ID2D1EffectContext *This,
        REFGUID resourceId,
        _In_reads_(shaderBufferCount) CONST BYTE *shaderBuffer,
        UINT32 shaderBufferCount 
        ) PURE;
    
    STDMETHOD(LoadComputeShader)(
        ID2D1EffectContext *This,
        REFGUID resourceId,
        _In_reads_(shaderBufferCount) CONST BYTE *shaderBuffer,
        UINT32 shaderBufferCount 
        ) PURE;
    
    STDMETHOD_(BOOL, IsShaderLoaded)(
        ID2D1EffectContext *This,
        REFGUID shaderId 
        ) PURE;
    
    STDMETHOD(CreateResourceTexture)(
        ID2D1EffectContext *This,
        _In_opt_ CONST GUID *resourceId,
        _In_ CONST D2D1_RESOURCE_TEXTURE_PROPERTIES *resourceTextureProperties,
        _In_reads_opt_(dataSize) CONST BYTE *data,
        _In_reads_opt_(resourceTextureProperties->dimensions - 1) CONST UINT32 *strides,
        UINT32 dataSize,
        _Outptr_ ID2D1ResourceTexture **resourceTexture 
        ) PURE;
    
    STDMETHOD(FindResourceTexture)(
        ID2D1EffectContext *This,
        _In_ CONST GUID *resourceId,
        _Outptr_ ID2D1ResourceTexture **resourceTexture 
        ) PURE;
    
    STDMETHOD(CreateVertexBuffer)(
        ID2D1EffectContext *This,
        _In_ CONST D2D1_VERTEX_BUFFER_PROPERTIES *vertexBufferProperties,
        _In_opt_ CONST GUID *resourceId,
        _In_opt_ CONST D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES *customVertexBufferProperties,
        _Outptr_ ID2D1VertexBuffer **buffer 
        ) PURE;
    
    STDMETHOD(FindVertexBuffer)(
        ID2D1EffectContext *This,
        _In_ CONST GUID *resourceId,
        _Outptr_ ID2D1VertexBuffer **buffer 
        ) PURE;
    
    STDMETHOD(CreateColorContext)(
        ID2D1EffectContext *This,
        D2D1_COLOR_SPACE space,
        _In_reads_opt_(profileSize) CONST BYTE *profile,
        UINT32 profileSize,
        _Outptr_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    STDMETHOD(CreateColorContextFromFilename)(
        ID2D1EffectContext *This,
        _In_ PCWSTR filename,
        _Outptr_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    STDMETHOD(CreateColorContextFromWicColorContext)(
        ID2D1EffectContext *This,
        _In_ IWICColorContext *wicColorContext,
        _Outptr_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    STDMETHOD(CheckFeatureSupport)(
        ID2D1EffectContext *This,
        D2D1_FEATURE feature,
        _Out_writes_bytes_(featureSupportDataSize) void *featureSupportData,
        UINT32 featureSupportDataSize 
        ) PURE;
    
    STDMETHOD_(BOOL, IsBufferPrecisionSupported)(
        ID2D1EffectContext *This,
        D2D1_BUFFER_PRECISION bufferPrecision 
        ) PURE;
} ID2D1EffectContextVtbl;

interface ID2D1EffectContext
{
    CONST struct ID2D1EffectContextVtbl *lpVtbl;
};


#define ID2D1EffectContext_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1EffectContext_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1EffectContext_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1EffectContext_GetDpi(This, dpiX, dpiY) \
    ((This)->lpVtbl->GetDpi(This, dpiX, dpiY))

#define ID2D1EffectContext_CreateEffect(This, effectId, effect) \
    ((This)->lpVtbl->CreateEffect(This, effectId, effect))

#define ID2D1EffectContext_GetMaximumSupportedFeatureLevel(This, featureLevels, featureLevelsCount, maximumSupportedFeatureLevel) \
    ((This)->lpVtbl->GetMaximumSupportedFeatureLevel(This, featureLevels, featureLevelsCount, maximumSupportedFeatureLevel))

#define ID2D1EffectContext_CreateTransformNodeFromEffect(This, effect, transformNode) \
    ((This)->lpVtbl->CreateTransformNodeFromEffect(This, effect, transformNode))

#define ID2D1EffectContext_CreateBlendTransform(This, numInputs, blendDescription, transform) \
    ((This)->lpVtbl->CreateBlendTransform(This, numInputs, blendDescription, transform))

#define ID2D1EffectContext_CreateBorderTransform(This, extendModeX, extendModeY, transform) \
    ((This)->lpVtbl->CreateBorderTransform(This, extendModeX, extendModeY, transform))

#define ID2D1EffectContext_CreateOffsetTransform(This, offset, transform) \
    ((This)->lpVtbl->CreateOffsetTransform(This, offset, transform))

#define ID2D1EffectContext_CreateBoundsAdjustmentTransform(This, outputRectangle, transform) \
    ((This)->lpVtbl->CreateBoundsAdjustmentTransform(This, outputRectangle, transform))

#define ID2D1EffectContext_LoadPixelShader(This, shaderId, shaderBuffer, shaderBufferCount) \
    ((This)->lpVtbl->LoadPixelShader(This, shaderId, shaderBuffer, shaderBufferCount))

#define ID2D1EffectContext_LoadVertexShader(This, resourceId, shaderBuffer, shaderBufferCount) \
    ((This)->lpVtbl->LoadVertexShader(This, resourceId, shaderBuffer, shaderBufferCount))

#define ID2D1EffectContext_LoadComputeShader(This, resourceId, shaderBuffer, shaderBufferCount) \
    ((This)->lpVtbl->LoadComputeShader(This, resourceId, shaderBuffer, shaderBufferCount))

#define ID2D1EffectContext_IsShaderLoaded(This, shaderId) \
    ((This)->lpVtbl->IsShaderLoaded(This, shaderId))

#define ID2D1EffectContext_CreateResourceTexture(This, resourceId, resourceTextureProperties, data, strides, dataSize, resourceTexture) \
    ((This)->lpVtbl->CreateResourceTexture(This, resourceId, resourceTextureProperties, data, strides, dataSize, resourceTexture))

#define ID2D1EffectContext_FindResourceTexture(This, resourceId, resourceTexture) \
    ((This)->lpVtbl->FindResourceTexture(This, resourceId, resourceTexture))

#define ID2D1EffectContext_CreateVertexBuffer(This, vertexBufferProperties, resourceId, customVertexBufferProperties, buffer) \
    ((This)->lpVtbl->CreateVertexBuffer(This, vertexBufferProperties, resourceId, customVertexBufferProperties, buffer))

#define ID2D1EffectContext_FindVertexBuffer(This, resourceId, buffer) \
    ((This)->lpVtbl->FindVertexBuffer(This, resourceId, buffer))

#define ID2D1EffectContext_CreateColorContext(This, space, profile, profileSize, colorContext) \
    ((This)->lpVtbl->CreateColorContext(This, space, profile, profileSize, colorContext))

#define ID2D1EffectContext_CreateColorContextFromFilename(This, filename, colorContext) \
    ((This)->lpVtbl->CreateColorContextFromFilename(This, filename, colorContext))

#define ID2D1EffectContext_CreateColorContextFromWicColorContext(This, wicColorContext, colorContext) \
    ((This)->lpVtbl->CreateColorContextFromWicColorContext(This, wicColorContext, colorContext))

#define ID2D1EffectContext_CheckFeatureSupport(This, feature, featureSupportData, featureSupportDataSize) \
    ((This)->lpVtbl->CheckFeatureSupport(This, feature, featureSupportData, featureSupportDataSize))

#define ID2D1EffectContext_IsBufferPrecisionSupported(This, bufferPrecision) \
    ((This)->lpVtbl->IsBufferPrecisionSupported(This, bufferPrecision))


#endif

#include <d2d1_1helper.h>
#endif // #ifndef _D2D1_EFFECT_AUTHOR_H_
