/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaAssignment_private_offset;
static gpointer vala_assignment_parent_class = NULL;

static void vala_assignment_set_left (ValaAssignment* self,
                               ValaExpression* value);
static void vala_assignment_set_operator (ValaAssignment* self,
                                   ValaAssignmentOperator value);
static void vala_assignment_set_right (ValaAssignment* self,
                                ValaExpression* value);
static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static void vala_assignment_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static void vala_assignment_check_constant_assignment (ValaAssignment* self,
                                                ValaMemberAccess* inner);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);
static GType vala_assignment_get_type_once (void);

static inline gpointer
vala_assignment_get_instance_private (ValaAssignment* self)
{
	return G_STRUCT_MEMBER_P (self, ValaAssignment_private_offset);
}

ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

static void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

static void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}

ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}

static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaAssignmentOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_assignment_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}

static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_assignment_real_get_error_types (ValaCodeNode* base,
                                      ValaCollection* collection,
                                      ValaSourceReference* source_reference)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp92_;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp97_;
	ValaExpression* _tmp249_;
	ValaExpression* _tmp250_;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp251_;
	ValaExpression* _tmp252_;
	gboolean _tmp253_ = FALSE;
	gboolean _tmp254_ = FALSE;
	ValaAssignmentOperator _tmp255_;
	ValaMemberAccess* _tmp304_;
	ValaExpression* _tmp607_;
	ValaExpression* _tmp608_;
	ValaDataType* _tmp609_;
	ValaDataType* _tmp610_;
	ValaDataType* _tmp619_;
	ValaDataType* _tmp620_;
	gboolean _tmp623_;
	gboolean _tmp624_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (VALA_IS_TUPLE (_tmp7_)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_EXPRESSION_STATEMENT (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaSemanticAnalyzer* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaBlock* _tmp29_;
		ValaDeclarationStatement* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp81_;
		ValaSemanticAnalyzer* _tmp82_;
		ValaList* _tmp83_;
		ValaCodeNode* _tmp84_;
		ValaCodeNode* _tmp85_;
		ValaExpressionStatement* _tmp86_;
		ValaExpression* _tmp87_;
		ValaExpression* _tmp88_;
		ValaExpressionStatement* _tmp89_;
		ValaExpression* _tmp90_;
		ValaExpression* _tmp91_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		tuple = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple);
		_tmp13_ = vala_code_node_get_temp_name ();
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_assignment_get_right (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_assignment_get_right (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (NULL, _tmp14_, _tmp16_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp14_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = vala_code_context_get_analyzer (context);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_->insert_block;
		_tmp30_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp29_, (ValaStatement*) _tmp30_);
		_tmp31_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp31_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp32_;
			ValaList* _tmp33_;
			gint _expr_size = 0;
			ValaList* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			gint _expr_index = 0;
			_tmp32_ = tuple;
			_tmp33_ = vala_tuple_get_expressions (_tmp32_);
			_expr_list = _tmp33_;
			_tmp34_ = _expr_list;
			_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
			_tmp36_ = _tmp35_;
			_expr_size = _tmp36_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp37_;
				gint _tmp38_;
				ValaExpression* expr = NULL;
				ValaList* _tmp39_;
				gpointer _tmp40_;
				ValaExpressionStatement* _tmp41_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				ValaExpression* _tmp50_;
				ValaExpression* _tmp51_;
				ValaSourceReference* _tmp52_;
				ValaSourceReference* _tmp53_;
				ValaMemberAccess* _tmp54_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp55_;
				ValaExpression* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValaElementAccess* _tmp59_;
				ValaElementAccess* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				ValaExpression* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaSourceReference* _tmp65_;
				ValaIntegerLiteral* _tmp66_;
				ValaIntegerLiteral* _tmp67_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp68_;
				ValaElementAccess* _tmp69_;
				ValaAssignmentOperator _tmp70_;
				ValaExpression* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaAssignment* _tmp74_;
				ValaAssignment* _tmp75_;
				ValaExpression* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaSourceReference* _tmp78_;
				ValaExpressionStatement* _tmp79_;
				gint _tmp80_;
				_expr_index = _expr_index + 1;
				_tmp37_ = _expr_index;
				_tmp38_ = _expr_size;
				if (!(_tmp37_ < _tmp38_)) {
					break;
				}
				_tmp39_ = _expr_list;
				_tmp40_ = vala_list_get (_tmp39_, _expr_index);
				expr = (ValaExpression*) _tmp40_;
				_tmp41_ = stmt;
				if (_tmp41_ != NULL) {
					ValaSemanticAnalyzer* _tmp42_;
					ValaSemanticAnalyzer* _tmp43_;
					ValaBlock* _tmp44_;
					ValaExpressionStatement* _tmp45_;
					ValaExpressionStatement* _tmp46_;
					_tmp42_ = vala_code_context_get_analyzer (context);
					_tmp43_ = _tmp42_;
					_tmp44_ = _tmp43_->insert_block;
					_tmp45_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp44_, (ValaStatement*) _tmp45_);
					_tmp46_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp46_, context);
				}
				_tmp47_ = local;
				_tmp48_ = vala_symbol_get_name ((ValaSymbol*) _tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = vala_assignment_get_right (self);
				_tmp51_ = _tmp50_;
				_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_member_access_new_simple (_tmp49_, _tmp53_);
				temp_access = _tmp54_;
				_tmp55_ = temp_access;
				_tmp56_ = expr;
				_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_element_access_new ((ValaExpression*) _tmp55_, _tmp58_);
				ea = _tmp59_;
				_tmp60_ = ea;
				_tmp61_ = g_strdup_printf ("%i", i);
				_tmp62_ = _tmp61_;
				_tmp63_ = expr;
				_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = vala_integer_literal_new (_tmp62_, _tmp65_);
				_tmp67_ = _tmp66_;
				vala_element_access_append_index (_tmp60_, (ValaExpression*) _tmp67_);
				_vala_code_node_unref0 (_tmp67_);
				_g_free0 (_tmp62_);
				_tmp68_ = expr;
				_tmp69_ = ea;
				_tmp70_ = self->priv->_operator;
				_tmp71_ = expr;
				_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_assignment_new (_tmp68_, (ValaExpression*) _tmp69_, _tmp70_, _tmp73_);
				assign = _tmp74_;
				_tmp75_ = assign;
				_tmp76_ = expr;
				_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = vala_expression_statement_new ((ValaExpression*) _tmp75_, _tmp78_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp79_;
				_tmp80_ = i;
				i = _tmp80_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
		}
		_tmp81_ = vala_code_context_get_analyzer (context);
		_tmp82_ = _tmp81_;
		_tmp83_ = _tmp82_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp83_, (ValaCodeNode*) self);
		_tmp84_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp85_ = _tmp84_;
		_tmp86_ = stmt;
		_tmp87_ = vala_expression_statement_get_expression (_tmp86_);
		_tmp88_ = _tmp87_;
		vala_code_node_replace_expression (_tmp85_, (ValaExpression*) self, _tmp88_);
		_tmp89_ = stmt;
		_tmp90_ = vala_expression_statement_get_expression (_tmp89_);
		_tmp91_ = _tmp90_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp91_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp92_ = vala_assignment_get_left (self);
	_tmp93_ = _tmp92_;
	vala_expression_set_lvalue (_tmp93_, TRUE);
	_tmp94_ = vala_assignment_get_left (self);
	_tmp95_ = _tmp94_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp95_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp96_ = vala_assignment_get_left (self);
	_tmp97_ = _tmp96_;
	if (VALA_IS_MEMBER_ACCESS (_tmp97_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp98_;
		ValaExpression* _tmp99_;
		ValaMemberAccess* _tmp100_;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		ValaMemberAccess* _tmp103_;
		ValaSymbol* _tmp104_;
		ValaSymbol* _tmp105_;
		ValaMemberAccess* _tmp121_;
		gboolean _tmp122_;
		gboolean _tmp123_;
		gboolean _tmp131_ = FALSE;
		ValaMemberAccess* _tmp132_;
		gboolean _tmp133_;
		gboolean _tmp134_;
		ValaMemberAccess* _tmp138_;
		ValaSymbol* _tmp139_;
		ValaSymbol* _tmp140_;
		ValaAttribute* _tmp141_;
		ValaMemberAccess* _tmp149_;
		ValaSymbol* _tmp150_;
		ValaSymbol* _tmp151_;
		_tmp98_ = vala_assignment_get_left (self);
		_tmp99_ = _tmp98_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp100_ = ma;
		vala_assignment_check_constant_assignment (self, _tmp100_);
		_tmp103_ = ma;
		_tmp104_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp103_);
		_tmp105_ = _tmp104_;
		if (!VALA_IS_DYNAMIC_PROPERTY (_tmp105_)) {
			ValaMemberAccess* _tmp106_;
			ValaDataType* _tmp107_;
			ValaDataType* _tmp108_;
			_tmp106_ = ma;
			_tmp107_ = vala_expression_get_value_type ((ValaExpression*) _tmp106_);
			_tmp108_ = _tmp107_;
			_tmp102_ = _tmp108_ == NULL;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			_tmp101_ = TRUE;
		} else {
			gboolean _tmp109_ = FALSE;
			gboolean _tmp110_ = FALSE;
			ValaMemberAccess* _tmp111_;
			ValaExpression* _tmp112_;
			ValaExpression* _tmp113_;
			_tmp111_ = ma;
			_tmp112_ = vala_member_access_get_inner (_tmp111_);
			_tmp113_ = _tmp112_;
			if (_tmp113_ == NULL) {
				ValaMemberAccess* _tmp114_;
				const gchar* _tmp115_;
				const gchar* _tmp116_;
				_tmp114_ = ma;
				_tmp115_ = vala_member_access_get_member_name (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp110_ = g_strcmp0 (_tmp116_, "this") == 0;
			} else {
				_tmp110_ = FALSE;
			}
			if (_tmp110_) {
				ValaSemanticAnalyzer* _tmp117_;
				ValaSemanticAnalyzer* _tmp118_;
				_tmp117_ = vala_code_context_get_analyzer (context);
				_tmp118_ = _tmp117_;
				_tmp109_ = vala_semantic_analyzer_is_in_instance_method (_tmp118_);
			} else {
				_tmp109_ = FALSE;
			}
			_tmp101_ = _tmp109_;
		}
		if (_tmp101_) {
			ValaSourceReference* _tmp119_;
			ValaSourceReference* _tmp120_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp120_ = _tmp119_;
			vala_report_error (_tmp120_, "unsupported lvalue in assignment");
			result = FALSE;
			return result;
		}
		_tmp121_ = ma;
		_tmp122_ = vala_member_access_get_prototype_access (_tmp121_);
		_tmp123_ = _tmp122_;
		if (_tmp123_) {
			ValaSourceReference* _tmp124_;
			ValaSourceReference* _tmp125_;
			ValaMemberAccess* _tmp126_;
			ValaSymbol* _tmp127_;
			ValaSymbol* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp125_ = _tmp124_;
			_tmp126_ = ma;
			_tmp127_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp126_);
			_tmp128_ = _tmp127_;
			_tmp129_ = vala_symbol_get_full_name (_tmp128_);
			_tmp130_ = _tmp129_;
			vala_report_error (_tmp125_, "Access to instance member `%s' denied", _tmp130_);
			_g_free0 (_tmp130_);
			result = FALSE;
			return result;
		}
		_tmp132_ = ma;
		_tmp133_ = vala_code_node_get_error ((ValaCodeNode*) _tmp132_);
		_tmp134_ = _tmp133_;
		if (_tmp134_) {
			_tmp131_ = TRUE;
		} else {
			ValaMemberAccess* _tmp135_;
			ValaSymbol* _tmp136_;
			ValaSymbol* _tmp137_;
			_tmp135_ = ma;
			_tmp136_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp135_);
			_tmp137_ = _tmp136_;
			_tmp131_ = _tmp137_ == NULL;
		}
		if (_tmp131_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp138_ = ma;
		_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp138_);
		_tmp140_ = _tmp139_;
		_tmp141_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp140_, "GtkChild");
		if (_tmp141_ != NULL) {
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			ValaMemberAccess* _tmp144_;
			ValaSymbol* _tmp145_;
			ValaSymbol* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp143_ = _tmp142_;
			_tmp144_ = ma;
			_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp144_);
			_tmp146_ = _tmp145_;
			_tmp147_ = vala_symbol_get_full_name (_tmp146_);
			_tmp148_ = _tmp147_;
			vala_report_error (_tmp143_, "Assignment of [GtkChild] `%s' is not allowed", _tmp148_);
			_g_free0 (_tmp148_);
			result = FALSE;
			return result;
		}
		_tmp149_ = ma;
		_tmp150_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp149_);
		_tmp151_ = _tmp150_;
		if (VALA_IS_DYNAMIC_PROPERTY (_tmp151_)) {
		} else {
			ValaExpression* _tmp152_;
			ValaExpression* _tmp153_;
			ValaMemberAccess* _tmp154_;
			ValaDataType* _tmp155_;
			ValaDataType* _tmp156_;
			ValaDataType* _tmp157_;
			ValaDataType* _tmp158_;
			ValaExpression* _tmp159_;
			ValaExpression* _tmp160_;
			ValaMemberAccess* _tmp161_;
			ValaDataType* _tmp162_;
			ValaDataType* _tmp163_;
			ValaDataType* _tmp164_;
			ValaDataType* _tmp165_;
			_tmp152_ = vala_assignment_get_right (self);
			_tmp153_ = _tmp152_;
			_tmp154_ = ma;
			_tmp155_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp154_);
			_tmp156_ = _tmp155_;
			_tmp157_ = vala_data_type_copy (_tmp156_);
			_tmp158_ = _tmp157_;
			vala_expression_set_formal_target_type (_tmp153_, _tmp158_);
			_vala_code_node_unref0 (_tmp158_);
			_tmp159_ = vala_assignment_get_right (self);
			_tmp160_ = _tmp159_;
			_tmp161_ = ma;
			_tmp162_ = vala_expression_get_value_type ((ValaExpression*) _tmp161_);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_data_type_copy (_tmp163_);
			_tmp165_ = _tmp164_;
			vala_expression_set_target_type (_tmp160_, _tmp165_);
			_vala_code_node_unref0 (_tmp165_);
		}
	} else {
		ValaExpression* _tmp166_;
		ValaExpression* _tmp167_;
		_tmp166_ = vala_assignment_get_left (self);
		_tmp167_ = _tmp166_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp167_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp168_;
			ValaExpression* _tmp169_;
			ValaElementAccess* _tmp170_;
			ValaExpression* _tmp171_;
			ValaExpression* _tmp172_;
			ValaElementAccess* _tmp173_;
			ValaExpression* _tmp174_;
			ValaExpression* _tmp175_;
			ValaDataType* _tmp176_;
			ValaDataType* _tmp177_;
			ValaTypeSymbol* _tmp178_;
			ValaTypeSymbol* _tmp179_;
			ValaSemanticAnalyzer* _tmp180_;
			ValaSemanticAnalyzer* _tmp181_;
			ValaDataType* _tmp182_;
			ValaTypeSymbol* _tmp183_;
			ValaTypeSymbol* _tmp184_;
			_tmp168_ = vala_assignment_get_left (self);
			_tmp169_ = _tmp168_;
			ea = G_TYPE_CHECK_INSTANCE_CAST (_tmp169_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
			_tmp170_ = ea;
			_tmp171_ = vala_element_access_get_container (_tmp170_);
			_tmp172_ = _tmp171_;
			vala_assignment_check_constant_assignment (self, VALA_IS_MEMBER_ACCESS (_tmp172_) ? ((ValaMemberAccess*) _tmp172_) : NULL);
			_tmp173_ = ea;
			_tmp174_ = vala_element_access_get_container (_tmp173_);
			_tmp175_ = _tmp174_;
			_tmp176_ = vala_expression_get_value_type (_tmp175_);
			_tmp177_ = _tmp176_;
			_tmp178_ = vala_data_type_get_type_symbol (_tmp177_);
			_tmp179_ = _tmp178_;
			_tmp180_ = vala_code_context_get_analyzer (context);
			_tmp181_ = _tmp180_;
			_tmp182_ = _tmp181_->string_type;
			_tmp183_ = vala_data_type_get_type_symbol (_tmp182_);
			_tmp184_ = _tmp183_;
			if (_tmp179_ == _tmp184_) {
				ValaElementAccess* _tmp185_;
				ValaSourceReference* _tmp186_;
				ValaSourceReference* _tmp187_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp185_ = ea;
				_tmp186_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp185_);
				_tmp187_ = _tmp186_;
				vala_report_error (_tmp187_, "strings are immutable");
				result = FALSE;
				return result;
			} else {
				ValaElementAccess* _tmp188_;
				ValaExpression* _tmp189_;
				ValaExpression* _tmp190_;
				ValaDataType* _tmp191_;
				ValaDataType* _tmp192_;
				ValaSymbol* _tmp193_;
				ValaSymbol* _tmp194_;
				gboolean _tmp195_;
				_tmp188_ = ea;
				_tmp189_ = vala_element_access_get_container (_tmp188_);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_expression_get_value_type (_tmp190_);
				_tmp192_ = _tmp191_;
				_tmp193_ = vala_data_type_get_member (_tmp192_, "set");
				_tmp194_ = _tmp193_;
				_tmp195_ = VALA_IS_METHOD (_tmp194_);
				_vala_code_node_unref0 (_tmp194_);
				if (_tmp195_) {
					ValaMethodCall* set_call = NULL;
					ValaElementAccess* _tmp196_;
					ValaExpression* _tmp197_;
					ValaExpression* _tmp198_;
					ValaSourceReference* _tmp199_;
					ValaSourceReference* _tmp200_;
					ValaMemberAccess* _tmp201_;
					ValaMemberAccess* _tmp202_;
					ValaSourceReference* _tmp203_;
					ValaSourceReference* _tmp204_;
					ValaMethodCall* _tmp205_;
					ValaMethodCall* _tmp206_;
					ValaMethodCall* _tmp218_;
					ValaExpression* _tmp219_;
					ValaExpression* _tmp220_;
					ValaCodeNode* _tmp221_;
					ValaCodeNode* _tmp222_;
					ValaMethodCall* _tmp223_;
					ValaMethodCall* _tmp224_;
					_tmp196_ = ea;
					_tmp197_ = vala_element_access_get_container (_tmp196_);
					_tmp198_ = _tmp197_;
					_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp200_ = _tmp199_;
					_tmp201_ = vala_member_access_new (_tmp198_, "set", _tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp204_ = _tmp203_;
					_tmp205_ = vala_method_call_new ((ValaExpression*) _tmp202_, _tmp204_);
					_tmp206_ = _tmp205_;
					_vala_code_node_unref0 (_tmp202_);
					set_call = _tmp206_;
					{
						ValaList* _e_list = NULL;
						ValaElementAccess* _tmp207_;
						ValaList* _tmp208_;
						gint _e_size = 0;
						ValaList* _tmp209_;
						gint _tmp210_;
						gint _tmp211_;
						gint _e_index = 0;
						_tmp207_ = ea;
						_tmp208_ = vala_element_access_get_indices (_tmp207_);
						_e_list = _tmp208_;
						_tmp209_ = _e_list;
						_tmp210_ = vala_collection_get_size ((ValaCollection*) _tmp209_);
						_tmp211_ = _tmp210_;
						_e_size = _tmp211_;
						_e_index = -1;
						while (TRUE) {
							gint _tmp212_;
							gint _tmp213_;
							ValaExpression* e = NULL;
							ValaList* _tmp214_;
							gpointer _tmp215_;
							ValaMethodCall* _tmp216_;
							ValaExpression* _tmp217_;
							_e_index = _e_index + 1;
							_tmp212_ = _e_index;
							_tmp213_ = _e_size;
							if (!(_tmp212_ < _tmp213_)) {
								break;
							}
							_tmp214_ = _e_list;
							_tmp215_ = vala_list_get (_tmp214_, _e_index);
							e = (ValaExpression*) _tmp215_;
							_tmp216_ = set_call;
							_tmp217_ = e;
							vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp216_, _tmp217_);
							_vala_code_node_unref0 (e);
						}
					}
					_tmp218_ = set_call;
					_tmp219_ = vala_assignment_get_right (self);
					_tmp220_ = _tmp219_;
					vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp218_, _tmp220_);
					_tmp221_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp222_ = _tmp221_;
					_tmp223_ = set_call;
					vala_code_node_replace_expression (_tmp222_, (ValaExpression*) self, (ValaExpression*) _tmp223_);
					_tmp224_ = set_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp224_, context);
					_vala_code_node_unref0 (set_call);
					return result;
				} else {
					ValaExpression* _tmp225_;
					ValaExpression* _tmp226_;
					ValaExpression* _tmp227_;
					ValaExpression* _tmp228_;
					ValaDataType* _tmp229_;
					ValaDataType* _tmp230_;
					ValaDataType* _tmp231_;
					ValaDataType* _tmp232_;
					_tmp225_ = vala_assignment_get_right (self);
					_tmp226_ = _tmp225_;
					_tmp227_ = vala_assignment_get_left (self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_expression_get_value_type (_tmp228_);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_data_type_copy (_tmp230_);
					_tmp232_ = _tmp231_;
					vala_expression_set_target_type (_tmp226_, _tmp232_);
					_vala_code_node_unref0 (_tmp232_);
				}
			}
		} else {
			ValaExpression* _tmp233_;
			ValaExpression* _tmp234_;
			_tmp233_ = vala_assignment_get_left (self);
			_tmp234_ = _tmp233_;
			if (VALA_IS_POINTER_INDIRECTION (_tmp234_)) {
				ValaExpression* _tmp235_;
				ValaExpression* _tmp236_;
				ValaExpression* _tmp237_;
				ValaExpression* _tmp238_;
				ValaDataType* _tmp239_;
				ValaDataType* _tmp240_;
				ValaDataType* _tmp241_;
				ValaDataType* _tmp242_;
				_tmp235_ = vala_assignment_get_right (self);
				_tmp236_ = _tmp235_;
				_tmp237_ = vala_assignment_get_left (self);
				_tmp238_ = _tmp237_;
				_tmp239_ = vala_expression_get_value_type (_tmp238_);
				_tmp240_ = _tmp239_;
				_tmp241_ = vala_data_type_copy (_tmp240_);
				_tmp242_ = _tmp241_;
				vala_expression_set_target_type (_tmp236_, _tmp242_);
				_vala_code_node_unref0 (_tmp242_);
			} else {
				ValaExpression* _tmp243_;
				ValaExpression* _tmp244_;
				_tmp243_ = vala_assignment_get_left (self);
				_tmp244_ = _tmp243_;
				if (VALA_IS_LITERAL (_tmp244_)) {
					ValaSourceReference* _tmp245_;
					ValaSourceReference* _tmp246_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp245_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp246_ = _tmp245_;
					vala_report_error (_tmp246_, "Literals are immutable");
					result = FALSE;
					return result;
				} else {
					ValaSourceReference* _tmp247_;
					ValaSourceReference* _tmp248_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp247_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp248_ = _tmp247_;
					vala_report_error (_tmp248_, "unsupported lvalue in assignment");
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp249_ = vala_assignment_get_right (self);
	_tmp250_ = _tmp249_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp250_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp251_ = vala_assignment_get_left (self);
	_tmp252_ = _tmp251_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp252_) ? ((ValaMemberAccess*) _tmp252_) : NULL;
	_tmp255_ = self->priv->_operator;
	if (_tmp255_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaMemberAccess* _tmp256_;
		_tmp256_ = ma;
		_tmp254_ = _tmp256_ != NULL;
	} else {
		_tmp254_ = FALSE;
	}
	if (_tmp254_) {
		gboolean _tmp257_ = FALSE;
		ValaExpression* _tmp258_;
		ValaExpression* _tmp259_;
		ValaDataType* _tmp260_;
		ValaDataType* _tmp261_;
		_tmp258_ = vala_assignment_get_left (self);
		_tmp259_ = _tmp258_;
		_tmp260_ = vala_expression_get_value_type (_tmp259_);
		_tmp261_ = _tmp260_;
		if (vala_data_type_is_non_null_simple_type (_tmp261_)) {
			ValaMemberAccess* _tmp262_;
			ValaSymbol* _tmp263_;
			ValaSymbol* _tmp264_;
			_tmp262_ = ma;
			_tmp263_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp262_);
			_tmp264_ = _tmp263_;
			_tmp257_ = VALA_IS_LOCAL_VARIABLE (_tmp264_);
		} else {
			_tmp257_ = FALSE;
		}
		_tmp253_ = !_tmp257_;
	} else {
		_tmp253_ = FALSE;
	}
	if (_tmp253_) {
		ValaMemberAccess* old_value = NULL;
		ValaMemberAccess* _tmp265_;
		ValaExpression* _tmp266_;
		ValaExpression* _tmp267_;
		ValaMemberAccess* _tmp268_;
		const gchar* _tmp269_;
		const gchar* _tmp270_;
		ValaSourceReference* _tmp271_;
		ValaSourceReference* _tmp272_;
		ValaMemberAccess* _tmp273_;
		ValaBinaryOperator bop = 0;
		ValaAssignmentOperator _tmp274_;
		ValaBinaryExpression* bin = NULL;
		ValaBinaryOperator _tmp277_;
		ValaMemberAccess* _tmp278_;
		ValaExpression* _tmp279_;
		ValaExpression* _tmp280_;
		ValaSourceReference* _tmp281_;
		ValaSourceReference* _tmp282_;
		ValaBinaryExpression* _tmp283_;
		ValaBinaryExpression* _tmp284_;
		ValaExpression* _tmp285_;
		ValaExpression* _tmp286_;
		ValaDataType* _tmp287_;
		ValaDataType* _tmp288_;
		ValaExpression* _tmp289_;
		ValaExpression* _tmp290_;
		ValaExpression* _tmp291_;
		ValaExpression* _tmp292_;
		ValaDataType* _tmp293_;
		ValaDataType* _tmp294_;
		ValaDataType* _tmp295_;
		ValaDataType* _tmp296_;
		ValaExpression* _tmp297_;
		ValaExpression* _tmp298_;
		ValaDataType* _tmp299_;
		ValaDataType* _tmp300_;
		ValaBinaryExpression* _tmp301_;
		ValaExpression* _tmp302_;
		ValaExpression* _tmp303_;
		_tmp265_ = ma;
		_tmp266_ = vala_member_access_get_inner (_tmp265_);
		_tmp267_ = _tmp266_;
		_tmp268_ = ma;
		_tmp269_ = vala_member_access_get_member_name (_tmp268_);
		_tmp270_ = _tmp269_;
		_tmp271_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp272_ = _tmp271_;
		_tmp273_ = vala_member_access_new (_tmp267_, _tmp270_, _tmp272_);
		old_value = _tmp273_;
		_tmp274_ = self->priv->_operator;
		switch (_tmp274_) {
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_OR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_AND;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_XOR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_ADD:
			{
				bop = VALA_BINARY_OPERATOR_PLUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SUB:
			{
				bop = VALA_BINARY_OPERATOR_MINUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_MUL:
			{
				bop = VALA_BINARY_OPERATOR_MUL;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_DIV:
			{
				bop = VALA_BINARY_OPERATOR_DIV;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_PERCENT:
			{
				bop = VALA_BINARY_OPERATOR_MOD;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_LEFT;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				break;
			}
			default:
			{
				ValaSourceReference* _tmp275_;
				ValaSourceReference* _tmp276_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp276_ = _tmp275_;
				vala_report_error (_tmp276_, "internal error: unsupported assignment operator");
				result = FALSE;
				_vala_code_node_unref0 (old_value);
				return result;
			}
		}
		_tmp277_ = bop;
		_tmp278_ = old_value;
		_tmp279_ = vala_assignment_get_right (self);
		_tmp280_ = _tmp279_;
		_tmp281_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp282_ = _tmp281_;
		_tmp283_ = vala_binary_expression_new (_tmp277_, (ValaExpression*) _tmp278_, _tmp280_, _tmp282_);
		bin = _tmp283_;
		_tmp284_ = bin;
		_tmp285_ = vala_assignment_get_right (self);
		_tmp286_ = _tmp285_;
		_tmp287_ = vala_expression_get_target_type (_tmp286_);
		_tmp288_ = _tmp287_;
		vala_expression_set_target_type ((ValaExpression*) _tmp284_, _tmp288_);
		_tmp289_ = vala_assignment_get_right (self);
		_tmp290_ = _tmp289_;
		_tmp291_ = vala_assignment_get_right (self);
		_tmp292_ = _tmp291_;
		_tmp293_ = vala_expression_get_target_type (_tmp292_);
		_tmp294_ = _tmp293_;
		_tmp295_ = vala_data_type_copy (_tmp294_);
		_tmp296_ = _tmp295_;
		vala_expression_set_target_type (_tmp290_, _tmp296_);
		_vala_code_node_unref0 (_tmp296_);
		_tmp297_ = vala_assignment_get_right (self);
		_tmp298_ = _tmp297_;
		_tmp299_ = vala_expression_get_target_type (_tmp298_);
		_tmp300_ = _tmp299_;
		vala_data_type_set_value_owned (_tmp300_, FALSE);
		_tmp301_ = bin;
		vala_assignment_set_right (self, (ValaExpression*) _tmp301_);
		_tmp302_ = vala_assignment_get_right (self);
		_tmp303_ = _tmp302_;
		vala_code_node_check ((ValaCodeNode*) _tmp303_, context);
		vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
		_vala_code_node_unref0 (bin);
		_vala_code_node_unref0 (old_value);
	}
	_tmp304_ = ma;
	if (_tmp304_ != NULL) {
		ValaMemberAccess* _tmp305_;
		ValaSymbol* _tmp306_;
		ValaSymbol* _tmp307_;
		gboolean _tmp424_ = FALSE;
		ValaExpression* _tmp425_;
		ValaExpression* _tmp426_;
		ValaDataType* _tmp427_;
		ValaDataType* _tmp428_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp481_;
		ValaExpression* _tmp482_;
		gboolean _tmp483_ = FALSE;
		ValaMemberAccess* _tmp484_;
		_tmp305_ = ma;
		_tmp306_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp305_);
		_tmp307_ = _tmp306_;
		if (VALA_IS_PROPERTY (_tmp307_)) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp308_;
			ValaSymbol* _tmp309_;
			ValaSymbol* _tmp310_;
			ValaDynamicProperty* dynamic_prop = NULL;
			ValaProperty* _tmp311_;
			ValaDynamicProperty* _tmp312_;
			_tmp308_ = ma;
			_tmp309_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp308_);
			_tmp310_ = _tmp309_;
			prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp310_, VALA_TYPE_PROPERTY, ValaProperty);
			_tmp311_ = prop;
			dynamic_prop = VALA_IS_DYNAMIC_PROPERTY (_tmp311_) ? ((ValaDynamicProperty*) _tmp311_) : NULL;
			_tmp312_ = dynamic_prop;
			if (_tmp312_ != NULL) {
				ValaDynamicProperty* _tmp313_;
				ValaExpression* _tmp314_;
				ValaExpression* _tmp315_;
				ValaDataType* _tmp316_;
				ValaDataType* _tmp317_;
				ValaDataType* _tmp318_;
				ValaDataType* _tmp319_;
				ValaExpression* _tmp320_;
				ValaExpression* _tmp321_;
				ValaDynamicProperty* _tmp322_;
				ValaDataType* _tmp323_;
				ValaDataType* _tmp324_;
				ValaDataType* _tmp325_;
				ValaDataType* _tmp326_;
				_tmp313_ = dynamic_prop;
				_tmp314_ = vala_assignment_get_right (self);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_expression_get_value_type (_tmp315_);
				_tmp317_ = _tmp316_;
				_tmp318_ = vala_data_type_copy (_tmp317_);
				_tmp319_ = _tmp318_;
				vala_property_set_property_type ((ValaProperty*) _tmp313_, _tmp319_);
				_vala_code_node_unref0 (_tmp319_);
				_tmp320_ = vala_assignment_get_left (self);
				_tmp321_ = _tmp320_;
				_tmp322_ = dynamic_prop;
				_tmp323_ = vala_property_get_property_type ((ValaProperty*) _tmp322_);
				_tmp324_ = _tmp323_;
				_tmp325_ = vala_data_type_copy (_tmp324_);
				_tmp326_ = _tmp325_;
				vala_expression_set_value_type (_tmp321_, _tmp326_);
				_vala_code_node_unref0 (_tmp326_);
			}
		} else {
			gboolean _tmp327_ = FALSE;
			ValaMemberAccess* _tmp328_;
			ValaSymbol* _tmp329_;
			ValaSymbol* _tmp330_;
			_tmp328_ = ma;
			_tmp329_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp328_);
			_tmp330_ = _tmp329_;
			if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp330_)) {
				ValaMemberAccess* _tmp331_;
				ValaExpression* _tmp332_;
				ValaExpression* _tmp333_;
				ValaDataType* _tmp334_;
				ValaDataType* _tmp335_;
				gboolean _tmp336_;
				gboolean _tmp337_;
				_tmp331_ = ma;
				_tmp332_ = vala_member_access_get_inner (_tmp331_);
				_tmp333_ = _tmp332_;
				_tmp334_ = vala_expression_get_value_type (_tmp333_);
				_tmp335_ = _tmp334_;
				_tmp336_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp335_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp337_ = _tmp336_;
				_tmp327_ = _tmp337_;
			} else {
				_tmp327_ = FALSE;
			}
			if (_tmp327_) {
				ValaSourceReference* _tmp338_;
				ValaSourceReference* _tmp339_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp338_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp339_ = _tmp338_;
				vala_report_error (_tmp339_, "`length' field of fixed length arrays is read-only");
				result = FALSE;
				return result;
			} else {
				gboolean _tmp340_ = FALSE;
				ValaMemberAccess* _tmp341_;
				ValaSymbol* _tmp342_;
				ValaSymbol* _tmp343_;
				_tmp341_ = ma;
				_tmp342_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp341_);
				_tmp343_ = _tmp342_;
				if (VALA_IS_VARIABLE (_tmp343_)) {
					ValaExpression* _tmp344_;
					ValaExpression* _tmp345_;
					ValaDataType* _tmp346_;
					ValaDataType* _tmp347_;
					_tmp344_ = vala_assignment_get_right (self);
					_tmp345_ = _tmp344_;
					_tmp346_ = vala_expression_get_value_type (_tmp345_);
					_tmp347_ = _tmp346_;
					_tmp340_ = VALA_IS_METHOD_TYPE (_tmp347_);
				} else {
					_tmp340_ = FALSE;
				}
				if (_tmp340_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp348_;
					ValaSymbol* _tmp349_;
					ValaSymbol* _tmp350_;
					ValaVariable* _tmp351_;
					ValaDataType* _tmp352_;
					ValaDataType* _tmp353_;
					_tmp348_ = ma;
					_tmp349_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp348_);
					_tmp350_ = _tmp349_;
					variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp350_, VALA_TYPE_VARIABLE, ValaVariable);
					_tmp351_ = variable;
					_tmp352_ = vala_variable_get_variable_type (_tmp351_);
					_tmp353_ = _tmp352_;
					if (VALA_IS_DELEGATE_TYPE (_tmp353_)) {
						ValaExpression* _tmp354_;
						ValaExpression* _tmp355_;
						ValaDataType* _tmp356_;
						ValaDataType* _tmp357_;
						ValaVariable* _tmp358_;
						ValaDataType* _tmp359_;
						ValaDataType* _tmp360_;
						_tmp354_ = vala_assignment_get_right (self);
						_tmp355_ = _tmp354_;
						_tmp356_ = vala_expression_get_value_type (_tmp355_);
						_tmp357_ = _tmp356_;
						_tmp358_ = variable;
						_tmp359_ = vala_variable_get_variable_type (_tmp358_);
						_tmp360_ = _tmp359_;
						if (!vala_data_type_compatible (_tmp357_, _tmp360_)) {
							ValaMethod* m = NULL;
							ValaExpression* _tmp361_;
							ValaExpression* _tmp362_;
							ValaSymbol* _tmp363_;
							ValaSymbol* _tmp364_;
							ValaDelegate* cb = NULL;
							ValaVariable* _tmp365_;
							ValaDataType* _tmp366_;
							ValaDataType* _tmp367_;
							ValaDelegate* _tmp368_;
							ValaDelegate* _tmp369_;
							ValaSourceReference* _tmp370_;
							ValaSourceReference* _tmp371_;
							ValaMethod* _tmp372_;
							gchar* _tmp373_;
							gchar* _tmp374_;
							ValaDelegate* _tmp375_;
							gchar* _tmp376_;
							gchar* _tmp377_;
							_tmp361_ = vala_assignment_get_right (self);
							_tmp362_ = _tmp361_;
							_tmp363_ = vala_expression_get_symbol_reference (_tmp362_);
							_tmp364_ = _tmp363_;
							m = G_TYPE_CHECK_INSTANCE_CAST (_tmp364_, VALA_TYPE_METHOD, ValaMethod);
							_tmp365_ = variable;
							_tmp366_ = vala_variable_get_variable_type (_tmp365_);
							_tmp367_ = _tmp366_;
							_tmp368_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp367_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							_tmp369_ = _tmp368_;
							cb = _tmp369_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp370_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp371_ = _tmp370_;
							_tmp372_ = m;
							_tmp373_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp372_);
							_tmp374_ = _tmp373_;
							_tmp375_ = cb;
							_tmp376_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp375_);
							_tmp377_ = _tmp376_;
							vala_report_error (_tmp371_, "Declaration of method `%s' is not compatible with delegate `%s'", _tmp374_, _tmp377_);
							_g_free0 (_tmp377_);
							_g_free0 (_tmp374_);
							result = FALSE;
							return result;
						}
					} else {
						ValaSourceReference* _tmp378_;
						ValaSourceReference* _tmp379_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp378_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp379_ = _tmp378_;
						vala_report_error (_tmp379_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						return result;
					}
				} else {
					gboolean _tmp380_ = FALSE;
					ValaMemberAccess* _tmp381_;
					ValaSymbol* _tmp382_;
					ValaSymbol* _tmp383_;
					_tmp381_ = ma;
					_tmp382_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp381_);
					_tmp383_ = _tmp382_;
					if (VALA_IS_VARIABLE (_tmp383_)) {
						ValaExpression* _tmp384_;
						ValaExpression* _tmp385_;
						ValaDataType* _tmp386_;
						ValaDataType* _tmp387_;
						_tmp384_ = vala_assignment_get_right (self);
						_tmp385_ = _tmp384_;
						_tmp386_ = vala_expression_get_value_type (_tmp385_);
						_tmp387_ = _tmp386_;
						_tmp380_ = _tmp387_ == NULL;
					} else {
						_tmp380_ = FALSE;
					}
					if (_tmp380_) {
						ValaSourceReference* _tmp388_;
						ValaSourceReference* _tmp389_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp388_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp389_ = _tmp388_;
						vala_report_error (_tmp389_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						return result;
					} else {
						ValaMemberAccess* _tmp390_;
						ValaSymbol* _tmp391_;
						ValaSymbol* _tmp392_;
						_tmp390_ = ma;
						_tmp391_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp390_);
						_tmp392_ = _tmp391_;
						if (VALA_IS_VARIABLE (_tmp392_)) {
							ValaVariable* variable = NULL;
							ValaMemberAccess* _tmp393_;
							ValaSymbol* _tmp394_;
							ValaSymbol* _tmp395_;
							ValaArrayType* variable_array_type = NULL;
							ValaVariable* _tmp396_;
							ValaDataType* _tmp397_;
							ValaDataType* _tmp398_;
							gboolean _tmp399_ = FALSE;
							gboolean _tmp400_ = FALSE;
							gboolean _tmp401_ = FALSE;
							ValaArrayType* _tmp402_;
							_tmp393_ = ma;
							_tmp394_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp393_);
							_tmp395_ = _tmp394_;
							variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp395_, VALA_TYPE_VARIABLE, ValaVariable);
							_tmp396_ = variable;
							_tmp397_ = vala_variable_get_variable_type (_tmp396_);
							_tmp398_ = _tmp397_;
							variable_array_type = VALA_IS_ARRAY_TYPE (_tmp398_) ? ((ValaArrayType*) _tmp398_) : NULL;
							_tmp402_ = variable_array_type;
							if (_tmp402_ != NULL) {
								ValaArrayType* _tmp403_;
								gboolean _tmp404_;
								gboolean _tmp405_;
								_tmp403_ = variable_array_type;
								_tmp404_ = vala_array_type_get_inline_allocated (_tmp403_);
								_tmp405_ = _tmp404_;
								_tmp401_ = _tmp405_;
							} else {
								_tmp401_ = FALSE;
							}
							if (_tmp401_) {
								ValaExpression* _tmp406_;
								ValaExpression* _tmp407_;
								_tmp406_ = vala_assignment_get_right (self);
								_tmp407_ = _tmp406_;
								_tmp400_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp407_);
							} else {
								_tmp400_ = FALSE;
							}
							if (_tmp400_) {
								ValaExpression* _tmp408_;
								ValaExpression* _tmp409_;
								ValaInitializerList* _tmp410_;
								ValaInitializerList* _tmp411_;
								_tmp408_ = vala_assignment_get_right (self);
								_tmp409_ = _tmp408_;
								_tmp410_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp409_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
								_tmp411_ = _tmp410_;
								_tmp399_ = _tmp411_ == NULL;
							} else {
								_tmp399_ = FALSE;
							}
							if (_tmp399_) {
								ValaSourceReference* _tmp412_;
								ValaSourceReference* _tmp413_;
								ValaCodeNode* _tmp414_;
								ValaCodeNode* _tmp415_;
								ValaCodeNode* _tmp416_;
								ValaCodeNode* _tmp417_;
								ValaCodeNode* _tmp418_;
								ValaCodeNode* _tmp419_;
								ValaSourceReference* _tmp420_;
								ValaSourceReference* _tmp421_;
								ValaEmptyStatement* _tmp422_;
								ValaEmptyStatement* _tmp423_;
								_tmp412_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp413_ = _tmp412_;
								vala_report_warning (_tmp413_, "Inline allocated arrays don't require an explicit instantiation");
								_tmp414_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp415_ = _tmp414_;
								_tmp416_ = vala_code_node_get_parent_node (_tmp415_);
								_tmp417_ = _tmp416_;
								_tmp418_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp419_ = _tmp418_;
								_tmp420_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp421_ = _tmp420_;
								_tmp422_ = vala_empty_statement_new (_tmp421_);
								_tmp423_ = _tmp422_;
								vala_block_replace_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp417_, VALA_TYPE_BLOCK, ValaBlock), G_TYPE_CHECK_INSTANCE_CAST (_tmp419_, VALA_TYPE_STATEMENT, ValaStatement), (ValaStatement*) _tmp423_);
								_vala_code_node_unref0 (_tmp423_);
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
		_tmp425_ = vala_assignment_get_left (self);
		_tmp426_ = _tmp425_;
		_tmp427_ = vala_expression_get_value_type (_tmp426_);
		_tmp428_ = _tmp427_;
		if (_tmp428_ != NULL) {
			ValaExpression* _tmp429_;
			ValaExpression* _tmp430_;
			ValaDataType* _tmp431_;
			ValaDataType* _tmp432_;
			_tmp429_ = vala_assignment_get_right (self);
			_tmp430_ = _tmp429_;
			_tmp431_ = vala_expression_get_value_type (_tmp430_);
			_tmp432_ = _tmp431_;
			_tmp424_ = _tmp432_ != NULL;
		} else {
			_tmp424_ = FALSE;
		}
		if (_tmp424_) {
			ValaExpression* _tmp433_;
			ValaExpression* _tmp434_;
			ValaDataType* _tmp435_;
			ValaDataType* _tmp436_;
			ValaExpression* _tmp437_;
			ValaExpression* _tmp438_;
			ValaDataType* _tmp439_;
			ValaDataType* _tmp440_;
			ValaMemberAccess* _tmp455_;
			ValaSymbol* _tmp456_;
			ValaSymbol* _tmp457_;
			_tmp433_ = vala_assignment_get_right (self);
			_tmp434_ = _tmp433_;
			_tmp435_ = vala_expression_get_value_type (_tmp434_);
			_tmp436_ = _tmp435_;
			_tmp437_ = vala_assignment_get_left (self);
			_tmp438_ = _tmp437_;
			_tmp439_ = vala_expression_get_value_type (_tmp438_);
			_tmp440_ = _tmp439_;
			if (!vala_data_type_compatible (_tmp436_, _tmp440_)) {
				ValaSourceReference* _tmp441_;
				ValaSourceReference* _tmp442_;
				ValaExpression* _tmp443_;
				ValaExpression* _tmp444_;
				ValaDataType* _tmp445_;
				ValaDataType* _tmp446_;
				gchar* _tmp447_;
				gchar* _tmp448_;
				ValaExpression* _tmp449_;
				ValaExpression* _tmp450_;
				ValaDataType* _tmp451_;
				ValaDataType* _tmp452_;
				gchar* _tmp453_;
				gchar* _tmp454_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp441_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp442_ = _tmp441_;
				_tmp443_ = vala_assignment_get_right (self);
				_tmp444_ = _tmp443_;
				_tmp445_ = vala_expression_get_value_type (_tmp444_);
				_tmp446_ = _tmp445_;
				_tmp447_ = vala_code_node_to_string ((ValaCodeNode*) _tmp446_);
				_tmp448_ = _tmp447_;
				_tmp449_ = vala_assignment_get_left (self);
				_tmp450_ = _tmp449_;
				_tmp451_ = vala_expression_get_value_type (_tmp450_);
				_tmp452_ = _tmp451_;
				_tmp453_ = vala_code_node_to_string ((ValaCodeNode*) _tmp452_);
				_tmp454_ = _tmp453_;
				vala_report_error (_tmp442_, "Assignment: Cannot convert from `%s' to `%s'", _tmp448_, _tmp454_);
				_g_free0 (_tmp454_);
				_g_free0 (_tmp448_);
				result = FALSE;
				return result;
			}
			_tmp455_ = ma;
			_tmp456_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp455_);
			_tmp457_ = _tmp456_;
			if (!VALA_IS_PROPERTY (_tmp457_)) {
				ValaExpression* _tmp458_;
				ValaExpression* _tmp459_;
				ValaDataType* _tmp460_;
				ValaDataType* _tmp461_;
				_tmp458_ = vala_assignment_get_right (self);
				_tmp459_ = _tmp458_;
				_tmp460_ = vala_expression_get_value_type (_tmp459_);
				_tmp461_ = _tmp460_;
				if (vala_data_type_is_disposable (_tmp461_)) {
					gboolean _tmp462_ = FALSE;
					ValaExpression* _tmp463_;
					ValaExpression* _tmp464_;
					ValaDataType* _tmp465_;
					ValaDataType* _tmp466_;
					_tmp463_ = vala_assignment_get_left (self);
					_tmp464_ = _tmp463_;
					_tmp465_ = vala_expression_get_value_type (_tmp464_);
					_tmp466_ = _tmp465_;
					if (!VALA_IS_POINTER_TYPE (_tmp466_)) {
						ValaExpression* _tmp467_;
						ValaExpression* _tmp468_;
						ValaDataType* _tmp469_;
						ValaDataType* _tmp470_;
						gboolean _tmp471_;
						gboolean _tmp472_;
						_tmp467_ = vala_assignment_get_left (self);
						_tmp468_ = _tmp467_;
						_tmp469_ = vala_expression_get_value_type (_tmp468_);
						_tmp470_ = _tmp469_;
						_tmp471_ = vala_data_type_get_value_owned (_tmp470_);
						_tmp472_ = _tmp471_;
						_tmp462_ = !_tmp472_;
					} else {
						_tmp462_ = FALSE;
					}
					if (_tmp462_) {
						ValaSourceReference* _tmp473_;
						ValaSourceReference* _tmp474_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp473_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp474_ = _tmp473_;
						vala_report_error (_tmp474_, "Invalid assignment from owned expression to unowned variable");
					}
				} else {
					ValaExpression* _tmp475_;
					ValaExpression* _tmp476_;
					ValaDataType* _tmp477_;
					ValaDataType* _tmp478_;
					gboolean _tmp479_;
					gboolean _tmp480_;
					_tmp475_ = vala_assignment_get_left (self);
					_tmp476_ = _tmp475_;
					_tmp477_ = vala_expression_get_value_type (_tmp476_);
					_tmp478_ = _tmp477_;
					_tmp479_ = vala_data_type_get_value_owned (_tmp478_);
					_tmp480_ = _tmp479_;
					if (_tmp480_) {
					}
				}
			}
		}
		_tmp481_ = vala_assignment_get_right (self);
		_tmp482_ = _tmp481_;
		right_ma = VALA_IS_MEMBER_ACCESS (_tmp482_) ? ((ValaMemberAccess*) _tmp482_) : NULL;
		_tmp484_ = right_ma;
		if (_tmp484_ != NULL) {
			ValaMemberAccess* _tmp485_;
			ValaSymbol* _tmp486_;
			ValaSymbol* _tmp487_;
			ValaMemberAccess* _tmp488_;
			ValaSymbol* _tmp489_;
			ValaSymbol* _tmp490_;
			_tmp485_ = ma;
			_tmp486_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp485_);
			_tmp487_ = _tmp486_;
			_tmp488_ = right_ma;
			_tmp489_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp488_);
			_tmp490_ = _tmp489_;
			_tmp483_ = _tmp487_ == _tmp490_;
		} else {
			_tmp483_ = FALSE;
		}
		if (_tmp483_) {
			gboolean _tmp491_ = FALSE;
			ValaMemberAccess* _tmp492_;
			ValaSymbol* _tmp493_;
			ValaSymbol* _tmp494_;
			_tmp492_ = ma;
			_tmp493_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp492_);
			_tmp494_ = _tmp493_;
			if (VALA_IS_LOCAL_VARIABLE (_tmp494_)) {
				_tmp491_ = TRUE;
			} else {
				ValaMemberAccess* _tmp495_;
				ValaSymbol* _tmp496_;
				ValaSymbol* _tmp497_;
				_tmp495_ = ma;
				_tmp496_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp495_);
				_tmp497_ = _tmp496_;
				_tmp491_ = VALA_IS_PARAMETER (_tmp497_);
			}
			if (_tmp491_) {
				ValaSourceReference* _tmp498_;
				ValaSourceReference* _tmp499_;
				_tmp498_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp499_ = _tmp498_;
				vala_report_warning (_tmp499_, "Assignment to same variable");
			} else {
				ValaMemberAccess* _tmp500_;
				ValaSymbol* _tmp501_;
				ValaSymbol* _tmp502_;
				_tmp500_ = ma;
				_tmp501_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp500_);
				_tmp502_ = _tmp501_;
				if (VALA_IS_FIELD (_tmp502_)) {
					ValaField* f = NULL;
					ValaMemberAccess* _tmp503_;
					ValaSymbol* _tmp504_;
					ValaSymbol* _tmp505_;
					ValaField* _tmp506_;
					ValaMemberBinding _tmp507_;
					ValaMemberBinding _tmp508_;
					_tmp503_ = ma;
					_tmp504_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp503_);
					_tmp505_ = _tmp504_;
					f = G_TYPE_CHECK_INSTANCE_CAST (_tmp505_, VALA_TYPE_FIELD, ValaField);
					_tmp506_ = f;
					_tmp507_ = vala_field_get_binding (_tmp506_);
					_tmp508_ = _tmp507_;
					if (_tmp508_ == VALA_MEMBER_BINDING_STATIC) {
						ValaSourceReference* _tmp509_;
						ValaSourceReference* _tmp510_;
						_tmp509_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp510_ = _tmp509_;
						vala_report_warning (_tmp510_, "Assignment to same variable");
					} else {
						ValaMemberAccess* ma_inner = NULL;
						ValaMemberAccess* _tmp511_;
						ValaExpression* _tmp512_;
						ValaExpression* _tmp513_;
						ValaMemberAccess* right_ma_inner = NULL;
						ValaMemberAccess* _tmp514_;
						ValaExpression* _tmp515_;
						ValaExpression* _tmp516_;
						gboolean _tmp517_ = FALSE;
						gboolean _tmp518_ = FALSE;
						gboolean _tmp519_ = FALSE;
						gboolean _tmp520_ = FALSE;
						gboolean _tmp521_ = FALSE;
						ValaMemberAccess* _tmp522_;
						_tmp511_ = ma;
						_tmp512_ = vala_member_access_get_inner (_tmp511_);
						_tmp513_ = _tmp512_;
						ma_inner = VALA_IS_MEMBER_ACCESS (_tmp513_) ? ((ValaMemberAccess*) _tmp513_) : NULL;
						_tmp514_ = right_ma;
						_tmp515_ = vala_member_access_get_inner (_tmp514_);
						_tmp516_ = _tmp515_;
						right_ma_inner = VALA_IS_MEMBER_ACCESS (_tmp516_) ? ((ValaMemberAccess*) _tmp516_) : NULL;
						_tmp522_ = ma_inner;
						if (_tmp522_ != NULL) {
							ValaMemberAccess* _tmp523_;
							const gchar* _tmp524_;
							const gchar* _tmp525_;
							_tmp523_ = ma_inner;
							_tmp524_ = vala_member_access_get_member_name (_tmp523_);
							_tmp525_ = _tmp524_;
							_tmp521_ = g_strcmp0 (_tmp525_, "this") == 0;
						} else {
							_tmp521_ = FALSE;
						}
						if (_tmp521_) {
							ValaMemberAccess* _tmp526_;
							ValaExpression* _tmp527_;
							ValaExpression* _tmp528_;
							_tmp526_ = ma_inner;
							_tmp527_ = vala_member_access_get_inner (_tmp526_);
							_tmp528_ = _tmp527_;
							_tmp520_ = _tmp528_ == NULL;
						} else {
							_tmp520_ = FALSE;
						}
						if (_tmp520_) {
							ValaMemberAccess* _tmp529_;
							_tmp529_ = right_ma_inner;
							_tmp519_ = _tmp529_ != NULL;
						} else {
							_tmp519_ = FALSE;
						}
						if (_tmp519_) {
							ValaMemberAccess* _tmp530_;
							const gchar* _tmp531_;
							const gchar* _tmp532_;
							_tmp530_ = right_ma_inner;
							_tmp531_ = vala_member_access_get_member_name (_tmp530_);
							_tmp532_ = _tmp531_;
							_tmp518_ = g_strcmp0 (_tmp532_, "this") == 0;
						} else {
							_tmp518_ = FALSE;
						}
						if (_tmp518_) {
							ValaMemberAccess* _tmp533_;
							ValaExpression* _tmp534_;
							ValaExpression* _tmp535_;
							_tmp533_ = right_ma_inner;
							_tmp534_ = vala_member_access_get_inner (_tmp533_);
							_tmp535_ = _tmp534_;
							_tmp517_ = _tmp535_ == NULL;
						} else {
							_tmp517_ = FALSE;
						}
						if (_tmp517_) {
							ValaSourceReference* _tmp536_;
							ValaSourceReference* _tmp537_;
							_tmp536_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp537_ = _tmp536_;
							vala_report_warning (_tmp537_, "Assignment to same variable");
						}
					}
				}
			}
		}
	} else {
		ValaExpression* _tmp538_;
		ValaExpression* _tmp539_;
		_tmp538_ = vala_assignment_get_left (self);
		_tmp539_ = _tmp538_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp539_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp540_;
			ValaExpression* _tmp541_;
			ValaExpression* _tmp542_;
			ValaExpression* _tmp543_;
			ValaDataType* _tmp544_;
			ValaDataType* _tmp545_;
			ValaExpression* _tmp546_;
			ValaExpression* _tmp547_;
			ValaDataType* _tmp548_;
			ValaDataType* _tmp549_;
			ValaExpression* _tmp564_;
			ValaExpression* _tmp565_;
			ValaDataType* _tmp566_;
			ValaDataType* _tmp567_;
			_tmp540_ = vala_assignment_get_left (self);
			_tmp541_ = _tmp540_;
			ea = G_TYPE_CHECK_INSTANCE_CAST (_tmp541_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
			_tmp542_ = vala_assignment_get_right (self);
			_tmp543_ = _tmp542_;
			_tmp544_ = vala_expression_get_value_type (_tmp543_);
			_tmp545_ = _tmp544_;
			_tmp546_ = vala_assignment_get_left (self);
			_tmp547_ = _tmp546_;
			_tmp548_ = vala_expression_get_value_type (_tmp547_);
			_tmp549_ = _tmp548_;
			if (!vala_data_type_compatible (_tmp545_, _tmp549_)) {
				ValaSourceReference* _tmp550_;
				ValaSourceReference* _tmp551_;
				ValaExpression* _tmp552_;
				ValaExpression* _tmp553_;
				ValaDataType* _tmp554_;
				ValaDataType* _tmp555_;
				gchar* _tmp556_;
				gchar* _tmp557_;
				ValaExpression* _tmp558_;
				ValaExpression* _tmp559_;
				ValaDataType* _tmp560_;
				ValaDataType* _tmp561_;
				gchar* _tmp562_;
				gchar* _tmp563_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp550_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp551_ = _tmp550_;
				_tmp552_ = vala_assignment_get_right (self);
				_tmp553_ = _tmp552_;
				_tmp554_ = vala_expression_get_value_type (_tmp553_);
				_tmp555_ = _tmp554_;
				_tmp556_ = vala_code_node_to_string ((ValaCodeNode*) _tmp555_);
				_tmp557_ = _tmp556_;
				_tmp558_ = vala_assignment_get_left (self);
				_tmp559_ = _tmp558_;
				_tmp560_ = vala_expression_get_value_type (_tmp559_);
				_tmp561_ = _tmp560_;
				_tmp562_ = vala_code_node_to_string ((ValaCodeNode*) _tmp561_);
				_tmp563_ = _tmp562_;
				vala_report_error (_tmp551_, "Assignment: Cannot convert from `%s' to `%s'", _tmp557_, _tmp563_);
				_g_free0 (_tmp563_);
				_g_free0 (_tmp557_);
				result = FALSE;
				return result;
			}
			_tmp564_ = vala_assignment_get_right (self);
			_tmp565_ = _tmp564_;
			_tmp566_ = vala_expression_get_value_type (_tmp565_);
			_tmp567_ = _tmp566_;
			if (vala_data_type_is_disposable (_tmp567_)) {
				ValaDataType* element_type = NULL;
				ValaElementAccess* _tmp568_;
				ValaExpression* _tmp569_;
				ValaExpression* _tmp570_;
				ValaDataType* _tmp571_;
				ValaDataType* _tmp572_;
				gboolean _tmp594_ = FALSE;
				ValaDataType* _tmp595_;
				_tmp568_ = ea;
				_tmp569_ = vala_element_access_get_container (_tmp568_);
				_tmp570_ = _tmp569_;
				_tmp571_ = vala_expression_get_value_type (_tmp570_);
				_tmp572_ = _tmp571_;
				if (VALA_IS_ARRAY_TYPE (_tmp572_)) {
					ValaArrayType* array_type = NULL;
					ValaElementAccess* _tmp573_;
					ValaExpression* _tmp574_;
					ValaExpression* _tmp575_;
					ValaDataType* _tmp576_;
					ValaDataType* _tmp577_;
					ValaArrayType* _tmp578_;
					ValaDataType* _tmp579_;
					ValaDataType* _tmp580_;
					ValaDataType* _tmp581_;
					_tmp573_ = ea;
					_tmp574_ = vala_element_access_get_container (_tmp573_);
					_tmp575_ = _tmp574_;
					_tmp576_ = vala_expression_get_value_type (_tmp575_);
					_tmp577_ = _tmp576_;
					array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp577_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
					_tmp578_ = array_type;
					_tmp579_ = vala_array_type_get_element_type (_tmp578_);
					_tmp580_ = _tmp579_;
					_tmp581_ = _vala_code_node_ref0 (_tmp580_);
					_vala_code_node_unref0 (element_type);
					element_type = _tmp581_;
				} else {
					ValaList* args = NULL;
					ValaElementAccess* _tmp582_;
					ValaExpression* _tmp583_;
					ValaExpression* _tmp584_;
					ValaDataType* _tmp585_;
					ValaDataType* _tmp586_;
					ValaList* _tmp587_;
					ValaList* _tmp588_;
					ValaList* _tmp589_;
					gint _tmp590_;
					gint _tmp591_;
					ValaList* _tmp592_;
					gpointer _tmp593_;
					_tmp582_ = ea;
					_tmp583_ = vala_element_access_get_container (_tmp582_);
					_tmp584_ = _tmp583_;
					_tmp585_ = vala_expression_get_value_type (_tmp584_);
					_tmp586_ = _tmp585_;
					_tmp587_ = vala_data_type_get_type_arguments (_tmp586_);
					_tmp588_ = _vala_iterable_ref0 (_tmp587_);
					args = _tmp588_;
					_tmp589_ = args;
					_tmp590_ = vala_collection_get_size ((ValaCollection*) _tmp589_);
					_tmp591_ = _tmp590_;
					_vala_assert (_tmp591_ == 1, "args.size == 1");
					_tmp592_ = args;
					_tmp593_ = vala_list_get (_tmp592_, 0);
					_vala_code_node_unref0 (element_type);
					element_type = (ValaDataType*) _tmp593_;
					_vala_iterable_unref0 (args);
				}
				_tmp595_ = element_type;
				if (!VALA_IS_POINTER_TYPE (_tmp595_)) {
					ValaDataType* _tmp596_;
					gboolean _tmp597_;
					gboolean _tmp598_;
					_tmp596_ = element_type;
					_tmp597_ = vala_data_type_get_value_owned (_tmp596_);
					_tmp598_ = _tmp597_;
					_tmp594_ = !_tmp598_;
				} else {
					_tmp594_ = FALSE;
				}
				if (_tmp594_) {
					ValaSourceReference* _tmp599_;
					ValaSourceReference* _tmp600_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp599_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp600_ = _tmp599_;
					vala_report_error (_tmp600_, "Invalid assignment from owned expression to unowned variable");
					result = FALSE;
					_vala_code_node_unref0 (element_type);
					return result;
				}
				_vala_code_node_unref0 (element_type);
			} else {
				ValaExpression* _tmp601_;
				ValaExpression* _tmp602_;
				ValaDataType* _tmp603_;
				ValaDataType* _tmp604_;
				gboolean _tmp605_;
				gboolean _tmp606_;
				_tmp601_ = vala_assignment_get_left (self);
				_tmp602_ = _tmp601_;
				_tmp603_ = vala_expression_get_value_type (_tmp602_);
				_tmp604_ = _tmp603_;
				_tmp605_ = vala_data_type_get_value_owned (_tmp604_);
				_tmp606_ = _tmp605_;
				if (_tmp606_) {
				}
			}
		} else {
			result = TRUE;
			return result;
		}
	}
	_tmp607_ = vala_assignment_get_left (self);
	_tmp608_ = _tmp607_;
	_tmp609_ = vala_expression_get_value_type (_tmp608_);
	_tmp610_ = _tmp609_;
	if (_tmp610_ != NULL) {
		ValaExpression* _tmp611_;
		ValaExpression* _tmp612_;
		ValaDataType* _tmp613_;
		ValaDataType* _tmp614_;
		ValaDataType* _tmp615_;
		ValaDataType* _tmp616_;
		ValaDataType* _tmp617_;
		ValaDataType* _tmp618_;
		_tmp611_ = vala_assignment_get_left (self);
		_tmp612_ = _tmp611_;
		_tmp613_ = vala_expression_get_value_type (_tmp612_);
		_tmp614_ = _tmp613_;
		_tmp615_ = vala_data_type_copy (_tmp614_);
		_tmp616_ = _tmp615_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp616_);
		_vala_code_node_unref0 (_tmp616_);
		_tmp617_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp618_ = _tmp617_;
		vala_data_type_set_value_owned (_tmp618_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp619_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp620_ = _tmp619_;
	if (_tmp620_ != NULL) {
		ValaDataType* _tmp621_;
		ValaDataType* _tmp622_;
		_tmp621_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp622_ = _tmp621_;
		vala_code_node_check ((ValaCodeNode*) _tmp622_, context);
	}
	_tmp623_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp624_ = _tmp623_;
	result = !_tmp624_;
	return result;
}

static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaBinaryExpression* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	binary = VALA_IS_BINARY_EXPRESSION (_tmp1_) ? ((ValaBinaryExpression*) _tmp1_) : NULL;
	_tmp3_ = binary;
	if (_tmp3_ != NULL) {
		ValaBinaryExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp4_ = binary;
		_tmp5_ = vala_binary_expression_get_left (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_get_value_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = VALA_IS_ARRAY_TYPE (_tmp8_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaBinaryExpression* _tmp9_;
		ValaBinaryOperator _tmp10_;
		ValaBinaryOperator _tmp11_;
		_tmp9_ = binary;
		_tmp10_ = vala_binary_expression_get_operator (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaBinaryExpression* _tmp16_;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			_tmp12_ = vala_assignment_get_left (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_expression_get_symbol_reference (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = binary;
			_tmp17_ = vala_binary_expression_get_left (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_expression_get_symbol_reference (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp15_ == _tmp20_) {
				ValaBinaryExpression* _tmp21_;
				ValaExpression* _tmp22_;
				ValaExpression* _tmp23_;
				_tmp21_ = binary;
				_tmp22_ = vala_binary_expression_get_left (_tmp21_);
				_tmp23_ = _tmp22_;
				vala_expression_set_lvalue (_tmp23_, TRUE);
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static void
vala_assignment_check_constant_assignment (ValaAssignment* self,
                                           ValaMemberAccess* inner)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		if (!(inner != NULL)) {
			break;
		}
		_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) inner);
		_tmp1_ = _tmp0_;
		if (VALA_IS_CONSTANT (_tmp1_)) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			vala_report_error (_tmp3_, "Assignment to constant after initialization");
			break;
		}
		_tmp4_ = vala_member_access_get_inner (inner);
		_tmp5_ = _tmp4_;
		if (VALA_IS_MEMBER_ACCESS (_tmp5_)) {
			ValaExpression* _tmp6_;
			ValaExpression* _tmp7_;
			_tmp6_ = vala_member_access_get_inner (inner);
			_tmp7_ = _tmp6_;
			inner = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		} else {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (inner);
			_tmp9_ = _tmp8_;
			if (VALA_IS_ELEMENT_ACCESS (_tmp9_)) {
				ValaExpression* _tmp10_;
				ValaExpression* _tmp11_;
				ValaExpression* _tmp12_;
				ValaExpression* _tmp13_;
				_tmp10_ = vala_member_access_get_inner (inner);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_element_access_get_container (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				_tmp13_ = _tmp12_;
				inner = VALA_IS_MEMBER_ACCESS (_tmp13_) ? ((ValaMemberAccess*) _tmp13_) : NULL;
			} else {
				inner = NULL;
			}
		}
	}
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaExpression* _tmp130_;
	ValaExpression* _tmp131_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	pi = VALA_IS_POINTER_INDIRECTION (_tmp5_) ? ((ValaPointerIndirection*) _tmp5_) : NULL;
	_tmp6_ = ma;
	if (_tmp6_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp13_;
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		ValaField* _tmp21_;
		gboolean instance = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		ValaAssignmentOperator _tmp36_;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		_tmp7_ = ma;
		_tmp8_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		local = VALA_IS_LOCAL_VARIABLE (_tmp9_) ? ((ValaLocalVariable*) _tmp9_) : NULL;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		param = VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL;
		_tmp13_ = ma;
		_tmp14_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp13_);
		_tmp15_ = _tmp14_;
		field = VALA_IS_FIELD (_tmp15_) ? ((ValaField*) _tmp15_) : NULL;
		_tmp16_ = ma;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
		_tmp18_ = _tmp17_;
		property = VALA_IS_PROPERTY (_tmp18_) ? ((ValaProperty*) _tmp18_) : NULL;
		_tmp21_ = field;
		if (_tmp21_ != NULL) {
			ValaField* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp22_ = field;
			_tmp23_ = vala_field_get_binding (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp20_ = _tmp24_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gboolean _tmp25_ = FALSE;
			ValaProperty* _tmp26_;
			_tmp26_ = property;
			if (_tmp26_ != NULL) {
				ValaProperty* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = property;
				_tmp28_ = vala_property_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp25_ = _tmp29_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp19_ = _tmp25_;
		}
		instance = _tmp19_;
		_tmp36_ = self->priv->_operator;
		if (_tmp36_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
			ValaLocalVariable* _tmp39_;
			_tmp39_ = local;
			if (_tmp39_ != NULL) {
				_tmp38_ = TRUE;
			} else {
				ValaParameter* _tmp40_;
				_tmp40_ = param;
				_tmp38_ = _tmp40_ != NULL;
			}
			if (_tmp38_) {
				_tmp37_ = TRUE;
			} else {
				ValaField* _tmp41_;
				_tmp41_ = field;
				_tmp37_ = _tmp41_ != NULL;
			}
			_tmp35_ = _tmp37_;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			_tmp34_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			ValaField* _tmp42_;
			_tmp42_ = field;
			_tmp33_ = !VALA_IS_ARRAY_LENGTH_FIELD (_tmp42_);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			ValaField* _tmp43_;
			_tmp43_ = field;
			_tmp32_ = !VALA_IS_DELEGATE_TARGET_FIELD (_tmp43_);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaField* _tmp44_;
			_tmp44_ = field;
			_tmp31_ = !VALA_IS_DELEGATE_DESTROY_FIELD (_tmp44_);
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			gboolean _tmp45_ = FALSE;
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			_tmp46_ = vala_assignment_get_left (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_expression_get_value_type (_tmp47_);
			_tmp49_ = _tmp48_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp49_)) {
				ValaExpression* _tmp50_;
				ValaExpression* _tmp51_;
				_tmp50_ = vala_assignment_get_right (self);
				_tmp51_ = _tmp50_;
				_tmp45_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp51_);
			} else {
				_tmp45_ = FALSE;
			}
			_tmp30_ = !_tmp45_;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			gboolean _tmp52_ = FALSE;
			ValaExpression* _tmp59_;
			ValaExpression* _tmp60_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaTargetValue* _tmp63_;
			ValaTargetValue* _tmp64_;
			ValaTargetValue* _tmp65_;
			ValaLocalVariable* _tmp66_;
			ValaCodeNode* _tmp91_;
			ValaCodeNode* _tmp92_;
			if (instance) {
				ValaMemberAccess* _tmp53_;
				ValaExpression* _tmp54_;
				ValaExpression* _tmp55_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_inner (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp52_ = _tmp55_ != NULL;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				vala_code_node_emit ((ValaCodeNode*) _tmp58_, codegen);
			}
			_tmp59_ = vala_assignment_get_right (self);
			_tmp60_ = _tmp59_;
			vala_code_node_emit ((ValaCodeNode*) _tmp60_, codegen);
			_tmp61_ = vala_assignment_get_right (self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_expression_get_target_value (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = _vala_target_value_ref0 (_tmp64_);
			new_value = _tmp65_;
			_tmp66_ = local;
			if (_tmp66_ != NULL) {
				ValaLocalVariable* _tmp67_;
				ValaTargetValue* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaSourceReference* _tmp70_;
				_tmp67_ = local;
				_tmp68_ = new_value;
				_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp70_ = _tmp69_;
				vala_code_generator_store_local (codegen, _tmp67_, _tmp68_, FALSE, _tmp70_);
			} else {
				ValaParameter* _tmp71_;
				_tmp71_ = param;
				if (_tmp71_ != NULL) {
					ValaParameter* _tmp72_;
					ValaTargetValue* _tmp73_;
					ValaSourceReference* _tmp74_;
					ValaSourceReference* _tmp75_;
					_tmp72_ = param;
					_tmp73_ = new_value;
					_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp75_ = _tmp74_;
					vala_code_generator_store_parameter (codegen, _tmp72_, _tmp73_, FALSE, _tmp75_);
				} else {
					ValaField* _tmp76_;
					_tmp76_ = field;
					if (_tmp76_ != NULL) {
						ValaTargetValue* _tmp77_ = NULL;
						gboolean _tmp78_ = FALSE;
						ValaField* _tmp87_;
						ValaTargetValue* _tmp88_;
						ValaSourceReference* _tmp89_;
						ValaSourceReference* _tmp90_;
						if (instance) {
							ValaMemberAccess* _tmp79_;
							ValaExpression* _tmp80_;
							ValaExpression* _tmp81_;
							_tmp79_ = ma;
							_tmp80_ = vala_member_access_get_inner (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp78_ = _tmp81_ != NULL;
						} else {
							_tmp78_ = FALSE;
						}
						if (_tmp78_) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							ValaTargetValue* _tmp85_;
							ValaTargetValue* _tmp86_;
							_tmp82_ = ma;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = vala_expression_get_target_value (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp77_ = _tmp86_;
						} else {
							_tmp77_ = NULL;
						}
						_tmp87_ = field;
						_tmp88_ = new_value;
						_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp90_ = _tmp89_;
						vala_code_generator_store_field (codegen, _tmp87_, _tmp77_, _tmp88_, _tmp90_);
					}
				}
			}
			_tmp91_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp92_ = _tmp91_;
			if (!VALA_IS_EXPRESSION_STATEMENT (_tmp92_)) {
				ValaLocalVariable* _tmp93_;
				_tmp93_ = local;
				if (_tmp93_ != NULL) {
					ValaLocalVariable* _tmp94_;
					ValaTargetValue* _tmp95_;
					ValaTargetValue* _tmp96_;
					_tmp94_ = local;
					_tmp95_ = vala_code_generator_load_local (codegen, _tmp94_, NULL);
					_tmp96_ = _tmp95_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp96_);
					_vala_target_value_unref0 (_tmp96_);
				} else {
					ValaParameter* _tmp97_;
					_tmp97_ = param;
					if (_tmp97_ != NULL) {
						ValaParameter* _tmp98_;
						ValaTargetValue* _tmp99_;
						ValaTargetValue* _tmp100_;
						_tmp98_ = param;
						_tmp99_ = vala_code_generator_load_parameter (codegen, _tmp98_, NULL);
						_tmp100_ = _tmp99_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp100_);
						_vala_target_value_unref0 (_tmp100_);
					} else {
						ValaField* _tmp101_;
						_tmp101_ = field;
						if (_tmp101_ != NULL) {
							ValaTargetValue* _tmp102_ = NULL;
							gboolean _tmp103_ = FALSE;
							ValaField* _tmp112_;
							ValaTargetValue* _tmp113_;
							ValaTargetValue* _tmp114_;
							if (instance) {
								ValaMemberAccess* _tmp104_;
								ValaExpression* _tmp105_;
								ValaExpression* _tmp106_;
								_tmp104_ = ma;
								_tmp105_ = vala_member_access_get_inner (_tmp104_);
								_tmp106_ = _tmp105_;
								_tmp103_ = _tmp106_ != NULL;
							} else {
								_tmp103_ = FALSE;
							}
							if (_tmp103_) {
								ValaMemberAccess* _tmp107_;
								ValaExpression* _tmp108_;
								ValaExpression* _tmp109_;
								ValaTargetValue* _tmp110_;
								ValaTargetValue* _tmp111_;
								_tmp107_ = ma;
								_tmp108_ = vala_member_access_get_inner (_tmp107_);
								_tmp109_ = _tmp108_;
								_tmp110_ = vala_expression_get_target_value (_tmp109_);
								_tmp111_ = _tmp110_;
								_tmp102_ = _tmp111_;
							} else {
								_tmp102_ = NULL;
							}
							_tmp112_ = field;
							_tmp113_ = vala_code_generator_load_field (codegen, _tmp112_, _tmp102_, NULL);
							_tmp114_ = _tmp113_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp114_);
							_vala_target_value_unref0 (_tmp114_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			return;
		}
		if (instance) {
			ValaMemberAccess* _tmp117_;
			ValaExpression* _tmp118_;
			ValaExpression* _tmp119_;
			_tmp117_ = ma;
			_tmp118_ = vala_member_access_get_inner (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp116_ = _tmp119_ != NULL;
		} else {
			_tmp116_ = FALSE;
		}
		if (_tmp116_) {
			ValaProperty* _tmp120_;
			_tmp120_ = property;
			_tmp115_ = _tmp120_ != NULL;
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			ValaMemberAccess* _tmp121_;
			ValaExpression* _tmp122_;
			ValaExpression* _tmp123_;
			_tmp121_ = ma;
			_tmp122_ = vala_member_access_get_inner (_tmp121_);
			_tmp123_ = _tmp122_;
			vala_code_node_emit ((ValaCodeNode*) _tmp123_, codegen);
		} else {
			ValaProperty* _tmp124_;
			_tmp124_ = property;
			if (_tmp124_ == NULL) {
				ValaMemberAccess* _tmp125_;
				_tmp125_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp125_, codegen);
			}
		}
	} else {
		ValaElementAccess* _tmp126_;
		_tmp126_ = ea;
		if (_tmp126_ != NULL) {
			ValaElementAccess* _tmp127_;
			_tmp127_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp127_, codegen);
		} else {
			ValaPointerIndirection* _tmp128_;
			_tmp128_ = pi;
			if (_tmp128_ != NULL) {
				ValaPointerIndirection* _tmp129_;
				_tmp129_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp129_, codegen);
			}
		}
	}
	_tmp130_ = vala_assignment_get_right (self);
	_tmp131_ = _tmp130_;
	vala_code_node_emit ((ValaCodeNode*) _tmp131_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaLocalVariable* _tmp12_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp7_) ? ((ValaLocalVariable*) _tmp7_) : NULL;
	_tmp8_ = vala_assignment_get_left (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_expression_get_symbol_reference (_tmp9_);
	_tmp11_ = _tmp10_;
	param = VALA_IS_PARAMETER (_tmp11_) ? ((ValaParameter*) _tmp11_) : NULL;
	_tmp12_ = local;
	if (_tmp12_ != NULL) {
		ValaLocalVariable* _tmp13_;
		_tmp13_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp13_);
	} else {
		gboolean _tmp14_ = FALSE;
		ValaParameter* _tmp15_;
		_tmp15_ = param;
		if (_tmp15_ != NULL) {
			ValaParameter* _tmp16_;
			ValaParameterDirection _tmp17_;
			ValaParameterDirection _tmp18_;
			_tmp16_ = param;
			_tmp17_ = vala_parameter_get_direction (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaParameter* _tmp19_;
			_tmp19_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp19_);
		}
	}
}

static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMemberAccess* _tmp5_;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp5_ = ma;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		_tmp6_ = ma;
		_tmp7_ = vala_member_access_get_inner (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaMemberAccess* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp9_ = ma;
		_tmp10_ = vala_member_access_get_inner (_tmp9_);
		_tmp11_ = _tmp10_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
	} else {
		ValaElementAccess* _tmp12_;
		_tmp12_ = ea;
		if (_tmp12_ != NULL) {
			ValaElementAccess* _tmp13_;
			_tmp13_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
		}
	}
	_tmp14_ = vala_assignment_get_right (self);
	_tmp15_ = _tmp14_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
}

static void
vala_assignment_class_init (ValaAssignmentClass * klass,
                            gpointer klass_data)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_adjust_private_offset (klass, &ValaAssignment_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_assignment_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}

static void
vala_assignment_instance_init (ValaAssignment * self,
                               gpointer klass)
{
	self->priv = vala_assignment_get_instance_private (self);
}

static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}

/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
static GType
vala_assignment_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
	GType vala_assignment_type_id;
	vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
	ValaAssignment_private_offset = g_type_add_instance_private (vala_assignment_type_id, sizeof (ValaAssignmentPrivate));
	return vala_assignment_type_id;
}

GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		GType vala_assignment_type_id;
		vala_assignment_type_id = vala_assignment_get_type_once ();
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}

const gchar*
vala_assignment_operator_to_string (ValaAssignmentOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_assignment_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
	GType vala_assignment_operator_type_id;
	vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
	return vala_assignment_operator_type_id;
}

GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = vala_assignment_operator_get_type_once ();
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}

