# ![Network](../images/icons/connect.png) Network

See also: [authentication](../Usage/Authentication.md), [encryption](./Encryption.md) and [multicast DNS](./Multicast-DNS.md)


## Connection Types
| Type                 | Bind option  | Availability                                                                              | Information                                                                                         |
|----------------------|--------------|-------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------|
| `TCP`                | `bind-tcp`   | All                                                                                       |
| [QUIC](./QUIC.md)    | `bind-quic`  | All                                                                                       |
| [SSL](./SSL.md)      | `bind-ssl`   | All                                                                                       |
| [SSH](./SSH.md)      | `bind-ssh`   | All                                                                                       |
| `WebSocket`          | `bind-ws`    | All                                                                                       |
| `Secure WebSocket`   | `bind-wss`   | All                                                                                       |
| `RFB`                | `bind-rfb`   | [desktop](../Usage/Start-Desktop.md) and [shadow](../Usage/Shadow-Server.md) servers only | Allows VNC clients to connect                                                                       |
| `unix domain socket` | `bind`       | Posix                                                                                     | Local connections or via [SSH](./SSH.md)                                                            |
| `named-pipe`         | `bind`       | MS Windows                                                                                | [#1150](https://github.com/Xpra-org/xpra/issues/1150)                                               |
| `vsock`              | `bind-vsock` | Linux                                                                                     | host - guest virtual machines connections - see [#983](https://github.com/Xpra-org/xpra/issues/983) |

`TCP` sockets can also be upgraded transparently to (`Secure`) `WebSocket`, `SSL`, `SSH` and `RFB`, so a single `TCP` port can support 6 different protocols automatically.\
Unencrypted modes like plain-`TCP` and plain-`WebSocket` can also be secured with [AES](./AES.md).\
All the sockets that can be accessed via a network connection (all but `vsock` and `named-pipe`) will usually be published via [multicast DNS](./Multicast-DNS.md). On Posix, `unix-domain-sockets` are exposed as `SSH` as we assume that a local SSH server is always available.  

See also: [Security Considerations](../Usage/Security.md)

## Examples:
<details>
  <summary>TCP Upgrade to WebSocket</summary>

```shell
xpra start --start=xterm --bind-tcp=0.0.0.0:10000
```
```shell
xpra attach ws://localhost:10000/
```
The same address (10000 here) can also be opened in a browser to use the HTML5 client:
```shell
xdg-open http://localhost:10000/
```
</details>

<details>
  <summary>SSH with password file</summary>

```shell
echo -n thepassword > password.txt
xpra start --start=xterm --bind-ssh=0.0.0.0:10000,auth=file:filename=password.txt
```
```shell
xpra attach ssh://localhost:10000/
```
The client will prompt for the password, as found in the `password.txt` file and not the regular shell account password.
</details>

***

## Network Performance
Xpra will try to detect your network adapter and connection characteristics and it should adapt to changing network capacity and performance.
However, it may not always get it right and you may need to turn off bandwidth detection (`bandwidth-detection` option) and / or specify your own bandwidth constraints. (`bandwidth-limit` option).

You can see how much bandwidth is used and how good the picture latency is using the "Graphs" tab of the "Session Info" dialog found in Xpra's system tray menu:

![Session Info : Graphs](../images/session-info-graphs.png)

More network information is available elsewhere in the "Session Info" dialog or via the "xpra info" command:
</details>

<details>
  <summary>network latency via xpra info</summary>

```
$ xpra info | egrep -i "network|latency"
(..)
client.latency.50p=3
client.latency.80p=3
client.latency.90p=3
client.latency.absmin=1
(..)
```
</details>

The performance of xpra will be affected by your network connection speed, in particular [bufferbloat](https://en.wikipedia.org/wiki/Bufferbloat) is known to cause severe performance degradations as xpra is quite sensitive to network jitter and latency, try to [eliminate bufferbloat in your network](https://www.bufferbloat.net/projects/bloat/wiki/What_can_I_do_about_Bufferbloat/).

QUIC should offer the lowest latency, though it may need [some tuning](https://github.com/Xpra-org/xpra/issues/3376).

See [A little bump in the wire that makes your Internet faster](https://apenwarr.ca/log/?m=201808), [bufferbloat faq](https://gettys.wordpress.com/bufferbloat-faq/).

For Linux systems, [Queueing in the Linux Network Stack](http://www.coverfire.com/articles/queueing-in-the-linux-network-stack/) is recommended reading.
