.TH XScreenSaver 1 "10-May-97" "X Version 11"
.SH NAME
rd-bomb \- reaction/diffusion textures
.SH SYNOPSIS
.B rd-bomb
[\-display \fIhost:display.screen\fP] [\-foreground \fIcolor\fP]
[\-background \fIcolor\fP] [\-window] [\-root] [\-install]
[\-visual \fIvisual\fP] [\-width \fIn\fP] [\-height \fIn\fP]
[\-reaction \fIn\fP] [\-diffusion \fIn\fP]
[\-size \fIf\fP] [\-speed \fIf\fP] [\-delay \fImillisecs\fP]
[\-fps]
.SH DESCRIPTION

The \fIrd-bomb\fP program draws reaction/diffusion textures.
.SH OPTIONS
If one of the reaction, diffusion, radius, and palette options is set
to a negative value, then that option will be set to a random
appropriate value.

Be sure to try "-speed 1 -size 0.1 -epoch 3000".

.I rd-bomb
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-width \fIn\fP
.TP 8
.B \-height \fIn\fP
Specify the size of the tile, in pixels.
.TP 8
.B \-reaction \fIn\fP
.TP 8
.B \-diffusion \fIn\fP
These are constants in the equations that effect its visual nature.
Each may be one of 0, 1, or 2. Default is -1: these constants are
chosen randomly.
.TP 8
.B \-radius \fIn\fP
Size of the seed.
.TP 8
.B \-size \fIf\fP
What fraction of the window is actively drawn, a floating point number
between 0 (exclusive) and 1 (inclusive).  Default is 1.0.
.TP 8
.B \-speed \fIf\fP
When a fraction of the screen is active, the active area moves at this
rate (a floating point number).  Default is zero.  Suggested value: 1.0.
.TP 8
.B \-delay \fImillisecs\fP
How many milliseconds to delay between frames; default 1, or 
about 1/1000th of a second.
.TP 8
.B \-fps
Display the current frame rate and CPU load.
.SH HISTORY
The code is derived from the 'd' mode of the "Bomb" visual musical
instrument, also by Scott Draves.  The equations come from Xmorphia,
which is based on a version of the Gray-Scott model taken from:
.PP
John E. Pearson "Complex Patterns in a Simple System"
.br
Science, 261,189, 9 July 1993.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.br
https://scottdraves.com/bomb.html
.br
https://web.archive.org/web/19981206145216/http%3A//www.ccsf.caltech.edu/ismap/image.html
.SH COPYRIGHT
Copyright \(co 1997 by Scott Draves.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation. 
.SH AUTHOR
Scott Draves <spot@cs.cmu.edu>, Sep 1997
