'\"
'\" Copyright (c) 2004 Joe English
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH ttk::style n 8.5 Tk "Tk Themed Widget"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
ttk::style \- Manipulate style database
.SH SYNOPSIS
\fBttk::style\fR \fIoption\fR ?\fIargs\fR?
.BE
.SH NOTES
.PP
See also the Tcl'2004 conference presentation,
available at https://tktable.sourceforge.net/tile/tile-tcl2004.pdf
.SH DEFINITIONS
.PP
Each widget is assigned a \fIstyle\fR,
which specifies the set of elements making up the widget
and how they are arranged, along with dynamic and default
settings for element options.
By default, the style name is the same as the widget's class;
this may be overridden by the \fB\-style\fR option.
.PP
A \fItheme\fR is a collection of elements and styles
which controls the overall look and feel of an application.
.SH DESCRIPTION
.PP
The \fBttk::style\fR command takes the following arguments:
.TP
\fBttk::style configure \fIstyle\fR ?\fI\-option\fR ?\fIvalue option value...\fR? ?
Sets the default value of the specified option(s) in \fIstyle\fR.
.TP
\fBttk::style element\fR \fIargs\fR
.RS
.TP
\fBttk::style element create\fR \fIelementName\fR \fItype\fR ?\fIargs...\fR?
Creates a new element in the current theme of type \fItype\fR.
The only cross-platform built-in element type is \fIimage\fR
(see \fBttk_image\fR(n)) but themes may define other element types
(see \fBTtk_RegisterElementFactory\fR). On suitable versions of Windows
an element factory is registered to create Windows theme elements
(see \fBttk_vsapi\fR(n)).
.TP
\fBttk::style element names\fR
Returns the list of elements defined in the current theme.
.TP
\fBttk::style element options \fIelement\fR
Returns the list of \fIelement\fR's options.
.RE
.TP
\fBttk::style layout \fIstyle\fR ?\fIlayoutSpec\fR?
Define the widget layout for style \fIstyle\fR.
See \fBLAYOUTS\fR below for the format of \fIlayoutSpec\fR.
If \fIlayoutSpec\fR is omitted, return the layout specification
for style \fIstyle\fR.
.TP
\fBttk::style lookup \fIstyle\fR \fI\-option \fR?\fIstate \fR?\fIdefault\fR??
Returns the value specified for \fI\-option\fR in style \fIstyle\fR
in state \fIstate\fR, using the standard lookup rules for element options.
\fIstate\fR is a list of state names; if omitted,
it defaults to all bits off (the
.QW normal
state).
If the \fIdefault\fR argument is present, it is used as a fallback
value in case no specification for \fI\-option\fR is found.
.\" Otherwise -- signal error? return empty string? Leave unspecified for now.
.TP
\fBttk::style map \fIstyle\fR ?\fI\-option\fB { \fIstatespec value...\fB }\fR?
Sets dynamic values of the specified option(s) in \fIstyle\fR.
Each \fIstatespec / value\fR pair is examined in order;
the value corresponding to the first matching \fIstatespec\fR
is used.
.TP
\fBttk::style theme\fR \fIargs\fR
.RS
.TP
\fBttk::style theme create\fR \fIthemeName\fR ?\fB\-parent \fIbasedon\fR? ?\fB\-settings \fIscript...\fR ?
Creates a new theme.  It is an error if \fIthemeName\fR already exists.
If \fB\-parent\fR is specified, the new theme will inherit
styles, elements, and layouts from the parent theme \fIbasedon\fR.
If \fB\-settings\fR is present, \fIscript\fR is evaluated in the
context of the new theme as per \fBttk::style theme settings\fR.
.TP
\fBttk::style theme names\fR
Returns a list of all known themes.
.TP
\fBttk::style theme settings \fIthemeName\fR \fIscript\fR
Temporarily sets the current theme to \fIthemeName\fR,
evaluate \fIscript\fR, then restore the previous theme.
Typically \fIscript\fR simply defines styles and elements,
though arbitrary Tcl code may appear.
.TP
\fBttk::style theme use\fR ?\fIthemeName\fR?
Without an argument the result is the name of the current theme.
Otherwise this command sets the current theme to \fIthemeName\fR,
and refreshes all widgets.
.RE
.SH LAYOUTS
.PP
A \fIlayout\fR specifies a list of elements, each followed
by one or more options specifying how to arrange the element.
The layout mechanism uses a simplified version of the \fBpack\fR
geometry manager: given an initial cavity,
each element is allocated a parcel.
Then the parcel actually used by the element is adjusted within
the allocated parcel.
Valid options are:
.\" -border should remain undocumented for now (dubious usefulness)
.\" .TP
.\" \fB\-border\fR \fIboolean\fR
.\" Specifies whether the element is drawn after its children. Defaults to 0.
.TP
\fB\-children { \fIsublayout...\fB }\fR
Specifies a list of elements to place inside the element.
.TP
\fB\-expand\fR \fIboolean\fR
Specifies whether the allocated parcel is the entire cavity. If so,
simultaneous specification of \fB\-side\fR is ignored.
Defaults to 0.
.TP
\fB\-side \fIside\fR
Specifies which side of the cavity to place the element;
one of \fBleft\fR, \fBright\fR, \fBtop\fR, or \fBbottom\fR.
For instance, \fB\-side top\fR allocates the parcel along the top of
the cavity having width and height respectively the width of the cavity
and the height of the element.
If omitted, the allocated parcel is the entire cavity (same effect
as \fB\-expand\fR 1).
.TP
\fB\-sticky\fR \fB[\fInswe\fB]\fR
Specifies the actual parcel position and size inside the allocated parcel.
If specified as an empty string then the actual parcel is centered in
the allocated parcel. Default is \fBnswe\fR. 
.\" -unit should remain undocumented for now (dubious usefulness)
.\" .TP
.\" \fB\-unit\fR \fIboolean\fR
.\" Specifies whether the element propagates its state to its children.
.\" Defaults to 0.
.PP
For example:
.CS
ttk::style layout Horizontal.TScrollbar {
    Scrollbar.trough \-children {
        Scrollbar.leftarrow \-side left
        Scrollbar.rightarrow \-side right
        Horizontal.Scrollbar.thumb \-side left \-sticky ew
    }
}
.CE
.SH "SEE ALSO"
ttk::intro(n), ttk::widget(n), photo(n), ttk_image(n)
.SH KEYWORDS
style, theme, appearance
'\" Local Variables:
'\" mode: nroff
'\" End:
