#!/bin/bash -ue

for arg in "$@"; do
	shift
	case "$arg" in
		"--filter")	set -- "$@" "-f" ;;
		*)		set -- "$@" "$arg"
	esac
done

filter="cat"

while getopts 'f:' OPTION; do
	case "$OPTION" in
		f)
			filter="$OPTARG" ;;
		*)
			echo "Usage: $0 [ -f filter ] fromdir todir" >&2
			exit 1 ;;
	esac
done

# Remove all options passed by getopts options
shift "$(($OPTIND -1))"

[[ "$#" -lt 2 ]] && { echo "Usage: $0 [ -f filter ] fromdir todir" >&2; exit 1; }
[[ -d $1 ]] ||  { echo "$1 is not a directory.";exit 1; }
( cd $1 && find . -type d          | eval $filter | xargs -I F mkdir -p $2/F )
( cd $1 && find . -type l -xtype d | eval $filter | xargs -I F cp -a $1/F $2/F )
( cd $1 && find . -type l -xtype f | eval $filter | xargs -I F ln -sfr $1/F $2/F )
( cd $1 && find . -type f          | eval $filter | xargs -I F ln -sfr $1/F $2/F )
