"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupEvents = setupEvents;
exports.addThreadEventListeners = addThreadEventListeners;
exports.removeThreadEventListeners = removeThreadEventListeners;
exports.attachAllTargets = attachAllTargets;
exports.ensureSourceActor = ensureSourceActor;
exports.clientEvents = void 0;

var _actions = _interopRequireDefault(require("../../actions/index"));

loader.lazyRequireGetter(this, "_create", "devtools/client/debugger/src/client/firefox/create");

var _sourceQueue = _interopRequireDefault(require("../../utils/source-queue"));

loader.lazyRequireGetter(this, "_telemetry", "devtools/client/debugger/src/utils/telemetry");
loader.lazyRequireGetter(this, "_prefs", "devtools/client/debugger/src/utils/prefs");
loader.lazyRequireGetter(this, "_selectors", "devtools/client/debugger/src/selectors/index");
loader.lazyRequireGetter(this, "_sourceActors", "devtools/client/debugger/src/reducers/source-actors");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at <http://mozilla.org/MPL/2.0/>. */
let actions;
let isInterrupted;
let threadFrontListeners;
let store;

function addThreadEventListeners(thread) {
  const removeListeners = [];
  Object.keys(clientEvents).forEach(eventName => {
    // EventEmitter.on returns a function that removes the event listener.
    removeListeners.push(thread.on(eventName, clientEvents[eventName].bind(null, thread)));
  });
  threadFrontListeners.set(thread, removeListeners);
}

function removeThreadEventListeners(thread) {
  const removeListeners = threadFrontListeners.get(thread) || [];

  for (const removeListener of removeListeners) {
    removeListener();
  }
}

function attachAllTargets(currentTarget) {
  return _prefs.prefs.fission && currentTarget.isParentProcess;
}

function setupEvents(dependencies) {
  actions = dependencies.actions;

  _sourceQueue.default.initialize(actions);

  store = dependencies.store;
  threadFrontListeners = new WeakMap();
}

async function paused(threadFront, packet) {
  // If paused by an explicit interrupt, which are generated by the
  // slow script dialog and internal events such as setting
  // breakpoints, ignore the event.
  const {
    why
  } = packet;

  if (why.type === "interrupted" && !packet.why.onNext) {
    isInterrupted = true;
    return;
  } // Ignore attached events because they are not useful to the user.


  if (why.type == "alreadyPaused" || why.type == "attached") {
    return;
  }

  if (packet.frame) {
    // When reloading we might receive a pause event before the
    // top frame's source has arrived.
    await ensureSourceActor(packet.frame.where.actor);
  }

  const pause = (0, _create.createPause)(threadFront.actor, packet);
  actions.paused(pause);
  (0, _telemetry.recordEvent)("pause", {
    reason: why.type
  });
}

function resumed(threadFront) {
  // NOTE: the client suppresses resumed events while interrupted
  // to prevent unintentional behavior.
  // see [client docs](../README.md#interrupted) for more information.
  if (isInterrupted) {
    isInterrupted = false;
    return;
  }

  actions.resumed(threadFront.actorID);
}
/**
 * This method wait for the given source is registered in Redux store.
 *
 * @param {String} sourceActor
 *                 Actor ID of the source to be waiting for.
 */


async function ensureSourceActor(sourceActor) {
  const sourceActorId = (0, _sourceActors.stringToSourceActorId)(sourceActor);

  if (!(0, _selectors.hasSourceActor)(store.getState(), sourceActorId)) {
    await new Promise(resolve => {
      const unsubscribe = store.subscribe(check);
      let currentState = null;

      function check() {
        const previousState = currentState;
        currentState = store.getState().sourceActors.values;

        if (previousState == currentState) {
          return;
        }

        if ((0, _selectors.hasSourceActor)(store.getState(), sourceActorId)) {
          unsubscribe();
          resolve();
        }
      }
    });
  }
}

const clientEvents = {
  paused,
  resumed
};
exports.clientEvents = clientEvents;