/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

ChromeUtils.defineModuleGetter(this, "Services", "resource://gre/modules/Services.jsm");
ChromeUtils.defineModuleGetter(this, "AddonManager", "resource://gre/modules/AddonManager.jsm");

this.EXPORTED_SYMBOLS = ["AppConstants"];

// Immutable for export.
this.AppConstants = Object.freeze({
  // See this wiki page for more details about channel specific build
  // defines: https://wiki.mozilla.org/Platform/Channel-specific_build_defines
  NIGHTLY_BUILD:
//@line 23 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 25 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  FENNEC_NIGHTLY:
//@line 30 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 32 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  RELEASE_OR_BETA:
//@line 35 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 39 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  EARLY_BETA_OR_EARLIER:
//@line 44 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 46 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  ACCESSIBILITY:
//@line 49 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 53 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  // Official corresponds, roughly, to whether this build is performed
  // on Mozilla's continuous integration infrastructure. You should
  // disable developer-only functionality when this flag is set.
  MOZILLA_OFFICIAL:
//@line 61 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 63 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_OFFICIAL_BRANDING:
//@line 68 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 70 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_DEV_EDITION:
//@line 75 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 77 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_SYNC:
//@line 82 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 84 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_HEALTHREPORT:
//@line 87 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 91 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_DATA_REPORTING:
//@line 94 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 98 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_SANDBOX:
//@line 101 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 105 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_REPORTING:
//@line 110 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 112 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_ON_BY_DEFAULT:
//@line 117 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 119 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_UPDATER:
//@line 124 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 126 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_SWITCHBOARD:
//@line 131 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 133 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_WEBRTC:
//@line 136 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 140 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_WIDGET_GTK:
//@line 143 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 147 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  XP_UNIX:
//@line 150 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 154 "$SRCDIR/toolkit/modules/AppConstants.jsm"

// NOTE! XP_LINUX has to go after MOZ_WIDGET_ANDROID otherwise Android
// builds will be misidentified as linux.
  platform:
//@line 159 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  "linux",
//@line 171 "$SRCDIR/toolkit/modules/AppConstants.jsm"

// Most of our frontend code assumes that any desktop Unix platform
// is "linux". Add the distinction for code that needs it.
  unixstyle:
//@line 176 "$SRCDIR/toolkit/modules/AppConstants.jsm"
    "linux",
//@line 188 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  isPlatformAndVersionAtLeast(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) >= 0;
  },

  isPlatformAndVersionAtMost(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) <= 0;
  },

  MOZ_CRASHREPORTER:
//@line 205 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 207 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_NORMANDY:
//@line 210 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 214 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_MAINTENANCE_SERVICE:
//@line 219 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 221 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_UPDATE_AGENT:
//@line 226 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 228 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_BITS_DOWNLOAD:
//@line 233 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 235 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  DEBUG:
//@line 240 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 242 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  ASAN:
//@line 247 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 249 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  ASAN_REPORTER:
//@line 254 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 256 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  TSAN:
//@line 261 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 263 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_SYSTEM_NSS:
//@line 266 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 270 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_PLACES:
//@line 273 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 277 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_REQUIRE_SIGNING:
//@line 282 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 284 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  get MOZ_UNSIGNED_SCOPES() {
    let result = 0;
//@line 293 "$SRCDIR/toolkit/modules/AppConstants.jsm"
    return result;
  },

  MOZ_ALLOW_ADDON_SIDELOAD:
//@line 300 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 302 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MENUBAR_CAN_AUTOHIDE:
//@line 305 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 309 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_HISTORY:
//@line 314 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  false,
//@line 316 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_GECKO_PROFILER:
//@line 319 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  true,
//@line 323 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  DLL_PREFIX: "lib",
  DLL_SUFFIX: ".so",

  MOZ_APP_NAME: "firefox",
  MOZ_APP_BASENAME: "Firefox",
  MOZ_APP_VERSION: "86.0.1",
  MOZ_APP_VERSION_DISPLAY: "86.0.1",
  MOZ_BUILDID: "20220405022927",
  MOZ_BUILD_APP: "browser",
  MOZ_MACBUNDLE_NAME: "Nightly.app",
  MOZ_UPDATE_CHANNEL: "default",
  MOZ_WIDGET_TOOLKIT: "gtk",
  ANDROID_PACKAGE_NAME: "org.mozilla.firefox",

  DEBUG_JS_MODULES: "",

  MOZ_BING_API_CLIENTID: "no-bing-api-clientid",
  MOZ_BING_API_KEY: "no-bing-api-key",
  MOZ_GOOGLE_LOCATION_SERVICE_API_KEY: "no-google-location-service-api-key",
  MOZ_GOOGLE_SAFEBROWSING_API_KEY: "no-google-safebrowsing-api-key",
  MOZ_MOZILLA_API_KEY: "no-mozilla-api-key",

  BROWSER_CHROME_URL: "chrome://browser/content/browser.xhtml",

  OMNIJAR_NAME: "omni.ja",

  // URL to the hg revision this was built from (e.g.
  // "https://hg.mozilla.org/mozilla-central/rev/6256ec9113c1")
  // On unofficial builds, this is an empty string.
//@line 356 "$SRCDIR/toolkit/modules/AppConstants.jsm"
  SOURCE_REVISION_URL: "",

  HAVE_USR_LIB64_DIR:
//@line 362 "$SRCDIR/toolkit/modules/AppConstants.jsm"
    false,
//@line 364 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  HAVE_SHELL_SERVICE:
//@line 367 "$SRCDIR/toolkit/modules/AppConstants.jsm"
    true,
//@line 371 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_CODE_COVERAGE:
//@line 376 "$SRCDIR/toolkit/modules/AppConstants.jsm"
    false,
//@line 378 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  TELEMETRY_PING_FORMAT_VERSION: 4,

  MOZ_NEW_XULSTORE:
//@line 385 "$SRCDIR/toolkit/modules/AppConstants.jsm"
    false,
//@line 387 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_NEW_NOTIFICATION_STORE:
//@line 392 "$SRCDIR/toolkit/modules/AppConstants.jsm"
    false,
//@line 394 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  ENABLE_REMOTE_AGENT:
//@line 397 "$SRCDIR/toolkit/modules/AppConstants.jsm"
    true,
//@line 401 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_RUST_FXA_CLIENT:
//@line 406 "$SRCDIR/toolkit/modules/AppConstants.jsm"
    false,
//@line 408 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  REMOTE_SETTINGS_VERIFY_SIGNATURE:
//@line 413 "$SRCDIR/toolkit/modules/AppConstants.jsm"
    true,
//@line 415 "$SRCDIR/toolkit/modules/AppConstants.jsm"

  MOZ_GLEAN:
//@line 418 "$SRCDIR/toolkit/modules/AppConstants.jsm"
    true,
//@line 422 "$SRCDIR/toolkit/modules/AppConstants.jsm"
});
