// Code generated by protoc-gen-go. DO NOT EDIT.
// source: grpc/gcp/handshaker.proto

package grpc_gcp // import "google.golang.org/grpc/credentials/alts/internal/proto/grpc_gcp"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type HandshakeProtocol int32

const (
	// Default value.
	HandshakeProtocol_HANDSHAKE_PROTOCOL_UNSPECIFIED HandshakeProtocol = 0
	// TLS handshake protocol.
	HandshakeProtocol_TLS HandshakeProtocol = 1
	// Application Layer Transport Security handshake protocol.
	HandshakeProtocol_ALTS HandshakeProtocol = 2
)

var HandshakeProtocol_name = map[int32]string{
	0: "HANDSHAKE_PROTOCOL_UNSPECIFIED",
	1: "TLS",
	2: "ALTS",
}
var HandshakeProtocol_value = map[string]int32{
	"HANDSHAKE_PROTOCOL_UNSPECIFIED": 0,
	"TLS":                            1,
	"ALTS":                           2,
}

func (x HandshakeProtocol) String() string {
	return proto.EnumName(HandshakeProtocol_name, int32(x))
}
func (HandshakeProtocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_handshaker_cd0a1186560da71f, []int{0}
}

type NetworkProtocol int32

const (
	NetworkProtocol_NETWORK_PROTOCOL_UNSPECIFIED NetworkProtocol = 0
	NetworkProtocol_TCP                          NetworkProtocol = 1
	NetworkProtocol_UDP                          NetworkProtocol = 2
)

var NetworkProtocol_name = map[int32]string{
	0: "NETWORK_PROTOCOL_UNSPECIFIED",
	1: "TCP",
	2: "UDP",
}
var NetworkProtocol_value = map[string]int32{
	"NETWORK_PROTOCOL_UNSPECIFIED": 0,
	"TCP":                          1,
	"UDP":                          2,
}

func (x NetworkProtocol) String() string {
	return proto.EnumName(NetworkProtocol_name, int32(x))
}
func (NetworkProtocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_handshaker_cd0a1186560da71f, []int{1}
}

type Endpoint struct {
	// IP address. It should contain an IPv4 or IPv6 string literal, e.g.
	// "192.168.0.1" or "2001:db8::1".
	IpAddress string `protobuf:"bytes,1,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// Port number.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Network protocol (e.g., TCP, UDP) associated with this endpoint.
	Protocol             NetworkProtocol `protobuf:"varint,3,opt,name=protocol,proto3,enum=grpc.gcp.NetworkProtocol" json:"protocol,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Endpoint) Reset()         { *m = Endpoint{} }
func (m *Endpoint) String() string { return proto.CompactTextString(m) }
func (*Endpoint) ProtoMessage()    {}
func (*Endpoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_handshaker_cd0a1186560da71f, []int{0}
}
func (m *Endpoint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Endpoint.Unmarshal(m, b)
}
func (m *Endpoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Endpoint.Marshal(b, m, deterministic)
}
func (dst *Endpoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Endpoint.Merge(dst, src)
}
func (m *Endpoint) XXX_Size() int {
	return xxx_messageInfo_Endpoint.Size(m)
}
func (m *Endpoint) XXX_DiscardUnknown() {
	xxx_messageInfo_Endpoint.DiscardUnknown(m)
}

var xxx_messageInfo_Endpoint proto.InternalMessageInfo

func (m *Endpoint) GetIpAddress() string {
	if m != nil {
		return m.IpAddress
	}
	return ""
}

func (m *Endpoint) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Endpoint) GetProtocol() NetworkProtocol {
	if m != nil {
		return m.Protocol
	}
	return NetworkProtocol_NETWORK_PROTOCOL_UNSPECIFIED
}

type Identity struct {
	// Types that are valid to be assigned to IdentityOneof:
	//	*Identity_ServiceAccount
	//	*Identity_Hostname
	IdentityOneof        isIdentity_IdentityOneof `protobuf_oneof:"identity_oneof"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Identity) Reset()         { *m = Identity{} }
func (m *Identity) String() string { return proto.CompactTextString(m) }
func (*Identity) ProtoMessage()    {}
func (*Identity) Descriptor() ([]byte, []int) {
	return fileDescriptor_handshaker_cd0a1186560da71f, []int{1}
}
func (m *Identity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Identity.Unmarshal(m, b)
}
func (m *Identity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Identity.Marshal(b, m, deterministic)
}
func (dst *Identity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Identity.Merge(dst, src)
}
func (m *Identity) XXX_Size() int {
	return xxx_messageInfo_Identity.Size(m)
}
func (m *Identity) XXX_DiscardUnknown() {
	xxx_messageInfo_Identity.DiscardUnknown(m)
}

var xxx_messageInfo_Identity proto.InternalMessageInfo

type isIdentity_IdentityOneof interface {
	isIdentity_IdentityOneof()
}

type Identity_ServiceAccount struct {
	ServiceAccount string `protobuf:"bytes,1,opt,name=service_account,json=serviceAccount,proto3,oneof"`
}

type Identity_Hostname struct {
	Hostname string `protobuf:"bytes,2,opt,name=hostname,proto3,oneof"`
}

func (*Identity_ServiceAccount) isIdentity_IdentityOneof() {}

func (*Identity_Hostname) isIdentity_IdentityOneof() {}

func (m *Identity) GetIdentityOneof() isIdentity_IdentityOneof {
	if m != nil {
		return m.IdentityOneof
	}
	return nil
}

func (m *Identity) GetServiceAccount() string {
	if x, ok := m.GetIdentityOneof().(*Identity_ServiceAccount); ok {
		return x.ServiceAccount
	}
	return ""
}

func (m *Identity) GetHostname() string {
	if x, ok := m.GetIdentityOneof().(*Identity_Hostname); ok {
		return x.Hostname
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Identity) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Identity_OneofMarshaler, _Identity_OneofUnmarshaler, _Identity_OneofSizer, []interface{}{
		(*Identity_ServiceAccount)(nil),
		(*Identity_Hostname)(nil),
	}
}

func _Identity_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Identity)
	// identity_oneof
	switch x := m.IdentityOneof.(type) {
	case *Identity_ServiceAccount:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ServiceAccount)
	case *Identity_Hostname:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Hostname)
	case nil:
	default:
		return fmt.Errorf("Identity.IdentityOneof has unexpected type %T", x)
	}
	return nil
}

func _Identity_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Identity)
	switch tag {
	case 1: // identity_oneof.service_account
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.IdentityOneof = &Identity_ServiceAccount{x}
		return true, err
	case 2: // identity_oneof.hostname
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.IdentityOneof = &Identity_Hostname{x}
		return true, err
	default:
		return false, nil
	}
}

func _Identity_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Identity)
	// identity_oneof
	switch x := m.IdentityOneof.(type) {
	case *Identity_ServiceAccount:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ServiceAccount)))
		n += len(x.ServiceAccount)
	case *Identity_Hostname:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Hostname)))
		n += len(x.Hostname)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type StartClientHandshakeReq struct {
	// Handshake security protocol requested by the client.
	HandshakeSecurityProtocol HandshakeProtocol `protobuf:"varint,1,opt,name=handshake_security_protocol,json=handshakeSecurityProtocol,proto3,enum=grpc.gcp.HandshakeProtocol" json:"handshake_security_protocol,omitempty"`
	// The application protocols supported by the client, e.g., "h2" (for http2),
	// "grpc".
	ApplicationProtocols []string `protobuf:"bytes,2,rep,name=application_protocols,json=applicationProtocols,proto3" json:"application_protocols,omitempty"`
	// The record protocols supported by the client, e.g.,
	// "ALTSRP_GCM_AES128".
	RecordProtocols []string `protobuf:"bytes,3,rep,name=record_protocols,json=recordProtocols,proto3" json:"record_protocols,omitempty"`
	// (Optional) Describes which server identities are acceptable by the client.
	// If target identities are provided and none of them matches the peer
	// identity of the server, handshake will fail.
	TargetIdentities []*Identity `protobuf:"bytes,4,rep,name=target_identities,json=targetIdentities,proto3" json:"target_identities,omitempty"`
	// (Optional) Application may specify a local identity. Otherwise, the
	// handshaker chooses a default local identity.
	LocalIdentity *Identity `protobuf:"bytes,5,opt,name=local_identity,json=localIdentity,proto3" json:"local_identity,omitempty"`
	// (Optional) Local endpoint information of the connection to the server,
	// such as local IP address, port number, and network protocol.
	LocalEndpoint *Endpoint `protobuf:"bytes,6,opt,name=local_endpoint,json=localEndpoint,proto3" json:"local_endpoint,omitempty"`
	// (Optional) Endpoint information of the remote server, such as IP address,
	// port number, and network protocol.
	RemoteEndpoint *Endpoint `protobuf:"bytes,7,opt,name=remote_endpoint,json=remoteEndpoint,proto3" json:"remote_endpoint,omitempty"`
	// (Optional) If target name is provided, a secure naming check is performed
	// to verify that the peer authenticated identity is indeed authorized to run
	// the target name.
	TargetName string `protobuf:"bytes,8,opt,name=target_name,json=targetName,proto3" json:"target_name,omitempty"`
	// (Optional) RPC protocol versions supported by the client.
	RpcVersions          *RpcProtocolVersions `protobuf:"bytes,9,opt,name=rpc_versions,json=rpcVersions,proto3" json:"rpc_versions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StartClientHandshakeReq) Reset()         { *m = StartClientHandshakeReq{} }
func (m *StartClientHandshakeReq) String() string { return proto.CompactTextString(m) }
func (*StartClientHandshakeReq) ProtoMessage()    {}
func (*StartClientHandshakeReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_handshaker_cd0a1186560da71f, []int{2}
}
func (m *StartClientHandshakeReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClientHandshakeReq.Unmarshal(m, b)
}
func (m *StartClientHandshakeReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClientHandshakeReq.Marshal(b, m, deterministic)
}
func (dst *StartClientHandshakeReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClientHandshakeReq.Merge(dst, src)
}
func (m *StartClientHandshakeReq) XXX_Size() int {
	return xxx_messageInfo_StartClientHandshakeReq.Size(m)
}
func (m *StartClientHandshakeReq) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClientHandshakeReq.DiscardUnknown(m)
}

var xxx_messageInfo_StartClientHandshakeReq proto.InternalMessageInfo

func (m *StartClientHandshakeReq) GetHandshakeSecurityProtocol() HandshakeProtocol {
	if m != nil {
		return m.HandshakeSecurityProtocol
	}
	return HandshakeProtocol_HANDSHAKE_PROTOCOL_UNSPECIFIED
}

func (m *StartClientHandshakeReq) GetApplicationProtocols() []string {
	if m != nil {
		return m.ApplicationProtocols
	}
	return nil
}

func (m *StartClientHandshakeReq) GetRecordProtocols() []string {
	if m != nil {
		return m.RecordProtocols
	}
	return nil
}

func (m *StartClientHandshakeReq) GetTargetIdentities() []*Identity {
	if m != nil {
		return m.TargetIdentities
	}
	return nil
}

func (m *StartClientHandshakeReq) GetLocalIdentity() *Identity {
	if m != nil {
		return m.LocalIdentity
	}
	return nil
}

func (m *StartClientHandshakeReq) GetLocalEndpoint() *Endpoint {
	if m != nil {
		return m.LocalEndpoint
	}
	return nil
}

func (m *StartClientHandshakeReq) GetRemoteEndpoint() *Endpoint {
	if m != nil {
		return m.RemoteEndpoint
	}
	return nil
}

func (m *StartClientHandshakeReq) GetTargetName() string {
	if m != nil {
		return m.TargetName
	}
	return ""
}

func (m *StartClientHandshakeReq) GetRpcVersions() *RpcProtocolVersions {
	if m != nil {
		return m.RpcVersions
	}
	return nil
}

type ServerHandshakeParameters struct {
	// The record protocols supported by the server, e.g.,
	// "ALTSRP_GCM_AES128".
	RecordProtocols []string `protobuf:"bytes,1,rep,name=record_protocols,json=recordProtocols,proto3" json:"record_protocols,omitempty"`
	// (Optional) A list of local identities supported by the server, if
	// specified. Otherwise, the handshaker chooses a default local identity.
	LocalIdentities      []*Identity `protobuf:"bytes,2,rep,name=local_identities,json=localIdentities,proto3" json:"local_identities,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ServerHandshakeParameters) Reset()         { *m = ServerHandshakeParameters{} }
func (m *ServerHandshakeParameters) String() string { return proto.CompactTextString(m) }
func (*ServerHandshakeParameters) ProtoMessage()    {}
func (*ServerHandshakeParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_handshaker_cd0a1186560da71f, []int{3}
}
func (m *ServerHandshakeParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServerHandshakeParameters.Unmarshal(m, b)
}
func (m *ServerHandshakeParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServerHandshakeParameters.Marshal(b, m, deterministic)
}
func (dst *ServerHandshakeParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerHandshakeParameters.Merge(dst, src)
}
func (m *ServerHandshakeParameters) XXX_Size() int {
	return xxx_messageInfo_ServerHandshakeParameters.Size(m)
}
func (m *ServerHandshakeParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerHandshakeParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ServerHandshakeParameters proto.InternalMessageInfo

func (m *ServerHandshakeParameters) GetRecordProtocols() []string {
	if m != nil {
		return m.RecordProtocols
	}
	return nil
}

func (m *ServerHandshakeParameters) GetLocalIdentities() []*Identity {
	if m != nil {
		return m.LocalIdentities
	}
	return nil
}

type StartServerHandshakeReq struct {
	// The application protocols supported by the server, e.g., "h2" (for http2),
	// "grpc".
	ApplicationProtocols []string `protobuf:"bytes,1,rep,name=application_protocols,json=applicationProtocols,proto3" json:"application_protocols,omitempty"`
	// Handshake parameters (record protocols and local identities supported by
	// the server) mapped by the handshake protocol. Each handshake security
	// protocol (e.g., TLS or ALTS) has its own set of record protocols and local
	// identities. Since protobuf does not support enum as key to the map, the key
	// to handshake_parameters is the integer value of HandshakeProtocol enum.
	HandshakeParameters map[int32]*ServerHandshakeParameters `protobuf:"bytes,2,rep,name=handshake_parameters,json=handshakeParameters,proto3" json:"handshake_parameters,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Bytes in out_frames returned from the peer's HandshakerResp. It is possible
	// that the peer's out_frames are split into multiple HandshakReq messages.
	InBytes []byte `protobuf:"bytes,3,opt,name=in_bytes,json=inBytes,proto3" json:"in_bytes,omitempty"`
	// (Optional) Local endpoint information of the connection to the client,
	// such as local IP address, port number, and network protocol.
	LocalEndpoint *Endpoint `protobuf:"bytes,4,opt,name=local_endpoint,json=localEndpoint,proto3" json:"local_endpoint,omitempty"`
	// (Optional) Endpoint information of the remote client, such as IP address,
	// port number, and network protocol.
	RemoteEndpoint *Endpoint `protobuf:"bytes,5,opt,name=remote_endpoint,json=remoteEndpoint,proto3" json:"remote_endpoint,omitempty"`
	// (Optional) RPC protocol versions supported by the server.
	RpcVersions          *RpcProtocolVersions `protobuf:"bytes,6,opt,name=rpc_versions,json=rpcVersions,proto3" json:"rpc_versions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StartServerHandshakeReq) Reset()         { *m = StartServerHandshakeReq{} }
func (m *StartServerHandshakeReq) String() string { return proto.CompactTextString(m) }
func (*StartServerHandshakeReq) ProtoMessage()    {}
func (*StartServerHandshakeReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_handshaker_cd0a1186560da71f, []int{4}
}
func (m *StartServerHandshakeReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartServerHandshakeReq.Unmarshal(m, b)
}
func (m *StartServerHandshakeReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartServerHandshakeReq.Marshal(b, m, deterministic)
}
func (dst *StartServerHandshakeReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartServerHandshakeReq.Merge(dst, src)
}
func (m *StartServerHandshakeReq) XXX_Size() int {
	return xxx_messageInfo_StartServerHandshakeReq.Size(m)
}
func (m *StartServerHandshakeReq) XXX_DiscardUnknown() {
	xxx_messageInfo_StartServerHandshakeReq.DiscardUnknown(m)
}

var xxx_messageInfo_StartServerHandshakeReq proto.InternalMessageInfo

func (m *StartServerHandshakeReq) GetApplicationProtocols() []string {
	if m != nil {
		return m.ApplicationProtocols
	}
	return nil
}

func (m *StartServerHandshakeReq) GetHandshakeParameters() map[int32]*ServerHandshakeParameters {
	if m != nil {
		return m.HandshakeParameters
	}
	return nil
}

func (m *StartServerHandshakeReq) GetInBytes() []byte {
	if m != nil {
		return m.InBytes
	}
	return nil
}

func (m *StartServerHandshakeReq) GetLocalEndpoint() *Endpoint {
	if m != nil {
		return m.LocalEndpoint
	}
	return nil
}

func (m *StartServerHandshakeReq) GetRemoteEndpoint() *Endpoint {
	if m != nil {
		return m.RemoteEndpoint
	}
	return nil
}

func (m *StartServerHandshakeReq) GetRpcVersions() *RpcProtocolVersions {
	if m != nil {
		return m.RpcVersions
	}
	return nil
}

type NextHandshakeMessageReq struct {
	// Bytes in out_frames returned from the peer's HandshakerResp. It is possible
	// that the peer's out_frames are split into multiple NextHandshakerMessageReq
	// messages.
	InBytes              []byte   `protobuf:"bytes,1,opt,name=in_bytes,json=inBytes,proto3" json:"in_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NextHandshakeMessageReq) Reset()         { *m = NextHandshakeMessageReq{} }
func (m *NextHandshakeMessageReq) String() string { return proto.CompactTextString(m) }
func (*NextHandshakeMessageReq) ProtoMessage()    {}
func (*NextHandshakeMessageReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_handshaker_cd0a1186560da71f, []int{5}
}
func (m *NextHandshakeMessageReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NextHandshakeMessageReq.Unmarshal(m, b)
}
func (m *NextHandshakeMessageReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NextHandshakeMessageReq.Marshal(b, m, deterministic)
}
func (dst *NextHandshakeMessageReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NextHandshakeMessageReq.Merge(dst, src)
}
func (m *NextHandshakeMessageReq) XXX_Size() int {
	return xxx_messageInfo_NextHandshakeMessageReq.Size(m)
}
func (m *NextHandshakeMessageReq) XXX_DiscardUnknown() {
	xxx_messageInfo_NextHandshakeMessageReq.DiscardUnknown(m)
}

var xxx_messageInfo_NextHandshakeMessageReq proto.InternalMessageInfo

func (m *NextHandshakeMessageReq) GetInBytes() []byte {
	if m != nil {
		return m.InBytes
	}
	return nil
}

type HandshakerReq struct {
	// Types that are valid to be assigned to ReqOneof:
	//	*HandshakerReq_ClientStart
	//	*HandshakerReq_ServerStart
	//	*HandshakerReq_Next
	ReqOneof             isHandshakerReq_ReqOneof `protobuf_oneof:"req_oneof"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *HandshakerReq) Reset()         { *m = HandshakerReq{} }
func (m *HandshakerReq) String() string { return proto.CompactTextString(m) }
func (*HandshakerReq) ProtoMessage()    {}
func (*HandshakerReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_handshaker_cd0a1186560da71f, []int{6}
}
func (m *HandshakerReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HandshakerReq.Unmarshal(m, b)
}
func (m *HandshakerReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HandshakerReq.Marshal(b, m, deterministic)
}
func (dst *HandshakerReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandshakerReq.Merge(dst, src)
}
func (m *HandshakerReq) XXX_Size() int {
	return xxx_messageInfo_HandshakerReq.Size(m)
}
func (m *HandshakerReq) XXX_DiscardUnknown() {
	xxx_messageInfo_HandshakerReq.DiscardUnknown(m)
}

var xxx_messageInfo_HandshakerReq proto.InternalMessageInfo

type isHandshakerReq_ReqOneof interface {
	isHandshakerReq_ReqOneof()
}

type HandshakerReq_ClientStart struct {
	ClientStart *StartClientHandshakeReq `protobuf:"bytes,1,opt,name=client_start,json=clientStart,proto3,oneof"`
}

type HandshakerReq_ServerStart struct {
	ServerStart *StartServerHandshakeReq `protobuf:"bytes,2,opt,name=server_start,json=serverStart,proto3,oneof"`
}

type HandshakerReq_Next struct {
	Next *NextHandshakeMessageReq `protobuf:"bytes,3,opt,name=next,proto3,oneof"`
}

func (*HandshakerReq_ClientStart) isHandshakerReq_ReqOneof() {}

func (*HandshakerReq_ServerStart) isHandshakerReq_ReqOneof() {}

func (*HandshakerReq_Next) isHandshakerReq_ReqOneof() {}

func (m *HandshakerReq) GetReqOneof() isHandshakerReq_ReqOneof {
	if m != nil {
		return m.ReqOneof
	}
	return nil
}

func (m *HandshakerReq) GetClientStart() *StartClientHandshakeReq {
	if x, ok := m.GetReqOneof().(*HandshakerReq_ClientStart); ok {
		return x.ClientStart
	}
	return nil
}

func (m *HandshakerReq) GetServerStart() *StartServerHandshakeReq {
	if x, ok := m.GetReqOneof().(*HandshakerReq_ServerStart); ok {
		return x.ServerStart
	}
	return nil
}

func (m *HandshakerReq) GetNext() *NextHandshakeMessageReq {
	if x, ok := m.GetReqOneof().(*HandshakerReq_Next); ok {
		return x.Next
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HandshakerReq) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HandshakerReq_OneofMarshaler, _HandshakerReq_OneofUnmarshaler, _HandshakerReq_OneofSizer, []interface{}{
		(*HandshakerReq_ClientStart)(nil),
		(*HandshakerReq_ServerStart)(nil),
		(*HandshakerReq_Next)(nil),
	}
}

func _HandshakerReq_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HandshakerReq)
	// req_oneof
	switch x := m.ReqOneof.(type) {
	case *HandshakerReq_ClientStart:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClientStart); err != nil {
			return err
		}
	case *HandshakerReq_ServerStart:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ServerStart); err != nil {
			return err
		}
	case *HandshakerReq_Next:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Next); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HandshakerReq.ReqOneof has unexpected type %T", x)
	}
	return nil
}

func _HandshakerReq_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HandshakerReq)
	switch tag {
	case 1: // req_oneof.client_start
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StartClientHandshakeReq)
		err := b.DecodeMessage(msg)
		m.ReqOneof = &HandshakerReq_ClientStart{msg}
		return true, err
	case 2: // req_oneof.server_start
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StartServerHandshakeReq)
		err := b.DecodeMessage(msg)
		m.ReqOneof = &HandshakerReq_ServerStart{msg}
		return true, err
	case 3: // req_oneof.next
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NextHandshakeMessageReq)
		err := b.DecodeMessage(msg)
		m.ReqOneof = &HandshakerReq_Next{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HandshakerReq_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HandshakerReq)
	// req_oneof
	switch x := m.ReqOneof.(type) {
	case *HandshakerReq_ClientStart:
		s := proto.Size(x.ClientStart)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HandshakerReq_ServerStart:
		s := proto.Size(x.ServerStart)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HandshakerReq_Next:
		s := proto.Size(x.Next)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type HandshakerResult struct {
	// The application protocol negotiated for this connection.
	ApplicationProtocol string `protobuf:"bytes,1,opt,name=application_protocol,json=applicationProtocol,proto3" json:"application_protocol,omitempty"`
	// The record protocol negotiated for this connection.
	RecordProtocol string `protobuf:"bytes,2,opt,name=record_protocol,json=recordProtocol,proto3" json:"record_protocol,omitempty"`
	// Cryptographic key data. The key data may be more than the key length
	// required for the record protocol, thus the client of the handshaker
	// service needs to truncate the key data into the right key length.
	KeyData []byte `protobuf:"bytes,3,opt,name=key_data,json=keyData,proto3" json:"key_data,omitempty"`
	// The authenticated identity of the peer.
	PeerIdentity *Identity `protobuf:"bytes,4,opt,name=peer_identity,json=peerIdentity,proto3" json:"peer_identity,omitempty"`
	// The local identity used in the handshake.
	LocalIdentity *Identity `protobuf:"bytes,5,opt,name=local_identity,json=localIdentity,proto3" json:"local_identity,omitempty"`
	// Indicate whether the handshaker service client should keep the channel
	// between the handshaker service open, e.g., in order to handle
	// post-handshake messages in the future.
	KeepChannelOpen bool `protobuf:"varint,6,opt,name=keep_channel_open,json=keepChannelOpen,proto3" json:"keep_channel_open,omitempty"`
	// The RPC protocol versions supported by the peer.
	PeerRpcVersions      *RpcProtocolVersions `protobuf:"bytes,7,opt,name=peer_rpc_versions,json=peerRpcVersions,proto3" json:"peer_rpc_versions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *HandshakerResult) Reset()         { *m = HandshakerResult{} }
func (m *HandshakerResult) String() string { return proto.CompactTextString(m) }
func (*HandshakerResult) ProtoMessage()    {}
func (*HandshakerResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_handshaker_cd0a1186560da71f, []int{7}
}
func (m *HandshakerResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HandshakerResult.Unmarshal(m, b)
}
func (m *HandshakerResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HandshakerResult.Marshal(b, m, deterministic)
}
func (dst *HandshakerResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandshakerResult.Merge(dst, src)
}
func (m *HandshakerResult) XXX_Size() int {
	return xxx_messageInfo_HandshakerResult.Size(m)
}
func (m *HandshakerResult) XXX_DiscardUnknown() {
	xxx_messageInfo_HandshakerResult.DiscardUnknown(m)
}

var xxx_messageInfo_HandshakerResult proto.InternalMessageInfo

func (m *HandshakerResult) GetApplicationProtocol() string {
	if m != nil {
		return m.ApplicationProtocol
	}
	return ""
}

func (m *HandshakerResult) GetRecordProtocol() string {
	if m != nil {
		return m.RecordProtocol
	}
	return ""
}

func (m *HandshakerResult) GetKeyData() []byte {
	if m != nil {
		return m.KeyData
	}
	return nil
}

func (m *HandshakerResult) GetPeerIdentity() *Identity {
	if m != nil {
		return m.PeerIdentity
	}
	return nil
}

func (m *HandshakerResult) GetLocalIdentity() *Identity {
	if m != nil {
		return m.LocalIdentity
	}
	return nil
}

func (m *HandshakerResult) GetKeepChannelOpen() bool {
	if m != nil {
		return m.KeepChannelOpen
	}
	return false
}

func (m *HandshakerResult) GetPeerRpcVersions() *RpcProtocolVersions {
	if m != nil {
		return m.PeerRpcVersions
	}
	return nil
}

type HandshakerStatus struct {
	// The status code. This could be the gRPC status code.
	Code uint32 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	// The status details.
	Details              string   `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HandshakerStatus) Reset()         { *m = HandshakerStatus{} }
func (m *HandshakerStatus) String() string { return proto.CompactTextString(m) }
func (*HandshakerStatus) ProtoMessage()    {}
func (*HandshakerStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_handshaker_cd0a1186560da71f, []int{8}
}
func (m *HandshakerStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HandshakerStatus.Unmarshal(m, b)
}
func (m *HandshakerStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HandshakerStatus.Marshal(b, m, deterministic)
}
func (dst *HandshakerStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandshakerStatus.Merge(dst, src)
}
func (m *HandshakerStatus) XXX_Size() int {
	return xxx_messageInfo_HandshakerStatus.Size(m)
}
func (m *HandshakerStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_HandshakerStatus.DiscardUnknown(m)
}

var xxx_messageInfo_HandshakerStatus proto.InternalMessageInfo

func (m *HandshakerStatus) GetCode() uint32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *HandshakerStatus) GetDetails() string {
	if m != nil {
		return m.Details
	}
	return ""
}

type HandshakerResp struct {
	// Frames to be given to the peer for the NextHandshakeMessageReq. May be
	// empty if no out_frames have to be sent to the peer or if in_bytes in the
	// HandshakerReq are incomplete. All the non-empty out frames must be sent to
	// the peer even if the handshaker status is not OK as these frames may
	// contain the alert frames.
	OutFrames []byte `protobuf:"bytes,1,opt,name=out_frames,json=outFrames,proto3" json:"out_frames,omitempty"`
	// Number of bytes in the in_bytes consumed by the handshaker. It is possible
	// that part of in_bytes in HandshakerReq was unrelated to the handshake
	// process.
	BytesConsumed uint32 `protobuf:"varint,2,opt,name=bytes_consumed,json=bytesConsumed,proto3" json:"bytes_consumed,omitempty"`
	// This is set iff the handshake was successful. out_frames may still be set
	// to frames that needs to be forwarded to the peer.
	Result *HandshakerResult `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
	// Status of the handshaker.
	Status               *HandshakerStatus `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *HandshakerResp) Reset()         { *m = HandshakerResp{} }
func (m *HandshakerResp) String() string { return proto.CompactTextString(m) }
func (*HandshakerResp) ProtoMessage()    {}
func (*HandshakerResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_handshaker_cd0a1186560da71f, []int{9}
}
func (m *HandshakerResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HandshakerResp.Unmarshal(m, b)
}
func (m *HandshakerResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HandshakerResp.Marshal(b, m, deterministic)
}
func (dst *HandshakerResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandshakerResp.Merge(dst, src)
}
func (m *HandshakerResp) XXX_Size() int {
	return xxx_messageInfo_HandshakerResp.Size(m)
}
func (m *HandshakerResp) XXX_DiscardUnknown() {
	xxx_messageInfo_HandshakerResp.DiscardUnknown(m)
}

var xxx_messageInfo_HandshakerResp proto.InternalMessageInfo

func (m *HandshakerResp) GetOutFrames() []byte {
	if m != nil {
		return m.OutFrames
	}
	return nil
}

func (m *HandshakerResp) GetBytesConsumed() uint32 {
	if m != nil {
		return m.BytesConsumed
	}
	return 0
}

func (m *HandshakerResp) GetResult() *HandshakerResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *HandshakerResp) GetStatus() *HandshakerStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func init() {
	proto.RegisterType((*Endpoint)(nil), "grpc.gcp.Endpoint")
	proto.RegisterType((*Identity)(nil), "grpc.gcp.Identity")
	proto.RegisterType((*StartClientHandshakeReq)(nil), "grpc.gcp.StartClientHandshakeReq")
	proto.RegisterType((*ServerHandshakeParameters)(nil), "grpc.gcp.ServerHandshakeParameters")
	proto.RegisterType((*StartServerHandshakeReq)(nil), "grpc.gcp.StartServerHandshakeReq")
	proto.RegisterMapType((map[int32]*ServerHandshakeParameters)(nil), "grpc.gcp.StartServerHandshakeReq.HandshakeParametersEntry")
	proto.RegisterType((*NextHandshakeMessageReq)(nil), "grpc.gcp.NextHandshakeMessageReq")
	proto.RegisterType((*HandshakerReq)(nil), "grpc.gcp.HandshakerReq")
	proto.RegisterType((*HandshakerResult)(nil), "grpc.gcp.HandshakerResult")
	proto.RegisterType((*HandshakerStatus)(nil), "grpc.gcp.HandshakerStatus")
	proto.RegisterType((*HandshakerResp)(nil), "grpc.gcp.HandshakerResp")
	proto.RegisterEnum("grpc.gcp.HandshakeProtocol", HandshakeProtocol_name, HandshakeProtocol_value)
	proto.RegisterEnum("grpc.gcp.NetworkProtocol", NetworkProtocol_name, NetworkProtocol_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// HandshakerServiceClient is the client API for HandshakerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type HandshakerServiceClient interface {
	// Handshaker service accepts a stream of handshaker request, returning a
	// stream of handshaker response. Client is expected to send exactly one
	// message with either client_start or server_start followed by one or more
	// messages with next. Each time client sends a request, the handshaker
	// service expects to respond. Client does not have to wait for service's
	// response before sending next request.
	DoHandshake(ctx context.Context, opts ...grpc.CallOption) (HandshakerService_DoHandshakeClient, error)
}

type handshakerServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandshakerServiceClient(cc *grpc.ClientConn) HandshakerServiceClient {
	return &handshakerServiceClient{cc}
}

func (c *handshakerServiceClient) DoHandshake(ctx context.Context, opts ...grpc.CallOption) (HandshakerService_DoHandshakeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_HandshakerService_serviceDesc.Streams[0], "/grpc.gcp.HandshakerService/DoHandshake", opts...)
	if err != nil {
		return nil, err
	}
	x := &handshakerServiceDoHandshakeClient{stream}
	return x, nil
}

type HandshakerService_DoHandshakeClient interface {
	Send(*HandshakerReq) error
	Recv() (*HandshakerResp, error)
	grpc.ClientStream
}

type handshakerServiceDoHandshakeClient struct {
	grpc.ClientStream
}

func (x *handshakerServiceDoHandshakeClient) Send(m *HandshakerReq) error {
	return x.ClientStream.SendMsg(m)
}

func (x *handshakerServiceDoHandshakeClient) Recv() (*HandshakerResp, error) {
	m := new(HandshakerResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// HandshakerServiceServer is the server API for HandshakerService service.
type HandshakerServiceServer interface {
	// Handshaker service accepts a stream of handshaker request, returning a
	// stream of handshaker response. Client is expected to send exactly one
	// message with either client_start or server_start followed by one or more
	// messages with next. Each time client sends a request, the handshaker
	// service expects to respond. Client does not have to wait for service's
	// response before sending next request.
	DoHandshake(HandshakerService_DoHandshakeServer) error
}

func RegisterHandshakerServiceServer(s *grpc.Server, srv HandshakerServiceServer) {
	s.RegisterService(&_HandshakerService_serviceDesc, srv)
}

func _HandshakerService_DoHandshake_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(HandshakerServiceServer).DoHandshake(&handshakerServiceDoHandshakeServer{stream})
}

type HandshakerService_DoHandshakeServer interface {
	Send(*HandshakerResp) error
	Recv() (*HandshakerReq, error)
	grpc.ServerStream
}

type handshakerServiceDoHandshakeServer struct {
	grpc.ServerStream
}

func (x *handshakerServiceDoHandshakeServer) Send(m *HandshakerResp) error {
	return x.ServerStream.SendMsg(m)
}

func (x *handshakerServiceDoHandshakeServer) Recv() (*HandshakerReq, error) {
	m := new(HandshakerReq)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _HandshakerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "grpc.gcp.HandshakerService",
	HandlerType: (*HandshakerServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "DoHandshake",
			Handler:       _HandshakerService_DoHandshake_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "grpc/gcp/handshaker.proto",
}

func init() {
	proto.RegisterFile("grpc/gcp/handshaker.proto", fileDescriptor_handshaker_cd0a1186560da71f)
}

var fileDescriptor_handshaker_cd0a1186560da71f = []byte{
	// 1127 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xdf, 0x6e, 0x1a, 0xc7,
	0x17, 0xf6, 0x02, 0xb6, 0xf1, 0xc1, 0xfc, 0xf1, 0x24, 0x51, 0xb0, 0x93, 0xfc, 0x7e, 0x94, 0xaa,
	0x2a, 0xc9, 0x05, 0xb4, 0xa4, 0x55, 0x9a, 0x54, 0x55, 0x62, 0x63, 0x2c, 0xdc, 0xa4, 0x18, 0x0d,
	0x4e, 0x2b, 0x35, 0x17, 0xab, 0xc9, 0x72, 0x82, 0x57, 0x2c, 0x33, 0xeb, 0x99, 0xc1, 0x0d, 0x0f,
	0xd0, 0xc7, 0xe9, 0x2b, 0xf4, 0x6d, 0xfa, 0x06, 0xbd, 0x6f, 0xb5, 0xb3, 0xff, 0x30, 0x86, 0x28,
	0x51, 0xef, 0x76, 0x67, 0xbe, 0xef, 0xec, 0x39, 0xdf, 0xf9, 0xe6, 0xec, 0xc0, 0xfe, 0x58, 0xfa,
	0x4e, 0x6b, 0xec, 0xf8, 0xad, 0x0b, 0xc6, 0x47, 0xea, 0x82, 0x4d, 0x50, 0x36, 0x7d, 0x29, 0xb4,
	0x20, 0xf9, 0x60, 0xab, 0x39, 0x76, 0xfc, 0x83, 0x46, 0x02, 0xd2, 0x92, 0x71, 0xe5, 0x0b, 0xa9,
	0x6d, 0x85, 0xce, 0x4c, 0xba, 0x7a, 0x6e, 0x3b, 0x62, 0x3a, 0x15, 0x3c, 0xe4, 0xd4, 0x35, 0xe4,
	0xbb, 0x7c, 0xe4, 0x0b, 0x97, 0x6b, 0xf2, 0x00, 0xc0, 0xf5, 0x6d, 0x36, 0x1a, 0x49, 0x54, 0xaa,
	0x6a, 0xd5, 0xac, 0xc6, 0x0e, 0xdd, 0x71, 0xfd, 0xc3, 0x70, 0x81, 0x10, 0xc8, 0x05, 0x81, 0xaa,
	0x99, 0x9a, 0xd5, 0xd8, 0xa4, 0xe6, 0x99, 0x7c, 0x0b, 0x79, 0x13, 0xc7, 0x11, 0x5e, 0x35, 0x5b,
	0xb3, 0x1a, 0xa5, 0xf6, 0x7e, 0x33, 0xce, 0xa2, 0xd9, 0x47, 0xfd, 0x9b, 0x90, 0x93, 0x41, 0x04,
	0xa0, 0x09, 0xb4, 0x8e, 0x90, 0x3f, 0x1d, 0x21, 0xd7, 0xae, 0x9e, 0x93, 0x87, 0x50, 0x56, 0x28,
	0xaf, 0x5c, 0x07, 0x6d, 0xe6, 0x38, 0x62, 0xc6, 0x75, 0xf8, 0xe9, 0xde, 0x06, 0x2d, 0x45, 0x1b,
	0x87, 0xe1, 0x3a, 0xb9, 0x0f, 0xf9, 0x0b, 0xa1, 0x34, 0x67, 0x53, 0x34, 0x59, 0x04, 0x98, 0x64,
	0xe5, 0xa8, 0x02, 0x25, 0x37, 0x0a, 0x6a, 0x0b, 0x8e, 0xe2, 0x5d, 0xfd, 0x8f, 0x1c, 0xdc, 0x1d,
	0x6a, 0x26, 0x75, 0xc7, 0x73, 0x91, 0xeb, 0x5e, 0x2c, 0x18, 0xc5, 0x4b, 0xf2, 0x06, 0xee, 0x25,
	0x02, 0xa6, 0xda, 0x24, 0xc5, 0x58, 0xa6, 0x98, 0x7b, 0x69, 0x31, 0x09, 0x39, 0x29, 0x67, 0x3f,
	0xe1, 0x0f, 0x23, 0x7a, 0xbc, 0x45, 0x1e, 0xc3, 0x1d, 0xe6, 0xfb, 0x9e, 0xeb, 0x30, 0xed, 0x0a,
	0x9e, 0x44, 0x55, 0xd5, 0x4c, 0x2d, 0xdb, 0xd8, 0xa1, 0xb7, 0x17, 0x36, 0x63, 0x8e, 0x22, 0x0f,
	0xa1, 0x22, 0xd1, 0x11, 0x72, 0xb4, 0x80, 0xcf, 0x1a, 0x7c, 0x39, 0x5c, 0x4f, 0xa1, 0xcf, 0x61,
	0x4f, 0x33, 0x39, 0x46, 0x6d, 0x47, 0x15, 0xbb, 0xa8, 0xaa, 0xb9, 0x5a, 0xb6, 0x51, 0x68, 0x93,
	0x34, 0xe5, 0x58, 0x62, 0x5a, 0x09, 0xc1, 0xa7, 0x09, 0x96, 0x3c, 0x85, 0x92, 0x27, 0x1c, 0xe6,
	0xc5, 0xfc, 0x79, 0x75, 0xb3, 0x66, 0xad, 0x61, 0x17, 0x0d, 0x32, 0xe9, 0x57, 0x42, 0xc5, 0xc8,
	0x37, 0xd5, 0xad, 0x65, 0x6a, 0xec, 0xa8, 0x88, 0x9a, 0x18, 0xec, 0x7b, 0x28, 0x4b, 0x9c, 0x0a,
	0x8d, 0x29, 0x77, 0x7b, 0x2d, 0xb7, 0x14, 0x42, 0x13, 0xf2, 0xff, 0xa1, 0x10, 0xd5, 0x6c, 0xfa,
	0x9f, 0x37, 0xf6, 0x84, 0x70, 0xa9, 0xcf, 0xa6, 0x48, 0x5e, 0xc0, 0xae, 0xf4, 0x1d, 0xfb, 0x0a,
	0xa5, 0x72, 0x05, 0x57, 0xd5, 0x1d, 0x13, 0xfa, 0x41, 0x1a, 0x9a, 0xfa, 0x4e, 0x2c, 0xe1, 0xcf,
	0x11, 0x88, 0x16, 0xa4, 0xef, 0xc4, 0x2f, 0xf5, 0xdf, 0x2d, 0xd8, 0x1f, 0xa2, 0xbc, 0x42, 0x99,
	0x76, 0x9b, 0x49, 0x36, 0x45, 0x8d, 0x72, 0x75, 0x7f, 0xac, 0xd5, 0xfd, 0xf9, 0x01, 0x2a, 0xd7,
	0xe4, 0x0d, 0xda, 0x93, 0x59, 0xdb, 0x9e, 0xf2, 0xa2, 0xc0, 0x2e, 0xaa, 0xfa, 0x3f, 0xd9, 0xc8,
	0xb7, 0x4b, 0xc9, 0x04, 0xbe, 0x5d, 0x6b, 0x2d, 0xeb, 0x03, 0xd6, 0x9a, 0xc2, 0xed, 0xd4, 0xec,
	0x7e, 0x52, 0x52, 0x94, 0xd3, 0xb3, 0x34, 0xa7, 0x35, 0x5f, 0x6d, 0xae, 0xd0, 0xa3, 0xcb, 0xb5,
	0x9c, 0xd3, 0x5b, 0x17, 0x2b, 0x94, 0xda, 0x87, 0xbc, 0xcb, 0xed, 0xb7, 0x73, 0x8d, 0xca, 0x4c,
	0x85, 0x5d, 0xba, 0xed, 0xf2, 0xa3, 0xe0, 0x75, 0x85, 0x7b, 0x72, 0xff, 0xc1, 0x3d, 0x9b, 0x1f,
	0xed, 0x9e, 0x65, 0x73, 0x6c, 0x7d, 0xaa, 0x39, 0x0e, 0x26, 0x50, 0x5d, 0xa7, 0x02, 0xa9, 0x40,
	0x76, 0x82, 0x73, 0x33, 0x34, 0x36, 0x69, 0xf0, 0x48, 0x9e, 0xc2, 0xe6, 0x15, 0xf3, 0x66, 0xe1,
	0x9c, 0x2a, 0xb4, 0x3f, 0x5f, 0x90, 0x78, 0x9d, 0xc1, 0x68, 0xc8, 0x78, 0x96, 0xf9, 0xce, 0xaa,
	0x7f, 0x03, 0x77, 0xfb, 0xf8, 0x3e, 0x9d, 0x58, 0x3f, 0xa1, 0x52, 0x6c, 0x6c, 0x0c, 0xb0, 0x28,
	0xae, 0x75, 0x4d, 0xdc, 0xfa, 0x5f, 0x16, 0x14, 0x13, 0x8a, 0x0c, 0xc0, 0x27, 0xb0, 0xeb, 0x98,
	0xd9, 0x67, 0xab, 0xa0, 0xb3, 0x86, 0x50, 0x68, 0x7f, 0xb6, 0xd4, 0xf0, 0x9b, 0xe3, 0xb1, 0xb7,
	0x41, 0x0b, 0x21, 0xd1, 0x00, 0x82, 0x38, 0xca, 0xe4, 0x1d, 0xc5, 0xc9, 0xac, 0x8c, 0x73, 0xd3,
	0x38, 0x41, 0x9c, 0x90, 0x18, 0xc6, 0x79, 0x02, 0x39, 0x8e, 0xef, 0xb5, 0x71, 0xc5, 0x35, 0xfe,
	0x9a, 0x6a, 0x7b, 0x1b, 0xd4, 0x10, 0x8e, 0x0a, 0xb0, 0x23, 0xf1, 0x32, 0x9a, 0xeb, 0x7f, 0x67,
	0xa0, 0xb2, 0x58, 0xa7, 0x9a, 0x79, 0x9a, 0x7c, 0x0d, 0xb7, 0x57, 0x1d, 0x8c, 0xe8, 0x3f, 0x76,
	0x6b, 0xc5, 0xb9, 0x20, 0x5f, 0x42, 0x79, 0xe9, 0x44, 0x87, 0xbf, 0x95, 0xc0, 0x3d, 0x8b, 0x07,
	0x3a, 0xd0, 0x7c, 0x82, 0x73, 0x7b, 0xc4, 0x34, 0x8b, 0x0d, 0x3d, 0xc1, 0xf9, 0x31, 0xd3, 0x8c,
	0x3c, 0x81, 0xa2, 0x8f, 0x28, 0xd3, 0x41, 0x9a, 0x5b, 0x3b, 0x48, 0x77, 0x03, 0xe0, 0xcd, 0x39,
	0xfa, 0xe9, 0x23, 0xf8, 0x11, 0xec, 0x4d, 0x10, 0x7d, 0xdb, 0xb9, 0x60, 0x9c, 0xa3, 0x67, 0x0b,
	0x1f, 0xb9, 0x71, 0x74, 0x9e, 0x96, 0x83, 0x8d, 0x4e, 0xb8, 0x7e, 0xe6, 0x23, 0x27, 0xa7, 0xb0,
	0x67, 0xf2, 0xbb, 0xe6, 0xfe, 0xed, 0x8f, 0x71, 0x7f, 0x39, 0xe0, 0xd1, 0x85, 0xf1, 0xf8, 0x62,
	0x51, 0xf5, 0xa1, 0x66, 0x7a, 0x66, 0x2e, 0x05, 0x8e, 0x18, 0xa1, 0x51, 0xb9, 0x48, 0xcd, 0x33,
	0xa9, 0xc2, 0xf6, 0x08, 0x35, 0x73, 0xcd, 0xff, 0x2e, 0x90, 0x33, 0x7e, 0xad, 0xff, 0x69, 0x41,
	0xe9, 0x5a, 0xe3, 0xfc, 0xe0, 0xd2, 0x21, 0x66, 0xda, 0x7e, 0x17, 0x9c, 0x82, 0xd8, 0xd0, 0x3b,
	0x62, 0xa6, 0x4f, 0xcc, 0x02, 0xf9, 0x02, 0x4a, 0xc6, 0xea, 0xb6, 0x23, 0xb8, 0x9a, 0x4d, 0x71,
	0x64, 0x42, 0x16, 0x69, 0xd1, 0xac, 0x76, 0xa2, 0x45, 0xd2, 0x86, 0x2d, 0x69, 0x6c, 0x10, 0x39,
	0xeb, 0x60, 0xc5, 0x8f, 0x3b, 0x32, 0x0a, 0x8d, 0x90, 0x01, 0x47, 0x99, 0x22, 0xa2, 0x96, 0xad,
	0xe4, 0x84, 0x65, 0xd2, 0x08, 0xf9, 0xe8, 0x47, 0xd8, 0xbb, 0x71, 0x11, 0x20, 0x75, 0xf8, 0x5f,
	0xef, 0xb0, 0x7f, 0x3c, 0xec, 0x1d, 0xbe, 0xec, 0xda, 0x03, 0x7a, 0x76, 0x7e, 0xd6, 0x39, 0x7b,
	0x65, 0xbf, 0xee, 0x0f, 0x07, 0xdd, 0xce, 0xe9, 0xc9, 0x69, 0xf7, 0xb8, 0xb2, 0x41, 0xb6, 0x21,
	0x7b, 0xfe, 0x6a, 0x58, 0xb1, 0x48, 0x1e, 0x72, 0x87, 0xaf, 0xce, 0x87, 0x95, 0xcc, 0xa3, 0x2e,
	0x94, 0x97, 0x6e, 0x48, 0xa4, 0x06, 0xf7, 0xfb, 0xdd, 0xf3, 0x5f, 0xce, 0xe8, 0xcb, 0x0f, 0xc5,
	0xe9, 0x0c, 0x2a, 0x56, 0xf0, 0xf0, 0xfa, 0x78, 0x50, 0xc9, 0xb4, 0xdf, 0x2c, 0xa4, 0x24, 0x87,
	0xe1, 0x85, 0x89, 0x9c, 0x40, 0xe1, 0x58, 0x24, 0xcb, 0xe4, 0xee, 0x6a, 0x39, 0x2e, 0x0f, 0xaa,
	0x6b, 0x74, 0xf2, 0xeb, 0x1b, 0x0d, 0xeb, 0x2b, 0xeb, 0x68, 0x02, 0x77, 0x5c, 0x11, 0x62, 0x98,
	0xa7, 0x55, 0xd3, 0xe5, 0x1a, 0x25, 0x67, 0xde, 0x51, 0x39, 0x85, 0x9b, 0xec, 0x07, 0xd6, 0xaf,
	0xcf, 0xc7, 0x42, 0x8c, 0x3d, 0x6c, 0x8e, 0x85, 0xc7, 0xf8, 0xb8, 0x29, 0xe4, 0xb8, 0x65, 0xae,
	0xa1, 0x8e, 0x44, 0x63, 0x5c, 0xe6, 0xa9, 0x56, 0x10, 0xa4, 0x15, 0x07, 0x69, 0x99, 0x53, 0x67,
	0x40, 0xf6, 0xd8, 0xf1, 0xdf, 0x6e, 0x99, 0xf7, 0xc7, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0xe6,
	0xde, 0x21, 0x9d, 0xe3, 0x0a, 0x00, 0x00,
}
