/* vim:set ts=2 sw=2 sts=2 et: */
/**
 * \author     Marcus Holland-Moritz (github@mhxnet.de)
 * \copyright  Copyright (c) Marcus Holland-Moritz
 *
 * This file is part of dwarfs.
 *
 * dwarfs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * dwarfs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with dwarfs.  If not, see <https://www.gnu.org/licenses/>.
 */

#include "loremipsum.h"

namespace {

const std::string s_loremipsum(
    "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo "
    "igula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis "
    "is parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies "
    "ec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. "
    "onec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In "
    "enim "
    "usto, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum "
    "felis "
    "u pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum "
    "emper nisi. Aenean vulputate eleifend tellus.\n"
    "Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. "
    "Aliquam "
    "orem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra "
    "ulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam "
    "ultricies "
    "isi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam "
    "honcus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper "
    "ibero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit "
    "el, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante "
    "tincidunt "
    "empus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis "
    "ante.\n"
    "Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla "
    "auris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo "
    "eget "
    "ibendum sodales, augue velit cursus nunc, quis gravida magna mi a libero. "
    "usce vulputate eleifend sapien. Vestibulum purus quam, scelerisque ut, "
    "ollis sed, nonummy id, metus. Nullam accumsan lorem in dui. Cras "
    "ultricies "
    "i eu turpis hendrerit fringilla. Vestibulum ante ipsum primis in faucibus "
    "rci luctus et ultrices posuere cubilia Curae; In ac dui quis mi "
    "consectetuer "
    "acinia. Nam pretium turpis et arcu.\n"
    "Duis arcu tortor, suscipit eget, imperdiet nec, imperdiet iaculis, ipsum. "
    "ed aliquam ultrices mauris. Integer ante arcu, accumsan a, consectetuer "
    "get, posuere ut, mauris. Praesent adipiscing. Phasellus ullamcorper ipsum "
    "utrum nunc. Nunc nonummy metus. Vestibulum volutpat pretium libero. Cras "
    "d dui. Aenean ut eros et nisl sagittis vestibulum. Nullam nulla eros, "
    "ultricies "
    "it amet, nonummy id, imperdiet feugiat, pede. Sed lectus. Donec mollis "
    "endrerit risus. Phasellus nec sem in justo pellentesque facilisis. Etiam "
    "mperdiet imperdiet orci. Nunc nec neque.\n"
    "Phasellus leo dolor, tempus non, auctor et, hendrerit quis, nisi. "
    "Curabitur "
    "igula sapien, tincidunt non, euismod vitae, posuere imperdiet, leo. "
    "Maecenas "
    "alesuada. Praesent congue erat at massa. Sed cursus turpis vitae tortor. "
    "onec posuere vulputate arcu. Phasellus accumsan cursus velit. Vestibulum "
    "nte ipsum primis in faucibus orci luctus et ultrices posuere cubilia "
    "Curae; "
    "ed aliquam, nisi quis porttitor congue, elit erat euismod orci, ac "
    "placerat "
    "olor lectus quis orci. Phasellus consectetuer vestibulum elit. Aenean "
    "tellus "
    "etus, bibendum sed, posuere ac, mattis non, nunc. Vestibulum fringilla "
    "ede sit amet augue.\n"
    "In turpis. Pellentesque posuere. Praesent turpis. Aenean posuere, tortor "
    "ed cursus feugiat, nunc augue blandit nunc, eu sollicitudin urna dolor "
    "agittis lacus. Donec elit libero, sodales nec, volutpat a, suscipit non, "
    "urpis. Nullam sagittis. Suspendisse pulvinar, augue ac venenatis "
    "condimentum, "
    "em libero volutpat nibh, nec pellentesque velit pede quis nunc. "
    "Vestibulum "
    "nte ipsum primis in faucibus orci luctus et ultrices posuere cubilia "
    "Curae; "
    "usce id purus. Ut varius tincidunt libero. Phasellus dolor. Maecenas "
    "vestibulum "
    "ollis diam. Pellentesque ut neque.\n"
    "Pellentesque habitant morbi tristique senectus et netus et malesuada "
    "fames "
    "c turpis egestas. In dui magna, posuere eget, vestibulum et, tempor "
    "auctor, "
    "usto. In ac felis quis tortor malesuada pretium. Pellentesque auctor "
    "neque "
    "ec urna. Proin sapien ipsum, porta a, auctor quis, euismod ut, mi. Aenean "
    "iverra rhoncus pede. Pellentesque habitant morbi tristique senectus et "
    "etus et malesuada fames ac turpis egestas. Ut non enim eleifend felis "
    "pretium "
    "eugiat. Vivamus quis mi. Phasellus a est. Phasellus magna. In hac "
    "habitasse "
    "latea dictumst. Curabitur at lacus ac velit ornare lobortis.\n"
    "Curabitur a felis in nunc fringilla tristique. Morbi mattis ullamcorper "
    "elit. Phasellus gravida semper nisi. Nullam vel sem. Pellentesque libero "
    "ortor, tincidunt et, tincidunt eget, semper nec, quam. Sed hendrerit. "
    "Morbi "
    "c felis. Nunc egestas, augue at pellentesque laoreet, felis eros vehicula "
    "eo, at malesuada velit leo quis pede. Donec interdum, metus et hendrerit "
    "liquet, dolor diam sagittis ligula, eget egestas libero turpis vel mi. "
    "unc nulla. Fusce risus nisl, viverra et, tempor et, pretium in, sapien. "
    "onec venenatis vulputate lorem. Morbi nec metus. Phasellus blandit leo "
    "t odio.\n"
    "Maecenas ullamcorper, dui et placerat feugiat, eros pede varius nisi, "
    "condimentum "
    "iverra felis nunc et lorem. Sed magna purus, fermentum eu, tincidunt eu, "
    "arius ut, felis. In auctor lobortis lacus. Quisque libero metus, "
    "condimentum "
    "ec, tempor a, commodo mollis, magna. Vestibulum ullamcorper mauris at "
    "ligula. "
    "usce fermentum. Nullam cursus lacinia erat. Praesent blandit laoreet "
    "nibh. "
    "usce convallis metus id felis luctus adipiscing. Pellentesque egestas, "
    "eque sit amet convallis pulvinar, justo nulla eleifend augue, ac auctor "
    "rci leo non est. Quisque id mi. Ut tincidunt tincidunt erat. Etiam "
    "feugiat "
    "orem non metus.\n"
    "Vestibulum dapibus nunc ac augue. Curabitur vestibulum aliquam leo. "
    "Praesent "
    "gestas neque eu enim. In hac habitasse platea dictumst. Fusce a quam. "
    "Etiam "
    "t purus mattis mauris sodales aliquam. Curabitur nisi. Quisque malesuada "
    "lacerat nisl. Nam ipsum risus, rutrum vitae, vestibulum eu, molestie vel, "
    "acus. Sed augue ipsum, egestas nec, vestibulum et, malesuada adipiscing, "
    "ui. Vestibulum facilisis, purus nec pulvinar iaculis, ligula mi congue "
    "unc, vitae euismod ligula urna in dolor. Mauris sollicitudin fermentum "
    "ibero. Praesent nonummy mi in odio. Nunc interdum lacus sit amet orci.\n"
    "Vestibulum rutrum, mi nec elementum vehicula, eros quam gravida nisl, id "
    "ringilla neque ante vel mi. Morbi mollis tellus ac sapien. Phasellus "
    "volutpat, "
    "etus eget egestas mollis, lacus lacus blandit dui, id egestas quam mauris "
    "t lacus. Fusce vel dui. Sed in libero ut nibh placerat accumsan. Proin "
    "aucibus arcu quis ante. In consectetuer turpis ut velit. Nulla sit amet "
    "st. Praesent metus tellus, elementum eu, semper a, adipiscing nec, purus. "
    "ras risus ipsum, faucibus ut, ullamcorper id, varius ac, leo. Suspendisse "
    "eugiat. Suspendisse enim turpis, dictum sed, iaculis a, condimentum nec, "
    "isi.\n"
    "Praesent nec nisl a purus blandit viverra. Praesent ac massa at ligula "
    "aoreet iaculis. Nulla neque dolor, sagittis eget, iaculis quis, molestie "
    "on, velit. Mauris turpis nunc, blandit et, volutpat molestie, porta ut, "
    "igula. Fusce pharetra convallis urna. Quisque ut nisi. Donec mi odio, "
    "faucibus "
    "t, scelerisque quis, convallis in, nisi. Suspendisse non nisl sit amet "
    "elit hendrerit rutrum. Ut leo. Ut a nisl id ante tempus hendrerit. Proin "
    "retium, leo ac pellentesque mollis, felis nunc ultrices eros, sed gravida "
    "ugue augue mollis justo. Suspendisse eu ligula. Nulla facilisi. Donec id "
    "usto.\n"
    "Praesent porttitor, nulla vitae posuere iaculis, arcu nisl dignissim "
    "dolor, "
    " pretium mi sem ut ipsum. Curabitur suscipit suscipit tellus. Praesent "
    "estibulum dapibus nibh. Etiam iaculis nunc ac metus. Ut id nisl quis enim "
    "ignissim sagittis. Etiam sollicitudin, ipsum eu pulvinar rutrum, tellus "
    "psum laoreet sapien, quis venenatis ante odio sit amet eros. Proin magna. "
    "uis vel nibh at velit scelerisque suscipit. Curabitur turpis. Vestibulum "
    "uscipit nulla quis orci. Fusce ac felis sit amet ligula pharetra "
    "condimentum. "
    "aecenas egestas arcu quis ligula mattis placerat. Duis lobortis massa "
    "imperdiet "
    "uam. Suspendisse potenti.\n"
    "Pellentesque commodo eros a enim. Vestibulum turpis sem, aliquet eget, "
    "obortis pellentesque, rutrum eu, nisl. Sed libero. Aliquam erat volutpat. "
    "tiam vitae tortor. Morbi vestibulum volutpat enim. Aliquam eu nunc. Nunc "
    "ed turpis. Sed mollis, eros et ultrices tempus, mauris ipsum aliquam "
    "libero, "
    "on adipiscing dolor urna a orci. Nulla porta dolor. Class aptent taciti "
    "ociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. "
    "ellentesque dapibus hendrerit tortor. Praesent egestas tristique nibh. "
    "ed a libero. Cras varius. Donec vitae orci sed dolor rutrum auctor. Fusce "
    "gestas elit eget lorem.\n"
    "Suspendisse nisl elit, rhoncus eget, elementum ac, condimentum eget, "
    "diam. "
    "am at tortor in tellus interdum sagittis. Aliquam lobortis. Donec orci "
    "ectus, aliquam ut, faucibus non, euismod id, nulla. Curabitur blandit "
    "mollis "
    "acus. Nam adipiscing. Vestibulum eu odio. Vivamus laoreet. Nullam "
    "tincidunt "
    "dipiscing enim. Phasellus tempus. Proin viverra, ligula sit amet ultrices "
    "emper, ligula arcu tristique sapien, a accumsan nisi mauris ac eros. "
    "Fusce "
    "eque. Suspendisse faucibus, nunc et pellentesque egestas, lacus ante "
    "convallis "
    "ellus, vitae iaculis lacus elit id tortor. Vivamus aliquet elit ac nisl. "
    "usce fermentum odio nec arcu.\n"
    "Vivamus euismod mauris. In ut quam vitae odio lacinia tincidunt. Praesent "
    "t ligula non mi varius sagittis. Cras sagittis. Praesent ac sem eget est "
    "gestas volutpat. Vivamus consectetuer hendrerit lacus. Cras non dolor. "
    "ivamus in erat ut urna cursus vestibulum. Fusce commodo aliquam arcu. Nam "
    "ommodo suscipit quam. Quisque id odio. Praesent venenatis metus at tortor "
    "ulvinar varius. Lorem ipsum dolor sit amet, consectetuer adipiscing elit. "
    "enean commodo ligula eget dolor. Aenean massa. Cum sociis natoque "
    "penatibus "
    "t magnis dis parturient montes, nascetur ridiculus mus.\n"
    "Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. "
    "Nulla "
    "onsequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, "
    "ulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis "
    "itae, justo. Nullam dictum felis eu pede mollis pretium. Integer "
    "tincidunt. "
    "ras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend "
    "tellus. "
    "enean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. "
    "Aliquam "
    "orem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra "
    "ulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam "
    "ultricies "
    "isi vel augue.\n"
    "Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. "
    "Maecenas "
    "empus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet "
    "dipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus "
    "pulvinar, "
    "endrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec "
    "vitae "
    "apien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci "
    "get eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet "
    "nibh. "
    "onec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, "
    "ugue velit cursus nunc, quis gravida magna mi a libero. Fusce vulputate "
    "leifend sapien.\n"
    "Vestibulum purus quam, scelerisque ut, mollis sed, nonummy id, metus. "
    "Nullam "
    "ccumsan lorem in dui. Cras ultricies mi eu turpis hendrerit fringilla. "
    "estibulum ante ipsum primis in faucibus orci luctus et ultrices posuere "
    "ubilia Curae; In ac dui quis mi consectetuer lacinia. Nam pretium turpis "
    "t arcu. Duis arcu tortor, suscipit eget, imperdiet nec, imperdiet "
    "iaculis, "
    "psum. Sed aliquam ultrices mauris. Integer ante arcu, accumsan a, "
    "consectetuer "
    "get, posuere ut, mauris. Praesent adipiscing. Phasellus ullamcorper ipsum "
    "utrum nunc. Nunc nonummy metus. Vestibulum volutpat pretium libero. Cras "
    "d dui.\n"
    "Aenean ut eros et nisl sagittis vestibulum. Nullam nulla eros, ultricies "
    "it amet, nonummy id, imperdiet feugiat, pede. Sed lectus. Donec mollis "
    "endrerit risus. Phasellus nec sem in justo pellentesque facilisis. Etiam "
    "mperdiet imperdiet orci. Nunc nec neque. Phasellus leo dolor, tempus non, "
    "uctor et, hendrerit quis, nisi. Curabitur ligula sapien, tincidunt non, "
    "uismod vitae, posuere imperdiet, leo. Maecenas malesuada. Praesent congue "
    "rat at massa. Sed cursus turpis vitae tortor. Donec posuere vulputate "
    "arcu. "
    "hasellus accumsan cursus velit.\n"
    "Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere "
    "ubilia Curae; Sed aliquam, nisi quis porttitor congue, elit erat euismod "
    "rci, ac placerat dolor lectus quis orci. Phasellus consectetuer "
    "vestibulum "
    "lit. Aenean tellus metus, bibendum sed, posuere ac, mattis non, nunc. "
    "Vestibulum "
    "ringilla pede sit amet augue. In turpis. Pellentesque posuere. Praesent "
    "urpis. Aenean posuere, tortor sed cursus feugiat, nunc augue blandit "
    "nunc, "
    "u sollicitudin urna dolor sagittis lacus. Donec elit libero, sodales nec, "
    "olutpat a, suscipit non, turpis. Nullam sagittis.\n"
    "Suspendisse pulvinar, augue ac venenatis condimentum, sem libero volutpat "
    "ibh, nec pellentesque velit pede quis nunc. Vestibulum ante ipsum primis "
    "n faucibus orci luctus et ultrices posuere cubilia Curae; Fusce id purus. "
    "t varius tincidunt libero. Phasellus dolor. Maecenas vestibulum mollis "
    "iam. Pellentesque ut neque. Pellentesque habitant morbi tristique "
    "senectus "
    "t netus et malesuada fames ac turpis egestas. In dui magna, posuere eget, "
    "estibulum et, tempor auctor, justo. In ac felis quis tortor malesuada "
    "pretium. "
    "ellentesque auctor neque nec urna. Proin sapien ipsum, porta a, auctor "
    "uis, euismod ut, mi. Aenean viverra rhoncus pede.\n"
    "Pellentesque habitant morbi tristique senectus et netus et malesuada "
    "fames "
    "c turpis egestas. Ut non enim eleifend felis pretium feugiat. Vivamus "
    "quis "
    "i. Phasellus a est. Phasellus magna. In hac habitasse platea dictumst. "
    "urabitur at lacus ac velit ornare lobortis. Curabitur a felis in nunc "
    "fringilla "
    "ristique. Morbi mattis ullamcorper velit. Phasellus gravida semper nisi. "
    "ullam vel sem. Pellentesque libero tortor, tincidunt et, tincidunt eget, "
    "emper nec, quam. Sed hendrerit. Morbi ac felis. Nunc egestas, augue at "
    "ellentesque laoreet, felis eros vehicula leo, at malesuada velit leo quis "
    "ede.\n"
    "Donec interdum, metus et hendrerit aliquet, dolor diam sagittis ligula, "
    "get egestas libero turpis vel mi. Nunc nulla. Fusce risus nisl, viverra "
    "t, tempor et, pretium in, sapien. Donec venenatis vulputate lorem. Morbi "
    "ec metus. Phasellus blandit leo ut odio. Maecenas ullamcorper, dui et "
    "placerat "
    "eugiat, eros pede varius nisi, condimentum viverra felis nunc et lorem. "
    "ed magna purus, fermentum eu, tincidunt eu, varius ut, felis. In auctor "
    "obortis lacus. Quisque libero metus, condimentum nec, tempor a, commodo "
    "ollis, magna. Vestibulum ullamcorper mauris at ligula. Fusce fermentum. "
    "ullam cursus lacinia erat. Praesent blandit laoreet nibh.\n"
    "Fusce convallis metus id felis luctus adipiscing. Pellentesque egestas, "
    "eque sit amet convallis pulvinar, justo nulla eleifend augue, ac auctor "
    "rci leo non est. Quisque id mi. Ut tincidunt tincidunt erat. Etiam "
    "feugiat "
    "orem non metus. Vestibulum dapibus nunc ac augue. Curabitur vestibulum "
    "liquam leo. Praesent egestas neque eu enim. In hac habitasse platea "
    "dictumst. "
    "usce a quam. Etiam ut purus mattis mauris sodales aliquam. Curabitur "
    "nisi. "
    "uisque malesuada placerat nisl. Nam ipsum risus, rutrum vitae, vestibulum "
    "u, molestie vel, lacus. Sed augue ipsum, egestas nec, vestibulum et, "
    "malesuada "
    "dipiscing, dui.\n"
    "Vestibulum facilisis, purus nec pulvinar iaculis, ligula mi congue nunc, "
    "itae euismod ligula urna in dolor. Mauris sollicitudin fermentum libero. "
    "raesent nonummy mi in odio. Nunc interdum lacus sit amet orci. Vestibulum "
    "utrum, mi nec elementum vehicula, eros quam gravida nisl, id fringilla "
    "eque ante vel mi. Morbi mollis tellus ac sapien. Phasellus volutpat, "
    "metus "
    "get egestas mollis, lacus lacus blandit dui, id egestas quam mauris ut "
    "acus. Fusce vel dui. Sed in libero ut nibh placerat accumsan. Proin "
    "faucibus "
    "rcu quis ante. In consectetuer turpis ut velit. Nulla sit amet est. "
    "Praesent "
    "etus tellus, elementum eu, semper a, adipiscing nec, purus.\n"
    "Cras risus ipsum, faucibus ut, ullamcorper id, varius ac, leo. "
    "Suspendisse "
    "eugiat. Suspendisse enim turpis, dictum sed, iaculis a, condimentum nec, "
    "isi. Praesent nec nisl a purus blandit viverra. Praesent ac massa at "
    "ligula "
    "aoreet iaculis. Nulla neque dolor, sagittis eget, iaculis quis, molestie "
    "on, velit. Mauris turpis nunc, blandit et, volutpat molestie, porta ut, "
    "igula. Fusce pharetra convallis urna. Quisque ut nisi. Donec mi odio, "
    "faucibus "
    "t, scelerisque quis, convallis in, nisi. Suspendisse non nisl sit amet "
    "elit hendrerit rutrum. Ut leo. Ut a nisl id ante tempus hendrerit.\n"
    "Proin pretium, leo ac pellentesque mollis, felis nunc ultrices eros, sed "
    "ravida augue augue mollis justo. Suspendisse eu ligula. Nulla facilisi. "
    "onec id justo. Praesent porttitor, nulla vitae posuere iaculis, arcu nisl "
    "ignissim dolor, a pretium mi sem ut ipsum. Curabitur suscipit suscipit "
    "ellus. Praesent vestibulum dapibus nibh. Etiam iaculis nunc ac metus. Ut "
    "d nisl quis enim dignissim sagittis. Etiam sollicitudin, ipsum eu "
    "pulvinar "
    "utrum, tellus ipsum laoreet sapien, quis venenatis ante odio sit amet "
    "eros. "
    "roin magna. Duis vel nibh at velit scelerisque suscipit. Curabitur "
    "turpis. "
    "estibulum suscipit nulla quis orci. Fusce ac felis sit amet ligula "
    "pharetra "
    "ondimentum.\n"
    "Maecenas egestas arcu quis ligula mattis placerat. Duis lobortis massa "
    "mperdiet quam. Suspendisse potenti. Pellentesque commodo eros a enim. "
    "Vestibulum "
    "urpis sem, aliquet eget, lobortis pellentesque, rutrum eu, nisl. Sed "
    "libero. "
    "liquam erat volutpat. Etiam vitae tortor. Morbi vestibulum volutpat enim. "
    "liquam eu nunc. Nunc sed turpis. Sed mollis, eros et ultrices tempus, "
    "mauris "
    "psum aliquam libero, non adipiscing dolor urna a orci. Nulla porta dolor. "
    "lass aptent taciti sociosqu ad litora torquent per conubia nostra, per "
    "nceptos hymenaeos. Pellentesque dapibus hendrerit tortor. Praesent "
    "egestas "
    "ristique nibh. Sed a libero. Cras varius. Donec vitae orci sed dolor "
    "rutrum "
    "uctor.\n"
    "Fusce egestas elit eget lorem. Suspendisse nisl elit, rhoncus eget, "
    "elementum "
    "c, condimentum eget, diam. Nam at tortor in tellus interdum sagittis. "
    "Aliquam "
    "obortis. Donec orci lectus, aliquam ut, faucibus non, euismod id, nulla. "
    "urabitur blandit mollis lacus. Nam adipiscing. Vestibulum eu odio. "
    "Vivamus "
    "aoreet. Nullam tincidunt adipiscing enim. Phasellus tempus. Proin "
    "viverra, "
    "igula sit amet ultrices semper, ligula arcu tristique sapien, a accumsan "
    "isi mauris ac eros. Fusce neque. Suspendisse faucibus, nunc et "
    "pellentesque "
    "gestas, lacus ante convallis tellus, vitae iaculis lacus elit id tortor. "
    "ivamus aliquet elit ac nisl. Fusce fermentum odio nec arcu. Vivamus "
    "euismod "
    "auris.\n"
    "In ut quam vitae odio lacinia tincidunt. Praesent ut ligula non mi varius "
    "agittis. Cras sagittis. Praesent ac sem eget est egestas volutpat. "
    "Vivamus "
    "onsectetuer hendrerit lacus. Cras non dolor. Vivamus in erat ut urna "
    "cursus "
    "estibulum. Fusce commodo aliquam arcu. Nam commodo suscipit quam. Quisque "
    "d odio. Praesent venenatis metus at tortor pulvinar varius. Lorem ipsum "
    "olor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget "
    "olor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient "
    "ontes, nascetur ridiculus mus. Donec quam felis, ultricies nec, "
    "pellentesque "
    "u, pretium quis, sem. Nulla consequat massa quis enim.\n"
    "Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In "
    "nim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum "
    "elis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus "
    "elementum "
    "emper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, "
    "porttitor "
    "u, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, "
    "iverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius "
    "aoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. "
    "urabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. "
    "Maecenas "
    "empus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet "
    "dipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus "
    "pulvinar, "
    "endrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec "
    "vitae "
    "apien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci "
    "get eros faucibus tincidunt.\n");
}

namespace dwarfs {
namespace test {

const std::string& loremipsum() { return s_loremipsum; }

std::string loremipsum(size_t size) {
  std::string str;
  str.reserve(size);
  while (str.size() + s_loremipsum.size() <= size) {
    str += s_loremipsum;
  }
  str.append(s_loremipsum.data(), size - str.size());
  return str;
}
} // namespace test
} // namespace dwarfs
