#	$NetBSD: gnustep.mk,v 1.2 2004/08/27 06:29:07 jlam Exp $

.if !defined(GNUSTEP_MK)
GNUSTEP_MK=		#defined

.include "../../mk/bsd.prefs.mk"

GNUSTEP_SUBDIR=		share/GNUstep
GNUSTEP_ROOT=		${PREFIX}/${GNUSTEP_SUBDIR}
GNUSTEP_SYSTEM_ROOT=	${GNUSTEP_ROOT}/System
GNUSTEP_LOCAL_ROOT=	${GNUSTEP_ROOT}/Local
GNUSTEP_NETWORK_ROOT=	${GNUSTEP_ROOT}/Network
GNUSTEP_MAKEFILES=	${GNUSTEP_SYSTEM_ROOT}/Makefiles
GNUSTEP_HOST=		${MACHINE_GNU_PLATFORM}
GNUSTEP_HOST_CPU=	${MACHINE_GNU_ARCH:S/i386/ix86/}
GNUSTEP_HOST_VENDOR=	${LOWER_VENDOR}
GNUSTEP_HOST_OS=	${LOWER_OPSYS}

GNUSTEP_FLATTENED=	yes

GNUSTEP_USER_ROOT=	${BUILDLINK_DIR}/share/GNUstep
GNUSTEP_PATHLIST=	${GNUSTEP_USER_ROOT}:${GNUSTEP_LOCAL_ROOT}:${GNUSTEP_NETWORK_ROOT}:${GNUSTEP_SYSTEM_ROOT}
GNUSTEP_PATH=		${GNUSTEP_USER_ROOT}/Tools:${GNUSTEP_USER_ROOT}/Tools/${GNUSTEP_HOST_CPU}/${GNUSTEP_HOST_OS}:${GNUSTEP_LOCAL_ROOT}/Tools:${GNUSTEP_LOCAL_ROOT}/Tools/${GNUSTEP_HOST_CPU}/${GNUSTEP_HOST_OS}:${GNUSTEP_NETWORK_ROOT}/Tools:${GNUSTEP_NETWORK_ROOT}/Tools/${GNUSTEP_HOST_CPU}/${GNUSTEP_HOST_OS}:${GNUSTEP_SYSTEM_ROOT}/Tools:${GNUSTEP_SYSTEM_ROOT}/Tools/${GNUSTEP_HOST_CPU}/${GNUSTEP_HOST_OS}
GUILE_LOAD_PATH=	${GNUSTEP_USER_ROOT}/Libraries/Guile:${GNUSTEP_LOCAL_ROOT}/Libraries/Guile:${GNUSTEP_NETWORK_ROOT}/Libraries/Guile:${GNUSTEP_SYSTEM_ROOT}/Libraries/Guile
GNUSTEP_LDIR=	Library/Libraries
GNUSTEP_IDIR=	Library/Headers
GNUSTEP_LFLAGS=	${GNUSTEP_ROOT:S/^/-L/}/${GNUSTEP_LDIR} ${GNUSTEP_LOCAL_ROOT:S/^/-L/}/${GNUSTEP_LDIR} ${GNUSTEP_NETWORK_ROOT:S/^/-L/}/${GNUSTEP_LDIR} ${GNUSTEP_SYSTEM_ROOT:S/^/-L/}/${GNUSTEP_LDIR}
GNUSTEP_IFLAGS=	${GNUSTEP_ROOT:S/^/-I/}/${GNUSTEP_IDIR} ${GNUSTEP_LOCAL_ROOT:S/^/-I/}/${GNUSTEP_IDIR} ${GNUSTEP_NETWORK_ROOT:S/^/-I/}/${GNUSTEP_IDIR} ${GNUSTEP_SYSTEM_ROOT:S/^/-I/}/${GNUSTEP_IDIR}
GNUSTEP_LDIRS=	${GNUSTEP_LFLAGS:S/-L//g}
GNUSTEP_IDIRS=	${GNUSTEP_IFLAGS:S/-I//g}
GNUSTEP_BLDIRS=	${GNUSTEP_LDIRS:S/${PREFIX}\///g}
GNUSTEP_BIDIRS=	${GNUSTEP_IDIRS:S/${PREFIX}\///g}
.if !empty(_USE_RPATH:M[yY][eE][sS])
GNUSTEP_RFLAGS=	${GNUSTEP_LFLAGS:S/-L/${COMPILER_RPATH_FLAG}/g}
.else
GNUSTEP_RFLAGS?=
.endif
GNUSTEP_LDFLAGS=	${GNUSTEP_LFLAGS} ${GNUSTEP_RFLAGS}

.if !defined(NO_GNUSTEP_ENV)

PATH:=		${GNUSTEP_PATH}:${PATH}

LDFLAGS+=	${GNUSTEP_LDFLAGS}
CPPFLAGS+=	${GNUSTEP_IFLAGS}
CFLAGS+=	${GNUSTEP_IFLAGS}

USE_GNU_TOOLS+=	make
.if defined(GNUSTEP_MAKEFILE)
MAKEFILE=	${GNUSTEP_MAKEFILE}
.else
MAKEFILE=	GNUmakefile
.endif

.if !defined(NO_CONFIGURE)
GNU_CONFIGURE=	yes
.endif

MAKE_ENV+=	GNUSTEP_ROOT="${GNUSTEP_ROOT}"
MAKE_ENV+=	GNUSTEP_SYSTEM_ROOT="${GNUSTEP_SYSTEM_ROOT}"
MAKE_ENV+=	GNUSTEP_LOCAL_ROOT="${GNUSTEP_LOCAL_ROOT}"
MAKE_ENV+=	GNUSTEP_NETWORK_ROOT="${GNUSTEP_NETWORK_ROOT}"
MAKE_ENV+=	GNUSTEP_MAKEFILES="${GNUSTEP_MAKEFILES}"
MAKE_ENV+=	GNUSTEP_HOST="${GNUSTEP_HOST}"
MAKE_ENV+=	GNUSTEP_HOST_CPU="${GNUSTEP_HOST_CPU}"
MAKE_ENV+=	GNUSTEP_HOST_VENDOR="${GNUSTEP_HOST_VENDOR}"
MAKE_ENV+=	GNUSTEP_HOST_OS="${GNUSTEP_HOST_OS}"
MAKE_ENV+=	GNUSTEP_USER_ROOT="${GNUSTEP_USER_ROOT}"
MAKE_ENV+=	GNUSTEP_PATHLIST="${GNUSTEP_PATHLIST}"
MAKE_ENV+=	GNUSTEP_FLATTENED="${GNUSTEP_FLATTENED}"
MAKE_ENV+=	GUILE_LOAD_PATH="${GUILE_LOAD_PATH}"

.if defined(GNU_CONFIGURE)
GNU_CONFIGURE_PREFIX?=	${GNUSTEP_ROOT}
CONFIGURE_ENV+=	GNUSTEP_ROOT="${GNUSTEP_ROOT}"
CONFIGURE_ENV+=	GNUSTEP_SYSTEM_ROOT="${GNUSTEP_SYSTEM_ROOT}"
CONFIGURE_ENV+=	GNUSTEP_LOCAL_ROOT="${GNUSTEP_LOCAL_ROOT}"
CONFIGURE_ENV+=	GNUSTEP_NETWORK_ROOT="${GNUSTEP_NETWORK_ROOT}"
CONFIGURE_ENV+=	GNUSTEP_MAKEFILES="${GNUSTEP_MAKEFILES}"
CONFIGURE_ENV+=	GNUSTEP_HOST="${GNUSTEP_HOST}"
CONFIGURE_ENV+=	GNUSTEP_HOST_CPU="${GNUSTEP_HOST_CPU}"
CONFIGURE_ENV+=	GNUSTEP_HOST_VENDOR="${GNUSTEP_HOST_VENDOR}"
CONFIGURE_ENV+=	GNUSTEP_HOST_OS="${GNUSTEP_HOST_OS}"
CONFIGURE_ENV+=	GNUSTEP_USER_ROOT="${GNUSTEP_USER_ROOT}"
CONFIGURE_ENV+=	GNUSTEP_PATHLIST="${GNUSTEP_PATHLIST}"
CONFIGURE_ENV+=	GNUSTEP_FLATTENED="${GNUSTEP_FLATTENED}"
CONFIGURE_ENV+=	GUILE_LOAD_PATH="${GUILE_LOAD_PATH}"
.endif	# GNU_CONFIGURE
.endif	# !NO_GNUSTEP_ENV

.endif	# !defined(GNUSTEP_MK)
