#	$NetBSD: gnustep.mk,v 1.6 2005/12/05 20:50:04 rillig Exp $

.if !defined(GNUSTEP_MK)
GNUSTEP_MK=		#defined

.include "../../mk/bsd.prefs.mk"

GNUSTEP_SUBDIR=		share/GNUstep
GNUSTEP_ROOT=		${PREFIX}/${GNUSTEP_SUBDIR}
GNUSTEP_SYSTEM_ROOT=	${GNUSTEP_ROOT}/System
GNUSTEP_LOCAL_ROOT=	${GNUSTEP_ROOT}/Local
GNUSTEP_NETWORK_ROOT=	${GNUSTEP_ROOT}/Network
GNUSTEP_MAKEFILES=	${GNUSTEP_SYSTEM_ROOT}/Library/Makefiles
GNUSTEP_HOST=		${MACHINE_GNU_PLATFORM}
GNUSTEP_HOST_CPU=	${MACHINE_GNU_ARCH:S/i386/ix86/}
GNUSTEP_HOST_VENDOR=	${LOWER_VENDOR}
GNUSTEP_HOST_OS=	${LOWER_OPSYS}

GNUSTEP_FLATTENED=	yes

GNUSTEP_USER_ROOT=	${BUILDLINK_DIR}/share/GNUstep
GNUSTEP_PATHLIST=	${GNUSTEP_USER_ROOT}:${GNUSTEP_LOCAL_ROOT}:${GNUSTEP_NETWORK_ROOT}:${GNUSTEP_SYSTEM_ROOT}
GNUSTEP_PATH=		${GNUSTEP_USER_ROOT}/Tools:${GNUSTEP_USER_ROOT}/Tools/${GNUSTEP_HOST_CPU}/${GNUSTEP_HOST_OS}:${GNUSTEP_LOCAL_ROOT}/Tools:${GNUSTEP_LOCAL_ROOT}/Tools/${GNUSTEP_HOST_CPU}/${GNUSTEP_HOST_OS}:${GNUSTEP_NETWORK_ROOT}/Tools:${GNUSTEP_NETWORK_ROOT}/Tools/${GNUSTEP_HOST_CPU}/${GNUSTEP_HOST_OS}:${GNUSTEP_SYSTEM_ROOT}/Tools:${GNUSTEP_SYSTEM_ROOT}/Tools/${GNUSTEP_HOST_CPU}/${GNUSTEP_HOST_OS}
GUILE_LOAD_PATH=	${GNUSTEP_USER_ROOT}/Libraries/Guile:${GNUSTEP_LOCAL_ROOT}/Libraries/Guile:${GNUSTEP_NETWORK_ROOT}/Libraries/Guile:${GNUSTEP_SYSTEM_ROOT}/Libraries/Guile
GNUSTEP_LDIR=	Library/Libraries
GNUSTEP_IDIR=	Library/Headers
GNUSTEP_LFLAGS=	${GNUSTEP_ROOT:S/^/-L/}/${GNUSTEP_LDIR} ${GNUSTEP_LOCAL_ROOT:S/^/-L/}/${GNUSTEP_LDIR} ${GNUSTEP_NETWORK_ROOT:S/^/-L/}/${GNUSTEP_LDIR} ${GNUSTEP_SYSTEM_ROOT:S/^/-L/}/${GNUSTEP_LDIR}
GNUSTEP_IFLAGS=	${GNUSTEP_ROOT:S/^/-I/}/${GNUSTEP_IDIR} ${GNUSTEP_LOCAL_ROOT:S/^/-I/}/${GNUSTEP_IDIR} ${GNUSTEP_NETWORK_ROOT:S/^/-I/}/${GNUSTEP_IDIR} ${GNUSTEP_SYSTEM_ROOT:S/^/-I/}/${GNUSTEP_IDIR}
GNUSTEP_LDIRS=	${GNUSTEP_LFLAGS:S/-L//g}
GNUSTEP_IDIRS=	${GNUSTEP_IFLAGS:S/-I//g}
GNUSTEP_BLDIRS=	${GNUSTEP_LDIRS:S/${PREFIX}\///g}
GNUSTEP_BIDIRS=	${GNUSTEP_IDIRS:S/${PREFIX}\///g}
.if !empty(_USE_RPATH:M[yY][eE][sS])
GNUSTEP_RFLAGS=	${GNUSTEP_LFLAGS:S/-L/${COMPILER_RPATH_FLAG}/g}
.else
GNUSTEP_RFLAGS?=
.endif
GNUSTEP_LDFLAGS=	${GNUSTEP_LFLAGS} ${GNUSTEP_RFLAGS}

.if !defined(NO_GNUSTEP_ENV)

PATH:=		${GNUSTEP_PATH}:${PATH}

LDFLAGS+=	${GNUSTEP_LDFLAGS}
CPPFLAGS+=	${GNUSTEP_IFLAGS}
CFLAGS+=	${GNUSTEP_IFLAGS}

USE_TOOLS+=	gmake
.if defined(GNUSTEP_MAKEFILE)
MAKEFILE=	${GNUSTEP_MAKEFILE}
.else
MAKEFILE=	GNUmakefile
.endif

.if !defined(NO_CONFIGURE) && !defined(HAS_CONFIGURE)
GNU_CONFIGURE=	yes
.endif

MAKE_ENV+=	GNUSTEP_ROOT=${GNUSTEP_ROOT:Q}
MAKE_ENV+=	GNUSTEP_SYSTEM_ROOT=${GNUSTEP_SYSTEM_ROOT:Q}
MAKE_ENV+=	GNUSTEP_LOCAL_ROOT=${GNUSTEP_LOCAL_ROOT:Q}
MAKE_ENV+=	GNUSTEP_NETWORK_ROOT=${GNUSTEP_NETWORK_ROOT:Q}
MAKE_ENV+=	GNUSTEP_MAKEFILES=${GNUSTEP_MAKEFILES:Q}
MAKE_ENV+=	GNUSTEP_HOST=${GNUSTEP_HOST:Q}
MAKE_ENV+=	GNUSTEP_HOST_CPU=${GNUSTEP_HOST_CPU:Q}
MAKE_ENV+=	GNUSTEP_HOST_VENDOR=${GNUSTEP_HOST_VENDOR:Q}
MAKE_ENV+=	GNUSTEP_HOST_OS=${GNUSTEP_HOST_OS:Q}
MAKE_ENV+=	GNUSTEP_USER_ROOT=${GNUSTEP_USER_ROOT:Q}
MAKE_ENV+=	GNUSTEP_PATHLIST=${GNUSTEP_PATHLIST:Q}
MAKE_ENV+=	GNUSTEP_FLATTENED=${GNUSTEP_FLATTENED:Q}
MAKE_ENV+=	GUILE_LOAD_PATH=${GUILE_LOAD_PATH:Q}

.if defined(GNU_CONFIGURE) || defined(HAS_CONFIGURE)
GNU_CONFIGURE_PREFIX?=	${GNUSTEP_ROOT}
CONFIGURE_ENV+=	GNUSTEP_ROOT=${GNUSTEP_ROOT:Q}
CONFIGURE_ENV+=	GNUSTEP_SYSTEM_ROOT=${GNUSTEP_SYSTEM_ROOT:Q}
CONFIGURE_ENV+=	GNUSTEP_LOCAL_ROOT=${GNUSTEP_LOCAL_ROOT:Q}
CONFIGURE_ENV+=	GNUSTEP_NETWORK_ROOT=${GNUSTEP_NETWORK_ROOT:Q}
CONFIGURE_ENV+=	GNUSTEP_MAKEFILES=${GNUSTEP_MAKEFILES:Q}
CONFIGURE_ENV+=	GNUSTEP_HOST=${GNUSTEP_HOST:Q}
CONFIGURE_ENV+=	GNUSTEP_HOST_CPU=${GNUSTEP_HOST_CPU:Q}
CONFIGURE_ENV+=	GNUSTEP_HOST_VENDOR=${GNUSTEP_HOST_VENDOR:Q}
CONFIGURE_ENV+=	GNUSTEP_HOST_OS=${GNUSTEP_HOST_OS:Q}
CONFIGURE_ENV+=	GNUSTEP_USER_ROOT=${GNUSTEP_USER_ROOT:Q}
CONFIGURE_ENV+=	GNUSTEP_PATHLIST=${GNUSTEP_PATHLIST:Q}
CONFIGURE_ENV+=	GNUSTEP_FLATTENED=${GNUSTEP_FLATTENED:Q}
CONFIGURE_ENV+=	GUILE_LOAD_PATH=${GUILE_LOAD_PATH:Q}
.endif	# GNU_CONFIGURE
.endif	# !NO_GNUSTEP_ENV

.endif	# !defined(GNUSTEP_MK)
