.\" $NetBSD: wrapper.man,v 1.1.1.1 2005/01/25 13:00:46 jmmv Exp $
.\"
.\" pkg_alternatives - Generic wrappers for programs with similar interfaces
.\" Copyright (c) 2005 Julio M. Merino Vidal <jmmv@NetBSD.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Neither the name of The NetBSD Foundation nor the names of its
.\"    contributors may be used to endorse or promote products derived
.\"    from this software without specific prior written permission.
.\" 3. Neither the name of author nor the names of its contributors may
.\"    be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
.\" ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
.\" TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
.\" BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
.\" CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
.\" SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
.\" CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
.\" ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
.\" POSSIBILITY OF SUCH DAMAGE.
.\"
.Dd January 25, 2005
.Dt __TITLE__ __SECTION__
.Os
.Sh NAME
.Nm __WRAPPER__
.Nd generic wrapper created by the alternatives system
.Sh SYNOPSIS
.Nm
.Op arguments
.Sh DESCRIPTION
.Nm
is a generic wrapper created by the
.Xr pkg_alternatives 1
utility.
Its purpose is to execute a program that provides a similar interface
to the one expected by the more common name
.Nm .
.Pp
The program to be really run is determined from a list of alternatives.
You can check which one will be executed, as well as all available
candidates, by issuing:
.Bd -literal -offset indent
$ pkg_alternatives -w status __WRAPPERBASE__
.Ed
.Pp
Once you know which alternative is the chosen one, look at its manual page
for more information.
.Sh FILES
.Bl -tag -width XXXX
.It ~/.pkg_alternatives__PREFIX__/__WRAPPERBASE__
User-specific list of candidates.
.It __CONF_FILE__
System-wide list of candidates, automatically configured by installed
packages.
.It __DB_FILE__
System-wide list of candidates, manually configured by the administrator.
.El
.Sh SEE ALSO
.Xr pkg_alternatives 1
.Sh AUTHORS
.An Julio M. Merino Vidal Aq jmmv@NetBSD.org
