# $NetBSD: convenience.mk,v 1.9 2006/10/05 12:41:24 rillig Exp $
#
# Override "libltdlc.la" -- the libltdl "convenience" library embedded into
# programs that ship with libltdl.  Also override packages attempting to
# build and install the full "libltdl.la".

LIBLTDL_CONVENIENCE_SUBDIR?=	libltdl
.include "../../mk/bsd.prefs.mk"

post-patch: fix-libltdlc
.PHONY: fix-libltdlc
fix-libltdlc:
	@${STEP_MSG} 'Fixing libltdl convenience library linkage.'
.for sd in ${LIBLTDL_CONVENIENCE_SUBDIR}
	${_PKG_SILENT}${_PKG_DEBUG} set -e;				\
	cd ${WRKSRC}/${sd};						\
	rm -f Makefile Makefile.in Makefile.am configure* ltdl.h *.la;	\
	{ ${ECHO} "# Generated by devel/libltdl/convenience.mk";	\
	  ${ECHO} "all install clean check:";				\
	} > Makefile.in;						\
	cp Makefile.in Makefile;					\
	${LN} -s ${BUILDLINK_DIR}/include/ltdl.h ltdl.h;		\
	${LN} -s ${BUILDLINK_DIR}/lib/libltdl.la libltdl.la;		\
	${LN} -s ${BUILDLINK_DIR}/lib/libltdl.la libltdlc.la
.  if ${OPSYS} == "Darwin"
	${_PKG_SILENT}${_PKG_DEBUG}					\
	cd ${WRKSRC}/${sd} &&						\
	${LN} -s ${BUILDLINK_DIR}/lib/libltdl.dylib libltdlc.dylib
.  endif
.endfor

.include "../../devel/libltdl/buildlink3.mk"
