#
# $NetBSD: subr.sh,v 1.1 2007/08/01 21:33:46 tnn Exp $
#

DIFS="$IFS"
newline="
"

# The order in which files are generated by this script:
#
# someheader.h.tests --->  test_header() 
#                                       \
#                   someheader.h.in ---> +---> someheader.h.out ---+
#                                                                  |
#       someheader.h <--- someheader.h.pre <--- c preprocessor <---+
#
# someheader.h.tests:	Definitions of tests we want to perform on the system
#			supplied header. Each successfull test will cause a
#			@macro@ to be defined during the preprocessing stage.
# someheader.h.out:	The result of the tests concatenated with the .in file.
# someheader.h.pre:	The preprocessed output. In this file any compatiblity
#			definitions that weren't needed have been removed.
# someheader.h:		The final header to be installed.
#
# The syntax used in test definitions is:
#
# test_function|test_name|argument
# 
# Example:
#
# scan_preproc|have_printf|printf
#
# If the above line would be used in the file stdio.h.tests, it would test
# if the preprocessed output of <stdio.h> contains the string printf. If it
# does, the macro @have_printf@ will be defined when parsing stdio.h.in.


# Test if a given regexp can be found in the preprocessed output of the hdr.
test_scan_preproc() {
	IFS="$DIFS"
	echo "#include <$hdr>" | $CPP - 2>/dev/null | grep "$1" > /dev/null
	return $?
}

# Test if the specified header can be included.
test_have_header() {
	IFS="$DIFS"
	echo "#include <$1>" | $CPP - > /dev/null 2>&1
	return $?
}

# Prints the full absolute pathname to the file that is included by doing
# #include <file.h>.
real_header() {
	echo "#include <$hdr>" | $CPP - 2> /dev/null |\
		awk -F\" '/^\# 1 "\// {if(!done){print $2;done=1;}}'
}

# Prints the uppercase of $1 with some characters converted to underscore.
toupper() {
	echo "$@" | tr a-z A-Z | tr . _ | tr / _
}

# Run a single header test and print the result.
do_test() {
	testtype=$1
	testname=$2
	shift 2
	testarg="$@"
	IFS=""
	if test_${testtype} $testarg
	then
		echo "#define PH_TEST_`toupper $hdr`_$testname 1"
	fi
}

# Run all header tests for a header and print the result.
test_header() {
	IFS="$newline"
	for line in `cat $hdr.tests`
	do
	IFS="|"
	do_test $line
	IFS="$newline"
	done
}

# Test, preprocess and generate a header.
make_header() {
	hdr="$1"
	HDR="`toupper $hdr`"
	rm -f $hdr
	test_header > $hdr.out
	IFS="$DIFS"
	cat $hdr.in | sed 's/@\(.*\)@/PH_TEST_'$HDR'_\1/g' >> $hdr.out
	$CPP - < $hdr.out | awk '/^[^#]/ {sub("^@", "#");print $0;}' > $hdr.pre
	if [ -s "$hdr.pre" ]
	then
	echo "/* --- This header file was automatically generated by pkgsrc. */" > $hdr
	echo "#ifndef _PKGSRC_${HDR}_" >> $hdr
	echo "#define _PKGSRC_${HDR}_" >> $hdr
	real_hdr="`real_header $hdr`"
	if [ "$real_hdr" != "" ]
	then
		echo "/* --- real header: */" >> $hdr
	 	echo "#include \"$real_hdr\"" >> $hdr
	fi
	cat $hdr.pre >> $hdr
	echo "#endif /* _PKGSRC_${HDR}_ */" >> $hdr
	fi
}
