$NetBSD: patch-CVE-2012-1150-Objects_stringobject.c,v 1.1 2012/03/25 09:09:05 tron Exp $

Fix for CVE-2012-1150 taken from here:

http://hg.python.org/cpython/rev/6b7704fe1be1

--- Objects/stringobject.c.orig	2010-08-01 23:02:09.000000000 +0100
+++ Objects/stringobject.c	2012-03-25 09:51:50.000000000 +0100
@@ -1212,11 +1212,21 @@
     if (a->ob_shash != -1)
         return a->ob_shash;
     len = Py_SIZE(a);
+    /*
+      We make the hash of the empty string be 0, rather than using
+      (prefix ^ suffix), since this slightly obfuscates the hash secret
+    */
+    if (len == 0) {
+        a->ob_shash = 0;
+        return 0;
+    }
     p = (unsigned char *) a->ob_sval;
-    x = *p << 7;
+    x = _Py_HashSecret.prefix;
+    x ^= *p << 7;
     while (--len >= 0)
         x = (1000003*x) ^ *p++;
     x ^= Py_SIZE(a);
+    x ^= _Py_HashSecret.suffix;
     if (x == -1)
         x = -2;
     a->ob_shash = x;
