$NetBSD: patch-CVE-2012-1150-Lib_test_test_cmd_line.py,v 1.1 2012/03/24 12:04:37 tron Exp $

Fix for CVE-2012-1150 taken from here:

http://hg.python.org/cpython/rev/a0f43f4481e0

--- Lib/test/test_cmd_line.py.orig	2011-06-11 16:46:25.000000000 +0100
+++ Lib/test/test_cmd_line.py	2012-03-24 11:02:25.000000000 +0000
@@ -86,6 +86,20 @@
             self.exit_code('-c', 'pass'),
             0)
 
+    def test_hash_randomization(self):
+        # Verify that -R enables hash randomization:
+        self.verify_valid_flag('-R')
+        hashes = []
+        for i in range(2):
+            code = 'print(hash("spam"))'
+            data = self.start_python('-R', '-c', code)
+            hashes.append(data)
+        self.assertNotEqual(hashes[0], hashes[1])
+
+        # Verify that sys.flags contains hash_randomization
+        code = 'import sys; print sys.flags'
+        data = self.start_python('-R', '-c', code)
+        self.assertTrue('hash_randomization=1' in data)
 
 def test_main():
     test.test_support.run_unittest(CmdLineTest)
