$NetBSD: patch-setup.ml,v 1.1 2012/05/30 13:40:59 wiz Exp $

Patch the OASIS build system to work with NetBSD paths
--- ./setup.ml.orig	2011-11-04 16:49:08.000000000 +0000
+++ ./setup.ml
@@ -8,14 +8,14 @@
  *)
 
 (* OASIS_START *)
-(* DO NOT EDIT (digest: 91ec49eb394436f650011e25724ddc84) *)
+(* DO NOT EDIT (digest: 67254d8a270274ae12f65dbd0230134d) *)
 (*
    Regenerated by OASIS v0.2.0
    Visit http://oasis.forge.ocamlcore.org for more information and
    documentation about functions used in this file.
 *)
 module OASISGettext = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISGettext.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISGettext.ml"
   
   let ns_ str = 
     str
@@ -38,7 +38,7 @@ module OASISGettext = struct
 end
 
 module OASISContext = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISContext.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISContext.ml"
   
   open OASISGettext 
   
@@ -97,7 +97,7 @@ module OASISContext = struct
 end
 
 module OASISUtils = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISUtils.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISUtils.ml"
   
   module MapString = Map.Make(String)
   
@@ -249,7 +249,7 @@ module OASISUtils = struct
 end
 
 module PropList = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/PropList.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/PropList.ml"
   
   open OASISGettext
   
@@ -284,7 +284,7 @@ module PropList = struct
     let clear t =
       Hashtbl.clear t
   
-# 59 "/home/chambart/bordel/oasis/oasis/src/oasis/PropList.ml"
+# 66 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/PropList.ml"
   end
   
   module Schema = 
@@ -525,7 +525,7 @@ module PropList = struct
 end
 
 module OASISMessage = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISMessage.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISMessage.ml"
   
   
   open OASISGettext
@@ -574,7 +574,7 @@ module OASISMessage = struct
 end
 
 module OASISVersion = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISVersion.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISVersion.ml"
   
   open OASISGettext
   
@@ -758,7 +758,7 @@ module OASISVersion = struct
 end
 
 module OASISLicense = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISLicense.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISLicense.ml"
   
   (** License for _oasis fields
       @author Sylvain Le Gall
@@ -791,7 +791,7 @@ module OASISLicense = struct
 end
 
 module OASISExpr = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISExpr.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISExpr.ml"
   
   
   
@@ -881,7 +881,7 @@ module OASISExpr = struct
 end
 
 module OASISTypes = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISTypes.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISTypes.ml"
   
   
   
@@ -958,7 +958,7 @@ module OASISTypes = struct
   
   type plugin_data = (all_plugin * plugin_data_purpose * (unit -> unit)) list
   
-# 102 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISTypes.ml"
+# 102 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISTypes.ml"
   
   type 'a conditional = 'a OASISExpr.choices 
   
@@ -1072,6 +1072,9 @@ module OASISTypes = struct
     | Doc        of common_section * doc
     
   
+  type section_kind =
+      [ `Library | `Executable | `Flag | `SrcRepo | `Test | `Doc ]
+  
   type package = 
       {
         oasis_version:    OASISVersion.t;
@@ -1112,7 +1115,7 @@ module OASISTypes = struct
 end
 
 module OASISUnixPath = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISUnixPath.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISUnixPath.ml"
   
   type unix_filename = string
   type unix_dirname = string
@@ -1191,44 +1194,36 @@ module OASISUnixPath = struct
 end
 
 module OASISSection = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISSection.ml"
-  
-  (** Manipulate section 
-      @author Sylvain Le Gall
-    *)
-  
+# 1 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISSection.ml"
   open OASISTypes
   
-  type section_kind =
-    | KLibrary 
-    | KExecutable
-    | KFlag
-    | KSrcRepo
-    | KTest
-    | KDoc
-  
-  (** Extract generic information 
-    *)
   let section_kind_common = 
     function
       | Library (cs, _, _) -> 
-          KLibrary, cs
+          `Library, cs
       | Executable (cs, _, _) ->
-          KExecutable, cs
+          `Executable, cs
       | Flag (cs, _) ->
-          KFlag, cs
+          `Flag, cs
       | SrcRepo (cs, _) ->
-          KSrcRepo, cs
+          `SrcRepo, cs
       | Test (cs, _) ->
-          KTest, cs
+          `Test, cs
       | Doc (cs, _) ->
-          KDoc, cs
+          `Doc, cs
   
-  (** Common section of a section
-    *)
   let section_common sct =
     snd (section_kind_common sct)
   
+  let section_common_set cs =
+    function
+      | Library (_, bs, lib)     -> Library (cs, bs, lib)
+      | Executable (_, bs, exec) -> Executable (cs, bs, exec)
+      | Flag (_, flg)            -> Flag (cs, flg)
+      | SrcRepo (_, src_repo)    -> SrcRepo (cs, src_repo)
+      | Test (_, tst)            -> Test (cs, tst)
+      | Doc (_, doc)             -> Doc (cs, doc)
+  
   (** Key used to identify section
     *)
   let section_id sct = 
@@ -1242,23 +1237,23 @@ module OASISSection = struct
       section_id sct
     in
       (match k with
-         | KLibrary    -> "library" 
-         | KExecutable -> "executable"
-         | KFlag       -> "flag"
-         | KSrcRepo    -> "src repository"
-         | KTest       -> "test"
-         | KDoc        -> "doc")
+         | `Library    -> "library" 
+         | `Executable -> "executable"
+         | `Flag       -> "flag"
+         | `SrcRepo    -> "src repository"
+         | `Test       -> "test"
+         | `Doc        -> "doc")
       ^" "^nm
   
 end
 
 module OASISBuildSection = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISBuildSection.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISBuildSection.ml"
   
 end
 
 module OASISExecutable = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISExecutable.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISExecutable.ml"
   
   open OASISTypes
   
@@ -1289,7 +1284,7 @@ module OASISExecutable = struct
 end
 
 module OASISLibrary = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISLibrary.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISLibrary.ml"
   
   open OASISTypes
   open OASISUtils
@@ -1580,33 +1575,33 @@ module OASISLibrary = struct
 end
 
 module OASISFlag = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISFlag.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISFlag.ml"
   
 end
 
 module OASISPackage = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISPackage.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISPackage.ml"
   
 end
 
 module OASISSourceRepository = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISSourceRepository.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISSourceRepository.ml"
   
 end
 
 module OASISTest = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISTest.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISTest.ml"
   
 end
 
 module OASISDocument = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/oasis/OASISDocument.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/oasis/OASISDocument.ml"
   
 end
 
 
 module BaseEnvLight = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseEnvLight.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseEnvLight.ml"
   
   module MapString = Map.Make(String)
   
@@ -1703,7 +1698,7 @@ end
 
 
 module BaseContext = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseContext.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseContext.ml"
   
   open OASISContext 
   
@@ -1714,7 +1709,7 @@ module BaseContext = struct
 end
 
 module BaseMessage = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseMessage.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseMessage.ml"
   
   (** Message to user, overrid for Base 
       @author Sylvain Le Gall
@@ -1735,7 +1730,7 @@ module BaseMessage = struct
 end
 
 module BaseFilePath = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseFilePath.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseFilePath.ml"
   
   
   open Filename
@@ -1767,7 +1762,7 @@ module BaseFilePath = struct
 end
 
 module BaseEnv = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseEnv.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseEnv.ml"
   
   open OASISTypes
   open OASISGettext
@@ -2226,7 +2221,7 @@ module BaseEnv = struct
 end
 
 module BaseExec = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseExec.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseExec.ml"
   
   open OASISGettext
   open OASISUtils
@@ -2286,7 +2281,7 @@ module BaseExec = struct
 end
 
 module BaseFileUtil = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseFileUtil.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseFileUtil.ml"
   
   open OASISGettext
   
@@ -2464,7 +2459,7 @@ module BaseFileUtil = struct
 end
 
 module BaseArgExt = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseArgExt.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseArgExt.ml"
   
   open OASISUtils
   open OASISGettext
@@ -2492,7 +2487,7 @@ module BaseArgExt = struct
 end
 
 module BaseCheck = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseCheck.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseCheck.ml"
   
   open BaseEnv
   open BaseMessage
@@ -2618,7 +2613,7 @@ module BaseCheck = struct
 end
 
 module BaseOCamlcConfig = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseOCamlcConfig.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseOCamlcConfig.ml"
   
   
   open BaseEnv
@@ -2720,7 +2715,7 @@ module BaseOCamlcConfig = struct
 end
 
 module BaseStandardVar = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseStandardVar.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseStandardVar.ml"
   
   
   open OASISGettext
@@ -2980,7 +2975,7 @@ module BaseStandardVar = struct
 end
 
 module BaseFileAB = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseFileAB.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseFileAB.ml"
   
   open BaseEnv
   open OASISGettext
@@ -3028,7 +3023,7 @@ module BaseFileAB = struct
 end
 
 module BaseLog = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseLog.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseLog.ml"
   
   open OASISUtils
   
@@ -3147,7 +3142,7 @@ module BaseLog = struct
 end
 
 module BaseBuilt = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseBuilt.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseBuilt.ml"
   
   open OASISTypes
   open OASISGettext
@@ -3294,7 +3289,7 @@ module BaseBuilt = struct
 end
 
 module BaseCustom = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseCustom.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseCustom.ml"
   
   open BaseEnv
   open BaseMessage
@@ -3344,7 +3339,7 @@ module BaseCustom = struct
 end
 
 module BaseDynVar = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseDynVar.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseDynVar.ml"
   
   
   open OASISTypes
@@ -3388,7 +3383,7 @@ module BaseDynVar = struct
 end
 
 module BaseTest = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseTest.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseTest.ml"
   
   open BaseEnv
   open BaseMessage
@@ -3470,7 +3465,7 @@ module BaseTest = struct
 end
 
 module BaseDoc = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseDoc.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseDoc.ml"
   
   open BaseEnv
   open BaseMessage
@@ -3500,7 +3495,7 @@ module BaseDoc = struct
 end
 
 module BaseSetup = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseSetup.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseSetup.ml"
   
   open BaseEnv
   open BaseMessage
@@ -3918,7 +3913,7 @@ module BaseSetup = struct
 end
 
 module BaseDev = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/base/BaseDev.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/base/BaseDev.ml"
   
   
   
@@ -3976,7 +3971,7 @@ end
 
 
 module InternalConfigurePlugin = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/plugins/internal/InternalConfigurePlugin.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/plugins/internal/InternalConfigurePlugin.ml"
   
   (** Configure using internal scheme
       @author Sylvain Le Gall
@@ -4192,7 +4187,7 @@ module InternalConfigurePlugin = struct
 end
 
 module InternalInstallPlugin = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/plugins/internal/InternalInstallPlugin.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/plugins/internal/InternalInstallPlugin.ml"
   
   (** Install using internal scheme
       @author Sylvain Le Gall
@@ -4591,7 +4586,7 @@ end
 
 
 module OCamlbuildCommon = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/plugins/ocamlbuild/OCamlbuildCommon.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/plugins/ocamlbuild/OCamlbuildCommon.ml"
   
   (** Functions common to OCamlbuild build and doc plugin
     *)
@@ -4691,7 +4686,7 @@ module OCamlbuildCommon = struct
 end
 
 module OCamlbuildPlugin = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/plugins/ocamlbuild/OCamlbuildPlugin.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/plugins/ocamlbuild/OCamlbuildPlugin.ml"
   
   (** Build using ocamlbuild  
       @author Sylvain Le Gall
@@ -4935,7 +4930,7 @@ module OCamlbuildPlugin = struct
 end
 
 module OCamlbuildDocPlugin = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/plugins/ocamlbuild/OCamlbuildDocPlugin.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/plugins/ocamlbuild/OCamlbuildDocPlugin.ml"
   
   (* Create documentation using ocamlbuild .odocl files
      @author Sylvain Le Gall
@@ -4984,7 +4979,7 @@ end
 
 
 module CustomPlugin = struct
-# 21 "/home/chambart/bordel/oasis/oasis/src/plugins/custom/CustomPlugin.ml"
+# 21 "/home/jaapb/progs/ocsigen-repos/oasis/src/plugins/custom/CustomPlugin.ml"
   
   (** Generate custom configure/build/doc/test/install system
       @author
@@ -5126,11 +5121,11 @@ let setup_t =
      build = OCamlbuildPlugin.build;
      test =
        [
-          ("unix",
+          ("core",
             CustomPlugin.Test.main
               {
                  CustomPlugin.cmd_main =
-                   [(OASISExpr.EBool true, ("$test_unix", []))];
+                   [(OASISExpr.EBool true, ("$test_core", []))];
                  cmd_clean = [(OASISExpr.EBool true, None)];
                  cmd_distclean = [(OASISExpr.EBool true, None)];
                  });
@@ -5142,18 +5137,17 @@ let setup_t =
                  cmd_clean = [(OASISExpr.EBool true, None)];
                  cmd_distclean = [(OASISExpr.EBool true, None)];
                  });
-          ("core",
+          ("unix",
             CustomPlugin.Test.main
               {
                  CustomPlugin.cmd_main =
-                   [(OASISExpr.EBool true, ("$test_core", []))];
+                   [(OASISExpr.EBool true, ("$test_unix", []))];
                  cmd_clean = [(OASISExpr.EBool true, None)];
                  cmd_distclean = [(OASISExpr.EBool true, None)];
                  })
        ];
      doc =
        [
-          ("lwt-api", OCamlbuildDocPlugin.doc_build "./");
           ("lwt-manual",
             CustomPlugin.Doc.main
               {
@@ -5164,18 +5158,19 @@ let setup_t =
                    ];
                  cmd_clean = [(OASISExpr.EBool true, None)];
                  cmd_distclean = [(OASISExpr.EBool true, None)];
-                 })
+                 });
+          ("lwt-api", OCamlbuildDocPlugin.doc_build "./")
        ];
      install = InternalInstallPlugin.install;
      uninstall = InternalInstallPlugin.uninstall;
      clean = [OCamlbuildPlugin.clean];
      clean_test =
        [
-          ("unix",
+          ("core",
             CustomPlugin.Test.clean
               {
                  CustomPlugin.cmd_main =
-                   [(OASISExpr.EBool true, ("$test_unix", []))];
+                   [(OASISExpr.EBool true, ("$test_core", []))];
                  cmd_clean = [(OASISExpr.EBool true, None)];
                  cmd_distclean = [(OASISExpr.EBool true, None)];
                  });
@@ -5187,18 +5182,17 @@ let setup_t =
                  cmd_clean = [(OASISExpr.EBool true, None)];
                  cmd_distclean = [(OASISExpr.EBool true, None)];
                  });
-          ("core",
+          ("unix",
             CustomPlugin.Test.clean
               {
                  CustomPlugin.cmd_main =
-                   [(OASISExpr.EBool true, ("$test_core", []))];
+                   [(OASISExpr.EBool true, ("$test_unix", []))];
                  cmd_clean = [(OASISExpr.EBool true, None)];
                  cmd_distclean = [(OASISExpr.EBool true, None)];
                  })
        ];
      clean_doc =
        [
-          ("lwt-api", OCamlbuildDocPlugin.doc_clean "./");
           ("lwt-manual",
             CustomPlugin.Doc.clean
               {
@@ -5209,16 +5203,17 @@ let setup_t =
                    ];
                  cmd_clean = [(OASISExpr.EBool true, None)];
                  cmd_distclean = [(OASISExpr.EBool true, None)];
-                 })
+                 });
+          ("lwt-api", OCamlbuildDocPlugin.doc_clean "./")
        ];
      distclean = [];
      distclean_test =
        [
-          ("unix",
+          ("core",
             CustomPlugin.Test.distclean
               {
                  CustomPlugin.cmd_main =
-                   [(OASISExpr.EBool true, ("$test_unix", []))];
+                   [(OASISExpr.EBool true, ("$test_core", []))];
                  cmd_clean = [(OASISExpr.EBool true, None)];
                  cmd_distclean = [(OASISExpr.EBool true, None)];
                  });
@@ -5230,11 +5225,11 @@ let setup_t =
                  cmd_clean = [(OASISExpr.EBool true, None)];
                  cmd_distclean = [(OASISExpr.EBool true, None)];
                  });
-          ("core",
+          ("unix",
             CustomPlugin.Test.distclean
               {
                  CustomPlugin.cmd_main =
-                   [(OASISExpr.EBool true, ("$test_core", []))];
+                   [(OASISExpr.EBool true, ("$test_unix", []))];
                  cmd_clean = [(OASISExpr.EBool true, None)];
                  cmd_distclean = [(OASISExpr.EBool true, None)];
                  })
@@ -5433,7 +5428,12 @@ let setup_t =
                       bs_cclib =
                         [
                            (OASISExpr.EBool true, []);
-                           (OASISExpr.EFlag "libev", ["-lev"]);
+                           (OASISExpr.EFlag "libev",
+                             [
+                                "-lev";
+                                "-L${LOCALBASE}/lib/ev";
+                                "-Wl,-R${LOCALBASE}/lib/ev"
+                             ]);
                            (OASISExpr.ENot
                               (OASISExpr.ETest ("os_type", "Win32")),
                              ["-lpthread"]);
@@ -5441,13 +5441,23 @@ let setup_t =
                               (OASISExpr.ENot
                                  (OASISExpr.ETest ("os_type", "Win32")),
                                 OASISExpr.EFlag "libev"),
-                             ["-lpthread"; "-lev"]);
+                             [
+                                "-lpthread";
+                                "-lev";
+                                "-L${LOCALBASE}/lib/ev";
+                                "-Wl,-R${LOCALBASE}/lib/ev"
+                             ]);
                            (OASISExpr.ETest ("os_type", "Win32"),
                              ["ws2_32.lib"]);
                            (OASISExpr.EAnd
                               (OASISExpr.ETest ("os_type", "Win32"),
                                 OASISExpr.EFlag "libev"),
-                             ["ws2_32.lib"; "-lev"]);
+                             [
+                                "ws2_32.lib";
+                                "-lev";
+                                "-L${LOCALBASE}/lib/ev";
+                                "-Wl,-R${LOCALBASE}/lib/ev"
+                             ]);
                            (OASISExpr.EAnd
                               (OASISExpr.ETest ("os_type", "Win32"),
                                 OASISExpr.ENot
@@ -5459,7 +5469,13 @@ let setup_t =
                                    OASISExpr.ENot
                                      (OASISExpr.ETest ("os_type", "Win32"))),
                                 OASISExpr.EFlag "libev"),
-                             ["ws2_32.lib"; "-lpthread"; "-lev"])
+                             [
+                                "ws2_32.lib";
+                                "-lpthread";
+                                "-lev";
+                                "-L${LOCALBASE}/lib/ev";
+                                "-Wl,-R${LOCALBASE}/lib/ev"
+                             ])
                         ];
                       bs_dlllib = [(OASISExpr.EBool true, [])];
                       bs_dllpath = [(OASISExpr.EBool true, [])];
@@ -5618,9 +5634,43 @@ let setup_t =
                       lib_findlib_name = Some "text";
                       lib_findlib_containers = [];
                       });
+               Library
+                 ({
+                     cs_name = "lwt-syntax";
+                     cs_data = PropList.Data.create ();
+                     cs_plugin_data = [];
+                     },
+                   {
+                      bs_build = [(OASISExpr.EBool true, true)];
+                      bs_install = [(OASISExpr.EBool true, true)];
+                      bs_path = "syntax";
+                      bs_compiled_object = Best;
+                      bs_build_depends =
+                        [
+                           FindlibPackage ("camlp4.lib", None);
+                           FindlibPackage ("camlp4.quotations.o", None);
+                           FindlibPackage ("camlp4.extend", None)
+                        ];
+                      bs_build_tools = [ExternalTool "ocamlbuild"];
+                      bs_c_sources = [];
+                      bs_data_files = [];
+                      bs_ccopt = [(OASISExpr.EBool true, [])];
+                      bs_cclib = [(OASISExpr.EBool true, [])];
+                      bs_dlllib = [(OASISExpr.EBool true, [])];
+                      bs_dllpath = [(OASISExpr.EBool true, [])];
+                      bs_byteopt = [(OASISExpr.EBool true, [])];
+                      bs_nativeopt = [(OASISExpr.EBool true, [])];
+                      },
+                   {
+                      lib_modules = ["Pa_lwt"];
+                      lib_internal_modules = [];
+                      lib_findlib_parent = Some "lwt";
+                      lib_findlib_name = Some "syntax";
+                      lib_findlib_containers = [];
+                      });
                Executable
                  ({
-                     cs_name = "test_unix";
+                     cs_name = "test_core";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
@@ -5633,7 +5683,7 @@ let setup_t =
                              true)
                         ];
                       bs_install = [(OASISExpr.EBool true, false)];
-                      bs_path = "tests/unix";
+                      bs_path = "tests/core";
                       bs_compiled_object = Best;
                       bs_build_depends =
                         [
@@ -5653,22 +5703,34 @@ let setup_t =
                       bs_nativeopt = [(OASISExpr.EBool true, [])];
                       },
                    {exec_custom = false; exec_main_is = "main.ml"; });
-               Library
+               Executable
                  ({
-                     cs_name = "lwt-syntax";
+                     cs_name = "test_react";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
                    {
-                      bs_build = [(OASISExpr.EBool true, true)];
-                      bs_install = [(OASISExpr.EBool true, true)];
-                      bs_path = "syntax";
+                      bs_build =
+                        [
+                           (OASISExpr.EBool true, false);
+                           (OASISExpr.EOr
+                              (OASISExpr.EAnd
+                                 (OASISExpr.EFlag "unix",
+                                   OASISExpr.EFlag "react"),
+                                OASISExpr.EFlag "all"),
+                             true)
+                        ];
+                      bs_install = [(OASISExpr.EBool true, false)];
+                      bs_path = "tests/react";
                       bs_compiled_object = Best;
                       bs_build_depends =
                         [
-                           FindlibPackage ("camlp4.lib", None);
-                           FindlibPackage ("camlp4.quotations.o", None);
-                           FindlibPackage ("camlp4.extend", None)
+                           InternalLibrary "test";
+                           InternalLibrary "lwt";
+                           FindlibPackage ("unix", None);
+                           InternalLibrary "lwt-unix";
+                           FindlibPackage ("react", None);
+                           InternalLibrary "lwt-react"
                         ];
                       bs_build_tools = [ExternalTool "ocamlbuild"];
                       bs_c_sources = [];
@@ -5680,16 +5742,10 @@ let setup_t =
                       bs_byteopt = [(OASISExpr.EBool true, [])];
                       bs_nativeopt = [(OASISExpr.EBool true, [])];
                       },
-                   {
-                      lib_modules = ["Pa_lwt"];
-                      lib_internal_modules = [];
-                      lib_findlib_parent = Some "lwt";
-                      lib_findlib_name = Some "syntax";
-                      lib_findlib_containers = [];
-                      });
-               Executable
+                   {exec_custom = false; exec_main_is = "main.ml"; });
+               Library
                  ({
-                     cs_name = "test_react";
+                     cs_name = "lwt-preemptive";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
@@ -5698,23 +5754,25 @@ let setup_t =
                         [
                            (OASISExpr.EBool true, false);
                            (OASISExpr.EOr
-                              (OASISExpr.EAnd
-                                 (OASISExpr.EFlag "unix",
-                                   OASISExpr.EFlag "react"),
+                              (OASISExpr.EFlag "preemptive",
                                 OASISExpr.EFlag "all"),
                              true)
                         ];
-                      bs_install = [(OASISExpr.EBool true, false)];
-                      bs_path = "tests/react";
+                      bs_install =
+                        [
+                           (OASISExpr.EBool true, false);
+                           (OASISExpr.EOr
+                              (OASISExpr.EFlag "preemptive",
+                                OASISExpr.EFlag "all"),
+                             true)
+                        ];
+                      bs_path = "src/preemptive";
                       bs_compiled_object = Best;
                       bs_build_depends =
                         [
-                           InternalLibrary "test";
                            InternalLibrary "lwt";
-                           FindlibPackage ("unix", None);
                            InternalLibrary "lwt-unix";
-                           FindlibPackage ("react", None);
-                           InternalLibrary "lwt-react"
+                           FindlibPackage ("threads", None)
                         ];
                       bs_build_tools = [ExternalTool "ocamlbuild"];
                       bs_c_sources = [];
@@ -5726,10 +5784,16 @@ let setup_t =
                       bs_byteopt = [(OASISExpr.EBool true, [])];
                       bs_nativeopt = [(OASISExpr.EBool true, [])];
                       },
-                   {exec_custom = false; exec_main_is = "main.ml"; });
+                   {
+                      lib_modules = ["Lwt_preemptive"];
+                      lib_internal_modules = [];
+                      lib_findlib_parent = Some "lwt";
+                      lib_findlib_name = Some "preemptive";
+                      lib_findlib_containers = [];
+                      });
                Executable
                  ({
-                     cs_name = "test_core";
+                     cs_name = "test_unix";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
@@ -5742,7 +5806,7 @@ let setup_t =
                              true)
                         ];
                       bs_install = [(OASISExpr.EBool true, false)];
-                      bs_path = "tests/core";
+                      bs_path = "tests/unix";
                       bs_compiled_object = Best;
                       bs_build_depends =
                         [
@@ -5808,9 +5872,9 @@ let setup_t =
                       lib_findlib_name = Some "top";
                       lib_findlib_containers = [];
                       });
-               Library
+               Executable
                  ({
-                     cs_name = "lwt-preemptive";
+                     cs_name = "parallelize";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
@@ -5818,26 +5882,15 @@ let setup_t =
                       bs_build =
                         [
                            (OASISExpr.EBool true, false);
-                           (OASISExpr.EOr
-                              (OASISExpr.EFlag "preemptive",
-                                OASISExpr.EFlag "all"),
-                             true)
-                        ];
-                      bs_install =
-                        [
-                           (OASISExpr.EBool true, false);
-                           (OASISExpr.EOr
-                              (OASISExpr.EFlag "preemptive",
-                                OASISExpr.EFlag "all"),
-                             true)
+                           (OASISExpr.EFlag "unix", true)
                         ];
-                      bs_path = "src/preemptive";
+                      bs_install = [(OASISExpr.EBool true, false)];
+                      bs_path = "examples/unix";
                       bs_compiled_object = Best;
                       bs_build_depends =
                         [
-                           InternalLibrary "lwt";
                            InternalLibrary "lwt-unix";
-                           FindlibPackage ("threads", None)
+                           InternalLibrary "lwt-syntax"
                         ];
                       bs_build_tools = [ExternalTool "ocamlbuild"];
                       bs_c_sources = [];
@@ -5849,23 +5902,7 @@ let setup_t =
                       bs_byteopt = [(OASISExpr.EBool true, [])];
                       bs_nativeopt = [(OASISExpr.EBool true, [])];
                       },
-                   {
-                      lib_modules = ["Lwt_preemptive"];
-                      lib_internal_modules = [];
-                      lib_findlib_parent = Some "lwt";
-                      lib_findlib_name = Some "preemptive";
-                      lib_findlib_containers = [];
-                      });
-               Flag
-                 ({
-                     cs_name = "extra";
-                     cs_data = PropList.Data.create ();
-                     cs_plugin_data = [];
-                     },
-                   {
-                      flag_description = Some "Asynchronous unix functions";
-                      flag_default = [(OASISExpr.EBool true, true)];
-                      });
+                   {exec_custom = false; exec_main_is = "parallelize.ml"; });
                SrcRepo
                  ({
                      cs_name = "head";
@@ -5882,41 +5919,51 @@ let setup_t =
                       src_repo_tag = None;
                       src_repo_subdir = None;
                       });
-               Flag
-                 ({
-                     cs_name = "preemptive";
-                     cs_data = PropList.Data.create ();
-                     cs_plugin_data = [];
-                     },
-                   {
-                      flag_description = Some "Preemptive threads support";
-                      flag_default = [(OASISExpr.EBool true, true)];
-                      });
-               Library
+               Test
                  ({
-                     cs_name = "lwt-simple-top";
+                     cs_name = "core";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
                    {
-                      bs_build =
+                      test_type = (`Test, "custom", Some "0.2");
+                      test_command =
+                        [(OASISExpr.EBool true, ("$test_core", []))];
+                      test_custom =
+                        {
+                           pre_command = [(OASISExpr.EBool true, None)];
+                           post_command = [(OASISExpr.EBool true, None)];
+                           };
+                      test_working_directory = None;
+                      test_run =
                         [
                            (OASISExpr.EBool true, false);
                            (OASISExpr.EOr
                               (OASISExpr.EFlag "unix", OASISExpr.EFlag "all"),
                              true)
                         ];
-                      bs_install =
+                      test_tools =
                         [
-                           (OASISExpr.EBool true, false);
-                           (OASISExpr.EOr
-                              (OASISExpr.EFlag "unix", OASISExpr.EFlag "all"),
-                             true)
+                           ExternalTool "ocamlbuild";
+                           InternalExecutable "test_core"
                         ];
-                      bs_path = "src/simple_top";
+                      });
+               Library
+                 ({
+                     cs_name = "lwt-syntax-log";
+                     cs_data = PropList.Data.create ();
+                     cs_plugin_data = [];
+                     },
+                   {
+                      bs_build = [(OASISExpr.EBool true, true)];
+                      bs_install = [(OASISExpr.EBool true, true)];
+                      bs_path = "syntax";
                       bs_compiled_object = Best;
                       bs_build_depends =
-                        [InternalLibrary "lwt"; InternalLibrary "lwt-unix"];
+                        [
+                           FindlibPackage ("camlp4.lib", None);
+                           FindlibPackage ("camlp4.quotations.o", None)
+                        ];
                       bs_build_tools = [ExternalTool "ocamlbuild"];
                       bs_c_sources = [];
                       bs_data_files = [];
@@ -5928,79 +5975,20 @@ let setup_t =
                       bs_nativeopt = [(OASISExpr.EBool true, [])];
                       },
                    {
-                      lib_modules = [];
-                      lib_internal_modules = ["Lwt_simple_top"];
-                      lib_findlib_parent = Some "lwt";
-                      lib_findlib_name = Some "simple-top";
+                      lib_modules = ["Pa_lwt_log"];
+                      lib_internal_modules = [];
+                      lib_findlib_parent = Some "lwt-syntax";
+                      lib_findlib_name = Some "log";
                       lib_findlib_containers = [];
                       });
-               Flag
+               Doc
                  ({
-                     cs_name = "glib";
+                     cs_name = "lwt-manual";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
                    {
-                      flag_description = Some "Glib integration";
-                      flag_default = [(OASISExpr.EBool true, false)];
-                      });
-               Test
-                 ({
-                     cs_name = "unix";
-                     cs_data = PropList.Data.create ();
-                     cs_plugin_data = [];
-                     },
-                   {
-                      test_type = (`Test, "custom", Some "0.2");
-                      test_command =
-                        [(OASISExpr.EBool true, ("$test_unix", []))];
-                      test_custom =
-                        {
-                           pre_command = [(OASISExpr.EBool true, None)];
-                           post_command = [(OASISExpr.EBool true, None)];
-                           };
-                      test_working_directory = None;
-                      test_run =
-                        [
-                           (OASISExpr.EBool true, false);
-                           (OASISExpr.EOr
-                              (OASISExpr.EFlag "unix", OASISExpr.EFlag "all"),
-                             true)
-                        ];
-                      test_tools =
-                        [
-                           ExternalTool "ocamlbuild";
-                           InternalExecutable "test_unix"
-                        ];
-                      });
-               Flag
-                 ({
-                     cs_name = "unix";
-                     cs_data = PropList.Data.create ();
-                     cs_plugin_data = [];
-                     },
-                   {
-                      flag_description = Some "Unix support";
-                      flag_default = [(OASISExpr.EBool true, true)];
-                      });
-               Flag
-                 ({
-                     cs_name = "text";
-                     cs_data = PropList.Data.create ();
-                     cs_plugin_data = [];
-                     },
-                   {
-                      flag_description = Some "Text mode utilities";
-                      flag_default = [(OASISExpr.EBool true, false)];
-                      });
-               Doc
-                 ({
-                     cs_name = "lwt-api";
-                     cs_data = PropList.Data.create ();
-                     cs_plugin_data = [];
-                     },
-                   {
-                      doc_type = (`Doc, "ocamlbuild", Some "0.2");
+                      doc_type = (`Doc, "custom", Some "0.2");
                       doc_custom =
                         {
                            pre_command = [(OASISExpr.EBool true, None)];
@@ -6008,129 +5996,40 @@ let setup_t =
                            };
                       doc_build = [(OASISExpr.EBool true, true)];
                       doc_install = [(OASISExpr.EBool true, true)];
-                      doc_install_dir = "$htmldir/api";
-                      doc_title = "API reference for Lwt";
+                      doc_install_dir = "$pdfdir";
+                      doc_title = "Lwt user manual";
                       doc_authors = [];
                       doc_abstract = None;
                       doc_format = OtherDoc;
-                      doc_data_files = [("utils/style.css", None)];
-                      doc_build_tools =
-                        [ExternalTool "ocamlbuild"; ExternalTool "ocamldoc"];
+                      doc_data_files = [("manual/manual.pdf", None)];
+                      doc_build_tools = [ExternalTool "ocamlbuild"];
                       });
-               Library
+               Flag
                  ({
-                     cs_name = "lwt-glib";
+                     cs_name = "libev";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
                    {
-                      bs_build =
-                        [
-                           (OASISExpr.EBool true, false);
-                           (OASISExpr.EOr
-                              (OASISExpr.EFlag "glib", OASISExpr.EFlag "all"),
-                             true)
-                        ];
-                      bs_install =
+                      flag_description = Some "Compile with libev support";
+                      flag_default =
                         [
                            (OASISExpr.EBool true, false);
-                           (OASISExpr.EOr
-                              (OASISExpr.EFlag "glib", OASISExpr.EFlag "all"),
+                           (OASISExpr.ENot
+                              (OASISExpr.ETest ("os_type", "Win32")),
                              true)
                         ];
-                      bs_path = "src/glib";
-                      bs_compiled_object = Best;
-                      bs_build_depends =
-                        [InternalLibrary "lwt"; InternalLibrary "lwt-unix"];
-                      bs_build_tools = [ExternalTool "ocamlbuild"];
-                      bs_c_sources = ["lwt_glib_stubs.c"];
-                      bs_data_files = [];
-                      bs_ccopt = [(OASISExpr.EBool true, [])];
-                      bs_cclib = [(OASISExpr.EBool true, [])];
-                      bs_dlllib = [(OASISExpr.EBool true, [])];
-                      bs_dllpath = [(OASISExpr.EBool true, [])];
-                      bs_byteopt = [(OASISExpr.EBool true, [])];
-                      bs_nativeopt = [(OASISExpr.EBool true, [])];
-                      },
-                   {
-                      lib_modules = ["Lwt_glib"];
-                      lib_internal_modules = [];
-                      lib_findlib_parent = Some "lwt";
-                      lib_findlib_name = Some "glib";
-                      lib_findlib_containers = [];
                       });
                Flag
                  ({
-                     cs_name = "all";
+                     cs_name = "extra";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
                    {
-                      flag_description = Some "build and install everything";
-                      flag_default = [(OASISExpr.EBool true, false)];
+                      flag_description = Some "Asynchronous unix functions";
+                      flag_default = [(OASISExpr.EBool true, true)];
                       });
-               Executable
-                 ({
-                     cs_name = "relay";
-                     cs_data = PropList.Data.create ();
-                     cs_plugin_data = [];
-                     },
-                   {
-                      bs_build =
-                        [
-                           (OASISExpr.EBool true, false);
-                           (OASISExpr.EFlag "unix", true)
-                        ];
-                      bs_install = [(OASISExpr.EBool true, false)];
-                      bs_path = "examples/unix";
-                      bs_compiled_object = Best;
-                      bs_build_depends =
-                        [
-                           InternalLibrary "lwt-unix";
-                           InternalLibrary "lwt-syntax"
-                        ];
-                      bs_build_tools = [ExternalTool "ocamlbuild"];
-                      bs_c_sources = [];
-                      bs_data_files = [];
-                      bs_ccopt = [(OASISExpr.EBool true, [])];
-                      bs_cclib = [(OASISExpr.EBool true, [])];
-                      bs_dlllib = [(OASISExpr.EBool true, [])];
-                      bs_dllpath = [(OASISExpr.EBool true, [])];
-                      bs_byteopt = [(OASISExpr.EBool true, [])];
-                      bs_nativeopt = [(OASISExpr.EBool true, [])];
-                      },
-                   {exec_custom = false; exec_main_is = "relay.ml"; });
-               Executable
-                 ({
-                     cs_name = "logging";
-                     cs_data = PropList.Data.create ();
-                     cs_plugin_data = [];
-                     },
-                   {
-                      bs_build =
-                        [
-                           (OASISExpr.EBool true, false);
-                           (OASISExpr.EFlag "unix", true)
-                        ];
-                      bs_install = [(OASISExpr.EBool true, false)];
-                      bs_path = "examples/unix";
-                      bs_compiled_object = Best;
-                      bs_build_depends =
-                        [
-                           InternalLibrary "lwt-unix";
-                           InternalLibrary "lwt-syntax"
-                        ];
-                      bs_build_tools = [ExternalTool "ocamlbuild"];
-                      bs_c_sources = [];
-                      bs_data_files = [];
-                      bs_ccopt = [(OASISExpr.EBool true, [])];
-                      bs_cclib = [(OASISExpr.EBool true, [])];
-                      bs_dlllib = [(OASISExpr.EBool true, [])];
-                      bs_dllpath = [(OASISExpr.EBool true, [])];
-                      bs_byteopt = [(OASISExpr.EBool true, [])];
-                      bs_nativeopt = [(OASISExpr.EBool true, [])];
-                      },
-                   {exec_custom = false; exec_main_is = "logging.ml"; });
                Test
                  ({
                      cs_name = "react";
@@ -6163,49 +6062,6 @@ let setup_t =
                            InternalExecutable "test_react"
                         ];
                       });
-               Library
-                 ({
-                     cs_name = "lwt-syntax-log";
-                     cs_data = PropList.Data.create ();
-                     cs_plugin_data = [];
-                     },
-                   {
-                      bs_build = [(OASISExpr.EBool true, true)];
-                      bs_install = [(OASISExpr.EBool true, true)];
-                      bs_path = "syntax";
-                      bs_compiled_object = Best;
-                      bs_build_depends =
-                        [
-                           FindlibPackage ("camlp4.lib", None);
-                           FindlibPackage ("camlp4.quotations.o", None)
-                        ];
-                      bs_build_tools = [ExternalTool "ocamlbuild"];
-                      bs_c_sources = [];
-                      bs_data_files = [];
-                      bs_ccopt = [(OASISExpr.EBool true, [])];
-                      bs_cclib = [(OASISExpr.EBool true, [])];
-                      bs_dlllib = [(OASISExpr.EBool true, [])];
-                      bs_dllpath = [(OASISExpr.EBool true, [])];
-                      bs_byteopt = [(OASISExpr.EBool true, [])];
-                      bs_nativeopt = [(OASISExpr.EBool true, [])];
-                      },
-                   {
-                      lib_modules = ["Pa_lwt_log"];
-                      lib_internal_modules = [];
-                      lib_findlib_parent = Some "lwt-syntax";
-                      lib_findlib_name = Some "log";
-                      lib_findlib_containers = [];
-                      });
-               Flag
-                 ({
-                     cs_name = "react";
-                     cs_data = PropList.Data.create ();
-                     cs_plugin_data = [];
-                     },
-                   {
-                      flag_description = Some "React helpers";
-                      flag_default = [(OASISExpr.EBool true, false)];
-                      });
                Flag
                  ({
                      cs_name = "ssl";
@@ -6216,94 +6072,29 @@ let setup_t =
                       flag_description = Some "SSL support";
                       flag_default = [(OASISExpr.EBool true, false)];
                       });
-               Test
+               Flag
                  ({
-                     cs_name = "core";
+                     cs_name = "toplevel";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
                    {
-                      test_type = (`Test, "custom", Some "0.2");
-                      test_command =
-                        [(OASISExpr.EBool true, ("$test_core", []))];
-                      test_custom =
-                        {
-                           pre_command = [(OASISExpr.EBool true, None)];
-                           post_command = [(OASISExpr.EBool true, None)];
-                           };
-                      test_working_directory = None;
-                      test_run =
-                        [
-                           (OASISExpr.EBool true, false);
-                           (OASISExpr.EOr
-                              (OASISExpr.EFlag "unix", OASISExpr.EFlag "all"),
-                             true)
-                        ];
-                      test_tools =
-                        [
-                           ExternalTool "ocamlbuild";
-                           InternalExecutable "test_core"
-                        ];
+                      flag_description = Some "Enhanced toplevel";
+                      flag_default = [(OASISExpr.EBool true, false)];
                       });
-               Executable
-                 ({
-                     cs_name = "lwt-toplevel";
-                     cs_data = PropList.Data.create ();
-                     cs_plugin_data = [];
-                     },
-                   {
-                      bs_build =
-                        [
-                           (OASISExpr.EBool true, false);
-                           (OASISExpr.EOr
-                              (OASISExpr.EFlag "toplevel",
-                                OASISExpr.EFlag "all"),
-                             true)
-                        ];
-                      bs_install =
-                        [
-                           (OASISExpr.EBool true, false);
-                           (OASISExpr.EOr
-                              (OASISExpr.EFlag "toplevel",
-                                OASISExpr.EFlag "all"),
-                             true)
-                        ];
-                      bs_path = "src/top";
-                      bs_compiled_object = Byte;
-                      bs_build_depends =
-                        [
-                           InternalLibrary "lwt";
-                           InternalLibrary "lwt-top";
-                           InternalLibrary "lwt-text";
-                           InternalLibrary "lwt-react";
-                           FindlibPackage ("text", None);
-                           FindlibPackage ("findlib", None);
-                           FindlibPackage ("unix", None)
-                        ];
-                      bs_build_tools = [ExternalTool "ocamlbuild"];
-                      bs_c_sources = [];
-                      bs_data_files = [];
-                      bs_ccopt = [(OASISExpr.EBool true, [])];
-                      bs_cclib = [(OASISExpr.EBool true, [])];
-                      bs_dlllib = [(OASISExpr.EBool true, [])];
-                      bs_dllpath = [(OASISExpr.EBool true, [])];
-                      bs_byteopt = [(OASISExpr.EBool true, [])];
-                      bs_nativeopt = [(OASISExpr.EBool true, [])];
-                      },
-                   {exec_custom = false; exec_main_is = "lwt_toplevel.ml"; });
                Flag
                  ({
-                     cs_name = "toplevel";
+                     cs_name = "preemptive";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
                    {
-                      flag_description = Some "Enhanced toplevel";
-                      flag_default = [(OASISExpr.EBool true, false)];
+                      flag_description = Some "Preemptive threads support";
+                      flag_default = [(OASISExpr.EBool true, true)];
                       });
                Executable
                  ({
-                     cs_name = "parallelize";
+                     cs_name = "logging";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
@@ -6331,7 +6122,7 @@ let setup_t =
                       bs_byteopt = [(OASISExpr.EBool true, [])];
                       bs_nativeopt = [(OASISExpr.EBool true, [])];
                       },
-                   {exec_custom = false; exec_main_is = "parallelize.ml"; });
+                   {exec_custom = false; exec_main_is = "logging.ml"; });
                Library
                  ({
                      cs_name = "lwt-extra";
@@ -6489,12 +6280,12 @@ let setup_t =
                       });
                Doc
                  ({
-                     cs_name = "lwt-manual";
+                     cs_name = "lwt-api";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
                    {
-                      doc_type = (`Doc, "custom", Some "0.2");
+                      doc_type = (`Doc, "ocamlbuild", Some "0.2");
                       doc_custom =
                         {
                            pre_command = [(OASISExpr.EBool true, None)];
@@ -6502,29 +6293,254 @@ let setup_t =
                            };
                       doc_build = [(OASISExpr.EBool true, true)];
                       doc_install = [(OASISExpr.EBool true, true)];
-                      doc_install_dir = "$pdfdir";
-                      doc_title = "Lwt user manual";
+                      doc_install_dir = "$htmldir/api";
+                      doc_title = "API reference for Lwt";
                       doc_authors = [];
                       doc_abstract = None;
                       doc_format = OtherDoc;
-                      doc_data_files = [("manual/manual.pdf", None)];
-                      doc_build_tools = [ExternalTool "ocamlbuild"];
+                      doc_data_files = [("utils/style.css", None)];
+                      doc_build_tools =
+                        [ExternalTool "ocamlbuild"; ExternalTool "ocamldoc"];
                       });
+               Executable
+                 ({
+                     cs_name = "relay";
+                     cs_data = PropList.Data.create ();
+                     cs_plugin_data = [];
+                     },
+                   {
+                      bs_build =
+                        [
+                           (OASISExpr.EBool true, false);
+                           (OASISExpr.EFlag "unix", true)
+                        ];
+                      bs_install = [(OASISExpr.EBool true, false)];
+                      bs_path = "examples/unix";
+                      bs_compiled_object = Best;
+                      bs_build_depends =
+                        [
+                           InternalLibrary "lwt-unix";
+                           InternalLibrary "lwt-syntax"
+                        ];
+                      bs_build_tools = [ExternalTool "ocamlbuild"];
+                      bs_c_sources = [];
+                      bs_data_files = [];
+                      bs_ccopt = [(OASISExpr.EBool true, [])];
+                      bs_cclib = [(OASISExpr.EBool true, [])];
+                      bs_dlllib = [(OASISExpr.EBool true, [])];
+                      bs_dllpath = [(OASISExpr.EBool true, [])];
+                      bs_byteopt = [(OASISExpr.EBool true, [])];
+                      bs_nativeopt = [(OASISExpr.EBool true, [])];
+                      },
+                   {exec_custom = false; exec_main_is = "relay.ml"; });
                Flag
                  ({
-                     cs_name = "libev";
+                     cs_name = "all";
                      cs_data = PropList.Data.create ();
                      cs_plugin_data = [];
                      },
                    {
-                      flag_description = Some "Compile with libev support";
-                      flag_default =
+                      flag_description = Some "build and install everything";
+                      flag_default = [(OASISExpr.EBool true, false)];
+                      });
+               Library
+                 ({
+                     cs_name = "lwt-simple-top";
+                     cs_data = PropList.Data.create ();
+                     cs_plugin_data = [];
+                     },
+                   {
+                      bs_build =
                         [
                            (OASISExpr.EBool true, false);
-                           (OASISExpr.ENot
-                              (OASISExpr.ETest ("os_type", "Win32")),
+                           (OASISExpr.EOr
+                              (OASISExpr.EFlag "unix", OASISExpr.EFlag "all"),
+                             true)
+                        ];
+                      bs_install =
+                        [
+                           (OASISExpr.EBool true, false);
+                           (OASISExpr.EOr
+                              (OASISExpr.EFlag "unix", OASISExpr.EFlag "all"),
+                             true)
+                        ];
+                      bs_path = "src/simple_top";
+                      bs_compiled_object = Best;
+                      bs_build_depends =
+                        [InternalLibrary "lwt"; InternalLibrary "lwt-unix"];
+                      bs_build_tools = [ExternalTool "ocamlbuild"];
+                      bs_c_sources = [];
+                      bs_data_files = [];
+                      bs_ccopt = [(OASISExpr.EBool true, [])];
+                      bs_cclib = [(OASISExpr.EBool true, [])];
+                      bs_dlllib = [(OASISExpr.EBool true, [])];
+                      bs_dllpath = [(OASISExpr.EBool true, [])];
+                      bs_byteopt = [(OASISExpr.EBool true, [])];
+                      bs_nativeopt = [(OASISExpr.EBool true, [])];
+                      },
+                   {
+                      lib_modules = [];
+                      lib_internal_modules = ["Lwt_simple_top"];
+                      lib_findlib_parent = Some "lwt";
+                      lib_findlib_name = Some "simple-top";
+                      lib_findlib_containers = [];
+                      });
+               Flag
+                 ({
+                     cs_name = "glib";
+                     cs_data = PropList.Data.create ();
+                     cs_plugin_data = [];
+                     },
+                   {
+                      flag_description = Some "Glib integration";
+                      flag_default = [(OASISExpr.EBool true, false)];
+                      });
+               Flag
+                 ({
+                     cs_name = "unix";
+                     cs_data = PropList.Data.create ();
+                     cs_plugin_data = [];
+                     },
+                   {
+                      flag_description = Some "Unix support";
+                      flag_default = [(OASISExpr.EBool true, true)];
+                      });
+               Flag
+                 ({
+                     cs_name = "text";
+                     cs_data = PropList.Data.create ();
+                     cs_plugin_data = [];
+                     },
+                   {
+                      flag_description = Some "Text mode utilities";
+                      flag_default = [(OASISExpr.EBool true, false)];
+                      });
+               Flag
+                 ({
+                     cs_name = "react";
+                     cs_data = PropList.Data.create ();
+                     cs_plugin_data = [];
+                     },
+                   {
+                      flag_description = Some "React helpers";
+                      flag_default = [(OASISExpr.EBool true, false)];
+                      });
+               Test
+                 ({
+                     cs_name = "unix";
+                     cs_data = PropList.Data.create ();
+                     cs_plugin_data = [];
+                     },
+                   {
+                      test_type = (`Test, "custom", Some "0.2");
+                      test_command =
+                        [(OASISExpr.EBool true, ("$test_unix", []))];
+                      test_custom =
+                        {
+                           pre_command = [(OASISExpr.EBool true, None)];
+                           post_command = [(OASISExpr.EBool true, None)];
+                           };
+                      test_working_directory = None;
+                      test_run =
+                        [
+                           (OASISExpr.EBool true, false);
+                           (OASISExpr.EOr
+                              (OASISExpr.EFlag "unix", OASISExpr.EFlag "all"),
+                             true)
+                        ];
+                      test_tools =
+                        [
+                           ExternalTool "ocamlbuild";
+                           InternalExecutable "test_unix"
+                        ];
+                      });
+               Executable
+                 ({
+                     cs_name = "lwt-toplevel";
+                     cs_data = PropList.Data.create ();
+                     cs_plugin_data = [];
+                     },
+                   {
+                      bs_build =
+                        [
+                           (OASISExpr.EBool true, false);
+                           (OASISExpr.EOr
+                              (OASISExpr.EFlag "toplevel",
+                                OASISExpr.EFlag "all"),
+                             true)
+                        ];
+                      bs_install =
+                        [
+                           (OASISExpr.EBool true, false);
+                           (OASISExpr.EOr
+                              (OASISExpr.EFlag "toplevel",
+                                OASISExpr.EFlag "all"),
                              true)
                         ];
+                      bs_path = "src/top";
+                      bs_compiled_object = Byte;
+                      bs_build_depends =
+                        [
+                           InternalLibrary "lwt";
+                           InternalLibrary "lwt-top";
+                           InternalLibrary "lwt-text";
+                           InternalLibrary "lwt-react";
+                           FindlibPackage ("text", None);
+                           FindlibPackage ("findlib", None);
+                           FindlibPackage ("unix", None)
+                        ];
+                      bs_build_tools = [ExternalTool "ocamlbuild"];
+                      bs_c_sources = [];
+                      bs_data_files = [];
+                      bs_ccopt = [(OASISExpr.EBool true, [])];
+                      bs_cclib = [(OASISExpr.EBool true, [])];
+                      bs_dlllib = [(OASISExpr.EBool true, [])];
+                      bs_dllpath = [(OASISExpr.EBool true, [])];
+                      bs_byteopt = [(OASISExpr.EBool true, [])];
+                      bs_nativeopt = [(OASISExpr.EBool true, [])];
+                      },
+                   {exec_custom = false; exec_main_is = "lwt_toplevel.ml"; });
+               Library
+                 ({
+                     cs_name = "lwt-glib";
+                     cs_data = PropList.Data.create ();
+                     cs_plugin_data = [];
+                     },
+                   {
+                      bs_build =
+                        [
+                           (OASISExpr.EBool true, false);
+                           (OASISExpr.EOr
+                              (OASISExpr.EFlag "glib", OASISExpr.EFlag "all"),
+                             true)
+                        ];
+                      bs_install =
+                        [
+                           (OASISExpr.EBool true, false);
+                           (OASISExpr.EOr
+                              (OASISExpr.EFlag "glib", OASISExpr.EFlag "all"),
+                             true)
+                        ];
+                      bs_path = "src/glib";
+                      bs_compiled_object = Best;
+                      bs_build_depends =
+                        [InternalLibrary "lwt"; InternalLibrary "lwt-unix"];
+                      bs_build_tools = [ExternalTool "ocamlbuild"];
+                      bs_c_sources = ["lwt_glib_stubs.c"];
+                      bs_data_files = [];
+                      bs_ccopt = [(OASISExpr.EBool true, [])];
+                      bs_cclib = [(OASISExpr.EBool true, [])];
+                      bs_dlllib = [(OASISExpr.EBool true, [])];
+                      bs_dllpath = [(OASISExpr.EBool true, [])];
+                      bs_byteopt = [(OASISExpr.EBool true, [])];
+                      bs_nativeopt = [(OASISExpr.EBool true, [])];
+                      },
+                   {
+                      lib_modules = ["Lwt_glib"];
+                      lib_internal_modules = [];
+                      lib_findlib_parent = Some "lwt";
+                      lib_findlib_name = Some "glib";
+                      lib_findlib_containers = [];
                       })
             ];
           plugins =
