$NetBSD: patch-i18n_csrucode.cpp,v 1.1.2.1 2013/12/16 16:12:01 tron Exp $

Fix for CVE-2013-2924.

--- i18n/csrucode.cpp.orig	2013-05-23 20:01:36.000000000 +0000
+++ i18n/csrucode.cpp
@@ -33,8 +33,9 @@ UBool CharsetRecog_UTF_16_BE::match(Inpu
 {
     const uint8_t *input = textIn->fRawInput;
     int32_t confidence = 0;
+    int32_t length = textIn->fRawLength;
 
-    if (input[0] == 0xFE && input[1] == 0xFF) {
+    if (length >=2 && input[0] == 0xFE && input[1] == 0xFF) {
         confidence = 100;
     }
 
@@ -57,8 +58,9 @@ UBool CharsetRecog_UTF_16_LE::match(Inpu
 {
     const uint8_t *input = textIn->fRawInput;
     int32_t confidence = 0;
+    int32_t length = textIn->fRawLength;
 
-    if (input[0] == 0xFF && input[1] == 0xFE && (input[2] != 0x00 || input[3] != 0x00)) {
+    if (length >= 4 && input[0] == 0xFF && input[1] == 0xFE && (input[2] != 0x00 || input[3] != 0x00)) {
         confidence = 100;
     }
 
@@ -81,7 +83,7 @@ UBool CharsetRecog_UTF_32::match(InputTe
     bool hasBOM = FALSE;
     int32_t confidence = 0;
 
-    if (getChar(input, 0) == 0x0000FEFFUL) {
+    if (limit > 0 && getChar(input, 0) == 0x0000FEFFUL) {
         hasBOM = TRUE;
     }
 
