$NetBSD: patch-cmake_modules_FindGStreamer.cmake,v 1.1 2015/12/01 13:11:49 jaapb Exp $

Search for gst/gstconfig.h explicitly. Patch is in upstream repository:
http://cgit.freedesktop.org/telepathy/telepathy-qt/commit/?id=ec4a3d62b68a57254515f01fc5ea3325ffb1dbfb
--- cmake/modules/FindGStreamer.cmake.orig	2015-05-24 19:33:18.000000000 +0000
+++ cmake/modules/FindGStreamer.cmake
@@ -13,12 +13,12 @@
 
 # TODO: Other versions --> GSTREAMER_X_Y_FOUND (Example: GSTREAMER_0_8_FOUND and GSTREAMER_0_10_FOUND etc)
 
-IF (GSTREAMER_INCLUDE_DIR AND GSTREAMER_LIBRARIES AND GSTREAMER_BASE_LIBRARY AND GSTREAMER_INTERFACE_LIBRARY)
+IF (GSTREAMER_INCLUDE_DIRS AND GSTREAMER_LIBRARIES AND GSTREAMER_BASE_LIBRARY AND GSTREAMER_INTERFACE_LIBRARY)
    # in cache already
    SET(GSTREAMER_FIND_QUIETLY TRUE)
-ELSE (GSTREAMER_INCLUDE_DIR AND GSTREAMER_LIBRARIES AND GSTREAMER_BASE_LIBRARY AND GSTREAMER_INTERFACE_LIBRARY)
+ELSE (GSTREAMER_INCLUDE_DIRS AND GSTREAMER_LIBRARIES AND GSTREAMER_BASE_LIBRARY AND GSTREAMER_INTERFACE_LIBRARY)
    SET(GSTREAMER_FIND_QUIETLY FALSE)
-ENDIF (GSTREAMER_INCLUDE_DIR AND GSTREAMER_LIBRARIES AND GSTREAMER_BASE_LIBRARY AND GSTREAMER_INTERFACE_LIBRARY)
+ENDIF (GSTREAMER_INCLUDE_DIRS AND GSTREAMER_LIBRARIES AND GSTREAMER_BASE_LIBRARY AND GSTREAMER_INTERFACE_LIBRARY)
 
 IF (NOT WIN32)
    # use pkg-config to get the directories and then use these values
@@ -38,6 +38,15 @@ FIND_PATH(GSTREAMER_INCLUDE_DIR gst/gst.
    PATH_SUFFIXES gstreamer-1.0
    )
 
+FIND_PATH(GSTREAMER_CONF_INCLUDE_DIR gst/gstconfig.h
+   PATHS
+   ${PC_GSTREAMER_INCLUDEDIR}
+   ${PC_GSTREAMER_INCLUDE_DIRS}
+   PATH_SUFFIXES gstreamer-1.0
+   )
+
+SET(GSTREAMER_INCLUDE_DIRS ${GSTREAMER_INCLUDE_DIR} ${GSTREAMER_CONF_INCLUDE_DIR})
+
 FIND_LIBRARY(GSTREAMER_LIBRARIES NAMES gstreamer-1.0
    PATHS
    ${PC_GSTREAMER_LIBDIR}
@@ -57,6 +66,13 @@ ELSE (GSTREAMER_INCLUDE_DIR)
    MESSAGE(STATUS "GStreamer: WARNING: include dir not found")
 ENDIF (GSTREAMER_INCLUDE_DIR)
 
+IF (GSTREAMER_CONF_INCLUDE_DIR)
+   #MESSAGE(STATUS "DEBUG: Found GStreamer config include dir: ${GSTREAMER_CONF_INCLUDE_DIR}")
+ELSE (GSTREAMER_CONF_INCLUDE_DIR)
+   MESSAGE(STATUS "GStreamer: WARNING: config include dir not found")
+ENDIF (GSTREAMER_CONF_INCLUDE_DIR)
+
+
 IF (GSTREAMER_LIBRARIES)
    #MESSAGE(STATUS "DEBUG: Found GStreamer library: ${GSTREAMER_LIBRARIES}")
 ELSE (GSTREAMER_LIBRARIES)
@@ -65,6 +81,6 @@ ENDIF (GSTREAMER_LIBRARIES)
 
 
 INCLUDE(FindPackageHandleStandardArgs)
-FIND_PACKAGE_HANDLE_STANDARD_ARGS(GStreamer  DEFAULT_MSG  GSTREAMER_LIBRARIES GSTREAMER_INCLUDE_DIR GSTREAMER_BASE_LIBRARY)
+FIND_PACKAGE_HANDLE_STANDARD_ARGS(GStreamer  DEFAULT_MSG  GSTREAMER_LIBRARIES GSTREAMER_INCLUDE_DIRS GSTREAMER_BASE_LIBRARY)
 
-MARK_AS_ADVANCED(GSTREAMER_INCLUDE_DIR GSTREAMER_LIBRARIES GSTREAMER_BASE_LIBRARY)
+MARK_AS_ADVANCED(GSTREAMER_INCLUDE_DIRS GSTREAMER_LIBRARIES GSTREAMER_BASE_LIBRARY)
