package main

// This file defines the specific type of some variables.
//
// There are two types of lists:
// * lkShell is a list whose elements are split by shell rules
// * lkSpace is a list whose elements are split by whitespace
//
// See vartypecheck.go for how these types are checked.
//
// Last synced with mk/defaults/mk.conf revision 1.118

func (gd *GlobalData) InitVartypes() {
	usr("ALLOW_VULNERABLE_PACKAGES", lkNone, CheckvarYes)
	usr("MANINSTALL", lkShell, enum("maninstall catinstall"))
	usr("MANZ", lkNone, CheckvarYes)
	usr("GZIP", lkShell, CheckvarShellWord)
	usr("MKCRYPTO", lkNone, CheckvarYesNo)
	usr("OBJHOSTNAME", lkNone, CheckvarYes)
	usr("OBJMACHINE", lkNone, CheckvarYes)
	usr("PKG_SUFX", lkNone, CheckvarFilename)
	usr("PKGSRC_LOCKTYPE", lkNone, enum("none sleep once"))
	usr("PKGSRC_SLEEPSECS", lkNone, CheckvarInteger)
	usr("USETBL", lkNone, CheckvarYes)
	usr("ABI", lkNone, enum("32 64"))
	usr("PKG_DEVELOPER", lkNone, CheckvarYes)
	usr("USE_ABI_DEPENDS", lkNone, CheckvarYesNo)
	usr("PKG_REGISTER_SHELLS", lkNone, enum("YES NO"))
	usr("PKGSRC_COMPILER", lkShell, enum("ccache ccc clang distcc f2c gcc hp icc ido gcc mipspro mipspro-ucode pcc sunpro xlc"))
	usr("PKGSRC_MESSAGE_RECIPIENTS", lkShell, CheckvarMailAddress)
	usr("PKGSRC_SHOW_BUILD_DEFS", lkNone, CheckvarYesNo)
	usr("PKGSRC_SHOW_PATCH_ERRORMSG", lkNone, CheckvarYesNo)
	usr("PKGSRC_RUN_TEST", lkNone, CheckvarYesNo)
	usr("PREFER_PKGSRC", lkShell, CheckvarIdentifier)
	usr("PREFER_NATIVE", lkShell, CheckvarIdentifier)
	usr("PREFER_NATIVE_PTHREADS", lkNone, CheckvarYesNo)
	usr("LOCALBASE", lkNone, CheckvarPathname)
	usr("CROSSBASE", lkNone, CheckvarPathname)
	usr("VARBASE", lkNone, CheckvarPathname)
	usr("X11_TYPE", lkNone, enum("modular native"))
	usr("X11BASE", lkNone, CheckvarPathname)
	usr("MOTIFBASE", lkNone, CheckvarPathname)
	usr("PKGINFODIR", lkNone, CheckvarPathname)
	usr("PKGMANDIR", lkNone, CheckvarPathname)
	usr("USE_XPKGWEDGE", lkNone, CheckvarYesNo)
	usr("BSDSRCDIR", lkNone, CheckvarPathname)
	usr("BSDXSRCDIR", lkNone, CheckvarPathname)
	usr("DISTDIR", lkNone, CheckvarPathname)
	usr("DIST_PATH", lkNone, CheckvarPathlist)
	usr("DEFAULT_VIEW", lkNone, CheckvarUnchecked)
	usr("FETCH_CMD", lkNone, CheckvarShellCommand)
	usr("FETCH_USING", lkNone, enum("curl custom fetch ftp manual wget"))
	usr("FETCH_RESUME_ARGS", lkShell, CheckvarShellWord)
	usr("FETCH_OUTPUT_ARGS", lkShell, CheckvarShellWord)
	usr("LIBTOOLIZE_PLIST", lkNone, CheckvarYesNo)
	usr("PKG_RESUME_TRANSFERS", lkNone, CheckvarYesNo)
	usr("PKG_SYSCONFBASE", lkNone, CheckvarPathname)
	usr("RCD_SCRIPTS_DIR", lkNone, CheckvarPathname)
	usr("PACKAGES", lkNone, CheckvarPathname)
	usr("PKGVULNDIR", lkNone, CheckvarPathname)
	usr("PASSIVE_FETCH", lkNone, CheckvarYes)
	usr("PATCH_FUZZ_FACTOR", lkNone, enum("-F0 -F1 -F2 -F3"))
	usr("ACCEPTABLE_LICENSES", lkShell, CheckvarIdentifier)
	usr("SPECIFIC_PKGS", lkNone, CheckvarYes)
	usr("SITE_SPECIFIC_PKGS", lkShell, CheckvarPkgPath)
	usr("HOST_SPECIFIC_PKGS", lkShell, CheckvarPkgPath)
	usr("GROUP_SPECIFIC_PKGS", lkShell, CheckvarPkgPath)
	usr("USER_SPECIFIC_PKGS", lkShell, CheckvarPkgPath)
	usr("FAILOVER_FETCH", lkNone, CheckvarYes)
	usr("MASTER_SORT", lkShell, CheckvarUnchecked)
	usr("MASTER_SORT_REGEX", lkShell, CheckvarUnchecked)
	usr("PATCH_DEBUG", lkNone, CheckvarYes)
	usr("PKG_FC", lkNone, CheckvarShellCommand)
	usr("IMAKE", lkNone, CheckvarShellCommand)
	usr("IMAKEOPTS", lkShell, CheckvarShellWord)
	usr("PRE_ROOT_CMD", lkNone, CheckvarShellCommand)
	pkg("USE_GAMESGROUP", lkNone, CheckvarYesNo)
	usr("SU_CMD", lkNone, CheckvarShellCommand)
	usr("SU_CMD_PATH_APPEND", lkNone, CheckvarPathlist)
	usr("FATAL_OBJECT_FMT_SKEW", lkNone, CheckvarYesNo)
	usr("WARN_NO_OBJECT_FMT", lkNone, CheckvarYesNo)
	usr("SMART_MESSAGES", lkNone, CheckvarYes)
	usr("BINPKG_SITES", lkShell, CheckvarURL)
	usr("BIN_INSTALL_FLAG", lkShell, CheckvarShellWord)
	usr("LOCALPATCHES", lkNone, CheckvarPathname)

	// some other variables, sorted alphabetically

	sys(".CURDIR", lkNone, CheckvarPathname)
	sys(".TARGET", lkNone, CheckvarPathname)
	acl("ALL_ENV", lkShell, CheckvarShellWord)
	acl("ALTERNATIVES_FILE", lkNone, CheckvarFilename)
	acl("ALTERNATIVES_SRC", lkShell, CheckvarPathname)
	pkg("APACHE_MODULE", lkNone, CheckvarYes)
	sys("AR", lkNone, CheckvarShellCommand)
	sys("AS", lkNone, CheckvarShellCommand)
	pkglist("AUTOCONF_REQD", lkShell, CheckvarVersion)
	acl("AUTOMAKE_OVERRIDE", lkShell, CheckvarPathmask)
	pkglist("AUTOMAKE_REQD", lkShell, CheckvarVersion)
	pkg("AUTO_MKDIRS", lkNone, CheckvarYesNo)
	usr("BATCH", lkNone, CheckvarYes)
	acl("BDB185_DEFAULT", lkNone, CheckvarUnchecked)
	sys("BDBBASE", lkNone, CheckvarPathname)
	pkg("BDB_ACCEPTED", lkShell, enum("db1 db2 db3 db4 db5"))
	acl("BDB_DEFAULT", lkNone, enum("db1 db2 db3 db4 db5"))
	sys("BDB_LIBS", lkShell, CheckvarLdFlag)
	sys("BDB_TYPE", lkNone, enum("db1 db2 db3 db4 db5"))
	sys("BINGRP", lkNone, CheckvarUserGroupName)
	sys("BINMODE", lkNone, CheckvarFileMode)
	sys("BINOWN", lkNone, CheckvarUserGroupName)
	acl("BOOTSTRAP_DEPENDS", lkSpace, CheckvarDependencyWithPath, "Makefile.common:a", "Makefile:a", "options.mk:a", "*.mk:a")
	pkg("BOOTSTRAP_PKG", lkNone, CheckvarYesNo)
	acl("BROKEN", lkNone, CheckvarMessage)
	pkg("BROKEN_GETTEXT_DETECTION", lkNone, CheckvarYesNo)
	pkglist("BROKEN_EXCEPT_ON_PLATFORM", lkShell, CheckvarPlatformTriple)
	pkglist("BROKEN_ON_PLATFORM", lkSpace, CheckvarPlatformTriple)
	sys("BSD_MAKE_ENV", lkShell, CheckvarShellWord)
	acl("BUILDLINK_ABI_DEPENDS.*", lkSpace, CheckvarDependency, "*:a")
	acl("BUILDLINK_API_DEPENDS.*", lkSpace, CheckvarDependency, "*:a")
	acl("BUILDLINK_CONTENTS_FILTER", lkShell, CheckvarShellWord) // Should better be ShellCommand
	sys("BUILDLINK_CFLAGS", lkShell, CheckvarCFlag)
	bl3list("BUILDLINK_CFLAGS.*", lkShell, CheckvarCFlag)
	sys("BUILDLINK_CPPFLAGS", lkShell, CheckvarCFlag)
	bl3list("BUILDLINK_CPPFLAGS.*", lkShell, CheckvarCFlag)
	acl("BUILDLINK_CONTENTS_FILTER.*", lkNone, CheckvarShellCommand, "buildlink3.mk:s")
	acl("BUILDLINK_DEPENDS", lkSpace, CheckvarIdentifier, "buildlink3.mk:a")
	acl("BUILDLINK_DEPMETHOD.*", lkShell, CheckvarBuildlinkDepmethod, "buildlink3.mk:ad", "Makefile:as", "Makefile.common:a", "*.mk:a") // FIXME: buildlink3.mk:d may lead to unexpected behavior.
	sys("BUILDLINK_DIR", lkNone, CheckvarPathname)
	bl3list("BUILDLINK_FILES.*", lkShell, CheckvarPathmask)
	acl("BUILDLINK_FILES_CMD.*", lkShell, CheckvarShellWord)                  // Should better be ShellCommand
	acl("BUILDLINK_INCDIRS.*", lkShell, CheckvarPathname, "buildlink3.mk:ad") // Should [d]efault really be allowed in buildlink3.mk?
	acl("BUILDLINK_JAVA_PREFIX.*", lkNone, CheckvarPathname, "buildlink3.mk:s")
	acl("BUILDLINK_LDADD.*", lkShell, CheckvarLdFlag, "builtin.mk:adsu", "buildlink3.mk:", "Makefile:u", "Makefile.common:u", "*.mk:u")
	sys("BUILDLINK_LDFLAGS", lkShell, CheckvarLdFlag)
	bl3list("BUILDLINK_LDFLAGS.*", lkShell, CheckvarLdFlag)
	bl3list("BUILDLINK_LIBDIRS.*", lkShell, CheckvarPathname)
	acl("BUILDLINK_LIBS.*", lkShell, CheckvarLdFlag, "buildlink3.mk:a")
	acl("BUILDLINK_PASSTHRU_DIRS", lkShell, CheckvarPathname, "Makefile:a", "Makefile.common:a", "buildlink3.mk:a", "hacks.mk:a")
	acl("BUILDLINK_PASSTHRU_RPATHDIRS", lkShell, CheckvarPathname, "Makefile:a", "Makefile.common:a", "buildlink3.mk:a", "hacks.mk:a")
	acl("BUILDLINK_PKGSRCDIR.*", lkNone, CheckvarRelativePkgDir, "buildlink3.mk:dp")
	acl("BUILDLINK_PREFIX.*", lkNone, CheckvarPathname, "builtin.mk:su", "buildlink3.mk:", "Makefile:u", "Makefile.common:u", "*.mk:u")
	acl("BUILDLINK_RPATHDIRS.*", lkShell, CheckvarPathname, "buildlink3.mk:a")
	acl("BUILDLINK_TARGETS", lkShell, CheckvarIdentifier)
	acl("BUILDLINK_FNAME_TRANSFORM.*", lkNone, CheckvarSedCommands, "Makefile:a", "builtin.mk:a", "hacks.mk:a", "buildlink3.mk:a")
	acl("BUILDLINK_TRANSFORM", lkShell, CheckvarWrapperTransform, "*:a")
	acl("BUILDLINK_TREE", lkShell, CheckvarIdentifier, "buildlink3.mk:a")
	acl("BUILD_DEFS", lkShell, CheckvarVarname, "Makefile:a", "Makefile.common:a", "options.mk:a")
	acl("BUILD_DEPENDS", lkSpace, CheckvarDependencyWithPath, "Makefile.common:a", "Makefile:a", "options.mk:a", "*.mk:a")
	pkglist("BUILD_DIRS", lkShell, CheckvarWrksrcSubdirectory)
	pkglist("BUILD_ENV", lkShell, CheckvarShellWord)
	sys("BUILD_MAKE_CMD", lkNone, CheckvarShellCommand)
	pkglist("BUILD_MAKE_FLAGS", lkShell, CheckvarShellWord)
	pkg("BUILD_TARGET", lkShell, CheckvarIdentifier)
	pkg("BUILD_USES_MSGFMT", lkNone, CheckvarYes)
	acl("BUILTIN_PKG", lkNone, CheckvarIdentifier, "builtin.mk:psu")
	acl("BUILTIN_PKG.*", lkNone, CheckvarPkgName, "builtin.mk:psu")
	acl("BUILTIN_FIND_FILES_VAR", lkShell, CheckvarVarname, "builtin.mk:s")
	acl("BUILTIN_FIND_FILES.*", lkShell, CheckvarPathname, "builtin.mk:s")
	acl("BUILTIN_FIND_GREP.*", lkNone, CheckvarString, "builtin.mk:s")
	acl("BUILTIN_FIND_LIBS", lkShell, CheckvarPathname, "builtin.mk:s")
	acl("BUILTIN_IMAKE_CHECK", lkShell, CheckvarUnchecked, "builtin.mk:s")
	acl("BUILTIN_IMAKE_CHECK.*", lkNone, CheckvarYesNo)
	sys("BUILTIN_X11_TYPE", lkNone, CheckvarUnchecked)
	sys("BUILTIN_X11_VERSION", lkNone, CheckvarUnchecked)
	acl("CATEGORIES", lkShell, CheckvarCategory, "Makefile:as", "Makefile.common:ads")
	sys("CC_VERSION", lkNone, CheckvarMessage)
	sys("CC", lkNone, CheckvarShellCommand)
	pkglist("CFLAGS*", lkShell, CheckvarCFlag) // may also be changed by the user
	acl("CHECK_BUILTIN", lkNone, CheckvarYesNo, "builtin.mk:d", "Makefile:s")
	acl("CHECK_BUILTIN.*", lkNone, CheckvarYesNo, "*:p")
	acl("CHECK_FILES_SKIP", lkShell, CheckvarBasicRegularExpression, "Makefile:a", "Makefile.common:a")
	pkg("CHECK_FILES_SUPPORTED", lkNone, CheckvarYesNo)
	usr("CHECK_HEADERS", lkNone, CheckvarYesNo)
	pkglist("CHECK_HEADERS_SKIP", lkShell, CheckvarPathmask)
	usr("CHECK_INTERPRETER", lkNone, CheckvarYesNo)
	pkglist("CHECK_INTERPRETER_SKIP", lkShell, CheckvarPathmask)
	usr("CHECK_PERMS", lkNone, CheckvarYesNo)
	pkglist("CHECK_PERMS_SKIP", lkShell, CheckvarPathmask)
	usr("CHECK_PORTABILITY", lkNone, CheckvarYesNo)
	pkglist("CHECK_PORTABILITY_SKIP", lkShell, CheckvarPathmask)
	acl("CHECK_SHLIBS", lkNone, CheckvarYesNo, "Makefile:s")
	pkglist("CHECK_SHLIBS_SKIP", lkShell, CheckvarPathmask)
	acl("CHECK_SHLIBS_SUPPORTED", lkNone, CheckvarYesNo, "Makefile:s")
	pkglist("CHECK_WRKREF_SKIP", lkShell, CheckvarPathmask)
	pkg("CMAKE_ARG_PATH", lkNone, CheckvarPathname)
	pkglist("CMAKE_ARGS", lkShell, CheckvarShellWord)
	acl("COMMENT", lkNone, CheckvarComment, "Makefile:as", "Makefile.common:as")
	sys("COMPILER_RPATH_FLAG", lkNone, enum("-Wl,-rpath"))
	pkglist("CONFIGURE_ARGS", lkShell, CheckvarShellWord)
	pkglist("CONFIGURE_DIRS", lkShell, CheckvarWrksrcSubdirectory)
	pkglist("CONFIGURE_ENV", lkShell, CheckvarShellWord)
	pkg("CONFIGURE_HAS_INFODIR", lkNone, CheckvarYesNo)
	pkg("CONFIGURE_HAS_LIBDIR", lkNone, CheckvarYesNo)
	pkg("CONFIGURE_HAS_MANDIR", lkNone, CheckvarYesNo)
	pkg("CONFIGURE_SCRIPT", lkNone, CheckvarPathname)
	acl("CONFIG_GUESS_OVERRIDE", lkShell, CheckvarPathmask, "Makefile:as", "Makefile.common:as")
	acl("CONFIG_STATUS_OVERRIDE", lkShell, CheckvarPathmask, "Makefile:as", "Makefile.common:as")
	acl("CONFIG_SHELL", lkNone, CheckvarPathname, "Makefile:s", "Makefile.common:s")
	acl("CONFIG_SUB_OVERRIDE", lkShell, CheckvarPathmask, "Makefile:as", "Makefile.common:as")
	pkglist("CONFLICTS", lkSpace, CheckvarDependency)
	pkglist("CONF_FILES", lkShell, CheckvarShellWord)
	pkg("CONF_FILES_MODE", lkNone, enum("0644 0640 0600 0400"))
	pkglist("CONF_FILES_PERMS", lkShell, CheckvarShellWord)
	sys("COPY", lkNone, enum("-c")) // The flag that tells ${INSTALL} to copy a file
	sys("CPP", lkNone, CheckvarShellCommand)
	pkglist("CPPFLAGS*", lkShell, CheckvarCFlag)
	acl("CRYPTO", lkNone, CheckvarYes, "Makefile:s")
	sys("CXX", lkNone, CheckvarShellCommand)
	pkglist("CXXFLAGS*", lkShell, CheckvarCFlag)
	acl("DEINSTALL_FILE", lkNone, CheckvarPathname, "Makefile:s")
	acl("DEINSTALL_SRC", lkShell, CheckvarPathname, "Makefile:s", "Makefile.common:ds")
	acl("DEINSTALL_TEMPLATES", lkShell, CheckvarPathname, "Makefile:as", "Makefile.common:ads")
	sys("DELAYED_ERROR_MSG", lkNone, CheckvarShellCommand)
	sys("DELAYED_WARNING_MSG", lkNone, CheckvarShellCommand)
	pkglist("DEPENDS", lkSpace, CheckvarDependencyWithPath)
	usr("DEPENDS_TARGET", lkShell, CheckvarIdentifier)
	acl("DESCR_SRC", lkShell, CheckvarPathname, "Makefile:s", "Makefile.common:ds")
	sys("DESTDIR", lkNone, CheckvarPathname)
	acl("DESTDIR_VARNAME", lkNone, CheckvarVarname, "Makefile:s", "Makefile.common:s")
	sys("DEVOSSAUDIO", lkNone, CheckvarPathname)
	sys("DEVOSSSOUND", lkNone, CheckvarPathname)
	pkglist("DISTFILES", lkShell, CheckvarFilename)
	pkg("DISTINFO_FILE", lkNone, CheckvarRelativePkgPath)
	pkg("DISTNAME", lkNone, CheckvarFilename)
	pkg("DIST_SUBDIR", lkNone, CheckvarPathname)
	acl("DJB_BUILD_ARGS", lkShell, CheckvarShellWord)
	acl("DJB_BUILD_TARGETS", lkShell, CheckvarIdentifier)
	acl("DJB_CONFIG_CMDS", lkShell, CheckvarShellWord, "options.mk:s") // ShellCommand, terminated by a semicolon
	acl("DJB_CONFIG_DIRS", lkShell, CheckvarWrksrcSubdirectory)
	acl("DJB_CONFIG_HOME", lkNone, CheckvarFilename)
	acl("DJB_CONFIG_PREFIX", lkNone, CheckvarPathname)
	acl("DJB_INSTALL_TARGETS", lkShell, CheckvarIdentifier)
	acl("DJB_MAKE_TARGETS", lkNone, CheckvarYesNo)
	acl("DJB_RESTRICTED", lkNone, CheckvarYesNo, "Makefile:s")
	acl("DJB_SLASHPACKAGE", lkNone, CheckvarYesNo)
	acl("DLOPEN_REQUIRE_PTHREADS", lkNone, CheckvarYesNo)
	acl("DL_AUTO_VARS", lkNone, CheckvarYes, "Makefile:s", "Makefile.common:s", "options.mk:s")
	acl("DL_LIBS", lkShell, CheckvarLdFlag)
	sys("DOCOWN", lkNone, CheckvarUserGroupName)
	sys("DOCGRP", lkNone, CheckvarUserGroupName)
	sys("DOCMODE", lkNone, CheckvarFileMode)
	sys("DOWNLOADED_DISTFILE", lkNone, CheckvarPathname)
	sys("DO_NADA", lkNone, CheckvarShellCommand)
	pkg("DYNAMIC_SITES_CMD", lkNone, CheckvarShellCommand)
	pkg("DYNAMIC_SITES_SCRIPT", lkNone, CheckvarPathname)
	sys("ECHO", lkNone, CheckvarShellCommand)
	sys("ECHO_MSG", lkNone, CheckvarShellCommand)
	sys("ECHO_N", lkNone, CheckvarShellCommand)
	pkg("EGDIR", lkNone, CheckvarPathname) // Not defined anywhere, but used in many places like this.
	sys("EMACS_BIN", lkNone, CheckvarPathname)
	sys("EMACS_ETCPREFIX", lkNone, CheckvarPathname)
	sys("EMACS_FLAVOR", lkNone, enum("emacs xemacs"))
	sys("EMACS_INFOPREFIX", lkNone, CheckvarPathname)
	sys("EMACS_LISPPREFIX", lkNone, CheckvarPathname)
	acl("EMACS_MODULES", lkShell, CheckvarIdentifier, "Makefile:as", "Makefile.common:as")
	sys("EMACS_PKGNAME_PREFIX", lkNone, CheckvarIdentifier) // Or the empty string.
	sys("EMACS_TYPE", lkNone, enum("emacs xemacs"))
	acl("EMACS_USE_LEIM", lkNone, CheckvarYes)
	acl("EMACS_VERSIONS_ACCEPTED", lkShell, enum("emacs25 emacs24 emacs24nox emacs23 emacs23nox emacs22 emacs22nox emacs21 emacs21nox emacs20 xemacs215 xemacs215nox xemacs214 xemacs214nox"), "Makefile:s")
	sys("EMACS_VERSION_MAJOR", lkNone, CheckvarInteger)
	sys("EMACS_VERSION_MINOR", lkNone, CheckvarInteger)
	acl("EMACS_VERSION_REQD", lkShell, enum("emacs24 emacs24nox emacs23 emacs23nox emacs22 emacs22nox emacs21 emacs21nox emacs20 xemacs215 xemacs214"), "Makefile:as")
	sys("EMULDIR", lkNone, CheckvarPathname)
	sys("EMULSUBDIR", lkNone, CheckvarPathname)
	sys("OPSYS_EMULDIR", lkNone, CheckvarPathname)
	sys("EMULSUBDIRSLASH", lkNone, CheckvarPathname)
	sys("EMUL_ARCH", lkNone, enum("i386 none"))
	sys("EMUL_DISTRO", lkNone, CheckvarIdentifier)
	sys("EMUL_IS_NATIVE", lkNone, CheckvarYes)
	pkg("EMUL_MODULES.*", lkShell, CheckvarIdentifier)
	sys("EMUL_OPSYS", lkNone, enum("freebsd hpux irix linux osf1 solaris sunos none"))
	pkg("EMUL_PKG_FMT", lkNone, enum("plain rpm"))
	usr("EMUL_PLATFORM", lkNone, CheckvarEmulPlatform)
	pkg("EMUL_PLATFORMS", lkShell, CheckvarEmulPlatform)
	usr("EMUL_PREFER", lkShell, CheckvarEmulPlatform)
	pkg("EMUL_REQD", lkSpace, CheckvarDependency)
	usr("EMUL_TYPE.*", lkNone, enum("native builtin suse suse-9.1 suse-9.x suse-10.0 suse-10.x"))
	sys("ERROR_CAT", lkNone, CheckvarShellCommand)
	sys("ERROR_MSG", lkNone, CheckvarShellCommand)
	acl("EVAL_PREFIX", lkSpace, CheckvarShellWord, "Makefile:a", "Makefile.common:a") // XXX: Combining ShellWord with lkSpace looks weird.
	sys("EXPORT_SYMBOLS_LDFLAGS", lkShell, CheckvarLdFlag)
	sys("EXTRACT_CMD", lkNone, CheckvarShellCommand)
	pkg("EXTRACT_DIR", lkNone, CheckvarPathname)
	pkglist("EXTRACT_ELEMENTS", lkShell, CheckvarPathmask)
	pkglist("EXTRACT_ENV", lkShell, CheckvarShellWord)
	pkglist("EXTRACT_ONLY", lkShell, CheckvarPathname)
	acl("EXTRACT_OPTS", lkShell, CheckvarShellWord, "Makefile:as", "Makefile.common:as")
	acl("EXTRACT_OPTS_BIN", lkShell, CheckvarShellWord, "Makefile:as", "Makefile.common:as")
	acl("EXTRACT_OPTS_LHA", lkShell, CheckvarShellWord, "Makefile:as", "Makefile.common:as")
	acl("EXTRACT_OPTS_PAX", lkShell, CheckvarShellWord, "Makefile:as", "Makefile.common:as")
	acl("EXTRACT_OPTS_RAR", lkShell, CheckvarShellWord, "Makefile:as", "Makefile.common:as")
	acl("EXTRACT_OPTS_TAR", lkShell, CheckvarShellWord, "Makefile:as", "Makefile.common:as")
	acl("EXTRACT_OPTS_ZIP", lkShell, CheckvarShellWord, "Makefile:as", "Makefile.common:as")
	acl("EXTRACT_OPTS_ZOO", lkShell, CheckvarShellWord, "Makefile:as", "Makefile.common:as")
	pkg("EXTRACT_SUFX", lkNone, CheckvarDistSuffix)
	pkg("EXTRACT_USING", lkNone, enum("bsdtar gtar nbtar pax"))
	sys("FAIL_MSG", lkNone, CheckvarShellCommand)
	sys("FAMBASE", lkNone, CheckvarPathname)
	pkg("FAM_ACCEPTED", lkShell, enum("fam gamin"))
	usr("FAM_DEFAULT", lkNone, enum("fam gamin"))
	sys("FAM_TYPE", lkNone, enum("fam gamin"))
	acl("FETCH_BEFORE_ARGS", lkShell, CheckvarShellWord, "Makefile:as")
	pkglist("FETCH_MESSAGE", lkShell, CheckvarShellWord)
	pkg("FILESDIR", lkNone, CheckvarRelativePkgPath)
	pkglist("FILES_SUBST", lkShell, CheckvarShellWord)
	acl("FILES_SUBST_SED", lkShell, CheckvarShellWord)
	pkglist("FIX_RPATH", lkShell, CheckvarVarname)
	pkglist("FLEX_REQD", lkShell, CheckvarVersion)
	acl("FONTS_DIRS.*", lkShell, CheckvarPathname, "Makefile:as", "Makefile.common:a")
	sys("GAMEDATAMODE", lkNone, CheckvarFileMode)
	sys("GAMES_GROUP", lkNone, CheckvarUserGroupName)
	sys("GAMEMODE", lkNone, CheckvarFileMode)
	sys("GAMES_USER", lkNone, CheckvarUserGroupName)
	pkglist("GCC_REQD", lkShell, CheckvarVersion)
	pkglist("GENERATE_PLIST", lkShell, CheckvarShellWord) // List of Shellcommand, terminated with a semicolon
	pkg("GITHUB_PROJECT", lkNone, CheckvarIdentifier)
	pkg("GITHUB_TAG", lkNone, CheckvarIdentifier)
	pkg("GITHUB_RELEASE", lkNone, CheckvarFilename)
	pkg("GITHUB_TYPE", lkNone, enum("tag release"))
	acl("GNU_ARCH", lkNone, enum("mips"))
	acl("GNU_CONFIGURE", lkNone, CheckvarYes, "Makefile.common:s", "Makefile:s")
	acl("GNU_CONFIGURE_INFODIR", lkNone, CheckvarPathname, "Makefile:s", "Makefile.common:s")
	acl("GNU_CONFIGURE_LIBDIR", lkNone, CheckvarPathname, "Makefile:s", "Makefile.common:s")
	pkg("GNU_CONFIGURE_LIBSUBDIR", lkNone, CheckvarPathname)
	acl("GNU_CONFIGURE_MANDIR", lkNone, CheckvarPathname, "Makefile:s", "Makefile.common:s")
	acl("GNU_CONFIGURE_PREFIX", lkNone, CheckvarPathname, "Makefile:s")
	acl("HAS_CONFIGURE", lkNone, CheckvarYes, "Makefile:s", "Makefile.common:s")
	pkglist("HEADER_TEMPLATES", lkShell, CheckvarPathname)
	pkg("HOMEPAGE", lkNone, CheckvarURL)
	acl("IGNORE_PKG.*", lkNone, CheckvarYes, "*:sp")
	acl("INCOMPAT_CURSES", lkSpace, CheckvarPlatformTriple, "Makefile:as")
	acl("INCOMPAT_ICONV", lkSpace, CheckvarPlatformTriple)
	acl("INFO_DIR", lkNone, CheckvarPathname) // relative to PREFIX
	pkg("INFO_FILES", lkNone, CheckvarYes)
	sys("INSTALL", lkNone, CheckvarShellCommand)
	pkglist("INSTALLATION_DIRS", lkShell, CheckvarPrefixPathname)
	pkg("INSTALLATION_DIRS_FROM_PLIST", lkNone, CheckvarYes)
	sys("INSTALL_DATA", lkNone, CheckvarShellCommand)
	sys("INSTALL_DATA_DIR", lkNone, CheckvarShellCommand)
	pkglist("INSTALL_DIRS", lkShell, CheckvarWrksrcSubdirectory)
	pkglist("INSTALL_ENV", lkShell, CheckvarShellWord)
	acl("INSTALL_FILE", lkNone, CheckvarPathname, "Makefile:s")
	sys("INSTALL_GAME", lkNone, CheckvarShellCommand)
	sys("INSTALL_GAME_DATA", lkNone, CheckvarShellCommand)
	sys("INSTALL_LIB", lkNone, CheckvarShellCommand)
	sys("INSTALL_LIB_DIR", lkNone, CheckvarShellCommand)
	pkglist("INSTALL_MAKE_FLAGS", lkShell, CheckvarShellWord)
	sys("INSTALL_MAN", lkNone, CheckvarShellCommand)
	sys("INSTALL_MAN_DIR", lkNone, CheckvarShellCommand)
	sys("INSTALL_PROGRAM", lkNone, CheckvarShellCommand)
	sys("INSTALL_PROGRAM_DIR", lkNone, CheckvarShellCommand)
	sys("INSTALL_SCRIPT", lkNone, CheckvarShellCommand)
	acl("INSTALL_SCRIPTS_ENV", lkShell, CheckvarShellWord)
	sys("INSTALL_SCRIPT_DIR", lkNone, CheckvarShellCommand)
	acl("INSTALL_SRC", lkShell, CheckvarPathname, "Makefile:s", "Makefile.common:ds")
	pkg("INSTALL_TARGET", lkShell, CheckvarIdentifier)
	acl("INSTALL_TEMPLATES", lkShell, CheckvarPathname, "Makefile:as", "Makefile.common:ads")
	acl("INSTALL_UNSTRIPPED", lkNone, CheckvarYesNo, "Makefile:s", "Makefile.common:s")
	pkg("INTERACTIVE_STAGE", lkShell, enum("fetch extract configure build install"))
	acl("IS_BUILTIN.*", lkNone, CheckvarYesNoIndirectly, "builtin.mk:psu")
	sys("JAVA_BINPREFIX", lkNone, CheckvarPathname)
	pkg("JAVA_CLASSPATH", lkNone, CheckvarShellWord)
	pkg("JAVA_HOME", lkNone, CheckvarPathname)
	pkg("JAVA_NAME", lkNone, CheckvarFilename)
	pkglist("JAVA_UNLIMIT", lkShell, enum("cmdsize datasize stacksize"))
	pkglist("JAVA_WRAPPERS", lkSpace, CheckvarFilename)
	pkg("JAVA_WRAPPER_BIN.*", lkNone, CheckvarPathname)
	sys("KRB5BASE", lkNone, CheckvarPathname)
	acl("KRB5_ACCEPTED", lkShell, enum("heimdal mit-krb5"))
	usr("KRB5_DEFAULT", lkNone, enum("heimdal mit-krb5"))
	sys("KRB5_TYPE", lkNone, CheckvarUnchecked)
	sys("LD", lkNone, CheckvarShellCommand)
	pkglist("LDFLAGS*", lkShell, CheckvarLdFlag)
	sys("LIBGRP", lkNone, CheckvarUserGroupName)
	sys("LIBMODE", lkNone, CheckvarFileMode)
	sys("LIBOWN", lkNone, CheckvarUserGroupName)
	sys("LIBOSSAUDIO", lkNone, CheckvarPathname)
	pkglist("LIBS*", lkShell, CheckvarLdFlag)
	sys("LIBTOOL", lkNone, CheckvarShellCommand)
	acl("LIBTOOL_OVERRIDE", lkShell, CheckvarPathmask, "Makefile:as")
	pkglist("LIBTOOL_REQD", lkShell, CheckvarVersion)
	acl("LICENCE", lkNone, CheckvarLicense, "Makefile:s", "Makefile.common:s", "options.mk:s")
	acl("LICENSE", lkNone, CheckvarLicense, "Makefile:s", "Makefile.common:s", "options.mk:s")
	pkg("LICENSE_FILE", lkNone, CheckvarPathname)
	sys("LINKER_RPATH_FLAG", lkNone, CheckvarShellWord)
	sys("LOWER_OPSYS", lkNone, CheckvarIdentifier)
	acl("LTCONFIG_OVERRIDE", lkShell, CheckvarPathmask, "Makefile:as", "Makefile.common:a")
	sys("MACHINE_ARCH", lkNone, CheckvarIdentifier)
	sys("MACHINE_GNU_PLATFORM", lkNone, CheckvarPlatformTriple)
	acl("MAINTAINER", lkNone, CheckvarMailAddress, "Makefile:s", "Makefile.common:d")
	sys("MAKE", lkNone, CheckvarShellCommand)
	pkglist("MAKEFLAGS", lkShell, CheckvarShellWord)
	acl("MAKEVARS", lkShell, CheckvarVarname, "builtin.mk:a", "buildlink3.mk:a", "hacks.mk:a")
	pkglist("MAKE_DIRS", lkShell, CheckvarPathname)
	pkglist("MAKE_DIRS_PERMS", lkShell, CheckvarShellWord)
	pkglist("MAKE_ENV", lkShell, CheckvarShellWord)
	pkg("MAKE_FILE", lkNone, CheckvarPathname)
	pkglist("MAKE_FLAGS", lkShell, CheckvarShellWord)
	usr("MAKE_JOBS", lkNone, CheckvarInteger)
	pkg("MAKE_JOBS_SAFE", lkNone, CheckvarYesNo)
	pkg("MAKE_PROGRAM", lkNone, CheckvarShellCommand)
	acl("MANCOMPRESSED", lkNone, CheckvarYesNo, "Makefile:s", "Makefile.common:ds")
	acl("MANCOMPRESSED_IF_MANZ", lkNone, CheckvarYes, "Makefile:s", "Makefile.common:ds")
	sys("MANGRP", lkNone, CheckvarUserGroupName)
	sys("MANMODE", lkNone, CheckvarFileMode)
	sys("MANOWN", lkNone, CheckvarUserGroupName)
	pkglist("MASTER_SITES", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_APACHE", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_BACKUP", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_CYGWIN", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_DEBIAN", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_FREEBSD", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_FREEBSD_LOCAL", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_GENTOO", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_GITHUB", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_GNOME", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_GNU", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_GNUSTEP", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_IFARCHIVE", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_HASKELL_HACKAGE", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_KDE", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_LOCAL", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_MOZILLA", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_MOZILLA_ALL", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_MOZILLA_ESR", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_MYSQL", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_NETLIB", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_OPENOFFICE", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_OSDN", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_PERL_CPAN", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_R_CRAN", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_RUBYGEMS", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_SOURCEFORGE", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_SUNSITE", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_SUSE", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_TEX_CTAN", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_XCONTRIB", lkShell, CheckvarFetchURL)
	sys("MASTER_SITE_XEMACS", lkShell, CheckvarFetchURL)
	pkglist("MESSAGE_SRC", lkShell, CheckvarPathname)
	acl("MESSAGE_SUBST", lkShell, CheckvarShellWord, "Makefile.common:a", "Makefile:a", "options.mk:a")
	pkg("META_PACKAGE", lkNone, CheckvarYes)
	sys("MISSING_FEATURES", lkShell, CheckvarIdentifier)
	acl("MYSQL_VERSIONS_ACCEPTED", lkShell, enum("51 55 56"), "Makefile:s")
	usr("MYSQL_VERSION_DEFAULT", lkNone, CheckvarVersion)
	sys("NM", lkNone, CheckvarShellCommand)
	sys("NONBINMODE", lkNone, CheckvarFileMode)
	pkg("NOT_FOR_COMPILER", lkShell, enum("ccache ccc clang distcc f2c gcc hp icc ido mipspro mipspro-ucode pcc sunpro xlc"))
	pkglist("NOT_FOR_PLATFORM", lkSpace, CheckvarPlatformTriple)
	pkg("NOT_FOR_UNPRIVILEGED", lkNone, CheckvarYesNo)
	acl("NO_BIN_ON_CDROM", lkNone, CheckvarRestricted, "Makefile:s", "Makefile.common:s")
	acl("NO_BIN_ON_FTP", lkNone, CheckvarRestricted, "Makefile:s", "Makefile.common:s")
	acl("NO_BUILD", lkNone, CheckvarYes, "Makefile:s", "Makefile.common:s", "Makefile.*:ds")
	pkg("NO_CHECKSUM", lkNone, CheckvarYes)
	pkg("NO_CONFIGURE", lkNone, CheckvarYes)
	acl("NO_EXPORT_CPP", lkNone, CheckvarYes, "Makefile:s")
	pkg("NO_EXTRACT", lkNone, CheckvarYes)
	pkg("NO_INSTALL_MANPAGES", lkNone, CheckvarYes) // only has an effect for Imake packages.
	acl("NO_PKGTOOLS_REQD_CHECK", lkNone, CheckvarYes, "Makefile:s")
	acl("NO_SRC_ON_CDROM", lkNone, CheckvarRestricted, "Makefile:s", "Makefile.common:s")
	acl("NO_SRC_ON_FTP", lkNone, CheckvarRestricted, "Makefile:s", "Makefile.common:s")
	pkglist("ONLY_FOR_COMPILER", lkShell, enum("ccc clang gcc hp icc ido mipspro mipspro-ucode pcc sunpro xlc"))
	pkglist("ONLY_FOR_PLATFORM", lkSpace, CheckvarPlatformTriple)
	pkg("ONLY_FOR_UNPRIVILEGED", lkNone, CheckvarYesNo)
	sys("OPSYS", lkNone, CheckvarIdentifier)
	acl("OPSYSVARS", lkShell, CheckvarVarname, "Makefile:a", "Makefile.common:a")
	acl("OSVERSION_SPECIFIC", lkNone, CheckvarYes, "Makefile:s", "Makefile.common:s")
	sys("OS_VERSION", lkNone, CheckvarVersion)
	pkg("OVERRIDE_DIRDEPTH*", lkNone, CheckvarInteger)
	pkg("OVERRIDE_GNU_CONFIG_SCRIPTS", lkNone, CheckvarYes)
	acl("OWNER", lkNone, CheckvarMailAddress, "Makefile:s", "Makefile.common:d")
	pkglist("OWN_DIRS", lkShell, CheckvarPathname)
	pkglist("OWN_DIRS_PERMS", lkShell, CheckvarShellWord)
	sys("PAMBASE", lkNone, CheckvarPathname)
	usr("PAM_DEFAULT", lkNone, enum("linux-pam openpam solaris-pam"))
	acl("PATCHDIR", lkNone, CheckvarRelativePkgPath, "Makefile:s", "Makefile.common:ds")
	pkglist("PATCHFILES", lkShell, CheckvarFilename)
	acl("PATCH_ARGS", lkShell, CheckvarShellWord)
	acl("PATCH_DIST_ARGS", lkShell, CheckvarShellWord, "Makefile:as")
	acl("PATCH_DIST_CAT", lkNone, CheckvarShellCommand)
	acl("PATCH_DIST_STRIP*", lkNone, CheckvarShellWord, "Makefile:s", "Makefile.common:s", "buildlink3.mk:", "builtin.mk:", "*.mk:s")
	acl("PATCH_SITES", lkShell, CheckvarURL, "Makefile:s", "options.mk:s", "Makefile.common:s")
	acl("PATCH_STRIP", lkNone, CheckvarShellWord)
	pkg("PERL5_USE_PACKLIST", lkNone, CheckvarYesNo)
	acl("PERL5_PACKLIST", lkShell, CheckvarPerl5Packlist, "Makefile:s", "options.mk:sa")
	acl("PERL5_PACKLIST_DIR", lkNone, CheckvarPathname)
	sys("PGSQL_PREFIX", lkNone, CheckvarPathname)
	acl("PGSQL_VERSIONS_ACCEPTED", lkShell, enum("91 92 93 94"))
	usr("PGSQL_VERSION_DEFAULT", lkNone, CheckvarVersion)
	sys("PG_LIB_EXT", lkNone, enum("dylib so"))
	sys("PGSQL_TYPE", lkNone, enum("postgresql81-client postgresql80-client"))
	sys("PGPKGSRCDIR", lkNone, CheckvarPathname)
	sys("PHASE_MSG", lkNone, CheckvarShellCommand)
	usr("PHP_VERSION_REQD", lkNone, CheckvarVersion)
	sys("PKGBASE", lkNone, CheckvarIdentifier)
	acl("PKGCONFIG_OVERRIDE", lkShell, CheckvarPathmask, "Makefile:as", "Makefile.common:a")
	pkg("PKGCONFIG_OVERRIDE_STAGE", lkNone, CheckvarStage)
	pkg("PKGDIR", lkNone, CheckvarRelativePkgDir)
	sys("PKGDIRMODE", lkNone, CheckvarFileMode)
	sys("PKGLOCALEDIR", lkNone, CheckvarPathname)
	pkg("PKGNAME", lkNone, CheckvarPkgName)
	sys("PKGNAME_NOREV", lkNone, CheckvarPkgName)
	sys("PKGPATH", lkNone, CheckvarPathname)
	acl("PKGREPOSITORY", lkNone, CheckvarUnchecked)
	acl("PKGREVISION", lkNone, CheckvarPkgRevision, "Makefile:s")
	sys("PKGSRCDIR", lkNone, CheckvarPathname)
	acl("PKGSRCTOP", lkNone, CheckvarYes, "Makefile:s")
	acl("PKGTOOLS_ENV", lkShell, CheckvarShellWord)
	sys("PKGVERSION", lkNone, CheckvarVersion)
	sys("PKGWILDCARD", lkNone, CheckvarFilemask)
	sys("PKG_ADMIN", lkNone, CheckvarShellCommand)
	sys("PKG_APACHE", lkNone, enum("apache22 apache24"))
	pkg("PKG_APACHE_ACCEPTED", lkShell, enum("apache22 apache24"))
	usr("PKG_APACHE_DEFAULT", lkNone, enum("apache22 apache24"))
	usr("PKG_CONFIG", lkNone, CheckvarYes)
	// ^^ No, this is not the popular command from GNOME, but the setting
	// whether the pkgsrc user wants configuration files automatically
	// installed or not.
	sys("PKG_CREATE", lkNone, CheckvarShellCommand)
	sys("PKG_DBDIR", lkNone, CheckvarPathname)
	cmdline("PKG_DEBUG_LEVEL", lkNone, CheckvarInteger)
	usr("PKG_DEFAULT_OPTIONS", lkShell, CheckvarOption)
	sys("PKG_DELETE", lkNone, CheckvarShellCommand)
	acl("PKG_DESTDIR_SUPPORT", lkShell, enum("destdir user-destdir"), "Makefile:s", "Makefile.common:s")
	pkglist("PKG_FAIL_REASON", lkShell, CheckvarShellWord)
	acl("PKG_GECOS.*", lkNone, CheckvarMessage, "Makefile:s")
	acl("PKG_GID.*", lkNone, CheckvarInteger, "Makefile:s")
	acl("PKG_GROUPS", lkShell, CheckvarShellWord, "Makefile:as")
	pkglist("PKG_GROUPS_VARS", lkShell, CheckvarVarname)
	acl("PKG_HOME.*", lkNone, CheckvarPathname, "Makefile:s")
	acl("PKG_HACKS", lkShell, CheckvarIdentifier, "hacks.mk:a")
	sys("PKG_INFO", lkNone, CheckvarShellCommand)
	sys("PKG_JAVA_HOME", lkNone, CheckvarPathname)
	jvms := enum("{ blackdown-jdk13 jdk jdk14 kaffe run-jdk13 sun-jdk14 sun-jdk15 sun-jdk6 openjdk7 openjdk7-bin sun-jdk7}")
	sys("PKG_JVM", lkNone, jvms)
	acl("PKG_JVMS_ACCEPTED", lkShell, jvms, "Makefile:s", "Makefile.common:ds")
	usr("PKG_JVM_DEFAULT", lkNone, jvms)
	acl("PKG_LEGACY_OPTIONS", lkShell, CheckvarOption)
	acl("PKG_LIBTOOL", lkNone, CheckvarPathname, "Makefile:s")
	acl("PKG_OPTIONS", lkSpace, CheckvarOption, "bsd.options.mk:s", "*:pu")
	usr("PKG_OPTIONS.*", lkSpace, CheckvarOption)
	acl("PKG_OPTIONS_DEPRECATED_WARNINGS", lkShell, CheckvarShellWord)
	acl("PKG_OPTIONS_GROUP.*", lkSpace, CheckvarOption, "options.mk:s", "Makefile:s")
	acl("PKG_OPTIONS_LEGACY_OPTS", lkSpace, CheckvarUnchecked, "Makefile:a", "Makefile.common:a", "options.mk:a")
	acl("PKG_OPTIONS_LEGACY_VARS", lkSpace, CheckvarUnchecked, "Makefile:a", "Makefile.common:a", "options.mk:a")
	acl("PKG_OPTIONS_NONEMPTY_SETS", lkSpace, CheckvarIdentifier)
	acl("PKG_OPTIONS_OPTIONAL_GROUPS", lkSpace, CheckvarIdentifier, "options.mk:as")
	acl("PKG_OPTIONS_REQUIRED_GROUPS", lkSpace, CheckvarIdentifier, "options.mk:s", "Makefile:s")
	acl("PKG_OPTIONS_SET.*", lkSpace, CheckvarOption)
	acl("PKG_OPTIONS_VAR", lkNone, CheckvarPkgOptionsVar, "options.mk:s", "Makefile:s", "Makefile.common:s", "bsd.options.mk:p")
	acl("PKG_PRESERVE", lkNone, CheckvarYes, "Makefile:s")
	acl("PKG_SHELL", lkNone, CheckvarPathname, "Makefile:s", "Makefile.common:s")
	acl("PKG_SHELL.*", lkNone, CheckvarPathname, "Makefile:s", "Makefile.common:s")
	acl("PKG_SHLIBTOOL", lkNone, CheckvarPathname)
	pkglist("PKG_SKIP_REASON", lkShell, CheckvarShellWord)
	acl("PKG_SUGGESTED_OPTIONS", lkShell, CheckvarOption, "options.mk:as", "Makefile:as", "Makefile.common:s")
	acl("PKG_SUPPORTED_OPTIONS", lkShell, CheckvarOption, "options.mk:as", "Makefile:as", "Makefile.common:s")
	pkg("PKG_SYSCONFDIR*", lkNone, CheckvarPathname)
	pkglist("PKG_SYSCONFDIR_PERMS", lkShell, CheckvarShellWord)
	sys("PKG_SYSCONFBASEDIR", lkNone, CheckvarPathname)
	pkg("PKG_SYSCONFSUBDIR", lkNone, CheckvarPathname)
	acl("PKG_SYSCONFVAR", lkNone, CheckvarIdentifier) // FIXME: name/type mismatch.")
	acl("PKG_UID", lkNone, CheckvarInteger, "Makefile:s")
	acl("PKG_USERS", lkShell, CheckvarShellWord, "Makefile:as")
	pkg("PKG_USERS_VARS", lkShell, CheckvarVarname)
	acl("PKG_USE_KERBEROS", lkNone, CheckvarYes, "Makefile:s", "Makefile.common:s")
	// PLIST.* has special handling code
	pkglist("PLIST_VARS", lkShell, CheckvarIdentifier)
	pkglist("PLIST_SRC", lkShell, CheckvarRelativePkgPath)
	pkglist("PLIST_SUBST", lkShell, CheckvarShellWord)
	acl("PLIST_TYPE", lkNone, enum("dynamic static"))
	acl("PREPEND_PATH", lkShell, CheckvarPathname)
	acl("PREFIX", lkNone, CheckvarPathname, "*:u")
	acl("PREV_PKGPATH", lkNone, CheckvarPathname, "*:u") // doesn't exist any longer
	acl("PRINT_PLIST_AWK", lkNone, CheckvarAwkCommand, "*:a")
	acl("PRIVILEGED_STAGES", lkShell, enum("install package clean"))
	acl("PTHREAD_AUTO_VARS", lkNone, CheckvarYesNo, "Makefile:s")
	sys("PTHREAD_CFLAGS", lkShell, CheckvarCFlag)
	sys("PTHREAD_LDFLAGS", lkShell, CheckvarLdFlag)
	sys("PTHREAD_LIBS", lkShell, CheckvarLdFlag)
	acl("PTHREAD_OPTS", lkShell, enum("native optional require"), "Makefile:as", "Makefile.common:a", "buildlink3.mk:a")
	sys("PTHREAD_TYPE", lkNone, CheckvarIdentifier) // Or "native" or "none".
	pkg("PY_PATCHPLIST", lkNone, CheckvarYes)
	acl("PYPKGPREFIX", lkNone, enum("py27 py33 py34"), "*:pu", "pyversion.mk:s", "*:")
	pkg("PYTHON_FOR_BUILD_ONLY", lkNone, CheckvarYes)
	pkglist("REPLACE_PYTHON", lkShell, CheckvarPathmask)
	pkg("PYTHON_VERSIONS_ACCEPTED", lkShell, CheckvarVersion)
	pkg("PYTHON_VERSIONS_INCOMPATIBLE", lkShell, CheckvarVersion)
	usr("PYTHON_VERSION_DEFAULT", lkNone, CheckvarVersion)
	usr("PYTHON_VERSION_REQD", lkNone, CheckvarVersion)
	pkglist("PYTHON_VERSIONED_DEPENDENCIES", lkShell, CheckvarPythonDependency)
	sys("RANLIB", lkNone, CheckvarShellCommand)
	pkglist("RCD_SCRIPTS", lkShell, CheckvarFilename)
	acl("RCD_SCRIPT_SRC.*", lkShell, CheckvarPathname, "Makefile:s")
	acl("REPLACE.*", lkNone, CheckvarString, "Makefile:s")
	pkglist("REPLACE_AWK", lkShell, CheckvarPathmask)
	pkglist("REPLACE_BASH", lkShell, CheckvarPathmask)
	pkglist("REPLACE_CSH", lkShell, CheckvarPathmask)
	acl("REPLACE_EMACS", lkShell, CheckvarPathmask)
	acl("REPLACE_FILES.*", lkShell, CheckvarPathmask, "Makefile:as", "Makefile.common:as")
	acl("REPLACE_INTERPRETER", lkShell, CheckvarIdentifier, "Makefile:a", "Makefile.common:a")
	pkglist("REPLACE_KSH", lkShell, CheckvarPathmask)
	pkglist("REPLACE_LOCALEDIR_PATTERNS", lkShell, CheckvarFilemask)
	pkglist("REPLACE_LUA", lkShell, CheckvarPathmask)
	pkglist("REPLACE_PERL", lkShell, CheckvarPathmask)
	pkglist("REPLACE_PYTHON", lkShell, CheckvarPathmask)
	pkglist("REPLACE_SH", lkShell, CheckvarPathmask)
	pkglist("REQD_DIRS", lkShell, CheckvarPathname)
	pkglist("REQD_DIRS_PERMS", lkShell, CheckvarShellWord)
	pkglist("REQD_FILES", lkShell, CheckvarPathname)
	pkg("REQD_FILES_MODE", lkNone, enum("0644 0640 0600 0400"))
	pkglist("REQD_FILES_PERMS", lkShell, CheckvarShellWord)
	pkg("RESTRICTED", lkNone, CheckvarMessage)
	usr("ROOT_USER", lkNone, CheckvarUserGroupName)
	usr("ROOT_GROUP", lkNone, CheckvarUserGroupName)
	usr("RUBY_VERSION_REQD", lkNone, CheckvarVersion)
	sys("RUN", lkNone, CheckvarShellCommand)
	acl("SCRIPTS_ENV", lkShell, CheckvarShellWord, "Makefile:a", "Makefile.common:a")
	usr("SETUID_ROOT_PERMS", lkShell, CheckvarShellWord)
	sys("SHAREGRP", lkNone, CheckvarUserGroupName)
	sys("SHAREMODE", lkNone, CheckvarFileMode)
	sys("SHAREOWN", lkNone, CheckvarUserGroupName)
	sys("SHCOMMENT", lkNone, CheckvarShellCommand)
	acl("SHLIB_HANDLING", lkNone, enum("YES NO no"))
	acl("SHLIBTOOL", lkNone, CheckvarShellCommand)
	acl("SHLIBTOOL_OVERRIDE", lkShell, CheckvarPathmask, "Makefile:as", "Makefile.common:a")
	acl("SITES.*", lkShell, CheckvarFetchURL, "Makefile:asu", "Makefile.common:asu", "options.mk:asu")
	pkglist("SPECIAL_PERMS", lkShell, CheckvarShellWord)
	sys("STEP_MSG", lkNone, CheckvarShellCommand)
	acl("SUBDIR", lkShell, CheckvarFilename, "Makefile:a", "*:")
	acl("SUBST_CLASSES", lkShell, CheckvarIdentifier, "Makefile:a", "Makefile.common:a", "hacks.mk:a", "Makefile.*:a")
	acl("SUBST_FILES.*", lkShell, CheckvarPathmask, "Makefile:as", "Makefile.common:as", "hacks.mk:as", "options.mk:as", "Makefile.*:as")
	acl("SUBST_FILTER_CMD.*", lkNone, CheckvarShellCommand, "Makefile:s", "Makefile.common:s", "hacks.mk:s", "options.mk:s", "Makefile.*:s")
	acl("SUBST_MESSAGE.*", lkNone, CheckvarMessage, "Makefile:s", "Makefile.common:s", "hacks.mk:s", "options.mk:s", "Makefile.*:s")
	acl("SUBST_SED.*", lkNone, CheckvarSedCommands, "Makefile:as", "Makefile.common:as", "hacks.mk:as", "options.mk:as", "Makefile.*:as")
	pkg("SUBST_STAGE.*", lkNone, CheckvarStage)
	pkglist("SUBST_VARS.*", lkShell, CheckvarVarname)
	pkglist("SUPERSEDES", lkSpace, CheckvarDependency)
	pkglist("TEST_DIRS", lkShell, CheckvarWrksrcSubdirectory)
	pkglist("TEST_ENV", lkShell, CheckvarShellWord)
	acl("TEST_TARGET", lkShell, CheckvarIdentifier, "Makefile:s", "Makefile.common:ds", "options.mk:as")
	acl("TEX_ACCEPTED", lkShell, enum("teTeX1 teTeX2 teTeX3"), "Makefile:s", "Makefile.common:s")
	acl("TEX_DEPMETHOD", lkNone, enum("build run"), "Makefile:s", "Makefile.common:s")
	pkglist("TEXINFO_REQD", lkShell, CheckvarVersion)
	acl("TOOL_DEPENDS", lkSpace, CheckvarDependencyWithPath, "Makefile.common:a", "Makefile:a", "options.mk:a", "*.mk:a")
	sys("TOOLS_ALIASES", lkShell, CheckvarFilename)
	sys("TOOLS_BROKEN", lkShell, CheckvarTool)
	sys("TOOLS_CREATE", lkShell, CheckvarTool)
	sys("TOOLS_DEPENDS.*", lkSpace, CheckvarDependencyWithPath)
	sys("TOOLS_GNU_MISSING", lkShell, CheckvarTool)
	sys("TOOLS_NOOP", lkShell, CheckvarTool)
	sys("TOOLS_PATH.*", lkNone, CheckvarPathname)
	sys("TOOLS_PLATFORM.*", lkNone, CheckvarShellCommand)
	sys("TOUCH_FLAGS", lkShell, CheckvarShellWord)
	pkglist("UAC_REQD_EXECS", lkShell, CheckvarPrefixPathname)
	acl("UNLIMIT_RESOURCES", lkShell, enum("datasize stacksize memorysize"), "Makefile:as", "Makefile.common:a")
	usr("UNPRIVILEGED_USER", lkNone, CheckvarUserGroupName)
	usr("UNPRIVILEGED_GROUP", lkNone, CheckvarUserGroupName)
	pkglist("UNWRAP_FILES", lkShell, CheckvarPathmask)
	usr("UPDATE_TARGET", lkShell, CheckvarIdentifier)
	pkg("USE_BSD_MAKEFILE", lkNone, CheckvarYes)
	acl("USE_BUILTIN.*", lkNone, CheckvarYesNoIndirectly, "builtin.mk:s")
	pkg("USE_CMAKE", lkNone, CheckvarYes)
	acl("USE_CROSSBASE", lkNone, CheckvarYes, "Makefile:s")
	pkg("USE_FEATURES", lkShell, CheckvarIdentifier)
	pkg("USE_GCC_RUNTIME", lkNone, CheckvarYesNo)
	pkg("USE_GNU_CONFIGURE_HOST", lkNone, CheckvarYesNo)
	acl("USE_GNU_ICONV", lkNone, CheckvarYes, "Makefile:s", "Makefile.common:s", "options.mk:s")
	acl("USE_IMAKE", lkNone, CheckvarYes, "Makefile:s")
	pkg("USE_JAVA", lkNone, enum("run yes build"))
	pkg("USE_JAVA2", lkNone, enum("YES yes no 1.4 1.5 6 7 8"))
	acl("USE_LANGUAGES", lkShell, enum("ada c c99 c++ fortran fortran77 java objc"), "Makefile:s", "Makefile.common:s", "options.mk:s")
	pkg("USE_LIBTOOL", lkNone, CheckvarYes)
	pkg("USE_MAKEINFO", lkNone, CheckvarYes)
	pkg("USE_MSGFMT_PLURALS", lkNone, CheckvarYes)
	pkg("USE_NCURSES", lkNone, CheckvarYes)
	pkg("USE_OLD_DES_API", lkNone, CheckvarYesNo)
	pkg("USE_PKGINSTALL", lkNone, CheckvarYes)
	pkg("USE_PKGLOCALEDIR", lkNone, CheckvarYesNo)
	usr("USE_PKGSRC_GCC", lkNone, CheckvarYes)
	acl("USE_TOOLS", lkShell, CheckvarTool, "*:a")
	pkg("USE_X11", lkNone, CheckvarYes)
	sys("WARNING_MSG", lkNone, CheckvarShellCommand)
	sys("WARNING_CAT", lkNone, CheckvarShellCommand)
	acl("WRAPPER_REORDER_CMDS", lkShell, CheckvarWrapperReorder, "buildlink3.mk:a", "Makefile.common:a", "Makefile:a")
	acl("WRAPPER_TRANSFORM_CMDS", lkShell, CheckvarWrapperTransform, "buildlink3.mk:a", "Makefile.common:a", "Makefile:a")
	sys("WRKDIR", lkNone, CheckvarPathname)
	pkg("WRKSRC", lkNone, CheckvarWrkdirSubdirectory)
	sys("X11_PKGSRCDIR.*", lkNone, CheckvarPathname)
	usr("XAW_TYPE", lkNone, enum("3d neXtaw standard xpm"))
	acl("XMKMF_FLAGS", lkShell, CheckvarShellWord)
}

func enum(values string) *VarChecker {
	vmap := make(map[string]bool)
	for _, value := range splitOnSpace(values) {
		vmap[value] = true
	}
	name := "enum: " + values + " " // See IsEnum
	return &VarChecker{name, func(ctx *VartypeCheck) {
		if !vmap[ctx.value] {
			ctx.line.warnf("%q is not valid for %s. Use one of { %s } instead.", ctx.value, ctx.varname, values)
		}
	}}
}

func acl(varname string, kindOfList KindOfList, checker *VarChecker, aclentries ...string) {
	m := mustMatch(`^([A-Z_.][A-Z0-9_]*)(|\*|\.\*)$`, varname)
	varbase, varparam := m[1], m[2]

	vtype := &Vartype{kindOfList, checker, parseAclEntries(aclentries), guNotGuessed}

	if G.globalData.vartypes == nil {
		G.globalData.vartypes = make(map[string]*Vartype)
	}
	if varparam == "" || varparam == "*" {
		G.globalData.vartypes[varbase] = vtype
	}
	if varparam == "*" || varparam == ".*" {
		G.globalData.vartypes[varbase+".*"] = vtype
	}
}

func parseAclEntries(args []string) []AclEntry {
	var result []AclEntry
	for _, arg := range args {
		m := mustMatch(`^([\w.*]+|_):([adpsu]*)$`, arg)
		glob, perms := m[1], m[2]
		result = append(result, AclEntry{glob, perms})
	}
	return result
}

// A package-defined variable may be set in all Makefiles except buildlink3.mk and builtin.mk.
func pkg(varname string, kindOfList KindOfList, checker *VarChecker) {
	acl(varname, kindOfList, checker, "Makefile:su", "Makefile.common:dsu", "buildlink3.mk:", "builtin.mk:", "*.mk:dsu")
}

// A package-defined list may be appended to in all Makefiles except buildlink3.mk and builtin.mk.
// Simple assignment (instead of appending) is only allowed in Makefile and Makefile.common.
func pkglist(varname string, kindOfList KindOfList, checker *VarChecker) {
	acl(varname, kindOfList, checker, "Makefile:asu", "Makefile.common:asu", "buildlink3.mk:", "builtin.mk:", "*.mk:au")
}

// A user-defined or system-defined variable must not be set by any
// package file. It also must not be used in buildlink3.mk and
// builtin.mk files or at load-time, since the system/user preferences
// may not have been loaded when these files are included.
func sys(varname string, kindOfList KindOfList, checker *VarChecker) {
	acl(varname, kindOfList, checker, "buildlink3.mk:", "builtin.mk:u", "*:u")
}
func usr(varname string, kindOfList KindOfList, checker *VarChecker) {
	acl(varname, kindOfList, checker, "buildlink3.mk:", "builtin.mk:", "*:u")
}
func bl3list(varname string, kindOfList KindOfList, checker *VarChecker) {
	acl(varname, kindOfList, checker, "buildlink3.mk:a", "builtin.mk:a")
}
func cmdline(varname string, kindOfList KindOfList, checker *VarChecker) {
	acl(varname, kindOfList, checker, "buildlink3.mk:", "builtin.mk:", "*:pu")
}
